/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/rta/command/BaseCommand","sap/ui/fl/FlexControllerFactory","sap/ui/rta/ControlTreeModifier","sap/ui/fl/Utils","sap/ui/core/util/reflection/JsControlTreeModifier"],function(B,F,R,U,J){"use strict";var a=B.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean"},selector:{type:"object"}},associations:{},events:{}}});a.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id;};a.prototype.getAppComponent=function(){if(!this._oControlAppComponent){var e=this.getElement();this._oControlAppComponent=e?U.getAppComponentForControl(e):this.getSelector().appComponent;}return this._oControlAppComponent;};a.prototype.prepare=function(f,v){if(!this.getSelector()&&this.getElement()){var s={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:U.getControlType(this.getElement())};this.setSelector(s);}try{this._oPreparedChange=this._createChange(f,v);}catch(e){jQuery.sap.log.error(e.message||e.name);return false;}return true;};a.prototype.getPreparedChange=function(){if(!this._oPreparedChange){this.prepare();}return this._oPreparedChange;};a.prototype.execute=function(){var c=this.getPreparedChange();return this._applyChange(c);};a.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),selector:{id:this.getElementId()}};};a.prototype._createChange=function(f,v){return this._createChangeFromData(this._getChangeSpecificData(),f,v);};a.prototype._createChangeFromData=function(c,f,v){if(f){jQuery.extend(c,f);}c.jsOnly=this.getJsOnly();var m=this.getAppComponent().getModel("$FlexVariants");var V;if(m&&v){V=m.getCurrentVariantReference(v);}var o=F.createForControl(this.getAppComponent());var b={"variantManagementReference":v,"variantReference":V};if(V){jQuery.extend(c,b);}return o.createChange(c,this.getElement()||this.getSelector());};a.prototype.undo=function(){return Promise.resolve().then(function(){var c=this.getElement()||this.getSelector();var C=this.getPreparedChange();if(C.getRevertData()){var f=F.createForControl(this.getAppComponent());var r=f.isChangeHandlerRevertible(C,c);if(!r){jQuery.sap.log.error("No revert change function available to handle revert data for "+c);return;}var A=this.getAppComponent();return f.revertChangesOnControl([C],A);}else if(this._aRecordedUndo){R.performUndo(this._aRecordedUndo);}else{jQuery.sap.log.warning("Undo is not available for "+c);}}.bind(this));};a.prototype._applyChange=function(c,n){var C=c.change||c;var A=this.getAppComponent();var s=R.bySelector(C.getSelector(),A);var f=F.createForControl(A);var r=f.isChangeHandlerRevertible(C,s);var p={modifier:r?J:R,appComponent:A,view:U.getViewForControl(s)};if(!r){R.startRecordingUndo();}return Promise.resolve(f.checkTargetAndApplyChange(C,s,p)).then(function(o){if(o.success){if(n){f.removeFromAppliedChangesOnControl(C,A,s);}}return o;}).then(function(o){if(!r){if(!C.getUndoOperations()){this._aRecordedUndo=R.stopRecordingUndo();}else{this._aRecordedUndo=C.getUndoOperations();C.resetUndoOperations();}}if(!o.success){return Promise.reject(o.error);}}.bind(this));};return a;},true);
