/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/rta/command/Stack','sap/ui/rta/command/FlexCommand','sap/ui/rta/command/BaseCommand','sap/ui/rta/command/AppDescriptorCommand','sap/ui/fl/FlexControllerFactory','sap/ui/fl/Utils','sap/ui/fl/Change','sap/ui/rta/ControlTreeModifier','sap/ui/fl/registry/Settings'],function(M,C,F,B,A,a,b,c,R,S){"use strict";var L=M.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"commandStack":{type:"object"}},aggregations:{}}});L.prototype._lastPromise=Promise.resolve();L.prototype.setCommandStack=function(o){if(this.getCommandStack()){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);}this.setProperty("commandStack",o);o.addCommandExecutionHandler(this._fnHandleCommandExecuted);};L.prototype.init=function(){this._fnHandleCommandExecuted=this.handleCommandExecuted.bind(this);};L.prototype.exit=function(){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);};L.prototype._isPersistedChange=function(p){return!!this.getCommandStack()._aPersistedChanges&&this.getCommandStack()._aPersistedChanges.indexOf(p.getId())!==-1;};L.prototype.handleCommandExecuted=function(e){return(function(e){var p=e;this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var d=this.getCommandStack().getSubCommands(p.command);var f;if(p.undo){d.forEach(function(o){if(!(o instanceof F||o instanceof A)||o.getRuntimeOnly()){return;}var g=o.getPreparedChange();var h=o.getAppComponent();if(h){if(o instanceof F){f=a.createForControl(h);var i=R.bySelector(g.getSelector(),h);f.removeFromAppliedChangesOnControl(g,h,i);}else if(o instanceof A){f=this._getAppDescriptorFlexController(h);}f.deleteChange(g,h);}}.bind(this));}else{var D=[];d.forEach(function(o){if(o.getRuntimeOnly()){return;}if(o instanceof F){var g=o.getAppComponent();if(g){var f=a.createForControl(g);var P=o.getPreparedChange();if(P.getState()===c.states.DELETED){P.setState(c.states.NEW);}if(!this._isPersistedChange(P)){f.addPreparedChange(o.getPreparedChange(),g);}}}else if(o instanceof A){D.push(o.createAndStoreChange());}}.bind(this));return Promise.all(D);}}.bind(this));return this._lastPromise;}.bind(this))(e);};L.prototype.needsReload=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var d=this.getCommandStack().getAllExecutedCommands();return d.some(function(o){return!!o.needsReload;});}.bind(this));return this._lastPromise;};L.prototype.saveCommands=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var r=sap.ui.getCore().byId(this.getRootControl());if(!r){throw new Error("Can't save commands without root control instance!");}var f=a.createForControl(r);return f.saveAll();}.bind(this)).then(function(){var r=sap.ui.getCore().byId(this.getRootControl());var f=this._getAppDescriptorFlexController(r);return f.saveAll();}.bind(this)).then(function(){jQuery.sap.log.info("UI adaptation successfully transfered changes to layered repository");this.getCommandStack().removeAllCommands();}.bind(this));return this._lastPromise;};L.prototype._getAppDescriptorFlexController=function(o){var d=b.getAppComponentForControl(o);var s=b.getComponentClassName(d).replace(".Component","");var e=b.getAppVersionFromManifest(d.getManifest());return a.create(s,e);};L.prototype._moveChangeToAppVariant=function(r,f){return S.getInstance().then(function(s){var p={reference:r};var n=b.createNamespace(p,"changes");var d=this.getCommandStack().getAllExecutedCommands();d.forEach(function(o){if(o.getPreparedChange&&!o.getRuntimeOnly()){var v=o.getPreparedChange();if(!Array.isArray(v)){v=[v];}v.forEach(function(e){if(s.isAtoEnabled()){e.setRequest("ATO_NOTIFICATION");}e.setNamespace(n);e.setComponent(r);});}});return f.saveAll(true);}.bind(this));};L.prototype._triggerUndoChanges=function(){var o=this.getCommandStack();var p=[];var d=o.getAllExecutedCommands();d.forEach(function(e){p.push(e.undo.bind(e));});p=p.reverse();return b.execPromiseQueueSequentially(p,false,true);};L.prototype._removeCommands=function(f){var o=this.getCommandStack();var d=o.getAllExecutedCommands();d.forEach(function(e){if(e instanceof F){var g=e.getPreparedChange();var h=e.getAppComponent();var i=R.bySelector(g.getSelector(),h);f.removeFromAppliedChangesOnControl(g,h,i);}});o.removeAllCommands();};L.prototype.saveAsCommands=function(r){if(!r){throw new Error("The id of the new app variant is required");}var o=sap.ui.getCore().byId(this.getRootControl());if(!o){throw new Error("Can't save commands without root control instance!");}var d=b.getAppDescriptor(o);if(d["sap.app"].id===r){throw new Error("The id of the app variant should be different from the current app id");}var f=a.createForControl(o);var e=this.getCommandStack();return this._moveChangeToAppVariant(r,f).then(function(){e.detachCommandExecuted(this.handleCommandExecuted.bind(this));return this._triggerUndoChanges();}.bind(this)).then(function(){this._removeCommands(f);e.attachCommandExecuted(this.handleCommandExecuted.bind(this));return true;}.bind(this));};return L;},true);
