/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/rta/Client',["sap/ui/base/ManagedObject","sap/ui/core/postmessage/Bus","sap/base/util/uid","sap/base/util/extend","sap/ui/rta/util/ServiceEventBus","sap/ui/thirdparty/URI"],function(M,P,u,e,S,U){"use strict";var C='sap.ui.rta.service.receiver';var a='pending';var b='accepted';var c='declined';
var d=M.extend("sap.ui.rta.Client",{
metadata:{library:"sap.ui.rta",properties:{"window":"object","origin":"string"}},
_bInit:false,
constructor:function(){M.apply(this,arguments);if(!this.getWindow()){throw new TypeError("sap.ui.rta.Client: window parameter is required");}if(!this.getOrigin()){throw new TypeError("sap.ui.rta.Client: origin parameter is required");}this._oPostMessageBus=P.getInstance();this._sStatus=a;this._mPendingRequests={};this._aRequestQueue=[];this._oServiceEventBus=null;this._mEventHandlerIds={};this._oPostMessageBus.subscribeOnce(C,P.event.READY,function(E){if(!this._isValidMessage(E)){return;}this._oPostMessageBus.subscribeOnce(C,P.event.ACCEPTED,function(E){if(!this._isValidMessage(E)){return;}this._sStatus=b;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(this._sendRequest,this);this._oPostMessageBus.subscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'event',this._receiverEvents,this);},this);this._oPostMessageBus.subscribeOnce(C,P.event.DECLINED,function(E){if(!this._isValidMessage(E)){return;}this._sStatus=c;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(function(R){R.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));});},this);this._oPostMessageBus.publish({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:P.event.CONNECT,data:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("SERVICE_NAME")});},this);this._bInit=true;}
});
d.prototype.destroy=function(){this._oPostMessageBus.unsubscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'event',this._receiverEvents,this);M.prototype.destroy.apply(this,arguments);};
d.prototype.getService=function(s){if(typeof s!=="string"){throw new TypeError('sap.ui.rta.Client.getService(): invalid service name specified');}return this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'getService',data:{arguments:[s]}}));};
d.prototype._createRequest=function(p){var r=u();var R={id:r,request:{target:p.target,origin:p.origin,channelId:C,eventId:p.eventId,data:{id:r,type:'request',body:p.data}}};R.promise=new Promise(function(f,g){R.resolve=f;R.reject=g;});return R;};
d.prototype._sendRequest=function(r){switch(this._sStatus){case b:this._mPendingRequests[r.id]=r;this._oPostMessageBus.publish(r.request);break;case a:this._aRequestQueue.push(r);break;case c:r.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));break;}return r.promise;};
d.prototype._isValidMessage=function(E){return this.getWindow()===E.source&&this.getOrigin()===E.origin;};
d.prototype._receiverMethods=function(E){if(!this._isValidMessage(E)){return;}var D=E.data;if(D.type!=='response'){return;}var r=this._mPendingRequests[D.id];switch(E.eventId){case'getService':var s=r.request.data.body.arguments[0];var m=D.body.methods||[];var f=D.body.events;var g=e(m.reduce(function(R,h){R[h]=function(){return this._sendRequest(this._createRequest({target:E.source,origin:E.origin,channelId:C,eventId:'callMethod',data:{service:s,method:h,arguments:Array.prototype.slice.call(arguments)}}));}.bind(this);return R;}.bind(this),{}),D.body.properties);if(Array.isArray(f)&&f.length>0){if(!this._oServiceEventBus){this._oServiceEventBus=new S();}e(g,{attachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling attachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling attachEvent() for a service");}var j=this._oServiceEventBus.getChannel(s);var k=!j||!j.hasListeners(h);this._oServiceEventBus.subscribe(s,h,i,o);if(k){this._sendRequest(this._createRequest({target:E.source,origin:E.origin,channelId:C,eventId:'subscribe',data:{service:s,event:h}})).then(function(R){this._mEventHandlerIds[s+','+h]=R.id;this._checkIfEventAlive(s,h);}.bind(this));}}.bind(this),detachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling detachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling detachEvent() for a service");}this._oServiceEventBus.unsubscribe(s,h,i,o);this._checkIfEventAlive(s,h);}.bind(this),attachEventOnce:function(h,i,o){function O(){g.detachEvent(h,O);i.apply(o,arguments);}g.attachEvent(h,O);}});}r.resolve(g);delete this._mPendingRequests[D.id];break;case'callMethod':if(D.status==='success'){r.resolve(D.body);}else{r.reject(D.body);}delete this._mPendingRequests[D.id];break;case'subscribe':case'unsubscribe':r.resolve(D.body);delete this._mPendingRequests[D.id];break;}};
d.prototype._checkIfEventAlive=function(s,E){var o=this._oServiceEventBus.getChannel(s);var f=this._mEventHandlerIds[s+','+E];if((!o||!o.hasListeners(E))&&f){this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'unsubscribe',data:{service:s,event:E,id:f}}));}};
d.prototype._receiverEvents=function(E){if(!this._isValidMessage(E)){return;}var r=E.data.body;this._oServiceEventBus.publish(r.service,r.event,r.data);};
d.prototype.setWindow=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Window parameter cannot be changed at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Window parameter is required");}if(v===window){throw new TypeError("sap.ui.rta.Client: Window object has to be different from the one where Client is running");}this.setProperty('window',v);return this;};
d.prototype.setOrigin=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Cannot change origin parameter at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Origin parameter is required");}if(typeof v!=='string'){throw new TypeError("sap.ui.rta.Client: Origin parameter has to be a string");}if(new U(v).origin()!==v){throw new TypeError("sap.ui.rta.Client: Origin string is invalid");}this.setProperty('origin',v);return this;};
return d;});
sap.ui.predefine('sap/ui/rta/ControlTreeModifier',["sap/ui/core/util/reflection/JsControlTreeModifier"],function(J){"use strict";var _;var R={startRecordingUndo:function(){_=[];},stopRecordingUndo:function(){var r=_;_=undefined;return r;},performUndo:function(u){while(u.length){var o=u.pop();this[o.name].apply(this,o.properties);}},_saveUndoOperation:function(f,p){if(_){_.push({name:f,properties:p});}},setVisible:function(c,v){var o=this.getVisible(c);var r=J.setVisible.apply(this,arguments);if(o!==this.getVisible(c)){this._saveUndoOperation("setVisible",[c,o]);}return r;},setStashed:function(c,s){var o;var C=c.getId();if(c.getVisible){o=!c.getVisible();}else{o=c.getStashed();}J.setStashed.apply(this,arguments);var S=sap.ui.getCore().byId(C);if(o!==s){this._saveUndoOperation("setStashed",[S,!s]);}},bindProperty:function(c,p,b){var o=c.getBindingInfo(p);var O;var m=c.getMetadata().getPropertyLikeSetting(p);if(m){var P=m._sGetter;O=c[P]();}J.bindProperty.apply(this,arguments);if(o){this._saveUndoOperation("bindProperty",[c,p,o]);}else{this._saveUndoOperation("unbindProperty",[c,p]);}if(O){this._saveUndoOperation("setProperty",[c,p,O]);}},unbindProperty:function(c,p){var o=c.getBindingInfo(p);J.unbindProperty.apply(this,arguments);if(o){this._saveUndoOperation("bindProperty",[c,p,o]);}},setProperty:function(c,p,P){var o;var m=c.getMetadata().getPropertyLikeSetting(p);if(m){var s=m._sGetter;o=c[s]();}var r=J.setProperty.apply(this,arguments);if(o!==P){this._saveUndoOperation("setProperty",[c,p,o]);}return r;},setPropertyBinding:function(c,p,P){var o;var m=c.getMetadata().getPropertyLikeSetting(p);if(m){var s=m._sGetter;o=c[s]();}J.setPropertyBinding.apply(this,arguments);if(o!==P){this._saveUndoOperation("setPropertyBinding",[c,p,o]);}},createControl:function(c,a,v,s){var e=this.bySelector(s,a);var r=J.createControl.apply(this,arguments);if(!e){var C=this.bySelector(s,a);this._saveUndoOperation("destroy",[C]);}return r;},instantiateFragment:function(f,c,v,C){var a=J.instantiateFragment.apply(this,arguments);a.forEach(function(o){this._saveUndoOperation("destroy",[o]);}.bind(this));return a;},destroy:function(c){if(c){c.destroy();}},insertAggregation:function(p,n,o,i){var O=J.getAggregation.call(this,p,n);J.insertAggregation.apply(this,arguments);if(p){if(p.getMetadata){var m=p.getMetadata();var a=m.getAllAggregations();if(a){var A=a[n];if(A){if(A.multiple){this._saveUndoOperation("removeAggregation",[p,n,o]);}else{this._saveUndoOperation("insertAggregation",[p,n,O]);}}}}}},removeAggregation:function(p,n,o){var O;var a;if(p&&o){a=J.getAggregation.call(this,p,n);if(a){a.some(function(e,i){if(e===o){O=i;return true;}});}}J.removeAggregation.apply(this,arguments);if(O||O===0){this._saveUndoOperation("insertAggregation",[p,n,o,O]);}},removeAllAggregation:function(p,n){var o=[];var a;if(p){a=J.getAggregation.call(this,p,n);}if(a&&a instanceof Array){o=a.slice();}else if(a&&a instanceof Object){o[0]=a;}J.removeAllAggregation(p,n);if(o){o.forEach(function(e){this._saveUndoOperation("insertAggregation",[p,n,e]);},this);}}};return jQuery.sap.extend(true,{},J,R);},true);
sap.ui.predefine('sap/ui/rta/RuntimeAuthoring',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/ControlVariant","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/fl/FlexControllerFactory","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/util/UrlParser","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,j,k,l,m,n,o,T,p,U,r,s,t,u,v,w,B,x,y,z,E,G,H,I,J){"use strict";var K="sap-ui-fl-max-layer";var N="starting";var Q="started";var V="failed";
var W=M.extend("sap.ui.rta.RuntimeAuthoring",{
metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"customFieldUrl":"string","showCreateCustomField":"boolean","showToolbars":{type:"boolean",defaultValue:true},"triggeredFromDialog":{type:"boolean",defaultValue:false},"showWindowUnloadDialog":{type:"boolean",defaultValue:true},"commandStack":{type:"any"},"plugins":{type:"any",defaultValue:{}},"flexSettings":{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},"mode":{type:"string",defaultValue:"adaptation"},"metadataScope":{type:"string",defaultValue:"default"}},events:{"start":{parameters:{editablePluginsCount:{type:"int"}}},"stop":{},"failed":{},"selectionChange":{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},"modeChanged":{},"undoRedoStackModified":{}}},
_sAppTitle:null,
_dependents:null,
constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new w(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}},
_RESTART:{NOT_NEEDED:"no restart",VIA_HASH:"without max layer",RELOAD_PAGE:"reload"}
});
W.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var i=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new l({commandFactory:i,multiSelectionRequiredPlugins:[j.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var Z=new c({commandFactory:i});this._mDefaultPlugins["dragDrop"]=new b({elementMover:Z,commandFactory:i,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:i,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:i,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:i});this._mDefaultPlugins["remove"]=new e({commandFactory:i});this._mDefaultPlugins["cutPaste"]=new d({elementMover:Z,commandFactory:i});this._mDefaultPlugins["settings"]=new m({commandFactory:i});this._mDefaultPlugins["combine"]=new j({commandFactory:i});this._mDefaultPlugins["split"]=new k({commandFactory:i});this._mDefaultPlugins["contextMenu"]=new o({styleClass:U.getRtaStyleClassName()});this._mDefaultPlugins["tabHandling"]=new T();this._mDefaultPlugins["controlVariant"]=new n({commandFactory:i});}return q.extend({},this._mDefaultPlugins);};
W.prototype.addDependent=function(i,Z,$){$=typeof $==='undefined'?true:!!$;if(!(Z in this._dependents)){if(Z&&$){this['get'+q.sap.charToUpperCase(Z,0)]=this.getDependent.bind(this,Z);}this._dependents[Z||i.getId()]=i;}else{throw r.createError("RuntimeAuthoring#addDependent",r.printf("Can't add dependency with same key '{0}'",Z),"sap.ui.rta");}};
W.prototype.getDependent=function(i){return this._dependents[i];};
W.prototype.getDependents=function(){return this._dependents;};
W.prototype.removeDependent=function(i){delete this._dependents[i];};
W.prototype._destroyDefaultPlugins=function(i){for(var Z in this._mDefaultPlugins){var $=this._mDefaultPlugins[Z];if($&&!$.bIsDestroyed){if(!i||i[Z]!==$){$.destroy();}}}if(!i){this._mDefaultPlugins=null;}};
W.prototype.onPopupOpen=function(i){if(i.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};
W.prototype.onPopupClose=function(i){if(i.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};
W.prototype.setPlugins=function(i){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",i);};
W.prototype.setFlexSettings=function(i){var Z=q.sap.getUriParameters();var $=Z.mParams["sap-ui-layer"];i=q.extend({},this.getFlexSettings(),i);if($&&$.length>0){i.layer=$[0];}if(i.scenario||i.baseId){var _=s.buildLrepRootNamespace(i.baseId,i.scenario,i.projectId);i.rootNamespace=_;i.namespace=_+"changes/";}U.setRtaStyleClassName(i.layer);this.setProperty("flexSettings",i);};
W.prototype.getLayer=function(i){return this.getFlexSettings().layer;};
W.prototype._getFlexController=function(){var i=this._oRootControl||sap.ui.getCore().byId(this.getRootControl());return p.createForControl(i);};
W.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
W.prototype.start=function(){var i;if(!this._oDesignTime){this._oRootControl=sap.ui.getCore().byId(this.getRootControl());if(!this._oRootControl){var Z="Could not start Runtime Adaptation: Root control not found";s.log.error(Z);return Promise.reject(Z);}return this._handlePersonalizationChangesOnStart().then(function($){if($){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(b1){if(this.getPlugins()[b1].attachElementModified){this.getPlugins()[b1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var _=Object.keys(this.getPlugins());var a1=_.map(function(b1){return this.getPlugins()[b1];},this);i=new Promise(function(b1,c1){q.sap.measure.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:a1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}this._oRootControl.addStyleClass("sapUiRtaRoot");this._oDesignTime.attachSelectionChange(function(d1){this.fireSelectionChange({selection:d1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){b1();q.sap.measure.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",c1);}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getPublishAndAppVariantSupportVisibility().then(function($){var _=$[0];var a1=$[1];this._createToolsMenu(_,a1);return this.getToolbar().show();}.bind(this));}}.bind(this)).then(function(){this._onStackModified();this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);}.bind(this)).then(function(){this.getPopupManager().setRta(this);var $=this.getPopupManager().getRelevantPopups();if($.aDialogs||$.aPopovers){return this.getShowToolbars()&&this.getToolbar().bringToFront();}}.bind(this)).then(function(){y.loadStyles('InPageStyles').then(function($){var _=$.replace(/%scrollWidth%/g,x.getScrollbarWidth()+'px');x.insertStyles(_);});}).then(function(){return i;}).then(function(){this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this),function(Z){if(Z!=="Reload triggered"){this.fireFailed(Z);}if(Z){return Promise.reject(Z);}}.bind(this));}};
W.prototype._getPublishAndAppVariantSupportVisibility=function(){return t.getInstance().then(function(i){var Z=E.isPlatFormEnabled(this._oRootControl,this.getLayer(),this._oSerializer);return[!i.isProductiveSystem()&&!i.hasMergeErrorOccured(),!i.isProductiveSystem()&&Z];}.bind(this)).catch(function(i){return false;});};
var X=function(Z){B.hide();var $="";if(Z.messages&&Array.isArray(Z.messages)){for(var i=0;i<Z.messages.length;i++){$=(Z.messages[i].severity==="Error")?$+Z.messages[i].text+"\n":$;}}else{$=Z.stack||Z.message||Z.status||Z;}var _=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");q.sap.log.error("Failed to transfer runtime adaptation changes to layered repository",$);var a1=_.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+_.getText("MSG_ERROR_REASON",$);u.error(a1,{styleClass:U.getRtaStyleClassName()});};
W.prototype.setCommandStack=function(i){var Z=this.getProperty("commandStack");if(Z){Z.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var $=this.setProperty("commandStack",i);if(i){i.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(i);}return $;};
W.prototype.getCommandStack=function(){var i=this.getProperty("commandStack");if(!i){i=new C();this._oInternalCommandStack=i;this.setCommandStack(i);}return i;};
W.prototype._onStackModified=function(){var i=this.getCommandStack();var Z=i.canUndo();var $=i.canRedo();var _=U.getUshellContainer();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(Z,$);this.getToolbar().setPublishEnabled(this._bChangesExist||Z);this.getToolbar().setRestoreEnabled(this._bChangesExist||Z);}this.fireUndoRedoStackModified();if(_){if(Z){_.setDirtyFlag(true);}else{_.setDirtyFlag(false);}}};
W.prototype._closeToolbar=function(){if(this.getShowToolbars()&&this.getToolbar){return this.getToolbar().hide();}};
W.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}else{return[];}};
W.prototype.stop=function(i,Z){return((Z)?Promise.resolve(this._RESTART.NOT_NEEDED):this._handleReloadOnExit()).then(function($){return((i)?Promise.resolve():this._serializeToLrep(this)).then(this._closeToolbar.bind(this)).then(function(){this.fireStop();if($!==this._RESTART.NOT_NEEDED){this._removeMaxLayerParameter();if($===this._RESTART.RELOAD_PAGE){this._reloadPage();}}}.bind(this));}.bind(this))['catch'](X);};
W.prototype.restore=function(){this._onRestore();};
W.prototype.transport=function(){return this._onTransport();};
W.prototype.undo=function(){return this._onUndo();};
W.prototype.redo=function(){return this._onRedo();};
W.prototype.canUndo=function(){return this.getCommandStack().canUndo();};
W.prototype.canRedo=function(){return this.getCommandStack().canRedo();};
W.prototype._onKeyDown=function(i){var Z=G.os.macintosh;var $=O.getOverlayContainer().get(0).contains(document.activeElement);var _=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var a1=document.body===document.activeElement;var b1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if(($||_||a1)&&!b1){var c1=Z?i.metaKey:i.ctrlKey;if(i.keyCode===q.sap.KeyCodes.Z&&i.shiftKey===false&&i.altKey===false&&c1===true){this._onUndo().then(i.stopPropagation.bind(i));}else if(((Z&&i.keyCode===q.sap.KeyCodes.Z&&i.shiftKey===true)||(!Z&&i.keyCode===q.sap.KeyCodes.Y&&i.shiftKey===false))&&i.altKey===false&&c1===true){this._onRedo().then(i.stopPropagation.bind(i));}}};
W.prototype._onUnload=function(){var i=this.getCommandStack();var Z=i.canUndo()||i.canRedo();if(Z&&this.getShowWindowUnloadDialog()){var $=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return $;}else{window.onbeforeunload=this._oldUnloadHandler;}};
W.prototype._serializeToLrep=function(){return this._oSerializer.saveCommands();};
W.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};
W.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};
W.prototype._createToolsMenu=function(i,Z){if(!this.getDependent('toolbar')){var $;if(this.getLayer()==="USER"){$=P;}else if(U.getFiori2Renderer()){$=F;}else{$=S;}if(this.getLayer()==="USER"){this.addDependent(new $({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new $({modeSwitcher:this.getMode(),publishVisible:i,textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:E.onGetOverview.bind(null,true),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:E.onSaveAsFromRtaToolbar.bind(null,true,true)}),'toolbar');}var _;if(Z){this.getToolbar().getControl('saveAs').setVisible(Z);_=E.isOverviewExtended();if(_){this.getToolbar().getControl('appVariantOverview').setVisible(Z);}else{this.getToolbar().getControl('manageApps').setVisible(Z);}E.isManifestSupported().then(function(a1){if(_){this.getToolbar().getControl('appVariantOverview').setEnabled(a1);}else{this.getToolbar().getControl('manageApps').setEnabled(a1);}this.getToolbar().getControl('saveAs').setEnabled(a1);}.bind(this));}this._checkChangesExist().then(function(a1){if(!this.bIsDestroyed){this._bChangesExist=a1;this.getToolbar().setPublishEnabled(a1);this.getToolbar().setRestoreEnabled(a1);}}.bind(this));}};
W.prototype._onGetAppVariantOverview=function(i){var Z=i.getParameter("item");var $=Z.getId()==='keyUser';return E.onGetOverview($);};
W.prototype.destroy=function(){q.map(this._dependents,function(Z,$){this.removeDependent($);Z.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(Z){this.stopService(Z);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._oRootControl){this._oRootControl.removeStyleClass("sapUiRtaRoot");}this.setCommandStack(null);var i=U.getUshellContainer();if(i){i.setDirtyFlag(false);}if(this._oServiceEventBus){this._oServiceEventBus.destroy();}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};
W.prototype._onTransport=function(){this._handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();return this._getFlexController()._oChangePersistence.transportAllUIChanges(this._oRootControl,U.getRtaStyleClassName(),this.getLayer()).then(function(i){if(i!=="Error"&&i!=="Cancel"){this._showMessageToast("MSG_TRANSPORT_SUCCESS");}}.bind(this));}.bind(this))['catch'](X);};
W.prototype._deleteChanges=function(){return this._getFlexController().resetChanges(this.getLayer(),"Change.createInitialFileContent",s.getAppComponentForControl(this._oRootControl||sap.ui.getCore().byId(this.getRootControl()))).then(function(){this._reloadPage();}.bind(this))["catch"](function(i){return U._showMessageBox(u.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",i);});};
W.prototype._reloadPage=function(){window.location.reload();};
W.prototype._showMessageToast=function(i){var Z=this._getTextResources().getText(i);v.show(Z);};
W.needsRestart=function(i){var Z=!!window.localStorage.getItem("sap.ui.rta.restart."+i);return Z;};
W.enableRestart=function(i){window.localStorage.setItem("sap.ui.rta.restart."+i,true);};
W.disableRestart=function(i){window.localStorage.removeItem("sap.ui.rta.restart."+i);};
W.prototype._onRestore=function(){var i=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var Z=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var $=function(_){if(_==="OK"){W.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();u.confirm(i,{icon:u.Icon.WARNING,title:Z,onClose:$,styleClass:U.getRtaStyleClassName()});};
W.prototype._scheduleRenameOnCreatedContainer=function(i,Z){var $=function(c1){var d1=this.getPlugins()["createContainer"].getCreatedContainerId(i,c1.getElement().getId());var e1=J.getOverlay(d1);e1.setSelected(true);this.getPlugins()["rename"].startEdit(e1);};var _=function(c1){var d1=c1.getSource();if(d1.getGeometry()&&d1.getGeometry().visible){$.call(this,d1);d1.detachEvent('geometryChanged',_,this);}};var a1=function(c1){var d1=c1.getSource();if(!d1.getGeometry()||!d1.getGeometry().visible){d1.attachEvent('geometryChanged',_,this);}else{$.call(this,d1);}d1.detachEvent('afterRendering',a1,this);};var b1=function(c1){var d1=c1.getParameter("elementOverlay");if(d1.getElement().getId()===Z){this._oDesignTime.detachEvent("elementOverlayCreated",b1,this);d1.attachEvent('afterRendering',a1,this);}};this._oDesignTime.attachEvent("elementOverlayCreated",b1,this);};
W.prototype._handleElementModified=function(i){this._handleStopCutPaste();var Z=i.getParameter("action");var $=i.getParameter("newControlId");var _=i.getParameter("command");if(_ instanceof sap.ui.rta.command.BaseCommand){if(Z&&$){this._scheduleRenameOnCreatedContainer(Z,$);}return this.getCommandStack().pushAndExecute(_).catch(function(a1){throw new Error(a1);});}return Promise.resolve();};
W.prototype._onElementEditableChange=function(i){var Z=i.getParameter("editable");if(Z){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};
W.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};
W.prototype._checkChangesExist=function(){if(this._getFlexController().getComponentName().length>0){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer(),includeCtrlVariants:true}).then(function(i){return i.length>0;});}else{return Promise.resolve(false);}};
W.prototype._getURLParsedHash=function(){var i=sap.ushell.Container.getService("URLParsing");if(i.parseShellHash&&i.getHash){return i.parseShellHash(i.getHash(window.location.href));}};
W.prototype._buildNavigationArguments=function(i){return{target:{semanticObject:i.semanticObject,action:i.action,context:i.contextRaw},params:i.params,appSpecificRoute:i.appSpecificRoute,writeHistory:false};};
W.prototype._hasCustomerLayerParameter=function(i){return i.params&&i.params[K]&&i.params[K][0]==="CUSTOMER";};
W.prototype._reloadWithoutPersonalizationChanges=function(i,Z){if(!this._hasCustomerLayerParameter(i)){if(!i.params){i.params={};}i.params[K]=["CUSTOMER"];W.enableRestart("CUSTOMER");Z.toExternal(this._buildNavigationArguments(i));return Promise.resolve(true);}};
W.prototype._removeMaxLayerParameter=function(){if(U.getUshellContainer()&&this.getLayer()!=="USER"){var i=U.getUshellContainer().getService("CrossApplicationNavigation");var Z=this._getURLParsedHash();if(i.toExternal&&Z){if(this._hasCustomerLayerParameter(Z)){delete Z.params[K];i.toExternal(this._buildNavigationArguments(Z));}}}};
W.prototype._handlePersonalizationMessageBoxOnStart=function(){return U._showMessageBox(u.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS","MSG_PERSONALIZATION_EXISTS");};
W.prototype._handleReloadMessageBox=function(i){return U._showMessageBox(u.Icon.INFORMATION,"HEADER_RELOAD_NEEDED",i,undefined,"BUTTON_RELOAD_NEEDED");};
W.prototype._handlePersonalizationChangesOnStart=function(){var i=U.getUshellContainer();if(i&&this.getLayer()!=="USER"){var Z=this._getURLParsedHash();return this._getFlexController().isPersonalized({ignoreMaxLayerParameter:false}).then(function($){if($){return this._handlePersonalizationMessageBoxOnStart().then(function(){var _=sap.ushell.Container.getService("CrossApplicationNavigation");if(_.toExternal&&Z){return this._reloadWithoutPersonalizationChanges(Z,_);}}.bind(this));}}.bind(this));}else{return Promise.resolve(false);}};
W.prototype._handleReloadOnExit=function(){return Promise.all([this._oSerializer.needsReload(),this._getFlexController().isPersonalized({ignoreMaxLayerParameter:true})]).then(function(i){var Z=i[0],$=i[1];if(Z||$){var _=this._RESTART.RELOAD_PAGE;var a1;if($){a1="MSG_RELOAD_WITH_PERSONALIZATION";if(!Z){_=this._RESTART.VIA_HASH;}}else if(Z){a1="MSG_RELOAD_NEEDED";}return this._handleReloadMessageBox(a1).then(function(){return _;});}else{return this._RESTART.NOT_NEEDED;}}.bind(this));};
W.prototype._onModeChange=function(i){this.setMode(i.getParameter('key'));};
W.prototype.setMode=function(i){if(this.getProperty('mode')!==i){var Z=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var $=i==='adaptation';if(Z){Z.setSelectedButton(Z.getItems().filter(function(_){return _.getKey()===i;}).pop().getId());}this._oDesignTime.setEnabled($);this.getPlugins()['tabHandling'][$?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',i);this.fireModeChanged({mode:i});}};
W.prototype.setMetadataScope=function(i){if(this._oDesignTime){q.sap.log.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',i);};
function Y(i){if(H.hasOwnProperty(i)){return H[i].replace(/\./g,'/');}}
W.prototype.startService=function(i){var Z=Y(i);var $;if(!Z){return Promise.reject(r.createError("RuntimeAuthoring#stopService",r.printf("Unknown service. Can't find any registered service by name '{0}'",i),"sap.ui.rta"));}else{$=this._mServices[i];if($){switch($.status){case'started':{return Promise.resolve($.exports);}case'starting':{return $.initPromise;}case'failed':{return $.initPromise;}default:{return Promise.reject(r.createError("RuntimeAuthoring#getService",r.printf("Unknown service status. Service name = '{0}'",i),"sap.ui.rta"));}}}else{$={status:N,location:Z,initPromise:new Promise(function(_,a1){sap.ui.require([Z],function(b1){$.factory=b1;if(!this._oServiceEventBus){this._oServiceEventBus=new I();}r.wrapIntoPromise(b1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,i)).then(function(c1){if(this.bIsDestroyed){throw r.createError("RuntimeAuthoring#getService",r.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",i),"sap.ui.rta");}if(!q.isPlainObject(c1)){throw r.createError("RuntimeAuthoring#getService",r.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",i),"sap.ui.rta");}$.service=c1;$.exports={};if(Array.isArray(c1.events)&&c1.events.length>0){q.extend($.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,i),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,i),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,i)});}var d1=c1.exports||{};q.extend($.exports,Object.keys(d1).reduce(function(e1,f1){var g1=d1[f1];e1[f1]=typeof g1==="function"?r.wrapIntoPromise(g1):g1;return e1;},{}));$.status=Q;_(Object.freeze($.exports));}.bind(this)).catch(a1);}.bind(this),function(b1){$.status=V;a1(r.propagateError(b1,"RuntimeAuthoring#getService",r.printf("Can't load service '{0}' by its name: {1}",i,Z),"sap.ui.rta"));});}.bind(this)).catch(function(_){$.status=V;return Promise.reject(r.propagateError(_,"RuntimeAuthoring#getService",r.printf("Error during service '{0}' initialisation.",i),"sap.ui.rta"));})};this._mServices[i]=$;return $.initPromise;}}};
W.prototype.stopService=function(i){var Z=this._mServices[i];if(Z){if(Z.status===Q){if(q.isFunction(Z.service.destroy)){Z.service.destroy();}}delete this._mServices[i];}else{throw r.createError("RuntimeAuthoring#stopService",r.printf("Can't destroy service: unable to find service with name '{0}'",i),"sap.ui.rta");}};
W.prototype.getService=function(i){return this.startService(i);};
return W;},true);
sap.ui.predefine('sap/ui/rta/Utils',['jquery.sap.global','sap/ui/fl/Utils','sap/ui/dt/OverlayUtil','sap/ui/fl/registry/Settings','sap/m/MessageBox'],function(q,F,O,S,M){"use strict";var U={};U.RESOLVED_PROMISE=Promise.resolve(true);U._sFocusableOverlayClass=".sapUiDtOverlaySelectable";U._sRtaStyleClassName='';
U.getRtaStyleClassName=function(){return U._sRtaStyleClassName;};
U.setRtaStyleClassName=function(l){if(l==="USER"){U._sRtaStyleClassName="";}else if(F.getLayerIndex(l)>-1){U._sRtaStyleClassName="sapContrast sapContrastPlus";}};
U.isExtensibilityEnabledInSystem=function(c){var C=F.getComponentClassName(c);if(!C||C==""){return Promise.resolve(false);}return S.getInstance(C).then(function(s){if(s.isModelS){return s.isModelS();}return false;});};
U.isServiceUpToDate=function(c){return this.isExtensibilityEnabledInSystem(c).then(function(e){if(e){q.sap.require("sap.ui.fl.fieldExt.Access");var m=c.getModel();if(m){var s=sap.ui.fl.fieldExt.Access.isServiceOutdated(m.sServiceUrl);if(s){sap.ui.fl.fieldExt.Access.setServiceValid(m.sServiceUrl);sap.ui.getCore().getEventBus().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{});return Promise.reject();}}}});};
U.isCustomFieldAvailable=function(c){return this.isExtensibilityEnabledInSystem(c).then(function(s){if(!s){return false;}else if(!c.getModel()){return false;}else{var a=c.getModel().sServiceUrl;var e=this.getBoundEntityType(c).name;try{q.sap.require("sap.ui.fl.fieldExt.Access");var j=sap.ui.fl.fieldExt.Access.getBusinessContexts(a,e);return Promise.resolve(j).then(function(r){if(r){if(r.BusinessContexts){if(r.BusinessContexts.length>0){r.EntityType=e;return r;}}}else{return false;}}).catch(function(E){if(E){if(q.isArray(E.errorMessages)){for(var i=0;i<E.errorMessages.length;i++){q.sap.log.error(E.errorMessages[i].text);}}}return false;});}catch(E){q.sap.log.error("exception occured in sap.ui.fl.fieldExt.Access.getBusinessContexts",E);return false;}}}.bind(this));};
U.openRemoveConfirmationDialog=function(e,t){var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var s;return new Promise(function(r,a){s=T.getText("CTX_REMOVE_TITLE");var d={messageText:t,titleText:s,icon:"sap-icon://question-mark",removeText:T.getText("BTN_FREP_REMOVE"),cancelText:T.getText("BTN_FREP_CANCEL")};var m=new sap.ui.model.json.JSONModel();m.setData(d);var f;var c=function(){if(f){f.close();f.destroy();f=null;}};var o={removeField:function(){c();r(true);},closeDialog:function(){c();r(false);}};if(!f){f=sap.ui.xmlfragment("sap.ui.rta.view.RemoveElementDialog",o);f.setModel(m);}f.addStyleClass(U.getRtaStyleClassName());f.open();});};
U.isOverlaySelectable=function(o){return o.isSelectable()&&o.$().is(":visible");};
U.getPropertyValue=function(e,p){var m=e.getMetadata().getPropertyLikeSetting(p);var P=m._sGetter;return e[P]();};
U.getOverlayInstanceForDom=function(d){var i=q(d).attr("id");if(i){return sap.ui.getCore().byId(i);}};
U.getFocusedOverlay=function(){if(document.activeElement){var e=sap.ui.getCore().byId(document.activeElement.id);if(e instanceof sap.ui.dt.ElementOverlay){return e;}}};
U.getFocusableParentOverlay=function(o){if(!o){return undefined;}var f=o.getParentElementOverlay();while(f&&!f.getSelectable()){f=f.getParentElementOverlay();}return f;};
U.getFirstFocusableDescendantOverlay=function(o){return O.getFirstDescendantByCondition(o,this.isOverlaySelectable);};
U.getNextFocusableSiblingOverlay=function(o){var n=O.getNextSiblingOverlay(o);while(n&&!this.isOverlaySelectable(n)){n=O.getNextSiblingOverlay(n);}return n;};
U.getPreviousFocusableSiblingOverlay=function(o){var p=O.getPreviousSiblingOverlay(o);while(p&&!this.isOverlaySelectable(p)){p=O.getPreviousSiblingOverlay(p);}return p;};
U.getIndex=function(p,c,a,g){var i;if(g&&typeof g==="function"){i=g.call(null,p,c);}else{var m=p.getMetadata();var A=m.getAggregation(a);var G=A._sGetter;var C=p[G]();if(Array.isArray(C)){if(c){i=C.indexOf(c)+1;}else{i=C.length;}}else{i=0;}}return i;};
U.createFieldLabelId=function(p,e,b){return(p.getId()+"_"+e+"_"+b).replace("/","_");};
U.getBoundEntityType=function(e,m){m||(m=e.getModel());var b=e.getBindingContext();if(b){return U.getEntityTypeByPath(m,b.getPath())||{};}return{};};
U.openNewWindow=function(u){window.open(u,"_blank");};
U.getElementBindingPaths=function(e){var p={};if(e.mBindingInfos){for(var i in e.mBindingInfos){var P=e.mBindingInfos[i].parts[0].path?e.mBindingInfos[i].parts[0].path:"";P=P.split("/")[P.split("/").length-1];p[P]={valueProperty:i};}}return p;};
U.getFiori2Renderer=function(){var c=U.getUshellContainer()||{};return typeof c.getRenderer==="function"?c.getRenderer("fiori2"):undefined;};
U.getUshellContainer=function(){return sap.ushell&&sap.ushell.Container;};
U.getEntityTypeByPath=function(m,p){return m.oMetadata&&m.oMetadata._getEntityTypeByPath(p);};
U.mergeWith=function(d,s,c){if(!(typeof c==="function")){throw new Error('In order to use mergeWith() utility function fnCustomizer should be provided!');}for(var a in s){if(s.hasOwnProperty(a)){d[a]=d.hasOwnProperty(a)?c(d[a],s[a],a,d,s):s[a];}}return d;};
U.extendWith=function(d,s,c){if(!(typeof c==="function")){throw new Error('In order to use extendWith() utility function fnCustomizer should be provided!');}for(var a in s){if(s.hasOwnProperty(a)){if(c(d[a],s[a],a,d,s)){d[a]=s[a];}}}};
U.isElementInViewport=function(d){if(d instanceof q){d=d.get(0);}var r=d.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&r.right<=(window.innerWidth||document.documentElement.clientWidth));};
U._showMessageBox=function(m,t,s,e,a){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var b=r.getText(s,e?[e.message||e]:undefined);var T=r.getText(t);var A=a?r.getText(a):M.Action.OK;return new Promise(function(c){M.show(b,{icon:m,title:T,onClose:c,actions:A,styleClass:U.getRtaStyleClassName()});});};
return U;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantDialog',['sap/m/Dialog','sap/m/DialogRenderer','sap/ui/layout/form/SimpleForm','sap/ui/layout/form/ResponsiveGridLayout','sap/ui/rta/Utils'],function(D,a,S,R,b){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var d,t,T,s,o,c,e,i,I,f,g,C,h;
function _(){d=new sap.m.GenericTile("tile",{header:"{/title}",subheader:"{/subtitle}",ariaLabel:r.getText("APP_VARIANT_TILE_ARIA_LABEL"),tileContent:[new sap.m.TileContent({content:[new sap.m.ImageContent({src:"{/icon}"})]})]}).addStyleClass("sapUiMediumMarginBegin").addStyleClass("sapUiTinyMarginTop").addStyleClass("sapUiTinyMarginBottom");}
function j(E){var v=E.getParameter("value");var F=new sap.ui.model.Filter("name",sap.ui.model.FilterOperator.Contains,v);var B=E.getSource().getBinding("items");B.filter([F]);}
function k(E){var q=E.getParameter("selectedContexts");if(q&&q.length){q.forEach(function(u){var v=u.getObject().name;I.setValue(v);C.setProperty("/icon",u.getObject().icon);});}E.getSource().getBinding("items").filter([]);}
function l(){if(!g){g=new sap.m.SelectDialog("selectDialog",{noDataText:r.getText("APP_VARIANT_ICON_NO_DATA"),title:r.getText("APP_VARIANT_ICON_SELECT_ICON"),search:function(E){j(E);},confirm:function(E){k(E);},cancel:function(E){k(E);}});}g.addStyleClass(b.getRtaStyleClassName());g.bindAggregation("items",{path:"/icons",template:new sap.m.StandardListItem({title:"{name}",description:"",icon:"{icon}",iconDensityAware:false,iconInset:false,type:"Active"})});var u=sap.ui.core.IconPool.getIconNames();var q=[];u.forEach(function(N){q.push({icon:sap.ui.core.IconPool.getIconInfo(N).uri,name:N.toLowerCase()});});h.setProperty("/icons",q);g.setModel(h);g.getBinding("items").filter([]);g.open();}
function m(){t=new sap.m.Label({required:true,text:r.getText("APP_DIALOG_TITLE_TEXT"),textAlign:"Left"});T=new sap.m.Input("titleInput",{value:"{/title}",valueLiveUpdate:true,placeholder:r.getText("SAVE_AS_DIALOG_PLACEHOLDER_TITLE_TEXT"),liveChange:function(){var q=sap.ui.getCore().byId("saveButton");if(this.getValue()===""){this.setValueState(sap.ui.core.ValueState.Error);q.setEnabled(false);}else{this.setValueState(sap.ui.core.ValueState.None);q.setEnabled(true);}}});s=new sap.m.Label({text:r.getText("APP_DIALOG_SUB_TITLE_TEXT"),textAlign:"Left"});o=new sap.m.Input({value:"{/subtitle}",valueLiveUpdate:true});c=new sap.m.Label({text:r.getText("APP_DIALOG_DESCRIPTION_TEXT"),textAlign:"Left"});e=new sap.m.TextArea({rows:4});i=new sap.m.Label({text:r.getText("APP_DIALOG_ICON_TEXT"),textAlign:"Left"});I=new sap.m.Input("selectInput",{showValueHelp:true,liveChange:function(E){l(E);},valueHelpRequest:function(E){l(E);},value:"{/iconname}",valueLiveUpdate:true});}
function n(){f=new sap.ui.layout.form.SimpleForm({editable:true,layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:4,adjustLabelSpan:false,emptySpanXL:0,emptySpanL:0,emptySpanM:0,emptySpanS:0,columnsXL:2,columnsL:2,columnsM:2,singleContainerFullSize:false,content:[new sap.ui.core.Title("title1"),t,T,s,o,i,I,c,e,new sap.ui.core.Title("title2"),d]});return f;}
function p(){var v=new sap.m.VBox({items:[n()]}).addStyleClass("sapUISmallMargin");return v;}
var A=D.extend("sap.ui.rta.appVariant.AppVariantDialog",{
metadata:{library:"sap.ui.rta",events:{create:{},cancel:{}}},
init:function(){D.prototype.init.apply(this);this.setTitle(r.getText("CREATE_APP_VARIANT_DIALOG_TITLE"));this.setContentWidth("620px");this.setContentHeight("250px");C=new sap.ui.model.json.JSONModel({title:null,subtitle:null,icon:" ",iconname:null});h=new sap.ui.model.json.JSONModel({icons:null});sap.ui.getCore().setModel(C);_();m();this.addContent(p());this._createButtons();this.addStyleClass(b.getRtaStyleClassName());},
onAfterRendering:function(){document.getElementById('title1').style.height="0px";document.getElementById('title2').style.height="0px";document.getElementById('tile').style.float="left";},
_onCreate:function(){var q=T.getValue()||" ";var u=o.getValue()||" ";var v=e.getValue()||" ";var w=I.getValue()?sap.ui.core.IconPool.getIconInfo(I.getValue()).uri:" ";this.fireCreate({title:q,subTitle:u,description:v,icon:w});this.close();this.destroy();},
_createButtons:function(){this.addButton(new sap.m.Button("saveButton",{text:r.getText("APP_VARIANT_DIALOG_SAVE"),tooltip:r.getText("TOOLTIP_APP_VARIANT_DIALOG_SAVE"),enabled:false,press:function(){this._onCreate();}.bind(this)}));this.addButton(new sap.m.Button({text:r.getText("SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),tooltip:r.getText("TOOLTIP_SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),press:function(){this.fireCancel();this.close();this.destroy();}.bind(this)}));},
destroy:function(){if(C){C.destroy();}D.prototype.destroy.apply(this,arguments);},
renderer:a.render
});
return A;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantManager',["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/m/MessageBox","sap/ui/rta/appVariant/Feature","sap/ui/fl/transport/TransportSelection","sap/ui/rta/appVariant/S4HanaCloudBackend","sap/ui/rta/Utils","sap/ui/core/BusyIndicator"],function(M,A,a,b,R,T,S,c,B){"use strict";
var d=M.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{"rootControl":{type:"sap.ui.core.Control"},"commandSerializer":{type:"object"}}}});
d.prototype._openDialog=function(C,f){var D=new A("appVariantDialog");D.attachCreate(C);D.attachCancel(f);D.attachAfterClose(function(){this.destroy();});D.open();return D;};
d.prototype._prepareAppVariantData=function(D,p){return{idRunningApp:D["sap.app"].id,title:p.title,subTitle:p.subTitle,description:p.description,icon:p.icon,inbounds:D["sap.app"].crossNavigation&&D["sap.app"].crossNavigation.inbounds?D["sap.app"].crossNavigation.inbounds:null};};
d.prototype.createAllInlineChanges=function(o){var s,e=[],p;s=a.getId(o.idRunningApp);var f={id:s,reference:o.idRunningApp};e.push(a.createDescriptorVariant(f));p=a.getInlinePropertyChange("title",o.title);e.push(a.createInlineChange(p,"title"));p=a.getInlinePropertyChange("subtitle",o.subTitle);e.push(a.createInlineChange(p,"subtitle"));p=a.getInlinePropertyChange("description",o.description);e.push(a.createInlineChange(p,"description"));p=a.getInlineChangeInputIcon(o.icon);e.push(a.createInlineChange(p,"icon"));var i=a.getInboundInfo(o.inbounds);var C=i.currentRunningInbound;var g=i.addNewInboundRequired;if(C==="customer.savedAsAppVariant"&&g){p=a.getInlineChangeCreateInbound(C);e.push(a.createInlineChange(p,"createInbound"));}p=a.getInlineChangeForInboundPropertySaveAs(C);e.push(a.createInlineChange(p,"inbound"));p=a.getInlineChangeRemoveInbounds(C);e.push(a.createInlineChange(p,"removeInbound"));p=a.getInlineChangesForInboundProperties(C,s,"title",o.title);e.push(a.createInlineChange(p,"inboundTitle"));p=a.getInlineChangesForInboundProperties(C,s,"subTitle",o.subTitle);e.push(a.createInlineChange(p,"inboundSubtitle"));p=a.getInlineChangesForInboundProperties(C,s,"icon",o.icon);e.push(a.createInlineChange(p,"inboundIcon"));return e;};
d.prototype._onTransportInDialogSelected=function(o,t){if(t){if(t.transport&&t.packageName!=="$TMP"){var p=[];if(t.transport){p.push(o.setTransportRequest(t.transport));}if(p.length){return Promise.all(p).then(function(){return Promise.resolve(o);});}}return Promise.resolve(o);}return Promise.resolve(false);};
d.prototype.createDescriptor=function(o){var i=this.createAllInlineChanges(o);var O=function(t){var f=new T();return f.openTransportSelection(t,this,c.getRtaStyleClassName());};var e;return Promise.all(i).then(function(r){e=r.shift();i=[];r.forEach(function(I){i.push(e.addDescriptorInlineChange(I));});return Promise.all(i);}).then(function(){var n=e.getNamespace();var t=a.getTransportInput("",n,"manifest","appdescr_variant");return O.call(this,t);}.bind(this)).then(function(t){return this._onTransportInDialogSelected(e,t);}.bind(this))["catch"](function(E){var f=a.buildErrorInfo("MSG_CREATE_DESCRIPTOR_FAILED",E,e.getId());B.hide();return a.showRelevantDialog(f,false);});};
d.prototype.processSaveAsDialog=function(D,s){return new Promise(function(r){var C=function(o){var p=o.getParameters();var e=this._prepareAppVariantData(D,p);r(e);}.bind(this);var f=function(){if(!s){return R.onGetOverview(true);}};return this._openDialog(C,f);}.bind(this));};
d.prototype.saveAppVariantToLREP=function(o){return o.submit()["catch"](function(e){B.hide();var E=a.buildErrorInfo("MSG_SAVE_APP_VARIANT_FAILED",e,o.getId());return a.showRelevantDialog(E,false);});};
d.prototype._takeOverDirtyChangesByAppVariant=function(r){return this.getCommandSerializer().saveAsCommands(r);};
d.prototype._deleteAppVariantFromLREP=function(s){return a.triggerDeleteAppVariantFromLREP(s);};
d.prototype.copyUnsavedChangesToLREP=function(s,C){var o=this.getCommandSerializer().getCommandStack();if(C&&o.getAllExecutedCommands().length){return this._takeOverDirtyChangesByAppVariant(s)["catch"](function(e){return this._deleteAppVariantFromLREP(s)["catch"](function(e){B.hide();var E=a.buildErrorInfo("SAVE_AS_MSG_DELETE_APP_VARIANT",e,s);return a.showRelevantDialog(E,false);}).then(function(){B.hide();var E=a.buildErrorInfo("MSG_COPY_UNSAVED_CHANGES_FAILED",e);return a.showRelevantDialog(E,false);});}.bind(this));}return Promise.resolve();};
d.prototype.triggerCatalogAssignment=function(o){if(a.isS4HanaCloud(o.getSettings())){return a.triggerCatalogAssignment(o.getId(),o.getReference())["catch"](function(e){B.hide();var E=a.buildErrorInfo("MSG_CATALOG_ASSIGNMENT_FAILED",e,o.getId());return a.showRelevantDialog(E,false);});}return Promise.resolve();};
d.prototype.notifyKeyUserWhenTileIsReady=function(i,s){var o=new S();return o.notifyFlpCustomizingIsReady(i,function(I){var m=a.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");var t=a.getText("SAVE_APP_VARIANT_NEW_TILE_AVAILABLE_TITLE");return new Promise(function(r){b.show(m,{icon:b.Icon.INFORMATION,title:t,onClose:r,styleClass:c.getRtaStyleClassName()});});})["catch"](function(e){B.hide();var E=a.buildErrorInfo("MSG_TILE_CREATION_FAILED",e,s);E.copyId=true;return a.showRelevantDialog(E,false);});};
d.prototype._buildSuccessInfo=function(o,s){var C=false;var m=a.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")+"\n\n";if(a.isS4HanaCloud(o.getSettings())){if(s){m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_CLOUD_MESSAGE");}else{m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_CLOUD_MESSAGE_OVERVIEW_LIST");}}else if(s){m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_ON_PREMISE_MESSAGE",o.getId());C=true;}else{m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_ON_PREMISE_MESSAGE_OVERVIEW_LIST",o.getId());C=true;}return{text:m,appVariantId:o.getId(),copyId:C};};
d.prototype._navigateToFLPHomepage=function(){var o=sap.ushell.services.AppConfiguration.getCurrentApplication();var C=o.componentHandle.getInstance();if(C){var e=sap.ushell.Container.getService("CrossApplicationNavigation");if(e.toExternal){e.toExternal({target:{shellHash:"#"}},C);return Promise.resolve();}}return Promise.resolve();};
d.prototype.showSuccessMessageAndTriggerActionFlow=function(o,s){var e=this._buildSuccessInfo(o,s);B.hide();return a.showRelevantDialog(e,true).then(function(){return s?this._navigateToFLPHomepage():R.onGetOverview(true);}.bind(this));};
return d;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantOverviewDialog',['sap/ui/core/ComponentContainer','sap/m/Dialog','sap/m/DialogRenderer','sap/ui/rta/appVariant/manageApps/webapp/Component',"sap/ui/fl/Utils","sap/ui/rta/Utils","sap/ui/rta/appVariant/AppVariantUtils"],function(C,D,a,M,F,R,A){"use strict";
var b=D.extend("sap.ui.rta.appVariant.AppVariantOverviewDialog",{
metadata:{properties:{"idRunningApp":"string",isOverviewForKeyUser:{type:"boolean"}},events:{cancel:{}}},
constructor:function(){D.prototype.constructor.apply(this,arguments);this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this.oManageAppsComponent=new M("manageApps",{idRunningApp:this.getIdRunningApp(),isOverviewForKeyUser:this.getIsOverviewForKeyUser()});this.oManageAppsComponentContainer=new C({component:this.oManageAppsComponent});this.addContent(this.oManageAppsComponentContainer);this._createButton();this.setContentWidth("1000px");this.setContentHeight("450px");this.setHorizontalScrolling(false);this.setTitle(this._oTextResources.getText("APP_VARIANT_OVERVIEW_DIALOG_TITLE"));this.addStyleClass(R.getRtaStyleClassName());},
destroy:function(){var n=A.getNewAppVariantId();if(n){A.setNewAppVariantId(null);}D.prototype.destroy.apply(this,arguments);},
renderer:a.render
});
b.prototype._createButton=function(){this.addButton(new sap.m.Button({text:this._oTextResources.getText("APP_VARIANT_DIALOG_CLOSE"),press:function(){this.close();this.fireCancel();}.bind(this)}));};
return b;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantUtils',["sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory","sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils"],function(D,a,L,F,M,R){"use strict";var A={};var H=56;A._newAppVariantId=null;
A.getManifirstSupport=function(r){var s='/sap/bc/ui2/app_index/ui5_app_mani_first_supported/?id='+r;var l=L.createConnector();return l.send(s,'GET');};
A.isStandAloneApp=function(){if(sap.ushell_abap){return false;}else{return true;}};
A.getNewAppVariantId=function(){return A._newAppVariantId;};
A.setNewAppVariantId=function(n){A._newAppVariantId=n;};
A.trimIdIfRequired=function(i){return i.substr(0,H);};
A.getId=function(b){var c;var i=b.split('.');if(i[0]!=="customer"){i[0]="customer."+i[0];}var r=false;var d=/^id.*/i;i.forEach(function(s,e,f){if(s.match(d)){s=s.replace(d,jQuery.sap.uid().replace(/-/g,"_"));f[e]=s;r=true;}});c=i.join(".");if(!r){c=c+"."+jQuery.sap.uid().replace(/-/g,"_");}c=this.trimIdIfRequired(c);this.setNewAppVariantId(c);return c;};
A.createDescriptorVariant=function(p){p.layer=F.getCurrentLayer(false);return D.createNew(p);};
A.getInlineChangeInput=function(v,c){return{"type":"XTIT","maxLength":50,"comment":c,"value":{"":v}};};
A.getInlinePropertyChange=function(p,P){var c="New "+p+" entered by a key user via RTA tool";return this.getInlineChangeInput(P,c);};
A.getInlineChangeInputIcon=function(i){return{icon:i};};
A.getInlineChangeRemoveInbounds=function(i){return{"inboundId":i};};
A.getURLParsedHash=function(){var u=sap.ushell.Container.getService("URLParsing");if(u.parseShellHash&&u.getHash){return u.parseShellHash(u.getHash(window.location.href));}};
A.getInboundInfo=function(i){var I={};if(!i){I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;return I;}var p=this.getURLParsedHash();var b=Object.keys(i);var c=[];b.forEach(function(s){if((i[s].action===p.action)&&(i[s].semanticObject===p.semanticObject)){c.push(s);}});switch(c.length){case 0:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;case 1:I.currentRunningInbound=c[0];I.addNewInboundRequired=false;break;default:I=undefined;break;}return I;};
A.getInboundPropertiesKey=function(s,c,p){return s+"_sap.app.crossNavigation.inbounds."+c+"."+p;};
A.getInlineChangesForInboundProperties=function(c,s,p,P){var C={"inboundId":c,"entityPropertyChange":{"propertyPath":p,"operation":"UPSERT","propertyValue":{}},"texts":{}};if(p==="title"||p==="subTitle"){var k=this.getInboundPropertiesKey(s,c,p);C.entityPropertyChange.propertyValue="{{"+k+"}}";C.texts[k]=this.getInlinePropertyChange(p,P);}else if(p==="icon"){C.entityPropertyChange.propertyValue=P;}return C;};
A.getInlineChangeForInboundPropertySaveAs=function(c){return{"inboundId":c,"entityPropertyChange":{"propertyPath":"signature/parameters/sap-appvar-id","operation":"UPSERT","propertyValue":{"required":true,"filter":{"value":this.getNewAppVariantId(),"format":"plain"},"launcherValue":{"value":this.getNewAppVariantId()}}}};};
A.getInlineChangeCreateInbound=function(c){var p=this.getURLParsedHash();var P={"inbound":{}};P.inbound[c]={"semanticObject":p.semanticObject,"action":p.action};return P;};
A.createInlineChange=function(p,c){var t;if(c==="title"){return a.create_app_setTitle(p);}else if(c==="description"){return a.create_app_setDescription(p);}else if(c==="subtitle"){return a.create_app_setSubTitle(p);}else if(c==="icon"){return a.create_ui_setIcon(p);}else if(c==="inbound"){return a.create_app_changeInbound(p);}else if(c==="createInbound"){return a.create_app_addNewInbound(p);}else if(c==="inboundTitle"){t=p.texts;delete p.texts;return a.create_app_changeInbound(p,t);}else if(c==="inboundSubtitle"){t=p.texts;delete p.texts;return a.create_app_changeInbound(p,t);}else if(c==="inboundIcon"){delete p.texts;return a.create_app_changeInbound(p);}else if(c==="removeInbound"){return a.create_app_removeAllInboundsExceptOne(p);}};
A.getTransportInput=function(p,n,N,t){return{getPackage:function(){return p;},getNamespace:function(){return n;},getId:function(){return N;},getDefinition:function(){return{fileType:t};}};};
A.triggerCatalogAssignment=function(s,o){var r='/sap/bc/lrep/appdescr_variants/'+s+'?action=assignCatalogs&assignFromAppId='+o;var l=L.createConnector();return l.send(r,'POST');};
A.isS4HanaCloud=function(s){return s.isAtoEnabled()&&s.isAtoAvailable();};
A.copyId=function(i){var t=document.createElement("textarea");t.value=i;document.body.appendChild(t);t.select();document.execCommand('copy');document.body.removeChild(t);return true;};
A.getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
A.getText=function(m,t){var T=this.getTextResources();return t?T.getText(m,t):T.getText(m);};
A._getErrorMessageText=function(e){var E;if(e.messages&&e.messages.length){E=e.messages.map(function(e){return e.text;}).join("\n");}else if(e.iamAppId){E="IAM App Id: "+e.iamAppId;}else{E=e.stack||e.message||e.status||e;}return E;};
A.buildErrorInfo=function(m,e,s){var E=this._getErrorMessageText(e);var b=A.getText(m)+"\n\n";if(s){b+=A.getText("MSG_APP_VARIANT_ID",s)+"\n";}b+=A.getText("MSG_TECHNICAL_ERROR",E);jQuery.sap.log.error("App variant error: ",E);return{text:b,appVariantId:s};};
A.showRelevantDialog=function(i,s){var t,r;if(s){t=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");r=this.getText("SAVE_APP_VARIANT_OK_TEXT");}else{t=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");r=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT");}var c;var b=[];if(i.copyId){c=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");b.push(c);}b.push(r);return new Promise(function(d,e){var C=function(f){if(s&&f===r){d();}else if(s&&f===c){A.copyId(i.appVariantId);d();}else if(i.overviewDialog&&f===r){d(false);}else if(f===r){e();}else if(f===c){A.copyId(i.appVariantId);e();}};M.show(i.text,{icon:s?M.Icon.INFORMATION:M.Icon.ERROR,onClose:C,title:t,actions:b,styleClass:R.getRtaStyleClassName()});});};
A.publishEventBus=function(){sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate");};
A.triggerDeleteAppVariantFromLREP=function(s){return D.createDeletion(s).then(function(o){return o.submit();});};
return A;},true);
sap.ui.predefine('sap/ui/rta/appVariant/Feature',["sap/ui/rta/Utils","sap/ui/fl/Utils","sap/ui/rta/appVariant/AppVariantUtils","sap/m/MessageBox","sap/ui/core/BusyIndicator"],function(R,F,A,M,B){"use strict";var a,o,r,c,C,d;var g=function(){return F.getAppDescriptor(r);};var t=function(e){return o.createDescriptor(e);};var T=function(D){if(D){d=null;B.show();d=jQuery.extend({},D);return o.saveAppVariantToLREP(D);}else{return Promise.reject();}};var f=function(){return o.triggerCatalogAssignment(d);};var b=function(e){if(e&&e.response&&e.response.IAMId){return o.notifyKeyUserWhenTileIsReady(e.response.IAMId,d.getId());}return Promise.resolve();};sap.ui.getCore().getEventBus().subscribe("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate",function(){if(a){a.destroy();a=null;}});return{onGetOverview:function(e){var D=g();return new Promise(function(h){var i=function(){A.publishEventBus();};sap.ui.require(["sap/ui/rta/appVariant/AppVariantOverviewDialog"],function(j){if(!a){a=new j({idRunningApp:D["sap.app"].id,isOverviewForKeyUser:e});}a.attachCancel(i);a.oPopup.attachOpened(function(){h(a);});a.open();});});},isOverviewExtended:function(){var u=jQuery.sap.getUriParameters();if(!u.mParams["sap-ui-xx-app-variant-overview-extended"]){return false;}else{var m=u.mParams["sap-ui-xx-app-variant-overview-extended"];if(m&&m.length){var s=m[0].toLowerCase();return s==='true';}}},isManifestSupported:function(){var D=g();return A.getManifirstSupport(D["sap.app"].id).then(function(e){return e.response;}).catch(function(e){var E=A.buildErrorInfo("MSG_APP_VARIANT_FEATURE_FAILED",e);E.overviewDialog=true;return A.showRelevantDialog(E,false);});},isPlatFormEnabled:function(e,s,l){r=e;c=l;var D=g();if(D["sap.app"]&&D["sap.app"].id){if(R.getUshellContainer()&&!A.isStandAloneApp()&&s==="CUSTOMER"){var i;if(D["sap.app"].crossNavigation&&D["sap.app"].crossNavigation.inbounds){i=A.getInboundInfo(D["sap.app"].crossNavigation.inbounds);}else{i=A.getInboundInfo();}if(i){return true;}}}return false;},onSaveAsFromRtaToolbar:function(s,e){var D;if(s){D=g();}else{D=jQuery.extend(true,{},C);C=null;}return new Promise(function(h){var p=function(){return o.processSaveAsDialog(D,s);};var i=function(){if(e){return o.copyUnsavedChangesToLREP(d.getId(),e);}return Promise.resolve();};var j=function(k){var u=R.getUshellContainer();if(u&&e){u.setDirtyFlag(false);}return o.showSuccessMessageAndTriggerActionFlow(d,s).then(function(){return b(k).then(h);});};sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(k){if(!o){o=new k({rootControl:r,commandSerializer:c});}var P=[p,t,T,i,f,j];function l(m){return m.reduce(function(n,q){return n.then(q);},Promise.resolve()).catch(function(){return Promise.resolve(false);});}l(P);});});},onSaveAsFromOverviewDialog:function(e,s){var h=false;var D=g();if(e["sap.app"].id===D["sap.app"].id){h=true;}C=jQuery.extend(true,{},e);e=null;return this.onSaveAsFromRtaToolbar(s,h);}};});
sap.ui.predefine('sap/ui/rta/appVariant/S4HanaCloudBackend',["sap/ui/base/ManagedObject","sap/ui/model/odata/v2/ODataModel"],function(M,O){"use strict";
var S=M.extend("sap.ui.rta.appVariant.S4HanaCloudBackend",{constructor:function(){M.apply(this,arguments);}});
S.prototype.notifyFlpCustomizingIsReady=function(i,I,c,m){var t=this;return new Promise(function(r,a){function b(n){return!isNaN(parseFloat(n))&&isFinite(n);}var d=b(c)?c:2500;var R=b(m)?m:-1;function e(){if(R==0){r({iamAppId:i,flpCustomizingIsReady:false});return;}else if(R>0){R=R-1;}t.checkFlpCustomizingIsReady(i).then(function(f){if(f){r({iamAppId:i,flpCustomizingIsReady:true});I(i);}else{setTimeout(e.bind(t),d);}}).catch(function(){a({iamAppId:i});});}setTimeout(e.bind(t),d);});};
S._evaluateAppIntegrityEstimation=function(a){var m=(a&&a.AppStatusTable&&JSON.parse(a.AppStatusTable)&&JSON.parse(a.AppStatusTable).ITAB);if(!Array.isArray(m)){throw("Error: /sap/opu/odata/sap/APS_IAM_APP_SRV/checkAppIntegrity() returned unexpected result"+"for IAM app ID "+a.AppID);}var c=m.filter(function(o){return(o.TYPE=='W'&&o.ID=="CM_APS_IAM_APP"&&o.NUMBER=="057");}).length>=1;var C=m.filter(function(o){return(o.TYPE=='E'&&o.ID=="CM_APS_IAM_APP"&&o.NUMBER=="058");}).length>=1;var e=m.filter(function(o){return(o.TYPE=='E');}).length>=1;if((e&&!c)||C){throw("Error: Tile generation for app variant with IAM app ID "+a.AppID+" failed");}return(!c&&!e&&!a.AppStatus);};
S.prototype.checkFlpCustomizingIsReady=function(i){return new Promise(function(r,a){var m=new O("/sap/opu/odata/sap/APS_IAM_APP_SRV");m.attachMetadataFailed(function(e){a(e);});m.metadataLoaded().then(function(){m.callFunction("/checkAppIntegrity",{method:"POST",urlParameters:{AppID:i},error:a,success:r});});}).then(S._evaluateAppIntegrityEstimation);};
return S;});
sap.ui.predefine('sap/ui/rta/appVariant/Utils',["jquery.sap.global","sap/ui/fl/LrepConnector","sap/ui/rta/appVariant/AppVariantUtils"],function(q,L,A){"use strict";var U={};var m=q.sap.getModulePath("sap.ui.rta.appVariant.manageApps.webapp");var i=q.sap.resources({url:m+"/i18n/i18n.properties"});
U.sendRequest=function(r,o){var l=L.createConnector();return l.send(r,o);};
U.getAppVariantOverviewAttributes=function(a,k){var o;var c=function(){if(a.isOriginal&&a.isAppVariant){return i.getText("MAA_ORIGINAL_TYPE");}else if(a.isAppVariant){return i.getText("MAA_APP_VARIANT_TYPE");}else if(a.isOriginal){return i.getText("MAA_ORIGINAL_TYPE");}};var f=function(N){var b=sap.ushell.Container.getService("CrossApplicationNavigation");return b.getLinks(N);};var g=function(o){if(a.hasStartableIntent){var s=a.startWith.semanticObject;var b=a.startWith.action;var p=a.startWith.parameters;var N={semanticObject:s,action:b,params:p};return f(N).then(function(r){if(r.length&&k){o.adaptUIButtonVisibility=true;}else{o.adaptUIButtonVisibility=false;}o.semanticObject=s;o.action=b;if(p){Object.keys(p).forEach(function(P){if(p[P].value){p[P]=p[P].value;}});o.params=p;}return Promise.resolve(o);});}else{o.adaptUIButtonVisibility=false;return Promise.resolve(o);}};o={appId:a.appId,title:a.title||'',subTitle:a.subTitle||'',description:a.description||'',icon:a.iconUrl||'',isOriginal:a.isOriginal,typeOfApp:c(),descriptorUrl:a.descriptorUrl,isKeyUser:k};var n=A.getNewAppVariantId();if(n===a.appId){o.currentStatus=i.getText("MAA_NEW_APP_VARIANT");}return g(o);};
U.getAppVariantOverview=function(r,k){var l=k?'CUSTOMER*':'VENDOR';var R='/sap/bc/lrep/app_variant_overview/?sap.app/id='+r+'&layer='+l;return this.sendRequest(R,'GET').then(function(o){var a=[];var b;if(o.response&&o.response.items){b=o.response.items;}else{return Promise.resolve([]);}b.forEach(function(c){if(!c.isDescriptorVariant){a.push(this.getAppVariantOverviewAttributes(c,k));}},this);return Promise.all(a).then(function(c){return c;});}.bind(this));};
U.getDescriptor=function(d){return this.sendRequest(d,'GET').then(function(r){return r.response;});};
return U;},true);
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/Component',["sap/ui/core/UIComponent"],function(U){"use strict";var _,a;return U.extend("sap.ui.rta.appVariant.manageApps.webapp.Component",{metadata:{"manifest":"json","library":"sap.ui.rta","version":"0.9","properties":{"idRunningApp":"string",isOverviewForKeyUser:{type:"boolean"}}},constructor:function(){_=arguments[1].idRunningApp;a=arguments[1].isOverviewForKeyUser;U.prototype.constructor.apply(this,arguments);},init:function(){this.setIdRunningApp(_);this.setIsOverviewForKeyUser(a);U.prototype.init.apply(this,arguments);}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/controller/ManageApps.controller',["jquery.sap.global","sap/ui/core/mvc/Controller","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/ui/rta/appVariant/AppVariantUtils"],function(q,C,M,A,a,R,b,c,B,d){"use strict";var _,e,m,i;return C.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit:function(){_=this.getOwnerComponent().getIdRunningApp();e=this.getOwnerComponent().getIsOverviewForKeyUser();m=q.sap.getModulePath("sap.ui.rta.appVariant.manageApps.webapp");i=q.sap.resources({url:m+"/i18n/i18n.properties"});B.show();return A.getAppVariantOverview(_,e).then(function(f){B.hide();if(f.length){return this._arrangeOverviewDataAndBindToModel(f).then(function(f){return this._highlightNewCreatedAppVariant(f);}.bind(this));}else{d.publishEventBus();return this._showMessageWhenNoAppVariantsExist();}}.bind(this))["catch"](function(E){d.publishEventBus();var o=d.buildErrorInfo("MSG_MANAGE_APPS_FAILED",E);o.overviewDialog=true;B.hide();return d.showRelevantDialog(o,false);});},_showMessageWhenNoAppVariantsExist:function(){var s=i.getText("MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER");var t=i.getText("TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER");return new Promise(function(r){a.show(s,{icon:a.Icon.INFORMATION,title:t,onClose:r,styleClass:R.getRtaStyleClassName()});});},_highlightNewCreatedAppVariant:function(f){var t=this.byId("Table1");f.forEach(function(o,g){if(o.currentStatus){if(t.getItems().length>=g){t.getItems()[g].focus();}}});return Promise.resolve();},_arrangeOverviewDataAndBindToModel:function(f){var g=f.filter(function(l){return l.appId===_;});var o=g[0];if(o){o.currentStatus=i.getText("MAA_CURRENTLY_ADAPTING");}f=f.filter(function(l){return l.appId!==_;});f.unshift(o);var r=f.filter(function(l){return l.isOriginal;});var h=r[0];f=f.filter(function(l){return!l.isOriginal;});f.unshift(h);var j={appVariants:f};var k=M.createModel(j);this.getView().setModel(k);return Promise.resolve(f);},formatRowHighlight:function(v){if(v===i.getText("MAA_CURRENTLY_ADAPTING")){return"Success";}else if(v===i.getText("MAA_NEW_APP_VARIANT")){return"Information";}return"None";},getModelProperty:function(s,f){return this.getView().getModel().getProperty(s,f);},handleUiAdaptation:function(E){var n=sap.ushell.Container.getService("CrossApplicationNavigation");var s=this.getModelProperty("semanticObject",E.getSource().getBindingContext());var f=this.getModelProperty("action",E.getSource().getBindingContext());var p=this.getModelProperty("params",E.getSource().getBindingContext());var N;if(s&&f&&p){N={target:{semanticObject:s,action:f},params:p};c.enableRestart("CUSTOMER");n.toExternal(N);d.publishEventBus();return true;}else{return false;}},saveAsAppVariant:function(E){d.publishEventBus();var D=this.getModelProperty("descriptorUrl",E.getSource().getBindingContext());B.show();return A.getDescriptor(D).then(function(o){B.hide();return b.onSaveAsFromOverviewDialog(o,false);});},copyId:function(E){var s=this.getModelProperty("appId",E.getSource().getBindingContext());d.copyId(s);}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/model/models',["sap/ui/model/json/JSONModel"],function(J){"use strict";return{createModel:function(d){var m=new J(d);m.setDefaultBindingMode("OneWay");return m;}};});
sap.ui.predefine('sap/ui/rta/command/AddODataProperty',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddODataProperty",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},newControlId:{type:"string"},bindingString:{type:"string"},entityType:{type:"string"},parentId:{type:"string"},oDataServiceVersion:{type:"string"}}}});
A.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),index:this.getIndex(),newControlId:this.getNewControlId(),bindingPath:this.getBindingString(),entityType:this.getEntityType(),parentId:this.getParentId(),oDataServiceVersion:this.getODataServiceVersion()};};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AddXML',['jquery.sap.global','sap/ui/rta/command/FlexCommand','sap/ui/fl/Utils'],function(q,F,a){"use strict";
var A=F.extend("sap.ui.rta.command.AddXML",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string"},fragmentPath:{type:"string"},targetAggregation:{type:"string"},index:{type:"int"},changeType:{type:"string",defaultValue:"addXML"}},associations:{},events:{}}});
A.prototype.bindProperty=function(n,b){if(n==="fragment"){return this.setFragment(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
A.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),fragmentPath:this.getFragmentPath(),targetAggregation:this.getTargetAggregation(),index:this.getIndex()};return s;};
A.prototype._applyChange=function(c,n){c.getDefinition().content.fragment=a.stringToAscii(this.getFragment());return F.prototype._applyChange.apply(this,arguments).then(function(){delete c.getDefinition().content.fragment;});};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AppDescriptorCommand',['sap/ui/rta/command/BaseCommand','sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory','sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory'],function(B,D,a){"use strict";
var A=B.extend("sap.ui.rta.command.AppDescriptor",{metadata:{library:"sap.ui.rta",properties:{reference:{type:"string"},appComponent:{type:"object"},layer:{type:"string"},changeType:{type:"string"},parameters:{type:"object"},texts:{type:"object"}},events:{}}});
A.prototype.needsReload=true;
A.prototype.prepare=function(f){this.setLayer(f.layer);return true;};
A.prototype.getPreparedChange=function(){return this._oPreparedChange;};
A.prototype.createAndStoreChange=function(){return D.createDescriptorInlineChange(this.getChangeType(),this.getParameters(),this.getTexts()).then(function(o){return new a().createNew(this.getReference(),o,this.getLayer(),this.getAppComponent());}.bind(this)).then(function(o){var c=o.store();this._oPreparedChange=c;}.bind(this));};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/BaseCommand',['sap/ui/base/ManagedObject'],function(M){"use strict";
var B=M.extend("sap.ui.rta.command.BaseCommand",{metadata:{library:"sap.ui.rta",properties:{name:{type:"string"},runtimeOnly:{type:"boolean"}},associations:{element:{type:"sap.ui.core.Element"}},events:{}}});
B.prototype.getElement=function(){var i=this.getAssociation("element");return sap.ui.getCore().byId(i);};
B.prototype.prepare=function(){return true;};
B.prototype.execute=function(){return Promise.resolve();};
B.prototype.getVariantChange=function(){return this._oVariantChange;};
B.prototype.undo=function(){return Promise.resolve();};
B.prototype.isEnabled=function(){return true;};
return B;},true);
sap.ui.predefine('sap/ui/rta/command/BindProperty',['sap/ui/rta/command/FlexCommand',"sap/ui/rta/Utils"],function(F,U){"use strict";
var B=F.extend("sap.ui.rta.command.BindProperty",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newBinding:{type:"string"},changeType:{type:"string",defaultValue:"propertyBindingChange"}},associations:{},events:{}}});
B.prototype.bindProperty=function(n,b){if(n==="newBinding"){return this.setNewBinding(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
B.prototype._getChangeSpecificData=function(){var e=this.getElement();var s={changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newBinding:this.getNewBinding()}};return s;};
return B;},true);
sap.ui.predefine('sap/ui/rta/command/Combine',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.Combine",{metadata:{library:"sap.ui.rta",properties:{source:{type:"any"},combineFields:{type:"any[]"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(){var f=[];this.getCombineFields().forEach(function(o){f.push(o.getId());});var s={changeType:this.getChangeType(),sourceControlId:this.getSource().getId(),combineFieldIds:f};return s;};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/CommandFactory',['sap/ui/base/ManagedObject','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayRegistry','sap/ui/fl/registry/ChangeRegistry','sap/ui/fl/Utils'],function(M,E,O,C,F){"use strict";
function c(o,l,A){var s;var J=false;if(typeof(A)==="string"){s=A;}else{s=A&&A.changeType;J=A&&A.jsOnly;}if(!s){return false;}l.setChangeType(s);l.setJsOnly(J);return true;}
function a(o,s,D){var A={changeType:"addXML"};if(D){jQuery.extend(A,D.getAction("addXML",o));}return A;}
function b(o,s,D){var n=s.element||sap.ui.getCore().byId(s.element.id);var A=D.getActionDataFromAggregations("createContainer",n)[0];return A;}
function d(o,s,D){var l=s.movedElements[0].element||sap.ui.getCore().byId(s.movedElements[0].id);var A=D.getAction("move",l);if(!A&&D.getMetadata().getName()==="sap.ui.dt.ElementDesignTimeMetadata"){A=D.getActionDataFromAggregations("move",o).filter(function(n){return n.aggregation===s.source.aggregation;})[0];}return A;}
function e(o,s,D){var r=s.renamedElement;var A=D.getAction("rename",r);return A;}
function f(o,s,D){var r=s.removedElement;if(!r){r=o;}else if(!(r instanceof M)){throw new Error("No valid 'removedElement' found");}var A=D.getAction("remove",r);return A;}
function g(o,s,D){var l=s.source;var A=D.getAction("combine",l);return A;}
function h(o,s,D){var S=s.source;var A=D.getAction("split",S);return A;}
function i(o,s,D){var n=s.element;var A=D.getAction("addODataProperty",n);return A;}
function j(o,s,D){var r=s.directParent;var A=D.getAction("reveal",r);return A;}
var m={"composite":{clazz:'sap.ui.rta.command.CompositeCommand'},"property":{clazz:'sap.ui.rta.command.Property'},"bindProperty":{clazz:'sap.ui.rta.command.BindProperty'},"addXML":{clazz:'sap.ui.rta.command.AddXML',configure:a},"createContainer":{clazz:'sap.ui.rta.command.CreateContainer',configure:b},"move":{clazz:'sap.ui.rta.command.Move',configure:d},"remove":{clazz:'sap.ui.rta.command.Remove',configure:f},"rename":{clazz:'sap.ui.rta.command.Rename',configure:e},"addODataProperty":{clazz:'sap.ui.rta.command.AddODataProperty',configure:i},"reveal":{clazz:'sap.ui.rta.command.Reveal',configure:j},"combine":{clazz:'sap.ui.rta.command.Combine',configure:g},"split":{clazz:'sap.ui.rta.command.Split',configure:h},"switch":{clazz:'sap.ui.rta.command.ControlVariantSwitch'},"duplicate":{clazz:'sap.ui.rta.command.ControlVariantDuplicate'},"setTitle":{clazz:'sap.ui.rta.command.ControlVariantSetTitle'},"configure":{clazz:'sap.ui.rta.command.ControlVariantConfigure'},"settings":{clazz:'sap.ui.rta.command.Settings'},"addLibrary":{clazz:'sap.ui.rta.command.appDescriptor.AddLibrary'},"appDescriptor":{clazz:'sap.ui.rta.command.AppDescriptorCommand'}};
function _(v,s,S,D,l,V){s=s[0].toLowerCase()+s.slice(1);var n=m[s];if(!n){throw new Error("Command '"+s+"' doesn't exist, check typing");}var o=n.clazz;jQuery.sap.require(o);var p=jQuery.sap.getObject(o);var I=v instanceof sap.ui.base.ManagedObject;S=jQuery.extend(S,{element:I?v:undefined,selector:I?undefined:v,name:s});var A;if(n.configure){A=n.configure(v,S,D);}var q;if(A&&A.changeOnRelevantContainer){q=O.getOverlay(v);S=jQuery.extend(S,{element:q.getRelevantContainer()});v=S.element;}var r=new p(S);var t=true;if(n.configure){t=c(v,r,A);}var P=t&&r.prepare(l,V);if(P){return r;}else{r.destroy();return undefined;}}
var k=M.extend("sap.ui.rta.command.CommandFactory",{metadata:{library:"sap.ui.rta",properties:{"flexSettings":{type:"object"}},associations:{},events:{}}});
k.prototype.init=function(){this.setProperty("flexSettings",{layer:"CUSTOMER",developerMode:true});};
k.prototype.setFlexSettings=function(l){this.setProperty("flexSettings",jQuery.extend(this.getFlexSettings(),l));};
k.prototype.getCommandFor=function(v,s,S,D,V){return _(v,s,S,D,this.getFlexSettings(),V);};
k.getCommandFor=function(v,s,S,D,l){if(!l){l={layer:"CUSTOMER",developerMode:true};}if(l.scenario||l.baseId){var L=F.buildLrepRootNamespace(l.baseId,l.scenario,l.projectId);l.rootNamespace=L;l.namespace=L+"changes/";}return _(v,s,S,D,l);};
return k;},true);
sap.ui.predefine('sap/ui/rta/command/CompositeCommand',['sap/ui/rta/command/BaseCommand','sap/ui/fl/Utils'],function(B,F){"use strict";
var C=B.extend("sap.ui.rta.command.CompositeCommand",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{}}});
C.prototype.execute=function(){var p=[];this._forEachCommand(function(c){p.push(c.execute.bind(c));});return F.execPromiseQueueSequentially(p,true).catch(function(e){var c=this.getCommands();c.forEach(function(o){if(o instanceof sap.ui.rta.command.FlexCommand){if(!o._aRecordedUndo){this.removeCommand(o);}}}.bind(this));return this.undo().then(function(){return Promise.reject(e);});}.bind(this));};
C.prototype.undo=function(){var p=[];this._forEachCommandInReverseOrder(function(c){p.push(c.undo.bind(c));});return F.execPromiseQueueSequentially(p);};
C.prototype._forEachCommand=function(d){var c=this.getCommands();c.forEach(d,this);};
C.prototype._forEachCommandInReverseOrder=function(d){var c=this.getCommands();for(var i=c.length-1;i>=0;i--){d.call(this,c[i]);}};
C.prototype._addCompositeIdToChange=function(c){if(c.getPreparedChange&&c.getPreparedChange()){var o=c.getPreparedChange().getDefinition();if(!o.support.compositeCommand){if(!this._sCompositeId){this._sCompositeId=F.createDefaultFileName("composite");}o.support.compositeCommand=this._sCompositeId;}}};
C.prototype.addCommand=function(c,s){this._addCompositeIdToChange(c);return this.addAggregation("commands",c,s);};
C.prototype.insertCommand=function(c,i,s){this._addCompositeIdToChange(c);return this.insertAggregation("commands",c,i,s);};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantConfigure',['sap/ui/rta/command/BaseCommand','sap/ui/fl/changeHandler/BaseTreeModifier','sap/ui/fl/Utils'],function(B,a,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantConfigure",{metadata:{library:"sap.ui.rta",properties:{control:{type:"any"},changes:{type:"array"}},associations:{},events:{}}});
C.prototype.MODEL_NAME="$FlexVariants";
C.prototype.prepare=function(F,v){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
C.prototype.execute=function(){var v=this.getControl();this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(this.MODEL_NAME);this.sVariantManagementReference=a.getSelector(v,this.oAppComponent).id;this._aPreparedChanges=[];this.getChanges().forEach(function(c){c.appComponent=this.oAppComponent;this._aPreparedChanges.push(this.oModel._setVariantProperties(this.sVariantManagementReference,c,true));}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var p;this.getChanges().forEach(function(c,i){p={};Object.keys(c).forEach(function(P){var o="original"+P.charAt(0).toUpperCase()+P.substr(1);if(P==="visible"){p[P]=true;}else if(c[o]){p[P]=c[o];p[o]=c[P];}else if(P.indexOf("original")===-1){p[P]=c[P];}});p.change=this._aPreparedChanges[i];this.oModel._setVariantProperties(this.sVariantManagementReference,p,false);}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);this._aPreparedChanges=null;}.bind(this));};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantDuplicate',['sap/ui/rta/command/BaseCommand','sap/ui/fl/changeHandler/BaseTreeModifier','sap/ui/fl/Utils'],function(B,a,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantDuplicate",{metadata:{library:"sap.ui.rta",properties:{sourceVariantReference:{type:"string"},newVariantReference:{type:"string"},newVariantTitle:{type:"string"}},associations:{},events:{}}});
C.prototype.MODEL_NAME="$FlexVariants";
C.prototype.prepare=function(F,v){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
C.prototype.execute=function(){var v=this.getElement(),s=this.getSourceVariantReference(),n=this.getNewVariantReference();this.oAppComponent=f.getAppComponentForControl(v);if(!n){n=f.createDefaultFileName("Copy");this.setNewVariantReference(n);}this.sVariantManagementReference=a.getSelector(v,this.oAppComponent).id;this.oModel=this.oAppComponent.getModel(this.MODEL_NAME);var p={variantManagementReference:this.sVariantManagementReference,appComponent:this.oAppComponent,layer:this.sLayer,newVariantReference:n,sourceVariantReference:s,title:this.getNewVariantTitle()};return this.oModel._copyVariant(p).then(function(c){this._oVariantChange=c[0];this._aPreparedChanges=c;}.bind(this));};
C.prototype.undo=function(){if(this._oVariantChange){return this.oModel.removeVariant(this._oVariantChange,this.getSourceVariantReference(),this.sVariantManagementReference).then(function(){this._oVariantChange=null;this._aPreparedChanges=null;}.bind(this));}};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantSetTitle',['sap/ui/rta/command/BaseCommand','sap/ui/fl/changeHandler/BaseTreeModifier','sap/ui/fl/Utils'],function(B,a,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSetTitle",{metadata:{library:"sap.ui.rta",properties:{oldText:{type:"string"},newText:{type:"string"}},associations:{},events:{}}});
C.prototype.MODEL_NAME="$FlexVariants";
C.prototype.prepare=function(F,v){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){this._oPreparedChange=this.getVariantChange();if(!this._oPreparedChange){return undefined;}return this._oPreparedChange;};
C.prototype.execute=function(){var v=this.getElement(),V=v.getTitle().getBinding("text");this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(this.MODEL_NAME);this.sVariantManagementReference=a.getSelector(v,this.oAppComponent).id;this.sCurrentVariant=this.oModel.getCurrentVariantReference(this.sVariantManagementReference);var c=this.oModel.getVariantProperty(this.sCurrentVariant,"title");this.setOldText(c);var p={appComponent:this.oAppComponent,variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getNewText(),layer:this.sLayer};return Promise.resolve(this.oModel._setVariantProperties(this.sVariantManagementReference,p,true)).then(function(o){this._oVariantChange=o;V.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var v=this.getElement().getTitle().getBinding("text"),p={variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getOldText(),change:this._oVariantChange};return Promise.resolve(this.oModel._setVariantProperties(this.sVariantManagementReference,p,false)).then(function(c){this._oVariantChange=c;v.checkUpdate(true);}.bind(this));};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantSwitch',['sap/ui/rta/command/BaseCommand','sap/ui/fl/changeHandler/BaseTreeModifier','sap/ui/fl/Utils'],function(B,a,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{targetVariantReference:{type:"string"},sourceVariantReference:{type:"string"}},associations:{},events:{}}});
C.prototype.MODEL_NAME="$FlexVariants";
C.prototype._getAppComponent=function(e){if(!this._oControlAppComponent){this._oControlAppComponent=e?f.getAppComponentForControl(e):this.getSelector().appComponent;}return this._oControlAppComponent;};
C.prototype.execute=function(){var e=this.getElement(),A=this._getAppComponent(e),n=this.getTargetVariantReference();this.oModel=A.getModel(this.MODEL_NAME);this.sVariantManagementReference=a.getSelector(e,A).id;return this._updateModelVariant(n);};
C.prototype.undo=function(){var o=this.getSourceVariantReference();return this._updateModelVariant(o);};
C.prototype._updateModelVariant=function(v){if(this.getTargetVariantReference()!==this.getSourceVariantReference()){return Promise.resolve(this.oModel.updateCurrentVariant(this.sVariantManagementReference,v));}return Promise.resolve();};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/CreateContainer',['jquery.sap.global','sap/ui/rta/command/FlexCommand'],function(q,F){"use strict";
var C=F.extend("sap.ui.rta.command.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},newControlId:{type:"string"},label:{type:"string"},parentId:{type:"string"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(f){var s={changeType:this.getChangeType(),index:this.getIndex(),newControlId:this.getNewControlId(),newLabel:this.getLabel(),parentId:this.getParentId()};return s;};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/FlexCommand',["sap/ui/rta/command/BaseCommand","sap/ui/fl/FlexControllerFactory","sap/ui/rta/ControlTreeModifier","sap/ui/fl/Utils","sap/ui/core/util/reflection/JsControlTreeModifier"],function(B,F,R,U,J){"use strict";
var a=B.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean"},selector:{type:"object"}},associations:{},events:{}}});
a.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id;};
a.prototype.getAppComponent=function(){if(!this._oControlAppComponent){var e=this.getElement();this._oControlAppComponent=e?U.getAppComponentForControl(e):this.getSelector().appComponent;}return this._oControlAppComponent;};
a.prototype.prepare=function(f,v){if(!this.getSelector()&&this.getElement()){var s={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:U.getControlType(this.getElement())};this.setSelector(s);}try{this._oPreparedChange=this._createChange(f,v);}catch(e){jQuery.sap.log.error(e.message||e.name);return false;}return true;};
a.prototype.getPreparedChange=function(){if(!this._oPreparedChange){this.prepare();}return this._oPreparedChange;};
a.prototype.execute=function(){var c=this.getPreparedChange();return this._applyChange(c);};
a.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),selector:{id:this.getElementId()}};};
a.prototype._createChange=function(f,v){return this._createChangeFromData(this._getChangeSpecificData(),f,v);};
a.prototype._createChangeFromData=function(c,f,v){if(f){jQuery.extend(c,f);}c.jsOnly=this.getJsOnly();var m=this.getAppComponent().getModel("$FlexVariants");var V;if(m&&v){V=m.getCurrentVariantReference(v);}var o=F.createForControl(this.getAppComponent());var b={"variantManagementReference":v,"variantReference":V};if(V){jQuery.extend(c,b);}return o.createChange(c,this.getElement()||this.getSelector());};
a.prototype.undo=function(){return Promise.resolve().then(function(){var c=this.getElement()||this.getSelector();var C=this.getPreparedChange();if(C.getRevertData()){var f=F.createForControl(this.getAppComponent());var r=f.isChangeHandlerRevertible(C,c);if(!r){jQuery.sap.log.error("No revert change function available to handle revert data for "+c);return;}var A=this.getAppComponent();return f.revertChangesOnControl([C],A);}else if(this._aRecordedUndo){R.performUndo(this._aRecordedUndo);}else{jQuery.sap.log.warning("Undo is not available for "+c);}}.bind(this));};
a.prototype._applyChange=function(c,n){var C=c.change||c;var A=this.getAppComponent();var s=R.bySelector(C.getSelector(),A);var f=F.createForControl(A);var r=f.isChangeHandlerRevertible(C,s);var p={modifier:r?J:R,appComponent:A,view:U.getViewForControl(s)};if(!r){R.startRecordingUndo();}return Promise.resolve(f.checkTargetAndApplyChange(C,s,p)).then(function(o){if(o.success){if(n){f.removeFromAppliedChangesOnControl(C,A,s);}}return o;}).then(function(o){if(!r){if(!C.getUndoOperations()){this._aRecordedUndo=R.stopRecordingUndo();}else{this._aRecordedUndo=C.getUndoOperations();C.resetUndoOperations();}}if(!o.success){return Promise.reject(o.error);}}.bind(this));};
return a;},true);
sap.ui.predefine('sap/ui/rta/command/LREPSerializer',['sap/ui/base/ManagedObject','sap/ui/rta/command/Stack','sap/ui/rta/command/FlexCommand','sap/ui/rta/command/BaseCommand','sap/ui/rta/command/AppDescriptorCommand','sap/ui/fl/FlexControllerFactory','sap/ui/fl/Utils','sap/ui/fl/Change','sap/ui/rta/ControlTreeModifier','sap/ui/fl/registry/Settings'],function(M,C,F,B,A,a,b,c,R,S){"use strict";
var L=M.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"commandStack":{type:"object"}},aggregations:{}}});
L.prototype._lastPromise=Promise.resolve();
L.prototype.setCommandStack=function(o){if(this.getCommandStack()){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);}this.setProperty("commandStack",o);o.addCommandExecutionHandler(this._fnHandleCommandExecuted);};
L.prototype.init=function(){this._fnHandleCommandExecuted=this.handleCommandExecuted.bind(this);};
L.prototype.exit=function(){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);};
L.prototype._isPersistedChange=function(p){return!!this.getCommandStack()._aPersistedChanges&&this.getCommandStack()._aPersistedChanges.indexOf(p.getId())!==-1;};
L.prototype.handleCommandExecuted=function(e){return(function(e){var p=e;this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var d=this.getCommandStack().getSubCommands(p.command);var f;if(p.undo){d.forEach(function(o){if(!(o instanceof F||o instanceof A)||o.getRuntimeOnly()){return;}var g=o.getPreparedChange();var h=o.getAppComponent();if(h){if(o instanceof F){f=a.createForControl(h);var i=R.bySelector(g.getSelector(),h);f.removeFromAppliedChangesOnControl(g,h,i);}else if(o instanceof A){f=this._getAppDescriptorFlexController(h);}f.deleteChange(g,h);}}.bind(this));}else{var D=[];d.forEach(function(o){if(o.getRuntimeOnly()){return;}if(o instanceof F){var g=o.getAppComponent();if(g){var f=a.createForControl(g);var P=o.getPreparedChange();if(P.getState()===c.states.DELETED){P.setState(c.states.NEW);}if(!this._isPersistedChange(P)){f.addPreparedChange(o.getPreparedChange(),g);}}}else if(o instanceof A){D.push(o.createAndStoreChange());}}.bind(this));return Promise.all(D);}}.bind(this));return this._lastPromise;}.bind(this))(e);};
L.prototype.needsReload=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var d=this.getCommandStack().getAllExecutedCommands();return d.some(function(o){return!!o.needsReload;});}.bind(this));return this._lastPromise;};
L.prototype.saveCommands=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var r=sap.ui.getCore().byId(this.getRootControl());if(!r){throw new Error("Can't save commands without root control instance!");}var f=a.createForControl(r);return f.saveAll();}.bind(this)).then(function(){var r=sap.ui.getCore().byId(this.getRootControl());var f=this._getAppDescriptorFlexController(r);return f.saveAll();}.bind(this)).then(function(){jQuery.sap.log.info("UI adaptation successfully transfered changes to layered repository");this.getCommandStack().removeAllCommands();}.bind(this));return this._lastPromise;};
L.prototype._getAppDescriptorFlexController=function(o){var d=b.getAppComponentForControl(o);var s=b.getComponentClassName(d).replace(".Component","");var e=b.getAppVersionFromManifest(d.getManifest());return a.create(s,e);};
L.prototype._moveChangeToAppVariant=function(r,f){return S.getInstance().then(function(s){var p={reference:r};var n=b.createNamespace(p,"changes");var d=this.getCommandStack().getAllExecutedCommands();d.forEach(function(o){if(o.getPreparedChange&&!o.getRuntimeOnly()){var v=o.getPreparedChange();if(!Array.isArray(v)){v=[v];}v.forEach(function(e){if(s.isAtoEnabled()){e.setRequest("ATO_NOTIFICATION");}e.setNamespace(n);e.setComponent(r);});}});return f.saveAll(true);}.bind(this));};
L.prototype._triggerUndoChanges=function(){var o=this.getCommandStack();var p=[];var d=o.getAllExecutedCommands();d.forEach(function(e){p.push(e.undo.bind(e));});p=p.reverse();return b.execPromiseQueueSequentially(p,false,true);};
L.prototype._removeCommands=function(f){var o=this.getCommandStack();var d=o.getAllExecutedCommands();d.forEach(function(e){if(e instanceof F){var g=e.getPreparedChange();var h=e.getAppComponent();var i=R.bySelector(g.getSelector(),h);f.removeFromAppliedChangesOnControl(g,h,i);}});o.removeAllCommands();};
L.prototype.saveAsCommands=function(r){if(!r){throw new Error("The id of the new app variant is required");}var o=sap.ui.getCore().byId(this.getRootControl());if(!o){throw new Error("Can't save commands without root control instance!");}var d=b.getAppDescriptor(o);if(d["sap.app"].id===r){throw new Error("The id of the app variant should be different from the current app id");}var f=a.createForControl(o);var e=this.getCommandStack();return this._moveChangeToAppVariant(r,f).then(function(){e.detachCommandExecuted(this.handleCommandExecuted.bind(this));return this._triggerUndoChanges();}.bind(this)).then(function(){this._removeCommands(f);e.attachCommandExecuted(this.handleCommandExecuted.bind(this));return true;}.bind(this));};
return L;},true);
sap.ui.predefine('sap/ui/rta/command/Move',['jquery.sap.global','sap/ui/rta/command/FlexCommand'],function(q,F){"use strict";
var M=F.extend("sap.ui.rta.command.Move",{metadata:{library:"sap.ui.rta",properties:{movedElements:{type:"any[]"},target:{type:"any"},source:{type:"any"}},associations:{},events:{}}});
M.prototype._getChangeSpecificData=function(i){var s=i?this.getTarget():this.getSource();var t=i?this.getSource():this.getTarget();if(s.parent){s.id=s.parent.getId();delete s.parent;}if(t.parent){t.id=t.parent.getId();delete t.parent;}var S={changeType:this.getChangeType(),source:s,target:t,movedElements:[]};this.getMovedElements().forEach(function(m){S.movedElements.push({id:m.id||(m.element&&m.element.getId()),sourceIndex:i?m.targetIndex:m.sourceIndex,targetIndex:i?m.sourceIndex:m.targetIndex});});return S;};
M.prototype.prepare=function(l,d){var s=F.prototype.prepare.apply(this,arguments);if(s){this._oPreparedUndoChange=this._createChangeFromData(this._getChangeSpecificData(true),l,d);}return s;};
M.prototype.undo=function(){return this._applyChange(this._oPreparedUndoChange,true);};
return M;},true);
sap.ui.predefine('sap/ui/rta/command/Property',['sap/ui/rta/command/FlexCommand',"sap/ui/rta/Utils"],function(F,U){"use strict";
var P=F.extend("sap.ui.rta.command.Property",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newValue:{type:"any"},semanticMeaning:{type:"string"},changeType:{type:"string",defaultValue:"propertyChange"}},associations:{},events:{}}});
P.prototype._getChangeSpecificData=function(){var e=this.getElement();return{changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newValue:this.getNewValue(),semantic:this.getSemanticMeaning()}};};
return P;},true);
sap.ui.predefine('sap/ui/rta/command/Remove',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Remove",{metadata:{library:"sap.ui.rta",properties:{removedElement:{type:"any"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var e=this.getRemovedElement()||this.getElement();var s={changeType:this.getChangeType(),removedElement:{id:e.getId()}};return s;};
return R;},true);
sap.ui.predefine('sap/ui/rta/command/Rename',['jquery.sap.global','sap/ui/rta/command/FlexCommand'],function(q,F){"use strict";
var R=F.extend("sap.ui.rta.command.Rename",{metadata:{library:"sap.ui.rta",properties:{renamedElement:{type:"object"},newValue:{type:"string",defaultValue:"new text"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),selector:{id:this.getElement().getId()},renamedElement:{id:this.getRenamedElement().getId()},value:this.getNewValue()};return s;};
return R;},true);
sap.ui.predefine('sap/ui/rta/command/Reveal',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Reveal",{metadata:{library:"sap.ui.rta",properties:{revealedElementId:{type:"string"},directParent:"object"}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType()};if(this.getRevealedElementId()){s.revealedElementId=this.getRevealedElementId();}return s;};
return R;},true);
sap.ui.predefine('sap/ui/rta/command/Settings',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Settings",{metadata:{library:"sap.ui.rta",properties:{content:{type:"any"}},associations:{},events:{}}});
S.prototype._getChangeSpecificData=function(f){var s={changeType:this.getChangeType(),content:this.getContent()};return s;};
S.prototype.execute=function(){if(this.getElement()){return F.prototype.execute.apply(this,arguments);}else{return Promise.resolve();}};
S.prototype.undo=function(){if(this.getElement()){return F.prototype.undo.apply(this,arguments);}else{return Promise.resolve();}};
return S;},true);
sap.ui.predefine('sap/ui/rta/command/Split',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Split",{metadata:{library:"sap.ui.rta",properties:{newElementIds:{type:"string[]"},source:{type:"any"},parentElement:{type:"any"}},associations:{},events:{}}});
S.prototype._getChangeSpecificData=function(){var s={newElementIds:this.getNewElementIds(),sourceControlId:this.getSource().getId(),changeType:this.getChangeType(),parentId:this.getParentElement().getId()};return s;};
return S;},true);
sap.ui.predefine('sap/ui/rta/command/Stack',['sap/ui/base/ManagedObject','sap/ui/fl/ChangePersistenceFactory','sap/ui/fl/Utils','sap/ui/rta/command/Settings','sap/ui/rta/command/CompositeCommand','sap/ui/rta/ControlTreeModifier'],function(M,C,F,S,a,b){"use strict";
var c=M.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});
c.initializeWithChanges=function(o,f){var s=new c();s._aPersistedChanges=f;var m={};if(f&&f.length>0){var d=C.getChangePersistenceForControl(o);var e=F.getComponentForControl(o);var A=sap.ui.fl.Utils.getAppDescriptor(e)["sap.app"].id;var p={oComponent:e,appName:A};return d.getChangesForComponent(p).then(function(g){var h={};g.forEach(function(i){h[i.getDefinition().fileName]=i;});f.forEach(function(i){var j=h[i];var k=j.getSelector();var l=new S({selector:k,changeType:j.getDefinition().changeType,element:b.bySelector(k,e)});l._oPreparedChange=j;if(j.getUndoOperations()){l._aRecordedUndo=j.getUndoOperations();j.resetUndoOperations();}var n=j.getDefinition().support.compositeCommand;if(n){if(!m[n]){m[n]=new a();s.pushExecutedCommand(m[n]);}m[n].addCommand(l);}else{s.pushExecutedCommand(l);}});return s;});}else{return Promise.resolve(s);}};
c.prototype.addCommandExecutionHandler=function(h){this._aCommandExecutionHandler.push(h);};
c.prototype.removeCommandExecutionHandler=function(h){var i=this._aCommandExecutionHandler.indexOf(h);if(i>-1){this._aCommandExecutionHandler.splice(i,1);}};
c.prototype.init=function(){this._aCommandExecutionHandler=[];this._toBeExecuted=-1;this._oLastCommand=Promise.resolve();};
c.prototype._waitForCommandExecutionHandler=function(p){return Promise.all(this._aCommandExecutionHandler.map(function(h){return h(p);}));};
c.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted];};
c.prototype.pushExecutedCommand=function(o){this.push(o,true);};
c.prototype.push=function(o,e){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop();}}this.insertCommand(o,0);if(!e){this._toBeExecuted++;}this.fireModified();};
c.prototype.top=function(){return this.getCommands()[0];};
c.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--;}return this.removeCommand(0);};
c.prototype.removeCommand=function(o,s){var r=this.removeAggregation("commands",o,s);this.fireModified();return r;};
c.prototype.removeAllCommands=function(s){var d=this.removeAllAggregation("commands",s);this._toBeExecuted=-1;this.fireModified();return d;};
c.prototype.isEmpty=function(){return this.getCommands().length===0;};
c.prototype.execute=function(){this._oLastCommand=this._oLastCommand.catch(function(){}).then(function(){var o=this._getCommandToBeExecuted();if(o){return o.execute().then(function(){this._toBeExecuted--;var p={command:o,undo:false};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this)).catch(function(e){e=e||new Error("Executing of the change failed.");e.index=this._toBeExecuted;e.command=this.removeCommand(this._toBeExecuted);this._toBeExecuted--;return Promise.reject(e);}.bind(this));}}.bind(this));return this._oLastCommand;};
c.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var o=this._getCommandToBeExecuted();if(o){return o.undo().then(function(){var p={command:o,undo:true};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this));}else{return Promise.resolve();}}else{return Promise.resolve();}};
c.prototype.canUndo=function(){return(this._toBeExecuted+1)<this.getCommands().length;};
c.prototype.undo=function(){return this._unExecute();};
c.prototype.canRedo=function(){return!!this._getCommandToBeExecuted();};
c.prototype.redo=function(){return this.execute();};
c.prototype.pushAndExecute=function(o){this.push(o);return this.execute();};
c.prototype.getAllExecutedCommands=function(){var A=[];var d=this.getCommands();for(var i=d.length-1;i>this._toBeExecuted;i--){var s=this.getSubCommands(d[i]);A=A.concat(s);}return A;};
c.prototype.getSubCommands=function(o){var d=[];if(o.getCommands){o.getCommands().forEach(function(s){var e=this.getSubCommands(s);d=d.concat(e);},this);}else{d.push(o);}return d;};
return c;},true);
sap.ui.predefine('sap/ui/rta/command/appDescriptor/AddLibrary',['sap/ui/rta/command/AppDescriptorCommand'],function(A){"use strict";
var a=A.extend("sap.ui.rta.command.appDescriptor.AddLibrary",{metadata:{library:"sap.ui.rta",events:{}}});
a.prototype.init=function(){this.setChangeType("appdescr_ui5_addLibraries");};
a.prototype.execute=function(){var p=[];if(this.getParameters().libraries){var l=Object.keys(this.getParameters().libraries);l.forEach(function(L){p.push(sap.ui.getCore().loadLibrary(L,true));});}return Promise.all(p);};
return a;},true);
sap.ui.predefine('sap/ui/rta/library',['jquery.sap.global','sap/ui/core/Core','sap/ui/core/library'],function(q,C,c){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.rta",version:"1.56.5",dependencies:["sap.ui.core","sap.m","sap.ui.fl","sap.ui.dt"],types:[],interfaces:[],controls:[],elements:[]});return sap.ui.rta;});
sap.ui.predefine('sap/ui/rta/plugin/Combine',['sap/ui/rta/plugin/Plugin','sap/ui/dt/OverlayRegistry','sap/ui/rta/Utils'],function(P,O,U){"use strict";
var C=P.extend("sap.ui.rta.plugin.Combine",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype._isEditable=function(o){var c=this.getAction(o);if(c&&c.changeType&&c.changeOnRelevantContainer){return this.hasChangeHandler(c.changeType,o.getRelevantContainer())&&this.hasStableId(o);}else{return false;}};
C.prototype._checkForSameRelevantContainer=function(s){var r=[];for(var i=0,n=s.length;i<n;i++){r[i]=s[i].getRelevantContainer();var c=this.getAction(s[i]);if(!c||!c.changeType){return false;}if(i>0){if((r[0]!==r[i])||(this.getAction(s[0]).changeType!==c.changeType)){return false;}}}return true;};
C.prototype.isAvailable=function(o){var s=this.getSelectedOverlays();if(s.length<=1){return false;}return(this._isEditableByPlugin(o)&&this._checkForSameRelevantContainer(s));};
C.prototype.isEnabled=function(o){var s=this.getSelectedOverlays();if(!this.isAvailable(o)||s.length<=1){return false;}var S=s.map(function(b){return b.getElement();});var a=s.every(function(b){var A=this.getAction(b);if(!A){return false;}if(typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){return A.isEnabled(S);}else{return A.isEnabled;}}return true;},this);return a;};
C.prototype.handleCombine=function(c){var e=O.getOverlay(c);var d=e.getDesignTimeMetadata();var t=[];var s=this.getSelectedOverlays();for(var i=0;i<s.length;i++){var S=s[i].getElement();t.push(S);}var o=this.getAction(e);var v=this.getVariantManagementReference(e,o);var a=this.getCommandFactory().getCommandFor(c,"combine",{source:c,combineFields:t},d,v);this.fireElementModified({"command":a});};
C.prototype.getMenuItems=function(o){return this._getMenuItems(o,{pluginId:"CTX_GROUP_FIELDS",rank:90,icon:"sap-icon://border"});};
C.prototype.getActionName=function(){return"combine";};
C.prototype.handler=function(o,p){this.handleCombine(p.contextElement);};
return C;},true);
sap.ui.predefine('sap/ui/rta/plugin/ControlVariant',['sap/ui/rta/plugin/Plugin','sap/ui/rta/plugin/RenameHandler','sap/ui/rta/Utils','sap/ui/dt/ElementOverlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/OverlayUtil','sap/ui/fl/changeHandler/BaseTreeModifier','sap/ui/fl/Utils','sap/ui/fl/variants/VariantManagement','sap/ui/base/ManagedObject','sap/m/delegate/ValueStateMessage','sap/ui/rta/command/CompositeCommand'],function(P,R,U,E,O,a,B,f,V,M,b,C){"use strict";E.prototype._variantManagement=undefined;
E.prototype.getVariantManagement=function(){return this._variantManagement;};
E.prototype.setVariantManagement=function(k){this._variantManagement=k;};
E.prototype.hasVariantManagement=function(){return this._variantManagement?true:false;};
var c=P.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string",variantManagementControlOverlay:{type:"any"}},associations:{},events:{}}});
c.MODEL_NAME="$FlexVariants";
c.prototype.registerElementOverlay=function(o){var d=o.getElement(),m=this._getVariantModel(d),v;P.prototype.registerElementOverlay.apply(this,arguments);if(!m){return;}if(d instanceof V){var d=o.getElement(),A=d.getFor(),e;v=B.getSelector(d,f.getComponentForControl(d)).id;if(!A||(Array.isArray(A)&&A.length===0)){o.setVariantManagement(v);return;}if(!this._isPersonalizationMode()){m._setModelPropertiesForControl(v,true,d);m.checkUpdate(true);}e=!jQuery.isArray(A)?[A]:A;e.forEach(function(s){var g=s instanceof M?s:sap.ui.getCore().byId(s),h=O.getOverlay(g);this._propagateVariantManagement(h,v);}.bind(this));o.attachEvent("editableChange",R._manageClickEvent,this);}else if(!o.getVariantManagement()){v=this._getVariantManagementFromParent(o);if(v){o.setVariantManagement(v);o.attachEvent("editableChange",R._manageClickEvent,this);}}};
c.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer==="USER";};
c.prototype._propagateVariantManagement=function(p,v){var e=[];p.setVariantManagement(v);e=a.getAllChildOverlays(p);e.forEach(function(o){e=e.concat(this._propagateVariantManagement(o,v));}.bind(this));return e;};
c.prototype._getVariantManagementFromParent=function(o){var v=o.getVariantManagement();if(!v&&o.getParentElementOverlay()){return this._getVariantManagementFromParent(o.getParentElementOverlay());}return v;};
c.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);var m;var v;var d=o.getElement();if(d instanceof V){m=this._getVariantModel(d);v=o.getVariantManagement();m._setModelPropertiesForControl(v,false,d);m.checkUpdate(true);}this.removeFromPluginsList(o);P.prototype.deregisterElementOverlay.apply(this,arguments);};
c.prototype._getVariantModel=function(e){var A=f.getAppComponentForControl(e);return A?A.getModel(c.MODEL_NAME):undefined;};
c.prototype._isEditable=function(o){if(this._isPersonalizationMode()){return false;}return this._isVariantManagementControl(o);};
c.prototype._isVariantManagementControl=function(o){var e=o.getElement(),A=e.getAssociation("for");return!!(A&&e instanceof V);};
c.prototype.isVariantSwitchAvailable=function(o){return this._isVariantManagementControl(o);};
c.prototype.isVariantSwitchEnabled=function(o){var v=[];if(this._isVariantManagementControl(o)){var e=o.getElement(),s=o.getVariantManagement?o.getVariantManagement():undefined;if(!s){return false;}var m=this._getVariantModel(e);if(m){v=m.getData()[s].variants.reduce(function(r,g){if(g.visible){return r.concat(g);}else{return r;}},[]);}var d=v.length>1;return d;}else{return false;}};
c.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};
c.prototype.isRenameAvailable=function(o){return this._isVariantManagementControl(o);};
c.prototype.isRenameEnabled=function(o){return this._isVariantManagementControl(o);};
c.prototype.isVariantDuplicateAvailable=function(o){return this._isVariantManagementControl(o);};
c.prototype.isVariantDuplicateEnabled=function(o){var v=o.getVariantManagement?o.getVariantManagement():undefined;if(!v||!this._isVariantManagementControl(o)){return false;}return true;};
c.prototype.isVariantConfigureAvailable=function(o){return this._isVariantManagementControl(o);};
c.prototype.isVariantConfigureEnabled=function(o){return this._isVariantManagementControl(o);};
c.prototype.switchVariant=function(t,n,s){var d=t.getDesignTimeMetadata(),T=t.getElement();var S=this.getCommandFactory().getCommandFor(T,"switch",{targetVariantReference:n,sourceVariantReference:s},d);this.fireElementModified({"command":S});};
c.prototype.renameVariant=function(o){this.setVariantManagementControlOverlay(o[0]);this.startEdit(o[0]);};
c.prototype.startEdit=function(o){var v=o.getElement(),d=o.getDesignTimeMetadata().getDomRef();var e=v.getTitle();var p=e.getText();var h=R.startEdit.bind(this,{overlay:o,domRef:d,pluginMethodName:"plugin.ControlVariant.startEdit"});if(o._triggerDuplicate){var s=this._getVariantTitleForCopy(p,o.getVariantManagement(),this._getVariantModel(v).getData());v.getTitle().setText(s);o.attachEventOnce("geometryChanged",function(){h();},this);}else{h();}};
c.prototype.stopEdit=function(r){if(this._oEditedOverlay._triggerDuplicate){this._oEditedOverlay.getElementInstance().getTitle().getBinding("text").refresh(true);if(!this._oEditedOverlay.hasStyleClass("sapUiRtaErrorBg")){delete this._oEditedOverlay._triggerDuplicate;}}R._stopEdit.call(this,r,"plugin.ControlVariant.stopEdit");};
c.prototype.isBusy=function(){return this._bPreventMenu;};
c.prototype._createDuplicateCommand=function(p){var d=this.getCommandFactory().getCommandFor(p.element,"duplicate",{sourceVariantReference:p.currentVariantReference,newVariantTitle:p.newVariantTitle},p.designTimeMetadata,p.variantManagementReference);return d;};
c.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this),o=this._oEditedOverlay,d=o.getDesignTimeMetadata(),r=o.getElement(),m=this._getVariantModel(r),e,g,v=o.getVariantManagement(),T=this.getOldValue()!==t,n=T||o._triggerDuplicate,D=n?m._getVariantTitleCount(t,v):0,h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta"),s=m.getCurrentVariantReference(v);o.removeStyleClass("sapUiRtaErrorBg");if(this._oValueStateMessage){this._oValueStateMessage.getPopup().attachClosed(function(){r.$().css("z-index",1);});this._oValueStateMessage.close();}if(t==='\xa0'){e="BLANK_ERROR_TEXT";}else if(D>0){e="DUPLICATE_ERROR_TEXT";}else if(n){var S=this._createSetTitleCommand({text:t,element:r,designTimeMetadata:d,variantManagementReference:v});if(o._triggerDuplicate){g=new C({commands:[this._createDuplicateCommand({currentVariantReference:s,designTimeMetadata:d,variantManagementReference:v,element:r,newVariantTitle:this.getOldValue()})]});if(T){g.addCommand(S);}}else{g=S;}this.fireElementModified({"command":g});return g;}else{jQuery.sap.log.info("Control Variant title unchanged");}if(e){var i=h.getText(e);this._prepareOverlayForValueState(o,i);o.addStyleClass("sapUiRtaErrorBg");U._showMessageBox("ERROR","BLANK_DUPLICATE_TITLE_TEXT",e).then(function(){if(!this._oValueStateMessage){this._oValueStateMessage=new b(o);this._oValueStateMessage.getPopup()._deactivateFocusHandle();}this._oValueStateMessage.open();this.startEdit(o);}.bind(this));}};
c.prototype._getVariantTitleForCopy=function(s,v,d){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var e=r.getText("VARIANT_COPY_SINGLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)");var g=r.getText("VARIANT_COPY_MULTIPLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)").replace("\\{1\\}","([0-9]+)");var h=new RegExp(e+"+");var i=new RegExp(g);var t;var I=g.lastIndexOf("(.*)")>g.lastIndexOf("([0-9]+)")?1:2;var j=(I===1)?2:1;var T=0;if(i.test(s)){t=i.exec(s)[j];}else{t=h.test(s)?h.exec(s)[1]:s;}var k=[];d[v].variants.forEach(function(o){if(o.visible){k=i.test(o.title)?i.exec(o.title):h.exec(o.title);if(!k){return;}if(k.length===3&&t===k[j]){T=k[I]?(parseInt(k[I],10)+1):T;}else if(k.length===2&&t===k[1]){T=T===0?1:T;}}});return T>0?r.getText("VARIANT_COPY_MULTIPLE_TEXT",[t,T]):r.getText("VARIANT_COPY_SINGLE_TEXT",[t]);};
c.prototype._createSetTitleCommand=function(p){var s;this._$oEditableControlDomRef.text(p.text);try{s=this.getCommandFactory().getCommandFor(p.element,"setTitle",{newText:p.text},p.designTimeMetadata,p.variantManagementReference);}catch(e){jQuery.sap.log.error("Error during rename : ",e);}return s;};
c.prototype._prepareOverlayForValueState=function(o,v){o.getValueState=function(){return"Error";};o.getValueStateText=function(){return v;};o.getDomRefForValueStateMessage=function(){return this.$();};};
c.prototype.configureVariants=function(o){var v=o[0].getElement();var s=o[0].getVariantManagement();var m=this._getVariantModel(v);var d=o[0].getDesignTimeMetadata();m.manageVariants(v,s,this.getCommandFactory().getFlexSettings().layer).then(function(e){var g=this.getCommandFactory().getCommandFor(v,"configure",{control:v,changes:e},d,s);this.fireElementModified({"command":g});}.bind(this));};
c.prototype.getMenuItems=function(o){var m=[];if(this.isRenameAvailable(o)){m.push({id:"CTX_VARIANT_SET_TITLE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_RENAME'),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:210,icon:"sap-icon://edit"});}if(this.isVariantDuplicateAvailable(o)){m.push({id:"CTX_VARIANT_DUPLICATE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_DUPLICATE'),handler:function(e){e[0]._triggerDuplicate=true;this.renameVariant(e);}.bind(this),enabled:this.isVariantDuplicateEnabled.bind(this),rank:220,icon:"sap-icon://duplicate"});}if(this.isVariantConfigureAvailable(o)){m.push({id:"CTX_VARIANT_MANAGE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_MANAGE'),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:230,icon:"sap-icon://action-settings"});}if(this.isVariantSwitchAvailable(o)){var d=this._getVariantModel(o.getElement());var s=o.getVariantManagement();var S=d.getData()[s].variants.reduce(function(r,v){if(v.visible){var e=d.getData()[s].currentVariant===v.key;var i={id:v.key,text:v.title,icon:e?"sap-icon://accept":"blank",enabled:!e};return r.concat(i);}else{return r;}},[]);m.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_SWITCH'),handler:function(e,p){var g=p.eventItem.data(),t=e[0],n=g.key,h=d.getData()[s].currentVariant;return this.switchVariant(t,n,h);}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:S,rank:240,icon:"sap-icon://switch-views"});}return m;};
return c;},true);
sap.ui.predefine('sap/ui/rta/plugin/CreateContainer',['sap/ui/rta/plugin/Plugin','sap/ui/fl/Utils','sap/ui/rta/Utils','sap/ui/dt/OverlayRegistry'],function(P,F,R,O){"use strict";
var C=P.extend("sap.ui.rta.plugin.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype._isEditable=function(o){return{asSibling:this._isEditableCheck(o,true),asChild:this._isEditableCheck(o,false)};};
C.prototype._isEditableCheck=function(o,b){var e=false;var p=this._getParentOverlay(b,o);if(!p||!p.getParentElementOverlay()){return false;}e=this.checkAggregationsOnSelf(p,"createContainer");if(e){var a=F.getViewForControl(p.getElement());return this.hasStableId(o)&&F.checkControlId(a);}else{return false;}};
C.prototype._getParentOverlay=function(s,o){var p;if(s){p=o.getParentElementOverlay();}else{p=o;}return p;};
C.prototype.getCreateAction=function(s,o){var p=this._getParentOverlay(s,o);var d=p.getDesignTimeMetadata();var a=d.getActionDataFromAggregations("createContainer",o.getElement());return a[0];};
C.prototype.isAvailable=function(s,o){return this._isEditableByPlugin(o,s);};
C.prototype.isEnabled=function(s,o){var a=this.getCreateAction(s,o);if(!a){return false;}if(a.isEnabled&&typeof a.isEnabled==="function"){var i=a.isEnabled;var p=this._getParentOverlay(s,o);return i.call(null,p.getElement());}else{return true;}};
C.prototype.getCreatedContainerId=function(a,n){var i=n;if(a.getCreatedContainerId&&typeof a.getCreatedContainerId==="function"){var m=a.getCreatedContainerId;i=m.call(null,n);}return i;};
C.prototype._determineIndex=function(p,s,a,g){return R.getIndex(p,s,a,g);};
C.prototype._getText=function(a,e,d,t){if(!a){return t;}var c=d.getAggregationDescription(a.aggregation,e).singular;var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return T.getText(t,c);};
C.prototype.getCreateContainerText=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var d=p.getDesignTimeMetadata();var e=p.getElement();var t="CTX_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype._getContainerTitle=function(a,e,d){var t="TITLE_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype.handleCreate=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var b=p.getElement();var d=p.getDesignTimeMetadata();var v=F.getViewForControl(b);var S;if(s){S=o.getElement();}var n=v.createId(jQuery.sap.uid());var g=d.getAggregation(a.aggregation).getIndex;var i=this._determineIndex(b,S,a.aggregation,g);var V=this.getVariantManagementReference(p,a);var c=this.getCommandFactory().getCommandFor(b,"createContainer",{newControlId:n,label:this._getContainerTitle(a,b,d),index:i,parentId:b.getId()},d,V);this.fireElementModified({"command":c,"action":a,"newControlId":n});};
C.prototype.getMenuItems=function(o){var b=true;var p="CTX_CREATE_SIBLING_CONTAINER";var r=40;var m=[];for(var i=0;i<2;i++){if(this.isAvailable(b,o)){var M=this.getCreateContainerText.bind(this,b);m.push({id:p,text:M,handler:this.handler.bind(this,b),enabled:this.isEnabled.bind(this,b),icon:"sap-icon://add-folder",rank:r,group:"Add"});}b=false;p="CTX_CREATE_CHILD_CONTAINER";r=50;}return m;};
C.prototype.getActionName=function(){return"createContainer";};
C.prototype.handler=function(o,a){this.handleCreate(o,a[0]);};
return C;},true);
sap.ui.predefine('sap/ui/rta/plugin/CutPaste',['jquery.sap.global','sap/ui/dt/plugin/CutPaste','sap/ui/dt/OverlayUtil','sap/ui/rta/plugin/Plugin','sap/ui/rta/plugin/RTAElementMover','sap/ui/rta/Utils'],function(q,C,O,P,R,U){"use strict";
var a=C.extend("sap.ui.rta.plugin.CutPaste",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(a.prototype,P.prototype,function(d,s,p,D,S){return p!=="getMetadata";});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
a.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration)||this._isPasteEditable(o);};
a.prototype._isPasteEditable=function(o){var d=o.getDesignTimeMetadata();return this.hasStableId(o)&&this.getElementMover()._isMoveAvailableOnRelevantContainer(o)&&d.isActionAvailableOnAggregations("move");};
a.prototype.isAvailable=function(o){return o.getMovable();};
a.prototype.registerElementOverlay=function(o){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype.deregisterElementOverlay=function(o){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
a.prototype.paste=function(t){this._executePaste(t);this.fireElementModified({"command":this.getElementMover().buildMoveCommand()});this.stopCutAndPaste();};
a.prototype.cut=function(o){C.prototype.cut.apply(this,arguments);o.setSelected(false);};
a.prototype.getMenuItems=function(o){var m=[],c={id:'CTX_CUT',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_CUT'),handler:function(b){return this.cut(b[0]);}.bind(this),enabled:function(){return this.getSelectedOverlays().length===1;}.bind(this),rank:70,icon:"sap-icon://scissors"},p={id:'CTX_PASTE',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_PASTE'),handler:function(b){return this.paste(b[0]);}.bind(this),enabled:function(o){return this.isElementPasteable(o);}.bind(this),rank:80,icon:"sap-icon://paste"};if(this.isAvailable(o)){m.push(c,p);}else if(this._isPasteEditable(o)){m.push(p);}return m;};
return a;},true);
sap.ui.predefine('sap/ui/rta/plugin/DragDrop',['jquery.sap.global','sap/ui/dt/plugin/ControlDragDrop','sap/ui/rta/plugin/RTAElementMover','sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/dt/OverlayRegistry'],function(q,C,R,P,U,O){"use strict";
var D=C.extend("sap.ui.rta.plugin.DragDrop",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(D.prototype,P.prototype,function(d,s,p,m,S){return p!=="getMetadata";});
D.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
D.prototype.setCommandFactory=function(c){this.setProperty("commandFactory",c);this.getElementMover().setCommandFactory(c);};
D.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration);};
D.prototype.registerElementOverlay=function(o){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
D.prototype.deregisterElementOverlay=function(o){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
D.prototype.onDragStart=function(o){this.fireDragStarted();C.prototype.onDragStart.apply(this,arguments);this.getSelectedOverlays().forEach(function(o){o.setSelected(false);});o.$().addClass("sapUiRtaOverlayPlaceholder");};
D.prototype.onDragEnd=function(o){this.fireElementModified({"command":this.getElementMover().buildMoveCommand()});o.$().removeClass("sapUiRtaOverlayPlaceholder");o.setSelected(true);o.focus();C.prototype.onDragEnd.apply(this,arguments);};
D.prototype.onMovableChange=function(o){C.prototype.onMovableChange.apply(this,arguments);};
return D;},true);
sap.ui.predefine('sap/ui/rta/plugin/EasyAdd',['sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin','sap/ui/dt/OverlayRegistry'],function(A,O){"use strict";
var E=A.extend("sap.ui.rta.plugin.EasyAdd",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAdd");c.addStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").addClass("sapUiRtaPaddingTop");}var a=function(d,o,i){var C;if(d){C=o.getDesignTimeMetadata().getName().plural;}else{C=o.getDesignTimeMetadata().getAggregation("sections").childNames.plural();}this.showAvailableElements(d,[o],i,C);}.bind(this);var f=function(o,d,S,C,i){var e=function(h){var o=O.getOverlay(h.getSource().getId().replace("-AddButton",""));a(S,o,i);h.cancelBubble();};var g=typeof C==="function"?C():C;this._addButton(o,e,d,g,S);}.bind(this);if(o.hasStyleClass("sapUiRtaPersAdd")){var b=o.hasStyleClass("sapUiRtaPersAdd")&&o.$().children(".sapUiRtaPersAddIconOuter").length<=0;if(b){f(o,o.$(),true,o.getDesignTimeMetadata().getName().singular);}}else if(o.hasStyleClass("sapUiRtaPersAddTop")){if(o.getAggregationOverlay("sections").$().children(".sapUiRtaPersAddIconOuter").length<=0){var s=o.getAggregationOverlay("sections").$();f(o,s,false,o.getDesignTimeMetadata().getAggregation("sections").childNames.singular,0);}}A.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(o._oAddButton){o._oAddButton.destroy();}if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersAdd");c.removeStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"){o.removeStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").removeClass("sapUiRtaPaddingTop");}};
E.prototype._isEditable=function(o){var i=A.prototype._isEditable.apply(this,arguments);if(o._oAddButton){var I=o.hasStyleClass("sapUiRtaPersAddTop");var s=I?"asChild":"asSibling";o._oAddButton.setEnabled(i[s]);if(I){var l=o.getElement();l.attachEventOnce("onAfterRenderingDOMReady",function(){l.$("sectionsContainer").addClass("sapUiRtaPaddingTop");});}}return i;};
E.prototype._addButton=function(o,c,a,C,b){var i=o.getEditableByPlugins().indexOf(this._retrievePluginName(b))>-1;var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var I=o.getId()+"-AddButton";var h=jQuery("<div class='sapUiRtaPersAddIconOuter' draggable='true'> </div>");o._oAddButton=new sap.m.Button(I,{text:t.getText("CTX_ADD_ELEMENTS",C),icon:"sap-icon://add",press:c,enabled:i}).placeAt(h.get(0));a.append(h);h[0].addEventListener("mouseover",function(e){e.stopPropagation();var o=e.fromElement?O.getOverlay(e.fromElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();p.removeStyleClass("sapUiRtaOverlayHover");}});h[0].addEventListener("mouseleave",function(e){e.stopPropagation();var o=e.toElement?O.getOverlay(e.toElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();if(p.getMovable()){p.addStyleClass("sapUiRtaOverlayHover");}}});h[0].addEventListener("dragstart",function(e){e.stopPropagation();e.preventDefault();});};
return E;},true);
sap.ui.predefine('sap/ui/rta/plugin/EasyRemove',['sap/ui/rta/plugin/Remove','sap/ui/dt/OverlayRegistry','sap/m/Button'],function(R,O,B){"use strict";
var E=R.extend("sap.ui.rta.plugin.EasyRemove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersDelete");}if(o.hasStyleClass("sapUiRtaPersDelete")&&o.$().children(".sapUiRtaPersDeleteClick").length<=0){var a=function(o){this.handler([o]);}.bind(this);var d=this._addButton(o);d.attachBrowserEvent("contextmenu",function(e){e.stopPropagation();e.preventDefault();});d.attachPress(function(e){var o=sap.ui.getCore().byId(e.getSource().getId().replace("-DeleteIcon",""));a(o);e.cancelBubble();});}R.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype._isEditable=function(o){if(o._oDeleteButton){o._oDeleteButton.setEnabled(this.isEnabled(o));}return R.prototype._isEditable.apply(this,arguments);};
E.prototype._addButton=function(o){var e=this.isEnabled(o);var i=o.getId()+"-DeleteIcon";var h=jQuery("<div class='sapUiRtaPersDeleteClick' draggable='true'> </div>");var H=jQuery("<div class='sapUiRtaPersDeleteIconOuter'> </div>");o._oDeleteButton=new B(i,{icon:"sap-icon://decline",tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_REMOVE"),enabled:e,noTabStop:true}).placeAt(H.get(0));h.append(H);o.$().append(h);h[0].addEventListener("dragstart",function(a){a.stopPropagation();a.preventDefault();});return o._oDeleteButton;};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersDelete");if(o._oDeleteButton){o._oDeleteButton.destroy();}}};
return E;},true);
sap.ui.predefine('sap/ui/rta/plugin/Plugin',['sap/ui/dt/Plugin','sap/ui/fl/Utils','sap/ui/fl/registry/ChangeRegistry','sap/ui/dt/OverlayRegistry','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementOverlay','sap/ui/fl/changeHandler/JsControlTreeModifier','sap/ui/base/ManagedObject'],function(P,F,C,O,a,E,J,M){"use strict";E.prototype._bElementHasStableId=undefined;
E.prototype.getElementHasStableId=function(){return this._bElementHasStableId;};
E.prototype.setElementHasStableId=function(h){this._bElementHasStableId=h;};
E.prototype.hasElementStableId=function(){return this._bElementHasStableId?true:false;};
var B=P.extend("sap.ui.rta.plugin.Plugin",{metadata:{"abstract":true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
B.prototype._isEditable=function(){};
var _=function(e){var p=e.getParameters();var r;var o=sap.ui.getCore().byId(p.id);if((p.type==="propertyChanged"&&p.name==="visible")){r=this._getRelevantOverlays(o);this.evaluateEditable(r,{onRegistration:false});}else if(p.type==="overlayRendered"){this.evaluateEditable([o],{onRegistration:true});}else if(p.type==="insertAggregation"||p.type==="removeAggregation"){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}};
B.prototype._detachReevaluationEditable=function(o){o.detachElementModified(_,this);};
B.prototype._attachReevaluationEditable=function(o){var g=function(e){if(e.getSource().getGeometry()&&e.getSource().getGeometry().visible){this.evaluateEditable([o],{onRegistration:true});o.detachEvent('geometryChanged',g,this);}};o.attachElementModified(_,this);if(!o.getGeometry()||!o.getGeometry().visible){o.attachEvent('geometryChanged',g,this);}};
B.prototype._getRelevantOverlays=function(o,A){var c=o.getRelevantOverlays();if(c.length===0){var r=a.findAllOverlaysInContainer(o);if(A){var d=o.getAggregationOverlay(A).getChildren();d=d.filter(function(e){return r.indexOf(e)===-1;});r=r.concat(d);}o.setRelevantOverlays(r);return r;}return c;};
function b(e){return e.some(function(s){return s&&a.isInAggregationBinding(O.getOverlay(s),s.sParentAggregationName);});}
B.prototype.evaluateEditable=function(o,p){var c=this.getDesignTime()?this.getDesignTime().getPlugins():[];var s=c.some(function(d){return d.isBusy&&d.isBusy();});if(s){return;}var e;o.forEach(function(d){var i=false;var S=d.getDesignTimeMetadata().getStableElements(d);if(S[0]instanceof M){i=b(S);}if(i){e=false;}else{e=d.getElement()&&d.getDesignTimeMetadata()&&this._isEditable(d,p);}if(e!==undefined&&e!==null){if(typeof e==="boolean"){this._modifyPluginList(d,e);}else{this._modifyPluginList(d,e.asChild,false);this._modifyPluginList(d,e.asSibling,true);}}}.bind(this));};
B.prototype._modifyPluginList=function(o,i,c){if(i){this.addToPluginsList(o,c);}else{this.removeFromPluginsList(o,c);}};
B.prototype._retrievePluginName=function(s){var n=this.getMetadata().getName();if(s!==undefined){n+=s?".asSibling":".asChild";}return n;};
B.prototype._isEditableByPlugin=function(o,s){var p=this._retrievePluginName(s);var c=o.getEditableByPlugins();return c.indexOf(p)>-1;};
B.prototype.registerElementOverlay=function(o){this.evaluateEditable([o],{onRegistration:true});this._attachReevaluationEditable(o);};
B.prototype.deregisterElementOverlay=function(o){this.removeFromPluginsList(o);this.removeFromPluginsList(o,true);this.removeFromPluginsList(o,false);this._detachReevaluationEditable(o);};
B.prototype.hasStableId=function(o){if(!o){return false;}if(!o.getDesignTimeMetadata()){return false;}if(o.getElementHasStableId()===undefined){var s=o.getDesignTimeMetadata().getStableElements(o);var u=s.length>0?s.some(function(S){var c=S.id||S;if(!F.checkControlId(c,S.appComponent)){return true;}}):true;o.setElementHasStableId(!u);}return o.hasElementStableId();};
B.prototype.getVariantManagementReference=function(o,A,f,s){var e;if(!s){e=o.getElement();}else{e=s;}var r;if((A.changeOnRelevantContainer||f)&&!s){r=o.getRelevantContainer();}else{r=e;}var v;if(o.getVariantManagement&&this._hasVariantChangeHandler(A.changeType,r)){v=o.getVariantManagement();}return v;};
B.prototype._hasVariantChangeHandler=function(c,e){var o=this._getChangeHandler(c,e);return(o&&o.revertChange);};
B.prototype.checkAggregationsOnSelf=function(o,A){var d=o.getDesignTimeMetadata();var e=o.getElement();var i=false;var c=d.getActionDataFromAggregations(A,o.getElement())[0];var s=c?c.changeType:null;var f=c&&c.changeOnRelevantContainer;if(f){e=o.getRelevantContainer();}if(s&&this.hasChangeHandler(s,e)){i=true;}return i;};
B.prototype.removeFromPluginsList=function(o,s){var n=this._retrievePluginName(s);o.removeEditableByPlugin(n);if(!o.getEditableByPlugins().length){o.setEditable(false);}};
B.prototype.addToPluginsList=function(o,s){var n=this._retrievePluginName(s);var p=o.getEditableByPlugins();if(p.indexOf(n)===-1){o.addEditableByPlugin(n);o.setEditable(true);}};
B.prototype.hasChangeHandler=function(c,e){return!!this._getChangeHandler(c,e);};
B.prototype._getChangeHandler=function(c,e,s){if(!s){s=e.getMetadata().getName();}var l=this.getCommandFactory().getFlexSettings().layer;return C.getInstance().getChangeHandler(c,s,e,J,l);};
return B;},true);
sap.ui.predefine('sap/ui/rta/plugin/RTAElementMover',['sap/ui/dt/plugin/ElementMover','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementUtil','sap/ui/fl/Utils','sap/ui/rta/Utils','sap/ui/rta/command/CommandFactory','sap/ui/rta/plugin/Plugin','sap/ui/dt/OverlayRegistry','sap/ui/rta/util/BindingsExtractor','sap/ui/dt/MetadataPropagationUtil'],function(E,O,a,F,U,C,P,b,B,M){"use strict";
var R=E.extend("sap.ui.rta.plugin.RTAElementMover",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"any",defaultValue:C},movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{}}});
R.prototype.init=function(){this.oBasePlugin=new P({commandFactory:this.getCommandFactory()});};
R.prototype.exit=function(){this.oBasePlugin.destroy();};
R.prototype.setCommandFactory=function(c){this.setProperty("commandFactory",c);this.oBasePlugin.setCommandFactory(c);};
R.prototype.isEditable=function(o,c){var e=o.getElement();var m=false;if(this.isMovableType(e)&&this.checkMovable(o,c)&&!O.isInAggregationBinding(o,e.sParentAggregationName)){m=true;}o.setMovable(m);return m;};
function i(o,c){var v=false,d=o.getDesignTimeMetadata(),p=o.getParentElementOverlay();if(!d||!p){return false;}var r=o.getRelevantContainer();var e=b.getOverlay(r);if(!e){return false;}v=this._isMoveAvailableOnRelevantContainer(o);if(v){v=this.oBasePlugin.hasStableId(o)&&this.oBasePlugin.hasStableId(p)&&this.oBasePlugin.hasStableId(e);}if(v){var f=O.findAllUniqueAggregationOverlaysInContainer(o,e);var V=f.filter(function(A){return this.checkTargetZone(A,o,c);}.bind(this));if(V.length<1){v=false;}else if(V.length===1){var g=V[0].getChildren().filter(function(j){var k=j.getElement();return(k&&k.getVisible()&&k.getParent());});v=g.length>1;}}return v;}
function h(A,e,r){var o=A.getDesignTimeMetadata();var m=o.getAction("move",e);if(!m){return false;}return this.oBasePlugin.hasChangeHandler(m.changeType,r);}
E.prototype._getMoveAction=function(o){var p,c=o.getParentAggregationOverlay();if(c){p=c.getDesignTimeMetadata();}return p?p.getAction("move",o.getElement()):undefined;};
E.prototype.isMovableType=function(e){return true;};
R.prototype.checkMovable=function(o,c){return i.call(this,o,c);};
R.prototype.checkTargetZone=function(A,o,c){var m=o?o:this.getMovedOverlay();var t=E.prototype.checkTargetZone.call(this,A,m,c);if(!t){return false;}var d=m.getElement();var T=A.getParent();var e=m.getRelevantContainer();var f=T.getElement();var g=A.getDesignTimeMetadata();var v=M.getRelevantContainerForPropagation(g.getData(),d);v=v?v:f;if(!e||!v||!P.prototype.hasStableId(T)||e!==v){return false;}if(m.getParent().getElement()!==f){var j=B.getBindings(d,d.getModel());if(Object.keys(j).length>0&&d.getBindingContext()&&f.getBindingContext()){var s=U.getEntityTypeByPath(d.getModel(),d.getBindingContext().getPath());var k=U.getEntityTypeByPath(f.getModel(),f.getBindingContext().getPath());if(!(s===k)){return false;}}}return h.call(this,A,d,v);};
R.prototype._isMoveAvailableOnRelevantContainer=function(o){var c,m=this._getMoveAction(o);if(m&&m.changeType){c=o.getRelevantContainer();return this.oBasePlugin.hasChangeHandler(m.changeType,c);}return false;};
R.prototype.buildMoveCommand=function(){var m=this.getMovedOverlay();var p=m.getParentAggregationOverlay();var o=m.getElement();var s=this._getSource();var r=m.getRelevantContainer();var t=O.getParentInformation(m);var S=s.index;var T=t.index;var c=this._compareSourceAndTarget(s,t);if(c){return undefined;}delete s.index;delete t.index;var d=this._getMoveAction(m);var v=this.oBasePlugin.getVariantManagementReference(m,d,true);var e=this.getCommandFactory().getCommandFor(r,"Move",{movedElements:[{element:o,sourceIndex:S,targetIndex:T}],source:s,target:t},p.getDesignTimeMetadata(),v);return e;};
return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Remove',['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/rta/command/CompositeCommand','sap/ui/dt/OverlayRegistry'],function(P,U,C,O){"use strict";
var R=P.extend("sap.ui.rta.plugin.Remove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
R.prototype.registerElementOverlay=function(o){if(this.isEnabled(o)){o.attachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.registerElementOverlay.apply(this,arguments);};
R.prototype._isEditable=function(o){var e=false;var E=o.getElement();var r=this.getAction(o);if(r&&r.changeType){if(r.changeOnRelevantContainer){E=o.getRelevantContainer();}e=this.hasChangeHandler(r.changeType,E);}if(e){return this.hasStableId(o);}return e;};
R.prototype.isEnabled=function(o){var a=this.getAction(o);var i=false;if(!a){return i;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){i=a.isEnabled(o.getElement());}else{i=a.isEnabled;}}else{i=true;}return i&&this._canBeRemovedFromAggregation(o);};
R.prototype._canBeRemovedFromAggregation=function(o){var e=o.getElement();var p=e.getParent();if(!p){return false;}var E=p.getAggregation(e.sParentAggregationName);if(!Array.isArray(E)){return true;}if(E.length===1){return false;}var n=this.getNumberOfSelectedOverlays()||1;var i=E.filter(function(e){var a=O.getOverlay(e);return!(a&&a.getElementVisibility());});return!(i.length===(E.length-n));};
R.prototype._getConfirmationText=function(o){var a=this.getAction(o);if(a&&a.getConfirmationText){return a.getConfirmationText(o.getElement());}};
R.prototype.deregisterElementOverlay=function(o){if(this.isEnabled(o)){o.detachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.deregisterElementOverlay.apply(this,arguments);};
R.prototype._onKeyDown=function(e){if(e.keyCode===jQuery.sap.KeyCodes.DELETE){e.stopPropagation();this.removeElement();}};
R.prototype.removeElement=function(o){var s;if(o){s=o;}else{s=this.getSelectedOverlays();}s=s.filter(this.isEnabled,this);if(s.length>0){this.handler(s);}};
R.prototype._getRemoveCommand=function(r,d,v){return this.getCommandFactory().getCommandFor(r,"Remove",{removedElement:r},d,v);};
R.prototype._fireElementModified=function(c){if(c.getCommands().length){this.fireElementModified({"command":c});}};
R.prototype.handler=function(s){var p=[];var c=new C();var S=function(o){o.setSelected(true);setTimeout(function(){o.focus();},0);};var n=R._getElementToFocus(s);s.forEach(function(o){var a;var r=o.getElement();var d=o.getDesignTimeMetadata();var b=this.getAction(o);var v=this.getVariantManagementReference(o,b);var e=this._getConfirmationText(o);if(e){p.push(U.openRemoveConfirmationDialog(r,e).then(function(f){if(f){a=this._getRemoveCommand(r,d,v);c.addCommand(a);}}.bind(this)));}else{a=this._getRemoveCommand(r,d,v);c.addCommand(a);}o.setSelected(false);},this);if(p.length){Promise.all(p).then(function(){this._fireElementModified(c);S(n);}.bind(this));}else{this._fireElementModified(c);S(n);}};
R._getElementToFocus=function(s){var n;if(s.length===1){var o=s[0];var S=o.getParent().getAggregation(o.sParentAggregationName);if(S.length>1){var i=S.indexOf(o);var c=S.slice(i+1);if(i!==0){c=c.concat(S.slice(0,i).reverse());}n=c.filter(function(a){return a.getElement().getVisible();}).shift();}}if(!n){n=O.getOverlay(s[0].getRelevantContainer());}return n;};
R.prototype.getMenuItems=function(o){return this._getMenuItems(o,{pluginId:"CTX_REMOVE",rank:60,icon:"sap-icon://hide"});};
R.prototype.getActionName=function(){return"remove";};
return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Rename',['jquery.sap.global','sap/ui/rta/plugin/Plugin','sap/ui/rta/plugin/RenameHandler','sap/ui/dt/Overlay','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/OverlayRegistry','sap/ui/rta/Utils'],function(q,P,R,O,E,a,b,U){"use strict";
var c=P.extend("sap.ui.rta.plugin.Rename",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{"editable":{},"nonEditable":{}}}});
c.prototype.exit=function(){P.prototype.exit.apply(this,arguments);this._bPreventMenu=false;R._exit.call(this);};
c.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};
c.prototype.startEdit=function(o){var e=o.getElement(),d=o.getDesignTimeMetadata(),D=d.getAction("rename",e).domRef;R.startEdit.call(this,{overlay:o,domRef:D,pluginMethodName:"plugin.Rename.startEdit"});};
c.prototype.stopEdit=function(r){R._stopEdit.call(this,r,"plugin.Rename.stopEdit");};
c.prototype.handler=function(o){this.startEdit(o[0]);};
c.prototype.isRenameAvailable=function(o){return this._isEditableByPlugin(o);};
c.prototype.isRenameEnabled=function(o){return this.isEnabled(o);};
c.prototype.isEnabled=function(o){var i=true;var A=this.getAction(o);if(!A){i=false;}if(i&&typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){i=A.isEnabled(o.getElement());}else{i=A.isEnabled;}}if(i){var d=o.getDesignTimeMetadata();if(!d.getAssociatedDomRef(o.getElement(),A.domRef)){i=false;}}return i&&this.isMultiSelectionInactive.call(this,o);};
c.prototype.registerElementOverlay=function(o){o.attachEvent("editableChange",R._manageClickEvent,this);P.prototype.registerElementOverlay.apply(this,arguments);};
c.prototype._isEditable=function(o){var e=false;var d=o.getElement();var r=this.getAction(o);if(r&&r.changeType){if(r.changeOnRelevantContainer){d=o.getRelevantContainer();}e=this.hasChangeHandler(r.changeType,d);}if(e){return this.hasStableId(o);}return e;};
c.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);this.removeFromPluginsList(o);};
c.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this);if(this.getOldValue()!==t){this._$oEditableControlDomRef.text(t);try{var r;var o=this._oEditedOverlay.getElement();var d=this._oEditedOverlay.getDesignTimeMetadata();var e=this.getAction(this._oEditedOverlay);var v=this.getVariantManagementReference(this._oEditedOverlay,e);r=this.getCommandFactory().getCommandFor(o,"rename",{renamedElement:o,newValue:t},d,v);this.fireElementModified({"command":r});}catch(f){q.sap.log.error("Error during rename : ",f);}}};
c.prototype.getMenuItems=function(o){return this._getMenuItems(o,{pluginId:"CTX_RENAME",rank:10,icon:"sap-icon://edit"});};
c.prototype.getActionName=function(){return"rename";};
c.prototype.isBusy=function(){return this._bPreventMenu;};
return c;},true);
sap.ui.predefine('sap/ui/rta/plugin/RenameHandler',['jquery.sap.global','sap/ui/rta/plugin/Plugin','sap/ui/dt/Overlay','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/OverlayRegistry','sap/ui/rta/Utils','sap/ui/dt/DOMUtil'],function(q,P,O,E,a,b,U,D){"use strict";var R={_manageClickEvent:function(e){var o=e.getSource?e.getSource():e;if(o.isSelected()&&this.isRenameAvailable(o)&&this.isRenameEnabled(o)){o.attachBrowserEvent("click",R._onClick,this);}else{o.detachBrowserEvent("click",R._onClick,this);}},startEdit:function(p){this._bPreventMenu=true;this._oEditedOverlay=p.overlay;var e=p.overlay.getElement();var d=this._oEditedOverlay.getDesignTimeMetadata();var v=d.getAssociatedDomRef(e,p.domRef);if(!U.isElementInViewport(v)){v.get(0).scrollIntoView();}var _=q(E.getDomRef(e));this._$oEditableControlDomRef=q(v);var c=this._$oEditableControlDomRef.parent();var w=0;var C=parseInt(_.outerWidth(),10);if(!isNaN(C)){var i=parseInt(this._$oEditableControlDomRef.outerWidth(),10);var f=parseInt(c.outerWidth(),10);w=C-i;if(w<0&&f){if(c.get(0).id!==_.get(0).id&&c.children(":visible").length===1&&c.children(":visible").get(0).id===this._$oEditableControlDomRef.get(0).id&&C>f){w=C-f;}else{w=0;}}}var o=sap.ui.dt.OverlayRegistry.getOverlay(v instanceof q?v.get(0).id:v.id)||p.overlay;var g=q("<div class='sapUiRtaEditableField'></div>").css({"white-space":"nowrap","overflow":"hidden","width":"calc(100% - ("+w+"px))"}).appendTo(o.$());this._$editableField=q("<div contentEditable='true'></div>").appendTo(g);if(this._$oEditableControlDomRef.text()===""){this._$oEditableControlDomRef.text("_?_");this._$editableField.text("");}else{this._$editableField.text(this._$oEditableControlDomRef.text());}this.setOldValue(R._getCurrentEditableFieldText.call(this));D.copyComputedStyle(this._$oEditableControlDomRef,this._$editableField);this._$editableField.children().remove();this._$editableField.css('visibility','hidden');this._$editableField.css({"-moz-user-modify":"read-write","-webkit-user-modify":"read-write","-ms-user-modify":"read-write","user-modify":"read-write","text-overflow":"clip","white-space":"nowrap","line-height":"normal"});O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$editableField.one("focus",R._onEditableFieldFocus.bind(this));this._$editableField.on("blur",R._onEditableFieldBlur.bind(this));this._$editableField.on("keydown",R._onEditableFieldKeydown.bind(this));this._$editableField.on("dragstart",R._stopPropagation.bind(this));this._$editableField.on("drag",R._stopPropagation.bind(this));this._$editableField.on("dragend",R._stopPropagation.bind(this));this._$editableField.on("click",R._stopPropagation.bind(this));this._$editableField.on("mousedown",R._stopPropagation.bind(this));setTimeout(function(){this._$oEditableControlDomRef.css("visibility","hidden");g.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({top:this._$oEditableControlDomRef.offset().top});this._$editableField.css('visibility','');this._$editableField.focus();p.overlay.setSelected(true);sap.ui.getCore().getEventBus().publish('sap.ui.rta',p.pluginMethodName,{overlay:p.overlay,editableField:this._$editableField});}.bind(this),0);},_setDesignTime:function(d){this._aSelection=[];var o=this.getDesignTime();if(o){o.detachSelectionChange(R._onDesignTimeSelectionChange,this);}P.prototype.setDesignTime.apply(this,arguments);if(d){d.attachSelectionChange(R._onDesignTimeSelectionChange,this);this._aSelection=this.getSelectedOverlays();}},_onDesignTimeSelectionChange:function(e){var s=e.getParameter("selection");this._aSelection.forEach(R._manageClickEvent,this);s.forEach(R._manageClickEvent,this);this._aSelection=s;},_stopPropagation:function(e){e.stopPropagation();},_onEditableFieldFocus:function(e){var c=e.target;var r=document.createRange();r.selectNodeContents(c);var s=window.getSelection();s.removeAllRanges();s.addRange(r);},_stopEdit:function(r,p){this._bPreventMenu=false;if(this._$oEditableControlDomRef.text()==="_?_"){this._$oEditableControlDomRef.text("");}this._oEditedOverlay.$().find(".sapUiRtaEditableField").remove();O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$oEditableControlDomRef.css("visibility","visible");if(r){var o=this._oEditedOverlay;o.setSelected(true);o.focus();}delete this._$editableField;delete this._$oEditableControlDomRef;delete this._oEditedOverlay;sap.ui.getCore().getEventBus().publish('sap.ui.rta',p,{overlay:o});},_onEditableFieldBlur:function(e){this._emitLabelChangeEvent();this.stopEdit(false);},_onEditableFieldKeydown:function(e){switch(e.keyCode){case q.sap.KeyCodes.ENTER:this._emitLabelChangeEvent();this.stopEdit(true);e.preventDefault();break;case q.sap.KeyCodes.ESCAPE:this.stopEdit(true);e.preventDefault();break;case q.sap.KeyCodes.DELETE:e.stopPropagation();break;default:}},_getCurrentEditableFieldText:function(){var t=this._$editableField.text().trim();return t===""?'\xa0':t;},_onClick:function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);if(this.isRenameEnabled(o)&&!e.metaKey&&!e.ctrlKey){this.startEdit(o);e.preventDefault();}},_exit:function(){if(this._$oEditableControlDomRef){this.stopEdit(false);}}};return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Selection',['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/fl/Utils','sap/ui/dt/OverlayRegistry'],function(P,U,F,O){"use strict";
var S=P.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});
S.prototype._checkDeveloperMode=function(o){if(o.getDesignTimeMetadata()){var d=this.getCommandFactory().getFlexSettings().developerMode;if(d&&this.hasStableId(o)){o.setEditable(true);o.setSelectable(true);this.fireElementEditableChange({editable:true});return true;}}return false;};
S.prototype.registerElementOverlay=function(o){if(!this._checkDeveloperMode(o)){o.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(o);}o.attachBrowserEvent("click",this._selectOverlay,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("mousedown",this._onMouseDown,this);o.attachBrowserEvent("mouseover",this._onMouseover,this);o.attachBrowserEvent("mouseleave",this._onMouseleave,this);};
S.prototype._onEditableChange=function(e){var o=e.getSource();this._adaptSelectable(o);};
S.prototype._adaptSelectable=function(o){var s=o.getEditable();if(o.getSelectable()!==s){o.setSelectable(s);if(!s){this._removePreviousHover();}this.fireElementEditableChange({editable:s});}};
S.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._selectOverlay,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("mousedown",this._onMouseDown,this);o.detachBrowserEvent("mouseover",this._onMouseover,this);o.detachBrowserEvent("mouseleave",this._onMouseleave,this);o.detachEditableChange(this._onEditableChange,this);};
S.prototype._setFocusOnOverlay=function(o,e){if(o&&o.getSelectable()){o.focus();e.stopPropagation();}};
S.prototype._onKeyDown=function(e){var o=U.getFocusedOverlay();if(e.keyCode===jQuery.sap.KeyCodes.ENTER){this._selectOverlay(e);}else if(e.keyCode===jQuery.sap.KeyCodes.ARROW_UP&&e.shiftKey===false&&e.altKey===false){if(o){var p=U.getFocusableParentOverlay(o);this._setFocusOnOverlay(p,e);e.preventDefault();}}else if(e.keyCode===jQuery.sap.KeyCodes.ARROW_DOWN&&e.shiftKey===false&&e.altKey===false){if(o){var f=U.getFirstFocusableDescendantOverlay(o);this._setFocusOnOverlay(f,e);e.preventDefault();}}else if(e.keyCode===jQuery.sap.KeyCodes.ARROW_LEFT&&e.shiftKey===false&&e.altKey===false){if(o){var d=U.getPreviousFocusableSiblingOverlay(o);this._setFocusOnOverlay(d,e);e.preventDefault();}}else if(e.keyCode===jQuery.sap.KeyCodes.ARROW_RIGHT&&e.shiftKey===false&&e.altKey===false){if(o){var n=U.getNextFocusableSiblingOverlay(o);this._setFocusOnOverlay(n,e);e.preventDefault();}}};
S.prototype._selectOverlay=function(e){var o=O.getOverlay(e.currentTarget.id);var m=e.metaKey||e.ctrlKey;var t=e.target.className;if(o.getSelectable()&&t.indexOf("sapUiDtOverlay")>-1){if(m){this.getDesignTime().setSelectionMode(sap.ui.dt.SelectionMode.Multi);}o.setSelected(!o.getSelected());if(m){this.getDesignTime().setSelectionMode(sap.ui.dt.SelectionMode.Single);}e.preventDefault();e.stopPropagation();}};
S.prototype._onMouseDown=function(e){if(sap.ui.Device.browser.name=="ie"){var t=O.getOverlay(e.target.id);var T=e.target.className==="sapUiDtOverlayScrollContainer";var o=O.getOverlay(e.currentTarget.id);if((T||t instanceof sap.ui.dt.Overlay)&&o instanceof sap.ui.dt.Overlay){if(o.getSelectable()){o.focus();e.stopPropagation();}else{o.getDomRef().blur();}}}};
S.prototype._onMouseover=function(e){var o=O.getOverlay(e.currentTarget.id);if(o.isSelectable()){if(o!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=o;o.addStyleClass("sapUiRtaOverlayHover");}e.preventDefault();e.stopPropagation();}};
S.prototype._onMouseleave=function(e){var o=O.getOverlay(e.currentTarget.id);if(o.isSelectable()){this._removePreviousHover();e.preventDefault();e.stopPropagation();}};
S.prototype._removePreviousHover=function(){if(this._oHoverTarget){this._oHoverTarget.removeStyleClass("sapUiRtaOverlayHover");}delete this._oHoverTarget;};
S.prototype.setDesignTime=function(d){if(this.getDesignTime()){this.getDesignTime().detachSelectionChange(this._onDesignTimeSelectionChange,this);}P.prototype.setDesignTime.apply(this,arguments);if(this.getDesignTime()){this.getDesignTime().attachSelectionChange(this._onDesignTimeSelectionChange,this);}};
S.prototype._onDesignTimeSelectionChange=function(e){if(this.getDesignTime().getSelectionMode()===sap.ui.dt.SelectionMode.Single){return;}var C=e.getParameter("selection")[e.getParameter("selection").length-1];var s=this.getSelectedOverlays();if(s&&s.length===1){C.setSelected(true);return;}if(!C||this.getDesignTime().getSelectionMode()===sap.ui.dt.SelectionMode.Single){return;}var m=_(s,this.getMultiSelectionRequiredPlugins())&&a(s)&&(b(s,C)||c(s,C));C.setSelected(m);};
function _(s,m){var d=m;s.forEach(function(o){var e=o.getEditableByPlugins();d=d.reduce(function(f,p){if(e.indexOf(p)!==-1){f.push(p);}return f;},[]);});return d.length>0;}
function a(s){var C=s[s.length-1];var p=s[s.length-2];var o=C.getRelevantContainer();var d=p.getRelevantContainer();return o===d;}
function b(s,o){return!s.some(function(d){return d.getParentElementOverlay()!==o.getParentElementOverlay();});}
function c(s,o){var d=o.getElement().getMetadata().getName();return!s.some(function(e){var C=e.getElement().getMetadata().getName();return(C!==d);});}
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/Settings',['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/base/Log'],function(P,U,B){"use strict";
var S=P.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",properties:{commandStack:{type:"any"}},associations:{},events:{}}});
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s){if(s.handler){return this.hasStableId(o);}else{var h=Object.keys(s).some(function(a){return s[a].handler;});if(h){return this.hasStableId(o);}}}return false;};
S.prototype.isEnabled=function(o){var a=this.getAction(o);if(!a){return false;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){return a.isEnabled(o.getElement());}else{return a.isEnabled;}}return true;};
S.prototype._getUnsavedChanges=function(i,c){var e;var u=this.getCommandStack().getAllExecutedCommands().filter(function(C){e=C.getElementId&&C.getElementId()||C.getElement&&C.getElement().getId();if(e===i&&c.indexOf(C.getChangeType())>=0){return true;}}).map(function(C){return C.getPreparedChange();});return u;};
S.prototype.handler=function(s,p){p=p||{};var o,a,c;var e=s[0].getElement();var h=p.fnHandler;if(!h){h=s[0].getDesignTimeMetadata().getAction("settings").handler;if(!h){throw new Error("Handler not found for settings action");}}p.getUnsavedChanges=this._getUnsavedChanges.bind(this);p.styleClass=U.getRtaStyleClassName();return h(e,p).then(function(C){if(C.length>0){c=this.getCommandFactory().getCommandFor(e,"composite");C.forEach(function(m){var b=m.changeSpecificData;if(b.changeType){var v;var d=m.selectorControl;var f;var g;if(d.controlType){f=d.controlType;}else{g=d;}var i=this._getChangeHandler(b.changeType,g,f);if(s[0].getVariantManagement&&i&&i.revertChange){v=s[0].getVariantManagement();}o=this.getCommandFactory().getCommandFor(d,"settings",b,undefined,v);c.addCommand(o);}else if(b.appDescriptorChangeType){var j=m.appComponent;var M=j.getManifest();var r=M["sap.app"].id;a=this.getCommandFactory().getCommandFor(e,"appDescriptor",{reference:r,appComponent:j,changeType:b.appDescriptorChangeType,parameters:b.content.parameters,texts:b.content.texts});c.addCommand(a);}},this);if(c.getCommands().length>0){this.fireElementModified({"command":c});}}}.bind(this))['catch'](function(E){if(E){throw E;}});};
S.prototype.getMenuItems=function(o){var s=this.getAction(o);var r=110;var p="CTX_SETTINGS";if(s){if(s.handler){return this._getMenuItems(o,{pluginId:p,rank:r,icon:this._getActionIcon(s)});}else{var m=[];var a=Object.keys(s);var A=0;a.forEach(function(b){var c=s[b],d=this.getActionText(o,c,c.name);if(c.handler){m.push({id:p+A,text:d,icon:this._getActionIcon(c),enabled:c.isEnabled&&c.isEnabled.bind(this,o.getElement()),handler:function(h,O,e){e=e||{};e.fnHandler=h;return this.handler(O,e);}.bind(this,c.handler),rank:r+A});A++;}else{jQuery.sap.log.warning("Handler not found for settings action '"+d+"'");}}.bind(this));return m;}}};
S.prototype._getActionIcon=function(s){var d="sap-icon://key-user-settings",a=s.icon;if(!a){return d;}if(typeof a!=="string"){B.error("Icon setting for settingsAction should be a string");return d;}return a;};
S.prototype.getActionName=function(){return"settings";};
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/Split',['sap/ui/rta/plugin/Plugin','sap/ui/dt/OverlayRegistry','sap/ui/rta/Utils','sap/ui/fl/Utils'],function(P,O,U,F){"use strict";
var S=P.extend("sap.ui.rta.plugin.Split",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s&&s.changeType&&s.changeOnRelevantContainer){return this.hasStableId(o)&&this.hasChangeHandler(s.changeType,o.getRelevantContainer());}else{return false;}};
S.prototype.isAvailable=function(o){if(!this._isEditableByPlugin(o)){return false;}var s=this.getSelectedOverlays();if(s.length!==1){return false;}var v=this.getAction(o);var e=s[0].getElement();if(v&&v.getControlsCount(e)<=1){return false;}return true;};
S.prototype.isEnabled=function(o){var a=this.getAction(o);if(!a||!this.isAvailable(o)){return false;}var A=true;if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){A=a.isEnabled(o.getElement());}else{A=a.isEnabled;}}return A;};
S.prototype.handleSplit=function(s){var p=s.getParent();var e=O.getOverlay(s);var d=e.getDesignTimeMetadata();var f=this.getAction(e).getControlsCount(s);var v=F.getViewForControl(s);var n=[];for(var i=0;i<f-1;i++){n.push(v.createId(jQuery.sap.uid()));}var o=this.getAction(e);var V=this.getVariantManagementReference(e,o);var a=this.getCommandFactory().getCommandFor(s,"split",{newElementIds:n,source:s,parentElement:p},d,V);this.fireElementModified({"command":a});};
S.prototype.getMenuItems=function(o){return this._getMenuItems(o,{pluginId:"CTX_UNGROUP_FIELDS",rank:100,icon:"sap-icon://screen-split-two"});};
S.prototype.getActionName=function(){return"split";};
S.prototype.handler=function(o,p){this.handleSplit(p.contextElement);};
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AddElementsDialog',['jquery.sap.global','sap/ui/base/ManagedObject','sap/m/Label','sap/m/LabelDesign','sap/m/Dialog','sap/ui/model/json/JSONModel','sap/m/SearchField','sap/m/Button','sap/m/Toolbar','sap/m/ToolbarSpacer','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/rta/command/CommandFactory','sap/ui/rta/command/CompositeCommand','sap/m/List','sap/m/CustomListItem','sap/m/ListType','sap/m/ScrollContainer','sap/ui/model/Sorter','sap/ui/dt/ElementUtil','sap/m/VBox','sap/ui/rta/Utils'],function(q,M,L,a,D,J,S,B,T,b,F,c,C,d,e,f,g,h,i,E,V,U){"use strict";
var A=M.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{"customFieldEnabled":{type:"boolean",defaultValue:false},"title":{type:"string"}},events:{"opened":{},"openCustomField":{}}}});
A.prototype.init=function(){this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this._bAscendingSortOrder=false;this._oDialog=new D().addStyleClass("sapUIRtaFieldRepositoryDialog");this._oDialog.addStyleClass(U.getRtaStyleClassName());this._oDialog.removeStyleClass("sapUiPopupWithPadding");this._oDialog.setModel(new J({elements:[]}));var j=this._createContent();var k=this._createButtons();j.forEach(function(o){this._oDialog.addContent(o);},this);k.forEach(function(o){this._oDialog.addButton(o);},this);this._oDialog.setInitialFocus(this._oInput);};
A.prototype._createContent=function(){this._oInput=new S({width:"100%",liveChange:[this._updateModelFilter,this]});var r=new B({text:"",icon:"sap-icon://sort",press:[this._resortList,this]});this._oCustomFieldButton=new B({text:"",icon:"sap-icon://add",tooltip:this._oTextResources.getText("BTN_FREP_CCF"),enabled:this.getCustomFieldEnabled(),press:[this._redirectToCustomFieldCreation,this]});this._oToolbarSpacer1=new b();this.oInputFields=new T({content:[this._oInput,r,this._oToolbarSpacer1,this._oCustomFieldButton]});var o=new L({design:a.Bold,tooltip:"{tooltip}",text:{parts:[{path:"label"},{path:"referencedComplexPropertyName"},{path:"duplicateComplexName"}],formatter:function(m,R,n){if(n&&R){m+=" ("+R+")";}return m;}}});var j=new L({text:{parts:[{path:"originalLabel"}],formatter:function(O){if(O){return this._oTextResources.getText("LBL_FREP",O);}return"";}.bind(this)},visible:{parts:[{path:"originalLabel"}],formatter:function(O){if(O){return true;}return false;}}});var v=new V();v.addItem(o);v.addItem(j);var s=new i("label",this._bAscendingSortOrder);this._oList=new e({mode:"MultiSelect",includeItemInSelection:true,growing:true,growingScrollToLoad:true}).setNoDataText(this._oTextResources.getText("MSG_NO_FIELDS",this._oTextResources.getText("MULTIPLE_CONTROL_NAME").toLowerCase()));var l=new f({type:g.Active,selected:"{selected}",content:[v]});this._oList.bindItems({path:"/elements",template:l,sorter:s});var k=new h({content:this._oList,vertical:true,horizontal:false}).addStyleClass("sapUIRtaCCDialogScrollContainer");return[this.oInputFields,k];};
A.prototype._createButtons=function(){this._oOKButton=new B({text:this._oTextResources.getText("BTN_FREP_OK"),press:[this._submitDialog,this]});var o=new B({text:this._oTextResources.getText("BTN_FREP_CANCEL"),press:[this._cancelDialog,this]});return[this._oOKButton,o];};
A.prototype._submitDialog=function(){this._oDialog.close();this._fnResolve();};
A.prototype._cancelDialog=function(){this._oList.removeSelections();this._oDialog.close();this._fnReject();};
A.prototype.setElements=function(j){this._oDialog.getModel().setProperty("/elements",j);};
A.prototype.getElements=function(){return this._oDialog.getModel().getProperty("/elements");};
A.prototype.getSelectedElements=function(){return this._oDialog.getModel().getObject("/elements").filter(function(o){return o.selected;});};
A.prototype.open=function(o){return new Promise(function(r,j){this._fnResolve=r;this._fnReject=j;this._oDialog.oPopup.attachOpened(function(){this.fireOpened();}.bind(this));this._oDialog.open();}.bind(this));};
A.prototype._resortList=function(o){this._bAscendingSortOrder=!this._bAscendingSortOrder;var j=this._oList.getBinding("items");var s=[];s.push(new i("label",this._bAscendingSortOrder));j.sort(s);};
A.prototype._updateModelFilter=function(o){var v=o.getParameter("newValue");var j=this._oList.getBinding("items");if((typeof v)==="string"){var k=new F("label",c.Contains,v);var O=new F("originalLabel",c.Contains,v);var r=new F("referencedComplexPropertyName",c.Contains,v);var l=new F("duplicateComplexName",c.EQ,true);var m=new F({filters:[r,l],and:true});var n=new F({filters:[k,O,m],and:false});j.filter([n]);}else{j.filter([]);}};
A.prototype._redirectToCustomFieldCreation=function(o){this.fireOpenCustomField();this._oDialog.close();};
A.prototype.setTitle=function(t){M.prototype.setProperty.call(this,"title",t,true);this._oDialog.setTitle(t);};
A.prototype.setCustomFieldEnabled=function(j){M.prototype.setProperty.call(this,"customFieldEnabled",j,true);this._oCustomFieldButton.setEnabled(j);};
return A;},true);
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer',['jquery.sap.global','sap/ui/core/StashedControlSupport','sap/ui/dt/ElementUtil','sap/ui/rta/Utils','sap/ui/rta/util/BindingsExtractor'],function(q,S,E,R,B){"use strict";
function _(P,i){var j=q.extend({},P);j.entityName=i.name;var l=P["com.sap.vocabularies.Common.v1.Label"];j.fieldLabel=l&&l.String;var Q=P["com.sap.vocabularies.Common.v1.QuickInfo"];j.quickInfo=Q&&Q.String;var H=P["com.sap.vocabularies.UI.v1.Hidden"];j.hidden=H&&H.Bool==="true";if(!j.hidden){var F=P["com.sap.vocabularies.Common.v1.FieldControl"];if(F){j.hidden=F.EnumMember==="com.sap.vocabularies.Common.v1.FieldControlType/Hidden";}}return j;}
function a(P){if(P&&P.type){if(P.type.toLowerCase().indexOf("edm")!==0){return true;}}return false;}
function b(O,M,i){return O.reduce(function(j,P){var l=_(P,i);if(a(l)){var C=M.getODataComplexType(l.type);if(C){l=C.property.map(function(w){w=_(w,i);w.bindingPath=l.name+"/"+w.name;w.referencedComplexPropertyName=l.fieldLabel||l.name;return w;});}}else{l.bindingPath=P.name;}return j.concat(l);},[]);}
function c(O,i,j){return O.filter(function(P){return!P.hidden;}).filter(function(P){var F=P["com.sap.vocabularies.Common.v1.FieldControl"];var l=F&&F.Path;if(l){var L=i.getBinding(j)instanceof sap.ui.model.ListBinding;if(L){return true;}var w=i.getBindingContext().getProperty(l);return w!==0;}return true;});}
function d(i,j){if(!i){return false;}var l=i.getBindingInfo(j);var P=l&&l.path;if(!P){return false;}if(P.indexOf(">")>-1){P=P.split(">").pop();}return P.indexOf("/")===0;}
var e=function(i,j,l){return j?i.getBindingInfo(l):i.getBindingContext();};var f=function(i,j){var l=d(i,j);var w=e(i,l,j);if(w){return l?w.path:w.getPath();}};
function g(i,j){var M=i.getModel();var D={property:[],navigationProperty:[],navigationEntityNames:[]};if(M){var l=M.getMetadata().getName();if(l==="sap.ui.model.odata.ODataModel"||l==="sap.ui.model.odata.v2.ODataModel"){var w=M.getMetaModel();return w.loaded().then(function(){var x=f(i,j);if(x){var y=w.getMetaContext(x);var O=y.getObject();var z=i.getMetadata().getAggregation();if(z){var C=i.getBindingInfo(z.name);var T=C&&C.template;if(T){var P=i.getBindingPath(z.name);var F=w.getODataAssociationEnd(O,P);var G=F&&F.type;if(G){var H=w.getODataEntityType(G);O=H;}}}D.property=O.property||[];D.property=b(D.property,w,O);D.property=c(D.property,i,j);if(O.navigationProperty){D.navigationProperty=O.navigationProperty;O.navigationProperty.forEach(function(N){var G=(w.getODataAssociationEnd(O,N.name)&&w.getODataAssociationEnd(O,N.name).type);var H=w.getODataEntityType(G);if(H&&H.name){if(D.navigationEntityNames.indexOf(H.name)===-1){D.navigationEntityNames.push(H.name);}}});}}return D;});}}return Promise.resolve(D);}
function h(O){return{selected:false,label:O.fieldLabel||O.name,referencedComplexPropertyName:O.referencedComplexPropertyName?O.referencedComplexPropertyName:"",duplicateComplexName:O.duplicateComplexName?O.duplicateComplexName:false,tooltip:O.quickInfo||O.fieldLabel,originalLabel:"",type:"odata",entityType:O.entityName,name:O.name,bindingPath:O.bindingPath};}
function k(D){var i=D.element;var j=D.action;return{selected:false,label:E.getLabelForElement(i,j.getLabel),tooltip:i.quickInfoFromOData||i.name||E.getLabelForElement(i,j.getLabel),referencedComplexPropertyName:i.referencedComplexPropertyName?i.referencedComplexPropertyName:"",duplicateComplexName:i.duplicateComplexName?i.duplicateComplexName:false,bindingPaths:i.bindingPaths,originalLabel:i.renamedLabel&&i.fieldLabel!==i.labelFromOData?i.labelFromOData:"",type:"invisible",elementId:i.getId()};}
function m(i,j,l){if(j&&j!==i){var w=R.getEntityTypeByPath(i.getModel(),f(i,l));return E.findAllSiblingsInContainer(i,j).filter(function(x){var P=f(x,l);if(P){return R.getEntityTypeByPath(x.getModel(),P)===w;}return false;});}else{return[i];}}
function n(O){O.forEach(function(i,l,O){if(i["duplicateComplexName"]!==true){for(var j=l+1;j<O.length-1;j++){if(i.fieldLabel===O[j].fieldLabel){i["duplicateComplexName"]=true;O[j]["duplicateComplexName"]=true;}}}});return O;}
function o(i,O){return O.some(function(D){return D.fieldLabel===i.fieldLabel;});}
function p(I,M){I.bindingPaths=[];I.bindingContextPaths=[];var j=I.sParentAggregationName;var P=I.getParent();var w=B.getBindings(I,M);if(P){var D=P.getMetadata().getAggregation();if(D){var x=E.getAggregation(P,j).indexOf(I);var y=D.name;var z=P.getBindingInfo(y);var T=z&&z.template;if(T){var C=T.getMetadata().getAggregation();if(C){var F=C.name;var G=E.getAggregation(T,F)[x];w=w.concat(B.getBindings(G,null,true));}}}}for(var i=0,l=w.length;i<l;i++){if(w[i].getPath&&w[i].getPath()){if(I.bindingPaths.indexOf(w[i].getPath())===-1){I.bindingPaths.push(w[i].getPath());}}if(w[i].getContext&&w[i].getContext()){if(I.bindingContextPaths.indexOf(w[i].getContext().getPath())===-1){I.bindingContextPaths.push(w[i].getContext().getPath());}}if(q.isPlainObject(w[i])){if(I.bindingPaths.indexOf(w[i].parts[0].path)===-1){I.bindingPaths.push(w[i].parts[0].path);}}}return I;}
function r(i){return Array.isArray(i)&&i.length>0;}
function s(i,N,j,l){var w=r(i)&&i.some(function(P){var y=P.trim().replace(/^\//gi,'').split('/');if(y.length>1){return N.indexOf(y.shift())!==-1;}});var x=l.some(function(C){C=C.match(/^\/?([A-Za-z0-9_]+)/)[0];return(j.indexOf(C)>=0);});return w||x;}
function t(i,O){return O.filter(function(D){return i.indexOf(D.bindingPath)!==-1;}).pop();}
function u(i,O){i.labelFromOData=O.fieldLabel;i.quickInfoFromOData=O.quickInfo;i.name=O.name;if(i.fieldLabel!==i.labelFromOData){i.renamedLabel=true;}if(O.referencedComplexPropertyName){i.referencedComplexPropertyName=O.referencedComplexPropertyName;}}
function v(i,O,N,j){var l=i.bindingPaths,w=i.bindingContextPaths,x;return(!r(l)||s(l,N,j,w)||((x=t(l,O))&&(u(i,x)||true)));}
var A={enhanceInvisibleElements:function(i,j){var M=i.getModel();var l=j.reveal;var w=j.addODataProperty;var D=i.getMetadata().getAggregation();var x=D?D.name:j.aggregation;return Promise.resolve().then(function(){return g(i,x);}).then(function(y){var O=y.property;var z=y.navigationProperty.map(function(N){return N.name;});var C=y.navigationEntityNames;O=n(O);var F=[];var I=l.elements||[];I.forEach(function(G){var T=G.getMetadata().getName();var H=l.types[T].action;var J=true;if(f(i,x)===f(G,x)){G=p(G,M);G.fieldLabel=E.getLabelForElement(G,H.getLabel);G.duplicateComplexName=o(G,O);if(w&&O.length>0){J=v(G,O,z,C);}}else if(G.getParent()&&B.getBindings(G,M).length>0){J=false;}if(J){F.push({element:G,action:H});}});return F;}).then(function(y){return y.map(k);});},getUnboundODataProperties:function(i,j){var D=i.getMetadata().getAggregation();var l=D?D.name:j.action.aggregation;var M=i.getModel();return Promise.resolve().then(function(){return g(i,l);}).then(function(w){var O=w.property;var x=m(i,j.relevantContainer,l);var y=[];x.forEach(function(i){y=y.concat(B.getBindings(i,M));});var F=j.action.filter?j.action.filter:function(){return true;};O=O.filter(function(z){var H=false;if(y){H=y.some(function(C){return(q.isPlainObject(C)?C.parts[0].path:!!C.getPath&&C.getPath())===z.bindingPath;});}return!H&&F(j.relevantContainer,z);});O=n(O);return O;}).then(function(U){return U.map(h);});}};return A;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin',["jquery.sap.global","sap/ui/rta/plugin/Plugin",'sap/ui/dt/ElementUtil','sap/ui/dt/OverlayRegistry','sap/ui/rta/Utils','sap/ui/fl/Utils','sap/ui/core/StashedControlSupport','sap/ui/dt/ElementDesignTimeMetadata'],function(q,P,E,O,U,F,S,a){"use strict";
function _(s,o){var p,r=o.getRelevantContainer(!s),R=O.getOverlay(r);if(s){p=o.getParentElementOverlay();}else{p=o;}return{relevantContainerOverlay:R,parentOverlay:p,relevantContainer:r,parent:p.getElement()};}
function b(p,C){return C.sParentAggregationName;}
function c(p,s){var o=p.getElement();var i=E.getAggregation(o,s).filter(function(C){var m=O.getOverlay(C);if(!this.hasStableId(m)){return false;}var r=p.getRelevantContainer(true);var R=O.getOverlay(r);var n=p;var t=false;do{t=!n.getElementVisibility();if(t){break;}if(n===R){break;}else{n=n.getParentElementOverlay();}}while(n);if(t){return true;}return m.getElementVisibility()===false;},this);var l=S.getStashedControls(o.getId());return i.concat(l);}
var d=true,e=false;
function f(r,m,p,s,C){var n=[];var i;var l;if(m.addODataProperty){var o=m.aggregation;var D=m.addODataProperty.designTimeMetadata;i=D.getAggregationDescription(o,p);if(i){l=s?i.singular:i.plural;n.push(l);}}if(m.reveal){Object.keys(m.reveal.types).forEach(function(T){var u=m.reveal.types[T];i=u.name;if(i){l=s?i.singular:i.plural;n.push(l);}});}var N=n.reduce(function(u,v){if(u.indexOf(v)===-1){u.push(v);}return u;},[]);var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(N.length===1){l=N[0];}else if(C){l=C;}else{l=t.getText("MULTIPLE_CONTROL_NAME");}return t.getText(r,l);}
function g(){return{designTimeMetadata:new a({data:{name:{singular:function(){return sap.uxap.i18nModel.getResourceBundle().getText("SECTION_CONTROL_NAME");},plural:function(){return sap.uxap.i18nModel.getResourceBundle().getText("SECTION_CONTROL_NAME_PLURAL");}},actions:{reveal:{changeType:"unstashControl",getAggregationName:b}}}}),action:{changeType:"unstashControl",getAggregationName:b}};}
var A=P.extend("sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin",{
metadata:{library:"sap.ui.rta",properties:{analyzer:"object",dialog:"object",commandFactory:"object"},associations:{},events:{}},
getContextMenuTitle:function(o,i){var p=_(o,i);var m=this._getActions(o,i);return f("CTX_ADD_ELEMENTS",m,p.parent,d);},
isAvailable:function(o,i){return this._isEditableByPlugin(i,o);},
isEnabled:function(o,i){var p;var I;if(o){p=i.getParentElementOverlay();if(p&&this.hasStableId(p)){I=true;}else{I=false;}}else{var m=this._getActions(o,i);if(m.reveal&&m.reveal.elements.length===0&&!m.addODataProperty){I=false;}else{I=true;}}return I&&this.isMultiSelectionInactive.call(this,i);},
_getRevealActions:function(s,o){var p=_(s,o);var r=this._getTypes(r,p,s,o);return r;},
_getTypes:function(r,p,s,o){var i=[p.parentOverlay];var R=o.getRelevantContainer(!s);if(R!==p.parent){i=E.findAllSiblingsInContainer(p.parent,R).map(function(m){return O.getOverlay(m);});}var l;if(s){l=[o.getParentAggregationOverlay().getAggregationName()];}else{l=p.parentOverlay.getAggregationOverlays().filter(function(m){return!m.getDesignTimeMetadata().isIgnored(p.parent);}).map(function(m){return m.getAggregationName();});}r=l.reduce(this._getRevealActionFromAggregations.bind(this,i),{});return r;},
_getRevealActionFromAggregations:function(p,i,s){var I=p.reduce(function(l,o){return o?l.concat(c.call(this,o,s)):l;}.bind(this),[]);var C=function(t,o){var T=o.getMetadata().getName();if(!t[T]){if(T==="sap.ui.core._StashedControl"){t[T]=g();}else{var l=O.getOverlay(o);if(l){var D=l.getDesignTimeMetadata();var r=D&&D.getAction("reveal",o);if(r&&r.changeType){if(r.changeOnRelevantContainer){o=l.getRelevantContainer();}if(this.hasChangeHandler(r.changeType,o)){if(!r.getAggregationName){r.getAggregationName=b;}t[T]={designTimeMetadata:D,action:r,name:D.getName(o)};}}}}}return t;};var t=I.reduce(C.bind(this),{});I=I.filter(function(o){return!!t[o.getMetadata().getName()];});if(I.length>0&&Object.keys(t).length>0){i[s]={reveal:{elements:I,types:t}};}return i;},
_getAddODataPropertyActions:function(s,o){var p=_(s,o);var D=p.parentOverlay.getDesignTimeMetadata();var i=D.getActionDataFromAggregations("addODataProperty",p.parent);var C=p.parent;var l=function(m,n){if(n){if(n.changeOnRelevantContainer){C=p.relevantContainer;}if(n.changeType&&this.hasChangeHandler(n.changeType,C)){m[n.aggregation]={addODataProperty:{designTimeMetadata:D,action:n}};}return m;}};if(i&&i.length>0){return i.reduce(l.bind(this),{});}},
_getActions:function(s,o){var r=this._getRevealActions(s,o);var m=this._getAddODataPropertyActions(s,o);var i=q.extend(true,r,m);var l=Object.keys(i);if(l.length===0){return{};}else if(l.length>1){q.sap.log.error("reveal or addODataProperty action defined for more than 1 aggregation, that is not yet possible");}var n=l[0];i[n].aggregation=n;return i[n];},
_hasRevealActionsOnChildren:function(o){var r=this._getRevealActions(false,o);return!!r&&Object.keys(r).length>0;},
showAvailableElements:function(o,i,I,C){var l=i[0];var p=_(o,l);var s=o&&l.getElement();var m=[];var n=this._getActions(o,l);if(n.reveal){m.push(this.getAnalyzer().enhanceInvisibleElements(p.parent,n));}if(n.addODataProperty){n.addODataProperty.relevantContainer=l.getRelevantContainer(!o);m.push(this.getAnalyzer().getUnboundODataProperties(p.parent,n.addODataProperty));}if(n.aggregation||C){this._setDialogTitle(n,p.parent,C);}return Promise.resolve().then(function(){if(n.addODataProperty){return U.isServiceUpToDate(p.parent);}}).then(function(){if(n.addODataProperty){this.getDialog()._oCustomFieldButton.setVisible(true);return U.isCustomFieldAvailable(p.parent);}else{this.getDialog()._oCustomFieldButton.setVisible(false);}}.bind(this)).then(function(r){if(r){this._oCurrentFieldExtInfo=r;this.getDialog().setCustomFieldEnabled(true);this.getDialog().detachEvent('openCustomField',this._onOpenCustomField,this);this.getDialog().attachEvent('openCustomField',null,this._onOpenCustomField,this);}}.bind(this)).then(h.bind(null,m)).then(function(r){this.getDialog().setElements(r);return this.getDialog().open().then(function(){this._createCommands(o,l,p,s,n.designTimeMetadata,n,I);}.bind(this)).catch(function(t){if(t instanceof Error){throw t;}});}.bind(this)).catch(function(r){if(r instanceof Error){throw r;}else{q.sap.log.info("Service not up to date, skipping add dialog","sap.ui.rta");}});},
_setDialogTitle:function(m,p,C){var D=f("HEADER_ADDITIONAL_ELEMENTS",m,p,e,C);this.getDialog().setTitle(D);if(C){this.getDialog()._oList.setNoDataText(this.getDialog()._oTextResources.getText("MSG_NO_FIELDS",C.toLowerCase()));}},
_onOpenCustomField:function(o){var C=sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService("CrossApplicationNavigation");var H=(C&&C.hrefForExternal({target:{semanticObject:"CustomField",action:"develop"},params:{businessContexts:this._oCurrentFieldExtInfo.BusinessContexts,serviceName:this._oCurrentFieldExtInfo.ServiceName,serviceVersion:this._oCurrentFieldExtInfo.ServiceVersion,entityType:this._oCurrentFieldExtInfo.EntityType}}));U.openNewWindow(H);},
_createCommands:function(s,o,p,i,D,m,I){var l=this.getDialog().getSelectedElements();if(l.length>0){var C=this.getCommandFactory().getCommandFor(p.parent,"composite");l.forEach(function(n){var r;switch(n.type){case"invisible":r=this._createRevealCommandForInvisible(n,m,p,i);C.addCommand(r);r=this._createMoveCommandForInvisible(n,m,p,i,I);if(r){C.addCommand(r);}else{q.sap.log.warning("No move action configured for "+p.parent.getMetadata().getName()+", aggregation: "+m.aggregation,"sap.ui.rta");}break;case"odata":var t=p.parentOverlay.getAggregationOverlay(m.aggregation);var u=t.getDesignTimeMetadata();var v=u.getAction("addODataProperty",p.parent);var w=v.changeHandlerSettings;var R;if(w&&w.content){R=w.content.requiredLibraries;}if(R){var x=this._createCommandForAddLibrary(p,m,R,u);C.addCommand(x);}r=this._createCommandsForOData(n,m,p,i,I);C.addCommand(r);break;default:q.sap.log.error("Can't create command for untreated element.type "+n.type);}},this);this.fireElementModified({"command":C});}},
_createCommandsForOData:function(s,m,p,o,i){var l=p.parentOverlay.getAggregationOverlay(m.aggregation);var n=l.getDesignTimeMetadata();var r=n.getAction("addODataProperty",p.parent);var C=r.changeHandlerSettings;var t;if(C&&C.key){t=C.key.oDataServiceVersion;}var R=p.parent;if(r.changeOnRelevantContainer){R=p.relevantContainer;}var u=U.getIndex(p.parent,o,m.aggregation,n.getData().getIndex);var v=this._getChangeHandler(r.changeType,p.parent);var V;if(p.parentOverlay.getVariantManagement&&v&&v.revertChange){V=p.parentOverlay.getVariantManagement();}return this.getCommandFactory().getCommandFor(p.parent,"addODataProperty",{newControlId:U.createFieldLabelId(R,s.entityType,s.bindingPath),index:i!==undefined?i:u,bindingString:s.bindingPath,entityType:s.entityType,parentId:p.parent.getId(),oDataServiceVersion:t},n,V);},
_createCommandForAddLibrary:function(p,m,r,o){var C=F.getAppComponentForControl(p.relevantContainer);var M=C.getManifest();var R=M["sap.app"].id;return this.getCommandFactory().getCommandFor(p.publicParent,"addLibrary",{reference:R,parameters:{libraries:r},appComponent:C},o);},
_createRevealCommandForInvisible:function(s,m,p,o){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var t=r.getMetadata().getName();var T=m.reveal.types[t];var D=T.designTimeMetadata;var i=D.getAction("reveal",r);var l=O.getOverlay(r);if(!l){var n=j(r,p,R);l=O.getOverlay(n);}var v;if(l){v=this.getVariantManagementReference(l,i,false,r);}if(i.changeOnRelevantContainer){return this.getCommandFactory().getCommandFor(r,"reveal",{revealedElementId:r.getId(),directParent:p.parent},D,v);}else{return this.getCommandFactory().getCommandFor(r,"reveal",{},D,v);}},
_createMoveCommandForInvisible:function(s,m,p,o,i){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var t=r.getMetadata().getName();var l;if(R){l=R.getParentAggregationOverlay().getAggregationName();}else{var T=m.reveal.types[t];l=T.action.getAggregationName(p.parent,r);}var n=j(r,p,R);var u=p.parent;var v=U.getIndex(p.parent,o,l);var w=U.getIndex(n,r,l)-1;v=i!==undefined?i:k(n,u,w,v);var C;if(v!==w||p.parent!==r.getParent()){var x=O.getOverlay(r)?O.getOverlay(r).getParentAggregationOverlay():p.relevantContainerOverlay;var y=x.getDesignTimeMetadata();var M=y.getAction("move",r);var V;if(M){V=this.getVariantManagementReference(O.getOverlay(r),M,true);}C=this.getCommandFactory().getCommandFor(p.relevantContainer,"move",{movedElements:[{element:r,sourceIndex:w,targetIndex:v}],source:{parent:n,aggregation:l},target:{parent:u,aggregation:l}},y,V);}return C;},
_isEditable:function(o){return{asSibling:this._isEditableCheck.call(this,o,true),asChild:this._isEditableCheck.call(this,o,false)};},
_isEditableCheck:function(o,i){var l=false;var r=o.getRelevantContainer();var R=O.getOverlay(r);if(!R){return false;}var m=this._getActions(i,o);var p=_(i,o);if(m.addODataProperty){var n=m.addODataProperty.action;l=n&&n.aggregation===o.getParentAggregationOverlay().getAggregationName();}if(!l&&m.reveal){l=true;}if(!l&&!i){l=this._hasRevealActionsOnChildren(o)||this.checkAggregationsOnSelf(p.parentOverlay,"addODataProperty");}if(l){return this.hasStableId(o);}else{return false;}},
getMenuItems:function(o){var l=true;var p="CTX_ADD_ELEMENTS_AS_SIBLING";var r=20;var I="sap-icon://add";var m=[];for(var i=0;i<2;i++){if(this.isAvailable(l,o)){var M=this.getContextMenuTitle.bind(this,l);m.push({id:p,text:M,handler:function(l,n){return this.showAvailableElements(l,n);}.bind(this,l),enabled:this.isEnabled.bind(this,l),rank:r,icon:I,group:"Add"});}l=false;p="CTX_ADD_ELEMENTS_AS_CHILD";r=30;}return m;}
});
function h(p){return Promise.all(p).then(function(i){var l=i[0]||[];if(l&&i[1]){l=l.concat(i[1]);}return l;});}
function j(r,p,R){var o;if(R){o=R.getParentElementOverlay().getElement();}if(!o&&r.sParentId){o=sap.ui.getCore().byId(r.sParentId);}else if(!o){o=p.parent;}return o;}
function k(s,t,i,T){if(s===t&&i<T&&i>-1){return T-1;}return T;}
return A;});
sap.ui.predefine('sap/ui/rta/service/ControllerExtension',['sap/ui/dt/Util','sap/ui/fl/Utils'],function(D,F){"use strict";return function(r){return{exports:{add:function(c,v){var f=r.getFlexSettings();if(!f.developerMode){throw D.createError("service.ControllerExtension#add","code extensions can only be created in developer mode","sap.ui.rta");}if(!c){throw D.createError("service.ControllerExtension#add","can't create controller extension without codeRef","sap.ui.rta");}if(!c.endsWith(".js")){throw D.createError("service.ControllerExtension#add","codeRef has to end with 'js'");}var o=r._getFlexController();var V=sap.ui.getCore().byId(v);var a=F.getAppComponentForControl(V);var C=V.getControllerName&&V.getControllerName()||V.getController()&&V.getController().getMetadata().getName();var b={content:{codeRef:c},selector:{controllerName:C},changeType:"codeExt",namespace:f.namespace};var p=o.createBaseChange(b,a);o.addPreparedChange(p,a);return p.getDefinition();}}};};});
sap.ui.predefine('sap/ui/rta/service/Outline',["sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementOverlay","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil"],function(O,E,R,D,a,b){"use strict";return function(r){var o={oRta:r};o._getOutline=function(i,d){if(!d&&D.isInteger(i)){d=i;i=undefined;}var c=[];if(!i){c=this.oRta._oDesignTime.getRootElements().map(function(v){var e=b.getElementInstance(v);return O.getOverlay(e);});}else{var p=O.getOverlay(i);if(!p){throw D.createError("services.Outline#get","Valid id for the starting overlay should be provided or this parameter should be neglected ","sap.ui.rta");}c.push(p);}return c.map(function(I){return this._getChildrenNodes(I,d);}.bind(this));};o._getChildrenNodes=function(c,d,p){var v=D.isInteger(d);var e=this._getNodeProperties(c,p);var C=c.getChildren();if((!v||(v&&d>0))&&C.length>0){d=v?d-1:d;e.elements=C.map(function(f){return this._getChildrenNodes(f,d,f.getParent());},this);}return e;};o._getNodeProperties=function(c,p){var d;var A;var i;var t;var I=false;var f=c.getElement();var g=f.getId();var h=f.getMetadata().getName();var j=c.getDesignTimeMetadata();var k=j.getData();var l=(k.palette&&k.palette.icons&&k.palette.icons.svg||undefined);if(c instanceof E){t="element";i=j.getLabel(f);I=c.getEditable();d=j.getName(f);}else{t="aggregation";A=c.getAggregationName();i=j.getLabel(f);if(p instanceof E){d=p.getAggregation(A)?p.getDesignTimeMetadata().getAggregationDescription(A,f):undefined;}}var m={id:g,instanceName:i!==g?i:undefined,name:d&&d.singular,technicalName:A?A:h,editable:I,icon:l,type:t};try{return JSON.parse(JSON.stringify(m));}catch(e){throw D.createError("services.Outline#get",e.message,"sap.ui.rta");}};var s={exports:{get:o._getOutline.bind(o)}};return new Promise(function(f,c){var C=function(){return r._oDesignTime.getRootElements().some(function(d){return!O.getOverlay(d);});};if(!r._oDesignTime||C()){r.attachEventOnce("start",function(){f(s);});r.attachEventOnce("failed",function(){c(D.createError("services.Outline#get","Designtime failed to load. This is needed to start the Outline service","sap.ui.rta"));});}else{f(s);}});};},true);
sap.ui.predefine('sap/ui/rta/service/Receiver',["sap/ui/core/postmessage/Bus","sap/ui/dt/Util","sap/base/util/uid"],function(P,D,u){"use strict";var C='sap.ui.rta.service.receiver';var p;return function(r){var e={};var R=function(E){var d=E.data;var m=d.body;switch(E.eventId){case"getService":var s=m.arguments[0];r.getService(s).then(function(S){var a={};var M=[];Object.keys(S).forEach(function(k){if(typeof S[k]==='function'){if(!/^(at|de)tach/.test(k)){M.push(k);}}else{a[k]=S[k];}});p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"getService",data:{id:d.id,type:"response",body:{methods:M,properties:a,events:r._mServices[s].service.events}}});});break;case'callMethod':r.getService(m.service).then(function(S){S[m.method].apply(null,m.arguments).then(function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'callMethod',data:{type:'response',status:'success',id:d.id,body:v}});});}).catch(function(v){var o=D.propagateError(v,"service.Receiver",D.printf("Can't execute method {0} of service {1} due unexpected error.",m.method,m.service),"sap.ui.rta");p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"callMethod",data:{type:"response",status:"error",id:d.id,body:o.toString()}});});break;case'subscribe':r.getService(m.service).then(function(S){var h=function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'event',data:{body:{service:m.service,event:m.event,data:v}}});};var H=u();e[H]=h;S.attachEvent(m.event,h);p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'subscribe',data:{type:'response',status:'success',id:d.id,body:{id:H}}});});break;case'unsubscribe':r.getService(m.service).then(function(S){S.detachEvent(m.event,e[m.id]);delete e[m.id];p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'unsubscribe',data:{type:'response',status:'success',id:d.id}});});break;}};r.attachEventOnce("start",function(){p=P.getInstance();p.publish({channelId:C,eventId:P.event.READY});p.subscribe(C,"getService",R);p.subscribe(C,"callMethod",R);p.subscribe(C,"subscribe",R);p.subscribe(C,"unsubscribe",R);});return{destroy:function(){if(p){p.unsubscribe(C,"getService",R);p.unsubscribe(C,"callMethod",R);p.unsubscribe(C,"subscribe",R);p.unsubscribe(C,"unsubscribe",R);}}};};});
sap.ui.predefine('sap/ui/rta/service/Selection',function(){"use strict";return function(r){var s=r._oDesignTime.getSelectionManager();return{exports:{get:s.get.bind(s),set:s.set.bind(s),add:s.add.bind(s),remove:s.remove.bind(s)}};};});
sap.ui.predefine('sap/ui/rta/service/index',function(){"use strict";return Object.freeze({receiver:'sap.ui.rta.service.Receiver',selection:'sap.ui.rta.service.Selection',controllerExtension:'sap.ui.rta.service.ControllerExtension',outline:'sap.ui.rta.service.Outline'});});
sap.ui.predefine('sap/ui/rta/toolbar/Adaptation',['sap/m/ToolbarSpacer','sap/m/Button','sap/m/SegmentedButton','sap/m/SegmentedButtonItem','sap/m/MenuButton','sap/m/MenuItem','sap/m/Menu','./Base'],function(T,B,S,a,M,b,c,d){"use strict";
var A=d.extend("sap.ui.rta.toolbar.Adaptation",{
renderer:'sap.ui.rta.toolbar.BaseRenderer',
animation:true,
metadata:{events:{"undo":{},"redo":{},"exit":{},"restore":{},"transport":{},"modeChange":{},"manageApps":{},"appVariantOverview":{},"saveAs":{}},properties:{"publishVisible":{"type":"boolean","defaultValue":false},"modeSwitcher":{type:"string",defaultValue:"adaptation"}}}
});
A.prototype.onAfterRendering=function(){var s=-1;var i=false;var w=this.getAggregation('content').reduce(function(r,C){switch(C.data('name')){case'spacerLeft':s=1;i=true;break;case'spacerRight':i=false;break;}return!(C instanceof T)&&!i?r+s*C.$().outerWidth(true):r;},0);if(w>0){this.getControl('spacerBalancer').setWidth(w+'px');}d.prototype.onAfterRendering.apply(this,arguments);};
A.prototype.buildControls=function(){return[new T().data('name','spacerBalancer'),new T().data('name','spacerLeft'),new S({width:"auto",selectedKey:this.getModeSwitcher(),items:[new a({text:this.getTextResources().getText("BTN_ADAPTATION"),tooltip:this.getTextResources().getText("BTN_ADAPTATION"),width:"auto",key:"adaptation"}),new a({text:this.getTextResources().getText("BTN_NAVIGATION"),tooltip:this.getTextResources().getText("BTN_NAVIGATION"),width:"auto",key:"navigation"})],select:this.eventHandler.bind(this,'ModeChange')}).data('name','modeSwitcher'),new T().data('name','spacerRight'),new B({type:"Transparent",icon:"sap-icon://undo",enabled:false,tooltip:this.getTextResources().getText("BTN_UNDO"),press:this.eventHandler.bind(this,'Undo')}).data('name','undo'),new B({type:"Transparent",icon:"sap-icon://redo",iconFirst:false,enabled:false,tooltip:this.getTextResources().getText("BTN_REDO"),press:this.eventHandler.bind(this,'Redo')}).data('name','redo'),new B({type:"Transparent",icon:"sap-icon://message-information",enabled:false,visible:false,tooltip:this.getTextResources().getText("BTN_MANAGE_APPS"),press:this.eventHandler.bind(this,'ManageApps')}).data('name','manageApps'),new M({type:"Transparent",icon:"sap-icon://message-information",enabled:false,visible:false,tooltip:this.getTextResources().getText("BTN_MANAGE_APPS"),menu:new c({itemSelected:this.eventHandler.bind(this,'AppVariantOverview'),items:[new b('keyUser',{text:this.getTextResources().getText("MENU_ITEM_KEY_USER")}),new b('developer',{text:this.getTextResources().getText("MENU_ITEM_SAP_DEVELOPER")})]})}).data('name','appVariantOverview'),new B({type:"Transparent",text:this.getTextResources().getText("BTN_RESTORE"),visible:true,enabled:false,tooltip:this.getTextResources().getText("BTN_RESTORE"),press:this.eventHandler.bind(this,'Restore')}).data('name','restore'),new B({type:"Transparent",enabled:false,visible:this.getPublishVisible(),text:this.getTextResources().getText("BTN_PUBLISH"),tooltip:this.getTextResources().getText("BTN_PUBLISH"),press:this.eventHandler.bind(this,'Transport')}).data('name','publish'),new B({type:"Transparent",text:this.getTextResources().getText("BTN_SAVE_AS"),enabled:false,visible:false,tooltip:this.getTextResources().getText("TOOLTIP_SAVE_AS"),press:this.eventHandler.bind(this,'SaveAs')}).data('name','saveAs'),new B({type:"Transparent",text:this.getTextResources().getText("BTN_EXIT"),tooltip:this.getTextResources().getText("BTN_EXIT"),press:this.eventHandler.bind(this,'Exit')}).data('name','exit')];};
A.prototype.setUndoRedoEnabled=function(C,e){this.getControl('undo').setEnabled(C);this.getControl('redo').setEnabled(e);};
A.prototype.setPublishEnabled=function(e){this.getControl('publish').setEnabled(e);};
A.prototype.setRestoreEnabled=function(e){this.getControl('restore').setEnabled(e);};
A.prototype.show=function(){return d.prototype.show.apply(this,arguments);};
A.prototype.hide=function(){return d.prototype.hide.apply(this,arguments);};
return A;},true);
sap.ui.predefine('sap/ui/rta/toolbar/Base',['jquery.sap.global','sap/ui/rta/library','sap/ui/core/Popup','sap/m/Toolbar','sap/ui/core/BusyIndicator','sap/ui/rta/util/Animation'],function(q,l,P,T,B,A){"use strict";
var a=T.extend("sap.ui.rta.toolbar.Base",{
metadata:{library:"sap.ui.rta",properties:{"color":{type:"string",defaultValue:"default"},"zIndex":{type:"int"},"textResources":"object"}},
constructor:function(){T.apply(this,arguments);this.setVisible(false);this.placeToContainer();this.buildContent();},
type:null,
animation:false
});
a.prototype.init=function(){T.prototype.init.apply(this,arguments);};
a.prototype.onBeforeRendering=function(){T.prototype.onBeforeRendering.apply(this,arguments);};
a.prototype.onAfterRendering=function(){T.prototype.onAfterRendering.apply(this,arguments);};
a.prototype.eventHandler=function(e,E){this['fire'+e](E.getParameters());};
a.prototype.buildControls=function(){return[];};
a.prototype.placeToContainer=function(){this.placeAt(sap.ui.getCore().getStaticAreaRef());};
a.prototype.buildContent=function(){this.buildControls().forEach(this.addContent,this);};
a.prototype.show=function(){return new Promise(function(r){var d={onAfterRendering:function(){this.removeEventDelegate(d);r();}};this.addEventDelegate(d,this);this.bringToFront();this.setVisible(true);}.bind(this)).then(function(){return this.animation?A.waitTransition(this.$(),this.addStyleClass.bind(this,'is_visible')):Promise.resolve();}.bind(this)).then(function(){this.focus();}.bind(this));};
a.prototype.hide=function(){return(this.animation?A.waitTransition(this.$(),this.removeStyleClass.bind(this,'is_visible')):Promise.resolve()).then(function(){this.setVisible(false);}.bind(this));};
a.prototype.getControl=function(n){return this.getAggregation('content').filter(function(c){return c.data('name')===n;}).pop();};
a.prototype.bringToFront=function(){var n;var b=B.oPopup;if(b&&b.isOpen()&&b.getModal()){n=b._iZIndex-3;}else{n=P.getNextZIndex();}this.setZIndex(n);};
a.prototype.setUndoRedoEnabled=function(){};
a.prototype.setPublishEnabled=function(){};
a.prototype.setRestoreEnabled=function(){};
return a;},true);
sap.ui.predefine('sap/ui/rta/toolbar/BaseRenderer',['sap/ui/core/Renderer','sap/m/ToolbarRenderer'],function(R,T){"use strict";var B=R.extend('sap.ui.rta.toolbar.BaseRenderer',T);
B.decorateRootElement=function(r,c){r.addClass('sapUiRtaToolbar');r.addClass('sapContrastPlus');r.addClass("color_"+c.getColor());c.type&&r.addClass("type_"+c.type);var z=c.getZIndex();z&&r.addStyle("z-index",z);T.decorateRootElement(r,c);};
return B;});
sap.ui.predefine('sap/ui/rta/toolbar/Fiori',['sap/m/Image','./Adaptation','../Utils'],function(I,A,U){"use strict";var F='sapUiRtaFioriHeaderInvisible';
var a=A.extend("sap.ui.rta.toolbar.Fiori",{
renderer:'sap.ui.rta.toolbar.BaseRenderer',
type:'fiori'
});
a.prototype.init=function(){A.prototype.init.apply(this,arguments);this._oRenderer=U.getFiori2Renderer();this._oFioriHeader=this._oRenderer.getRootControl().getOUnifiedShell().getHeader();};
a.prototype.show=function(){this._oFioriHeader.addStyleClass(F);return A.prototype.show.apply(this,arguments);};
a.prototype.buildControls=function(){var c=A.prototype.buildControls.apply(this,arguments);var l=this._oFioriHeader.getLogo();if(this._oFioriHeader.getShowLogo()&&l){var $=this._oFioriHeader.$().find('#shell-header-icon');var w,h;if($.length){w=$.width();h=$.height();this._checkLogoSize($,w,h);}c.unshift(new I({src:l,width:w?w+'px':w,height:h?h+'px':h}).data('name','logo'));}return c;};
a.prototype.hide=function(){return A.prototype.hide.apply(this,arguments).then(function(){this._oFioriHeader.removeStyleClass(F);}.bind(this));};
a.prototype._checkLogoSize=function($,w,h){var n=$.get(0).naturalWidth;var N=$.get(0).naturalHeight;if(w!==n||h!==N){jQuery.sap.log.error(["sap.ui.rta: please check Fiori Launchpad logo, expected size is",w+"x"+h+",","but actual is "+n+"x"+N].join(' '));}};
a.prototype.destroy=function(){this._oFioriHeader.removeStyleClass(F);delete this._oRenderer;delete this._oFioriHeader;A.prototype.destroy.apply(this,arguments);};
return a;},true);
sap.ui.predefine('sap/ui/rta/toolbar/Personalization',['./Base','sap/m/ToolbarSpacer'],function(B,T){"use strict";
var P=B.extend("sap.ui.rta.toolbar.Personalization",{
renderer:'sap.ui.rta.toolbar.BaseRenderer',
type:'personalization',
metadata:{events:{"exit":{},"restore":{}}}
});
P.prototype.buildControls=function(){var c=[new T(),new sap.m.Button({type:"Transparent",text:this.getTextResources().getText("BTN_RESTORE"),tooltip:this.getTextResources().getText("BTN_RESTORE"),visible:true,press:this.eventHandler.bind(this,'Restore')}).data('name','restore'),new sap.m.Button({type:"Emphasized",text:this.getTextResources().getText("BTN_DONE"),tooltip:this.getTextResources().getText("BTN_DONE_TOOLTIP"),press:this.eventHandler.bind(this,'Exit')}).data('name','exit')];return c;};
P.prototype.setUndoRedoEnabled=function(){};
P.prototype.setPublishEnabled=function(){};
P.prototype.setRestoreEnabled=function(e){this.getControl('restore').setEnabled(e);};
return P;},true);
sap.ui.predefine('sap/ui/rta/toolbar/Standalone',['./Adaptation'],function(A){"use strict";
var S=A.extend("sap.ui.rta.toolbar.Standalone",{
renderer:'sap.ui.rta.toolbar.BaseRenderer',
type:'standalone'
});
return S;},true);
sap.ui.predefine('sap/ui/rta/util/Animation',['jquery.sap.global'],function(q){"use strict";var m={};
m.waitTransition=function($,c){if(!($ instanceof q)){throw new Error('$element should be wrapped into jQuery object');}if(!q.isFunction(c)){throw new Error('fnCallback should be a function');}return new Promise(function(r){$.one('transitionend',r);var t;var a=function(T){if(!t){t=T;}if(T!==t){c();}else{window.requestAnimationFrame(a);}};window.requestAnimationFrame(a);});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/BindingsExtractor',['sap/ui/dt/ElementUtil','sap/ui/rta/Utils'],function(E,R){"use strict";
function g(e,p,t){var B=(t?c(e):b(e,p));for(var A in e.getMetadata().getAllAggregations()){var o=e.getBindingInfo(A);var T=o&&o.template;var d=T?[T]:E.getAggregation(e,A);d.forEach(function(C){if(C.getMetadata){B=B.concat(T||t?c(C):b(C,p),g(C,p,T||t));}});}return B;}
function f(B,p){var d=[];var m=B.getMetadata().getName();if(m==="sap.ui.model.CompositeBinding"){B.getBindings().forEach(function(B){d=d.concat(f(B,p));});}else if((m==="sap.ui.model.odata.ODataPropertyBinding"||m==="sap.ui.model.odata.v2.ODataPropertyBinding"||m==="sap.ui.model.odata.v4.ODataPropertyBinding"||m==="sap.ui.model.json.JSONPropertyBinding"||m==="sap.ui.model.json.XMLPropertyBinding"||m==="sap.ui.model.resource.ResourcePropertyBinding")&&B.getModel()===p&&B.isRelative()&&jQuery.isFunction(B.getPath)&&B.getPath()){d.push(B);}return d;}
function a(B){var d=[];var p=B.parts;p.forEach(function(P){d.push({parts:[P]});});return d;}
function b(e,p){var P=Object.keys(e.getMetadata().getAllProperties());return P.filter(e.getBinding.bind(e)).reduce(function(B,s){return B.concat(f(e.getBinding(s),p));},[]);}
function c(e){var p=Object.keys(e.getMetadata().getAllProperties());return p.filter(function(P){return P in e.mBindingInfos;}).reduce(function(B,P){return B.concat(a(e.mBindingInfos[P]));},[]);}
return{getBindings:g,flattenBindings:f,getBindingsFromProperties:b};},true);
sap.ui.predefine('sap/ui/rta/util/PopupManager',['jquery.sap.global','sap/ui/base/ManagedObject','sap/m/Dialog','sap/m/Popover','sap/m/InstanceManager','sap/ui/core/Popup','sap/ui/dt/OverlayRegistry','sap/ui/dt/Overlay','sap/ui/fl/Utils','sap/ui/core/Component','sap/ui/core/ComponentContainer','sap/ui/core/Element'],function(q,M,D,P,I,a,O,b,f,C,c,E){"use strict";var F={"add":"_activateFocusHandle","remove":"_deactivateFocusHandle"};
var d=M.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});
d.prototype._overrideInstanceFunctions=function(){this._applyPopupMethods(this._createPopupOverlays);this._overrideAddPopupInstance();this._overrideRemovePopupInstance();};
d.prototype.getRelevantPopups=function(){var o,e;o=I.getOpenDialogs();e=I.getOpenPopovers();var r={aDialogs:this._getValidatedPopups(o),aPopovers:this._getValidatedPopups(e)};return r;};
d.prototype._getValidatedPopups=function(o){o=o.filter(function(p){return this._isPopupAdaptable(p);}.bind(this));return(o.length>0)?o:false;};
d.prototype._isComponentInsidePopup=function(p){return q.isArray(p.getContent())?p.getContent().some(function(o){if(o instanceof c){return this.oRtaRootAppComponent===this._getAppComponentForControl(sap.ui.getCore().getComponent(o.getComponent()));}}.bind(this)):false;};
d.prototype._isSupportedPopup=function(p){return(p instanceof sap.m.Dialog||p instanceof sap.m.Popover);};
d.prototype.setRta=function(r){if(r&&r._oDesignTime){this.setProperty("rta",r);var R=sap.ui.getCore().byId(r.getRootControl());this.oRtaRootAppComponent=this._getAppComponentForControl(R);this._overrideInstanceFunctions();var m=this._onModeChange.bind(this);r.attachModeChanged(m);}};
d.prototype._onModeChange=function(e){var s,n=e.getParameters().mode;var A=function(p){p.oPopup[s]();};if(n==='navigation'){s=this._getFocusEventName("add");this._applyFocusEventsToOpenPopups(A);}else{s=this._getFocusEventName("remove");this._removeFocusEventsFromOpenPopups(A);}};
d.prototype._applyFocusEventsToOpenPopups=function(e){this._applyPopupMethods(e,true);};
d.prototype._removeFocusEventsFromOpenPopups=function(e){this._applyPopupMethods(e);};
d.prototype._getFocusEventName=function(o){return F[o];};
d.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=I.addDialogInstance;I.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=I.addPopoverInstance;I.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance);};
d.prototype._overrideAddFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){p.attachAfterOpen(this._createPopupOverlays,this);this.fireOpen(p);}return v;}.bind(this);};
d.prototype._applyPopupMethods=function(p,e){var r=this.getRelevantPopups();Object.keys(r).forEach(function(k){if(r[k]){if(e){q.sap.focus(r[k][0].oPopup.oContent);}r[k].forEach(function(o){p.call(this,o);}.bind(this));}}.bind(this));};
d.prototype._applyPopupPatch=function(p){var o=b.getOverlayContainer();var e=p.oPopup;var A=[e.oContent.getDomRef(),o.get(0)].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){A.push(this.getRta().getToolbar().getDomRef());}e.setAutoCloseAreas(A);if(!this.fnOriginalPopupOnAfterRendering){this.fnOriginalPopupOnAfterRendering=e.onAfterRendering;}e.onAfterRendering=function(){var v=this.fnOriginalPopupOnAfterRendering.apply(e,arguments);e[this._getFocusEventName("remove")]();return v;}.bind(this);if(this.getRta().getMode()==='adaptation'){e[this._getFocusEventName("remove")]();}};
d.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=I.removeDialogInstance;I.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=I.removePopoverInstance;I.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance);};
d.prototype._overrideRemoveFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(p);this.fireClose(p);}return v;}.bind(this);};
d.prototype._getAppComponentForControl=function(o){var e,A;if(o instanceof C){e=o;}else{e=this._getComponentForControl(o);}if(e){A=f.getAppComponentForControl(e);}return A;};
d.prototype._getComponentForControl=function(o){var e,r,p;if(o){e=C.getOwnerComponentFor(o);if(!e&&typeof o.getParent==="function"&&o.getParent()instanceof E){p=o.getParent();}else if(e){p=e;}if(p){r=this._getComponentForControl(p);}}return r?r:e;};
d.prototype._createPopupOverlays=function(e){if(!e){return;}var p=(e instanceof E)?e:e.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(p.getId())===-1&&!this._isComponentInsidePopup(p)){this.getRta()._oDesignTime.addRootElement(p);}p.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(p);};
d.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){I.addDialogInstance=this._fnOriginalAddDialogInstance;}if(this._fnOriginalRemoveDialogInstance){I.removeDialogInstance=this._fnOriginalRemoveDialogInstance;}if(this._fnOriginalAddPopoverInstance){I.addPopoverInstance=this._fnOriginalAddPopoverInstance;}if(this._fnOriginalRemovePopoverInstance){I.removePopoverInstance=this._fnOriginalRemovePopoverInstance;}this._applyFocusEventsToOpenPopups(this._removePopupPatch);};
d.prototype._removePopupPatch=function(p){var o=p.oPopup;o[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){o.onAfterRendering=this.fnOriginalPopupOnAfterRendering;}};
d.prototype._isPopupAdaptable=function(p){if(p.isPopupAdaptationAllowed&&!p.isPopupAdaptationAllowed()){return false;}var o=this._getAppComponentForControl(p);return(this.oRtaRootAppComponent===o||this._isComponentInsidePopup(p))&&this._isSupportedPopup(p);};
d.prototype.exit=function(){this._restoreInstanceFunctions();};
return d;},true);
sap.ui.predefine('sap/ui/rta/util/ServiceEventBus',["sap/ui/core/EventBus"],function(E){"use strict";
var S=E.extend("sap.ui.rta.util.ServiceEventBus");
S.prototype._callListener=function(c,l,C,e,d){c.call(l,d);};
S.prototype.getChannel=function(c){return this._mChannels[c];};
return S;});
sap.ui.predefine('sap/ui/rta/util/StylesLoader',['jquery.sap.global'],function(q){"use strict";var m={};
m.loadStyles=function(f){return q.get(q.sap.getModulePath('sap.ui.rta.themes.base.'+f)+'.css').then(function(d){if(sap.ui.getCore().getConfiguration().getRTL()){return d.replace(/right/g,'left');}return d;});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/UrlParser',[],function(q){"use strict";var m={};
m.getParam=function(p){return m.getParams()[p];};
m.getParams=function(){return document.location.search.replace(/^\?/,'').split('&').reduce(function(p,P){var a=P.split('=');var v=a[1];switch(v){case'true':v=true;break;case'false':v=false;break;}p[a[0]]=v;return p;},{});};
return m;},true);
sap.ui.require.preload({
	"sap/ui/rta/appVariant/manageApps/webapp/manifest.json":'{"_version":"1.8.0","sap.app":{"id":"manageApps","type":"application","i18n":"i18n/i18n.properties","applicationVersion":{"version":"1.0.0"},"title":"{{appTitle}}","description":"{{appDescription}}","resources":"resources.json","ach":"ach","sourceTemplate":{"id":"ui5template.basicSAPUI5ApplicationProject","version":"1.40.12"}},"sap.ui":{"technology":"UI5","icons":{"icon":"","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.rta.appVariant.manageApps.webapp.view.ManageApps","type":"XML","async":true},"dependencies":{"minUI5Version":"1.30.0","libs":{"sap.ui.core":{},"sap.m":{},"sap.ui.layout":{},"sap.ui.rta":{}}},"contentDensities":{"compact":true,"cozy":true},"models":{"i18n":{"type":"sap.ui.model.resource.ResourceModel","settings":{"bundleName":"sap.ui.rta.appVariant.manageApps.webapp.i18n.i18n"}}},"resources":{"css":[{"uri":"css/style.css"}]}}}',
	"sap/ui/rta/appVariant/manageApps/webapp/view/ManageApps.view.xml":'<mvc:View controllerName="sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns="sap.m"><Table id="Table1" showNoData="false" inset="false" growing="true" growingThreshold="500" items="{/appVariants}"><columns><Column width="6em" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_APP_TYPE}"/></Column><Column width="2em" minScreenWidth="tablet" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ICON}"/></Column><Column width="12em" minScreenWidth="tablet" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_TITLE_SUBTITLE}"/></Column><Column width="12em" minScreenWidth="tablet" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_DESCRIPTION}"/></Column><Column width="4em" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Center"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_COPY_ID_ACTION}"/></Column><Column width="4em" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Center"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ADAPT_UI_ACTION}"/></Column><Column width="4em" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Center"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_SAVE_AS_ACTION}"/></Column></columns><items><ColumnListItem highlight="{path:\'currentStatus\',formatter:\'.formatRowHighlight\'}"><cells><ObjectIdentifier title="{typeOfApp}" text="{currentStatus}"/><core:Icon src="{icon}" class="sapUiListTableIconSize"/><ObjectIdentifier title="{title}" text="{subTitle}"/><Text text="{description}"/><Button text="{i18n&gt;MAA_DIALOG_COPY_ID}" press="copyId"/><Button text="{i18n&gt;MAA_DIALOG_ADAPT_UI}" enabled="{adaptUIButtonVisibility}" press="handleUiAdaptation" visible="{isKeyUser}"/><Button text="{i18n&gt;MAA_DIALOG_SAVE_AS_APP}" tooltip="{i18n&gt;TOOLTIP_MAA_DIALOG_SAVE_AS_APP}" press="saveAsAppVariant" visible="{isKeyUser}"/></cells></ColumnListItem></items></Table></mvc:View>',
	"sap/ui/rta/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.rta","type":"library","embeds":["appVariant/manageApps/webapp"],"applicationVersion":{"version":"1.56.5"},"title":"SAPUI5 library with RTA controls.","description":"SAPUI5 library with RTA controls.","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.56","libs":{"sap.ui.core":{"minVersion":"1.56.5"},"sap.ui.layout":{"minVersion":"1.56.5"},"sap.m":{"minVersion":"1.56.5"},"sap.ui.fl":{"minVersion":"1.56.5"},"sap.ui.dt":{"minVersion":"1.56.5"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":[],"elements":[],"types":[],"interfaces":[]}}}}',
	"sap/ui/rta/view/RemoveElementDialog.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns:commons="sap.ui.commons" xmlns:layout="sap.ui.layout" xmlns:sap.m="sap.m"><sap.m:Dialog class="sapUiRtaConfirmationDialog" verticalScrolling="false" title="{/titleText}" icon="{/icon}"><layout:VerticalLayout width="100%"><commons:TextView class="sapUiRtaConfirmationDialogText" text="{/messageText}"/></layout:VerticalLayout><sap.m:beginButton><sap.m:Button class="sapUiRtaConfirmationDialogRemoveButton" text="{/removeText}" press="removeField"/></sap.m:beginButton><sap.m:endButton><sap.m:Button class="sapUiRtaConfirmationDialogCancelButton" text="{/cancelText}" press="closeDialog"/></sap.m:endButton></sap.m:Dialog></core:FragmentDefinition>'
},"sap/ui/rta/library-preload"
);
//# sourceMappingURL=library-preload.js.map