/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/rta/plugin/Plugin','sap/ui/rta/plugin/RenameHandler','sap/ui/rta/Utils','sap/ui/dt/ElementOverlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/OverlayUtil','sap/ui/fl/changeHandler/BaseTreeModifier','sap/ui/fl/Utils','sap/ui/fl/variants/VariantManagement','sap/ui/base/ManagedObject','sap/m/delegate/ValueStateMessage','sap/ui/rta/command/CompositeCommand'],function(P,R,U,E,O,a,B,f,V,M,b,C){"use strict";E.prototype._variantManagement=undefined;E.prototype.getVariantManagement=function(){return this._variantManagement;};E.prototype.setVariantManagement=function(k){this._variantManagement=k;};E.prototype.hasVariantManagement=function(){return this._variantManagement?true:false;};var c=P.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string",variantManagementControlOverlay:{type:"any"}},associations:{},events:{}}});c.MODEL_NAME="$FlexVariants";c.prototype.registerElementOverlay=function(o){var d=o.getElement(),m=this._getVariantModel(d),v;P.prototype.registerElementOverlay.apply(this,arguments);if(!m){return;}if(d instanceof V){var d=o.getElement(),A=d.getFor(),e;v=B.getSelector(d,f.getComponentForControl(d)).id;if(!A||(Array.isArray(A)&&A.length===0)){o.setVariantManagement(v);return;}if(!this._isPersonalizationMode()){m._setModelPropertiesForControl(v,true,d);m.checkUpdate(true);}e=!jQuery.isArray(A)?[A]:A;e.forEach(function(s){var g=s instanceof M?s:sap.ui.getCore().byId(s),h=O.getOverlay(g);this._propagateVariantManagement(h,v);}.bind(this));o.attachEvent("editableChange",R._manageClickEvent,this);}else if(!o.getVariantManagement()){v=this._getVariantManagementFromParent(o);if(v){o.setVariantManagement(v);o.attachEvent("editableChange",R._manageClickEvent,this);}}};c.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer==="USER";};c.prototype._propagateVariantManagement=function(p,v){var e=[];p.setVariantManagement(v);e=a.getAllChildOverlays(p);e.forEach(function(o){e=e.concat(this._propagateVariantManagement(o,v));}.bind(this));return e;};c.prototype._getVariantManagementFromParent=function(o){var v=o.getVariantManagement();if(!v&&o.getParentElementOverlay()){return this._getVariantManagementFromParent(o.getParentElementOverlay());}return v;};c.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);var m;var v;var d=o.getElement();if(d instanceof V){m=this._getVariantModel(d);v=o.getVariantManagement();m._setModelPropertiesForControl(v,false,d);m.checkUpdate(true);}this.removeFromPluginsList(o);P.prototype.deregisterElementOverlay.apply(this,arguments);};c.prototype._getVariantModel=function(e){var A=f.getAppComponentForControl(e);return A?A.getModel(c.MODEL_NAME):undefined;};c.prototype._isEditable=function(o){if(this._isPersonalizationMode()){return false;}return this._isVariantManagementControl(o);};c.prototype._isVariantManagementControl=function(o){var e=o.getElement(),A=e.getAssociation("for");return!!(A&&e instanceof V);};c.prototype.isVariantSwitchAvailable=function(o){return this._isVariantManagementControl(o);};c.prototype.isVariantSwitchEnabled=function(o){var v=[];if(this._isVariantManagementControl(o)){var e=o.getElement(),s=o.getVariantManagement?o.getVariantManagement():undefined;if(!s){return false;}var m=this._getVariantModel(e);if(m){v=m.getData()[s].variants.reduce(function(r,g){if(g.visible){return r.concat(g);}else{return r;}},[]);}var d=v.length>1;return d;}else{return false;}};c.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};c.prototype.isRenameAvailable=function(o){return this._isVariantManagementControl(o);};c.prototype.isRenameEnabled=function(o){return this._isVariantManagementControl(o);};c.prototype.isVariantDuplicateAvailable=function(o){return this._isVariantManagementControl(o);};c.prototype.isVariantDuplicateEnabled=function(o){var v=o.getVariantManagement?o.getVariantManagement():undefined;if(!v||!this._isVariantManagementControl(o)){return false;}return true;};c.prototype.isVariantConfigureAvailable=function(o){return this._isVariantManagementControl(o);};c.prototype.isVariantConfigureEnabled=function(o){return this._isVariantManagementControl(o);};c.prototype.switchVariant=function(t,n,s){var d=t.getDesignTimeMetadata(),T=t.getElement();var S=this.getCommandFactory().getCommandFor(T,"switch",{targetVariantReference:n,sourceVariantReference:s},d);this.fireElementModified({"command":S});};c.prototype.renameVariant=function(o){this.setVariantManagementControlOverlay(o[0]);this.startEdit(o[0]);};c.prototype.startEdit=function(o){var v=o.getElement(),d=o.getDesignTimeMetadata().getDomRef();var e=v.getTitle();var p=e.getText();var h=R.startEdit.bind(this,{overlay:o,domRef:d,pluginMethodName:"plugin.ControlVariant.startEdit"});if(o._triggerDuplicate){var s=this._getVariantTitleForCopy(p,o.getVariantManagement(),this._getVariantModel(v).getData());v.getTitle().setText(s);o.attachEventOnce("geometryChanged",function(){h();},this);}else{h();}};c.prototype.stopEdit=function(r){if(this._oEditedOverlay._triggerDuplicate){this._oEditedOverlay.getElementInstance().getTitle().getBinding("text").refresh(true);if(!this._oEditedOverlay.hasStyleClass("sapUiRtaErrorBg")){delete this._oEditedOverlay._triggerDuplicate;}}R._stopEdit.call(this,r,"plugin.ControlVariant.stopEdit");};c.prototype.isBusy=function(){return this._bPreventMenu;};c.prototype._createDuplicateCommand=function(p){var d=this.getCommandFactory().getCommandFor(p.element,"duplicate",{sourceVariantReference:p.currentVariantReference,newVariantTitle:p.newVariantTitle},p.designTimeMetadata,p.variantManagementReference);return d;};c.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this),o=this._oEditedOverlay,d=o.getDesignTimeMetadata(),r=o.getElement(),m=this._getVariantModel(r),e,g,v=o.getVariantManagement(),T=this.getOldValue()!==t,n=T||o._triggerDuplicate,D=n?m._getVariantTitleCount(t,v):0,h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta"),s=m.getCurrentVariantReference(v);o.removeStyleClass("sapUiRtaErrorBg");if(this._oValueStateMessage){this._oValueStateMessage.getPopup().attachClosed(function(){r.$().css("z-index",1);});this._oValueStateMessage.close();}if(t==='\xa0'){e="BLANK_ERROR_TEXT";}else if(D>0){e="DUPLICATE_ERROR_TEXT";}else if(n){var S=this._createSetTitleCommand({text:t,element:r,designTimeMetadata:d,variantManagementReference:v});if(o._triggerDuplicate){g=new C({commands:[this._createDuplicateCommand({currentVariantReference:s,designTimeMetadata:d,variantManagementReference:v,element:r,newVariantTitle:this.getOldValue()})]});if(T){g.addCommand(S);}}else{g=S;}this.fireElementModified({"command":g});return g;}else{jQuery.sap.log.info("Control Variant title unchanged");}if(e){var i=h.getText(e);this._prepareOverlayForValueState(o,i);o.addStyleClass("sapUiRtaErrorBg");U._showMessageBox("ERROR","BLANK_DUPLICATE_TITLE_TEXT",e).then(function(){if(!this._oValueStateMessage){this._oValueStateMessage=new b(o);this._oValueStateMessage.getPopup()._deactivateFocusHandle();}this._oValueStateMessage.open();this.startEdit(o);}.bind(this));}};c.prototype._getVariantTitleForCopy=function(s,v,d){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var e=r.getText("VARIANT_COPY_SINGLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)");var g=r.getText("VARIANT_COPY_MULTIPLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)").replace("\\{1\\}","([0-9]+)");var h=new RegExp(e+"+");var i=new RegExp(g);var t;var I=g.lastIndexOf("(.*)")>g.lastIndexOf("([0-9]+)")?1:2;var j=(I===1)?2:1;var T=0;if(i.test(s)){t=i.exec(s)[j];}else{t=h.test(s)?h.exec(s)[1]:s;}var k=[];d[v].variants.forEach(function(o){if(o.visible){k=i.test(o.title)?i.exec(o.title):h.exec(o.title);if(!k){return;}if(k.length===3&&t===k[j]){T=k[I]?(parseInt(k[I],10)+1):T;}else if(k.length===2&&t===k[1]){T=T===0?1:T;}}});return T>0?r.getText("VARIANT_COPY_MULTIPLE_TEXT",[t,T]):r.getText("VARIANT_COPY_SINGLE_TEXT",[t]);};c.prototype._createSetTitleCommand=function(p){var s;this._$oEditableControlDomRef.text(p.text);try{s=this.getCommandFactory().getCommandFor(p.element,"setTitle",{newText:p.text},p.designTimeMetadata,p.variantManagementReference);}catch(e){jQuery.sap.log.error("Error during rename : ",e);}return s;};c.prototype._prepareOverlayForValueState=function(o,v){o.getValueState=function(){return"Error";};o.getValueStateText=function(){return v;};o.getDomRefForValueStateMessage=function(){return this.$();};};c.prototype.configureVariants=function(o){var v=o[0].getElement();var s=o[0].getVariantManagement();var m=this._getVariantModel(v);var d=o[0].getDesignTimeMetadata();m.manageVariants(v,s,this.getCommandFactory().getFlexSettings().layer).then(function(e){var g=this.getCommandFactory().getCommandFor(v,"configure",{control:v,changes:e},d,s);this.fireElementModified({"command":g});}.bind(this));};c.prototype.getMenuItems=function(o){var m=[];if(this.isRenameAvailable(o)){m.push({id:"CTX_VARIANT_SET_TITLE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_RENAME'),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:210,icon:"sap-icon://edit"});}if(this.isVariantDuplicateAvailable(o)){m.push({id:"CTX_VARIANT_DUPLICATE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_DUPLICATE'),handler:function(e){e[0]._triggerDuplicate=true;this.renameVariant(e);}.bind(this),enabled:this.isVariantDuplicateEnabled.bind(this),rank:220,icon:"sap-icon://duplicate"});}if(this.isVariantConfigureAvailable(o)){m.push({id:"CTX_VARIANT_MANAGE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_MANAGE'),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:230,icon:"sap-icon://action-settings"});}if(this.isVariantSwitchAvailable(o)){var d=this._getVariantModel(o.getElement());var s=o.getVariantManagement();var S=d.getData()[s].variants.reduce(function(r,v){if(v.visible){var e=d.getData()[s].currentVariant===v.key;var i={id:v.key,text:v.title,icon:e?"sap-icon://accept":"blank",enabled:!e};return r.concat(i);}else{return r;}},[]);m.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_SWITCH'),handler:function(e,p){var g=p.eventItem.data(),t=e[0],n=g.key,h=d.getData()[s].currentVariant;return this.switchVariant(t,n,h);}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:S,rank:240,icon:"sap-icon://switch-views"});}return m;};return c;},true);
