/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/fl/Utils','sap/ui/dt/OverlayRegistry'],function(P,U,F,O){"use strict";var S=P.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});S.prototype._checkDeveloperMode=function(o){if(o.getDesignTimeMetadata()){var d=this.getCommandFactory().getFlexSettings().developerMode;if(d&&this.hasStableId(o)){o.setEditable(true);o.setSelectable(true);this.fireElementEditableChange({editable:true});return true;}}return false;};S.prototype.registerElementOverlay=function(o){if(!this._checkDeveloperMode(o)){o.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(o);}o.attachBrowserEvent("click",this._selectOverlay,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("mousedown",this._onMouseDown,this);o.attachBrowserEvent("mouseover",this._onMouseover,this);o.attachBrowserEvent("mouseleave",this._onMouseleave,this);};S.prototype._onEditableChange=function(e){var o=e.getSource();this._adaptSelectable(o);};S.prototype._adaptSelectable=function(o){var s=o.getEditable();if(o.getSelectable()!==s){o.setSelectable(s);if(!s){this._removePreviousHover();}this.fireElementEditableChange({editable:s});}};S.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._selectOverlay,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("mousedown",this._onMouseDown,this);o.detachBrowserEvent("mouseover",this._onMouseover,this);o.detachBrowserEvent("mouseleave",this._onMouseleave,this);o.detachEditableChange(this._onEditableChange,this);};S.prototype._setFocusOnOverlay=function(o,e){if(o&&o.getSelectable()){o.focus();e.stopPropagation();}};S.prototype._onKeyDown=function(e){var o=U.getFocusedOverlay();if(e.keyCode===jQuery.sap.KeyCodes.ENTER){this._selectOverlay(e);}else if(e.keyCode===jQuery.sap.KeyCodes.ARROW_UP&&e.shiftKey===false&&e.altKey===false){if(o){var p=U.getFocusableParentOverlay(o);this._setFocusOnOverlay(p,e);e.preventDefault();}}else if(e.keyCode===jQuery.sap.KeyCodes.ARROW_DOWN&&e.shiftKey===false&&e.altKey===false){if(o){var f=U.getFirstFocusableDescendantOverlay(o);this._setFocusOnOverlay(f,e);e.preventDefault();}}else if(e.keyCode===jQuery.sap.KeyCodes.ARROW_LEFT&&e.shiftKey===false&&e.altKey===false){if(o){var d=U.getPreviousFocusableSiblingOverlay(o);this._setFocusOnOverlay(d,e);e.preventDefault();}}else if(e.keyCode===jQuery.sap.KeyCodes.ARROW_RIGHT&&e.shiftKey===false&&e.altKey===false){if(o){var n=U.getNextFocusableSiblingOverlay(o);this._setFocusOnOverlay(n,e);e.preventDefault();}}};S.prototype._selectOverlay=function(e){var o=O.getOverlay(e.currentTarget.id);var m=e.metaKey||e.ctrlKey;var t=e.target.className;if(o.getSelectable()&&t.indexOf("sapUiDtOverlay")>-1){if(m){this.getDesignTime().setSelectionMode(sap.ui.dt.SelectionMode.Multi);}o.setSelected(!o.getSelected());if(m){this.getDesignTime().setSelectionMode(sap.ui.dt.SelectionMode.Single);}e.preventDefault();e.stopPropagation();}};S.prototype._onMouseDown=function(e){if(sap.ui.Device.browser.name=="ie"){var t=O.getOverlay(e.target.id);var T=e.target.className==="sapUiDtOverlayScrollContainer";var o=O.getOverlay(e.currentTarget.id);if((T||t instanceof sap.ui.dt.Overlay)&&o instanceof sap.ui.dt.Overlay){if(o.getSelectable()){o.focus();e.stopPropagation();}else{o.getDomRef().blur();}}}};S.prototype._onMouseover=function(e){var o=O.getOverlay(e.currentTarget.id);if(o.isSelectable()){if(o!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=o;o.addStyleClass("sapUiRtaOverlayHover");}e.preventDefault();e.stopPropagation();}};S.prototype._onMouseleave=function(e){var o=O.getOverlay(e.currentTarget.id);if(o.isSelectable()){this._removePreviousHover();e.preventDefault();e.stopPropagation();}};S.prototype._removePreviousHover=function(){if(this._oHoverTarget){this._oHoverTarget.removeStyleClass("sapUiRtaOverlayHover");}delete this._oHoverTarget;};S.prototype.setDesignTime=function(d){if(this.getDesignTime()){this.getDesignTime().detachSelectionChange(this._onDesignTimeSelectionChange,this);}P.prototype.setDesignTime.apply(this,arguments);if(this.getDesignTime()){this.getDesignTime().attachSelectionChange(this._onDesignTimeSelectionChange,this);}};S.prototype._onDesignTimeSelectionChange=function(e){if(this.getDesignTime().getSelectionMode()===sap.ui.dt.SelectionMode.Single){return;}var C=e.getParameter("selection")[e.getParameter("selection").length-1];var s=this.getSelectedOverlays();if(s&&s.length===1){C.setSelected(true);return;}if(!C||this.getDesignTime().getSelectionMode()===sap.ui.dt.SelectionMode.Single){return;}var m=_(s,this.getMultiSelectionRequiredPlugins())&&a(s)&&(b(s,C)||c(s,C));C.setSelected(m);};function _(s,m){var d=m;s.forEach(function(o){var e=o.getEditableByPlugins();d=d.reduce(function(f,p){if(e.indexOf(p)!==-1){f.push(p);}return f;},[]);});return d.length>0;}function a(s){var C=s[s.length-1];var p=s[s.length-2];var o=C.getRelevantContainer();var d=p.getRelevantContainer();return o===d;}function b(s,o){return!s.some(function(d){return d.getParentElementOverlay()!==o.getParentElementOverlay();});}function c(s,o){var d=o.getElement().getMetadata().getName();return!s.some(function(e){var C=e.getElement().getMetadata().getName();return(C!==d);});}return S;},true);
