/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/support/Bootstrap',["jquery.sap.global"],function(q){"use strict";var B={initSupportRules:function(s,d){sap.ui.require(["sap/ui/support/supportRules/Main"],function(M){if(s[0].toLowerCase()==="true"||s[0].toLowerCase()==="silent"){if(d&&d.onReady&&typeof d.onReady==="function"){M.attachEvent("ready",d.onReady);}M.startPlugin(s);if('logSupportInfo'in q.sap.log){q.sap.log.logSupportInfo(true);}}});}};return B;});
sap.ui.predefine('sap/ui/support/library',["sap/ui/core/library"],function(l){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.support",dependencies:["sap.ui.core"],types:["sap.ui.support.Severity"],interfaces:[],controls:[],elements:[],noLibraryCSS:true,version:"1.56.5",extensions:{"sap.ui.support":{internalRules:true}}});sap.ui.support.Severity={Medium:"Medium",High:"High",Low:"Low"};sap.ui.support.Audiences={Control:"Control",Internal:"Internal",Application:"Application"};sap.ui.support.Categories={Accessibility:"Accessibility",Performance:"Performance",Memory:"Memory",Bindings:"Bindings",Consistency:"Consistency",Functionality:"Functionality",Usability:"Usability",DataModel:"DataModel",Usage:"Usage",Other:"Other"};return sap.ui.support;});
sap.ui.predefine('sap/ui/support/supportRules/Analyzer',["jquery.sap.global","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/Constants"],function(q,I,C){"use strict";var A=function(){this.dStartedAt=null;this.dFinishedAt=null;this.iElapsedTime=0;this._iAllowedTimeout=10000;this.reset();};
A.prototype.reset=function(){this._iTotalProgress=0;this._iCompletedRules=0;this._iTotalRules=0;this._bRunning=false;this._aRulePromices=[];};
A.prototype.running=function(){return this._bRunning;};
A.prototype.start=function(r,c,e){var i,t=this;this.dStartedAt=new Date();this._iTotalRules=r.length;this._bRunning=true;r.forEach(function(R){t._aRulePromices.push(new Promise(function(f){try{i=I.createIssueManagerFacade(R);if(R.async){t._runAsyncRule(i,c,e,R,f);}else{R.check(i,c,e);f();t._updateProgress();}}catch(a){t._handleException(a,R.id,f);}}));});return Promise.all(this._aRulePromices).then(function(){t.reset();t.dFinishedAt=new Date();t.iElapsedTime=t.dFinishedAt.getTime()-t.dStartedAt.getTime();});};
A.prototype._handleException=function(e,r,R){var t=e.message||e;var m="["+C.SUPPORT_ASSISTANT_NAME+"] Error while execution rule \""+r+"\": "+t;q.sap.log.error(m);R();this._updateProgress();};
A.prototype._updateProgress=function(){this._iCompletedRules++;this._iTotalProgress=Math.ceil(this._iCompletedRules/this._iTotalRules*100);if(this.onNotifyProgress){this.onNotifyProgress(this._iTotalProgress);}};
A.prototype._runAsyncRule=function(i,c,e,r,R){var t=this,T=false;var a=setTimeout(function(){T=true;t._handleException("Check function timed out",r.id,R);},this._iAllowedTimeout);new Promise(function(f){r.check(i,c,e,f);}).then(function(){if(!T){clearTimeout(a);R();t._updateProgress();}}).catch(function(b){if(!T){clearTimeout(a);t._handleException(b,r.id,R);}});};
A.prototype.getElapsedTimeString=function(){if(!this.iElapsedTime){return"";}var d=new Date(null);d.setHours(0,0,0,0);d.setMilliseconds(this.iElapsedTime);var b=[(d.getHours()<10?"0":"")+d.getHours(),(d.getMinutes()<10?"0":"")+d.getMinutes(),(d.getSeconds()<10?"0":"")+d.getSeconds(),d.getMilliseconds()];return b.join(":");};
return A;},false);
sap.ui.predefine('sap/ui/support/supportRules/Constants',[],function(){"use strict";return{TEMP_RULESETS_NAME:"temporary",SUPPORT_ASSISTANT_NAME:"Support Assistant",LOCAL_STORAGE_TEMP_RULES_KEY:"support-assistant-temprules",LOCAL_STORAGE_SELECTED_RULES_KEY:"support-assistant-selected-rules",LOCAL_STORAGE_SELECTED_CONTEXT_KEY:"support-assistant-settings-selected-context",LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY:"support-assistant-settings-selected-context-components",COOKIE_NAME:"persistence-cookie",SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR:"#bb0000",SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR:"#e78c07",SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR:"#5e696e",SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:"Low",SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:"Medium",SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:"High",SUPPORT_ASSISTANT_EXTENSION:"sap.ui.support",MAX_VISIBLE_ISSUES_FOR_RULE:5,RULESET_LOADING:"Loading ruleset files:",FILTER_VALUE_ALL:"All",RULE_SELECTION_EXPORT_FILE_NAME:"sa-rule-selections"};},true);
sap.ui.predefine('sap/ui/support/supportRules/CoreFacade',[],function(){"use strict";var c=null;
function C(o){c=o;return{getMetadata:function(){return c.getMetadata();},getUIAreas:function(){return c.mUIAreas;},getComponents:function(){return c.mObjects.component;},getModels:function(){return c.oModels;}};}
return C;},true);
sap.ui.predefine('sap/ui/support/supportRules/ExecutionScope',["jquery.sap.global"],function(q){"use strict";var c=null,_=null,e=[];var g={setScope:function(){for(var i in c.mElements){e.push(c.mElements[i]);}}};var d={setScope:function(){var a=sap.ui.getCore().byId(_.parentId);e=a.findAggregatedObjects(true);}};var f={setScope:function(){var s={};_.components.forEach(function(a){var b=c.mObjects.component[a],j=b.findAggregatedObjects(true);j.forEach(function(l){s[l.getId()]=l;});});for(var i in s){if(s.hasOwnProperty(i)){e.push(s[i]);}}}};var h={global:g,subtree:d,components:f};
function k(C){var a=C.getParent().getMetadata().getAggregation(C.sParentAggregationName);return!!a;}
function m(C){var r;if(C.getRootControl){r=C.getRootControl();if(r){return[r].concat(r.findAggregatedObjects(true,k));}}return[];}
function n(C){var P=C.sParentAggregationName,a=C.getParent();if(a&&P){var b=a.getBindingInfo(P);if(b&&C instanceof b.template.getMetadata().getClass()){return true;}else{return n(a);}}return false;}
function o(C){var P=C.sParentAggregationName,a=C.getParent();if(a&&P){var b=a.getBindingInfo(P);if(b&&C instanceof b.template.getMetadata().getClass()){return a.getId();}else{return o(a);}}return null;}
function p(a,b){var r=[];for(var i=0,l=a.length;i<l;i++){for(var j=0,s=b.length;j<s;j++){if(a[i]===b[j]){r.push(a[i]);}}}return r;}
function E(a,b){c=a;e=[];_=b;h[_.type].setScope();return{getElements:function(C){var t=this;var i={"type":null,"public":false,"cloned":true};if(C&&Object.keys(C).length){var j=e;var r={};Object.keys(i).forEach(function(l){if(C.hasOwnProperty(l)){switch(l){case"type":var s=t.getElementsByClassName(C["type"]);j=p(j,s);break;case"public":if(C["public"]===true){var u=t.getPublicElements();j=p(j,u);}break;case"cloned":if(!C["cloned"]){j=j.filter(function(v){var I=n(v);if(I){var L=o(v);if(!r.hasOwnProperty(L)){r[L]=v;}}return(I===false);});}break;}}});Object.keys(r).forEach(function(R){j.push(r[R]);});return j;}return e;},getPublicElements:function(){var P=[];var C=a.mObjects.component;var u=a.mUIAreas;for(var i in C){P=P.concat(m(C[i]));}for(var j in u){P=P.concat(m(u[j]));}return P;},getElementsByClassName:function(i){if(typeof i==="string"){return e.filter(function(j){return j.getMetadata().getName()===i;});}if(typeof i==="function"){return e.filter(function(j){return j instanceof i;});}},getLoggedObjects:function(t){var l=q.sap.log.getLogEntries(),i=[];l.forEach(function(j){if(!j.supportInfo){return;}var r=e.map(function(w){return w.getId();});var s=!!j.supportInfo.elementId,u=j.supportInfo.type===t||t===undefined,v=!s||q.inArray(j.supportInfo.elementId,r)>-1;if(typeof t==="function"&&t(j)&&v){i.push(j);return;}if(u&&v){i.push(j);}});return i;},_getType:function(){return _.type;},_getContext:function(){return _;}};}
E.possibleScopes=Object.getOwnPropertyNames(h);return E;},true);
sap.ui.predefine('sap/ui/support/supportRules/IssueManager',["jquery.sap.global","sap/ui/base/Object","sap/ui/support/supportRules/Constants"],function(q,B,c){"use strict";var _=[];var a=[];var b=function(i){var e=sap.ui.getCore().byId(i.context.id),f="";if(i.context.id==="WEBPAGE"){f="sap.ui.core";}else if(e){f=e.getMetadata().getName();}return{severity:i.severity,name:i.rule.title,description:i.rule.description,resolution:i.rule.resolution,resolutionUrls:i.rule.resolutionurls,audiences:i.rule.audiences,categories:i.rule.categories,details:i.details,ruleLibName:i.rule.libName,ruleId:i.rule.id,async:i.rule.async===true,minVersion:i.rule.minversion,context:{className:f,id:i.context.id}};};var I={addIssue:function(i){_.push(i);},walkIssues:function(C){_.forEach(C);},clearIssues:function(){_=[];},saveHistory:function(){a.push({issues:_.slice()});},getHistory:function(){return a.slice();},getConvertedHistory:function(){var t=this,i=t.getHistory(),e=[],f=null;i.forEach(function(r){f=t.groupIssues(t.convertToViewModel(r.issues));e.push({issues:f});});return e;},getIssuesModel:function(){var v=[];this.walkIssues(function(i){v.push(b(i));});return v;},getRulesViewModel:function(r,s,i){var e={},f=0,g={},l={},h={},j=q.extend(true,{},r),k=q.extend(true,{},i);for(g in j){e[g]=q.extend(true,{},j[g].ruleset._mRules);l=e[g];Object.defineProperty(l,'selected',{enumerable:false,configurable:true,writable:true,value:false});Object.defineProperty(l,'issueCount',{enumerable:false,configurable:true,writable:true,value:0});for(h in j[g].ruleset._mRules){l[h]=q.extend(true,[],l[h]);Object.defineProperty(l[h],'selected',{enumerable:false,configurable:true,writable:true,value:false});Object.defineProperty(l[h],'issueCount',{enumerable:false,configurable:true,writable:true,value:0});if(s[h]){l[h].selected=true;l.selected=true;}if(k[g]&&k[g][h]){l[h].push.apply(l[h],k[g][h]);f=k[g][h].length;l[h].issueCount=f;l.issueCount+=f;}}}return e;},getTreeTableViewModel:function(r){var i=0,e=0,t={},f,g;f=this.getRulesViewModel(r,[],[]);for(var l in f){t[i]={name:l,type:"lib",rules:[]};for(var h in f[l]){g=f[l][h];t[i][e]={name:g.title,description:g.description,id:g.id,audiences:g.audiences,categories:g.categories,minversion:g.minversion,resolution:g.resolution,title:g.title,libName:l};e++;}i++;}return t;},getIssuesViewModel:function(i){var t={},e=0,f=0,g=0,s,h=0,m=0,l=0;for(var j in i){t[e]={name:j,showAudiences:false,showCategories:false,type:"lib"};for(var r in i[j]){s=this._sortSeverityIssuesByPriority(i[j][r]);t[e][f]={formattedName:this._getFormattedName({name:i[j][r][0].name,highCount:s.high,mediumCount:s.medium,lowCount:s.low,highName:'H',mediumName:'M',lowName:'L'}),name:i[j][r][0].name,showAudiences:true,showCategories:true,categories:i[j][r][0].categories.join(", "),audiences:i[j][r][0].audiences.join(", "),issueCount:i[j][r].length,description:i[j][r][0].description,resolution:i[j][r][0].resolution,type:"rule",ruleLibName:i[j][r][0].ruleLibName,ruleId:i[j][r][0].ruleId,selected:i[j][r][0].selected,details:i[j][r][0].details,severity:i[j][r][0].severity};g+=i[j][r].length;f++;h+=s.high;m+=s.medium;l+=s.low;}t[e].formattedName=this._getFormattedName({name:t[e].name,highCount:h,mediumCount:m,lowCount:l,highName:'High',mediumName:'Medium',lowName:'Low'});t[e].name+=" ("+g+" issues)";t[e].issueCount=g;g=0;f=0;e++;h=0;m=0;l=0;}return t;},_getFormattedName:function(v){var h="",m="",l="";if(v.highCount>0){h="color: "+c.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR+";";}if(v.mediumCount>0){m="color: "+c.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR+";";}if(v.lowCount>0){l="color: "+c.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR+";";}return v.name+" (<span style=\""+h+"\"> "+v.highCount+" "+v.highName+", </span> "+"<span style=\""+m+"\"> "+v.mediumCount+" "+v.mediumName+", </span> "+"<span style=\""+l+"\"> "+v.lowCount+" "+v.lowName+"</span> )";},_sortSeverityIssuesByPriority:function(i){var h=0,m=0,l=0;i.forEach(function(e){switch(e.severity){case c.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:l++;break;case c.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:m++;break;case c.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:h++;break;}});return{high:h,medium:m,low:l};},clearHistory:function(){a=[];},convertToViewModel:function(o){var v=[];for(var i=0;i<o.length;i++){v.push(b(o[i]));}return v;},groupIssues:function(o){var g={},e={};for(var i=0;i<o.length;i++){e=o[i];if(!g[e.ruleLibName]){g[e.ruleLibName]={};}if(!g[e.ruleLibName][e.ruleId]){g[e.ruleLibName][e.ruleId]=[];}g[e.ruleLibName][e.ruleId].push(e);}return g;},createIssueManagerFacade:function(r){return new d(r);}};var d=function(r){this.oRule=r;};
d.prototype.addIssue=function(i){i.rule=this.oRule;if(!sap.ui.support.Severity[i.severity]){throw"The issue from rule "+this.oRule.title+" does not have proper severity defined. Allowed values can be found"+"in sap.ui.support.Severity";}if(!i.context||!i.context.id){throw"The issue from rule '"+this.oRule.title+"' should provide a context id.";}if(!i.details){throw"The issue from rule '"+this.oRule.title+"' should provide details for the generated issue.";}I.addIssue(i);};
return I;},true);
sap.ui.predefine('sap/ui/support/supportRules/Main',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/Analyzer","sap/ui/support/supportRules/CoreFacade","sap/ui/support/supportRules/ExecutionScope","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/RuleSet","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/report/DataCollector","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSetLoader","sap/ui/support/supportRules/report/AnalysisHistoryFormatter"],function(q,M,J,A,C,E,H,a,R,b,I,D,c,d,f,g){"use strict";var h=null;var m=null;
var j=M.extend("sap.ui.support.Main",{constructor:function(){if(!m){var t=this;this._oCore=null;this._oAnalyzer=new A();this._oAnalyzer.onNotifyProgress=function(i){a.publish(c.ON_PROGRESS_UPDATE,{currentProgress:i});};f._initTempRulesLib();M.apply(this,arguments);q.sap.support={analyze:function(o,r){if(f._rulesCreated){return m.analyze(o,r);}return f._oMainPromise.then(function(){return m.analyze(o,r);});},getLastAnalysisHistory:function(){var i=this.getAnalysisHistory();if(q.isArray(i)&&i.length>0){return i[i.length-1];}else{return null;}},getAnalysisHistory:function(){if(t._oAnalyzer.running()){return null;}return I.getHistory();},getFormattedAnalysisHistory:function(){if(t._oAnalyzer.running()){return"";}return g.format(I.getConvertedHistory());}};var e=document.createEvent("CustomEvent");e.initCustomEvent("supportToolLoaded",true,true,{});}else{q.sap.log.warning("Only one support tool allowed");return m;}}});
j.prototype._isInIframe=function(){try{return window.self!==window.top;}catch(e){return true;}};
j.prototype.startPlugin=function(s){if(this._pluginStarted){return;}this._pluginStarted=true;var t=this;sap.ui.getCore().registerPlugin({startPlugin:function(o){t._supportModeConfig=s=s||o.getConfiguration().getSupportMode();t._setCommunicationSubscriptions();var F=t._isInIframe()&&s.indexOf("frame-force-ui")!==-1;t._oCore=o;t._oDataCollector=new D(o);t._oCoreFacade=C(o);t._oExecutionScope=null;t._createCoreSpies();o.attachLibraryChanged(f._onLibraryChanged);if(!s||s.indexOf("silent")===-1||F){sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"],function(e){h=e;h.injectFrame(s);a.onMessageChecks.push(function(i){return i.origin===h.getFrameOrigin();});a.onMessageChecks.push(function(i){return i.data._frameIdentifier===h.getFrameIdentifier();});a.onMessageChecks.push(function(i){var k=h.getFrameUrl();k=k.replace(/\.\.\//g,'');return i.data._origin.indexOf(k)>-1;});});}else{f.updateRuleSets(function(){t.fireEvent("ready");});}},stopPlugin:function(){h._stop();t._pluginStarted=false;t._oCore=null;t._oCoreFacade=null;t._oDataCollector=null;t._oExecutionScope=null;}});};
j.prototype._createCoreSpies=function(){var t=this,n=500;this._fnDirtyTimeoutHandle=null;var s=function(N){var o=t._oCore[N];t._oCore[N]=function(){o.apply(t._oCore,arguments);clearTimeout(t._fnDirtyTimeoutHandle);t._fnDirtyTimeoutHandle=setTimeout(function(){a.publish(c.ON_CORE_STATE_CHANGE);},n);};};s("registerElement");s("deregisterElement");};
j.prototype._setCommunicationSubscriptions=function(){if(this._supportModeConfig.indexOf("silent")<0){a.subscribe(c.VERIFY_CREATE_RULE,function(t){var e=R.deserialize(t),i=f.getRuleSet(d.TEMP_RULESETS_NAME).ruleset,r=i.addRule(e);a.publish(c.VERIFY_RULE_CREATE_RESULT,{result:r,newRule:R.serialize(e)});},this);a.subscribe(c.VERIFY_UPDATE_RULE,function(e){var t=R.deserialize(e.updateObj),i=f.getRuleSet(d.TEMP_RULESETS_NAME).ruleset,r=i.updateRule(e.oldId,t);a.publish(c.VERIFY_RULE_UPDATE_RESULT,{result:r,updateRule:R.serialize(t)});},this);a.subscribe(c.OPEN_URL,function(u){var w=window.open(u,"_blank");w.focus();},this);a.subscribe(c.ON_DOWNLOAD_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.downloadReportZip(e);});},this);a.subscribe(c.HIGHLIGHT_ELEMENT,function(i){var $=sap.ui.getCore().byId(i).$();$.css("background-color","red");},this);a.subscribe(c.TREE_ELEMENT_MOUSE_ENTER,function(e){H.highlight(e);},this);a.subscribe(c.TREE_ELEMENT_MOUSE_OUT,function(){H.hideHighLighter();},this);a.subscribe(c.TOGGLE_FRAME_HIDDEN,function(e){h.toggleHide(e);},this);}a.subscribe(c.POST_UI_INFORMATION,function(e){this._oDataCollector.setSupportAssistantLocation(e.location);this._oDataCollector.setSupportAssistantVersion(e.version);},this);a.subscribe(c.GET_AVAILABLE_COMPONENTS,function(){a.publish(c.POST_AVAILABLE_COMPONENTS,Object.keys(this._oCore.mObjects.component));},this);a.subscribe(c.ON_ANALYZE_REQUEST,function(e){this.analyze(e.executionContext,e.selectedRules);},this);a.subscribe(c.ON_INIT_ANALYSIS_CTRL,function(){f.updateRuleSets(function(){this.fireEvent("ready");}.bind(this));},this);a.subscribe(c.ON_SHOW_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.openReport(e);});},this);a.subscribe(c.LOAD_RULESETS,function(e){f.loadAdditionalRuleSets(e.aLibNames);},this);a.subscribe(c.REQUEST_RULES_MODEL,function(e){if(e){a.publish(c.GET_RULES_MODEL,I.getTreeTableViewModel(e));}},this);a.subscribe(c.REQUEST_ISSUES,function(i){if(i){var e=I.groupIssues(i),k=I.getIssuesViewModel(e);a.publish(c.GET_ISSUES,{groupedIssues:e,issuesModel:k});}},this);a.subscribe(c.GET_NON_LOADED_RULE_SETS,function(){f.fetchNonLoadedRuleSets();},this);};
j.prototype.analyze=function(e,r){var t=this;if(this._oAnalyzer&&this._oAnalyzer.running()){return;}e=e||{type:"global"};r=r||f.getAllRuleDescriptors();if(!this._isExecutionScopeValid(e)){return;}a.publish(c.ON_ANALYZE_STARTED);if(e.selectors){this._mapExecutionScope(e);}this._oAnalyzer.reset();this.setExecutionScope(e);I.clearIssues();this._setSelectedRules(r);return this._oAnalyzer.start(this._aSelectedRules,this._oCoreFacade,this._oExecutionScope).then(function(){t._done();});};
j.prototype._isExecutionScopeValid=function(e){var o=sap.ui.getCore(),s=[],k=false,i;if(E.possibleScopes.indexOf(e.type)===-1){q.sap.log.error("Invalid execution scope type. Type must be one of the following: "+E.possibleScopes.join(", "));return false;}if(e.type=="subtree"){if(e.parentId){s.push(e.parentId);}else if(q.isArray(e.selectors)){q.merge(s,e.selectors);}else if(e.selectors){s.push(e.selectors);}for(i=0;i<s.length;i++){if(o.byId(s[i])){k=true;break;}}if(!k){a.publish(c.POST_MESSAGE,{message:"Set a valid element ID."});return false;}}return true;};
j.prototype.setExecutionScope=function(s){this._oExecutionScope=E(this._oCore,s);};
j.prototype._setSelectedRules=function(r){this._aSelectedRules=[];this._oSelectedRulesIds={};if(!r){return;}if(!Array.isArray(r)){r=[r];}r.forEach(function(o){var e,i;if(!o.libName||!o.ruleId){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Invalid Rule Descriptor.");return;}e=f.getRuleSet(o.libName);if(!e||!e.ruleset){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Ruleset for library "+o.libName);return;}i=e.ruleset.getRules();if(!i||!i[o.ruleId]){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Rule with id "+o.ruleId+" for library "+o.libName);return;}this._aSelectedRules.push(i[o.ruleId]);this._oSelectedRulesIds[o.ruleId]=true;},this);};
j.prototype._mapExecutionScope=function(e){if(e.type==="subtree"){if(typeof e.selectors==="string"){e.parentId=e.selectors;}else if(Array.isArray(e.selectors)){e.parentId=e.selectors[0];}}else if(e.type==="components"){if(typeof e.selectors==="string"){e.components=[e.selectors];}else if(Array.isArray(e.selectors)){e.components=e.selectors;}}delete e.selectors;};
j.prototype._done=function(){var i=I.getIssuesModel(),e=this._createElementTree();a.publish(c.ON_ANALYZE_FINISH,{issues:i,elementTree:e,elapsedTime:this._oAnalyzer.getElapsedTimeString()});I.saveHistory();};
j.prototype._createElementTree=function(){var e=this._copyElementsStructure(),k=[];this._setContextElementReferences(e);for(var i in e){if(e[i].skip){continue;}k.push(e[i]);}return[{content:k,id:"WEBPAGE",name:"WEBPAGE"}];};
j.prototype._setContextElementReferences=function(o){var e=this._oCore.mElements;for(var i in o){var k=o[i],p=e[i]==undefined?undefined:e[i].getParent();if(e[i]instanceof sap.ui.core.ComponentContainer){var l=e[i],n=l.getComponent();if(n){k.content.push(o[n]);o[n].skip=true;}}if(p){var r=p.getId();if(!o[r]){continue;}o[r].content.push(o[i]);o[i].skip=true;}}};
j.prototype._copyElementsStructure=function(){var e={},t=this;var k=function(n,o){for(var i in n){if(n.hasOwnProperty(i)){var r=n[i];var s={content:[],id:r.getId(),name:(o==undefined)?r.getMetadata().getName():o};e[r.getId()]=s;}}};k(this._oExecutionScope.getElements());this._oExecutionScope.getElements().forEach(function(i){if(i instanceof sap.ui.core.ComponentContainer){var n=i.getComponent(),o=t._oCore.mObjects.component[n];if(o){k([o],"sap-ui-component");}}});switch(this._oExecutionScope._getType()){case"global":k(this._oCoreFacade.getUIAreas(),"sap-ui-area");k(this._oCoreFacade.getComponents(),"sap-ui-component");break;case"subtree":var p=this._oExecutionScope._getContext().parentId;k([this._oCore.mElements[p]]);break;case"components":var l=this._oExecutionScope._getContext().components;l.forEach(function(i){k([t._oCore.mObjects.component[i]],"sap-ui-component");});break;}return e;};
j.prototype._getReportData=function(r){var i=I.groupIssues(I.getIssuesModel()),e=f.getRuleSets(),s=this._oSelectedRulesIds;return{issues:i,technical:this._oDataCollector.getTechInfoJSON(),application:this._oDataCollector.getAppInfo(),rules:I.getRulesViewModel(e,s,i),scope:{executionScope:this._oExecutionScope,scopeDisplaySettings:{executionScopes:r.executionScopes,executionScopeTitle:r.executionScopeTitle}},analysisDuration:this._oAnalyzer.getElapsedTimeString(),analysisDurationTitle:r.analysisDurationTitle,name:d.SUPPORT_ASSISTANT_NAME};};
var m=new j();return m;},true);
sap.ui.predefine('sap/ui/support/supportRules/RuleSerializer',[],function(){"use strict";return{serialize:function serializeRule(r){var a=function(k,v){if(typeof v==="function"){return v.toString();}else{return v;}};var b=JSON.stringify(r,a);return b;},deserialize:function(serializedRule,stringifyCheck){var rule;if(typeof serializedRule==='string'){rule=JSON.parse(serializedRule);}else{rule=serializedRule;}if(!stringifyCheck&&rule.check!==undefined){eval("rule.check = "+rule.check);}return rule;}};},true);
sap.ui.predefine('sap/ui/support/supportRules/RuleSet',["jquery.sap.global","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/Constants"],function(q,s,c){"use strict";var r={};var R=function(S){S=S||{};if(!S.name){q.sap.log.error("Please provide a name for the RuleSet.");}if(r[S.name]){return r[S.name];}this._oSettings=S;this._mRules={};r[S.name]=this;};
R.clearAllRuleSets=function(){r={};};
R.prototype.getRules=function(){return this._mRules;};
R.prototype.updateRule=function(a,O){var b=this._verifySettingsObject(O,true);if(b==="success"){delete this._mRules[a];this._mRules[O.id]=O;}return b;};
R.prototype._verifySettingsObject=function(S,u){if(!S.id){q.sap.log.error("Support rule needs an id.");return"Support rule needs an unique id.";}if(!u&&this._mRules[S.id]){q.sap.log.error("Support rule with the id "+S.id+" already exists.");return"Support rule with the id "+S.id+" already exists.";}if(!S.check){q.sap.log.error("Support rule with the id "+S.id+" needs a check function.");return"Support rule with the id "+S.id+" needs a check function.";}if(!S.title){q.sap.log.error("Support rule with the id "+S.id+" needs a title.");return"Support rule with the id "+S.id+" needs a title.";}if(!S.description){q.sap.log.error("Support rule with the id "+S.id+" needs a description.");return"Support rule with the id "+S.id+" needs a description.";}if(!S.resolution&&(!S.resolutionurls||!S.resolutionurls.length>0)){q.sap.log.error("Support rule with the id "+S.id+" needs either a resolution or resolutionurls or should have a ticket handler function");return"Support rule with the id "+S.id+" needs either a resolution or resolutionurls or should have a ticket handler function";}if(!S.audiences||S.audiences.length===0){q.sap.log.error("Support rule with the id "+S.id+" should have an audience. Applying audience ['Control']");S.audiences=[sap.ui.support.Audiences.Control];}if(S.audiences&&S.audiences.forEach){var i=false,a="";S.audiences.forEach(function(b){if(!sap.ui.support.Audiences[b]){i=true;a=b;}});if(i){q.sap.log.error("Audience "+a+" does not exist. Please use the audiences from sap.ui.support.Audiences");return"Audience "+a+" does not exist. Please use the audiences from sap.ui.support.Audiences";}}if(!S.categories||S.categories.length===0){q.sap.log.error("Support rule with the id "+S.id+" should have a category. Applying category ['Performance']");S.categories=["Performance"];}if(S.categories&&S.categories.forEach){var I=false,C="";S.categories.forEach(function(b){if(!sap.ui.support.Categories[b]){I=true;C=b;}});if(I){q.sap.log.error("Category "+C+" does not exist. Please use the categories from sap.ui.support.Categories");return"Category "+C+" does not exist. Please use the categories from sap.ui.support.Categories";}}return"success";};
R.prototype.addRule=function(S){var C=R.versionInfo?R.versionInfo.version:'';var a=S.minversion?S.minversion:'';if(a==='-'){a='';}if(a&&q.sap.Version(C).compareTo(a)<0){return"Rule "+S.id+" should be used with a version >= "+S.minversion;}var b=this._verifySettingsObject(S);if(b==="success"){this._mRules[S.id]=S;S.libName=this._oSettings.name;}return b;};
R.addToTempRules=function(l,t){if(t){t.forEach(function(a){var b=a.id;l[c.TEMP_RULESETS_NAME].RuleSet._mRules[b]=a;});}};
R.storeSelectionOfRules=function(l){var a=R._extractRulesSettingsToSave(l);s.setSelectedRules(a);};
R.loadSelectionOfRules=function(l){var a=s.getSelectedRules();if(!a){return;}for(var i=0;i<l.length;i+=1){var b=l[i].rules;var d=l[i].title;for(var e=0;e<b.length;e+=1){if(a[d]&&a[d].hasOwnProperty(b[e].id)){b[e].selected=a[d][b[e].id].selected;}}}};
R._extractRulesSettingsToSave=function(l){var L={};var a;var b=l.length;var d;var e;var f;for(var g=0;g<b;g+=1){e=l[g].title;L[e]={};a=l[g].rules;d=a.length;for(var h=0;h<d;h+=1){f={};f.id=a[h].id;f.selected=a[h].selected;L[e][f.id]=f;}}return L;};
return R;},true);
sap.ui.predefine('sap/ui/support/supportRules/RuleSetLoader',["jquery.sap.global","sap/ui/support/supportRules/RuleSet","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/util/Utils"],function(q,R,C,c,b,d,U){"use strict";var g=(function(){var a;return function(u){if(!a){a=document.createElement('a');}a.href=u;return a.href;};})();var s="sprt";var S=q.sap.getModulePath("sap.ui.support");var f=S.replace('/sap/ui/support','');var A=g(f);var h;var j={};j._mRuleSets={};
j.getRuleSets=function(){return this._mRuleSets;};
j.addRuleSet=function(l,r){this._mRuleSets[l]=r;};
j.getRuleSet=function(l){return this._mRuleSets[l];};
j._fetchSupportRuleSets=function(r){var t=this,l=sap.ui.getCore().getLoadedLibraries(),L=this._fetchLibraryNamesWithSupportRules(l);if(typeof h==="undefined"){h=!U.isDistributionOpenUI5(sap.ui.getVersionInfo())&&U.canLoadInternalRules();}var m=new Promise(function(a){R.versionInfo=sap.ui.getVersionInfo();L.then(function(o){var e=t._fetchLibraryFiles(o,j._fetchRuleSet);Promise.all(e).then(function(){t._bRulesCreated=true;C.publish(c.UPDATE_SUPPORT_RULES,b.serialize(t._mRuleSets));a();if(r&&typeof r==="function"){r();}});});});return m;};
j.loadAdditionalRuleSets=function(l){var t=this,L=t._fetchLibraryFiles(l,t._fetchRuleSet);Promise.all(L).then(function(){t._bRulesCreated=true;C.publish(c.UPDATE_SUPPORT_RULES,b.serialize(t._mRuleSets));});};
j._fetchLibraryNamesWithSupportRules=function(l){return new Promise(function(m){var L={publicRules:[],internalRules:[]};l=l||{};var a=[];Object.keys(l).forEach(function(e){var M=new Promise(function(r){var i=A+"/"+e.replace(/\./g,'/')+"/.supportrc";q.ajax({type:"GET",dataType:"json",url:i,success:function(k){r({lib:e,rcData:k});},error:function(){r({lib:e,rcData:null});}});});a.push(M);});Promise.all(a).then(function(e){e.forEach(function(i){if(i.rcData){if(i.rcData.publicRules){L.publicRules.push(i.lib);}if(i.rcData.internalRules){L.internalRules.push(i.lib);}}m(L);});});});};
j._fetchLibraryFiles=function(l,p,a){var e=[],t=this,i=q.sap.getModulePath("sap.ui.support"),k=i.replace("sap/ui/support",""),H=h&&l.internalRules.length>0,P=0,r=l.publicRules.length;var m=sap.ui.getCore().getConfiguration().getSupportMode();var n=m&&m.indexOf("silent")>-1;if(H){r+=l.internalRules.length;}function o(){P+=1;var u=Math.ceil((P/r)*100);C.publish(c.CURRENT_LOADING_PROGRESS,{value:u});}if(l.publicRules.length>0){l.publicRules.forEach(function(L){var u=t._registerLibraryPath(L,i,k);if(u){var v=t._requireRuleSet(u.customizableLibName,p);if(!n&&!a){v.then(function(){o();});}e.push(v);}});}if(h&&l.internalRules.length>0){l.internalRules.forEach(function(L){var u=t._registerLibraryPath(L,i,k);if(u){var v=t._requireRuleSet(u.internalLibName,p);if(!n&&!a){v.then(function(){o();});}e.push(v);}});}return e;};
j._registerLibraryPath=function(l,a,e){if(this._mRuleSets[l]){return null;}var i=l.replace(/\./g,"/");var k=l;var m=this._getLoadFromSupportOrigin();if(m){k+='.'+s;q.sap.registerModulePath(k,e+l.replace(/\./g,"/"));}var n=k+'.internal';var o=e.replace('resources/','')+'test-resources/'+i+'/internal';q.sap.registerModulePath(n,o);return{internalLibName:n,customizableLibName:k};};
j._requireRuleSet=function(l,p){var t=this;return new Promise(function(r){try{sap.ui.require([l.replace(/\./g,"/")+"/library.support"],function(){p.call(t,l);r();});}catch(e){r();}});};
j._fetchRuleSet=function(l){try{var n,L,o,a=q.sap.getObject(l).library.support;if(!a){throw"The library.support file was not fetched successfully.";}n=l.replace("."+s,"").replace(".internal","");L=q.extend({},a);o=this._mRuleSets[n];if(!(L.ruleset instanceof R)){L=this._createRuleSet(L);}if(o){o.ruleset._mRules=q.extend(o.ruleset._mRules,L.ruleset._mRules);}else{o=L;}this._mRuleSets[n]=o;}catch(e){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Failed to load RuleSet for "+l+" library",e);}};
j._getLoadFromSupportOrigin=function(){var l=false;var a=new window.URI(q.sap.getModulePath("sap.ui.core"));var e=new window.URI(q.sap.getModulePath("sap.ui.support"));if(a.protocol()!==e.protocol()||a.host()!==e.host()){l=true;}return l;};
j.fetchNonLoadedRuleSets=function(){var l=sap.ui.getVersionInfo().libraries,a=[],L={};l.forEach(function(e){L[e.name]=e;});var o=this._fetchLibraryNamesWithSupportRules(L);o.then(function(e){var i=j._fetchLibraryFiles(e,function(k){k=k.replace("."+s,"").replace(".internal","");if(a.indexOf(k)<0){a.push(k);}},true);Promise.all(i).then(function(){C.publish(c.POST_AVAILABLE_LIBRARIES,{libNames:a});});});};
j._onLibraryChanged=function(e){var t=this;if(e.getParameter("stereotype")==="library"&&j._bRulesCreated){t._oMainPromise=j._fetchSupportRuleSets();}};
j.updateRuleSets=function(r){this._oMainPromise=j._fetchSupportRuleSets(r);};
j._createRuleSet=function(l){var L={name:l.name,niceName:l.niceName};var r=new R(L);for(var i=0;i<l.ruleset.length;i++){var a=l.ruleset[i];if(q.isArray(a)){for(var k=0;k<a.length;k++){r.addRule(a[k]);}}else{r.addRule(a);}}return{lib:L,ruleset:r};};
j._initTempRulesLib=function(){if(this.getRuleSet(d.TEMP_RULESETS_NAME)){return;}this.addRuleSet(d.TEMP_RULESETS_NAME,{lib:{name:d.TEMP_RULESETS_NAME},ruleset:new R({name:d.TEMP_RULESETS_NAME})});};
j.getAllRules=function(){var r={};Object.keys(this._mRuleSets).map(function(l){r=q.extend(r,this._mRuleSets[l].ruleset.getRules());},this);return r;};
j.getAllRuleDescriptors=function(){var r=this.getAllRules();return Object.keys(r).map(function(a){return{libName:r[a].libName,ruleId:a};});};
return j;},true);
sap.ui.predefine('sap/ui/support/supportRules/Storage',["sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants"],function(R,a){"use strict";
function e(D){return window.btoa(unescape(encodeURIComponent(D)));}
function d(D){return decodeURIComponent(escape(window.atob(D)));}
return{getRules:function(){var r=localStorage.getItem(a.LOCAL_STORAGE_TEMP_RULES_KEY);if(!r){return null;}var t=JSON.parse(d(r));t=t.map(function(b){return R.deserialize(b);});return t;},setRules:function(r){var s=e(JSON.stringify(r));localStorage.setItem(a.LOCAL_STORAGE_TEMP_RULES_KEY,s);},getSelectedRules:function(){var r=localStorage.getItem(a.LOCAL_STORAGE_SELECTED_RULES_KEY);if(!r){return null;}return JSON.parse(r);},setSelectedRules:function(s){localStorage.setItem(a.LOCAL_STORAGE_SELECTED_RULES_KEY,JSON.stringify(s));},setSelectedContext:function(s){localStorage.setItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_KEY,JSON.stringify(s));},getSelectedContext:function(){return JSON.parse(localStorage.getItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_KEY));},setSelectedScopeComponents:function(c){localStorage.setItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY,JSON.stringify(c));},getSelectedScopeComponents:function(){var c=localStorage.getItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);return JSON.parse(c);},removeSelectedRules:function(s){this.setRules(s);},removeAllData:function(){localStorage.removeItem(a.LOCAL_STORAGE_TEMP_RULES_KEY);localStorage.removeItem(a.LOCAL_STORAGE_SELECTED_RULES_KEY);localStorage.removeItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_KEY);localStorage.removeItem(a.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);},createPersistenceCookie:function(c,C){document.cookie=c+"="+C;},readPersistenceCookie:function(C){var n=C+"=",b=decodeURIComponent(document.cookie),f=b.split(';'),o="";for(var i=0;i<f.length;i++){var c=f[i];while(c.charAt(0)==' '){c=c.substring(1);}if(c.indexOf(n)==0){o=c.substring(n.length,c.length);return o;}}return o;},deletePersistenceCookie:function(c){document.cookie=c+'=;expires=Thu, 01 Jan 1970 00:00:01 GMT;';}};},true);
sap.ui.predefine('sap/ui/support/supportRules/WCBChannels',[],function(){"use strict";return{ON_CORE_STATE_CHANGE:"ON_CORE_STATE_CHANGE",ON_SHOW_REPORT_REQUEST:"ON_SHOW_REPORT_REQUEST",ON_DOWNLOAD_REPORT_REQUEST:"ON_DOWNLOAD_REPORT_REQUEST",ON_ANALYZE_REQUEST:"ON_ANALYZE_REQUEST",ON_INIT_ANALYSIS_CTRL:"ON_INIT_ANALYSIS_CTRL",ON_PROGRESS_UPDATE:"ON_PROGRESS_UPDATE",ON_ANALYZE_STARTED:"ON_ANALYZE_STARTED",ON_ANALYZE_FINISH:"ON_ANALYZE_FINISH",POST_UI_INFORMATION:"POST_UI_INFORMATION",VERIFY_CREATE_RULE:"VERIFY_CREATE_RULE",VERIFY_RULE_CREATE_RESULT:"VERIFY_RULE_CREATE_RESULT",VERIFY_UPDATE_RULE:"VERIFY_UPDATE_RULE",VERIFY_RULE_UPDATE_RESULT:"VERIFY_RULE_UPDATE_RESULT",POST_AVAILABLE_LIBRARIES:"POST_AVAILABLE_LIBRARIES",LOAD_RULESETS:"LOAD_RULESETS",GET_AVAILABLE_COMPONENTS:"GET_AVAILABLE_COMPONENTS",POST_AVAILABLE_COMPONENTS:"POST_AVAILABLE_COMPONENTS",HIGHLIGHT_ELEMENT:"HIGHLIGHT_ELEMENT",OPEN_URL:"OPEN_URL",TREE_ELEMENT_MOUSE_ENTER:"TREE_ELEMENT_MOUSE_ENTER",TREE_ELEMENT_MOUSE_OUT:"TREE_ELEMENT_MOUSE_OUT",UPDATE_SUPPORT_RULES:"UPDATE_SUPPORT_RULES",EXTERNAL_MODULE_UPLOADED:"EXTERNAL_MODULE_UPLOADED",TOGGLE_FRAME_HIDDEN:"TOGGLE_FRAME_HIDDEN",ENSURE_FRAME_OPENED:"ENSURE_FRAME_OPENED",RESIZE_FRAME:"RESIZE_FRAME",REQUEST_RULES_MODEL:"REQUEST_RULES_MODEL",GET_RULES_MODEL:"GET_RULES_MODEL",REQUEST_ISSUES:"REQUEST_ISSUES",GET_ISSUES:"GET_ISSUES",POST_MESSAGE:"POST_MESSAGE",GET_NON_LOADED_RULE_SETS:"GET_NON_LOADED_RULE_SETS",CURRENT_LOADING_PROGRESS:"CURRENT_LOADING_PROGRESS"};},true);
sap.ui.predefine('sap/ui/support/supportRules/WindowCommunicationBus',["jquery.sap.global"],function(q){"use strict";var C={channels:{},onMessageChecks:[]};var o=q.sap.getUriParameters().get("sap-ui-xx-support-origin");var a=o;var f=q.sap.getUriParameters().get("sap-ui-xx-frame-identifier")||'_unnamed_frame_-_use_message_origin_';if(!a){var m=new window.URI(q.sap.getModulePath("sap.ui.support"));var p=m.protocol()===""?window.location.protocol.replace(":",""):m.protocol();var h=m.host()===""?window.location.host:m.host();a=p+"://"+h;}C.origin=a;
C.subscribe=function(c,b,d){if(!this.channels[c]){this.channels[c]=[{callback:b,context:d}];return;}this.channels[c].push({callback:b,context:d});};
C.publish=function(c,P){var r=this._getReceivingWindow(),d={channelName:c,params:P,_frameIdentifier:f,_origin:window.location.href};r.postMessage(d,this.origin);};
C.destroyChanels=function(){C.channels={};};
C._getReceivingWindow=function(){if(window.communicationWindows&&window.communicationWindows.hasOwnProperty("supportTool")){return window.communicationWindows.supportTool;}return window.opener||window.parent;};
C._onmessage=function(e){var c=C.onMessageChecks.every(function(M){return M.call(null,e);});if(!c){q.sap.log.error("Message was received but failed validation");return;}var b=e.data.channelName,d=e.data.params,g=C.channels[b];if(!g){return;}g.forEach(function(i){i.callback.apply(i.context,[d]);});};
if(window.addEventListener){window.addEventListener("message",C._onmessage,false);}else{window.attachEvent("onmessage",C._onmessage);}if(o){C.publish("COMM_BUS_INTERNAL","READY");}return C;},true);
sap.ui.predefine('sap/ui/support/supportRules/report/AnalysisHistoryFormatter',[],function(){"use strict";var _=Array(196).join("-"),a="|";
function f(t,e){var g="",t=t||"";if(!e){e=50;}g=t.replace(/(\r\n|\n|\r)/gm," ").replace(/(\")/gm,"");if(g.length>e){g=g.substring(0,e-3)+"...";}else{while(g.length<e){g+=" ";}}return g;}
function b(r){var t=_+"\n";t+=a+f("rule id: "+r[0].ruleId,193)+a+"\n";t+=a+f("name: "+r[0].name,193)+a+"\n";t+=a+f("library: "+r[0].ruleLibName,193)+a+"\n";t+=a+f("categories: "+r[0].categories.join(", "),193)+a+"\n";t+=a+f("audiences: "+r[0].audiences.join(", "),193)+a+"\n";t+=a+f("description: "+r[0].description,193)+a+"\n";t+=a+f("resolution: "+r[0].resolution,193)+a+"\n";t+=_+"\n";t+=a+f("id",50);t+=a+f("class name",30);t+=a+f("status",10);t+=a+f("details",100);t+=a+"\n";t+=_+"\n";for(var i=0;i<r.length;i++){t+=a+f(r[i].context.id,50);t+=a+f(r[i].context.className,30);t+=a+f(r[i].severity,10);t+=a+f(r[i].details,100);t+=a+"\n";}t+=_+"\n";return t;}
function c(l){var t="";if(!l){return t;}for(var e in l){for(var r in l[e]){t+=b(l[e][r]);}t+="\n";}t+="\n";return t;}
function d(e){var t="";if(!e){return t;}for(var i=0;i<e.length;i++){t+="\n";t+="Run "+(i+1)+"\n";t+=c(e[i].issues);t+="\n";}return t;}
return{format:d};},true);
sap.ui.predefine('sap/ui/support/supportRules/report/Archiver',['jquery.sap.global','sap/ui/thirdparty/jszip','sap/ui/core/util/File'],function(q,J,F){"use strict";var A=function(){this._mData={};};
A.prototype.add=function(n,d,t){if(!n){q.sap.log.error("Archiver: No name was given.");return false;}if(!d){q.sap.log.error("Archiver: No data was given.");return false;}if(typeof d==="string"){this._mData[n]=d;return true;}else if(t){if((t==="json"||t==="har")&&(q.isPlainObject(d)||q.isArray(d))){try{this._mData[n]=JSON.stringify(d);return true;}catch(e){q.sap.log.error("Archiver: JSON data could not be serialized for "+n);}}else{q.sap.log.error("Archiver: JSON data could not be serialized for "+t+". Either the type is unknown or the data has a wrong format.");}}else{q.sap.log.error("Archiver: Data could not be serialized for "+n+". Data is is not a string or has a an invalid type.");return false;}return false;};
A.prototype.download=function(f){var z=new J();if(z){for(var n in this._mData){z.file(n,this._mData[n]);}var c=z.generate({type:"blob"});F.save(c,f,"zip","application/zip");}};
A.prototype.clear=function(){this._mData={};return true;};
A.prototype.hasData=function(n){if(n!==undefined){return this._mData.hasOwnProperty(n);}return Object.keys(this._mData).length>0;};
return A;},true);
sap.ui.predefine('sap/ui/support/supportRules/report/DataCollector',["jquery.sap.global","sap/ui/core/support/ToolsAPI","sap/ui/thirdparty/URI"],function(q,T,U){"use strict";var D=function(c){this._oCore=c;this._oSupportAssistantInfo={location:"",version:{},versionAsString:""};};
D.prototype.setSupportAssistantLocation=function(l){this._oSupportAssistantInfo.location=l;};
D.prototype.setSupportAssistantVersion=function(v){this._oSupportAssistantInfo.version=v;this._oSupportAssistantInfo.versionAsString="not available";if(v){this._oSupportAssistantInfo.versionAsString=q.sap.escapeHTML(v.version||"");this._oSupportAssistantInfo.versionAsString+=" (built at "+q.sap.escapeHTML(v.buildTimestamp||"");this._oSupportAssistantInfo.versionAsString+=", last change "+q.sap.escapeHTML(v.scmRevision||"")+")";}};
D.prototype.getSupportAssistantInfo=function(){return this._oSupportAssistantInfo;};
D.prototype.getAppInfo=function(){var a=[];for(var c in this._oCore.mObjects.component){var b=this._oCore.mObjects.component[c];var s=b.getMetadata().getManifestEntry('sap.app');a.push(s);}return a;};
D.prototype.getTechInfoJSON=function(){var c=T.getFrameworkInformation();var t={sapUi5Version:null,version:c.commonInformation.version,build:c.commonInformation.buildTime,change:c.commonInformation.lastChange,jquery:c.commonInformation.jquery,useragent:c.commonInformation.userAgent,docmode:c.commonInformation.documentMode,debug:c.commonInformation.debugMode,bootconfig:c.configurationBootstrap,config:c.configurationComputed,libraries:c.libraries,loadedLibraries:c.loadedLibraries,modules:c.loadedModules,uriparams:c.URLParameters,appurl:c.commonInformation.applicationHREF,title:c.commonInformation.documentTitle,statistics:c.commonInformation.statistics,resourcePaths:[],themePaths:[],locationsearch:document.location.search,locationhash:document.location.hash,supportAssistant:this._oSupportAssistantInfo};var m=q.sap.getAllDeclaredModules();var r=[];for(var i=0;i<m.length;i++){r.push({moduleName:m[i],relativePath:q.sap.getResourcePath(m[i]),absolutePath:U(q.sap.getResourcePath(m[i])).absoluteTo(document.location.origin+document.location.pathname).toString()});}t.resourcePaths=r;var l=this._oCore.getLoadedLibraries();r=[];for(var n in l){var p=this._oCore._getThemePath(n,this._oCore.oConfiguration.theme);r.push({theme:this._oCore.oConfiguration.theme,library:n,relativePath:p,absolutePath:U(p).absoluteTo(document.location.origin+document.location.pathname).toString()});}t.themePaths=r;try{t.sapUi5Version={version:sap.ui.getVersionInfo(),path:sap.ui.resource("","sap-ui-version.json")};}catch(e){t.sapUi5Version=null;}return t;};
return D;},true);
sap.ui.predefine('sap/ui/support/supportRules/report/IssueRenderer',['jquery.sap.global'],function(q){'use strict';var _=false;
function g(v){if(v){if(q.isArray(v)){return q.sap.escapeHTML(v.join(', '));}else{return q.sap.escapeHTML(v);}}else{return'';}}
function r(f,h,j,l){var m='';var n='';var o=1;var t=0;for(var p in h){var s=h[p];t+=s.length;var u=s[0];n+='<tr id="'+j+'_rule_'+o+'" >';n+='<td>';n+='<div class="expandable-control collapsed-content" data-expandableElement="'+j+'_rule_'+o+'_content">';n+='<div class="expandable-title"> '+o+'. '+g(u.name)+' <span class="rule-issue-number">('+s.length+' issues)</span></div></div>';n+='<div id="'+j+'_rule_'+o+'_content">';n+='<div><span class="sapUiSupportLabel">Description: </span>'+g(u.description)+'</div>';n+='<div><span class="sapUiSupportLabel">Min version: </span>'+g(u.minVersion)+'</div>';n+='<div><span class="sapUiSupportLabel">Async: </span>'+g(u.async.toString())+'</div>';n+='<div><span class="sapUiSupportLabel">Resolution: </span>'+g(u.resolution)+'</div>';n+='<div>';if(u.resolutionUrls){for(var k=0;k<u.resolutionUrls.length;k++){n+='<div><a href="'+g(u.resolutionUrls[k].href)+'" target="_blank">'+g(u.resolutionUrls[k].text)+'</a></div>';}}n+='</div>';n+='<table class="sapUiTable"><tr><th></th><th>Element Id</th><th>Class</th><th>Status</th><th>Details</th></tr>';for(var i=0;i<s.length;i++){n+='<tr class="filterable" data-severity="'+g(s[i].severity)+'"><td>'+(i+1)+'</td><td>'+g(s[i].context.id)+'</td>';n+='<td>'+g(s[i].context.className)+'</td>';n+='<td class="'+g(s[i].severity)+'">'+g(s[i].severity)+'</td>';n+='<td>'+g(s[i].details)+'</td></tr>';}n+='</table>';n+='</div></td>';n+='<td>'+g(u.categories)+'</td>';n+='<td>'+g(u.audiences)+'</td>';n+='</tr>';o++;}var v='collapsed-content';if(l===1){v='expanded-content';}m+='<tr>';m+='<td colspan="100" class="expandable-control '+v+'" data-expandableElement="'+j+'" data-groupName="'+f+'" data-groupNumber="'+l+'">';m+='<span class="sapUiSupportLabel expandable-title"> '+l+'. '+f+' ('+(o-1)+' rules, '+t+' issues)</span>';m+='</td></tr><tbody id="'+j+'">';m+=n;m+='</tbody>';return m;}
function a(f){var h='';var i=1;if(!f){return h;}try{h+='<table class="sapUiTable"><tr><th>Name</th><th>Categories</th><th>Audiences</th></tr>';for(var j in f){h+=r(j,f[j],'group'+i,i);i++;}h+='</table>';}catch(k){q.sap.log.warning('There was a problem extracting issues info.');h='';}return h;}
function b(s,f,i){if(!f){return'';}var h=i?'filter-active':'';return'<div data-severity="'+s+'" class="filter '+h+' '+s+'">'+s+'('+f+')</div>'+' | ';}
function c(f){var h='',s={},j,i,t=0,k=[],l={},m={},n={};if(!f){return h;}try{for(n in f){l=f[n];for(m in l){k=l[m];for(i=0;i<k.length;i++){j=k[i].severity;if(s[j]){s[j]++;}else{s[j]=1;}t++;}}}h+=b('Total',t,true);h+=b('High',s['High'],false);h+=b('Medium',s['Medium'],false);h+=b('Low',s['Low'],false);}catch(o){q.sap.log.warning('There was a problem creating severity filters.');h='';}return h;}
function d(i,f){var h='';if(f){h+='<div class="filters">'+c(i)+'<div>\n';}h+='<div>'+a(i)+'</div>';return'<div>'+h+'</div>';}
function e(i){if(!q("#qunit")||!i){return;}var f=q(this.render(i));q("#qunit").append(f);if(!_){var s=[q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/styles.css'),q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/collapseExpand.css'),q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/filter.css')];var h=q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/collapseExpand.js');var j=q.sap.getResourcePath('sap/ui/support/supportRules/report/resources/filter.js');q.each(s,function(k,v){q('<link>').appendTo('head').attr({type:'text/css',rel:'stylesheet',href:v});});q.getScript(h,function(){window.sapUiSupportReport.collapseExpand.init();});q.getScript(j,function(){window.sapUiSupportReport.filter.init();});_=true;}else{window.sapUiSupportReport.collapseExpand.init();window.sapUiSupportReport.filter.init();}}
return{render:d,renderIssuesForOPA:e};},true);
sap.ui.predefine('sap/ui/support/supportRules/report/ReportProvider',['jquery.sap.global','sap/ui/thirdparty/handlebars','sap/ui/support/supportRules/report/Archiver','sap/ui/support/supportRules/report/IssueRenderer'],function(q,H,A,I){'use strict';var r=q.sap.getResourcePath('sap/ui/support/supportRules/report/resources');var b=[{url:r+'/ReportTemplate.html',type:'template'},{url:r+'/styles.css',type:'css'},{url:r+'/filter.css',type:'css'},{url:r+'/collapseExpand.css',type:'css'},{url:r+'/filter.js',type:'js'},{url:r+'/collapseExpand.js',type:'js'}];var t={line:function(a,i,u,v,w){a.push("<tr><td ",i?"align='right' ":"","valign='top'>","<label class='sapUiSupportLabel'>",q.sap.escapeHTML(v||""),"</label></td><td",u?" class='sapUiSupportTechInfoBorder'":"",">");var x=w;if(q.isFunction(w)){x=w(a);}a.push(q.sap.escapeHTML(x||""));a.push("</td></tr>");},multiline:function(a,u,w,x,y){var z=this;z.line(a,u,w,x,function(a){a.push("<table border='0' cellspacing='0' cellpadding='3'>");q.each(y,function(i,v){var B="";if(v){if(typeof(v)==="string"||typeof(v)==="string"||typeof(v)==="boolean"){B=v;}else if((q.isArray(v)||q.isPlainObject(v))&&window.JSON){B=window.JSON.stringify(v);}}z.line(a,false,false,i,""+B);});a.push("</table>");});},subheader:function(a,i){a.push("<tr class='sapUiSupportTitle'><td valign='top' colspan='2'>","<label class='sapUiSupportLabel'>",q.sap.escapeHTML(i||""),"</label></td></tr>");}};
function g(a){return q.ajax({type:'GET',url:a.url,dataType:'text'}).then(function(i){return{content:i,type:a.type};});}
function c(){var a=[];for(var i=0;i<b.length;i++){a.push(g(b[i]));}return q.when.apply(q,a);}
function d(a){var u='';if(!a){return new H.SafeString(u);}try{a.modules.sort();var w=["<div class='sapUiSupportToolbar'>","<div><div class='sapUiSupportTechInfoCntnt'>","<table border='0' cellpadding='3'>"];t.subheader(w,"Support Assistant Information");t.line(w,true,true,"Location",a.supportAssistant.location);t.line(w,true,true,"Version",a.supportAssistant.versionAsString);t.subheader(w,"Application Information");t.line(w,true,true,"SAPUI5 Version",function(i){var v=a.sapUi5Version;if(v&&v.version){var V=v.version;var y=q.sap.escapeHTML(V.version||"");i.push(y," (built at ",q.sap.escapeHTML(V.buildTimestamp||""),", last change ",q.sap.escapeHTML(V.scmRevision||""),")");}else{i.push("not available");}});t.line(w,true,true,"Core Version",function(i){return a.version+" (built at "+a.build+", last change "+a.change+")";});t.line(w,true,true,"Loaded jQuery Version",function(i){return a.jquery;});t.line(w,true,true,"User Agent",function(i){return a.useragent+(a.docmode?", Document Mode '"+a.docmode+"'":"");});t.line(w,true,true,"Application",a.appurl);t.multiline(w,true,true,"Configuration (bootstrap)",a.bootconfig);t.multiline(w,true,true,"Configuration (computed)",a.config);if(!q.isEmptyObject(a.libraries)){t.multiline(w,true,true,"Libraries",a.libraries);}t.multiline(w,true,true,"Loaded Libraries",a.loadedLibraries);t.line(w,true,true,"Loaded Modules",function(y){q.each(a.modules,function(i,v){if(v.indexOf("sap.ui.core.support")<0){y.push("<span>",q.sap.escapeHTML(v||""),"</span>");if(i<a.modules.length-1){y.push(", ");}}});});t.multiline(w,true,true,"URI Parameters",a.uriparams);w.push("</table></div>");u=w.join('');}catch(x){q.sap.log.warning('There was a problem extracting technical info.');}return new H.SafeString(u);}
function e(v){var a='<td>';if(v){a+=q.sap.escapeHTML(v);}a+='</td>';return a;}
function f(a){var u='';if(!a){return new H.SafeString(u);}u+='<table class="sapUiTable"><tr><th>Component ID</th><th>Type</th><th>Title</th><th>Subtitle</th><th>Application version</th><th>Description</th><th>BCP Component</th></tr>';try{for(var i=0;i<a.length;i++){var v=a[i];u+='<tr>';u+=e(v.id);u+=e(v.type);u+=e(v.title);u+=e(v.subTitle);if(v.applicationVersion){u+=e(v.applicationVersion.version);}else{u+='<td></td>';}u+=e(v.description);u+=e(v.ach);u+='</tr>';}u+='</table>';}catch(w){q.sap.log.warning('There was a problem extracting app info.');u='';}return new H.SafeString(u);}
function h(a){var i='';i+='<div><span class="sapUiSupportLabel">'+a.displayName+'</span>';i+='<span> ('+a.description+')</span></div>';return i;}
function j(a,i){var u='';u+='<div><span class="sapUiSupportLabel">'+i.displayName+' with id:</span> '+a;u+='<span> ('+i.description+')</span></div>';return u;}
function k(a,u){var v='';if(a.length>5){v+='<div class="expandable-control collapsed-content" data-expandableElement="execution-scope-components">';v+='<span class="expandable-title"><span class="sapUiSupportLabel">'+u.displayName+'</span>';v+='<span> ('+u.description+')</span></span></div>';}else{v+='<div><span class="sapUiSupportLabel">'+u.displayName+'</span>';v+='<span> ('+u.description+')</span></div>';}v+='<ol id="execution-scope-components" class="top-margin-xsmall">';for(var i=0;i<a.length;i++){v+='<li>'+a[i]+'</li>';}v+='</ol>';return v;}
function l(a){var i='';try{var u=a.executionScope._getType();var v=a.scopeDisplaySettings.executionScopes[u];var w=a.scopeDisplaySettings.executionScopeTitle;i+='<div class="sapUiSupportLabel">'+w+': </div>';switch(u){case'global':i+=h(v);break;case'subtree':i+=j(a.executionScope._getContext().parentId,v);break;case'components':i+=k(a.executionScope._getContext().components,v);break;}}catch(x){q.sap.log.warning('There was a problem extracting scope info.');i='';}return new H.SafeString(i);}
function m(a){var i='';if(!a){return new H.SafeString(i);}try{var u=1;i+='<table class="sapUiTable"><tbody><tr><th>Name</th><th>Description</th><th>Categories</th><th>Audiences</th></tr></tbody>';for(var v in a){var w=a[v];var x='collapsed-content';if(u===1){x='expanded-content';}var y=a[v].selected?' ('+a[v].issueCount+' issues)':'';var z='<span class="checked" style="'+(a[v].selected?'':'visibility: hidden;')+'"> &#10004; </span>';i+='<tbody><tr><td colspan="100" ';i+='class="expandable-control '+x+'" data-expandableElement="section-selected-rules-group'+u+'">'+z;i+='<span class="sapUiSupportLabel expandable-title"> '+v+y+'</span>';i+='</td></tr></tbody>';var B='';for(var C in w){var D=w[C].selected?' ('+w[C].issueCount+' issues)':'';var E='<span class="checked" style="'+(w[C].selected?'':'visibility: hidden;')+'"> &#10004; </span>';B+='<tr>';B+='<td>'+E+w[C].title+D+'</td>';B+='<td>'+w[C].description+'</td>';B+='<td>'+w[C].categories.join(', ')+'</td>';B+='<td>'+w[C].audiences.join(', ')+'</td>';B+='</tr>';}i+='<tbody id="section-selected-rules-group'+u+'">'+B+'</tbody>';u++;}i+='</table>';}catch(F){q.sap.log.warning('There was a problem extracting selected rules info.');i='';}return new H.SafeString(i);}
function n(b,a){var u='';if(a!=='script'&&a!=='style'){return u;}for(var i=0;i<b.length;i++){switch(a){case'script':u+='<script>'+b[i]+'</script>\n';break;case'style':u+='<style type="text/css">'+b[i]+'</style>\n';break;}}return new H.SafeString(u);}
H.registerHelper('getTechnicalInformation',function(a){return d(a);});H.registerHelper('getRules',function(a){return m(a);});H.registerHelper('getIssues',function(i){return new H.SafeString(I.render(i,true));});H.registerHelper('getAppInfo',function(a){return f(a);});H.registerHelper('getScope',function(a){return l(a);});H.registerHelper('getScripts',function(a){return n(a,'script');});H.registerHelper('getStyles',function(a){return n(a,'style');});
function o(D){return c().then(function(){var a=[],u=[],v='',i,w={},x={};for(i=0;i<arguments.length;i++){switch(arguments[i].type){case'template':v=arguments[i].content;break;case'css':a.push(arguments[i].content);break;case'js':u.push(arguments[i].content);break;}}w=H.compile(v);x={technicalInfo:D.technical,issues:D.issues,appInfo:D.application,rules:D.rules,metadata:{title:D.name+' Analysis Results',title_TechnicalInfo:'Technical Information',title_Issues:'Issues',title_AppInfo:'Application Information',title_SelectedRules:'Available and (<span class="checked">&#10004;</span>) Executed Rules',timestamp:new Date(),scope:D.scope,analysisDuration:D.analysisDuration,analysisDurationTitle:D.analysisDurationTitle,styles:a,scripts:u}};return w(x);});}
function p(D){this.getReportHtml(D).done(function(a){var i='<!DOCTYPE HTML><html><head><title>Report</title></head><body><div id="sap-report-content">'+a+'</div></body></html>';var u={'issues':D.issues};var v={'appInfos':D.application};var w={'technicalInfo':D.technical};var x=new A();x.add('technicalInfo.json',w,'json');x.add('issues.json',u,'json');x.add('appInfos.json',v,'json');x.add('report.html',i);x.download("SupportAssistantReport");x.clear();});}
function s(D){var i='';var a=q('<a style="display: none;"/>');a.on('click',function(){var u=window.open('','_blank');q(u.document).ready(function(){if(u.document.getElementById('sap-report-content')){u.document.getElementById('sap-report-content').innerHtml=i;}else{u.document.write('<div id="sap-report-content">'+i+'</div>');}u.document.title='Report';});});q('body').append(a);this.getReportHtml(D).then(function(u){i=u;a[0].click();a.remove();});}
return{getReportHtml:o,downloadReportZip:p,openReport:s};},true);
sap.ui.predefine('sap/ui/support/supportRules/ui/IFrameController',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants"],function(q,M,C,c,a){"use strict";var i=null;var f;var F;var s;
function b(u){var e=new window.URI(u);var O=(e.protocol()||window.location.protocol.replace(':',''))+'://'+(e.host()||window.location.host);return O;}
function g(){return''+ +new Date();}
function o(u){var t=document.createElement("IFRAME");var e=t.style;t.id="sap-ui-supportToolsFrame";t.src=u;e.width="100%";e.height="28px";e.position="absolute";e.left="0";e.bottom="0";e.border="none";e.zIndex="1001";e.boxShadow="1px -10px 42px -4px #888";document.body.appendChild(t);setInterval(function(){if(t.parentNode.nodeName!=="BODY"){document.body.appendChild(t);window.communicationWindows.supportTool=t.contentWindow;}},1000);window.communicationWindows.supportTool=t.contentWindow;}
function d(u){window.communicationWindows.supportTool=window.open(u,"sapUiSupportTool","width=1024,height=400,status=no,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,scrollbars=no");window.communicationWindows.supportTool.window.onload=function(){window.communicationWindows.supportTool.document.title=a.SUPPORT_ASSISTANT_NAME;};}
var I=M.extend("sap.ui.support.IFrameController",{constructor:function(){if(!i){M.apply(this,arguments);}else{q.sap.log.warning("Only one support tool allowed");return i;}}});
I.prototype._setCommunicationSubscriptions=function(){C.subscribe(c.ENSURE_FRAME_OPENED,function(){if(document.getElementById("sap-ui-supportToolsFrame").style.height==="28px"){this.resizeFrame(true);this.toggleHide();}},this);C.subscribe(c.RESIZE_FRAME,function(p){i.resizeFrame(p.bigger);});};
I.prototype.injectFrame=function(e){F=g();s=q.sap.getModulePath("sap.ui.support.supportRules.ui","/overlay.html?sap-ui-xx-formfactor=compact&sap-ui-xx-support-origin="+window.location.protocol+"//"+window.location.host+"&"+"sap-ui-xx-frame-identifier="+F);f=b(s);window.communicationWindows=window.communicationWindows||{};if(e.indexOf("window")>-1){d(s);}else{o(s);this._setCommunicationSubscriptions();}};
I.prototype.resizeFrame=function(e){var t=document.getElementById("sap-ui-supportToolsFrame").style;if(e){if(t.height==="50%"){t.height="100%";}else if(t.height==="28px"){t.height="50%";}}else{if(t.height==="100%"){t.height="50%";}else if(t.height==="50%"){t.height="28px";}}};
I.prototype.toggleHide=function(h){var t=document.getElementById("sap-ui-supportToolsFrame").style;if(h){this._originalSize={width:t.width,height:t.height};t.width="170px";t.height="28px";}else{if(this._originalSize){t.width=this._originalSize.width;t.height=this._originalSize.height;this._originalSize=null;}}};
I.prototype._stop=function(){this._oCssLink.parentNode.removeChild(this._oCssLink);this._oDomRef.parentNode.removeChild(this._oCssLink);this._oCore=null;};
I.prototype.getFrameOrigin=function(){return f;};
I.prototype.getFrameIdentifier=function(){return F;};
I.prototype.getFrameUrl=function(){return s;};
i=new I();return i;},true);
sap.ui.predefine('sap/ui/support/supportRules/ui/controllers/Analysis.controller',["jquery.sap.global","sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/model/json/JSONModel","sap/m/Panel","sap/m/List","sap/m/ListItemBase","sap/m/StandardListItem","sap/m/InputListItem","sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Label","sap/m/MessageToast","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSet","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/ui/models/SelectionUtils","sap/m/Dialog","sap/ui/unified/FileUploader"],function($,BaseController,JSONModel,Panel,List,ListItemBase,StandardListItem,InputListItem,Button,Toolbar,ToolbarSpacer,Label,MessageToast,CommunicationBus,channelNames,SharedModel,RuleSerializer,constants,Ruleset,storage,SelectionUtils,Dialog,FileUploader){"use strict";return BaseController.extend("sap.ui.support.supportRules.ui.controllers.Analysis",{onInit:function(){this.model=SharedModel;this.setCommunicationSubscriptions();this.tempRulesLoaded=false;this.getView().setModel(this.model);this.treeTable=SelectionUtils.treeTable=this.byId("ruleList");this.ruleSetView=this.byId("ruleSetsView");this.rulesViewContainer=this.byId("rulesNavContainer");this.bAdditionalViewLoaded=false;CommunicationBus.subscribe(channelNames.UPDATE_SUPPORT_RULES,function(){if(!this.bAdditionalViewLoaded){CommunicationBus.publish(channelNames.RESIZE_FRAME,{bigger:true});this.bAdditionalViewLoaded=true;this.loadAdditionalUI();}},this);},loadAdditionalUI:function(){this._ruleDetails=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.RuleDetails",this);this.byId("rulesDisplayPage").addContentArea(this._ruleDetails);this._ruleCreateUpdatePages=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.RuleUpdate",this);this._ruleCreateUpdatePages.forEach(function(r){this.byId("rulesNavContainer").insertPage(r);},this);this._updateRuleList();},onAfterRendering:function(){var t=function(){CommunicationBus.publish(channelNames.ON_INIT_ANALYSIS_CTRL);sap.ui.getCore().detachThemeChanged(t);};if(sap.ui.getCore().isThemeApplied()){CommunicationBus.publish(channelNames.ON_INIT_ANALYSIS_CTRL);}else{sap.ui.getCore().attachThemeChanged(t);}},onAsyncSwitch:function(e){var s=e.getSource();if(e.getParameter("selected")){var a=s.getCustomData()[0].getValue()==="true";var r=s.getProperty("groupName")==="asyncContext"?"/newRule":"/editRule";this.model.setProperty(r+"/async",a);this._updateCheckFunction(r,a);}},_updateCheckFunction:function(r,a){var c=this.model.getProperty(r+"/check");if(!c){return;}var m=c.match(/function[^(]*\(([^)]*)\)/);if(!m){return;}var p=m[1].trim().split(/\W+/);p[0]=p[0]||"oIssueManager";p[1]=p[1]||"oCoreFacade";p[2]=p[2]||"oScope";if(a){p[3]=p[3]||"fnResolve";}else{p=p.slice(0,3);}var n=c.replace(/function[^(]*\(([^)]*)\)/,"function ("+p.join(", ")+")");this.model.setProperty(r+"/check",n);},getTemporaryLib:function(){var l=this.model.getProperty("/libraries");for(var i=0;i<l.length;i++){if(l[i].title==constants.TEMP_RULESETS_NAME){return l[i];}}},setCommunicationSubscriptions:function(){CommunicationBus.subscribe(channelNames.UPDATE_SUPPORT_RULES,this.updatesupportRules,this);CommunicationBus.subscribe(channelNames.VERIFY_RULE_CREATE_RESULT,function(d){var r=d.result,n=RuleSerializer.deserialize(d.newRule,true),t=this.getTemporaryLib(),a=this.model.getProperty('/treeViewModel'),b;if(r=="success"){t.rules.push(n);b=this._syncTreeTableVieModelTempRulesLib(t,a);this._syncTreeTableVieModelTempRulesLib(t,a);if(this.model.getProperty("/persistingSettings")){storage.setRules(t.rules);if(this.showRuleCreatedToast){MessageToast.show('Your temporary rule "'+n.id+'" was persisted in the local storage');this.showRuleCreatedToast=false;}}var e=this.model.getProperty("/newEmptyRule");this.model.setProperty("/newRule",jQuery.extend(true,{},e));this.goToRuleProperties();this.model.setProperty("/selectedRule",n);SelectionUtils.updateTreeViewTempRulesSelection(b);this._updateRuleList();}else{MessageToast.show("Add rule failed because: "+r);}},this);CommunicationBus.subscribe(channelNames.VERIFY_RULE_UPDATE_RESULT,function(d){var r=d.result,u=RuleSerializer.deserialize(d.updateRule,true),t=this;if(r==="success"){var a=this.model.getProperty("/editRuleSource"),b=this.model.getProperty('/treeViewModel');var l=this.model.getProperty('/libraries');l.forEach(function(c,e){if(c.title===constants.TEMP_RULESETS_NAME){c.rules.forEach(function(f,g){if(f.id===a.id){c.rules[g]=u;if(t.model.getProperty("/persistingSettings")){storage.setRules(c.rules);}}});t._syncTreeTableVieModelTempRule(u,b);}});this.model.checkUpdate(true);this.model.setProperty('/selectedRule',u);this.goToRuleProperties();}else{MessageToast.show("Update rule failed because: "+r);}},this);CommunicationBus.subscribe(channelNames.POST_AVAILABLE_LIBRARIES,function(d){this.model.setProperty("/availableLibrariesSet",d.libNames);this.rulesViewContainer.setBusy(false);},this);CommunicationBus.subscribe(channelNames.POST_AVAILABLE_COMPONENTS,function(d){var e=[],m=this.model.getProperty("/executionScopeComponents"),s=storage.getSelectedScopeComponents(),i;for(var c=0;c<d.length;c+=1){e.push({text:d[c]});}if(m&&m.length>0){for(i=0;i<e.length;i++){e[i].selected=this.checkIfComponentIsSelected(e[i],m);}}else if(s&&s.length>0){for(i=0;i<e.length;i++){e[i].selected=this.checkIfComponentIsSelected(e[i],s);}}this.model.setProperty("/executionScopeComponents",e);},this);CommunicationBus.subscribe(channelNames.GET_RULES_MODEL,function(t){var i=this.model.getProperty("/initialRulesLoading");if(i){this.model.setProperty("/initialRulesLoading",false);this.model.setProperty("/treeViewModel",t);SelectionUtils.initializeSelection(i);}else{SelectionUtils._syncSelections(t);SelectionUtils.initializeSelection();}},this);CommunicationBus.subscribe(channelNames.POST_MESSAGE,function(d){MessageToast.show(d.message);},this);CommunicationBus.subscribe(channelNames.ON_ANALYZE_STARTED,function(d){this.model.setProperty("/showProgressIndicator",true);},this);},checkIfComponentIsSelected:function(c,s){for(var i=0;i<s.length;i+=1){if(s[i].text==c.text&&s[i].selected){return true;}}return false;},onAnalyze:function(){var s=this._getSelectedRules(),e=this._getExecutionContext();if(!s.length>0){MessageToast.show("Select some rules to be analyzed.");return;}if(e.type==="components"&&e.components.length===0){MessageToast.show("Please select some components to be analyzed.");return;}CommunicationBus.publish(channelNames.ON_ANALYZE_REQUEST,{selectedRules:s,executionContext:e});},_getExecutionContext:function(){var c={type:this.model.getProperty("/analyzeContext/key")};if(c.type==="subtree"){c.parentId=this.model.getProperty("/subtreeExecutionContextId");}if(c.type==="components"){var s=sap.ui.getCore().byId("componentsSelectionContainer"),a=s.getContent();c.components=[];a.forEach(function(b){if(b.getSelected()){c.components.push(b.getText());}});}return c;},onSelectedRuleSets:function(e){if(e.getParameter("selectedKey")==="additionalRulesets"){this.rulesViewContainer.setBusyIndicatorDelay(0);this.rulesViewContainer.setBusy(true);CommunicationBus.publish(channelNames.GET_NON_LOADED_RULE_SETS);}},_getSelectedRules:function(){var r=this.getView().getModel().getProperty("/treeViewModel"),R,l,o,s=[];for(l in r){if(Number.isInteger(Number.parseInt(l,10))){for(R in r[l]){o=r[l][R];if(Number.isInteger(Number.parseInt(R,10))&&o.selected){s.push({libName:o.libName,ruleId:o.id});}}}}return s;},_syncTreeTableVieModelTempRulesLib:function(t,a){var b=0,l,r;for(var i in a){l=a[i];if(l.name!==constants.TEMP_RULESETS_NAME){continue;}for(var c in t.rules){r=t.rules[c];l[b]={name:r.title,description:r.description,id:r.id,audiences:r.audiences,categories:r.categories,minversion:r.minversion,resolution:r.resolution,title:r.title,selected:l[b]!==undefined?l[b].selected:l.selected,libName:l.name,check:r.check};b++;}return l;}},_syncTreeTableVieModelTempRule:function(t,a){var r=this.model.getProperty("/editRuleSource");for(var i in a){if(a[i].name===constants.TEMP_RULESETS_NAME){for(var b in a[i]){if(a[i][b].id===r.id){a[i][b]={name:t.title,description:t.description,id:t.id,audiences:t.audiences,categories:t.categories,minversion:t.minversion,resolution:t.resolution,selected:t.selected,title:t.title,libName:a[i].name,check:t.check};}}}}},_hasSelectedComponent:function(){var a=sap.ui.getCore().byId("componentsSelectionContainer").getContent();function i(c){return c.getSelected();}return a.some(i);},onAnalyzeSettings:function(e){CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);if(!this._settingsPopover){this._settingsPopover=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.AnalyzeSettings",this);this.getView().addDependent(this._settingsPopover);}this._settingsPopover.openBy(e.getSource());},onContextSelect:function(e){if(e.getParameter("selected")){var s=e.getSource(),r=s.getCustomData()[0].getValue(),a=this.model.getProperty("/executionScopes")[r];if(r==="components"&&!this._hasSelectedComponent()){var c=sap.ui.getCore().byId("componentsSelectionContainer").getContent();if(c.length>0){c[0].setSelected(true);this.onScopeComponentSelect(null);}}this.model.setProperty("/analyzeContext",a);}if(storage.readPersistenceCookie(constants.COOKIE_NAME)){this.persistExecutionScope();}},onExecutionContextChange:function(e){var v=e.getSource().getValue();if(v){this.model.setProperty("/subtreeExecutionContextId",v);}if(storage.readPersistenceCookie(constants.COOKIE_NAME)){this.persistExecutionScope();}},onScopeComponentSelect:function(e){var s=this.model.getProperty("/executionScopeComponents");if(storage.readPersistenceCookie(constants.COOKIE_NAME)){storage.setSelectedScopeComponents(s);}},onBeforePopoverOpen:function(){if(this.model.getProperty("/executionScopeComponents").length===0){CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);}},createNewRulePress:function(e){var a=this.model.getProperty("/newEmptyRule");this.model.setProperty("/selectedSetPreviewKey","availableRules");this.model.setProperty("/newRule",jQuery.extend(true,{},a));this.model.setProperty("/tempLink",{href:"",text:""});this.goToCreateRule();},exportSelectedRules:function(){var i=new sap.m.Input();var t=new sap.m.TextArea({width:"100%"});var d=new Dialog({title:"Export Rulesets",content:[new sap.m.VBox({items:[new sap.m.Label({text:"Title",labelFor:i}),i,new sap.m.Label({text:"Description",labelFor:t}),t]})],beginButton:new sap.m.Button({text:"Cancel",press:function(e){d.close();}}),endButton:new sap.m.Button({text:"Export",press:function(e){d.close();SelectionUtils.exportSelectedRules(i.getValue(),t.getValue());}})});d.open();},importSelectedRules:function(){var t=this;var f=new FileUploader({uploadComplete:function(e){var r=new FileReader();r.onloadend=i;function i(a){var b=a.target.result;var o=JSON.parse(b);if(SelectionUtils.isValidSelectionImport(o)){var O=t.model.getProperty("/persistingSettings");t.model.setProperty("/persistingSettings",true);SelectionUtils.selectAllRows(false);storage.setSelectedRules(o.selections);SelectionUtils.initializeModelSelection();t.model.setProperty("/persistingSettings",O);}if(storage.readPersistenceCookie(constants.COOKIE_NAME)){SelectionUtils.persistSelection();}}r.readAsText(e.oSource.oFileUpload.files[0],"UTF-8");}});var d=new Dialog({title:"Upload rule settings",content:[f,new sap.m.Button({text:"Upload File",press:function(e){f.upload();d.close();}})],endButton:new sap.m.Button({text:"Close",press:function(e){d.close();}})});d.open();},goToRuleProperties:function(){var n=this.byId("rulesNavContainer");n.to(this.byId("rulesDisplayPage"),"show");},createRuleString:function(r){if(!r){return'';}var s="{\n",c=0,k=Object.keys(r).length;for(var a in r){var v=r[a];c++;s+="\t";s+=a+": ";if(a==="check"){s+=v.split("\n").join("\n\t");}else{s+=JSON.stringify(v);}if(c<k){s+=",";}s+="\n";}s+="}";return s;},updateRule:function(){var o=this.model.getProperty("/editRuleSource/id"),u=this.model.getProperty("/editRule");if(this.checkFunctionString(u.check)){CommunicationBus.publish(channelNames.VERIFY_UPDATE_RULE,{oldId:o,updateObj:RuleSerializer.serialize(u)});}},updatesupportRules:function(d){d=RuleSerializer.deserialize(d);CommunicationBus.publish(channelNames.REQUEST_RULES_MODEL,d);var l=[],t=this;for(var i in d){var r=[],a=d[i].ruleset._mRules;for(var j in a){var b=a[j];b.libName=i;b.selected=true;r.push(b);}l.push({title:i,type:"library",rules:r});}var f;if(l[0].rules[0]){f=l[0].rules[0];}else{f=l[1].rules[0];}t.placeTemporaryRulesetAtStart(l);t.model.setProperty("/selectedRuleStringify","");t.model.setProperty("/selectedRule",f);t.model.setProperty("/selectedRuleStringify",t.createRuleString(f));t.model.setProperty("/libraries",l);var c=storage.getRules(),e=t.model.getProperty("/loadingAdditionalRuleSets");if(e){MessageToast.show("Additional rule set(s) loaded!");this.ruleSetView.setSelectedKey("availableRules");}if(c&&!e&&!this.tempRulesLoaded){this.tempRulesLoaded=true;c.forEach(function(g){CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE,RuleSerializer.serialize(g));});}},placeTemporaryRulesetAtStart:function(l){for(var i=0;i<l.length;i++){var r=l[i];if(r.title===constants.TEMP_RULESETS_NAME){var t=r;l.splice(i,1);l.unshift(t);return;}}},addLinkToRule:function(e){var t=this.model.getProperty("/tempLink"),c=jQuery.extend(true,{},t),a=e.getSource().getProperty("text"),r=a==='Add'?"/newRule":"/editRule",u=this.model.getProperty(r+"/resolutionurls");if(u){u.push(c);}else{this.model.setProperty(r+"/resolutionurls","");u.push(c);}this.model.setProperty("/tempLink",{href:"",text:""});this.model.checkUpdate(true,true);},goToCreateRule:function(){var n=this.byId("rulesNavContainer");n.to(sap.ui.getCore().byId("rulesCreatePage"),"show");},checkFunctionString:function(functionString){try{eval("var testAsignedVar = "+functionString);}catch(err){MessageToast.show("Your check function contains errors, and can't be evaluated:"+err);return false;}return true;},addNewRule:function(){var n=this.model.getProperty("/newRule");if(this.checkFunctionString(n.check)){this.showRuleCreatedToast=true;CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE,RuleSerializer.serialize(n));}},rulesToolbarITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var n=this.model.getProperty("/newRule"),s=this.createRuleString(n);this.model.setProperty("/newRuleStringified",s);}},rulesToolbarEditITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var n=this.model.getProperty("/editRule"),s=this.createRuleString(n);this.model.setProperty("/updateRuleStringified",s);}},loadMarkedSupportLibraries:function(){var l=this.byId("availableLibrariesSet"),L=l.getSelectedItems().map(function(i){return i.getTitle();});l.getItems().forEach(function(i){i.setSelected(false);});if(L.length>0){CommunicationBus.publish(channelNames.LOAD_RULESETS,{aLibNames:{publicRules:L,internalRules:L}});this.model.setProperty("/loadingAdditionalRuleSets",true);}else{MessageToast.show("Select additional RuleSet to be loaded.");}},onCellClick:function(e){if(e.getParameter("rowBindingContext")){var s=e.getParameter("rowBindingContext").getObject(),a;if(s.id){a=this.getMainModelFromTreeViewModel(s);var b=this.createRuleString(a);this.model.setProperty("/selectedRuleStringify",b);}this.model.setProperty("/selectedRule",a);}},getMainModelFromTreeViewModel:function(s){var a=this.model.getProperty("/libraries"),m=null;a.forEach(function(l,i){a[i].rules.forEach(function(e){if(s.id===e.id){m=e;}});});return m;},duplicateRule:function(e){var p=e.getSource().getBindingContext().getPath(),s=this.getView().getModel().getProperty(p),a=this.getMainModelFromTreeViewModel(s),b=jQuery.extend(true,{},a);this.model.setProperty("/newRule",b);this.model.checkUpdate(true,false);this.goToCreateRule();},editRule:function(e){var p=e.getSource().getBindingContext().getPath(),s=this.getView().getModel().getProperty(p),a=this.getMainModelFromTreeViewModel(s);this.model.setProperty("/editRuleSource",a);this.model.setProperty("/editRule",jQuery.extend(true,{},a));this.model.checkUpdate(true,true);var n=this.byId("rulesNavContainer");n.to(sap.ui.getCore().byId("ruleUpdatePage"),"show");},deleteTemporaryRule:function(e){var s=this.getObjectOnTreeRow(e),t=this.model.getProperty("/treeViewModel"),m=this.model.getProperty("/libraries"),r=[];m.forEach(function(l,b){if(l.title===constants.TEMP_RULESETS_NAME){l.rules.forEach(function(c,d){if(c.id===s.id){l.rules.splice(d,1);return;}else{r.push(c);}});}});for(var i in t){if(t[i].name===constants.TEMP_RULESETS_NAME){for(var a in t[i]){if(t[i][a].id===s.id){delete t[i][a];}}}}this.model.setProperty("/treeViewModel",t);storage.removeSelectedRules(r);this._updateRuleList();},getObjectOnTreeRow:function(e){var p=e.getSource().getBindingContext().getPath(),s=this.getView().getModel().getProperty(p),l=this.model.getProperty("/libraries");l.forEach(function(a,b){a.rules.forEach(function(r){if(r.id===s.id){s.check=r.check;}});});return s;},onToggleOpenState:SelectionUtils.toggleOpenStateHandler.bind(SelectionUtils),onRowSelectionChange:SelectionUtils.selectionChangeHandler.bind(SelectionUtils),_updateRuleList:function(){var r=this.getView().byId("ruleList"),t=this.getTemporaryLib()["rules"];if(!t.length){r.setRowActionCount(1);}else{r.setRowActionCount(2);}}});});
sap.ui.predefine('sap/ui/support/supportRules/ui/controllers/BaseController',["sap/ui/core/mvc/Controller","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/ui/models/SelectionUtils"],function(C,s,c,S){"use strict";return C.extend("sap.ui.support.supportRules.ui.controllers.BaseController",{onPersistedSettingSelect:function(){var m=this.getView().getModel();if(m.getProperty("/persistingSettings")){s.createPersistenceCookie(c.COOKIE_NAME,true);m.getProperty("/libraries").forEach(function(l){if(l.title==c.TEMP_RULESETS_NAME){s.setRules(l.rules);}});this.persistExecutionScope();S.persistSelection();}else{s.deletePersistenceCookie(c.COOKIE_NAME);this.deletePersistedData();}},persistExecutionScope:function(){var a={analyzeContext:this.model.getProperty("/analyzeContext"),subtreeExecutionContextId:this.model.getProperty("/subtreeExecutionContextId")},b=this.model.getProperty("/executionScopeComponents");s.setSelectedScopeComponents(b);s.setSelectedContext(a);},deletePersistedData:function(){s.deletePersistenceCookie(c.COOKIE_NAME);this.getView().getModel().setProperty("/persistingSettings",false);s.removeAllData();}});});
sap.ui.predefine('sap/ui/support/supportRules/ui/controllers/Issues.controller',["jquery.sap.global","sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/formatter","sap/ui/support/supportRules/Constants","sap/m/OverflowToolbarAssociativePopoverControls"],function($,B,J,C,S,E,I,c,f,a,O){"use strict";var i={severityIcons:{High:"sap-icon://message-error",Medium:"sap-icon://message-warning",Low:"sap-icon://message-information",All:"sap-icon://multiselect-all"}};return B.extend("sap.ui.support.supportRules.ui.controllers.Issues",{ISSUES_LIMIT:1000,formatter:f,onInit:function(){this.model=S;this.setCommunicationSubscriptions();this.getView().setModel(this.model);this.clearFilters();this._initElementTree();this.treeTable=this.byId("issuesList");this.issueTable=this.byId("issueTable");this.toolHeader=this.byId('toolHeader');this.toolHeader.removeStyleClass('sapTntToolHeader sapContrast sapContrastPlus');this.model.setProperty("/bEnabledFilterButton",false);var t=this.toolHeader._getPopover();t.removeStyleClass('sapTntToolHeaderPopover sapContrast sapContrastPlus');O._mSupportedControls["sap.ui.layout.VerticalLayout"]={canOverflow:true,listenForEvents:[],noInvalidationProps:[]};},setCommunicationSubscriptions:function(){C.subscribe(c.ON_ANALYZE_FINISH,function(d){var t=this;var p={};t.data=d;d.issues.forEach(function(b){if(!b.context||!b.context.id){return;}if(!p[b.context.id]){p[b.context.id]=[b.name];}else{p[b.context.id].push(b.name);}});this.model.setSizeLimit(this.ISSUES_LIMIT);this.model.setProperty("/issues",d.issues);this.model.setProperty('/analyzePressed',true);this.model.setProperty("/issuesCount",this.data.issues.length);this.model.setProperty("/selectedIssue",null);this.elementTree.setData({controls:d.elementTree,issuesIds:p});this.clearFilters();},this);C.subscribe(c.GET_ISSUES,function(d){this.structuredIssuesModel=d.groupedIssues;this.model.setProperty("/issues",d.issuesModel);if(d.issuesModel[0]){this._setSelectedRule(d.issuesModel[0][0]);this.treeTable.setSelectedIndex(1);this.issueTable.setSelectedIndex(0);}},this);},_initElementTree:function(){var t=this;this.elementTree=new E(null,{onIssueCountClicked:function(s){t.clearFilters();t.model.setProperty("/elementFilter",s);t.updateIssuesVisibility();},onHoverChanged:function(h){C.publish(c.TREE_ELEMENT_MOUSE_ENTER,h);},onMouseOut:function(){C.publish(c.TREE_ELEMENT_MOUSE_OUT);}});},onAfterRendering:function(){this.elementTree.setContainerId(this.byId("elementTreeContainer").getId());},clearFilters:function(){this.model.setProperty("/severityFilter",a.FILTER_VALUE_ALL);this.model.setProperty("/categoryFilter",a.FILTER_VALUE_ALL);this.model.setProperty("/elementFilter",a.FILTER_VALUE_ALL);this.model.setProperty("/audienceFilter",a.FILTER_VALUE_ALL);if(this.data){this.model.setProperty("/issues",this.data.issues);this.setToolbarHeight();}this.model.setProperty("/bEnabledFilterButton",false);this.updateIssuesVisibility();},clearFiltersAndElementSelection:function(){this.clearFilters();this.elementTree.clearSelection();},onIssuePressed:function(e){var s=this.model.getProperty("/selectedIssue");this.elementTree.setSelectedElement(s.context.id,false);},onRowSelectionChanged:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject(),v=a.MAX_VISIBLE_ISSUES_FOR_RULE;if(s.type==="rule"){this._setSelectedRule(s);}else{this.model.setProperty("/selectedIssue",null);}if(s.issueCount<v){v=s.issueCount;}this.model.setProperty("/visibleRowCount",v);}},openDocumentation:function(e){var l=sap.ui.getCore().byId(e.mParameters.id),u=l.getBindingContext().getProperty("href");C.publish(c.OPEN_URL,u);},updateIssuesVisibility:function(){if(this.data){var b=this.data.issues.filter(this.filterIssueListItems,this);C.publish(c.REQUEST_ISSUES,b);this.model.setProperty("/visibleIssuesCount",b.length);}this.setToolbarHeight();},filterIssueListItems:function(b){var s=this.model.getProperty("/severityFilter"),d=b.severity===s||s===a.FILTER_VALUE_ALL,e=this.model.getProperty("/categoryFilter"),g=$.inArray(e,b.categories)>-1||e===a.FILTER_VALUE_ALL,h=this.model.getProperty("/elementFilter"),j=h===b.context.id||h===a.FILTER_VALUE_ALL,k=this.model.getProperty("/audienceFilter"),l=$.inArray(k,b.audiences)>-1||k===a.FILTER_VALUE_ALL,m=s===a.FILTER_VALUE_ALL&&e===a.FILTER_VALUE_ALL&&k===a.FILTER_VALUE_ALL&&h===a.FILTER_VALUE_ALL;this.model.setProperty("/bEnabledFilterButton",!m);return d&&g&&j&&l;},setToolbarHeight:function(){this.model.setProperty("/filterBarHeight","4rem");},onReportPress:function(e){var o=e.getParameter("item"),b=o.getText(),d=this._getReportData();if(b==='View'){C.publish(c.ON_SHOW_REPORT_REQUEST,d);}else{C.publish(c.ON_DOWNLOAD_REPORT_REQUEST,d);}},_getReportData:function(){return{executionScopes:this.model.getProperty("/executionScopes"),executionScopeTitle:this.model.getProperty("/executionScopeTitle"),analysisDurationTitle:this.model.getProperty("/analysisDurationTitle")};},onRowSelection:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject();this.elementTree.setSelectedElement(s.context.id,false);this.model.setProperty("/selectedIssue/details",s.details);}},_setSelectedRule:function(s){var b,d;if(this.model.getProperty("/visibleIssuesCount")>0){b=this.structuredIssuesModel[s.ruleLibName][s.ruleId];d=jQuery.extend(true,{},s);d.issues=b;d.resolutionUrls=b[0].resolutionUrls;this.issueTable.setSelectedIndex(0);this.model.setProperty("/selectedIssue/details",d.details);this.model.setProperty("/selectedIssue",d);this._setIconAndColorToIssue(d.issues);}else{this.model.setProperty("/selectedIssue",null);}},_setIconAndColorToIssue:function(b){b.forEach(function(e){switch(e.severity){case a.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:e.severityIcon=i.severityIcons.Low;e.severityColor=a.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR;break;case a.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:e.severityIcon=i.severityIcons.Medium;e.severityColor=a.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR;break;case a.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:e.severityIcon=i.severityIcons.High;e.severityColor=a.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR;break;}});}});});
sap.ui.predefine('sap/ui/support/supportRules/ui/controllers/Main.controller',["sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/Storage","sap/ui/thirdparty/URI","sap/m/library"],function(B,J,C,S,c,a,s,U,l){"use strict";return B.extend("sap.ui.support.supportRules.ui.controllers.Main",{onInit:function(){this.model=S;this.getView().setModel(this.model);this.resizeDown();this.setCommunicationSubscriptions();this.initSettingsPopoverModel();this.hidden=false;this.model.setProperty("/hasNoOpener",window.opener?false:true);this.model.setProperty("/constants",a);this.updateShowButton();this._setContextSettings();this.bAdditionalViewLoaded=false;C.subscribe(c.UPDATE_SUPPORT_RULES,function(){if(!this.bAdditionalViewLoaded){this.bAdditionalViewLoaded=true;this.loadAdditionalUI();}},this);},loadAdditionalUI:function(){this._issuesPage=sap.ui.xmlview(this.getView().getId()+"--issues","sap.ui.support.supportRules.ui.views.Issues");this.byId("navCon").insertPage(this._issuesPage);},onAfterRendering:function(){C.publish(c.POST_UI_INFORMATION,{version:sap.ui.getVersionInfo(),location:new U(jQuery.sap.getModulePath("sap.ui.support"),window.location.origin+window.location.pathname).toString()});},initSettingsPopoverModel:function(){var b=new U(sap.ui.resource('sap.ui.support',''),window.location.origin+window.location.pathname)._string,d=sap.ui.version;this.model.setProperty("/supportAssistantOrigin",b);this.model.setProperty("/supportAssistantVersion",d);},copySupportAssistantOriginToClipboard:function(e){var b=this.model.getProperty("/supportAssistantOrigin"),d=function(e){if(e.clipboardData){e.clipboardData.setData('text/plain',b);}else{e.originalEvent.clipboardData.setData('text/plain',b);}e.preventDefault();};if(window.clipboardData){window.clipboardData.setData("text",b);}else{document.addEventListener('copy',d);document.execCommand('copy');document.removeEventListener('copy',d);}},setCommunicationSubscriptions:function(){var p;C.subscribe(c.CURRENT_LOADING_PROGRESS,function(d){var i=d.value,P=this.byId("progressIndicator");if(d.value<100){this.model.setProperty("/showProgressIndicator",true);clearTimeout(p);p=setTimeout(function(){this.model.setProperty("/showProgressIndicator",false);}.bind(this),2500);}else{setTimeout(function(){this.model.setProperty("/showProgressIndicator",false);}.bind(this),2000);}P.setDisplayValue(a.RULESET_LOADING+" "+i+"%");this.model.setProperty("/progress",i);},this);C.subscribe(c.ON_ANALYZE_FINISH,function(d){this._clearProcessIndicator();this.ensureOpened();this.model.setProperty("/showProgressIndicator",false);this.model.setProperty("/coreStateChanged",false);this.model.setProperty("/lastAnalysisElapsedTime",d.elapsedTime);this.goToIssues();this.model.setProperty("/analyzedFinish",true);},this);C.subscribe(c.ON_PROGRESS_UPDATE,function(d){var b=d.currentProgress,e=this.byId("progressIndicator");e.setDisplayValue(b+"/"+100);this.model.setProperty("/progress",b);},this);C.subscribe(c.ON_CORE_STATE_CHANGE,function(){this.model.setProperty("/coreStateChanged",true);},this);},resizeUp:function(){C.publish(c.RESIZE_FRAME,{bigger:true});},ensureOpened:function(){C.publish(c.ENSURE_FRAME_OPENED);},resizeDown:function(){C.publish(c.RESIZE_FRAME,{bigger:false});},onSettings:function(e){C.publish(c.ENSURE_FRAME_OPENED);if(!this._settingsPopover){this._settingsPopover=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.StorageSettings",this);this.getView().addDependent(this._settingsPopover);}var t=this,o=e.getSource();setTimeout(function(){t._settingsPopover.openBy(o);});},goToAnalysis:function(e){this._setActiveView("analysis");},goToIssues:function(e){this._setActiveView("issues");},_pingUrl:function(u){return jQuery.ajax({type:"HEAD",async:true,context:this,url:u});},_redirectToUrlWithFallback:function(u){this._pingUrl(u).then(function success(){l.URLHelper.redirect(u,true);},function error(){jQuery.sap.log.info("Support Assistant tried to load documentation link in "+u+"but fail");u="https://ui5.sap.com/#/topic/57ccd7d7103640e3a187ed55e1d2c163";l.URLHelper.redirect(u,true);});},goToWiki:function(){var u="",v="",f=sap.ui.getVersionInfo().version,m=jQuery.sap.Version(f).getMajor(),M=jQuery.sap.Version(f).getMinor(),o=window.location.origin;if(M%2!==0){M--;}v+=String(m)+"."+String(M);if(o.indexOf("veui5infra")!==-1){u=o+"/sapui5-sdk-internal/#/topic/57ccd7d7103640e3a187ed55e1d2c163";}else{u=o+"/demokit-"+v+"/#/topic/57ccd7d7103640e3a187ed55e1d2c163";}this._redirectToUrlWithFallback(u);},setRulesLabel:function(b){var d=0;if(b===null){return"Rules ("+d+")";}else{b.forEach(function(e,f){d+=e.rules.length;});return"Rules ("+d+")";}},updateShowButton:function(){this.byId("sapSTShowButtonBar").setVisible(this.hidden);},toggleHide:function(){this.hidden=!this.hidden;this.updateShowButton();C.publish(c.TOGGLE_FRAME_HIDDEN,this.hidden);},_clearProcessIndicator:function(){var p=this.byId("progressIndicator");p.setDisplayValue("None");this.model.setProperty("/progress",0.1);},_setContextSettings:function(){var b=s.readPersistenceCookie(a.COOKIE_NAME);if(b){this.model.setProperty("/persistingSettings",true);var d=s.getSelectedContext();if(d){this.model.setProperty("/analyzeContext",d.analyzeContext);this.model.setProperty("/subtreeExecutionContextId",d.subtreeExecutionContextId);}else{this.model.setProperty("/analyzeContext",this.model.getProperty("/analyzeContext"));this.model.setProperty("/subtreeExecutionContextId","");}}},_setActiveView:function(i){this.byId("issuesBtn").setType(sap.m.ButtonType.Default);this.byId("analysisBtn").setType(sap.m.ButtonType.Default);this.byId(i+"Btn").setType(sap.m.ButtonType.Emphasized);this.byId("navCon").to(this.byId(i),"show");this.ensureOpened();}});});
sap.ui.predefine('sap/ui/support/supportRules/ui/external/ElementTree',["jquery.sap.global"],function(q){"use strict";
function _(h){return(typeof h==="object"&&!Array.isArray(h)&&h!==null);}
function a(o){return"<ul "+o.attributes.join(" ")+">";}
function b(){return"</ul>";}
function c(o,h){var i="<li data-id=\""+o.id+"\" ";if(h){i+="issue";}i+=">";return i;}
function d(){return"</li>";}
function e(h,p){var i="<offset style=\"padding-left:"+p+"px\" >";if(h.content.length>0){i+="<arrow down=\"true\"></arrow>";}else{i+="<place-holder></place-holder>";}i+="</offset>";return i;}
function f(h,n){var s=h.name.split(".");var i=s[s.length-1];var j=h.name.replace(i,"");var k=(n>0)?"showNumbOfIssues":"hideNumbOfIssues";return"<tag data-search=\""+h.name+h.id+"\">"+"&#60;"+"<namespace>"+j+"</namespace>"+i+"<attribute>&#32;id=\"<attribute-value>"+h.id+"</attribute-value>\"</attribute>"+"&#62;"+"</tag>"+"<span class = "+k+">["+n+"  issue(s)] </span>";}
function g(h,p){while(h.nodeName!==p){if(h.nodeName==="CONTROL-TREE"){break;}h=h.parentNode;}return h;}
function E(i,h){var j=_(h);var o;if(j){o=h;}else{o={};}this._ElementTreeContainer=document.getElementById(i);this.onIssueCountClicked=o.onIssueCountClicked?o.onIssueCountClicked:function(){};this.onSelectionChanged=o.onSelectionChanged?o.onSelectionChanged:function(s){};this.onHoverChanged=o.onHoverChanged?o.onHoverChanged:function(k){};this.onMouseOut=o.onMouseOut?o.onMouseOut:function(){};this.onInitialRendering=o.onInitialRendering?o.onInitialRendering:function(){};this.setData(o.data);}
E.prototype.init=function(){if(!this._ElementTreeContainer){return;}this._createHTML();this._createHandlers();this.onInitialRendering();};
E.prototype.getData=function(){return this._data;};
E.prototype.setData=function(h){var o=this.getData();var i=_(h);if(i===false){q.sap.log.warning("The parameter should be an Object");return;}if(JSON.stringify(o)===JSON.stringify(h)){return;}this._data=h;if(this._isFirstRendering===undefined){this.init();this._isFirstRendering=true;}else{this._createTree();}return this;};
E.prototype.setContainerId=function(i){this._ElementTreeContainer=document.getElementById(i);this.init();};
E.prototype.getSelectedElement=function(){return this._selectedElement;};
E.prototype.setSelectedElement=function(h,n){var s;if(typeof h!=="string"){q.sap.log.warning("Please use a valid string parameter");return;}s=this._ElementTreeContainer.querySelector("[data-id='"+h+"']");if(s===null){q.sap.log.warning("The selected element is not a child of the ElementTree");return;}this._selectedElement=s;this._selectTreeElement(s,n);return this;};
E.prototype.clearSelection=function(){var s=this._ElementTreeContainer.querySelector("[selected]");if(s){s.removeAttribute("selected");}};
E.prototype._createHTML=function(){var h;h=this._createFilter();h+=this._createTreeContainer();this._ElementTreeContainer.innerHTML=h;this._setReferences();if(this.getData()!==undefined){this._createTree();}};
E.prototype._createFilter=function(){return"<filter>"+"<end>"+"<label><input type=\"checkbox\" issues checked/>Issues</label>"+"<label><input type=\"checkbox\" namespaces checked/>Namespaces</label>"+"<label><input type=\"checkbox\" attributes/>Attributes</label>"+"</end>"+"</filter>";};
E.prototype._createTreeContainer=function(){return"<tree show-namespaces show-problematic-elements></tree>";};
E.prototype._createTree=function(){var h=this.getData().controls;this._treeContainer.innerHTML=this._createTreeHTML(h);};
E.prototype._createTreeHTML=function(h,l){if(h===undefined||h.length===0){return"";}var i="";var n=l||0;var p=++n*10;var t=this;var j=this.getData().issuesIds;h.forEach(function(k){i+=a({attributes:["expanded=\"true\""]});var m=j[k.id]!==undefined?true:false;var o=0;var o=m?j[k.id].length:0;i+=c({id:k.id},m);i+=e(k,p);i+=f(k,o);i+=d();i+=t._createTreeHTML(k.content,n);i+=b();});return i;};
E.prototype._toggleCollapse=function(t){var h=g(t.parentNode,"UL");if(t.getAttribute("right")==="true"){t.removeAttribute("right");t.setAttribute("down","true");h.setAttribute("expanded","true");}else if(t.getAttribute("down")==="true"){t.removeAttribute("down");h.removeAttribute("expanded");t.setAttribute("right","true");}};
E.prototype._selectTreeElement=function(t,n){var h=g(t,"LI");var i=h.attributes["data-id"];if(!i){return;}var j=i.value;if(j===this._ElementTreeContainer.id){return;}this._scrollToElement(h,window);if(n){this.onSelectionChanged(j);}this.clearSelection();h.setAttribute("selected","true");if(n){this.onIssueCountClicked(j);}};
E.prototype._scrollToElement=function(t,w){var h=this._treeContainer.offsetHeight-this._treeContainer.offsetTop+this._treeContainer.scrollTop;if(t.offsetTop>h||t.offsetTop<this._treeContainer.scrollTop){this._treeContainer.scrollTop=t.offsetTop-w.innerHeight/6;}};
E.prototype._searchInTree=function(u){var s=this._ElementTreeContainer.querySelectorAll("[data-search]");var h=u.toLocaleLowerCase();var j;for(var i=0;i<s.length;i++){j=s[i].getAttribute("data-search").toLocaleLowerCase();if(j.indexOf(h)!==-1){s[i].parentNode.setAttribute("matching",true);}else{s[i].parentNode.removeAttribute("matching");}}};
E.prototype._removeAttributesFromSearch=function(){var h=this._treeContainer.querySelectorAll("[matching]");for(var i=0;i<h.length;i++){h[i].removeAttribute("matching");}};
E.prototype._setSearchResultCount=function(h){this._filterContainer.querySelector("results").innerHTML="("+h+")";};
E.prototype._onArrowClick=function(h){var t=h.target;if(t.nodeName==="ARROW"){this._toggleCollapse(t);}else if(q(h.srcElement).hasClass("showNumbOfIssues")){this._selectTreeElement(t,true);}};
E.prototype._onSearchInput=function(h){var t=h.target;var s;if(t.getAttribute("search")!==null){if(t.value.length!==0){this._searchInTree(t.value);}else{this._removeAttributesFromSearch("matching");}s=this._treeContainer.querySelectorAll("[matching]").length;this._setSearchResultCount(s);}};
E.prototype._onSearchEvent=function(h){var s;if(h.target.value.length===0){this._removeAttributesFromSearch("matching");s=this._treeContainer.querySelectorAll("[matching]").length;this._setSearchResultCount(s);}};
E.prototype._onOptionsChange=function(h){var t=h.target;if(t.getAttribute("filter")!==null){if(t.checked){this._treeContainer.setAttribute("show-filtered-elements",true);}else{this._treeContainer.removeAttribute("show-filtered-elements");}}if(t.getAttribute("issues")!==null){if(t.checked){this._treeContainer.setAttribute("show-problematic-elements",true);}else{this._treeContainer.removeAttribute("show-problematic-elements");}}if(t.getAttribute("namespaces")!==null){if(t.checked){this._treeContainer.setAttribute("show-namespaces",true);}else{this._treeContainer.removeAttribute("show-namespaces");}}if(t.getAttribute("attributes")!==null){if(t.checked){this._treeContainer.setAttribute("show-attributes",true);}else{this._treeContainer.removeAttribute("show-attributes");}}};
E.prototype._onTreeElementMouseHover=function(h){var t=g(h.target,"LI");var i=this._ElementTreeContainer.querySelector("[hover]");if(i){i.removeAttribute("hover");}t.setAttribute("hover","true");var j=t.attributes["data-id"];this.onHoverChanged(j&&j.value);};
E.prototype._onTreeElementMouseOut=function(h){this.onMouseOut();};
E.prototype._createHandlers=function(){this._treeContainer.onclick=this._onArrowClick.bind(this);this._filterContainer.onkeyup=this._onSearchInput.bind(this);this._filterContainer.onsearch=this._onSearchEvent.bind(this);this._filterContainer.onchange=this._onOptionsChange.bind(this);this._ElementTreeContainer.onmouseover=this._onTreeElementMouseHover.bind(this);this._ElementTreeContainer.onmouseout=this._onTreeElementMouseOut.bind(this);};
E.prototype._setReferences=function(){this._filterContainer=this._ElementTreeContainer.querySelector("filter");this._treeContainer=this._ElementTreeContainer.querySelector("tree");};
return E;});
sap.ui.predefine('sap/ui/support/supportRules/ui/external/Highlighter',[],function(){"use strict";var _=null;
function a(){_.style.display="none";}
function b(){_.style.display="block";}
function c(){var h=document.createElement("div");h.style.cssText="box-sizing: border-box;border:1px solid blue;background: rgba(20, 20, 200, 0.4);position: absolute";var d=document.createElement("div");d.id="ui5-highlighter";d.style.cssText="position: fixed;top:0;right:0;bottom:0;left:0;z-index: 1000;overflow: hidden;";d.appendChild(h);document.body.appendChild(d);_=document.getElementById("ui5-highlighter");_.onmouseover=a;}
return{highlight:function(e){var h;var t;var d;if(_===null&&!document.getElementById("ui5-highlighter")){c();}else{b();}h=_.firstElementChild;t=document.getElementById(e);if(t){d=t.getBoundingClientRect();h.style.top=d.top+"px";h.style.left=d.left+"px";h.style.height=d.height+"px";h.style.width=d.width+"px";}return this;},hideHighLighter:a};});
sap.ui.predefine('sap/ui/support/supportRules/ui/models/SelectionUtils',["sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/core/util/File"],function(c,s,S,F){"use strict";var n=function n(a,b){return a-b;};var d={model:S,isRowAGroup:function(r){if(!r){return false;}var R=r.getModel();if(!R){return false;}var b=r.getBindingContext(),p=b.getPath();return R.getProperty(p+"/rules")!==undefined;},getChildIndicesRange:function(r,R){var o=r.getModel(),b=r.getBindingContext(),p=b.getPath(),m=o.getProperty(p),f=R+1,t=R,k;for(k in m){if(Number.isInteger(Number.parseInt(k,10))){t++;}}if(f>t){return null;}return{from:f,to:t};},selectAllRows:function(b){var m=this.model,t=m.getProperty("/treeViewModel/"),l;for(var i in t){if(Number.isInteger(Number.parseInt(i,10))){m.setProperty("/treeViewModel/"+i+"/selected",b);l=m.getProperty("/treeViewModel/"+i);for(var k in l){if(Number.isInteger(Number.parseInt(k,10))){m.setProperty("/treeViewModel/"+i+"/"+k+"/selected",b);}}}}if(s.readPersistenceCookie(c.COOKIE_NAME)){this.persistSelection();}},updateLibrarySelection:function(p,b){var m=this.model,r=this.getRowContextIndexByPath(p),l,a;while(r>=0){a=this.treeTable.getContextByIndex(r);p=a.getPath();l=m.getProperty(p);if(l.type==="lib"){break;}r--;}if(b){for(var i in l){if(Number.isInteger(Number.parseInt(i,10))&&!l[i].selected){return;}}this.treeTable.addSelectionInterval(r,r);}else{this.treeTable.removeSelectionInterval(r,r);}m.setProperty(p+"/selected",b);},updateTreeViewTempRulesSelection:function(t){this.treeTable.expand(0);var a=true;for(var r in t){var R=Number.parseInt(r,10);if(!Number.isInteger(R)){continue;}R++;var b=t[r];var m=false;var p=s.getSelectedRules();for(var i=0;i<p.length;i++){var e=p[i];if(b.id===e.ruleId&&b.libName===e.libName){m=true;break;}}if(m){this.treeTable.addSelectionInterval(R,R);}else{a=false;this.treeTable.removeSelectionInterval(R,R);}}if(a){this.model.setProperty("/treeViewModel/0/selected",true);this.treeTable.addSelectionInterval(0,0);}},getRowContextIndexByPath:function(p){var r=0,R=this.treeTable.getContextByIndex(r);while(R){if(R.getPath()==p){return r;}r++;R=this.treeTable.getContextByIndex(r);}},_syncSelections:function(N){var I=this._buildTreeTableIndex(),l=[],L={},m;for(var i in N){if(Number.isInteger(Number.parseInt(i,10))){for(var k in N[i]){var r=I[N[i][k].id];if(Number.isInteger(Number.parseInt(k,10))&&r&&r.selected){N[i][k].selected=r.selected;if(l.indexOf(N[i][k].libName)<0){l.push(N[i][k].libName);}}}}}this.model.setProperty("/treeViewModel",N);m=this._buildTreeTableIndex();l.forEach(function(a){if(m[a]){L[a]=m[a];}});for(var K in m){if(m[K].type==="lib"&&!I[K]){L[K]=m[K];}}this.updateLibrariesSelection(L);},updateLibrariesSelection:function(l){var m=this.model,L,b;for(var a in l){L=m.getProperty(l[a].path);b=true;for(var i in L){if(Number.isInteger(Number.parseInt(i,10))){if(!L[i].selected){b=false;break;}}}this.updateLibrarySelection(l[a].path,b);}},initializeSelection:function(i){var p=this.model.getProperty("/persistingSettings"),m=this.model,I={},l=[],a;if(p){a=s.getSelectedRules()||[];if(a.length===0){return;}I=this._buildTreeTableIndex();a.forEach(function(r){var R=I[r.ruleId];if(R){m.setProperty(R.path+"/selected",true);this.treeTable.addSelectionInterval(R.index,R.index);if(I[R.libName]){l[R.libName]=I[R.libName];}}},this);this.updateLibrariesSelection(l);}else if(i){this.treeTable.selectAll();}},initializeModelSelection:function(){var t=this.model.getProperty("/treeViewModel");var r=s.getSelectedRules();var T=this.treeTable;T.expandToLevel(1);var i=-1;Object.keys(t).map(function(N){return Number.parseInt(N,10);}).sort(n).forEach(function(l,L){i+=1;var a=i;var A=true;Object.keys(t[l]).filter(function(R){return Number.isInteger(Number.parseInt(R,10));}).map(function(N){return Number.parseInt(N,10);}).sort(n).forEach(function(R,b){i+=1;var o=t[l][R];r.forEach(function(e){if(o.id===e.ruleId&&o.libName===e.libName){o.selected=true;}});if(o.selected===true){T.addSelectionInterval(i,i);}else{T.removeSelectionInterval(i,i);A=false;}});if(i===a){A=false;}t[l].selected=A;if(A){T.addSelectionInterval(a,a);}else{T.removeSelectionInterval(a,a);}});},_buildTreeTableIndex:function(){var i=0,p=this.treeTable.getBinding().getPath()+'/',m=this.model,I={},l=m.getProperty(p+i),a=0,g=0,r;while(l){I[l.name]={index:g,path:p+i,libName:l.name,type:"lib",selected:l.selected};g++;r=m.getProperty(p+i+'/'+a);while(r){I[r.id]={index:g,path:p+i+'/'+a,libName:r.libName,type:"rule",selected:r.selected};a++;g++;r=m.getProperty(p+i+'/'+a);}i++;l=m.getProperty(p+i);}return I;},getVisualIndex:function(r){var R=this.treeTable.getRows(),o,i;for(i=0;i<R.length;i++){o=R[i];if(o.getBindingContext()==r){return i;}}},selectionChangeHandler:function(e){var i=e.getParameter("rowIndex"),r=e.getParameter("rowContext"),R=e.getParameter("rowIndices"),u=e.getParameter("userInteraction");if(e.getParameter("selectAll")){this.selectAllRows(true);return;}if(i===-1){this.selectAllRows(false);return;}if(!u||R.length!=1||R[0]!=i){return;}var t=this.treeTable,a=t.getRows(),v=this.getVisualIndex(r),o=a[v],b=o.getModel(),B=o.getBindingContext(),p=B.getPath(),m=b.getProperty(p),f=!b.getProperty(p+"/selected"),C,k;b.setProperty(p+"/selected",f);if(this.isRowAGroup(o)){C=this.getChildIndicesRange(o,i);if(!C){return;}for(k in m){if(Number.isInteger(Number.parseInt(k,10))){b.setProperty(p+"/"+k+"/selected",f);}}if(t.isExpanded(i)){if(f){t.addSelectionInterval(C.from,C.to);}else{t.removeSelectionInterval(C.from,C.to);}}}else{this.updateLibrarySelection(p,f);}if(s.readPersistenceCookie(c.COOKIE_NAME)){this.persistSelection();}},toggleOpenStateHandler:function(e){var i=e.getParameter("rowIndex"),r=e.getParameter("rowContext"),E=e.getParameter("expanded"),t=this.treeTable,R=t.getRows(),v=this.getVisualIndex(r),o=R[v],a=o.getModel(),b=o.getBindingContext(),p=b.getPath(),m=a.getProperty(p),k,f,g=i+1;if(!E){return;}for(k in m){if(Number.isInteger(Number.parseInt(k,10))){f=a.getProperty(p+"/"+k+"/selected");if(f){t.addSelectionInterval(g,g);}else{t.removeSelectionInterval(g,g);}g++;}}},getSelectedRulesPlain:function(){var m=this.model,a=[],r;for(var i in m.getProperty("/treeViewModel/")){if(Number.isInteger(Number.parseInt(i,10))){for(var k in m.getProperty("/treeViewModel/"+i)){r=m.getProperty("/treeViewModel/"+i+"/"+k);if(Number.isInteger(Number.parseInt(k,10))&&r&&r.selected){a.push({ruleId:r.id,libName:r.libName});}}}}return a;},persistSelection:function(){var a=this.getSelectedRulesPlain();s.setSelectedRules(a);},exportSelectedRules:function(t,a){var b=this.getSelectedRulesPlain();var r={title:t,description:a,selections:b};var e=JSON.stringify(r);F.save(e,c.RULE_SELECTION_EXPORT_FILE_NAME,'json','text/plain');},isValidSelectionImport:function(I){var b=true;if(!I.hasOwnProperty("title")){b=false;}if(!I.hasOwnProperty("description")){b=false;}if(!I.hasOwnProperty("selections")){b=false;}else if(!Array.isArray(I.selections)){b=false;}else{for(var i=0;i<I.selections.length;i++){var r=I.selections[i];if(!r.hasOwnProperty("ruleId")||!r.hasOwnProperty("libName")){b=false;break;}}}return b;}};return d;});
sap.ui.predefine('sap/ui/support/supportRules/ui/models/SharedModel',["sap/ui/support/library","sap/ui/model/json/JSONModel"],function(l,J){"use strict";var A=l.Audiences,C=l.Categories,S=l.Severity,e={global:{key:"global",displayName:"Global",description:"The Rules will be / are executed on the complete application with all loaded elements and components, including all previously loaded pages"},subtree:{key:"subtree",displayName:"Sub-tree",description:"The Rules will be / are executed on the specified sub-tree root element, including all child elements (aggregated sub-elements)"},components:{key:"components",displayName:"Component(s)",description:"The Rules will be / are executed on the selected components from the list of currently loaded components (or fragments)"}};var m=new J({selectedRule:null,libraries:null,selectedIssue:null,issues:[],progress:0.1,showProgressIndicator:false,coreStateChanged:true,analyzePressed:false,selectedRulePreviewKey:"ruleProperties",selectedRuleCreateKey:"ruleProperties",selectedRuleEditKey:"ruleProperties",selectedSetPreviewKey:"availableRules",newRule:{},newRuleStringified:"",updateRuleStringified:"",subtreeExecutionContextId:"",availableComponents:[],audiences:A,categories:C,severities:S,audiencesFilter:["All"].concat(Object.keys(A)),categoriesFilter:["All"].concat(Object.keys(C)),severitiesFilter:["All"].concat(Object.keys(S)),newEmptyRule:{libName:"",id:"",categories:[C.Other],audiences:[A.Internal],title:"",description:"",resolution:"",resolutionurls:[],check:"function (oIssueManager, oCoreFacade, oScope) {\n\t/* \n\t oIssueManager - allows you to add new issues with the addIssue() method \n\t oCoreFacade - gives you access to state of the core: getMetadata(), getUIAreas(), getComponents(), getModels() \n\t oScope - retrieves elements in the scope with these methods: getElements(), getElementsByClassName(className), getLoggedObjects(type) \n\t fnResolve - optional, passed when the rule property async is set to true \n\t*/ \n}",selected:true,async:false},editRule:null,tempLink:{href:"",text:""},resolveDescription:"Make sure to resolve your async rule by using the passed fnResolve function",selectedRuleStringify:"",analyzeContext:e.global,executionScopes:e,executionScopeTitle:"Execution scope",lastAnalysisElapsedTime:"",analysisDurationTitle:"Last analysis duration",costants:"",executionScopeComponents:[],persistingSettings:false,loadingAdditionalRuleSets:false,analyzedFinish:false,selectedRules:true,filteredIssues:null,issuesCount:0,visibleRowCount:5,supportAssistantOrigin:"",supportAssistantVersion:"",initialRulesLoading:true});return m;});
sap.ui.predefine('sap/ui/support/supportRules/ui/models/formatter',["sap/ui/support/supportRules/Constants"],function(c){"use strict";return{resolutionUrl:function(u,U){var s=u.indexOf(U)===u.length-1?"":", \u00a0";return U.text+s;},hasResolutionUrls:function(u){if(u&&u.length>0){return true;}return false;},filteredText:function(s,a,b,e){var r="Filtered by: ";r+=s===c.FILTER_VALUE_ALL?"":"Severity - "+s+";";r+=a===c.FILTER_VALUE_ALL?"":" Category    - "+a+";";r+=b===c.FILTER_VALUE_ALL?"":" Audience - "+b+";";r+=e===c.FILTER_VALUE_ALL?"":" Control Element - "+e+";";return r;}};});
sap.ui.predefine('sap/ui/support/supportRules/util/RuleValidator',[],function(){'use strict';var R={validateVersion:function(v){if(!v||typeof v!=='string'){return false;}var a=/^\*$|^\-$|^\d\.\d\d$/;if(v.match(a)){return true;}return false;},validateRuleCollection:function(e,E){if(e&&Array.isArray(e)&&e.length){for(var i=0;i<e.length;i++){if(E.hasOwnProperty(e[i])){continue;}else{return false;}}return true;}return false;},validateId:function(i){var a=/^[a-z][a-zA-Z]+$/;if(!i||typeof i!=='string'){return false;}if(i.match(a)&&this.validateStringLength(i,6,50)){return true;}return false;},validateStringLength:function(s,m,M){return m<=s.length&&s.length<=M;}};return R;},false);
sap.ui.predefine('sap/ui/support/supportRules/util/StringAnalyzer',[],function(){"use strict";var S={calculateLevenshteinDistance:function(w,W){var l=w.length;var L=W.length;if(l===0){return L;}if(L===0){return l;}var m=new Array(L+1);var i;for(i=0;i<=L;i++){m[i]=new Array(l+1);m[i][0]=i;}var I;for(I=0;I<=l;I++){m[0][I]=I;}var a=0;var b;var c;for(b=1;b<=L;b++){for(c=1;c<=l;c++){var d=m[b-1][c]+1;var e=m[b][c-1]+1;var s=m[b-1][c-1];if(w[c]!==W[b]){s+=1;}a=Math.min(d,e,s);m[b][c]=a;}}return a;}};return S;},false);
sap.ui.predefine('sap/ui/support/supportRules/util/Utils',[],function(){"use strict";var U={isDistributionOpenUI5:function(v){var r=false,f="";try{f=v.gav?v.gav:v.name;r=f.indexOf('openui5')!==-1?true:false;}catch(e){return r;}return r;},canLoadInternalRules:function(){var f=jQuery.sap.getModulePath("sap.ui.support").replace("/resources/","/test-resources/")+"/internal/.ping";var c;jQuery.ajax({type:"HEAD",async:false,url:f,success:function(){c=true;},error:function(){c=false;}});return c;}};return U;});
sap.ui.require.preload({
	"sap/ui/support/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.support","type":"library","embeds":[],"applicationVersion":{"version":"1.56.5"},"title":"UI5 library: sap.ui.support","description":"UI5 library: sap.ui.support","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":[]},"sap.ui5":{"dependencies":{"minUI5Version":"1.56","libs":{"sap.ui.core":{"minVersion":"1.56.5"}}},"library":{"i18n":false,"css":false,"content":{"controls":[],"elements":[],"types":["sap.ui.support.Severity"],"interfaces":[]}}}}',
	"sap/ui/support/supportRules/ui/views/Analysis.view.xml":'<mvc:View controllerName="sap.ui.support.supportRules.ui.controllers.Analysis" height="100%" xmlns="sap.ui.table" xmlns:m="sap.m" xmlns:l="sap.ui.layout" xmlns:mvc="sap.ui.core.mvc" xmlns:t="sap.ui.table"><m:NavContainer id="rulesNavContainer" afterNavigate="onAfterNavigate"><l:Splitter id="rulesDisplayPage"><l:contentAreas><m:Page showHeader="true" showSubHeader="{= ${/selectedSetPreviewKey} === \'availableRules\' }"><m:headerContent><m:Bar><m:contentLeft><m:IconTabHeader id="ruleSetsView" select="onSelectedRuleSets" selectedKey="{/selectedSetPreviewKey}" class="customIconTabHeader"><m:items><m:IconTabFilter key="availableRules" text="Available Rulesets"/><m:IconTabFilter key="additionalRulesets" text="Additional Rulesets"/></m:items></m:IconTabHeader></m:contentLeft><m:contentRight><m:Button class="supportAnalyzeButton" text="Analyze" press="onAnalyze" type="Emphasized"/><m:Button class="supportSettingsButton" icon="sap-icon://settings" press="onAnalyzeSettings" type="Emphasized"/></m:contentRight></m:Bar></m:headerContent><m:subHeader><m:Bar><m:contentLeft><m:Label text="Rule Selections:"/><m:Button text="Export" press="exportSelectedRules"/><m:Button text="Import" press="importSelectedRules"/></m:contentLeft><m:contentRight><m:Button text="Create Rule" icon="sap-icon://add" press="createNewRulePress"/></m:contentRight></m:Bar></m:subHeader><t:TreeTable id="ruleList" collapseRecursive="false" selectionMode="MultiToggle" enableColumnReordering="false" expandFirstLevel="true" rows="{path:\'/treeViewModel\'}" cellClick="onCellClick" class="sapUiSizeCondensed" visible="{= ${/selectedSetPreviewKey} === \'availableRules\' }" visibleRowCountMode="Auto" selectionBehavior="RowSelector" rowActionCount="1" toggleOpenState="onToggleOpenState" rowSelectionChange="onRowSelectionChange"><t:columns><t:Column label="Rules"><t:template><m:Text text="{name}" wrapping="false"/></t:template></t:Column><t:Column label="Categories" width="10rem"><t:template><m:Text text="{categories}" wrapping="false"/></t:template></t:Column></t:columns><t:rowActionTemplate><t:RowAction><t:items><t:RowActionItem icon="sap-icon://edit" text="Edit" press="editRule" visible="{= ${libName} === \'temporary\'}"/><t:RowActionItem icon="sap-icon://delete" text="Delete" press="deleteTemporaryRule" visible="{= ${libName} === \'temporary\'}"/><t:RowActionItem icon="sap-icon://copy" text="Copy" press="duplicateRule" visible="{= ${libName} !== \'temporary\' &amp;&amp; ${type} !== \'lib\'}"/></t:items></t:RowAction></t:rowActionTemplate></t:TreeTable><l:VerticalLayout id="librarySetContainer" width="100%" visible="{= ${/selectedSetPreviewKey} === \'additionalRulesets\' }"><m:Text class="sapUiSupportToolAdditionRuleSetNote" text="The list of available rules is dynamic and changes based on the libraries currently required by your application.         In the table below, you can select and load rulesets from the additional libraries."/><m:Link class="sapUiSupportToolAdditionRuleSetNote" text="See more here" href="https://ui5.sap.com/#/topic/3fc864acf926406194744375aa464fe7" target="_blank"/><m:List id="availableLibrariesSet" mode="MultiSelect" includeItemInSelection="true" items="{path:\'/availableLibrariesSet\'}"><m:StandardListItem title="{}"/></m:List><m:Button class="customMargin" text="Load" type="Emphasized" press="loadMarkedSupportLibraries"/></l:VerticalLayout></m:Page></l:contentAreas></l:Splitter></m:NavContainer></mvc:View>',
	"sap/ui/support/supportRules/ui/views/AnalyzeSettings.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core"><Popover title="{/executionScopeTitle}" contentMinWidth="250px" class="sapUiContentPadding" beforeOpen="onBeforePopoverOpen" placement="Bottom"><content><VBox><RadioButton groupName="analyzeContext" text="{/executionScopes/global/displayName}" select="onContextSelect" selected="{= ${/analyzeContext/key} === \'global\'}" tooltip="{/executionScopes/global/description}"><customData><core:CustomData key="analyzeContext" value="global"/></customData></RadioButton><RadioButton groupName="analyzeContext" text="{/executionScopes/subtree/displayName}" select="onContextSelect" selected="{= ${/analyzeContext/key} === \'subtree\'}" tooltip="{/executionScopes/subtree/description}"><customData><core:CustomData key="analyzeContext" value="subtree"/></customData></RadioButton><l:VerticalLayout class="sapUiSupportToolSettingsPopoverPadding"><Input placeholder="Input sub-root ID" enabled="{= ${/analyzeContext/key} === \'subtree\'}" value="{/subtreeExecutionContextId}" width="300px" liveChange="onExecutionContextChange"/></l:VerticalLayout><RadioButton groupName="analyzeContext" text="{/executionScopes/components/displayName}" select="onContextSelect" selected="{= ${/analyzeContext/key} === \'components\'}" tooltip="{/executionScopes/components/description}"><customData><core:CustomData key="analyzeContext" value="components"/></customData></RadioButton><l:VerticalLayout id="componentsSelectionContainer" content="{/executionScopeComponents}" class="sapUiSupportToolSettingsPopoverPadding"><CheckBox text="{text}" enabled="{= ${/analyzeContext/key} === \'components\'}" select="onScopeComponentSelect" selected="{selected}"/></l:VerticalLayout></VBox></content></Popover></core:FragmentDefinition>',
	"sap/ui/support/supportRules/ui/views/Issues.view.xml":'<mvc:View xmlns="sap.m" controllerName="sap.ui.support.supportRules.ui.controllers.Issues" height="100%" xmlns:l="sap.ui.layout" xmlns:tnt="sap.tnt" xmlns:c="sap.ui.core" xmlns:f="sap.ui.layout.form" xmlns:t="sap.ui.table" xmlns:mvc="sap.ui.core.mvc"><l:Splitter><l:contentAreas><Page class="sapUiSupportToolIssuesPage"><customHeader><Toolbar id="filtersBar" height="{/filterBarHeight}" class="sapUiSupportToolToolbar"><tnt:ToolHeader id="toolHeader" class="sapUiSupportToolIssueHeader" height="4rem" width="100%"><l:VerticalLayout><l:layoutData><OverflowToolbarLayoutData priority="Low"/></l:layoutData><Label text="Severity:" class="customMargin"/><Select id="severityFilter" change="updateIssuesVisibility" selectedKey="{/severityFilter}" items="{/severitiesFilter}" class="customMargin"><c:ListItem key="{}" text="{}"/></Select></l:VerticalLayout><l:VerticalLayout><l:layoutData><OverflowToolbarLayoutData priority="Low"/></l:layoutData><Label text="Category:" class="customMargin"/><Select id="categoryFilter" change="updateIssuesVisibility" selectedKey="{/categoryFilter}" items="{/categoriesFilter}" class="customMargin"><c:ListItem key="{}" text="{}"/></Select></l:VerticalLayout><l:VerticalLayout><l:layoutData><OverflowToolbarLayoutData priority="Low"/></l:layoutData><Label text="Audiences:" class="customMargin"/><Select id="audiencesFilter" change="updateIssuesVisibility" selectedKey="{/audienceFilter}" items="{/audiencesFilter}" class="customMargin"><c:ListItem key="{}" text="{}"/></Select></l:VerticalLayout><l:VerticalLayout><l:layoutData><OverflowToolbarLayoutData priority="Low"/></l:layoutData><Label text="" class="customMargin"/></l:VerticalLayout><ToolbarSpacer/></tnt:ToolHeader><l:VerticalLayout><Label text="" class="customMargin"/><MenuButton id="ReportMenuButton" text="Report" icon="sap-icon://order-status" visible="{= ${/analyzePressed}}"><menu><Menu itemSelected="onReportPress"><items><MenuItem text="View" press="onViewReport"/><MenuItem text="Download" press="onDownloadReport"/></items></Menu></menu></MenuButton></l:VerticalLayout></Toolbar></customHeader><subHeader><Toolbar id="messegeStrip"><FlexBox alignItems="Center" justifyContent="Start"><items><l:VerticalLayout><Text text="{= \'Displaying: \' + ${/visibleIssuesCount} + \' out of \' + ${/issuesCount} + \' (scope: \' + ${/analyzeContext/displayName} + \')\' }"/></l:VerticalLayout></items></FlexBox></Toolbar></subHeader><content><FlexBox alignItems="Center" justifyContent="End"><items><Text text="{parts:[\'/severityFilter\',\'/categoryFilter\',\'/audienceFilter\',\'/elementFilter\'],formatter:\'.formatter.filteredText\'}"><layoutData><FlexItemData growFactor="2"/></layoutData></Text><Button icon="sap-icon://clear-filter" press="clearFiltersAndElementSelection" enabled="{/bEnabledFilterButton}"><layoutData><FlexItemData growFactor="0"/></layoutData></Button></items></FlexBox><t:TreeTable id="issuesList" class="sapUiSupportToolIssuesTreeTable" selectionMode="Single" selectionBehavior="RowOnly" enableColumnReordering="false" expandFirstLevel="true" rows="{path:\'/issues\'}" rowSelectionChange="onRowSelectionChanged" rowHeight="24" visibleRowCountMode="Auto"><t:columns><t:Column label="Issues" resizable="false"><t:template><FormattedText htmlText="{formattedName}"/></t:template></t:Column></t:columns></t:TreeTable></content></Page><Page enableScrolling="false"><customHeader><Bar class="selectedRuleTitle"><contentLeft><Title text="{/selectedIssue/name}"/></contentLeft></Bar></customHeader><content><Panel visible="{= ${/selectedIssue} !== null}" height="100%"><Text text="{/selectedIssue/description}" class="sapUiTinyMarginBeginEnd sapUiTinyMarginBottom"/><t:Table rows="{path:\'/selectedIssue/issues\'}" selectionMode="Single" rowHeight="24" selectionBehavior="RowOnly" enableColumnReordering="false" visibleRowCount="{/visibleRowCount}" rowSelectionChange="onRowSelection" id="issueTable"><t:columns><t:Column width="36px" resizable="false"><t:template><c:Icon class="issuesSeverityIcon" color="{severityColor}" src="{severityIcon}"><c:layoutData><FlexItemData growFactor="1"/></c:layoutData></c:Icon></t:template></t:Column><t:Column sortProperty="context/id" filterProperty="context/id" label="Control Id" resizable="false"><t:template><Text text="{context/id}" wrapping="false" tooltip="{context/id}"/></t:template></t:Column><t:Column sortProperty="context/className" filterProperty="context/className" label="Class name" resizable="false"><t:template><Text text="{context/className}" wrapping="false" tooltip="{context/className}"/></t:template></t:Column></t:columns></t:Table><f:SimpleForm editable="true" visible="{= ${/visibleIssuesCount} &gt; 0}" layout="ResponsiveGridLayout" breakpointM="400"><f:content><Label text="Details"/><Text text="{/selectedIssue/details}" width="100%" visible="{= ${/selectedIssue/details} !== \'\'}"/><Label text="Resolution"/><Text text="{/selectedIssue/resolution}"/><Label text="URLs" visible="{parts:[\'/selectedIssue/resolutionUrls\'],formatter:\'.formatter.hasResolutionUrls\'}"/><HBox wrap="Wrap" items="{/selectedIssue/resolutionUrls}"><Link text="{parts:[\'/selectedIssue/resolutionUrls\',\'\'],formatter:\'.formatter.resolutionUrl\'}" press="openDocumentation"/></HBox></f:content></f:SimpleForm></Panel></content></Page><c:HTML id="elementTreeContainer" content="&lt;control-tree&gt;  &lt;/control-tree&gt;"/></l:contentAreas></l:Splitter></mvc:View>',
	"sap/ui/support/supportRules/ui/views/Main.view.xml":'<mvc:View height="100%" controllerName="sap.ui.support.supportRules.ui.controllers.Main" xmlns="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:l="sap.ui.layout" xmlns:c="sap.ui.core"><Page showHeader="false"><l:FixFlex><l:fixContent><Bar class="sapContrast" design="SubHeader" id="sapSTShowButtonBar"><contentMiddle><Text text="{/constants/SUPPORT_ASSISTANT_NAME}" class="STCustomHeaderInfo"/><c:Icon src="sap-icon://full-screen" press="toggleHide" class="STCustomHeaderInfo"/></contentMiddle></Bar><Bar class="sapContrast" design="SubHeader"><contentLeft><Image src="../ui/images/Logo_O_22x22.png" densityAware="false"/><Text text="{/constants/SUPPORT_ASSISTANT_NAME}" class="STCustomHeaderInfo"/></contentLeft><contentMiddle><FlexBox height="100%" width="500px" alignItems="Center" justifyContent="Center"><ProgressIndicator id="progressIndicator" percentValue="{/progress}" displayValue="None" showValue="true" state="Success" visible="{/showProgressIndicator}"><layoutData><FlexItemData growFactor="1"/></layoutData></ProgressIndicator><Text id="coreStateLabel" visible="{= ${/analyzePressed} === true &amp;&amp; ${/coreStateChanged} === true &amp;&amp; ${/showProgressIndicator} === false }" text="Application state has changed and issues view is not in sync. Analyze again. "/><Text id="elapsedTimeLabel" visible="{= ${/analyzePressed} === true &amp;&amp; ${/coreStateChanged} === false &amp;&amp; ${/showProgressIndicator} === false }" text="{/analysisDurationTitle}: {/lastAnalysisElapsedTime}"/><Text visible="{= ${/persistingSettings} === true &amp;&amp;  ${/analyzePressed} === false &amp;&amp; ${/showProgressIndicator} === false }" text="There are settings persisted from your previous session"/></FlexBox></contentMiddle><contentRight><Toolbar id="navToolbar"><Button id="issuesBtn" text="{= \'Issues (\' + ${/issuesCount} + \')\' }" enabled="{= ${/analyzedFinish} === true}" press="goToIssues"/><Button id="analysisBtn" text="{path:\'/libraries\',formatter:\'.setRulesLabel\'}" press="goToAnalysis" type="Emphasized"/><c:Icon width="100%" src="sap-icon://settings" press="onSettings" class="STCustomHeaderInfo STHelpIcon sapUiTinyMargin"/><c:Icon width="100%" src="sap-icon://sys-help" press="goToWiki" class="STCustomHeaderInfo STHelpIcon sapUiTinyMargin" tooltip="Open Documentation"/><c:Icon width="100%" src="sap-icon://minimize" press="toggleHide" class="STCustomHeaderInfo sapUiTinyMargin" visible="{/hasNoOpener}"/><Button icon="sap-icon://down" press="resizeDown" visible="{/hasNoOpener}"/><Button icon="sap-icon://up" press="resizeUp" visible="{/hasNoOpener}"/></Toolbar></contentRight></Bar></l:fixContent><l:flexContent><NavContainer id="navCon"><mvc:XMLView id="analysis" viewName="sap.ui.support.supportRules.ui.views.Analysis" async="true"/></NavContainer></l:flexContent></l:FixFlex></Page></mvc:View>',
	"sap/ui/support/supportRules/ui/views/RuleDetails.fragment.xml":'<core:FragmentDefinition xmlns:m="sap.m" xmlns:l="sap.ui.layout" xmlns:f="sap.ui.layout.form" xmlns:mvc="sap.ui.core.mvc" xmlns:t="sap.ui.table" xmlns:core="sap.ui.core" xmlns:tools="sap.ui.codeeditor"><m:Page showHeader="false"><m:Bar><m:contentLeft><m:Title text="{= ${/selectedRule/libName} + \' &gt; \' + ${/selectedRule/title}}" visible="{= ${/selectedRule} !== undefined &amp;&amp; ${/selectedSetPreviewKey} !== \'additionalRulesets\'}" titleStyle="H6" class="customMarginLeft"/></m:contentLeft><m:contentMiddle><m:IconTabHeader selectedKey="{/selectedRulePreviewKey}" class="customIconTabHeader"><m:items><m:IconTabFilter enabled="{= ${/selectedRule} !== undefined}" key="ruleProperties" text="Rule properties"/><m:IconTabFilter enabled="{= ${/selectedRule} !== undefined}" key="checkFunction" text="Check function"/><m:IconTabFilter enabled="{= ${/selectedRule} !== undefined}" key="jsonOutput" text="Code"/></m:items></m:IconTabHeader></m:contentMiddle></m:Bar><f:SimpleForm visible="{= ${/selectedRule/type} !== \'library\'  &amp;&amp; ${/selectedRulePreviewKey} === \'ruleProperties\' &amp;&amp; ${/selectedRule} !== undefined &amp;&amp; ${/selectedSetPreviewKey} !== \'additionalRulesets\'}"><f:content><m:Label text="ID"/><m:Text text="{/selectedRule/id}"/><m:Label text="Title"/><m:Text text="{/selectedRule/title}"/><m:Label text="Async"/><m:Text text="{= ${/selectedRule/async} === true }"/><m:Label text="Audiences"/><m:Text text="{/selectedRule/audiences}"/><m:Label text="Categories"/><m:Text text="{/selectedRule/categories}"/><m:Label text="Min version"/><m:Text text="{/selectedRule/minversion}"/><m:Label text="Description"/><m:Text text="{/selectedRule/description}"/><m:Label text="Resolution"/><m:Text text="{/selectedRule/resolution}"/><m:Label text="Resolution URLs"/><l:VerticalLayout content="{/selectedRule/resolutionurls}"><m:Link target="_blank" text="{text}" href="{href}"/></l:VerticalLayout></f:content><f:layoutData><l:SplitterLayoutData size="40%"/></f:layoutData></f:SimpleForm><m:Panel width="100%" height="calc(100% - 2rem)" visible="{= ${/selectedRulePreviewKey} === \'checkFunction\' }"><tools:CodeEditor id="codeEditorPreview" syntaxHints="false" width="100%" height="100%" value="{/selectedRule/check}" editable="false"/></m:Panel><m:Panel width="100%" height="calc(100% - 2rem)" visible="{= ${/selectedRulePreviewKey} === \'jsonOutput\' }"><tools:CodeEditor id="codeEditorJson1" syntaxHints="false" width="100%" height="100%" value="{/selectedRuleStringify}" editable="false" type="javascript"/></m:Panel></m:Page></core:FragmentDefinition>',
	"sap/ui/support/supportRules/ui/views/RuleUpdate.fragment.xml":'<c:FragmentDefinition xmlns:m="sap.m" xmlns:l="sap.ui.layout" xmlns:f="sap.ui.layout.form" xmlns:mvc="sap.ui.core.mvc" xmlns:t="sap.ui.table" xmlns:c="sap.ui.core" xmlns:tools="sap.ui.codeeditor"><m:Page id="ruleUpdatePage" showHeader="false"><m:content><m:Bar><m:contentLeft><m:Button icon="sap-icon://arrow-left" press="goToRuleProperties" text="Back"/></m:contentLeft><m:contentMiddle><m:IconTabHeader select="rulesToolbarEditITHSelect" selectedKey="{/selectedRuleEditKey}" class="customIconTabHeader"><m:items><m:IconTabFilter key="ruleProperties" text="Rule properties"/><m:IconTabFilter key="checkFunction" text="Check function"/><m:IconTabFilter key="jsonOutput" text="Code"/></m:items></m:IconTabHeader></m:contentMiddle></m:Bar><f:SimpleForm visible="{= ${/selectedRuleEditKey} === \'ruleProperties\' }" editable="true"><f:content><m:Label text="ID"/><m:Input value="{/editRule/id}" required="true"/><m:Label text="Async"/><m:HBox><m:items><m:RadioButton groupName="asyncEditContext" text="true" selected="{= ${/editRule/async} === true }" select="onAsyncSwitch"><m:customData><c:CustomData key="asyncEditContext" value="true"/></m:customData></m:RadioButton><m:RadioButton groupName="asyncEditContext" text="false" selected="{= ${/editRule/async} !== true }" select="onAsyncSwitch"><m:customData><c:CustomData key="asyncEditContext" value="false"/></m:customData></m:RadioButton><c:Icon src="sap-icon://message-warning" class="sapUiSmallMarginBegin sapUiTinyMarginEnd" color="#E09D00" visible="{= ${/editRule/async} === true }"><c:layoutData><m:FlexItemData alignSelf="Center"/></c:layoutData></c:Icon><m:Text text="{/resolveDescription}" visible="{= ${/editRule/async} === true }"><m:layoutData><m:FlexItemData alignSelf="Center"/></m:layoutData></m:Text></m:items></m:HBox><m:Label text="Categories"/><m:MultiComboBox selectedKeys="{/editRule/categories}" items="{/categories}" required="true"><c:Item key="{}" text="{}"/></m:MultiComboBox><m:Label text="Audiences"/><m:MultiComboBox selectedKeys="{/editRule/audiences}" items="{/audiences}" required="true"><c:Item key="{}" text="{}"/></m:MultiComboBox><m:Label text="Title"/><m:Input type="Text" value="{/editRule/title}" required="true"/><m:Label text="Description"/><m:TextArea value="{/editRule/description}" required="true"/><m:Label text="Resolution"/><m:TextArea value="{/editRule/resolution}" required="true"/><m:Label text="Min version"/><m:TextArea value="{/editRule/minversion}" required="true"/><m:Label text="Resolution URLS"/><l:VerticalLayout><l:HorizontalLayout><m:Input type="text" placeholder="Text" value="{/tempLink/text}"/><m:Input type="text" placeholder="Href" value="{/tempLink/href}"/><m:Button text="Add Link" press="addLinkToRule" icon="sap-icon://add"/></l:HorizontalLayout><l:VerticalLayout content="{/editRule/resolutionurls}"><m:Link text="{text}" href="{href}" target="_blank"/></l:VerticalLayout></l:VerticalLayout></f:content></f:SimpleForm><m:Panel width="100%" height="calc(100% - 2rem)" visible="{= ${/selectedRuleEditKey} === \'checkFunction\' }"><tools:CodeEditor id="codeEditorUpdate" width="100%" height="100%" value="{/editRule/check}" editable="true"/></m:Panel><m:Panel width="100%" height="calc(100% - 2rem)" visible="{= ${/selectedRuleEditKey} === \'jsonOutput\' }"><tools:CodeEditor syntaxHints="false" width="100%" height="100%" value="{/updateRuleStringified}" editable="false" type="javascript"/></m:Panel></m:content><m:footer><m:Bar><m:contentRight><m:Button press="updateRule" text="Update" type="Emphasized"/></m:contentRight></m:Bar></m:footer></m:Page><m:Page id="rulesCreatePage" showHeader="false"><m:content><m:Bar><m:contentLeft><m:Button icon="sap-icon://arrow-left" press="goToRuleProperties" text="Back"/></m:contentLeft><m:contentMiddle><m:IconTabHeader select="rulesToolbarITHSelect" selectedKey="{/selectedRuleCreateKey}" class="customIconTabHeader"><m:items><m:IconTabFilter key="ruleProperties" text="Rule properties"/><m:IconTabFilter key="checkFunction" text="Check function"/><m:IconTabFilter key="jsonOutput" text="Code"/></m:items></m:IconTabHeader></m:contentMiddle></m:Bar><f:SimpleForm visible="{= ${/selectedRuleCreateKey} === \'ruleProperties\' }" editable="true"><f:content><m:Label text="ID"/><m:Input value="{/newRule/id}" required="true"/><m:Label text="Async"/><m:HBox><m:items><m:RadioButton groupName="asyncContext" text="true" selected="{= ${/newRule/async} === true }" select="onAsyncSwitch"><m:customData><c:CustomData key="asyncContext" value="true"/></m:customData><m:layoutData><m:FlexItemData alignSelf="Center"/></m:layoutData></m:RadioButton><m:RadioButton groupName="asyncContext" text="false" selected="{= ${/newRule/async} !== true }" select="onAsyncSwitch"><m:customData><c:CustomData key="asyncContext" value="false"/></m:customData><m:layoutData><m:FlexItemData alignSelf="Center"/></m:layoutData></m:RadioButton><c:Icon src="sap-icon://message-warning" class="sapUiSmallMarginBegin sapUiTinyMarginEnd" color="#E09D00" visible="{= ${/newRule/async} === true }"><c:layoutData><m:FlexItemData alignSelf="Center"/></c:layoutData></c:Icon><m:Text text="{/resolveDescription}" visible="{= ${/newRule/async} === true }"><m:layoutData><m:FlexItemData alignSelf="Center"/></m:layoutData></m:Text></m:items></m:HBox><m:Label text="Categories"/><m:MultiComboBox selectedKeys="{/newRule/categories}" items="{/categories}" required="true"><c:Item key="{}" text="{}"/></m:MultiComboBox><m:Label text="Audiences"/><m:MultiComboBox selectedKeys="{/newRule/audiences}" items="{/audiences}" required="true"><c:Item key="{}" text="{}"/></m:MultiComboBox><m:Label text="Title"/><m:Input type="Text" value="{/newRule/title}" required="true"/><m:Label text="Description"/><m:TextArea value="{/newRule/description}" required="true"/><m:Label text="Resolution"/><m:TextArea value="{/newRule/resolution}" required="true"/><m:Label text="Min version"/><m:TextArea value="{/newRule/minversion}" required="true"/><m:Label text="Resolution URLS"/><l:VerticalLayout><l:HorizontalLayout><m:Input type="text" placeholder="Text" value="{/tempLink/text}"/><m:Input type="text" placeholder="Href" value="{/tempLink/href}"/><m:Button text="Add" press="addLinkToRule" icon="sap-icon://add"/></l:HorizontalLayout><l:VerticalLayout content="{/newRule/resolutionurls}"><m:Link text="{text}"/></l:VerticalLayout></l:VerticalLayout></f:content></f:SimpleForm><m:Panel width="100%" height="calc(100% - 2rem)" visible="{= ${/selectedRuleCreateKey} === \'checkFunction\' }"><tools:CodeEditor id="codeEditorCreate" width="100%" height="100%" value="{/newRule/check}" editable="true"/></m:Panel><m:Panel width="100%" height="calc(100% - 2rem)" visible="{= ${/selectedRuleCreateKey} === \'jsonOutput\' }"><tools:CodeEditor id="codeEditorJson" syntaxHints="false" width="100%" height="100%" value="{/newRuleStringified}" editable="false" type="javascript"/></m:Panel></m:content><m:footer><m:Bar><m:contentRight><m:Button press="addNewRule" text="Add Rule" type="Emphasized"/></m:contentRight></m:Bar></m:footer></m:Page></c:FragmentDefinition>',
	"sap/ui/support/supportRules/ui/views/StorageSettings.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core"><Popover title="Settings" contentMinWidth="250px" class="sapUiContentPadding" placement="Bottom"><content><FlexBox alignContent="Center" justifyContent="Center"><l:VerticalLayout><l:HorizontalLayout><CheckBox text="I agree to use local storage persistency for:" select="onPersistedSettingSelect" selected="{/persistingSettings}"/></l:HorizontalLayout><FlexBox alignContent="Center" justifyContent="Start"><l:VerticalLayout class="customSettingsPadding"><Text text="  Execution Scope"/><Text text="  Temporary Rules"/><Text text="  Selected Rules"/><Button text="Delete Persisted Data" press="deletePersistedData"/><l:HorizontalLayout class="customSettingsInfo"><Text text="Support Assistant Location : \\t" renderWhitespace="true"/><Link text="Copy" href="#" press="copySupportAssistantOriginToClipboard"/></l:HorizontalLayout><Text text="{/supportAssistantOrigin}"/><l:HorizontalLayout><Text text="Support Assistant Version : {/supportAssistantVersion}" renderWhitespace="true"/></l:HorizontalLayout></l:VerticalLayout></FlexBox></l:VerticalLayout></FlexBox></content></Popover></core:FragmentDefinition>',
	"sap/ui/support/supportRules/report/resources/collapseExpand.js":function(){window.sapUiSupportReport=window.sapUiSupportReport||{};window.sapUiSupportReport.collapseExpand=(function(){'use strict';function c(e){var t=this.getAttribute('data-expandableElement');var b=document.getElementById(t);var d=b.classList.contains('collapsed');if(d){b.classList.remove('collapsed');b.classList.add('expanded');this.classList.remove('collapsed-content');this.classList.add('expanded-content');}else{b.classList.remove('expanded');b.classList.add('collapsed');this.classList.remove('expanded-content');this.classList.add('collapsed-content');}}function a(){try{var e=document.getElementsByClassName('expandable-control');if(!e){return;}for(var i=0;i<e.length;i++){e[i].addEventListener('click',c);var b=e[i].getAttribute('data-expandableElement');var d=document.getElementById(b);if(e[i].classList.contains('collapsed-content')){d.classList.add('collapsed');}else{d.classList.add('expanded');}e[i].setAttribute('style','cursor: pointer;');}}catch(f){console.log('There was a problem initializing collapse/expand functionality.');}}return{init:a};}());
},
	"sap/ui/support/supportRules/report/resources/filter.js":function(){window.sapUiSupportReport=window.sapUiSupportReport||{};window.sapUiSupportReport.filter=(function(){'use strict';function u(){var g=document.querySelectorAll('[data-groupName]');for(var i=0;i<g.length;i++){var c=g[i];var d=c.getAttribute('data-expandableElement');var e=c.getAttribute('data-groupName');var h=c.getAttribute('data-groupNumber');var j=document.querySelectorAll('#'+d+' > tr');var n=0;var l=0;for(var k=0;k<j.length;k++){var m=j[k];var o=m.querySelectorAll('tr.filterable:not(.filtered)');var p=o.length;if(p===0){m.classList.add('filtered');}else{l++;n+=p;m.querySelector('span.rule-issue-number').innerText='('+p+' issues)';}}if(l===0){c.classList.add('filtered');}else{c.classList.remove('filtered');c.querySelector('span').innerText=' '+h+'. '+e+' ('+l+' rules, '+n+' issues)';}}}function s(c){if(c.classList.contains('filter-active')){return;}var d=document.getElementsByClassName('filter-active');for(var k=0;k<d.length;k++){d[k].classList.remove('filter-active');}c.classList.add('filter-active');}function r(){var c=document.querySelectorAll('.filtered');for(var i=0;i<c.length;i++){c[i].classList.remove('filtered');}}function f(c){r();if(c==='Total'){return;}var e=document.querySelectorAll('.filterable:not([data-severity="'+c+'"])');for(var i=0;i<e.length;i++){e[i].classList.add('filtered');}}function a(e){s(this);var c=this.getAttribute('data-severity');f(c);u();}function b(){try{var c=document.getElementsByClassName('filter');if(!c){return;}for(var i=0;i<c.length;i++){if(c[i].classList.contains('filter-initialized')){continue;}c[i].addEventListener('click',a);c[i].classList.add('filter-initialized');}}catch(e){console.log('There was a problem initializing filters.');}}return{init:b};}());
}
},"sap/ui/support/library-preload"
);
//# sourceMappingURL=library-preload.js.map