/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/model/BindingMode','./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','./TableDragAndDropExtension',"./TableRenderer",'jquery.sap.dom','jquery.sap.trace','jquery.sap.events'],function(q,D,C,E,I,b,F,S,c,B,d,R,e,T,f,g,h,j,k,m,n){"use strict";var G=e.GroupEventType,N=e.NavigationMode,o=e.SelectionMode,p=e.SelectionBehavior,r=e.SortOrder,V=e.VisibleRowCountMode;var s=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:o.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:p.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designtime:"sap/ui/table/designtime/Table.designtime"}});I.insertFontFaceStyle();s.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._bHideStandardTooltips=false;this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;this._aRowHeights=[];this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];var t=this;this._performUpdateRows=function(a){if(!t.bIsDestroyed){t._lastCalledUpdateRows=Date.now();t._updateBindingContexts();if(!t._bInvalid){t._updateTableContent();t._getAccExtension().updateAccForCurrentCell(false);t._updateSelection();t._collectTableSizes();t._aRowHeights=t._collectRowHeights(false);t._updateRowHeights(t._collectRowHeights(true),true);t._updateRowHeights(t._aRowHeights,false);if(T.isVariableRowHeightEnabled(t)){t._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex();}t._getScrollExtension().updateVerticalScrollbarVisibility();}t._mTimeouts.bindingTimer=undefined;t._fireRowsUpdated(a);}};this._initSelectionModel(S.MULTI_SELECTION);this._aTableHeaders=[];this._aIdxCols2Cells=[];this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iBindingLength=null;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;this._bInvalid=true;};s.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}f.enrich(this,j);f.enrich(this,k);f.enrich(this,h);f.enrich(this,g);f.enrich(this,m);this._bExtensionsInitialized=true;};s.prototype.exit=function(){this._bExitCalled=true;this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();if(this._oSelection){this._oSelection.destroy();}delete this._aTableHeaders;};s.prototype._detachExtensions=function(){f.cleanup(this);};s.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};s.prototype.onlocalizationChanged=function(a){var i=a.changes||{};var l=i.hasOwnProperty("rtl");var L=i.hasOwnProperty("language");this._adaptLocalization(l,L).then(function(){this.invalidate();}.bind(this));};s.prototype._adaptLocalization=function(a,l){if(!a&&!l){return Promise.reject();}var i=Promise.resolve();if(a){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){i=T.getResourceBundle({async:true,reload:true});}return i.then(function(){if(l){T.Menu.cleanupDataCellContextMenu(this);this._invalidateColumnMenus();}}.bind(this));};s.prototype._collectRowHeights=function(H){var a=this.getDomRef();if(!a){return[];}if(H&&this.getColumnHeaderHeight()){return[];}var l=this._getDefaultRowHeight();var t=H?".sapUiTableColHdrTr":".sapUiTableTr";var u=a.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+t);var v=a.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+t);var w=this.getRows().length;var x=[];var y=D.browser.chrome&&window.devicePixelRatio!=1;for(var i=0;i<w;i++){var z=u[i]?u[i].getBoundingClientRect().height:0;var A=v[i]?v[i].getBoundingClientRect().height:0;var J=Math.max(z,A);if(y){var K=l-J;if(K>0&&K<1){x.push(Math.max(J,l-1));continue;}}x.push(Math.max(J,l));}return x;};s.prototype._resetRowHeights=function(){var a=this._getDefaultRowHeight();var l="";if(a){l=a+"px";}var t=this.getDomRef();if(t){var u=t.querySelectorAll(".sapUiTableTr");for(var i=0;i<u.length;i++){u[i].style.height=l;}}};s.prototype._resetColumnHeaderHeights=function(){if(this.getColumnHeaderHeight()){return;}var a=this.getDomRef();if(a){var l=a.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<l.length;i++){l[i].style.height=null;}}};s.prototype._determineAvailableSpace=function(){var a=this.getDomRef();if(a&&a.parentNode){var i=a.querySelector(".sapUiTableCCnt");if(i){var u=a.scrollHeight-i.clientHeight;var t=0;if(a.parentNode.firstChild!==a){var P=parseFloat(window.getComputedStyle(a.parentNode).paddingTop);if(isNaN(P)){P=0;}t=a.offsetTop-P;}var l=this._getScrollExtension();var H=l.getHorizontalScrollbar();if(!H||!l.isHorizontalScrollbarVisible()){var v={};v[D.browser.BROWSER.CHROME]=16;v[D.browser.BROWSER.FIREFOX]=16;v[D.browser.BROWSER.INTERNET_EXPLORER]=18;v[D.browser.BROWSER.EDGE]=12;v[D.browser.BROWSER.SAFARI]=16;v[D.browser.BROWSER.ANDROID]=8;u+=v[D.browser.name];}if(this._iLastAvailableSpace==null){this._iLastAvailableSpace=0;}var w=Math.floor(q(a.parentNode).height()-u-t);var A=Math.abs(w-this._iLastAvailableSpace);if(A>=5){this._iLastAvailableSpace=w;}return this._iLastAvailableSpace;}}return 0;};s.prototype._collectTableSizes=function(){var a={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var l=this.getDomRef();if(!l){return a;}var t=l.querySelector(".sapUiTableCnt");if(t){a.tableCntHeight=t.clientHeight;a.tableCntWidth=t.clientWidth;}var u=l.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(u){a.tableCtrlScrollWidth=u.clientWidth;}var v=l.querySelector(".sapUiTableRowHdrScr");if(v){a.tableRowHdrScrWidth=v.clientWidth;}var w=l.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(w){a.tableCtrlScrWidth=w.clientWidth;}var H=this._getScrollExtension().getHorizontalScrollbar();if(H){a.tableHSbScrollLeft=H.scrollLeft;}var x=l.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(x){a.tableCtrlFixedWidth=x.clientWidth;}var y=this.getFixedColumnCount();var z=0;if(y){var A=this.getColumns();var J=l.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<J.length;i++){var K=parseInt(J[i].getAttribute("data-sap-ui-headcolindex"),10);if(!isNaN(K)&&(K<y)){var L=A[K];var W;if(L._iFixWidth!=null){W=L._iFixWidth;}else{W=J[i].getBoundingClientRect().width;}z+=W;}}}if(z>0){var U=a.tableRowHdrScrWidth;var M=this.getDomRef("vsb");if(M){U+=M.offsetWidth;}if(T.hasRowActions(this)){var O=this.getDomRef("sapUiTableRowActionScr");if(O){U+=O.offsetWidth;}}U+=T.Column.getMinColumnWidth();var P=a.tableCntWidth-U;var Q=P>z;var X=!Q;if(this._bIgnoreFixedColumnCount!==X){this._bIgnoreFixedColumnCount=X;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}this.invalidate();}}return a;};s.prototype._updateRowHeights=function(i,H){var l=this.getDomRef();if(!l){return;}if(H&&this.getColumnHeaderHeight()){return;}function u(z,A){var J=i[A];if(J){z.style.height=J+"px";}}var t=H?".sapUiTableColHdrTr":".sapUiTableTr";var v=H?[]:l.querySelectorAll(".sapUiTableRowHdr");var w=H?[]:l.querySelectorAll(".sapUiTableRowAction");var x=l.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+t);var y=l.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+t);var a=[];a.forEach.call(v,u);a.forEach.call(w,u);a.forEach.call(x,u);a.forEach.call(y,u);};s.prototype.onBeforeRendering=function(a){if(a&&a.isMarked("renderRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var v=this.getVisibleRowCountMode();var i=this.getRows();if(v==V.Interactive||v==V.Fixed||(v==V.Auto&&this._iTableRowContentHeight&&i.length==0)){this.getBinding("rows");this._updateRows(this._calculateRowsToDisplay(),T.RowsUpdateReason.Render);}else if(this._bRowAggregationInvalid&&i.length>0){this._updateRows(i.length,T.RowsUpdateReason.Render);}this._aTableHeaders=[];};s.prototype.onAfterRendering=function(a){var t=a&&a.isMarked("renderRows");this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var u=this.getColumns();for(var i=0,l=u.length;i<l;i++){if(u[i].getVisible()){u[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection&&!t){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();this._updateTableContent();this.getDomRef().classList.remove("sapUiTableRActFlexible");if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,T.RowsUpdateReason.Render,true));}else{this._updateTableSizes(T.RowsUpdateReason.Render,null,t,t&&T.isVariableRowHeightEnabled(this));}if(!t){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");if(this.getBinding("rows")){this._fireRowsUpdated(T.RowsUpdateReason.Render);}}};s.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var v=C.prototype.invalidate.call(this);T.Column.invalidateColumnUtils(this);}return v;};s.prototype._initRowDomRefs=function(){var a=this.getRows();for(var i=0;i<a.length;i++){a[i].initDomRefs();}};s.prototype._updateTableSizes=function(a,l,t,u){var v=this.getDomRef();var w=this;if(this._bInvalid||!v){return;}if(v.offsetWidth===0){T.deregisterResizeHandler(this,"");Q();return;}this._resetRowHeights();this._resetColumnHeaderHeights();this._aRowHeights=this._collectRowHeights(false);var x=this._collectRowHeights(true);if(T.isVariableRowHeightEnabled(this)&&!T.isNoDataVisible(this)){this._getScrollExtension().updateInnerVerticalScrollPosition();}var y=null;if(!t&&this.getVisibleRowCountMode()==V.Auto){y=this._determineAvailableSpace();if(this._handleRowCountModeAuto(y,a)&&!l){return;}}T.deregisterResizeHandler(this,"");function z(U){var W=U.getDomRef();var X=T.Column.getMinColumnWidth();var Y=[];var Z=U.getColumnHeaderVisible();function _(c1,d1){if(c1<=d1){return Math.max(c1,d1-5,X)+"px";}return-1;}function a1(d1){var e1=Math.max(d1._minWidth||0,X,d1.getMinWidth());var f1=d1.getWidth();var g1;var h1;var i1;if(T.isVariableWidth(f1)&&!T.isFixedColumn(U,d1.getIndex())){g1=W.querySelectorAll('th[data-sap-ui-colid="'+d1.getId()+'"]');h1=g1[Z?0:1];i1=h1?h1.offsetWidth:null;if(i1!==null){if(i1<=e1){return{headers:g1,newWidth:_(i1,e1)};}else if(h1&&h1.style.width!=f1){Y.push({col:d1,header:h1,minWidth:e1,headers:g1});return{headers:g1,newWidth:f1};}Y.push({col:d1,header:h1,minWidth:e1,headers:g1});}}return null;}function b1(d1){if(d1){Array.prototype.forEach.call(d1.headers,function(e1){e1.style.width=d1.newWidth;});}}U._getVisibleColumns().map(a1).forEach(b1);if(Y.length){var c1;for(var i=0;i<Y.length;i++){c1=Y[i].header&&Y[i].header.offsetWidth;Y[i].newWidth=_(c1,Y[i].minWidth);if(parseInt(Y[i].newWidth,10)>=0){b1(Y[i]);}}}}z(this);this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(x,true);if(!t||u){this._setRowContentHeight(y);}if(this.getVisibleRowCountMode()==V.Auto){var A=this._calculateRowsToDisplay(y!=null?y:this._determineAvailableSpace());if(A==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}}var H=this._collectTableSizes();if(H.tableCntHeight==0&&H.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}var J=this._getScrollExtension();J.updateHorizontalScrollbar(H);J.updateVerticalScrollbarPosition();J.updateVerticalScrollbarVisibility();var $=this.$();if(T.hasRowActions(this)){var K=$.hasClass("sapUiTableRActFlexible");var L=this.getDomRef("dummycolhdr");var M=L?L.clientWidth:0;if(!K&&M>0){var O=H.tableCtrlScrWidth+H.tableRowHdrScrWidth+H.tableCtrlFixedWidth-M;var P={width:"auto"};P[this._bRtlMode?"right":"left"]=O;this.$("sapUiTableRowActionScr").css(P);this.$("rowacthdr").css(P);$.toggleClass("sapUiTableRActFlexible",true);}else if(K&&M<=0){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");function Q(){T.registerResizeHandler(w,"",w._onTableResize.bind(w),true);}if($.closest(".sapUiLoSplitter").length){Q();}else{Promise.resolve().then(Q);}};s.prototype.setShowOverlay=function(a){a=!!a;this.setProperty("showOverlay",a,true);if(this.getDomRef()){var i=document.activeElement;this.$().toggleClass("sapUiTableOverlay",a);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(i);}return this;};s.prototype._updateFixedBottomRows=function(){var i=this.getFixedBottomRowCount();var a=this.getDomRef();if(a&&i>0){var $=q(a).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var l=q(a).find(".sapUiTableFixedFirstBottomRow");l.removeClass("sapUiTableFixedFirstBottomRow");var t=T.getFirstFixedButtomRowIndex(this);var u=this.getRows();var v;if(t>=0&&t<u.length){v=u[t].getDomRefs(true);v.row.addClass("sapUiTableFixedFirstBottomRow",true);}if(t>=1&&t<u.length){v=u[t-1].getDomRefs(true);v.row.addClass("sapUiTableFixedPreBottomRow",true);}}};s.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};s.prototype.applyFocusInfo=function(a){if(a&&a.customId){q.sap.byId(a.customId,this.getDomRef()).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};s.prototype.setTitle=function(t){var a=t;if(typeof(t)==="string"||t instanceof String){a=e.TableHelper.createTextView({text:t,width:"100%"});a.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",a);return this;};s.prototype.setFooter=function(v){var a=v;if(typeof(v)==="string"||v instanceof String){a=e.TableHelper.createTextView({text:v,width:"100%"});}this.setAggregation("footer",a);return this;};s.prototype.setSelectionMode=function(a){this.clearSelection();if(a===o.Single){this._oSelection.setSelectionMode(S.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(S.MULTI_SELECTION);}a=T.sanitizeSelectionMode(this,a);this.setProperty("selectionMode",a);return this;};s.prototype.setFirstVisibleRow=function(i,O,a){if(parseInt(i,10)<0){q.sap.log.error("The index of the first visible row must be greater than or equal to 0."+" The value has been set to 0.",this);i=0;}if(this._getTotalRowCount()>0){var M=this._getMaxFirstVisibleRowIndex();if(M<i){q.sap.log.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+M+".",this);i=M;}}var l=this.getFirstVisibleRow()!=i;var t=this._getScrollExtension();if(l){var u=this._getFirstRenderedRowIndex();this.setProperty("firstVisibleRow",i,true);var v=this._getFirstRenderedRowIndex()!==u;if(this.getBinding("rows")){if(v){var w=O===true?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(w);}if(!O){t.updateVerticalScrollPosition();}}if(!a){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}else if(!O){t.updateVerticalScrollPosition();}return this;};s.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;s.prototype.bindAggregation=function(a){if(a==="rows"){return this.bindRows.apply(this,[].slice.call(arguments,1));}return C.prototype.bindAggregation.apply(this,arguments);};s.prototype.bindRows=function(a){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._iPendingRequests=0;this._bPendingRequest=false;return C.prototype.bindAggregation.call(this,"rows",s._getSanitizedBindingInfo(arguments));};s.prototype._bindAggregation=function(a,i){if(a==="rows"){s._addBindingListener(i,"change",this._onBindingChange.bind(this));s._addBindingListener(i,"dataRequested",this._onBindingDataRequested.bind(this));s._addBindingListener(i,"dataReceived",this._onBindingDataReceived.bind(this));this._bContextsRequested=false;}E.prototype._bindAggregation.call(this,a,i);var l=this.getBinding("rows");if(a==="rows"&&l){var M=l.getModel();if(M&&M.getDefaultBindingMode()===B.OneTime){q.sap.log.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}this._initSelectionModel(S.MULTI_SELECTION);};s._getSanitizedBindingInfo=function(a){var i;if(a==null||a[0]==null){i=null;}else if(typeof a[0]==="string"){var P=a[0];var t=a[1];var l=a[2];var u=a[3];if(t instanceof c||q.isArray(l)&&l[0]instanceof F){u=l;l=t;t=undefined;}i={path:P,sorter:l,filters:u,template:t};}else{i=a[0];}return i;};s._addBindingListener=function(a,i,H){if(!a.events){a.events={};}if(!a.events[i]){a.events[i]=H;}else{var O=a.events[i];a.events[i]=function(){H.apply(this,arguments);O.apply(this,arguments);};}};s.prototype._initSelectionModel=function(a){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new S(a);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};s.prototype._onBindingChange=function(a){var i=typeof(a)==="object"?a.getParameter("reason"):a;if(i==="sort"||i==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};s.prototype.unbindAggregation=function(a,i){var l=this.getBinding("rows");if(a==="rows"&&this.isBound("rows")){i=true;}var v=E.prototype.unbindAggregation.apply(this,[a,i]);if(a==="rows"&&l){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateTotalRowCount(true);this.updateRows(T.RowsUpdateReason.Unbind);}return v;};s.prototype.setVisibleRowCount=function(v){if(v!=null&&!isFinite(v)){return this;}var a=this.getVisibleRowCountMode();if(a==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var i=this.getFixedRowCount()+this.getFixedBottomRowCount();if(v<=i&&i>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+v+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}v=this.validateProperty("visibleRowCount",v);if(this.getBinding("rows")&&this._getTotalRowCount()<=v){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",v);this._setRowContentHeight(v*this._getDefaultRowHeight());return this;};s.prototype.setMinAutoRowCount=function(M){if(parseInt(M,10)<1){q.sap.log.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);M=1;}this.setProperty("minAutoRowCount",M);};s.prototype.setRowHeight=function(i){this.setProperty("rowHeight",i);this._iTableRowContentHeight=undefined;return this;};s.prototype.setTooltip=function(t){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",t,true);};s.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};s.prototype._getFixedBottomRowContexts=function(i,a){var l=this.getBinding("rows");var t=[];if(!l){return t;}i=i||this.getFixedBottomRowCount();a=a||this._getTotalRowCount();var v=this.getVisibleRowCount();if(i>0&&(v-i)<a){t=this._getContexts(a-i,i,1);}return t;};s.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};s.prototype._getContexts=function(i,l,t){var a=this.getBinding("rows");if(a){return a.getContexts(i,l,t);}else{return[];}};s.prototype._computeRequestLength=function(l){if(this.getVisibleRowCountMode()===V.Auto&&!this._bContextsRequested){var i=Math.ceil(D.resize.height/T.DEFAULT_ROW_HEIGHT.sapUiSizeCondensed);return Math.max(l,i);}return l;};s.prototype._getRowContexts=function(v,a,l){var t=this.getBinding("rows");var u=v==null?this.getRows().length:v;if(!t||u<=0){return[];}a=a===true;l=l===true;var w=this._getFirstRenderedRowIndex();var x=this.getFixedRowCount();var y=this.getFixedBottomRowCount();var z=0;var A;var H=[];var J;var L=u-y;var M=0;var K=L;var O=this.getThreshold();O=O?Math.max(u,O):0;var P=w;var Q=function(X,Y,P){for(var i=0;i<Y.length;i++){X[P+i]=Y[i];}};if(x>0&&w>0){P=w+x;L-=x;M=x;J=this._getFixedRowContexts(x);z+=J.length;H=H.concat(J);}J=this._getContexts(P,this._computeRequestLength(L),O);var U=this._updateTotalRowCount(!a);this._bContextsRequested=true;A=J.length<Math.min(L,U-y);z+=J.length;Q(H,J,M);K=Math.min(K,Math.max(U-y,0));if(y>0){J=this._getFixedBottomRowContexts(y,U);z+=J.length;Q(H,J,K);}var W=this._getMaxFirstRenderedRowIndex();if(A&&U>0&&W<w&&!l){w=W;this.setProperty("firstVisibleRow",w,true);H=this._getRowContexts(u,a,true);}return H;};s.prototype._updateTotalRowCount=function(u){if(this._iBindingLength===null){this._iBindingLength=0;}var a=this.getBinding("rows");var i=this._getTotalRowCount();var l=a?a.getLength():0;if(i!==l){this._iBindingLength=l;if(u!==false){var t=this._getScrollExtension();this._updateFixedBottomRows();t.updateVerticalScrollbarVisibility();t.updateVerticalScrollHeight();if(!a||!T.hasPendingRequests(this)){this._updateNoData();}}}return l;};s.prototype.refreshRows=function(v){var a=this.getBinding("rows");if(!a){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var t=this;var i=typeof(v)==="object"?v.getParameter("reason"):v;var l=this.getVisibleRowCountMode();if((this.bOutput&&l===V.Auto)||l!==V.Auto){if(this.bOutput){a.attachEventOnce("dataRequested",function(){if(t._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(t._mTimeouts.refreshRowsAdjustRows);}t._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){t._updateRows(t._calculateRowsToDisplay(),i,false);},0);});}if(i===b.Filter||i===b.Sort){this.setFirstVisibleRow(0);}var u=i!=null;this._updateBindingContexts(this._calculateRowsToDisplay(),u);}};s.prototype.updateRows=function(a){if(this._bExitCalled){return;}var v=this.getVisibleRowCountMode();if((this.getRows().length<=0||this._bRowAggregationInvalid)&&((v==V.Auto&&this.bOutput)||v!=V.Auto)){if(this._iTableRowContentHeight){this._updateRows(this._calculateRowsToDisplay(),a);}}if(!this.bIsDestroyed){var i=(a===b.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||a===T.RowsUpdateReason.Unbind?0:this._iBindingTimerDelay);var t=this;if(i===0&&a){Promise.resolve().then(function(){t._performUpdateRows(a);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){t._performUpdateRows(a);},i);}}};s.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};s.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};s.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};s.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};s.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};s.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};s.prototype._attachEvents=function(){var $=this.$();if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(a){if(q(a.target).has($).length>0){this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}D.resize.attachHandler(this._onWindowResize,this);f.attachEvents(this);};s.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);D.resize.detachHandler(this._onWindowResize,this);f.detachEvents(this);};s.prototype._cleanUpTimers=function(){var K;for(K in this._mTimeouts){if(this._mTimeouts[K]){window.clearTimeout(this._mTimeouts[K]);delete this._mTimeouts[K];}}for(K in this._mAnimationFrames){if(this._mAnimationFrames[K]){window.cancelAnimationFrame(this._mAnimationFrames[K]);delete this._mAnimationFrames[K];}}};s.prototype._updateBindingContexts=function(i,a){var l=this.getBinding("rows");var t;a=a===true;if(l){t=this._getRowContexts(i,a);}if(!a){this._resetRowHeights();var u=this.getRows(),v=this.mBindingInfos["rows"],M=v&&v.model;for(var w=u.length-1;w>=0;w--){var x=t?t[w]:undefined;var y=u[w];if(y){y.setRowBindingContext(x,M,l);}}}};s.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var a=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);};s.prototype.removeColumn=function(a,i){var l=this.removeAggregation('columns',a,i);if(typeof a==="number"&&a>-1){a=this.getColumns()[a];}var t=q.inArray(a,this._aSortedColumns);if(!this._bReorderInProcess&&t>=0){this._aSortedColumns.splice(t,1);}this.invalidateRowsAggregation();return l;};s.prototype.removeAllColumns=function(){var a=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};s.prototype.destroyColumns=function(){var a=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};s.prototype.addColumn=function(a,i){this.addAggregation('columns',a,i);this.invalidateRowsAggregation();return this;};s.prototype.insertColumn=function(a,i,l){this.insertAggregation('columns',a,i,l);this.invalidateRowsAggregation();return this;};s.prototype._getTotalRowCount=function(i){if(this._iBindingLength===null||i===true){var a=this.getBinding("rows");return a?a.getLength():0;}else{return this._iBindingLength;}};s.prototype._getSelectableRowCount=function(){return this._getTotalRowCount();};s.prototype._getMaxFirstVisibleRowIndex=function(){var M;if(T.isVariableRowHeightEnabled(this)){M=this._getTotalRowCount(true)-1;}else{M=this._getTotalRowCount(true)-this.getVisibleRowCount();}return Math.max(0,M);};s.prototype._getMaxFirstRenderedRowIndex=function(){var M;if(T.isVariableRowHeightEnabled(this)){M=this._getTotalRowCount(true)-this.getVisibleRowCount()-1;}else{M=this._getTotalRowCount(true)-this.getVisibleRowCount();}return Math.max(0,M);};s.prototype._getFirstRenderedRowIndex=function(){var i=this.getFirstVisibleRow();if(T.isVariableRowHeightEnabled(this)&&i>this._getMaxFirstRenderedRowIndex()){return this._getMaxFirstRenderedRowIndex();}else{return i;}};s.prototype._getVisibleColumns=function(){var a=[];var t=this.getColumns();for(var i=0,l=t.length;i<l;i++){if(t[i].shouldRender()){a.push(t[i]);}}return a;};s.prototype._getColumnsWidth=function(a,t){var u=this.getColumns();var v=0;if(a!==0&&!a){a=0;}if(t!==0&&!t){t=u.length;}for(var i=a,l=t;i<l;i++){if(u[i]&&u[i].shouldRender()){v+=this._CSSSizeToPixel(u[i].getWidth());}}return v;};s.prototype._CSSSizeToPixel=function(a,i){var P=T.Column.getMinColumnWidth();if(a){if(q.sap.endsWith(a,"px")){P=parseInt(a,10);}else if(q.sap.endsWith(a,"em")||q.sap.endsWith(a,"rem")){P=Math.ceil(parseFloat(a)*this._getBaseFontSize());}}if(i){return P+"px";}else{return parseInt(P,10);}};s.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};s.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};s.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return;}if(D.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(T.RowsUpdateReason.Zoom);}};s.prototype._handleRowCountModeAuto=function(t,a){t=t||this._determineAvailableSpace();var i=this.getBinding("rows");var l=this._calculateRowsToDisplay(t);if(i&&this.getRows().length>0){return this._updateRows(l,a);}else{var u=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var v=this;if(t){this._setRowContentHeight(t);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!v._updateRows(l,a)){v._updateTableSizes(a,false,true);}delete v._mTimeouts.handleRowCountModeAutoAdjustRows;},0);return u;}};s.prototype._disableTextSelection=function(a){q(a||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(i){i.preventDefault();return false;});};s.prototype._enableTextSelection=function(a){q(a||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};s.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(a){}}};s.prototype._findAndfireCellEvent=function(a,i,l){var $=q(i.target);var t=$.closest("td.sapUiTableTd");var u=t.attr("id");var M=/.*-row(\d*)-col(\d*)/i.exec(u);var v=false;if(M){var w=M[1];var x=M[2];var y=this.getRows()[w];var z=y&&y.getCells()[x];var A=y&&y.getIndex();var H=z.data("sap-ui-colid");var J;if(this.getBindingInfo("rows")){J=y.getBindingContext(this.getBindingInfo("rows").model);}var P={rowIndex:A,columnIndex:x,columnId:H,cellControl:z,rowBindingContext:J,cellDomRef:t.get(0)};v=!a.call(this,P);if(!v&&typeof l==="function"){P.cellDomRef=t[0];v=l.call(this,P);}}return v;};s.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var a=T.getFocusedItemInfo(this);if(a){return a.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};s.prototype._isRowSelectable=function(i){return i>=0&&i<this._getTotalRowCount();};s.prototype.pushSortedColumn=function(a,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(a);};s.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};s.prototype.sort=function(a,l,A){if(!a){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var t=this.getBinding("rows");if(t){t.sort();}this._aSortedColumns=[];}if(q.inArray(a,this.getColumns())>=0){a.sort(l===r.Descending,A);}};s.prototype.filter=function(a,v){if(q.inArray(a,this.getColumns())>=0){a.filter(v);}};s.prototype._updateSelection=function(){var a=this.getSelectionMode();if(a===o.None){return;}var t=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=T.isRowSelectionAllowed(this);var u=this.getRows();for(var i=0;i<u.length;i++){var v=u[i];v._updateSelection(this,t,l);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);if(T.hasSelectAll(this)){var $=this.$("selall");var A=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!A);this._getAccExtension().setSelectAllState(A);if(this._getShowStandardTooltips()){$.attr('title',T.getResourceText(A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL"));}}};s.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};s.prototype._onSelectionChanged=function(a){var i=a.getParameter("rowIndices");var l=a.getParameter("selectAll");var t=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();this.fireRowSelectionChange({rowIndex:t,rowContext:this.getContextByIndex(t),rowIndices:i,selectAll:l,userInteraction:this._iSourceRowIndex!==undefined});};s.prototype.getContextByIndex=function(i){var a=this.getBinding("rows");return i>=0&&a?a.getContexts(i,1)[0]:null;};s.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};s.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};s.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};s.prototype.selectAll=function(){if(!T.hasSelectAll(this)){return this;}var a=this.getBinding("rows");if(a){this._oSelection.selectAll(this._getTotalRowCount()-1);}return this;};s.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};s.prototype.addSelectionInterval=function(i,a){if(this.getSelectionMode()===e.SelectionMode.None){return this;}this._oSelection.addSelectionInterval(i,a);return this;};s.prototype.setSelectionInterval=function(i,a){if(this.getSelectionMode()===e.SelectionMode.None){return this;}this._oSelection.setSelectionInterval(i,a);return this;};s.prototype.removeSelectionInterval=function(i,a){this._oSelection.removeSelectionInterval(i,a);return this;};s.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};s.prototype.setGroupBy=function(v){var a=v;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof a==="string"){a=sap.ui.getCore().byId(a);}var i=false;if(a instanceof d&&a!==O){if(q.inArray(a,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var l=this.fireGroup({column:a,groupedColumns:[a.getId()],type:G.group});if(O){O.setGrouped(false);i=true;}if(l&&this.getEnableGrouping()){a.setGrouped(true);}}if(!a||i){if(O){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",a);};s.prototype.getBinding=function(a){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[a||"rows"]);};s.prototype.setEnableGrouping=function(a){var i=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",a);if(i){i.setGrouped(a);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};s.prototype.setEnableCustomFilter=function(a){this.setProperty("enableCustomFilter",a);this._invalidateColumnMenus();return this;};s.prototype.setEnableColumnFreeze=function(a){this.setProperty("enableColumnFreeze",a);this._invalidateColumnMenus();return this;};s.prototype.setShowColumnVisibilityMenu=function(a){this.setProperty("showColumnVisibilityMenu",a);this._invalidateColumnMenus();return this;};s.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}return this.getFixedColumnCount();};s.prototype.setFixedColumnCount=function(a,l){var t=this.getColumns();var u,i;for(i=a-1;i>=0;i--){u=t[i];if(u&&u.getVisible()){a=Math.max(a,u.getIndex()+T.Column.getHeaderSpan(u));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=a-1;i>=0;i--){u=t[i];if(u&&T.isVariableWidth(u.getWidth())){u._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+u.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",a,l);this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus();}return this;};s.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};s.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};s.prototype.setThreshold=function(t){this.setProperty("threshold",t,true);};s.prototype._invalidateColumnMenus=function(){var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){a[i].invalidateMenu();}};s.prototype._isTouchEvent=function(a){return!!(a&&a.originalEvent&&a.originalEvent.touches);};s.prototype._getRowClone=function(a){var t=new R(this.getId()+"-rows"+"-row"+a);var u=this.getColumns();for(var i=0,l=u.length;i<l;i++){if(u[i].getVisible()){var v=u[i].getTemplateClone(i);if(v){t.addCell(v);}}}if(T.hasRowActions(this)){var w=this.getRowActionTemplate().clone();w._setFixedLayout(true);w._setCount(this.getRowActionCount());w._setIconLabel(this.getId()+"-rowacthdr");t.setAggregation("_rowAction",w,true);}var x=this.getRowSettingsTemplate();if(x){var y=x.clone();t.setAggregation("_settings",y,true);}return t;};s.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};s.prototype._updateRows=function(a,l,u){if(isNaN(a)){return false;}if(u==null){u=true;}if(T.isVariableRowHeightEnabled(this)){a=a+1;}var i;var t=this.getRows();if(this._bRowAggregationInvalid&&t.length>0){this.destroyAggregation("rows",true);t=[];}if(a==t.length){return false;}for(i=t.length-1;i>=a;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",a-1,true);}else{this.setProperty("visibleRowCount",a,true);}this._ignoreInvalidateOfChildControls=true;var v;var w;var M;var x=this.getBinding("rows");if(u){w=this.getBindingInfo("rows");M=w&&w.model;v=this._getRowContexts(a);for(i=0;i<t.length;i++){t[i].setRowBindingContext(v[i],M,x);}}if(t.length<a){for(i=t.length;i<a;i++){var y=this._getRowClone(i);if(u){y.setRowBindingContext(v[i],M,x);}this.addAggregation("rows",y,true);this._bRowAggregationInvalid=false;if(u){y._updateTableCells(v[i]);}}}this._ignoreInvalidateOfChildControls=false;if(T.isVariableRowHeightEnabled(this)){this._iRenderedFirstVisibleRow=this._getFirstRenderedRowIndex();}var z=u&&v.length>0;return this._renderRows(l,z);};s.prototype._renderRows=function(a,i){var l=false;i=i===true;if(!this._bInvalid){var t=this.getDomRef("tableCCnt");if(this.getRows().length===0||!t){return false;}this._detachEvents();if(this.getVisibleRowCountMode()===V.Auto){var u=this.getDomRef();if(u){u.style.height="0px";}}var v=q.Event("BeforeRendering");v.setMarked("renderRows");v.srcControl=this;this._handleEvent(v);var w=new sap.ui.getCore().createRenderManager(),x=this.getRenderer();x.renderTableCCnt(w,this);w.flush(t,false,false);w.destroy();v=q.Event("AfterRendering");v.setMarked("renderRows");v.srcControl=this;this._handleEvent(v);l=true;}if(i&&!this._bInvalid&&this.getBinding("rows")){var y=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){y._fireRowsUpdated(a);},0);}return l;};s.prototype._getDefaultRowHeight=function(){var i=this.getRowHeight();if(i>0){return i+T.ROW_HORIZONTAL_FRAME_SIZE;}else{var a=T.getContentDensity(this);return T.DEFAULT_ROW_HEIGHT[a];}};s.prototype._setRowContentHeight=function(H){H=H||0;var v=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var a=this._getDefaultRowHeight();var M=this.getMinAutoRowCount();var l;if(v==V.Interactive||v==V.Fixed){if(this._iTableRowContentHeight&&v==V.Interactive){l=M*a;if(!H){H=this._iTableRowContentHeight;}}else{l=i*a;H=l;}}else if(v==V.Auto){l=M*a;}var t=Math.max(H,l);if((v==V.Fixed&&this.getRows().length==0)||v!=V.Fixed){this._iTableRowContentHeight=Math.floor(t/a)*a;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",a*i+"px");}else{if((v==V.Fixed||v==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}};s.prototype._determineMinAutoRowCount=function(){var M=this.getMinAutoRowCount();if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){M=this.getVisibleRowCount()||M;}return M;};s.prototype._calculateRowsToDisplay=function(t){this._iRowsToDisplayHeight=t||this._iRowsToDisplayHeight||this._iTableRowContentHeight;t=this._iRowsToDisplayHeight;var v=this.getVisibleRowCountMode();var i=0;if(v==V.Fixed){i=this.getVisibleRowCount()||0;}else if(v==V.Interactive||v==V.Auto){var M=this._determineMinAutoRowCount();var a=this._getDefaultRowHeight();if(!a||!t){i=M;}else{var A=Math.min(t,50000);var l=Math.floor(A/a);i=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(M,l));}}return Math.max(i,0);};s.prototype.setShowNoData=function(a){this.setProperty('showNoData',a,true);this._updateNoData();return this;};s.prototype.setNoData=function(v){var O=T.getNoDataText(this);this.setAggregation("noData",v,true);var a=T.getNoDataText(this);if(O!=null&&a!=null){if(O!==a){this.$("noDataMsg").text(a);}}else{this.invalidate();}return this;};s.prototype.exportData=function(a){var t=sap.ui.requireSync("sap/ui/core/util/Export");a=a||{};if(!a.rows){var u=this.getBinding("rows"),v=this.getBindingInfo("rows");var w=u.aFilters.concat(u.aApplicationFilters);a.rows={path:v.path,model:v.model,sorter:u.aSorters,filters:w,parameters:v.parameters};}if(!a.exportType){var x=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");a.exportType=new x();}var M=a.rows.model;if(!M){var P=a.rows.path;var y=P.indexOf(">");if(y>0){M=P.substr(0,y);}}if(!a.columns){a.columns=[];var z=this.getColumns();for(var i=0,l=z.length;i<l;i++){var A=z[i];if(A.getSortProperty()){a.columns.push({name:A.getLabel().getText(),template:{content:{path:A.getSortProperty(),model:M}}});}}}var H=new t(a);this.addDependent(H);return H;};s.prototype._onPersoApplied=function(){var a=this.getColumns();var t=[];for(var i=0,l=a.length;i<l;i++){var u=a[i];if(u.getSorted()){t.push(new c(u.getSortProperty(),u.getSortOrder()===r.Descending));}}var v=this.getBinding("rows");if(v){if(t.length>0){v.sort(t);}this.refreshRows();}};s.prototype._toggleSelectAll=function(){if(!T.hasData(this)){return;}if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}this._iSourceRowIndex=undefined;};s.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var a=this.getColumns();q.each(a,function(i,l){l._restoreAppDefaults();});};s.prototype.setBusy=function(a,i){var l=this.getBusy()!=a;i="sapUiTableCnt";var v=C.prototype.setBusy.call(this,a,i);if(l){this.fireBusyStateChanged({busy:a});}return v;};s.prototype.setEnableBusyIndicator=function(v){this.setProperty("enableBusyIndicator",v,true);if(!v){this.setBusy(false);}};s.prototype._onBindingDataRequested=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var i=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(i&&this._iPendingRequests===1||!i)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};s.prototype._onBindingDataReceived=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;this._updateTotalRowCount(true);if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;});}};s.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};s.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};s.prototype._updateTableContent=function(){T.Grouping.updateGroups(this);};s.prototype.setRowActionTemplate=function(t){this.setAggregation("rowActionTemplate",t);t=this.getRowActionTemplate();if(t){t._setCount(this.getRowActionCount());}this.invalidateRowsAggregation();return this;};s.prototype.setRowActionCount=function(a){this.setProperty("rowActionCount",a);a=this.getRowActionCount();var l=this.getRowActionTemplate();if(l){l._setCount(a);}var t=this.getRows();for(var i=0;i<t.length;i++){l=t[i].getAggregation("_rowAction");if(l){l._setCount(a);}}return this;};s.prototype.setRowSettingsTemplate=function(t){this.setAggregation("rowSettingsTemplate",t);this.invalidateRowsAggregation();return this;};s.prototype._validateRow=function(a){return a&&a instanceof R&&a.getParent()===this;};s.prototype.getRowForCell=function(a){if(a){var i=a.getParent();if(this._validateRow(i)){return i;}}return null;};s.prototype.getColumnForCell=function(a){if(this.getRowForCell(a)){var i=a.data("sap-ui-colindex");var l=this.getColumns();if(i>=0&&i<l.length){return l[i];}}return null;};s.prototype.getCellControl=function(i,a,v){var l=T.getRowColCell(this,i,a,!v);return l.cell;};s.prototype._fireRowsUpdated=function(a){if(a==null){a=T.RowsUpdateReason.Unknown;}this.fireEvent("_rowsUpdated",{reason:a});};return s;});
