/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./TableExtension","./TableUtils","sap/ui/Device","./library","jquery.sap.trace","jquery.sap.events"],function(q,T,c,D,l){"use strict";var S=l.SharedDomRef;var M=1000000;var V=2;var H={onScroll:function(o){var s=this._getScrollExtension();q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(o);if(this._bOnAfterRendering){return;}var n=o.target.scrollLeft;var O=o.target._scrollLeft;if(n!==O){var a=H.getScrollAreas(this);o.target._scrollLeft=n;for(var i=0;i<a.length;i++){var b=a[i];if(b!==o.target&&b.scrollLeft!==n){b.scrollLeft=n;b._scrollLeft=n;}}s._iHorizontalScrollPosition=n;}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var h=s.getHorizontalScrollbar();if(h&&s._iHorizontalScrollPosition!==null){var a=H.getScrollAreas(t);for(var i=0;i<a.length;i++){var o=a[i];delete o._scrollLeft;}if(h.scrollLeft!==s._iHorizontalScrollPosition){h.scrollLeft=s._iHorizontalScrollPosition;}else{var b=q.Event("scroll");b.target=h;H.onScroll.call(t,b);}}},onScrollbarMouseDown:function(o){this._getKeyboardExtension().setActionMode(false);},addEventListeners:function(t){var s=t._getScrollExtension();var h=s.getHorizontalScrollbar();var a=H.getScrollAreas(t);if(!s._onHorizontalScrollEventHandler){s._onHorizontalScrollEventHandler=H.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}if(h){if(!s._onHorizontalScrollbarMouseDownEventHandler){s._onHorizontalScrollbarMouseDownEventHandler=H.onScrollbarMouseDown.bind(t);}h.addEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var h=s.getHorizontalScrollbar();var a=H.getScrollAreas(t);if(s._onHorizontalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete a[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}if(h&&s._onHorizontalScrollbarMouseDownEventHandler){h.removeEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);delete s._onHorizontalScrollbarMouseDownEventHandler;}},getScrollAreas:function(t){var s=[t._getScrollExtension().getHorizontalScrollbar(),t.getDomRef("sapUiTableColHdrScr"),t.getDomRef("sapUiTableCtrlScr")];return s.filter(function(o){return o!=null;});}};var d={onScroll:function(o){var s=this._getScrollExtension();q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(o);if(s._bIsScrolledVerticallyByKeyboard||d.isUpdatePending(this)){q.sap.log.debug("sap.ui.table.TableScrollExtension","Vertical scroll event handler aborted: "+(s._bIsScrolledVerticallyByKeyboard?"Scrolled by keyboard":"Waiting for pending update"),this);return;}this._getKeyboardExtension().setActionMode(false);var n=o.target.scrollTop;var a=o.target._scrollTop;if(n!==a){q.sap.log.debug("sap.ui.table.TableScrollExtension","Scroll position changed by setting scrollTop: "+"From "+s._nVerticalScrollPosition+" to "+n,this);delete o.target._scrollTop;s._nVerticalScrollPosition=n;s._iFirstVisibleRowInBuffer=null;}q.sap.clearDelayedCall(this._mTimeouts.largeDataScrolling);delete this._mTimeouts.largeDataScrolling;if(this._bLargeDataScrolling&&!s._bIsScrolledVerticallyByWheel){this._mTimeouts.largeDataScrolling=q.sap.delayedCall(300,this,function(){delete this._mTimeouts.largeDataScrolling;d.updateFirstVisibleRow(this);});}else{d.updateFirstVisibleRow(this);}s._bIsScrolledVerticallyByWheel=false;},updateFirstVisibleRow:function(t){var s=t._getScrollExtension();var n=s.getRowIndexAtCurrentScrollPosition();var o=t.getFirstVisibleRow();var N=n<0;var O=o>=t._getMaxFirstRenderedRowIndex();var F=n!==o;var r=F&&!(N&&O);if(r){if(N){n=t._getMaxFirstRenderedRowIndex();}q.sap.log.debug("sap.ui.table.TableScrollExtension","updateFirstVisibleRow: From "+o+" to "+n,t);t.setFirstVisibleRow(n,true);t._bIgnoreOnRowsUpdatedOnScroll=true;t.attachEventOnce("_rowsUpdated",function(){s.updateInnerVerticalScrollPosition();delete t._bIgnoreOnRowsUpdatedOnScroll;});}else if(c.isVariableRowHeightEnabled(t)){q.sap.log.debug("sap.ui.table.TableScrollExtension","updateFirstVisibleRow: Update inner vertical scroll position",t);s.updateInnerVerticalScrollPosition();}},onScrollbarMouseDown:function(o){var s=this._getScrollExtension();s._bIsScrolledVerticallyByWheel=false;s._bIsScrolledVerticallyByKeyboard=false;},onRowsUpdated:function(o){if(this._bIgnoreOnRowsUpdatedOnScroll){return;}if(c.isVariableRowHeightEnabled(this)){var r=o.getParameters().reason;var s=this._getScrollExtension();var F=this.getFirstVisibleRow()-this._getMaxFirstRenderedRowIndex();if(F>=0&&(r===c.RowsUpdateReason.Expand||r===c.RowsUpdateReason.Collapse)){s._iFirstVisibleRowInBuffer=F;s.updateInnerVerticalScrollPosition();}}},restoreScrollPosition:function(t){var s=t._getScrollExtension();s.updateVerticalScrollPosition(s._nVerticalScrollPosition);},addEventListeners:function(t){var s=t._getScrollExtension();var a=d.getScrollAreas(t);var v=s.getVerticalScrollbar();if(!s._onVerticalScrollEventHandler){s._onVerticalScrollEventHandler=d.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v){if(!s._onVerticalScrollbarMouseDownEventHandler){s._onVerticalScrollbarMouseDownEventHandler=d.onScrollbarMouseDown.bind(t);}v.addEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);}t.attachEvent("_rowsUpdated",d.onRowsUpdated);},removeEventListeners:function(t){var s=t._getScrollExtension();var a=d.getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v&&s._onVerticalScrollbarMouseDownEventHandler){v.removeEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);delete s._onVerticalScrollbarMouseDownEventHandler;}t.detachEvent("_rowsUpdated",d.onRowsUpdated);},isUpdatePending:function(t){return!!(t&&(t._mAnimationFrames.verticalScrollUpdate||t._mTimeouts.verticalScrollUpdate));},getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(o){return o!=null;});}};var e={onMouseWheelScrolling:function(o){var s=this._getScrollExtension();var v=Math.abs(o.deltaY)>Math.abs(o.deltaX);var i=v?o.deltaY:o.deltaX;var h=v&&o.shiftKey||!v;var b=i>0;var a=false;if(i===0){return;}if(h){var g=s.getHorizontalScrollbar();if(o.deltaMode>0){var m=c.Column.getMinColumnWidth();i=b?m:-m;}if(b){a=g.scrollLeft===g.scrollWidth-g.offsetWidth;}else{a=g.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!a){this._getKeyboardExtension().setActionMode(false);g.scrollLeft=g.scrollLeft+i;}o.preventDefault();o.stopPropagation();}else{var j=s.getVerticalScrollbar();if(o.deltaMode===1){i*=s.getVerticalScrollRangeRowFraction();}else if(o.deltaMode===2){i*=s.getVerticalScrollRangeRowFraction()*this.getVisibleRowCount();}if(b){a=j.scrollTop===j.scrollHeight-j.offsetWidth;}else{a=j.scrollTop===0;}if(s.isVerticalScrollbarVisible()&&!a){o.preventDefault();o.stopPropagation();var n=s.getVerticalScrollPosition();var k=i;var p=s.getVerticalScrollRangeRowFraction();if(!s.isVerticalScrollPositionInBuffer()){var r=i/this._getDefaultRowHeight();if(r>1){r=Math.floor(r);}else if(r<-1){r=Math.ceil(r);}k=r*p;}else if(!b){var t=n-(this._getFirstRenderedRowIndex()*p);if(t<=0){k=-s.getVerticalScrollRangeRowFraction();}else if(t+k<0){k=-t;}}s._bIsScrolledVerticallyByWheel=true;s._bIsScrolledVerticallyByKeyboard=false;s.updateVerticalScrollPosition(n+k);}}},onTouchStart:function(o){if(o.type==="touchstart"||o.pointerType==="touch"){var s=this._getScrollExtension();var h=s.getHorizontalScrollbar();var v=s.getVerticalScrollbar();var t=o.touches?o.touches[0]:o;s._mTouchSessionData={initialPageX:t.pageX,initialPageY:t.pageY,initialScrollTop:v?v.scrollTop:0,initialScrollLeft:h?h.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null};}},onTouchMoveScrolling:function(o){if(o.type==="touchmove"||o.pointerType==="touch"){var s=this._getScrollExtension();var t=s._mTouchSessionData;if(!t){return;}var a=o.touches?o.touches[0]:o;var i=(a.pageX-t.initialPageX);var b=(a.pageY-t.initialPageY);var g=false;var h=false;if(!t.touchMoveDirection){if(i===0&&b===0){return;}t.touchMoveDirection=Math.abs(i)>Math.abs(b)?"horizontal":"vertical";}switch(t.touchMoveDirection){case"horizontal":var j=s.getHorizontalScrollbar();if(j){this._getKeyboardExtension().setActionMode(false);if(i<0){g=j.scrollLeft===j.scrollWidth-j.offsetWidth;}else{g=j.scrollLeft===0;}if(!t.initialScrolledToEnd){t.initialScrolledToEnd=g;}if(!g&&!t.initialScrolledToEnd){j.scrollLeft=t.initialScrollLeft-i;h=true;}}break;case"vertical":var v=s.getVerticalScrollbar();if(v){if(b<0){g=v.scrollTop===v.scrollHeight-v.offsetHeight;}else{g=v.scrollTop===0;}if(!t.initialScrolledToEnd){t.initialScrolledToEnd=g;}if(!g&&!t.initialScrolledToEnd){v.scrollTop=t.initialScrollTop-b;h=true;}}break;default:}if(h){o.preventDefault();}}},addEventListeners:function(t){var s=t._getScrollExtension();var a=e.getEventListenerTargets(t);if(!s._onMouseWheelEventHandler){s._onMouseWheelEventHandler=e.onMouseWheelScrolling.bind(t);}if(!s._onTouchStartEventHandler){s._onTouchStartEventHandler=e.onTouchStart.bind(t);}if(!s._onTouchMoveEventHandler){s._onTouchMoveEventHandler=e.onTouchMoveScrolling.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("wheel",s._onMouseWheelEventHandler);if(D.support.pointer&&D.system.desktop){a[i].addEventListener("pointerdown",s._onTouchStartEventHandler);a[i].addEventListener("pointermove",s._onTouchMoveEventHandler,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].addEventListener("touchstart",s._onTouchStartEventHandler);a[i].addEventListener("touchmove",s._onTouchMoveEventHandler);}}},removeEventListeners:function(t){var s=t._getScrollExtension();var a=e.getEventListenerTargets(t);for(var i=0;i<a.length;i++){if(s._onMouseWheelEventHandler){a[i].removeEventListener("wheel",s._onMouseWheelEventHandler);}if(s._onTouchStartEventHandler&&s._onTouchMoveEventHandler){if(D.support.pointer&&D.system.desktop){a[i].removeEventListener("pointerdown",s._onTouchStartEventHandler);a[i].removeEventListener("pointermove",s._onTouchMoveEventHandler,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].removeEventListener("touchstart",s._onTouchStartEventHandler);a[i].removeEventListener("touchmove",s._onTouchMoveEventHandler);}}}delete s._onMouseWheelEventHandler;delete s._onTouchStartEventHandler;delete s._onTouchMoveEventHandler;},getEventListenerTargets:function(t){var a=[t.getDomRef("tableCCnt")];return a.filter(function(o){return o!=null;});}};var E={onBeforeRendering:function(o){this._getScrollExtension()._clearCache();},onAfterRendering:function(o){var s=this._getScrollExtension();var r=o&&o.isMarked("renderRows");if(r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}d.restoreScrollPosition(this);H.restoreScrollPosition(this);},onfocusin:function(o){var r;var C=c.getCellInfo(o.target);if(C.isOfType(c.CELLTYPE.DATACELL)){r=this.getDomRef("sapUiTableCtrlScr");}else if(C.isOfType(c.CELLTYPE.COLUMNHEADER)){r=this.getDomRef("sapUiTableColHdrScr");}if(r&&C.columnIndex>=this.getComputedFixedColumnCount()){var a=C.cell[0];var s=r.scrollLeft;var R=r.clientWidth;var i=a.offsetLeft;var b=i+a.offsetWidth;var O=i-s;var g=b-R-s;var h=this._getScrollExtension().getHorizontalScrollbar();if(O<0&&g<0){h.scrollLeft=s+O;}else if(g>0&&O>0){h.scrollLeft=s+g;}}var p=c.getParentCell(this,o.target);if(p){Promise.resolve().then(function(){var I=p.find(".sapUiTableCell")[0];if(I){I.scrollLeft=0;I.scrollTop=0;}});}}};var f=T.extend("sap.ui.table.TableScrollExtension",{_init:function(t,s,m){this._delegate=E;this._oHorizontalScrollbar=null;this._iHorizontalScrollPosition=null;this._oVerticalScrollbar=null;this._nVerticalScrollPosition=null;this._iVerticalScrollHeight=null;this._iVerticalScrollbarHeight=null;this._iFirstVisibleRowInBuffer=null;this._bIsScrolledVerticallyByWheel=false;this._bIsScrolledVerticallyByKeyboard=false;this._mTouchSessionData=null;t.addEventDelegate(this._delegate,t);return"ScrollExtension";},_attachEvents:function(){var t=this.getTable();H.addEventListeners(t);d.addEventListeners(t);e.addEventListeners(t);},_detachEvents:function(){var t=this.getTable();H.removeEventListeners(t);d.removeEventListeners(t);e.removeEventListeners(t);},_debug:function(){this._ScrollingHelper=e;this._ExtensionDelegate=E;this._HorizontalScrollingHelper=H;this._VerticalScrollingHelper=d;},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;this._clearCache();T.prototype.destroy.apply(this,arguments);}});f.prototype.scrollVertically=function(b,p,i){var t=this.getTable();if(!t){return false;}if(b==null){b=false;}if(p==null){p=false;}if(i==null){i=false;}var s=false;var r=t._getTotalRowCount();var v=t.getVisibleRowCount();var a=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var F=t.getFirstVisibleRow();var g=p?a:1;if(b){if(F+v<r){t.setFirstVisibleRow(Math.min(F+g,r-v));s=true;}}else if(F>0){t.setFirstVisibleRow(Math.max(F-g,0));s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};f.prototype.scrollVerticallyMax=function(b,i){var t=this.getTable();if(!t){return false;}if(b==null){b=false;}if(i==null){i=false;}var s=false;var F=t.getFirstVisibleRow();if(b){var a=t._getTotalRowCount()-c.getNonEmptyVisibleRowCount(t);if(F<a){t.setFirstVisibleRow(a);s=true;}}else if(F>0){t.setFirstVisibleRow(0);s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};f.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(t&&!this._oHorizontalScrollbar){this._oHorizontalScrollbar=t.getDomRef(S.HorizontalScrollBar);}return this._oHorizontalScrollbar;};f.prototype.getVerticalScrollbar=function(){var t=this.getTable();if(t&&!this._oVerticalScrollbar){this._oVerticalScrollbar=t.getDomRef(S.VerticalScrollBar);}return this._oVerticalScrollbar;};f.prototype.isHorizontalScrollbarVisible=function(){var t=this.getTable();var o=t?t.getDomRef():null;if(!o){return false;}return o.classList.contains("sapUiTableHScr");};f.prototype.isVerticalScrollbarVisible=function(){var t=this.getTable();var o=t?t.getDomRef():null;if(!o){return false;}return o.classList.contains("sapUiTableVScr");};f.prototype.updateHorizontalScrollbar=function(t){var o=this.getTable();var h=this.getHorizontalScrollbar();if(!o||!h||!t){return;}var $=o.$();var C=t.tableCtrlScrollWidth;if(D.browser.safari){C=Math.max(C,o._getColumnsWidth(o.getComputedFixedColumnCount()));}var b=C>t.tableCtrlScrWidth;if(b){if(!this.isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");if(D.browser.safari){var a=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");a.outerWidth(C);}}var s=t.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){s+=t.tableRowHdrScrWidth;}if(o.getRows().length>0){if(o._bRtlMode){h.style.marginRight=s+"px";h.style.marginLeft="";}else{h.style.marginLeft=s+"px";h.style.marginRight="";}}var g=o.getDomRef("hsb-content");if(g){g.style.width=C+"px";}}if(!b&&this.isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");if(D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}};f.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var n=this.getVerticalScrollbarHeight();v.style.maxHeight=n+"px";if(this._iVerticalScrollbarHeight!==n){this._iVerticalScrollbarHeight=n;this.updateVerticalScrollPosition();}};f.prototype.getVerticalScrollbarHeight=function(){var t=this.getTable();if(!t){return 0;}var s=Math.max(1,t.getVisibleRowCount()-t.getFixedRowCount()-t.getFixedBottomRowCount());return s*t._getDefaultRowHeight();};f.prototype.updateVerticalScrollbarPosition=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var o=t.getDomRef("tableCCnt");if(o){var i=o.offsetTop;var a=t.getDomRef("vsb-bg");a.style.top=i+"px";var F=t.getFixedRowCount();if(F>0){i+=t._iVsbTop;}v.style.top=i+"px";}};f.prototype.updateVerticalScrollPosition=function(n){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v||!this.isVerticalScrollbarRequired()){return;}var a=this._nVerticalScrollPosition;var N=0;var i=this.getVerticalScrollRange();if(n==null){var F=t.getFirstVisibleRow();var m=t._getMaxFirstRenderedRowIndex();if(F>m){this._nVerticalScrollPosition=this.getVerticalScrollRange();this._iFirstVisibleRowInBuffer=F-m;}else{this._nVerticalScrollPosition=F*this.getVerticalScrollRangeRowFraction();this._iFirstVisibleRowInBuffer=null;}}else{var b=0;var g=this.getVerticalScrollRange();this._nVerticalScrollPosition=Math.min(Math.max(b,n),g);this._iFirstVisibleRowInBuffer=null;}q.sap.log.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: From "+a+" to "+this._nVerticalScrollPosition+" (diff: "+(this._nVerticalScrollPosition-a)+")",t);if(this._nVerticalScrollPosition>0&&this._nVerticalScrollPosition<0.5){N=1;}else if(this._nVerticalScrollPosition>=i-0.5&&this._nVerticalScrollPosition<i){N=i-1;}else{N=Math.round(this._nVerticalScrollPosition);}if(v.scrollTop!==N){if(t._mAnimationFrames.verticalScrollUpdate){window.cancelAnimationFrame(t._mAnimationFrames.verticalScrollUpdate);}q.sap.clearDelayedCall(t._mTimeouts.verticalScrollUpdate);delete t._mTimeouts.verticalScrollUpdate;q.sap.log.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: scrollTop will be set asynchronously",t);t._mAnimationFrames.verticalScrollUpdate=window.requestAnimationFrame(function(){var h=v.scrollTop;delete t._mAnimationFrames.verticalScrollUpdate;q.sap.log.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: (async) Set scrollTop from "+h+" to "+N,t);v.scrollTop=N;v._scrollTop=v.scrollTop;if(v.scrollTop===h){d.updateFirstVisibleRow(t);}});}else if(this._nVerticalScrollPosition!==a){if(t._mAnimationFrames.verticalScrollUpdate){window.cancelAnimationFrame(t._mAnimationFrames.verticalScrollUpdate);delete t._mAnimationFrames.verticalScrollUpdate;}q.sap.clearDelayedCall(t._mTimeouts.verticalScrollUpdate);q.sap.log.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: firstVisibleRow will be set asynchronously",t);t._mTimeouts.verticalScrollUpdate=q.sap.delayedCall(0,this,function(){delete t._mTimeouts.verticalScrollUpdate;d.updateFirstVisibleRow(t);});}else{q.sap.log.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: scrollTop and nVerticalScrollPosition not changed -> update inner vertical scroll position",t);this.updateInnerVerticalScrollPosition();}};f.prototype.updateVerticalScrollHeight=function(){var t=this.getTable();var v=t?t.getDomRef("vsb-content"):null;if(!v){return;}var n=this.getVerticalScrollHeight(true);v.style.height=this.getVerticalScrollHeight()+"px";if(this._iVerticalScrollHeight!==n){this._iVerticalScrollHeight=n;this.updateVerticalScrollPosition();}};f.prototype.getVerticalScrollHeight=function(b){var t=this.getTable();if(!t){return 0;}var i=t._getTotalRowCount();var v=t.getVisibleRowCount();var a=t._getDefaultRowHeight();var r;var s;if(c.isVariableRowHeightEnabled(t)){r=Math.max(i,v+1);s=a*(r-1)+this.getVerticalScrollRangeBuffer();}else{r=Math.max(i,v);s=a*r;}if(b===true){return s;}else{return Math.min(M,s);}};f.prototype.updateVerticalScrollbarVisibility=function(){var t=this.getTable();var o=t?t.getDomRef():null;var v=this.getVerticalScrollbar();if(!o||!v){return;}var b=this.isVerticalScrollbarRequired();if(b&&!this.isVerticalScrollbarVisible()){o.classList.add("sapUiTableVScr");this.updateVerticalScrollPosition(0);}if(!b&&this.isVerticalScrollbarVisible()){o.classList.remove("sapUiTableVScr");}};f.prototype.isVerticalScrollbarRequired=function(){var t=this.getTable();if(!t){return false;}return this.getInnerVerticalScrollRange()>0||(t._getTotalRowCount()>t.getVisibleRowCount());};f.prototype.getRowIndexAtCurrentScrollPosition=function(){var t=this.getTable();if(!t){return-1;}var m=t._getMaxFirstVisibleRowIndex();if(m===0){return 0;}else{var n=this.getVerticalScrollPosition();var s=this.getVerticalScrollRange();var a=this.getVerticalScrollRangeRowFraction();if(c.isVariableRowHeightEnabled(t)){if(this.isVerticalScrollPositionInBuffer()){return-1;}else{return Math.min(m,Math.floor(n/a));}}else{var r=Math.floor(n/a);var b=s-n;var g=this.getVerticalScrollbar()._scrollTop==null;var h=b<1;if(h&&g){this._nVerticalScrollPosition=s;}return h&&g?m:Math.min(m,r);}}};f.prototype.getVerticalScrollRange=function(){var v=this.getVerticalScrollHeight()-this.getVerticalScrollbarHeight();return Math.max(0,v);};f.prototype.getVerticalScrollRangeBuffer=function(){var t=this.getTable();if(!c.isVariableRowHeightEnabled(t)){return 0;}return V*t._getDefaultRowHeight();};f.prototype.getVerticalScrollPosition=function(){if(this._nVerticalScrollPosition!=null){return this._nVerticalScrollPosition;}else if(this.isVerticalScrollbarVisible()){return this._oVerticalScrollbar.scrollTop;}else{return 0;}};f.prototype.getVerticalScrollRangeRowFraction=function(){var t=this.getTable();if(!t){return 0;}var v=t._getTotalRowCount()-t.getVisibleRowCount();var s;if(c.isVariableRowHeightEnabled(t)){s=this.getVerticalScrollRange()-this.getVerticalScrollRangeBuffer();var b=this.getVerticalScrollHeight()===M;if(!b){s+=t._getDefaultRowHeight();}}else{s=this.getVerticalScrollRange();}return s/Math.max(1,v);};f.prototype.updateInnerVerticalScrollPosition=function(){var t=this.getTable();var C=t?t.getDomRef("tableCCnt"):null;if(!c.isVariableRowHeightEnabled(t)||!C||d.isUpdatePending(t)){return;}var I=this.getInnerVerticalScrollRange();if(I===0){q.sap.log.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: 0",t);t.setFirstVisibleRow(0,true);this._nVerticalScrollPosition=0;C.scrollTop=0;return;}if(t._getFirstRenderedRowIndex()!==t._iRenderedFirstVisibleRow){q.sap.log.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: Skipped, because rows will be updated",t);return;}var F=t.getFirstVisibleRow();var n=this.getVerticalScrollPosition();var s=this.isVerticalScrollPositionInBuffer();var a=0;var b;var g;var h=null;var r=t._aRowHeights;if(!s){var j=this.getVerticalScrollRangeRowFraction();a=n-(F*j);b=r[0];g=Math.max(0,Math.min(a/j,1));h=Math.round(b*g);}else{var k=0;var m=0;var i;for(i=0;i<r.length&&m<I;i++){k++;m+=r[i];}var o=this.getVerticalScrollRange();var B=this.getVerticalScrollRangeBuffer();var p=B/k;if(this._iFirstVisibleRowInBuffer==null){a=n-o+B;var u=Math.min(Math.floor(a/p),k);b=r[u]||0;g=Math.max(0,Math.min((a-(p*u))/p,1));for(i=0;i<u;i++){h+=r[i];}h+=b*g;h=Math.min(h,I);var N=t._getMaxFirstRenderedRowIndex()+u;if(N!==F){q.sap.log.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: Set firstVisibleRow from "+F+" to "+N,t);t.setFirstVisibleRow(N,true);}}else{var v=o-B;a=this._iFirstVisibleRowInBuffer*p;var w=v+a;g=0;q.sap.log.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: Set scroll position to "+w,t);this.updateVerticalScrollPosition(w);return;}}q.sap.log.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: "+h+" of "+b+" ("+(g*100)+"%)"+" (in buffer: "+s+")",t);C.scrollTop=h;};f.prototype.isVerticalScrollPositionInBuffer=function(){var t=this.getTable();if(!c.isVariableRowHeightEnabled(t)){return false;}return this.getVerticalScrollRange()-this.getVerticalScrollPosition()<=this.getVerticalScrollRangeBuffer();};f.prototype.getInnerVerticalScrollRange=function(){var t=this.getTable();if(!t||!t._aRowHeights){return 0;}var r=t._aRowHeights;var i=t._getDefaultRowHeight()*t.getVisibleRowCount();if(t.getVisibleRowCount()>=t._getTotalRowCount()){r=r.slice(0,t._getTotalRowCount());}var I=r.reduce(function(a,b){return a+b;},0)-i;if(I>0){I=Math.ceil(I);}return Math.max(0,I);};f.prototype._clearCache=function(){this._oVerticalScrollbar=null;this._oHorizontalScrollbar=null;};return f;});
