/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRenderer"],function(q,C,L,a,D,H,M,b,Y,c,l,d,e,R,f,g){"use strict";var h=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});h.prototype.init=function(){this._iBreakPointTablet=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._iColumns=1;this._oYearFormat=e.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var u=this._createMonth(this.getId()+"--Month0");u.attachEvent("focus",this._handleFocus,this);u.attachEvent("select",o,this);u.attachEvent("_renderMonth",n,this);u.attachEvent("_bindMousemove",p,this);u.attachEvent("_unbindMousemove",r,this);u._bNoThemeChange=true;this.addAggregation("month",u);this._initilizeMonthPicker();this._initilizeYearPicker();this._resizeProxy=q.proxy(s,this);this._oSelectedMonth;};h.prototype.exit=function(){if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};h.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this.setAggregation("header",i);};h.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead");S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("secondMonthHeader",S);};h.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};h.prototype._initilizeYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);this.setAggregation("yearPicker",y);};h.prototype._createMonth=function(i){var u=new M(i,{width:"100%"});u.attachEvent("datehovered",this._handleDateHovered,this);return u;};h.prototype._handleDateHovered=function(E){var u=this.getAggregation("month"),v=E.getParameter("date1"),w=E.getParameter("date2"),i;for(i=0;i<u.length;i++){u[i]._markDatesBetweenStartAndHoveredDate(v,w);}};h.prototype.onBeforeRendering=function(){var u=this.getAggregation("month");var v;var w=u[0].getDate();var F=this._getFocusedDate();if(u.length>1&&w){v=c.fromLocalJSDate(w,this.getPrimaryCalendarType());}else if(u.length>1){v=t.call(this,this._getFocusedDate());}else{v=F;}for(var i=0;i<u.length;i++){w=new c(v);if(i>0){w.setDate(1);w.setMonth(w.getMonth()+i);}var x=w;if(F.getYear()===w.getYear()&&F.getMonth()===w.getMonth()){x=F;}u[i].displayDate(x.toLocalJSDate());u[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(v);this._iSize=0;};h.prototype.onAfterRendering=function(E){if(!this._getSucessorsPickerPopup()){j.call(this);}if(m.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};s.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};h.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof D))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=q.sap.delayedCall(0,this,this._invalidateMonth,[O]);}};h.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};h.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};h.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};h.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};h.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};h.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};h.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};h.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};h.prototype.focusDate=function(i){k.call(this,i,false);return this;};h.prototype.displayDate=function(i){k.call(this,i,true);return this;};h.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};h.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};h.prototype.setMonths=function(u){this._bDateRangeChanged=undefined;this.setProperty("months",u,false);u=m.call(this);var v=this.getAggregation("month");var i=0;var w;if(v.length<u){for(i=v.length;i<u;i++){w=this._createMonth(this.getId()+"--Month"+i);w.attachEvent("focus",this._handleFocus,this);w.attachEvent("select",o,this);w.attachEvent("_renderMonth",n,this);w.attachEvent("_bindMousemove",p,this);w.attachEvent("_unbindMousemove",r,this);w._bNoThemeChange=true;this.addAggregation("month",w);}}else if(v.length>u){for(i=v.length;i>u;i--){w=this.removeAggregation("month",i-1);w.destroy();}if(u==1){this._bInitMonth=true;}}if(u>1&&v[0].getDate()){v[0].setProperty("date",null,true);}return this;};h.prototype.setPrimaryCalendarType=function(u){var v=this.getAggregation("month");var w=false;if(v.length>1){w=true;}this.setProperty("primaryCalendarType",u,!w);this._oYearFormat=e.getDateInstance({format:"y",calendarType:u});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,u);}this._oMinDate=new c(this._oMinDate,u);this._oMaxDate=new c(this._oMaxDate,u);for(var i=0;i<v.length;i++){var x=v[i];x.setPrimaryCalendarType(u);}if(!this._getSucessorsPickerPopup()){var y=this.getAggregation("monthPicker");y.setPrimaryCalendarType(u);var z=this.getAggregation("yearPicker");z.setPrimaryCalendarType(u);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&y.getDomRef()){y.$().remove();}if(this.iMode!=2&&z.getDomRef()){z.$().remove();}}}return this;};h.prototype.setSecondaryCalendarType=function(u){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",u,true);this._oYearFormatSecondary=e.getDateInstance({format:"y",calendarType:u});var v=this.getAggregation("month");for(var i=0;i<v.length;i++){var w=v[i];w.setSecondaryCalendarType(u);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};h.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};h.prototype.setMinDate=function(i){if(q.sap.equal(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMinDate.getYear();a._checkYearInValidRange(y);if(this._oMaxDate.isBefore(this._oMinDate)){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){var u=this.getAggregation("yearPicker");u._oMinDate.setYear(this._oMinDate.getYear());}return this;};h.prototype.setMaxDate=function(i){if(q.sap.equal(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMaxDate.getYear();a._checkYearInValidRange(y);if(this._oMinDate.isAfter(this._oMaxDate)){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){var u=this.getAggregation("yearPicker");u._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};h.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){q.sap.log.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};h.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var u=new f(i);this._oLocaleData=L.getInstance(u);}return this._oLocaleData;};h.prototype._getShowMonthHeader=function(){var i=m.call(this);if(i>2){return true;}else{return false;}};h.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);if(w){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};h.prototype.onclick=function(E){var i=E.target,T=i.classList.contains("sapUiCalWeekNum");if(this.getIntervalSelection()&&this.getPrimaryCalendarType()===sap.ui.core.CalendarType.Gregorian&&T){this._handleWeekSelection(i);}if(E.isMarked("delayedMouseEvent")){return;}if(i.id==this.getId()+"-cancel"){this.onsapescape(E);}};h.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};h.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};h.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};h.prototype.onsaphide=h.prototype.onsapshow;h.prototype.onsaptabnext=function(E){var u=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabNext(E)){q.sap.focus(u.getDomRef("B2"));}else{q.sap.focus(u.getDomRef("B1"));}if(!this._bPoupupMode){var v=this.getAggregation("month");for(var i=0;i<v.length;i++){var w=v[i];q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var x=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(x.getDomRef()){q(x._oItemNavigation.getItemDomRefs()[x._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(y.getDomRef()){q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}else if(this._shouldFocusB2OnTabNext(E)){q.sap.focus(u.getDomRef("B2"));E.preventDefault();}};h.prototype._shouldFocusB2OnTabNext=function(E){var i=this.getAggregation("header");return(E.target.id==i.getId()+"-B1");};h.prototype._shouldFocusB2OnTabPrevious=function(E){return this._bPoupupMode;};h.prototype.onsaptabprevious=function(E){var u=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabPrevious()){q.sap.focus(u.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==u.getId()+"-B1"){var v=this.getAggregation("month");var F;switch(this._iMode){case 0:F=this._getFocusedDate();for(var i=0;i<v.length;i++){var w=v[i];var x=c.fromLocalJSDate(w.getDate(),this.getPrimaryCalendarType());if(F.isSame(x)){w._oItemNavigation.focusItem(w._oItemNavigation.getFocusedIndex());}else{q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var y=this.getAggregation("monthPicker");y._oItemNavigation.focusItem(y._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var z=this.getAggregation("yearPicker");z._oItemNavigation.focusItem(z._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}else if(E.target.id==u.getId()+"-B2"){q.sap.focus(u.getDomRef("B1"));E.preventDefault();}};h.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var u=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<u.length;i++){var v=u[i];q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var w=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(w.getDomRef()){q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(y.getDomRef()){q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};h.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");q.sap.focus(i.getDomRef("B2"));};h.prototype.onsapfocusleave=function(E){var u,v,w,y;if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){u=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<u.length;i++){v=u[i];q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){w=this.getAggregation("monthPicker");q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){y=this.getAggregation("yearPicker");q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};h.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};h.prototype.onThemeChanged=function(){var u;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){u=this.getAggregation("monthPicker");this._showMonthPicker(true);u._bNoThemeChange=false;u.onThemeChanged(arguments);u._bNoThemeChange=true;this._bLongMonth=u._bLongMonth;this._hideMonthPicker(true);}var v=this.getAggregation("month");for(var i=0;i<v.length;i++){var w=v[i];w._bNoThemeChange=false;w.onThemeChanged(arguments);w._bNoThemeChange=true;}var x;if(v.length>1){x=c.fromLocalJSDate(v[0].getDate(),this.getPrimaryCalendarType());}else{x=this._getFocusedDate();}this._setHeaderText(x);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!this._getSucessorsPickerPopup()){j.call(this);}};h.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};h.prototype._togglePrevNext=function(i,u){var y=this._oMaxDate.getYear();var v=this._oMinDate.getYear();var w=this._oMaxDate.getMonth();var x=this._oMinDate.getMonth();var z=this.getAggregation("header");var A=m.call(this);var B=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&A>1){B=t.call(this,i);B.setMonth(B.getMonth()+A-1);B.setDate(a._daysInMonth(B));}else{B.setDate(a._daysInMonth(B));}var E=B.getYear();var F=B.getMonth();if(E>y||(E==y&&(!u||F>=w))||(this._iMode==1&&this._getSucessorsPickerPopup())){z.setEnabledNext(false);}else{z.setEnabledNext(true);}if(this._iMode==0&&A>1){B.setMonth(B.getMonth()-A+1);B.setDate(1);}else{B.setDate(1);}E=B.getYear();F=B.getMonth();if(E<v||(E==v&&(!u||F<=x))||(this._iMode==1&&this._getSucessorsPickerPopup())){z.setEnabledPrevious(false);}else{z.setEnabledPrevious(true);}};h.prototype._togglePrevNexYearPicker=function(){var y=this.getAggregation("yearPicker");var i=y.getYears();var u=c.fromLocalJSDate(y.getFirstRenderedDate());u.setYear(u.getYear()+Math.floor(i/2));var v=this.getAggregation("header");var w=new c(this._oMaxDate,this.getPrimaryCalendarType());w.setYear(w.getYear()-Math.ceil(i/2));w.setMonth(11);w.setDate(31);var x=new c(this._oMinDate,this.getPrimaryCalendarType());x.setYear(x.getYear()+Math.floor(i/2)+1);x.setMonth(0);x.setDate(1);v.setEnabledNext(u.isSameOrBefore(w));v.setEnabledPrevious(u.isSameOrAfter(x));};h.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var i=m.call(this);var u;var v;var S=false;switch(this._iMode){case 0:if(i>1){u=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());u.setDate(1);this._setFocusedDate(u);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var w=this._getSecondaryCalendarType();if(w){v=new c(F,w);v.setMonth(0);v.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(v.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.previousPage();this._togglePrevNexYearPicker();break;}};h.prototype._handleNext=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var i=m.call(this);var u;var v;switch(this._iMode){case 0:if(i>1){u=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(u);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+i);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){v=new c(F,S);v.setMonth(0);v.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(v.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.nextPage();this._togglePrevNexYearPicker();break;}};h.prototype._getDisplayedMonths=function(u){var v=[];var w=u.getMonth();var x=m.call(this);if(x>1){for(var i=0;i<x;i++){v.push((w+i)%12);}}else{v.push(w);}return v;};h.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var u=F.getMonth();var v=c.fromLocalJSDate(i[i.length-1].getDate(),P);v.setDate(a._daysInMonth(v));v=new c(v,S);var E=v.getMonth();return{start:u,end:E};};h.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;}};h.prototype._setDisabledMonths=function(y,i){var u=0;var v=11;if(y==this._oMinDate.getYear()){u=this._oMinDate.getMonth();}if(y==this._oMaxDate.getYear()){v=this._oMaxDate.getMonth();}if(!i){i=this.getAggregation("monthPicker");}i.setMinMax(u,v);};h.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var u=E.getParameter("restoreOldDate");if(u){if(!q.sap.equal(this._getFocusedDate(),i)){this._renderMonth(false,false,true);}}else{this._focusDate(i,O);}};h.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};h.prototype._renderMonth=function(S,I,N){var u=this._getFocusedDate();var v=this.getAggregation("month");var F=false;var w;var x;var y;var i=0;for(i=0;i<v.length;i++){w=v[i];if(w.checkDateFocusable(u.toLocalJSDate())){F=true;}if(F||v.length==1){if(!S){w.setDate(u.toLocalJSDate());}else{w.displayDate(u.toLocalJSDate());}break;}}if(!F){y=new c(u,this.getPrimaryCalendarType());if(v.length>1){y=t.call(this,y);for(i=0;i<v.length;i++){w=v[i];x=new c(y,this.getPrimaryCalendarType());x.setMonth(y.getMonth()+i);if(!S&&a._isSameMonthAndYear(x,u)){w.setDate(u.toLocalJSDate());}else{w.displayDate(x.toLocalJSDate());}}}this._updateHeader(y);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!N){this.fireStartDateChange();}}};function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}h.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var u=this._getFocusedDate();var v=this.getAggregation("monthPicker");if(v.getDomRef()){v.$().css("display","");}else{var w=sap.ui.getCore().createRenderManager();var $=this.$("content");w.renderControl(v);w.flush($[0],false,true);w.destroy();}this._showOverlay();if(!S){v.setMonth(u.getMonth());this._setDisabledMonths(u.getYear(),v);if(this._iMode==0){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){var y=x[i];q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(u,false);};h.prototype._hideMonthPicker=function(S){this._iMode=0;var u=this.getAggregation("monthPicker");u.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(m.call(this)>1){var v=this.getAggregation("month");for(var i=0;i<v.length;i++){var w=v[i];q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};h.prototype._showYearPicker=function(){if(this._iMode==1){this._hideMonthPicker(true);}var u=this._getFocusedDate();var y=this.getAggregation("yearPicker");if(y.getDomRef()){y.$().css("display","");}else{var v=sap.ui.getCore().createRenderManager();var $=this.$("content");v.renderControl(y);v.flush($[0],false,true);v.destroy();}this._showOverlay();y.setDate(u.toLocalJSDate());var w;if(m.call(this)==1){w=this.getAggregation("month")[0];var x=w.$("days").find(".sapUiCalItem");if(x.length==28){y.$().addClass("sapUiCalYearNoTop");}else{y.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var z=this.getAggregation("month");for(var i=0;i<z.length;i++){w=z[i];q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;};h.prototype._hideYearPicker=function(S){this._iMode=0;var y=this.getAggregation("yearPicker");y.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(m.call(this)>1){var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};function j(){if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var u=this.getAggregation("month");var v;if(u.length>1){v=c.fromLocalJSDate(u[0].getDate(),this.getPrimaryCalendarType());}else{v=this._getFocusedDate();}this._setHeaderText(v);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}else if(m.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}h.prototype._focusDate=function(i,O,N){var F;var u=false;var v=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;u=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;u=true;}else{F=i;}if(this._focusDateExtend){v=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(u||O){this._renderMonth(false,I,N);}if(v){this.fireStartDateChange();}};h.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var u=this.getAggregation("month");if(u){for(var i=0;i<u.length;i++){var v=u[i];v._bDateRangeChanged=true;v._bInvalidateSync=true;v._bNoFocus=true;v.invalidate(O);v._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};h.prototype._setHeaderText=function(i){var u=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var v=this._getLocaleData();var w=[];var x=[];var y=[];var A;var z=false;var F;var B;var T;var E;var P;var G=this.getPrimaryCalendarType();var I=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){w=v.getMonthsStandAlone("wide",G);}else{z=true;w=v.getMonthsStandAlone("abbreviated",G);x=v.getMonthsStandAlone("wide",G);}if(I){y=v.getMonthsStandAlone("abbreviated",I);var J=this._getDisplayedSecondaryMonths(G,I);if(J.start==J.end){T=y[J.start];}else{P=v.getIntervalPattern();T=P.replace(/\{0\}/,y[J.start]).replace(/\{1\}/,y[J.end]);}}u.setAdditionalTextButton1(T);u._setAdditionalTextButton3(T);S.setAdditionalTextButton1(T);var K=this._getDisplayedMonths(i);this._sFirstMonthName=F=w[K[0]];B=w[K[K.length-1]];if(K.length>1&&!this._bShowOneMonth){if(!P){P=v.getIntervalPattern();}T=P.replace(/\{0\}/,F).replace(/\{1\}/,B);A=x.length?P.replace(/\{0\}/,x[K[0]]).replace(/\{1\}/,x[K[K.length-1]]):T;}else{T=F;A=x[K[0]]||T;}u.setTextButton1(T);u.setAriaLabelButton1(A);u._setTextButton3(B);u._setAriaLabelButton3(B);S.setTextButton1(B);S.setAriaLabelButton1(B);var N=new c(i,G);N.setDate(1);E=this._oYearFormat.format(N.toUTCJSDate(),true);this._updateHeadersYearPrimaryText(E);if(I){N=new c(N,I);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(N.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:T,sYear:E,sAriaLabel:A,bShort:z};};function k(i,S){if(!i){return;}var u=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=u.getYear();a._checkYearInValidRange(y);if(a._isOutside(u,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(u);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}function m(){if(d.system.phone){return 1;}else{return this.getMonths();}}h.prototype._handleButton1=function(E){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};h.prototype._handleButton2=function(E){if(this._iMode!=2){this._showYearPicker();}else{this._hideYearPicker();}};function n(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function o(E){if(m.call(this)>1){var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];if(v.getId()!=E.oSource.getId()){v._updateSelection();}}}this._oSelectedMonth=E.oSource;this.fireSelect();}function p(E){if(m.call(this)>1){var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];if(v.getId()!=E.oSource.getId()){v._bindMousemove();}}}}function r(E){if(m.call(this)>1){var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];if(v.getId()!=E.oSource.getId()){v._unbindMousemove();}}}}h.prototype._selectMonth=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),u=i.getMonth();F.setMonth(u);if(u!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};h.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};h.prototype._selectYear=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var y=this.getAggregation("yearPicker");var i=c.fromLocalJSDate(y.getDate(),this.getPrimaryCalendarType());i.setMonth(F.getMonth());i.setDate(F.getDate());F=i;this._focusDate(F,true);this._hideYearPicker();};h.prototype._showOverlay=function(){this.$("contentOver").css("display","");};h.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};h.prototype._setColumns=function(i){this._iColumns=i;return this;};h.prototype._getColumns=function(){return this._iColumns;};h.prototype._updateHeadersButtons=function(){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);i._setVisibleButton3(false);i._setVisibleButton4(false);}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);i._setVisibleButton3(true);i._setVisibleButton4(true);}else{S.setVisible(false);i._setVisibleButton3(false);i._setVisibleButton4(false);}};h.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};h.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){this.addStyleClass("sapUiCalTwoMonthsTwoColumns");}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}};h.prototype._isTwoMonthsInOneColumn=function(){var i=m.call(this);return this._getColumns()===1&&i===2;};h.prototype._isTwoMonthsInTwoColumns=function(){var i=m.call(this);return this._getColumns()===2&&i===2;};h.prototype._updateHeadersYearPrimaryText=function(y){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");i.setTextButton2(y);i.setAriaLabelButton2(y);i._setTextButton4(y);i._setAriaLabelButton4(y);S.setTextButton2(y);S.setAriaLabelButton2(y);};h.prototype._updateHeadersYearAdditionalText=function(y){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");i.setAdditionalTextButton2(y);i._setAdditionalTextButton4(y);S.setAdditionalTextButton2(y);};h.prototype._handleWeekSelection=function(E){var S=parseInt(E.innerText,10),i=q(E.parentElement).attr("data-sap-day"),F=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"}),u=F.parse(i),v=new Date(u.getFullYear(),u.getMonth(),u.getDate()+6),w=new D({startDate:u,endDate:v}),x=this.getSelectedDates();if(x.length&&x[0].getStartDate().getTime()===w.getStartDate().getTime()&&x[0].getEndDate()&&x[0].getEndDate().getTime()===w.getEndDate().getTime()){w=null;}if(this.fireWeekNumberSelect({weekNumber:S,weekDays:w})){this.removeAllSelectedDates();this.addSelectedDate(w);this.focusDate(u);}};function s(E){var w=E.size.width;if(w<=0){return;}var O=this._iSize;if(w<this._iBreakPointTablet){this._iSize=0;}else if(w<this._iBreakPointDesktop){this._iSize=1;}else if(w<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var u=m.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(u<this._getColumns()){this._setColumns(u);}if(this._getColumns()>2&&u>this._getColumns()){var v=this._getColumns();var U=0.0;var x=this._getColumns();while(v>=2){var y=u%v;if(y==0){x=v;break;}else{var N=y/v;if(N>U){U=N;x=v;}}v--;}this._setColumns(x);}var W;var z=this.getAggregation("month");if(this._getColumns()>1){W=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{W="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<z.length;i++){var A=z[i];A.setWidth(W);}}this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}function t(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var u=m.call(this);if(u<=12){var v=i.getMonth();v=v-v%u;if(12%u>0&&v+u>11){v=12-u;}F.setMonth(v);}return F;}return h;});
