/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/Device',"./CalendarDateIntervalRenderer"],function(q,C,a,D,M,Y,b,l,c,d){"use strict";var e=a.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarDateInterval.designtime"}});e.prototype.init=function(){a.prototype.init.apply(this,arguments);this._iDaysMonthHead=35;};e.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};e.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};e.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var h=this.getAggregation("header"),m,y;if(p){if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}h.setVisibleButton2(false);h.detachEvent("pressButton2",this._handleButton2,this);this._setHeaderText(this._getFocusedDate(true));}else{if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}m=this.getAggregation("monthPicker");y=this.getAggregation("yearPicker");m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);y._oMinDate.setYear(this._oMinDate.getYear());y._oMaxDate.setYear(this._oMaxDate.getYear());h.setVisibleButton2(true);h.detachEvent("pressButton2",this._handleButton2,this);h.attachEvent("pressButton2",this._handleButton2,this);}return this;};e.prototype._createMonthPicker=function(){var m=new M(this.getId()+"--MP");m.attachEvent("select",this._selectMonth,this);m._bNoThemeChange=true;m.setColumns(0);m.setMonths(3);m.attachEvent("pageChange",_,this);return m;};e.prototype._createYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",f,this);return y;};e.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new a(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",this._handleCalendarPickerDateSelect,this);o.attachEvent("cancel",function(E){this._closeCalendarPicker();q.sap.focus(this.getAggregation("header").getDomRef("B1"));},this);this.setAggregation("calendarPicker",o);}return o;};e.prototype._handleButton1=function(E){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}}};e.prototype._setHeaderText=function(o){var t=a.prototype._setHeaderText.apply(this,arguments);var T,A,h=this.getAggregation("header");var L=this._getLocaleData();if(this.getPickerPopup()){if(L.oLocale.sLanguage.toLowerCase()==="ja"||L.oLocale.sLanguage.toLowerCase()==="zh"){T=t.sYear+" "+t.sMonth;A=t.sYear+t.sAriaLabel;}else{T=t.sMonth+" "+t.sYear;A=t.sAriaLabel+t.sYear;}h.setTextButton1(T,true);if(t.bShort){h.setAriaLabelButton1(A);}}};e.prototype._showCalendarPicker=function(){var s=this.getStartDate(),o=this._getCalendarPicker(),S=new sap.ui.unified.DateRange(),E=new Date(s.getTime());E.setDate(E.getDate()+this._getDays()-1);S.setStartDate(s);S.setEndDate(E);o.displayDate(this._getFocusedDate().toLocalJSDate());o.removeAllSelectedDates();o.addSelectedDate(S);o.setMinDate(this.getMinDate());o.setMaxDate(this.getMaxDate());this._openPickerPopup(o);this._showOverlay();};e.prototype._handleCalendarPickerDateSelect=function(E){var o=this._getCalendarPicker(),n=new b(o._getFocusedDate());this._setStartDate(n);this._setFocusedDate(n);this._closeCalendarPicker();};e.prototype._closeCalendarPicker=function(s){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!s){this._renderMonth();var m=this.getAggregation("month");for(var i=0;i<m.length;i++){var o=m[i];q(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}};e.prototype._getDaysLarge=function(){return 10;};e.prototype._createMonth=function(i){var m=new D(i);return m;};e.prototype.setStartDate=function(s){C._checkJSDateObject(s);if(q.sap.equal(this.getStartDate(),s)){return this;}var y=s.getFullYear();C._checkYearInValidRange(y);var o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());if(C._isOutside(o,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this);}var m=this.getMinDate();if(m&&s.getTime()<m.getTime()){q.sap.log.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(m.getTime());}var g=this.getMaxDate();if(g&&s.getTime()>g.getTime()){q.sap.log.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(g.getTime());}this.setProperty("startDate",s,true);o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());this._oStartDate=o;var h=this.getAggregation("month")[0];h.setStartDate(s);this._updateHeader(o);var i=this._getFocusedDate(true).toLocalJSDate();if(!h.checkDateFocusable(i)){this._setFocusedDate(o);h.displayDate(s);}return this;};e.prototype.getStartDate=function(){return this.getProperty("startDate");};e.prototype.setDays=function(i){this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var g=Math.ceil(i/3);if(g>12){g=12;}m.setMonths(g);var y=this.getAggregation("yearPicker");var h=Math.floor(i/2);if(h>20){h=20;}y.setYears(h);}var s=this._getStartDate();this._updateHeader(s);if(this.getDomRef()){if(i>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};e.prototype._getDays=function(){var i=this.getDays();if(c.system.phone&&i>8){return 8;}else{return i;}};e.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};e.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};e.prototype._getFocusedDate=function(F){if(!this._oFocusedDate||F){this._oFocusedDate=null;a.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=b.fromLocalJSDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};e.prototype.setMonths=function(m){if(m==1){return this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};e.prototype.setFirstDayOfWeek=function(F){if(F==-1){return this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};e.prototype.focusDate=function(o){var g=this.getAggregation("month")[0];if(!g.checkDateFocusable(o)){this._focusDateExtend(b.fromLocalJSDate(o,this.getPrimaryCalendarType()),true,true);}a.prototype.focusDate.apply(this,arguments);return this;};e.prototype._shouldFocusB2OnTabNext=function(E){var h=this.getAggregation("header");return(!this.getPickerPopup()&&E.target.id==h.getId()+"-B1");};e.prototype._focusOnShiftTab=function(){var h=this.getAggregation("header");if(this.getPickerPopup()){q.sap.focus(h.getDomRef("B1"));}else{q.sap.focus(h.getDomRef("B2"));}};e.prototype.onsapescape=function(E){if(this.getPickerPopup()){this._closeCalendarPicker();this.fireCancel();}else{if(this._iMode===0){this.fireCancel();}this._closedPickers();}};e.prototype._focusDateExtend=function(o,O,n){if(O){var g=this._getFocusedDate();var h=this._getStartDate();var i=C._daysBetween(g,h);var N=new b(o,this.getPrimaryCalendarType());N.setDate(N.getDate()-i);this._setStartDate(N,false,true);if(!n){return true;}}return false;};e.prototype._setMinMaxDateExtend=function(o){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){q.sap.log.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new b(this._oMinDate,this.getPrimaryCalendarType()),true,true);}else{var E=new b(this._oStartDate);E.setDate(E.getDate()+this._getDays()-1);if(E.isAfter(this._oMaxDate)){q.sap.log.warning("end date > maxDate -> start date will be changed",this);var s=new b(this._oMaxDate);s.setDate(s.getDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};e.prototype._togglePrevNext=function(o,g){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return a.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getYear();var i=this._oMinDate.getYear();var m=this._oMaxDate.getMonth();var h=this._oMinDate.getMonth();var j=this._oMinDate.getDate();var k=this._oMaxDate.getDate();var H=this.getAggregation("header");var n=this._getDays();var p;var s;var E;var r;var t;if(this._iMode==1&&!g){var u=this.getAggregation("monthPicker");var v=u.getMonths();var S=u.getStartMonth();var w=S+v-1;p=o.getYear();if(S==0||(p==i&&S<=h)){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}if(w>10||(p==y&&w>=m)){H.setEnabledNext(false);}else{H.setEnabledNext(true);}return;}s=this._getStartDate();E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+n-1);if(C._isOutside(o,s,E)){s=new b(o,this.getPrimaryCalendarType());E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+n-1);}p=s.getYear();r=s.getMonth();t=s.getDate();if(p<i||(p==i&&(!g||r<h||(r==h&&t<=j)))){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}p=E.getYear();r=E.getMonth();t=E.getDate();if(p>y||(p==y&&(!g||r>m||(r==m&&t>=k)))){H.setEnabledNext(false);}else{H.setEnabledNext(true);}};e.prototype._shiftStartFocusDates=function(s,F,i){s.setDate(s.getDate()+i);F.setDate(F.getDate()+i);this._setFocusedDate(F);this._setStartDate(s,true);};e.prototype._handlePrevious=function(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,(i*-1));break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.previousPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()-1);var g=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(g){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.previousPage();this._togglePrevNexYearPicker();}break;}};e.prototype._handleNext=function(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,i);break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.nextPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()+1);var g=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(g){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.nextPage();this._togglePrevNexYearPicker();}break;}};e.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getMonth();var g=this._getDays();m.push(i);if(g>this._getDaysLarge()){var E=new b(o,this.getPrimaryCalendarType());E.setDate(E.getDate()+g-1);var h=E.getMonth();while(i!=h){i=(i+1)%12;m.push(i);}}return m;};e.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=new b(this._getStartDate(),s);var g=S.getMonth();var E=new b(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+i-1);E=new b(E,s);var h=E.getMonth();return{start:g,end:h};};e.prototype._openPickerPopup=function(p){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(function(){this._closeCalendarPicker(true);},this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var h=this.getAggregation("header");var g=sap.ui.core.Popup.Dock;this._oPopup.open(0,g.CenterTop,g.CenterTop,h,null,"flipfit",true);};e.prototype._getMaxDateAlignedToMinDate=function(m,o){var n=new b(m,this.getPrimaryCalendarType());if(n.isBefore(o)){n=new b(o);n.setDate(n.getDate()+this._getDays()-1);}return n;};e.prototype._getStartDateAlignedToMinAndMaxDate=function(m,o,s){var n=new b(s,this.getPrimaryCalendarType());if(n.isBefore(o)){n=new b(o,this.getPrimaryCalendarType());}else if(n.isAfter(m)){n=m;}return n;};e.prototype._calculateStartDate=function(m,o,s){var n=new b(m,this.getPrimaryCalendarType());n.setDate(n.getDate()-this._getDays()+1);n=this._getMaxDateAlignedToMinDate(n,o);s=this._getStartDateAlignedToMinAndMaxDate(n,o,s);return s;};e.prototype._setStartDate=function(s,S,n){s=this._calculateStartDate(this._oMaxDate,this._oMinDate,s);var L=s.toLocalJSDate();this.setProperty("startDate",L,true);this._oStartDate=s;var o=this.getAggregation("month")[0];o.setStartDate(L);this._updateHeader(s);if(S){var g=this._getFocusedDate().toLocalJSDate();if(!o.checkDateFocusable(g)){this._setFocusedDate(s);o.setDate(L);}else{o.setDate(g);}}if(!n){this.fireStartDateChange();}};e.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();}return this._oStartDate;};function _(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(F);}function f(E){this._togglePrevNexYearPicker();}return e;});
