/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./library',"./NavigationBarRenderer",'jquery.sap.dom'],function(q,C,I,l,N){"use strict";var b=C.extend("sap.ui.ux3.NavigationBar",{metadata:{library:"sap.ui.ux3",properties:{toplevelVariant:{type:"boolean",group:"Misc",defaultValue:false},overflowItemsToUpperCase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"item"},overflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.ux3.NavigationItem",multiple:false},associatedItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"associatedItem"}},events:{select:{allowPreventDefault:true,parameters:{itemId:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"}}}}}});b.SCROLL_STEP=250;b.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iLastArrowPos=-100;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this.allowTextSelection(false);this.startScrollX=0;this.startTouchX=0;var t=this;this._oItemNavigation=new I().setCycling(false);this.addDelegate(this._oItemNavigation);this.data("sap-ui-fastnavgroup","true",true);if(q.sap.touchEventMode==="ON"){var T=function(e){e.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("list").scrollLeft;t.startTouchX=e.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var f=function(e){var d=e.touches[0].pageX-t.startTouchX;var L=t.getDomRef("list");var o=L.scrollLeft;var n=t.startScrollX-d;L.scrollLeft=n;t._bTouchNotMoved=false;var c=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(c>0){t._velocity=(n-o)/c;}e.preventDefault();};var a=function(e){if(t._bTouchNotMoved===false){e.preventDefault();var L=t.getDomRef("list");var d=50;var c=Math.abs(t._velocity/10);t._iInertiaIntervalId=window.setInterval(function(){t._velocity=t._velocity*0.80;var g=t._velocity*d;L.scrollLeft=L.scrollLeft+g;if(Math.abs(t._velocity)<c){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},d);}else if(t._bTouchNotMoved===true){t.onclick(e);e.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.ontouchstart=T;this.ontouchend=a;this.ontouchmove=f;}};b.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._checkOverflowIntervalId){q.sap.clearIntervalCall(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null;}};b.prototype.onBeforeRendering=function(){if(this._checkOverflowIntervalId){q.sap.clearIntervalCall(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null;}this._iSoredScrollPosition=this.$("list").scrollLeft();if(!!sap.ui.Device.browser.firefox){this.$().unbind("DOMMouseScroll",this._handleScroll);}else{this.$().unbind("mousewheel",this._handleScroll);}var a=this.getDomRef("arrow");this._iLastArrowPos=a?parseInt(this._bRtl?a.style.right:a.style.left,10):-100;};b.prototype.invalidate=function(s){if(s instanceof sap.ui.ux3.NavigationItem){this._menuInvalid=true;}C.prototype.invalidate.apply(this,arguments);};b.prototype._calculatePositions=function(){var d=this.getDomRef();this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._checkOverflow(d.firstChild,this.getDomRef("ofb"),this.getDomRef("off"));};b.prototype.onThemeChanged=function(){if(this.getDomRef()){this._calculatePositions();}};b.prototype.onAfterRendering=function(){var d=this.getDomRef();var L=d.firstChild;var o=this.getDomRef("ofb");var a=this.getDomRef("off");this._checkOverflowIntervalId=q.sap.intervalCall(350,this,"_checkOverflow",[L,o,a]);if(!!sap.ui.Device.browser.firefox){q(d).bind("DOMMouseScroll",q.proxy(this._handleScroll,this));}else{q(d).bind("mousewheel",q.proxy(this._handleScroll,this));}this._calculatePositions();this._updateItemNavigation();var n=this.$();n.on("scroll",function(){n.children().scrollTop(0);n.scrollTop(0);});if(this._iSoredScrollPosition){this.$("list").scrollLeft(this._iSoredScrollPosition);}};b.prototype._updateItemNavigation=function(){var d=this.getDomRef();if(d){var s=-1;var S=this.getSelectedItem();var i=q(d).children().children("li").children().not(".sapUiUx3NavBarDummyItem");i.each(function(a,e){if(e.id==S){s=a;}});this._oItemNavigation.setRootDomRef(d);this._oItemNavigation.setItemDomRefs(i.toArray());this._oItemNavigation.setSelectedIndex(s);}};b.prototype.onsapspace=function(e){this._handleActivation(e);};b.prototype.onclick=function(e){this._handleActivation(e);};b.prototype.setOverflowItemsToUpperCase=function(v){this._getOverflowMenu().toggleStyleClass("sapUiUx3NavBarUpperCaseText",v);return this.setProperty("overflowItemsToUpperCase",v);};b.prototype._handleActivation=function(e){var t=e.target.id;if(t){var i=this.getId();e.preventDefault();if(t==i+"-ofb"){this._scroll(-b.SCROLL_STEP,500);}else if(t==i+"-off"){this._scroll(b.SCROLL_STEP,500);}else if(t==i+"-oflt"||t==i+"-ofl"){this._showOverflowMenu();}else{var a=sap.ui.getCore().byId(t);if(a&&(t!=this.getSelectedItem())&&(sap.ui.getCore().byId(t)instanceof sap.ui.ux3.NavigationItem)){if(this.fireSelect({item:a,itemId:t})){this.setAssociation("selectedItem",a,true);this._updateSelection(t);}}}}};b.prototype._getOverflowMenu=function(){var m=this.getAggregation("overflowMenu");if(!m||this._menuInvalid){if(m){m.destroyAggregation("items",true);}else{m=new sap.ui.commons.Menu();}var a=this._getCurrentItems();var t=this;var s=this.getSelectedItem();for(var i=0;i<a.length;++i){var n=a[i];var M=new sap.ui.commons.MenuItem(n.getId()+"-overflowItem",{text:n.getText(),visible:n.getVisible(),icon:s==n.getId()?"sap-icon://accept":null,select:(function(n){return function(e){t._handleActivation({target:{id:n.getId()},preventDefault:function(){}});};})(n)});m.addAggregation("items",M,true);}this.setAggregation("overflowMenu",m,true);this._menuInvalid=false;}return m;};b.prototype._getCurrentItems=function(){var a=this.getItems();if(a.length<1){a=this.getAssociatedItems();var c=sap.ui.getCore();for(var i=0;i<a.length;++i){a[i]=c.byId(a[i]);}}return a;};b.prototype._showOverflowMenu=function(){var m=this._getOverflowMenu();var t=this.$("ofl").get(0);m.open(true,t,sap.ui.core.Popup.Dock.EndTop,sap.ui.core.Popup.Dock.CenterCenter,t);};b.prototype._updateSelection=function(i){this._menuInvalid=true;var $=q.sap.byId(i);$.attr("tabindex","0").attr("aria-checked","true");$.parent().addClass("sapUiUx3NavBarItemSel");$.parent().parent().children().each(function(){var a=this.firstChild;if(a&&(a.id!=i)&&(a.className.indexOf("Dummy")==-1)){q(a).attr("tabindex","-1");q(a).parent().removeClass("sapUiUx3NavBarItemSel");q(a).attr("aria-checked","false");}});var s=$.parent().index();if(s>0){s--;}this._oItemNavigation.setSelectedIndex(s);var A=this.$("arrow");var c=A.outerWidth();var t=b._getArrowTargetPos(i,c,this._bRtl);A.stop();var d=this._bRtl?{right:t+"px"}:{left:t+"px"};A.animate(d,500,"linear");var e=this;window.setTimeout(function(){t=b._getArrowTargetPos(i,c,e._bRtl);A.stop();var a=e._bRtl?{right:t+"px"}:{left:t+"px"};A.animate(a,200,"linear",function(){var f=q.sap.domById(i);e._scrollItemIntoView(f);});},300);};b.prototype._scrollItemIntoView=function(i){if(!i){return;}var a=q(i.parentNode);var u=a.parent();var t;var r=sap.ui.getCore().getConfiguration().getRTL();var c=a.index()-1;if(c==0){t=r?(u[0].scrollWidth-u.innerWidth()+20):0;}else if(c==a.siblings().length-2){t=r?0:(u[0].scrollWidth-u.innerWidth()+20);}else{var d=a.position().left;var e=r?u.scrollLeftRTL():u.scrollLeft();if(d<0){t=e+d;}else{var f=u.innerWidth()-(d+a.outerWidth(true));if(f<0){t=e-f;t=Math.min(t,e+d);}}}if(t!==undefined){if(r){t=q.sap.denormalizeScrollLeftRTL(t,u.get(0));}u.stop(true,true).animate({scrollLeft:t});}};b._getArrowTargetPos=function(t,a,r){var i=q.sap.byId(t);if(i.length>0){var w=i.outerWidth();var c=Math.round(i[0].offsetLeft+(w/2)-(a/2));if(!r){return c;}else{return i.parent().parent().innerWidth()-c-a;}}else{return-100;}};b.prototype._handleScroll=function(e){if(e.type=="DOMMouseScroll"){var s=e.originalEvent.detail*40;this._scroll(s,50);}else{var s=-e.originalEvent.wheelDelta;this._scroll(s,50);}e.preventDefault();};b.prototype._scroll=function(d,D){var o=this.$()[0].firstChild;var s=o.scrollLeft;if(!sap.ui.Device.browser.internet_explorer&&this._bRtl){d=-d;}var S=s+d;q(o).stop(true,true).animate({scrollLeft:S},D);};b.prototype._checkOverflow=function(L,o,a){function i(){return sap.ui.Device.os.macintosh&&sap.ui.Device.browser.chrome;}if(L&&this.getDomRef()&&q.sap.act.isActive()){var s=L.scrollLeft;var S=false;var c=false;var r=L.scrollWidth;var d=L.clientWidth;var e=i()?5:0;if(Math.abs(r-d)==1){r=d;}if(!this._bRtl){if(s>e){S=true;}if((r>d)&&(r-(s+d)>e)){c=true;}}else{var $=q(L);if($.scrollLeftRTL()>e){c=true;}if($.scrollRightRTL()>e){S=true;}}if((c!=this._bPreviousScrollForward)||(S!=this._bPreviousScrollBack)){this._bPreviousScrollForward=c;this._bPreviousScrollBack=S;this.$().toggleClass("sapUiUx3NavBarScrollBack",S).toggleClass("sapUiUx3NavBarScrollForward",c);if(!b._bMenuLoaded&&(S||c)){b._bMenuLoaded=true;q.sap.require("sap.ui.commons.Menu");}}var f=sap.ui.getCore().byId(this.getSelectedItem());if(f){var A=this.$("arrow");var g=A.outerWidth();var t=b._getArrowTargetPos(f.getId(),g,this._bRtl)+"px";if(!this._bRtl){if(A[0].style.left!=t){A[0].style.left=t;}}else{if(A[0].style.right!=t){A[0].style.right=t;}}}}};b.prototype.setSelectedItem=function(i){this.setAssociation("selectedItem",i,true);if(this.getDomRef()){var s=(!i||(typeof(i)=="string"))?i:i.getId();this._updateSelection(s);}};b.prototype.addItem=function(i){this._menuInvalid=true;return this.addAggregation("items",i);};b.prototype.destroyItems=function(){this._menuInvalid=true;return this.destroyAggregation("items");};b.prototype.insertItem=function(i,a){this._menuInvalid=true;return this.insertAggregation("items",i,a);};b.prototype.removeItem=function(i){this._menuInvalid=true;return this.removeAggregation("items",i);};b.prototype.removeAllItems=function(){this._menuInvalid=true;return this.removeAllAggregation("items");};b.prototype.addAssociatedItem=function(i){this._menuInvalid=true;return this.addAssociation("associatedItems",i);};b.prototype.removeAssociatedItem=function(i){this._menuInvalid=true;return this.removeAssociation("associatedItems",i);};b.prototype.removeAllAssociatedItems=function(){this._menuInvalid=true;return this.removeAllAssociation("associatedItems");};b.prototype.setAssociatedItems=function(a){var L=this.getDomRef("list");this.removeAllAssociation("associatedItems",true);for(var i=0;i<a.length;i++){this.addAssociation("associatedItems",a[i],true);}if(L){var f=q(L).find(":focus");var c=(f.length>0)?f.attr("id"):null;if(arguments.length>1&&typeof arguments[1]==="boolean"){this._iLastArrowPos=-100;}else{var d=this.getDomRef("arrow");this._iLastArrowPos=parseInt(this._bRtl?d.style.right:d.style.left,10);}L.innerHTML="";var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.NavigationBarRenderer.renderItems(r,this);r.flush(L,true);r.destroy();var n;if(c&&(n=q.sap.domById(c))){q.sap.focus(n);}this._updateSelection(this.getSelectedItem());this._updateItemNavigation();}return this;};b.prototype.isSelectedItemValid=function(){var s=this.getSelectedItem();if(!s){return false;}var a=this.getItems();if(!a||a.length==0){a=this.getAssociatedItems();for(var i=0;i<a.length;i++){if(a[i]==s){return true;}}}else{for(var i=0;i<a.length;i++){if(a[i].getId()==s){return true;}}}return false;};return b;},true);
