/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/Device","sap/ui/base/Metadata","./ObjectPageSubSection","./library"],function(q,D,M,O,l){"use strict";var L=M.createClass("sap.uxap._helpers.LazyLoading",{constructor:function(o){this._oObjectPageLayout=o;this._$html=q("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters();}});L.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;this.LAZY_LOADING_EXTRA_PAGE_SIZE=0.5;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":1,"ScrollToSection":1};}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":1};}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":2};}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":3,"ScrollToSection":3};}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5;};L.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading();};L.prototype.lazyLoadDuringScroll=function(s,t,p){var P,d,f=false;this._iScrollProgress=s-this._iPreviousScrollTop;P=Math.round(Math.abs(this._iScrollProgress)/p*100);if(P>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){f=true;}this._iPreviousScrollTop=s;this._iPreviousScrollTimestamp=t||0;d=(s===0)?0:this.LAZY_LOADING_DELAY;if(f&&this._sLazyLoadingTimer){q.sap.log.debug("ObjectPageLayout :: lazyLoading","delayed by "+d+" ms because of fast scroll");q.sap.clearDelayedCall(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null;}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=q.sap.delayedCall(d,this,this.doLazyLoading);}};L.prototype.doLazyLoading=function(){var h=this._oObjectPageLayout._getHeightRelatedParameters(),s=this._oObjectPageLayout._oSectionInfo,S,i,p,b=this._iPreviousScrollTop>=(h.iHeaderContentHeight),e,E=-1,o={},a={},t,c,d;p=(h.iScreenHeight-(b?h.iAnchorBarHeight:0)-(b?h.iHeaderTitleHeightStickied:0));S=h.iScrollTop;t=Date.now()-this._iPreviousScrollTimestamp;c=(t<(this.LAZY_LOADING_DELAY/2))&&(Math.abs(this._iScrollProgress)>5);if(c){if(this._iScrollProgress>=0){d=Math.round(Math.min(this._iScrollProgress*20,p/2));}else{d=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,p/2));}S+=d;q.sap.log.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+d);}i=S+p;S+=16;q.each(s,q.proxy(function(I,f){if(!f.isSection&&f.sectionReference.getParent()&&f.sectionReference.getParent().getVisible()){if(f.positionTop<=i&&S<f.positionBottom-1){a[I]=I;if(!f.loaded){o[I]=I;}}else if(!f.loaded&&f.positionTop>i&&f.positionTop<i+p*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(E==-1||f.positionTop<E)){E=f.positionTop;e=I;}}},this));if(E!=-1&&q.isEmptyObject(o)){q.sap.log.debug("ObjectPageLayout :: lazyLoading","extra section added : "+e);o[e]=e;}q.each(o,q.proxy(function(f,g){q.sap.log.debug("ObjectPageLayout :: lazyLoading","connecting "+g);sap.ui.getCore().byId(g).connectToModels();s[g].loaded=true;},this));q.each(a,q.proxy(function(f,g){if(!this._oPrevSubSectionsInView[f]){q.sap.log.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+g);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:sap.ui.getCore().byId(g)});}},this));this._oPrevSubSectionsInView=a;if(c){this._sLazyLoadingTimer=q.sap.delayedCall(this.LAZY_LOADING_DELAY,this,this.doLazyLoading);}else{if(E){this._sLazyLoadingTimer=q.sap.delayedCall(5*this.LAZY_LOADING_DELAY,this,this.doLazyLoading);}else{this._sLazyLoadingTimer=null;}}};L.prototype.getSubsectionsToPreload=function(a,i){var s,t;if(i){s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;t=false;}else{s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;t=true;}var S=[];a.some(function(o){if(!t&&i){t=o.getId()==i;}if(t&&o instanceof O){if(o.getVisible()&&o._getInternalVisible()){S.push(o);s--;}}return s<=0;});return S;};L.prototype._isPhone=function(){return l.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};L.prototype._isTablet=function(){return D.system.tablet;};L.prototype._isTabletSize=function(){return l.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};return L;},false);
