/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/uxap/AnchorBar',["jquery.sap.global","sap/m/Button","sap/m/library","sap/m/Popover","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","jquery.sap.keycodes"],function(q,B,m,P,T,I,a,R,S,H,D,C,b,l,A){"use strict";var c=m.SelectType;var d=m.PlacementType;
var e=T.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_popovers:{type:"sap.m.Popover",multiple:true,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
e.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._bRtlScenario=this._bRtl&&!D.browser.msie;this._bHasButtonsBar=D.system.tablet||D.system.desktop;this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=parseInt(q("body").css("font-size"),10);this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3;this._sResizeListenerId=undefined;}this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();this.setDesign("Transparent");};
e.SCROLL_STEP=250;e.SCROLL_DURATION=500;e.DOM_CALC_DELAY=200;
e.prototype.setSelectedButton=function(o){var p=this.getSelectedButton(),f,s=this._oSelect.getItems(),h=s.length>0;if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o){if(o.getId()===p){return this;}var g=o.data("sectionId");this._sSelectedKey=g;if(g&&h){this._oSelect.setSelectedKey(g);}if(this._bHasButtonsBar){f=sap.ui.getCore().byId(p);this._toggleSelectionStyleClass(f,false);this._toggleSelectionStyleClass(o,true);if(g){this.scrollToSection(g,e.SCROLL_DURATION);}this._setAnchorButtonsTabFocusValues(o);}}return this.setAssociation("selectedButton",o,true);};
e.prototype.setShowPopover=function(v,s){if(this.getShowPopover()===v){return this;}var f,n=!q.isEmptyObject(this._oPressHandlers);if(n){var g=this.getContent()||[];f=this.getSelectedButton();g.forEach(this._detachPopoverHandler,this);}this.setProperty("showPopover",v,true);if(n){this.rerender();if(f){this.setSelectedButton(f);}}return this;};
e.prototype.getSelectedSection=function(){var s=this.getSelectedButton();if(s&&(typeof(s)==="string")){s=sap.ui.getCore().byId(s);}if(s&&(s instanceof B)&&s.data("sectionId")){return sap.ui.getCore().byId(s.data("sectionId"));}return null;};
e.prototype.onBeforeRendering=function(){if(T.prototype.onBeforeRendering){T.prototype.onBeforeRendering.call(this);}var f=this.getContent()||[],u=this.getUpperCase(),p={oLastFirstLevelButton:null,oCurrentPopover:null};this._oSelect.removeAllItems();this._oSelect.setUpperCase(u);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",u);f.forEach(function(o){this._createSelectItem(o);if(this._bHasButtonsBar){this._createPopoverSubMenu(o,p);}},this);if(f.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey);}};
e.prototype.addContent=function(o,i){o.addStyleClass("sapUxAPAnchorBarButton");o.removeAllAriaDescribedBy();if(this._bHasButtonsBar&&(o.data("secondLevel")===true||o.data("secondLevel")==="true")){o.attachPress(this._handleDirectScroll,this);}return this.addAggregation("content",o,i);};
e.prototype._createSelectItem=function(o){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true";if(o.getText().trim()!=""&&(!i||o.data("bTitleVisible")===true)){var p=new a({key:o.data("sectionId"),text:o.getText(),customData:[new C({key:"secondLevel",value:o.data("secondLevel")})]});this._oSelect.addItem(p);}};
e.prototype._createPopoverSubMenu=function(o,p){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true",f=null;if(i){if(p.oLastFirstLevelButton&&p.oCurrentPopover){if(!this._oPressHandlers[p.oLastFirstLevelButton.getId()]){f=q.proxy(this._handlePopover,{oCurrentPopover:p.oCurrentPopover,oLastFirstLevelButton:p.oLastFirstLevelButton});p.oLastFirstLevelButton.attachPress(f);this._oPressHandlers[p.oLastFirstLevelButton.getId()]=f;}p.oCurrentPopover.addContent(o);}else if(this.getShowPopover()){q.sap.log.error("sapUxApAnchorBar :: missing parent first level for item "+o.getText());}else{this.removeContent(o);o.destroy();}}else{p.oLastFirstLevelButton=o;if(this.getShowPopover()){p.oCurrentPopover=new P({placement:d.Bottom,showHeader:false,verticalScrolling:true,horizontalScrolling:false,contentWidth:"auto",showArrow:false,afterOpen:this._decorateSubMenuButtons});p.oCurrentPopover.addStyleClass("sapUxAPAnchorBarPopover");this._addKeyboardHandling(p.oCurrentPopover);this.addAggregation('_popovers',p.oCurrentPopover);}else if(!this._oPressHandlers[p.oLastFirstLevelButton.getId()]){f=q.proxy(this._handleDirectScroll,this);p.oLastFirstLevelButton.attachPress(f);this._oPressHandlers[p.oLastFirstLevelButton.getId()]=f;}}};
e.prototype._decorateSubMenuButtons=function(E){var f=E.getSource().getContent();f.forEach(function(o){o.$().attr("aria-controls",o.data("sectionId"));});};
e.prototype._toggleSelectionStyleClass=function(o,f){if(o){o.toggleStyleClass("sapUxAPAnchorBarButtonSelected",f);o.$().attr("aria-checked",f);}};
e.prototype._addKeyboardHandling=function(o){o.onsapdown=function(E){if(E.target.nextSibling){E.target.nextSibling.focus();}};o.onsapright=function(E){o.onsapdown(E);};o.onsapup=function(E){if(E.target.previousSibling){E.target.previousSibling.focus();}};o.onsapleft=function(E){o.onsapup(E);};o.onsaphome=function(E){if(E.target.parentElement.firstChild){E.target.parentElement.firstChild.focus();}};o.onsapend=function(E){if(E.target.parentElement.lastChild){E.target.parentElement.lastChild.focus();}};o.onsappageup=this._handlePageUp.bind(o);o.onsappagedown=this._handlePageDown.bind(o);};
e.prototype._detachPopoverHandler=function(o){if(this._oPressHandlers[o.getId()]){o.detachPress(this._oPressHandlers[o.getId()]);this._oPressHandlers[o.getId()]=null;}};
e.prototype._handlePopover=function(E){var p=this.oCurrentPopover.getContent()||[];if(this.oLastFirstLevelButton.$().is(":visible")){if(p.length==1){p[0].firePress({});}else{this.oCurrentPopover.openBy(this.oLastFirstLevelButton);}}};
e.prototype._handleDirectScroll=function(E){if(E.getSource().getParent()instanceof P){E.getSource().getParent().close();}this._requestScrollToSection(E.getSource().data("sectionId"));};
e.prototype._requestScrollToSection=function(r){var o=sap.ui.getCore().byId(r),f=o.getParent();if(this.getParent()instanceof l.ObjectPageLayout){var n=r;if(o instanceof l.ObjectPageSubSection&&f instanceof l.ObjectPageSection){n=f.getId();}this.getParent().setDirectScrollingToSection(n);this.getParent().scrollToSection(o.getId(),null,0,true);}if(o instanceof l.ObjectPageSubSection&&f instanceof l.ObjectPageSection){f.setAssociation("selectedSubSection",o,true);}};
e.prototype._onSelectChange=function(E){var s=E.getParameter("selectedItem"),o;o=sap.ui.getCore().byId(s.getKey());if(o){this._requestScrollToSection(o.getId());}else{q.sap.log.error("AnchorBar :: cannot find corresponding section",s.getKey());}};
e.prototype._getHierarchicalSelect=function(){if(!this.getAggregation('_select')){this.setAggregation('_select',new b({width:"100%",icon:"sap-icon://slim-arrow-down",change:q.proxy(this._onSelectChange,this)}));}return this.getAggregation('_select');};
e.prototype._createScrollArrow=function(L){var s,i,f,g,o,t=this,h=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),j=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(L){s=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";f="anchorBarArrowLeft";g=this._bRtl?j:h;}else{s=this.getId()+"-arrowScrollRight";i="slim-arrow-right";f="anchorBarArrowRight";g=this._bRtl?h:j;}o=new B(s,{icon:I.getIconURI(i),type:"Transparent",press:function(E){E.preventDefault();t._handleScrollButtonTap(L);},tooltip:g});o.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().getConfiguration().getTheme()!="sap_hcb"){this.$().attr("tabindex",-1);}},onThemeChanged:function(){if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",-1);}}},o);return new H({content:[o]}).addStyleClass("anchorBarArrow").addStyleClass(f);};
e.prototype._getScrollArrowLeft=function(){var s=this.getAggregation("_scrollArrowLeft");if(s){return s;}else{s=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",s);return s;}};
e.prototype._getScrollArrowRight=function(){var s=this.getAggregation("_scrollArrowRight");if(s){return s;}else{s=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",s);return s;}};
e.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(c.IconOnly);this._computeBarSectionsInfo();}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(c.Default);}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon);};
e.prototype._adjustSize=function(){var n=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())?A._AnchorBarHierarchicalSelectMode.Text:A._AnchorBarHierarchicalSelectMode.Icon;if(n!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=n;this._applyHierarchicalSelectMode();}if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return;}var $=this.$(),f=$.find(".sapUxAPAnchorBarScrollContainer"),N,g,i;i=f.width();if(this._bRtlScenario){if(D.browser.firefox){g=Math.abs(f.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);N=Math.abs(f.scrollLeft())>=this._iTolerance;}else{g=Math.abs(f.scrollLeft())>=this._iTolerance;N=Math.abs(f.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);}}else{g=f.scrollLeft()+i<(this._iMaxPosition-this._iTolerance);N=f.scrollLeft()>=this._iTolerance;}q.sap.log.debug("AnchorBar :: scrolled at "+f.scrollLeft(),"scrollBegin ["+(N?"true":"false")+"] scrollEnd ["+(g?"true":"false")+"]");$.toggleClass("sapUxAPAnchorBarScrollLeft",N);$.toggleClass("sapUxAPAnchorBarScrollRight",g);}};
e.prototype._handleScrollButtonTap=function(s){var i=((!this._bRtlScenario&&s)||(this._bRtlScenario&&!s))?-1:1;this._oScroller.scrollTo(this._iMaxPosition*i,0,e.SCROLL_DURATION*3);};
e.prototype.scrollToSection=function(i,f){if(this._bHasButtonsBar){var f=f||e.SCROLL_DURATION,s;if(!l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())&&this._oSectionInfo[i]){if(this._bRtlScenario&&D.browser.firefox){s=this._oSectionInfo[i].scrollLeft+this._iOffset;}else{s=this._oSectionInfo[i].scrollLeft-this._iOffset;if(s<0){s=0;}}q.sap.log.debug("AnchorBar :: scrolling to section "+i+" of "+s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){q.sap.clearDelayedCall(this._iCurrentScrollTimeout);q.sap.byId(this.getId()+"-scroll").parent().stop(true,false);}this._iCurrentScrollTimeout=q.sap.delayedCall(f,this,function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;});this._oScroller.scrollTo(s,0,f);}}else{q.sap.log.debug("AnchorBar :: no need to scroll to "+i);}}};
e.prototype.getScrollDelegate=function(){return this._oScroller;};
e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
e.prototype.onsapdown=function(E){E.preventDefault();if(E.target.nextSibling){E.target.nextSibling.focus();}};
e.prototype.onsapright=function(E){var M=this._bRtl?"onsapup":"onsapdown";this[M](E);};
e.prototype.onsapup=function(E){E.preventDefault();if(E.target.previousSibling){E.target.previousSibling.focus();}};
e.prototype.onsapleft=function(E){var M=this._bRtl?"onsapdown":"onsapup";this[M](E);};
e.prototype.onsaphome=function(E){E.preventDefault();if(E.target.parentElement.firstChild){E.target.parentElement.firstChild.focus();}};
e.prototype.onsapend=function(E){E.preventDefault();if(E.target.parentElement.lastChild){E.target.parentElement.lastChild.focus();}};
e.prototype.onsappageup=function(E){this._handlePageUp(E);};
e.prototype.onsappagedown=function(E){this._handlePageDown(E);};
e.prototype._handlePageUp=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(o.getId()===E.target.id){n=i-(e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};
e.prototype._handlePageDown=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(o.getId()===E.target.id){n=i+e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};
e.prototype._setAnchorButtonsTabFocusValues=function(s){var f=this.getContent()||[],$,F='0',n='-1',t="tabIndex";f.forEach(function(o){$=o.$();if(o.sId===s.sId){$.attr(t,F);}else{$.attr(t,n);}});};
e.prototype.onsapskipforward=function(E){this._handleGroupNavigation(E,false);};
e.prototype._handleGroupNavigation=function(E,s){var o=q.Event("keydown"),f={},O=this.getParent(),u=O.getUseIconTabBar(),g=O.getSelectedSection(),h=O._getVisibleSections(),i=[this.getDomRef()],j=[];if(u){j=sap.ui.getCore().byId(g).getSubSections().map(function(k){return k.$().attr("tabindex",-1)[0];});i=i.concat(j);}else{h.forEach(function(k){j=k.getSubSections().map(function(n){return n.$().attr("tabindex",-1)[0];});i=i.concat(j);});}f.scope=i;E.preventDefault();this.$().focus();o.target=E.target;o.keyCode=q.sap.KeyCodes.F6;o.shiftKey=s;q.sap.handleF6GroupNavigation(o,f);};
e.prototype.onAfterRendering=function(){var s;if(T.prototype.onAfterRendering){T.prototype.onAfterRendering.call(this);}s=sap.ui.getCore().byId(this.getSelectedButton());this._iMaxPosition=-1;this._sResizeListenerId=R.register(this,q.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").scroll(q.proxy(this._onScroll,this));if(s){this.setSelectedButton(s);this._setAnchorButtonsTabFocusValues(s);}if(this._bHasButtonsBar){q.sap.delayedCall(e.DOM_CALC_DELAY,this,function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo();}this._adjustSize();});}};
e.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=q.sap.delayedCall(e.SCROLL_DURATION,this,function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize();});}};
e.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var f=this.getContent()||[];f.forEach(this._computeNextSectionInfo,this);if(this._bRtlScenario&&(D.browser.webkit||D.browser.firefox)){f.forEach(this._adjustNextSectionInfo,this);this._oScroller.scrollTo(this._iMaxPosition,0,0);}};
e.prototype._computeNextSectionInfo=function(o){if(o.data("bHasSubMenu")){o.$().attr("aria-haspopup","true");}o.$().attr("aria-controls",o.data("sectionId")).attr("aria-checked",false);var w=o.$().outerWidth(true);this._oSectionInfo[o.data("sectionId")]={scrollLeft:this._iMaxPosition,width:w};this._iMaxPosition+=w;};
e.prototype._adjustNextSectionInfo=function(o){var s=this._oSectionInfo[o.data("sectionId")];if(D.browser.firefox){s.scrollLeft=-s.scrollLeft;}else{s.scrollLeft=this._iMaxPosition-s.scrollLeft-s.width;}};
e.prototype._destroyPopoverContent=function(){var p=this.getAggregation("_popovers");if(Array.isArray(p)){p.forEach(function(f){f.destroyContent();});}};
e.prototype._resetControl=function(){this._destroyPopoverContent();this.getContent().forEach(this._detachPopoverHandler,this);this.destroyAggregation('content',true);return this;};
e.prototype.enhanceAccessibilityState=function(E,f){var o=this.getContent(),i=o.indexOf(E);if(i!==-1){f.role="menuitemradio";f.type="button";f.setsize=o.length;f.posinset=i+1;}};
e.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null;}};
return e;});
sap.ui.predefine('sap/uxap/AnchorBarRenderer',["sap/m/ToolbarRenderer","sap/ui/core/Renderer","sap/m/BarInPageEnabler","./library"],function(T,R,B,l){"use strict";var A=R.extend(T);var _=A._AnchorBarHierarchicalSelectMode={Icon:"icon",Text:"text"};
A.renderBarContent=function(r,t){if(t._bHasButtonsBar){r.renderControl(t._getScrollArrowLeft());r.write("<div");r.writeAttributeEscaped("id",t.getId()+"-scrollContainer");r.writeAttributeEscaped("aria-label",l.i18nModel.getResourceBundle().getText("ANCHOR_BAR_LABEL"));r.addClass("sapUxAPAnchorBarScrollContainer");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",t.getId()+"-scroll");r.writeAttributeEscaped("role","menu");r.write(">");A.renderBarItems(r,t);r.write("</div>");r.write("</div>");r.renderControl(t._getScrollArrowRight());}B.addChildClassTo(t._oSelect,t);r.renderControl(t._oSelect);};
A.renderBarItems=function(r,t){var s=t.getSelectedButton();t.getContent().forEach(function(c){B.addChildClassTo(c,t);if(c.getId()===s){c.addStyleClass("sapUxAPAnchorBarButtonSelected");}r.renderControl(c);});};
A.decorateRootElement=function(r,t){T.decorateRootElement.apply(this,arguments);if(t._sHierarchicalSelectMode===_.Icon){r.addClass("sapUxAPAnchorBarOverflow");}};
return A;},true);
sap.ui.predefine('sap/uxap/BlockBase',["jquery.sap.global","sap/ui/core/Control","sap/ui/core/CustomData","./BlockBaseMetadata","sap/ui/model/Context","sap/ui/Device","sap/ui/layout/form/ResponsiveGridLayout","./library","sap/ui/core/Component","sap/ui/layout/library"],function(q,C,a,B,b,D,R,l,c,d){"use strict";var S=d.form.SimpleFormLayout;var e=l.BlockBaseFormAdjustment;
var f=C.extend("sap.uxap.BlockBase",{
metadata:{designtime:"sap/uxap/designtime/BlockBase.designtime",library:"sap.uxap",properties:{"mode":{type:"string",group:"Appearance"},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"columnLayout":{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},"formAdjustment":{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:e.BlockColumns},"showSubSectionMore":{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{"mappings":{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},"_views":{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{"selectedView":{type:"sap.ui.core.Control",multiple:false}},views:{}},
renderer:"sap.uxap.BlockBaseRenderer"
},B);
f.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"});}this._oMappingApplied={};this._bLazyLoading=false;this._bConnected=false;this._oUpdatedModels={};this._oParentObjectPageSubSection=null;};
f.prototype.onBeforeRendering=function(){var p;this._applyMapping();if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML");}else{q.sap.log.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.");}}this._applyFormAdjustment();p=this._getObjectPageLayout();this._bLazyLoading=p&&(p.getEnableLazyLoading()||p.getUseIconTabBar());};
f.prototype.onAfterRendering=function(){var p=this._getObjectPageLayout();if(p){p._requestAdjustLayout();}};
f.prototype.setParent=function(p,A,s){C.prototype.setParent.call(this,p,A,s);if(p instanceof l.ObjectPageSubSection){this._bLazyLoading=true;this._oParentObjectPageSubSection=p;}};
f.prototype.setModel=function(m,n){this._applyMapping(n);return C.prototype.setModel.call(this,m,n);};
f.prototype._applyMapping=function(){if(this._shouldLazyLoad()){q.sap.log.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected");}else{this.getMappings().forEach(function(m,i){var M,o,I=m.getInternalModelName(),E=m.getExternalPath(),s=m.getExternalModelName(),p;if(E){if(I==""||E==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty");}M=this.getModel(s);if(!M){return;}p=M.resolve(E,this.getBindingContext(s));o=this.getBindingContext(I);if(!this._isMappingApplied(I)||(this.getModel(I)!==this.getModel(s))||(o&&(o.getPath()!==p))){q.sap.log.info("BlockBase :: mapping external model "+s+" to "+I);this._oMappingApplied[I]=true;C.prototype.setModel.call(this,M,I);this.setBindingContext(new b(M,p),I);}}},this);}};
f.prototype._isMappingApplied=function(i){return this.getModel(i)&&this._oMappingApplied[i];};
f.prototype.propagateProperties=function(n){if(this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(n)){this._oUpdatedModels[n]=true;}else{this._applyMapping(n);}return C.prototype.propagateProperties.call(this,n);};
f.prototype.getSupportedModes=function(){var s=q.extend({},this.getMetadata().getViews());for(var k in s){s[k]=k;}return s;};
f.prototype.setMode=function(m){m=this._validateMode(m);if(this.getMode()!==m){this.setProperty("mode",m,false);if(!this._shouldLazyLoad()){this._initView(m);}}return this;};
f.prototype.setColumnLayout=function(L){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate();}this.setProperty("columnLayout",L);};
f.prototype.clone=function(){var A=-1,s=this.getAssociation("selectedView"),v=this.getAggregation("_views")||[];if(s){v.forEach(function(V,i){if(V.getId()===s){A=i;}return A<0;});}var n=C.prototype.clone.call(this);if(A>=0){n.setAssociation("selectedView",n.getAggregation("_views")[A]);}return n;};
f.prototype._validateMode=function(m){this.validateProperty("mode",m);if(!this.getMetadata().getView(m)){var s=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){q.sap.log.warning("BlockBase :: no view defined for block "+s+" for mode "+m+", loading defaultXML instead");m="defaultXML";}else{throw new Error("BlockBase :: no view defined for block "+s+" for mode "+m);}}return m;};
f.prototype._getSelectedViewContent=function(){var v=null,s,V;s=this.getAssociation("selectedView");V=this.getAggregation("_views");if(V){for(var i=0;!v&&i<V.length;i++){if(V[i].getId()===s){v=V[i];}}}return v;};
f.prototype.createView=function(p,m){var o,g;g=function(){return sap.ui.view(this.getId()+"-"+m,p);}.bind(this);o=c.getOwnerComponentFor(this);if(o){return o.runAsOwner(g);}else{return g();}};
f.prototype._initView=function(m){var v,V=this.getAggregation("_views")||[],p=this.getMetadata().getView(m);V.forEach(function(o,i){if(o.data("layoutMode")===m){v=o;}});if(!v){v=this._initNewView(m);}this.setAssociation("selectedView",v,true);if(v.getController()&&v.getController().onParentBlockModeChange){v.getController().onParentBlockModeChange(m);}else{q.sap.log.info("BlockBase ::: could not notify "+p.viewName+" of loading in mode "+m+": missing controller onParentBlockModeChange method");}return v;};
f.prototype._initNewView=function(m){var v=this._getSelectedViewContent(),p=this.getMetadata().getView(m);if(!v||p.viewName!=v.getViewName()){v=this.createView(p,m);if(v){if(v.getController()){v.getController().oParentBlock=this;}v.addCustomData(new a({"key":"layoutMode","value":m}));this.addAggregation("_views",v,true);}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+m);}}return v;};
f.FORM_ADUSTMENT_OFFSET=32;f._FORM_ADJUSTMENT_CONST={breakpoints:{XL:D.media._predefinedRangeSets.StdExt.points[2]-f.FORM_ADUSTMENT_OFFSET,L:D.media._predefinedRangeSets.StdExt.points[1]-f.FORM_ADUSTMENT_OFFSET,M:D.media._predefinedRangeSets.StdExt.points[0]-f.FORM_ADUSTMENT_OFFSET},labelSpan:{XL:12,L:12,M:12,S:12},emptySpan:{XL:0,L:0,M:0,S:0},columns:{XL:1,L:1,M:1}};f._PARENT_GRID_SIZE=12;
f.prototype._computeFormAdjustmentFields=function(v,L,F,p){if(v&&L&&F&&p){var o=this._computeFormColumns(L,F,p),g=this._computeFormBreakpoints(L,F);return q.extend({},f._FORM_ADJUSTMENT_CONST,{columns:o},{breakpoints:g});}};
f.prototype._computeFormColumns=function(L,F,p){var o=q.extend({},f._FORM_ADJUSTMENT_CONST.columns);if(F===e.BlockColumns){var i=f._PARENT_GRID_SIZE/p.XL,g=f._PARENT_GRID_SIZE/p.L,h=f._PARENT_GRID_SIZE/p.M;o.XL=L.getSpanXL()/i;o.L=L.getSpanL()/g;o.M=L.getSpanM()/h;}return o;};
f.prototype._computeFormBreakpoints=function(L,F){var o=q.extend({},f._FORM_ADJUSTMENT_CONST.breakpoints);if(F===e.BlockColumns){o.XL=Math.round(o.XL*L.getSpanXL()/f._PARENT_GRID_SIZE);o.L=Math.round(o.L*L.getSpanL()/f._PARENT_GRID_SIZE);o.M=Math.round(o.M*L.getSpanM()/f._PARENT_GRID_SIZE);}return o;};
f.prototype._applyFormAdjustment=function(){var L=this.getLayoutData(),F=this.getFormAdjustment(),v=this._getSelectedViewContent(),p=this._oParentObjectPageSubSection,o;if(F&&(F!==e.None)&&v&&L&&p){var P=p._oLayoutConfig;v.getContent().forEach(function(i){if(i.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){i.setLayout(S.ResponsiveGridLayout);if(!o){o=this._computeFormAdjustmentFields(v,L,F,P);}this._applyFormAdjustmentFields(o,i);i.setWidth("100%");}else if(i.getMetadata().getName()==="sap.ui.layout.form.Form"){var g=i.getLayout(),r;if(g&&g.getMetadata().getName()==="sap.ui.layout.form.ResponsiveGridLayout"){r=g;}else{r=new R();i.setLayout(r);}if(!o){o=this._computeFormAdjustmentFields(v,L,F,P);}this._applyFormAdjustmentFields(o,r);i.setWidth("100%");}},this);}};
f.prototype._applyFormAdjustmentFields=function(F,o){o.setColumnsXL(F.columns.XL);o.setColumnsL(F.columns.L);o.setColumnsM(F.columns.M);o.setLabelSpanXL(F.labelSpan.XL);o.setLabelSpanL(F.labelSpan.L);o.setLabelSpanM(F.labelSpan.M);o.setLabelSpanS(F.labelSpan.S);o.setEmptySpanXL(F.emptySpan.XL);o.setEmptySpanL(F.emptySpan.L);o.setEmptySpanM(F.emptySpan.M);o.setEmptySpanS(F.emptySpan.S);o.setBreakpointXL(F.breakpoints.XL);o.setBreakpointL(F.breakpoints.L);o.setBreakpointM(F.breakpoints.M);};
f.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
f.prototype.setVisible=function(v,s){var p=this._getObjectPageLayout();this.setProperty("visible",v,s);p&&p._requestAdjustLayoutAndUxRules();return this;};
f.prototype.setShowSubSectionMore=function(v,i){if(v!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",v,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility();}}return this;};
f.prototype.connectToModels=function(){if(!this._bConnected){q.sap.log.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._bLazyLoading){var m=this.getMode();m&&this._initView(m);}this.invalidate();}};
f.prototype._allowPropagationToLoadedViews=function(A){if(!this._bConnected){return;}this.mSkipPropagation._views=!A;};
f.prototype.updateBindingContext=function(s,g,m,u){if(!this._shouldLazyLoad()){return C.prototype.updateBindingContext.call(this,s,g,m,u);}else{q.sap.log.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
f.prototype.updateBindings=function(u,m){if(!this._shouldLazyLoad()){return C.prototype.updateBindings.call(this,u,m);}else{q.sap.log.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
f.prototype._shouldLazyLoad=function(){return!!this._oParentObjectPageSubSection&&this._bLazyLoading&&!this._bConnected;};
return f;});
sap.ui.predefine('sap/uxap/BlockBaseMetadata',["jquery.sap.global","sap/ui/core/ElementMetadata"],function(q,E){"use strict";var B=function(c,C){E.apply(this,arguments);this._mViews=C.metadata.views||{};};B.prototype=q.sap.newObject(E.prototype);
B.prototype.applySettings=function(c){var r=c.hasOwnProperty("renderer")?(c.renderer||""):undefined;E.prototype.applySettings.call(this,c);if(r==null){this._sRendererName=null;}};
B.prototype.getRendererName=function(){if(!this._sBlockRenderer){this._sBlockRenderer=this._resolveRendererName();q.sap.log.debug("BlockBaseMetadata :: "+this.getName()+" is renderer with "+this._sBlockRenderer);}return this._sBlockRenderer;};
B.prototype._resolveRendererName=function(){var c=E.prototype.getRendererName.call(this);if(c==null){var p=this.getParent();if(p){c=B.prototype._resolveRendererName.apply(p);}else{throw new Error("BlockBaseMetadata :: no renderer found for "+this.getName());}}return c;};
B.prototype.getView=function(v){return this._mViews[v];};
B.prototype.getViews=function(){return this._mViews;};
B.prototype.setView=function(v,V){this._mViews[v]=V;return this;};
B.prototype.hasViews=function(){return!q.isEmptyObject(this._mViews);};
return B;},true);
sap.ui.predefine('sap/uxap/BlockBaseRenderer',function(){"use strict";var B={};
B.render=function(r,c){if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);if(c._getSelectedViewContent()){r.addClass('sapUxAPBlockBase');r.addClass("sapUxAPBlockBase"+c.getMode());}else{var C=c.getMetadata().getName().split(".").pop();r.addClass('sapUxAPBlockBaseDefaultSize');r.addClass('sapUxAPBlockBaseDefaultSize'+C+c.getMode());}r.writeClasses();r.write(">");if(c._getSelectedViewContent()){r.renderControl(c._getSelectedViewContent());}r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/uxap/BreadCrumbs',["sap/m/Link","sap/m/Select","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/Device","./library","sap/ui/core/InvisibleText","./BreadCrumbsRenderer"],function(L,S,C,R,I,a,b,D,l,c,B){"use strict";
var d=C.extend("sap.uxap.BreadCrumbs",{metadata:{library:"sap.uxap",properties:{showCurrentLocation:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"links",aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},currentLocation:{type:"sap.m.Text",multiple:false},_tubeIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowSelect:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}}});
d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
d.prototype.init=function(){this._iREMSize=parseInt(jQuery("body").css("font-size"),10);this._iContainerMaxHeight=this._iREMSize*2;};
d.prototype.onBeforeRendering=function(){this._bOnPhone=D.system.phone;this._resetControl();};
d.prototype.onAfterRendering=function(){this._handleInitialModeSelection();};
d.prototype._handleInitialModeSelection=function(){if(this._bOnPhone){this._setSelectVisible(true);return this;}this._configureKeyboardHandling();if(!this._iContainerHeight){this._iContainerHeight=this.$().outerHeight();}if(this._iContainerHeight>this._iContainerMaxHeight){this._toggleOverflowMode(true);return this;}this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._toggleOverflowMode=function(u){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}this._setSelectVisible(u);this._setBreadcrumbsVisible(!u);this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._getTubeIcon=function(){if(!this.getAggregation("_tubeIcon")){this.setAggregation("_tubeIcon",new b({"src":"sap-icon://slim-arrow-right","color":"#bfbfbf","size":"1rem","useIconTooltip":false}).addStyleClass("sapUxAPTubeIcon"));}return this.getAggregation("_tubeIcon");};
d.prototype._getOverflowSelect=function(){var o,s;if(!this.getAggregation("_overflowSelect")){s=this.getLinks().reverse()||[];s.unshift(this.getCurrentLocation());o=new S({items:s.map(this._createSelectItem),autoAdjustWidth:true});o.attachChange(this._overflowSelectChangeHandler);this.setAggregation("_overflowSelect",o);}return this.getAggregation("_overflowSelect");};
d.prototype._createSelectItem=function(i){return new a({key:i.getId(),text:i.getText()});};
d.prototype._overflowSelectChangeHandler=function(e){var s=e.getParameter("selectedItem").getKey(),o=sap.ui.getCore().byId(s),f,g;if(o instanceof L){f=o.getHref();o.firePress();if(f){g=o.getTarget();if(g){window.open(f,g);}else{window.location.href=f;}}}return this;};
d.prototype._handleScreenResize=function(e){var s=this._shouldOverflow(),u=this._getUsingOverflowSelect();if(s&&!u){this._toggleOverflowMode(true);}else if(!s&&u){this._toggleOverflowMode(false);}return this;};
d.prototype._shouldOverflow=function(){var $=this._getBreadcrumbsAsJQueryObject(),s,u=this._getUsingOverflowSelect();if(u){this._setBreadcrumbsVisible(true);}$.addClass("sapUxAPInvisible");s=$.outerHeight()>this._iContainerMaxHeight;$.removeClass("sapUxAPInvisible");if(u){this._setBreadcrumbsVisible(false);}return s;};
d.prototype._getBreadcrumbsAsJQueryObject=function(){if(!this._$breadcrumbs){this._$breadcurmbs=this.$("breadcrumbs");}return this._$breadcurmbs;};
d.prototype._getOverflowSelectAsJQueryObject=function(){if(!this._$select){this._$select=this.$("select");}return this._$select;};
d.prototype._setBreadcrumbsVisible=function(v){var $=this.$(),e=this._getBreadcrumbsAsJQueryObject(),f="sapUxAPFullWidth",s="sapUiHidden";if(v){e.removeClass(s);$.removeClass(f);}else{e.addClass(s);$.addClass(f);}return $;};
d.prototype._setSelectVisible=function(v){var $=this._getOverflowSelectAsJQueryObject(),s="sapUiHidden";if(v){$.removeClass(s);}else{$.addClass(s);}return this;};
d.prototype._resetControl=function(){this._iContainerHeight=null;this._$select=null;this._$breadcrumbs=null;this.setAggregation("_overflowSelect",null,true);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}return this;};
d.prototype._getAriaLabelledBy=function(){if(!this._oAriaLabelledBy){d.prototype._oAriaLabelledBy=new c({text:l.i18nModel.getResourceBundle().getText("BREADCRUMB_TRAIL_LABEL")}).toStatic();}return this._oAriaLabelledBy;};
d.prototype._getItemNavigation=function(){if(!this._ItemNavigation){this._ItemNavigation=new I();}return this._ItemNavigation;};
d.prototype._getItemsToNavigate=function(){var i=this.getLinks(),o=this.getCurrentLocation(),s=this.getShowCurrentLocation();if(s&&o){i.push(o);}return i;};
d.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),h=this._getBreadcrumbsAsJQueryObject()[0],s=-1,e=this._getItemsToNavigate(),n=[];e.forEach(function(o){o.$().attr("tabIndex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setCycling(false);i.setRootDomRef(h);i.setItemDomRefs(n);i.setSelectedIndex(s);this._getBreadcrumbsAsJQueryObject().attr("tabindex","-1");e[0].$().attr("tabindex","0");return this;};
d.prototype.onsappageup=function(e){this._handlePageKeys(e,false);};
d.prototype.onsappagedown=function(e){this._handlePageKeys(e,true);};
d.prototype._handlePageKeys=function(e,m){var n,f=this._getItemsToNavigate(),E=0,i=m?f.length-1:0;e.preventDefault();f.some(function(o,g){if(o.getId()===e.target.id){E=g;return true;}});if(m){n=E+d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}else{n=E-d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}if(n&&f[n]){f[n].focus();}else if(f[i]){f[i].focus();}};
d.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden");};
d.prototype.exit=function(){if(this._ItemNavigation){this.removeDelegate(this._ItemNavigation);this._ItemNavigation.destroy();this._ItemNavigation=null;}this._resetControl();};
return d;});
sap.ui.predefine('sap/uxap/BreadCrumbsRenderer',function(){"use strict";var B={};
B.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUxAPBreadCrumbs");r.writeClasses();r.writeAttribute("role","navigation");r.writeAttributeEscaped("aria-labelledby",c._getAriaLabelledBy().getId());r.write(">");this._renderOverflowSelect(r,c);if(!c._bOnPhone){this._renderBreadcrumbTrail(r,c);}r.write("</div>");};
B._renderBreadcrumbTrail=function(r,c){var l=c.getLinks(),C=c.getCurrentLocation(),t=c._getTubeIcon(),s=c.getShowCurrentLocation();r.write("<ul id='"+c.getId()+"-breadcrumbs'");r.write(">");l.forEach(function(L){r.write("<li>");r.renderControl(L);r.renderControl(t);r.write("</li>");});if(s){r.write("<li>");r.renderControl(C);r.write("</li>");}r.write("</ul>");};
B._renderOverflowSelect=function(r,c){var t=c._getTubeIcon();r.write("<div id='"+c.getId()+"-select'");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.write('<span class="sapUxAPBreadCrumbsDots">...</span>');r.renderControl(t);r.renderControl(c._getOverflowSelect());r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/uxap/HierarchicalSelect',["jquery.sap.global","sap/m/Select","sap/ui/Device","./library","./HierarchicalSelectRenderer"],function(q,S,D,l,H){"use strict";
var a=S.extend("sap.uxap.HierarchicalSelect",{metadata:{library:"sap.uxap",properties:{upperCase:{type:"boolean",group:"Appearance",defaultValue:false}}}});
a.POPOVER_MIN_WIDTH_REM=11;
a.prototype.onAfterRendering=function(){S.prototype.onAfterRendering.apply(this,arguments);};
a.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var i=this.getItems()||[];i.forEach(function(I){var c=(I.data("secondLevel")===true)?"sapUxAPHierarchicalSelectSecondLevel":"sapUxAPHierarchicalSelectFirstLevel";I.$().addClass(c);},this);};
a.prototype.setUpperCase=function(v,s){this.setProperty("upperCase",v,s);this.toggleStyleClass("sapUxAPHierarchicalSelectUpperCase",v);var p=this.getAggregation("picker");if(p){p.toggleStyleClass("sapMSltPickerFirstLevelUpperCase",v);if(!s){p.invalidate();}}return this;};
a.prototype.onsapenter=S.prototype.onsapspace;["onsapup","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(n){a.prototype[n]=function(e){S.prototype[n].call(this,e);e.stopPropagation();};});
a.prototype._createDialog=function(){var d=S.prototype._createDialog.call(this),c=d.getCustomHeader();if(c){c.addStyleClass("sapUxAPHierarchicalSelect");}return d;};
a.prototype._decoratePopover=function(p){S.prototype._decoratePopover.call(this,p);p._adaptPositionParams=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["end bottom","end center","end top","begin center"];this._atPositions=["end top","end center","end bottom","begin center"];};if(D.system.tablet||D.system.desktop){var r=q.position.scrollbarWidth();if(r>0){p.setOffsetX(r);}}};
a.prototype._onAfterRenderingPopover=function(){var p=this.getPicker(),P=p.getDomRef("cont"),m=P.style.minWidth;if(q.sap.endsWith(m,"rem")){m=m.substring(0,m.length-3);var M=parseFloat(m);if(M<a.POPOVER_MIN_WIDTH_REM&&P){P.style.minWidth=a.POPOVER_MIN_WIDTH_REM+"rem";}}};
return a;});
sap.ui.predefine('sap/uxap/HierarchicalSelectRenderer',["sap/m/SelectRenderer","sap/ui/core/Renderer"],function(S,R){"use strict";var H=R.extend(S);
H.addClass=function(r){r.addClass("sapUxAPHierarchicalSelect");};
return H;},true);
sap.ui.predefine('sap/uxap/LazyLoading',["jquery.sap.global","sap/ui/Device","sap/ui/base/Metadata","./ObjectPageSubSection","./library"],function(q,D,M,O,l){"use strict";var L=M.createClass("sap.uxap._helpers.LazyLoading",{constructor:function(o){this._oObjectPageLayout=o;this._$html=q("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters();}});
L.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;this.LAZY_LOADING_EXTRA_PAGE_SIZE=0.5;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":1,"ScrollToSection":1};}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":1};}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":2};}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":3,"ScrollToSection":3};}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5;};
L.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading();};
L.prototype.lazyLoadDuringScroll=function(s,t,p){var P,d,f=false;this._iScrollProgress=s-this._iPreviousScrollTop;P=Math.round(Math.abs(this._iScrollProgress)/p*100);if(P>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){f=true;}this._iPreviousScrollTop=s;this._iPreviousScrollTimestamp=t||0;d=(s===0)?0:this.LAZY_LOADING_DELAY;if(f&&this._sLazyLoadingTimer){q.sap.log.debug("ObjectPageLayout :: lazyLoading","delayed by "+d+" ms because of fast scroll");q.sap.clearDelayedCall(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null;}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=q.sap.delayedCall(d,this,this.doLazyLoading);}};
L.prototype.doLazyLoading=function(){var h=this._oObjectPageLayout._getHeightRelatedParameters(),s=this._oObjectPageLayout._oSectionInfo,S,i,p,b=this._iPreviousScrollTop>=(h.iHeaderContentHeight),e,E=-1,o={},a={},t,c,d;p=(h.iScreenHeight-(b?h.iAnchorBarHeight:0)-(b?h.iHeaderTitleHeightStickied:0));S=h.iScrollTop;t=Date.now()-this._iPreviousScrollTimestamp;c=(t<(this.LAZY_LOADING_DELAY/2))&&(Math.abs(this._iScrollProgress)>5);if(c){if(this._iScrollProgress>=0){d=Math.round(Math.min(this._iScrollProgress*20,p/2));}else{d=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,p/2));}S+=d;q.sap.log.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+d);}i=S+p;S+=16;q.each(s,q.proxy(function(I,f){if(!f.isSection&&f.sectionReference.getParent()&&f.sectionReference.getParent().getVisible()){if(f.positionTop<=i&&S<f.positionBottom-1){a[I]=I;if(!f.loaded){o[I]=I;}}else if(!f.loaded&&f.positionTop>i&&f.positionTop<i+p*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(E==-1||f.positionTop<E)){E=f.positionTop;e=I;}}},this));if(E!=-1&&q.isEmptyObject(o)){q.sap.log.debug("ObjectPageLayout :: lazyLoading","extra section added : "+e);o[e]=e;}q.each(o,q.proxy(function(f,g){q.sap.log.debug("ObjectPageLayout :: lazyLoading","connecting "+g);sap.ui.getCore().byId(g).connectToModels();s[g].loaded=true;},this));q.each(a,q.proxy(function(f,g){if(!this._oPrevSubSectionsInView[f]){q.sap.log.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+g);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:sap.ui.getCore().byId(g)});}},this));this._oPrevSubSectionsInView=a;if(c){this._sLazyLoadingTimer=q.sap.delayedCall(this.LAZY_LOADING_DELAY,this,this.doLazyLoading);}else{if(E){this._sLazyLoadingTimer=q.sap.delayedCall(5*this.LAZY_LOADING_DELAY,this,this.doLazyLoading);}else{this._sLazyLoadingTimer=null;}}};
L.prototype.getSubsectionsToPreload=function(a,i){var s,t;if(i){s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;t=false;}else{s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;t=true;}var S=[];a.some(function(o){if(!t&&i){t=o.getId()==i;}if(t&&o instanceof O){if(o.getVisible()&&o._getInternalVisible()){S.push(o);s--;}}return s<=0;});return S;};
L.prototype._isPhone=function(){return l.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
L.prototype._isTablet=function(){return D.system.tablet;};
L.prototype._isTabletSize=function(){return l.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
return L;},false);
sap.ui.predefine('sap/uxap/ModelMapping',["sap/ui/core/Element","./library"],function(E,l){"use strict";
var M=E.extend("sap.uxap.ModelMapping",{metadata:{library:"sap.uxap",properties:{externalModelName:{type:"string",group:"Misc",defaultValue:null},internalModelName:{type:"string",group:"Misc",defaultValue:"Model"},externalPath:{type:"string",group:"Misc",defaultValue:null}}}});
return M;});
sap.ui.predefine('sap/uxap/ObjectImageHelper',["sap/ui/core/Icon","sap/ui/core/IconPool","sap/m/Image"],function(I,a,b){"use strict";var O=function(){};
O.createObjectImage=function(h){var o,s=h.getObjectImageURI();if(s.indexOf("sap-icon://")===0){o=new I();o.addStyleClass("sapUxAPObjectPageHeaderObjectImageIcon");}else{o=new b({densityAware:h.getObjectImageDensityAware(),alt:h.getObjectImageAlt(),decorative:false});o.addStyleClass("sapUxAPObjectPageHeaderObjectImage");}o.setSrc(s);if(h.getObjectImageAlt()){o.setTooltip(h.getObjectImageAlt());}return o;};
O.createPlaceholder=function(){return a.createControlByURI({src:a.getIconURI("picture"),visible:true});};
O._renderImageAndPlaceholder=function(r,o){var h=o.oHeader,c=o.oObjectImage,p=o.oPlaceholder,i=o.bIsObjectIconAlwaysVisible,A=o.bAddSubContainer,B=o.sBaseClass,s=!(h.getObjectImageShape()||h.getShowPlaceholder()),d=(c instanceof I);if(h.getObjectImageURI()||h.getShowPlaceholder()){r.write("<span ");r.addClass(B);r.addClass('sapUxAPObjectPageHeaderObjectImage-'+h.getObjectImageShape());if(i){r.addClass('sapUxAPObjectPageHeaderObjectImageForce');}r.writeClasses();r.write(">");if(A){r.write("<span class='sapUxAPObjectPageHeaderObjectImageContainerSub'>");}if(d){r.write("<div");r.addClass("sapUxAPObjectPageHeaderObjectImage");r.addClass("sapUxAPObjectPageHeaderPlaceholder");r.writeClasses();r.write(">");}r.renderControl(c);O._renderPlaceholder(r,p,s);if(d){r.write("</div>");}if(A){r.write("</span>");}r.write("</span>");}};
O._renderPlaceholder=function(r,p,v){r.write("<div");r.addClass('sapUxAPObjectPageHeaderPlaceholder');r.addClass('sapUxAPObjectPageHeaderObjectImage');if(!v){r.addClass('sapUxAPHidePlaceholder');}r.writeClasses();r.write(">");r.renderControl(p);r.write("</div>");};
return O;},false);
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContent',['jquery.sap.global','./library',"./ObjectPageDynamicHeaderContentRenderer"],function(q,l,O){"use strict";try{sap.ui.getCore().loadLibrary("sap.f");}catch(e){q.sap.log.error("The control 'sap.uxap.ObjectPageDynamicHeaderContent' needs library 'sap.f'.");throw(e);}var D=sap.ui.requireSync("sap/f/DynamicPageHeader");
var a=D.extend("sap.uxap.ObjectPageDynamicHeaderContent",{metadata:{interfaces:["sap.uxap.IHeaderContent"],library:"sap.uxap"}});
a.createInstance=function(c,v,C,p){return new a({content:c,visible:v,pinnable:p});};
a.prototype.supportsPinUnpin=function(){return true;};
a.prototype.supportsChildPageDesign=function(){return false;};
a.prototype.supportsAlwaysExpanded=function(){return false;};
a.prototype.setContentDesign=function(d){};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContentRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageHeaderRenderer'],function(R,D){"use strict";var O=R.extend(D);return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitle',['jquery.sap.global','./library','sap/uxap/ObjectPageDynamicHeaderContent',"./ObjectPageDynamicHeaderTitleRenderer"],function(q,l,O,a){"use strict";try{sap.ui.getCore().loadLibrary("sap.f");}catch(e){q.sap.log.error("The control 'sap.uxap.ObjectPageDynamicHeaderTitle' needs library 'sap.f'.");throw(e);}var D=sap.ui.requireSync("sap/f/DynamicPageTitle");
var b=D.extend("sap.uxap.ObjectPageDynamicHeaderTitle",{metadata:{interfaces:["sap.uxap.IHeaderTitle"],library:"sap.uxap"}});
b.prototype.isDynamic=function(){return true;};
b.prototype.getCompatibleHeaderContentClass=function(){return O;};
b.prototype.supportsToggleHeaderOnTitleClick=function(){return true;};
b.prototype.supportsTitleInHeaderContent=function(){return false;};
b.prototype.supportsAdaptLayoutForDomElement=function(){return false;};
b.KNOWN_HEADING_CONTROL_CLASS_NAMES=["sap.m.Title","sap.m.Text","sap.m.FormattedText","sap.m.Label"];
b.prototype.getTitleText=function(){var h=this.getHeading(),c=h&&h.getMetadata().getName();if(b.KNOWN_HEADING_CONTROL_CLASS_NAMES.indexOf(c)>-1){return h.getText();}};
b.prototype.getHeaderDesign=function(){return l.ObjectPageHeaderDesign.Light;};
b.prototype.snap=function(u){this._toggleState(false,u);};
b.prototype.unSnap=function(u){this._toggleState(true,u);};
b.prototype._adaptLayoutForDomElement=function($,E){};
return b;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitleRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageTitleRenderer'],function(R,D){"use strict";var O=R.extend(D);return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeader',["jquery.sap.global","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library","./ObjectPageHeaderRenderer"],function(q,C,I,a,D,B,O,R,b,A,c,d,l,m,e){"use strict";var f=l.Importance;var g=m.ButtonType;var P=m.PlacementType;var h=l.ObjectPageHeaderDesign;var j=l.ObjectPageHeaderPictureShape;
function k(i){return typeof i==="function";}
var n=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.uxap.ObjectPageHeaderPictureShape",defaultValue:j.Square},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:h.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false},titleSelectorTooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designtime:"sap/uxap/designtime/ObjectPageHeader.designtime"}});
n.prototype._iAvailablePercentageForActions=0.3;
n.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this);};
n.getMetadata().forwardAggregation("breadCrumbsLinks",{getter:function(){return this._lazyLoadInternalAggregation("_breadCrumbs");},aggregation:"links"});
n.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};
n.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};
n.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};
n.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};
n._internalAggregationFactory={"_objectImage":c.createObjectImage,"_placeholder":c.createPlaceholder,"_overflowActionSheet":function(){return new A({placement:P.Bottom});},"_lockIconCont":function(i){return this._getButton(i,"sap-icon://private","lock-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(i){return new B({links:i.getAggregation("breadCrumbLinks")});},"_lockIcon":function(i){return this._getButton(i,"sap-icon://private","lock",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow-cont",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(i){return this._getIcon(i,"favorite",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(i){return this._getIcon(i,"flag",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(i){return this._getButton(i,"sap-icon://overflow","overflow",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"));},"_expandButton":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","expand",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(i){return this._getButton(i,"sap-icon://user-edit","changes-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(i){return this._getButton(i,"sap-icon://user-edit","changes",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(i,t,T){return I.createControlByURI({id:this._getParentAugmentedId(i,t),tooltip:T,src:I.getIconURI(t),visible:false});},_getButton:function(i,t,u,T){return new b({id:this._getParentAugmentedId(i,u),tooltip:T,icon:t,type:g.Transparent});},_getParentAugmentedId:function(i,t){return i.getId()+"-"+t;}};
n.prototype._lazyLoadInternalAggregation=function(i,S){if(!this.getAggregation(i)){this.setAggregation(i,n._internalAggregationFactory[i](this),S);}return this.getAggregation(i);};
n.prototype._applyActionProperty=function(i,t){var u=t[0];if(this.getProperty(i)!==u){t.unshift(i);this.setProperty.apply(this,t);if(!this._bFirstRendering){this._notifyParentOfChanges();}}return this;};
n.prototype._applyObjectImageProperty=function(i,t){var u=t[0];if(this.getProperty(i)!==u){t.unshift(i);this.setProperty.apply(this,t);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true);}}return this;};
n.prototype._setAggregationTooltip=function(i,t){var u=this.getAggregation(i);if(u){u.setTooltip(t);}return this;};
n.prototype._setTitleSelectorTooltip=function(t){if(t===null||t===undefined){t=this.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP");}this._setAggregationTooltip("_titleArrowIcon",t);this._setAggregationTooltip("_titleArrowIconCont",t);return this;};
n.prototype.setHeaderDesign=function(H){this.setProperty("headerDesign",H);if(this.getParent()){this.getParent().invalidate();}return this;};
n.prototype.setObjectTitle=function(N){var i=this.getParent(),t=this.getProperty("objectTitle"),u=t!==N;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));i&&k(i._updateRootAriaLabel)&&i._updateRootAriaLabel();if(u&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":t,"newValue":N});}return this;};
var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],o=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape"];var G=function(i){var t="set"+i.charAt(0).toUpperCase()+i.slice(1);n.prototype[t]=function(){var u=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,i,u);};};var r=function(i){var t="set"+i.charAt(0).toUpperCase()+i.slice(1);n.prototype[t]=function(){var u=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,i,u);};};var s=function(i,S,t){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);S[u]=function(){var v=Array.prototype.slice.call(arguments);v.unshift(i);t.setProperty.apply(t,v);return this.setProperty.apply(this,v);};};p.forEach(G);o.forEach(r);
n.prototype._destroyObjectImage=function(){var i="_objectImage",t=this.getAggregation(i);if(t){t.destroy();this.setAggregation(i,null);}};
n.prototype.onBeforeRendering=function(){var S=this.getSideContentButton();if(S&&!S.getTooltip()){S.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var i=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._resetActionSheetMap();if(i.length>1||this._hasOneButtonShowText(i)){i.forEach(function(t){if(t instanceof b&&!(t instanceof O)){t._bInternalVisible=t.getVisible();t._getInternalVisible=function(){return this._bInternalVisible;};t._setInternalVisible=function(v,w){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(w){this.invalidate();}}};t.setVisible=function(v){t._setInternalVisible(v,true);b.prototype.setVisible.call(this,v);};t.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};}if(t instanceof b&&(t.getType()==="Default"||t.getType()==="Unstyled")){t.setProperty("type",g.Transparent,false);}if(t instanceof b&&t.getVisible()){var u=this._createActionSheetButton(t);this._oActionSheetButtonMap[t.getId()]=u;this._oOverflowActionSheet.addButton(u);s("text",t,u);s("icon",t,u);s("enabled",t,u);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._bFirstRendering=false;};
n.prototype._resetActionSheetMap=function(){Object.keys(this._oActionSheetButtonMap).forEach(function(i){this._oActionSheetButtonMap[i].destroy();}.bind(this));this._oActionSheetButtonMap={};};
n.prototype._createActionSheetButton=function(i){return new b({press:q.proxy(this._onSeeMoreContentSelect,this),enabled:i.getEnabled(),text:i.getText(),icon:i.getIcon(),tooltip:i.getTooltip(),customData:new a({key:"originalId",value:i.getId()})});};
n.prototype._handleImageNotFoundError=function(){var i=this._lazyLoadInternalAggregation("_objectImage"),t=this.getParent(),$=t?t.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{i.addStyleClass("sapMNoImg");}};
n.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error");};
n.prototype.onAfterRendering=function(){var $=this._lazyLoadInternalAggregation("_objectImage").$();this._adaptLayout();this._clearImageNotFoundHandler();$.error(this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._attachDetachActionButtonsHandler(true);};
n.prototype._onHeaderResize=function(E){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._onUpdateHeaderTitleSize==="function"){this.getParent()._onUpdateHeaderTitleSize(E);}};
n.prototype._attachDetachActionButtonsHandler=function(i){var t=this.getActions()||[];if(t.length<1){return;}t.forEach(function(u){if(u instanceof b){var v=this._oActionSheetButtonMap[u.getId()];if(i){u.attachEvent("_change",this._adaptLayout,this);if(v){v.attachEvent("_change",this._adaptOverflow,this);}}else{u.detachEvent("_change",this._adaptLayout,this);if(v){v.detachEvent("_change",this._adaptOverflow,this);}}}},this);};
n.prototype._onSeeMoreContentSelect=function(E){var i=E.getSource(),t=sap.ui.getCore().byId(i.data("originalId"));if(t.firePress){t.firePress({overflowButtonId:this._oOverflowButton.getId()});}this._oOverflowActionSheet.close();};
n._actionImportanceMap={"Low":3,"Medium":2,"High":1};
n._sortActionsByImportance=function(i,t){var u=(i instanceof O)?i.getImportance():f.High,v=(t instanceof O)?t.getImportance():f.High,w=n._actionImportanceMap[u]-n._actionImportanceMap[v];if(w===0){return i.position-t.position;}return w;};
n.prototype._hasOneButtonShowText=function(i){var t=false;if(i.length!==1){return t;}if(i[0]instanceof O){t=(!i[0].getHideText()&&i[0].getText()!="");}else if(i[0]instanceof b){t=(i[0].getText()!="");}return t;};
n.prototype._adaptLayout=function(E){this._adaptLayoutForDomElement(null,E);};
n.prototype._adaptLayoutForDomElement=function($,E){var i=this._findById($,"identifierLine"),t=i.width(),u=this._getActionsWidth(),v=u/t,w=this._iAvailablePercentageForActions*t,x=this._oOverflowButton.$(),y=this._findById($,"actions"),z=y.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(v>this._iAvailablePercentageForActions){this._adaptActions(w);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(D.system.phone){this.getActions().forEach(function(F){if(F instanceof b){F.$().css("visibility","visible");}});}if(z.filter(":visible").length===z.length){x.hide();}this._adaptObjectPageHeaderIndentifierLine($);};
n.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){q.sap.clearDelayedCall(this._adaptLayoutTimeout);}this._adaptLayoutTimeout=q.sap.delayedCall(0,this,function(){this._adaptLayoutTimeout=null;this._adaptLayout();});};
n.prototype._adaptObjectPageHeaderIndentifierLine=function($){var i=this._findById($,"identifierLine"),t=i.width(),u=this._findById($,"subtitle"),v=this._findById($,"innerTitle"),w=this._findById($,"identifierLineContainer"),S,T,x=this._findById($,"actions"),y=$?$.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),z=x.width()+y.width(),E=this.$().parents().hasClass('sapUiSizeCompact')?7:3;if(u.length){if(u.hasClass("sapOPHSubtitleBlock")){u.removeClass("sapOPHSubtitleBlock");}S=u.outerHeight()+u.position().top;T=v.outerHeight()+v.position().top;if(Math.abs(S-T)>E){u.addClass("sapOPHSubtitleBlock");}}w.width((0.95-(z/t))*100+"%");};
n.prototype._adaptActions=function(t){var M=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||D.system.phone,$=this._oOverflowButton.$(),v=$.show().width(),u=this.getActions(),w=u.length,x;for(var i=0;i<w;i++){u[i].position=i;}u.sort(n._sortActionsByImportance);u.forEach(function(y){x=this._oActionSheetButtonMap[y.getId()];if(x){v+=y.$().width();if(t>v&&!M){this._setActionButtonVisibility(y,true);$.hide();}else{this._setActionButtonVisibility(y,false);$.show();}}},this);};
n.prototype._adaptOverflow=function(){var i=this._oOverflowActionSheet.getButtons();var H=i.some(function(t){return t.getVisible();});this._oOverflowButton.$().toggle(H);};
n.prototype._setActionButtonVisibility=function(i,v){var t=this._oActionSheetButtonMap[i.getId()];if(t){if(i.getVisible()){i._setInternalVisible(v);t.setVisible(!v);}else{t.setVisible(false);}}};
n.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(i){if(i instanceof b){i.$().show();if(D.system.phone){i.$().css("visibility","hidden");}w+=i.$().outerWidth(true);}});return w;};
n.prototype._findById=function($,i){if(!i){return null;}if($){i=this.getId()+'-'+i;return q.sap.byId(i,$);}return this.$(i);};
n.prototype._getBreadcrumbsAggregation=function(){var i=this.getBreadcrumbs(),t=this._lazyLoadInternalAggregation('_breadCrumbs',true);return i||((t&&t.getLinks().length)?t:null);};
n.prototype._notifyParentOfChanges=function(i){var t=this.getParent();if(t&&typeof t._headerTitleChangeHandler==="function"){t._headerTitleChangeHandler(i);}};
n.prototype.setTitleSelectorTooltip=function(t){this._setTitleSelectorTooltip(t);this.setAggregation("titleSelectorTooltip",t,true);return this;};
n.prototype.destroyTitleSelectorTooltip=function(){this._setTitleSelectorTooltip(null);this.destroyAggregation("titleSelectorTooltip",true);return this;};
n.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._resetActionSheetMap();};
n.prototype.setNavigationBar=function(i){this.setAggregation("navigationBar",i);if(i&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":i});}return this;};
n.prototype._getAdaptableContent=function(){return this.getNavigationBar();};
n.prototype.isDynamic=function(){return false;};
n.prototype.getCompatibleHeaderContentClass=function(){return d;};
n.prototype.supportsToggleHeaderOnTitleClick=function(){return false;};
n.prototype.supportsTitleInHeaderContent=function(){return true;};
n.prototype.supportsAdaptLayoutForDomElement=function(){return true;};
n.prototype.getTitleText=function(){return this.getObjectTitle();};
n.prototype.snap=function(){this._adaptLayout();};
n.prototype.unSnap=function(){this._adaptLayout();};
n.prototype._toggleExpandButton=function(t){};
n.prototype._setShowExpandButton=function(v){};
n.prototype._focusExpandButton=function(){};
n.prototype._toggleFocusableState=function(F){};
return n;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButton',["sap/m/Button","./library","./ObjectPageHeaderActionButtonRenderer"],function(B,l,O){"use strict";
var a=B.extend("sap.uxap.ObjectPageHeaderActionButton",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.uxap",properties:{hideText:{type:"boolean",defaultValue:true},hideIcon:{type:"boolean",defaultValue:false},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}}}});
a.prototype.init=function(){this._bInternalVisible=this.getVisible();};
a.prototype.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};
a.prototype.applySettings=function(s,S){if(B.prototype.applySettings){B.prototype.applySettings.call(this,s,S);}this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",this.getHideText());this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",this.getHideIcon());};
a.prototype.setHideText=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",v);return this.setProperty("hideText",v,i);};
a.prototype.setHideIcon=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",v);return this.setProperty("hideIcon",v,i);};
a.prototype._setInternalVisible=function(v,i){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
a.prototype.setVisible=function(v){var r=B.prototype.setVisible.apply(this,arguments);if(this.getParent()&&typeof this.getParent()._adaptLayoutDelayed==="function"){this.getParent()._adaptLayoutDelayed();}return r;};
a.prototype._getInternalVisible=function(){return this._bInternalVisible;};
a.prototype.getOverflowToolbarConfig=function(){var c={canOverflow:true,propsUnrelatedToSize:["importance"],getCustomImportance:function(){return this.getImportance();}.bind(this)};c.onBeforeEnterOverflow=function(A){A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",false,true);A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",false,true);};c.onAfterExitOverflow=function(A){A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",A.getHideText(),true);A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",A.getHideIcon(),true);};return c;};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButtonRenderer',["sap/m/ButtonRenderer","sap/ui/core/Renderer"],function(B,R){"use strict";var O=R.extend(B);return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderContent',["sap/ui/core/Control","./library","sap/m/Button","./ObjectImageHelper","./ObjectPageHeaderContentRenderer"],function(C,l,B,O,a){"use strict";var b=l.ObjectPageHeaderDesign;
var c=C.extend("sap.uxap.ObjectPageHeaderContent",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderContent"],properties:{contentDesign:{type:"sap.uxap.ObjectPageHeaderDesign",group:"Misc",defaultValue:b.Light}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_editHeaderButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});
c.prototype.onBeforeRendering=function(){var p=this.getParent(),e=this.getAggregation("_editHeaderButton");if(e){return;}if(p&&(p instanceof l.ObjectPageLayout)&&p.getShowEditHeaderButton()){e=this._getInternalBtnAggregation("_editHeaderButton","EDIT_HEADER","-editHeaderBtn","Transparent");e.attachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype.exit=function(){var e=this.getAggregation("_editHeaderButton");if(e){e.detachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype._handleEditHeaderButtonPress=function(e){this.getParent().fireEditHeaderButtonPress();};
c.prototype._getInternalBtnAggregation=function(A,s,d,e){if(!this.getAggregation(A)){var o=new B({text:l.i18nModel.getResourceBundle().getText(s),type:e,id:this.getId()+d});this.setAggregation(A,o);}return this.getAggregation(A);};
c.prototype._getObjectImage=function(){if(!this.getAggregation("_objectImage")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),o=h&&O.createObjectImage(h);if(o){this.setAggregation("_objectImage",o,true);}}return this.getAggregation("_objectImage");};
c.prototype._destroyObjectImage=function(s){var o=this.getAggregation("_objectImage");if(o){o.destroy();this.getAggregation("_objectImage",null,s);}};
c.prototype._getPlaceholder=function(){if(!this.getAggregation("_placeholder")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),s=h.getShowPlaceholder();var P=s&&O.createPlaceholder();if(P){this.setAggregation("_placeholder",P,true);}}return this.getAggregation("_placeholder");};
c.prototype._getLayoutDataForControl=function(o){var L=o.getLayoutData();if(!L){return;}else if(L instanceof l.ObjectPageHeaderLayoutData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var d=L.getMultipleLayoutData();for(var i=0;i<d.length;i++){var e=d[i];if(e instanceof l.ObjectPageHeaderLayoutData){return e;}}}};
c.createInstance=function(d,v,s){return new c({content:d,visible:v,contentDesign:s});};
c.prototype.supportsPinUnpin=function(){return false;};
c.prototype.supportsChildPageDesign=function(){return true;};
c.prototype.supportsAlwaysExpanded=function(){return true;};
c.prototype._toggleCollapseButton=function(t){};
c.prototype._setShowCollapseButton=function(v){};
c.prototype._focusCollapseButton=function(){};
c.prototype._focusPinButton=function(){};
return c;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderContentRenderer',["./ObjectPageHeaderRenderer","./ObjectImageHelper"],function(O,a){"use strict";var b={};
b.render=function(r,c){var p=c.getParent(),P=p&&p.isA("sap.uxap.ObjectPageLayout"),h=(p&&P)?p.getHeaderTitle():undefined,R=(p&&P)?(p.isA("sap.uxap.ObjectPageLayout")&&p.getShowTitleInHeaderContent()):false,d=P&&p.getShowEditHeaderButton()&&c.getContent()&&c.getContent().length>0;if(d){r.write("<div ");r.writeControlData(c);r.addClass("sapUxAPObjectPageHeaderContentFlexBox");r.addClass("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.addClass('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}r.writeClasses();r.write(">");}r.write("<div ");if(d){r.addClass("sapUxAPObjectPageHeaderContentCellLeft");}else{r.writeControlData(c);r.addClass("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.addClass('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}}r.addClass("sapContrastPlus");r.addClass("ui-helper-clearfix");r.addClass("sapUxAPObjectPageHeaderContent");if(!c.getVisible()){r.addClass("sapUxAPObjectPageHeaderContentHidden");}r.writeClasses();r.write(">");if(P&&p.getIsChildPage()){r.write("<div");r.addClass('sapUxAPObjectChildPage');r.writeClasses();r.write("></div>");}if(R){this._renderTitleImage(r,c,h);if(c.getContent().length==0){r.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");this._renderTitle(r,h);r.write("</span>");}}c.getContent().forEach(function(i,I){this._renderHeaderContentItem(i,I,r,R,h,c);},this);r.write("</div>");if(d){this._renderEditButton(r,c);r.write("</div>");}};
b._renderHeaderContentItem=function(h,i,r,R,t,c){var H=false,d=false,l=c._getLayoutDataForControl(h),I=i===0;if(l){H=l.getShowSeparatorBefore();d=l.getShowSeparatorAfter();r.write("<span ");r.addClass("sapUxAPObjectPageHeaderWidthContainer");r.addClass("sapUxAPObjectPageHeaderContentItem");r.addStyle("width",l.getWidth());r.writeStyles();if(d||H){r.addClass("sapUxAPObjectPageHeaderSeparatorContainer");}if(!l.getVisibleL()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenL");}if(!l.getVisibleM()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenM");}if(!l.getVisibleS()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenS");}r.writeClasses();r.write(">");if(H){r.write("<span class=\"sapUxAPObjectPageHeaderSeparatorBefore\"/>");}if(I&&R){this._renderTitle(r,t);}}else{if(I&&R){r.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");this._renderTitle(r,t);}else{h.addStyleClass("sapUxAPObjectPageHeaderContentItem");}}r.renderControl(h);if(d){r.write("<span class=\"sapUxAPObjectPageHeaderSeparatorAfter\"/>");}if(l||(I&&R)){r.write("</span>");}};
b._renderTitleImage=function(r,c,h){a._renderImageAndPlaceholder(r,{oHeader:h,oObjectImage:c._getObjectImage(),oPlaceholder:c._getPlaceholder(),bIsObjectIconAlwaysVisible:false,bAddSubContainer:false,sBaseClass:'sapUxAPObjectPageHeaderContentImageContainer'});};
b._renderTitle=function(r,h){O._renderObjectPageTitle(r,h,true);};
b._renderEditButton=function(r,h){r.write("<div class=\"sapUxAPObjectPageHeaderContentCellRight\">");r.renderControl(h.getAggregation("_editHeaderButton"));r.write("</div>");};
return b;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderLayoutData',["sap/ui/core/LayoutData","./library"],function(L,l){"use strict";
var O=L.extend("sap.uxap.ObjectPageHeaderLayoutData",{metadata:{library:"sap.uxap",properties:{visibleS:{type:"boolean",group:"Misc",defaultValue:true},visibleM:{type:"boolean",group:"Misc",defaultValue:true},visibleL:{type:"boolean",group:"Misc",defaultValue:true},showSeparatorBefore:{type:"boolean",group:"Misc",defaultValue:false},showSeparatorAfter:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'}}}});
return O;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderRenderer',["./ObjectImageHelper","sap/ui/Device"],function(O,D){"use strict";var a={};
a.render=function(r,c){var n=c.getNavigationBar(),t=(c.getIsObjectIconAlwaysVisible()||c.getIsObjectTitleAlwaysVisible()||c.getIsObjectSubtitleAlwaysVisible()||c.getIsActionAreaAlwaysVisible()),p=c.getParent(),e=c.getAggregation("_expandButton"),o=c._lazyLoadInternalAggregation("_objectImage",true),P,I=D.system.desktop,b=p&&p.isA("sap.uxap.ObjectPageLayout")&&((p.getHeaderContent()&&p.getHeaderContent().length>0&&p.getShowHeaderContent())||(p.getShowHeaderContent()&&p.getShowTitleInHeaderContent()));r.write("<div");r.writeControlData(c);r.addClass('sapUxAPObjectPageHeader');r.addClass('sapUxAPObjectPageHeaderDesign-'+c.getHeaderDesign());r.writeClasses();r.write(">");if(n){r.write("<div");r.addClass('sapUxAPObjectPageHeaderNavigation');r.writeClasses();r.write(">");r.renderControl(n);r.write("</div>");}r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-identifierLine");r.addClass('sapUxAPObjectPageHeaderIdentifier');if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierForce');}r.writeClasses();r.write(">");if(p&&p.isA("sap.uxap.ObjectPageLayout")&&p.getIsChildPage()){r.write("<div");r.addClass('sapUxAPObjectChildPage');r.writeClasses();r.write("></div>");}if(c.getShowPlaceholder()){P=c._lazyLoadInternalAggregation("_placeholder",true);}O._renderImageAndPlaceholder(r,{oHeader:c,oObjectImage:o,oPlaceholder:P,bIsObjectIconAlwaysVisible:c.getIsObjectIconAlwaysVisible(),bAddSubContainer:true,sBaseClass:'sapUxAPObjectPageHeaderObjectImageContainer'});r.write("<span ");r.writeAttributeEscaped("id",c.getId()+"-identifierLineContainer");r.addClass('sapUxAPObjectPageHeaderIdentifierContainer');r.writeClasses();r.write(">");this._renderObjectPageTitle(r,c);r.write("</span>");r.write("<span");r.writeAttributeEscaped("id",c.getId()+"-actions");r.addClass('sapUxAPObjectPageHeaderIdentifierActions');if(c.getIsActionAreaAlwaysVisible()){r.addClass('sapUxAPObjectPageHeaderIdentifierActionsForce');}r.writeClasses();r.write(">");if(I&&b){e.addStyleClass("sapUxAPObjectPageHeaderExpandButton");r.renderControl(e);}var A=c.getActions();for(var i=0;i<A.length;i++){var d=A[i];r.renderControl(d);}var f=c.getAggregation("_overflowButton");r.renderControl(f);this._renderSideContentBtn(r,c);r.write("</span>");r.write("</div>");r.write("</div>");};
a._renderObjectPageTitle=function(r,c,t){var o=c.getObjectTitle(),m=(c.getShowMarkers()&&(c.getMarkFavorite()||c.getMarkFlagged())),b=c._getBreadcrumbsAggregation();if(!t&&b){r.renderControl(b);}r.write("<h1");r.addClass('sapUxAPObjectPageHeaderIdentifierTitle');if(c.getIsObjectTitleAlwaysVisible()){r.addClass('sapUxAPObjectPageHeaderIdentifierTitleForce');}if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierTitleInContent');}if(c.getShowTitleSelector()){r.addClass('sapUxAPObjectPageHeaderTitleFollowArrow');}r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-title");r.write(">");r.write("<span");r.addClass("sapUxAPObjectPageHeaderTitleTextWrappable");r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-innerTitle");r.write(">");if(m||c.getShowTitleSelector()||c.getMarkLocked()||c.getMarkChanges()){var s=o.substr(o.lastIndexOf(" ")+1);var d=o.substr(0,o.lastIndexOf(" ")+1);if(s.length===1){s=o;d='';}r.writeEscaped(d);r.write("</span>");r.write("<span");r.addClass('sapUxAPObjectPageHeaderNowrapMarkers');if(c.getMarkLocked()||c.getMarkChanges()){r.addClass('sapUxAPObjectPageHeaderMarks');}r.writeClasses();r.write(">");r.writeEscaped(s);this._renderMarkers(r,c);if(c.getMarkLocked()){this._renderLock(r,c,t);}else if(c.getMarkChanges()){this._renderMarkChanges(r,c,t);}this._renderSelectTitleArrow(r,c,t);r.write("</span>");}else{r.writeEscaped(o);r.write("</span>");}r.write("</h1>");r.write("<span");r.addClass('sapUxAPObjectPageHeaderIdentifierDescription');if(c.getIsObjectSubtitleAlwaysVisible()&&c.getObjectSubtitle()){r.addClass('sapUxAPObjectPageHeaderIdentifierDescriptionForce');}if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierSubTitleInContent');}r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-subtitle");r.write(">");r.writeEscaped(c.getObjectSubtitle());r.write("</span>");};
a._renderSelectTitleArrow=function(r,c,t){if(c.getShowTitleSelector()){r.write("<span");r.addClass("sapUxAPObjectPageHeaderTitleArrow");r.writeClasses();r.write(">");if(t){r.renderControl(c._oTitleArrowIconCont);}else{r.renderControl(c._oTitleArrowIcon);}r.write("</span>");}};
a._renderSideContentBtn=function(r,c){var s=c.getSideContentButton();if(s){r.write("<span");r.addClass("sapUxAPObjectPageHeaderSideContentBtn");r.writeClasses();r.write(">");r.write("<span");r.addClass("sapUxAPObjectPageHeaderSeparator");r.writeClasses();r.write("></span>");r.renderControl(s);r.write("</span>");}};
a._renderMarkChanges=function(r,c,t){r.write("<span");r.addClass("sapUxAPObjectPageHeaderChangesBtn");r.addClass("sapUiSizeCompact");r.writeClasses();r.write(">");if(t){r.renderControl(c._oChangesIconCont);}else{r.renderControl(c._oChangesIcon);}r.write("</span>");};
a._renderLock=function(r,c,t){r.write("<span");r.addClass("sapUxAPObjectPageHeaderLockBtn");r.addClass("sapUiSizeCompact");r.writeClasses();r.write(">");if(t){r.renderControl(c._oLockIconCont);}else{r.renderControl(c._oLockIcon);}r.write("</span>");};
a._renderMarkers=function(r,c){var I=[];if(c.getShowMarkers()){I.push(c._oFavIcon);I.push(c._oFlagIcon);this._renderMarkersAria(r,c);r.write("<span");r.addClass("sapMObjStatusMarker");r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-markers");r.writeAttributeEscaped("aria-describedby",c.getId()+"-markers-aria");r.write(">");for(var i=0;i<I.length;i++){r.renderControl(I[i]);}r.write("</span>");}};
a._renderMarkersAria=function(r,c){var A="";if(c.getMarkFlagged()){A+=(c.oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE")+" ");}if(c.getMarkFavorite()){A+=(c.oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE")+" ");}if(A!==""){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-markers-aria");r.writeAttribute("aria-hidden","false");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.writeEscaped(A);r.write("</div>");}};
return a;},true);
sap.ui.predefine('sap/uxap/ObjectPageLayout',["jquery.sap.global","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/ui/core/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","jquery.sap.keycodes"],function(q,R,C,D,S,O,a,b,c,L,A,T,d,e,l,f){"use strict";var g=e.TitleLevel;var h=l.ObjectPageSubSectionLayout;
var i=C.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:h.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:g.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}}},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});
i.HEADER_CALC_DELAY=350;i.DOM_CALC_DELAY=200;i.FOOTER_ANIMATION_DURATION=350;i.MAX_SNAP_POSITION_OFFSET=20;i.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;i.TITLE_LEVEL_AS_ARRAY=Object.keys(g);i.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};i.BREAK_POINTS={TABLET:1024,PHONE:600};i.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};
i._getNextTitleLevelEntry=function(t){var k=i.TITLE_LEVEL_AS_ARRAY.indexOf(t),m=k!==-1,H=m&&(k!==i.TITLE_LEVEL_AS_ARRAY.length-1);if(!m){return g.Auto;}return i.TITLE_LEVEL_AS_ARRAY[H?k+1:k];};
i._getLibraryResourceBundle=function(){return l.i18nModel.getResourceBundle();};
i.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollPosition=0;this._bInternalAnchorBarVisible=true;this._$opWrapper=[];this._$anchorBar=[];this._$headerTitle=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iTotalHeaderSize=0;this._iREMSize=parseInt(q("body").css("font-size"),10);this._iOffset=parseInt(0.25*this._iREMSize,10);this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();};
i.prototype.onBeforeRendering=function(){var H,p;this._oLazyLoading=new L(this);if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();this._getCustomScrollBar().setScrollPosition(0);if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){p=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(p);if(p){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);};
i.prototype.setToggleHeaderOnTitleClick=function(t){var o=this.getHeaderTitle(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);if(!o||!o.supportsToggleHeaderOnTitleClick()){q.sap.log.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return r;}t=this.getProperty("toggleHeaderOnTitleClick");this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",t);this._updateToggleHeaderVisualIndicators();if(j(o)){o._toggleFocusableState(t);}return r;};
i.prototype._attachTitlePressHandler=function(){var t=this.getHeaderTitle();if(j(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(i.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};
i.prototype._toggleHeaderVisibility=function(s){var H=this._getHeaderContent();if(j(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!s);}};
i.prototype._snapHeader=function(k){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin();H.getAggregation("_pinButton").setPressed(false);k=true;}this._toggleHeaderTitle(false,true);this._moveAnchorBarToTitleArea();if(k){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._toggleHeaderVisibility(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};
i.prototype._expandHeader=function(k){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(k){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();if(j(this._$stickyAnchorBar)){this._$stickyAnchorBar.addClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();if(j(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}};
i.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()){return;}var E=!this._bHeaderExpanded,I,k,m;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));k=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(k);if(!k){this._scrollTo(0,0);}}else{m=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(m);}};
i.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(j(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(i.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
i.prototype._handleExpandButtonPressEventLifeCycle=function(k){var H=this.getHeaderTitle(),E;if(H){E=H.getAggregation("_expandButton");if(E){E[k?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};
i.prototype._adjustSelectedSectionByUXRules=function(){var s=this.oCore.byId(this.getSelectedSection()),v=s&&this._sectionCanBeRenderedByUXRules(s);if(!v){if(this._oFirstVisibleSection){s=this._oFirstVisibleSection;this.setAssociation("selectedSection",s.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}var o=this.oCore.byId(this._sStoredScrolledSubSectionId),V=o&&this._sectionCanBeRenderedByUXRules(o)&&(s.indexOfSubSection(o)>=0);if(!V){this._sStoredScrolledSubSectionId=null;}};
i.prototype._sectionCanBeRenderedByUXRules=function(s){if(!s||!s.getVisible()||!s._getInternalVisible()){return false;}var k=this._aSectionBases.map(function(o){return o.getId();});return(k.indexOf(s.getId())>-1);};
i.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var s=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&s){return[s];}else{return this.getSections();}};
i.prototype._preloadSectionsOnBeforeFirstRendering=function(){var t;if(!this.getEnableLazyLoading()){t=this._getSectionsToRender();}else{var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;t=this._oLazyLoading.getSubsectionsToPreload(s);}this._connectModelsForSections(t);};
i.prototype._grepCurrentTabSectionBases=function(){var F=[],s;this._adjustSelectedSectionByUXRules();s=this.oCore.byId(this.getSelectedSection());if(s){var k=s.getId();this._aSectionBases.forEach(function(o){if(o.getParent().getId()===k){F.push(o);}});}return F;};
i.prototype.onAfterRendering=function(){var H=this._getHeaderContent();this._ensureCorrectParentHeight();this._cacheDomElements();this._$opWrapper.on("scroll",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=q.sap.delayedCall(this._getDOMCalculationDelay(),this,this._onAfterRenderingDomReady);}if(H&&H.supportsPinUnpin()){this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",H.getPinnable());}this._handleExpandButtonPressEventLifeCycle(true);};
i.prototype._onAfterRenderingDomReady=function(){var s,o,k;if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(s){if(this.getUseIconTabBar()){this._setSelectedSectionId(s);this._setCurrentTabSection(o);}else{this.scrollToSection(s,0);}}if(D.system.desktop){this._$opWrapper.on("scroll",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){k=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(k);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);if(this._hasDynamicTitle()){this._updateMedia(this._getWidth(this));}this._updateToggleHeaderVisualIndicators();this.fireEvent("onAfterRenderingDOMReady");};
i.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),s=this._calculateShiftOffset();$.css(s.sStyleAttribute,s.iMarginalsOffset+"px");};
i.prototype._calculateShiftOffset=function(){var H=0,s=this.oCore.getConfiguration().getRTL()?"left":"right",k=this._hasVerticalScrollBar(),m=this._iOffset,n;if(D.system.desktop){n=q.sap.scrollbarSize().width;H=n;if(!k){H=0;m+=n;}}return{"sStyleAttribute":s,"iActionsOffset":m,"iMarginalsOffset":H};};
i.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?i.HEADER_CALC_DELAY:0;};
i.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._iResizeId){R.deregister(this._iResizeId);}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};
i.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new d(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};
i.prototype.onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(s);}};
i.prototype.onCustomScrollerScroll=function(E){var s=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(s);};
i.prototype.setShowOnlyHighImportance=function(v){var o=this.getShowOnlyHighImportance();if(o!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(s){s._updateImportance();});}return this;};
i.prototype.setIsHeaderContentAlwaysExpanded=function(v){var o=this.getAlwaysShowContentHeader();var s=(D.system.phone||D.system.tablet);if(o!==v){this.setProperty("alwaysShowContentHeader",v,s);}return this;};
i.prototype.setShowEditHeaderButton=function(v){var o=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(o!==v){this.setProperty("showEditHeaderButton",v,true);H&&H.invalidate();}return this;};
i.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};
i.prototype.setSelectedSection=function(I){var v,s;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._requestAdjustLayoutAndUxRules(true);return this;}this.scrollToSection(I);v=a._getClosestSection(I);s=(v instanceof a)?v.getId():v;return this.setAssociation("selectedSection",s,true);};
i.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};
i.prototype._cacheDomElements=function(){this._$headerTitle=q.sap.byId(this.getId()+"-headerTitle");this._$anchorBar=q.sap.byId(this.getId()+"-anchorBar");this._$stickyAnchorBar=q.sap.byId(this.getId()+"-stickyAnchorBar");this._$opWrapper=q.sap.byId(this.getId()+"-opwrapper");this._$spacer=q.sap.byId(this.getId()+"-spacer");this._$headerContent=q.sap.byId(this.getId()+"-headerContent");this._$stickyHeaderContent=q.sap.byId(this.getId()+"-stickyHeaderContent");this._$contentContainer=q.sap.byId(this.getId()+"-scroll");this._$sectionsContainer=q.sap.byId(this.getId()+"-sectionsContainer");this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};
i.prototype._handleExpandButtonPress=function(E){if(this._bStickyAnchorBar){this._moveHeaderToTitleArea();this._toggleHeaderTitle(true);}};
i.prototype._toggleHeaderTitle=function(E,u){var H=this.getHeaderTitle();this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",!E);if(E){H&&H.unSnap(u);}else{H&&H.snap(u);}};
i.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};
i.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};
i.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};
i.prototype._applyUxRules=function(I){var s,k,v,V,m,n,o,F,p;s=this.getSections()||[];V=0;n=this.getShowAnchorBar();o=this.getUseIconTabBar();F=null;this._cleanMemory();s.forEach(function(r){if(!r.getVisible()){return true;}this._registerSectionBaseInfo(r);k=r.getSubSections()||[];v=0;p=null;k.forEach(function(t){if(!t.getVisible()){return true;}this._registerSectionBaseInfo(t);m=t.getVisibleBlocksCount();if(m===0){t._setInternalVisible(false,I);q.sap.log.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+t.getTitle()+" forced to hidden");}else{t._setInternalVisible(true,I);t._setInternalTitleVisible(true,I);v++;if(!p){p=t;}if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t));}}},this);if(v==0){r._setInternalVisible(false,I);q.sap.log.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+r.getTitle()+" forced to hidden");}else{r._setInternalVisible(true,I);r._setInternalTitleVisible(true,I);if(!F){F=r;}if(this.getSubSectionLayout()===h.TitleOnTop&&v===1&&p.getTitle().trim()!==""){q.sap.log.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+r.getTitle()+" is taking its single subsection title "+p.getTitle());r._setInternalTitle(p.getTitle(),I);p._setInternalTitleVisible(false,I);}else{r._setInternalTitle("",I);}if(this._shouldApplySectionTitleLevel(r)){r._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(r));}V++;}if(o){r._setInternalTitleVisible(false,I);}},this);if(V<=1){n=false;q.sap.log.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");}else if(F&&n){F._setInternalTitleVisible(false,I);q.sap.log.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+F.getTitle()+" title forced to hidden");}if(n){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(n,I);this._oFirstVisibleSection=F;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(F);};
i.prototype.setUseIconTabBar=function(v){var o=this.getUseIconTabBar();if(v!=o){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};
i.prototype._setCurrentTabSection=function(s,I){if(!s){return;}var o;if(s instanceof sap.uxap.ObjectPageSubSection){o=s;s=s.getParent();}else{o=this._getFirstVisibleSubSection(s);}if(this._oCurrentTabSection!==s){this._renderSection(s);this._oCurrentTabSection=s;}this._oCurrentTabSubSection=o;};
i.prototype._renderSection=function(s){var $=this.$().find(".sapUxAPObjectPageContainer"),r;if(s&&$.length){r=this.oCore.createRenderManager();this.getSections().forEach(function(o){if((o.getId()===s.getId())){r.renderControl(s);}else{r.cleanupControlWithoutRendering(o);}});r.flush($[0]);r.destroy();}};
i.prototype.setShowAnchorBarPopover=function(v,s){var o=this.getProperty("showAnchorBarPopover"),v=this.validateProperty("showAnchorBarPopover",v);if(v===o){return;}this._oABHelper._getAnchorBar().setShowPopover(v);this._oABHelper._buildAnchorBar();return this.setProperty("showAnchorBarPopover",v,true);};
i.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};
i.prototype._setInternalAnchorBarVisible=function(v,I){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(I===true){this.invalidate();}}};
i.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};
i.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,i.DOM_CALC_DELAY,this);}if(!I){q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+i.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(r){});};
i.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,i.DOM_CALC_DELAY,this);}if(!I){q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+i.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(r){});};
i.prototype._adjustLayoutAndUxRules=function(){var s,o;q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);if(o){this._setSelectedSectionId(s);if(this.getUseIconTabBar()){this._setCurrentTabSection(o);}this._requestAdjustLayout(true).then(function(k){if(k){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();if(!this._isClosestScrolledSection(s)||this._oScroller._$Container.is(":animated")){this.scrollToSection(s,null,0,false,true);}}.bind(this));}};
i.prototype._isClosestScrolledSection=function(s){var k=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,p=this.iScreenHeight,m=this._getClosestScrolledSectionId(k,p);return m&&(s===m);};
i.prototype._setSelectedSectionId=function(s){var o=this.getAggregation("_anchorBar"),k=s&&this._oSectionInfo[s];if(!k){return;}if(o&&k.buttonId){o.setSelectedButton(k.buttonId);this.setAssociation("selectedSection",s,true);}};
i.prototype.isFirstRendering=function(){return this._bFirstRendering;};
i.prototype._cleanMemory=function(){var o=this.getAggregation("_anchorBar");if(o){o._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};
i.prototype._registerSectionBaseInfo=function(s){this._oSectionInfo[s.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(s instanceof a),sectionReference:s};this._aSectionBases.push(s);};
i.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};
i.prototype.scrollToSection=function(I,k,o,m,r){var s=this.oCore.byId(I);if(!this.getDomRef()){q.sap.log.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!s){q.sap.log.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]){q.sap.log.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){q.sap.log.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var t=a._getClosestSection(s);if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}t._allowPropagationToLoadedViews(true);this._setCurrentTabSection(s);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[t.getId()].buttonId);this.setAssociation("selectedSection",t.getId(),true);}if(m){this.fireNavigate({section:a._getClosestSection(s),subSection:s instanceof b?s:s.getSubSections()[0]});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}o=o||0;s._expandSection();this._requestAdjustLayout(true);k=this._computeScrollDuration(k,s);var n=this._computeScrollPosition(s);if(this._sCurrentScrollId!=I||r){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=q.sap.delayedCall(k,this,function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;});}this._preloadSectionsOnScroll(s);this.getHeaderTitle()&&this._shiftHeaderTitle();this._scrollTo(n+o,k);}};
i.prototype._computeScrollDuration=function(k,t){var m=parseInt(k,10);m=m>=0?m:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((t instanceof a)||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){m=0;}return m;};
i.prototype._computeScrollPosition=function(t){var F=t&&(t instanceof a),I=t.getId(),s=this._bMobileScenario||F?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(t)){s=0;}return s;};
i.prototype._preloadSectionsOnScroll=function(t){var I=t.getId(),k;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){k=(t instanceof a)?t:t.getParent();this._connectModelsForSections([k]);}if(this.getEnableLazyLoading()){var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;k=this._oLazyLoading.getSubsectionsToPreload(s,I);if(D.system.desktop){q.sap.delayedCall(50,this,function(){this._connectModelsForSections(k);});}else{this._connectModelsForSections(k);}k.forEach(function(m){this.fireEvent("subSectionEnteredViewPort",{subSection:m});},this);}};
i.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};
i.prototype.setDirectScrollingToSection=function(s){this.sDirectSectionId=s;};
i.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};
i.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};
i.prototype._scrollTo=function(y,t){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){q.sap.log.debug("ObjectPageLayout :: scrolling to "+y);if((t===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}this._oScroller.scrollTo(0,y,t);}return this;};
i.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,k,v,o;if(!j(H)||!j(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();k=$.getBoundingClientRect().height;v=this._$opWrapper[0].getBoundingClientRect().height;o=$.offsetTop+k-v;this._scrollTo(o);};
i.prototype._updateMedia=function(w){var u=function(M){Object.keys(i.DYNAMIC_HEADERS_MEDIA).forEach(function(s){var k=i.DYNAMIC_HEADERS_MEDIA[s],E=M===k;this.toggleStyleClass(k,E);},this);}.bind(this),m=i.DYNAMIC_HEADERS_MEDIA,B=i.BREAK_POINTS;if(w<=B.PHONE){u(m.PHONE);}else if(w<=B.TABLET){u(m.TABLET);}else{u(m.DESKTOP);}};
i.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var k,o,s,p,P,m,n=!this._bHeaderExpanded,r=this.getDomRef();if(!r||!this._bDomReady){return false;}q.sap.log.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(r);if(this.iScreenHeight===0){return;}var t=0;this._aSectionBases.forEach(function(u){var I=this._oSectionInfo[u.getId()],$=u.$(),v,w=false;if(!I||!$.length){return;}if(!I.isSection){t++;}I.$dom=$;var x=$.position().top;I.positionTop=Math.ceil(x);if(I.isSection){v=u.$("header");}else{v=u.$("headerTitle");}w=v.length===0;if(!w){I.positionTopMobile=Math.ceil(v.position().top)+v.outerHeight();}else{I.positionTopMobile=I.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){I.positionTopMobile-=this.iAnchorBarHeight;I.positionTop-=this.iAnchorBarHeight;}I.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",w);if(this._bMobileScenario){var y=this.oCore.byId(u.getId()).getParent();if(y instanceof a&&y._getIsHidden()){return;}if(P){this._oSectionInfo[P].positionBottom=I.positionTop;}P=u.getId();o=u;}else{if(I.isSection){if(P){this._oSectionInfo[P].positionBottom=I.positionTop;if(p){this._oSectionInfo[p].positionBottom=I.positionTop;}}P=u.getId();p=null;}else{if(p){this._oSectionInfo[p].positionBottom=I.positionTop;}p=u.getId();o=u;}}},this);if(o){k=this._computeLastVisibleHeight(o);if(this._bMobileScenario&&P){this._oSectionInfo[P].positionBottom=this._oSectionInfo[P].positionTop+k;}else{if(p){this._oSectionInfo[p].positionBottom=this._oSectionInfo[p].positionTop+k;}if(P&&p){this._oSectionInfo[P].positionBottom=this._oSectionInfo[p].positionTop+k;}}m=this._bStickyAnchorBar||(t>1)||this._checkContentBottomRequiresSnap(o);if(m&&!this._shouldPreserveHeaderInTitleArea()){n=true;}s=this._computeSpacerHeight(o,k,m,n);this._$spacer.height(s+"px");q.sap.log.debug("ObjectPageLayout :: bottom spacer is now "+s+"px");}this._updateCustomScrollerHeight(n);this._setSectionInfoIsDirty(false);return true;};
i.prototype._updateCustomScrollerHeight=function(r){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var s=this._computeScrollableContentSize(r);s+=this._getStickyAreaHeight(r);this._getCustomScrollBar().setContentSize(s+"px");var k=(s>Math.ceil(this.iScreenHeight)),v=(k!==this._getCustomScrollBar().getVisible());if(v){this._getCustomScrollBar().setVisible(k);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};
i.prototype._computeScrollableContentSize=function(s){var k=0;if(this._$contentContainer&&this._$contentContainer.length){k=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&s){k-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!s){k+=this.iAnchorBarHeight;}return k;};
i.prototype._computeLastVisibleHeight=function(o){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var k=this._getSectionPositionTop(o,I);return this._$spacer.position().top-k;};
i.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};
i.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};
i.prototype._getSectionPositionTop=function(s,k){var p=s.$().position().top;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&k){p-=this.iAnchorBarHeight;}return p;};
i.prototype._getSectionPositionBottom=function(s,k){var p=this._oSectionInfo[s.getId()].positionBottom;if(!k){p+=this.iAnchorBarHeight;}return p;};
i.prototype._determineSectionBaseInternalTitleLevel=function(s){var k=this.getSectionTitleLevel(),I=s instanceof a;if(k===g.Auto){return I?g.H3:g.H4;}return I?k:i._getNextTitleLevelEntry(k);};
i.prototype._shouldApplySectionTitleLevel=function(s){return s.getTitleLevel()===g.Auto;};
i.prototype._checkContentBottomRequiresSnap=function(s){var k=false;return this._getSectionPositionBottom(s,k)>=(this._getScrollableViewportHeight(k)+this._getSnapPosition());};
i.prototype._computeSpacerHeight=function(o,k,m,s){var n,p,F;if(this.getFooter()&&this.getShowFooter()){F=this.$("footerWrapper").outerHeight();}p=this._getScrollableViewportHeight(s);if(!m){k=this._getSectionPositionBottom(o,false);}if(k<p){n=p-k;if(this._bMobileScenario){n+=(this._oSectionInfo[o.getId()].positionTopMobile-this._oSectionInfo[o.getId()].positionTop);}}else{n=0;}if(F>n){n+=F;}return n;};
i.prototype._isFirstVisibleSectionBase=function(s){var k,o,F,m=this.getSelectedSection(),u=this.getUseIconTabBar();if(!s||!s.getParent()){return;}k=s.getId();if(u&&(k===m)){return true;}if(u&&(s.getParent().getId()===m)){o=sap.ui.getCore().byId(m);F=this._getFirstVisibleSubSection(o);return F&&(F.getId()===k);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return k===this._oFirstVisibleSection.getId()||k===this._oFirstVisibleSubSection.getId();}return false;};
i.prototype._getFirstVisibleSubSection=function(s){if(!s){return;}var F;this._aSectionBases.every(function(o){if(o.getParent()&&(o.getParent().getId()===s.getId())){F=o;return false;}return true;});return F;};
i.prototype._initAnchorBarScroll=function(){var s=this.oCore.byId(this.getSelectedSection()),k;this._requestAdjustLayout(true);k=s?this._computeScrollPosition(s):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:k}});};
i.prototype._setAsCurrentSection=function(s){var o,k,m;if(this._sScrolledSectionId===s){return;}q.sap.log.debug("ObjectPageLayout :: current section is "+s);this._sScrolledSectionId=s;o=this.getAggregation("_anchorBar");if(o&&this._getInternalAnchorBarVisible()){k=this.oCore.byId(s);m=k&&k instanceof b&&(k.getTitle().trim()===""||!k._getInternalTitleVisible()||k.getParent()._getIsHidden());if(m){s=k.getParent().getId();q.sap.log.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+s);}if(k&&this._oSectionInfo[s]){o.setSelectedButton(this._oSectionInfo[s].buttonId);this.setAssociation("selectedSection",a._getClosestSection(s).getId(),true);this._setSectionsFocusValues(s);}}};
i.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};
i.prototype._onUpdateContentSize=function(E){var s;if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(this._hasDynamicTitle()){this._adjustHeaderHeights();}this._requestAdjustLayout().then(function(){s=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(s);}.bind(this));};
i.prototype._onUpdateScreenSize=function(E){var t=this.getHeaderTitle(),H=this._getHeaderContent(),k=E.size.width,m=E.size.height,o=E.oldSize.height,n=(m!==o),s,I=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){q.sap.log.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){q.sap.log.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();q.sap.delayedCall(this._getDOMCalculationDelay(),this,function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(I&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._scrollTo(0,0);}if(t&&t.isDynamic()){t._onResize(k);this._updateMedia(k);}this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}s=this.getSelectedSection();if((o===0)&&n&&!this._isClosestScrolledSection(s)){this.scrollToSection(s,0);}this._scrollTo(this._$opWrapper.scrollTop(),0);if((o===0)&&n&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}});};
i.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){q.sap.log.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){q.sap.log.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};
i.prototype._shouldSnapHeaderOnScroll=function(s){return(s>0)&&(s>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};
i.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};
i.prototype._isContentScrolledToBottom=function(){return this._oLastScrollState.iScrollableContentLength<=(this._oLastScrollState.iScrollTop+this._oLastScrollState.iScrollableViewportHeight);};
i.prototype._isContentLengthDecreased=function(p){if(p){return((p.iScrollableContentLength>this._oLastScrollState.iScrollableContentLength)&&(p.iSpacerHeight===this._oLastScrollState.iSpacerHeight));}};
i.prototype._canReachScrollTop=function(r,E){var k;E=E||0;k=this._oLastScrollState.iScrollableContentLength+E-this._oLastScrollState.iScrollableViewportHeight;return k>=r;};
i.prototype._onScroll=function(E){var s=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],k=this._$spacer.length&&this._$spacer[0],m=k.offsetHeight,p,H=this.getHeaderTitle(),n=this._shouldSnapHeaderOnScroll(s),o=this._shouldPreserveHeaderInTitleArea(),r=false,P=this._oLastScrollState,t=P?(P.iScrollTop-s):0;this._oLastScrollState={iScrollTop:s,iScrollableContentLength:this._getScrollableContentLength(),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:m};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!k){return;}p=this.iScreenHeight;if(p===0){return;}if(this._getSectionInfoIsDirty()){return;}if(P&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(P)){var u=P.iScrollableContentLength-this._oLastScrollState.iScrollableContentLength;if(!this._canReachScrollTop(P.iScrollTop)&&this._canReachScrollTop(P.iScrollTop,u)){var N=m+u;this._$spacer.height(N+"px");this._scrollTo($.scrollTop+t);return;}}if(n&&!o){p-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!o){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!o&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(n,!!(E&&E.type==="scroll"));}if(!o){this._adjustHeaderTitleBackgroundPosition(s);}q.sap.log.debug("ObjectPageLayout :: lazy loading : Scrolling at "+s,"----------------------------------------");this._updateSelectionOnScroll(s);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(s,E.timeStamp,p);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(s===0){q.sap.byId(this.getId()+"-scroll").css("z-index","1000");r=false;}else if(!r){r=true;q.sap.byId(this.getId()+"-scroll").css("z-index","0");}}};
i.prototype._updateSelectionOnScroll=function(s){var p=this.iScreenHeight,k,m;if(p===0){return;}k=this._getClosestScrolledSectionId(s,p);m=this._getClosestScrolledSectionId(s,p,true);if(k){var n=this.getDirectScrollingToSection();if(k!==this._sScrolledSectionId){q.sap.log.debug("ObjectPageLayout :: closest id "+k,"----------------------------------------");var n=this.getDirectScrollingToSection();if(n&&n!==k){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(k);}else if(k===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(m!==this._sScrolledSubSectionId){this._sScrolledSubSectionId=m;this.fireEvent("_sectionChange",{section:this.oCore.byId(k),subSection:this.oCore.byId(m)});}}};
i.prototype._getSnapPosition=function(){var s=this.iHeaderContentHeight,t=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;if(t<i.MAX_SNAP_POSITION_OFFSET){s-=t;}return s;};
i.prototype._getClosestScrolledSectionId=function(s,p,k){k=!!k;s=Math.ceil(s);if(this.getUseIconTabBar()&&this._oCurrentTabSection){return this._oCurrentTabSection.getId();}var m=s+p,n,t=k||this._bMobileScenario;q.each(this._oSectionInfo,function(I,o){var r,u,v;r=this.oCore.byId(I);if(!r){return;}u=r.getParent();v=u instanceof a&&u._getIsHidden();if(o.isSection||(t&&!v)){if(!n&&(o.sectionReference._getInternalVisible()===true)){if(o.isSection&&k){n=this._getFirstVisibleSubSection(o.sectionReference).getId();}else{n=I;}}if(o.isSection&&k){return true;}if(o.positionTop<=m&&s<=o.positionBottom){if(o.positionTop<=s&&o.positionBottom>s){n=I;return false;}}}}.bind(this));return n;};
i.prototype._toggleHeader=function(s,u){var H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!s,u);}if(!this._bStickyAnchorBar&&s){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!s){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(j(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}}};
i.prototype._restoreFocusAfter=function(m){var o=this.oCore.byId(this.oCore.getCurrentFocusedControlId());m.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){o&&o.$().focus();}}return this;};
i.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};
i.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._toggleHeaderStyleRules(false);}return this;};
i.prototype._toggleHeaderStyleRules=function(s){s=!!s;var v=s?"hidden":"inherit";this._bStickyAnchorBar=s;this._$headerContent.css("overflow",v);this._$headerContent.toggleClass("sapContrastPlus",!s);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",s);this._$anchorBar.css("visibility",v);this._$anchorBar.toggleClass("sapUxAPObjectPageNavigationHidden",s);this.fireToggleAnchorBar({fixed:s});};
i.prototype.getScrollDelegate=function(){return this._oScroller;};
i.prototype.setHeaderTitle=function(H,s){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)});}this.setAggregation("headerTitle",H,s);if(H){this._createHeaderContent();}return this;};
i.prototype.invalidate=function(o){if(this.getUseIconTabBar()&&o&&(o instanceof a)&&!o.isActive()){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}C.prototype.invalidate.apply(this,arguments);};
i.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),o=this.getAggregation("_headerContent"),n;var k=H?H.getCompatibleHeaderContentClass():c;if(!(o instanceof k)){var n=k.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable());this.setAggregation("_headerContent",n,true);}};
i.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};
i.prototype._adjustHeaderTitleBackgroundPosition=function(s){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-s)+"px");}}}};
i.prototype._adjustHeaderHeights=function(){var t=this.getHeaderTitle(),p=true;if(t&&!t.supportsAdaptLayoutForDomElement()){p=false;}if(this._$headerTitle.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.ceil(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.height():this._$anchorBar.height();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$headerTitle.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(p);}else{this.iHeaderTitleHeight=this._$headerTitle.is(":visible")?this._$headerTitle.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(p);}this._adjustHeaderBackgroundSize();q.sap.log.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{q.sap.log.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};
i.prototype._appendTitleCloneToDOM=function(E){var $=this._$headerTitle.clone();$.css({position:"absolute"});$.css({left:"-10000px",top:"-10000px",width:this._$headerTitle.width()+"px"});$.toggleClass("sapUxAPObjectPageHeaderStickied",E);$.appendTo(this._$headerTitle.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptLayoutForDomElement($);}return $;};
i.prototype._obtainSnappedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(v){this._$opWrapper.css("overflow-y","hidden");$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();this._$opWrapper.css("overflow-y","auto");}else if(t&&t.snap){t.snap(false);H=t.$().outerHeight();t.unSnap(false);}return H;};
i.prototype._obtainExpandedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(v){this._$opWrapper.css("overflow-y","hidden");$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();this._$opWrapper.css("overflow-y","auto");}else if(t&&t.unSnap){t.unSnap(false);H=t.$().outerHeight();t.snap(false);}return H;};
i.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),s=l.ObjectPageHeaderDesign.Light;if(H!=null){s=H.getHeaderDesign();}return s;};
i.prototype._getVisibleSections=function(){return this.getSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};
i.prototype._setSectionsFocusValues=function(s){var k=this._getVisibleSections()||[],$,F='0',n='-1',t="tabIndex",o,m=k[0];k.forEach(function(p){$=p.$();if(s===p.sId){$.attr(t,F);o=p;p._setSubSectionsFocusValues();}else{$.attr(t,n);p._disableSubSectionsFocus();}});if(!o&&k.length>0){m.$().attr(t,F);m._setSubSectionsFocusValues();o=m;}return o;};
i.prototype.setShowHeaderContent=function(s){var o=this.getShowHeaderContent(),H;if(o!==s){if(o&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",s);H=this._getHeaderContent();if(H){H.setProperty("visible",s);}}return this;};
i.prototype._headerTitleChangeHandler=function(I){var r;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}r=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(r,this);this._getHeaderContent().invalidate();r.destroy();};
i.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};
i.prototype.insertHeaderContent=function(o,I,s){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",o,I,s);}return this._getHeaderContent().insertAggregation("content",o,I,s);};
i.prototype.addHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.addAggregation("headerContent",o,s);}return this._getHeaderContent().addAggregation("content",o,s);};
i.prototype.removeAllHeaderContent=function(s){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",s);}return this._getHeaderContent().removeAllAggregation("content",s);};
i.prototype.removeHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",o,s);}return this._getHeaderContent().removeAggregation("content",o,s);};
i.prototype.destroyHeaderContent=function(s){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",s);}return this._getHeaderContent().destroyAggregation("content",s);};
i.prototype.indexOfHeaderContent=function(o){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",o);}return this._getHeaderContent().indexOfAggregation("content",o);};
i.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};
i.prototype._connectModelsForSections=function(s){s=s||[];s.forEach(function(o){o.connectToModels();});};
i.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};
i.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};
i.prototype._shiftHeaderTitle=function(){var s=this._calculateShiftOffset(),k=s.sStyleAttribute,p=s.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+k,p+"px");};
i.prototype._isFirstSection=function(s){var k=this._getVisibleSections();if(s===k[0]){return true;}return false;};
i.prototype._isPositionWithinSection=function(s,o){if(!o||!this._bDomReady||!this._oSectionInfo[o.getId()]){return;}var k=this._computeScrollPosition(o),m=q(o.getDomRef()).height(),n=k+m;return((s>=k)&&(s<n));};
i.prototype._restoreScrollPosition=function(){var s=this.oCore.byId(this._sStoredScrolledSubSectionId);if(!s){return;}if(this._isPositionWithinSection(this._iStoredScrollPosition,s)){this._scrollTo(this._iStoredScrollPosition,0);}else{this.scrollToSection(s.getId(),0);}};
i.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady){return;}this._iStoredScrollPosition=this._oScroller.getScrollTop();this._sStoredScrolledSubSectionId=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true);this._oCurrentTabSection=null;};
i.prototype.onkeyup=function(E){var F,o;if(E.which===q.sap.KeyCodes.TAB){F=this.oCore.getCurrentFocusedControlId();o=F&&this.oCore.byId(F);if(o&&this._isFirstSection(o)){this._scrollTo(0,0);}}};
i.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};
i.prototype._toggleFooter=function(s){var u=this.oCore.getConfiguration().getAnimation(),F=this.getFooter();if(!j(F)){return;}F.toggleStyleClass("sapUxAPObjectPageFloatingFooterShow",s);F.toggleStyleClass("sapUxAPObjectPageFloatingFooterHide",!s);if(this._iFooterWrapperHideTimeout){q.sap.clearDelayedCall(this._iFooterWrapperHideTimeout);}if(u){if(!s){this._iFooterWrapperHideTimeout=q.sap.delayedCall(i.FOOTER_ANIMATION_DURATION,this,function(){this.$("footerWrapper").toggleClass("sapUiHidden",!s);});}else{this.$("footerWrapper").toggleClass("sapUiHidden",!s);this._iFooterWrapperHideTimeout=null;}q.sap.delayedCall(i.FOOTER_ANIMATION_DURATION,this,function(){F.removeStyleClass("sapUxAPObjectPageFloatingFooterShow");});}this._requestAdjustLayout();};
i.prototype.clone=function(){var o,H;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);o=C.prototype.clone.apply(this,arguments);H=this._getHeaderContent();o.setAggregation("_headerContent",H.clone(),true);return o;};
i.prototype._cloneProxiedAggregations=function(s){var o=this.mAggregations[s];if(Array.isArray(o)&&o.length===0){o=this["get"+s.charAt(0).toUpperCase()+s.slice(1)]();}this.mAggregations[s]=o;};
i.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};
i.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};
i.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};
i.prototype._headerBiggerThanAllowedToBeFixed=function(){var k=this._getOwnHeight();return this._getEntireHeaderHeight()>i.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*k;};
i.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};
i.prototype._getOwnHeight=function(){return this._getHeight(this);};
i.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};
i.prototype._getEntireHeaderHeight=function(){var t=0,H=0,o=this.getHeaderTitle(),k=this._getHeaderContent();if(j(o)){t=o.$().outerHeight();}if(j(k)){H=k.$().outerHeight();}return t+H;};
i.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();}};
i.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(j($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}if(j(this._$stickyAnchorBar)){this._$stickyAnchorBar.addClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}};
i.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(j($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};
i.prototype._togglePinButtonARIAState=function(p){var H=this._getHeaderContent();if(j(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(p);}};
i.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};
i.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};
i.prototype._hasDynamicTitle=function(){var t=this.getHeaderTitle();return t&&t.isDynamic();};
i.prototype._attachVisualIndicatorsPressHandlers=function(p,o){var t=this.getHeaderTitle(),H=this._getHeaderContent();if(j(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(i.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){p.call(o);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(j(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(i.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){p.call(o);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};
i.prototype._updateToggleHeaderVisualIndicators=function(){var H,k,E;if(!this.getToggleHeaderOnTitleClick()){k=false;E=false;}else{H=this._bHeaderExpanded;k=H;E=!H;}this._toggleCollapseVisualIndicator(k);this._toggleExpandVisualIndicator(E);};
i.prototype._focusCollapseVisualIndicator=function(){var o=this._getHeaderContent();if(j(o)){o._focusCollapseButton();}};
i.prototype._focusExpandVisualIndicator=function(){var o=this.getHeaderTitle();if(j(o)){o._focusExpandButton();}};
i.prototype._toggleExpandVisualIndicator=function(t){var o=this.getHeaderTitle();if(j(o)){o._toggleExpandButton(t);}};
i.prototype._toggleCollapseVisualIndicator=function(t){var o=this._getHeaderContent();if(j(o)){o._toggleCollapseButton(t);}};
i.prototype._attachVisualIndicatorMouseOverHandlers=function(o,k,m){var H=this._getHeaderContent();if(j(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(i.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,o,m);H.attachEvent(i.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,k,m);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};
i.prototype._attachTitleMouseOverHandlers=function(o,k,m){var t=this.getHeaderTitle();if(j(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(i.EVENTS.TITLE_MOUSE_OVER,o,m);t.attachEvent(i.EVENTS.TITLE_MOUSE_OUT,k,m);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};
i.prototype._suppressScroll=function(){this._bSuppressScroll=true;};
i.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollPosition){this._scrollTo(this._iStoredScrollPosition,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};
i.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
i.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
i.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};
i.prototype._getWidth=function(o){return!(o instanceof C)?0:o.$().outerWidth()||0;};
i.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};
i.prototype._setSectionInfoIsDirty=function(k){this.bSectionInfoIsDirty=k;};
i.prototype._getRootAriaLabelText=function(){var H=this.getHeaderTitle(),t=H?H.getTitleText():null,s;if(H&&t){s=i._getLibraryResourceBundle().getText("ROOT_ARIA_LABEL_WITH_TITLE")+" "+t;}else{s=i._getLibraryResourceBundle().getText("ROOT_ARIA_LABEL_WITHOUT_TITLE");}return s;};
i.prototype._getDOMRefHeight=function(o){return o.parentElement?o.getBoundingClientRect().height:0;};
i.prototype._updateRootAriaLabel=function(){var n=this._getRootAriaLabelText(),s=this.$().attr("aria-label");if(n!==s){this.$().attr("aria-label",n);}};
function j(o){if(arguments.length===1){return Array.isArray(o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(k){return j(k);});}
return i;});
sap.ui.predefine('sap/uxap/ObjectPageLayoutABHelper',["jquery.sap.global","sap/ui/base/Metadata","sap/ui/core/CustomData","sap/ui/base/ManagedObjectObserver","./AnchorBar","sap/m/Button","sap/ui/core/IconPool"],function(q,M,C,a,A,B,I){"use strict";var b=M.createClass("sap.uxap._helpers.AB",{constructor:function(o){this._oObjectPageLayout=o;this._iScrollDuration=o._iScrollToSectionDuration;this._oObserver=new a(this._proxyStateChanges.bind(this));}});
b.prototype.getObjectPageLayout=function(){return this._oObjectPageLayout;};
b.prototype._proxyStateChanges=function(o){var O=o.object,d=this._findExistingClone(O),p=o.name,v=o.current,s="set"+c(p);if(d){d[s].call(d,v);}};
b.prototype._findExistingClone=function(o){var d,s=o.getId()+"-__clone",e=this._getAnchorBar(),f=e.getContent();f.some(function(g){if(g.getId().indexOf(s)===0){d=g;return true;}});return d;};
b.prototype._getAnchorBar=function(){var o=this.getObjectPageLayout().getAggregation("_anchorBar");if(!o){o=new A({id:this.getObjectPageLayout().getId()+"-anchBar",showPopover:this.getObjectPageLayout().getShowAnchorBarPopover()});this.getObjectPageLayout().setAggregation("_anchorBar",o,true);}return o;};
b.prototype._buildAnchorBar=function(){var s=this.getObjectPageLayout().getSections()||[],o=this._getAnchorBar();if(o&&this.getObjectPageLayout().getShowAnchorBar()){o._resetControl();this._oObserver.disconnect();s.forEach(function(S){if(!S.getVisible()||!S._getInternalVisible()){return;}var d,e=S.getSubSections()||[];d=this._buildAnchorBarButton(S,true);if(d){o.addContent(d);e.forEach(function(f){if(!f.getVisible()||!f._getInternalVisible()){return;}var g=this._buildAnchorBarButton(f,false);if(g){o.addContent(g);}},this);}},this);}};
b.prototype._focusOnSectionWhenUsingKeyboard=function(e){var s=e.srcControl.data(),S=sap.ui.getCore().byId(s.sectionId),o=this.getObjectPageLayout();if(S&&!s.bHasSubMenu&&!o.getUseIconTabBar()){q.sap.delayedCall(this._iScrollDuration,S.$(),"focus");}};
b.prototype._buildAnchorBarButton=function(s,i){var o=null,O=this.getObjectPageLayout(),d,e=this._getAnchorBar(),f,S=s.getAggregation("subSections"),g=this._focusOnSectionWhenUsingKeyboard.bind(this),E={onsapenter:g,onsapspace:g};if(s.getVisible()&&s._getInternalVisible()){d=s.getCustomAnchorBarButton();if(!d){f=e.getId()+"-"+s.getId()+"-anchor";o=new B({ariaDescribedBy:s,id:f});o.addEventDelegate(E);var t=(s._getInternalTitle()!="")?s._getInternalTitle():s.getTitle();o.setText(t);}else{o=d.clone();this._oObserver.observe(d,{properties:true});}O._oSectionInfo[s.getId()].buttonId=o.getId();o.addCustomData(new C({key:"sectionId",value:s.getId()}));o.addCustomData(new C({key:"bTitleVisible",value:s._getInternalTitleVisible()}));if(!i){o.addCustomData(new C({key:"secondLevel",value:true}));}if(S&&S.length>1){var v=S.filter(function(h){return h.getVisible();}).length;if(v>1){o.addCustomData(new C({key:"bHasSubMenu",value:true}));if(e.getShowPopover()){o.setIcon(I.getIconURI("slim-arrow-down"));o.setIconFirst(false);}}}}return o;};
function c(n){return n.substring(0,1).toUpperCase()+n.substring(1);}
return b;},false);
sap.ui.predefine('sap/uxap/ObjectPageLayoutRenderer',["sap/ui/Device"],function(D){"use strict";var O={};
O.render=function(r,c){var s,h=c.getHeaderTitle(),a=null,i=c.getHeaderContent()&&c.getHeaderContent().length>0&&c.getShowHeaderContent(),I=c.getShowTitleInHeaderContent()&&c.getShowHeaderContent(),R=i||I,u=c.getUseIconTabBar(),t=c.getToggleHeaderOnTitleClick()&&c.getHeaderTitle()&&c.getHeaderTitle().supportsToggleHeaderOnTitleClick(),b=c._getRootAriaLabelText();if(c.getShowAnchorBar()&&c._getInternalAnchorBarVisible()){a=c.getAggregation("_anchorBar");}r.write("<div");r.writeControlData(c);r.writeAttribute("role","region");r.writeAttributeEscaped("aria-label",b);r.addClass("sapUxAPObjectPageLayout");if(t){r.addClass("sapUxAPObjectPageLayoutTitleClickEnabled");}if(a){r.addClass("sapUxAPObjectPageLayoutWithNavigation");}r.writeClasses();r.addStyle("height",c.getHeight());r.writeStyles();r.write(">");if(D.system.desktop){r.renderControl(c._getCustomScrollBar().addStyleClass("sapUxAPObjectPageCustomScroller"));}r.write("<header ");r.writeAttribute("role","banner");r.writeAttributeEscaped("id",c.getId()+"-headerTitle");r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.addClass("sapUxAPObjectPageHeaderTitle");r.addClass("sapContrastPlus");r.writeClasses();r.write(">");if(h){r.renderControl(h);}this._renderHeaderContentDOM(r,c,R&&c._bHeaderInTitleArea,"-stickyHeaderContent");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-stickyAnchorBar");r.addClass("sapUxAPObjectPageStickyAnchorBar");r.addClass("sapUxAPObjectPageNavigation");r.writeClasses();r.write(">");this._renderAnchorBar(r,c,a,c._bHeaderInTitleArea);r.write("</div>");r.write("</header>");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-opwrapper");r.addClass("sapUxAPObjectPageWrapper");if(h&&!h.supportsTitleInHeaderContent()||!(c.getShowTitleInHeaderContent()&&h.getShowTitleSelector())){r.addClass("sapUxAPObjectPageWrapperTransform");}r.writeClasses();r.write(">");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-scroll");r.addClass("sapUxAPObjectPageScroll");r.writeClasses();r.write(">");this._renderHeaderContentDOM(r,c,R&&!c._bHeaderInTitleArea,"-headerContent",true);r.write("<section ");r.writeAttributeEscaped("id",c.getId()+"-anchorBar");r.writeAttribute("role","navigation");r.addClass("sapUxAPObjectPageNavigation");r.addClass("sapContrastPlus");r.writeClasses();r.write(">");this._renderAnchorBar(r,c,a,!c._bHeaderInTitleArea);r.write("</section>");r.write("<section");r.addClass("sapUxAPObjectPageContainer");r.writeAttributeEscaped("id",c.getId()+"-sectionsContainer");r.addClass("ui-helper-clearfix");if(!a){r.addClass("sapUxAPObjectPageContainerNoBar");}r.writeClasses();r.write(">");s=c._getSectionsToRender();if(jQuery.isArray(s)){jQuery.each(s,function(d,S){r.renderControl(S);if(u){c._oCurrentTabSection=S;}});}r.write("</section>");this.renderFooterContent(r,c);r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-spacer");r.write("></div>");r.write("</div>");r.write("</div>");this._renderFooterContentInternal(r,c);r.write("</div>");};
O._renderAnchorBar=function(r,c,a,R){var s=c.getAggregation("sections"),h;if(R){h=c._getHeaderContent();if(c.getIsChildPage()&&h&&h.supportsChildPageDesign()){r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-childPageBar");if(jQuery.isArray(s)&&s.length>1){r.addClass('sapUxAPObjectChildPage');}r.writeClasses();r.write("></div>");}if(a){r.renderControl(a);}}};
O._renderHeaderContentDOM=function(r,c,R,i,a){r.write("<header ");r.writeAttributeEscaped("id",c.getId()+i);r.addClass("ui-helper-clearfix");r.addClass("sapUxAPObjectPageHeaderDetails");r.addClass("sapUxAPObjectPageHeaderDetailsDesign-"+c._getHeaderDesign());if(a){r.addClass("sapContrastPlus");}r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");if(R){this.renderHeaderContent(r,c);}r.write("</header>");};
O.renderHeaderContent=function(r,c){r.renderControl(c._getHeaderContent());};
O.renderFooterContent=function(r,c){};
O._renderFooterContentInternal=function(r,o){var f=o.getFooter();if(!f){return;}r.write("<footer");r.writeAttributeEscaped("id",o.getId()+"-footerWrapper");r.addClass("sapUxAPObjectPageFooter sapMFooter-CTX sapContrast sapContrastPlus");if(!o.getShowFooter()){r.addClass("sapUiHidden");}r.writeClasses();r.write(">");f.addStyleClass("sapUxAPObjectPageFloatingFooter");r.renderControl(f);r.write("</footer>");};
O._rerenderHeaderContentArea=function(r,c){var h=c._bHeaderInTitleArea?"stickyHeaderContent":"headerContent",$;this.renderHeaderContent(r,c);$=c.$(h)[0];if($){r.flush($);}};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageLazyLoader',['jquery.sap.global','./library','sap/ui/core/Element','sap/ui/core/StashedControlSupport'],function(q,l,E,S){"use strict";
var L=E.extend("sap.uxap.ObjectPageLazyLoader",{metadata:{library:"sap.uxap",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},defaultAggregation:"content"}});
S.mixInto(L);
L.prototype.setParent=function(p){if(!(p===null||p instanceof sap.uxap.ObjectPageSubSection)){}return E.prototype.setParent.apply(this,arguments);};
return L;});
sap.ui.predefine('sap/uxap/ObjectPageSection',["sap/ui/core/InvisibleText","./ObjectPageSectionBase","sap/ui/Device","sap/m/Button","sap/ui/core/StashedControlSupport","./ObjectPageSubSection","./library","sap/m/library","./ObjectPageSectionRenderer"],function(I,O,D,B,S,a,l,m,b){"use strict";var c=m.ButtonType;
var d=O.extend("sap.uxap.ObjectPageSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"subSections",aggregations:{subSections:{type:"sap.uxap.ObjectPageSubSection",multiple:true,singularName:"subSection"},ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_showHideAllButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_showHideButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{selectedSubSection:{type:"sap.uxap.ObjectPageSubSection",multiple:false}},designtime:"sap/uxap/designtime/ObjectPageSection.designtime"}});
d.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;
d._getClosestSection=function(s){var o=(typeof s==="string"&&sap.ui.getCore().byId(s))||s;return(o instanceof a)?o.getParent():o;};
d._getLibraryResourceBundle=function(){return l.i18nModel.getResourceBundle();};
d.prototype._expandSection=function(){O.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections());};
d.prototype.init=function(){O.prototype.init.call(this);this._sContainerSelector=".sapUxAPObjectPageSectionContainer";};
d.prototype.exit=function(){this._detachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype.setTitle=function(v){O.prototype.setTitle.call(this,v);var A=this.getAggregation("ariaLabelledBy");if(A){sap.ui.getCore().byId(A.getId()).setText(v);}};
d.prototype._getImportanceLevelToHide=function(C){var o=this._getObjectPageLayout(),M=C||this._getCurrentMediaContainerRange(),s=o&&o.getShowOnlyHighImportance();return this._determineTheLowestLevelOfImportanceToShow(M.name,s);};
d.prototype._updateImportance=function(C){var o=this._getObjectPageLayout(),i=this._getImportanceLevelToHide(C);this.getSubSections().forEach(function(s){s._applyImportanceRules(i);});this._applyImportanceRules(i);this._updateShowHideAllButton(false);if(o&&this.getDomRef()){o._requestAdjustLayout();}};
d.prototype._determineTheLowestLevelOfImportanceToShow=function(M,s){if(s||M==="Phone"){return l.Importance.High;}if(M==="Tablet"){return l.Importance.Medium;}return l.Importance.Low;};
d.prototype.connectToModels=function(){this.getSubSections().forEach(function(s){s.connectToModels();});};
d.prototype._allowPropagationToLoadedViews=function(A){this.getSubSections().forEach(function(s){s._allowPropagationToLoadedViews(A);});};
d.prototype.onBeforeRendering=function(){var A="ariaLabelledBy";if(!this.getAggregation(A)){this.setAggregation(A,this._getAriaLabelledBy(),true);}this._detachMediaContainerWidthChange(this._updateImportance,this);this._updateImportance();};
d.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype._getAriaLabelledBy=function(){return new I({text:this._getTitle()}).toStatic();};
d.prototype._isTitleVisible=function(){return this.getShowTitle()&&this._getInternalTitleVisible();};
d.prototype._setSubSectionsFocusValues=function(){var s=this.getSubSections()||[],L=this.getSelectedSubSection(),p;if(s.length===0){return this;}if(s.length===1){s[0]._setToFocusable(false);return this;}s.forEach(function(o){if(L===o.sId){o._setToFocusable(true);p=true;}else{o._setToFocusable(false);}});if(!p){s[0]._setToFocusable(true);}return this;};
d.prototype._disableSubSectionsFocus=function(){var s=this.getSubSections()||[];s.forEach(function(o){o._setToFocusable(false);});return this;};
d.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(s){return s._getIsHidden();});};
d.prototype._updateShowHideSubSections=function(h){this.getSubSections().forEach(function(s){if(h&&s._shouldBeHidden()){s._updateShowHideState(true);}else if(!h){s._updateShowHideState(false);}});};
d.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(s){return s._shouldBeHidden();});};
d.prototype._showHideContentAllContent=function(){var s=this._thereAreHiddenSubSections();if(this._getIsHidden()&&s){this._updateShowHideState(false);}this._updateShowHideSubSections(!s);this._updateShowHideAllButton(s);};
d.prototype._updateShowHideState=function(h){this._updateShowHideButton(h);this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());return O.prototype._updateShowHideState.call(this,h);};
d.prototype._updateShowHideAllButton=function(h){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(h));};
d.prototype._getShowHideAllButton=function(){if(!this.getAggregation("_showHideAllButton")){this.setAggregation("_showHideAllButton",new B({visible:this._getShouldDisplayShowHideAllButton(),text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideAllButton");};
d.prototype._getShowHideButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE":"SHOW");};
d.prototype._getShowHideAllButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE_ALL":"SHOW_ALL");};
d.prototype._updateShowHideButton=function(h){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!h));};
d.prototype._getShowHideButton=function(){if(!this.getAggregation("_showHideButton")){this.setAggregation("_showHideButton",new B({visible:this._shouldBeHidden(),text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideButton");};
S.mixInto(d);return d;});
sap.ui.predefine('sap/uxap/ObjectPageSectionBase',["jquery.sap.global","sap/ui/core/Control","sap/ui/core/library","./library","jquery.sap.keycodes"],function(q,C,c,l){"use strict";var T=c.TitleLevel;
var O=C.extend("sap.uxap.ObjectPageSectionBase",{metadata:{"abstract":true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:T.Auto},visible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},aggregations:{customAnchorBarButton:{type:"sap.m.Button",multiple:false}}}});
O.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._sInternalTitleLevel=T.Auto;this._isHidden=false;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();};
O.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){q.sap.log.debug("ObjectPageSectionBase :: cannot adjustLayout",this);});this._getObjectPageLayout()._setSectionsFocusValues();}};
O.prototype.setCustomAnchorBarButton=function(b){var r=this.setAggregation("customAnchorBarButton",b,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation();}return r;};
O.prototype._setInternalVisible=function(v,i){if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalVisible=function(){return this._bInternalVisible;};
O.prototype._setInternalTitleVisible=function(v,i){if(v!=this._bInternalTitleVisible){this._bInternalTitleVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible;};
O.prototype._setInternalTitle=function(v,i){if(v!=this._sInternalTitle){this._sInternalTitle=v;if(i){this.invalidate();}}};
O.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle();};
O.prototype._getInternalTitle=function(){return this._sInternalTitle;};
O.prototype._getARIALevel=function(){return this._getTitleLevel().slice(-1);};
O.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return(t===T.Auto)?this._getInternalTitleLevel():t;};
O.prototype._setInternalTitleLevel=function(t){this._sInternalTitleLevel=t;};
O.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel;};
O.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
O.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules();}};
["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(m){O.prototype[m]=function(a,o,i,s){if(["addAggregation","removeAggregation"].indexOf(m)>-1){s=i;}if(["removeAllAggregation","destroyAggregation"].indexOf(m)>-1){s=o;}var r=C.prototype[m].apply(this,arguments);if(s!==true){this._notifyObjectPageLayout();}return r;};});
O.prototype.setVisible=function(v,s){if(!this._getObjectPageLayout()){return this.setProperty("visible",v,s);}this.setProperty("visible",v,true);this._notifyObjectPageLayout();this.invalidate();return this;};
O.prototype.setTitle=function(v,s){this.setProperty("title",v,s);this._notifyObjectPageLayout();return this;};
O.prototype._shouldBeHidden=function(){return O._importanceMap[this.getImportance()]>O._importanceMap[this._sCurrentLowestImportanceLevelToShow];};
O._importanceMap={"Low":3,"Medium":2,"High":1};
O.prototype._updateShowHideState=function(h){var o=this._getObjectPageLayout();this._isHidden=h;this.$().children(this._sContainerSelector).toggle(!h);if(o){o._requestAdjustLayout();}return this;};
O.prototype._getIsHidden=function(){return this._isHidden;};
O.prototype._expandSection=function(){return this._updateShowHideState(false);};
O.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden());};
O.prototype._applyImportanceRules=function(s){this._sCurrentLowestImportanceLevelToShow=s;if(this.getDomRef()){this._updateShowHideState(this._shouldBeHidden());}else{this._isHidden=this._shouldBeHidden();}};
O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
O.prototype.onkeydown=function(e){if(e.keyCode===q.sap.KeyCodes.F7){var s=this.getSubSections(),f=s[0],L;if(s.length===1){L=f._oLastFocusedControlF7;if(L){L.$().focus();}else{f.$().firstFocusableDomRef().focus();}}else{if(f.getActions().length){f.getActions()[0].$().focus();}}}};
O.prototype.onsapdown=function(e){this._handleFocusing(e,e.currentTarget.nextSibling);};
O.prototype._handleFocusing=function(e,E){if(this._targetIsCorrect(e)&&E){e.preventDefault();E.focus();this._scrollParent(q(E).attr("id"));}};
O.prototype._targetIsCorrect=function(e){return e.srcControl===this;};
O.prototype.onsapright=function(e){var m=this._bRtl?"onsapup":"onsapdown";this[m](e);};
O.prototype.onsapup=function(e){this._handleFocusing(e,e.currentTarget.previousSibling);};
O.prototype.onsapleft=function(e){var m=this._bRtl?"onsapdown":"onsapup";this[m](e);};
O.prototype.onsaphome=function(e){this._handleFocusing(e,e.currentTarget.parentElement.firstChild);};
O.prototype.onsapend=function(e){this._handleFocusing(e,e.currentTarget.parentElement.lastChild);};
O.prototype.onsappageup=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S-(O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[0]){s[0].focus();f=q(s[0]).attr("id");}this._scrollParent(f);};
O.prototype.onsappagedown=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S+O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[s.length-1]){s[s.length-1].focus();f=q(s[s.length-1]).attr("id");}this._scrollParent(f);};
O.prototype._scrollParent=function(i){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(i,0,10);}};
return O;});
sap.ui.predefine('sap/uxap/ObjectPageSectionRenderer',function(){"use strict";var O={};
O.render=function(r,c){var t,T,a=sap.ui.getCore().getConfiguration().getAccessibility();if(!c.getVisible()||!c._getInternalVisible()){return;}t=c._getTitle();T=c._isTitleVisible();r.write("<section ");r.addClass("sapUxAPObjectPageSection");if(!T){r.addClass("sapUxAPObjectPageSectionNoTitle");}r.writeClasses();r.writeAttribute("role","region");if(a){if(t){r.writeAttributeEscaped("aria-labelledby",c.getAggregation("ariaLabelledBy").getId());}else{r.writeAttribute("aria-label",sap.uxap.ObjectPageSection._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME"));}}r.writeControlData(c);r.write(">");if(T){r.write("<div");r.writeAttribute("role","heading");r.writeAttribute("aria-level",c._getARIALevel());r.writeAttributeEscaped("id",c.getId()+"-header");r.addClass("sapUxAPObjectPageSectionHeader");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-title");r.addClass("sapUxAPObjectPageSectionTitle");if(c.getTitleUppercase()){r.addClass("sapUxAPObjectPageSectionTitleUppercase");}r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div>");r.renderControl(c._getShowHideAllButton());r.renderControl(c._getShowHideButton());r.write("</div>");}r.write("<div");r.addClass("sapUxAPObjectPageSectionContainer");r.writeClasses();if(c._isHidden){r.addStyle("display","none");}r.writeStyles();r.write(">");c.getSubSections().forEach(r.renderControl);r.write("</div>");r.write("</section>");};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageSubSection',["jquery.sap.global","sap/ui/layout/Grid","sap/ui/layout/GridData","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/Device","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","./library","sap/m/library","./ObjectPageSubSectionRenderer","jquery.sap.keycodes"],function(q,G,a,O,b,B,c,D,S,d,l,m,e){"use strict";var f=m.ButtonType;var g=l.ObjectPageSubSectionMode;var h=l.ObjectPageSubSectionLayout;
var i=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:g.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"}});
i.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;
i._getLibraryResourceBundle=function(){return l.i18nModel.getResourceBundle();};
i.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._oObserver=new d(i.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._attachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._switchSubSectionMode(this.getMode());};
i.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};
i.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);}return this.getAggregation("_grid");};
i.prototype._hasVisibleActions=function(){var A=this.getActions()||[];if(A.length===0){return false;}return A.filter(function(o){return o.getVisible();}).length>0;};
i.prototype._observeChanges=function(C){var o=C.object,s=C.name,M=C.mutation,j=C.child,H;if(o===this){if(s==="actions"){if(M==="insert"){this._observeAction(j);}else if(M==="remove"){this._unobserveAction(j);}}}else if(s==="visible"){H=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!H){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions());}}};
i.prototype._observeAction=function(C){this._oObserver.observe(C,{properties:["visible"]});};
i.prototype._unobserveAction=function(C){this._oObserver.unobserve(C,{properties:["visible"]});};
i.prototype._unStashControls=function(){S.getStashedControls(this.getId()).forEach(function(C){C.setStashed(false);});};
i.prototype.connectToModels=function(){var j=this.getBlocks()||[],M=this.getMoreBlocks()||[],C=this.getMode();this._unStashControls();j.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});if(M.length>0&&C===g.Expanded){M.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});}};
i.prototype._allowPropagationToLoadedViews=function(A){var j=this.getBlocks()||[],M=this.getMoreBlocks()||[];j.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});M.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});};
i.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(A){var o=this.mAggregations[A];if(!o||o.length===0){this.mAggregations[A]=this._aAggregationProxy[A];}},this);return O.prototype.clone.apply(this,arguments);};
i.prototype._cleanProxiedAggregations=function(){var p=this._aAggregationProxy;Object.keys(p).forEach(function(k){p[k].forEach(function(o){o.destroy();});});};
i.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}this._detachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._cleanProxiedAggregations();if(O.prototype.exit){O.prototype.exit.call(this);}};
i.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}this._$spacer=q.sap.byId(o.getId()+"-spacer");};
i.prototype.onBeforeRendering=function(){var o=this._getObjectPageLayout();if(!o){return;}if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(o);this.refreshSeeMoreVisibility();};
i.prototype._applyLayout=function(L){var v,o=this._getGrid(),C=this.getMode(),s=L.getSubSectionLayout(),j=this._calculateLayoutConfiguration(s,L),k=this.getBlocks(),A=k.concat(this.getMoreBlocks());this._oLayoutConfig=j;this._resetLayoutData(A);if(C===g.Expanded){v=A;}else{v=k;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(n){this._setBlockMode(n,C);o.addAggregation("content",n,true);},this);}catch(E){q.sap.log.error("ObjectPageSubSection :: error while building layout "+s+": "+E);}return this;};
i.prototype._calculateLayoutConfiguration=function(L,o){var j={M:2,L:3,XL:4},k=j.L,E=j.XL,t=(L===h.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){k-=1;E-=1;}if(u){k-=1;}j.L=k;j.XL=E;return j;};
i.prototype.refreshSeeMoreVisibility=function(){var j=!!this.getMoreBlocks().length,s=this._getSeeMoreButton(),$=s.$(),k=this.$();if(!j){j=this.getBlocks().some(function(o){if(o instanceof B&&o.getVisible()&&o.getShowSubSectionMore()){return true;}});}if(k.length){k.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore",j);}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",j);if($.length){$.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible",j);}s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",j);return j;};
i.prototype.setMode=function(M){if(this.getMode()!==M){this._switchSubSectionMode(M);if(this._bRenderedFirstTime){this.rerender();}}return this;};
i.prototype.onkeydown=function(E){if(E.keyCode===q.sap.KeyCodes.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof i){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};
i.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().focus();}else{this.getParent().$().focus();}};
i.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().focus();}else{this.$().firstFocusableDomRef().focus();}};
i.prototype._calcBlockColumnLayout=function(j,C){var k=12,v,M,L,X,n;M={iRemaining:C.M,iColumnConfig:C.M};L={iRemaining:C.L,iColumnConfig:C.L};X={iRemaining:C.XL,iColumnConfig:C.XL};n=[X,L,M];v=j.filter(function(o){return o.getVisible&&o.getVisible();});v.forEach(function(o,I){n.forEach(function(p){p.iCalculatedSize=this._calculateBlockSize(o,p.iRemaining,v,I,p.iColumnConfig);},this);o.setLayoutData(new a(o.getId()+"-layoutData",{spanS:k,spanM:M.iCalculatedSize*(k/M.iColumnConfig),spanL:L.iCalculatedSize*(k/L.iColumnConfig),spanXL:X.iCalculatedSize*(k/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));n.forEach(function(p){p.iRemaining-=p.iCalculatedSize;if(p.iRemaining<1){p.iRemaining=p.iColumnConfig;}});},this);return v;};
i.prototype._calculateBlockSize=function(o,r,v,C,M){var j,F=M,k;if(!this._hasAutoLayout(o)){return Math.min(M,parseInt(o.getColumnLayout(),10));}for(k=1;k<=F;k++){j=this._calcLayout(v[C+k]);if(j<r){r-=j;}else{break;}}return r;};
i.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout(),10);}return L;};
i.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};
i.prototype._onDesktopMediaRange=function(C){return this._onMediaRange(C,["LargeDesktop","Desktop"]);};
i.prototype._onTabletMediaRange=function(C){return this._onMediaRange(C,["Tablet"]);};
i.prototype._onPhoneMediaRange=function(C){return this._onMediaRange(C,["Phone"]);};
i.prototype._onMediaRange=function(C,j){var M=C||this._getCurrentMediaContainerRange();return j.indexOf(M.name)>-1;};
i.prototype._synchronizeBlockLayouts=function(C){if(this._getUseTitleOnTheLeft()){this.$("header").toggleClass("titleOnLeftLayout",this._onDesktopMediaRange(C));}this._toggleBlockLayoutResponsiveStyles(C);};
i.prototype._toggleBlockLayoutResponsiveStyles=function(C){this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerDesktop",this._onDesktopMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerTablet",this._onTabletMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerPhone",this._onPhoneMediaRange(C));};
i.prototype._getMediaString=function(C){if(this._onPhoneMediaRange(C)){return"Phone";}if(this._onTabletMediaRange(C)){return"Tablet";}return"Desktop";};
i.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}q.each(this._aAggregationProxy,q.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A,true),true);},this));this._bRenderedFirstTime=true;};
i.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};
i.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};
i.prototype._setAggregation=function(A,v,s){this._aAggregationProxy[A]=v;if(s!==true){this._notifyObjectPageLayout();this.invalidate();}return this._aAggregationProxy[A];};
i.prototype.addAggregation=function(A,o,s){var j;if(o instanceof b){o.getContent().forEach(function(C){this.addAggregation(A,C,true);},this);o.removeAllContent();o.destroy();this.invalidate();return this;}if(this.hasProxy(A)){j=this._getAggregation(A);j.push(o);this._setAggregation(A,j,s);if(o instanceof B||o instanceof b){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};
i.prototype.insertBlock=function(o,I){q.sap.log.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",o);};
i.prototype.insertMoreBlock=function(o,I){q.sap.log.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",o);};
i.prototype.removeAllAggregation=function(A,s){var I;if(this.hasProxy(A)){I=this._getAggregation(A);this._setAggregation(A,[],s);return I.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};
i.prototype.removeAggregation=function(A,o){var r=false,I;if(this.hasProxy(A)){I=this._getAggregation(A);I.forEach(function(j,k){if(j.getId()===o.getId()){I.splice(k,1);this._setAggregation(A,I);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};
i.prototype.indexOfAggregation=function(A,o){var I=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(j,k){if(j.getId()===o.getId()){I=k;return true;}},this);return I;}return O.prototype.indexOfAggregation.apply(this,arguments);};
i.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};
i.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};
i.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new c(this.getId()+"--seeMore",{type:f.Transparent,iconFirst:false,ariaLabelledBy:this.getId()}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};
i.prototype._seeMoreLessControlPressHandler=function(E){var C=this.getMode(),t,M=this.getMoreBlocks()||[];if(C===g.Expanded){t=g.Collapsed;}else{t=g.Expanded;M.forEach(function(o){if(o instanceof B){o.setMode(C);o.connectToModels();}},this);}this._switchSubSectionMode(t);if(this._$spacer.length>0){this._$spacer.height(this._$spacer.height()+this.$().height());}this.rerender();};
i.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===g.Collapsed){this.setProperty("mode",g.Collapsed,true);this._getSeeMoreButton().setText(i._getLibraryResourceBundle().getText("SEE_MORE"));}else{this.setProperty("mode",g.Expanded,true);this._getSeeMoreButton().setText(i._getLibraryResourceBundle().getText("SEE_LESS"));}};
i.prototype._setBlockMode=function(o,M){if(o instanceof B){o.setMode(M);}else{q.sap.log.debug("ObjectPageSubSection :: cannot propagate mode "+M+" to "+o.getMetadata().getName());}};
i.prototype._setToFocusable=function(F){var s='0',n='-1',t="tabIndex";if(F){this.$().attr(t,s);}else{this.$().attr(t,n);}return this;};
i.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o&&(o.getSubSectionLayout()===h.TitleOnLeft);};
i.prototype._resetLayoutData=function(j){j.forEach(function(o){if(o.getLayoutData()){o.destroyLayoutData();}},this);};
i.prototype.getVisibleBlocksCount=function(){var v=S.getStashedControls(this.getId()).length;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(M){if(M.getVisible&&!M.getVisible()){return true;}v++;});return v;};
return i;});
sap.ui.predefine('sap/uxap/ObjectPageSubSectionRenderer',function(){"use strict";var O={};
O.render=function(r,c){var a,h,H,b,u,d,A=sap.ui.getCore().getConfiguration().getAccessibility();if(!c.getVisible()||!c._getInternalVisible()){return;}a=c.getActions()||[];b=a.length>0;h=(c._getInternalTitleVisible()&&(c.getTitle().trim()!==""));H=h||b;d=c._hasVisibleActions();r.write("<div ");r.writeAttribute("role","region");r.writeControlData(c);r.addClass("sapUxAPObjectPageSubSection");r.addClass("ui-helper-clearfix");r.writeClasses(c);r.writeClasses();if(A){if(h){r.writeAttributeEscaped("aria-labelledby",c.getId()+"-headerTitle");}else{r.writeAttribute("aria-label",sap.uxap.ObjectPageSubSection._getLibraryResourceBundle().getText("SUBSECTION_CONTROL_NAME"));}}r.write(">");if(H){r.write("<div");r.addClass("sapUxAPObjectPageSubSectionHeader");if(!h&&!d){r.addClass("sapUiHidden");}u=c._getUseTitleOnTheLeft();if(u&&c._onDesktopMediaRange()){r.addClass("titleOnLeftLayout");}r.writeAttributeEscaped("id",c.getId()+"-header");r.writeClasses();r.write(">");r.write("<div");if(h){r.writeAttribute("role","heading");r.writeAttribute("aria-level",c._getARIALevel());}r.addClass('sapUxAPObjectPageSubSectionHeaderTitle');if(c.getTitleUppercase()){r.addClass("sapUxAPObjectPageSubSectionHeaderTitleUppercase");}r.writeAttributeEscaped("id",c.getId()+"-headerTitle");r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");if(h){r.writeEscaped(c.getTitle());}r.write("</div>");if(b){r.write("<div");r.addClass('sapUxAPObjectPageSubSectionHeaderActions');r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");a.forEach(r.renderControl);r.write("</div>");}r.write("</div>");}r.write("<div");r.addClass("ui-helper-clearfix");r.addClass("sapUxAPBlockContainer");r.addClass("sapUxAPBlockContainer"+c._getMediaString());r.writeClasses();if(c._isHidden){r.addStyle("display","none");}r.writeStyles();r.write(">");r.renderControl(c._getGrid());r.write("<div");r.addClass("sapUxAPSubSectionSeeMoreContainer");r.writeClasses();r.write(">");r.renderControl(c._getSeeMoreButton());r.write("</div>");r.write("</div>");r.write("</div>");};
return O;},true);
sap.ui.predefine('sap/uxap/ThrottledTaskHelper',["jquery.sap.global",'sap/ui/base/Object'],function(q,B){"use strict";
var T=B.extend("ThrottledTask",{
constructor:function(t,d,c){this._fnTask=t;this._iDelay=d;this._oContext=c;this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._iTimer=null;this._oTaskOptions=null;},
reSchedule:function(i,t){var r=this._getPromise();if(this._iTimer){q.sap.clearDelayedCall(this._iTimer);this._iTimer=null;}this._oTaskOptions=this._mergeOptions(this._oTaskOptions||{},t);if(i){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);return r;}this._iTimer=q.sap.delayedCall(this._iDelay,this,function(){if(this._oPromise){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);}}.bind(this));return r;},
_getPromise:function(){if(!this._oPromise){this._oPromise=new window.Promise(function(r,a){this._fnResolvePromise=r;this._fnRejectPromise=a;}.bind(this));}return this._oPromise;},
_completePromise:function(s){var c=(s)?this._fnResolvePromise:this._fnRejectPromise;c();this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._oTaskOptions=null;},
_mergeOptions:function(o,n){var m=q.extend({},o,n);q.each(m,function(k){m[k]=o[k]||n[k];});return m;}
});
return T;});
sap.ui.predefine('sap/uxap/changeHandler/MoveObjectPageSection',["sap/ui/fl/changeHandler/MoveControls"],function(M){"use strict";var a=jQuery.extend({},M);
a.applyChange=function(c,C,p){var j=p.modifier.targets==="jsControlTree";if(j){C._suppressScroll();}var r=M.applyChange.call(this,c,C,p);if(j){C.attachEventOnce("onAfterRenderingDOMReady",function(){C._resumeScroll(false);});}return r;};
a.revertChange=function(c,C,p){var j=p.modifier.targets==="jsControlTree";if(j){C._suppressScroll();}var r=M.revertChange.call(this,c,C,p);if(j){C.attachEventOnce("onAfterRenderingDOMReady",function(){C._resumeScroll(false);});}return r;};
return a;},true);
sap.ui.predefine('sap/uxap/changeHandler/RenameObjectPageSection',["sap/ui/fl/Utils","sap/ui/fl/changeHandler/BaseRename"],function(U,B){"use strict";var r={propertyName:"title",changePropertyName:"newText",translationTextType:"XGRP"};var R=B.createRenameChangeHandler(r);
R._getControlForRename=function(c,m){var s=m.getAggregation(c,"subSections");if(s&&s.length===1&&m.getProperty(s[0],"title")&&m.getProperty(m.getParent(c),"subSectionLayout")==="TitleOnTop"){return s[0];}return c;};
R._getSetterMethodName=function(v,p,m){return U.isBinding(v)?"setPropertyBinding":"setProperty";};
R.applyChange=function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;var a=R._getControlForRename(C,m);if(o.texts&&t&&typeof(v)==="string"){c.setRevertData(m.getProperty(a,P));var M=R._getSetterMethodName(v);m[M](a,P,v);return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
R.revertChange=function(c,C,p){var o=c.getRevertData();if(typeof(o)==="string"){var m=p.modifier;var a=R._getControlForRename(C,m);var P=r.propertyName;var M=R._getSetterMethodName(o);m[M](a,P,o);c.resetRevertData();return true;}else{U.log.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");}};
return R;},true);
sap.ui.predefine('sap/uxap/component/Component',["jquery.sap.global","sap/uxap/library","sap/ui/core/UIComponent","sap/ui/core/library","sap/ui/core/Component"],function(q,l,U,c){"use strict";var V=c.mvc.ViewType;var O=l.ObjectPageConfigurationMode;
var C=U.extend("sap.uxap.component.Component",{
metadata:{},
init:function(){this._oModel=null;this._oViewConfig={viewData:{component:this}};switch(this.oComponentData.mode){case O.JsonURL:this._oModel=new U(this.oComponentData.jsonConfigurationURL);this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;case O.JsonModel:this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;default:q.sap.log.error("UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation");}U.prototype.init.call(this);},
createContent:function(){var o;this._oView=sap.ui.view(this._oViewConfig);if(this._oModel){o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this._oModel);}this._oView.setModel(this._oModel,"objectPageLayoutMetadata");}return this._oView;},
propagateProperties:function(n){if(this.oComponentData.mode===O.JsonModel){var o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this.getModel("objectPageLayoutMetadata"));}}return U.prototype.propagateProperties.apply(this,arguments);},
destroy:function(){if(this._oView){this._oView.destroy();this._oView=null;}if(this._oModel){this._oModel.destroy();this._oModel=null;}if(U.prototype.destroy){U.prototype.destroy.call(this);}}
});
return C;});
sap.ui.predefine('sap/uxap/component/ObjectPageComponentContainer',['jquery.sap.global','sap/ui/core/ComponentContainer','sap/ui/core/Component'],function(q,C){"use strict";
var O=C.extend("sap.uxap.component.ObjectPageComponentContainer",{
metadata:{properties:{"jsonConfigurationURL":{type:"string",group:"Behavior"},"mode":{type:"sap.uxap.ObjectPageConfigurationMode",group:"Behavior"}}},
init:function(){this.setPropagateModel(true);this.setName("sap.uxap.component");},
onBeforeRendering:function(){this._oComponent=sap.ui.component("sap.uxap");if(!this._oComponent){this._oComponent=sap.ui.component({name:this.getName(),url:this.getUrl(),componentData:{jsonConfigurationURL:this.getJsonConfigurationURL(),mode:this.getMode()}});this.setComponent(this._oComponent,true);}if(C.prototype.onBeforeRendering){C.prototype.onBeforeRendering.call(this);}},
getObjectPageLayoutInstance:function(){var o=null;if(this._oComponent&&this._oComponent._oView){o=this._oComponent._oView.byId("ObjectPageLayout");}else{q.sap.log.error("ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?");}return o;},
renderer:"sap.ui.core.ComponentContainerRenderer"
});
return O;});
sap.ui.predefine('sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller',["jquery.sap.global","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/base/ManagedObject","sap/ui/core/mvc/Controller"],function(q,B,C,M,a){"use strict";return a.extend("sap.uxap.component.ObjectPageLayoutUXDrivenFactory",{connectToComponent:function(m){var h=q.isEmptyObject(m.getData());m.setDefaultBindingMode(B.OneWay);var H=q.proxy(function(){if(h){m.detachRequestCompleted(H);}var o=new C(m,"/headerTitle"),O=this.getView().byId("ObjectPageLayout");if(o.getProperty("")){try{this._oHeader=this.controlFactory(O.getId(),o);O.setHeaderTitle(this._oHeader);}catch(e){q.sap.log.error("ObjectPageLayoutFactory :: error in header creation from config: "+e);}}},this);if(h){m.attachRequestCompleted(H);}else{H();}},controlFactory:function(p,b){var c=b.getProperty(""),o,d,e;try{q.sap.require(c.Type);d=q.sap.getObject(c.Type);e=d.getMetadata();q.each(e._mAllEvents,q.proxy(function(s,f){if(typeof c[s]=="string"){c[s]=this.convertEventHandler(c[s]);}},this));o=M.create(c);q.each(e._mAllProperties,q.proxy(function(P,f){if(c[P]){o.bindProperty(P,"objectPageLayoutMetadata>"+b.getPath()+"/"+P);}},this));}catch(E){q.sap.log.error("ObjectPageLayoutFactory :: error in control creation from config: "+E);}return o;},convertEventHandler:function(s){var n=window,N=s.split('.');try{q.each(N,function(i,b){n=n[b];});}catch(e){q.sap.log.error("ObjectPageLayoutFactory :: undefined event handler: "+s+". Did you forget to require its static class?");n=undefined;}return n;}});},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageDynamicHeaderTitle.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(C,S,M){"use strict";return{"hideControl":"default","unhideControl":"default","combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}},"moveActions":{"changeHandler":M},"moveControls":"default"};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageHeader.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton"],function(C,S){"use strict";return{"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageLayout.flexibility',['sap/uxap/changeHandler/MoveObjectPageSection'],function(M){"use strict";return{"moveControls":{"changeHandler":M,"layers":{"USER":true}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSection.flexibility',['sap/uxap/changeHandler/RenameObjectPageSection'],function(R){"use strict";return{"rename":R,"moveControls":"default","hideControl":{"changeHandler":"default","layers":{"USER":true}},"unhideControl":{"changeHandler":"default","layers":{"USER":true}},"stashControl":{"changeHandler":"default","layers":{"USER":true}},"unstashControl":{"changeHandler":"default","layers":{"USER":true}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSubSection.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/ui/fl/changeHandler/BaseRename"],function(C,S,B){"use strict";return{"hideControl":"default","unhideControl":"default","rename":B.createRenameChangeHandler({propertyName:"title",translationTextType:"XGRP"}),"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/library',["jquery.sap.global","sap/ui/core/Core","sap/ui/base/DataType","sap/ui/Device","sap/m/library","sap/ui/layout/library"],function(q,C,D,a){"use strict";sap.ui.getCore().initLibrary({name:"sap.uxap",dependencies:["sap.ui.core","sap.m","sap.ui.layout"],designtime:"sap/uxap/designtime/library.designtime",types:["sap.uxap.BlockBaseColumnLayout","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],interfaces:["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"],controls:["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],elements:["sap.uxap.ModelMapping","sap.uxap.ObjectPageHeaderLayoutData"],version:"1.56.5",extensions:{flChangeHandlers:{"sap.uxap.ObjectPageHeader":"sap/uxap/flexibility/ObjectPageHeader","sap.uxap.ObjectPageLayout":"sap/uxap/flexibility/ObjectPageLayout","sap.uxap.ObjectPageSection":"sap/uxap/flexibility/ObjectPageSection","sap.uxap.ObjectPageSubSection":"sap/uxap/flexibility/ObjectPageSubSection","sap.uxap.ObjectPageDynamicHeaderTitle":"sap/uxap/flexibility/ObjectPageDynamicHeaderTitle","sap.ui.core._StashedControl":{"unstashControl":{"changeHandler":"default","layers":{"USER":true}}}},"sap.ui.support":{publicRules:true}}});sap.uxap.BlockBaseColumnLayout=D.createType('sap.uxap.BlockBaseColumnLayout',{isValid:function(v){return/^(auto|[1-4]{1})$/.test(v);}},D.getType('string'));sap.uxap.BlockBaseFormAdjustment={BlockColumns:"BlockColumns",OneColumn:"OneColumn",None:"None"};sap.uxap.ObjectPageConfigurationMode={JsonURL:"JsonURL",JsonModel:"JsonModel"};sap.uxap.ObjectPageHeaderDesign={Light:"Light",Dark:"Dark"};sap.uxap.ObjectPageHeaderPictureShape={Circle:"Circle",Square:"Square"};sap.uxap.ObjectPageSubSectionLayout={TitleOnTop:"TitleOnTop",TitleOnLeft:"TitleOnLeft"};sap.uxap.ObjectPageSubSectionMode={Collapsed:"Collapsed",Expanded:"Expanded"};sap.uxap.Importance={Low:"Low",Medium:"Medium",High:"High"};sap.uxap.i18nModel=(function(){return new sap.ui.model.resource.ResourceModel({bundleUrl:q.sap.getModulePath("sap.uxap.i18n.i18n",".properties")});}());sap.uxap.Utilities={getClosestOPL:function(c){while(c&&!(c instanceof sap.uxap.ObjectPageLayout)){c=c.getParent();}return c;},isPhoneScenario:function(r){if(a.system.phone){return true;}return sap.uxap.Utilities._isCurrentMediaSize("Phone",r);},isTabletScenario:function(r){return sap.uxap.Utilities._isCurrentMediaSize("Tablet",r);},_isCurrentMediaSize:function(m,r){return r&&r.name===m;}};return sap.uxap;});
sap.ui.require.preload({
	"sap/uxap/component/ObjectPageLayoutUXDrivenFactory.view.xml":'<core:View xmlns:core="sap.ui.core" xmlns="sap.uxap" height="100%" controllerName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory"><ObjectPageLayout id="ObjectPageLayout" subSectionLayout="{objectPageLayoutMetadata&gt;/subSectionLayout}" showAnchorBar="{objectPageLayoutMetadata&gt;/showAnchorBar}" height="{objectPageLayoutMetadata&gt;/height}" enableLazyLoading="{objectPageLayoutMetadata&gt;/enableLazyLoading}" sections="{objectPageLayoutMetadata&gt;/sections}" headerContent="{path:\'objectPageLayoutMetadata&gt;/headerContent\',factory:\'.controlFactory\'}" showAnchorBarPopover="{objectPageLayoutMetadata&gt;/showAnchorBarPopover}" upperCaseAnchorBar="{objectPageLayoutMetadata&gt;/upperCaseAnchorBar}" useIconTabBar="{objectPageLayoutMetadata&gt;/useIconTabBar}" showHeaderContent="{objectPageLayoutMetadata&gt;/showHeaderContent}" useTwoColumnsForLargeScreen="{objectPageLayoutMetadata&gt;/useTwoColumnsForLargeScreen}" showTitleInHeaderContent="{objectPageLayoutMetadata&gt;/showTitleInHeaderContent}" showOnlyHighImportance="{objectPageLayoutMetadata&gt;/showOnlyHighImportance}" isChildPage="{objectPageLayoutMetadata&gt;/isChildPage}" alwaysShowContentHeader="{objectPageLayoutMetadata&gt;/alwaysShowContentHeader}" showEditHeaderButton="{objectPageLayoutMetadata&gt;/showEditHeaderButton}"><sections><ObjectPageSection id="ObjectPageSection" title="{objectPageLayoutMetadata&gt;title}" importance="{objectPageLayoutMetadata&gt;importance}" showTitle="{objectPageLayoutMetadata&gt;showTitle}" subSections="{objectPageLayoutMetadata&gt;subSections}" visible="{objectPageLayoutMetadata&gt;visible}"><subSections><ObjectPageSubSection id="ObjectPageSubSection" title="{objectPageLayoutMetadata&gt;title}" visible="{objectPageLayoutMetadata&gt;visible}" mode="{objectPageLayoutMetadata&gt;mode}" importance="{objectPageLayoutMetadata&gt;importance}" actions="{path:\'objectPageLayoutMetadata&gt;actions\',factory:\'.controlFactory\'}" blocks="{path:\'objectPageLayoutMetadata&gt;blocks\',factory:\'.controlFactory\'}" moreBlocks="{path:\'objectPageLayoutMetadata&gt;moreBlocks\',factory:\'.controlFactory\'}"/></subSections></ObjectPageSection></sections></ObjectPageLayout></core:View>',
	"sap/uxap/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.uxap","type":"library","embeds":["component"],"applicationVersion":{"version":"1.56.5"},"title":"SAP UxAP","description":"SAP UxAP","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.56","libs":{"sap.ui.core":{"minVersion":"1.56.5"},"sap.m":{"minVersion":"1.56.5"},"sap.ui.layout":{"minVersion":"1.56.5"}}},"library":{"i18n":false,"content":{"controls":["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],"elements":["sap.uxap.ModelMapping","sap.uxap.ObjectPageHeaderLayoutData"],"types":["sap.uxap.BlockBaseColumnLayout","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],"interfaces":["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"]}}}}'
},"sap/uxap/library-preload"
);
//# sourceMappingURL=library-preload.js.map