/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','./InputBase','./DateTimeField','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","sap/ui/dom/jquery/cursorPos"],function(q,D,I,a,U,l,C,c,b,d,e,L,f){"use strict";var T=c.TextAlign;var g=c.CalendarType;var h;var i=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"}}}},designtime:"sap/m/designtime/DatePicker.designtime"}});i.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);var s=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,title:""});this._bShouldClosePicker=false;s.addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=!!this.isOpen();}},this);s.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);};i.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen();};i.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){if(O){j.call(this);}else{_.call(this);}}};i.prototype.getIconSrc=function(){return f.getIconURI("appointment-2");};i.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};i.prototype.invalidate=function(O){if(!O||O!=this._oCalendar){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(r.bind(this),0);}};i.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();};i.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};i.prototype.getWidth=function(w){return this.getProperty("width")||"100%";};i.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;I.prototype.applyFocusInfo.apply(this,arguments);};i.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};i.prototype.onsapshow=function(E){this.toggleOpen(this.isOpen());E.preventDefault();};i.prototype.onsaphide=i.prototype.onsapshow;i.prototype.onsappageup=function(E){k.call(this,1,"day");E.preventDefault();};i.prototype.onsappageupmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){k.call(this,1,"month");}else{k.call(this,1,"year");}E.preventDefault();};i.prototype.onsappagedown=function(E){k.call(this,-1,"day");E.preventDefault();};i.prototype.onsappagedownmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){k.call(this,-1,"month");}else{k.call(this,-1,"year");}E.preventDefault();};i.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var s=String.fromCharCode(E.charCode);if(s&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(s)<0){E.preventDefault();}};i.prototype._dateValidation=function(s){this._bValid=true;if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;e(this._bValid,"Date must be in valid range");}this.setProperty("dateValue",s);return s;};i.prototype.setMinDate=function(s){if(this._isValidDate(s)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMinDate(),s)){return this;}if(s){var y=s.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(s.getTime());var t=this.getDateValue();if(t&&t.getTime()<s.getTime()){L.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",s);if(this._oCalendar){this._oCalendar.setMinDate(s);}this._oMinDate.setHours(0,0,0,0);return this;};i.prototype.setMaxDate=function(s){if(this._isValidDate(s)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMaxDate(),s)){return this;}if(s){var y=s.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(s.getTime());var t=this.getDateValue();if(t&&t.getTime()>s.getTime()){L.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",s);if(this._oCalendar){this._oCalendar.setMaxDate(s);}this._oMaxDate.setHours(23,59,59,999);return this;};i.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){L.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var s=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(s.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",s,true);this.setProperty("maxDate",M,true);if(this._oCalendar){this._oCalendar.setMinDate(s);this._oCalendar.setMaxDate(M);}}var t=this.getDateValue();if(t&&(t.getTime()<this._oMinDate.getTime()||t.getTime()>this._oMaxDate.getTime())){L.error("dateValue "+t.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};i.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};i.prototype._handleDateValidation=function(s){this._bValid=true;if(!s||s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime()){this._bValid=false;L.warning("Value can not be converted to a valid date",this);}this.setProperty("dateValue",s);};i.prototype.setDisplayFormatType=function(s){if(s){var F=false;for(var t in g){if(t==s){F=true;break;}}if(!F){throw new Error(s+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",s,true);this.setDisplayFormat(this.getDisplayFormat());return this;};i.prototype.setSecondaryCalendarType=function(s){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",s,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(s);}return this;};i.prototype.addSpecialDate=function(s){p.call(this,s);this.addAggregation("specialDates",s,true);r.call(this);return this;};i.prototype.insertSpecialDate=function(s,t){p.call(this,s);this.insertAggregation("specialDates",s,t,true);r.call(this);return this;};i.prototype.removeSpecialDate=function(s){var R=this.removeAggregation("specialDates",s,true);r.call(this);return R;};i.prototype.removeAllSpecialDates=function(){var R=this.removeAllAggregation("specialDates",true);r.call(this);return R;};i.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);r.call(this);return this;};i.prototype.setLegend=function(s){this.setAssociation("legend",s,true);var t=this.getLegend();if(t){var u=sap.ui.require("sap/ui/unified/CalendarLegend");s=sap.ui.getCore().byId(t);if(s&&!(typeof u=="function"&&s instanceof u)){throw new Error(s+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._oCalendar){this._oCalendar.setLegend(t);}return this;};i.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var O=this._formatValue(this.getDateValue());if(v==O&&this._bValid){return;}var s;this._bValid=true;if(v!=""){s=this._parseValue(v,true);if(!s||s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime()){this._bValid=false;s=undefined;}else{v=this._formatValue(s);}}if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}if(s){v=this._formatValue(s,true);}if(this._lastValue!==v||(s&&this.getDateValue()&&s.getFullYear()!==this.getDateValue().getFullYear())){this._lastValue=v;this.setProperty("value",v,true);var N=this.getValue();if(this._bValid&&v==N){this.setProperty("dateValue",s,true);}v=N;if(this.isOpen()){if(this._bValid){s=this.getDateValue();}this._oCalendar.focusDate(s);var S=this._oDateRange.getStartDate();if((!S&&s)||(S&&s&&S.getTime()!=s.getTime())){this._oDateRange.setStartDate(new Date(s.getTime()));}else if(S&&!s){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(v,{valid:this._bValid});}};i.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var s=this._parseValue(v,true);v=this._formatValue(s,true);return v;};i.prototype.updateDomValue=function(v){if(this.isActive()&&(this._$input.val()!==v)){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var s=this._parseValue(v,true);v=this._formatValue(s);this._$input.val(v);this._$input.cursorPos(this._curpos);}return this;};i.prototype._storeInputSelection=function(s){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:s.selectionStart,iEnd:s.selectionEnd};s.selectionStart=0;s.selectionEnd=0;}};i.prototype._restoreInputSelection=function(s){if((D.browser.msie||D.browser.edge)&&!D.support.touch){s.selectionStart=this._oInputSelBeforePopupOpen.iStart;s.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};function _(){this._createPopup();this._createPopupContent();var s;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){s=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.calendarType;}if(!s){s=this.getDisplayFormatType();}if(s){this._oCalendar.setPrimaryCalendarType(s);}var v=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(v!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}i.prototype._createPopup=function(){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setDurations(0,0);this._oPopup.attachOpened(m,this);this._oPopup.attachClosed(n,this);}};i.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup.setAutoCloseAreas([this.getDomRef()]);var s=sap.ui.core.Popup.Dock;var A;if(this.getTextAlign()==T.End){A=s.EndBottom+"-4";this._oPopup.open(0,s.EndTop,A,this,null,"fit",true);}else{A=s.BeginBottom+"-4";this._oPopup.open(0,s.BeginTop,A,this,null,"fit",true);}};i.prototype._getVisibleDatesRange=function(s){var v=s._getVisibleDays();return new sap.ui.unified.DateRange({startDate:v[0].toLocalJSDate(),endDate:v[v.length-1].toLocalJSDate()});};i.prototype._createPopupContent=function(){if(!this._oCalendar){if(!h){sap.ui.getCore().loadLibrary("sap.ui.unified");h=sap.ui.requireSync("sap/ui/unified/Calendar");}this._oCalendar=new h(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}.bind(this)});this._oDateRange=new sap.ui.unified.DateRange();this._oCalendar.addSelectedDate(this._oDateRange);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._selectDate,this);this._oCalendar.attachCancel(j,this);this._oCalendar.attachEvent("_renderMonth",o,this);this._oCalendar.setPopupMode(true);this._oCalendar.setParent(this,undefined,true);this._oPopup.setContent(this._oCalendar);}}};i.prototype._fillDateRange=function(){var s=this.getDateValue();if(s&&s.getTime()>=this._oMinDate.getTime()&&s.getTime()<=this._oMaxDate.getTime()){this._oCalendar.focusDate(new Date(s.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));}}else{var t=this.getInitialFocusedDateValue();var F=t?t:new Date();var M=this._oMaxDate.getTime()+86400000;if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._oCalendar.focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};i.prototype.getAccessibilityInfo=function(){var R=this.getRenderer();var s=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var t=this.getDateValue();if(t){v=this._formatValue(t);}}s.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATEINPUT");s.description=[v,R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this)].join(" ").trim();return s;};i.prototype._selectDate=function(E){var s=this.getDateValue();var t=this._getSelectedDate();var v="";if(!d(t,s)){this.setDateValue(new Date(t.getTime()));v=this.getValue();this.fireChangeEvent(v,{valid:true});if(this.getDomRef()&&(D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){v=this._formatValue(t);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);this._lastValue=v;}v=this._formatValue(t,true);this.setProperty("value",v,true);this.fireChangeEvent(v,{valid:true});}}else if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this.focus();}this._oPopup.close();};i.prototype._getSelectedDate=function(){var s=this._oCalendar.getSelectedDates();var t;if(s.length>0){t=s[0].getStartDate();}return t;};function j(E){if(this.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this.focus();}}}function k(N,u){var O=this.getDateValue();var s=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var t;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){t=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){t=B.oType.oFormat.oFormatOptions.calendarType;}if(!t){t=this.getDisplayFormatType();}var v=U.getInstance(new Date(O.getTime()),t);O=U.getInstance(new Date(O.getTime()),t);switch(u){case"day":v.setDate(v.getDate()+N);break;case"month":v.setMonth(v.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(v.getMonth()!=M){v.setDate(v.getDate()-1);}break;case"year":v.setFullYear(v.getFullYear()+N);while(v.getMonth()!=O.getMonth()){v.setDate(v.getDate()-1);}break;default:break;}if(v.getTime()<this._oMinDate.getTime()){v=new U(this._oMinDate.getTime());}else if(v.getTime()>this._oMaxDate.getTime()){v=new U(this._oMaxDate.getTime());}if(!d(this.getDateValue(),v.getJSDate())){this.setDateValue(new Date(v.getTime()));this._curpos=s;this._$input.cursorPos(this._curpos);var V=this.getValue();this.fireChangeEvent(V,{valid:true});}}}function m(E){this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);}function n(E){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));}function o(E){var s=E.getParameter("days");if(s>this._renderedDays){this._renderedDays=s;this._oPopup._applyPosition(this._oPopup._oLastPosition);}}function p(s){var t=sap.ui.require("sap/ui/unified/DateTypeRange");if(s&&!(t&&s instanceof t)){throw new Error(s+"is not valid for aggregation \"specialDates\" of "+this);}}function r(){if(this.isOpen()){this._oCalendar._bDateRangeChanged=true;this._oCalendar.invalidate();}}return i;});
