/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/events/KeyCodes","sap/ui/model/BindingMode","sap/ui/Device","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Icon","./library","./Button","./CheckBox","./RadioButton","./ListItemBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(K,B,D,C,I,a,l,b,c,R,L,d,q){"use strict";var e=l.ListKeyboardMode;var f=l.ListMode;var g=l.ListType;var h=l.ButtonType;var i=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:g.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:"None"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designtime:"sap/m/designtime/ListItemBase.designtime"}});i.getAccessibilityText=function(o,j){if(!o||!o.getVisible||!o.getVisible()){return"";}var A;if(o.getAccessibilityInfo){A=o.getAccessibilityInfo();}if(!A||!o.getAccessibilityInfo){A=this.getDefaultAccessibilityInfo(o.getDomRef());}A=q.extend({type:"",description:"",children:[]},A);var k=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=A.type+" "+A.description+" ",T=o.getTooltip_AsString();if(A.enabled===false){t+=k.getText("CONTROL_DISABLED")+" ";}if(A.editable===false){t+=k.getText("CONTROL_READONLY")+" ";}if(!A.type&&T&&t.indexOf(T)==-1){t=T+" "+t;}A.children.forEach(function(m){t+=i.getAccessibilityText(m)+" ";});t=t.trim();if(j&&!t){t=k.getText("CONTROL_EMPTY");}return t;};i.getDefaultAccessibilityInfo=function(o){if(!o){return null;}var N=window.Node,j=window.NodeFilter,t=document.createTreeWalker(o,j.SHOW_TEXT+j.SHOW_ELEMENT,function(n){if(n.type===N.ELEMENT_NODE){if(n.classList.contains("sapUiInvisibleText")){return j.FILTER_SKIP;}if(n.getAttribute("aria-hidden")=="true"||n.style.visibility=="hidden"||n.style.display=="none"){return j.FILTER_REJECT;}return j.FILTER_SKIP;}return j.FILTER_ACCEPT;},false);var T=[];while(t.nextNode()){var n=t.currentNode;if(n.nodeType===N.TEXT_NODE){var s=(n.nodeValue||"").trim();if(s){T.push(s);}}}return{description:T.join(" ")};};i.prototype.DetailIconURI=I.getIconURI("edit");i.prototype.DeleteIconURI=I.getIconURI("sys-cancel");i.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");i.prototype.TagName="li";i.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;};i.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);this._checkHighlight();};i.prototype.invalidate=function(){if(!this.bOutput){return;}C.prototype.invalidate.apply(this,arguments);};i.prototype.getBindingContextPath=function(m){var o=this.getList();if(o&&!m){m=(o.getBindingInfo("items")||{}).model;}var j=this.getBindingContext(m);if(j){return j.getPath();}};i.prototype.isSelectedBoundTwoWay=function(){var o=this.getBinding("selected");if(o&&o.getBindingMode()==B.TwoWay){return true;}};i.prototype.getList=function(){var p=this.getParent();if(p&&p.isA("sap.m.ListBase")){return p;}};i.prototype.getListProperty=function(p,F){var o=this.getList();if(o){p=d(p);return o["get"+p]();}return F;};i.prototype.informList=function(E,p,P){var o=this.getList();if(o){var m="onItem"+E;if(o[m]){o[m](this,p,P);}}};i.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};i.prototype.getAccessibilityType=function(o){return o.getText("ACC_CTR_TYPE_OPTION");};i.prototype.getGroupAnnouncement=function(){return this.$().prevAll(".sapMGHLI:first").text();};i.prototype.getAccessibilityDescription=function(o){var O=[],t=this.getType(),H=this.getHighlight(),T=this.getTooltip_AsString();if(this.getSelected()){O.push(o.getText("LIST_ITEM_SELECTED"));}if(H!="None"){O.push(o.getText("LIST_ITEM_STATE_"+H.toUpperCase()));}if(this.getUnread()&&this.getListProperty("showUnread")){O.push(o.getText("LIST_ITEM_UNREAD"));}if(this.getCounter()){O.push(o.getText("LIST_ITEM_COUNTER",this.getCounter()));}if(t==g.Navigation){O.push(o.getText("LIST_ITEM_NAVIGATION"));}else{if(t==g.Detail||t==g.DetailAndActive){O.push(o.getText("LIST_ITEM_DETAIL"));}if(t==g.Active||t==g.DetailAndActive){O.push(o.getText("LIST_ITEM_ACTIVE"));}}O.push(this.getGroupAnnouncement()||"");if(this.getContentAnnouncement){O.push((this.getContentAnnouncement(o)||"").trim());}if(T){O.push(T);}return O.join(" ");};i.prototype.getAccessibilityInfo=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{type:this.getAccessibilityType(o),description:this.getAccessibilityDescription(o),focusable:true};};i.prototype.getMode=function(){return this.getListProperty("mode","");};i.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var $=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":$.length,"aria-posinset":$.index(t)+1},A));};i.prototype.getDeleteControl=function(j){if(!j||this._oDeleteControl){return this._oDeleteControl;}this._oDeleteControl=new b({id:this.getId()+"-imgDel",icon:this.DeleteIconURI,type:h.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_DELETE")}).addStyleClass("sapMLIBIconDel sapMLIBSelectD").setParent(this,null,true).attachPress(function(E){this.informList("Delete");},this);this._oDeleteControl._bExcludeFromTabChain=true;return this._oDeleteControl;};i.prototype.getDetailControl=function(j){if(!j||this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new b({id:this.getId()+"-imgDet",icon:this.DetailIconURI,type:h.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_EDIT")}).addStyleClass("sapMLIBType sapMLIBIconDet").setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this);this._oDetailControl._bExcludeFromTabChain=true;return this._oDetailControl;};i.prototype.getNavigationControl=function(j){if(!j||this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new a({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};i.prototype.getSingleSelectControl=function(j){if(!j||this._oSingleSelectControl){j&&this._oSingleSelectControl.setSelected(this.getSelected());return this._oSingleSelectControl;}this._oSingleSelectControl=new R({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectS").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oSingleSelectControl;};i.prototype.getMultiSelectControl=function(j){if(!j||this._oMultiSelectControl){j&&this._oMultiSelectControl.setSelected(this.getSelected());return this._oMultiSelectControl;}this._oMultiSelectControl=new c({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oMultiSelectControl;};i.prototype.getModeControl=function(j){var m=this.getMode();if(!m||m==f.None){return;}if(m==f.Delete){return this.getDeleteControl(j);}if(m==f.MultiSelect){return this.getMultiSelectControl(j);}return this.getSingleSelectControl(j);};i.prototype.getTypeControl=function(j){var t=this.getType();if(t==g.Detail||t==g.DetailAndActive){return this.getDetailControl(j);}if(t==g.Navigation){return this.getNavigationControl(j);}};i.prototype.destroyControls=function(j){j.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};i.prototype.isActionable=function(){return this.getListProperty("includeItemInSelection")||this.getMode()==f.SingleSelectMaster||(this.getType()!=g.Inactive&&this.getType()!=g.Detail);};i.prototype.exit=function(){this._oLastFocused=null;this._checkHighlight(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};i.prototype.isSelectable=function(){var m=this.getMode();return!(m==f.None||m==f.Delete);};i.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};i.prototype.isSelected=i.prototype.getSelected;i.prototype.setSelected=function(s,j){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!j){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};i.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};i.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};i.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};i.prototype.isGroupHeader=function(){return this._bGroupHeader;};i.prototype.isIncludedIntoSelection=function(){var m=this.getMode();return(m==f.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(m==f.SingleSelectLeft||m==f.SingleSelect||m==f.MultiSelect)));};i.prototype._checkHighlight=function(n){if(n==undefined){n=(this.getVisible()&&this.getHighlight()!="None");}if(this._bNeedsHighlight!=n){this._bNeedsHighlight=n;this.informList("HighlightChange",n);}};i.prototype.hasActiveType=function(){var t=this.getType();return(t==g.Active||t==g.Navigation||t==g.DetailAndActive);};i.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==g.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};i.prototype.ontap=function(E){if(this._eventHandledByControl){return E.setMarked();}var t=window.getSelection().toString().replace("\n","");if(t){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==f.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(D.os.ios){this.focus();}setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}this.informList("Press",E.srcControl);};i.prototype.ontouchstart=function(E){this._eventHandledByControl=E.isMarked();var t=E.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||E.touches.length!=1||!this.hasActiveType()){return;}this._timeoutIdStart=setTimeout(function(){this.setActive(true);}.bind(this),100);};i.prototype.ontouchmove=function(E){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-E.targetTouches[0].clientY)>10||Math.abs(this._touchedX-E.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};i.prototype.ontouchend=function(E){if(E.targetTouches.length==0&&this.hasActiveType()){this._timeoutIdEnd=setTimeout(function(){this.setActive(false);}.bind(this),100);}};i.prototype.ontouchcancel=i.prototype.ontouchend;i.prototype._activeHandlingNav=function(){};i.prototype._activeHandlingInheritor=function(){};i.prototype._inactiveHandlingInheritor=function(){};i.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(D.system.desktop&&this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};i.prototype.onsapspace=function(E){if(E.srcControl!==this){return;}E.preventDefault();if(E.isMarked()||!this.isSelectable()){return;}if(this.getMode()==f.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}E.setMarked();};i.prototype.onsapenter=function(E){var o=this.getList();if(E.isMarked()||!o){return;}if(E.srcControl!==this&&o.getKeyboardMode()==e.Edit){o.setKeyboardMode(e.Navigation);this._switchFocus(E);return;}if(E.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(E);}else if(this.hasActiveType()){E.setMarked();this.setActive(true);setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}o.onItemPress(this,E.srcControl);};i.prototype.onsapdelete=function(E){if(E.isMarked()||E.srcControl!==this||this.getMode()!=f.Delete){return;}this.informList("Delete");E.preventDefault();E.setMarked();};i.prototype._switchFocus=function(E){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(E.srcControl!==this){o._iLastFocusPosOfItem=t.index(E.target);this.focus();}else if(t.length){var F=o._iLastFocusPosOfItem||0;F=t[F]?F:-1;t.eq(F).focus();}E.preventDefault();E.setMarked();};i.prototype.onkeydown=function(E){if(E.isMarked()){return;}if(E.which==K.F7){this._switchFocus(E);return;}if(E.which==K.F2){if(E.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();E.preventDefault();E.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);o.setKeyboardMode(o.getKeyboardMode()==e.Edit?e.Navigation:e.Edit);this._switchFocus(E);}}}};i.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};i.prototype.onsaptabnext=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==e.Edit){return;}var j=this.getTabbables().get(-1)||this.getDomRef();if(E.target===j){o.forwardTab(true);E.setMarked();}};i.prototype.onsaptabprevious=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==e.Edit){return;}if(E.target===this.getDomRef()){o.forwardTab(false);E.setMarked();}};i.prototype.onfocusin=function(E){var o=this.getList();if(!o||E.isMarked()){return;}this.informList("FocusIn",E.srcControl);if(E.srcControl===this){return;}if(o.getKeyboardMode()==e.Edit||!q(E.target).is(":sapFocusable")){return;}setTimeout(o["setItemFocusable"].bind(o,this),0);E.setMarked();};i.prototype.onsapup=function(E){if(E.isMarked()||E.srcControl===this||this.getListProperty("keyboardMode")===e.Navigation){return;}this.informList("ArrowUpDown",E);};i.prototype.oncontextmenu=function(E){if(this._bGroupHeader){return;}if(q(document.activeElement).is(":focusable")&&document.activeElement!==this.getDomRef()&&E.srcControl!==this.getModeControl()){return;}this.informList("ContextMenu",E);};i.prototype.onsapdown=i.prototype.onsapup;return i;});
