/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','./Toolbar','./AssociativeOverflowToolbar','./ToolbarDesign','./Button','./Title','./ToolbarSpacer','./SegmentedButton','sap/ui/unified/Calendar','sap/ui/core/format/DateFormat','sap/ui/core/date/UniversalDate','sap/ui/core/Popup','sap/ui/core/IconPool','sap/ui/core/LocaleData'],function(C,T,A,a,B,b,c,S,d,D,U,P,I,L){"use strict";var O=C.extend("sap.m.OnePersonHeader",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:""},selectedDate:{type:"object",group:"Data"},pickerText:{type:"string",group:"Data"}},aggregations:{actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navigationToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_picker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},events:{pressPrevious:{},pressToday:{},pressNext:{},dateSelect:{}}}});O.prototype.init=function(){var o=this.getId(),n=o+"-NavToolbar",p,t,N;this.setAggregation("_actionsToolbar",new A(o+"-ActionsToolbar",{design:a.Transparent}).addStyleClass("sapMOnePerHeadActionsToolbar").addContent(this._getTitleControl()).addContent(this._getToolbarSpacer()).addContent(this._getViewSwitch()));p=new B(n+"-PrevBtn",{icon:I.getIconURI('slim-arrow-left'),press:function(){this.firePressPrevious();}.bind(this)});t=new B(n+"-TodayBtn",{text:"Today",press:function(){this.firePressToday();}.bind(this)});N=new B(n+"-NextBtn",{icon:I.getIconURI('slim-arrow-right'),press:function(){this.firePressNext();}.bind(this)});this.oPicker=new d(o+"-Cal");this.oPicker.attachEvent("select",this._handlePickerDateSelect,this);this.setAggregation("_picker",this.oPicker);this.oPickerBtn=new B(n+"-PickerBtn",{text:this.getPickerText(),press:function(){var e=this.getSelectedDate()||new Date(),u=new U(U.UTC(e.getFullYear(),e.getMonth(),e.getDate()));this.oPicker.displayDate(u.oDate);this._openPickerPopup(this.oPicker);}.bind(this)});this.setAggregation("_navigationToolbar",new T(n,{design:a.Transparent,content:[p,t,N,this.oPickerBtn]}).addStyleClass("sapMOnePerHeadNavToolbar"));};O.prototype.exit=function(){if(this._oTitle){this._oTitle.destroy();this._oTitle=null;}if(this._oToolbarSpacer){this._oToolbarSpacer.destroy();this._oToolbarSpacer=null;}if(this._oViewSwitch){this._oViewSwitch.destroy();this._oViewSwitch=null;}if(this.oPickerBtn){this.oPickerBtn=null;}};O.prototype.onBeforeRendering=function(){var o=this._getActionsToolbar();if(this.getActions().length){o.setProperty("visible",true,true);}else{o.setProperty("visible",false,true);}};O.prototype.setTitle=function(t){this._getTitleControl().setText(t).setVisible(!!t);return this.setProperty("title",t);};O.prototype.addAction=function(o){this._getActionsToolbar().addContent(o);return this.addAggregation("actions",o);};O.prototype.insertAction=function(o,i){this._getActionsToolbar().insertContent(o,i+3);return this.insertAggregation("actions",o,i);};O.prototype.removeAction=function(o){this._getActionsToolbar().removeContent(o);return this.removeAggregation("actions",o);};O.prototype.removeAllActions=function(){this._getActionsToolbar().getContent().forEach(function(i,e){if(e>2){this._getActionsToolbar().removeContent(i);}},this);return this.removeAllAggregation("actions");};O.prototype.destroyActions=function(){this._getActionsToolbar().getContent().forEach(function(i,e){if(e>2){this._getActionsToolbar().removeContent(i);}},this);return this.destroyAggregation("actions");};O.prototype.setSelectedDate=function(o){this.setProperty("selectedDate",o,true);return this;};O.prototype.setPickerText=function(t){this.setProperty("pickerText",t,true);this.oPickerBtn.setText(t);return this;};O.prototype._getTitleControl=function(){if(!this._oTitle){this._oTitle=new b(this.getId()+"-Title",{visible:false});}return this._oTitle;};O.prototype._getToolbarSpacer=function(){if(!this._oToolbarSpacer){this._oToolbarSpacer=new c(this.getId()+"-Spacer");}return this._oToolbarSpacer;};O.prototype._getViewSwitch=function(){if(!this._oViewSwitch){this._oViewSwitch=new S(this.getId()+"-ViewSwitch");}return this._oViewSwitch;};O.prototype._handlePickerDateSelect=function(){var s=this.oPicker.getSelectedDates()[0].getStartDate();this.setSelectedDate(s);this._closeCalendarPicker();this.fireDateSelect();};O.prototype._openPickerPopup=function(p){var e;if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(function(){this._closeCalendarPicker(true);},this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);e=P.Dock;this._oPopup.open(0,e.CenterTop,e.CenterTop,this.oPickerBtn,null,"flipfit",true);};O.prototype.onsapescape=function(){if(this._oPopup){this._closeCalendarPicker.call(this);if(this.oPickerBtn.getDomRef()){this.oPickerBtn.getDomRef().focus();}}};O.prototype._closeCalendarPicker=function(){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}};O.prototype._getActionsToolbar=function(){return this.getAggregation("_actionsToolbar");};return O;});
