/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/core/format/NumberFormat','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/ListItem','sap/ui/model/odata/type/Boolean','sap/ui/model/type/String','sap/ui/model/odata/type/String','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/odata/type/DateTime','sap/ui/model/type/Float','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./ToolbarSpacer','./Text','./SearchField','./CheckBox','./ComboBox','./Select','./Label','./Input','./DatePicker','./TimePicker','./DateTimePicker',"sap/base/Log","sap/ui/thirdparty/jquery"],function(a,c,C,D,N,I,b,d,R,e,L,B,S,f,g,T,h,F,k,O,m,o,q,r,s,t,u,v,x,y,z,A,E,Q){"use strict";var V=c.ValueState;var G=a.ButtonType;var H=a.ToolbarDesign;var J=c.TextAlign;var K=a.OverflowToolbarPriority;var M;var P;var U;var W;var X=C.extend("sap.m.P13nConditionPanel",{metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},renderer:function(j,l){j.write("<section");j.writeControlData(l);j.addClass("sapMConditionPanel");j.writeClasses();j.writeStyles();j.write(">");j.write("<div");j.addClass("sapMConditionPanelContent");j.addClass("sapMConditionPanelBG");j.writeClasses();j.write(">");var n=l.getAggregation("content");var p=n.length;for(var i=0;i<p;i++){j.renderControl(n[i]);}j.write("</div>");j.write("</section>");}});X.prototype.setConditions=function(j){if(!j){E.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<j.length;i++){this._addCondition2Map(j[i]);}this._clearConditions();this._fillConditions();};X.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};X.prototype.addCondition=function(i){if(this._bIgnoreSetConditions){return;}i.index=this._iConditions;this._addCondition2Map(i);this._addCondition(i);};X.prototype.insertCondition=function(i,j){if(this._bIgnoreSetConditions){return;}if(j!==undefined){i.index=j;}this._addCondition2Map(i);this._addCondition(i);};X.prototype.removeCondition=function(i){this._clearConditions();if(typeof i=="string"){this._removeConditionFromMap(i);}if(typeof i=="object"){this._removeConditionFromMap(i.key);}this._fillConditions();};X.prototype._addCondition2Map=function(i){if(!i.key){i.key="condition_"+this._iConditions;if(this.getExclude()){i.key="x"+i.key;}}this._iConditions++;this._oConditionsMap[i.key]=i;this._aConditionKeys.push(i.key);};X.prototype._removeConditionFromMap=function(j){this._iConditions--;delete this._oConditionsMap[j];var i=this._aConditionKeys.indexOf(j);if(i>=0){this._aConditionKeys.splice(i,1);}};X.prototype.getConditions=function(){var i;var j=[];if(this._oConditionsMap){for(var l in this._oConditionsMap){i=this._oConditionsMap[l];var n=i.value;if(!n){n=this._getFormatedConditionText(i.operation,i.value1,i.value2,i.exclude,i.keyField,i.showIfGrouped);}if(!i._oGrid||i._oGrid.select.getSelected()){j.push({"key":l,"text":n,"exclude":i.exclude,"operation":i.operation,"keyField":i.keyField,"value1":i.value1,"value2":i.operation===Y.BT?i.value2:null,"showIfGrouped":i.showIfGrouped});}}}return j;};X.prototype.setOperations=function(i,j){j=j||"default";this._oTypeOperations[j]=i;this._updateAllOperations();};X.prototype.setValues=function(i,j){j=j||"default";this._oTypeValues[j]=i;};X.prototype.addOperation=function(i,j){j=j||"default";this._oTypeOperations[j].push(i);this._updateAllOperations();};X.prototype.removeAllOperations=function(i){i=i||"default";this._oTypeOperations[i]=[];this._updateAllOperations();};X.prototype.getOperations=function(i){i=i||"default";return this._oTypeOperations[i];};X.prototype.setKeyFields=function(i){this._aKeyFields=i;this._aKeyFields.forEach(function(j){X._createKeyFieldTypeInstance(j);},this);this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};X.prototype.addKeyField=function(i){this._aKeyFields.push(i);X._createKeyFieldTypeInstance(i);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};X._createKeyFieldTypeInstance=function(i){if(!i.typeInstance){switch(i.type){case"boolean":i.typeInstance=new B();break;case"numc":if(!(i.formatSettings&&i.formatSettings.isDigitSequence)){E.error("sap.m.P13nConditionPanel","NUMC type support requires isDigitSequence==true!");i.formatSettings=Q.extend({},i.formatSettings,{isDigitSequence:true});}var l=i.formatSettings;if(i.maxLength){l=Q.extend({},l,{maxLength:i.maxLength});}if(!l.maxLength){E.error("sap.m.P13nConditionPanel","NUMC type suppport requires maxLength!");}i.typeInstance=new f({},l);break;case"date":i.typeInstance=new g(Q.extend({},i.formatSettings,{strictParsing:true}),{});break;case"time":i.typeInstance=new T(Q.extend({},i.formatSettings,{strictParsing:true}),{});break;case"datetime":i.typeInstance=new h(Q.extend({},i.formatSettings,{strictParsing:true}),{displayFormat:"Date"});break;case"stringdate":sap.ui.getCore().loadLibrary("sap.ui.comp");W=W||sap.ui.requireSync("sap/ui/comp/odata/type/StringDate");i.typeInstance=new W(Q.extend({},i.formatSettings,{strictParsing:true}));break;case"numeric":var n;if(i.precision||i.scale){n={};if(i.precision){n["maxIntegerDigits"]=parseInt(i.precision,10);}if(i.scale){n["maxFractionDigits"]=parseInt(i.scale,10);}}i.typeInstance=new F(n);break;default:var j=i.formatSettings;if(i.maxLength){j=Q.extend({},j,{maxLength:i.maxLength});}i.typeInstance=new S({},j);break;}}};X.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};X.prototype.getKeyFields=function(){return this._aKeyFields;};X.prototype.setAlwaysShowAddIcon=function(i){this.setProperty("alwaysShowAddIcon",i);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};X.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};X.prototype.setContainerQuery=function(i){this._unregisterResizeHandler();this.setProperty("containerQuery",i);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};X.prototype._updateConditionFieldSpans=function(i){if(this._aConditionsFields){var j=i==="Desktop";if(j){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var l=i==="Tablet";if(l){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};X.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");M=M||sap.ui.requireSync("sap/ui/layout/Grid");P=P||sap.ui.requireSync("sap/ui/layout/GridData");U=U||sap.ui.requireSync("sap/ui/layout/HorizontalLayout");this.addStyleClass("sapMConditionPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=b.media._predefinedRangeSets[b.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=b.media._predefinedRangeSets[b.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new M({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._oConditionsGrid.addStyleClass("sapUiRespGridOverflowHidden");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new d({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperator=new d({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_LABEL")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":b.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];this._oButtonGroupSpan={"SpanFilter":"L2 M2 S2","SpanSort":b.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};X.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var i=this;this._oPrevButton=new k({icon:I.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(j){i._iFirstConditionIndex=Math.max(0,i._iFirstConditionIndex-i._iConditionPageSize);i._clearConditions();i._fillConditions();},layoutData:new m({priority:K.NeverOverflow})});this._oNextButton=new k({icon:I.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(j){i._iFirstConditionIndex+=i._iConditionPageSize;i._clearConditions();i._fillConditions();},layoutData:new m({priority:K.NeverOverflow})});this._oRemoveAllButton=new k({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(j){i._aConditionKeys.forEach(function(l,n){if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}},i);this._iFirstConditionIndex=0;i.removeAllConditions();},layoutData:new m({priority:K.Low})});this._oAddButton=new k({icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),visible:true,press:function(j){var l=i._createConditionRow(i._oConditionsGrid,undefined,null,0);i._changeField(l);setTimeout(function(){l.keyField.focus();});i._updatePaginatorToolbar();},layoutData:new m({priority:K.Low})});this._oHeaderText=new q({wrapping:false,layoutData:new m({priority:K.NeverOverflow})});this._oPageText=new q({wrapping:false,textAlign:J.Center,layoutData:new m({priority:K.NeverOverflow})});this._oFilterField=new r({width:"12rem",layoutData:new m({priority:K.High})});this._oPaginatorToolbar=new O({height:"3rem",design:H.Transparent,content:[this._oHeaderText,new o(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};X.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var j=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var l=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}l.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(l&&l.setHeaderToolbar){if(!l.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);l.setHeaderToolbar(this._oPaginatorToolbar);l.attachExpand(function(Z){this._setToolbarElementVisibility(Z.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}var n=this._sOrgHeaderText+(i>0?" ("+i+")":"");l.setHeaderText(n);this._oHeaderText.setText(n);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(j+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(j>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var w=0;this._oConditionsGrid.getContent().forEach(function(Z){if(Z.select.getSelected()){w++;}},this);if(p==j&&(i-this._iFirstConditionIndex)>w){this._clearConditions();this._fillConditions();}};X.prototype._setToolbarElementVisibility=function(i){this._oPrevButton.setVisible(i);this._oNextButton.setVisible(i);this._oPageText.setVisible(i);this._oFilterField.setVisible(false);this._oAddButton.setVisible(i);this._oRemoveAllButton.setVisible(i);};X.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};X.prototype._clearConditions=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){for(var l in this._aConditionsFields){var n=this._aConditionsFields[l];if(j[n["ID"]]&&j.getContent().indexOf(j[n["ID"]])===-1){j[n["ID"]].destroy();}}},this);this._oConditionsGrid.destroyContent();};X.prototype._fillConditions=function(){var j,l;var i=0,p=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var w=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(p,this._iFirstConditionIndex+w));for(i=this._iFirstConditionIndex;i<n;i++){l=this._aConditionKeys[i];j=this._oConditionsMap[l];this._createConditionRow(this._oConditionsGrid,j,l);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<p){this._createConditionRow(this._oConditionsGrid);}};X.prototype._addCondition=function(j){var i=0;var l=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var n in this._oConditionsMap){if(i<l&&j===this._oConditionsMap[n]){this._createConditionRow(this._oConditionsGrid,j,n,i);}i++;}}this._updatePaginatorToolbar();};X.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions(),10);};X.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};X.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};X.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}b.media.detachHandler(this._handleMediaChange,this,b.media.RANGESETS.SAP_STANDARD);};X.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=R.register(this._oConditionsGrid,Q.proxy(this._onGridResize,this));this._onGridResize();}else{b.media.attachHandler(this._handleMediaChange,this,b.media.RANGESETS.SAP_STANDARD);}};X.prototype._getKeyFromConditionGrid=function(i){var j=i.data("_key");if(!j){j=this._createConditionKey();}return j;};X.prototype._createConditionKey=function(){var i=0;var j;do{j="condition_"+i;if(this.getExclude()){j="x"+j;}i++;}while(this._oConditionsMap[j]);return j;};X.prototype._createConditionRow=function(i,j,l,p){var n=null;var w;var Z=this;if(p===undefined){p=i.getContent().length;}var $=new M({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",l);$.addStyleClass("sapUiRespGridOverflowHidden");for(var _ in this._aConditionsFields){var a1;var b1=this._aConditionsFields[_];switch(b1["Control"]){case"CheckBox":a1=new s({enabled:false,visible:false,layoutData:new P({span:b1["Span"+this._sConditionType]})});if(b1["ID"]==="showIfGrouped"){a1.setEnabled(true);a1.setText(b1["Label"]);a1.attachSelect(function(){Z._changeField($);});a1.setSelected(j?j.showIfGrouped:true);}else{if(j){a1.setSelected(true);a1.setEnabled(true);}}break;case"ComboBox":if(b1["ID"]==="keyField"){a1=new t({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var c1=Q.proxy(a1.setSelectedKey,a1);a1.setSelectedKey=function(l){c1(l);var p1=Z.getValidationExecutor();if(p1){p1();}};var d1=Q.proxy(a1.setSelectedItem,a1);a1.setSelectedItem=function(p1){d1(p1);var q1=Z.getValidationExecutor();if(q1){q1();}};a1.setLayoutData(new P({span:b1["Span"+this._sConditionType]}));this._fillKeyFieldListItems(a1,this._aKeyFields);if(a1.attachSelectionChange){a1.attachSelectionChange(function(p1){var q1=Z.getValidationExecutor();if(q1){q1();}Z._handleSelectionChangeOnKeyField(i,$);});}if(a1.attachChange){a1.attachChange(function(p1){$.keyField.close();Z._handleChangeOnKeyField(i,$);});}if(a1.setSelectedItem){if(j){a1.setSelectedKey(j.keyField);this._aKeyFields.forEach(function(e1,p1){var q1=e1.key;if(q1===undefined){q1=e1;}if(j.keyField===q1){a1.setSelectedItem(a1.getItems()[p1]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!l){w=i.getContent()[p-1];if(w.keyField.getSelectedKey()){a1.setSelectedKey(w.keyField.getSelectedKey());}else{if(!a1.getSelectedItem()&&a1.getItems().length>0){a1.setSelectedItem(a1.getItems()[0]);}}}else{this._aKeyFields.some(function(e1,p1){if(e1.isDefault){a1.setSelectedItem(a1.getItems()[p1]);return true;}if(!a1.getSelectedItem()&&e1.type!=="boolean"){a1.setSelectedItem(a1.getItems()[p1]);}},this);if(!a1.getSelectedItem()&&a1.getItems().length>0){a1.setSelectedItem(a1.getItems()[0]);}}}else{this._aKeyFields.forEach(function(e1,p1){if(e1.isDefault){a1.setSelectedItem(a1.getItems()[p1]);}},this);}}}}if(b1["ID"]==="operation"){a1=new u({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new P({span:b1["Span"+this._sConditionType]})});a1.attachChange(function(){Z._handleChangeOnOperationField(i,$);});$[b1["ID"]]=a1;this._updateOperationItems(i,$);if(j){var e1=this._getCurrentKeyFieldItem($.keyField);var f1=this._oTypeOperations["default"];if(e1){if(e1.type&&this._oTypeOperations[e1.type]){f1=this._oTypeOperations[e1.type];}if(e1.operations){f1=e1.operations;}}f1.some(function(p1,q1){if(j.operation===p1){a1.setSelectedKey(p1);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&l===null){var w=i.getContent()[p-1];a1.setSelectedKey(w.operation.getSelectedKey());}}}}if(a1.getSelectedItem&&a1.getSelectedItem()){a1.setTooltip(a1.getSelectedItem().getTooltip()||a1.getSelectedItem().getText());}break;case"TextField":var g1=this._getCurrentKeyFieldItem($.keyField);a1=this._createValueField(g1,b1,$);a1.oTargetGrid=i;if(j&&j[b1["ID"]]!==undefined){var h1=j[b1["ID"]];if(a1 instanceof u){if(typeof h1==="boolean"){a1.setSelectedIndex(h1?2:1);}}else if(h1!==null&&$.oType){if(typeof h1==="string"&&$.oType.getName()!=="String"){try{h1=$.oType.parseValue(h1,"string");a1.setValue($.oType.formatValue(h1,"string"));}catch(i1){E.error("sap.m.P13nConditionPanel","Value '"+h1+"' does not have the expected type format for "+$.oType.getName()+".parseValue()");}}else{a1.setValue($.oType.formatValue(h1,"string"));}}else{a1.setValue(h1);}}break;case"Label":a1=new v({text:b1["Text"]+":",visible:this.getShowLabel(),layoutData:new P({span:b1["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");a1.oTargetGrid=i;break;}$[b1["ID"]]=a1;$.addContent(a1);}n=new U({layoutData:new P({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");$.addContent(n);$["ButtonContainer"]=n;var j1=new k({type:G.Transparent,icon:I.getIconURI("sys-cancel"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){Z._handleRemoveCondition(this.oTargetGrid,$);},layoutData:new P({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});j1.oTargetGrid=i;n.addContent(j1);$["remove"]=j1;var k1=new k({type:G.Transparent,icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){Z._handleAddCondition(this.oTargetGrid,$);},layoutData:new P({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});k1.oTargetGrid=i;k1.addStyleClass("conditionAddBtnFloatRight");n.addContent(k1);$["add"]=k1;i.insertContent($,p);this._updateOperationItems(i,$);this._changeOperationValueFields(i,$);this._updateAllConditionsEnableStates();this._updateConditionButtons(i);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(j){var l1=this._getFormatedConditionText(j.operation,j.value1,j.value2,j.exclude,j.keyField,j.showIfGrouped);j._oGrid=$;j.value=l1;this._oConditionsMap[l]=j;}var m1=$.operation.getSelectedKey();if(m1==="BT"&&$.value1.setMinDate&&$.value2.setMaxDate){var n1=$.value1.getDateValue();var o1=$.value2.getDateValue();this._updateMinMaxDate($,n1,o1);}else{this._updateMinMaxDate($,null,null);}return $;};X.prototype._handleRemoveCondition=function(i,j){var l=i.getContent().indexOf(j);this._removeCondition(i,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(l>=0){l=Math.min(l,i.getContent().length-1);var j=i.getContent()[l];setTimeout(function(){j.remove.focus();});}this._updatePaginatorToolbar();};X.prototype._handleAddCondition=function(i,j){var p=i.getContent().indexOf(j);var l=this._createConditionRow(i,undefined,null,p+1);this._changeField(l);setTimeout(function(){l.keyField.focus();});this._updatePaginatorToolbar();};X.prototype._getCurrentKeyFieldItem=function(i){if(i.getSelectedKey&&i.getSelectedKey()){var j=i.getSelectedKey();var l=this._aKeyFields;for(var n in l){var p=l[n];if(p.key===j){return p;}}}return null;};X.prototype._createValueField=function(j,n,p){var w;var Z;var $=this;var _={value:n["Value"],width:"100%",placeholder:n["Label"],change:function(i){$._validateAndFormatFieldValue(i);$._changeField(p);},layoutData:new P({span:n["Span"+this._sConditionType]})};if(j&&j.typeInstance){var a1=j.typeInstance;Z=this._findConfig(a1,"ctrl");if(Z==="DateTimePicker"&&a1.getMetadata().getName()==="sap.ui.model.odata.type.DateTime"){if(!(a1.oConstraints&&a1.oConstraints.isDateOnly)){E.error("sap.m.P13nConditionPanel","sap.ui.model.odata.type.DateTime without displayFormat = Date is not supported!");a1.oConstraints=Q.extend({},a1.oConstraints,{isDateOnly:true});}Z="DatePicker";}p.oType=a1;if(Z=="select"){var b1=[];var c1=j.values||this._oTypeValues[Z]||["",a1.formatValue(false,"string"),a1.formatValue(true,"string")];c1.forEach(function(i,e1){b1.push(new e({key:(e1===c1.length-1).toString(),text:i.toString()}));});_={width:"100%",items:b1,change:function(){$._changeField(p);},layoutData:new P({span:n["Span"+this._sConditionType]})};w=new u(_);}else if(Z=="TimePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new z(_);}else if(Z=="DateTimePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new A(_);}else if(Z=="DatePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new y(_);}else{w=new x(_);if(this._fSuggestCallback){j=this._getCurrentKeyFieldItem(p.keyField);if(j&&j.key){var d1=this._fSuggestCallback(w,j.key);if(d1){w._oSuggestProvider=d1;}}}}}else{p.oType=null;w=new x(_);}if(Z!=="boolean"&&Z!=="enum"&&w){w.onpaste=function(e1){var f1;if(window.clipboardData){f1=window.clipboardData.getData("Text");}else{f1=e1.originalEvent.clipboardData.getData('text/plain');}var p=e1.srcControl.getParent();var g1=f1.split(/\r\n|\r|\n/g);var h1=p.operation;var op=h1.getSelectedKey();if(g1&&g1.length>1&&op!=="BT"){setTimeout(function(){var i1=g1?g1.length:0;var j1=$._getCurrentKeyFieldItem(p.keyField);var h1=p.operation;for(var i=0;i<i1;i++){if($._aConditionKeys.length>=$._getMaxConditionsAsNumber()){break;}if(g1[i]){var k1={"key":$._createConditionKey(),"exclude":$.getExclude(),"operation":h1.getSelectedKey(),"keyField":j1.key,"value1":g1[i],"value2":null};$._addCondition2Map(k1);$.fireDataChange({key:k1.key,index:k1.index,operation:"add",newData:k1});}}$._clearConditions();$._fillConditions();},0);}};}if(j&&j.maxLength&&w.setMaxLength){var l=-1;if(typeof j.maxLength==="string"){l=parseInt(j.maxLength,10);}if(typeof j.maxLength==="number"){l=j.maxLength;}if(l>0&&(!w.getShowSuggestion||!w.getShowSuggestion())){w.setMaxLength(l);}}return w;};X.prototype._fillOperationListItems=function(i,j,l){if(l==="_STRING_"){l="";}if(l==="_TIME_"||l==="_DATETIME_"){l="_DATE_";}if(l==="_BOOLEAN_"||l==="_NUMC_"){l="";}i.destroyItems();for(var n in j){var p=this._oRb.getText("CONDITIONPANEL_OPTION"+l+j[n]);if(p.startsWith("CONDITIONPANEL_OPTION")){p=this._oRb.getText("CONDITIONPANEL_OPTION"+j[n]);}i.addItem(new L({key:j[n],text:p,tooltip:p}));}};X.prototype._fillKeyFieldListItems=function(i,j){i.destroyItems();for(var l in j){var n=j[l];i.addItem(new L({key:n.key,text:n.text,tooltip:n.tooltip?n.tooltip:n.text}));}i.setEditable(i.getItems().length>1);};X.prototype._handleChangeOnOperationField=function(i,j){this._changeOperationValueFields(i,j);this._changeField(j);};X.prototype._handleSelectionChangeOnKeyField=function(i,j){if(this._sConditionType==="Filter"){this._updateOperationItems(i,j);this._createAndUpdateValueFields(i,j);this._changeOperationValueFields(i,j);}this._changeField(j);};X.prototype._handleChangeOnKeyField=function(i,j){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false,false,j.keyField);}};X.prototype._createAndUpdateAllKeyFields=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._createAndUpdateValueFields(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};X.prototype._createAndUpdateValueFields=function(i,j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=function(j,p,w){var Z=p.getValue?p.getValue():"";var $=j.indexOfContent(p);j.removeContent(p);if(p._oSuggestProvider){p._oSuggestProvider.destroy();p._oSuggestProvider=null;}p.destroy();var _=this._aConditionsFields[w];p=this._createValueField(l,_,j);j[_["ID"]]=p;j.insertContent(p,$===-1?j.indexOfContent(j.operation)+1:$);var a1,b1;if(j.oType&&Z){try{a1=j.oType.parseValue(Z,"string");j.oType.validateValue(a1);b1=j.oType.formatValue(a1,"string");p.setValue(b1);}catch(c1){var d1=c1.message;this._makeFieldValid(p,false,d1);p.setValue(Z);}}};Q.proxy(n,this)(j,j.value1,5);Q.proxy(n,this)(j,j.value2,6);};X.prototype._updateAllOperations=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._updateOperationItems(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};X.prototype._updateOperationItems=function(i,j){var l="";var n=this._getCurrentKeyFieldItem(j.keyField);var p=j.operation;var w=this._oTypeOperations["default"];var Z=p.getSelectedItem();if(n){if(n.type&&n.type!==""&&this._oTypeOperations[n.type]){l=n.type;w=this._oTypeOperations[l];}if(n.operations){w=n.operations;}}this._fillOperationListItems(p,w,l?"_"+l.toUpperCase()+"_":"");if(Z&&p.getItemByKey(Z.getKey())){p.setSelectedKey(Z.getKey());}else{p.setSelectedItem(p.getItems()[0]);}this._sConditionType="Filter";if(w[0]===Y.Ascending||w[0]===Y.Descending){this._sConditionType="Sort";}if(w[0]===Y.GroupAscending||w[0]===Y.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(j);};X.prototype._updateKeyFieldItems=function(l,p,w,Z){var n=l.getContent().length;var i;var $={};if(!p){for(i=0;i<n;i++){var _=l.getContent()[i].keyField;var a1=_.getSelectedKey();if(a1!=null&&a1!==""){$[a1]=true;}}}for(i=0;i<n;i++){var _=l.getContent()[i].keyField;var b1=l.getContent()[i].select;var c1=_.getSelectedKey();var j=0;var d1=this._aKeyFields;if(_!==Z){if(w){j=d1.length-1;}else{_.destroyItems();}for(j;j<d1.length;j++){var e1=d1[j];if(e1.key==null||e1.key===""||!$[e1.key]||e1.key===c1){_.addItem(new L({key:e1.key,text:e1.text,tooltip:e1.tooltip?e1.tooltip:e1.text}));}}_.setEditable(_.getItems().length>1);}if(c1){_.setSelectedKey(c1);}else if(_.getItems().length>0){_.setSelectedItem(_.getItems()[0]);}if(!b1.getSelected()){this._aKeyFields.some(function(f1,g1){if(f1.isDefault){_.setSelectedItem(_.getItems()[g1]);return true;}if(!_.getSelectedItem()){if(f1.type!=="boolean"){_.setSelectedItem(_.getItems()[g1]);}}},this);}if(_.getSelectedItem()){_.setTooltip(_.getSelectedItem().getTooltip()||_.getSelectedItem().getText());}}};X.prototype._changeOperationValueFields=function(i,j){var l=j.operation;var n=l.getSelectedKey();var p=j.value1;var w=j.value2;var Z=j.showIfGrouped;if(!n){return;}if(n===Y.BT){if(p.setPlaceholder&&p.getPlaceholder()!==this._sFromLabelText){p.setPlaceholder(this._sFromLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.setPlaceholder&&w.getPlaceholder()!==this._sToLabelText){w.setPlaceholder(this._sToLabelText);}if(!w.getVisible()){w.setVisible(true);j.insertContent(w,j.getContent().length-1);}}else{if(n===Y.GroupAscending||n===Y.GroupDescending){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}if(l.getVisible()){l.setVisible(false);j.removeContent(l);}Z.setVisible(this._getMaxConditionsAsNumber()!=1);}else{if(n===Y.NotEmpty||n===Y.Empty||n===Y.Initial||n===Y.Ascending||n===Y.Descending||n===Y.Total||n===Y.Average||n===Y.Minimum||n===Y.Maximum){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}j.removeContent(Z);}else{if(p.setPlaceholder&&p.getPlaceholder()!==this._sValueLabelText){p.setPlaceholder(this._sValueLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}}}}this._adjustValue1Span(j);};X.prototype._adjustValue1Span=function(i){if(this._sConditionType==="Filter"&&i.value1&&i.operation){var j=i.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(j.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=i.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};X.prototype._getIndexOfCondition=function(i){var j=-1;i.getParent().getContent().some(function(l){if(l.select.getSelected()){j++;}return(l===i);},this);return j+this._iFirstConditionIndex;};X.prototype._makeFieldValid=function(i,j,l){if(j){i.setValueState(V.None);i.setValueStateText("");}else{i.setValueState(V.Warning);i.setValueStateText(l?l:this._sValidationDialogFieldMessage);}};X.prototype._validateAndFormatFieldValue=function(i){var j=i.oSource;var l=j.getParent();var n;if(j.getDateValue&&i){n=i.getParameter("value");var p=i.getParameter("valid");this._makeFieldValid(j,p);return;}else{n=j.getValue&&j.getValue();}if(!l){return;}if(this.getDisplayFormat()==="UpperCase"&&n){n=n.toUpperCase();j.setValue(n);}if(l.oType&&n){try{var w=l.oType.parseValue(n,"string");l.oType.validateValue(w);this._makeFieldValid(j,true);n=l.oType.formatValue(w,"string");j.setValue(n);}catch(Z){var $=Z.message;this._makeFieldValid(j,false,$);}}else{this._makeFieldValid(j,true);}};X.prototype._updateMinMaxDate=function(i,j,l){if(i.value1.setMinDate&&i.value2.setMaxDate){if(i.value1&&i.value1.setMaxDate){i.value1.setMaxDate(l instanceof Date?l:null);}if(i.value2&&i.value2.setMinDate){i.value2.setMinDate(j instanceof Date?j:null);}}};X.prototype._changeField=function(i,j){var l=i.keyField.getSelectedKey();if(i.keyField.getSelectedItem()){i.keyField.setTooltip(i.keyField.getSelectedItem().getTooltip()||i.keyField.getSelectedItem().getText());}else{i.keyField.setTooltip(null);}var n=i.operation.getSelectedKey();if(i.operation.getSelectedItem()){i.operation.setTooltip(i.operation.getSelectedItem().getTooltip()||i.operation.getSelectedItem().getText());}else{i.operation.setTooltip(null);}var p=this._getValueTextFromField(i.value1);var w=p;if(i.oType&&p){try{w=i.oType.parseValue(p,"string");i.oType.validateValue(w);}catch(Z){p="";E.error("sap.m.P13nConditionPanel","not able to parse value1 "+p+" with type "+i.oType.getName());}}var $=this._getValueTextFromField(i.value2);var _=$;if(i.oType&&$){try{_=i.oType.parseValue($,"string");i.oType.validateValue(_);}catch(Z){$="";E.error("sap.m.P13nConditionPanel","not able to parse value2 "+$+" with type "+i.oType.getName());}}if(n==="BT"){this._updateMinMaxDate(i,w,_);}else{this._updateMinMaxDate(i,null,null);}var a1=this._getCurrentKeyFieldItem(i.keyField);if(a1&&a1.type==="numc"){if([Y.Contains,Y.EndsWith].indexOf(n)!=-1){w=i.oType.formatValue(w,"string");}}var b1=i.showIfGrouped.getSelected();var c1=this.getExclude();var d1=i.select;var e1="";var f1;if(l===""||l==null){l=null;f1=this._getKeyFromConditionGrid(i);this._removeConditionFromMap(f1);this._enableCondition(i,false);var g1=this._getIndexOfCondition(i);if(d1.getSelected()){d1.setSelected(false);d1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:f1,index:g1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(i,true);e1=this._getFormatedConditionText(n,p,$,c1,l,b1);var h1={"value":e1,"exclude":c1,"operation":n,"keyField":l,"value1":w,"value2":n===Y.BT?_:null,"showIfGrouped":b1};f1=this._getKeyFromConditionGrid(i);if(e1!==""){d1.setSelected(true);d1.setEnabled(true);var n="update";if(!this._oConditionsMap[f1]){n="add";}this._oConditionsMap[f1]=h1;if(n==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(i),0,f1);}i.data("_key",f1);this.fireDataChange({key:f1,index:this._getIndexOfCondition(i),operation:n,newData:h1});}else if(this._oConditionsMap[f1]!==undefined){this._removeConditionFromMap(f1);i.data("_key",null);var g1=this._getIndexOfCondition(i);if(d1.getSelected()){d1.setSelected(false);d1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:f1,index:g1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};X.prototype._getValueTextFromField=function(i){if(i instanceof u){return i.getSelectedItem()?i.getSelectedItem().getText():"";}return i.getValue();};X.prototype._updateAllConditionsEnableStates=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=l&&l.key!==undefined?l.key:l;var p=n!==""&&n!==null;this._enableCondition(j,p);},this);};X.prototype._enableCondition=function(i,j){i.operation.setEnabled(j);i.value1.setEnabled(j);i.value2.setEnabled(j);i.showIfGrouped.setEnabled(j);};X.prototype._removeCondition=function(i,j){var l=this._getKeyFromConditionGrid(j);var n=-1;if(j.select.getSelected()){n=this._getIndexOfCondition(j);}this._removeConditionFromMap(l);j.destroy();if(i.getContent().length<1){this._createConditionRow(i);}else{this._updateConditionButtons(i);}if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}};X.prototype._updateConditionButtons=function(j){var l=this._getMaxConditionsAsNumber();var n=j.getContent().length;for(var i=0;i<n;i++){var p=j.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<l))||(i===n-1&&i<l-1)){p.removeStyleClass("displayNone");}else{p.addStyleClass("displayNone");}var w=j.getContent()[i].remove;if(l===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){w.addStyleClass("displayNone");}else{w.removeStyleClass("displayNone");}}};X.prototype.validateConditions=function(){var j=this;var l=function(n){var p=true;for(var i=0;i<n.length;i++){var w=n[i];var Z=j._checkCondition(w,i===n.length-1);p=p&&Z;}return p;};return l(this._oConditionsGrid.getContent());};X.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(i){var j=i.value1;var l=i.value2;j.setValueState(V.None);j.setValueStateText("");l.setValueState(V.None);l.setValueStateText("");},this);};X.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(j){if(j.value1.getValueState()!==V.None||j.value2.getValueState()!==V.None){i.push(j);}},this);i.forEach(function(j){this._removeCondition(this._oConditionsGrid,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};X.prototype._checkCondition=function(i,j){var l=true;var n=i.value1;var p=i.value2;var w=n&&(n.getVisible()&&!this._getValueTextFromField(n));var Z=n&&n.getVisible()&&n.getValueState?n.getValueState():V.None;var $=p&&(p.getVisible()&&!this._getValueTextFromField(p));var _=p&&p.getVisible()&&p.getValueState?p.getValueState():V.None;var a1=i.operation.getSelectedKey();if(a1===Y.BT){if(!w?$:!$){if(w){n.setValueState(V.Warning);n.setValueStateText(this._sValidationDialogFieldMessage);}if($){p.setValueState(V.Warning);p.setValueStateText(this._sValidationDialogFieldMessage);}l=false;}else if(Z!==V.None||_!==V.None){l=false;}else{n.setValueState(V.None);n.setValueStateText("");p.setValueState(V.None);p.setValueStateText("");}}if((n.getVisible()&&n.getValueState&&n.getValueState()!==V.None)||(p.getVisible()&&p.getValueState&&p.getValueState()!==V.None)){l=false;}return l;};X.prototype._getFormatedConditionText=function(j,l,n,p,w,Z){var $=X.getFormatedConditionText(j,l,n,p);if(!$){switch(j){case Y.Initial:$="=''";break;case Y.NotEmpty:$="!''";break;case Y.Ascending:$="ascending";break;case Y.GroupAscending:$="ascending";$+=" showIfGrouped:"+Z;break;case Y.Descending:$="descending";break;case Y.GroupDescending:$="descending";$+=" showIfGrouped:"+Z;break;case Y.Total:$="total";break;case Y.Average:$="average";break;case Y.Minimum:$="minimum";break;case Y.Maximum:$="maximum";break;}if(p&&$!==""){$="!("+$+")";}}if(this._aKeyFields&&this._aKeyFields.length>1){var _=null;for(var i=0;i<this._aKeyFields.length;i++){var a1=this._aKeyFields[i];if(typeof a1!=="string"){if(a1.key===w&&a1.text){_=a1.text;}}}if(_&&$!==""){$=_+": "+$;}}return $;};var Y=sap.m.P13nConditionOperation={BT:"BT",EQ:"EQ",Contains:"Contains",StartsWith:"StartsWith",EndsWith:"EndsWith",LT:"LT",LE:"LE",GT:"GT",GE:"GE",Initial:"Initial",Empty:"Empty",NotEmpty:"NotEmpty",Ascending:"Ascending",Descending:"Descending",GroupAscending:"GroupAscending",GroupDescending:"GroupDescending",Total:"Total",Average:"Average",Minimum:"Minimum",Maximum:"Maximum"};X._oConditionMap={"EQ":"=$0","GT":">$0","GE":">=$0","LT":"<$0","LE":"<=$0","Contains":"*$0*","StartsWith":"$0*","EndsWith":"*$0","BT":"$0...$1","Empty":"<$r>"};(function(){var _=sap.ui.getCore().getLibraryResourceBundle("sap.m");X._oConditionMap[Y.Empty]=X._oConditionMap[Y.Empty].replace("$r",_.getText("CONDITIONPANEL_OPTIONEmpty"));})();X._templateReplace=function(i,j){return i.replace(/\$\d/g,function(l){return j[parseInt(l.substr(1),10)];});};X.getFormatedConditionText=function(i,j,l,n){var p="";switch(i){case Y.Empty:p=X._templateReplace(X._oConditionMap[i],[]);break;case Y.EQ:case Y.GT:case Y.GE:case Y.LT:case Y.LE:case Y.Contains:case Y.StartsWith:case Y.EndsWith:if(j!==""&&j!==undefined){p=X._templateReplace(X._oConditionMap[i],[j]);}break;case Y.BT:if(j!==""&&j!==undefined){if(l!==""&&l!==undefined){p=X._templateReplace(X._oConditionMap[i],[j,l]);}}break;default:break;}if(n&&p!==""){p="!("+p+")";}return p;};X.prototype._updateLayout=function(j){if(!this._oConditionsGrid){return;}var l=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var p=n;if(j.name==="Tablet"){p=5;}if(j.name==="Phone"){p=3;}if(this._sConditionType==="Filter"){for(var i=0;i<l.length;i++){var w=l[i];w.ButtonContainer.removeStyleClass("floatRight");w.removeContent(w.ButtonContainer);w.insertContent(w.ButtonContainer,p);if(!this.getAlwaysShowAddIcon()){if(p!==n){w.ButtonContainer.removeContent(w.add);w.addContent(w.add);}else{w.removeContent(w.add);w.ButtonContainer.addContent(w.add);}}}}};X.prototype._onGridResize=function(){if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var i=this._oConditionsGrid.getContent()[0];if(i.remove&&i.remove.$().position()){var w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var j=i.remove.$().position().left-w+i.remove.$().width();this._oPaginatorToolbar.setWidth(j+"px");}}var l=this._oConditionsGrid.getDomRef();if(!l){return;}if(!Q(l).is(":visible")){return;}var w=l.clientWidth;var n={};if(w<=this._iBreakPointTablet){n.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){n.name="Tablet";}else{n.name="Desktop";}if(n.name==="Phone"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Tablet"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Desktop"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}};X.prototype._findConfig=function(i,j){if(typeof i==="object"){i=i.getMetadata().getName();}var l;while(i&&!(l=this._getConfig(i,j))){i=this._getParentType(i);}return l;};X.prototype._getConfig=function(i,j){var l=this._mOpsForType[i];if(l){return l[j];}};X.prototype._getParentType=function(i){return this._mTypes[i];};X.prototype._mTypes={"base":undefined,"string":"base","numeric":"base","date":"base","time":"base","boolean":"base","int":"numeric","float":"numeric","sap.ui.model.type.Boolean":"boolean","sap.ui.model.type.Date":"date","sap.ui.model.type.FileSize":"string","sap.ui.model.type.Float":"float","sap.ui.model.type.Integer":"int","sap.ui.model.type.String":"string","sap.ui.model.type.Time":"time","sap.ui.comp.odata.type.StringDate":"date","sap.ui.model.odata.type.Boolean":"boolean","sap.ui.model.odata.type.Byte":"int","sap.ui.model.odata.type.Date":"date","sap.ui.model.odata.type.DateTime":"datetime","sap.ui.model.odata.type.DateTimeOffset":"datetime","sap.ui.model.odata.type.Decimal":"float","sap.ui.model.odata.type.Double":"float","sap.ui.model.odata.type.Single":"float","sap.ui.model.odata.type.Guid":"string","sap.ui.model.odata.type.Int16":"int","sap.ui.model.odata.type.Int32":"int","sap.ui.model.odata.type.Int64":"int","sap.ui.model.odata.type.Raw":"string","sap.ui.model.odata.type.SByte":"int","sap.ui.model.odata.type.String":"string","sap.ui.model.odata.type.Time":"time","sap.ui.model.odata.type.TimeOfDay":"time","Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.Date":"sap.ui.model.odata.type.Date","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Single":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};X.prototype._mOpsForType={"base":{ctrl:"input"},"string":{ctrl:"input"},"date":{ctrl:"DatePicker"},"datetime":{ctrl:"DateTimePicker"},"numeric":{ctrl:"input"},"time":{ctrl:"TimePicker"},"boolean":{ctrl:"select"}};return X;});
