/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/DateRange','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarWeekInterval','sap/ui/unified/CalendarOneMonthInterval','sap/ui/Device','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/m/Select','sap/m/Button','sap/m/Toolbar','sap/m/Table','sap/m/Column','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/StandardListItem','sap/m/StandardListItemRenderer','sap/m/PlanningCalendarRow','sap/m/PlanningCalendarRenderer','sap/m/library',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(C,M,u,a,b,D,c,d,e,f,g,h,k,E,R,l,I,m,n,o,S,B,T,p,q,r,s,t,v,P,w,x,y,L,Q){"use strict";var z=u.CalendarDayType;var A=x.ListMode;var F=x.ToolbarDesign;var G=x.ButtonType;var H=x.PlanningCalendarBuiltInView;var J=x.ScreenSize;var K=u.CalendarAppointmentVisualization;var N=u.GroupAppointmentsMode;var O=u.CalendarIntervalType;var U="DragDropConfig";var V="ResizeConfig";var W="CreateConfig";var X="-CLI";var Y=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:O.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:N.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:K.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent"},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{row:{type:"sap.m.PlanningCalendarRow"}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var Z=["_oTimeInterval","_oDateInterval","_oMonthInterval","_oWeekInterval","_oOneMonthInterval"],$={};$[O.Day]={sInstanceName:"_oDateInterval",sIdSuffix:"-DateInt",oClass:f};$[O.Week]={sInstanceName:"_oWeekInterval",sIdSuffix:"-WeekInt",oClass:g};$[O.OneMonth]={sInstanceName:"_oOneMonthInterval",sIdSuffix:"-OneMonthInt",oClass:h};var _=J.Desktop;var a1=[H.Hour,H.Day,H.Month,H.Week,H.OneMonth];var b1=C.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addClass("sapMPlanCalHead");i.writeClasses();i.write(">");var D1=j.getToolbar();if(D1){i.renderControl(D1);}var E1=j.getAllCheckBox();if(E1){i.renderControl(E1);}i.write("</div>");}});Y.prototype.init=function(){this._iBreakPointTablet=k.media._predefinedRangeSets[k.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=k.media._predefinedRangeSets[k.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=k.media._predefinedRangeSets[k.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(k.system.phone||Q('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if(k.system.tablet||Q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=new S(i+"-IntType",{maxWidth:"15rem",ariaLabelledBy:i+"-SelDescr"});this._oIntervalTypeSelect.attachEvent("change",c1,this);this._oTodayButton=new B(i+"-Today",{text:this._oRB.getText("PLANNINGCALENDAR_TODAY"),type:G.Transparent});this._oTodayButton.attachEvent("press",this._handleTodayPress,this);this._oHeaderToolbar=new T(i+"-HeaderToolbar",{design:F.Transparent,content:[this._oIntervalTypeSelect,this._oTodayButton]});this._oCalendarHeader=new b1(i+"-CalHead",{toolbar:this._oHeaderToolbar});this._oInfoToolbar=new T(i+"-InfoToolbar",{height:"auto",design:F.Transparent,content:[this._oCalendarHeader,this._oTimeInterval]});var j=new p(i+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,mode:A.SingleSelectMaster,columns:[new q({styleClass:"sapMPlanCalRowHead"}),new q({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:_,demandPopin:true})],ariaLabelledBy:i+"-Descr"});j.attachEvent("selectionChange",s1,this);j.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=j.$().find(".sapMPlanCalRowHead > div.sapMLIB").click(function(D1){var E1=Q(D1.currentTarget).control(0),F1=o1(E1.getParent());this.fireRowHeaderClick({row:F1});}.bind(this));}},false,this);this.setAggregation("table",j,true);this.setStartDate(new Date());this._resizeProxy=Q.proxy(g1,this);this._fnCustomSortedAppointments=undefined;};Y.prototype.exit=function(){if(this._sResizeListener){l.deregister(this._sResizeListener);this._sResizeListener=undefined;}k.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();Z.forEach(function(D1){if(this[D1]){this[D1]._oPlanningCalendar=undefined;this[D1].destroy();this[D1]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this.getToolbarContent().length==0&&this._oToolbar){this._oToolbar.destroy();this._oToolbar=undefined;}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};Y.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimeInterval&&!this._oDateInterval&&!this._oMonthInterval&&!this._oWeekInterval&&!this._oOneMonthInterval)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}w1.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updateTodayButtonState();k.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;};Y.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};Y.prototype._dateMatchesVisibleRange=function(i,j){var D1=this._getView(j,!this._bBeforeRendering);if(!D1){return false;}var E1=D1.getIntervalType(),F1=$[E1],G1=F1?this[F1.sInstanceName]:null,H1=false;if(G1&&G1._dateMatchesVisibleRange){H1=G1._dateMatchesVisibleRange(i);}return H1;};Y.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};g1.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=l.register(this,this._resizeProxy);}if(k.system.phone&&this.getStickyHeader()){k.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);};Y.prototype.setStartDate=function(i){var j,D1;if(!i){i=new Date();}else{a._checkJSDateObject(i);}if(this.getViewKey()===H.Week){j=a.getFirstDateOfWeek(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(j,true).getTime());}if(this.getViewKey()===H.OneMonth){D1=a.getFirstDateOfMonth(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(D1,true).getTime());}if(y(i,this.getStartDate())){this._updateTodayButtonState();return this;}var E1=i.getFullYear();a._checkYearInValidRange(E1);var F1=this.getMinDate();if(F1&&F1.getTime()>i.getTime()){L.warning("StartDate < minDate -> StartDate set to minDate",this);i=new Date(F1.getTime());}else{var G1=this.getMaxDate();if(G1&&G1.getTime()<i.getTime()){L.warning("StartDate > maxDate -> StartDate set to minDate",this);if(F1){i=new Date(F1.getTime());}else{i=new Date(1,0,1);i.setFullYear(1);}}}this.setProperty("startDate",i,true);Z.forEach(function(H1){if(this[H1]){this[H1].setStartDate(new Date(i.getTime()));}},this);this._setRowsStartDate(new Date(i.getTime()));if(this.getViewKey()===H.Week||this.getViewKey()===H.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);}return this;};Y.prototype.setMinDate=function(i){if(y(i,this.getMinDate())){return this;}var j=this.getMaxDate();if(i){a._checkJSDateObject(i);var D1=i.getFullYear();a._checkYearInValidRange(D1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;Z.forEach(function(G1){if(this[G1]){this[G1].setMinDate(new Date(i.getTime()));}},this);if(j&&j.getTime()<i.getTime()){L.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var E1=this.getStartDate();if(E1&&E1.getTime()<i.getTime()){L.warning("StartDate < minDate -> StartDate set to minDate",this);E1=new Date(i.getTime());this.setStartDate(E1);}}else{this.setProperty("minDate",undefined,true);Z.forEach(function(G1){if(this[G1]){this[G1].setMinDate();}},this);}var F1=new Date();if(i&&F1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||F1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};Y.prototype.setMaxDate=function(i){if(y(i,this.getMaxDate())){return this;}var j=this.getMinDate();if(i){a._checkJSDateObject(i);var D1=i.getFullYear();a._checkYearInValidRange(D1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;Z.forEach(function(G1){if(this[G1]){this[G1].setMaxDate(new Date(i.getTime()));}},this);if(j&&j.getTime()>i.getTime()){L.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var E1=this.getStartDate();if(E1&&E1.getTime()>i.getTime()){L.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){E1=new Date(j.getTime());}else{E1=new Date(1,0,1);E1.setFullYear(1);}this.setStartDate(E1);}}else{this.setProperty("maxDate",undefined,true);Z.forEach(function(G1){if(this[G1]){this[G1].setMaxDate();}},this);}var F1=new Date();if(i&&F1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||F1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};Y.prototype.setViewKey=function(j){var D1,E1,F1,G1=this.getViewKey(),H1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);if(this._oInfoToolbar.getContent().length>1){this._oInfoToolbar.removeContent(1);}if(j===H.Week||j===H.OneMonth){E1=this.getStartDate();this.setStartDate(new Date(E1.getTime()));if(E1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}var I1=this.getStartDate();var J1=this.getMinDate();var K1=this.getMaxDate();var L1=this._getView(j,!this._bBeforeRendering);if(!L1){this._bCheckView=true;this.invalidate();}else{var M1=L1.getIntervalType();var N1=this._getIntervals(L1);this._bCheckView=false;switch(M1){case O.Hour:if(!this._oTimeInterval){this._oTimeInterval=new sap.ui.unified.CalendarTimeInterval(this.getId()+"-TimeInt",{startDate:new Date(I1.getTime()),items:N1,pickerPopup:true,legend:this.getLegend()});this._oTimeInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oTimeInterval.attachEvent("select",this._handleCalendarSelect,this);this._oTimeInterval._oPlanningCalendar=this;this._oTimeInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(J1){this._oTimeInterval.setMinDate(new Date(J1.getTime()));}if(K1){this._oTimeInterval.setMaxDate(new Date(K1.getTime()));}}else if(this._oTimeInterval.getItems()!=N1){this._oTimeInterval.setItems(N1);}this._oInfoToolbar.addContent(this._oTimeInterval);break;case O.Day:case O.Week:case O.OneMonth:F1=$[M1];D1=this[F1.sInstanceName];if(!D1){D1=new F1.oClass(this.getId()+F1.sIdSuffix,{startDate:new Date(I1.getTime()),days:N1,showDayNamesLine:this.getShowDayNamesLine(),pickerPopup:true,legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});D1.attachEvent("startDateChange",this._handleStartDateChange,this);D1.attachEvent("select",this._handleCalendarSelect,this);if(j===H.OneMonth){D1._setRowsStartDate=this._setRowsStartDate.bind(this);}D1._oPlanningCalendar=this;D1.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(J1){D1.setMinDate(new Date(J1.getTime()));}if(K1){D1.setMaxDate(new Date(K1.getTime()));}}else if(D1.getDays()!==N1){D1.setDays(N1);}this._oInfoToolbar.addContent(D1);this[F1.sInstanceName]=D1;break;case O.Month:if(!this._oMonthInterval){this._oMonthInterval=new sap.ui.unified.CalendarMonthInterval(this.getId()+"-MonthInt",{startDate:new Date(I1.getTime()),months:N1,pickerPopup:true,legend:this.getLegend()});this._oMonthInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oMonthInterval.attachEvent("select",this._handleCalendarSelect,this);this._oMonthInterval._oPlanningCalendar=this;this._oMonthInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(J1){this._oMonthInterval.setMinDate(new Date(J1.getTime()));}if(K1){this._oMonthInterval.setMaxDate(new Date(K1.getTime()));}}else if(this._oMonthInterval.setMonths()!=N1){this._oMonthInterval.setMonths(N1);}this._oInfoToolbar.addContent(this._oMonthInterval);break;default:throw new Error("Unknown IntervalType: "+M1+"; "+this);}var O1=this.getRows();for(var i=0;i<O1.length;i++){var P1=O1[i];var Q1=r1(P1);Q1.setIntervalType(M1);Q1.setIntervals(N1);Q1.setShowSubIntervals(L1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);e1.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));f1.call(this,this.getShowDayNamesLine(),!!D1);}}if(this._oOneMonthInterval&&j===H.OneMonth){this._oOneMonthInterval._setDisplayMode(this._iSize);this._oOneMonthInterval._adjustSelectedDate(b.fromLocalJSDate(E1));if(this._iSize<2){this._setRowsStartDate(E1);}}else if(this._oOneMonthInterval&&G1===H.OneMonth&&this._oOneMonthInterval.getSelectedDates().length){H1=this._oOneMonthInterval.getSelectedDates()[0].getStartDate();if(H1){this.setStartDate(H1);}}this._updateTodayButtonState();return this;};Y.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),D1=$[j];return!!D1&&!!D1.oClass.prototype.setShowWeekNumbers;};Y.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),D1=$[j];return!!D1&&!!D1.oClass.prototype.setShowDayNamesLine;};Y.prototype._getIntervalInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),D1=$[j],E1;if(D1){E1=this[D1.sInstanceName];}return E1;};Y.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var D1=j.getKey(),E1=this._viewAllowsWeekNumbers(D1),F1=this._getIntervalInstanceByViewKey(D1);if(F1&&E1){this._getIntervalInstanceByViewKey(D1).setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===D1){e1.call(this,i,E1);}},this);return this;};Y.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var D1=this.getRows();for(var i=0;i<D1.length;i++){var E1=D1[i];r1(E1).setShowIntervalHeaders(j);}return this;};Y.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var D1=this.getRows();for(var i=0;i<D1.length;i++){var E1=D1[i];r1(E1).setShowEmptyIntervalHeaders(j);}return this;};Y.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var D1=this.getRows();for(var i=0;i<D1.length;i++){var E1=D1[i];r1(E1).setGroupAppointmentsMode(j);}return this;};Y.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var D1=this.getRows();for(var i=0;i<D1.length;i++){var E1=D1[i];r1(E1).setAppointmentsReducedHeight(j);}return this;};Y.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var D1=this.getRows();for(var i=0;i<D1.length;i++){var E1=D1[i];r1(E1).setAppointmentsVisualization(j);}return this;};Y.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);A1.call(this);B1.call(this);return this;};Y.prototype.setShowDayNamesLine=function(i){var j,D1,E1,F1=!!this.getDomRef(),G1=this.getViewKey();for(j in $){D1=$[j].sInstanceName;if(this[D1]){E1=this[D1];E1.setShowDayNamesLine(i);if(F1&&j===G1){f1.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};Y.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(k.system.phone){if(i){k.orientation.attachHandler(this._updateStickyHeader,this);}else{k.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};Y.prototype._updateStickyHeader=function(){var i=[],j=this.getStickyHeader(),D1=this.getViewKey()===H.OneMonth&&this._iSize<2,E1=j&&!k.system.phone&&!D1,F1=j&&!(k.system.phone&&k.orientation.landscape)&&!D1;if(this._oToolbar&&E1){i.push(sap.m.Sticky.HeaderToolbar);}if(this._oInfoToolbar&&F1){i.push(sap.m.Sticky.InfoToolbar);}this.getAggregation("table").setSticky(i);};Y.prototype.addRow=function(i){this.addAggregation("rows",i,true);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(i));return this;};Y.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(i),j,true);return this;};Y.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true),D1=this.getAggregation("table");D1.removeItem(p1(j),true);this._handleRowRemoval(j);z1.call(this);B1.call(this);return j;};Y.prototype.removeAllRows=function(){var i=this.removeAllAggregation("rows",true),j=this.getAggregation("table");j.removeAllItems(true);i.forEach(this._handleRowRemoval,this);z1.call(this);B1.call(this);return i;};Y.prototype.destroyRows=function(){var i=this.destroyAggregation("rows",true);var j=this.getAggregation("table");j.destroyItems(true);z1.call(this);B1.call(this);return i;};Y.prototype.addToolbarContent=function(i){this.addAggregation("toolbarContent",i,true);t1.call(this);return this;};Y.prototype.insertToolbarContent=function(i,j){this.insertAggregation("toolbarContent",i,j);t1.call(this);return this;};Y.prototype.removeToolbarContent=function(i){var j=this.removeAggregation("toolbarContent",i,true);t1.call(this);return j;};Y.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent",true);t1.call(this);return i;};Y.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent",true);t1.call(this);return i;};Y.prototype.indexOfContent=function(i){return this.indexOfToolbarContent(i);};Y.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);A1.call(this);B1.call(this);if(i){this.selectAllRows(false);}else{z1.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};Y.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};Y.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var D1=this.getRows(),E1=this.getLegend()&&sap.ui.getCore().byId(this.getLegend()),F1;for(var i=0;i<D1.length;i++){var G1=D1[i];r1(G1).setLegend(j);}Z.forEach(function(H1){if(this[H1]){this[H1].setLegend(j);}},this);if(E1){F1=new M(function(H1){this.invalidate();}.bind(this));F1.observe(E1,{destroy:true});}return this;};Y.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};Y.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};Y.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};Y.prototype.invalidate=function(i){var j=i&&i instanceof D;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var D1=this.getViewKey();var E1=this._getView(D1);var F1=E1.getIntervalType();switch(F1){case O.Hour:if(this._oTimeInterval){this._oTimeInterval.invalidate(arguments);}break;case O.Day:if(this._oDateInterval){this._oDateInterval.invalidate(arguments);}break;case O.Month:if(this._oMonthInterval){this._oMonthInterval.invalidate(arguments);}break;case O.OneMonth:if(this._oOneMonthInterval){this._oOneMonthInterval.invalidate(arguments);}break;case O.Week:if(this._oWeekInterval){this._oWeekInterval.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+F1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};Y.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.addAggregation.call(this,"specialDates",i);};Y.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;return C.prototype.insertAggregation.call(this,"specialDates",i,j);};Y.prototype.removeSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.removeAggregation.call(this,"specialDates",i);};Y.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates");};Y.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates");};Y.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(a1[0]);}return i;};Y.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(a1[0]);}return i;};Y.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};Y.prototype.selectAllRows=function(j){var D1=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<D1.length;i++){var E1=D1[i];E1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};Y.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var D1=j[0];var E1=new Q.Event("saphome");E1._bPlanningCalendar=true;r1(D1).onsaphome(E1);i.preventDefault();i.stopPropagation();}};Y.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var D1=j[j.length-1];var E1=new Q.Event("sapend");E1._bPlanningCalendar=true;r1(D1).onsapend(E1);i.preventDefault();i.stopPropagation();}};Y.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};Y.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};Y.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};Y.prototype._getView=function(j,D1){var E1=this._getViews();var F1;for(var i=0;i<E1.length;i++){F1=E1[i];if(F1.getKey()!=j){F1=undefined;}else{break;}}if(!F1&&!D1){throw new Error("PlanningCalendarView with key "+j+"not assigned "+this);}return F1;};Y.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this.fireStartDateChange();};Y.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var D1=this.getRows();for(var i=0;i<D1.length;i++){var E1=D1[i];r1(E1).updateCurrentTimeVisualization();}}var F1=new Date();var G1=this.getStartDate();var H1=this.getViewKey();var I1=this._getView(H1);var J1=I1.getIntervalType();var K1=this._getIntervals(I1);var L1=0;var M1=0;var N1=0;switch(J1){case O.Hour:L1=60000;M1=G1.getTime()-3600000;N1=G1.getTime()+K1*3600000;break;case O.Day:case O.Week:case O.OneMonth:L1=1800000;M1=G1.getTime()-3600000;N1=G1.getTime()+K1*86400000;break;default:L1=-1;break;}if(F1.getTime()<=N1&&F1.getTime()>=M1&&L1>0){this._sUpdateCurrentTime=setTimeout(this['_updateCurrentTimeVisualization'].bind(this,true),L1);}};function c1(i){this.setViewKey(i.getParameter("selectedItem").getKey());this.fireViewChange();}Y.prototype._handleTodayPress=function(i){var j=new Date(),D1,E1=this.getViewKey();if(E1===H.OneMonth){D1=a.getFirstDateOfMonth(a._createUniversalUTCDate(j,undefined,true));this._oOneMonthInterval._adjustSelectedDate(b.fromLocalJSDate(j),false);j=a._createLocalDate(D1,true);}if(E1===H.Week){D1=this.getStartDate();j.setHours(D1.getHours());j.setMinutes(D1.getMinutes());j.setSeconds(D1.getSeconds());}this.setStartDate(j);this.fireStartDateChange();};Y.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();this._changeStartDate(j);};Y.prototype._handleCalendarSelect=function(i){var j=i.oSource.getSelectedDates();var D1=new Date(j[0].getStartDate());var E1=a._createUniversalUTCDate(D1,undefined,true);var F1=this.getViewKey();var G1=this._getView(F1);var H1=G1.getIntervalType();if(H1!==O.OneMonth||this._iSize>1){j[0].setStartDate();}switch(H1){case O.Hour:E1.setUTCHours(E1.getUTCHours()+1);break;case O.Day:case O.Week:E1.setUTCDate(E1.getUTCDate()+1);break;case O.OneMonth:if(this._iSize<2){var I1=new Date(D1.getTime());if(a.monthsDiffer(this.getStartDate(),D1)){this.setStartDate(D1);}this._setRowsStartDate(I1);this._oOneMonthInterval.getAggregation('month')[0]._focusDate(b.fromLocalJSDate(I1),true);}else if(a._isNextMonth(D1,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}E1.setUTCDate(E1.getUTCDate()+1);break;case O.Month:E1.setUTCMonth(E1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+H1+"; "+this);}E1.setUTCMilliseconds(E1.getUTCMilliseconds()-1);E1=a._createLocalDate(E1,true);this.fireIntervalSelect({startDate:D1,endDate:E1,subInterval:false,row:undefined});};function d1(i){var j=i.getParameter("startDate");var D1=this.getViewKey();var E1=this._getView(D1);var F1=E1.getIntervalType();if(F1===O.OneMonth&&a._isNextMonth(j,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}var G1=i.getParameter("endDate");var H1=i.getParameter("subInterval");var I1=o1(i.oSource.getParent());this.fireIntervalSelect({startDate:j,endDate:G1,subInterval:H1,row:I1});}Y.prototype._applyContextualSettings=function(){return C.prototype._applyContextualSettings.call(this,{contextualWidth:this.$().width()});};function e1(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function f1(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function g1(j,D1){this._applyContextualSettings();if(j.size.width<=0){return;}var E1=this.getRows();var F1;var i=0;var G1=this._iSize;u1.call(this,j.size.width);if(G1!=this._iSize){v1.call(this,this._iSize);var H1=this.getViewKey();var I1=this._getView(H1);var J1=I1.getIntervalType();var K1=this._getIntervals(I1);for(i=0;i<E1.length;i++){F1=E1[i];var L1=r1(F1);if(K1!=L1.getIntervals()){L1.setIntervals(K1);}else{L1.handleResize();}}switch(J1){case O.Hour:if(this._oTimeInterval&&this._oTimeInterval.getItems()!=K1){this._oTimeInterval.setItems(K1);}break;case O.Day:if(this._oDateInterval&&this._oDateInterval.getDays()!=K1){this._oDateInterval.setDays(K1);}break;case O.Month:if(this._oMonthInterval&&this._oMonthInterval.getMonths()!=K1){this._oMonthInterval.setMonths(K1);}break;case O.Week:if(this._oWeekInterval&&this._oWeekInterval.getDays()!=K1){this._oWeekInterval.setDays(K1);}break;case O.OneMonth:if(this._oOneMonthInterval&&this._oOneMonthInterval.getDays()!=K1){this._oOneMonthInterval.setDays(K1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+J1+"; "+this);}A1.call(this);}else if(!D1){for(i=0;i<E1.length;i++){F1=E1[i];r1(F1).handleResize();}}if(this._oOneMonthInterval){this._oOneMonthInterval._setDisplayMode(this._iSize);}if(this.getStickyHeader()){this._updateStickyHeader();}}function h1(D1){var E1=D1.getParameter("appointment"),F1=D1.getParameter("multiSelect"),G1=D1.getParameter("appointments"),H1=D1.getParameter("domRefId"),I1,J1,K1,L1,M1,i,j;if(!F1){J1=this.getRows();for(i=0;i<J1.length;i++){K1=J1[i];if(D1.oSource!=r1(K1)){L1=K1.getAppointments();for(j=0;j<L1.length;j++){M1=L1[j];M1.setSelected(false);}}}}I1={appointment:E1,appointments:G1,multiSelect:F1,domRefId:H1};this.fireAppointmentSelect(I1);}Y.prototype._setRowsStartDate=function(j){var D1=this.getRows(),E1,i;for(i=0;i<D1.length;i++){E1=D1[i];r1(E1).setStartDate(j);}};Y.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),D1=j.getColumns()[1];D1.setDemandPopin(i);D1.setMinScreenWidth(i?_:"");};Y.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),D1,E1=[],F1=H,G1=O;if(!this._oViews){this._oViews={};}if(j.length){E1=j;}else{E1=i.length?[]:a1;}D1=E1.map(function(I1){switch(I1){case F1.Hour:return this._oViews[F1.Hour]||(this._oViews[F1.Hour]=new sap.m.PlanningCalendarView(this.getId()+"-HourView",{key:F1.Hour,intervalType:G1.Hour,description:this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case F1.Day:return this._oViews[F1.Day]||(this._oViews[F1.Day]=new sap.m.PlanningCalendarView(this.getId()+"-DayView",{key:F1.Day,intervalType:G1.Day,description:this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case F1.Month:return this._oViews[F1.Month]||(this._oViews[F1.Month]=new sap.m.PlanningCalendarView(this.getId()+"-MonthView",{key:F1.Month,intervalType:G1.Month,description:this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case F1.Week:return this._oViews[F1.Week]||(this._oViews[F1.Week]=new sap.m.PlanningCalendarView(this.getId()+"-WeekView",{key:F1.Week,intervalType:G1.Week,description:this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case F1.OneMonth:return this._oViews[F1.OneMonth]||(this._oViews[F1.OneMonth]=new sap.m.PlanningCalendarView(this.getId()+"-OneMonthView",{key:F1.OneMonth,intervalType:G1.OneMonth,description:this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:L.error("Cannot get PlanningCalendar views. Invalid view key "+I1);break;}},this);for(var H1 in this._oViews){if(E1.indexOf(H1)<0){this._oViews[H1].destroy();delete this._oViews[H1];}}if(i.length){D1=D1.concat(i);}return D1;};Y.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,r1(j).aSelectedAppointments);});return i;};Y.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"||i===null||i===undefined){this.getRows().forEach(function(j){r1(j)._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}else{L.warning("Your custom sort function won't be used, but the old one will be preserved.",this);}return this;};Y.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};Y.prototype._onRowDeselectAppointment=function(){var D1=this.getRows();for(var i=0;i<D1.length;i++){var E1=r1(D1[i]).aSelectedAppointments;for(var j=0;j<E1.length;j++){var F1=sap.ui.getCore().byId(E1[j]);if(F1){F1.setProperty("selected",false,true);F1.$().removeClass("sapUiCalendarAppSel");}}r1(D1[i]).aSelectedAppointments=[];}};Y.prototype._updateRowTimeline=function(i){var j=r1(i),D1,E1,F1,G1;j.setNonWorkingDays(i.getNonWorkingDays());j.setNonWorkingHours(i.getNonWorkingHours());j.setStartDate(this.getStartDate());j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setGroupAppointmentsMode(this.getGroupAppointmentsMode());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.attachEvent("select",h1,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",y1,this);j.attachEvent("intervalSelect",d1,this);z1.call(this);if(C1.call(this)){D1=this.getViewKey();E1=this._getView(D1);F1=E1.getIntervalType();G1=this._getIntervals(E1);j.setIntervalType(F1);j.setIntervals(G1);j.setShowSubIntervals(E1.getShowSubIntervals());}B1.call(this);if(this._fnCustomSortedAppointments){j._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}};Y.prototype._observeRowChanges=function(i){var j=p1(i),D1=q1(i),E1=r1(i);var F1={destroy:function(){j.destroy();},change:{title:function(G1){D1.setProperty(G1.name,G1.current);},icon:function(G1){D1.setProperty(G1.name,G1.current);},text:function(G1){E1.toggleStyleClass("sapMPlanCalRowLarge",!!G1.current);D1.setProperty("description",G1.current);},enableAppointmentsDragAndDrop:function(G1){this._enableAppointmentsDragAndDrop(i);}.bind(this),enableAppointmentsResize:function(G1){this._enableAppointmentsResize(i);}.bind(this),enableAppointmentsCreate:function(G1){this._enableAppointmentsCreate(i);}.bind(this),nonWorkingDays:function(G1){E1.setProperty(G1.name,G1.current);},nonWorkingHours:function(G1){E1.setProperty(G1.name,G1.current);},selected:function(G1){z1.call(this);j.setProperty(G1.name,G1.current);}.bind(this),intervalHeaders:function(G1){E1.invalidate();},appointments:function(G1){E1.invalidate();}}};new M(function(G1){if(G1.type==="destroy"){F1.destroy();}else if(F1.change[G1.name]){F1.change[G1.name](G1);}}).observe(i,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["appointments","intervalHeaders"],destroy:true});i.invalidate=function(G1){if(!G1||!(G1 instanceof c)){E.prototype.invalidate.apply(this,arguments);}else if(j){E1.invalidate(G1);}};i.applyFocusInfo=function(G1){E1.applyFocusInfo(G1);return this;};};Y.prototype._createPlanningCalendarListItem=function(i){var j,D1,E1;D1=new i1(i.getId()+"-Head",{icon:i.getIcon(),description:i.getText(),title:i.getTitle()});E1=new k1(i.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:D1.getId()});E1.getAppointments=function(){return i.getAppointments();};E1.getIntervalHeaders=function(){return i.getIntervalHeaders();};j=new m1(i.getId()+X,{cells:[D1,E1]});this._updateRowTimeline(i);this._observeRowChanges(i);this._enableAppointmentsDragAndDrop(i);this._enableAppointmentsResize(i);this._enableAppointmentsCreate(i);return j;};Y.prototype._handleRowRemoval=function(i){var j=r1(i);j.detachEvent("select",h1,this);j.detachEvent("startDateChange",this._handleStartDateChange,this);j.detachEvent("leaveRow",y1,this);j.detachEvent("intervalSelect",d1,this);if(this._fnCustomSortedAppointments){j._fnCustomSortedAppointments=undefined;}p1(i).destroy();};var i1=t.extend("PlanningCalendarRowHeader",{renderer:R.extend(v)});PlanningCalendarRowHeaderRenderer.openItemTag=function(i,j){i.write("<div");};PlanningCalendarRowHeaderRenderer.closeItemTag=function(i,j){i.write("</div>");};PlanningCalendarRowHeaderRenderer.renderTabIndex=function(i,j){};var j1=R.extend(e);j1.getLegendItems=function(i){var j=[],D1,E1=i.getLegend();if(E1){D1=sap.ui.getCore().byId(E1);if(D1){j=D1.getAppointmentItems?D1.getAppointmentItems():D1.getItems();}else{L.error("PlanningCalendarLegend with id '"+E1+"' does not exist!",i);}}return j;};j1.renderBeforeAppointments=function(j,D1){var E1=o1(D1.getParent()),F1;if(!E1.getEnableAppointmentsDragAndDrop()&&!E1.getEnableAppointmentsResize()&&!E1.getEnableAppointmentsCreate()||D1._isOneMonthIntervalOnSmallSizes()){return;}F1=D1.getAggregation("_intervalPlaceholders");j.write("<div class=\"sapUiCalendarRowAppsOverlay\">");if(F1){for(var i=0;i<F1.length;i++){var G1=F1[i];G1.setWidth(100/F1.length+"%");j.renderControl(G1);}}j.write("</div>");};j1.renderResizeHandle=function(i,j,D1){if(!o1(j.getParent()).getEnableAppointmentsResize()||j._isOneMonthIntervalOnSmallSizes()||(D1._aAppointments&&D1._aAppointments.length>0)){return;}i.write("<span");i.addClass("sapUiCalendarAppResizeHandle");i.writeClasses();i.write(">");i.write("</span>");};j1.writeCustomAttributes=function(i,j){if(o1(j.getParent()).getEnableAppointmentsCreate()){i.writeAttribute("draggable","true");}};j1.renderInterval=function(j,D1,E1,F1,G1,H1,I1,J1,K1,L1,M1,N1,O1){var P1=D1.getIntervalType();if(P1===O.Day||P1===O.Week||P1===O.OneMonth){var Q1=o1(D1.getParent()),R1=Q1.getParent(),S1=function(a2){return a2.getType()===z.NonWorking;},T1=Q1.getSpecialDates().filter(S1),U1=R1.getSpecialDates().filter(S1),V1=D1.getStartDate(),W1,X1,Y1,Z1;if(U1&&T1){W1=U1.concat(T1);}else if(T1){W1=T1;}if(W1&&W1.length){var $1=function(a2){return a2===X1.getDay();};X1=new Date(V1.getTime());X1.setHours(0,0,0);X1.setDate(V1.getDate()+E1);for(var i=0;i<W1.length;i++){if(W1[i].getStartDate()){Y1=new Date(W1[i].getStartDate().getTime());}if(W1[i].getEndDate()){Z1=new Date(W1[i].getEndDate().getTime());}else{Z1=new Date(W1[i].getStartDate().getTime());Z1.setHours(23,59,59);}if(X1.getTime()>=Y1.getTime()&&X1.getTime()<=Z1.getTime()){var _1=H1.some($1);if(!_1){j.addClass("sapUiCalendarRowAppsNoWork");}}}}}e.renderInterval(j,D1,E1,F1,G1,H1,I1,J1,K1,L1,M1,N1,O1);};var k1=d.extend("PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}}},renderer:j1});k1.prototype._updatePlaceholders=function(){var j=this.getProperty("intervals");if(this.getIntervalType()===O.Hour){j*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<j;i++){this.addAggregation("_intervalPlaceholders",new l1());}};k1.prototype.onBeforeRendering=function(){d.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};k1.prototype.onmousedown=function(i){var j=i.target.classList;this._isResizeHandleMouseDownTarget=j.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=j.contains("sapUiCalendarRowAppsInt");};k1.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};k1.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};k1.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var l1=C.extend("IntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addStyle("width",j.getWidth());i.writeStyles();i.addClass("sapUiCalendarRowAppsPlaceholder");i.writeClasses();i.write("></div>");}});var m1=r.extend("sap.m.internal.PlanningCalendarRowListItem",{renderer:s});m1.prototype.getHeader=function(){return this.getCells()[0];};m1.prototype.getTimeline=function(){return this.getCells()[1];};m1.prototype.getCustomData=function(){return o1(this).getCustomData();};Y.prototype._enableAppointmentsDragAndDrop=function(i){var j=r1(i),D1;if(i.getEnableAppointmentsDragAndDrop()){D1=i.getDragDropConfig().some(function(E1){return E1.getGroupName()===U;});if(!D1){this._addDragDropInfo(i,r1(i));}}else{i.getDragDropConfig().forEach(function(E1){if(E1.getGroupName()===U){i.removeDragDropConfig(E1);}});j.getDragDropConfig().forEach(function(E1){if(E1.getGroupName()===U){j.removeDragDropConfig(E1);}});}};Y.prototype._enableAppointmentsResize=function(i){var j=i.getEnableAppointmentsResize(),D1=this._getConfigFromDragDropConfigAggregation(i.getAggregation("dragDropConfig"),V),E1=this._getResizeConfig(i);if(j&&!D1){i.addAggregation("dragDropConfig",E1,true);}if(!j){i.removeAggregation("dragDropConfig",D1,true);}};Y.prototype._enableAppointmentsCreate=function(i){var j=i.getEnableAppointmentsCreate(),D1=r1(i),E1=this._getConfigFromDragDropConfigAggregation(D1.getAggregation("dragDropConfig"),W),F1=this._getAppointmentsCreateConfig(i);if(j&&!E1){D1.addAggregation("dragDropConfig",F1,true);}if(!j){D1.removeAggregation("dragDropConfig",E1,true);}};Y.prototype._addDragDropInfo=function(i,j){i.addDragDropConfig(new m({groupName:U,sourceAggregation:"appointments",dragStart:function(D1){var E1=function(){var F1=Q(".sapUiCalendarRowAppsOverlay");setTimeout(function(){F1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){F1.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(j._isOneMonthIntervalOnSmallSizes()||!j._isDraggingPerformed()){D1.preventDefault();return;}E1();}}));j.addDragDropConfig(new n({groupName:U,targetAggregation:"_intervalPlaceholders",dragEnter:function(D1){var E1=D1.getParameter("dragSession"),F1=E1.getDragControl(),G1=j.getIntervalType(),H1=j.getStartDate(),I1=j.indexOfAggregation("_intervalPlaceholders",E1.getDropControl()),J1=j.getId(),K1,L1=function(){var N1=Q(E1.getIndicator()),O1=E1.getDropControl().getDomRef().getBoundingClientRect(),P1=sap.ui.getCore().byId(J1).getDomRef().getBoundingClientRect(),Q1=E1.getDragControl().$().outerWidth(),R1=sap.ui.getCore().getConfiguration().getRTL(),S1=R1?Math.ceil(O1.right)-P1.left:P1.right-Math.ceil(O1.left);N1.css("min-width",(Q1<S1)?Q1:S1).css(R1?"border-left-width":"border-right-width",(Q1>S1)?"0":"").css("margin-left",R1?-(N1.outerWidth()-parseFloat(N1.context.style.width)):"");};if(i.hasListeners("appointmentDragEnter")){if(G1===O.Hour){K1=this._calcNewHoursAppPos(H1,F1.getStartDate(),F1.getEndDate(),I1);}else if(G1===O.Day||G1===O.Week||(G1===O.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){K1=this._calcNewDaysAppPos(H1,F1.getStartDate(),F1.getEndDate(),I1);}else if(G1===O.Month){K1=this._calcNewMonthsAppPos(H1,F1.getStartDate(),F1.getEndDate(),I1);}var M1=i.fireAppointmentDragEnter({appointment:F1,startDate:K1.startDate,endDate:K1.endDate,calendarRow:o1(j.getParent())});if(!M1){D1.preventDefault();return;}}else if(r1(F1.getParent())!==j){D1.preventDefault();return;}if(j.getIntervalType()!==O.Hour){return;}if(!E1.getIndicator()){setTimeout(L1,0);}else{L1();}}.bind(this),drop:function(D1){var E1=D1.getParameter("dragSession"),F1=E1.getDragControl(),G1=j.getIntervalType(),H1=j.getStartDate(),I1=j.indexOfAggregation("_intervalPlaceholders",E1.getDropControl()),J1,K1=D1.getParameter("browserEvent"),L1=(K1.metaKey||K1.ctrlKey);if(G1===O.Hour){J1=this._calcNewHoursAppPos(H1,F1.getStartDate(),F1.getEndDate(),I1);}else if(G1===O.Day||G1===O.Week||(G1===O.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){J1=this._calcNewDaysAppPos(H1,F1.getStartDate(),F1.getEndDate(),I1);}else if(G1===O.Month){J1=this._calcNewMonthsAppPos(H1,F1.getStartDate(),F1.getEndDate(),I1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(F1.getStartDate().getTime()===J1.startDate.getTime()&&F1.getParent()===o1(j.getParent())){return;}i.fireAppointmentDrop({appointment:F1,startDate:J1.startDate,endDate:J1.endDate,calendarRow:o1(j.getParent()),copy:L1});}.bind(this)}));};Y.prototype._calcNewHoursAppPos=function(i,j,D1,E1){var F1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours());F1=new Date(F1.getTime()+(E1*30*60*1000));return{startDate:F1,endDate:new Date(F1.getTime()+D1.getTime()-j.getTime())};};Y.prototype._calcNewDaysAppPos=function(i,j,D1,E1){var F1=new Date(i);F1.setDate(F1.getDate()+E1);F1=new Date(F1.getFullYear(),F1.getMonth(),F1.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:F1,endDate:new Date(F1.getTime()+D1.getTime()-j.getTime())};};Y.prototype._calcNewMonthsAppPos=function(i,j,D1,E1){var F1=new Date(i);F1.setMonth(F1.getMonth()+E1);F1=new Date(F1.getFullYear(),F1.getMonth(),j.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:F1,endDate:new Date(F1.getTime()+D1.getTime()-j.getTime())};};Y.prototype._getResizeConfig=function(i){var j=r1(i),D1=new o({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:r1(i),dragStart:function(E1){if(!i.getEnableAppointmentsResize()||j._isOneMonthIntervalOnSmallSizes()||!j._isResizingPerformed()){E1.preventDefault();return;}var F1=E1.getParameter("dragSession"),G1=j.$().find(".sapUiCalendarRowAppsOverlay"),H1=Q(F1.getIndicator()),I1=F1.getDragControl().$();H1.addClass("sapUiDnDIndicatorHide");setTimeout(function(){G1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){G1.removeClass("sapUiCalendarRowAppsOverlayDragging");H1.removeClass("sapUiDnDIndicatorHide");I1.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});if(!k.browser.msie&&!k.browser.edge){E1.getParameter("browserEvent").dataTransfer.setDragImage(n1(),0,0);}},dragEnter:function(E1){var F1=E1.getParameter("dragSession"),G1=this.getTargetElement(),H1=function(){var L1=Q(F1.getIndicator());L1.addClass("sapUiDnDIndicatorHide");},I1=F1.getDropControl().getDomRef().getBoundingClientRect(),J1=sap.ui.getCore().byId(G1).getDomRef().getBoundingClientRect(),K1={width:I1.left+I1.width-(F1.getDragControl().$().position().left+J1.left),"min-width":Math.min(F1.getDragControl().$().outerWidth(),F1.getDropControl().$().outerWidth()),"z-index":1,opacity:0.8};F1.getDragControl().$().css(K1);if(!F1.getIndicator()){setTimeout(H1,0);}else{H1();}},drop:function(E1){var j=r1(i),F1=E1.getParameter("dragSession"),G1=F1.getDragControl(),H1=j.getIntervalType(),I1=j.getStartDate(),J1=j.indexOfAggregation("_intervalPlaceholders",F1.getDropControl()),K1;if(H1===O.Hour){K1=this._calcResizeNewHoursAppPos(I1,G1.getStartDate(),G1.getEndDate(),J1);}else if(H1===O.Day||H1===O.Week||(H1===O.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){K1=this._calcResizeNewDaysAppPos(I1,G1.getStartDate(),G1.getEndDate(),J1);}else if(H1===O.Month){K1=this._calcResizeNewMonthsAppPos(I1,G1.getStartDate(),G1.getEndDate(),J1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");Q(F1.getIndicator()).removeClass("sapUiDnDIndicatorHide");G1.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(G1.getEndDate().getTime()===K1.endDate.getTime()){return;}i.fireAppointmentResize({appointment:G1,startDate:K1.startDate,endDate:K1.endDate,calendarRow:i});}.bind(this)});D1.setProperty("groupName",V);return D1;};Y.prototype._calcResizeNewHoursAppPos=function(i,j,D1,E1){var F1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours()),G1=30*60*1000;F1=new Date(F1.getTime()+((E1+1)*G1));if(F1.getTime()<=j.getTime()){F1=new Date(j.getTime()+G1);}return{startDate:j,endDate:F1};};Y.prototype._calcResizeNewDaysAppPos=function(i,j,D1,E1){var F1=new Date(i),G1=F1.getDate()+E1+1;if(G1<=j.getDate()){G1=j.getDate()+1;}F1.setDate(G1);F1=new Date(F1.getFullYear(),F1.getMonth(),F1.getDate());return{startDate:j,endDate:F1};};Y.prototype._calcResizeNewMonthsAppPos=function(i,j,D1,E1){var F1=new Date(i),G1=F1.getMonth()+E1+1;if(G1<=j.getMonth()){G1=j.getMonth()+1;}F1.setMonth(G1);F1=new Date(F1.getFullYear(),F1.getMonth(),1);return{startDate:j,endDate:F1};};Y.prototype._calcCreateNewAppHours=function(i,j,D1){var E1=30*60*1000,F1,G1;if(j<=D1){F1=new Date(i.getTime()+(j*E1));G1=new Date(i.getTime()+((D1+1)*E1));}else{F1=new Date(i.getTime()+(D1*E1));G1=new Date(i.getTime()+(j*E1));}return{startDate:F1,endDate:G1};};Y.prototype._calcCreateNewAppDays=function(i,j,D1){var E1=new Date(i),F1=new Date(i);if(j<=D1){E1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);F1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+D1+1);}else{E1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+D1);F1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);}return{startDate:E1,endDate:F1};};Y.prototype._calcCreateNewAppMonths=function(i,j,D1){var E1=new Date(i),F1=new Date(i);if(j<=D1){E1=new Date(i.getFullYear(),i.getMonth()+j,1);F1=new Date(i.getFullYear(),i.getMonth()+D1+1,1);}else{E1=new Date(i.getFullYear(),i.getMonth()+D1,1);F1=new Date(i.getFullYear(),i.getMonth()+j,1);}return{startDate:E1,endDate:F1};};Y.prototype._getConfigFromDragDropConfigAggregation=function(j,D1){var E1=j,F1=E1&&E1.length;for(var i=0;i<F1;i++){if(E1[i].getGroupName()===D1){return E1[i];}}return null;};Y.prototype._getAppointmentsCreateConfig=function(i){var j=r1(i),D1=new o({targetAggregation:"_intervalPlaceholders",dragStart:function(E1){if(!i.getEnableAppointmentsCreate()||j._isOneMonthIntervalOnSmallSizes()||!j._isCreatingPerformed()){E1.preventDefault();return;}var F1=E1.getParameter("dragSession"),G1=j.$().find(".sapUiCalendarRowAppsOverlay"),H1=Q(F1.getIndicator());setTimeout(function(){G1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){G1.removeClass("sapUiCalendarRowAppsOverlayDragging");H1.html("");H1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});if(!k.browser.msie&&!k.browser.edge){E1.getParameter("browserEvent").dataTransfer.setDragImage(n1(),0,0);}},dragEnter:function(E1){var F1=E1.getParameter("dragSession"),G1=F1.getDropControl().getDomRef().getBoundingClientRect(),H1=function(){var J1=Q(F1.getIndicator());J1.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var I1=F1.getData("text")?parseFloat(F1.getData("text").split("|")[0]):0;if(I1){if(I1<=G1.left){F1.setIndicatorConfig({left:I1,width:Math.max((G1.left+G1.width-I1),G1.width)});}else{F1.setIndicatorConfig({left:G1.left,width:I1-G1.left});}}else{F1.setData("text",G1.left+"|"+j.indexOfAggregation("_intervalPlaceholders",F1.getDropControl()));}if(!F1.getIndicator()){setTimeout(H1,0);}else{H1();}},drop:function(E1){var F1=E1.getParameter("dragSession"),G1=Q(F1.getIndicator()),H1=j.getIntervalType(),I1=r1(i).getStartDate(),J1=parseInt(F1.getData("text").split("|")[1],10),K1=j.indexOfAggregation("_intervalPlaceholders",F1.getDropControl()),L1;if(H1===O.Hour){L1=this._calcCreateNewAppHours(I1,J1,K1);}else if(H1===O.Day||H1===O.Week||(H1===O.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){L1=this._calcCreateNewAppDays(I1,J1,K1);}else if(H1===O.Month){L1=this._calcCreateNewAppMonths(I1,J1,K1);}i.fireAppointmentCreate({startDate:L1.startDate,endDate:L1.endDate,calendarRow:i});G1.html("");G1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});D1.setProperty("groupName",W);return D1;};function n1(){var i=Q("<span></span>").addClass("sapUiCalAppResizeGhost");i.appendTo(document.body);setTimeout(function(){i.remove();},0);return i.get(0);}function o1(i){var j=i.getId();return sap.ui.getCore().byId(j.substring(0,j.indexOf(X)));}function p1(i){return sap.ui.getCore().byId(i.getId()+X);}function q1(i){var j=p1(i);return j?j.getHeader():null;}function r1(i){var j=p1(i);return j?j.getTimeline():null;}function s1(j){var D1=[];var E1=this.getRows();for(var i=0;i<E1.length;i++){var F1=E1[i];var G1=p1(F1);var H1=G1.getSelected();if(F1.getSelected()!=H1){F1.setProperty("selected",H1,true);D1.push(F1);}}if(!this.getSingleSelection()){z1.call(this);}if(D1.length>0){this.fireRowSelectionChange({rows:D1});}}function t1(){var i=this.getAggregation("table");if(this.getToolbarContent().length>0){if(!this._oToolbar){this._oToolbar=new sap.m.OverflowToolbar(this.getId()+"-Toolbar",{design:F.Transpaent});this._oToolbar._oPlanningCalendar=this;this._oToolbar.getContent=function(){return this._oPlanningCalendar.getToolbarContent();};}if(!i.getHeaderToolbar()){i.setHeaderToolbar(this._oToolbar);}}else if(i.getHeaderToolbar()){i.setHeaderToolbar();}this._oToolbar.invalidate();}function u1(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(Q('html').hasClass("sapUiMedia-Std-Phone")){this._iSizeScreen=0;}else if(Q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function v1(j){var D1='sapMSize'+j,E1=this.$(),i,F1;if(E1){for(i=0;i<3;i++){F1='sapMSize'+i;if(F1===D1){E1.addClass(F1);}else{E1.removeClass(F1);}}}}function w1(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var D1;for(i=0;i<j.length;i++){var E1=j[i];D1=new I(this.getId()+"-"+i,{key:E1.getKey(),text:E1.getDescription(),tooltip:E1.getTooltip()});this._oIntervalTypeSelect.addItem(D1);}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function x1(i){var j=i.getParameter("selected");var D1=this.getRows();if(j){D1=this.getRows().filter(function(E1){return!E1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:D1});}function y1(j){var D1=j.oSource;var E1=j.getParameter("type");var F1=this.getRows();var G1;var H1;var I1;var J1;var i=0;var K1=0;var L1;for(i=0;i<F1.length;i++){G1=F1[i];if(r1(G1)==D1){K1=i;break;}}switch(E1){case"sapup":I1=D1.getFocusedAppointment();J1=I1.getStartDate();if(K1>0){K1--;}H1=F1[K1];r1(H1).focusNearestAppointment(J1);break;case"sapdown":I1=D1.getFocusedAppointment();J1=I1.getStartDate();if(K1<F1.length-1){K1++;}H1=F1[K1];r1(H1).focusNearestAppointment(J1);break;case"saphome":if(K1>0){H1=F1[0];L1=new Q.Event(E1);L1._bPlanningCalendar=true;r1(H1).onsaphome(L1);}break;case"sapend":if(K1<F1.length-1){H1=F1[F1.length-1];L1=new Q.Event(E1);L1._bPlanningCalendar=true;r1(H1).onsapend(L1);}break;default:break;}}function z1(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function A1(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new sap.m.CheckBox(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",x1,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function B1(){var i=this.getAggregation("table");var j=i.getMode();var D1;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){D1=A.None;}else{D1=A.SingleSelectMaster;}}else{D1=A.MultiSelect;}if(j!=D1){i.setMode(D1);}}function C1(){return this._oTimeInterval||this._oDateInterval||this._oMonthInterval||this._oWeekInterval||this._oOneMonthInterval;}return Y;});
