/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/Context','sap/ui/model/PropertyBinding','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/Device','sap/ui/core/TextAlign','sap/ui/core/InvisibleText','sap/ui/core/Control','sap/ui/core/Icon','sap/ui/core/ValueState','sap/ui/layout/HorizontalLayout','sap/ui/layout/Grid','sap/m/SearchField','sap/m/RadioButton','sap/m/ScreenSize','sap/m/PopinDisplay','sap/m/ColumnListItem','sap/m/Column','sap/m/Text','sap/m/Bar','sap/m/Table','sap/m/Page','sap/m/PlacementType','sap/m/ButtonType','sap/m/Toolbar','sap/m/ToolbarSpacer','sap/m/Button','sap/m/CheckBox','sap/m/Dialog','sap/m/Input','sap/m/Label','sap/m/Title','sap/m/ResponsivePopover','sap/m/SelectList','sap/m/ObjectIdentifier','sap/m/OverflowToolbar','sap/m/OverflowToolbarPriority','sap/m/OverflowToolbarLayoutData','sap/m/VBox','sap/ui/fl/Utils','../changeHandler/BaseTreeModifier',"sap/ui/events/KeyCodes"],function(C,P,J,F,D,T,I,a,b,V,H,G,S,R,c,d,f,g,h,B,i,j,k,l,m,n,o,p,q,r,L,s,t,u,O,v,w,x,y,z,A,K){"use strict";var E=a.extend("sap.ui.fl.variants.VariantManagement",{metadata:{library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{showExecuteOnSelection:{type:"boolean",group:"Misc",defaultValue:false},showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},manualVariantKey:{type:"boolean",group:"Misc",defaultValue:false},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},editable:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:null},updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false}},associations:{"for":{type:"sap.ui.core.Control",multiple:true}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"}}},manage:{},initialized:{},select:{parameters:{key:{type:"string"}}}}},renderer:function(e,M){e.write("<div ");e.writeControlData(M);e.addClass("sapUiFlVarMngmt");e.writeClasses();e.write(">");e.renderControl(M.oVariantLayout);e.write("</div>");}});E.MODEL_NAME="$FlexVariants";E.INNER_MODEL_NAME="$sapUiFlVariants";E.MAX_NAME_LEN=100;E.COLUMN_FAV_IDX=0;E.COLUMN_NAME_IDX=1;E.prototype.init=function(){this._sModelName=E.MODEL_NAME;this.attachModelContextChange(this._setModel,this);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._createInnerModel();this.oVariantInvisibleText=new I({text:{parts:[{path:'currentVariant',model:this._sModelName},{path:"modified",model:this._sModelName}],formatter:function(M,N){if(N){M=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT_MOD",[M]);}else{M=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT",[M]);}}.bind(this)}});this.oVariantText=new s(this.getId()+"-text",{text:{path:'currentVariant',model:this._sModelName,formatter:function(M){var N=this.getSelectedVariantText(M);return N;}.bind(this)}});this.oVariantText.addStyleClass("sapUiFlVarMngmtClickable");this.oVariantText.addStyleClass("sapUiFlVarMngmtTitle");if(D.system.phone){this.oVariantText.addStyleClass("sapUiFlVarMngmtTextPhoneMaxWidth");}else{this.oVariantText.addStyleClass("sapUiFlVarMngmtTextMaxWidth");}var e=new L(this.getId()+"-modified",{text:"*",visible:{path:"modified",model:this._sModelName,formatter:function(M){return(M===null||M===undefined)?false:M;}}});e.setVisible(false);e.addStyleClass("sapUiFlVarMngmtModified");e.addStyleClass("sapUiFlVarMngmtClickable");e.addStyleClass("sapMTitleStyleH4");this.oVariantPopoverTrigger=new o(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:l.Transparent});this.oVariantPopoverTrigger.addAriaLabelledBy(this.oVariantInvisibleText);this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtn");this.oVariantPopoverTrigger.addStyleClass("sapMTitleStyleH4");this.oVariantLayout=new H({content:[this.oVariantText,e,this.oVariantPopoverTrigger,this.oVariantInvisibleText]});this.oVariantLayout.addStyleClass("sapUiFlVarMngmtLayout");this.addDependent(this.oVariantLayout);};E.prototype.getTitle=function(){return this.oVariantText;};E.prototype._createInnerModel=function(){var M=new J({showExecuteOnSelection:false,showSetAsDefault:true,editable:true,popoverTitle:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS")});this.setModel(M,E.INNER_MODEL_NAME);this._bindProperties();};E.prototype._bindProperties=function(){this.bindProperty("showExecuteOnSelection",{path:"/showExecuteOnSelection",model:E.INNER_MODEL_NAME});this.bindProperty("showSetAsDefault",{path:"/showSetAsDefault",model:E.INNER_MODEL_NAME});this.bindProperty("editable",{path:"/editable",model:E.INNER_MODEL_NAME});};E.prototype.getOriginalDefaultVariantKey=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/originalDefaultVariant");}return null;};E.prototype.setDefaultVariantKey=function(e){var M=this.getModel(this._sModelName);if(M&&this.oContext){M.setProperty(this.oContext+"/defaultVariant",e);}};E.prototype.getDefaultVariantKey=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/defaultVariant");}return null;};E.prototype.setCurrentVariantKey=function(e){var M=this.getModel(this._sModelName);if(M&&this.oContext){M.setProperty(this.oContext+"/currentVariant",e);}return this;};E.prototype.getCurrentVariantKey=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/currentVariant");}return null;};E.prototype._assignPopoverTitle=function(){var e,M,N=this.getModel(this._sModelName);if(N&&this.oContext){e=N.getProperty(this.oContext+"/popoverTitle");}if(e!==undefined){M=this.getModel(E.INNER_MODEL_NAME);if(M){M.setProperty("/popoverTitle",e);}}};E.prototype.getVariants=function(){return this._getItems();};E.prototype.setModified=function(e){var M=this.getModel(this._sModelName);if(M&&this.oContext){M.setProperty(this.oContext+"/modified",e);}};E.prototype.getModified=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/modified");}return false;};E.prototype.getSelectedVariantText=function(e){var M=this._getItemByKey(e);if(M){return M.title;}return"";};E.prototype.getStandardVariantKey=function(){var e=this._getItems();if(e&&e[0]){return e[0].key;}return null;};E.prototype.getShowFavorites=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/showFavorites");}return false;};E.prototype._clearDeletedItems=function(){this._aDeletedItems=[];};E.prototype._addDeletedItem=function(e){this._aDeletedItems.push(e);};E.prototype._getDeletedItems=function(e){return this._aDeletedItems;};E.prototype._getItems=function(){var e=[];if(this.oContext&&this.oContext.getObject()){e=this.oContext.getObject().variants.filter(function(M){if(!M.hasOwnProperty("visible")){return true;}return M.visible;});}return e;};E.prototype._getItemByKey=function(e){var M=null,N=this._getItems();N.some(function(Q){if(Q.key===e){M=Q;}return(M!=null);});return M;};E.prototype._rebindControl=function(e){this.oVariantInvisibleText.unbindProperty("text");this.oVariantInvisibleText.bindProperty("text",{parts:[{path:'currentVariant',model:this._sModelName},{path:"modified",model:this._sModelName}],formatter:function(M,N){if(N){M=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT_MOD",[M]);}else{M=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT",[M]);}}.bind(this)});this.oVariantText.unbindProperty("text");this.oVariantText.bindProperty("text",{path:'currentVariant',model:this._sModelName,formatter:function(M){var N=this.getSelectedVariantText(M);return N;}.bind(this)});this.oVariantText.unbindProperty("visible",{path:"modified",model:this._sModelName,formatter:function(M){return(M===null||M===undefined)?false:M;}});};E.prototype.setModelName=function(e){if(this.getModelName()){this.oContext=null;}this.setProperty("modelName",e);this._sModelName=e;this._rebindControl();};E.prototype._setBindingContext=function(){var M,e;if(!this.oContext){M=this.getModel(this._sModelName);if(M){e=this._getLocalId();if(e){this.oContext=new C(M,"/"+e);this.setBindingContext(this.oContext,this._sModelName);if(!this.getModelName()&&M.registerToModel){M.registerToModel(this);}this._assignPopoverTitle();this._registerPropertyChanges(M);this.fireInitialized();}}}};E.prototype._getLocalId=function(){if(this.getModelName()&&(this._sModelName!==E.MODEL_NAME)){return this.getId();}return A.getSelector(this,z.getComponentForControl(this)).id;};E.prototype._setModel=function(){this._setBindingContext();};E.prototype._registerPropertyChanges=function(M){var e=new P(M,this.oContext+"/variantsEditable");e.attachChange(function(N){if(N&&N.oSource&&N.oSource.oModel&&N.oSource.sPath){var Q,U=N.oSource.oModel.getProperty(N.oSource.sPath);Q=this.getModel(E.INNER_MODEL_NAME);if(Q){Q.setProperty("/editable",U);}}}.bind(this));};E.prototype.handleOpenCloseVariantPopover=function(){if(!this.bPopoverOpen){this._openVariantList();}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close();}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close();}};E.prototype.getFocusDomRef=function(){if(this.oVariantPopoverTrigger){return this.oVariantPopoverTrigger.getFocusDomRef();}};E.prototype.onclick=function(e){if(this.oVariantPopoverTrigger&&!this.bPopoverOpen){this.oVariantPopoverTrigger.focus();}this.handleOpenCloseVariantPopover();};E.prototype.onkeydown=function(e){if(e.which===K.F4||e.which===K.SPACE||e.altKey===true&&e.which===K.ARROW_UP||e.altKey===true&&e.which===K.ARROW_DOWN){this._openVariantList();}};E.prototype.onAfterRendering=function(){this.oVariantText.$().off("mouseover").on("mouseover",function(){this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));this.oVariantText.$().off("mouseout").on("mouseout",function(){this.oVariantPopoverTrigger.removeStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));};E.prototype._openInErrorState=function(){var M;if(!this.oErrorVariantPopOver){M=new y({fitContainer:true,alignItems:sap.m.FlexAlignItems.Center,items:[new b({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new s({titleStyle:sap.ui.core.TitleLevel.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new h({textAlign:sap.ui.core.TextAlign.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});M.addStyleClass("sapUiFlVarMngmtErrorPopover");this.oErrorVariantPopOver=new t(this.getId()+"-errorpopover",{title:{path:"/popoverTitle",model:E.INNER_MODEL_NAME},contentWidth:"400px",placement:k.Bottom,content:[new j(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[M]})],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.attachBrowserEvent("keyup",function(e){if(e.which===32){this.oErrorVariantPopOver.close();}}.bind(this));}if(this.bPopoverOpen){return;}this.oErrorVariantPopOver.openBy(this.oVariantLayout);};E.prototype._createVariantList=function(){if(this.oVariantPopOver){return;}this.oVariantManageBtn=new o(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog();}.bind(this),layoutData:new x({priority:w.Low})});this.oVariantSaveBtn=new o(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave();}.bind(this),enabled:{path:"modified",model:this._sModelName,formatter:function(M){return M;}},layoutData:new x({priority:w.Low})});this.oVariantSaveAsBtn=new o(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog();}.bind(this),layoutData:new x({priority:w.Low})});this._oVariantList=new u(this.getId()+"-list",{selectedKey:{path:"currentVariant",model:this._sModelName},itemPress:function(M){var N=null;if(M&&M.getParameters()){var Q=M.getParameters().item;if(Q){N=Q.getKey();}}if(N){this.setCurrentVariantKey(N);this.fireEvent("select",{key:N});this.oVariantPopOver.close();}}.bind(this)});this._oVariantList.setNoDataText(this._oRb.getText("VARIANT_MANAGEMENT_NODATA"));var e=new sap.ui.core.Item({key:'{'+this._sModelName+">key}",text:'{'+this._sModelName+">title}"});this._oVariantList.bindAggregation("items",{path:"variants",model:this._sModelName,template:e});this._oSearchField=new S(this.getId()+"-search");this._oSearchField.attachLiveChange(function(M){this._triggerSearch(M,this._oVariantList);}.bind(this));this.oVariantSelectionPage=new j(this.getId()+"-selpage",{subHeader:new m({content:[this._oSearchField]}),content:[this._oVariantList],footer:new v({content:[new n(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,this.oVariantManageBtn]}),showNavButton:false,showHeader:false,showFooter:{path:"/editable",model:E.INNER_MODEL_NAME}});this.oVariantPopOver=new t(this.getId()+"-popover",{title:{path:"/popoverTitle",model:E.INNER_MODEL_NAME},contentWidth:"400px",placement:k.Bottom,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapUiFlVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oVariantPopOver);};E.prototype._openVariantList=function(){var e;if(this.getInErrorState()){this._openInErrorState();return;}if(this.bPopoverOpen){return;}if(!this.oContext){return;}this._createVariantList();this._oSearchField.setValue("");this._oVariantList.getBinding("items").filter(this._getFilters());this.oVariantSelectionPage.setShowSubHeader(this._oVariantList.getItems().length>9?true:false);this.oVariantSaveBtn.setEnabled(false);this.oVariantSaveAsBtn.setEnabled(true);if(this.getModified()){e=this._getItemByKey(this.getCurrentVariantKey());if(e&&e.change){this.oVariantSaveBtn.setEnabled(true);}}this.oVariantPopOver.openBy(this.oVariantLayout);};E.prototype._triggerSearch=function(e,M){if(!e){return;}var N=e.getParameters();if(!N){return;}var Q=N.newValue?N.newValue:"";var U=new F({path:"title",operator:sap.ui.model.FilterOperator.Contains,value1:Q});M.getBinding("items").filter(this._getFilters(U));};E.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new r(this.getId()+"-name",{liveChange:function(N){this._checkVariantNameConstraints(this.oInputName,this.oSaveSave);}.bind(this)});var e=new L(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME"),required:true});e.setLabelFor(this.oInputName);this.oDefault=new p(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/showSetAsDefault",model:E.INNER_MODEL_NAME},width:"100%"});this.oExecuteOnSelect=new p(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/showExecuteOnSelection",model:E.INNER_MODEL_NAME},width:"100%"});this.oInputManualKey=new r(this.getId()+"-key",{liveChange:function(N){this._checkVariantNameConstraints(this.oInputManualKey);}.bind(this)});this.oLabelKey=new L(this.getId()+"-keylabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_KEY"),required:true});this.oLabelKey.setLabelFor(this.oInputManualKey);this.oSaveSave=new o(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),press:function(){this._bSaveCanceled=false;this._handleVariantSaveAs(this.oInputName.getValue());}.bind(this),enabled:true});var M=new G({defaultSpan:"L12 M12 S12"});if(this.getShowSetAsDefault()){M.addContent(this.oDefault);}if(this.getShowExecuteOnSelection()){M.addContent(this.oExecuteOnSelect);}this.oSaveAsDialog=new q(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),beginButton:this.oSaveSave,endButton:new o(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._bSaveCanceled=true;this.oSaveAsDialog.close();}.bind(this)}),content:[e,this.oInputName,this.oLabelKey,this.oInputManualKey,M],stretch:D.system.phone});this.oSaveAsDialog.addStyleClass("sapUiPopupWithPadding");this.oSaveAsDialog.addStyleClass("sapUiFlVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oSaveAsDialog);}};E.prototype._openSaveAsDialog=function(){this._createSaveAsDialog();this.oInputName.setValue(this.getSelectedVariantText(this.getCurrentVariantKey()));this.oSaveSave.setEnabled(false);this.oInputName.setEnabled(true);this.oInputName.setValueState(V.None);this.oInputName.setValueStateText(null);this.oDefault.setSelected(false);this.oExecuteOnSelect.setSelected(false);if(this.oVariantPopOver){this.oVariantPopOver.close();}if(this.getManualVariantKey()){this.oInputManualKey.setVisible(true);this.oInputManualKey.setEnabled(true);this.oInputManualKey.setValueState(V.None);this.oInputManualKey.setValueStateText(null);this.oLabelKey.setVisible(true);}else{this.oInputManualKey.setVisible(false);this.oLabelKey.setVisible(false);}this.oSaveAsDialog.open();};E.prototype._handleVariantSaveAs=function(N){var e=null,M=N.trim(),Q=this.oInputManualKey.getValue().trim();if(M==""){this.oInputName.setValueState(V.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}if(this.getManualVariantKey()){if(Q==""){this.oInputManualKey.setValueState(V.Error);this.oInputManualKey.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}e=Q;}if(this.oSaveAsDialog){this.oSaveAsDialog.close();}if(this.oDefault.getSelected()){this.setDefaultVariantKey(e);}this.setModified(false);this.fireSave({key:e,name:M,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected()});};E.prototype._handleVariantSave=function(){var e=this._getItemByKey(this.getCurrentVariantKey());var M=false;if(this.getDefaultVariantKey()===e.key){M=true;}if(this.oVariantPopOver){this.oVariantPopOver.close();}this.fireSave({name:e.title,overwrite:true,key:e.key,def:M});this.setModified(false);};E.prototype.openManagementDialog=function(e){if(e&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined;}this._openManagementDialog();};E.prototype._triggerSearchInManageDialog=function(e,M){if(!e){return;}var N=e.getParameters();if(!N){return;}var Q=N.newValue?N.newValue:"";var U=[this._getVisibleFilter(),new F({filters:[new F({path:"title",operator:sap.ui.model.FilterOperator.Contains,value1:Q}),new F({path:"author",operator:sap.ui.model.FilterOperator.Contains,value1:Q})],and:false})];M.getBinding("items").filter(U);this._bDeleteOccured=true;};E.prototype._createManagementDialog=function(){if(!this.oManagementDialog){this.oManagementTable=new i(this.getId()+"-managementTable",{growing:true,columns:[new g({width:"3rem",visible:{path:"showFavorites",model:this._sModelName}}),new g({header:new h({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"14rem"}),new g({header:new h({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT")}),width:"4rem",demandPopin:true,popinDisplay:d.Inline,minScreenWidth:c.Tablet,visible:{path:"/showSetAsDefault",model:E.INNER_MODEL_NAME}}),new g({header:new h({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT")}),width:"6rem",hAlign:T.Center,demandPopin:true,popinDisplay:d.Inline,minScreenWidth:"800px",visible:{path:"/showExecuteOnSelection",model:E.INNER_MODEL_NAME}}),new g({header:new h({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR")}),width:"8rem",demandPopin:true,popinDisplay:d.Inline,minScreenWidth:"900px"}),new g({width:"2rem",hAlign:T.Center}),new g({visible:false})]});this.oManagementSave=new o(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),enabled:true,press:function(){this._handleManageSavePressed();}.bind(this)});this.oManagementCancel=new o(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this.oManagementDialog.close();this._handleManageCancelPressed();}.bind(this)});this.oManagementDialog=new q(this.getId()+"-managementdialog",{resizable:true,draggable:true,customHeader:new B(this.getId()+"-managementHeader",{contentMiddle:[new h(this.getId()+"-managementHeaderText",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG")})]}),beginButton:this.oManagementSave,endButton:this.oManagementCancel,content:[this.oManagementTable],stretch:D.system.phone});this.oManagementDialog.isPopupAdaptationAllowed=function(){return false;};this._oSearchFieldOnMgmtDialog=new S();this._oSearchFieldOnMgmtDialog.attachLiveChange(function(M){this._triggerSearchInManageDialog(M,this.oManagementTable);}.bind(this));var e=new B(this.getId()+"-mgmHeaderSearch",{contentRight:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(e);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});this._bDeleteOccured=false;}};E.prototype._setFavoriteIcon=function(e,M){if(e){e.setSrc(M?"sap-icon://favorite":"sap-icon://unfavorite");e.setTooltip(this._oRb.getText(M?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));}};E.prototype._templateFactoryManagementDialog=function(e,M){var N=null,Q,U,W,X=M.getObject();if(!X){return undefined;}var Y=function(e1){this._checkVariantNameConstraints(e1.oSource,this.oManagementSave,e1.oSource.getBindingContext(this._sModelName).getObject().key);}.bind(this);var Z=function(e1){this._handleManageTitleChanged(e1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var $=function(e1){if(e1.getParameters().selected===true){this._handleManageDefaultVariantChange(e1.oSource,e1.oSource.getBindingContext(this._sModelName).getObject());}}.bind(this);var _=function(e1){this._handleManageExecuteOnSelectionChanged(e1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var a1=function(e1){this._handleManageDeletePressed(e1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var b1=function(e1){this._handleManageFavoriteChanged(e1.oSource,e1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);if(X.rename){W=new r({liveChange:Y,change:Z,value:'{'+this._sModelName+">title}"});}else{W=new O({title:'{'+this._sModelName+">title}"});if(N){W.setTooltip(N);}}Q=new o({icon:"sap-icon://sys-cancel",enabled:true,type:l.Transparent,press:a1,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:X.remove});this._assignColumnInfoForDeleteButton(Q);U=this.oContext.getPath();var c1=new b({src:{path:"favorite",model:this._sModelName,formatter:function(e1){return e1?"sap-icon://favorite":"sap-icon://unfavorite";}},tooltip:{path:'favorite',model:this._sModelName,formatter:function(e1){return this._oRb.getText(e1?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP");}.bind(this)},press:b1});c1.addStyleClass("sapUiFlVarMngmtFavColor");var d1=new f({cells:[c1,W,new R({groupName:this.getId(),select:$,selected:{path:U+"/defaultVariant",model:this._sModelName,formatter:function(e1){return(X.key===e1)?true:false;}}}),new p({select:_,selected:'{'+this._sModelName+">executeOnSelect}"}),new h({text:'{'+this._sModelName+">author}",textAlign:"Begin"}),Q,new h({text:'{'+this._sModelName+">key}"})]});return d1;};E.prototype._openManagementDialog=function(){this._createManagementDialog();if(this.oVariantPopOver){this.oVariantPopOver.close();}this._clearDeletedItems();this.oManagementSave.setEnabled(false);this._oSearchFieldOnMgmtDialog.setValue("");if(this._bDeleteOccured){this._bDeleteOccured=false;this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});}this.oManagementDialog.open();};E.prototype._assignColumnInfoForDeleteButton=function(e){if(!this._oInvisibleDeleteColumnName){this._oInvisibleDeleteColumnName=new I({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")});this.oManagementDialog.addContent(this._oInvisibleDeleteColumnName);}if(this._oInvisibleDeleteColumnName){e.addAriaLabelledBy(this._oInvisibleDeleteColumnName);}};E.prototype._handleManageDefaultVariantChange=function(e,M){var N=M.key;if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if(this.getShowFavorites()&&!M.favorite&&e){M.favorite=!M.favorite;this._setFavoriteIcon(e.getParent().getCells()[E.COLUMN_FAV_IDX],M.favorite);}this.setDefaultVariantKey(N);};E.prototype._handleManageCancelPressed=function(){var e,M;this._getDeletedItems().forEach(function(N){N.visible=true;});this._getItems().forEach(function(N){N.title=N.originalTitle;N.favorite=N.originalFavorite;N.executeOnSelection=N.originalExecuteOnSelection;});e=this.getOriginalDefaultVariantKey();if(e!==this.getDefaultVariantKey()){this.setDefaultVariantKey(e);}M=this.getModel(this._sModelName);if(M){M.checkUpdate();}};E.prototype._handleManageFavoriteChanged=function(e,M){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if((this.getDefaultVariantKey()===M.key)&&M.favorite){return;}M.favorite=!M.favorite;this._setFavoriteIcon(e,M.favorite);};E.prototype._handleManageDeletePressed=function(e){var M,N=e.key;if(this.oManagementTable.getItems().length===1){return;}if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}e.visible=false;this._addDeletedItem(e);if((N===this.getDefaultVariantKey())){this.setDefaultVariantKey(this.getStandardVariantKey());}M=this.getModel(this._sModelName);if(M){M.checkUpdate();}this.oManagementCancel.focus();};E.prototype._handleManageExecuteOnSelectionChanged=function(e){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}};E.prototype._handleManageTitleChanged=function(e){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}};E.prototype._handleManageSavePressed=function(){this._getDeletedItems().some(function(e){if(e.key===this.getCurrentVariantKey()){var M=this.getStandardVariantKey();this.setModified(false);this.setCurrentVariantKey(M);this.fireEvent("select",{key:M});return true;}return false;}.bind(this));this.fireManage();this.oManagementDialog.close();};E.prototype._anyInErrorState=function(M){var e,N,Q=false;if(M){e=M.getItems();e.some(function(U){N=U.getCells()[E.COLUMN_NAME_IDX];if(N&&N.getValueState&&(N.getValueState()===V.Error)){Q=true;}return Q;});}return Q;};E.prototype._getFilters=function(e){var M=[];if(e){M.push(e);}M.push(this._getVisibleFilter());if(this.getShowFavorites()){M.push(this._getFilterFavorites());}return M;};E.prototype._getVisibleFilter=function(){return new F({path:"visible",operator:sap.ui.model.FilterOperator.EQ,value1:true});};E.prototype._getFilterFavorites=function(){return new F({path:"favorite",operator:sap.ui.model.FilterOperator.EQ,value1:true});};E.prototype._checkVariantNameConstraints=function(e,M,N){if(!e){return;}var Q=e.getValue();Q=Q.trim();if(!this._checkIsDuplicate(Q,N)){if(Q===""){e.setValueState(V.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));}else if(Q.indexOf('{')>-1){e.setValueState(V.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NOT_ALLOWED_CHAR",["{"]));}else if(Q.length>E.MAX_NAME_LEN){e.setValueState(V.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[E.MAX_NAME_LEN]));}else{e.setValueState(V.None);e.setValueStateText(null);}}else{e.setValueState(V.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"));}if(M){if(e.getValueState()===V.Error){M.setEnabled(false);}else{M.setEnabled(true);}}};E.prototype._checkIsDuplicate=function(e,M){var N=false,Q=this._getItems(),U=e.toLowerCase();Q.some(function(W){if(W.title.toLowerCase()===U){if(M&&(M===W.key)){return false;}N=true;}return N;});return N;};E.prototype.exit=function(){var M;if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy();}this.oDefault=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy();}this.oExecuteOnSelect=undefined;this._oRb=undefined;this.oContext=undefined;this._oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantPopoverTrigger=undefined;this.oVariantInvisibleText=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;M=this.getModel(E.INNER_MODEL_NAME);if(M){M.destroy();}};return E;},true);
