/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/ControlVariant","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/fl/FlexControllerFactory","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/util/UrlParser","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,j,k,l,m,n,o,T,p,U,r,s,t,u,v,w,B,x,y,z,E,G,H,I,J,K,N,Q,V,W){"use strict";var X="sap-ui-fl-max-layer";var Y="STARTING";var Z="STARTED";var $="STOPPED";var _="FAILED";var a1="SERVICE_STARTING";var b1="SERVICE_STARTED";var c1="SERVICE_FAILED";var d1=M.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"customFieldUrl":"string","showCreateCustomField":"boolean","showToolbars":{type:"boolean",defaultValue:true},"triggeredFromDialog":{type:"boolean",defaultValue:false},"showWindowUnloadDialog":{type:"boolean",defaultValue:true},"commandStack":{type:"any"},"plugins":{type:"any",defaultValue:{}},"flexSettings":{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},"mode":{type:"string",defaultValue:"adaptation"},"metadataScope":{type:"string",defaultValue:"default"},"validateAppVersion":{type:"boolean",defaultValue:false}},events:{"start":{parameters:{editablePluginsCount:{type:"int"}}},"stop":{},"failed":{},"selectionChange":{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},"modeChanged":{},"undoRedoStackModified":{}}},_sAppTitle:null,_dependents:null,_sStatus:$,constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new w(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}},_RESTART:{NOT_NEEDED:"no restart",VIA_HASH:"without max layer",RELOAD_PAGE:"reload"}});d1.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var i=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new l({commandFactory:i,multiSelectionRequiredPlugins:[j.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var g1=new c({commandFactory:i});this._mDefaultPlugins["dragDrop"]=new b({elementMover:g1,commandFactory:i,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:i,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:i,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:i});this._mDefaultPlugins["remove"]=new e({commandFactory:i});this._mDefaultPlugins["cutPaste"]=new d({elementMover:g1,commandFactory:i});this._mDefaultPlugins["settings"]=new m({commandFactory:i});this._mDefaultPlugins["combine"]=new j({commandFactory:i});this._mDefaultPlugins["split"]=new k({commandFactory:i});this._mDefaultPlugins["contextMenu"]=new o({styleClass:U.getRtaStyleClassName()});this._mDefaultPlugins["tabHandling"]=new T();this._mDefaultPlugins["controlVariant"]=new n({commandFactory:i});}return q.extend({},this._mDefaultPlugins);};d1.prototype.addDependent=function(i,g1,h1){h1=typeof h1==='undefined'?true:!!h1;if(!(g1 in this._dependents)){if(g1&&h1){this['get'+K(g1,0)]=this.getDependent.bind(this,g1);}this._dependents[g1||i.getId()]=i;}else{throw r.createError("RuntimeAuthoring#addDependent",r.printf("Can't add dependency with same key '{0}'",g1),"sap.ui.rta");}};d1.prototype.getDependent=function(i){return this._dependents[i];};d1.prototype.getDependents=function(){return this._dependents;};d1.prototype.removeDependent=function(i){delete this._dependents[i];};d1.prototype._destroyDefaultPlugins=function(i){for(var g1 in this._mDefaultPlugins){var h1=this._mDefaultPlugins[g1];if(h1&&!h1.bIsDestroyed){if(!i||i[g1]!==h1){h1.destroy();}}}if(!i){this._mDefaultPlugins=null;}};d1.prototype.onPopupOpen=function(i){if(i.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};d1.prototype.onPopupClose=function(i){if(i.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};d1.prototype.setPlugins=function(i){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",i);};d1.prototype.setFlexSettings=function(i){var g1=new N(window.location.href);var h1=g1.get("sap-ui-layer");i=q.extend({},this.getFlexSettings(),i);if(h1){i.layer=h1;}if(i.scenario||i.baseId){var i1=s.buildLrepRootNamespace(i.baseId,i.scenario,i.projectId);i.rootNamespace=i1;i.namespace=i1+"changes/";}U.setRtaStyleClassName(i.layer);this.setProperty("flexSettings",i);};d1.prototype.getLayer=function(i){return this.getFlexSettings().layer;};d1.prototype._getFlexController=function(){var i=this._oRootControl||sap.ui.getCore().byId(this.getRootControl());return p.createForControl(i);};d1.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};d1.prototype.start=function(){this._sStatus=Y;var i;if(!this._oDesignTime){this._oRootControl=sap.ui.getCore().byId(this.getRootControl());if(!this._oRootControl){var g1=new Error("Root control not found");s.log.error(g1);return Promise.reject(g1);}if(this.getValidateAppVersion()&&!s.isCorrectAppVersionFormat(this._getFlexController().getAppVersion())){var g1=this._getTextResources().getText("MSG_INCORRECT_APP_VERSION_ERROR");s.log.error(g1);return Promise.reject(g1);}return this._handlePersonalizationChangesOnStart().then(function(h1){if(h1){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(k1){if(this.getPlugins()[k1].attachElementModified){this.getPlugins()[k1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var i1=Object.keys(this.getPlugins());var j1=i1.map(function(k1){return this.getPlugins()[k1];},this);i=new Promise(function(k1,l1){Q.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:j1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}this._oRootControl.addStyleClass("sapUiRtaRoot");this._oDesignTime.getSelectionManager().attachChange(function(m1){this.fireSelectionChange({selection:m1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){k1();Q.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(m1){l1(m1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getPublishAndAppVariantSupportVisibility().then(function(h1){var i1=h1[0];var j1=h1[1];this._createToolsMenu(i1,j1);}.bind(this));}}.bind(this)).then(function(){this._onStackModified();this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);}.bind(this)).then(function(){y.loadStyles('InPageStyles').then(function(h1){var i1=h1.replace(/%scrollWidth%/g,x.getScrollbarWidth()+'px');x.insertStyles(i1,O.getOverlayContainer().get(0));});}).then(function(){return i;}).then(function(){if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){this.getPopupManager().setRta(this);}.bind(this)).then(function(){this._sStatus=Z;this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this),function(g1){if(g1!=="Reload triggered"){this._sStatus=_;this.fireFailed(g1);}if(g1){return Promise.reject(g1);}}.bind(this));}};d1.prototype._getPublishAndAppVariantSupportVisibility=function(){return t.getInstance().then(function(i){var g1=E.isPlatFormEnabled(this._oRootControl,this.getLayer(),this._oSerializer);return[!i.isProductiveSystem()&&!i.hasMergeErrorOccured(),!i.isProductiveSystem()&&g1];}.bind(this)).catch(function(){return false;});};var e1=function(g1){B.hide();var h1="";if(g1.messages&&Array.isArray(g1.messages)){for(var i=0;i<g1.messages.length;i++){h1=(g1.messages[i].severity==="Error")?h1+g1.messages[i].text+"\n":h1;}}else{h1=g1.stack||g1.message||g1.status||g1;}var i1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");V.error("Failed to transfer runtime adaptation changes to layered repository",h1);var j1=i1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+i1.getText("MSG_ERROR_REASON",h1);u.error(j1,{styleClass:U.getRtaStyleClassName()});};d1.prototype.setCommandStack=function(i){var g1=this.getProperty("commandStack");if(g1){g1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var h1=this.setProperty("commandStack",i);if(i){i.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(i);}return h1;};d1.prototype.getCommandStack=function(){var i=this.getProperty("commandStack");if(!i){i=new C();this._oInternalCommandStack=i;this.setCommandStack(i);}return i;};d1.prototype._onStackModified=function(){var i=this.getCommandStack();var g1=i.canUndo();var h1=i.canRedo();var i1=U.getUshellContainer();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(g1,h1);this.getToolbar().setPublishEnabled(this._bChangesExist||g1);this.getToolbar().setRestoreEnabled(this._bChangesExist||g1);}this.fireUndoRedoStackModified();if(i1){if(g1){i1.setDirtyFlag(true);}else{i1.setDirtyFlag(false);}}};d1.prototype._closeToolbar=function(){if(this.getShowToolbars()&&this.getToolbar){return this.getToolbar().hide();}};d1.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}else{return[];}};d1.prototype.stop=function(i,g1){return((g1)?Promise.resolve(this._RESTART.NOT_NEEDED):this._handleReloadOnExit()).then(function(h1){return((i)?Promise.resolve():this._serializeToLrep(this)).then(this._closeToolbar.bind(this)).then(function(){this.fireStop();if(h1!==this._RESTART.NOT_NEEDED){this._removeMaxLayerParameter();if(h1===this._RESTART.RELOAD_PAGE){this._reloadPage();}}}.bind(this));}.bind(this)).catch(e1).then(function(){this._sStatus=$;}.bind(this));};d1.prototype.restore=function(){this._onRestore();};d1.prototype.transport=function(){return this._onTransport();};d1.prototype.undo=function(){return this._onUndo();};d1.prototype.redo=function(){return this._onRedo();};d1.prototype.canUndo=function(){return this.getCommandStack().canUndo();};d1.prototype.canRedo=function(){return this.getCommandStack().canRedo();};d1.prototype._onKeyDown=function(i){var g1=G.os.macintosh;var h1=O.getOverlayContainer().get(0).contains(document.activeElement);var i1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var j1=document.body===document.activeElement;var k1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((h1||i1||j1)&&!k1){var l1=g1?i.metaKey:i.ctrlKey;if(i.keyCode===W.Z&&i.shiftKey===false&&i.altKey===false&&l1===true){this._onUndo().then(i.stopPropagation.bind(i));}else if(((g1&&i.keyCode===W.Z&&i.shiftKey===true)||(!g1&&i.keyCode===W.Y&&i.shiftKey===false))&&i.altKey===false&&l1===true){this._onRedo().then(i.stopPropagation.bind(i));}}};d1.prototype._onUnload=function(){var i=this.getCommandStack();var g1=i.canUndo()||i.canRedo();if(g1&&this.getShowWindowUnloadDialog()){var h1=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return h1;}else{window.onbeforeunload=this._oldUnloadHandler;}};d1.prototype._serializeToLrep=function(){return this._oSerializer.saveCommands().then(this._invalidateCache.bind(this));};d1.prototype._invalidateCache=function(){return this._getFlexController().getComponentChanges(undefined,true);};d1.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};d1.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};d1.prototype._createToolsMenu=function(i,g1){if(!this.getDependent('toolbar')){var h1;if(this.getLayer()==="USER"){h1=P;}else if(U.getFiori2Renderer()){h1=F;}else{h1=S;}if(this.getLayer()==="USER"){this.addDependent(new h1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new h1({modeSwitcher:this.getMode(),publishVisible:i,textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:E.onGetOverview.bind(null,true),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:E.onSaveAsFromRtaToolbar.bind(null,true,true)}),'toolbar');}var i1;if(g1){this.getToolbar().getControl('saveAs').setVisible(g1);i1=E.isOverviewExtended();if(i1){this.getToolbar().getControl('appVariantOverview').setVisible(g1);}else{this.getToolbar().getControl('manageApps').setVisible(g1);}E.isManifestSupported().then(function(j1){if(i1){this.getToolbar().getControl('appVariantOverview').setEnabled(j1);}else{this.getToolbar().getControl('manageApps').setEnabled(j1);}this.getToolbar().getControl('saveAs').setEnabled(j1);}.bind(this));}this._checkChangesExist().then(function(j1){if(!this.bIsDestroyed){this._bChangesExist=j1;this.getToolbar().setPublishEnabled(j1);this.getToolbar().setRestoreEnabled(j1);}}.bind(this));}};d1.prototype._onGetAppVariantOverview=function(i){var g1=i.getParameter("item");var h1=g1.getId()==='keyUser';return E.onGetOverview(h1);};d1.prototype.destroy=function(){q.map(this._dependents,function(g1,h1){this.removeDependent(h1);g1.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(g1){this.stopService(g1);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._oRootControl){this._oRootControl.removeStyleClass("sapUiRtaRoot");}this.setCommandStack(null);var i=U.getUshellContainer();if(i){i.setDirtyFlag(false);}if(this._oServiceEventBus){this._oServiceEventBus.destroy();}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};d1.prototype._onTransport=function(){this._handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();return this._getFlexController()._oChangePersistence.transportAllUIChanges(this._oRootControl,U.getRtaStyleClassName(),this.getLayer()).then(function(i){if(i!=="Error"&&i!=="Cancel"){this._showMessageToast("MSG_TRANSPORT_SUCCESS");}}.bind(this));}.bind(this))['catch'](e1);};d1.prototype._deleteChanges=function(){return this._getFlexController().resetChanges(this.getLayer(),"Change.createInitialFileContent",s.getAppComponentForControl(this._oRootControl||sap.ui.getCore().byId(this.getRootControl()))).then(function(){this._reloadPage();}.bind(this))["catch"](function(i){return U._showMessageBox(u.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",i);});};d1.prototype._reloadPage=function(){window.location.reload();};d1.prototype._showMessageToast=function(i){var g1=this._getTextResources().getText(i);v.show(g1);};d1.needsRestart=function(i){var g1=!!window.sessionStorage.getItem("sap.ui.rta.restart."+i);return g1;};d1.enableRestart=function(i){window.sessionStorage.setItem("sap.ui.rta.restart."+i,true);};d1.disableRestart=function(i){window.sessionStorage.removeItem("sap.ui.rta.restart."+i);};d1.prototype._onRestore=function(){var i=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var g1=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var h1=function(i1){if(i1==="OK"){d1.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();u.confirm(i,{icon:u.Icon.WARNING,title:g1,onClose:h1,styleClass:U.getRtaStyleClassName()});};d1.prototype._scheduleRenameOnCreatedContainer=function(i,g1){var h1=function(l1){var m1=this.getPlugins()["createContainer"].getCreatedContainerId(i,l1.getElement().getId());var n1=J.getOverlay(m1);n1.setSelected(true);this.getPlugins()["rename"].startEdit(n1);};var i1=function(l1){var m1=l1.getSource();if(m1.getGeometry()&&m1.getGeometry().visible){h1.call(this,m1);m1.detachEvent('geometryChanged',i1,this);}};var j1=function(l1){var m1=l1.getSource();if(!m1.getGeometry()||!m1.getGeometry().visible){m1.attachEvent('geometryChanged',i1,this);}else{h1.call(this,m1);}m1.detachEvent('afterRendering',j1,this);};var k1=function(l1){var m1=l1.getParameter("elementOverlay");if(m1.getElement().getId()===g1){this._oDesignTime.detachEvent("elementOverlayCreated",k1,this);m1.attachEvent('afterRendering',j1,this);}};this._oDesignTime.attachEvent("elementOverlayCreated",k1,this);};d1.prototype._handleElementModified=function(i){this._handleStopCutPaste();var g1=i.getParameter("action");var h1=i.getParameter("newControlId");var i1=i.getParameter("command");if(i1 instanceof sap.ui.rta.command.BaseCommand){if(g1&&h1){this._scheduleRenameOnCreatedContainer(g1,h1);}return this.getCommandStack().pushAndExecute(i1).catch(function(j1){if(j1&&j1.message&&j1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U._showMessageBox(u.Icon.ERROR,"HEADER_DEPENDENCY_ERROR","MSG_DEPENDENCY_ERROR",j1);}s.log.error("sap.ui.rta: "+j1.message);});}return Promise.resolve();};d1.prototype._onElementEditableChange=function(i){var g1=i.getParameter("editable");if(g1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};d1.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};d1.prototype._checkChangesExist=function(){if(this._getFlexController().getComponentName().length>0){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer(),includeCtrlVariants:true}).then(function(i){return i.length>0;});}else{return Promise.resolve(false);}};d1.prototype._getURLParsedHash=function(){var i=sap.ushell.Container.getService("URLParsing");if(i.parseShellHash&&i.getHash){return i.parseShellHash(i.getHash(window.location.href));}};d1.prototype._buildNavigationArguments=function(i){return{target:{semanticObject:i.semanticObject,action:i.action,context:i.contextRaw},params:i.params,appSpecificRoute:i.appSpecificRoute,writeHistory:false};};d1.prototype._hasCustomerLayerParameter=function(i){return i.params&&i.params[X]&&i.params[X][0]==="CUSTOMER";};d1.prototype._reloadWithoutPersonalizationChanges=function(i,g1){if(!this._hasCustomerLayerParameter(i)){if(!i.params){i.params={};}i.params[X]=["CUSTOMER"];d1.enableRestart("CUSTOMER");g1.toExternal(this._buildNavigationArguments(i));return Promise.resolve(true);}};d1.prototype._removeMaxLayerParameter=function(){if(U.getUshellContainer()&&this.getLayer()!=="USER"){var i=U.getUshellContainer().getService("CrossApplicationNavigation");var g1=this._getURLParsedHash();if(i.toExternal&&g1){if(this._hasCustomerLayerParameter(g1)){delete g1.params[X];i.toExternal(this._buildNavigationArguments(g1));}}}};d1.prototype._handlePersonalizationMessageBoxOnStart=function(){return U._showMessageBox(u.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS","MSG_PERSONALIZATION_EXISTS");};d1.prototype._handleReloadMessageBox=function(i){return U._showMessageBox(u.Icon.INFORMATION,"HEADER_RELOAD_NEEDED",i,undefined,"BUTTON_RELOAD_NEEDED");};d1.prototype._handlePersonalizationChangesOnStart=function(){var i=U.getUshellContainer();if(i&&this.getLayer()!=="USER"){var g1=this._getURLParsedHash();return this._getFlexController().isPersonalized({ignoreMaxLayerParameter:false}).then(function(h1){if(h1){return this._handlePersonalizationMessageBoxOnStart().then(function(){var i1=sap.ushell.Container.getService("CrossApplicationNavigation");if(i1.toExternal&&g1){return this._reloadWithoutPersonalizationChanges(g1,i1);}}.bind(this));}}.bind(this));}else{return Promise.resolve(false);}};d1.prototype._handleReloadOnExit=function(){return Promise.all([this._oSerializer.needsReload(),this._getFlexController().isPersonalized({ignoreMaxLayerParameter:true})]).then(function(i){var g1=i[0],h1=i[1];if(g1||h1){var i1=this._RESTART.RELOAD_PAGE;var j1,k1;if(h1){j1="MSG_RELOAD_WITH_PERSONALIZATION";k1=U.getUshellContainer();if(!g1&&k1){i1=this._RESTART.VIA_HASH;}}else if(g1){j1="MSG_RELOAD_NEEDED";}return this._handleReloadMessageBox(j1).then(function(){return i1;});}else{return this._RESTART.NOT_NEEDED;}}.bind(this));};d1.prototype._onModeChange=function(i){this.setMode(i.getParameter("item").getKey());};d1.prototype.setMode=function(i){if(this.getProperty('mode')!==i){var g1=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var h1=i==='adaptation';if(g1){g1.setSelectedButton(g1.getItems().filter(function(i1){return i1.getKey()===i;}).pop().getId());}this._oDesignTime.setEnabled(h1);this.getPlugins()['tabHandling'][h1?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',i);this.fireModeChanged({mode:i});}};d1.prototype.setMetadataScope=function(i){if(this._oDesignTime){V.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',i);};function f1(i){if(H.hasOwnProperty(i)){return H[i].replace(/\./g,'/');}}d1.prototype.startService=function(i){if(this._sStatus!==Z){return new Promise(function(i1,j1){this.attachEventOnce('start',i1);this.attachEventOnce('failed',j1);}.bind(this)).then(function(){return this.startService(i);}.bind(this),function(){return Promise.reject(r.createError("RuntimeAuthoring#startService",r.printf("Can't start the service '{0}' while RTA has been failed during a startup",i),"sap.ui.rta"));});}var g1=f1(i);var h1;if(!g1){return Promise.reject(r.createError("RuntimeAuthoring#startService",r.printf("Unknown service. Can't find any registered service by name '{0}'",i),"sap.ui.rta"));}else{h1=this._mServices[i];if(h1){switch(h1.status){case b1:{return Promise.resolve(h1.exports);}case a1:{return h1.initPromise;}case c1:{return h1.initPromise;}default:{return Promise.reject(r.createError("RuntimeAuthoring#startService",r.printf("Unknown service status. Service name = '{0}'",i),"sap.ui.rta"));}}}else{this._mServices[i]=h1={status:a1,location:g1,initPromise:new Promise(function(i1,j1){sap.ui.require([g1],function(k1){h1.factory=k1;if(!this._oServiceEventBus){this._oServiceEventBus=new I();}r.wrapIntoPromise(k1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,i)).then(function(l1){if(this.bIsDestroyed){throw r.createError("RuntimeAuthoring#startService",r.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",i),"sap.ui.rta");}if(!q.isPlainObject(l1)){throw r.createError("RuntimeAuthoring#startService",r.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",i),"sap.ui.rta");}h1.service=l1;h1.exports={};if(Array.isArray(l1.events)&&l1.events.length>0){q.extend(h1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,i),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,i),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,i)});}var m1=l1.exports||{};q.extend(h1.exports,Object.keys(m1).reduce(function(n1,o1){var p1=m1[o1];n1[o1]=typeof p1==="function"?r.wrapIntoPromise(p1):p1;return n1;},{}));h1.status=b1;i1(Object.freeze(h1.exports));}.bind(this)).catch(j1);}.bind(this),function(k1){h1.status=c1;j1(r.propagateError(k1,"RuntimeAuthoring#startService",r.printf("Can't load service '{0}' by its name: {1}",i,g1),"sap.ui.rta"));});}.bind(this)).catch(function(i1){h1.status=c1;return Promise.reject(r.propagateError(i1,"RuntimeAuthoring#startService",r.printf("Error during service '{0}' initialisation.",i),"sap.ui.rta"));})};return h1.initPromise;}}};d1.prototype.stopService=function(i){var g1=this._mServices[i];if(g1){if(g1.status===b1){if(typeof g1.service.destroy==="function"){g1.service.destroy();}}delete this._mServices[i];}else{throw r.createError("RuntimeAuthoring#stopService",r.printf("Can't destroy service: unable to find service with name '{0}'",i),"sap.ui.rta");}};d1.prototype.getService=function(i){return this.startService(i);};return d1;},true);
