/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/unified/Calendar',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,D,H,M,b,Y,c,l,d,e,R,f,g,h,j,k,q){"use strict";
var m=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});
m.prototype.init=function(){this._iBreakPointTablet=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._iColumns=1;this._oYearFormat=e.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var x=this._createMonth(this.getId()+"--Month0");x.attachEvent("focus",this._handleFocus,this);x.attachEvent("select",s,this);x.attachEvent("_renderMonth",r,this);x.attachEvent("_bindMousemove",t,this);x.attachEvent("_unbindMousemove",u,this);x._bNoThemeChange=true;this.addAggregation("month",x);this._initilizeMonthPicker();this._initilizeYearPicker();this._resizeProxy=q.proxy(v,this);this._oSelectedMonth;};
m.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};
m.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this.setAggregation("header",i);};
m.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead");S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("secondMonthHeader",S);};
m.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};
m.prototype._initilizeYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);this.setAggregation("yearPicker",y);};
m.prototype._createMonth=function(i){var x=new M(i,{width:"100%"});x.attachEvent("datehovered",this._handleDateHovered,this);return x;};
m.prototype._handleDateHovered=function(E){var x=this.getAggregation("month"),y=E.getParameter("date1"),z=E.getParameter("date2"),i;for(i=0;i<x.length;i++){x[i]._markDatesBetweenStartAndHoveredDate(y,z);}};
m.prototype.onBeforeRendering=function(){var x=this.getAggregation("month");var y;var z=x[0].getDate();var F=this._getFocusedDate();if(x.length>1&&z){y=c.fromLocalJSDate(z,this.getPrimaryCalendarType());}else if(x.length>1){y=w.call(this,this._getFocusedDate());}else{y=F;}for(var i=0;i<x.length;i++){z=new c(y);if(i>0){z.setDate(1);z.setMonth(z.getMonth()+i);}var A=z;if(F.getYear()===z.getYear()&&F.getMonth()===z.getMonth()){A=F;}x[i].displayDate(A.toLocalJSDate());x[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(y);this._iSize=0;};
m.prototype.onAfterRendering=function(E){if(!this._getSucessorsPickerPopup()){n.call(this);}if(p.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};v.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};
m.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof D))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=setTimeout(this._invalidateMonth.bind(this,O),0);}};
m.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};
m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};
m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};
m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
m.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
m.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};
m.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
m.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};
m.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
m.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};
m.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};
m.prototype.focusDate=function(i){o.call(this,i,false);return this;};
m.prototype.displayDate=function(i){o.call(this,i,true);return this;};
m.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};
m.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};
m.prototype.setMonths=function(x){this._bDateRangeChanged=undefined;this.setProperty("months",x,false);x=p.call(this);var y=this.getAggregation("month");var i=0;var z;if(y.length<x){for(i=y.length;i<x;i++){z=this._createMonth(this.getId()+"--Month"+i);z.attachEvent("focus",this._handleFocus,this);z.attachEvent("select",s,this);z.attachEvent("_renderMonth",r,this);z.attachEvent("_bindMousemove",t,this);z.attachEvent("_unbindMousemove",u,this);z._bNoThemeChange=true;this.addAggregation("month",z);}}else if(y.length>x){for(i=y.length;i>x;i--){z=this.removeAggregation("month",i-1);z.destroy();}if(x==1){this._bInitMonth=true;}}if(x>1&&y[0].getDate()){y[0].setProperty("date",null,true);}return this;};
m.prototype.setPrimaryCalendarType=function(x){var y=this.getAggregation("month");var z=false;if(y.length>1){z=true;}this.setProperty("primaryCalendarType",x,!z);this._oYearFormat=e.getDateInstance({format:"y",calendarType:x});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,x);}this._oMinDate=new c(this._oMinDate,x);this._oMaxDate=new c(this._oMaxDate,x);for(var i=0;i<y.length;i++){var A=y[i];A.setPrimaryCalendarType(x);}if(!this._getSucessorsPickerPopup()){var B=this.getAggregation("monthPicker");B.setPrimaryCalendarType(x);var E=this.getAggregation("yearPicker");E.setPrimaryCalendarType(x);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&B.getDomRef()){B.$().remove();}if(this.iMode!=2&&E.getDomRef()){E.$().remove();}}}return this;};
m.prototype.setSecondaryCalendarType=function(x){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",x,true);this._oYearFormatSecondary=e.getDateInstance({format:"y",calendarType:x});var y=this.getAggregation("month");for(var i=0;i<y.length;i++){var z=y[i];z.setSecondaryCalendarType(x);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};
m.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};
m.prototype.setMinDate=function(i){if(j(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMinDate.getYear();a._checkYearInValidRange(y);if(this._oMaxDate.isBefore(this._oMinDate)){k.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){var x=this.getAggregation("yearPicker");x._oMinDate.setYear(this._oMinDate.getYear());}return this;};
m.prototype.setMaxDate=function(i){if(j(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMaxDate.getYear();a._checkYearInValidRange(y);if(this._oMinDate.isAfter(this._oMaxDate)){k.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){var x=this.getAggregation("yearPicker");x._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};
m.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){k.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};
m.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var x=new f(i);this._oLocaleData=L.getInstance(x);}return this._oLocaleData;};
m.prototype._getShowMonthHeader=function(){var i=p.call(this);if(i>2){return true;}else{return false;}};
m.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};
m.prototype.onclick=function(E){var i=E.target,T=i.classList.contains("sapUiCalWeekNum");if(this.getIntervalSelection()&&this.getPrimaryCalendarType()===sap.ui.core.CalendarType.Gregorian&&T){this._handleWeekSelection(i);}if(E.isMarked("delayedMouseEvent")){return;}if(i.id==this.getId()+"-cancel"){this.onsapescape(E);}};
m.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};
m.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};
m.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};
m.prototype.onsaphide=m.prototype.onsapshow;
m.prototype.onsaptabnext=function(E){var x=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabNext(E)){var y=x.getDomRef("B2");if(y){y.focus();}}else{var z=x.getDomRef("B1");if(z){z.focus();}}if(!this._bPoupupMode){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}else if(this._shouldFocusB2OnTabNext(E)){var y=x.getDomRef("B2");if(y){y.focus();}E.preventDefault();}};
m.prototype._shouldFocusB2OnTabNext=function(E){var i=this.getAggregation("header");return(E.target.id==i.getId()+"-B1");};
m.prototype._shouldFocusB2OnTabPrevious=function(E){return this._bPoupupMode;};
m.prototype.onsaptabprevious=function(E){var x=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabPrevious()){var y=x.getDomRef("B2");if(y){y.focus();}E.preventDefault();}}else if(E.target.id==x.getId()+"-B1"){var z=this.getAggregation("month");var F;switch(this._iMode){case 0:F=this._getFocusedDate();for(var i=0;i<z.length;i++){var A=z[i];var B=c.fromLocalJSDate(A.getDate(),this.getPrimaryCalendarType());if(F.isSame(B)){A._oItemNavigation.focusItem(A._oItemNavigation.getFocusedIndex());}else{q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var G=this.getAggregation("monthPicker");G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var I=this.getAggregation("yearPicker");I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}else if(E.target.id==x.getId()+"-B2"){var J=x.getDomRef("B1");if(J){J.focus();}E.preventDefault();}};
m.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var x=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<x.length;i++){var y=x[i];q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var z=this.getAggregation("monthPicker");var A=this.getAggregation("yearPicker");if(z.getDomRef()){q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(A.getDomRef()){q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
m.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");var x=i.getDomRef("B2");if(x){x.focus();}};
m.prototype.onsapfocusleave=function(E){var x,y,z,A;if(!E.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){x=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<x.length;i++){y=x[i];q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){z=this.getAggregation("monthPicker");q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){A=this.getAggregation("yearPicker");q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
m.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};
m.prototype.onThemeChanged=function(){var x;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){x=this.getAggregation("monthPicker");this._showMonthPicker(true);x._bNoThemeChange=false;x.onThemeChanged(arguments);x._bNoThemeChange=true;this._bLongMonth=x._bLongMonth;this._hideMonthPicker(true);}var y=this.getAggregation("month");for(var i=0;i<y.length;i++){var z=y[i];z._bNoThemeChange=false;z.onThemeChanged(arguments);z._bNoThemeChange=true;}var A;if(y.length>1){A=c.fromLocalJSDate(y[0].getDate(),this.getPrimaryCalendarType());}else{A=this._getFocusedDate();}this._setHeaderText(A);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!this._getSucessorsPickerPopup()){n.call(this);}};
m.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};
m.prototype._togglePrevNext=function(i,x){var y=this._oMaxDate.getYear();var z=this._oMinDate.getYear();var A=this._oMaxDate.getMonth();var B=this._oMinDate.getMonth();var E=this.getAggregation("header");var F=p.call(this);var G=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&F>1){G=w.call(this,i);G.setMonth(G.getMonth()+F-1);G.setDate(a._daysInMonth(G));}else{G.setDate(a._daysInMonth(G));}var I=G.getYear();var J=G.getMonth();if(I>y||(I==y&&(!x||J>=A))||(this._iMode==1&&this._getSucessorsPickerPopup())){E.setEnabledNext(false);}else{E.setEnabledNext(true);}if(this._iMode==0&&F>1){G.setMonth(G.getMonth()-F+1);G.setDate(1);}else{G.setDate(1);}I=G.getYear();J=G.getMonth();if(I<z||(I==z&&(!x||J<=B))||(this._iMode==1&&this._getSucessorsPickerPopup())){E.setEnabledPrevious(false);}else{E.setEnabledPrevious(true);}};
m.prototype._togglePrevNexYearPicker=function(){var y=this.getAggregation("yearPicker");var i=y.getYears();var x=c.fromLocalJSDate(y.getFirstRenderedDate());x.setYear(x.getYear()+Math.floor(i/2));var z=this.getAggregation("header");var A=new c(this._oMaxDate,this.getPrimaryCalendarType());A.setYear(A.getYear()-Math.ceil(i/2));A.setMonth(11);A.setDate(31);var B=new c(this._oMinDate,this.getPrimaryCalendarType());B.setYear(B.getYear()+Math.floor(i/2)+1);B.setMonth(0);B.setDate(1);z.setEnabledNext(x.isSameOrBefore(A));z.setEnabledPrevious(x.isSameOrAfter(B));};
m.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var i=p.call(this);var x;var z;var S=false;switch(this._iMode){case 0:if(i>1){x=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());x.setDate(1);this._setFocusedDate(x);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var A=this._getSecondaryCalendarType();if(A){z=new c(F,A);z.setMonth(0);z.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(z.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.previousPage();this._togglePrevNexYearPicker();break;}};
m.prototype._handleNext=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var i=p.call(this);var x;var z;switch(this._iMode){case 0:if(i>1){x=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(x);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+i);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){z=new c(F,S);z.setMonth(0);z.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(z.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.nextPage();this._togglePrevNexYearPicker();break;}};
m.prototype._getDisplayedMonths=function(x){var y=[];var z=x.getMonth();var A=p.call(this);if(A>1){for(var i=0;i<A;i++){y.push((z+i)%12);}}else{y.push(z);}return y;};
m.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var x=F.getMonth();var y=c.fromLocalJSDate(i[i.length-1].getDate(),P);y.setDate(a._daysInMonth(y));y=new c(y,S);var E=y.getMonth();return{start:x,end:E};};
m.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;}};
m.prototype._setDisabledMonths=function(y,i){var x=0;var z=11;if(y==this._oMinDate.getYear()){x=this._oMinDate.getMonth();}if(y==this._oMaxDate.getYear()){z=this._oMaxDate.getMonth();}if(!i){i=this.getAggregation("monthPicker");}i.setMinMax(x,z);};
m.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var x=E.getParameter("restoreOldDate");if(x){if(!j(this._getFocusedDate(),i)){this._renderMonth(false,false,true);}}else{this._focusDate(i,O);}};
m.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};
m.prototype._renderMonth=function(S,I,N){var x=this._getFocusedDate();var y=this.getAggregation("month");var F=false;var z;var A;var B;var i=0;for(i=0;i<y.length;i++){z=y[i];if(z.checkDateFocusable(x.toLocalJSDate())){F=true;}if(F||y.length==1){if(!S){z.setDate(x.toLocalJSDate());}else{z.displayDate(x.toLocalJSDate());}break;}}if(!F){B=new c(x,this.getPrimaryCalendarType());if(y.length>1){B=w.call(this,B);for(i=0;i<y.length;i++){z=y[i];A=new c(B,this.getPrimaryCalendarType());A.setMonth(B.getMonth()+i);if(!S&&a._isSameMonthAndYear(A,x)){z.setDate(x.toLocalJSDate());}else{z.displayDate(A.toLocalJSDate());}}}this._updateHeader(B);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!N){this.fireStartDateChange();}}};
function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}
m.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var x=this._getFocusedDate();var y=this.getAggregation("monthPicker");if(y.getDomRef()){y.$().css("display","");}else{var z=sap.ui.getCore().createRenderManager();var $=this.$("content");z.renderControl(y);z.flush($[0],false,true);z.destroy();}this._showOverlay();if(!S){y.setMonth(x.getMonth());this._setDisabledMonths(x.getYear(),y);if(this._iMode==0){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(x,false);};
m.prototype._hideMonthPicker=function(S){this._iMode=0;var x=this.getAggregation("monthPicker");x.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(p.call(this)>1){var y=this.getAggregation("month");for(var i=0;i<y.length;i++){var z=y[i];q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};
m.prototype._showYearPicker=function(){if(this._iMode==1){this._hideMonthPicker(true);}var x=this._getFocusedDate();var y=this.getAggregation("yearPicker");if(y.getDomRef()){y.$().css("display","");}else{var z=sap.ui.getCore().createRenderManager();var $=this.$("content");z.renderControl(y);z.flush($[0],false,true);z.destroy();}this._showOverlay();y.setDate(x.toLocalJSDate());var A;if(p.call(this)==1){A=this.getAggregation("month")[0];var B=A.$("days").find(".sapUiCalItem");if(B.length==28){y.$().addClass("sapUiCalYearNoTop");}else{y.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var E=this.getAggregation("month");for(var i=0;i<E.length;i++){A=E[i];q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;};
m.prototype._hideYearPicker=function(S){this._iMode=0;var y=this.getAggregation("yearPicker");y.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(p.call(this)>1){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){var z=x[i];q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};
function n(){if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var x=this.getAggregation("month");var y;if(x.length>1){y=c.fromLocalJSDate(x[0].getDate(),this.getPrimaryCalendarType());}else{y=this._getFocusedDate();}this._setHeaderText(y);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}else if(p.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}
m.prototype._focusDate=function(i,O,N){var F;var x=false;var y=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;x=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;x=true;}else{F=i;}if(this._focusDateExtend){y=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(x||O){this._renderMonth(false,I,N);}if(y){this.fireStartDateChange();}};
m.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var x=this.getAggregation("month");if(x){for(var i=0;i<x.length;i++){var y=x[i];y._bDateRangeChanged=true;y._bInvalidateSync=true;y._bNoFocus=true;y.invalidate(O);y._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};
m.prototype._setHeaderText=function(i){var x=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var y=this._getLocaleData();var z=[];var A=[];var B=[];var E;var F=false;var G;var I;var T;var J;var P;var K=this.getPrimaryCalendarType();var N=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){z=y.getMonthsStandAlone("wide",K);}else{F=true;z=y.getMonthsStandAlone("abbreviated",K);A=y.getMonthsStandAlone("wide",K);}if(N){B=y.getMonthsStandAlone("abbreviated",N);var O=this._getDisplayedSecondaryMonths(K,N);if(O.start==O.end){T=B[O.start];}else{P=y.getIntervalPattern();T=P.replace(/\{0\}/,B[O.start]).replace(/\{1\}/,B[O.end]);}}x.setAdditionalTextButton1(T);x._setAdditionalTextButton3(T);S.setAdditionalTextButton1(T);var Q=this._getDisplayedMonths(i);this._sFirstMonthName=G=z[Q[0]];I=z[Q[Q.length-1]];if(Q.length>1&&!this._bShowOneMonth){if(!P){P=y.getIntervalPattern();}T=P.replace(/\{0\}/,G).replace(/\{1\}/,I);E=A.length?P.replace(/\{0\}/,A[Q[0]]).replace(/\{1\}/,A[Q[Q.length-1]]):T;}else{T=G;E=A[Q[0]]||T;}x.setTextButton1(T);x.setAriaLabelButton1(E);x._setTextButton3(I);x._setAriaLabelButton3(I);S.setTextButton1(I);S.setAriaLabelButton1(I);var U=new c(i,K);U.setDate(1);J=this._oYearFormat.format(U.toUTCJSDate(),true);this._updateHeadersYearPrimaryText(J);if(N){U=new c(U,N);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(U.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:T,sYear:J,sAriaLabel:E,bShort:F};};
function o(i,S){if(!i){return;}var x=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=x.getYear();a._checkYearInValidRange(y);if(a._isOutside(x,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(x);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}
function p(){if(d.system.phone){return 1;}else{return this.getMonths();}}
m.prototype._handleButton1=function(E){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};
m.prototype._handleButton2=function(E){if(this._iMode!=2){this._showYearPicker();}else{this._hideYearPicker();}};
function r(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}
function s(E){if(p.call(this)>1){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){var y=x[i];if(y.getId()!=E.oSource.getId()){y._updateSelection();}}}this._oSelectedMonth=E.oSource;this.fireSelect();}
function t(E){if(p.call(this)>1){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){var y=x[i];if(y.getId()!=E.oSource.getId()){y._bindMousemove();}}}}
function u(E){if(p.call(this)>1){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){var y=x[i];if(y.getId()!=E.oSource.getId()){y._unbindMousemove();}}}}
m.prototype._selectMonth=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),x=i.getMonth();F.setMonth(x);if(x!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};
m.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};
m.prototype._selectYear=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var y=this.getAggregation("yearPicker");var i=c.fromLocalJSDate(y.getDate(),this.getPrimaryCalendarType());i.setMonth(F.getMonth());i.setDate(F.getDate());F=i;this._focusDate(F,true);this._hideYearPicker();};
m.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
m.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
m.prototype._setColumns=function(i){this._iColumns=i;return this;};
m.prototype._getColumns=function(){return this._iColumns;};
m.prototype._updateHeadersButtons=function(){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);i._setVisibleButton3(false);i._setVisibleButton4(false);}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);i._setVisibleButton3(true);i._setVisibleButton4(true);}else{S.setVisible(false);i._setVisibleButton3(false);i._setVisibleButton4(false);}};
m.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};
m.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){this.addStyleClass("sapUiCalTwoMonthsTwoColumns");}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}};
m.prototype._isTwoMonthsInOneColumn=function(){var i=p.call(this);return this._getColumns()===1&&i===2;};
m.prototype._isTwoMonthsInTwoColumns=function(){var i=p.call(this);return this._getColumns()===2&&i===2;};
m.prototype._updateHeadersYearPrimaryText=function(y){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");i.setTextButton2(y);i.setAriaLabelButton2(y);i._setTextButton4(y);i._setAriaLabelButton4(y);S.setTextButton2(y);S.setAriaLabelButton2(y);};
m.prototype._updateHeadersYearAdditionalText=function(y){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");i.setAdditionalTextButton2(y);i._setAdditionalTextButton4(y);S.setAdditionalTextButton2(y);};
m.prototype._handleWeekSelection=function(E){var S=parseInt(E.innerText,10),i=q(E.parentElement).attr("data-sap-day"),F=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"}),x=F.parse(i),y=new Date(x.getFullYear(),x.getMonth(),x.getDate()+6),z=new D({startDate:x,endDate:y}),A=this.getSelectedDates();if(A.length&&A[0].getStartDate().getTime()===z.getStartDate().getTime()&&A[0].getEndDate()&&A[0].getEndDate().getTime()===z.getEndDate().getTime()){z=null;}if(this.fireWeekNumberSelect({weekNumber:S,weekDays:z})){this.removeAllSelectedDates();this.addSelectedDate(z);this.focusDate(x);}};
function v(E){var W=E.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var x=p.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(x<this._getColumns()){this._setColumns(x);}if(this._getColumns()>2&&x>this._getColumns()){var y=this._getColumns();var U=0.0;var z=this._getColumns();while(y>=2){var A=x%y;if(A==0){z=y;break;}else{var N=A/y;if(N>U){U=N;z=y;}}y--;}this._setColumns(z);}var B;var F=this.getAggregation("month");if(this._getColumns()>1){B=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{B="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<F.length;i++){var G=F[i];G.setWidth(B);}}this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}
function w(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var x=p.call(this);if(x<=12){var y=i.getMonth();y=y-y%x;if(12%x>0&&y+x>11){y=12-x;}F.setMonth(y);}return F;}
return m;});
sap.ui.predefine('sap/ui/unified/CalendarAppointment',['./DateTypeRange','sap/ui/core/format/DateFormat','./library',"sap/base/Log"],function(D,a,l,L){"use strict";
var C=D.extend("sap.ui.unified.CalendarAppointment",{metadata:{library:"sap.ui.unified",properties:{title:{type:"string",group:"Data"},text:{type:"string",group:"Data"},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},tentative:{type:"boolean",group:"Data",defaultValue:false},selected:{type:"boolean",group:"Data",defaultValue:false},key:{type:"string",group:"Data",defaultValue:null},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
C.prototype.applyFocusInfo=function(f){var p=this.getParent();if(p){p.applyFocusInfo(f);}return this;};
C.prototype._getDateRangeIntersectionText=function(c){var s=this.getStartDate(),e=this.getEndDate()?this.getEndDate():new Date(864000000000000),t,o=new Date(c.getFullYear(),c.getMonth(),c.getDate(),0,0,0),n=new Date(o.getTime()+24*60*60*1000),T=a.getTimeInstance({pattern:"HH:mm"}),r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(s.getTime()>n.getTime()||e.getTime()<o.getTime()){t="";}else if(s.getTime()<o.getTime()&&e.getTime()>n.getTime()){t=r.getText("PLANNINGCALENDAR_ALLDAY");}else if(s.getTime()<o.getTime()){t=r.getText("PLANNINGCALENDAR_UNTIL",[T.format(e)]);}else if(e.getTime()>n.getTime()){t=T.format(s);}else{t=T.format(s)+" - "+T.format(e);}return t;};
C._getComparer=function(d){var O=24*60*60*1000,c=new Date(d.getFullYear(),d.getMonth(),d.getDate(),0,0,0).getTime(),n=c+O;return function(A,o){var s=A.appointment.getStartDate().getTime(),S=o.appointment.getStartDate().getTime(),e=A.appointment.getEndDate()?A.appointment.getEndDate().getTime():864000000000000,E=o.appointment.getEndDate()?o.appointment.getEndDate().getTime():864000000000000,w=s<=c&&e>=n,W=S<=c&&E>=n,r;if((w&&W)||(!w&&!W)){r=s-S;if(r===0){r=E-e;}}else if(w){r=-1;}else{r=1;}return r;};};
C.prototype.setColor=function(c){if(c&&c.match(/^#[0-9a-f]{6}$/i)){L.warning("setColor accepts only full hex color value with pound symbol.");}return this.setProperty("color",c);};
C.prototype._getCSSColorForBackground=function(h){return"rgba("+[parseInt(h.substr(1,2),16),parseInt(h.substr(3,2),16),parseInt(h.substr(5,2),16)].join(",")+", 0.2)";};
return C;});
sap.ui.predefine('sap/ui/unified/CalendarDateInterval',['sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/Device',"./CalendarDateIntervalRenderer","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,a,D,M,Y,b,l,c,d,e,L,q){"use strict";
var f=a.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarDateInterval.designtime"}});
f.prototype.init=function(){a.prototype.init.apply(this,arguments);this._iDaysMonthHead=35;};
f.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};
f.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};
f.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var h=this.getAggregation("header"),m,y;if(p){if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}h.setVisibleButton2(false);h.detachEvent("pressButton2",this._handleButton2,this);this._setHeaderText(this._getFocusedDate(true));}else{if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}m=this.getAggregation("monthPicker");y=this.getAggregation("yearPicker");m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);y._oMinDate.setYear(this._oMinDate.getYear());y._oMaxDate.setYear(this._oMaxDate.getYear());h.setVisibleButton2(true);h.detachEvent("pressButton2",this._handleButton2,this);h.attachEvent("pressButton2",this._handleButton2,this);}return this;};
f.prototype._createMonthPicker=function(){var m=new M(this.getId()+"--MP");m.attachEvent("select",this._selectMonth,this);m._bNoThemeChange=true;m.setColumns(0);m.setMonths(3);m.attachEvent("pageChange",_,this);return m;};
f.prototype._createYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",g,this);return y;};
f.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new a(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",this._handleCalendarPickerDateSelect,this);o.attachEvent("cancel",function(E){this._closeCalendarPicker();var h=this.getAggregation("header").getDomRef("B1");if(h){h.focus();}},this);this.setAggregation("calendarPicker",o);}return o;};
f.prototype._handleButton1=function(E){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}}};
f.prototype._setHeaderText=function(o){var t=a.prototype._setHeaderText.apply(this,arguments);var T,A=t.sAriaLabel,h=this.getAggregation("header");var i=this._getLocaleData();var E=b.fromLocalJSDate(new Date(o.toLocalJSDate().getTime()+(this._getDays()-1)*24*60*60*1000),this.getPrimaryCalendarType());E.setDate(1);var s=i.getIntervalPattern().replace("{0}","").replace("{1}","");var j=this._oYearFormat.format(E.toUTCJSDate(),true);var m=t.sMonth;if(this.getPickerPopup()){if(i.oLocale.sLanguage.toLowerCase()==="ja"||i.oLocale.sLanguage.toLowerCase()==="zh"){if(j!=t.sYear){m=m.replace(s,s+j+" ");A=A.replace(s,s+j+" ");}T=t.sYear+" "+m;A=t.sYear+" "+A;}else{if(j!=t.sYear){m=m.replace(s," "+t.sYear+s);A=A.replace(s," "+t.sYear+s);}T=m+" "+j;A=A+" "+j;}h.setTextButton1(T,true);if(t.bShort){h.setAriaLabelButton1(A);}}};
f.prototype._showCalendarPicker=function(){var s=this.getStartDate(),o=this._getCalendarPicker(),S=new sap.ui.unified.DateRange(),E=new Date(s.getTime());E.setDate(E.getDate()+this._getDays()-1);S.setStartDate(s);S.setEndDate(E);o.displayDate(this._getFocusedDate().toLocalJSDate());o.removeAllSelectedDates();o.addSelectedDate(S);o.setMinDate(this.getMinDate());o.setMaxDate(this.getMaxDate());this._openPickerPopup(o);this._showOverlay();};
f.prototype._handleCalendarPickerDateSelect=function(E){var o=this._getCalendarPicker(),s=o.getSelectedDates()[0].getStartDate(),n=new b.fromLocalJSDate(s);this._setStartDate(n);this._setFocusedDate(n);this._closeCalendarPicker();};
f.prototype._closeCalendarPicker=function(s){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!s){this._renderMonth();var m=this.getAggregation("month");for(var i=0;i<m.length;i++){var o=m[i];q(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}};
f.prototype._getDaysLarge=function(){return 10;};
f.prototype._createMonth=function(i){var m=new D(i);return m;};
f.prototype.setStartDate=function(s){C._checkJSDateObject(s);if(e(this.getStartDate(),s)){return this;}var y=s.getFullYear();C._checkYearInValidRange(y);var o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());if(C._isOutside(o,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this);}var m=this.getMinDate();if(m&&s.getTime()<m.getTime()){L.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(m.getTime());}var h=this.getMaxDate();if(h&&s.getTime()>h.getTime()){L.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(h.getTime());}this.setProperty("startDate",s,true);o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());this._oStartDate=o;var i=this.getAggregation("month")[0];i.setStartDate(s);this._updateHeader(o);var j=this._getFocusedDate(true).toLocalJSDate();if(!i.checkDateFocusable(j)){this._setFocusedDate(o);i.displayDate(s);}return this;};
f.prototype.getStartDate=function(){return this.getProperty("startDate");};
f.prototype.setDays=function(i){this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var h=Math.ceil(i/3);if(h>12){h=12;}m.setMonths(h);var y=this.getAggregation("yearPicker");var j=Math.floor(i/2);if(j>20){j=20;}y.setYears(j);}var s=this._getStartDate();this._updateHeader(s);if(this.getDomRef()){if(i>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
f.prototype._getDays=function(){var i=this.getDays();if(c.system.phone&&i>8){return 8;}else{return i;}};
f.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};
f.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};
f.prototype._getFocusedDate=function(F){if(!this._oFocusedDate||F){this._oFocusedDate=null;a.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=b.fromLocalJSDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};
f.prototype.setMonths=function(m){if(m==1){return this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};
f.prototype.setFirstDayOfWeek=function(F){if(F==-1){return this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};
f.prototype.focusDate=function(o){var h=this.getAggregation("month")[0];if(!h.checkDateFocusable(o)){this._focusDateExtend(b.fromLocalJSDate(o,this.getPrimaryCalendarType()),true,true);}a.prototype.focusDate.apply(this,arguments);return this;};
f.prototype._shouldFocusB2OnTabNext=function(E){var h=this.getAggregation("header");return(!this.getPickerPopup()&&E.target.id==h.getId()+"-B1");};
f.prototype._focusOnShiftTab=function(){var h=this.getAggregation("header");if(this.getPickerPopup()&&h.getDomRef("B1")){h.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&h.getDomRef("B2")){h.getDomRef("B2").focus();}};
f.prototype.onsapescape=function(E){if(this.getPickerPopup()){this._closeCalendarPicker();this.fireCancel();}else{if(this._iMode===0){this.fireCancel();}this._closedPickers();}};
f.prototype._focusDateExtend=function(o,O,n){if(O){var h=this._getFocusedDate();var i=this._getStartDate();var j=C._daysBetween(h,i);var N=new b(o,this.getPrimaryCalendarType());N.setDate(N.getDate()-j);this._setStartDate(N,false,true);if(!n){return true;}}return false;};
f.prototype._setMinMaxDateExtend=function(o){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){L.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new b(this._oMinDate,this.getPrimaryCalendarType()),true,true);}else{var E=new b(this._oStartDate);E.setDate(E.getDate()+this._getDays()-1);if(E.isAfter(this._oMaxDate)){L.warning("end date > maxDate -> start date will be changed",this);var s=new b(this._oMaxDate);s.setDate(s.getDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};
f.prototype._togglePrevNext=function(o,h){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return a.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getYear();var i=this._oMinDate.getYear();var m=this._oMaxDate.getMonth();var j=this._oMinDate.getMonth();var k=this._oMinDate.getDate();var n=this._oMaxDate.getDate();var H=this.getAggregation("header");var p=this._getDays();var r;var s;var E;var t;var u;if(this._iMode==1&&!h){var v=this.getAggregation("monthPicker");var w=v.getMonths();var S=v.getStartMonth();var x=S+w-1;r=o.getYear();if(S==0||(r==i&&S<=j)){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}if(x>10||(r==y&&x>=m)){H.setEnabledNext(false);}else{H.setEnabledNext(true);}return;}s=this._getStartDate();E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+p-1);if(C._isOutside(o,s,E)){s=new b(o,this.getPrimaryCalendarType());E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+p-1);}r=s.getYear();t=s.getMonth();u=s.getDate();if(r<i||(r==i&&(!h||t<j||(t==j&&u<=k)))){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}r=E.getYear();t=E.getMonth();u=E.getDate();if(r>y||(r==y&&(!h||t>m||(t==m&&u>=n)))){H.setEnabledNext(false);}else{H.setEnabledNext(true);}};
f.prototype._shiftStartFocusDates=function(s,F,i){s.setDate(s.getDate()+i);F.setDate(F.getDate()+i);this._setFocusedDate(F);this._setStartDate(s,true);};
f.prototype._handlePrevious=function(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,(i*-1));break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.previousPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()-1);var h=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(h){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.previousPage();this._togglePrevNexYearPicker();}break;}};
f.prototype._handleNext=function(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,i);break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.nextPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()+1);var h=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(h){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.nextPage();this._togglePrevNexYearPicker();}break;}};
f.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getMonth();var h=this._getDays();m.push(i);if(h>this._getDaysLarge()){var E=new b(o,this.getPrimaryCalendarType());E.setDate(E.getDate()+h-1);var j=E.getMonth();while(i!=j){i=(i+1)%12;m.push(i);}}return m;};
f.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=new b(this._getStartDate(),s);var h=S.getMonth();var E=new b(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+i-1);E=new b(E,s);var j=E.getMonth();return{start:h,end:j};};
f.prototype._openPickerPopup=function(p){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(function(){this._closeCalendarPicker(true);},this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var h=this.getAggregation("header");var i=sap.ui.core.Popup.Dock;this._oPopup.open(0,i.CenterTop,i.CenterTop,h,null,"flipfit",true);};
f.prototype._getMaxDateAlignedToMinDate=function(m,o){var n=new b(m,this.getPrimaryCalendarType());if(n.isBefore(o)){n=new b(o);n.setDate(n.getDate()+this._getDays()-1);}return n;};
f.prototype._getStartDateAlignedToMinAndMaxDate=function(m,o,s){var n=new b(s,this.getPrimaryCalendarType());if(n.isBefore(o)){n=new b(o,this.getPrimaryCalendarType());}else if(n.isAfter(m)){n=m;}return n;};
f.prototype._calculateStartDate=function(m,o,s){var n=new b(m,this.getPrimaryCalendarType());n.setDate(n.getDate()-this._getDays()+1);n=this._getMaxDateAlignedToMinDate(n,o);s=this._getStartDateAlignedToMinAndMaxDate(n,o,s);return s;};
f.prototype._setStartDate=function(s,S,n){s=this._calculateStartDate(this._oMaxDate,this._oMinDate,s);var o=s.toLocalJSDate();this.setProperty("startDate",o,true);this._oStartDate=s;var h=this.getAggregation("month")[0];h.setStartDate(o);this._updateHeader(s);if(S){var i=this._getFocusedDate().toLocalJSDate();if(!h.checkDateFocusable(i)){this._setFocusedDate(s);h.setDate(o);}else{h.setDate(i);}}if(!n){this.fireStartDateChange();}};
f.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();}return this._oStartDate;};
function _(E){var F=new b(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(F);}
function g(E){this._togglePrevNexYearPicker();}
return f;});
sap.ui.predefine('sap/ui/unified/CalendarDateIntervalRenderer',['sap/ui/core/Renderer','./CalendarRenderer'],function(R,C){"use strict";var a=R.extend(C);
a.renderCalContentOverlay=function(){};
a.renderCalContentAndArrowsOverlay=function(r,c,i){if(c.getPickerPopup()){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");}};
a.addAttributes=function(r,c){r.addClass("sapUiCalInt");r.addClass("sapUiCalDateInt");var d=c._getDays();if(d>c._getDaysLarge()){r.addClass("sapUiCalIntLarge");}if(d>c._iDaysMonthHead){r.addClass("sapUiCalIntHead");}};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarLegend',['sap/ui/core/Control','./library','sap/ui/Device','./CalendarLegendRenderer',"sap/base/Log","sap/ui/thirdparty/jquery"],function(C,l,D,a,L,q){"use strict";var b=l.CalendarDayType;var S=l.StandardCalendarLegendItem;
var c=C.extend("sap.ui.unified.CalendarLegend",{
metadata:{library:"sap.ui.unified",properties:{standardItems:{type:"string[]",group:"Misc",defaultValue:['Today','Selected','WorkingDay','NonWorkingDay']},columnWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'120px'}},aggregations:{items:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,singularName:"item"},_standardItems:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarLegend.designtime"},
constructor:function(i,s){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){s=i;}if(!s||(s&&!s.standardItems)){this._addStandardItems(this.getStandardItems());}}
});
c.prototype.setStandardItems=function(v){var i;if(v&&v.length===1&&v[0]===""){v=[];}if(v&&v.length){v=this.validateProperty("standardItems",v);for(i=0;i<v.length;i++){if(!S[v[i]]){throw new Error("Invalid value '"+v[i]+"'. Property standardItems must contain values from sap.ui.unified.StandardCalendarLegendItem.");}}}this.setProperty("standardItems",v);this._addStandardItems(this.getStandardItems(),true);return this;};
c.prototype._addStandardItems=function(s,r){var i,d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),I=this.getId();if(r){this.destroyAggregation("_standardItems");}for(i=0;i<s.length;i++){var o=new sap.ui.unified.CalendarLegendItem(I+"-"+s[i],{text:d.getText(c._Standard_Items_TextKeys[s[i]])});this.addAggregation("_standardItems",o);}};
c._Standard_Items_TextKeys={"Today":"LEGEND_TODAY","Selected":"LEGEND_SELECTED","WorkingDay":"LEGEND_NORMAL_DAY","NonWorkingDay":"LEGEND_NON_WORKING_DAY"};
c.prototype._getItemType=function(i,I){var t=i.getType(),n,f;if(t&&t!==b.None){return t;}f=this._getUnusedItemTypes(I);n=I.filter(function(d){return!d.getType()||d.getType()===b.None;}).indexOf(i);if(n<0){L.error('Legend item is not in the legend',this);return t;}if(f[n]){t=f[n];}else{t="Type"+(Object.keys(b).length+n-f.length-1);}return t;};
c.prototype._getItemByType=function(t){var I,d=this.getItems(),i;for(i=0;i<d.length;i++){if(this._getItemType(d[i],d)===t){I=d[i];break;}}return I;};
c.prototype._getUnusedItemTypes=function(I){var f=q.extend({},b),t,i;delete f[b.None];delete f[b.NonWorking];for(i=0;i<I.length;i++){t=I[i].getType();if(f[t]){delete f[t];}}return Object.keys(f);};
return c;});
sap.ui.predefine('sap/ui/unified/CalendarLegendItem',['sap/ui/core/Element','./library'],function(E,l){"use strict";var C=l.CalendarDayType;
var a=E.extend("sap.ui.unified.CalendarLegendItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:C.None},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
return a;});
sap.ui.predefine('sap/ui/unified/CalendarLegendRenderer',['sap/ui/core/InvisibleText'],function(I){"use strict";var C={};
C.render=function(r,l){var s=l.getAggregation("_standardItems"),c=l.getItems(),i,a,b;r.write("<div");r.writeControlData(l);r.addClass("sapUiUnifiedLegend");r.writeClasses();r.write(">");this.renderItemsHeader(r,l);if(s||c){r.write("<div");r.addClass("sapUiUnifiedLegendItems");r.writeClasses();b=l.getColumnWidth();r.writeAttribute("style","column-width:"+b+";-moz-column-width:"+b+";-webkit-column-width:"+b+";");r.writeStyles();r.write(">");if(s){a=l.getId().length+1;for(i=0;i<s.length;++i){var d="sapUiUnifiedLegend"+s[i].getId().slice(a);this.renderLegendItem(r,d,s[i],["sapUiUnifiedLegendSquareColor"]);}}if(c){for(i=0;i<c.length;i++){this.renderLegendItem(r,"sapUiCalLegDayType"+l._getItemType(c[i],c).slice(4),c[i],["sapUiUnifiedLegendSquareColor"]);}}r.write("</div>");}this.renderAdditionalContent(r,l);r.write("</div>");};
C.renderLegendItem=function(r,c,i,a){var t=i.getText();var T=i.getTooltip_AsString();r.write("<div");r.writeElementData(i);if(T){r.writeAttributeEscaped('title',T);}r.addClass("sapUiUnifiedLegendItem");r.addClass(c);r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiUnifiedLegendSquare");r.writeClasses();r.write(">");this.renderColor(r,i.getColor(),a);r.write("</div>");r.write("<div");r.writeAttribute("id",i.getId()+"-Text");r.addClass("sapUiUnifiedLegendDescription");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div></div>");};
C.renderItemsHeader=function(r,l){};
C.renderAdditionalContent=function(r,l){};
C.renderColor=function(r,c,a){r.write("<div");for(var i=0;i<a.length;i++){r.addClass(a[i]);}if(c){r.addStyle("background-color",c);r.writeStyles();}r.writeClasses();r.write("></div>");};
C.addCalendarTypeAccInfo=function(a,t,l){var T,s;if(l){var L=l._getItemByType(t);if(L){T=L.getText();}}if(T){a["label"]=a["label"]?a["label"]+"; "+T:T;}else{s=C.getTypeAriaText(t);if(s){a["describedby"]=a["describedby"]?a["describedby"]+" "+s.getId():s.getId();}}};
C.typeARIATexts={};
C.getTypeAriaText=function(t){var r,T;if(t.indexOf("Type")!==0){return;}if(!C.typeARIATexts[t]){r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");T=r.getText("LEGEND_UNNAMED_TYPE",parseInt(t.slice(4),10).toString());C.typeARIATexts[t]=new I({text:T});C.typeARIATexts[t].toStatic();}return C.typeARIATexts[t];};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarMonthInterval',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Renderer','sap/ui/core/format/DateFormat','./calendar/CalendarUtils','./calendar/Header','./calendar/MonthsRow','./calendar/YearPicker','./calendar/CalendarDate','./Calendar','./CalendarRenderer',"./CalendarMonthIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(D,C,L,a,R,b,c,H,M,Y,d,e,f,g,h,i,j,q){"use strict";
var k=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
k.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=b.getDateInstance({format:"y"});this._oMinDate=c._minDate();this._oMaxDate=c._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};
k.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};
k.prototype.onBeforeRendering=function(){var O=this.getAggregation("monthsRow");var P=this._getFocusedDate();r.call(this);O.displayDate(P.toLocalJSDate());};
k.prototype._initializeHeader=function(){var O=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});O.attachEvent("pressPrevious",this._handlePrevious,this);O.attachEvent("pressNext",this._handleNext,this);O.attachEvent("pressButton2",x,this);this.setAggregation("header",O);};
k.prototype._initializeMonthsRow=function(){var O=new M(this.getId()+"--MonthsRow");O.attachEvent("focus",A,this);O.attachEvent("select",z,this);O._bNoThemeChange=true;this.setAggregation("monthsRow",O);};
k.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};
k.prototype._createYearPicker=function(){var O=new Y(this.getId()+"--YP",{columns:0,years:6});O.attachEvent("select",E,this);O.attachEvent("pageChange",K,this);O._oMinDate.setYear(this._oMinDate.getYear());O._oMaxDate.setYear(this._oMaxDate.getYear());return O;};
k.prototype._getCalendarPicker=function(){var O=this.getAggregation("calendarPicker");if(!O){O=new N(this.getId()+"--Cal");O.setPopupMode(true);O.attachEvent("select",B,this);O.attachEvent("cancel",function(P){this._oPopup.close();var Q=this.getAggregation("header").getDomRef("B2");if(Q){Q.focus();}},this);this.setAggregation("calendarPicker",O);}return O;};
k.prototype.setStartDate=function(S){c._checkJSDateObject(S);if(i(this.getStartDate(),S)){return this;}var O=S.getFullYear();c._checkYearInValidRange(O);this.setProperty("startDate",S,true);this._oStartDate=d.fromLocalJSDate(S);this._oStartDate.setDate(1);var P=this.getAggregation("monthsRow");P.setStartDate(S);r.call(this);var Q=this._getFocusedDate().toLocalJSDate();if(!P.checkDateFocusable(Q)){this._setFocusedDate(this._oStartDate);P.displayDate(S);}return this;};
k.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(F.bind(this),0);}};
k.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("selectedDates");return O;};
k.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("selectedDates");return O;};
k.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("specialDates");return O;};
k.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("specialDates");return O;};
k.prototype.setLocale=function(O){if(this._sLocale!=O){this._sLocale=O;this._oLocaleData=undefined;this.invalidate();}return this;};
k.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
k.prototype._getFocusedDate=function(){if(!this._oFocusedDate){n.call(this);}return this._oFocusedDate;};
k.prototype._setFocusedDate=function(O){c._checkCalendarDate(O);this._oFocusedDate=new d(O);};
k.prototype.focusDate=function(O){var P=false;var Q=this.getAggregation("monthsRow");if(O&&!Q.checkDateFocusable(O)){G.call(this,d.fromLocalJSDate(O));P=true;}w.call(this,O,false);if(P){this.fireStartDateChange();}return this;};
k.prototype.displayDate=function(O){w.call(this,O,true);return this;};
k.prototype.setMonths=function(O){this.setProperty("months",O,true);O=this._getMonths();var P=this.getAggregation("monthsRow");P.setMonths(O);if(!P.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=l.call(this);this._setFocusedDate(this._oStartDate);P.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var Q=this.getAggregation("yearPicker");var T=Math.floor(O/2);if(T>20){T=20;}Q.setYears(T);}r.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
k.prototype._getMonths=function(){var O=this.getMonths();if(D.system.phone&&O>6){return 6;}else{return O;}};
k.prototype._getLocaleData=function(){if(!this._oLocaleData){var O=this.getLocale();var P=new L(O);this._oLocaleData=a.getInstance(P);}return this._oLocaleData;};
k.prototype.setPickerPopup=function(P){var O;this.setProperty("pickerPopup",P,true);if(P){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}O=this.getAggregation("yearPicker");O.setColumns(0);O.setYears(6);}return this;};
k.prototype.setMinDate=function(O){if(i(O,this.getMinDate())){return this;}if(!O){this._oMinDate=c._minDate();}else{c._checkJSDateObject(O);this._oMinDate=d.fromLocalJSDate(O);this._oMinDate.setDate(1);var P=this._oMinDate.getYear();c._checkYearInValidRange(P);if(this._oMaxDate.isBefore(this._oMinDate)){j.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=d.fromLocalJSDate(O);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){j.warning("focused date < minDate -> minDate focused",this);this.focusDate(O);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){j.warning("start date < minDate -> minDate set as start date",this);_.call(this,new d(this._oMinDate),true,true);}}this.setProperty("minDate",O,false);if(this.getPickerPopup()){var Q=this._getCalendarPicker();Q.setMinDate(O);}else{var S=this.getAggregation("yearPicker");S._oMinDate.setYear(this._oMinDate.getYear());}return this;};
k.prototype.setMaxDate=function(O){if(i(O,this.getMaxDate())){return this;}if(!O){this._oMaxDate=c._maxDate();}else{c._checkJSDateObject(O);this._oMaxDate=d.fromLocalJSDate(O);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));var P=this._oMaxDate.getYear();c._checkYearInValidRange(P);if(this._oMinDate.isAfter(this._oMaxDate)){j.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=d.fromLocalJSDate(O);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){j.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(O);}}if(this._oStartDate){var Q=new d(this._oStartDate);Q.setDate(1);Q.setMonth(Q.getMonth()+this._getMonths());Q.setDate(0);if(Q.isAfter(this._oMaxDate)){var S=new d(this._oMaxDate);S.setDate(1);S.setMonth(S.getMonth()-this._getMonths()+1);if(S.isSameOrAfter(this._oMinDate)){j.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,S,true,true);}}}}this.setProperty("maxDate",O,false);if(this.getPickerPopup()){var T=this._getCalendarPicker();T.setMaxDate(O);}else{var U=this.getAggregation("yearPicker");U._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};
k.prototype.onclick=function(O){if(O.isMarked("delayedMouseEvent")){return;}if(O.target.id==this.getId()+"-cancel"){this.onsapescape(O);}};
k.prototype.onmousedown=function(O){O.preventDefault();O.setMark("cancelAutoClose");};
k.prototype.onsapescape=function(O){if(this.getPickerPopup()){y.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:p.call(this);break;}}};
k.prototype.onsaptabnext=function(O){var P=this.getAggregation("header"),Q,S;if(h(this.getDomRef("content"),O.target)){if(P.getDomRef("B2")){P.getDomRef("B2").focus();}if(!this._bPoupupMode){S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");if(Q.getDomRef()){q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}O.preventDefault();}};
k.prototype.onsaptabprevious=function(O){var P=this.getAggregation("header"),Q,S;if(h(this.getDomRef("content"),O.target)){if(this._bPoupupMode){if(P.getDomRef("B2")){P.getDomRef("B2").focus();}O.preventDefault();}}else if(O.target.id==P.getId()+"-B2"){switch(this._iMode){case 0:Q=this.getAggregation("monthsRow");Q._oItemNavigation.focusItem(Q._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");S._oItemNavigation.focusItem(S._oItemNavigation.getFocusedIndex());}break;}O.preventDefault();}};
k.prototype.onfocusin=function(O){if(O.target.id==this.getId()+"-end"){var P=this.getAggregation("header"),Q,S;if(P.getDomRef("B2")){P.getDomRef("B2").focus();}if(!this._bPoupupMode){Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");if(S.getDomRef()){q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
k.prototype.onsapfocusleave=function(O){var P,Q;if(!O.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(O.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:P=this.getAggregation("monthsRow");q(P._oItemNavigation.getItemDomRefs()[P._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
k.prototype._handlePrevious=function(O){var P,Q,S,T;switch(this._iMode){case 0:P=this._getFocusedDate();Q=this._getMonths();S=new d(l.call(this));S.setMonth(S.getMonth()-Q);P.setMonth(P.getMonth()-Q);this._setFocusedDate(P);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");T.previousPage();t.call(this);}break;}};
k.prototype._handleNext=function(O){var P,Q,S,T;switch(this._iMode){case 0:P=this._getFocusedDate();Q=this._getMonths();S=new d(l.call(this));S.setMonth(S.getMonth()+Q);P.setMonth(P.getMonth()+Q);this._setFocusedDate(P);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");T.nextPage();t.call(this);}break;}};
k.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
k.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
k.prototype._getShowItemHeader=function(){var O=this.getMonths();if(O>this._iDaysMonthsHead){return true;}else{return false;}};
function _(S,O,P){var Q=new d(this._oMaxDate);Q.setDate(1);Q.setMonth(Q.getMonth()-this._getMonths()+1);if(Q.isBefore(this._oMinDate)){Q=new d(this._oMinDate);Q.setMonth(Q.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new d(this._oMinDate);}else if(S.isAfter(Q)){S=Q;}S.setDate(1);var T=S.toLocalJSDate();this.setProperty("startDate",T,true);this._oStartDate=S;var U=this.getAggregation("monthsRow");U.setStartDate(T);r.call(this);if(O){var V=this._getFocusedDate().toLocalJSDate();if(!U.checkDateFocusable(V)){this._setFocusedDate(S);U.setDate(T);}else{U.setDate(V);}}if(!P){this.fireStartDateChange();}}
function l(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}
function m(O){var P=this._getFocusedDate();var Q=this.getAggregation("monthsRow");if(!O){Q.setDate(P.toLocalJSDate());}else{Q.displayDate(P.toLocalJSDate());}r.call(this);}
function n(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=d.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new d();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new d(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new d(this._oMaxDate);}}
function o(){var O=this._getFocusedDate();var P=this.getAggregation("yearPicker");if(P.getDomRef()){P.$().css("display","");}else{var Q=sap.ui.getCore().createRenderManager();var $=this.$("content");Q.renderControl(P);Q.flush($[0],false,true);Q.destroy();}this._showOverlay();P.setDate(O.toLocalJSDate());if(this._iMode==0){var S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}t.call(this);this._iMode=1;}
function p(O){this._iMode=0;var P=this.getAggregation("yearPicker");P.$().css("display","none");this._hideOverlay();if(!O){m.call(this);var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function r(){u.call(this);s.call(this);}
function s(){var O=new d(l.call(this));var P=this._getMonths();var Q=O.getYear();var S=this._oMaxDate.getYear();var T=this._oMinDate.getYear();var U=O.getMonth();var V=this._oMaxDate.getMonth();var W=this._oMinDate.getMonth();var X=this.getAggregation("header");if(Q<T||(Q==T&&U<=W)){X.setEnabledPrevious(false);}else{X.setEnabledPrevious(true);}O.setMonth(O.getMonth()+P-1);Q=O.getYear();U=O.getMonth();if(Q>S||(Q==S&&U>=V)){X.setEnabledNext(false);}else{X.setEnabledNext(true);}}
function t(){var O=this.getAggregation("yearPicker");var P=O.getYears();var Q=d.fromLocalJSDate(O.getFirstRenderedDate());Q.setYear(Q.getYear()+Math.floor(P/2));var S=this.getAggregation("header");var T=new d(this._oMaxDate);T.setYear(T.getYear()-Math.ceil(P/2));T.setMonth(11,31);var U=new d(this._oMinDate);U.setYear(U.getYear()+Math.floor(P/2)+1);U.setMonth(0,1);S.setEnabledNext(!Q.isAfter(T));S.setEnabledPrevious(!Q.isBefore(U));}
function u(){var T;var S=l.call(this);var O=this._oYearFormat.format(S.toUTCJSDate(),true);var P=new d(S);P.setMonth(P.getMonth()+this._getMonths()-1);var Q=this._oYearFormat.format(P.toUTCJSDate(),true);if(O!=Q){var U=this._getLocaleData();var V=U.getIntervalPattern();T=V.replace(/\{0\}/,O).replace(/\{1\}/,Q);}else{T=O;}var W=this.getAggregation("header");W.setTextButton2(T);}
function v(O,P){var Q;var S=false;if(O.isBefore(this._oMinDate)){Q=this._oMinDate;S=true;}else if(O.isAfter(this._oMaxDate)){Q=this._oMaxDate;S=true;}else{Q=O;}this._setFocusedDate(Q);if(S||P){G.call(this,Q);m.call(this,false);this.fireStartDateChange();}}
function w(O,S){if(!O){return;}var P=d.fromLocalJSDate(O);if(this._oFocusedDate&&this._oFocusedDate.isSame(P)){return;}var Q=P.getYear();c._checkYearInValidRange(Q);if(c._isOutside(P,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(P);if(this.getDomRef()&&this._iMode==0){m.call(this,S);}}
function x(O){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){o.call(this);}else{p.call(this);}}}
k.prototype._showCalendarPicker=function(){var O=this._getFocusedDate(true).toLocalJSDate();var P=this._getCalendarPicker();var S=new sap.ui.unified.DateRange({startDate:O});P.displayDate(O,false);P.removeAllSelectedDates();P.addSelectedDate(S);P.setMinDate(this.getMinDate());P.setMaxDate(this.getMaxDate());I.call(this,P);this._showOverlay();};
function y(O){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!O){m.call(this);var P=this.getAggregation("monthsRow");q(P._oItemNavigation.getItemDomRefs()[P._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function z(O){this.fireSelect();}
function A(O){var P=d.fromLocalJSDate(O.getParameter("date"));var Q=O.getParameter("notVisible");v.call(this,P,Q);}
function B(O){var P=new d(this._getFocusedDate());var Q=this._getCalendarPicker();var S=Q.getSelectedDates()[0].getStartDate();var T=d.fromLocalJSDate(S);T.setMonth(P.getMonth());T.setDate(P.getDate());v.call(this,T,true);y.call(this);}
function E(O){var P=new d(this._getFocusedDate());var Q=this.getAggregation("yearPicker");var S=d.fromLocalJSDate(Q.getDate());S.setMonth(P.getMonth());S.setDate(P.getDate());P=S;v.call(this,P,true);p.call(this);}
function F(){this._sInvalidateContent=undefined;var O=this.getAggregation("monthsRow");O._bDateRangeChanged=true;O._bInvalidateSync=true;O.invalidate();O._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}
function G(O){var P=this.getAggregation("monthsRow");var S=l.call(this);var Q=P._oItemNavigation.getFocusedIndex();S=new d(O);S.setMonth(S.getMonth()-Q);_.call(this,S,false,true);}
function I(P){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(J,this);this._oPopup.onsapescape=function(S){this._oCalendar.onsapescape(S);};}this._oPopup.setContent(P);var O=this.getAggregation("header");var Q=sap.ui.core.Popup.Dock;this._oPopup.open(0,Q.CenterTop,Q.CenterTop,O,null,"flipfit",true);}
function J(O){y.call(this);}
function K(O){t.call(this);}
var N=e.extend("CustomYearPicker",{renderer:R.extend(f)});
N.prototype._initializeHeader=function(){var O=new H(this.getId()+"--Head",{visibleButton1:false});O.attachEvent("pressPrevious",this._handlePrevious,this);O.attachEvent("pressNext",this._handleNext,this);O.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",O);};
N.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);var O=this.getAggregation("header");O.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");this._showYearPicker();};
N.prototype.onThemeChanged=function(){e.prototype.onThemeChanged.apply(this,arguments);var O=this.getAggregation("header");O.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");};
N.prototype._selectYear=function(){var O=this.getAggregation("yearPicker");var P=this.getSelectedDates()[0];if(!P){P=new sap.ui.unified.DateRange();}P.setStartDate(O.getDate());this.addSelectedDate(P);this.fireSelect();};
N.prototype.onsapescape=function(O){this.fireCancel();};
N.prototype._shouldFocusB2OnTabPrevious=function(O){return false;};
return k;});
sap.ui.predefine('sap/ui/unified/CalendarMonthIntervalRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var i=c.getId();var t=c.getTooltip_AsString();var m=c.getAggregation("monthsRow");r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");r.addClass("sapUiCalInt");r.addClass("sapUiCalMonthInt");if(c._getShowItemHeader()){r.addClass("sapUiCalIntHead");}r.writeAttribute("tabindex","-1");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}var w=c.getWidth();if(w&&w!=''){r.addStyle("width",w);r.writeStyles();}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+i+"-content\" class=\"sapUiCalContent\">");r.renderControl(m);r.write("</div>");r.write("<button id=\""+i+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+i+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");if(c.getPickerPopup()){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarOneMonthInterval',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarDateIntervalRenderer','sap/ui/unified/calendar/OneMonthDatesRow','sap/ui/core/Renderer','sap/ui/unified/Calendar','sap/ui/unified/CalendarRenderer',"./CalendarOneMonthIntervalRenderer","sap/ui/dom/containsOrEquals"],function(C,a,l,b,c,O,R,d,e,f,g){"use strict";
var h=b.extend("sap.ui.unified.CalendarOneMonthInterval",{});
h.prototype.init=function(){b.prototype.init.apply(this,arguments);this._bShowOneMonth=true;};
h.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new i(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",function(){var o=this._getCalendarPicker(),j=o._getFocusedDate(),n=C._getFirstDateOfMonth(j);this._setStartDate(n);this._adjustSelectedDate(n,false);this._oFocusDateOneMonth=n;this._closeCalendarPicker(true);this._focusDate(j,false,true);},this);o.attachEvent("cancel",function(E){var o=this._getCalendarPicker(),j=o._getFocusedDate();this._closeCalendarPicker(true);this._oFocusDateOneMonth=j;this._focusDate(j,true);var D=this.getAggregation("header").getDomRef("B1");if(D){D.focus();}},this);this.setAggregation("calendarPicker",o);}return o;};
h.prototype._createMonth=function(I){return new O(I);};
h.prototype._handleFocus=function(E){var o=!!E.getParameter("_outsideBorder"),D=E.getParameter("date"),j=a.fromLocalJSDate(D),k=a.fromLocalJSDate(this.getStartDate()),I=!C._isSameMonthAndYear(j,k),m,F,s;if(o||I){if(C._isLastDateInMonth(j)){this._oFocusDateOneMonth=j;}else{this._oFocusDateOneMonth=C._getFirstDateOfMonth(j);}m=j.isBefore(k)?-1:1;F=new a(this._getFocusedDate(),this.getPrimaryCalendarType());s=new a(this._getStartDate(),this.getPrimaryCalendarType());b.prototype._shiftStartFocusDates.call(this,F,s,m);}return b.prototype._handleFocus.apply(this,arguments);};
h.prototype._focusDateExtend=function(D,o,n){var j,L;if(!this._oFocusDateOneMonth){return b.prototype._focusDateExtend.apply(this,arguments);}j=this.getAggregation("month")[0];L=this._oFocusDateOneMonth.toLocalJSDate();this._setFocusedDate(this._oFocusDateOneMonth);j._bNoRangeCheck=true;j.setDate(L);j._bNoRangeCheck=false;this._oFocusDateOneMonth=null;return!n;};
h.prototype._setDisplayMode=function(m){this.getAggregation("month")[0].setMode(m);};
h.prototype._shiftStartFocusDates=function(s,F,D){var S=D,o=this.getAggregation("month")[0];if(S!==0){S=S>0?1:-1;}s.setMonth(s.getMonth()+S);F.setYear(s.getYear());F.setMonth(s.getMonth());F.setDate(s.getDate());this._setFocusedDate(F);this._setStartDate(s,true);o.selectDate(s.toLocalJSDate());};
h.prototype._adjustSelectedDate=function(D,u){var m=this.getAggregation("month")[0],s;s=u?C._getFirstDateOfMonth(D):D;if(m.getMode&&m.getMode()<2){this._selectDate(s);}};
h.prototype._selectDate=function(D){var m=this.getAggregation("month")[0],L=D.toLocalJSDate();this.removeAllSelectedDates();this.addSelectedDate(new sap.ui.unified.DateRange({startDate:L}));m.selectDate(L);this._bDateRangeChanged=undefined;};
h.prototype._dateMatchesVisibleRange=function(D){return C._isSameMonthAndYear(a.fromLocalJSDate(this.getStartDate()),a.fromLocalJSDate(D));};
var i=d.extend("CustomMonthPicker",{renderer:R.extend(e)});
i.prototype._initializeHeader=function(){var H=new sap.ui.unified.calendar.Header(this.getId()+"--Head",{visibleButton1:false});H.attachEvent("pressPrevious",this._handlePrevious,this);H.attachEvent("pressNext",this._handleNext,this);H.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",H);};
i.prototype._shouldFocusB2OnTabNext=function(E){return g(this.getDomRef("content"),E.target);};
i.prototype.onAfterRendering=function(){this._showMonthPicker();};
i.prototype._selectYear=function(){var y=this.getAggregation("yearPicker");var F=this._getFocusedDate();F.setYear(y.getYear());this._focusDate(F,true);this._showMonthPicker();};
i.prototype._selectMonth=function(){var m=this.getAggregation("monthPicker");var s=this.getSelectedDates()[0];var F=this._getFocusedDate();F.setMonth(m.getMonth());if(!s){s=new sap.ui.unified.DateRange();}s.setStartDate(F.toLocalJSDate());this.addSelectedDate(s);this.fireSelect();};
i.prototype.onsapescape=function(E){this.fireCancel();};
return h;});
sap.ui.predefine('sap/ui/unified/CalendarOneMonthIntervalRenderer',['sap/ui/core/Renderer','./CalendarDateIntervalRenderer'],function(R,C){"use strict";var a=R.extend(C);
a.addAttributes=function(r,c){C.addAttributes.apply(this,arguments);r.addClass("sapUiCalOneMonthInt");};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var I=c.getId();var t=c.getTooltip_AsString();var m=c.getAggregation("month");var w=c.getWidth();r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");if(m.length>1){r.addClass("sapUiCalMulti");}r.writeAttribute("tabindex","-1");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}if(w){r.addClass("sapUiCalWidth");r.addStyle("width",w);r.writeStyles();}if(c._getSecondaryCalendarType()){r.addClass("sapUiCalSecType");}if(this.addAttributes){this.addAttributes(r,c);}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);var M=m.length;r.write("<div id=\""+I+"-content\" class=\"sapUiCalContent\">");for(var i=0;i<M;i++){var o=m[i];r.renderControl(o);if(M===2&&i===0){r.renderControl(c.getAggregation("secondMonthHeader"));}}this.renderCalContentOverlay(r,c,I);if(!c._bNamesLengthChecked){var b=c.getAggregation("monthPicker");r.renderControl(b);}r.write("</div>");r.write("<button id=\""+I+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+I+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");this.renderCalContentAndArrowsOverlay(r,c,I);r.write("</div>");};
C.renderCalContentOverlay=function(r,c,i){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");};
C.renderCalContentAndArrowsOverlay=function(r,c,i){};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarRow',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(C,D,L,a,U,l,I,b,R,c,d,e,q){"use strict";var f=l.CalendarDayType;var g=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var h=l.CalendarIntervalType;
var m=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:h.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:g.Standard}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});
m.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined;};
m.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._fnCustomSortedAppointments=undefined;};
m.prototype.onBeforeRendering=function(){o.call(this);s.call(this);w.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};
m.prototype.onAfterRendering=function(){x.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};
m.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};
m.prototype.invalidate=function(O){if(O&&O instanceof sap.ui.unified.CalendarAppointment){var j=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==O){j=true;break;}}if(j){this._aVisibleAppointments=[];}}C.prototype.invalidate.apply(this,arguments);};
m.prototype.setStartDate=function(S){if(!S){S=new Date();}a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};
m.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};
m.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};
m.prototype.setGroupAppointmentsMode=function(i){this.setProperty("groupAppointmentsMode",i);this._aVisibleAppointments=[];return this;};
m.prototype.setAppointmentsReducedHeight=function(i){this.setProperty("appointmentsReducedHeight",i);this._aVisibleAppointments=[];return this;};
m.prototype._getAppointmentReducedHeight=function(i){var j=false;if(!D.system.phone&&this.getAppointmentsReducedHeight()&&!i.getText()){j=true;}return j;};
m.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){F.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var k=false;var N;for(var i=0;i<V.length;i++){N=V[i].appointment;if(e(N.getDomRef(),j.target)){k=true;N.focus();break;}}if(!k){N=this.getFocusedAppointment();if(N){N.focus();}}}};
m.prototype.applyFocusInfo=function(i){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};
m.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){H.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};
m.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){H.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};
m.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};
m.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};
m.prototype.onsaphome=function(i){J.call(this,i);i.preventDefault();i.stopPropagation();};
m.prototype.onsapend=function(i){J.call(this,i);i.preventDefault();i.stopPropagation();};
m.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(e(k.getDomRef(),j.target)){y.call(this,k,!j.ctrlKey);break;}}j.stopPropagation();j.preventDefault();};
m.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var N=false;for(k=0;k<j.length;k++){var O=j[k];if(!this._isOneMonthIntervalOnSmallSizes()&&e(O,i.target)){N=true;break;}}if(N){K.call(this,k,i.target);}else{this.onsapselect(i);}};
m.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};
m.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");x.call(this);return this;};
m.prototype.updateCurrentTimeVisualization=function(){var N=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var S=this._getStartDate();var O=S.getTime();var P=this._oUTCEndDate;var Q=P.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=Q&&i.getTime()>=O){var T=u.call(this,k,j,S,P,O,i);var V=0;if(this._bRTL){N.css("right",T+"%");}else{N.css("left",T+"%");}N.css("display","");if(this.getUpdateCurrentTime()){switch(k){case h.Hour:V=60000;break;case h.Day:case h.Week:case h.OneMonth:V=1800000;break;default:V=-1;break;}if(V>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),V);}}}else{N.css("display","none");}return this;};
m.prototype.getFocusedAppointment=function(){var j=this._getAppointmentsSorted();var k=this.getAggregation("groupAppointments",[]);var N;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){N=k[i];break;}}if(!N){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){N=j[i];break;}}}return N;};
m.prototype.focusAppointment=function(i){if(!i||!(i instanceof sap.ui.unified.CalendarAppointment)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){F.call(this,j);}else{i.focus();}return this;};
m.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=this._getAppointmentsSorted();var N;var P;var O;for(var i=0;i<k.length;i++){N=k[i];if(N.getStartDate()>j){if(i>0){P=k[i-1];}else{P=N;}break;}}if(N){if(P&&Math.abs(N.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){O=P;}else{O=N;}this.focusAppointment(O);}return this;};
m.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};
m.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};
m.prototype._getNonWorkingDays=function(){var N=this.getNonWorkingDays();if(!N){var j=n.call(this);var W=j.getWeekendStart();var k=j.getWeekendEnd();N=[];for(var i=0;i<=6;i++){if((W<=k&&i>=W&&i<=k)||(W>k&&(i>=W||i<=k))){N.push(i);}}}else if(!Array.isArray(N)){N=[];}return N;};
m.prototype._isOneMonthIntervalOnSmallSizes=function(){return this.getIntervalType()===h.OneMonth&&this.getIntervals()===1;};
m.prototype._getAppointmentsSorted=function(){var i=this.getAppointments(),j=M;i.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:j);return i;};
m.prototype._setCustomAppointmentsSorterCallback=function(S){this._fnCustomSortedAppointments=S;this.invalidate();};
function _(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}
function n(){if(!this._oLocaleData){var i=_.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}
function o(){var S=this.getStartDate();var i;var j=this.getIntervals();var k=this.getIntervalType();this._oUTCStartDate=p.call(this,S);switch(k){case h.Hour:i=new U(this._oUTCStartDate.getTime());i.setUTCHours(i.getUTCHours()+j);this._iMinDelta=this._iHoursMinDelta;break;case h.Day:case h.Week:case h.OneMonth:i=new U(this._oUTCStartDate.getTime());i.setUTCDate(i.getUTCDate()+j);this._iMinDelta=this._iDaysMinDelta;break;case h.Month:i=new U(this._oUTCStartDate.getTime());i.setUTCMonth(i.getUTCMonth()+j);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}i.setUTCMilliseconds(-1);this._iRowSize=i.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/j);this._oUTCEndDate=i;}
function p(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case h.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case h.Day:case h.Week:case h.OneMonth:k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case h.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}
function r(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}
function s(){var N=this._getAppointmentsSorted();var O;var P;var Q;var S=this.getIntervals();var T=this.getIntervalType();var V=this._getStartDate();var W=V.getTime();var X=this._oUTCEndDate;var Y=X.getTime();var Z=[];var $=false;var i=0;var j=0;var a1=r.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<N.length;i++){O=N[i];var b1=a._createUniversalUTCDate(O.getStartDate(),undefined,true);b1.setUTCSeconds(0);b1.setUTCMilliseconds(0);var c1=O.getEndDate()?a._createUniversalUTCDate(O.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);c1.setUTCSeconds(0);c1.setUTCMilliseconds(0);var d1=false;if(b1.getTime()<W&&c1.getTime()>=W){b1=new U(W);d1=true;}if(c1.getTime()>Y&&b1.getTime()<=Y){c1=new U(Y);d1=true;}var e1=b1.getUTCHours()*60+b1.getUTCMinutes();b1.setUTCMinutes(b1.getUTCMinutes()-(e1%this._iMinDelta));var f1=(c1.getTime()-b1.getTime())/60000;if(d1&&f1==0){continue;}var g1=0;var h1=0;var i1=-1;P=undefined;Q=undefined;if(b1&&b1.getTime()<=Y&&c1&&c1.getTime()>=W){if(a1&&(T==h.Month)&&((c1.getTime()-b1.getTime())<604800000)){P=t.call(this,b1,O,T,S,V,X,W,Z);var j1=a._createUniversalUTCDate(P.getEndDate(),undefined,true);if(c1.getTime()>j1.getTime()){Q=t.call(this,c1,O,T,S,V,X,W,Z);}}g1=u.call(this,T,S,V,X,W,b1);h1=v.call(this,T,S,V,X,W,c1);if(P){P._iBegin=g1;P._iEnd=h1;P._iLevel=i1;if(Q){Q._iBegin=g1;Q._iEnd=h1;Q._iLevel=i1;}continue;}Z.push({appointment:O,begin:g1,end:h1,calculatedEnd:h1,level:i1});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==O.getId()){$=true;}}}var k1=this.getAggregation("groupAppointments",[]);if(k1.length>0){for(i=0;i<Z.length;i++){O=Z[i];if(O.appointment._aAppointments&&O.appointment._aAppointments.length<=1){P=O.appointment;var l1=false;if(P._aAppointments.length==0){l1=true;}else{for(j=0;j<Z.length;j++){if(Z[j].appointment==P._aAppointments[0]){l1=true;break;}}}if(!l1){for(j=0;j<k1.length;j++){Q=k1[j];if(P!=Q){for(var k=0;k<Q._aAppointments.length;k++){if(P._aAppointments[0]==Q._aAppointments[k]){Q._aAppointments.splice(k,1);if(Q._aAppointments.length==1){this.removeAggregation("groupAppointments",Q);Q.destroy();k1=this.getAggregation("groupAppointments",[]);}else{Q.setProperty("title",Q._aAppointments.length,true);}break;}}}}O.begin=P._iBegin;O.end=P._iEnd;O.calculatedEnd=P._iEnd;O.level=P._iLevel;O.appointment=P._aAppointments[0];}else{Z.splice(i,1);i--;}this.removeAggregation("groupAppointments",P);P.destroy();k1=this.getAggregation("groupAppointments",[]);}}}if(!$){if(Z.length>0){this._sFocusedAppointmentId=Z[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=Z;return this._aVisibleAppointments;}
function t(i,k,N,O,S,P,Q,V){var T=this.getAggregation("groupAppointments",[]);var W;var X=n.call(this);var Y=X.getFirstDayOfWeek();var Z=i.getUTCDay();var $=new U(i.getTime());$.setUTCHours(0);$.setUTCMinutes(0);$.setUTCSeconds(0);$.setUTCMilliseconds(0);if(Y<=Z){$.setDate($.getDate()-(Z-Y));}else{$.setDate($.getDate()-(7-Z-Y));}for(var j=0;j<T.length;j++){W=T[j];var a1=a._createUniversalUTCDate(W.getStartDate(),undefined,true);if(a1.getTime()==$.getTime()){break;}W=undefined;}if(!W){var b1=new U($.getTime());b1.setDate(b1.getDate()+7);b1.setMilliseconds(-1);W=new sap.ui.unified.CalendarAppointment(this.getId()+"-Group"+T.length,{type:k.getType(),startDate:a._createLocalDate(new Date($.getTime()),true),endDate:a._createLocalDate(new Date(b1.getTime()),true)});W._aAppointments=[];this.addAggregation("groupAppointments",W,true);var c1=u.call(this,N,O,S,P,Q,$);var d1=v.call(this,N,O,S,P,Q,b1);V.push({appointment:W,begin:c1,end:d1,calculatedEnd:d1,level:-1});}W._aAppointments.push(k);if(W.getType()!=f.None&&W.getType()!=k.getType()){W.setType(f.None);}W.setProperty("title",W._aAppointments.length,true);return W;}
function u(i,j,S,k,N,O){var P=0;if(i!=h.Month){P=100*(O.getTime()-N)/this._iRowSize;}else{var Q=new U(O.getTime());Q.setUTCDate(1);Q.setUTCHours(0);Q.setUTCMinutes(0);Q.setUTCSeconds(0);Q.setUTCMilliseconds(0);var T=new U(Q.getTime());T.setUTCMonth(T.getUTCMonth()+1);T.setMilliseconds(-1);var V=T.getTime()-Q.getTime();var W=(Q.getUTCFullYear()-S.getUTCFullYear())*12+Q.getUTCMonth()-S.getUTCMonth();P=(100*W/j)+(100*(O.getTime()-Q.getTime())/V)/j;}if(P<0){P=0;}P=Math.round(P*100000)/100000;return P;}
function v(i,j,S,k,N,O){var P=0;if(i!=h.Month){P=100-(100*(O.getTime()-N)/this._iRowSize);}else{var Q=new U(O.getTime());Q.setUTCDate(1);Q.setUTCHours(0);Q.setUTCMinutes(0);Q.setUTCSeconds(0);Q.setUTCMilliseconds(0);var T=new U(Q.getTime());T.setUTCMonth(T.getUTCMonth()+1);T.setMilliseconds(-1);var V=T.getTime()-Q.getTime();var W=(Q.getUTCFullYear()-S.getUTCFullYear())*12+Q.getUTCMonth()-S.getUTCMonth();P=100-((100*W/j)+(100*(O.getTime()-Q.getTime())/V)/j);}if(P<0){P=0;}P=Math.round(P*100000)/100000;return P;}
function w(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var N;var O=this.getIntervals();var P=this.getIntervalType();var S=this._getStartDate();var Q=S.getTime();var T=this._oUTCEndDate;var W=T.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){N=k[i];var X=a._createUniversalUTCDate(N.getStartDate(),undefined,true);X.setUTCSeconds(0);X.setUTCMilliseconds(0);var Y=N.getEndDate()?a._createUniversalUTCDate(N.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);Y.setUTCSeconds(0);Y.setUTCMilliseconds(0);if(X&&X.getTime()<=W&&Y&&Y.getTime()>=Q){var Z=new U(S.getTime());var $=new U(S.getTime());$.setUTCMinutes($.getUTCMinutes()-1);var a1=-1;var b1=-1;for(j=0;j<O;j++){switch(P){case h.Hour:$.setUTCHours($.getUTCHours()+1);if(j>0){Z.setUTCHours(Z.getUTCHours()+1);}break;case h.Day:case h.Week:case h.OneMonth:$.setUTCDate($.getUTCDate()+1);if(j>0){Z.setUTCDate(Z.getUTCDate()+1);}break;case h.Month:$.setUTCDate(1);$.setUTCMonth($.getUTCMonth()+2);$.setUTCDate(0);if(j>0){Z.setUTCMonth(Z.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+P+"; "+this);}if(X&&X.getTime()<=Z.getTime()&&Y&&Y.getTime()>=$.getTime()){if(a1<0){a1=j;}b1=j;}}if(a1>=0){V.push({interval:a1,appointment:N,last:b1});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}
function x(){if(this._isOneMonthIntervalOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var N=this.$("DummyApp");var O=N.outerHeight(true);if(O<=0){return;}var P=N.outerWidth();var Q=P/k*100;var S=Math.ceil(1000*Q)/1000;var T;var V;var W=0;var X=0;var i=0;var Y=!D.system.phone&&this.getAppointmentsReducedHeight();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){W=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){T=this._aVisibleAppointments[i];V=T.appointment.$();var Z=Math.floor(1000*(100-T.calculatedEnd-T.begin))/1000;var a1=false;if(Z<S){T.end=100-T.begin-Q;if(T.end<0){T.end=0;}T.level=-1;a1=true;V.addClass("sapUiCalendarAppSmall");}else if(V.hasClass("sapUiCalendarAppSmall")){T.end=T.calculatedEnd;a1=true;V.removeClass("sapUiCalendarAppSmall");}if(a1){if(this._bRTL){V.css("left",T.end+"%");}else{V.css("right",T.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){T=this._aVisibleAppointments[i];V=T.appointment.$();var b1={};var c1=Y&&!this._getAppointmentReducedHeight(T.appointment);if(T.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var d1=this._aVisibleAppointments[j];if(T!=d1&&T.begin<(Math.floor(1000*(100-d1.end))/1000)&&(Math.floor(1000*(100-T.end))/1000)>d1.begin&&d1.level>=0){if(b1[d1.level]){b1[d1.level]++;}else{b1[d1.level]=1;}if(Y&&!this._getAppointmentReducedHeight(d1.appointment)){if(b1[d1.level+1]){b1[d1.level+1]++;}else{b1[d1.level+1]=1;}}}}T.level=0;while(b1[T.level]||(c1&&b1[T.level+1])){T.level++;}V.attr("data-sap-level",T.level);}V.css("top",(O*T.level+W)+"px");var e1=T.level;if(c1){e1++;}if(X<e1){X=e1;}}X++;O=O*X+W;if(!this.getHeight()){$.outerHeight(O);}else{var f1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<f1.length;i++){var g1=q(f1[i]);g1.outerHeight(O);}}N.css("display","none");}
function y(j,k){var i=0;var O;var N;var P;var Q;var S=I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");if(k){var T=this.getAppointments();var V=this.getAggregation("groupAppointments",[]);q.merge(T,V);for(i=0;i<T.length;i++){O=T[i];if(O.getId()!==j.getId()&&O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==O.getId()){this.aSelectedAppointments.splice(i);}}N=O.$().attr("aria-labelledby");P=N?N.replace(S,""):"";O.$().attr("aria-labelledby",P);}}}if(j.getSelected()){j.setProperty("selected",false,true);j.$().removeClass("sapUiCalendarAppSel");this.aSelectedAppointments=this.aSelectedAppointments.filter(function(W){return W!==j.getId();});B(this,k);}else{j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");B(this,k);this.aSelectedAppointments.push(j.getId());}Q=j.$().attr("aria-labelledby")+" "+S;j.$().attr("aria-labelledby",Q);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){O=j._aAppointments[i];O.setProperty("selected",true,true);Q=O.$().attr("aria-labelledby")+" "+S;O.$().attr("aria-labelledby",Q);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}
function z(i){var P=A.call(this);if(P){P["_onRow"+i]();}}
function A(){var P=this;while(P.getParent()!==null){if(P.getMetadata().getName()==="sap.m.PlanningCalendar"){return P;}P=P.getParent();}}
function B(i,j){if(j){z.call(i,"DeselectAppointment");}}
function E(k){var N=this.getAggregation("groupAppointments",[]);var O;var P=false;for(var i=0;i<N.length;i++){var Q=N[i]._aAppointments;for(var j=0;j<Q.length;j++){if(Q[j].getId()==k){O=N[i];P=true;break;}}if(P){break;}}return O;}
function F(j){if(this._sFocusedAppointmentId!=j){var k=this._getAppointmentsSorted();var V=this._aVisibleAppointments;var N;var i=0;N=E.call(this,j);if(N){j=N.getId();N=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){N=V[i].appointment;break;}}if(N){var O=this.getFocusedAppointment().$();var $=N.$();this._sFocusedAppointmentId=N.getId();O.attr("tabindex","-1");$.attr("tabindex","0");$.focus();}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){N=k[i];break;}}if(N){this._sFocusedAppointmentId=N.getId();var P=p.call(this,N.getStartDate());this.setStartDate(a._createLocalDate(P,true));if(!e(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus();}.bind(this),0);}this.fireStartDateChange();}}}}
function H(j,S){var k=this._sFocusedAppointmentId;var N=this._getAppointmentsSorted();var O=this.getAggregation("groupAppointments",[]);var P;var Q=0;var i=0;for(i=0;i<O.length;i++){if(O[i].getId()==k){var T=O[i]._aAppointments;if(j){k=T[T.length-1].getId();}else{k=T[0].getId();}break;}}for(i=0;i<N.length;i++){if(N[i].getId()==k){Q=i;break;}}if(j){Q=Q+S;}else{Q=Q-S;}if(Q<0){Q=0;}else if(Q>=N.length){Q=N.length-1;}P=N[Q];F.call(this,P.getId());}
function J(j){var k=this._getAppointmentsSorted();var N;var S=new U(this._getStartDate());var O=new U(this._oUTCEndDate);var P=this.getIntervalType();var Q;var T;S.setUTCHours(0);O.setUTCHours(0);O.setUTCMinutes(0);O.setUTCSeconds(0);switch(P){case h.Hour:O.setUTCDate(O.getUTCDate()+1);O.setUTCMilliseconds(-1);break;case h.Day:case h.Week:case h.OneMonth:S.setUTCDate(1);O.setUTCMonth(O.getUTCMonth()+1);O.setUTCDate(1);O.setUTCMilliseconds(-1);break;case h.Month:S.setUTCMonth(0);S.setUTCDate(1);O.setUTCFullYear(O.getUTCFullYear()+1);O.setUTCMonth(1);O.setUTCDate(1);O.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+P+"; "+this);}var V=a._createLocalDate(S,true);var W=a._createLocalDate(O,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=V&&k[i].getStartDate()<=W){N=k[i];Q=N.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>W){break;}}T=E.call(this,Q);if(T){N=T;Q=N.getId();}if(Q&&Q!=this._sFocusedAppointmentId){F.call(this,Q);}else if(j._bPlanningCalendar&&N){N.focus();}else{this.fireLeaveRow({type:j.type});}}
function K(i,j){var k=this.getIntervalType();var S=this._getStartDate();var N=new U(S.getTime());var O;var P=false;var Q=0;var T=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){P=true;var V=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");T=V.length;for(Q=0;Q<T;Q++){var W=V[Q];if(W==j){break;}}}switch(k){case h.Hour:N.setUTCHours(N.getUTCHours()+i);if(P){N.setUTCMinutes(N.getUTCMinutes()+Q*60/T);O=new U(N.getTime());O.setUTCMinutes(O.getUTCMinutes()+60/T);}else{O=new U(N.getTime());O.setUTCHours(O.getUTCHours()+1);}break;case h.Day:case h.Week:case h.OneMonth:N.setUTCDate(N.getUTCDate()+i);if(P){N.setUTCHours(N.getUTCHours()+Q*24/T);O=new U(N.getTime());O.setUTCHours(O.getUTCHours()+24/T);}else{O=new U(N.getTime());O.setUTCDate(O.getUTCDate()+1);}break;case h.Month:N.setUTCMonth(N.getUTCMonth()+i);if(P){N.setUTCDate(N.getUTCDate()+Q);O=new U(N.getTime());O.setUTCDate(O.getUTCDate()+1);}else{O=new U(N.getTime());O.setUTCMonth(O.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}O.setUTCMilliseconds(O.getUTCMilliseconds()-1);N=a._createLocalDate(N,true);O=a._createLocalDate(O,true);this.fireIntervalSelect({startDate:N,endDate:O,subInterval:P});}
function M(i,j){var k=i.getStartDate()-j.getStartDate();if(k==0){k=j.getEndDate()-i.getEndDate();}return k;}
return m;});
sap.ui.predefine('sap/ui/unified/CalendarRowRenderer',['sap/ui/core/date/UniversalDate','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarLegendRenderer','sap/ui/Device','sap/ui/unified/library','sap/ui/core/InvisibleText',"sap/base/Log"],function(U,C,a,D,l,I,L){"use strict";var b=l.CalendarDayType;var c=l.CalendarIntervalType;var d=l.CalendarAppointmentVisualization;var e={};
e.render=function(r,R){var t=R.getTooltip_AsString();var v=R.getAppointmentsVisualization();var T=this.getLegendItems(R);r.write("<div");r.writeControlData(R);r.addClass("sapUiCalendarRow");if(!D.system.phone&&R.getAppointmentsReducedHeight()){r.addClass("sapUiCalendarRowAppsRedHeight");}if(v!=d.Standard){r.addClass("sapUiCalendarRowVis"+v);}if(t){r.writeAttributeEscaped("title",t);}var w=R.getWidth();if(w){r.addStyle("width",w);}var h=R.getHeight();if(h){r.addStyle("height",h);}r.writeAccessibilityState(R);r.writeClasses();r.writeStyles();r.write(">");this.renderAppointmentsRow(r,R,T);r.write("</div>");};
e.renderAppointmentsRow=function(r,R,t){var i=R.getId();r.write("<div id=\""+i+"-Apps\" class=\"sapUiCalendarRowApps\">");this.renderBeforeAppointments(r,R);this.renderAppointments(r,R,t);this.renderAfterAppointments(r,R);r.write("</div>");};
e.renderBeforeAppointments=function(r,R){};
e.renderAfterAppointments=function(r,R){};
e.renderResizeHandle=function(r,R,A){};
e.renderAppointments=function(r,R,t){var A=R._getVisibleAppointments();var f=R._getVisibleIntervalHeaders();var s=R._getStartDate();var n=[];var S=0;var N=0;var g=[];var h=0;var j=0;var k=R.getIntervals();var m=R.getIntervalType();var w=100/k;var i=0;var o=new U(s);var F=false;var p=false;switch(m){case c.Hour:n=R.getNonWorkingHours()||[];S=s.getUTCHours();N=24;break;case c.Day:case c.Week:case c.OneMonth:n=R._getNonWorkingDays();S=s.getUTCDay();N=7;g=R.getNonWorkingHours()||[];h=s.getUTCHours();j=24;break;case c.Month:g=R._getNonWorkingDays();h=s.getUTCDay();j=7;break;default:break;}if(R._isOneMonthIntervalOnSmallSizes()){this.renderSingleDayInterval(r,R,A,t,f,n,S,N,g,h,j,true,true);}else{for(i=0;i<k;i++){if(p){F=true;}else{F=false;}p=false;switch(m){case c.Hour:o.setUTCHours(o.getUTCHours()+1);if(o.getUTCHours()==0){p=true;}break;case c.Day:case c.Week:case c.OneMonth:o.setUTCDate(o.getUTCDate()+1);if(o.getUTCDate()==1){p=true;}break;case c.Month:o.setUTCMonth(o.getUTCMonth()+1);if(o.getUTCMonth()==0){p=true;}break;default:break;}this.renderInterval(r,R,i,w,f,n,S,N,g,h,j,F,p);}this.renderIntervalHeaders(r,R,w,f,k);r.write("<div id=\""+R.getId()+"-Now\" class=\"sapUiCalendarRowNow\"></div>");for(i=0;i<A.length;i++){var q=A[i];this.renderAppointment(r,R,q,t);}r.write("<div id=\""+R.getId()+"-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\"></div>");}};
e.writeCustomAttributes=function(r,R){};
e.renderInterval=function(r,R,f,w,g,n,s,N,h,S,k,F,m){var o=R.getId()+"-AppsInt"+f;var i;var p=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||g.length>0);var M=R.getStartDate().getMonth();var q=new Date(R.getStartDate().getFullYear(),M+1,0).getDate();r.write("<div id=\""+o+"\"");r.addClass("sapUiCalendarRowAppsInt");r.addStyle("width",w+"%");if(f>=q&&R.getIntervalType()===c.OneMonth){r.addClass("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((f+s)%N==n[i]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}if(!p){r.addClass("sapUiCalendarRowAppsIntNoHead");}if(F){r.addClass("sapUiCalendarRowAppsIntFirst");}if(m){r.addClass("sapUiCalendarRowAppsIntLast");}r.writeClasses();r.writeStyles();this.writeCustomAttributes(r,R);r.write(">");if(p){r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");r.writeClasses();r.write(">");r.write("</div>");}if(R.getShowSubIntervals()){var t=R.getIntervalType();var u=0;switch(t){case c.Hour:u=4;break;case c.Day:case c.Week:case c.OneMonth:u=24;break;case c.Month:var v=R._getStartDate();var x=new U(v);x.setUTCMonth(x.getUTCMonth()+f+1,0);u=x.getUTCDate();x.setUTCDate(1);s=x.getUTCDay();break;default:break;}var y=100/u;for(i=0;i<u;i++){r.write("<div");r.addClass("sapUiCalendarRowAppsSubInt");r.addStyle("width",y+"%");for(var j=0;j<h.length;j++){if((i+S)%k==h[j]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}r.writeStyles();r.writeClasses();r.write(">");r.write("</div>");}}r.write("</div>");};
e.renderIntervalHeaders=function(r,R,w,f,g){var s=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||f.length>0);if(s){for(var i=0;i<f.length;i++){var o=f[i],h,j;if(R._bRTL){j=w*o.interval;h=w*(g-o.last-1);}else{h=w*o.interval;j=w*(g-o.last-1);}this.renderIntervalHeader(r,o,R._bRTL,h,j);}}};
e.renderIntervalHeader=function(r,i,R,f,g){var s=i.appointment.getId();r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");if(f!==undefined){r.addStyle("left",f+"%");}if(g!==undefined){r.addStyle("right",g+"%");}r.writeElementData(i.appointment);r.addClass("sapUiCalendarRowAppsIntHeadFirst");if(i.appointment.getSelected()){r.addClass("sapUiCalendarRowAppsIntHeadSel");}if(i.appointment.getTentative()){r.addClass("sapUiCalendarRowAppsIntHeadTent");}var t=i.appointment.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}var T=i.appointment.getType();var h=i.appointment.getColor();if(!h&&T&&T!=b.None){r.addClass("sapUiCalendarRowAppsIntHead"+T);}if(h){if(R){r.addStyle("border-right-color",h);}else{r.addStyle("border-left-color",h);}}r.writeStyles();r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiCalendarIntervalHeaderCont");r.writeClasses();if(h){r.addStyle("background-color",i.appointment._getCSSColorForBackground(h));r.writeStyles();}r.write(">");var j=i.appointment.getIcon();if(j){var k=["sapUiCalendarRowAppsIntHeadIcon"];var A={};A["id"]=s+"-Icon";A["title"]=null;r.writeIcon(j,k,A);}var m=i.appointment.getTitle();if(m){r.write("<span");r.writeAttribute("id",s+"-Title");r.addClass("sapUiCalendarRowAppsIntHeadTitle");r.writeClasses();r.write(">");r.writeEscaped(m,true);r.write("</span>");}var n=i.appointment.getText();if(n){r.write("<span");r.writeAttribute("id",s+"-Text");r.addClass("sapUiCalendarRowAppsIntHeadText");r.writeClasses();r.write(">");r.writeEscaped(n,true);r.write("</span>");}r.write("</div>");r.write("</div>");};
e.renderAppointment=function(r,R,A,t,f){var o=A.appointment;var T=o.getTooltip_AsString();var s=o.getType();var g=o.getColor();var h=o.getTitle();var i=o.getText();var j=o.getIcon();var k=o.getId();var m={labelledby:{value:I.getStaticId("sap.ui.unified","APPOINTMENT")+" "+k+"-Descr",append:true}};var n=R.getAriaLabelledBy();if(n.length>0){m["labelledby"].value=m["labelledby"].value+" "+n.join(" ");}if(h){m["labelledby"].value=m["labelledby"].value+" "+k+"-Title";}if(i){m["labelledby"].value=m["labelledby"].value+" "+k+"-Text";}r.write("<div");r.writeElementData(o);r.addClass("sapUiCalendarApp");if(o.getSelected()){r.addClass("sapUiCalendarAppSel");m["labelledby"].value=m["labelledby"].value+" "+I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");}if(o.getTentative()){r.addClass("sapUiCalendarAppTent");m["labelledby"].value=m["labelledby"].value+" "+I.getStaticId("sap.ui.unified","APPOINTMENT_TENTATIVE");}if(!i){r.addClass("sapUiCalendarAppTitleOnly");}if(j){r.addClass("sapUiCalendarAppWithIcon");}if(!f){if(R._bRTL){r.addStyle("right",A.begin+"%");r.addStyle("left",A.end+"%");}else{r.addStyle("left",A.begin+"%");r.addStyle("right",A.end+"%");}}r.writeAttribute("data-sap-level",A.level);if(R._sFocusedAppointmentId==k){r.writeAttribute("tabindex","0");}else{r.writeAttribute("tabindex","-1");}if(T){r.writeAttributeEscaped("title",T);}if(!g&&s&&s!=b.None){r.addClass("sapUiCalendarApp"+s);}if(g){if(R._bRTL){r.addStyle("border-right-color",g);}else{r.addStyle("border-left-color",g);}}r.writeAccessibilityState(o,m);r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapUiCalendarAppCont");if(g&&R.getAppointmentsVisualization()===d.Filled){r.addStyle("background-color",o._getCSSColorForBackground(g));r.writeStyles();}r.writeClasses();r.write(">");if(j){var p=["sapUiCalendarAppIcon"];var q={};q["id"]=k+"-Icon";q["title"]=null;r.writeIcon(j,p,q);}if(h){r.write("<span");r.writeAttribute("id",k+"-Title");r.addClass("sapUiCalendarAppTitle");r.writeClasses();r.write(">");r.writeEscaped(h,true);r.write("</span>");}if(i){r.write("<span");r.writeAttribute("id",k+"-Text");r.addClass("sapUiCalendarAppText");r.writeClasses();r.write(">");r.writeEscaped(i,true);r.write("</span>");}var u=R._oRb.getText("CALENDAR_START_TIME")+": "+R._oFormatAria.format(o.getStartDate());u=u+"; "+R._oRb.getText("CALENDAR_END_TIME")+": "+R._oFormatAria.format(o.getEndDate());if(T){u=u+"; "+T;}if(s&&s!=b.None){u=u+"; "+this.getAriaTextForType(s,t);}r.write("<span id=\""+k+"-Descr\" class=\"sapUiInvisibleText\">"+u+"</span>");r.write("</div>");this.renderResizeHandle(r,R,o);r.write("</div>");};
e.renderSingleDayInterval=function(r,R,A,t,f,n,s,N,g,S,h,F,k){var m=1,w=100,o=R.getId()+"-AppsInt"+m,i,p=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||f.length>0),q=R.getStartDate(),M=q.getMonth(),u=new Date(q.getFullYear(),M+1,0).getDate(),v,x=A.concat(R.getIntervalHeaders().filter(function(H){var J=H.getStartDate().getTime(),K=H.getStartDate().getTime(),O=q.getTime(),P=O+1000*60*60*24;return(J>=O&&J<P)||(K>=O&&K<P);}).map(function(H){return{appointment:H,isHeader:true};})).sort(C._getComparer(q)),y;r.write("<div id=\""+o+"\"");r.addClass("sapUiCalendarRowAppsInt");r.addClass("sapUiCalendarMonthRowAppsS");r.addStyle("width",w+"%");if(m>=u&&R.getIntervalType()===c.OneMonth){r.addClass("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((m+s)%N==n[i]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}if(!p){r.addClass("sapUiCalendarRowAppsIntNoHead");}if(F){r.addClass("sapUiCalendarRowAppsIntFirst");}if(k){r.addClass("sapUiCalendarRowAppsIntLast");}r.writeClasses();r.writeStyles();r.write(">");if(p){r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");r.writeClasses();r.write(">");r.write("</div>");}for(i=0;i<x.length;i++){y=x[i];r.write("<div class=\"sapUiCalendarAppContainer\">");r.write("<div class=\"sapUiCalendarAppContainerLeft\">");r.write("<div>"+y.appointment._getDateRangeIntersectionText(q)+"</div>");r.write("</div>");r.write("<div class=\"sapUiCalendarAppContainerRight\">");if(y.isHeader){this.renderIntervalHeader(r,y);}else{this.renderAppointment(r,R,y,t,true);}r.write("</div>");r.write("</div>");}if(A.length===0){r.write("<div class=\"sapUiCalendarNoApps\">");v=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PLANNINGCALENDAR_ROW_NO_APPOINTMENTS");r.write(v);r.write("</div>");}r.write("<div id=\""+R.getId()+"-Now\" class=\"sapUiCalendarRowNow\"></div>");r.write("<div id=\""+R.getId()+"-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\" style='margin:0; height:0px;'></div>");if(R.getShowSubIntervals()){var z=R.getIntervalType();var B=0;switch(z){case c.Hour:B=4;break;case c.Day:case c.Week:case c.OneMonth:B=24;break;case c.Month:var E=new U(q);E.setUTCMonth(E.getUTCMonth()+m+1,0);B=E.getUTCDate();E.setUTCDate(1);s=E.getUTCDay();break;default:break;}var G=100/B;for(i=0;i<B;i++){r.write("<div");r.addClass("sapUiCalendarRowAppsSubInt");r.addStyle("width",G+"%");for(var j=0;j<g.length;j++){if((i+S)%h==g[j]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}r.writeStyles();r.writeClasses();r.write(">");r.write("</div>");}}r.write("</div>");};
e.getLegendItems=function(o){var r=[],f,s=o.getLegend();if(s){f=sap.ui.getCore().byId(s);if(f){r=f.getItems();}else{L.error("CalendarLegend with id '"+s+"' does not exist!",o);}}return r;};
e.getAriaTextForType=function(t,f){var T,s,o,i;if(f&&f.length){for(var i=0;i<f.length;i++){o=f[i];if(o.getType()===t){T=o.getText();break;}}}if(!T){s=a.getTypeAriaText(t);if(s){T=s.getText();}}return T;};
return e;},true);
sap.ui.predefine('sap/ui/unified/CalendarTimeInterval',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library','sap/ui/core/format/DateFormat','sap/ui/Device','sap/ui/core/Locale','sap/ui/core/library',"./CalendarTimeIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,H,T,D,M,Y,U,l,b,c,d,e,f,g,h,i,q){"use strict";var j=e.CalendarType;
var k=C.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
k.prototype.init=function(){this._iMode=0;this._oYearFormat=b.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initilizeMonthPicker();this._initilizeYearPicker();this.setPickerPopup(false);this._iItemsHead=15;};
k.prototype._initializeHeader=function(){var c1=new H(this.getId()+"--Head");c1.attachEvent("pressPrevious",this._handlePrevious,this);c1.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",c1);};
k.prototype._initializeTimesRow=function(){var c1=new T(this.getId()+"--TimesRow");c1.attachEvent("focus",K,this);c1.attachEvent("select",J,this);c1._bNoThemeChange=true;this.setAggregation("timesRow",c1);};
k.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};
k.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};
k.prototype._createDatesRow=function(){var c1=new D(this.getId()+"--DatesRow",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});c1.attachEvent("focus",P,this);c1.attachEvent("select",O,this);c1._bNoThemeChange=true;c1.getIntervalSelection=function(){return this.getProperty("intervalSelection");};c1.getSingleSelection=function(){return this.getProperty("singleSelection");};c1.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};c1.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};c1.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};return c1;};
k.prototype._createMonthPicker=function(){var c1=new M(this.getId()+"--MP",{columns:0,months:6});c1.attachEvent("select",Q,this);c1._bNoThemeChange=true;c1.attachEvent("pageChange",a1,this);return c1;};
k.prototype._createYearPicker=function(){var c1=new Y(this.getId()+"--YP",{columns:0,years:6});c1.attachEvent("select",R,this);c1.attachEvent("pageChange",b1,this);c1._oMinDate.setYear(this._oMinDate.getUTCFullYear());c1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return c1;};
k.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};
k.prototype.onBeforeRendering=function(){var c1=this.getAggregation("timesRow");var d1=this._getFocusedDate();x.call(this);c1.displayDate(a._createLocalDate(d1,true));};
k.prototype._getCalendarPicker=function(){var c1=this.getAggregation("calendarPicker");if(!c1){c1=new sap.ui.unified.Calendar(this.getId()+"--Cal",{});c1.setPopupMode(true);c1.attachEvent("select",N,this);c1.attachEvent("cancel",function(d1){this._oPopup.close();var e1=this.getAggregation("header").getDomRef("B1");if(e1){e1.focus();}},this);this.setAggregation("calendarPicker",c1);}return c1;};
k.prototype.setStartDate=function(c1){a._checkJSDateObject(c1);if(h(this.getStartDate(),c1)){return this;}var d1=c1.getFullYear();a._checkYearInValidRange(d1);var e1=this.getMinDate();if(e1&&c1.getTime()<e1.getTime()){i.warning("startDate < minDate -> minDate as startDate set",this);c1=new Date(e1);}var f1=this.getMaxDate();if(f1&&c1.getTime()>f1.getTime()){i.warning("startDate > maxDate -> maxDate as startDate set",this);c1=new Date(f1);}this.setProperty("startDate",c1,true);var g1=this.getAggregation("timesRow");g1.setStartDate(c1);this._oUTCStartDate=new U(g1._getStartDate().getTime());x.call(this);var h1=a._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(h1)){this._setFocusedDate(this._oUTCStartDate);g1.displayDate(c1);}return this;};
k.prototype.invalidate=function(c1){if(!this._bDateRangeChanged&&(!c1||!(c1 instanceof sap.ui.unified.DateRange))){if(!c1||(!(c1 instanceof D||c1 instanceof M||c1 instanceof Y||c1 instanceof H))){C.prototype.invalidate.apply(this,arguments);}}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(S.bind(this),0);}};
k.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("selectedDates");return c1;};
k.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("selectedDates");return c1;};
k.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("specialDates");return c1;};
k.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("specialDates");return c1;};
k.prototype.setIntervalMinutes=function(c1){if(c1>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%c1>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",c1,false);var d1=this.getAggregation("timesRow");var e1=a._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=m.call(this);this._setFocusedDate(f1);d1.setDate(a._createLocalDate(f1,true));}return this;};
k.prototype.setLocale=function(c1){if(this._sLocale!=c1){this._sLocale=c1;this._oLocaleData=undefined;this.invalidate();}return this;};
k.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
k.prototype._getFocusedDate=function(){if(!this._oFocusedDate){o.call(this);}return this._oFocusedDate;};
k.prototype._setFocusedDate=function(c1){if(!(c1 instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(c1.getTime());};
k.prototype.focusDate=function(c1){var d1=false;var e1=this.getAggregation("timesRow");if(!e1.checkDateFocusable(c1)){var f1=a._createUniversalUTCDate(c1,undefined,true);V.call(this,f1);d1=true;}E.call(this,c1,false);if(d1){this.fireStartDateChange();}return this;};
k.prototype.displayDate=function(c1){E.call(this,c1,true);return this;};
k.prototype.setItems=function(c1){this.setProperty("items",c1,true);c1=this._getItems();var d1=this.getAggregation("timesRow");d1.setItems(c1);var e1=a._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=m.call(this);this._setFocusedDate(f1);d1.setDate(a._createLocalDate(f1,true));}if(!this.getPickerPopup()){var g1=this.getAggregation("datesRow");var h1=Math.floor(c1*1.5);if(h1>31){h1=31;}g1.setDays(h1);var i1=this.getAggregation("monthPicker");var j1=Math.floor(c1/2);if(j1>12){j1=12;}i1.setMonths(j1);var k1=this.getAggregation("yearPicker");var l1=Math.floor(c1/2);if(l1>20){l1=20;}k1.setYears(l1);}x.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
k.prototype._getItems=function(){var c1=this.getItems();if(c.system.phone&&c1>6){return 6;}else{return c1;}};
k.prototype._getLocaleData=function(){if(!this._oLocaleData){var c1=this.getLocale();var d1=new d(c1);this._oLocaleData=L.getInstance(d1);}return this._oLocaleData;};
k.prototype.setPickerPopup=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;this.setProperty("pickerPopup",c1,true);if(e1){e1.destroy();}if(c1){d1.setVisibleButton0(false);d1.setVisibleButton1(true);d1.setVisibleButton2(false);d1.detachEvent("pressButton1",G,this);d1.attachEvent("pressButton1",G,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy();}if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{d1.setVisibleButton0(true);d1.setVisibleButton1(true);d1.setVisibleButton2(true);d1.detachEvent("pressButton0",F,this);d1.attachEvent("pressButton0",F,this);d1.detachEvent("pressButton1",G,this);d1.attachEvent("pressButton1",G,this);d1.detachEvent("pressButton2",I,this);d1.attachEvent("pressButton2",I,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}f1=this.getAggregation("monthPicker");g1=this.getAggregation("yearPicker");f1.setColumns(0);f1.setMonths(6);g1.setColumns(0);g1.setYears(6);}return this;};
k.prototype.setMinDate=function(c1){var d1,e1,f1,g1;if(h(c1,this.getMinDate())){return this;}if(!c1){a._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0);}else{a._checkJSDateObject(c1);this._oMinDate=a._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMinDate=d1._getIntervalStart(this._oMinDate);e1=this._oMinDate.getUTCFullYear();a._checkYearInValidRange(e1);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){i.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=a._createUniversalUTCDate(c1,undefined,true);a._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",a._createLocalDate(this._oMaxDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){i.warning("focused date < minDate -> minDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){i.warning("start date < minDate -> minDate set as start date",this);_.call(this,new U(this._oMinDate.getTime()),true,true);}}this.setProperty("minDate",c1,false);if(this.getPickerPopup()){g1=this._getCalendarPicker();g1.setMinDate(c1);}else{f1=this.getAggregation("yearPicker");f1._oMinDate.setYear(this._oMinDate.getUTCFullYear());}return this;};
k.prototype.setMaxDate=function(c1){var d1,e1,f1,g1,h1,i1;if(h(c1,this.getMaxDate())){return this;}if(!c1){a._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0);}else{a._checkJSDateObject(c1);this._oMaxDate=a._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMaxDate=d1._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);e1=this._oMaxDate.getUTCFullYear();a._checkYearInValidRange(e1);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){i.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=a._createUniversalUTCDate(c1,undefined,true);a._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",a._createLocalDate(this._oMinDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){i.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate){f1=new U(this._oUTCStartDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()>this._oMaxDate.getTime()){g1=new U(this._oMaxDate.getTime());g1.setUTCMinutes(g1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(g1.getTime()>=this._oMinDate.getTime()){i.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,g1,true,true);}}}}this.setProperty("maxDate",c1,false);if(this.getPickerPopup()){i1=this._getCalendarPicker();i1.setMaxDate(c1);}else{h1=this.getAggregation("yearPicker");h1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());}return this;};
k.prototype.onclick=function(c1){if(c1.isMarked("delayedMouseEvent")){return;}if(c1.target.id==this.getId()+"-cancel"){this.onsapescape(c1);}};
k.prototype.onmousedown=function(c1){c1.preventDefault();c1.setMark("cancelAutoClose");};
k.prototype.onsapescape=function(c1){if(this.getPickerPopup()){p.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:s.call(this);break;case 2:u.call(this);break;case 3:w.call(this);break;}}};
k.prototype.onsaptabnext=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(g(this.getDomRef("content"),c1.target)){if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B0")){d1.getDomRef("B0").focus();}if(!this._bPoupupMode){g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){e1=this.getAggregation("monthPicker");f1=this.getAggregation("yearPicker");if(e1.getDomRef()){q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B0"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(!this.getPickerPopup()&&(c1.target.id==d1.getId()+"-B1")){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}};
k.prototype.onsaptabprevious=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(g(this.getDomRef("content"),c1.target)){if(this._bPoupupMode){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}}else if(c1.target.id==d1.getId()+"-B0"){g1=this.getAggregation("timesRow");switch(this._iMode){case 0:g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());break;case 2:if(!this.getPickerPopup()){e1=this.getAggregation("monthPicker");e1._oItemNavigation.focusItem(e1._oItemNavigation.getFocusedIndex());}break;case 3:if(!this.getPickerPopup()){f1=this.getAggregation("yearPicker");f1._oItemNavigation.focusItem(f1._oItemNavigation.getFocusedIndex());}break;}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B2"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B1"){if(!this.getPickerPopup()){if(d1.getDomRef("B0")){d1.getDomRef("B0").focus();}}else{g1=this.getAggregation("timesRow");g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());}c1.preventDefault();}};
k.prototype.onfocusin=function(c1){if(c1.target.id==this.getId()+"-end"){var d1=this.getAggregation("header"),e1,f1,g1;if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B2")){d1.getDomRef("B2").focus();}if(!this._bPoupupMode){e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){f1=this.getAggregation("monthPicker");g1=this.getAggregation("yearPicker");if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(g1.getDomRef()){q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
k.prototype.onsapfocusleave=function(c1){if(!c1.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(c1.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var d1,e1,f1;switch(this._iMode){case 0:d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:if(!this.getPickerPopup()){e1=this.getAggregation("monthPicker");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 3:if(!this.getPickerPopup()){f1=this.getAggregation("yearPicker");q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
k.prototype._handlePrevious=function(c1){var d1=this._getFocusedDate(),e1,f1,g1,h1,i1,j1,k1,l1;switch(this._iMode){case 0:e1=this._getItems();f1=new U(m.call(this).getTime());g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()-e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()-e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){h1=this.getAggregation("datesRow");i1=a._createUniversalUTCDate(h1.getDate());j1=h1.getDays();if(i1.getUTCDate()<=j1){i1.setUTCDate(1);}else{i1.setUTCDate(i1.getUTCDate()-j1);}W.call(this,i1);}break;case 2:if(!this.getPickerPopup()){k1=this.getAggregation("monthPicker");if(k1.getMonths()<12){k1.previousPage();y.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()-1);V.call(this,d1);this._setFocusedDate(d1);x.call(this);$.call(this,d1.getUTCFullYear(),k1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){l1=this.getAggregation("yearPicker");l1.previousPage();z.call(this);}break;}};
k.prototype._handleNext=function(c1){var d1=this._getFocusedDate();switch(this._iMode){case 0:var e1=this._getItems();var f1=new U(m.call(this).getTime());var g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()+e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()+e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){var h1=this.getAggregation("datesRow");var i1=a._createUniversalUTCDate(h1.getDate());var j1=new U(i1.getTime());j1.setUTCDate(1);j1.setUTCMonth(j1.getUTCMonth()+1);j1.setUTCDate(0);var k1=h1.getDays();if(i1.getUTCDate()+k1>j1.getUTCDate()){i1.setUTCDate(j1.getUTCDate());}else{i1.setUTCDate(i1.getUTCDate()+k1);}W.call(this,i1);}break;case 2:if(!this.getPickerPopup()){var l1=this.getAggregation("monthPicker");if(l1.getMonths()<12){l1.nextPage();y.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()+1);V.call(this,d1);this._setFocusedDate(d1);x.call(this);$.call(this,d1.getUTCFullYear(),l1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){var m1=this.getAggregation("yearPicker");m1.nextPage();z.call(this);}break;}};
k.prototype._getShowItemHeader=function(){var c1=this.getItems();if(c1>this._iItemsHead){return true;}else{return false;}};
function _(c1,d1,e1){var f1=new U(this._oMaxDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()<this._oMinDate.getTime()){f1=new U(this._oMinDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));}if(c1.getTime()<this._oMinDate.getTime()){c1=new U(this._oMinDate.getTime());}else if(c1.getTime()>f1.getTime()){c1=f1;}var g1=this.getAggregation("timesRow");var h1=a._createLocalDate(c1,true);g1.setStartDate(h1);this._oUTCStartDate=new U(g1._getStartDate().getTime());h1=a._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",h1,true);x.call(this);if(d1){var i1=a._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(i1)){this._setFocusedDate(c1);g1.setDate(h1);}else{g1.setDate(i1);}}if(!e1){this.fireStartDateChange();}}
function m(){if(!this._oUTCStartDate){var c1=this.getAggregation("timesRow");c1.setStartDate(a._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(c1._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}
function n(c1){var d1=this._getFocusedDate();var e1=this.getAggregation("timesRow");if(!c1){e1.setDate(a._createLocalDate(d1,true));}else{e1.displayDate(a._createLocalDate(d1,true));}x.call(this);}
function o(){var c1=this.getSelectedDates();if(c1&&c1[0]&&c1[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(c1[0].getStartDate(),undefined,true);}else{var d1=new Date();this._oFocusedDate=a._createUniversalUTCDate(d1,undefined,true);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new U(this._oMinDate.getTime());}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new U(this._oMaxDate.getTime());}}
k.prototype._showCalendarPicker=function(){var c1=a._createLocalDate(this._getFocusedDate(),true);var d1=this._getCalendarPicker();var e1=new sap.ui.unified.DateRange({startDate:c1});d1.displayDate(c1,false);d1.removeAllSelectedDates();d1.addSelectedDate(e1);d1.setMinDate(this.getMinDate());d1.setMaxDate(this.getMaxDate());X.call(this,d1);this._showOverlay();};
k.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
k.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
function p(c1){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!c1){n.call(this);var d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function r(){if(this._iMode==3){w.call(this,true);}else if(this._iMode==2){u.call(this,true);}var c1=this._getFocusedDate();var d1=this._getItems();var e1=this.getAggregation("datesRow");var f1=e1.getSelectedDates()[0];f1.setStartDate(a._createLocalDate(c1,true));var g1=new U(c1.getTime());g1.setUTCDate(1);g1.setUTCMonth(g1.getUTCMonth()+1);g1.setUTCDate(0);var h1=g1.getUTCDate();var i1=Math.floor(d1*1.5);if(i1>h1){i1=h1;}e1.setDays(i1);if(e1.getDomRef()){e1.$().css("display","");}else{var j1=sap.ui.getCore().createRenderManager();var k1=this.$("content");j1.renderControl(e1);j1.flush(k1[0],false,true);j1.destroy();}this._showOverlay();W.call(this,c1);if(this._iMode==0){var l1=this.getAggregation("timesRow");q(l1._oItemNavigation.getItemDomRefs()[l1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}
function s(c1){this._iMode=0;var d1=this.getAggregation("datesRow");d1.$().css("display","none");this._hideOverlay();if(!c1){n.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function t(){if(this._iMode==1){s.call(this,true);}else if(this._iMode==3){w.call(this,true);}var c1=this._getFocusedDate();var d1=this.getAggregation("monthPicker");if(d1.getDomRef()){d1.$().css("display","");}else{var e1=sap.ui.getCore().createRenderManager();var f1=this.$("content");e1.renderControl(d1);e1.flush(f1[0],false,true);e1.destroy();}this._showOverlay();d1.setMonth(c1.getUTCMonth());$.call(this,c1.getUTCFullYear(),d1);if(this._iMode==0){var g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;y.call(this);}
function u(c1){this._iMode=0;var d1=this.getAggregation("monthPicker");d1.$().css("display","none");this._hideOverlay();if(!c1){n.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function v(){if(this._iMode==1){s.call(this,true);}else if(this._iMode==2){u.call(this,true);}var c1=this._getFocusedDate();var d1=this.getAggregation("yearPicker");if(d1.getDomRef()){d1.$().css("display","");}else{var e1=sap.ui.getCore().createRenderManager();var f1=this.$("content");e1.renderControl(d1);e1.flush(f1[0],false,true);e1.destroy();}this._showOverlay();d1.setDate(c1.getJSDate());if(this._iMode==0){var g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}z.call(this);this._iMode=3;}
function w(c1){this._iMode=0;var d1=this.getAggregation("yearPicker");d1.$().css("display","none");this._hideOverlay();if(!c1){n.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function x(){A.call(this);y.call(this,true);}
function y(c1){var d1=new U(m.call(this).getTime());var e1=this._getItems();var f1=d1.getJSDate().getUTCFullYear();var g1=this._oMaxDate.getJSDate().getUTCFullYear();var h1=this._oMinDate.getJSDate().getUTCFullYear();var i1=d1.getJSDate().getUTCMonth();var j1=this._oMaxDate.getJSDate().getUTCMonth();var k1=this._oMinDate.getJSDate().getUTCMonth();var l1=d1.getJSDate().getUTCDate();var m1=this._oMaxDate.getJSDate().getUTCDate();var n1=this._oMinDate.getJSDate().getUTCDate();var o1=d1.getJSDate().getUTCHours();var p1=this._oMaxDate.getJSDate().getUTCHours();var q1=this._oMinDate.getJSDate().getUTCHours();var r1=d1.getJSDate().getUTCMinutes();var s1=this._oMaxDate.getJSDate().getUTCMinutes();var t1=this._oMinDate.getJSDate().getUTCMinutes();var u1=this.getAggregation("header");if(this._iMode==2&&!c1){var v1=this.getAggregation("monthPicker");var w1=v1.getMonths();var x1=v1.getStartMonth();var y1=x1+w1-1;if(x1==0||(f1==h1&&x1<=k1)){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}if(y1>10||(f1==g1&&y1>=j1)){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}return;}if((f1<h1||(f1==h1&&(!c1||(i1<k1||(i1==k1&&(l1<n1||(l1==n1&&(o1<q1||(o1==q1&&r1<=t1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}d1.setUTCMinutes(d1.getUTCMinutes()+(e1)*this.getIntervalMinutes()-1);f1=d1.getJSDate().getUTCFullYear();i1=d1.getJSDate().getUTCMonth();l1=d1.getJSDate().getUTCDate();o1=d1.getJSDate().getUTCHours();r1=d1.getJSDate().getUTCMinutes();if((f1>g1||(f1==g1&&(!c1||(i1>j1||(i1==j1&&(l1>m1||(l1==m1&&(o1>p1||(o1==p1&&r1>=s1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}}
function z(){var c1=this.getAggregation("yearPicker");var d1=c1.getYears();var e1=a._createUniversalUTCDate(c1.getFirstRenderedDate());e1.setUTCFullYear(e1.getUTCFullYear()+Math.floor(d1/2));var f1=this.getAggregation("header");var g1=new U(this._oMaxDate);g1.setUTCFullYear(g1.getUTCFullYear()-Math.ceil(d1/2));g1.setUTCMonth(11,31);var h1=new U(this._oMinDate);h1.setUTCFullYear(h1.getUTCFullYear()+Math.floor(d1/2)+1);h1.setUTCMonth(0,1);if(e1.getTime()>g1.getTime()){f1.setEnabledNext(false);}else{f1.setEnabledNext(true);}if(e1.getTime()<h1.getTime()){f1.setEnabledPrevious(false);}else{f1.setEnabledPrevious(true);}}
function A(){var c1=this.getAggregation("header");var d1;var e1=m.call(this);var f1;var g1=this._getLocaleData();var h1=[];var i1=[];var j1;var k1=false;var l1;var m1=j.Gregorian;var n1=false;if(g1.oLocale.sLanguage.toLowerCase()==="ja"||g1.oLocale.sLanguage.toLowerCase()==="zh"){l1=b.getDateInstance({format:"d"}).format(e1,true);}else{l1=(e1.getUTCDate()).toString();}if(this._bLongMonth||!this._bNamesLengthChecked){h1=g1.getMonthsStandAlone("wide");}else{k1=true;h1=g1.getMonthsStandAlone("abbreviated");i1=g1.getMonthsStandAlone("wide");}var o1=e1.getUTCMonth();d1=h1[o1];if(k1){j1=i1[h1[o1]];}if(!this.getPickerPopup()){c1.setTextButton0(l1);c1.setTextButton1(d1);c1.setTextButton2(this._oYearFormat.format(e1,true));}else{f1=b.getInstance({style:"long",strictParsing:true,relative:n1,calendarType:m1},g1.oLocale);j1=l1=f1.format(a._createLocalDate(e1,true));c1.setTextButton1(l1);}if(k1){c1.setAriaLabelButton1(j1);}}
function B(c1,d1){var e1;var f1=false;if(c1.getTime()<this._oMinDate.getTime()){e1=this._oMinDate;f1=true;}else if(c1.getTime()>this._oMaxDate.getTime()){e1=this._oMaxDate;f1=true;}else{e1=c1;}this._setFocusedDate(e1);if(f1||d1){V.call(this,e1);n.call(this,false);this.fireStartDateChange();}}
function E(c1,d1){if(c1&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=c1.getTime())){a._checkJSDateObject(c1);c1=a._createUniversalUTCDate(c1,undefined,true);var e1=c1.getUTCFullYear();a._checkYearInValidRange(e1);if(c1.getTime()<this._oMinDate.getTime()||c1.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(c1);if(this.getDomRef()&&this._iMode==0){n.call(this,d1);}}}
function F(c1){if(this._iMode!=1){r.call(this);}else{s.call(this);}}
function G(c1){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=2){t.call(this);}else{u.call(this);}}}
function I(c1){if(this._iMode!=3){v.call(this);}else{w.call(this);}}
function J(c1){this.fireSelect();}
function K(c1){var d1=a._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var e1=c1.getParameter("notVisible");B.call(this,d1,e1);}
function N(c1){var d1=c1.getSource(),e1=d1.getSelectedDates()[0].getStartDate();var f1=new U(this._getFocusedDate().getTime());var g1=a._createUniversalUTCDate(e1);f1.setUTCDate(g1.getUTCDate());f1.setUTCMonth(g1.getUTCMonth());f1.setUTCFullYear(g1.getUTCFullYear());B.call(this,f1,true);p.call(this);}
function O(c1){var d1=new U(this._getFocusedDate().getTime());var e1=c1.oSource;var f1=e1.getSelectedDates()[0];var g1=a._createUniversalUTCDate(f1.getStartDate());if(!this.getPickerPopup()||g1.getUTCMonth()==d1.getUTCMonth()){d1.setUTCDate(g1.getUTCDate());d1.setUTCMonth(g1.getUTCMonth());d1.setUTCFullYear(g1.getUTCFullYear());B.call(this,d1,true);s.call(this);}}
function P(c1){var d1=new U(this._getFocusedDate().getTime());var e1=a._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var f1=c1.getParameter("otherMonth");if(f1&&e1.getUTCMonth()==d1.getUTCMonth()&&e1.getUTCFullYear()==d1.getUTCFullYear()){W.call(this,e1);}}
function Q(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this.getAggregation("monthPicker");var f1=e1.getMonth();d1.setUTCMonth(f1);if(f1!=d1.getUTCMonth()){d1.setUTCDate(0);}B.call(this,d1,true);u.call(this);}
function R(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this.getAggregation("yearPicker");var f1=a._createUniversalUTCDate(e1.getDate());var g1=d1.getUTCMonth();f1.setUTCMonth(d1.getUTCMonth(),d1.getUTCDate());f1.setUTCHours(d1.getUTCHours());f1.setUTCMinutes(d1.getUTCMinutes());d1=f1;if(g1!=d1.getUTCMonth()){d1.setUTCDate(0);}B.call(this,d1,true);w.call(this);}
function S(){this._sInvalidateContent=undefined;var c1=this.getAggregation("timesRow");c1._bDateRangeChanged=true;c1._bInvalidateSync=true;c1.invalidate();c1._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}
function V(c1){var d1=this.getAggregation("timesRow");var e1=m.call(this);var f1=d1._oItemNavigation.getFocusedIndex();e1=new U(c1.getTime());e1.setUTCMinutes(e1.getUTCMinutes()-f1*this.getIntervalMinutes());_.call(this,e1,false,true);}
function W(c1){var d1=this.getAggregation("datesRow");var e1=this.getAggregation("header");if(!this.getPickerPopup()){var f1=new U(c1.getTime());f1.setUTCDate(1);f1.setUTCMonth(f1.getUTCMonth()+1);f1.setUTCDate(0);var g1=d1.getDays();var h1=new U(c1.getTime());h1.setUTCDate(1+(Math.ceil(c1.getUTCDate()/g1)-1)*g1);if(f1.getUTCDate()-h1.getUTCDate()<g1){h1.setUTCDate(f1.getUTCDate()-g1+1);}d1.setStartDate(a._createLocalDate(h1,true));var i1=h1.getJSDate().getUTCFullYear();var j1=this._oMaxDate.getJSDate().getUTCFullYear();var k1=this._oMinDate.getJSDate().getUTCFullYear();var l1=h1.getJSDate().getUTCMonth();var m1=this._oMaxDate.getJSDate().getUTCMonth();var n1=this._oMinDate.getJSDate().getUTCMonth();var o1=h1.getJSDate().getUTCDate();var p1=this._oMaxDate.getJSDate().getUTCDate();var q1=this._oMinDate.getJSDate().getUTCDate();if(o1<=1||(i1==k1&&l1==n1&&o1<=q1)){e1.setEnabledPrevious(false);}else{e1.setEnabledPrevious(true);}if((o1+g1)>=f1.getUTCDate()||(i1==j1&&l1==m1&&o1>=p1)){e1.setEnabledNext(false);}else{e1.setEnabledNext(true);}}else{e1.setEnabledPrevious(false);e1.setEnabledNext(false);}d1.setDate(a._createLocalDate(c1,true));}
function X(c1){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(Z,this);this._oPopup.onsapescape=function(f1){this._oCalendar.onsapescape(f1);};}this._oPopup.setContent(c1);var d1=this.getAggregation("header");var e1=sap.ui.core.Popup.Dock;this._oPopup.open(0,e1.CenterTop,e1.CenterTop,d1,null,"flipfit",true);}
function Z(c1){p.call(this);}
function $(c1,d1){var e1=0;var f1=11;if(c1==this._oMinDate.getUTCFullYear()){e1=this._oMinDate.getUTCMonth();}if(c1==this._oMaxDate.getUTCFullYear()){f1=this._oMaxDate.getUTCMonth();}d1.setMinMax(e1,f1);}
function a1(c1){y.call(this);}
function b1(c1){z.call(this);}
return k;});
sap.ui.predefine('sap/ui/unified/CalendarTimeIntervalRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var i=c.getId();var t=c.getTooltip_AsString();var T=c.getAggregation("timesRow");r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");r.addClass("sapUiCalInt");r.addClass("sapUiCalTimeInt");if(c._getShowItemHeader()){r.addClass("sapUiCalIntHead");}if(c.getPickerPopup()){r.addClass("sapUiCalIntLarge");}r.writeAttribute("tabindex","-1");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}var w=c.getWidth();if(w&&w!=''){r.addStyle("width",w);r.writeStyles();}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+i+"-content\" class=\"sapUiCalContent\">");r.renderControl(T);r.write("</div>");r.write("<button id=\""+i+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+i+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");if(c.getPickerPopup()){r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarWeekInterval',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarDateIntervalRenderer'],function(C,a,l,b,c){"use strict";
var d=b.extend("sap.ui.unified.CalendarWeekInterval",{renderer:c});
d.prototype._getDaysLarge=function(){return 6;};
d.prototype._handleFocus=function(e){var o=!!e.getParameter("_outsideBorder"),D,f,g;if(o){D=e.getParameter("date");this._oFocusDateWeek=a.fromLocalJSDate(D);f=C._getFirstDateOfWeek(this._oFocusDateWeek);g=this.getAggregation("month")[0];if(g.getDomRef()){this._setStartDate(f,false,true);}}return b.prototype._handleFocus.apply(this,arguments);};
d.prototype._focusDateExtend=function(D,o,n){var e,L;if(!this._oFocusDateWeek){return b.prototype._focusDateExtend.apply(this,arguments);}e=this.getAggregation("month")[0];L=this._oFocusDateWeek.toLocalJSDate();this._setFocusedDate(this._oFocusDateWeek);e.setDate(L);this._oFocusDateWeek=null;return!n;};
d.prototype._dateMatchesVisibleRange=function(D){var i=this.getDays(),o=a.fromLocalJSDate(D),s=a.fromLocalJSDate(this.getStartDate()),e=a.fromLocalJSDate(this.getStartDate());e.setDate(e.getDate()+i);return o.isSameOrAfter(s)&&o.isBefore(e);};
d.prototype._showCalendarPicker=function(){var o=this._getFocusedDate(),e=this._getStartDate(),f=this._getCalendarPicker(),s=new sap.ui.unified.DateRange(),g;g=new a(e);g.setDate(g.getDate()+this._getDays()-1);s.setStartDate(e.toLocalJSDate());s.setEndDate(g.toLocalJSDate());f.displayDate(o.toLocalJSDate(),false);f.removeAllSelectedDates();f.addSelectedDate(s);f.setMinDate(this.getMinDate());f.setMaxDate(this.getMaxDate());this._openPickerPopup(f);this._showOverlay();};
d.prototype._handleCalendarPickerDateSelect=function(e){var o=this._getCalendarPicker(),s=o.getSelectedDates()[0].getStartDate(),f=new a.fromLocalJSDate(s),F;if(this._dateMatchesVisibleRange(f.toLocalJSDate())){this._oFocusDateWeek=f;this._focusDate(this._oFocusDateWeek,false,true);}else{F=C._getFirstDateOfWeek(f);this._setStartDate(F);this._oFocusDateWeek=f;this._focusDate(this._oFocusDateWeek,false,true);}this._closeCalendarPicker(true);};
d.prototype._calculateStartDate=function(m,M,s){var m=new a(this._oMaxDate,this.getPrimaryCalendarType());m=this._getMaxDateAlignedToMinDate(m,this._oMinDate);s=this._getStartDateAlignedToMinAndMaxDate(m,this._oMinDate,s);return s;};
return d;});
sap.ui.predefine('sap/ui/unified/ColorPicker',["./library","sap/ui/core/Control","sap/ui/core/HTML","sap/ui/core/ResizeHandler","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/ui/core/Icon","sap/ui/core/theming/Parameters","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/core/library","./ColorPickerRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/Global"],function(L,a,H,R,G,b,V,c,I,P,e,D,f,g,h,q){"use strict";var j=f.ValueState;var k=L.ColorPickerMode,l=L.ColorPickerDisplayMode;
var m=a.extend("sap.ui.unified.ColorPicker",{metadata:{library:"sap.ui.unified",properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:k.HSV},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:l.Default}},aggregations:{_grid:{type:"sap.ui.layout.Grid",group:"Appearance",multiple:false,visibility:"hidden"},_invisibleTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}}});
var B="",s=sap.ui.resource('sap.ui.unified','img/ColorPicker/Alphaslider_BG.png'),r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),o=L.ColorPickerHelper,F=o.factory,n={};Object.defineProperties(n,{RGB:{value:"RGB"},CPResponsiveClass:{value:"sapUnifiedColorPicker"},CPMatrixClass:{value:"sapUiColorPicker-ColorPickerMatrix"},HSLClass:{value:"sapUiColorPickerHSL"},LabelClass:{value:"sapUiColorPicker-ColorPickerLabels"},UnitLabelClass:{value:"sapUiCPUnitLabel"},HEXClass:{value:"sapUiColorPicker-ColorPickerHexField"},LeftColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsLeft"},RightColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsRight"},SliderClass:{value:"sapUiColorPicker-ColorPickerSlider"},AlphaSliderClass:{value:"sapUiColorPicker-ColorPickerAlphaSlider"},OutputSelectorClass:{value:"sapUiColorPickerHSL-RB"},OutputSelectorRowClass:{value:"sapUiColorPicker-RBRow"},CPBoxClass:{value:"sapUiColorPicker-ColorPickerBox"},CPCircleClass:{value:"sapUiColorPicker-ColorPickerCircle"},LastColumnClass:{value:"sapUiColorPicker-ColorPickerLastColumn"},HideForHSVClass:{value:"hideForHSV"},HideForHSLClass:{value:"hideForHSL"},OldColorClass:{value:"sapUiColorPicker-ColorPickerOldColor"},NewColorClass:{value:"sapUiColorPicker-ColorPickerNewColor"},SwatchesClass:{value:"sapUiColorPicker-swatches"},Colors:{value:{aliceblue:'f0f8ff',antiquewhite:'faebd7',aqua:'00ffff',aquamarine:'7fffd4',azure:'f0ffff',beige:'f5f5dc',bisque:'ffe4c4',black:'000000',blanchedalmond:'ffebcd',blue:'0000ff',blueviolet:'8a2be2',brown:'a52a2a',burlywood:'deb887',cadetblue:'5f9ea0',chartreuse:'7fff00',chocolate:'d2691e',coral:'ff7f50',cornflowerblue:'6495ed',cornsilk:'fff8dc',crimson:'dc143c',cyan:'00ffff',darkblue:'00008b',darkcyan:'008b8b',darkgoldenrod:'b8860b',darkgray:'a9a9a9',darkgrey:'a9a9a9',darkgreen:'006400',darkkhaki:'bdb76b',darkmagenta:'8b008b',darkolivegreen:'556b2f',darkorange:'ff8c00',darkorchid:'9932cc',darkred:'8b0000',darksalmon:'e9967a',darkseagreen:'8fbc8f',darkslateblue:'483d8b',darkslategray:'2f4f4f',darkslategrey:'2f4f4f',darkturquoise:'00ced1',darkviolet:'9400d3',deeppink:'ff1493',deepskyblue:'00bfff',dimgray:'696969',dimgrey:'696969',dodgerblue:'1e90ff',firebrick:'b22222',floralwhite:'fffaf0',forestgreen:'228b22',fuchsia:'ff00ff',gainsboro:'dcdcdc',ghostwhite:'f8f8ff',gold:'ffd700',goldenrod:'daa520',gray:'808080',grey:'808080',green:'008000',greenyellow:'adff2f',honeydew:'f0fff0',hotpink:'ff69b4',indianred:'cd5c5c',indigo:'4b0082',ivory:'fffff0',khaki:'f0e68c',lavender:'e6e6fa',lavenderblush:'fff0f5',lawngreen:'7cfc00',lemonchiffon:'fffacd',lightblue:'add8e6',lightcoral:'f08080',lightcyan:'e0ffff',lightgoldenrodyellow:'fafad2',lightgray:'d3d3d3',lightgrey:'d3d3d3',lightgreen:'90ee90',lightpink:'ffb6c1',lightsalmon:'ffa07a',lightseagreen:'20b2aa',lightskyblue:'87cefa',lightslategray:'778899',lightslategrey:'778899',lightsteelblue:'b0c4de',lightyellow:'ffffe0',lime:'00ff00',limegreen:'32cd32',linen:'faf0e6',magenta:'ff00ff',maroon:'800000',mediumaquamarine:'66cdaa',mediumblue:'0000cd',mediumorchid:'ba55d3',mediumpurple:'9370db',mediumseagreen:'3cb371',mediumslateblue:'7b68ee',mediumspringgreen:'00fa9a',mediumturquoise:'48d1cc',mediumvioletred:'c71585',midnightblue:'191970',mintcream:'f5fffa',mistyrose:'ffe4e1',moccasin:'ffe4b5',navajowhite:'ffdead',navy:'000080',oldlace:'fdf5e6',olive:'808000',olivedrab:'6b8e23',orange:'ffa500',orangered:'ff4500',orchid:'da70d6',palegoldenrod:'eee8aa',palegreen:'98fb98',paleturquoise:'afeeee',palevioletred:'db7093',papayawhip:'ffefd5',peachpuff:'ffdab9',peru:'cd853f',pink:'ffc0cb',plum:'dda0dd',powderblue:'b0e0e6',purple:'800080',red:'ff0000',rosybrown:'bc8f8f',royalblue:'4169e1',saddlebrown:'8b4513',salmon:'fa8072',sandybrown:'f4a460',seagreen:'2e8b57',seashell:'fff5ee',sienna:'a0522d',silver:'c0c0c0',skyblue:'87ceeb',slateblue:'6a5acd',slategray:'708090',slategrey:'708090',snow:'fffafa',springgreen:'00ff7f',steelblue:'4682b4',tan:'d2b48c',teal:'008080',thistle:'d8bfd8',tomato:'ff6347',turquoise:'40e0d0',violet:'ee82ee',wheat:'f5deb3',white:'ffffff',whitesmoke:'f5f5f5',yellow:'ffff00',yellowgreen:'9acd32',transparent:'00000000'}}});
m.prototype.init=function(){if(D.browser.firefox){B="-moz-linear-gradient";}else if(D.browser.msie){B="-ms-linear-gradient";}else if(D.browser.webkit){B="-webkit-linear-gradient";}else{B="linear-gradient";}this.Color={r:255,g:255,b:255,h:0,s:0,l:100,v:100,a:1,oldA:1,hex:"#ffffff",old:"#ffffff"};this.sHexString="ffffff";this.$CPBox=null;this.$CPCur=null;this.RGB={r:0,g:0,b:0};this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this.data("sap-ui-fastnavgroup","true",true);this.bResponsive=o.isResponsive();var d=this.bResponsive?"_sap_ui_unified_ColorPicker_CircleSize":"_sap_ui_commons_ColorPicker_CircleSize";this._iCPCursorSize=parseInt(P.get(d),10);this._processChanges=this._processHSVChanges;this._bHSLMode=false;if(this.getDisplayMode()===l.Simplified){n.HideForDisplay.value=".hideDisplay";}this.bPressed=true;};
var p=a.extend("sap.ui.unified._ColorPickerBox",{
metadata:{events:{select:{parameters:{value:{type:"int"},saturation:{type:"int"}}},resize:{parameters:{size:{type:"int"}}}}},
init:function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();},
exit:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
getWidth:function(){return this.$().width();},
getOffset:function(){return this.$().offset();},
onBeforeRendering:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
onAfterRendering:function(){this._handle=this.$().find("> div."+n.CPCircleClass);this._sResizeListener=R.register(this.getDomRef(),this.handleResize.bind(this));},
handleResize:function(E){this.fireResize({size:E.size.width});},
getHandle:function(){return this._handle;},
ontouchstart:function(E){this.handleTouch(E);},
ontouchend:function(E){this.handleTouch(E);},
ontouchmove:function(E){this.handleTouch(E);},
handleTouch:function(E){var v=this.calculateValuesFromEvent(E);if(v){this.fireSelect(v);}},
calculateValuesFromEvent:function(E){var x=E.offsetX,y=E.offsetY,i,d=i=this.getWidth(),t,O;E.preventDefault&&E.preventDefault();if(!x){t=E.targetTouches?E.targetTouches[0]:E;if(!t||!t.pageX){t=E;if((!t||!t.pageX)&&E.changedTouches){t=E.changedTouches[0];}}if(!t.pageX){return false;}O=this.getOffset();x=t.pageX-O.left;y=t.pageY-O.top;}x=Math.min(Math.max(x,0),d);y=Math.min(Math.max(y,0),i);if(this.bRtl){x=d-x;}return{value:x/d*100,saturation:(1-y/i)*100};},
renderer:function(d,C){d.write("<div");d.addClass(n.CPBoxClass);d.writeControlData(C);d.writeClasses();d.write(">");d.write("<div");d.writeAttribute("id",C.getId()+"-cpCur");d.addClass(n.CPCircleClass);d.writeClasses();d.write("></div>");d.write("</div>");}
});
m.prototype._createRowFromInput=function(i,t,d,u){var T=r.getText(t),v;v=new c({content:[F.createLabel({text:d,tooltip:T,labelFor:i}).addStyleClass(n.LabelClass),i.setTooltip(T)]});if(u){v.addContent(F.createLabel({text:u,labelFor:i}).addStyleClass(n.UnitLabelClass).addStyleClass(n.LabelClass));}return v;};
m.prototype._updateColorStringProperty=function(d,i){var t=this._getCSSColorString();this.setProperty('colorString',t,true);if(i){this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:t});}if(d){this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:t});}};
m.prototype._handleCPBoxSelectEvent=function(E){var v=E.getParameter("value"),d=E.getParameter("saturation");this.oSatField.setValue(d);if(this._bHSLMode){this.oLitField.setValue(v);}else{this.oValField.setValue(v);}this._processChanges();this._updateColorStringProperty(false,true);};
m.prototype._handleCPBoxResizeEvent=function(E){this._iCPBoxSize=E.getParameter("size");this._updateCursorPosition();};
m.prototype._handleCPBoxTouchEndEvent=function(E){this._updateColorStringProperty(true,false);};
m.prototype._createInteractionControls=function(){var i=this.getId(),d,A;this.oCPBox=new p(i+"-cpBox",{select:this._handleCPBoxSelectEvent.bind(this),resize:this._handleCPBoxResizeEvent.bind(this)});this.oCPBox.addDelegate({ontouchend:this._handleCPBoxTouchEndEvent.bind(this)});this.oHexField=F.createInput(i+"-hxF",{value:this.Color.hex.substr(1),change:this._handleHexValueChange.bind(this)}).addStyleClass(n.HEXClass);this.oRedField=F.createInput(i+"-rF",{value:this.Color.r,change:this._handleRedValueChange.bind(this)}).addStyleClass(n.LeftColumnInputClass);this.oGreenField=F.createInput(i+"-gF",{value:this.Color.g,change:this._handleGreenValueChange.bind(this)}).addStyleClass(n.LeftColumnInputClass);this.oBlueField=F.createInput(i+"-bF",{value:this.Color.b,change:this._handleBlueValueChange.bind(this)}).addStyleClass(n.LeftColumnInputClass);this.oHueField=F.createInput(i+"-hF",{value:this.Color.h,change:this._handleHueValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oSatField=F.createInput(i+"-sF",{value:this.Color.s,change:this._handleSatValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oLitField=F.createInput(i+"-lF",{value:this.Color.l,change:this._handleLitValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oAlphaField=F.createInput(i+"-aF",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oAlphaFieldHSL=F.createInput(i+"-aFHSL",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oValField=F.createInput(i+"-vF",{value:this.Color.v,change:this._handleValValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oRGBorHSLRBGroup=F.createRadioButtonGroup({columns:2,buttons:[F.createRadioButtonItem({text:n.RGB}),F.createRadioButtonItem({text:L.ColorPickerMode.HSL})],select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:(this.Color.formatHSL?1:0)}).addStyleClass(n.OutputSelectorClass);if(this.bResponsive){this.oRGBorHSLRBUnifiedGroup=new sap.m.RadioButtonGroup({buttons:[new sap.m.RadioButton(),new sap.m.RadioButton()]});}d=new e({text:r.getText("COLORPICKER_HUE_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",d,true);this.oSlider=F.createSlider(i+"-hSLD",{max:360,step:1,tooltip:r.getText("COLORPICKER_HUE"),value:parseInt(this.oHueField.getValue(),10)}).addStyleClass(n.SliderClass).addAriaLabelledBy(d);this.oSlider.attachEvent("liveChange","liveChange",this._handleSliderChange.bind(this));this.oSlider.attachEvent("change","change",this._handleSliderChange.bind(this));A=new e({text:r.getText("COLORPICKER_ALPHA_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",A,true);this.oAlphaSlider=F.createSlider(i+"-aSLD",{max:1,value:1,step:0.01,tooltip:r.getText("COLORPICKER_ALPHA")}).addStyleClass(n.AlphaSliderClass).addAriaLabelledBy(A);this.oAlphaSlider.attachEvent("liveChange","liveChange",this._handleAlphaSliderChange.bind(this));this.oAlphaSlider.attachEvent("change","change",this._handleAlphaSliderChange.bind(this));};
m.prototype._createLayout=function(){var i=this.getId(),d;if(this._bLayoutControlsCreated){return;}this._createInteractionControls();this.oCPBoxGD=new b({span:"L6 M6 S12"});this.icOne=new b({span:"L3 M3 S6"});this.icTwo=new b({span:"L3 M3 S6"});this.swatches=new b({span:"L3 M3 S12"});this.rbg=new b({span:"L6 M8 S12"});if(this.bResponsive){d=this._createUnifiedColorPicker(d,i);}else{d=this._createCommonsColorPicker(d,i);}this.setAggregation("_grid",d,true);this._bLayoutControlsCreated=true;this._adaptControlToLibrary();};
m.prototype._adaptControlToLibrary=function(){var d;if(!this._bLayoutControlsCreated){return;}d=this.getAggregation("_grid");if(this.bResponsive){if(!D.system.phone&&!q('html').hasClass("sapUiMedia-Std-Phone")){d._setBreakPointTablet(400);}d.addStyleClass(n.CPResponsiveClass);}else{d.setProperty("hSpacing",0,true);d.setProperty("vSpacing",0,true);this.oCPBoxGD.setSpanS(5);this.icOne.setSpanS(4);this.icTwo.setSpanS(3);this.rbg.setSpanS(8);}};
m.prototype._updateControlVisualState=function(){var d=this.getAggregation("_grid");if(!d){return;}if(this.bResponsive){if(this._bHSLMode){d.addStyleClass(n.HSLClass);this.swatches.setSpanM(4).setLinebreak(true);}else{d.removeStyleClass(n.HSLClass);this.swatches.setSpanM(3).setLinebreak(false);}}else{if(this._bHSLMode){d.addStyleClass(n.HSLClass);this.swatches.setSpanS(4).setLinebreak(true);}else{d.removeStyleClass(n.HSLClass);this.swatches.setSpanS(3).setLinebreak(false);}}};
m.prototype._processChanges=function(){};
m.prototype.setMode=function(M,S){this._bLayoutControlsCreated=false;switch(M){case L.ColorPickerMode.HSL:this._processChanges=this._processHSLChanges;break;case L.ColorPickerMode.HSV:this._processChanges=this._processHSVChanges;break;default:h.error("Control must have a valid mode set to work correct");break;}this._bHSLMode=M===L.ColorPickerMode.HSL;return this.setProperty("mode",M,S);};
m.prototype.setDisplayMode=function(d){this._bLayoutControlsCreated=false;return this.setProperty("displayMode",d,false);};
m.prototype._cleanup=function(){var C=[this.getAggregation("_grid"),this.oCPBox,this.oHLayoutDefault,this.oHLayoutLarge,this.oHLayoutSwatches,this.oHexField,this.oRedField,this.oGreenField,this.oBlueField,this.oHueField,this.oSatField,this.oLitField,this.oAlphaField,this.oAlphaFieldHSL,this.oValField,this.oSlider,this.oAlphaSlider,this.oRGBorHSLRBGroup,this.oRGBorHSLRBUnifiedGroup,this.oLabelRGB,this.oLabelRGBA,this.oLabelHSL,this.oLabelHSV,this.oLabelHSLA,this.oLabelHSVA,this.oCPBoxGD,this.icOne,this.icTwo,this.rbg,this.swatches,this.comparissonFields,this.slidersComparissonFields,this.oSliderPhone,this.oAlphaSliderPhone];C.forEach(function(d){if(d){d.destroy();}},this);this._bLayoutControlsCreated=false;};
m.prototype.exit=function(){this._cleanup();};
m.prototype.onBeforeRendering=function(){this._cleanup();this._createLayout();this._updateControlVisualState();this._updateColorString();};
m.prototype._updateColorString=function(){this._parseColorString(this.getColorString());this.oHexField.setValue(this.Color.hex.substr(1));this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(this.Color.a);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);if(this.bResponsive){this.oRGBorHSLRBUnifiedGroup.setSelectedIndex(this.Color.formatHSL?1:0);}else{this.oRGBorHSLRBGroup.setSelectedIndex(this.Color.formatHSL?1:0);}}else{this.oValField.setValue(this.Color.v);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oAlphaField.setValue(this.Color.a);}this._updateColorStringProperty(true,true);};
m.prototype.isColor=function(C){return this._parseColorString(C,true);};
m.prototype._handleSliderChange=function(E,d){var i=parseInt(this.oSlider.getValue(),10);this.oHueField.setValue(i);this._processChanges();this._updateColorStringProperty(d==="change",d==="liveChange");};
m.prototype._handleAlphaSliderChange=function(E,d){this.Color.a=this.oAlphaSlider.getValue();if(this._bHSLMode){this.oAlphaField.setValue(this.Color.a);}if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(d==="change",d==="liveChange");};
m.prototype._getValueInRange=function(v,M,i){if(isNaN(v)){v=0;}return Math.min(Math.max(v,M),i);};
m.prototype._handleAlphaValueChange=function(){var d=parseFloat(this.oAlphaField.getValue(),10);d=this._getValueInRange(d,0,1);this.Color.a=d;this.oAlphaField.setValue(d);this.oAlphaSlider.setValue(d);if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(true,true);};
m.prototype._handleRGBorHSLValueChange=function(){var u=this.oRGBorHSLRBUnifiedGroup;this.Color.formatHSL=u?u.getSelectedIndex()===1:this.oRGBorHSLRBGroup.getSelectedIndex()===1;this._updateColorStringProperty(true,true);};
m.prototype._handleHueValueChange=function(){var d=parseInt(this.oHueField.getValue(),10);d=this._getValueInRange(d,0,360);this.oHueField.setValue(d);this.oSlider.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleSatValueChange=function(){var d=parseInt(this.oSatField.getValue(),10);d=this._getValueInRange(d,0,100);this.oSatField.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleValValueChange=function(){var v=parseInt(this.oValField.getValue(),10);v=this._getValueInRange(v,0,100);this.oValField.setValue(v);this._processHSVChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleLitValueChange=function(){var d=parseInt(this.oLitField.getValue(),10);d=this._getValueInRange(d,0,100);this.oLitField.setValue(d);this._processHSLChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleRedValueChange=function(){var d=parseInt(this.oRedField.getValue(),10);d=this._getValueInRange(d,0,255);this.oRedField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleGreenValueChange=function(){var d=parseInt(this.oGreenField.getValue(),10);d=this._getValueInRange(d,0,255);this.oGreenField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleBlueValueChange=function(){var d=parseInt(this.oBlueField.getValue(),10);d=this._getValueInRange(d,0,255);this.oBlueField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
m.prototype._processHSVChanges=function(){var d=parseInt(this.oHueField.getValue(),10);var i=parseInt(this.oSatField.getValue(),10);var v=parseInt(this.oValField.getValue(),10);this._calculateRGB(d,i,v);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=d;this.Color.s=i;this.Color.v=v;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oValField.setValue(this.Color.v);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};
m.prototype._processHSLChanges=function(){var i=parseInt(this.oHueField.getValue(),10),S=parseInt(this.oSatField.getValue(),10),d=parseInt(this.oLitField.getValue(),10);if(i>360){i%=360;}this._calculateRGB(i,S,d);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=i;this.Color.s=S;this.Color.l=d;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oLitField.setValue(this.Color.l);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();};
m.prototype._processRGBChanges=function(){var d=Math.round(parseInt(this.oRedField.getValue(),10)),i=Math.round(parseInt(this.oGreenField.getValue(),10)),t=Math.round(parseInt(this.oBlueField.getValue(),10)),u=(d+i+t)===765;this._calculateHEX(d,i,t);this.oHexField.setValue(this.sHexString);if(this._bHSLMode){this._calculateHSL(d,i,t);this.oLitField.setValue(this.Color.l);}else{if(!u){this._calculateHSV(d,i,t);}this.oValField.setValue(this.Color.v);}if(!u){this.oHueField.setValue(this.Color.h);}this.oSatField.setValue(this.Color.s);this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.Color.r=d;this.Color.g=i;this.Color.b=t;this.Color.hex="#"+this.oHexField.getValue();this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};
m.prototype._handleHexValueChange=function(){var d=this.oHexField.getValue().toLowerCase(),i=1,t;if(d.substr(0,1)==='#'){d=d.substr(1);}t=/^([0-9a-fA-F]{8})$/;if(t.test(d)!==false){i=Number((parseInt(d.substr(6,2),16)/255).toFixed(2));d=d.substr(0,6);}t=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;if(t.test(d)===false){this.oHexField.setValueState(j.Error);this.oSlider.setEnabled(false);this.oAlphaSlider.setEnabled(false);this.oHueField.setEnabled(false);this.oRedField.setEnabled(false);this.oGreenField.setEnabled(false);this.oBlueField.setEnabled(false);this.oSatField.setEnabled(false);if(this._bHSLMode){this.oLitField.setEnabled(false);this.oAlphaField.setEnabled(false);}else{this.oValField.setEnabled(false);}return;}else if(this.oHexField.getValueState()===j.Error){this.oHexField.setValueState(j.None);this.oSlider.setEnabled(true);this.oAlphaSlider.setEnabled(true);this.oHueField.setEnabled(true);this.oRedField.setEnabled(true);this.oGreenField.setEnabled(true);this.oBlueField.setEnabled(true);this.oSatField.setEnabled(true);if(this._bHSLMode){this.oLitField.setEnabled(true);this.oAlphaField.setEnabled(true);}else{this.oValField.setEnabled(true);}}if(d.length===3){d=d.charAt(0)+d.charAt(0)+d.charAt(1)+d.charAt(1)+d.charAt(2)+d.charAt(2);}this._processHexChanges(d);this.oHexField.setValue(d);this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(1);}else{this.oValField.setValue(this.Color.v);}this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.oAlphaSlider.setValue(i);this.Color.a=i;if(this._bHSLMode){this.oAlphaField.setValue(i);}this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();this._updateColorStringProperty(true,true);};
m.prototype._processHexChanges=function(d){this._convertRGB(d);if(this._bHSLMode){this._calculateHSL(this.Color.r,this.Color.g,this.Color.b);}else{this._calculateHSV(this.Color.r,this.Color.g,this.Color.b);}this.Color.hex="#"+d.toLowerCase();};
m.prototype._updateAlphaBackground=function(){var d=[this.Color.r,this.Color.g,this.Color.b].join(","),i=B+"(left,rgba("+d+",0),rgba("+d+",1)),url("+s+")";if(this.lastAlphaSliderGradient!==i){this.oAlphaSlider.$().find(this.bResponsive?".sapMSliderInner":".sapUiSliBar").css("background-image",i);this.lastAlphaSliderGradient=i;}};
m.prototype._updateCursorPosition=function(){var x,y;if(!this._iCPBoxSize){return;}if(this._bHSLMode){x=Math.round(this.oLitField.getValue()*this._iCPBoxSize/100.0);}else{x=Math.round(this.oValField.getValue()*this._iCPBoxSize/100.0);}if(sap.ui.getCore().getConfiguration().getRTL()){x=this._iCPBoxSize-x;}y=Math.round((1-this.oSatField.getValue()/100.0)*this._iCPBoxSize);x=Math.round(Math.max(x,0)-this._iCPCursorSize/2.0-1.0);y=Math.round(Math.max(y,0)-this._iCPCursorSize/2.0-1.0);this.$CPCur.css("left",x).css("top",y);};
m.prototype._calculateRGB=function(d,S,v){var t,u,w,M,x,C,i;if(this._bHSLMode){this._calculateRGBAdvanced(d,S,v);return;}d%=360;d/=60;S/=100;v/=100;C=v*S;x=C*(1-Math.abs(d%2-1));M=v-C;t=0;u=0;w=0;i=Math.floor(d);switch(i){case 0:t=C;u=x;break;case 1:t=x;u=C;break;case 2:u=C;w=x;break;case 3:u=x;w=C;break;case 4:t=x;w=C;break;case 5:t=C;w=x;break;default:t=0;w=0;u=0;break;}this.RGB.r=Math.floor((t+M)*255);this.RGB.g=Math.floor((u+M)*255);this.RGB.b=Math.floor((w+M)*255);};
m.prototype._calculateRGBAdvanced=function(d,S,t){var u,v,w,M,x,X,y,z,i;d=this._getValueInRange(d,0,360);d%=360;if(S>100){S=1;}else if(S<0){S=0;}else{S=S/100;}if(t>100){t=1;}else if(t<0){t=0;}else{t=t/100;}z=S*(1-Math.abs(2*t-1));y=255*(t-0.5*z);X=z*(1-Math.abs((d/60)%2-1));i=Math.floor(d/60);x=y+255*X;M=y+255*z;switch(i){case 0:u=M;v=x;w=y;break;case 1:u=x;v=M;w=y;break;case 2:u=y;v=M;w=x;break;case 3:u=y;v=x;w=M;break;case 4:u=x;v=y;w=M;break;case 5:u=M;v=y;w=x;break;default:u=0;v=0;w=0;break;}this.RGB.r=Math.round(u);this.RGB.g=Math.round(v);this.RGB.b=Math.round(w);};
m.prototype._getCSSColorString=function(){if(this.Color.formatHSL){if(this.Color.a<1){return"hsla("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%, "+this.Color.a+")";}else{return"hsl("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%)";}}if(this.Color.a<1){return"rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+", "+this.Color.a+")";}else{return"rgb("+this.Color.r+","+this.Color.g+","+this.Color.b+")";}};
m.prototype._calculateHEX=function(i,d,t){var u=i.toString(16),v=d.toString(16),w=t.toString(16);if(u.length===1){u='0'+u;}if(v.length===1){v='0'+v;}if(w.length===1){w='0'+w;}this.sHexString=(u+v+w).toLowerCase();};
m.prototype._calculateHSV=function(i,d,t){var u=Math.max(Math.max(i,d),t),v=Math.min(Math.min(i,d),t),w=u-v,x=Math.round(u*100/255),y=u===0.0?0:(100*w/u),z=0;if(y===0){z=0;}else if(i===u){z=60.0*(d-t)/w;}else if(d===u){z=120.0+60.0*(t-i)/w;}else if(t===u){z=240.0+60.0*(i-d)/w;}if(z<0.0){z+=359.9;}z=Math.round(z);y=Math.round(y);this.Color.h=z;this.Color.s=y;this.Color.v=x;};
m.prototype._calculateHSL=function(i,t,u){var v=Math.max(i,t,u),w=Math.min(i,t,u),d=(v-w)/255,x=(v+w)/510,y=1-Math.abs(2*x-1),z=(x===0.0)?0:d/y,A=(y!==0)?z:0,E=0;x=Math.round(x*100);A=Math.round(A*100);if(x===0||A===0||(i+t+u===765)){E=0;}else{var C=v-w;if(v===i){E=((t-u)/C)%6;}if(v===t){E=(u-i)/C+2;}if(v===u){E=(i-t)/C+4;}if(C===0){E=0;}E*=60;if(E<0){E+=360;}}if(E!==0||this.Color.h!==360){this.Color.h=Math.round(E);}this.Color.s=A;this.Color.l=x;};
m.prototype._convertRGB=function(d){this.Color.r=parseInt(d.substr(0,2),16);this.Color.g=parseInt(d.substr(2,2),16);this.Color.b=parseInt(d.substr(4,2),16);};
m.prototype._updateGradientBoxBackground=function(i){if(this._bHSLMode){this._calculateRGBAdvanced(i,100,50);}else{this._calculateRGB(i,100,100);}this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.$CPBox.css('background-color','rgb('+[this.RGB.r,this.RGB.g,this.RGB.b].join(",")+')');};
m.prototype._updateSelColorBackground=function(){this.$().find(".sapUiColorPicker-ColorPickerNewColor").css('background-color',this._getCSSColorString());};
m.prototype._parseColorString=function(C,d){var i;if(C.substr(0,1)==='#'){C=C.substr(1);}C=C.trim().toLowerCase();i=this._parseColorName(C);if(i){if(d){return true;}if(i.length===8){this.Color.a=this.Color.oldA=Number((parseInt(i.substr(6,2),16)/255).toFixed(2));i=i.substring(0,6);}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(C)){if(d){return true;}if(C.length===3){i=C[0]+C[0]+C[1]+C[1]+C[2]+C[2];}else{i=C;}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(C.substr(0,3)==='rgb'){return this._parseRGB(C,d);}if(this._bHSLMode){return this._parseHSL(C,d);}else if(C.substr(0,3)==='hsv'){return this._parseHSV(C,d);}return false;};
m.prototype._parseHSV=function(C,d){var i=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),)(((\d{1,2})|(100)),)((\d{1,2})|(100))$/,t,u,S,v;C=C.substr(3).replace("(",'').replace(")",'').split(' ').join('');if(i.test(C)===true){if(d){return true;}t=C.split(",");u=parseInt(t[0],10);S=parseInt(t[1],10);v=parseInt(t[2],10);this._calculateRGB(u,S,v);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=u;this.Color.s=S;this.Color.v=v;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;return true;}return false;};
m.prototype._parseHSL=function(C,d){var i,t=C.substr(0,4),u,v,S,w,A;if(t==="hsla"){u=true;}else if(t==="hsl("){u=false;}else{return false;}C=C.substr(u?4:3).replace("(",'').replace(")",'').split(' ').join('');i=C.split(",");v=parseInt(i[0],10);S=parseFloat(i[1]);w=parseFloat(i[2]);if(u){A=parseFloat(i[3]);}else{if(i[3]&&parseFloat(i[3])>=0){return false;}A=1;}S=(S<1&&S>0)?S*100:S;w=(w<1&&w>0)?w*100:w;if((v>=0&&v<=360)&&(S>=0&&S<=100)&&(w>=0&&w<=100)&&(A>=0&&A<=1)){if(d){return true;}this._calculateRGB(v,S,w);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=v;this.Color.s=S;this.Color.l=w;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.oldA=A;this.Color.formatHSL=true;}else{return false;}return true;};
m.prototype._parseRGB=function(C,d){var v,i,t,u;i=C.substring(0,4);if(i==="rgba"){u=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),)([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1])$/;t=true;}else if(i.substring(0,3)==="rgb"){u=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])))$/;t=false;}else{return false;}C=C.substr(t?4:3).replace("(",'').replace(")",'').split(' ').join('');if(u.test(C)){if(d){return true;}v=C.split(",");this._calculateHEX(parseInt(v[0],10),parseInt(v[1],10),parseInt(v[2],10));this._processHexChanges(this.sHexString);this.Color.old=this.Color.hex;if(t){this.Color.a=this.Color.oldA=parseFloat(v[3]);}return true;}if(this._bHSLMode){this.Color.formatHSL=false;}return false;};
m.prototype._parseColorName=function(C){return n.Colors[C];};
m.prototype.onAfterRendering=function(){var d=this._getCSSColorString(),i=this.getParent();this.$CPBox=this.oCPBox.$();this.$CPCur=this.oCPBox.getHandle();this.$().find(".sapUiColorPicker-ColorPickerNewColor").css('background-color',d);this.$().find(".sapUiColorPicker-ColorPickerOldColor").css('background-color',d);this._updateGradientBoxBackground(this.Color.h);this._iCPBoxSize=this.oCPBox.getWidth();this._updateCursorPosition();if(this._bHSLMode){this._updateAlphaBackground();}this.oSlider.iShiftGrip=Math.round(q(this.oSlider.oGrip).outerWidth()/2);this.oAlphaSlider.iShiftGrip=Math.round(q(this.oAlphaSlider.oGrip).outerWidth()/2);if(i&&i.getMetadata().getName()==="sap.m.Dialog"){i.addStyleClass("colorPickerDialog");}};
m.prototype.getRGB=function(){return{r:this.Color.r,g:this.Color.g,b:this.Color.b};};
m.prototype._getConstants=function(){return n;};
m.prototype._createCommonsColorPicker=function(d,i){d=new G({containerQuery:true,content:[this.oCPBox.setLayoutData(this.oCPBoxGD),new V({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED","R:"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN","G:"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE","B:"),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","#:")],layoutData:this.icOne}),new V({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE","H:"),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","S:","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","L:","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","A:").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE","V:").addStyleClass(n.HideForHSLClass)],layoutData:this.icTwo}).addStyleClass(n.LastColumnClass),new c({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")})],layoutData:this.swatches}).addStyleClass(n.SwatchesClass),new c({content:[F.createLabel({text:"Output:",labelFor:this.oRGBorHSLRBGroup}),this.oRGBorHSLRBGroup],layoutData:this.rbg}).addStyleClass(n.HideForHSVClass).addStyleClass(n.OutputSelectorRowClass),this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})),this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12"}))]}).addStyleClass(n.CPMatrixClass);return d;};
m.prototype._createUnifiedColorPicker=function(d,i){var t=this.getDisplayMode(),C;this.oLabelRGB=F.createLabel({text:"R G B"});this.oLabelRGBA=F.createLabel({text:"R G B A"});this.oLabelHSL=F.createLabel({text:"H S L"});this.oLabelHSV=F.createLabel({text:"H S V"});this.oLabelHSLA=F.createLabel({text:"H S L A"});this.oLabelHSVA=F.createLabel({text:"H S V A"});this.oLabelRGB.addStyleClass("colorModeLabels");this.oLabelRGBA.addStyleClass("colorModeLabels");this.oLabelHSL.addStyleClass("colorModeLabels");this.oLabelHSV.addStyleClass("colorModeLabels");this.oLabelHSLA.addStyleClass("colorModeLabels");this.oLabelHSVA.addStyleClass("colorModeLabels");C=new V({content:[new c({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED").addStyleClass("noMargin"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE"),this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","").addStyleClass("hsvMargin")]}),new c({content:[this.oLabelRGBA]}),new c({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE",""," ").addStyleClass("noMargin"),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE",""," ").addStyleClass(n.HideForHSLClass),this._createRowFromInput(this.oAlphaFieldHSL,"COLORPICKER_ALPHA","").addStyleClass("hsvMargin")]}).addStyleClass("defaultPickerDisplayNone"),new c({content:[this.oLabelHSLA.addStyleClass(n.HideForHSVClass),this.oLabelHSVA.addStyleClass(n.HideForHSLClass)]}).addStyleClass("defaultPickerDisplayNone")]});this.oHLayoutDefault=new c({content:[C,new V({content:new sap.m.Button(i+"-toggleMode",{type:D.system.phone?"Default":"Transparent",tooltip:"Toggle color mode",icon:"sap-icon://source-code",press:function(E){this.bPressed=!this.bPressed;C.getContent()[0].toggleStyleClass("defaultPickerDisplayNone",this.bPressed);C.getContent()[1].toggleStyleClass("defaultPickerDisplayNone",this.bPressed);C.getContent()[2].toggleStyleClass("defaultPickerDisplayNone",!this.bPressed);C.getContent()[3].toggleStyleClass("defaultPickerDisplayNone",!this.bPressed);}})})],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass("colors");this.comparissonFields=new V({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")})]}).addStyleClass("comparisonFields");this.slidersComparissonFields=new c({content:[new V({content:[this.oSlider.setLayoutData(this.oSliderPhone=new b({span:"L6 M6 S12",linebreak:true})),t!==l.Simplified?this.oAlphaSlider.setLayoutData(this.oAlphaSliderPhone=new b({span:"L6 M6 S12",linebreak:true})):this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","").addStyleClass("simplifiedHex"),t==l.Simplified?new c({content:[F.createLabel({text:"Hex"})]}):null]}).addStyleClass("phoneSliders"),this.comparissonFields]}).addStyleClass("phoneContent");if(D.system.phone&&!q('html').hasClass("sapUiMedia-Std-Tablet")){d=new G({content:[this.oCPBox.setLayoutData(this.oCPBoxGD).addStyleClass("sapUiColorPickerCPBoxGrid")]}).addStyleClass(n.CPMatrixClass).addStyleClass("phoneGrid");if(t!==l.Large){d.addContent(this.slidersComparissonFields);}else{d.addContent(this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})));d.addContent(this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})));d.addContent(new c({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")}),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","Hex")],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass(n.SwatchesClass));d.addContent(this.oHLayoutLarge=new c({content:[new V({content:[this.oRGBorHSLRBUnifiedGroup]}),new V({content:[new c({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE")]}),new c({content:[this.oLabelRGB]}),new c({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE",""," "),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE").addStyleClass(n.HideForHSLClass)]}),new c({content:[this.oLabelHSL.addStyleClass(n.HideForHSVClass),this.oLabelHSV.addStyleClass(n.HideForHSLClass)]})]}),new V({content:[this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","").addStyleClass("hsvMargin"),F.createLabel({text:"A"}).addStyleClass("labelA")]})],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass("colors"));}if(t!==l.Simplified&&t!==l.Large){d.addContent(this.oHLayoutDefault);}}else{d=new G({containerQuery:true,content:[this.oCPBox.setLayoutData(this.oCPBoxGD).addStyleClass("sapUiColorPickerCPBoxGrid"),this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true}))]}).addStyleClass(n.CPMatrixClass);if(t!==l.Simplified){d.addContent(this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})));}d.addContent(this.oHLayoutSwatches=new c({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")}),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","Hex")],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass(n.SwatchesClass));if(t===l.Default){d.addContent(this.oHLayoutDefault);}if(t===l.Large){d.addContent(this.oHLayoutLarge=new c({content:[new V({content:[this.oRGBorHSLRBUnifiedGroup]}),new V({content:[new c({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE")]}),new c({content:[this.oLabelRGB]}),new c({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE",""," "),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE").addStyleClass(n.HideForHSLClass)]}),new c({content:[this.oLabelHSL.addStyleClass(n.HideForHSVClass),this.oLabelHSV.addStyleClass(n.HideForHSLClass)]})]}),new V({content:[this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","").addStyleClass("hsvMargin"),F.createLabel({text:"A"}).addStyleClass("labelA")]})],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass("colors"));}}return d;};
return m;});
sap.ui.predefine('sap/ui/unified/ColorPickerRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){r.write("<div");r.writeControlData(c);if(c.bResponsive){r.addClass("sapUiColorPicker-"+c.getDisplayMode());}r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_grid"));r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/ContentSwitcher',['sap/ui/core/Control','./library',"./ContentSwitcherRenderer","sap/base/Log"],function(C,l,a,L){"use strict";var b=l.ContentSwitcherAnimation;
var c=C.extend("sap.ui.unified.ContentSwitcher",{metadata:{deprecated:true,library:"sap.ui.unified",properties:{animation:{type:"string",group:"Appearance",defaultValue:'None'},activeContent:{type:"int",group:"Behavior",defaultValue:1}},aggregations:{content1:{type:"sap.ui.core.Control",multiple:true,singularName:"content1"},content2:{type:"sap.ui.core.Control",multiple:true,singularName:"content2"}}}});
(function(w){
c.prototype.init=function(){};
c.prototype.switchContent=function(){this.setActiveContent(this.getActiveContent()==1?2:1);return this;};
c.prototype.onAfterRendering=function(){this._$Contents=[this.$("content1"),this.$("content2")];};
c.prototype._showActiveContent=function(n){if(this._$Contents){this._$Contents[0].toggleClass("sapUiUfdCSwitcherVisible",n===1);this._$Contents[1].toggleClass("sapUiUfdCSwitcherVisible",n===2);}};
c.prototype.setActiveContent=function(n){n=parseInt(n,10);if(isNaN(n)||n<1){n=1;L.warning("setActiveContent argument must be either 1 or 2. Active content set to 1.");}else if(n>2){n=2;L.warning("setActiveContent argument must be either 1 or 2. Active content set to 2.");}this.setProperty("activeContent",n,true);this._showActiveContent(n);return this;};
c.prototype.setAnimation=function(A,s){if(typeof(A)!=="string"){A=b.None;L.warning("setAnimation argument must be a string. Animation was set to \""+b.None+"\".");}A=A.replace(/[^a-zA-Z0-9]/g,"");var d=this.getProperty("animation");if(A===d){return this;}var D=this.$();if(D[0]){D.toggleClass("sapUiUfdCSwitcherAnimation"+d,false);D.toggleClass("sapUiUfdCSwitcherAnimation"+A,true);}return this.setProperty("animation",A,s);};
})(window);return c;});
sap.ui.predefine('sap/ui/unified/ContentSwitcherRenderer',['sap/ui/unified/library',"sap/base/security/encodeXML"],function(l,e){"use strict";var C=l.ContentSwitcherAnimation;var a={};
a.render=function(r,c){var i=c.getId();var A=c.getAnimation();if(!sap.ui.getCore().getConfiguration().getAnimation()){A=C.None;}var b=c.getActiveContent();r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdCSwitcher");r.addClass("sapUiUfdCSwitcherAnimation"+e(A));r.writeClasses();r.write(">");r.write("<section id=\""+i+"-content1\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1"+(b==1?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent1());r.write("</section>");r.write("<section id=\""+i+"-content2\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2"+(b==2?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent2());r.write("</section>");r.write("</div>");};
a.renderContent=function(r,c){for(var i=0;i<c.length;++i){r.renderControl(c[i]);}};
return a;},true);
sap.ui.predefine('sap/ui/unified/Currency',['sap/ui/core/Control','sap/ui/core/format/NumberFormat',"./CurrencyRenderer","sap/ui/thirdparty/jquery"],function(C,N,a,q){"use strict";
var b=C.extend("sap.ui.unified.Currency",{metadata:{library:"sap.ui.unified",properties:{value:{type:"float",group:"Appearance",defaultValue:0},stringValue:{type:"string",group:"Appearance",defaultValue:null},currency:{type:"string",group:"Appearance",defaultValue:null},maxPrecision:{type:"int",group:"Appearance",defaultValue:3},useSymbol:{type:"boolean",group:"Appearance",defaultValue:true}},designtime:"sap/ui/unified/designtime/Currency.designtime"}});
b.FIGURE_SPACE='\u2007';b.PUNCTUATION_SPACE='\u2008';
b.prototype.init=function(){this._oFormat=N.getCurrencyInstance({showMeasure:false});};
b.prototype.exit=function(){this._oFormat=null;this._$Value=null;this._$Currency=null;this._sLastCurrency=null;this._iLastCurrencyDigits=null;this._bRenderNoValClass=null;};
b.prototype.onAfterRendering=function(){if(this.$()){this._$Value=this.$().find(".sapUiUfdCurrencyValue");this._$Currency=this.$().find(".sapUiUfdCurrencyCurrency");}};
b.prototype.setValue=function(v){if(this.isBound("value")){this._bRenderNoValClass=v==null;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",this._bRenderNoValClass);}}this.setProperty("value",v,true);this._renderValue();return this;};
b.prototype.unbindProperty=function(p){C.prototype.unbindProperty.apply(this,arguments);if(p==="value"){this._bRenderNoValClass=false;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}};
b.prototype.setCurrency=function(v){var c,r;this.setProperty("currency",v,true);this._renderCurrency();c=this._oFormat.oLocaleData.getCurrencyDigits(v);if(q.isNumeric(this._iLastCurrencyDigits)&&this._iLastCurrencyDigits!==c){r=true;}this._iLastCurrencyDigits=c;if(this._sLastCurrency==="*"||v==="*"){r=true;}this._sLastCurrency=v;if(r){this._renderValue();if(v==="*"&&this.$()){this._bRenderNoValClass=false;this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}return this;};
b.prototype.setUseSymbol=function(v){this.setProperty("useSymbol",v,true);this._renderCurrency();return this;};
b.prototype.setMaxPrecision=function(v){this.setProperty("maxPrecision",v,true);this._renderValue();return this;};
b.prototype._renderValue=function(){if(this._$Value){this._$Value.text(this.getFormattedValue());}};
b.prototype._renderCurrency=function(){if(this._$Currency){this._$Currency.text(this._getCurrency());}};
b.prototype._getCurrency=function(){return this.getUseSymbol()?this.getCurrencySymbol():this.getCurrency();};
b.prototype.getFormattedValue=function(){var c=this.getCurrency(),m,p,i,f;if(c==="*"){return"";}i=this._oFormat.oLocaleData.getCurrencyDigits(c);m=this.getMaxPrecision();m=(m<=0&&i>0?m-1:m);p=m-i;f=this._oFormat.format(this.getStringValue()||this.getValue(),c);if(p==m&&m>0){f+=b.PUNCTUATION_SPACE;}if(p>0){f=f.padEnd(f.length+p,b.FIGURE_SPACE);}else if(p<0){f=f.substr(0,f.length+p);}return f;};
b.prototype.getCurrencySymbol=function(){return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency());};
b.prototype.getAccessibilityInfo=function(){if(this._bRenderNoValClass){return{};}return{description:(this.getFormattedValue()||"")+" "+(this.getCurrency()||"").trim()};};
return b;});
sap.ui.predefine('sap/ui/unified/CurrencyRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){var t=c.getTooltip_AsString();r.write("<div");r.writeControlData(c);if(t){r.writeAttributeEscaped("title",t);}r.addClass("sapUiUfdCurrency");if(c._bRenderNoValClass){r.addClass("sapUiUfdCurrencyNoVal");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiUfdCurrencyAlign");r.writeClasses();r.write(">");r.write("<span");r.writeAttribute("dir","ltr");r.addClass("sapUiUfdCurrencyValue");r.writeClasses();r.write(">");r.writeEscaped(c.getFormattedValue());r.write("</span>");r.write("<span");r.addClass("sapUiUfdCurrencyCurrency");r.writeClasses();r.write(">");r.writeEscaped(c._getCurrency());r.write("</span>");r.write("</div>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/DateRange',['sap/ui/core/Element','./library','sap/ui/unified/calendar/CalendarUtils'],function(E,l,C){"use strict";
var D=E.extend("sap.ui.unified.DateRange",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Misc",defaultValue:null},endDate:{type:"object",group:"Misc",defaultValue:null}}}});
D.prototype.setStartDate=function(d){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("startDate",d);return this;};
D.prototype.setEndDate=function(d){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("endDate",d);return this;};
return D;});
sap.ui.predefine('sap/ui/unified/DateTypeRange',['./DateRange','./library'],function(D,l){"use strict";var C=l.CalendarDayType;
var a=D.extend("sap.ui.unified.DateTypeRange",{metadata:{library:"sap.ui.unified",properties:{type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:C.Type01}}}});
return a;});
sap.ui.predefine('sap/ui/unified/FileUploader',['sap/ui/core/Control','./library','sap/ui/core/LabelEnablement','sap/ui/core/library','sap/ui/Device','./FileUploaderRenderer','sap/ui/dom/containsOrEquals','sap/ui/events/KeyCodes','sap/base/Log','sap/base/security/encodeXML',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/Aria'],function(C,a,L,c,D,F,b,K,d,f,q){"use strict";var V=c.ValueState;
var g=C.extend("sap.ui.unified.FileUploader",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.unified.IProcessableBlobs"],library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/FileUploader.designtime",properties:{value:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"sap.ui.core.URI",group:"Data",defaultValue:''},name:{type:"string",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:''},uploadOnChange:{type:"boolean",group:"Behavior",defaultValue:false},additionalData:{type:"string",group:"Data",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},buttonText:{type:"string",group:"Misc",defaultValue:null},fileType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},sendXHR:{type:"boolean",group:"Behavior",defaultValue:false},placeholder:{type:"string",group:"Appearance",defaultValue:null},style:{type:"string",group:"Appearance",defaultValue:null},buttonOnly:{type:"boolean",group:"Appearance",defaultValue:false},useMultipart:{type:"boolean",group:"Behavior",defaultValue:true},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconHovered:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconSelected:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},iconOnly:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{parameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"parameter"},headerParameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"headerParameter"},xhrSettings:{type:"sap.ui.unified.FileUploaderXHRSettings",multiple:false}},events:{change:{parameters:{newValue:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{fileName:{type:"string"},response:{type:"string"},readyStateXHR:{type:"string"},status:{type:"string"},responseRaw:{type:"string"},headers:{type:"object"},requestHeaders:{type:"object[]"}}},typeMissmatch:{parameters:{fileName:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"}}},fileSizeExceed:{parameters:{fileName:{type:"string"},fileSize:{type:"string"}}},fileAllowed:{},uploadProgress:{parameters:{lengthComputable:{type:"boolean"},loaded:{type:"float"},total:{type:"float"},fileName:{type:"string"},requestHeaders:{type:"object[]"}}},uploadAborted:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}},filenameLengthExceed:{parameters:{fileName:{type:"string"}}},uploadStart:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}}}}});
g.prototype.init=function(){this.oFilePath=a.FileUploaderHelper.createTextField(this.getId()+"-fu_input");this.oBrowse=a.FileUploaderHelper.createButton();this.oFilePath.setParent(this);this.oBrowse.setParent(this);this.oFileUpload=null;this.bMobileLib=this.oBrowse.getMetadata().getName()=="sap.m.Button";if(!this.getIconOnly()){this.oBrowse.setText(this.getBrowseText());}else{this.oBrowse.setTooltip(this.getBrowseText());}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(!g.prototype._sAccText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");g.prototype._sAccText=r.getText("FILEUPLOAD_ACC");}if(this.oBrowse.addAriaDescribedBy){this.oBrowse.addAriaDescribedBy(this.getId()+"-AccDescr");}}};
g.prototype.setButtonText=function(t){this.setProperty("buttonText",t,false);if(!this.getIconOnly()){this.oBrowse.setText(t||this.getBrowseText());}else{this.oBrowse.setTooltip(t||this.getBrowseText());}return this;};
g.prototype.setIcon=function(i){this.oBrowse.setIcon(i);this.setProperty("icon",i,false);return this;};
g.prototype.setIconHovered=function(i){this.setProperty("iconHovered",i,false);if(this.oBrowse.setIconHovered){this.oBrowse.setIconHovered(i);}return this;};
g.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,false);if(this.oBrowse.setIconSelected){this.oBrowse.setIconSelected(i);}else{this.oBrowse.setActiveIcon(i);}return this;};
g.prototype.setIconFirst=function(i){this.oBrowse.setIconFirst(i);this.setProperty("iconFirst",i,false);return this;};
g.prototype.setIconOnly=function(i){this.setProperty("iconOnly",i,false);if(i){this.oBrowse.setText("");this.oBrowse.setTooltip(this.getButtonText()||this.getBrowseText());}else{this.oBrowse.setText(this.getButtonText()||this.getBrowseText());this.oBrowse.setTooltip("");}return this;};
g.prototype.getIdForLabel=function(){return this.oBrowse.getId();};
g.prototype.setFileType=function(t){var T=this._convertTypesToArray(t);this.setProperty("fileType",T,false);return this;};
g.prototype.setMimeType=function(t){var T=this._convertTypesToArray(t);this.setProperty("mimeType",T,false);return this;};
g.prototype.setTooltip=function(t){var T,s;this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(this.oFileUpload){if(typeof t==="string"){T=this.getTooltip_AsString();s=this.$().find(".sapUiFupInputMask")[0];if(T){this.oFileUpload.setAttribute("title",T);s&&s.setAttribute("title",T);}else{this.oFileUpload.removeAttribute("title");s&&s.removeAttribute("title");}}}return this;};
g.prototype.setXhrSettings=function(x){this.setAggregation("xhrSettings",x,true);return this;};
g.prototype._convertTypesToArray=function(t){if(typeof t==="string"){if(t===""){return[];}else{return t.split(",").map(function(T){return T.trim();});}}return t;};
g.prototype.exit=function(){this.oFilePath.destroy();this.oBrowse.destroy();if(this.oIFrameRef){q(this.oIFrameRef).unbind();sap.ui.getCore().getStaticAreaRef().removeChild(this.oIFrameRef);this.oIFrameRef=null;}};
g.prototype.onBeforeRendering=function(){var s=sap.ui.getCore().getStaticAreaRef();q(this.oFileUpload).appendTo(s);q(this.oFileUpload).unbind();};
g.prototype.onAfterRendering=function(){this.prepareFileUploadAndIFrame();this._cacheDOMEls();this._addLabelFeaturesToBrowse();q(this.oFileUpload).change(q.proxy(this.handlechange,this));if(!this.bMobileLib){this.oFilePath.$().attr("tabindex","-1");}else{this.oFilePath.$().find('input').attr("tabindex","-1");}if((!!D.browser.internet_explorer&&D.browser.version==9)){this.oBrowse.$().attr("tabindex","-1");}if(L.isRequired(this)){this.oBrowse.$().attr("aria-required","true");}setTimeout(this._recalculateWidth.bind(this),0);this.oFilePath.$().find('input').removeAttr("role").attr("aria-live","polite");if(this.getValueState()==V.Error){this.oBrowse.$().attr("aria-invalid","true");}};
g.prototype._cacheDOMEls=function(){this.FUEl=this.getDomRef("fu");this.FUDataEl=this.getDomRef("fu_data");};
g.prototype.onfocusin=function(e){if(!this.oFilePath.shouldValueStateMessageBeOpened||this.oFilePath.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
g.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!b(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){this.closeValueStateMessage();}};
g.prototype._recalculateWidth=function(){if(this.getWidth()){if(this.getButtonOnly()&&this.oBrowse.getDomRef()){this.oBrowse.getDomRef().style.width=this.getWidth();}this._resizeDomElements();}};
g.prototype.getFocusDomRef=function(){return this.$("fu").get(0);};
g.prototype._resizeDomElements=function(){var i=this.getId();this._oBrowseDomRef=this.oBrowse.getDomRef();var $=q(this._oBrowseDomRef);var _=$.parent().outerWidth(true);this._oFilePathDomRef=this.oFilePath.getDomRef();var o=this._oFilePathDomRef;var w=this.getWidth();if(w.substr(-1)=="%"&&o){while(o.id!=i){o.style.width="100%";o=o.parentNode;}o.style.width=w;}else{if(o){o.style.width=w;var e=q(this._oFilePathDomRef);var h=e.outerWidth()-_;if(h<0){this.oFilePath.getDomRef().style.width="0px";if(!D.browser.internet_explorer){this.oFileUpload.style.width=$.outerWidth(true);}}else{this.oFilePath.getDomRef().style.width=h+"px";}}}};
g.prototype.onresize=function(){this._recalculateWidth();};
g.prototype.onThemeChanged=function(){this._recalculateWidth();};
g.prototype.setEnabled=function(e){var $=q(this.oFileUpload);this.setProperty("enabled",e,true);this.oFilePath.setEnabled(e);this.oBrowse.setEnabled(e);e?$.removeAttr('disabled'):$.attr('disabled','disabled');this.$().toggleClass("sapUiFupDisabled",!e);return this;};
g.prototype.setValueState=function(v){this.setProperty("valueState",v,true);if(this.oFilePath.setValueState){this.oFilePath.setValueState(v);}else{d.warning("Setting the valueState property with the combination of libraries used is not supported.",this);}if(this.oBrowse.getDomRef()){if(v==V.Error){this.oBrowse.$().attr("aria-invalid","true");}else{this.oBrowse.$().removeAttr("aria-invalid");}}if(b(this.getDomRef(),document.activeElement)){switch(v){case V.Error:case V.Warning:case V.Success:this.openValueStateMessage();break;default:this.closeValueStateMessage();}}return this;};
g.prototype.setValueStateText=function(v){if(this.oFilePath.setValueStateText){this.oFilePath.setValueStateText(v);}else{d.warning("Setting the valueStateText property with the combination of libraries used is not supported.",this);}return this.setProperty("valueStateText",v,true);};
g.prototype.setUploadUrl=function(v,e){this.setProperty("uploadUrl",v,true);var $=this.$("fu_form");$.attr("action",this.getUploadUrl());return this;};
g.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);this.oFilePath.setPlaceholder(p);return this;};
g.prototype.setStyle=function(s){this.setProperty("style",s,true);if(s){if(s=="Transparent"){if(this.oBrowse.setLite){this.oBrowse.setLite(true);}else{this.oBrowse.setType("Transparent");}}else{if(this.oBrowse.setType){this.oBrowse.setType(s);}else{if(s=="Emphasized"){s="Emph";}this.oBrowse.setStyle(s);}}}return this;};
g.prototype.setValue=function(v,e,s){var o=this.getValue();var h;if((o!=v)||this.getSameFilenameAllowed()){var u=this.getUploadOnChange()&&v;this.setProperty("value",v,u);if(this.oFilePath){this.oFilePath.setValue(v);if(this.oBrowse.getDomRef()&&!s&&b(this.getDomRef(),document.activeElement)){this.oBrowse.focus();}}var i=this.getDomRef("fu_form"),j=this.getDomRef("fu_input-inner");if(this.oFileUpload&&i&&!v){i.reset();this.getDomRef("fu_input").value="";if(j){j.value="";}q(this.FUDataEl).val(this.getAdditionalData());}if(e){if(window.File){h=this.FUEl.files;}if(!this.getSameFilenameAllowed()||v){this.fireChange({id:this.getId(),newValue:v,files:h});}}if(u){this.upload();}}return this;};
g.prototype.clear=function(){var u=this.getDomRef("fu_form");if(u){u.reset();}return this.setValue("",false,true);};
g.prototype.onmousedown=function(e){if(!this.bMobileLib){this.oBrowse.onmousedown(e);}};
g.prototype.onmouseup=function(e){if(!this.bMobileLib){this.oBrowse.onmouseup(e);}};
g.prototype.onmouseover=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).addClass('sapUiBtnStdHover');this.oBrowse.onmouseover(e);}};
g.prototype.onmouseout=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdHover');this.oBrowse.onmouseout(e);}};
g.prototype.setAdditionalData=function(A){this.setProperty("additionalData",A,true);var o=this.FUDataEl;if(o){A=this.getAdditionalData()||"";o.value=A;}return this;};
g.prototype.sendFiles=function(x,I){var t=this;var A=true;for(var i=0;i<x.length;i++){if(!x[i].bPosted){A=false;break;}}if(A){if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){t.setValue("",true);}return;}var X=x[I];var s=X.file.name?X.file.name:"MultipartFile";if((D.browser.edge||D.browser.internet_explorer)&&X.file.type&&X.xhr.readyState==1){var e=X.file.type;X.xhr.setRequestHeader("Content-Type",e);X.requestHeaders.push({name:"Content-Type",value:e});}var r=X.requestHeaders;var p=function(P){var o={lengthComputable:!!P.lengthComputable,loaded:P.loaded,total:P.total};t.fireUploadProgress({"lengthComputable":o.lengthComputable,"loaded":o.loaded,"total":o.total,"fileName":s,"requestHeaders":r});};X.xhr.upload.addEventListener("progress",p);X.xhr.onreadystatechange=function(){var R;var h;var H={};var P;var j;var k;var l;l=X.xhr.readyState;var S=X.xhr.status;if(X.xhr.readyState==4){if(X.xhr.responseXML){R=X.xhr.responseXML.documentElement.textContent;}h=X.xhr.response;P=X.xhr.getAllResponseHeaders();if(P){j=P.split("\u000d\u000a");for(var i=0;i<j.length;i++){if(j[i]){k=j[i].indexOf("\u003a\u0020");H[j[i].substring(0,k)]=j[i].substring(k+2);}}}t.fireUploadComplete({"fileName":s,"headers":H,"response":R,"responseRaw":h,"readyStateXHR":l,"status":S,"requestHeaders":r});}t._bUploading=false;};if(X.xhr.readyState===0||X.bPosted){I++;t.sendFiles(x,I);}else{X.xhr.send(X.file);X.bPosted=true;I++;t.sendFiles(x,I);}};
g.prototype.upload=function(p){if(!this.getEnabled()){return;}var u=this.getDomRef("fu_form");try{this._bUploading=true;if(this.getSendXHR()&&window.File){var e=this.FUEl.files;if(p){this._sendProcessedFilesWithXHR(e);}else{this._sendFilesWithXHR(e);}}else if(u){u.submit();this._resetValueAfterUploadStart();}}catch(E){d.error("File upload failed:\n"+E.message);}};
g.prototype.abort=function(h,H){if(!this.getUseMultipart()){var s=this._aXhr.length-1;for(var i=s;i>-1;i--){if(h&&H){for(var j=0;j<this._aXhr[i].requestHeaders.length;j++){var e=this._aXhr[i].requestHeaders[j].name;var v=this._aXhr[i].requestHeaders[j].value;if(e==h&&v==H){this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);d.info("File upload aborted.");break;}}}else{this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);d.info("File upload aborted.");}}}else if(this._uploadXHR&&this._uploadXHR.abort){this._uploadXHR.abort();this.fireUploadAborted({"fileName":null,"requestHeaders":null});d.info("File upload aborted.");}};
g.prototype.onkeypress=function(e){this.onkeydown(e);};
g.prototype.onclick=function(e){if(this.getSameFilenameAllowed()&&this.getEnabled()){this.setValue("",true);}if(this.oBrowse.getDomRef()&&b(this.getDomRef(),document.activeElement)){this.oBrowse.focus();}};
g.prototype.onkeydown=function(e){if(!this.getEnabled()){return;}if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){this.setValue("",true);}var k=e.keyCode,h=K;if(k==h.DELETE||k==h.BACKSPACE){if(this.oFileUpload){this.setValue("",true);}}else if(k==h.SPACE||k==h.ENTER){if(!(!!D.browser.internet_explorer&&D.browser.version<=9)&&this.oFileUpload){this.oFileUpload.click();e.preventDefault();e.stopPropagation();}}else if(k!=h.TAB&&k!=h.SHIFT&&k!=h.F6&&k!=h.PAGE_UP&&k!=h.PAGE_DOWN&&k!=h.ESCAPE&&k!=h.END&&k!=h.HOME&&k!=h.ARROW_LEFT&&k!=h.ARROW_UP&&k!=h.ARROW_RIGHT&&k!=h.ARROW_DOWN){e.preventDefault();e.stopPropagation();}};
g.prototype._isFilenameTooLong=function(s){var m=this.getMaximumFilenameLength();if(m!==0&&s.length>m){d.info("The filename of "+s+" ("+s.length+" characters)  is longer than the maximum of "+m+" characters.");return true;}return false;};
g.prototype.handlechange=function(e){if(this.oFileUpload&&this.getEnabled()){var h=this.getFileType();var s='';var w,n,i,j;var u=this.getDomRef("fu_form");if(window.File){var k=e.target.files;if(this._areFilesAllowed(k)){this.fireFileAllowed();s=this._generateInputValue(k);}else{u.reset();this.setValue("",true,true);return;}}else if(h&&h.length>0){w=true;n=this.oFileUpload.value||"";i=n.lastIndexOf(".");j=(i===-1)?"":n.substring(i+1);for(var l=0;l<h.length;l++){if(j==h[l]){w=false;}}if(w){d.info("File: "+n+" is of type "+j+". Allowed types are: "+h+".");this.fireTypeMissmatch({fileName:n,fileType:j});u.reset();this.setValue("",true,true);return;}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});u.reset();this.setValue("",true,true);return;}if(n){this.fireFileAllowed();}}var v=this.oFileUpload.value||"";var I=v.lastIndexOf("\\");if(I>=0){v=v.substring(I+1);}if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){v=s;}}if(v||D.browser.chrome){this.setValue(v,true);}}};
g.prototype._sendFilesWithXHR=function(e){var h,H,v,x,X=this.getXhrSettings();if(e.length>0){if(this.getUseMultipart()){h=1;}else{h=e.length;}this._aXhr=this._aXhr||[];for(var j=0;j<h;j++){this._uploadXHR=new window.XMLHttpRequest();x={xhr:this._uploadXHR,requestHeaders:[]};this._aXhr.push(x);x.xhr.open("POST",this.getUploadUrl(),true);if(X){x.xhr.withCredentials=X.getWithCredentials();}if(this.getHeaderParameters()){var n=this.getHeaderParameters();for(var i=0;i<n.length;i++){H=n[i].getName();v=n[i].getValue();x.requestHeaders.push({name:H,value:v});}}var s=e[j].name;var r=x.requestHeaders;x.fileName=s;x.file=e[j];this.fireUploadStart({"fileName":s,"requestHeaders":r});for(var k=0;k<r.length;k++){if(x.xhr.readyState===0){break;}H=r[k].name;v=r[k].value;x.xhr.setRequestHeader(H,v);}}if(this.getUseMultipart()){var o=new window.FormData();var p=this.FUEl.name;for(var l=0;l<e.length;l++){this._appendFileToFormData(o,p,e[l]);}o.append("_charset_","UTF-8");var t=this.FUDataEl.name;if(this.getAdditionalData()){var u=this.getAdditionalData();o.append(t,u);}else{o.append(t,"");}if(this.getParameters()){var P=this.getParameters();for(var m=0;m<P.length;m++){var N=P[m].getName();v=P[m].getValue();o.append(N,v);}}x.file=o;this.sendFiles(this._aXhr,0);}else{this.sendFiles(this._aXhr,0);}this._bUploading=false;this._resetValueAfterUploadStart();}return this;};
g.prototype._appendFileToFormData=function(o,s,e){if(e instanceof window.Blob&&e.name){o.append(s,e,e.name);}else{o.append(s,e);}};
g.prototype._sendProcessedFilesWithXHR=function(e){this.getProcessedBlobsFromArray(e).then(function(B){this._sendFilesWithXHR(B);}.bind(this)).catch(function(r){d.error("File upload failed: "+r&&r.message?r.message:"no details available");});return this;};
g.prototype._areFilesAllowed=function(e){var n,w,I,s,t,m=this.getMaximumFileSize(),M=this.getMimeType(),h=this.getFileType();for(var i=0;i<e.length;i++){n=e[i].name;t=e[i].type;if(!t){t="unknown";}var S=((e[i].size/1024)/1024);if(m&&(S>m)){d.info("File: "+n+" is of size "+S+" MB which exceeds the file size limit of "+m+" MB.");this.fireFileSizeExceed({fileName:n,fileSize:S});return false;}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});return false;}if(M&&M.length>0){var W=true;for(var j=0;j<M.length;j++){if(t==M[j]||M[j]=="*/*"||t.match(M[j])){W=false;}}if(W){d.info("File: "+n+" is of type "+t+". Allowed types are: "+M+".");this.fireTypeMissmatch({fileName:n,mimeType:t});return false;}}if(h&&h.length>0){w=true;I=n.lastIndexOf(".");s=(I===-1)?"":n.substring(I+1);for(var k=0;k<h.length;k++){if(s.toLowerCase()==h[k].toLowerCase()){w=false;}}if(w){d.info("File: "+n+" is of type "+s+". Allowed types are: "+h+".");this.fireTypeMissmatch({fileName:n,fileType:s});return false;}}}return true;};
g.prototype._sendFilesFromDragAndDrop=function(e){if(this._areFilesAllowed(e)){this._sendFilesWithXHR(e);}return this;};
g.prototype._generateInputValue=function(e){var s="";for(var i=0;i<e.length;i++){s=s+'"'+e[i].name+'" ';}return s;};
g.prototype.getBrowseText=function(){if(!g.prototype._sBrowseText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");g.prototype._sBrowseText=r.getText("FILEUPLOAD_BROWSE");}return g.prototype._sBrowseText?g.prototype._sBrowseText:"Browse...";};
g.prototype.getShortenValue=function(){return this.getValue();};
g.prototype.prepareFileUploadAndIFrame=function(){if(!this.oFileUpload){var e=[];e.push('<input ');e.push('type="file" ');e.push('aria-hidden="true" ');if(this.getName()){if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){e.push('name="'+this.getName()+'[]" ');}}else{e.push('name="'+this.getName()+'" ');}}else{if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){e.push('name="'+this.getId()+'[]" ');}}else{e.push('name="'+this.getId()+'" ');}}e.push('id="'+this.getId()+'-fu" ');if(!(!!D.browser.internet_explorer&&D.browser.version==9)){e.push('tabindex="-1" ');}e.push('size="1" ');if(this.getTooltip_AsString()){e.push('title="'+f(this.getTooltip_AsString())+'" ');}else if(this.getValue()!==""){e.push('title="'+f(this.getValue())+'" ');}if(!this.getEnabled()){e.push('disabled="disabled" ');}if(this.getMultiple()){if(!(D.browser.internet_explorer&&D.browser.version<=9)){e.push('multiple ');}}if(this.getMimeType()&&window.File){var m=this.getMimeType();var M=m.join(",");e.push('accept="'+M+'" ');}e.push('>');this.oFileUpload=q(e.join("")).prependTo(this.$().find(".sapUiFupInputMask")).get(0);}else{q(this.oFileUpload).prependTo(this.$().find(".sapUiFupInputMask"));}if(!this.oIFrameRef){var i=document.createElement("iframe");i.style.display="none";i.id=this.sId+"-frame";sap.ui.getCore().getStaticAreaRef().appendChild(i);i.contentWindow.name=this.sId+"-frame";var t=this;this._bUploading=false;q(i).load(function(E){if(t._bUploading){d.info("File uploaded to "+t.getUploadUrl());var r;try{r=t.oIFrameRef.contentWindow.document.body.innerHTML;}catch(h){}t.fireUploadComplete({"response":r});t._bUploading=false;}});this.oIFrameRef=i;}};
g.prototype.openValueStateMessage=function(){if(this.oFilePath.openValueStateMessage){this.oFilePath.openValueStateMessage();this.oBrowse.$().addAriaDescribedBy(this.oFilePath.getId()+"-message");}};
g.prototype.closeValueStateMessage=function(){if(this.oFilePath.closeValueStateMessage){this.oFilePath.closeValueStateMessage();this.oBrowse.$().removeAriaDescribedBy(this.oFilePath.getId()+"-message");}};
g.prototype._resetValueAfterUploadStart=function(){d.info("File uploading to "+this.getUploadUrl());if(this.getSameFilenameAllowed()&&this.getUploadOnChange()&&this.getUseMultipart()){this.setValue("",true);}};
g.prototype._addLabelFeaturesToBrowse=function(){var $;if(this.oBrowse&&this.oBrowse.$().length){$=this.oBrowse.$();$.attr("type', 'button");$.click(function(e){e.preventDefault();this.FUEl.click();}.bind(this));}};
g.prototype.getProcessedBlobsFromArray=function(B){return new Promise(function(r){r(B);});};
return g;});
sap.ui.predefine('sap/ui/unified/FileUploaderParameter',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var F=E.extend("sap.ui.unified.FileUploaderParameter",{metadata:{library:"sap.ui.unified",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});
return F;});
sap.ui.predefine('sap/ui/unified/FileUploaderRenderer',['sap/ui/unified/library',"sap/ui/thirdparty/jquery"],function(l,q){"use strict";var F=function(){};
F.render=function(r,f){var a=sap.ui.getCore().getConfiguration().getAccessibility(),e=f.getEnabled();r.write('<div');r.writeControlData(f);r.addClass("sapUiFup");if(f.getButtonOnly()){r.addClass("sapUiFupButtonOnly");}var c=l.FileUploaderHelper.addFormClass();if(c){r.addClass(c);}if(!e){r.addClass("sapUiFupDisabled");}r.writeClasses();r.write('>');r.write('<form style="display:inline-block" encType="multipart/form-data" method="post"');r.writeAttribute('id',f.getId()+'-fu_form');r.writeAttributeEscaped('action',f.getUploadUrl());r.writeAttribute('target',f.getId()+'-frame');r.write('>');r.write('<div ');if(!f.bMobileLib){r.write('class="sapUiFupInp"');}if(a){r.writeAttribute("role","textbox");r.writeAttribute("aria-readonly","true");}r.write('>');if(!f.getButtonOnly()){r.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div>');}else{r.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div style="display:none">');}r.renderControl(f.oFilePath);r.write('</div><div>');r.renderControl(f.oBrowse);var A;var t="";if(f.getTooltip()){t=f.getTooltip_AsString();}var p="";if(f.getPlaceholder()){p=f.getPlaceholder();}var v="";if(f.getValue()){v=f.getValue();}var b="";if(f.getButtonText()){b=f.getButtonText();}else{b=f.getBrowseText();}if(!v){A=t+" "+p+" "+b;}else{A=t+" "+v+" "+b;}r.write('<span id="'+f.getId()+'-AccDescr" class="sapUiInvisibleText" aria-hidden="true">');r.writeEscaped(A+" "+f._sAccText);r.write('</span>');r.write('</div></div></div>');var n=f.getName()||f.getId();r.write('<div class="sapUiFupInputMask"');if(t&&t.length){r.writeAttributeEscaped('title',t);}r.write('>');r.write('<input type="hidden" name="_charset_" aria-hidden="true">');r.write('<input type="hidden" id="'+f.getId()+'-fu_data" aria-hidden="true"');r.writeAttributeEscaped('name',n+'-data');r.writeAttributeEscaped('value',f.getAdditionalData()||"");r.write('>');q.each(f.getParameters(),function(i,P){r.write('<input type="hidden" aria-hidden="true" ');r.writeAttributeEscaped('name',P.getName()||"");r.writeAttributeEscaped('value',P.getValue()||"");r.write('>');});r.write('</div>');r.write('</div>');r.write('</form>');r.write('</div>');};
return F;},true);
sap.ui.predefine('sap/ui/unified/FileUploaderXHRSettings',['sap/ui/core/Element','./library'],function(E){"use strict";
var F=E.extend("sap.ui.unified.FileUploaderXHRSettings",{metadata:{library:"sap.ui.unified",properties:{withCredentials:{type:"boolean",group:"Data",defaultValue:false}}}});
return F;});
sap.ui.predefine('sap/ui/unified/MenuItem',['sap/ui/core/IconPool','./MenuItemBase','./library'],function(I,M,l){"use strict";
var a=M.extend("sap.ui.unified.MenuItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Appearance",defaultValue:''},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''}}}});
I.insertFontFaceStyle();
a.prototype.render=function(r,i,m,o){var b=r;var s=i.getSubmenu();b.write("<li ");var c="sapUiMnuItm";if(o.iItemNo==1){c+=" sapUiMnuItmFirst";}else if(o.iItemNo==o.iTotalItems){c+=" sapUiMnuItmLast";}if(!m.checkEnabled(i)){c+=" sapUiMnuItmDsbl";}if(i.getStartsSection()){c+=" sapUiMnuItmSepBefore";}b.writeAttribute("class",c);if(i.getTooltip_AsString()){b.writeAttributeEscaped("title",i.getTooltip_AsString());}b.writeElementData(i);if(o.bAccessible){b.writeAccessibilityState(i,{role:"menuitem",disabled:!m.checkEnabled(i),posinset:o.iItemNo,setsize:o.iTotalItems,labelledby:{value:this.getId()+"-txt "+this.getId()+"-scuttxt",append:true}});if(s){b.writeAttribute("aria-haspopup",true);b.writeAttribute("aria-owns",s.getId());}}b.write("><div class=\"sapUiMnuItmL\"></div>");b.write("<div class=\"sapUiMnuItmIco\">");if(i.getIcon()){b.writeIcon(i.getIcon(),null,{title:null});}b.write("</div>");b.write("<div id=\""+this.getId()+"-txt\" class=\"sapUiMnuItmTxt\">");b.writeEscaped(i.getText());b.write("</div>");b.write("<div id=\""+this.getId()+"-scuttxt\" class=\"sapUiMnuItmSCut\"></div>");b.write("<div class=\"sapUiMnuItmSbMnu\">");if(s){b.write("<div class=\"sapUiIconMirrorInRTL\"></div>");}b.write("</div>");b.write("<div class=\"sapUiMnuItmR\"></div>");b.write("</li>");};
a.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);};
return a;});
sap.ui.predefine('sap/ui/unified/MenuItemBase',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var M=E.extend("sap.ui.unified.MenuItemBase",{metadata:{library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"submenu",aggregations:{submenu:{type:"sap.ui.unified.Menu",multiple:false}},events:{select:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
M.prototype.init=function(){};
M.prototype.render=function(r,i,m){var a=r;a.write("<li");a.writeElementData(i);a.write("><div style=\"white-space:nowrap;display:inline-block;padding:1px;color:black;\" id=\""+this.getId()+"-txt\">");a.write(i.getId());if(this.getSubmenu()){a.write("&nbsp;&nbsp;->");}a.write("</div></li>");};
M.prototype.hover=function(h,m){this.$("txt").attr("style",h?"white-space:nowrap;display:inline-block;padding:1px;color:red;":"white-space:nowrap;display:inline-block;padding:1px;color:black;");};
M.prototype.onSubmenuToggle=function(o){this.$().toggleClass("sapUiMnuItmSubMnuOpen",o);};
M.prototype.onAfterRendering=function(){};
M.prototype.onmouseover=function(e){var p=this.getParent();if(p&&p instanceof sap.ui.unified.Menu&&this.getTooltip()instanceof sap.ui.core.TooltipBase){p.onmouseover(e);}};
M.prototype.onsapshow=function(e){if(this.getParent()&&this.getParent().close){this.getParent().close();}e.preventDefault();};
M.prototype.onsaphide=M.prototype.onsapshow;return M;});
sap.ui.predefine('sap/ui/unified/MenuRenderer',[],function(){"use strict";var M={};
M.render=function(r,m){if(m.oHoveredItem&&m.indexOfItem(m.oHoveredItem)<0){m.oHoveredItem=null;}r.write("<div tabindex=\"-1\" hideFocus=\"true\"");if(m.getTooltip_AsString()){r.writeAttributeEscaped("title",m.getTooltip_AsString());}var a=sap.ui.getCore().getConfiguration().getAccessibility();if(a){r.writeAccessibilityState(m,{role:"menu",disabled:null,labelledby:{value:m.getId()+"-label",append:true}});if(m.oHoveredItem){r.writeAttribute("aria-activedescendant",m.oHoveredItem.getId());}}r.addClass("sapUiMnu");var R=m.getRootMenu();if(R.bUseTopStyle){r.addClass("sapUiMnuTop");}if(R.isCozy()){r.addClass("sapUiSizeCozy");}if(m.bCozySupported){r.addClass("sapUiMnuCozySupport");}r.writeClasses();r.writeControlData(m);r.write(">");M.renderItems(r,m);if(a){r.write("<span id='",m.getId(),"-label' class='sapUiInvisibleText' aria-hidden='true'>");r.writeEscaped(m.getAriaDescription()?m.getAriaDescription():"");r.write("</span>");}r.write("</div>");};
M.renderItems=function(r,m){var I=m.getItems();var a=sap.ui.getCore().getConfiguration().getAccessibility();r.write("<ul class=\"sapUiMnuLst");var h=false;var H=false;for(var b=0;b<I.length;b++){if(I[b].getIcon&&I[b].getIcon()){h=true;}if(I[b].getSubmenu()){H=true;}}if(!h){r.write(" sapUiMnuNoIco");}if(!H){r.write(" sapUiMnuNoSbMnu");}r.write("\">");var n=0;for(var i=0;i<I.length;i++){if(I[i].getVisible()&&I[i].render){n++;}}var c=0;for(var i=0;i<I.length;i++){var o=I[i];if(o.getVisible()&&o.render){c++;if(o.getStartsSection()){r.write("<li ");if(a){r.write("role=\"separator\" ");}r.write("class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>");}o.render(r,o,m,{bAccessible:a,iItemNo:c,iTotalItems:n});}}r.write("</ul>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/MenuTextFieldItem',['sap/ui/core/ValueStateSupport','./MenuItemBase','./library','sap/ui/core/library','sap/ui/Device','sap/base/Log','sap/ui/events/PseudoEvents','sap/ui/dom/jquery/cursorPos'],function(V,M,l,c,D,L,P){"use strict";var a=c.ValueState;
var b=M.extend("sap.ui.unified.MenuTextFieldItem",{metadata:{library:"sap.ui.unified",properties:{label:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:a.None}}}});
(function(){
b.prototype.render=function(r,i,m,I){var d=r,e=m.checkEnabled(i),f=i.getId();var C="sapUiMnuItm sapUiMnuTfItm";if(I.iItemNo==1){C+=" sapUiMnuItmFirst";}else if(I.iItemNo==I.iTotalItems){C+=" sapUiMnuItmLast";}if(!m.checkEnabled(i)){C+=" sapUiMnuItmDsbl";}if(i.getStartsSection()){C+=" sapUiMnuItmSepBefore";}d.write("<li ");d.writeAttribute("class",C);d.writeElementData(i);if(I.bAccessible){d.writeAttribute("role","menuitem");d.writeAttribute("aria-disabled",!e);d.writeAttribute("aria-posinset",I.iItemNo);d.writeAttribute("aria-setsize",I.iTotalItems);}d.write("><div class=\"sapUiMnuItmL\"></div>");d.write("<div class=\"sapUiMnuItmIco\">");if(i.getIcon()){d.writeIcon(i.getIcon(),null,{title:null});}d.write("</div>");d.write("<div id=\""+f+"-txt\" class=\"sapUiMnuItmTxt\">");d.write("<label id=\""+f+"-lbl\" class=\"sapUiMnuTfItemLbl\">");d.writeEscaped(i.getLabel()||"");d.write("</label>");d.write("<div id=\""+f+"-str\" class=\"sapUiMnuTfItmStretch\"></div>");d.write("<div class=\"sapUiMnuTfItemWrppr\">");d.write("<input id=\""+f+"-tf\" tabindex=\"-1\"");d.writeAttributeEscaped("value",i.getValue()||"");d.writeAttribute("class",e?"sapUiMnuTfItemTf sapUiMnuTfItemTfEnbl":"sapUiMnuTfItemTf sapUiMnuTfItemTfDsbl");if(!e){d.writeAttribute("disabled","disabled");}if(I.bAccessible){d.writeAccessibilityState(i,{role:"textbox",disabled:!e,multiline:false,autocomplete:"none",labelledby:{value:f+"-lbl",append:true}});}d.write("/></div></div>");d.write("<div class=\"sapUiMnuItmR\"></div>");d.write("</li>");};
b.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);if(h&&m.checkEnabled(this)){m.closeSubmenu(false,true);if(D.browser.msie){setTimeout(function(){var f=function(){this.$("tf").focus();}.bind(this);if(typeof f==="string"||f instanceof String){f=this[f];}f.apply(this,[]);}.bind(this),0);}else{this.$("tf").focus();}}};
b.prototype.onAfterRendering=function(){this._adaptSizes();this.setValueState(this.getValueState());};
b.prototype.onsapup=function(e){this.getParent().focus();this.getParent().onsapprevious(e);};
b.prototype.onsapdown=function(e){this.getParent().focus();this.getParent().onsapnext(e);};
b.prototype.onsaphome=function(e){if(this._checkCursorPosForNav(false)){this.getParent().focus();this.getParent().onsaphome(e);}};
b.prototype.onsapend=function(e){if(this._checkCursorPosForNav(true)){this.getParent().focus();this.getParent().onsapend(e);}};
b.prototype.onsappageup=function(e){this.getParent().focus();this.getParent().onsappageup(e);};
b.prototype.onsappagedown=function(e){this.getParent().focus();this.getParent().onsappagedown(e);};
b.prototype.onsapescape=function(e){this.getParent().onsapescape(e);};
b.prototype.onkeydown=function(e){e.stopPropagation();};
b.prototype.onclick=function(e){this.getParent().closeSubmenu(false,true);if(!D.system.desktop&&this.getParent().checkEnabled(this)){this.focus();}e.stopPropagation();};
b.prototype.onkeyup=function(e){if(!P.events.sapenter.fnCheck(e)){return;}var v=this.$("tf").val();this.setValue(v);this.getParent().selectItem(this);e.preventDefault();e.stopPropagation();};
b.prototype.setSubmenu=function(m){L.warning("The aggregation 'submenu' is not supported for this type of menu item.","","sap.ui.unified.MenuTextFieldItem");return this;};
b.prototype.setLabel=function(s){this.setProperty("label",s,true);this.$("lbl").text(s);this._adaptSizes();return this;};
b.prototype.setValue=function(v){this.setProperty("value",v,true);this.$("tf").val(v);return this;};
b.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var $=this.$("tf");$.toggleClass("sapUiMnuTfItemTfErr",v==a.Error);$.toggleClass("sapUiMnuTfItemTfWarn",v==a.Warning);var t=V.enrichTooltip(this,this.getTooltip_AsString());this.$().attr("title",t?t:"");return this;};
b.prototype.getFocusDomRef=function(){var f=this.$("tf");return f.length?f.get(0):null;};
b.prototype._adaptSizes=function(){var $=this.$("tf");var d=this.$("lbl");var o=d.length?d.get(0).offsetLeft:0;if(sap.ui.getCore().getConfiguration().getRTL()){$.parent().css({"width":"auto","right":(this.$().outerWidth(true)-o+(d.outerWidth(true)-d.outerWidth()))+"px"});}else{$.parent().css({"width":"auto","left":(o+d.outerWidth(true))+"px"});}};
b.prototype._checkCursorPosForNav=function(f){var r=sap.ui.getCore().getConfiguration().getRTL();var B=f?r:!r;var $=this.$("tf");var p=$.cursorPos();var i=$.val().length;if(r){p=i-p;}if((!B&&p!=i)||(B&&p!=0)){return false;}return true;};
}());return b;});
sap.ui.predefine('sap/ui/unified/Shell',['./ShellHeader','./ShellLayout','./library','./ShellRenderer'],function(S,a,l,b){"use strict";
var c=a.extend("sap.ui.unified.Shell",{metadata:{library:"sap.ui.unified",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},showCurtain:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},showCurtainPane:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},searchVisible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{curtainContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainContent"},curtainPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainPaneContent"},headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headItem",forwarding:{idSuffix:"-header",aggregation:"headItems"}},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headEndItem",forwarding:{idSuffix:"-header",aggregation:"headEndItems"}},search:{type:"sap.ui.core.Control",multiple:false,forwarding:{idSuffix:"-header",aggregation:"search"}},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false,forwarding:{idSuffix:"-header",aggregation:"user"}}}}});
c.prototype.init=function(){a.prototype.init.apply(this,arguments);this._header=new S(this.getId()+"-header");this.setHeader(this._header);};
c.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._header.destroy();delete this._header;};
c.prototype._getSearchWidth=function(){if(this._header===this.getHeader()&&this._header.getDomRef()){var s=this._header.$("hdr-center").children();if(s.length){return s.width();}}return-1;};
c.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._header.setLogo(i);return this;};
c.prototype.getIcon=function(){return this._header.getLogo();};
c.prototype.setSearchVisible=function(s){this.setProperty("searchVisible",s,true);this._header.setSearchVisible(s);return this;};
c.prototype.getSearchVisible=function(){return this._header.getSearchVisible();};
c.prototype.setHeader=function(h){return a.prototype.setHeader.apply(this,[h?h:this._header]);};
c.prototype.destroyHeader=function(){if(this.getHeader()===this._header){return this;}return a.prototype.destroyHeader.apply(this,[]);};
return c;});
sap.ui.predefine('sap/ui/unified/ShellHeadItem',['sap/ui/core/Element','sap/ui/core/IconPool','./library',"sap/base/security/encodeXML","sap/ui/thirdparty/jquery"],function(E,I,l,e,q){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadItem",{metadata:{library:"sap.ui.unified",properties:{startsSection:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},showSeparator:{type:"boolean",group:"Appearance",defaultValue:true},selected:{type:"boolean",group:"Appearance",defaultValue:false},toggleEnabled:{type:"boolean",group:"Appearance",defaultValue:true},showMarker:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
S.prototype.onclick=function(o){this.firePress();o.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setStartsSection=function(s){s=!!s;this.setProperty("startsSection",s,true);this.$().toggleClass("sapUiUfdShellHeadItmDelim",s);return this;};
S.prototype.setShowSeparator=function(s){s=!!s;this.setProperty("showSeparator",s,true);this.$().toggleClass("sapUiUfdShellHeadItmSep",s);return this;};
function _(){var t=this.$(),T=this.getToggleEnabled(),s=this.getSelected();if(!t.length){return;}if(T){t.toggleClass("sapUiUfdShellHeadItmSel",s);t.attr("aria-pressed",s);}else{t.removeClass("sapUiUfdShellHeadItmSel");t.removeAttr("aria-pressed");}}
S.prototype.setToggleEnabled=function(b){this.setProperty("toggleEnabled",!!b,true);_.apply(this);return this;};
S.prototype.setSelected=function(s){this.setProperty("selected",!!s,true);_.apply(this);return this;};
S.prototype.setVisible=function(v){this.setProperty("visible",!!v);return this;};
S.prototype.setShowMarker=function(m){m=!!m;this.setProperty("showMarker",m,true);this.$().toggleClass("sapUiUfdShellHeadItmMark",m);return this;};
S.prototype.setIcon=function(i){this.setProperty("icon",i,true);if(this.getDomRef()){this._refreshIcon();}return this;};
S.prototype._refreshIcon=function(){var i=q(this.$().children()[0]);var s=this.getIcon();if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").css("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.css("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+e(s)+"'/>");}}};
return S;});
sap.ui.predefine('sap/ui/unified/ShellHeadUserItem',['sap/ui/core/Element','sap/ui/core/IconPool','./library',"sap/base/security/encodeXML"],function(E,I,l,e){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadUserItem",{metadata:{library:"sap.ui.unified",properties:{username:{type:"string",group:"Appearance",defaultValue:''},showPopupIndicator:{type:"boolean",group:"Accessibility",defaultValue:true},image:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
I.insertFontFaceStyle();
S.prototype.onclick=function(o){this.firePress();o.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setImage=function(i){this.setProperty("image",i,true);if(this.getDomRef()){this._refreshImage();}return this;};
S.prototype._refreshImage=function(){var i=this.$("img");var s=this.getImage();if(!s){i.html("").css("style","").css("display","none");}else if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").css("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.css("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+e(s)+"'/>");}}};
S.prototype._checkAndAdaptWidth=function(s){if(!this.getDomRef()){return false;}var r=this.$(),n=this.$("name");var b=r.width();r.toggleClass("sapUiUfdShellHeadUsrItmLimit",false);var m=240;if(s){m=Math.min(m,0.5*document.documentElement.clientWidth-225);}if(m<n.width()){r.toggleClass("sapUiUfdShellHeadUsrItmLimit",true);}return b!=r.width();};
return S;});
sap.ui.predefine('sap/ui/unified/ShellHeader',['./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/theming/Parameters',"sap/ui/thirdparty/jquery"],function(l,C,D,P,q){"use strict";
var S=C.extend("sap.ui.unified.ShellHeader",{
metadata:{properties:{logo:{type:"sap.ui.core.URI",defaultValue:""},searchVisible:{type:"boolean",defaultValue:true}},aggregations:{headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},search:{type:"sap.ui.core.Control",multiple:false},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false}}},
renderer:{render:function(r,h){var i=h.getId();r.write("<div");r.writeControlData(h);r.writeAttribute("class","sapUiUfdShellHeader");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write(">");r.write("<div id='",i,"-hdr-begin' class='sapUiUfdShellHeadBegin'>");this.renderHeaderItems(r,h,true);r.write("</div>");r.write("<div id='",i,"-hdr-center' class='sapUiUfdShellHeadCenter'>");this.renderSearch(r,h);r.write("</div>");r.write("<div id='",i,"-hdr-end' class='sapUiUfdShellHeadEnd'>");this.renderHeaderItems(r,h,false);r.write("</div>");r.write("</div>");},renderSearch:function(r,h){var s=h.getSearch();r.write("<div id='",h.getId(),"-hdr-search'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","search");}r.writeAttribute("class","sapUiUfdShellSearch"+(h.getSearchVisible()?"":" sapUiUfdShellHidden"));r.write("><div>");if(s){r.renderControl(s);}r.write("</div></div>");},renderHeaderItems:function(r,h,b){r.write("<div class='sapUiUfdShellHeadContainer'>");var I=b?h.getHeadItems():h.getHeadEndItems();for(var i=0;i<I.length;i++){r.write("<div tabindex='0'");r.writeElementData(I[i]);r.addClass("sapUiUfdShellHeadItm");if(I[i].getStartsSection()){r.addClass("sapUiUfdShellHeadItmDelim");}if(I[i].getShowSeparator()){r.addClass("sapUiUfdShellHeadItmSep");}if(!I[i].getVisible()){r.addClass("sapUiUfdShellHidden");}if(I[i].getSelected()&&I[i].getToggleEnabled()){r.addClass("sapUiUfdShellHeadItmSel");}if(I[i].getShowMarker()){r.addClass("sapUiUfdShellHeadItmMark");}r.writeClasses();var t=I[i].getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(I[i],{role:"button",selected:null,pressed:I[i].getToggleEnabled()?I[i].getSelected():null});}r.write("><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></div>");}var u=h.getUser();if(!b&&u){r.write("<div tabindex='0'");r.writeElementData(u);r.addClass("sapUiUfdShellHeadUsrItm");if(!u.getShowPopupIndicator()){r.addClass("sapUiUfdShellHeadUsrItmWithoutPopup");}r.writeClasses();var t=u.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(u,{role:"button"});if(u.getShowPopupIndicator()){r.writeAttribute("aria-haspopup","true");}}r.write("><span id='",u.getId(),"-img' aria-hidden='true' class='sapUiUfdShellHeadUsrItmImg'></span>");r.write("<span id='"+u.getId()+"-name' class='sapUiUfdShellHeadUsrItmName'");var U=u.getUsername()||"";r.writeAttributeEscaped("title",U);r.write(">");r.writeEscaped(U);r.write("</span><span class='sapUiUfdShellHeadUsrItmExp' aria-hidden='true'></span></div>");}r.write("</div>");if(b){this._renderLogo(r,h);}},_renderLogo:function(r,h){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),L=a.getText("SHELL_LOGO_TOOLTIP"),i=h._getLogo();r.write("<div class='sapUiUfdShellIco'>");r.write("<img id='",h.getId(),"-icon'");r.writeAttributeEscaped("title",L);r.writeAttributeEscaped("alt",L);r.write("src='");r.writeEscaped(i);r.write("' style='",i?"":"display:none;","'/>");r.write("</div>");}}
});
S.prototype.init=function(){var t=this;this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._handleMediaChange=function(p){if(!t.getDomRef()){return;}t._refresh();};D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);this._handleResizeChange=function(p){if(!t.getDomRef()||!t.getUser()){return;}var u=this.getUser();var c=u._checkAndAdaptWidth(!t.$("hdr-search").hasClass("sapUiUfdShellHidden")&&!!t.getSearch());if(c){t._refresh();}};D.resize.attachHandler(this._handleResizeChange,this);this.data("sap-ui-fastnavgroup","true",true);};
S.prototype.exit=function(){D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);delete this._handleMediaChange;D.resize.detachHandler(this._handleResizeChange,this);delete this._handleResizeChange;};
S.prototype.onAfterRendering=function(){this._refresh();this.$("hdr-center").toggleClass("sapUiUfdShellAnim",!this._noHeadCenterAnim);};
S.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};
S.prototype._getLogo=function(){var i=this.getLogo();if(!i){i=P._getThemeImage(null,true);}return i;};
S.prototype._refresh=function(){function u(I){for(var i=0;i<I.length;i++){I[i]._refreshIcon();}}u(this.getHeadItems());u(this.getHeadEndItems());var U=this.getUser(),a=q("html").hasClass("sapUiMedia-Std-Phone"),s=!this.$("hdr-search").hasClass("sapUiUfdShellHidden"),$=this.$("icon");if(U){U._refreshImage();U._checkAndAdaptWidth(s&&!!this.getSearch());}$.parent().toggleClass("sapUiUfdShellHidden",a&&s&&!!this.getSearch());var w=this.$("hdr-end").outerWidth(),b=this.$("hdr-begin").outerWidth(),c=Math.max(w,b),d=(a&&s?b:c)+"px",e=(a&&s?w:c)+"px";this.$("hdr-center").css({"left":this._rtl?e:d,"right":this._rtl?d:e});};
return S;});
sap.ui.predefine('sap/ui/unified/ShellLayout',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./SplitContainer','./library','./ShellLayoutRenderer','sap/ui/dom/containsOrEquals','sap/base/Log',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/Focusable'],function(D,C,P,a,S,l,b,c,L,q){"use strict";
var d=C.extend("sap.ui.unified.ShellLayout",{metadata:{library:"sap.ui.unified",properties:{showPane:{type:"boolean",group:"Appearance",defaultValue:false},headerHiding:{type:"boolean",group:"Appearance",defaultValue:false},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",forwarding:{idSuffix:"-container",aggregation:"content"}},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent",forwarding:{idSuffix:"-container",aggregation:"secondaryContent"}},header:{type:"sap.ui.core.Control",multiple:false},canvasSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"},curtainSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"}}}});
d._SIDEPANE_WIDTH_PHONE=208;d._SIDEPANE_WIDTH_TABLET=208;d._SIDEPANE_WIDTH_DESKTOP=240;d._HEADER_ALWAYS_VISIBLE=true;d._HEADER_AUTO_CLOSE=true;d._HEADER_TOUCH_TRESHOLD=15;if(D.browser.chrome&&D.browser.version<36){d._HEADER_TOUCH_TRESHOLD=10;}
d.prototype.init=function(){this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._showHeader=true;this._showCurtain=false;this._iHeaderHidingDelay=3000;this._useStrongBG=false;this._cont=new S(this.getId()+"-container");this._cont._bRootContent=true;if(sap.ui.getCore().getConfiguration().getAccessibility()){var t=this;this._cont.addEventDelegate({onAfterRendering:function(){t._cont.$("canvas").attr("role","main");t._cont.$("pane").attr("role","complementary");}});}this.setAggregation("canvasSplitContainer",this._cont,true);this._curtCont=new S(this.getId()+"-curt-container");this._curtCont._bRootContent=true;this.setAggregation("curtainSplitContainer",this._curtCont,true);this._setSidePaneWidth();D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.attachHandler(this._handleResizeChange,this);};
d.prototype.exit=function(){D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.detachHandler(this._handleResizeChange,this);delete this._cont;delete this._curtCont;};
d.prototype.onAfterRendering=function(){var t=this;function h(B){var e=q.event.fix(B);if(c(t.getDomRef("hdr"),e.target)){t._timedHideHeader(e.type==="focus");}}if(window.addEventListener&&!d._HEADER_ALWAYS_VISIBLE){var H=this.getDomRef("hdr");H.addEventListener("focus",h,true);H.addEventListener("blur",h,true);}this._refreshAfterRendering();};
d.prototype.onThemeChanged=function(){this._refreshAfterRendering();};
d.prototype.onfocusin=function(e){var i=this.getId();if(e.target.id===i+"-curt-focusDummyOut"&&this.$("hdrcntnt").firstFocusableDomRef()){this.$("hdrcntnt").firstFocusableDomRef().focus();}else if(e.target.id===i+"-main-focusDummyOut"&&this.$("curtcntnt").firstFocusableDomRef()){this.$("curtcntnt").firstFocusableDomRef().focus();}};
(function(){
function _(s){if(s._startY===undefined||s._currY===undefined){return;}var y=s._currY-s._startY;if(Math.abs(y)>d._HEADER_TOUCH_TRESHOLD){s._doShowHeader(y>0);s._startY=s._currY;}}
if(D.support.touch){d._HEADER_ALWAYS_VISIBLE=false;d.prototype.ontouchstart=function(e){this._startY=e.touches[0].pageY;if(this._startY>2*48){this._startY=undefined;}this._currY=this._startY;};d.prototype.ontouchend=function(e){_(this);this._startY=undefined;this._currY=undefined;};d.prototype.ontouchcancel=d.prototype.ontouchend;d.prototype.ontouchmove=function(e){this._currY=e.touches[0].pageY;_(this);};}})();
d.prototype.setHeaderHiding=function(e){e=!!e;return this._mod(function(r){return this.setProperty("headerHiding",e,r);},function(){this._doShowHeader(!e?true:this._showHeader);});};
d.prototype.setHeaderHidingDelay=function(i){this._iHeaderHidingDelay=i;return this;};
d.prototype.getHeaderHidingDelay=function(){return this._iHeaderHidingDelay;};
d.prototype.getShowPane=function(){return this._cont.getShowSecondaryContent();};
d.prototype.setShowPane=function(s){this._cont.setShowSecondaryContent(s);this.setProperty("showPane",!!s,true);return this;};
d.prototype.setShowCurtainPane=function(s){this._curtCont.setShowSecondaryContent(s);return this;};
d.prototype.getShowCurtainPane=function(){return this._curtCont.getShowSecondaryContent();};
d.prototype.setHeaderVisible=function(h){h=!!h;this.setProperty("headerVisible",h,true);this.$().toggleClass("sapUiUfdShellNoHead",!h);return this;};
d.prototype.setShowCurtain=function(s){s=!!s;return this._mod(function(r){this._showCurtain=s;return this;},function(){this.$("main-focusDummyOut").attr("tabindex",s?0:-1);this.$().toggleClass("sapUiUfdShellCurtainHidden",!s).toggleClass("sapUiUfdShellCurtainVisible",s);if(s){var z=P.getNextZIndex();this.$("curt").css("z-index",z+1);this.$("hdr").css("z-index",z+3);this.$("brand").css("z-index",z+7);this.$().toggleClass("sapUiUfdShellCurtainClosed",false);}this._timedCurtainClosed(s);this._doShowHeader(true);});};
d.prototype.getShowCurtain=function(){return this._showCurtain;};
d.prototype.setHeader=function(h){this.setAggregation("header",h,true);h=this.getHeader();if(this.getDomRef()){if(!h){this.$("hdrcntnt").html("");}else{var r=sap.ui.getCore().createRenderManager();r.renderControl(h);r.flush(this.getDomRef("hdrcntnt"));r.destroy();}}return this;};
d.prototype.destroyHeader=function(){this.destroyAggregation("header",true);this.$("hdrcntnt").html("");return this;};
d.prototype.getCurtainContent=function(){return this._curtCont.getContent();};
d.prototype.insertCurtainContent=function(o,i){this._curtCont.insertContent(o,i);return this;};
d.prototype.addCurtainContent=function(o){this._curtCont.addContent(o);return this;};
d.prototype.removeCurtainContent=function(i){return this._curtCont.removeContent(i);};
d.prototype.removeAllCurtainContent=function(){return this._curtCont.removeAllContent();};
d.prototype.destroyCurtainContent=function(){this._curtCont.destroyContent();return this;};
d.prototype.indexOfCurtainContent=function(o){return this._curtCont.indexOfCurtainContent(o);};
d.prototype.getCurtainPaneContent=function(){return this._curtCont.getSecondaryContent();};
d.prototype.insertCurtainPaneContent=function(o,i){this._curtCont.insertSecondaryContent(o,i);return this;};
d.prototype.addCurtainPaneContent=function(o){this._curtCont.addSecondaryContent(o);return this;};
d.prototype.removeCurtainPaneContent=function(i){return this._curtCont.removeSecondaryContent(i);};
d.prototype.removeAllCurtainPaneContent=function(){return this._curtCont.removeAllSecondaryContent();};
d.prototype.destroyCurtainPaneContent=function(){this._curtCont.destroySecondaryContent();return this;};
d.prototype.indexOfCurtainPaneContent=function(o){return this._curtCont.indexOfSecondaryContent(o);};
d.prototype._setStrongBackground=function(u){this._useStrongBG=!!u;this.$("strgbg").toggleClass("sapUiStrongBackgroundColor",this._useStrongBG);};
d.prototype._mod=function(m,o){var r=!!this.getDomRef();var e=m.apply(this,[r]);if(r&&o){if(o instanceof l._ContentRenderer){o.render();}else{o.apply(this);}}return e;};
d.prototype._doShowHeader=function(s){var w=this._showHeader;this._showHeader=this._isHeaderHidingActive()?!!s:true;this.$().toggleClass("sapUiUfdShellHeadHidden",!this._showHeader).toggleClass("sapUiUfdShellHeadVisible",this._showHeader);if(this._showHeader){this._timedHideHeader();}if(w!=this._showHeader&&this._isHeaderHidingActive()){setTimeout(function(){try{var r=document.createEvent("UIEvents");r.initUIEvent("resize",true,false,window,0);window.dispatchEvent(r);}catch(e){L.error(e);}},500);}};
d.prototype._timedHideHeader=function(e){if(this._headerHidingTimer){clearTimeout(this._headerHidingTimer);this._headerHidingTimer=null;}if(e||!d._HEADER_AUTO_CLOSE||!this._isHeaderHidingActive()||this._iHeaderHidingDelay<=0){return;}this._headerHidingTimer=setTimeout(function(){if(this._isHeaderHidingActive()&&this._iHeaderHidingDelay>0&&!c(this.getDomRef("hdr"),document.activeElement)){this._doShowHeader(false);}}.bind(this),this._iHeaderHidingDelay);};
d.prototype._timedCurtainClosed=function(e){if(this._curtainClosedTimer){clearTimeout(this._curtainClosedTimer);this._curtainClosedTimer=null;}if(e){return;}var f=parseInt(a.get("_sap_ui_unified_ShellLayout_AnimDuration"),10);if(!this._animation||(D.browser.internet_explorer&&D.browser.version<10)){f=0;}this._curtainClosedTimer=setTimeout(function(){this._curtainClosedTimer=null;this.$("curt").css("z-index","");this.$("hdr").css("z-index","");this.$("brand").css("z-index","");this.$().toggleClass("sapUiUfdShellCurtainClosed",true);}.bind(this),f);};
d.prototype._isHeaderHidingActive=function(){if(d._HEADER_ALWAYS_VISIBLE||this.getShowCurtain()||!this.getHeaderHiding()||l._iNumberOfOpenedShellOverlays>0||!this.getHeaderVisible()){return false;}return true;};
d.prototype._refreshCSSWorkaround=function(){if(!D.browser.webkit||!D.support.touch){return;}if(this._cssWorkaroundTimer){clearTimeout(this._cssWorkaroundTimer);this._cssWorkaroundTimer=null;}this.$("css").remove();this._cssWorkaroundTimer=setTimeout(function(){this._cssWorkaroundTimer=null;L.debug("sap.ui.unified.ShellLayout: CSS Workaround applied.");q("head").append("<link type='text/css' rel='stylesheet' id='"+this.getId()+"-css' href='data:text/css;base64,LnNhcFVpVWZkU2hlbGxDaHJvbWVSZXBhaW50e291dGxpbmUtY29sb3I6aW5pdGlhbDt9'/>");this._cssWorkaroundTimer=setTimeout(function(){this.$("css").remove();}.bind(this),100);}.bind(this),10);};
d.prototype._setSidePaneWidth=function(r){if(!r){r=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD).name;}var w=d["_SIDEPANE_WIDTH_"+r.toUpperCase()]+"px";this._cont.setSecondaryContentSize(w);this._curtCont.setSecondaryContentSize(w);};
d.prototype._handleMediaChange=function(p){if(!this.getDomRef()){return false;}this._setSidePaneWidth(p.name);};
d.prototype._handleResizeChange=function(p){};
d.prototype._refreshAfterRendering=function(){var o=this.getDomRef();if(!o){return false;}this._repaint(o);this._timedHideHeader();return true;};
d.prototype._repaint=function(o){if(D.browser.webkit){var e=o.style.display;o.style.display="none";o.offsetHeight;o.style.display=e;this._refreshCSSWorkaround();}};
d.prototype._getSearchWidth=function(){return-1;};
return d;});
sap.ui.predefine('sap/ui/unified/ShellLayoutRenderer',[],function(){"use strict";var S={};
S.render=function(r,s){var i=s.getId();r.write("<div");r.writeControlData(s);r.addClass("sapUiUfdShell");if(s._animation){r.addClass("sapUiUfdShellAnim");}if(!s.getHeaderVisible()){r.addClass("sapUiUfdShellNoHead");}r.addClass("sapUiUfdShellHead"+(s._showHeader?"Visible":"Hidden"));if(s.getShowCurtain()){r.addClass("sapUiUfdShellCurtainVisible");}else{r.addClass("sapUiUfdShellCurtainHidden");r.addClass("sapUiUfdShellCurtainClosed");}r.writeClasses();r.write(">");r.write("<hr id='",i,"-brand' class='sapUiUfdShellBrand'/>");r.write("<header id='",i,"-hdr'  class='sapUiUfdShellHead'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","banner");}r.write("><div><div id='",i,"-hdrcntnt' class='sapUiUfdShellCntnt'>");if(s.getHeader()){r.renderControl(s.getHeader());}r.write("</div>","</div>","</header>");r.write("<section id='",i,"-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>");r.write("<div id='",i,"-curtcntnt' class='sapUiUfdShellCntnt'>");r.renderControl(s._curtCont);r.write("</div>");r.write("<span id='",i,"-curt-focusDummyOut' tabindex='0'></span>");r.write("</section>");r.write("<div id='",i,"-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas sapUiGlobalBackgroundColor sapUiGlobalBackgroundColorForce'>");r.write("<div id='",i,"-strgbg' class='sapUiUfdShellBG"+(s._useStrongBG?" sapUiStrongBackgroundColor":"")+"'></div>");r.write("<div class='sapUiGlobalBackgroundImage sapUiGlobalBackgroundImageForce sapUiUfdShellBG'></div>");r.renderControl(s._cont);r.write("</div>");r.write("<span id='",i,"-main-focusDummyOut' tabindex='"+(s.getShowCurtain()?0:-1)+"'></span>");r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellOverlay',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','./library','sap/ui/core/theming/Parameters','./ShellOverlayRenderer',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/rect','sap/ui/dom/jquery/Selectors'],function(D,C,P,l,a,S,q){"use strict";
var b=C.extend("sap.ui.unified.ShellOverlay",{metadata:{library:"sap.ui.unified",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},search:{type:"sap.ui.core.Control",multiple:false}},associations:{shell:{type:"sap.ui.unified.ShellLayout",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{closed:{}}}});
b.prototype.open=function(){if(this._getPopup().isOpen()){return;}this._opening=true;this._forceShellHeaderVisible();this._getPopup().setModal(true,P.blStack.length==0&&this._getAnimActive()?"sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp":"");this._getPopup().open(0,P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","none");var s=this.getSearch();if(s){s.focus();}this._opening=false;if(this._getAnimActive()){setTimeout(function(){q(document.getElementById("sap-ui-blocklayer-popup")).toggleClass("sapUiUfdShellOvrlyBlyTp",false);},50);}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyOpening",false);}.bind(this),this._getAnimDuration(true));};
b.prototype.close=function(){if(!this._getPopup().isOpen()){return;}this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",true).toggleClass("sapUiUfdShellOvrlyClosing",true);this._setSearchWidth();setTimeout(function(){var B=q(document.getElementById("sap-ui-blocklayer-popup"));if(P.blStack.length==1&&this._getAnimActive()&&B.hasClass("sapUiUfdShellOvrlyBly")){B.toggleClass("sapUiUfdShellOvrlyBlyTp",true);}}.bind(this),Math.max(this._getAnimDuration(false)-this._getBLAnimDuration(),0));setTimeout(function(){this._getPopup().close(0);this.$().remove();this._forceShellHeaderVisible();this.fireClosed();}.bind(this),this._getAnimDuration(false));};
b.prototype.setShell=function(s){return this.setAssociation("shell",s,true);};
b.prototype.setSearch=function(s){this.setAggregation("search",s,true);if(!!this.getDomRef()){this._headRenderer.render();}return this;};
b.prototype.insertContent=function(c,i){var r=this.insertAggregation("content",c,i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.addContent=function(c){var r=this.addAggregation("content",c,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.removeContent=function(i){var r=this.removeAggregation("content",i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.destroyContent=function(){var r=this.destroyAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.init=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._opening=false;var t=this;this._headRenderer=new l._ContentRenderer(this,this.getId()+"-hdr-center",function(r){S.renderSearch(r,t);});this._contentRenderer=new l._ContentRenderer(this,this.getId()+"-cntnt",function(r){S.renderContent(r,t);});};
b.prototype.exit=function(){if(this._popup){this._popup.close(0);this._popup.destroy();this._popup=null;}this._getPopup=function(){return null;};this._headRenderer.destroy();delete this._headRenderer;this._contentRenderer.destroy();delete this._contentRenderer;};
b.prototype.onAfterRendering=function(){if(this._opening){this._setSearchWidth();}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",false);this.$("search").css("width","");}.bind(this),10);};
b.prototype.onclick=function(e){if(q(e.target).attr("id")===this.getId()+"-close"){this.close();e.preventDefault();}};
b.prototype.onsapspace=b.prototype.onclick;
b.prototype.onThemeChanged=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;};
b.prototype.onfocusin=function(e){var f,d;if(e.target.id==this.getId()+"-focfirst"){f=q(":sapTabbable",this.$("inner"));d=f.get(f.length-1);}else if(e.target.id==this.getId()+"-foclast"){f=q(":sapTabbable",this.$("inner"));d=f.get(0);}if(d){d.focus();}};
b.prototype._getAnimDurationThemeParam=function(p,c){var v=parseInt(a.get(p),10);if(!this._getAnimActive()&&c){v=0;}return v;};
b.prototype._getAnimDuration=function(o){if((o&&this._animOpenDuration==-1)||(!o&&this._animCloseDuration==-1)){var t=o?"Open":"Close";this["_anim"+t+"Duration"]=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_"+t+"AnimOverAll",true);}return o?this._animOpenDuration:this._animCloseDuration;};
b.prototype._getBLAnimDuration=function(){if(this._animBlockLayerDuration==-1){this._animBlockLayerDuration=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_BlockLayerAnimDuration",true);}return this._animBlockLayerDuration;};
b.prototype._getAnimActive=function(){if(!this._animation||(D.browser.internet_explorer&&D.browser.version<10)){return false;}return true;};
b.prototype._getPopup=function(){if(!this._popup){this._popup=new P(this,true,false,false);this._popup._applyPosition=function(p){this._$().css("left","0").css("top","0");this._oLastPosition=p;this._oLastOfRect=q(window).rect();};this._popup.attachOpened(function(){l._iNumberOfOpenedShellOverlays++;});this._popup.attachClosed(function(){l._iNumberOfOpenedShellOverlays--;});}return this._popup;};
b.prototype._getShell=function(){var i=this.getShell();if(!i){return;}var s=sap.ui.getCore().byId(i);if(!s||!(s instanceof sap.ui.unified.ShellLayout)){return;}return s;};
b.prototype._forceShellHeaderVisible=function(){var s=this._getShell();if(s){s._doShowHeader(true);}};
b.prototype._getSearchWidth=function(){var s=this._getShell();return s?s._getSearchWidth():-1;};
b.prototype._setSearchWidth=function(){var w=this._getSearchWidth();if(w<=0){return;}var W=w+"px";if(D.browser.safari){var t=this.$("hdr-center").width();if(t>w){W=Math.round((w*100)/t)+"%";}else{W="100%";}}this.$("search").css("width",W);};
return b;});
sap.ui.predefine('sap/ui/unified/ShellOverlayRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdShellOvrly");if(c._opening){r.addClass("sapUiUfdShellOvrlyCntntHidden");r.addClass("sapUiUfdShellOvrlyOpening");}if(c._getAnimActive()){r.addClass("sapUiUfdShellOvrlyAnim");}r.writeClasses();if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(c,{role:"dialog"});}r.write("><span id='",c.getId(),"-focfirst' tabIndex='0'></span><div id='",c.getId(),"-inner'>");r.write("<header class='sapUiUfdShellOvrlyHead'>");r.write("<hr class='sapUiUfdShellOvrlyBrand'/>");r.write("<div class='sapUiUfdShellOvrlyHeadCntnt'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write("><div id='"+c.getId()+"-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>");S.renderSearch(r,c);r.write("</div>");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),C=a.getText("SHELL_OVERLAY_CLOSE");r.write("<a tabindex='0' href='#' id='"+c.getId()+"-close' class='sapUiUfdShellOvrlyHeadClose'");r.writeAttributeEscaped("title",C);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","button");}r.write(">");r.writeEscaped(C);r.write("</a></div></header>");r.write("<div id='"+c.getId()+"-cntnt' class='sapUiUfdShellOvrlyCntnt'>");S.renderContent(r,c);r.write("</div>");r.write("</div><span id='",c.getId(),"-foclast' tabIndex='0'></span></div>");};
S.renderSearch=function(r,c){var w=c._getSearchWidth();var s="";if(w>0&&c._opening){s="style='width:"+w+"px'";}r.write("<div id='"+c.getId()+"-search' class='sapUiUfdShellOvrlySearch' "+s+"><div>");var o=c.getSearch();if(o){r.renderControl(o);}r.write("</div></div>");};
S.renderContent=function(r,c){r.write("<div>");var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellRenderer',['sap/ui/core/Renderer','./ShellLayoutRenderer'],function(R,S){"use strict";var a=R.extend(S);return a;},true);
sap.ui.predefine('sap/ui/unified/SplitContainer',['sap/ui/core/Control','sap/ui/core/theming/Parameters','./library','sap/ui/core/library','./SplitContainerRenderer',"sap/base/Log"],function(C,P,l,c,S,L){"use strict";var O=c.Orientation;
var a=C.extend("sap.ui.unified.SplitContainer",{metadata:{library:"sap.ui.unified",properties:{showSecondaryContent:{type:"boolean",group:"Appearance",defaultValue:null},secondaryContentSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px'},secondaryContentWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px',deprecated:true},orientation:{type:"sap.ui.core.Orientation",group:"Appearance",defaultValue:O.Horizontal}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},secondaryContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondaryContent"}}}});
(function(w){
a.prototype.init=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._paneRenderer=new l._ContentRenderer(this,this.getId()+"-panecntnt","secondaryContent");this._canvasRenderer=new l._ContentRenderer(this,this.getId()+"-canvascntnt","content");this._moveContent=true;};
a.prototype.exit=function(){this._paneRenderer.destroy();delete this._paneRenderer;this._canvasRenderer.destroy();delete this._canvasRenderer;if(this._closeContentDelayId){clearTimeout(this._closeContentDelayId);delete this._closeContentDelayId;}delete this._contentContainer;delete this._secondaryContentContainer;};
a.prototype.onAfterRendering=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._contentContainer=this.$("canvas");this._secondaryContentContainer=this.$("pane");this._applySecondaryContentSize();};
a.prototype._applySecondaryContentSize=function(){if(this.getDomRef()){var v=this.getOrientation()==O.Vertical;var s,o;var d,b;var e=this.getSecondaryContentSize();var f=this.getShowSecondaryContent();if(v){s="height";o="width";d="top";b=this.bRtl?"right":"left";}else{s="width";o="height";d=this.bRtl?"right":"left";b="top";}if(this._closeContentDelayId){clearTimeout(this._closeContentDelayId);delete this._closeContentDelayId;}this._secondaryContentContainer.css(s,e);this._secondaryContentContainer.css(o,"");this._secondaryContentContainer.css(d,f?"0":"-"+e);this._secondaryContentContainer.css(b,"");if(this._moveContent){this._contentContainer.css(d,f?e:"0");}else{this._contentContainer.css(d,"0");}if(!f){var h=parseInt(P.get("_sap_ui_unified_SplitContainer_AnimationDuration"),10);this._closeContentDelayId=setTimeout(function(){this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",true);}.bind(this),h);}else{this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",false);}}};
a.prototype._mod=function(m,d){var r=!!this.getDomRef();var b=m.apply(this,[r]);if(r&&d){d.render();}return b;};
a.prototype.setShowSecondaryContent=function(s){var r=this.getDomRef();this.setProperty("showSecondaryContent",!!s,r);this._applySecondaryContentSize();return this;};
a.prototype.setSecondaryContentSize=function(s){this.setProperty("secondaryContentSize",s,true);this._applySecondaryContentSize();return this;};
a.prototype.getSecondaryContentWidth=function(){L.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.getSecondaryContentSize.apply(this,arguments);};
a.prototype.setSecondaryContentWidth=function(){L.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.setSecondaryContentSize.apply(this,arguments);};
a.prototype.insertContent=function(o,i){return this._mod(function(r){return this.insertAggregation("content",o,i,r);},this._canvasRenderer);};
a.prototype.addContent=function(o){return this._mod(function(r){return this.addAggregation("content",o,r);},this._canvasRenderer);};
a.prototype.removeContent=function(i){return this._mod(function(r){return this.removeAggregation("content",i,r);},this._canvasRenderer);};
a.prototype.removeAllContent=function(){return this._mod(function(r){return this.removeAllAggregation("content",r);},this._canvasRenderer);};
a.prototype.destroyContent=function(){return this._mod(function(r){return this.destroyAggregation("content",r);},this._canvasRenderer);};
a.prototype.insertSecondaryContent=function(o,i){return this._mod(function(r){return this.insertAggregation("secondaryContent",o,i,r);},this._paneRenderer);};
a.prototype.addSecondaryContent=function(o){return this._mod(function(r){return this.addAggregation("secondaryContent",o,r);},this._paneRenderer);};
a.prototype.removeSecondaryContent=function(i){return this._mod(function(r){return this.removeAggregation("secondaryContent",i,r);},this._paneRenderer);};
a.prototype.removeAllSecondaryContent=function(){return this._mod(function(r){return this.removeAllAggregation("secondaryContent",r);},this._paneRenderer);};
a.prototype.destroySecondaryContent=function(){return this._mod(function(r){return this.destroyAggregation("secondaryContent",r);},this._paneRenderer);};
})(window);return a;});
sap.ui.predefine('sap/ui/unified/SplitContainerRenderer',["sap/ui/core/library"],function(c){"use strict";var O=c.Orientation;var S={};
S.render=function(r,C){var i=C.getId();var v=C.getOrientation()==O.Vertical;r.write("<div");r.writeControlData(C);r.addClass("sapUiUfdSpltCont");r.addClass("sapUiUfdSpltCont"+(v?"V":"H"));if(sap.ui.getCore().getConfiguration().getAnimation()){r.addClass("sapUiUfdSpltContAnim");}if(!C.getShowSecondaryContent()){r.addClass("sapUiUfdSpltContPaneHidden");}r.writeClasses();r.write(">");var s=i+"-canvas";r.write("<section id='",s,"' class='sapUiUfdSpltContCanvas'>");this.renderContent(r,s,C.getContent(),C._bRootContent);r.write("</section>");var a=i+"-pane";var w=C.getShowSecondaryContent()?C.getSecondaryContentSize():"0";r.write("<aside id='",a,"' style='width:",w,"'");r.addClass("sapUiUfdSpltContPane");if(!C.getShowSecondaryContent()){r.addClass("sapUiUfdSplitContSecondClosed");}r.writeClasses();r.write(">");this.renderContent(r,a,C.getSecondaryContent(),C._bRootContent);r.write("</aside>");r.write("</div>");};
S.renderContent=function(r,I,C,R){r.write("<div id='",I,"cntnt' class='sapUiUfdSpltContCntnt'");if(R){r.writeAttribute("data-sap-ui-root-content","true");}r.write(">");for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/calendar/CalendarDate',['sap/ui/base/Object','sap/ui/core/date/UniversalDate',"sap/ui/thirdparty/jquery"],function(B,U,q){"use strict";
var C=B.extend("sap.ui.unified.calendar.CalendarDate",{constructor:function(){var A=arguments,j,n,s;switch(A.length){case 0:n=new Date();return this.constructor(n.getFullYear(),n.getMonth(),n.getDate());case 1:case 2:if(!(A[0]instanceof C)){throw"Invalid arguments: the first argument must be of type sap.ui.unified.calendar.CalendarDate.";}s=A[1]?A[1]:A[0]._oUDate.sCalendarType;j=new Date(A[0].valueOf());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());j.setHours(j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());this._oUDate=c(j,s);break;case 3:case 4:d(A[0],"Invalid year: "+A[0]);d(A[1],"Invalid month: "+A[1]);d(A[2],"Invalid date: "+A[2]);j=new Date(0,0,1);j.setFullYear(A[0],A[1],A[2]);if(A[3]){s=A[3];}this._oUDate=c(j,s);break;default:throw"Invalid arguments. Accepted arguments are: 1) oCalendarDate, (optional)calendarType"+"or 2) year, month, date, (optional) calendarType"+A;}}});
C.prototype.getYear=function(){return this._oUDate.getUTCFullYear();};
C.prototype.setYear=function(y){d(y,"Invalid year: "+y);this._oUDate.setUTCFullYear(y);return this;};
C.prototype.getMonth=function(){return this._oUDate.getUTCMonth();};
C.prototype.setMonth=function(m){d(m,"Invalid month: "+m);this._oUDate.setUTCMonth(m);return this;};
C.prototype.getDate=function(){return this._oUDate.getUTCDate();};
C.prototype.setDate=function(e){d(e,"Invalid date: "+e);this._oUDate.setUTCDate(e);return this;};
C.prototype.getDay=function(){return this._oUDate.getUTCDay();};
C.prototype.getCalendarType=function(){return this._oUDate.sCalendarType;};
C.prototype.isBefore=function(o){b(o);return this.valueOf()<o.valueOf();};
C.prototype.isAfter=function(o){b(o);return this.valueOf()>o.valueOf();};
C.prototype.isSameOrBefore=function(o){b(o);return this.valueOf()<=o.valueOf();};
C.prototype.isSameOrAfter=function(o){b(o);return this.valueOf()>=o.valueOf();};
C.prototype.isSame=function(o){b(o);return this.valueOf()===o.valueOf();};
C.prototype.toLocalJSDate=function(){var l=new Date(this._oUDate.getTime());l.setFullYear(l.getUTCFullYear(),l.getUTCMonth(),l.getUTCDate());l.setHours(0,0,0,0);return l;};
C.prototype.toUTCJSDate=function(){var u=new Date(this._oUDate.getTime());u.setUTCHours(0,0,0,0);return u;};
C.prototype.toString=function(){return this._oUDate.sCalendarType+": "+this.getYear()+"/"+(this.getMonth()+1)+"/"+this.getDate();};
C.prototype.valueOf=function(){return this._oUDate.getTime();};
C.fromLocalJSDate=function(j,s){if(q.type(j)!=="date"){throw new Error("Date parameter must be a JavaScript Date object: ["+j+"].");}return new C(j.getFullYear(),j.getMonth(),j.getDate(),s);};
function c(D,s){if(s){return U.getInstance(a(D),s);}else{return new U(a(D).getTime());}}
function a(D){var u=new Date(Date.UTC(0,0,1));u.setUTCFullYear(D.getFullYear(),D.getMonth(),D.getDate());return u;}
function b(o){if(!(o instanceof C)){throw"Invalid calendar date: ["+o+"]. Expected: sap.ui.unified.calendar.CalendarDate";}}
function d(v,m){if(v==undefined||v===Infinity||isNaN(v)){throw m;}}
return C;});
sap.ui.predefine('sap/ui/unified/calendar/CalendarUtils',['sap/ui/core/date/UniversalDate','./CalendarDate','sap/ui/core/Locale','sap/ui/core/LocaleData',"sap/ui/thirdparty/jquery"],function(U,C,L,a,q){"use strict";var b={};b.MAX_MILLISECONDS=8640000000000000;b.HOURS24=1000*3600*24;
b._createLocalDate=function(d,t){var l;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}l=new Date(m.getUTCFullYear(),m.getUTCMonth(),m.getUTCDate());if(m.getFullYear()<1000){l.setFullYear(m.getFullYear());}if(t){l.setHours(m.getUTCHours());l.setMinutes(m.getUTCMinutes());l.setSeconds(m.getUTCSeconds());l.setMilliseconds(m.getUTCMilliseconds());}}return l;};
b._createUTCDate=function(d,t){var u;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}u=new Date(Date.UTC(m.getFullYear(),m.getMonth(),m.getDate()));if(m.getFullYear()<1000){u.setUTCFullYear(m.getFullYear());}if(t){u.setUTCHours(m.getHours());u.setUTCMinutes(m.getMinutes());u.setUTCSeconds(m.getSeconds());u.setUTCMilliseconds(m.getMilliseconds());}}return u;};
b._createUniversalUTCDate=function(d,c,t){var u;if(c){u=U.getInstance(this._createUTCDate(d,t),c);}else{u=new U(this._createUTCDate(d,t).getTime());}return u;};
b.calculateWeekNumber=function(d,y,l,o){var w=0;var W=0;var f=o.getFirstDayOfWeek();var c=new L(l);if(c&&(c.getLanguage()=='en'&&c.getRegion()=='US')){var j=new U(d.getTime());j.setUTCFullYear(y,0,1);W=j.getUTCDay();var e=new U(d.getTime());e.setUTCDate(e.getUTCDate()-e.getUTCDay()+W);w=Math.round((e.getTime()-j.getTime())/86400000/7)+1;}else{var t=new U(d.getTime());t.setUTCDate(t.getUTCDate()-f);W=t.getUTCDay();t.setUTCDate(t.getUTCDate()-W+4);var F=new U(t.getTime());F.setUTCMonth(0,1);W=F.getUTCDay();var A=0;if(W>4){A=7;}var g=new U(F.getTime());g.setUTCDate(1-W+4+A);w=Math.round((t.getTime()-g.getTime())/86400000/7)+1;}return w;};
b.getFirstDateOfWeek=function(d){var u=new U(d.getTime()),f,F,l=a.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),c=l.getFirstDayOfWeek(),w;w=U.getWeekByDate(u.getCalendarType(),u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate());f=U.getFirstDateOfWeek(u.getCalendarType(),w.year,w.week);F=new U(Date.UTC(f.year,f.month,f.day));while(F.getUTCDay()!==c){F.setUTCDate(F.getUTCDate()-1);}return new U(Date.UTC(F.getUTCFullYear(),F.getUTCMonth(),F.getUTCDate(),d.getUTCHours(),d.getUTCMinutes(),d.getUTCSeconds())).getJSDate();};
b.getFirstDateOfMonth=function(d){var n=new U(d.getTime());n.setUTCDate(1);return n;};
b._getNumberOfWeeksForYear=function(y){var l=sap.ui.getCore().getConfiguration().getFormatLocale(),o=a.getInstance(new L(l)),c=new Date(Date.UTC(y,0,1)),i=c.getUTCDay(),n=52;if(o.getFirstDayOfWeek()===0){if(i===5||i===6){n=53;}}else{if(i===3||i===4){n=53;}}return n;};
b.monthsDiffer=function(d,D){return(d.getMonth()!==D.getMonth()||d.getFullYear()!==D.getFullYear());};
b.isDateLastInMonth=function(d){var n=new Date(d.getTime()+24*60*60*1000);return n.getUTCDate()<d.getUTCDate();};
b._updateUTCDate=function(d,y,m,D,h,M,s,i){if(q.isNumeric(y)){d.setUTCFullYear(y);}if(q.isNumeric(m)){d.setUTCMonth(m);}if(q.isNumeric(D)){d.setUTCDate(D);}if(q.isNumeric(h)){d.setUTCHours(h);}if(q.isNumeric(M)){d.setUTCMinutes(M);}if(q.isNumeric(s)){d.setUTCSeconds(s);}if(q.isNumeric(i)){d.setUTCMilliseconds(i);}};
b._checkJSDateObject=function(d){if(q.type(d)!=="date"){throw new Error("Date must be a JavaScript date object.");}};
b._checkYearInValidRange=function(y){if(!q.isNumeric(y)||(y<1||y>9999)){throw new Error("Year must be in valid range (between year 0001 and year 9999).");}};
b._isNextMonth=function(d,D){return(d.getMonth()>D.getMonth()&&d.getFullYear()===D.getFullYear())||d.getFullYear()>D.getFullYear();};
b._daysInMonth=function(c){this._checkCalendarDate(c);c=new C(c);c.setDate(1);c.setMonth(c.getMonth()+1);c.setDate(0);return c.getDate();};
b._isLastDateInMonth=function(c){return c.getDate()===b._daysInMonth(c);};
b._getFirstDateOfWeek=function(c){this._checkCalendarDate(c);var j=b.getFirstDateOfWeek(c.toUTCJSDate());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
b._getFirstDateOfMonth=function(c){this._checkCalendarDate(c);var j=b.getFirstDateOfMonth(c.toUTCJSDate()).getJSDate();j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
b._minDate=function(c){return new C(1,0,1,c);};
b._maxDate=function(c){var o=new C(9999,11,1,c);o.setDate(this._daysInMonth(o));return new C(o);};
b._isBetween=function(d,s,e,i){this._checkCalendarDate(d);this._checkCalendarDate(s);this._checkCalendarDate(e);if(i){return d.isSameOrAfter(s)&&d.isSameOrBefore(e);}else{return d.isAfter(s)&&d.isBefore(e);}};
b._daysBetween=function(f,s){this._checkCalendarDate(f);this._checkCalendarDate(s);return Math.ceil((f.valueOf()-s.valueOf())/(this.HOURS24));};
b._isOutside=function(c,s,e){return!this._isBetween(c,s,e,true);};
b._isSameMonthAndYear=function(c,o){this._checkCalendarDate(c);this._checkCalendarDate(o);return c.getYear()===o.getYear()&&c.getMonth()===o.getMonth();};
b._checkCalendarDate=function(c){if(!c||!(c instanceof C)){throw"Invalid calendar date: ["+c+"]. Expected: sap.ui.unified.calendar.CalendarDate";}};
b._getWeek=function(c){this._checkCalendarDate(c);return U.getWeekByDate(c.getCalendarType(),c.getYear(),c.getMonth(),c.getDate());};
return b;},true);
sap.ui.predefine('sap/ui/unified/calendar/DatesRow',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/Month','sap/ui/unified/library',"./DatesRowRenderer","sap/ui/thirdparty/jquery"],function(C,a,M,l,D,q){"use strict";
var b=M.extend("sap.ui.unified.calendar.DatesRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true}}}});
b.prototype.init=function(){M.prototype.init.apply(this,arguments);this._iColumns=1;this._aWeekNumbers=[];};
b.prototype.setStartDate=function(s){C._checkJSDateObject(s);var y=s.getFullYear();C._checkYearInValidRange(y);this.setProperty("startDate",s,true);this._oStartDate=a.fromLocalJSDate(s,this.getPrimaryCalendarType());if(this.getDomRef()){var o=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(s);this._bNoRangeCheck=false;if(o&&this.checkDateFocusable(o)){this.displayDate(o);}}return this;};
b.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=a.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oStartDate;};
b.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.setDate.apply(this,arguments);return this;};
b.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.displayDate.apply(this,arguments);return this;};
b.prototype.setPrimaryCalendarType=function(c){M.prototype.setPrimaryCalendarType.apply(this,arguments);if(this._oStartDate){this._oStartDate=new a(this._oStartDate,c);}return this;};
b.prototype.setFirstDayOfWeek=function(f){if(f==-1){return this.setProperty("firstDayOfWeek",f,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};
b.prototype._handleBorderReached=function(c){var e=c.getParameter("event");var d=this.getDays();var o=this._getDate();var f=new a(o,this.getPrimaryCalendarType());if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":f.setDate(f.getDate()+1);break;case"sapprevious":case"sappreviousmodifiers":f.setDate(f.getDate()-1);break;case"sappagedown":f.setDate(f.getDate()+d);break;case"sappageup":f.setDate(f.getDate()-d);break;default:break;}this.fireFocus({date:f.toLocalJSDate(),otherMonth:true,_outsideBorder:true});}};
b.prototype.checkDateFocusable=function(d){C._checkJSDateObject(d);if(this._bNoRangeCheck){return false;}var s=this._getStartDate();var e=new a(s,this.getPrimaryCalendarType());e.setDate(e.getDate()+this.getDays());var c=a.fromLocalJSDate(d,this.getPrimaryCalendarType());return c.isSameOrAfter(s)&&c.isBefore(e);};
b.prototype._renderHeader=function(){var s=this._getStartDate();var S=s.getDay();var L=this._getLocaleData();var w=this.$("Names").children();var W=[];if(this._bLongWeekDays||!this._bNamesLengthChecked){W=L.getDaysStandAlone("abbreviated");}else{W=L.getDaysStandAlone("narrow");}var c=L.getDaysStandAlone("wide");var i=0;for(i=0;i<w.length;i++){var $=q(w[i]);$.text(W[(i+S)%7]);$.attr("aria-label",c[(i+S)%7]);}if(this._getShowHeader()){var d=this.$("Head");if(d.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(r,this,L,s);r.flush(d[0]);r.destroy();}}};
b.prototype._getFirstWeekDay=function(){return this._getStartDate().getDay();};
b.prototype.getWeekNumbers=function(){var d=this.getDays(),L=this._getLocale(),o=this._getLocaleData(),c=this.getPrimaryCalendarType(),s=this._getStartDate(),e=new a(s,c),E=new a(s,c).setDate(e.getDate()+d),f=[];while(e.isBefore(E)){f.push(new a(e,c));e.setDate(e.getDate()+1);}this._aWeekNumbers=f.reduce(function(w,g){var W=C.calculateWeekNumber(g.toUTCJSDate(),g.getYear(),L,o);if(!w.length||w[w.length-1].number!==W){w.push({len:0,number:W});}w[w.length-1].len++;return w;},[]);return this._aWeekNumbers;};
b.prototype._getCachedWeekNumbers=function(){return this._aWeekNumbers;};
return b;});
sap.ui.predefine('sap/ui/unified/calendar/DatesRowRenderer',['sap/ui/core/Renderer','sap/ui/unified/calendar/CalendarDate','./MonthRenderer'],function(R,C,M){"use strict";var D=R.extend(M);
D.getStartDate=function(d){return d._getStartDate();};
D.getClass=function(r,d){var c="sapUiCalDatesRow sapUiCalRow";if(!d.getShowDayNamesLine()){c=c+" sapUiCalNoNameLine";}return c;};
D.renderMonth=function(r,d,o){M.renderMonth.apply(this,arguments);this.renderWeekNumbers(r,d);};
D.renderWeekNumbers=function(r,d){var o,i,a,w;if(d.getShowWeekNumbers()&&d.getPrimaryCalendarType()===sap.ui.core.CalendarType.Gregorian){o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");r.write("<div id=\""+d.getId()+"-weeks\"");r.addClass("sapUiCalRowWeekNumbers");r.writeClasses();r.write(">");i=d.getDays();a=100/i;w=d.getWeekNumbers();w.forEach(function(W){r.write("<div");r.addClass('sapUiCalRowWeekNumber');r.writeClasses();r.addStyle("width",W.len*a+"%");r.writeStyles();r.writeAttribute("data-sap-ui-week",W.number);r.write(">"+o.getText('CALENDAR_DATES_ROW_WEEK_NUMBER',[W.number])+"</div>");});r.write("</div>");}};
D.renderHeader=function(r,d,o){var l=d._getLocaleData();var i=d.getId();var a=d.getDays();var w="";if(d._getShowHeader()){r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,d,l,o);r.write("</div>");}w=(100/a)+"%";if(d.getShowDayNamesLine()){r.write("<div id=\""+i+"-Names\" style=\"display: inline;\">");this.renderDayNames(r,d,l,o.getDay(),a,false,w);r.write("</div>");}};
D.renderHeaderLine=function(r,d,l,o){var I=d.getId();var a=d.getDays();var b=new C(o,d.getPrimaryCalendarType());var w="";var m=0;var c=[];var i=0;for(i=0;i<a;i++){m=b.getMonth();if(c.length>0&&c[c.length-1].iMonth==m){c[c.length-1].iDays++;}else{c.push({iMonth:m,iDays:1});}b.setDate(b.getDate()+1);}var e=l.getMonthsStandAlone("wide");for(i=0;i<c.length;i++){var f=c[i];w=(100/a*f.iDays)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(e[f.iMonth]);r.write("</div>");}};
D.renderDays=function(r,d,o){var a=d.getDays();var w=(100/a)+"%";var s=d.getShowDayNamesLine();if(!o){o=d._getFocusedDate();}var h=this.getDayHelper(d,o);if(!s){if(d._bLongWeekDays||!d._bNamesLengthChecked){h.aWeekDays=h.oLocaleData.getDaysStandAlone("abbreviated");}else{h.aWeekDays=h.oLocaleData.getDaysStandAlone("narrow");}h.aWeekDaysWide=h.oLocaleData.getDaysStandAlone("wide");}var b=new C(o,d.getPrimaryCalendarType());for(var i=0;i<a;i++){this.renderDay(r,d,b,h,false,false,i,w,!s);b.setDate(b.getDate()+1);}};
return D;},true);
sap.ui.predefine('sap/ui/unified/calendar/Header',['sap/ui/core/Control','sap/ui/unified/library',"./HeaderRenderer","sap/ui/dom/containsOrEquals"],function(C,l,H,c){"use strict";
var a=C.extend("sap.ui.unified.calendar.Header",{metadata:{library:"sap.ui.unified",properties:{textButton0:{type:"string",group:"Appearance"},additionalTextButton0:{type:"string",group:"Appearance"},ariaLabelButton0:{type:"string",group:"Misc"},visibleButton0:{type:"boolean",group:"Appearance",defaultValue:false},textButton1:{type:"string",group:"Appearance"},additionalTextButton1:{type:"string",group:"Appearance"},ariaLabelButton1:{type:"string",group:"Misc"},visibleButton1:{type:"boolean",group:"Appearance",defaultValue:true},textButton2:{type:"string",group:"Appearance"},additionalTextButton2:{type:"string",group:"Appearance"},ariaLabelButton2:{type:"string",group:"Misc"},visibleButton2:{type:"boolean",group:"Appearance",defaultValue:true},enabledPrevious:{type:"boolean",group:"Behavior",defaultValue:true},enabledNext:{type:"boolean",group:"Behavior",defaultValue:true}},events:{pressPrevious:{},pressNext:{},pressButton0:{},pressButton1:{},pressButton2:{}}}});
a.prototype.setTextButton0=function(t){_.call(this,0,t);return this;};
a.prototype.setAdditionalTextButton0=function(t){b.call(this,0,t);return this;};
a.prototype.setAriaLabelButton0=function(t){d.call(this,0,t);return this;};
a.prototype.setTextButton1=function(t){_.call(this,1,t);return this;};
a.prototype.setAdditionalTextButton1=function(t){b.call(this,1,t);return this;};
a.prototype.setAriaLabelButton1=function(t){d.call(this,1,t);return this;};
a.prototype.setTextButton2=function(t){_.call(this,2,t);return this;};
a.prototype.setAdditionalTextButton2=function(t){b.call(this,2,t);return this;};
a.prototype.setAriaLabelButton2=function(t){d.call(this,2,t);return this;};
a.prototype._setVisibleButton3=function(v){this._visibleButton3=v;this.invalidate();return this;};
a.prototype._getVisibleButton3=function(){return this._visibleButton3;};
a.prototype._setTextButton3=function(t){e.call(this,3,t);return this;};
a.prototype._getTextButton3=function(){return this._textButton3;};
a.prototype._setAdditionalTextButton3=function(t){f.call(this,3,t);return this;};
a.prototype._getAdditionalTextButton3=function(){return this._additionalTextButton3;};
a.prototype._setAriaLabelButton3=function(t){g.call(this,3,t);return this;};
a.prototype._getAriaLabelButton3=function(){return this._ariaLabelButton3;};
a.prototype._setVisibleButton4=function(v){this._visibleButton4=v;this.invalidate();return this;};
a.prototype._getVisibleButton4=function(){return this._visibleButton4;};
a.prototype._setTextButton4=function(t){e.call(this,4,t);return this;};
a.prototype._getTextButton4=function(){return this._textButton4;};
a.prototype._setAdditionalTextButton4=function(t){f.call(this,4,t);return this;};
a.prototype._getAdditionalTextButton4=function(){return this._additionalTextButton4;};
a.prototype._setAriaLabelButton4=function(t){g.call(this,4,t);return this;};
a.prototype._getAriaLabelButton4=function(){return this._ariaLabelButton4;};
a.prototype.setEnabledPrevious=function(E){this.setProperty("enabledPrevious",E,true);if(this.getDomRef()){if(E){this.$("prev").toggleClass("sapUiCalDsbl",false).removeAttr("disabled");}else{this.$("prev").toggleClass("sapUiCalDsbl",true).attr("disabled","disabled");}}return this;};
a.prototype.setEnabledNext=function(E){this.setProperty("enabledNext",E,true);if(this.getDomRef()){if(E){this.$("next").toggleClass("sapUiCalDsbl",false).removeAttr("disabled");}else{this.$("next").toggleClass("sapUiCalDsbl",true).attr("disabled","disabled");}}return this;};
a.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(c(this.getDomRef("prev"),E.target)&&this.getEnabledPrevious()){this.firePressPrevious();}else if(c(this.getDomRef("next"),E.target)&&this.getEnabledNext()){this.firePressNext();}else if(c(this.getDomRef("B0"),E.target)){this.firePressButton0();}else if(c(this.getDomRef("B1"),E.target)){this.firePressButton1();}else if(c(this.getDomRef("B2"),E.target)){this.firePressButton2();}else if(c(this.getDomRef("B3"),E.target)){this.fireEvent("pressButton3");}else if(c(this.getDomRef("B4"),E.target)){this.fireEvent("pressButton4");}};
a.prototype.onsapnext=function(E){E.preventDefault();};
function _(B,t){this.setProperty("textButton"+B,t,true);if(this.getDomRef()&&this["getVisibleButton"+B]()){if(this.$("B"+B+"-Text").get(0)){this.$("B"+B+"-Text").text(t);}else{this.$("B"+B).text(t);}}}
function b(B,t){var r=false;var o=this["getAdditionalTextButton"+B]();if(o==t){return;}if((!o&&t)||(o&&!t)){r=true;}this.setProperty("additionalTextButton"+B,t,!r);if(!r&&this.getDomRef()&&this["getVisibleButton"+B]()){this.$("B"+B+"-AddText").text(t);}}
function d(B,t){this.setProperty("ariaLabelButton"+B,t,true);if(this.getDomRef()&&this["getVisibleButton"+B]()){if(t){this.$("B"+B).attr("aria-label",t);}else{this.$("B"+B).removeAttr("aria-label");}}}
function e(B,t){this["_textButton"+B]=t;if(this.isActive()&&this["_getVisibleButton"+B]()){if(this.$("B"+B+"-Text").get(0)){this.$("B"+B+"-Text").text(t);}else{this.$("B"+B).text(t);}}}
function f(B,t){var r=false;var o=this["_getAdditionalTextButton"+B]();if(o==t){return;}if((!o&&t)||(o&&!t)){r=true;}this["_additionalTextButton"+B]=t;if(!r&&this.isActive()&&this["_getVisibleButton"+B]()){this.$("B"+B+"-AddText").text(t);}if(r){this.invalidate();}}
function g(B,t){this["_ariaLabelButton"+B]=t;if(this.isActive()&&this["_getVisibleButton"+B]()){if(t){this.$("B"+B).attr("aria-label",t);}else{this.$("B"+B).removeAttr("aria-label");}}}
return a;});
sap.ui.predefine('sap/ui/unified/calendar/HeaderRenderer',["sap/base/security/encodeXML"],function(e){"use strict";var M=5;var H={};
H.render=function(r,h){var l=sap.ui.getCore().getConfiguration().getLocale().getLanguage();var t=h.getTooltip_AsString();var I=h.getId();var a={};var L=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_NEXT");var s=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_PREV");r.write("<div");r.writeControlData(h);r.addClass("sapUiCalHead");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(h);r.write(">");r.write("<button");r.writeAttributeEscaped('id',I+'-prev');r.writeAttributeEscaped("title",s);r.writeAccessibilityState(null,{label:s});r.addClass("sapUiCalHeadPrev");if(!h.getEnabledPrevious()){r.addClass("sapUiCalDsbl");r.writeAttribute('disabled',"disabled");}r.writeAttribute('tabindex',"-1");r.writeClasses();r.write(">");r.writeIcon("sap-icon://slim-arrow-left",null,{title:null});r.write("</button>");var f=-1;var b=-1;var i=0;var B;for(i=0;i<M;i++){if(this.getVisibleButton(h,i)){if(f<0){f=i;}b=i;}}for(i=0;i<M;i++){if(l.toLowerCase()==="ja"||l.toLowerCase()==="zh"){B=M-1-i;}else{B=i;}this.renderCalendarButtons(r,h,I,f,b,a,B);}r.write("<button");r.writeAttributeEscaped('id',I+'-next');r.writeAttributeEscaped("title",L);r.writeAccessibilityState(null,{label:L});r.addClass("sapUiCalHeadNext");if(!h.getEnabledNext()){r.addClass("sapUiCalDsbl");r.writeAttribute('disabled',"disabled");}r.writeAttribute('tabindex',"-1");r.writeClasses();r.write(">");r.writeIcon("sap-icon://slim-arrow-right",null,{title:null});r.write("</button>");r.write("</div>");};
H.renderCalendarButtons=function(r,h,I,f,l,a,i){if(this.getVisibleButton(h,i)){r.write("<button");r.writeAttributeEscaped('id',I+'-B'+i);r.addClass("sapUiCalHeadB");r.addClass("sapUiCalHeadB"+i);if(f==i){r.addClass("sapUiCalHeadBFirst");}if(l==i){r.addClass("sapUiCalHeadBLast");}r.writeAttribute('tabindex',"-1");r.writeClasses();if(this.getAriaLabelButton(h,i)){a["label"]=e(this.getAriaLabelButton(h,i));}r.writeAccessibilityState(null,a);a={};r.write(">");var t=this.getTextButton(h,i)||"";var A=this.getAdditionalTextButton(h,i)||"";if(A){r.write("<span");r.writeAttributeEscaped('id',I+'-B'+i+"-Text");r.addClass("sapUiCalHeadBText");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</span>");r.write("<span");r.writeAttributeEscaped('id',I+'-B'+i+"-AddText");r.addClass("sapUiCalHeadBAddText");r.writeClasses();r.write(">");r.writeEscaped(A);r.write("</span>");}else{r.writeEscaped(t);}r.write("</button>");}};
H.getVisibleButton=function(h,b){var v=false;if(h["getVisibleButton"+b]){v=h["getVisibleButton"+b]();}else if(h["_getVisibleButton"+b]){v=h["_getVisibleButton"+b]();}return v;};
H.getAriaLabelButton=function(h,b){var a;if(h["getAriaLabelButton"+b]){a=h["getAriaLabelButton"+b]();}else if(h["_getAriaLabelButton"+b]){a=h["_getAriaLabelButton"+b]();}return a;};
H.getTextButton=function(h,b){var t;if(h["getTextButton"+b]){t=h["getTextButton"+b]();}else if(h["_getTextButton"+b]){t=h["_getTextButton"+b]();}return t;};
H.getAdditionalTextButton=function(h,b){var t;if(h["getAdditionalTextButton"+b]){t=h["getAdditionalTextButton"+b]();}else if(h["_getAdditionalTextButton"+b]){t=h["_getAdditionalTextButton"+b]();}return t;};
return H;},true);
sap.ui.predefine('sap/ui/unified/calendar/Month',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,L,I,a,b,l,c,d,e,M,f,K,q){"use strict";var g=d.CalendarType;var h=l.CalendarDayType;
var j=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}}}}});
j.prototype.init=function(){var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._oFormatYyyymmdd=c.getInstance({pattern:"yyyyMMdd",calendarType:g.Gregorian});this._oFormatLong=c.getInstance({style:"long",calendarType:i});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._iColumns=7;this._aVisibleDays=[];};
j.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}this._aVisibleDays=null;};
j.prototype.onAfterRendering=function(){_.call(this);t.call(this);};
j.prototype.onmouseover=function(E){var T=q(E.target),S,i,u;if(!this.getIntervalSelection()){return;}S=this.getSelectedDates()[0];if(!S||!S.getStartDate()||S.getEndDate()){return;}if(!T.hasClass('sapUiCalItemText')&&!T.hasClass('sapUiCalItem')){return;}if(T.hasClass('sapUiCalItemText')){T=T.parent();}i=parseInt(this._oFormatYyyymmdd.format(S.getStartDate()),10);u=T.data("sapDay");if(i>u){i=i+u;u=i-u;i=i-u;}if(this.hasListeners("datehovered")){this.fireEvent("datehovered",{date1:i,date2:u});}else{this._markDatesBetweenStartAndHoveredDate(i,u);}};
j.prototype._markDatesBetweenStartAndHoveredDate=function(u,v){var w,$,x,i;w=this.$().find(".sapUiCalItem");for(i=0;i<w.length;i++){$=q(w[i]);x=$.data('sapDay');if(x>u&&x<v){$.addClass('sapUiCalItemSelBetween');}else{$.removeClass('sapUiCalItemSelBetween');}}};
j.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!f(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(true);var S=this._selectDay(this._getDate());if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;s.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}}};
j.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
j.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
j.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
j.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
j.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("disabledDates");return R;};
j.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
j.prototype.setDate=function(i){var u=b.fromLocalJSDate(i,this.getPrimaryCalendarType());n.call(this,u,false);return this;};
j.prototype._setDate=function(i){var u=i.toLocalJSDate();this.setProperty("date",u,true);this._oDate=i;};
j.prototype._getDate=function(){if(!this._oDate){this._oDate=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oDate;};
j.prototype.displayDate=function(i){var u=b.fromLocalJSDate(i,this.getPrimaryCalendarType());n.call(this,u,true);return this;};
j.prototype.setPrimaryCalendarType=function(i){this.setProperty("primaryCalendarType",i);this._oFormatLong=c.getInstance({style:"long",calendarType:i});if(this._oDate){this._oDate=new b(this._oDate,i);}return this;};
j.prototype.setSecondaryCalendarType=function(i){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",i);this.invalidate();this._oFormatSecondaryLong=c.getInstance({style:"long",calendarType:i});return this;};
j.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};
j.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
j.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var u=new e(i);this._oLocaleData=L.getInstance(u);}return this._oLocaleData;};
j.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var u=new e(i);this._oFormatLong=c.getInstance({style:"long",calendarType:this.getPrimaryCalendarType()},u);if(this._oFormatSecondaryLong){this._oFormatSecondaryLong=c.getInstance({style:"long",calendarType:this._getSecondaryCalendarType()},u);}}return this._oFormatLong;};
j.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
j.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
j.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
j.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
j.prototype.getDisabledDates=function(){var P=this.getParent();if(P&&P.getDisabledDates){return P.getDisabledDates();}else{return this.getAggregation("disabledDates",[]);}};
j.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowMonthHeader){return P._getShowMonthHeader();}else{return this.getProperty("showHeader");}};
j.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
j.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("legend",[]);}};
j.prototype._getFirstDayOfWeek=function(){var P=this.getParent();var F=0;if(P&&P.getFirstDayOfWeek){F=P.getFirstDayOfWeek();}else{F=this.getProperty("firstDayOfWeek");}if(F<0||F>6){var i=this._getLocaleData();F=i.getFirstDayOfWeek();}return F;};
j.prototype._getNonWorkingDays=function(){var P=this.getParent();var N;if(P&&P.getNonWorkingDays){N=P.getNonWorkingDays();}else{N=this.getProperty("nonWorkingDays");}if(N&&!Array.isArray(N)){N=[];}return N;};
j.prototype._checkDateSelected=function(u){a._checkCalendarDate(u);var S=0;var v=this.getSelectedDates();var T=u.toUTCJSDate().getTime();var w=this.getPrimaryCalendarType();for(var i=0;i<v.length;i++){var R=v[i];var x=R.getStartDate();var y=0;if(x){x=b.fromLocalJSDate(x,w);y=x.toUTCJSDate().getTime();}var E=R.getEndDate();var z=0;if(E){E=b.fromLocalJSDate(E,w);z=E.toUTCJSDate().getTime();}if(T==y&&!E){S=1;break;}else if(T==y&&E){S=2;if(E&&T==z){S=5;}break;}else if(E&&T==z){S=3;break;}else if(E&&T>y&&T<z){S=4;break;}if(this.getSingleSelection()){break;}}return S;};
j.prototype._getDateTypes=function(u){a._checkCalendarDate(u);var T,v,N,w=[];var S=this.getSpecialDates();var x=u.toUTCJSDate().getTime();var y=this.getPrimaryCalendarType();for(var i=0;i<S.length;i++){var R=S[i];var z=R.getStartDate();var A=a.MAX_MILLISECONDS;if(z){z=b.fromLocalJSDate(z,y);A=z.toUTCJSDate().getTime();}var E=R.getEndDate();var B=-a.MAX_MILLISECONDS;if(E){E=b.fromLocalJSDate(E,y);B=E.toUTCJSDate().getTime();}N=R.getType()===h.NonWorking;if((x==A&&!E)||(x>=A&&x<=B)){if(!N&&!T){T={type:R.getType(),tooltip:R.getTooltip_AsString()};w.push(T);}else if(N&&!v){v={type:R.getType(),tooltip:R.getTooltip_AsString()};w.push(v);}if(T&&v){break;}}}return w;};
j.prototype._checkDateEnabled=function(u){a._checkCalendarDate(u);var E=true;var v=this.getDisabledDates();var T=u.toUTCJSDate().getTime();var w=this.getPrimaryCalendarType();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(T<P._oMinDate.valueOf()||T>P._oMaxDate.valueOf()){return false;}}for(var i=0;i<v.length;i++){var R=v[i];var S=R.getStartDate();var x=0;if(S){S=b.fromLocalJSDate(S,w);x=S.toUTCJSDate().getTime();}var y=R.getEndDate();var z=0;if(y){y=b.fromLocalJSDate(y,w);z=y.toUTCJSDate().getTime();}if(y){if(T>x&&T<z){E=false;break;}}else if(T==x){E=false;break;}}return E;};
j.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
j.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(this._sLastTargetId&&this._sLastTargetId==T.attr("id")){return;}this._sLastTargetId=T.attr("id");if(T.hasClass("sapUiCalItem")){var O=this._getDate();if(!f(this.getDomRef(),E.target)){var S=this.getSelectedDates();if(S.length>0&&this.getSingleSelection()){var i=S[0].getStartDate();if(i){i=b.fromLocalJSDate(i,this.getPrimaryCalendarType());}var u=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(T.attr("data-sap-day")));if(u.isSameOrAfter(i)){p.call(this,i,u);}else{p.call(this,u,i);}}}else{var F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(T.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F.isSame(O)){if(T.hasClass("sapUiCalItemOtherMonth")){this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}else{this._setDate(F);var v=this._selectDay(F,true);if(v){this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}this._bMoveChange=true;}}}}};
j.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
j.prototype.onmouseup=function(E){if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var u=this._oItemNavigation.getItemDomRefs();for(var i=0;i<u.length;i++){var $=q(u[i]);if(!$.hasClass("sapUiCalItemOtherMonth")){if($.attr("data-sap-day")==this._oFormatYyyymmdd.format(F.toUTCJSDate(),true)){$.focus();break;}}}if(this._bMoveChange){var S=this._selectDay(F);if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;s.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)&&(E.target.classList.contains("sapUiCalItemText")||E.target.classList.contains("sapUiCalDayName"))){var v=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(E.target).parent().attr("data-sap-day")),this.getPrimaryCalendarType());this._selectDay(v,false,false);s.call(this);}};
j.prototype.onsapselect=function(E){var S=this._selectDay(this._getDate());if(S){s.call(this);}E.stopPropagation();E.preventDefault();};
j.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
j.prototype.onsappageupmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y-10);}else{F.setYear(y-1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
j.prototype.onsappagedownmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y+10);}else{F.setYear(y+1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
j.prototype._updateSelection=function(){var S=this.getSelectedDates();if(S.length>0){var i=this.getPrimaryCalendarType();var u=S.map(function(v){var w=v.getStartDate();if(w){return b.fromLocalJSDate(w,i);}});var E=S[0].getEndDate();if(E){E=b.fromLocalJSDate(E,i);}p.call(this,u,E);}};
j.prototype._isValueInThreshold=function(R,v,T){var i=R-T,u=R+T;return v>=i&&v<=u;};
j.prototype._bindMousemove=function(F){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};
j.prototype._unbindMousemove=function(F){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(F){this.fireEvent("_unbindMousemove");}};
j.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var w=this.$().find(".sapUiCalWH");var u=this._getLocaleData();var S=this._getFirstWeekDay();var v=u.getDaysStandAlone("abbreviated",this.getPrimaryCalendarType());for(var i=0;i<w.length;i++){var W=w[i];q(W).text(v[(i+S)%7]);}t.call(this);};
j.prototype._handleBorderReached=function(i){var E=i.getParameter("event");var u=0;var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==K.ARROW_DOWN){F.setDate(F.getDate()+7);}else{F.setDate(F.getDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==K.ARROW_UP){F.setDate(F.getDate()-7);}else{F.setDate(F.getDate()-1);}break;case"sappagedown":u=F.getMonth()+1;F.setMonth(u);if(u%12!=F.getMonth()){while(u!=F.getMonth()){F.setDate(F.getDate()-1);}}break;case"sappageup":u=F.getMonth()-1;F.setMonth(u);if(u<0){u=11;}if(u!=F.getMonth()){while(u!=F.getMonth()){F.setDate(F.getDate()-1);}}break;default:break;}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}};
j.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);var u=this._getDate();var v=b.fromLocalJSDate(i,this.getPrimaryCalendarType());return a._isSameMonthAndYear(v,u);};
j.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
j.prototype._renderHeader=function(){if(this._getShowHeader()){var i=this._getDate();var u=this._getLocaleData();var v=u.getMonthsStandAlone("wide",this.getPrimaryCalendarType());this.$("Head").text(v[i.getMonth()]);}};
j.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek();};
j.prototype._isMonthNameLong=function(w){var i;var W;for(i=0;i<w.length;i++){W=w[i];if(Math.abs(W.clientWidth-W.scrollWidth)>1){return true;}}return false;};
j.prototype._getVisibleDays=function(S,i){var N,u,v,w,F,x,y;if(!S){return this._aVisibleDays;}this._aVisibleDays=[];x=this._getFirstDayOfWeek();F=new b(S,this.getPrimaryCalendarType());F.setDate(1);w=F.getDay()-x;if(w<0){w=7+w;}if(w>0){F.setDate(1-w);}u=new b(F);N=(S.getMonth()+1)%12;do{y=u.getYear();v=new b(u,this.getPrimaryCalendarType());if(i&&y<1){v._bBeforeFirstYear=true;this._aVisibleDays.push(v);}else if(y>0&&y<10000){this._aVisibleDays.push(v);}u.setDate(u.getDate()+1);}while(u.getMonth()!==N||u.getDay()!==x);return this._aVisibleDays;};
j.prototype._handleMousedown=function(E,F,i){var T=(D.browser.msie||D.browser.edge)&&navigator.maxTouchPoints,w=E.target.classList.contains("sapUiCalWeekNum"),u=!E.button;if(!u||D.support.touch||(w&&(u||T))){return;}var S=this._selectDay(F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){this._unbindMousemove(true);this._bMoveChange=false;this._oMoveSelectedDate=undefined;}else if(S&&this.getIntervalSelection()&&this.$().is(":visible")){this._bindMousemove(true);this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}E.preventDefault();E.setMark("cancelAutoClose");};
j.prototype._selectDay=function(u,v){if(!this._checkDateEnabled(u)){return false;}var S=this.getSelectedDates();var w;var x=this._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=this.getParent();var A=this;var z;var B=this.getPrimaryCalendarType();if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){w=S[0];z=w.getStartDate();if(z){z=b.fromLocalJSDate(z,B);}}else{w=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",w,true);}if(this.getIntervalSelection()&&(!w.getEndDate()||v)&&z){var E;if(u.isBefore(z)){E=z;z=u;if(!v){w.setProperty("startDate",z.toLocalJSDate(),true);w.setProperty("endDate",E.toLocalJSDate(),true);}}else if(u.isSameOrAfter(z)){E=u;if(!v){w.setProperty("endDate",E.toLocalJSDate(),true);}}p.call(this,z,E);}else{p.call(this,u);w.setProperty("startDate",u.toLocalJSDate(),true);w.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var F=this._checkDateSelected(u);if(F>0){for(i=0;i<S.length;i++){z=S[i].getStartDate();if(z&&u.isSame(b.fromLocalJSDate(z,B))){A.removeAggregation("selectedDates",i,true);break;}}}else{w=new sap.ui.unified.DateRange({startDate:u.toLocalJSDate()});A.addAggregation("selectedDates",w,true);}y=this._oFormatYyyymmdd.format(u.toUTCJSDate(),true);for(i=0;i<x.length;i++){$=q(x[i]);if($.attr("data-sap-day")==y){if(F>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;};
function _(){var y=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var u=0;var R=this.$("days").get(0);var v=this.$("days").find(".sapUiCalItem");for(var i=0;i<v.length;i++){var $=q(v[i]);if($.attr("data-sap-day")===y){u=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,k,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,m,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(this._iColumns>1){this._oItemNavigation.setHomeEndColumnMode(true,true);}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this._iColumns,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(v);this._oItemNavigation.setFocusedIndex(u);this._oItemNavigation.setPageSize(v.length);}
function k(u){var v=u.getParameter("index");var E=u.getParameter("event");if(!E){return;}var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());var w=false;var x=true;var y=this._oItemNavigation.getItemDomRefs();var i=0;var $=q(y[v]);var z;if($.hasClass("sapUiCalItemOtherMonth")){if(E.type=="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){F.setDate(1);this._focusDate(F);}else if(E.type=="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(i=y.length-1;i>0;i--){z=q(y[i]);if(!z.hasClass("sapUiCalItemOtherMonth")){F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(z.attr("data-sap-day")),this.getPrimaryCalendarType());break;}}this._focusDate(F);}else{w=true;F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F){F=new b(O);}this._focusDate(O);if(E.type=="mousedown"||(this._sTouchstartYyyyMMdd&&E.type=="focusin"&&this._sTouchstartYyyyMMdd==$.attr("data-sap-day"))){x=false;this.fireFocus({date:O.toLocalJSDate(),otherMonth:false,restoreOldDate:true});}if(E.originalEvent&&E.originalEvent.type=="touchstart"){this._sTouchstartYyyyMMdd=$.attr("data-sap-day");}else{this._sTouchstartYyyyMMdd=undefined;}}}else{if(q(E.target).hasClass("sapUiCalWeekNum")){this._focusDate(F);}else{F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());this._setDate(F);}this._sTouchstartYyyyMMdd=undefined;}if(E.type=="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=$.attr("id");}if(x){this.fireFocus({date:F.toLocalJSDate(),otherMonth:w});}if(E.type=="mousedown"){this._handleMousedown(E,F,v);}}
function m(i){var u=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();if(this.getIntervalSelection()){var v=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=v[u].id;}this._handleMousedown(E,F,u);}}
function n(i,N){a._checkCalendarDate(i);var y=i.getYear();a._checkYearInValidRange(y);var F=true;if(!this.getDate()||!i.isSame(b.fromLocalJSDate(this.getDate(),i.getCalendarType()))){var u=new b(i);F=this.checkDateFocusable(i.toLocalJSDate());this.setProperty("date",i.toLocalJSDate(),true);this._oDate=u;}if(this.getDomRef()){if(F){this._focusDate(this._oDate,true,N);}else{o.call(this,N);}}}
j.prototype._focusDate=function(u,S,v){if(!S){this.setDate(u.toLocalJSDate());}var y=this._oFormatYyyymmdd.format(u.toUTCJSDate(),true);var w=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<w.length;i++){$=q(w[i]);if($.attr("data-sap-day")==y){if(document.activeElement!=w[i]){if(v){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}};
function o(N){var u=this.getRenderer().getStartDate(this);var $=this.$("days");var w=this.$("weeks");var v;var x;var i=0;var y=0;if(this._sLastTargetId){v=this._oItemNavigation.getItemDomRefs();for(i=0;i<v.length;i++){x=q(v[i]);if(x.attr("id")==this._sLastTargetId){y=i;break;}}}if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderDays(R,this,u);R.flush($[0]);if(w.length){this.getRenderer().renderWeekNumbers(R,this);R.flush(w[0]);}R.destroy();}this._renderHeader();this.fireEvent("_renderMonth",{days:$.find(".sapUiCalItem").length});_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}if(this._sLastTargetId){v=this._oItemNavigation.getItemDomRefs();if(y<=v.length-1){x=q(v[y]);this._sLastTargetId=x.attr("id");}}}
function p(S,E){if(!Array.isArray(S)){S=[S];}var u=this._oItemNavigation.getItemDomRefs();var $;var i=0;var v=false;var w=false;if(!E){var x=S.map(function(z){return this._oFormatYyyymmdd.format(z.toUTCJSDate(),true);},this);for(i=0;i<u.length;i++){$=q(u[i]);v=false;w=false;if(x.indexOf($.attr("data-sap-day"))>-1){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");v=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}r.call(this,$,v,w);}}else{var y;for(i=0;i<u.length;i++){$=q(u[i]);v=false;w=false;y=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),g.Gregorian);if(y.isSame(S[0])){$.addClass("sapUiCalItemSelStart");v=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&y.isSame(E)){$.addClass("sapUiCalItemSelEnd");w=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(y,S[0],E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&y.isSame(E)){$.addClass("sapUiCalItemSelEnd");w=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}r.call(this,$,v,w);}}}
function r($,S,E){if(!this.getIntervalSelection()){return;}var u="";var v=[];var w=this.getId();var x=false;u=$.attr("aria-describedby");if(u){v=u.split(" ");}var y=-1;var z=-1;for(var i=0;i<v.length;i++){var A=v[i];if(A==(w+"-Start")){y=i;}if(A==(w+"-End")){z=i;}}if(y>=0&&!S){v.splice(y,1);x=true;if(z>y){z--;}}if(z>=0&&!E){v.splice(z,1);x=true;}if(y<0&&S){v.push(w+"-Start");x=true;}if(z<0&&E){v.push(w+"-End");x=true;}if(x){u=v.join(" ");$.attr("aria-describedby",u);}}
function s(){if(this._bMouseMove){this._unbindMousemove(true);}this.fireSelect();}
function t(){if(!this._bNamesLengthChecked){var w;var W=this.$().find(".sapUiCalWH");var T=this._isMonthNameLong(W);var i=0;if(T){this._bLongWeekDays=false;var u=this._getLocaleData();var S=this._getFirstWeekDay();var v=u.getDaysStandAlone("narrow",this.getPrimaryCalendarType());for(i=0;i<W.length;i++){w=W[i];q(w).text(v[(i+S)%7]);}}else{this._bLongWeekDays=true;}this._bNamesLengthChecked=true;}}
return j;});
sap.ui.predefine('sap/ui/unified/calendar/MonthPicker',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/library','sap/ui/core/Locale',"./MonthPickerRenderer","sap/ui/thirdparty/jquery"],function(C,D,L,I,l,a,M,q){"use strict";
var c=C.extend("sap.ui.unified.calendar.MonthPicker",{metadata:{library:"sap.ui.unified",properties:{month:{type:"int",group:"Data",defaultValue:0},months:{type:"int",group:"Appearance",defaultValue:12},columns:{type:"int",group:"Appearance",defaultValue:3},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},events:{select:{},pageChange:{}}}});
c.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._iMinMonth=0;this._iMaxMonth=11;};
c.prototype.onAfterRendering=function(){_.call(this);j.call(this);};
c.prototype.setMonth=function(m){this.setProperty("month",m,true);m=this.getProperty("month");if(m<0||m>11){throw new Error("Property month must be between 0 and 11; "+this);}if(this.getDomRef()){if(this.getMonths()<12){var s=this.getStartMonth();if(m>=s&&m<=s+this.getMonths()-1){h.call(this,m,true);this._oItemNavigation.focusItem(m-s);}else{k.call(this,m);}}else{h.call(this,m,true);this._oItemNavigation.focusItem(m);}}return this;};
c.prototype._getLocale=function(){var p=this.getParent();if(p&&p._getLocale){return p._getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
c.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var o=new a(s);this._oLocaleData=L.getInstance(o);}return this._oLocaleData;};
c.prototype.onsapspace=function(E){E.preventDefault();};
c.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var m=i+this.getStartMonth();if(m>=this._iMinMonth&&m<=this._iMaxMonth){h.call(this,m);this.fireSelect();}};
c.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
c.prototype.onmouseup=function(E){if(this._bMousedownChange){this._bMousedownChange=false;this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){var i=this._oItemNavigation.getFocusedIndex();var m=i+this.getStartMonth();h.call(this,m);this.fireSelect();}};
c.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;var m=this._oItemNavigation.getItemDomRefs();this._bLongMonth=false;var o=this._getLocaleData();var b=o.getMonthsStandAlone("wide",this.getPrimaryCalendarType());for(var i=0;i<m.length;i++){var $=q(m[i]);$.text(b[i]);}j.call(this);};
c.prototype.nextPage=function(){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();m=m+b;if(m>11){m=11;}k.call(this,m);return this;};
c.prototype.previousPage=function(){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();m=m-b;if(m<0){m=0;}k.call(this,m);return this;};
c.prototype.setMinMax=function(m,b){if(m==this._iMinMonth&&b==this._iMaxMonth){return this;}m=parseInt(m,10);if(isNaN(m)||m<0||m>11){m=0;}b=parseInt(b,10);if(isNaN(b)||b<0||b>11){b=11;}if(m<=b){this._iMinMonth=m;this._iMaxMonth=b;}else{this._iMaxMonth=m;this._iMinMonth=b;}if(this.getDomRef()){var n=this._oItemNavigation.getItemDomRefs();var o=this.getId().length+2;for(var i=0;i<n.length;i++){var $=q(n[i]);var p=parseInt($.attr("id").slice(o),10);if(p<this._iMinMonth||p>this._iMaxMonth){$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}else{$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}}}return this;};
c.prototype.getStartMonth=function(){if(this.getMonths()<12){var F=this._oItemNavigation.getItemDomRefs()[0];return parseInt(F.id.slice(this.getId().length+2),10);}else{return 0;}};
c.prototype._isValueInThreshold=function(r,v,t){var i=r-t,u=r+t;return v>=i&&v<=u;};
function _(){var r=this.getDomRef();var b=this.$().find(".sapUiCalItem");var i=this.getColumns();var m=this.getMonths();var n=true;if(m<12){n=false;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,d,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,e,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,g,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(b);this._oItemNavigation.setCycling(n);this._oItemNavigation.setColumns(i,!n);var o=this.getMonth()-this.getStartMonth();this._oItemNavigation.setFocusedIndex(o);this._oItemNavigation.setPageSize(b.length);}
function d(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){f.call(this,E,i);}}
function e(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){f.call(this,E,i);}}
function f(E,i){if(E.button||D.support.touch){return;}var m=i+this.getStartMonth();if(m>=this._iMinMonth&&m<=this._iMaxMonth){h.call(this,m);this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");}
function g(o){var E=o.getParameter("event");if(E.type){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();switch(E.type){case"sapnext":case"sapnextmodifiers":if(m<11){m++;k.call(this,m,true);}break;case"sapprevious":case"sappreviousmodifiers":if(m>0){m--;k.call(this,m,true);}break;case"sappagedown":if(m<12-b){m=m+b;k.call(this,m,true);}break;case"sappageup":if(m>b){m=m-b;k.call(this,m,true);}break;default:break;}}}
function h(m,n){var b=this._oItemNavigation.getItemDomRefs();var $;var s=this.getId()+"-m"+m;for(var i=0;i<b.length;i++){$=q(b[i]);if($.attr("id")==s){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}}if(!n){this.setProperty("month",m,true);}}
function j(){if(!this._bNamesLengthChecked){var i=0;var m=this._oItemNavigation.getItemDomRefs();var t=false;var n=this.getMonths();var B=Math.ceil(12/n);var o=n-1;for(var b=0;b<B;b++){if(n<12){k.call(this,o);o=o+n;if(o>11){o=11;}}for(i=0;i<m.length;i++){var p=m[i];if(Math.abs(p.clientWidth-p.scrollWidth)>1){t=true;break;}}if(t){break;}}if(n<12){o=this.getMonth();k.call(this,o);}if(t){this._bLongMonth=false;var r=this._getLocaleData();var s=this.getPrimaryCalendarType();var u=r.getMonthsStandAlone("abbreviated",s);var v=r.getMonthsStandAlone("wide",s);for(i=0;i<m.length;i++){var $=q(m[i]);$.text(u[i]);$.attr("aria-label",v[i]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function k(m,F){var b=this._oItemNavigation.getItemDomRefs();if(b.legth>11){return;}var n=b.length;var s=Math.floor(m/n)*n;if(s+n>12){s=12-n;}var o=this._getLocaleData();var p=[];var r=[];var t=this.getPrimaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){p=o.getMonthsStandAlone("wide",t);}else{p=o.getMonthsStandAlone("abbreviated",t);r=o.getMonthsStandAlone("wide",t);}var S=this.getMonth();for(var i=0;i<b.length;i++){var u=i+s;var $=q(b[i]);$.text(p[i+s]);$.attr("id",this.getId()+"-m"+(i+s));if(!this._bLongMonth){$.attr("aria-label",r[i+s]);}if(u==S){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if(u<this._iMinMonth||u>this._iMaxMonth){$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}else{$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}}this._oItemNavigation.focusItem(m-s);if(F){this.firePageChange();}}
return c;});
sap.ui.predefine('sap/ui/unified/calendar/MonthPickerRenderer',[],function(){"use strict";var M={};
M.render=function(r,m){var a=m.getMonth();var b=m.getMonths();var s=0;var c=m.getColumns();var t=m.getTooltip_AsString();var l=m._getLocaleData();var I=m.getId();var w="";var d=[];var e=[];var C=m.getPrimaryCalendarType();if(m._bLongMonth||!m._bNamesLengthChecked){d=l.getMonthsStandAlone("wide",C);}else{d=l.getMonthsStandAlone("abbreviated",C);e=l.getMonthsStandAlone("wide",C);}r.write("<div");r.writeControlData(m);r.addClass("sapUiCalMonthPicker");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:"false"});r.write(">");var A;if(b>12){b=12;}else if(b<12){s=Math.floor(a/b)*b;if(s+b>12){s=12-b;}}if(c>0){w=(100/c)+"%";}else{w=(100/b)+"%";}for(var i=0;i<b;i++){var f=i+s;A={role:"gridcell"};if(!m._bLongMonth&&m._bNamesLengthChecked){A["label"]=e[f];}if(c>0&&i%c==0){r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");}r.write("<div");r.writeAttribute("id",I+"-m"+(f));r.addClass("sapUiCalItem");if(f==a){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(f<m._iMinMonth||f>m._iMaxMonth){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.addStyle("width",w);r.writeClasses();r.writeStyles();r.writeAccessibilityState(null,A);r.write(">");r.write(d[f]);r.write("</div>");if(c>0&&((i+1)%c==0)){r.write("</div>");}}r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthRenderer',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegend','sap/ui/unified/CalendarLegendRenderer','sap/ui/core/library','sap/ui/unified/library',"sap/base/Log"],function(C,a,b,c,d,l,L){"use strict";var e=l.CalendarDayType;var f=d.CalendarType;var M={};
M.render=function(r,m){var D=this.getStartDate(m);var t=m.getTooltip_AsString();var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var i=m.getId();var A={value:i+"-Descr",append:true};var w=m.getWidth();r.write("<div");r.writeControlData(m);r.addClass(this.getClass(r,m));if(m._getSecondaryCalendarType()){r.addClass("sapUiCalMonthSecType");}r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}if(w){r.addStyle("width",w);r.writeStyles();}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+g.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+g.getText("CALENDAR_START_DATE")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+g.getText("CALENDAR_END_DATE")+"</span>");}this.renderMonth(r,m,D);r.write("</div>");};
M.getStartDate=function(m){return m._getDate();};
M.getClass=function(r,m){var s="sapUiCalMonthView",g=m.getPrimaryCalendarType(),S=m.getShowWeekNumbers();if(g==f.Islamic||!S){s=s+" sapUiCalNoWeekNum";}return s;};
M.renderMonth=function(r,m,D){var i=m.getId();this.renderHeader(r,m,D);r.write("<div id=\""+i+"-days\" class=\"sapUiCalItems\">");this.renderDays(r,m,D);r.write("</div>");};
M.renderHeader=function(r,m,D){var o=m._getLocaleData();var F=m._getFirstDayOfWeek();var i=m.getId();var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this.renderHeaderLine(r,m,o,D);r.write("<div");r.writeAttribute("id",i+"-CW");r.addStyle("display","none");r.writeStyles();r.writeAccessibilityState(null,{role:"columnheader"});r.write(">");r.write(g.getText("CALENDAR_WEEK"));r.write("</div>");r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.addStyle("overflow","hidden");r.writeStyles();r.write(">");this.renderDayNames(r,m,o,F,7,true,undefined);r.write("</div>");};
M.renderHeaderLine=function(r,m,o,D){C._checkCalendarDate(D);if(m._getShowHeader()){var i=m.getId();var s=m.getPrimaryCalendarType();var g=o.getMonthsStandAlone("wide",s);r.write("<div id=\""+i+"-Head\"class=\"sapUiCalHeadText\" >");r.write(g[D.getMonth()]);r.write("</div>");}};
M.renderDayNames=function(r,m,o,s,D,g,w){var F=m._getFirstDayOfWeek();var I=m.getId();var h="";var j=m.getPrimaryCalendarType();var W=[];if(m._bLongWeekDays||!m._bNamesLengthChecked){W=o.getDaysStandAlone("abbreviated",j);}else{W=o.getDaysStandAlone("narrow",j);}var k=o.getDaysStandAlone("wide",j);for(var i=0;i<D;i++){r.write("<div");r.addClass("sapUiCalWH");if(g){h=I+"-WH"+((i+F)%7);}else{h=I+"-WH"+i;}r.writeAttribute("id",h);if(i==0){r.addClass("sapUiCalFirstWDay");}if(w){r.addStyle("width",w);}r.writeAccessibilityState(null,{role:"columnheader",label:k[(i+s)%7]});r.writeClasses();r.writeStyles();r.write(">");r.write(W[(i+s)%7]);r.write("</div>");}};
M.renderDays=function(r,m,D){var w,g,h,H,i,t,s;C._checkCalendarDate(D);if(!D){D=m._getFocusedDate();}t=D.toUTCJSDate().getTime();if(!t&&t!==0){throw new Error("Date is invalid "+m);}H=this.getDayHelper(m,D);g=m._getVisibleDays(D,true);s=m.getShowWeekNumbers();w=m.getPrimaryCalendarType()!==f.Islamic&&s;h=g.length;for(i=0;i<h;i++){this.renderDay(r,m,g[i],H,true,w,-1);}};
M.getDayHelper=function(m,D){var o,s,g=m._getLocaleData(),h={sLocale:m._getLocale(),oLocaleData:g,iMonth:D.getMonth(),iYear:D.getYear(),iFirstDayOfWeek:m._getFirstDayOfWeek(),iWeekendStart:g.getWeekendStart(),iWeekendEnd:g.getWeekendEnd(),aNonWorkingDays:m._getNonWorkingDays(),sToday:g.getRelativeDay(0),oToday:a.fromLocalJSDate(new Date(),m.getPrimaryCalendarType()),sId:m.getId(),oFormatLong:m._getFormatLong(),sSecondaryCalendarType:m._getSecondaryCalendarType(),oLegend:undefined};s=m.getLegend();if(s&&typeof s==="string"){o=sap.ui.getCore().byId(s);if(o){if(!(o instanceof b)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=o;}else{L.warning("CalendarLegend "+s+" does not exist!",m);}}return h;};
M.renderDay=function(r,m,D,h,o,w,n,W,g){C._checkCalendarDate(D);var s=new a(D,h.sSecondaryCalendarType),A={role:"gridcell",selected:false,label:"",describedby:""},B=D._bBeforeFirstYear,j="";var y=m._oFormatYyyymmdd.format(D.toUTCJSDate(),true);var k=D.getDay();var S=m._checkDateSelected(D);var p=m._getDateTypes(D);var E=m._checkDateEnabled(D);var i=0;if(B){E=false;}var q=0;if(w){q=C.calculateWeekNumber(D.toUTCJSDate(),h.iYear,h.sLocale,h.oLocaleData);A["describedby"]=h.sId+"-CW"+" "+h.sId+"-WNum-"+q;}if(!g){var t="";if(n<0){t=h.sId+"-WH"+k;}else{t=h.sId+"-WH"+n;}A["describedby"]=A["describedby"]+" "+t;}r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");r.addClass("sapUiCalWDay"+k);if(W){r.addStyle("width",W);}if(k==h.iFirstDayOfWeek){r.addClass("sapUiCalFirstWDay");}if(o&&h.iMonth!=D.getMonth()){r.addClass("sapUiCalItemOtherMonth");A["disabled"]=true;}if(D.isSame(h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sToday+" ";}if(S>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(S==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(S==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(S==4){r.addClass("sapUiCalItemSelBetween");}else if(S==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}p.forEach(function(u){if(u.type!=e.None){if(u.type===e.NonWorking){r.addClass("sapUiCalItemWeekEnd");return;}r.addClass("sapUiCalItem"+u.type);j=u.type;if(u.tooltip){r.writeAttributeEscaped('title',u.tooltip);}}});if(m.getParent()&&m.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval"&&D.getMonth()!==m.getStartDate().getMonth()){r.addClass("sapUiCalItemOtherMonth");}if(!E){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}if(h.aNonWorkingDays){for(i=0;i<h.aNonWorkingDays.length;i++){if(k==h.aNonWorkingDays[i]){r.addClass("sapUiCalItemWeekEnd");break;}}}else if((k>=h.iWeekendStart&&k<=h.iWeekendEnd)||(h.iWeekendEnd<h.iWeekendStart&&(k>=h.iWeekendStart||k<=h.iWeekendEnd))){r.addClass("sapUiCalItemWeekEnd");}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-day",y);if(g){A["label"]=A["label"]+h.aWeekDaysWide[k]+" ";}A["label"]=A["label"]+h.oFormatLong.format(D.toUTCJSDate(),true);if(j!==""){c.addCalendarTypeAccInfo(A,j,h.oLegend);}if(h.sSecondaryCalendarType){A["label"]=A["label"]+" "+m._oFormatSecondaryLong.format(s.toUTCJSDate(),true);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");if(!B){r.write(D.getDate());}r.write("</span>");if(w&&k==h.iFirstDayOfWeek){r.write("<span");r.writeAttribute("id",h.sId+"-WNum-"+q);r.addClass("sapUiCalWeekNum");r.writeClasses();r.writeAccessibilityState(null,{role:"rowheader",desribedby:h.sId+"-CW"});r.write(">");r.write(q);r.write("</span>");}if(g){r.write("<span");r.addClass("sapUiCalDayName");r.writeClasses();r.write(">");r.write(h.aWeekDays[k]);r.write("</span>");}if(h.sSecondaryCalendarType){r.write("<span");r.addClass("sapUiCalItemSecText");r.writeClasses();r.write(">");r.write(s.getDate());r.write("</span>");}r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthsRow',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthsRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(C,L,I,a,c,l,D,d,e,M,f,q){"use strict";var g=d.CalendarType;
var h=C.extend("sap.ui.unified.calendar.MonthsRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
h.prototype.init=function(){this._oFormatYyyymm=D.getInstance({pattern:"yyyyMMdd",calendarType:g.Gregorian});this._oFormatLong=D.getInstance({pattern:"MMMM y"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonths){clearTimeout(this._sInvalidateMonths);}};
h.prototype.onAfterRendering=function(){_.call(this);x.call(this);};
h.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!f(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){A.call(this,true);t.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;w.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this);}}};
h.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateMonths){if(this._bInvalidateSync){y.call(this);}else{this._sInvalidateMonths=setTimeout(y.bind(this),0);}}};
h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("selectedDates");return b;};
h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("specialDates");return b;};
h.prototype.setDate=function(b){o.call(this,c.fromLocalJSDate(b),false);return this;};
h.prototype._setDate=function(b){var i=b.toLocalJSDate();this.setProperty("date",i,true);this._oDate=b;};
h.prototype._getDate=function(){if(!this._oDate){this._oDate=new c();}return this._oDate;};
h.prototype.setStartDate=function(S){a._checkJSDateObject(S);var b,Y,O;Y=S.getFullYear();a._checkYearInValidRange(Y);b=c.fromLocalJSDate(S);this.setProperty("startDate",S,true);this._oStartDate=b;this._oStartDate.setDate(1);if(this.getDomRef()){O=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.setDate(O);}}return this;};
h.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=new c();this._oStartDate.setDate(1);}return this._oStartDate;};
h.prototype.displayDate=function(b){o.call(this,c.fromLocalJSDate(b),true);return this;};
h.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
h.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var b=this._getLocale();var i=new e(b);this._oLocaleData=L.getInstance(i);}return this._oLocaleData;};
h.prototype._getFormatLong=function(){var b=this._getLocale();if(this._oFormatLong.oLocale.toString()!=b){var i=new e(b);this._oFormatLong=D.getInstance({style:"long"},i);}return this._oFormatLong;};
h.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
h.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
h.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
h.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
h.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
h.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
h.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
h.prototype._checkDateSelected=function(b){var R,S,E,T,B=0,F=0,G=0,i,H,J;a._checkCalendarDate(b);H=this.getSelectedDates();J=new c(b);J.setDate(1);T=J.toUTCJSDate().getTime();for(i=0;i<H.length;i++){R=H[i];S=R.getStartDate();B=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);B=S.toUTCJSDate().getTime();}E=R.getEndDate();F=0;if(E){E=c.fromLocalJSDate(E);E.setDate(1);F=E.toUTCJSDate().getTime();}if(T==B&&!E){G=1;break;}else if(T==B&&E){G=2;if(E&&T==F){G=5;}break;}else if(E&&T==F){G=3;break;}else if(E&&T>B&&T<F){G=4;break;}if(this.getSingleSelection()){break;}}return G;};
h.prototype._getDateType=function(b){a._checkCalendarDate(b);var T,R,i,S,B=0,E,F=0,G,H=this.getSpecialDates(),J=new c(b);J.setDate(1);G=J.toUTCJSDate().getTime();for(i=0;i<H.length;i++){R=H[i];S=R.getStartDate();B=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);B=S.toUTCJSDate().getTime();}E=R.getEndDate();F=0;if(E){E=c.fromLocalJSDate(E);E.setDate(a._daysInMonth(E));F=E.toUTCJSDate().getTime();}if((G==B&&!E)||(G>=B&&G<=F)){T={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return T;};
h.prototype._checkMonthEnabled=function(b){a._checkCalendarDate(b);var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(a._isOutside(b,P._oMinDate,P._oMaxDate)){return false;}}return true;};
h.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){A.call(this,true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){var O=this._getDate();var F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);if(!F.isSame(O)){this._setDate(F);t.call(this,F,true);this._bMoveChange=true;}}};
h.prototype.onmouseup=function(E){if(this._bMouseMove){A.call(this,true);var F=this._getDate();var b=this._oItemNavigation.getItemDomRefs();for(var i=0;i<b.length;i++){var $=q(b[i]);if($.attr("data-sap-month")==this._oFormatYyyymm.format(F.toUTCJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);}t.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;w.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this);}};
h.prototype.onsapselect=function(E){var S=t.call(this,this._getDate());if(S){w.call(this);}E.stopPropagation();E.preventDefault();};
h.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
h.prototype.onsappageupmodifiers=function(E){var F=new c(this._getDate());var Y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(Y-10);}else{var i=this.getMonths();if(i<=12){F.setYear(Y-1);}else{F.setMonth(F.getMonth()-i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
h.prototype.onsappagedownmodifiers=function(E){var F=new c(this._getDate());var Y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(Y+10);}else{var i=this.getMonths();if(i<=12){F.setYear(Y+1);}else{F.setMonth(F.getMonth()+i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
h.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var b=this._getLocaleData();var B=b.getMonthsStandAlone("wide");var E=this.$("months").children();var F=this._getStartDate().getMonth();for(var i=0;i<E.length;i++){var $=q(q(E[i]).children(".sapUiCalItemText"));$.text(B[(i+F)%12]);}x.call(this);};
h.prototype.checkDateFocusable=function(b){a._checkJSDateObject(b);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new c(S);E.setDate(1);E.setMonth(E.getMonth()+this.getMonths());var i=c.fromLocalJSDate(b);return i.isSameOrAfter(S)&&i.isBefore(E);};
h.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
function _(){var b=this._getDate();var Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var B=0;var R=this.$("months").get(0);var E=this.$("months").children(".sapUiCalItem");for(var i=0;i<E.length;i++){var $=q(E[i]);if($.attr("data-sap-month")===Y){B=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,j,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,k,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,m,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(E);this._oItemNavigation.setFocusedIndex(B);this._oItemNavigation.setPageSize(E.length);}
function j(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}var O=this._getDate();var F=new c(O);var B=this._oItemNavigation.getItemDomRefs();var $=q(B[i]);F=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));F.setDate(1);this._setDate(F);this.fireFocus({date:F.toLocalJSDate(),notVisible:false});if(E.type=="mousedown"){n.call(this,E,F,i);}}
function k(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();n.call(this,E,F,i);}}
function m(b){var E=b.getParameter("event");var i=this.getMonths();var O=this._getDate();var F=new c(O);if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setMonth(F.getMonth()+1);break;case"sapprevious":case"sappreviousmodifiers":F.setMonth(F.getMonth()-1);break;case"sappagedown":F.setMonth(F.getMonth()+i);break;case"sappageup":F.setMonth(F.getMonth()-i);break;default:break;}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});}}
function n(E,F,i){if(E.button){return;}var S=t.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){A.call(this,true);this._bMoveChange=false;}else if(S&&this.getIntervalSelection()&&this.$().is(":visible")){z.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function o(b,N){a._checkCalendarDate(b);var Y=b.getYear();a._checkYearInValidRange(Y);var F=true;if(!this.getDate()||!b.isSame(c.fromLocalJSDate(this.getDate()))){var i=new c(b);i.setDate(1);F=this.checkDateFocusable(b.toLocalJSDate());if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",b.toLocalJSDate(),true);this._oDate=i;}if(this.getDomRef()){if(F){p.call(this,this._oDate,N);}else{r.call(this,N);}}}
function p(b,N){var Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var B=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<B.length;i++){$=q(B[i]);if($.attr("data-sap-month")==Y){if(document.activeElement!=B[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function r(N){var b=this._getStartDate();var $=this.$("months");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderMonths(R,this,b);R.flush($[0]);R.destroy();}s.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}
function s(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var b=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,b,S);R.flush($[0]);R.destroy();}}}
function t(b,B){if(!this._checkMonthEnabled(b)){return false;}var S=this.getSelectedDates();var E;var F=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var G=this;var H;if(P&&P.getSelectedDates){G=P;}if(this.getSingleSelection()){if(S.length>0){E=S[0];H=E.getStartDate();if(H){H=c.fromLocalJSDate(H);H.setDate(1);}}else{E=new sap.ui.unified.DateRange();G.addAggregation("selectedDates",E,true);}if(this.getIntervalSelection()&&(!E.getEndDate()||B)&&H){var J;if(b.isBefore(H)){J=H;H=b;if(!B){E.setProperty("startDate",H.toLocalJSDate(),true);E.setProperty("endDate",J.toLocalJSDate(),true);}}else if(b.isSameOrAfter(H)){J=b;if(!B){E.setProperty("endDate",J.toLocalJSDate(),true);}}u.call(this,H,J);}else{u.call(this,b);E.setProperty("startDate",b.toLocalJSDate(),true);E.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var K=this._checkDateSelected(b);if(K>0){for(i=0;i<S.length;i++){H=S[i].getStartDate();if(H){H=c.fromLocalJSDate(H);H.setDate(1);if(b.isSame(H)){G.removeAggregation("selectedDates",i,true);break;}}}}else{E=new sap.ui.unified.DateRange({startDate:b.toLocalJSDate()});G.addAggregation("selectedDates",E,true);}Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);for(i=0;i<F.length;i++){$=q(F[i]);if($.attr("data-sap-month")==Y){if(K>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function u(S,E){var b=this._oItemNavigation.getItemDomRefs();var $;var i=0;var B=false;var F=false;if(!E){var Y=this._oFormatYyyymm.format(S.toUTCJSDate(),true);for(i=0;i<b.length;i++){$=q(b[i]);B=false;F=false;if($.attr("data-sap-month")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");B=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}v.call(this,$,B,F);}}else{var G;for(i=0;i<b.length;i++){$=q(b[i]);B=false;F=false;G=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));G.setDate(1);if(G.isSame(S)){$.addClass("sapUiCalItemSelStart");B=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&G.isSame(E)){$.addClass("sapUiCalItemSelEnd");F=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(G,S,E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&G.isSame(E)){$.addClass("sapUiCalItemSelEnd");F=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}v.call(this,$,B,F);}}}
function v($,S,E){if(!this.getIntervalSelection()){return;}var b="";var B=[];var F=this.getId();var G=false;b=$.attr("aria-describedby");if(b){B=b.split(" ");}var H=-1;var J=-1;for(var i=0;i<B.length;i++){var K=B[i];if(K==(F+"-Start")){H=i;}if(K==(F+"-End")){J=i;}}if(H>=0&&!S){B.splice(H,1);G=true;if(J>H){J--;}}if(J>=0&&!E){B.splice(J,1);G=true;}if(H<0&&S){B.push(F+"-Start");G=true;}if(J<0&&E){B.push(F+"-End");G=true;}if(G){b=B.join(" ");$.attr("aria-describedby",b);}}
function w(){if(this._bMouseMove){A.call(this,true);}this.fireSelect();}
function x(){if(!this._bNamesLengthChecked){var i=0;var B=this.$("months").children();var T=false;var E=this.getMonths();var F=Math.ceil(12/E);var G=0;var H=this._getLocaleData();var J=H.getMonthsStandAlone("wide");var $;for(var b=0;b<F;b++){if(E<12){for(i=0;i<B.length;i++){$=q(q(B[i]).children(".sapUiCalItemText"));$.text(J[(i+G)%12]);}G=G+E;if(G>11){G=11;}}for(i=0;i<B.length;i++){var K=B[i];if(Math.abs(K.clientWidth-K.scrollWidth)>1){T=true;break;}}if(T){break;}}if(E<12){G=this._getStartDate().getMonth();for(i=0;i<B.length;i++){$=q(q(B[i]).children(".sapUiCalItemText"));$.text(J[(i+G)%12]);}}if(T){this._bLongMonth=false;var N=H.getMonthsStandAlone("abbreviated");G=this._getStartDate().getMonth();for(i=0;i<B.length;i++){$=q(q(B[i]).children(".sapUiCalItemText"));$.text(N[(i+G)%12]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function y(){this._sInvalidateMonths=undefined;r.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}
function z(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function A(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
return h;});
sap.ui.predefine('sap/ui/unified/calendar/MonthsRowRenderer',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegendRenderer','sap/ui/unified/library',"sap/base/Log"],function(C,a,b,l,L){"use strict";var c=l.CalendarDayType;var M={};
M.render=function(r,m){var d=m._getStartDate();var t=m.getTooltip_AsString();var i=m.getId();var A={value:i+"-Descr",append:true};r.write("<div");r.writeControlData(m);r.addClass("sapUiCalMonthsRow");r.addClass("sapUiCalRow");r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+m._rb.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+m._rb.getText("CALENDAR_START_MONTH")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+m._rb.getText("CALENDAR_END_MONTH")+"</span>");}this.renderRow(r,m,d);r.write("</div>");};
M.renderRow=function(r,m,d){var i=m.getId();this.renderHeader(r,m,d);r.write("<div id=\""+i+"-months\" class=\"sapUiCalItems\">");this.renderMonths(r,m,d);r.write("</div>");};
M.renderHeader=function(r,m,d){C._checkCalendarDate(d);if(m._getShowHeader()){var o=m._getLocaleData();var i=m.getId();r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,m,o,d);r.write("</div>");}};
M.renderHeaderLine=function(r,m,o,d){C._checkCalendarDate(d);var I=m.getId();var e=m.getMonths();var f=new a(d);var w="";var y=0;var Y=[];var i=0;for(i=0;i<e;i++){y=f.getYear();if(Y.length>0&&Y[Y.length-1].iYear==y){Y[Y.length-1].iMonths++;}else{Y.push({iYear:y,iMonths:1});}f.setMonth(f.getMonth()+1);}for(i=0;i<Y.length;i++){var g=Y[i];w=(100/e*g.iMonths)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(g.iYear);r.write("</div>");}};
M.renderMonths=function(r,m,d){var h=this.getHelper(m,d);var e=m.getMonths();var w=(100/e)+"%";var o=new a(d);o.setDate(1);for(var i=0;i<e;i++){this.renderMonth(r,m,o,h,w);o.setMonth(o.getMonth()+1);}};
M.getHelper=function(m,d){C._checkCalendarDate(d);var h={};h.sLocale=m._getLocale();h.oLocaleData=m._getLocaleData();h.oToday=new a();h.sCurrentMonth=m._rb.getText("CALENDAR_CURRENT_MONTH");h.sId=m.getId();h.oFormatLong=m._getFormatLong();if(m._bLongMonth||!m._bNamesLengthChecked){h.aMonthNames=h.oLocaleData.getMonthsStandAlone("wide");}else{h.aMonthNames=h.oLocaleData.getMonthsStandAlone("abbreviated");h.aMonthNamesWide=h.oLocaleData.getMonthsStandAlone("wide");}var s=m.getLegend();if(s){var o=sap.ui.getCore().byId(s);if(o){if(!(o instanceof sap.ui.unified.CalendarLegend)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=o;}else{L.warning("CalendarLegend "+s+" does not exist!",m);}}return h;};
M.renderMonth=function(r,m,d,h,w){C._checkCalendarDate(d);var A={role:"gridcell",selected:false,label:"",describedby:""};if(!m._bLongMonth&&m._bNamesLengthChecked){A["label"]=h.aMonthNamesWide[d.getMonth()];}var y=m._oFormatYyyymm.format(d.toUTCJSDate(),true);var s=m._checkDateSelected(d);var t=m._getDateType(d);var e=m._checkMonthEnabled(d);r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");if(w){r.addStyle("width",w);}if(C._isSameMonthAndYear(d,h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sCurrentMonth+" ";}if(s>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}if(s==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(s==4){r.addClass("sapUiCalItemSelBetween");}else if(s==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(t&&t.type!=c.None){r.addClass("sapUiCalItem"+t.type);if(t.tooltip){r.writeAttributeEscaped('title',t.tooltip);}}if(!e){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-month",y);A["label"]=A["label"]+h.oFormatLong.format(d.toUTCJSDate(),true);if(t&&t.type!=c.None){b.addCalendarTypeAccInfo(A,t.type,h.oLegend);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");r.write(h.aMonthNames[d.getMonth()]);r.write("</span>");r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRow',['sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library',"./OneMonthDatesRowRenderer"],function(D,C,a,l,O){"use strict";
var b=D.extend("sap.ui.unified.calendar.OneMonthDatesRow",{metadata:{library:"sap.ui.unified"}});
b.prototype.init=function(){D.prototype.init.apply(this,arguments);this.iMode=2;};
b.prototype.setMode=function(m){var s=this.getSelectedDates(),S,c=this.iMode!==m;this.iMode=m;if(c&&s.length){if(this.iMode<2){S=this.getStartDate();}s[0].setProperty('startDate',S,true);}return this;};
b.prototype.getMode=function(){return this.iMode;};
b.prototype.selectDate=function(d){if(this.iMode<2&&this.getSelectedDates().length){this.getSelectedDates()[0].setStartDate(d);}return this;};
b.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.setDate.apply(this,arguments);return this;};
b.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.displayDate.apply(this,arguments);return this;};
b.prototype.onsaphome=function(e){var c=a.fromLocalJSDate(this.getStartDate());i(e);this._setDate(c);this._focusDate(c);this.fireFocus({date:c.toLocalJSDate(),otherMonth:false});};
b.prototype.onsapend=function(e){var s=this.getStartDate(),L;L=a.fromLocalJSDate(s);L.setDate(C._daysInMonth(L));i(e);this._setDate(L);this._focusDate(L);this.fireFocus({date:L.toLocalJSDate(),otherMonth:false});};
function i(e){e.stopPropagation();e.preventDefault();e.stopImmediatePropagation(true);}
return b;});
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRowRenderer',['sap/ui/core/Renderer','./MonthRenderer','./DatesRowRenderer'],function(R,M,D){"use strict";var O=R.extend(D);["getClass","renderMonth","renderDays","renderHeader"].forEach(function(h){O[h]=function(r,d){if(d.iMode<2){return M[h].apply(M,arguments);}else{return D[h].apply(D,arguments);}};});return O;},true);
sap.ui.predefine('sap/ui/unified/calendar/TimesRow',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./TimesRowRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/thirdparty/jquery"],function(C,L,I,a,U,l,D,c,b,T,d,e,q){"use strict";var f=c.CalendarType;
var g=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
g.prototype.init=function(){this._oFormatYyyyMMddHHmm=D.getInstance({pattern:"yyyyMMddHHmm",calendarType:f.Gregorian});this._oFormatLong=D.getDateTimeInstance({style:"long/short"});this._oFormatDate=D.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
g.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateTimes){clearTimeout(this._sInvalidateTimes);}};
g.prototype.onAfterRendering=function(){_.call(this);};
g.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!d(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){y.call(this,true);s.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;v.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;v.call(this);}}};
g.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateTimes){if(this._bInvalidateSync){w.call(this);}else{this._sInvalidateTimes=setTimeout(w.bind(this),0);}}};
g.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
g.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
g.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
g.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
g.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};
g.prototype.setDate=function(i){n.call(this,i,false);return this;};
g.prototype._setDate=function(i){var z=a._createLocalDate(i,true);this.setProperty("date",z,true);this._oUTCDate=i;};
g.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};
g.prototype.setStartDate=function(S){a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);var i=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S,true);this._oUTCStartDate=this._getIntervalStart(i);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};
g.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};
g.prototype.displayDate=function(i){n.call(this,i,true);return this;};
g.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
g.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var z=new b(i);this._oLocaleData=L.getInstance(z);}return this._oLocaleData;};
g.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var z=new b(i);this._oFormatLong=D.getInstance({style:"long/short"},z);}return this._oFormatLong;};
g.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var z=new b(i);var A=this.getIntervalMinutes();var B=this._getLocaleData();var P;this._oFormatTimeAmPm=undefined;if(A%60==0){P=B.getPreferredHourSymbol();if(B.getTimePattern("short").search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},z);}}else{P=B.getTimePattern("short");P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},z);P=P.replace("a","").trim();}}this._oFormatTime=D.getTimeInstance({pattern:P},z);}return this._oFormatTime;};
g.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var z=new b(i);this._oFormatDate=D.getDateInstance({style:"medium"},z);}return this._oFormatDate;};
g.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
g.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
g.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
g.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
g.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
g.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};
g.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
g.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
g.prototype._checkDateSelected=function(z){if(!(z instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var A=this.getSelectedDates();var M=new U(z.getTime());M=this._getIntervalStart(M);var B=M.getTime();for(var i=0;i<A.length;i++){var R=A[i];var E=R.getStartDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);F=E.getTime();}var G=R.getEndDate();var H=0;if(G){G=a._createUniversalUTCDate(G,undefined,true);G=this._getIntervalStart(G);H=G.getTime();}if(B==F&&!G){S=1;break;}else if(B==F&&G){S=2;if(G&&B==H){S=5;}break;}else if(G&&B==H){S=3;break;}else if(G&&B>F&&B<H){S=4;break;}if(this.getSingleSelection()){break;}}return S;};
g.prototype._getDateType=function(z){if(!(z instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var A;var S=this.getSpecialDates();var M=new U(z.getTime());M=this._getIntervalStart(M);var B=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var E=R.getStartDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);F=E.getTime();}var G=R.getEndDate();var H=0;if(G){G=a._createUniversalUTCDate(G,undefined,true);G=this._getIntervalStart(G);G.setUTCMinutes(G.getUTCMinutes()+this.getIntervalMinutes()-1);H=G.getTime();}else if(E.getUTCHours()==0&&E.getUTCMinutes()==0&&E.getUTCSeconds()==0&&E.getUTCMilliseconds()==0){G=new U(E.getTime());G.setUTCDate(G.getUTCDate()+1);H=G.getTime();}if((B==F&&!G)||(B>=F&&B<=H)){A={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return A;};
g.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var z=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(z<P._oMinDate.getTime()||z>P._oMaxDate.getTime()){return false;}}return true;};
g.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){y.call(this,true);}var $=q(E.target);if($.hasClass("sapUiCalItemText")){$=$.parent();}if($.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._setDate(F);s.call(this,F,true);this._bMoveChange=true;}}};
g.prototype.onmouseup=function(E){if(this._bMouseMove){y.call(this,true);var F=this._getDate();var z=this._oItemNavigation.getItemDomRefs();for(var i=0;i<z.length;i++){var $=q(z[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var A=q(E.target);if(A.hasClass("sapUiCalItemText")){A=A.parent();}if(A.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(A.attr("data-sap-time"),true).getTime());}s.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;v.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;v.call(this);}};
g.prototype.onsapselect=function(E){var S=s.call(this,this._getDate());if(S){v.call(this);}E.stopPropagation();E.preventDefault();};
g.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
g.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
g.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
g.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var z=a._createUniversalUTCDate(i,undefined,true);if(z.getTime()>=S.getTime()&&z.getTime()<E.getTime()){return true;}else{return false;}};
g.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
g.prototype._getIntervalStart=function(i){var z=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=z){S.setUTCMinutes(S.getUTCMinutes()+M);}var A=new U(S.getTime());A.setUTCMinutes(A.getUTCMinutes()-M);return A;};
function _(){var z=this._getDate();var Y=this._oFormatYyyyMMddHHmm.format(z.getJSDate(),true);var A=0;var R=this.$("times").get(0);var B=this.$("times").children(".sapUiCalItem");for(var i=0;i<B.length;i++){var $=q(B[i]);if($.attr("data-sap-time")===Y){A=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,h,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,j,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(B);this._oItemNavigation.setFocusedIndex(A);this._oItemNavigation.setPageSize(B.length);}
function h(i){var z=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var A=this._oItemNavigation.getItemDomRefs();var $=q(A[z]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._setDate(F);this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){m.call(this,E,F,z);}}
function j(i){var z=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();m.call(this,E,F,z);}}
function k(i){var E=i.getParameter("event");var z=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*z);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*z);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}
function m(E,F,i){if(E.button){return;}var S=s.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){y.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){x.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function n(i,N){a._checkJSDateObject(i);var Y=i.getFullYear();a._checkYearInValidRange(Y);var F=true;if(!e(this.getDate(),i)){var z=a._createUniversalUTCDate(i,undefined,true);z=this._getIntervalStart(z);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i,true);this._oUTCDate=z;}if(this.getDomRef()){if(F){o.call(this,this._oUTCDate,N);}else{p.call(this,N);}}}
function o(z,N){var Y=this._oFormatYyyyMMddHHmm.format(z.getJSDate(),true);var A=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<A.length;i++){$=q(A[i]);if($.attr("data-sap-time")==Y){if(document.activeElement!=A[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function p(N){var i=this._getStartDate();var $=this.$("times");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderTimes(R,this,i);R.flush($[0]);R.destroy();}r.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}
function r(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var i=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,i,S);R.flush($[0]);R.destroy();}}}
function s(z,M){if(!this._checkTimeEnabled(z)){return false;}var S=this.getSelectedDates();var A;var B=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var E=this;var F;if(P&&P.getSelectedDates){E=P;}if(this.getSingleSelection()){if(S.length>0){A=S[0];F=A.getStartDate();if(F){F=a._createUniversalUTCDate(F,undefined,true);F=this._getIntervalStart(F);}}else{A=new sap.ui.unified.DateRange();E.addAggregation("selectedDates",A,true);}if(this.getIntervalSelection()&&(!A.getEndDate()||M)&&F){var G;if(z.getTime()<F.getTime()){G=F;F=z;if(!M){A.setProperty("startDate",a._createLocalDate(new Date(F.getTime()),true),true);A.setProperty("endDate",a._createLocalDate(new Date(G.getTime()),true),true);}}else if(z.getTime()>=F.getTime()){G=z;if(!M){A.setProperty("endDate",a._createLocalDate(new Date(G.getTime()),true),true);}}t.call(this,F,G);}else{t.call(this,z);A.setProperty("startDate",a._createLocalDate(new Date(z.getTime()),true),true);A.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var H=this._checkDateSelected(z);if(H>0){for(i=0;i<S.length;i++){F=S[i].getStartDate();if(F){F=a._createUniversalUTCDate(F,undefined,true);F=this._getIntervalStart(F);if(z.getTime()==F.getTime()){E.removeAggregation("selectedDates",i,true);break;}}}}else{A=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(z.getTime()),true)});E.addAggregation("selectedDates",A,true);}Y=this._oFormatYyyyMMddHHmm.format(z.getJSDate(),true);for(i=0;i<B.length;i++){$=q(B[i]);if($.attr("data-sap-time")==Y){if(H>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function t(S,E){var z=this._oItemNavigation.getItemDomRefs();var $;var i=0;var A=false;var B=false;if(!E){var Y=this._oFormatYyyyMMddHHmm.format(S.getJSDate(),true);for(i=0;i<z.length;i++){$=q(z[i]);A=false;B=false;if($.attr("data-sap-time")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");A=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}u.call(this,$,A,B);}}else{var F;for(i=0;i<z.length;i++){$=q(z[i]);A=false;B=false;F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()==S.getTime()){$.addClass("sapUiCalItemSelStart");A=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&F.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");B=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&F.getTime()>S.getTime()&&F.getTime()<E.getTime()){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&F.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");B=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}u.call(this,$,A,B);}}}
function u($,S,E){if(!this.getIntervalSelection()){return;}var z="";var A=[];var B=this.getId();var F=false;z=$.attr("aria-describedby");if(z){A=z.split(" ");}var G=-1;var H=-1;for(var i=0;i<A.length;i++){var J=A[i];if(J==(B+"-Start")){G=i;}if(J==(B+"-End")){H=i;}}if(G>=0&&!S){A.splice(G,1);F=true;if(H>G){H--;}}if(H>=0&&!E){A.splice(H,1);F=true;}if(G<0&&S){A.push(B+"-Start");F=true;}if(H<0&&E){A.push(B+"-End");F=true;}if(F){z=A.join(" ");$.attr("aria-describedby",z);}}
function v(){if(this._bMouseMove){y.call(this,true);}this.fireSelect();}
function w(){this._sInvalidateTimes=undefined;p.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}
function x(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function y(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
return g;});
sap.ui.predefine('sap/ui/unified/calendar/TimesRowRenderer',['sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/CalendarLegendRenderer','sap/ui/unified/library',"sap/base/Log"],function(C,U,a,l,L){"use strict";var b=l.CalendarDayType;var T={};
T.render=function(r,t){var d=t._getStartDate();var s=t.getTooltip_AsString();var i=t.getId();var A={value:i+"-Descr",append:true};r.write("<div");r.writeControlData(t);r.addClass("sapUiCalTimesRow");r.addClass("sapUiCalRow");r.writeClasses();if(s){r.writeAttributeEscaped("title",s);}if(t._getShowHeader()){A.value=A.value+" "+i+"-Head";}r.writeAccessibilityState(t,{role:"grid",readonly:"true",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+t._rb.getText("CALENDAR_DIALOG")+"</span>");if(t.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+t._rb.getText("CALENDAR_START_TIME")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+t._rb.getText("CALENDAR_END_TIME")+"</span>");}this.renderRow(r,t,d);r.write("</div>");};
T.renderRow=function(r,t,d){var i=t.getId();this.renderHeader(r,t,d);r.write("<div id=\""+i+"-times\" class=\"sapUiCalItems\">");this.renderTimes(r,t,d);r.write("</div>");};
T.renderHeader=function(r,t,d){if(t._getShowHeader()){var o=t._getLocaleData();var i=t.getId();r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,t,o,d);r.write("</div>");}};
T.renderHeaderLine=function(r,t,o,d){var f=t._getFormatDate();var I=t.getId();var c=t.getItems();var e=t._getIntervalStart(d);var m=t.getIntervalMinutes();var w="";var D=0;var g=[];var i=0;for(i=0;i<c;i++){D=f.format(e,true);if(g.length>0&&g[g.length-1].sDay==D){g[g.length-1].iItems++;}else{g.push({sDay:D,iItems:1});}e.setUTCMinutes(e.getUTCMinutes()+m);}for(i=0;i<g.length;i++){var h=g[i];w=(100/c*h.iItems)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(h.sDay);r.write("</div>");}};
T.renderTimes=function(r,t,d){var h=this.getHelper(t,d);var I=t.getItems();var w=(100/I)+"%";var o=t._getIntervalStart(d);var O="";var A="";for(var i=0;i<I;i++){if(h.oFormatTimeAmPm){A=h.oFormatTimeAmPm.format(o,true);if(O==A){A="";}else{O=A;}}this.renderTime(r,t,o,h,w,A);o.setUTCMinutes(o.getUTCMinutes()+h.iMinutes);}};
T.getHelper=function(t,d){var h={};h.sLocale=t._getLocale();h.oLocaleData=t._getLocaleData();h.oNow=C._createUniversalUTCDate(new Date(),undefined,true);h.sCurrentTime=t._rb.getText("CALENDAR_CURRENT_TIME");h.sId=t.getId();h.oFormatLong=t._getFormatLong();h.oFormatTime=t._getFormatTime();h.oFormatTimeAmPm=t._oFormatTimeAmPm;h.iMinutes=t.getIntervalMinutes();var s=t.getLegend();if(s){var o=sap.ui.getCore().byId(s);if(o){if(!(o instanceof sap.ui.unified.CalendarLegend)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+t);}h.oLegend=o;}else{L.warning("CalendarLegend "+s+" does not exist!",t);}}return h;};
T.renderTime=function(r,t,d,h,w,A){var m={role:"gridcell",selected:false,label:"",describedby:""};var y=t._oFormatYyyyMMddHHmm.format(d.getJSDate(),true);var s=t._checkDateSelected(d);var o=t._getDateType(d);var e=t._checkTimeEnabled(d);r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");if(w){r.addStyle("width",w);}var n=new U(d.getTime());n.setUTCMinutes(n.getUTCMinutes()+h.iMinutes);if(d.getTime()<=h.oNow.getTime()&&n.getTime()>h.oNow.getTime()){r.addClass("sapUiCalItemNow");m["label"]=h.sCurrentTime+" ";}if(s>0){r.addClass("sapUiCalItemSel");m["selected"]=true;}if(s==2){r.addClass("sapUiCalItemSelStart");m["describedby"]=m["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.addClass("sapUiCalItemSelEnd");m["describedby"]=m["describedby"]+" "+h.sId+"-End";}else if(s==4){r.addClass("sapUiCalItemSelBetween");}else if(s==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");m["describedby"]=m["describedby"]+" "+h.sId+"-Start";m["describedby"]=m["describedby"]+" "+h.sId+"-End";}if(o&&o.type!=b.None){r.addClass("sapUiCalItem"+o.type);if(o.tooltip){r.writeAttributeEscaped('title',o.tooltip);}}if(!e){r.addClass("sapUiCalItemDsbl");m["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-time",y);m["label"]=m["label"]+h.oFormatLong.format(d,true);if(o&&o.type!=b.None){a.addCalendarTypeAccInfo(m,o.type,h.oLegend);}r.writeAccessibilityState(null,m);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");r.write(h.oFormatTime.format(d,true));if(A){r.write("<span");r.addClass("sapUiCalItemTextAmPm");r.writeClasses();r.write(">");r.write(A);r.write("</span>");}r.write("</span>");r.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/unified/calendar/YearPicker',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library',"./YearPickerRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,I,a,b,U,l,c,d,Y,K,q){"use strict";var e=d.CalendarType;
var f=C.extend("sap.ui.unified.calendar.YearPicker",{metadata:{library:"sap.ui.unified",properties:{year:{type:"int",group:"Data",defaultValue:2000},years:{type:"int",group:"Appearance",defaultValue:20},columns:{type:"int",group:"Appearance",defaultValue:4},date:{type:"object",group:"Data"},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},events:{select:{},pageChange:{}}}});
f.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._oYearFormat=c.getDateInstance({format:"y",calendarType:s});this._oFormatYyyymmdd=c.getInstance({pattern:"yyyyMMdd",calendarType:e.Gregorian});this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());};
f.prototype.onAfterRendering=function(){_.call(this);};
f.prototype.setYear=function(y){this.setProperty("year",y,true);y=this.getProperty("year");var i=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());i.setDate(1);i.setMonth(0);i.setYear(y);this.setDate(i.toLocalJSDate());return this;};
f.prototype.setDate=function(i){var p,y,r,F;i&&a._checkJSDateObject(i);y=i.getFullYear();a._checkYearInValidRange(y);p=b.fromLocalJSDate(i,this.getPrimaryCalendarType());p.setMonth(0);p.setDate(1);this.setProperty("date",i,true);this.setProperty("year",p.getYear(),true);this._oDate=p;if(this.getDomRef()){r=this.getYears();F=new b(this._oDate,this.getPrimaryCalendarType());F.setYear(F.getYear()-Math.floor(r/2));o.call(this,F,Math.floor(r/2));}return this;};
f.prototype._getDate=function(){if(!this._oDate){var y=this.getYear();this._oDate=new b(y,0,1,this.getPrimaryCalendarType());}return this._oDate;};
f.prototype.setPrimaryCalendarType=function(s){this.setProperty("primaryCalendarType",s);this._oYearFormat=c.getDateInstance({format:"y",calendarType:s});if(this._oDate){this._oDate=new b(this._oDate,s);this._oDate.setMonth(0);this._oDate.setDate(1);}this._oMinDate=new b(this._oMinDate,s);this._oMaxDate=new b(this._oMaxDate,s);return this;};
f.prototype.nextPage=function(){n.call(this,true,this._oItemNavigation.getFocusedIndex());return this;};
f.prototype.previousPage=function(){n.call(this,false,this._oItemNavigation.getFocusedIndex());return this;};
f.prototype.onsapspace=function(E){E.preventDefault();};
f.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var s=m.call(this,i);if(s){this.fireSelect();}};
f.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
f.prototype.onmouseup=function(E){if(this._bMousedownChange){this._bMousedownChange=false;this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){var i=this._oItemNavigation.getFocusedIndex();m.call(this,i);this.fireSelect();}};
f.prototype.getFirstRenderedDate=function(){var F;if(this.getDomRef()){var i=this._oItemNavigation.getItemDomRefs();F=this._oFormatYyyymmdd.parse(q(i[0]).attr("data-sap-year-start"),true);}return F;};
f.prototype._isValueInThreshold=function(r,v,t){var L=r-t,u=r+t;return v>=L&&v<=u;};
f.prototype._checkFirstDate=function(i){var y=this.getYears();var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(i.isAfter(M)&&i.getYear()!=M.getYear()){i=new b(M,this.getPrimaryCalendarType());i.setMonth(0);i.setDate(1);}else if(i.isBefore(this._oMinDate)&&i.getYear()!=this._oMinDate.getYear()){i=new b(this._oMinDate,this.getPrimaryCalendarType());i.setMonth(0);i.setDate(1);}return i;};
f.prototype._checkDateEnabled=function(i){var E=true;if((i.isAfter(this._oMaxDate)&&i.getYear()!=this._oMaxDate.getYear())||(i.isBefore(this._oMinDate)&&i.getYear()!=this._oMinDate.getYear())){E=false;}return E;};
function _(){var y=this.getYears();var i=this._getDate().getYear();var M=this._oMinDate.getYear();var p=this._oMaxDate.getYear();var r=this.getDomRef();var s=this.$().find(".sapUiCalItem");var t=Math.floor(y/2);if(i>p-Math.floor(y/2)){t=t+i-p+Math.floor(y/2);}else if(i<=M+Math.floor(y/2)){t=i-M;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,g,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,h,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(s);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this.getColumns(),true);this._oItemNavigation.setFocusedIndex(t);this._oItemNavigation.setPageSize(s.length);}
function g(i){var p=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){j.call(this,E,p);}}
function h(i){var p=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){j.call(this,E,p);}}
function j(E,i){if(E.button||D.support.touch){return;}var s=m.call(this,i);if(s){this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");}
function k(i){var E=i.getParameter("event");if(E.type){var y=this.getYears();var p=this.getColumns();if(p==0){p=y;}switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==K.ARROW_DOWN&&p<y){n.call(this,true,this._oItemNavigation.getFocusedIndex()-y+p,true);}else{n.call(this,true,0,true);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==K.ARROW_UP&&p<y){n.call(this,false,y-p+this._oItemNavigation.getFocusedIndex(),true);}else{n.call(this,false,y-1,true);}break;case"sappagedown":n.call(this,true,this._oItemNavigation.getFocusedIndex(),true);break;case"sappageup":n.call(this,false,this._oItemNavigation.getFocusedIndex(),true);break;default:break;}}}
function m(p){var r=this._oItemNavigation.getItemDomRefs();var $=q(r[p]);if($.hasClass("sapUiCalItemDsbl")){return false;}var y=$.attr("data-sap-year-start");var s=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y));var t=this.getId()+"-y"+y;for(var i=0;i<r.length;i++){$=q(r[i]);if($.attr("id")==t){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}}this.setProperty("date",s.toLocalJSDate(),true);this.setProperty("year",s.getYear(),true);return true;}
function n(F,s,i){var p=this._oItemNavigation.getItemDomRefs();var r=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(p[0]).attr("data-sap-year-start")),this.getPrimaryCalendarType());var y=this.getYears();if(F){var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(r.isBefore(M)){r.setYear(r.getYear()+y);if(r.isAfter(M)){s=s+(r.getYear()-M.getYear());if(s>y-1){s=y-1;}r=this._oMaxDate;r.setMonth(0);r.setDate(1);}}else{return;}}else{if(r.isAfter(this._oMinDate)){r.setYear(r.getYear()-y);if(r.isBefore(this._oMinDate)){s=s-(this._oMinDate.getYear()-r.getYear());if(s<0){s=0;}r=new b(this._oMinDate,this.getPrimaryCalendarType());}}else{return;}}o.call(this,r,s);if(i){this.firePageChange();}}
function o(F,s){var p=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var E=false;var r=this._checkFirstDate(F);var S;if(!r.isSame(F)){S=new b(F,this.getPrimaryCalendarType());S.setYear(S.getYear()+s);F=r;E=true;}var t=this._oItemNavigation.getItemDomRefs();var u=new b(F,this.getPrimaryCalendarType());for(var i=0;i<t.length;i++){var y=this._oFormatYyyymmdd.format(u.toUTCJSDate(),true);var $=q(t[i]);$.attr("id",this.getId()+"-y"+y);$.text(this._oYearFormat.format(U.getInstance(u.toUTCJSDate(),u.getCalendarType()),true));$.attr("data-sap-year-start",y);if($.hasClass("sapUiCalItemSel")&&y!=p){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else if(!$.hasClass("sapUiCalItemSel")&&y==p){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}var v=true;if(E){v=this._checkDateEnabled(u);if(u.isSame(S)){s=i;}}if(v){$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}else{$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}u.setYear(u.getYear()+1);}this._oItemNavigation.focusItem(s);}
return f;});
sap.ui.predefine('sap/ui/unified/calendar/YearPickerRenderer',['sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate'],function(C,U){"use strict";var Y={};
Y.render=function(r,y){var t=y.getTooltip_AsString();var I=y.getId();var c=y._getDate();var a=c.getYear();var b=y.getYears();var d=y.getColumns();var w="";r.write("<div");r.writeControlData(y);r.addClass("sapUiCalYearPicker");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(y,{role:"grid",readonly:"true",multiselectable:"false"});r.write(">");var D=new C(c,y.getPrimaryCalendarType());D.setYear(D.getYear()-Math.floor(b/2));var e=false;var f=y._checkFirstDate(D);if(!f.isSame(D)){D=f;e=true;}if(d>0){w=(100/d)+"%";}else{w=(100/b)+"%";}for(var i=0;i<b;i++){var s=y._oFormatYyyymmdd.format(D.toUTCJSDate(),true);var A={role:"gridcell"};var E=true;if(e){E=y._checkDateEnabled(D);}if(d>0&&i%d==0){r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");}r.write("<div");r.writeAttribute("id",I+"-y"+s);r.addClass("sapUiCalItem");if(D.getYear()==a){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(!E){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-year-start",s);r.addStyle("width",w);r.writeClasses();r.writeStyles();r.writeAccessibilityState(null,A);r.write(">");r.write(y._oYearFormat.format(U.getInstance(D.toUTCJSDate(),D.getCalendarType()),true));r.write("</div>");D.setYear(D.getYear()+1);if(d>0&&((i+1)%d==0)){r.write("</div>");}}r.write("</div>");};
return Y;},true);
sap.ui.predefine('sap/ui/unified/library',['sap/ui/core/Core','sap/ui/base/Object'],function(C,B){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.unified",version:"1.58.2",dependencies:["sap.ui.core"],designtime:"sap/ui/unified/designtime/library.designtime",types:["sap.ui.unified.CalendarDayType","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.ColorPickerMode","sap.ui.unified.ColorPickerDisplayMode"],interfaces:["sap.ui.unified.IProcessableBlobs"],controls:["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],elements:["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],extensions:{"sap.ui.support":{publicRules:true}}});var t=sap.ui.unified;t.CalendarDayType={None:"None",NonWorking:"NonWorking",Type01:"Type01",Type02:"Type02",Type03:"Type03",Type04:"Type04",Type05:"Type05",Type06:"Type06",Type07:"Type07",Type08:"Type08",Type09:"Type09",Type10:"Type10",Type11:"Type11",Type12:"Type12",Type13:"Type13",Type14:"Type14",Type15:"Type15",Type16:"Type16",Type17:"Type17",Type18:"Type18",Type19:"Type19",Type20:"Type20"};t.StandardCalendarLegendItem={Today:"Today",WorkingDay:"WorkingDay",NonWorkingDay:"NonWorkingDay",Selected:"Selected"};t.CalendarIntervalType={Hour:"Hour",Day:"Day",Month:"Month",Week:"Week",OneMonth:"One Month"};t.GroupAppointmentsMode={Collapsed:"Collapsed",Expanded:"Expanded"};t.CalendarAppointmentVisualization={Standard:"Standard",Filled:"Filled"};t.ContentSwitcherAnimation={None:"None",Fade:"Fade",ZoomIn:"ZoomIn",ZoomOut:"ZoomOut",Rotate:"Rotate",SlideRight:"SlideRight",SlideOver:"SlideOver"};t.ColorPickerMode={HSV:"HSV",HSL:"HSL"};t.ColorPickerDisplayMode={Default:"Default",Large:"Large",Simplified:"Simplified"};t._ContentRenderer=B.extend("sap.ui.unified._ContentRenderer",{constructor:function(c,s,o,a){B.apply(this);this._id=s;this._cntnt=o;this._ctrl=c;this._rm=sap.ui.getCore().createRenderManager();this._cb=a||function(){};},destroy:function(){this._rm.destroy();delete this._rm;delete this._id;delete this._cntnt;delete this._cb;delete this._ctrl;if(this._rerenderTimer){clearTimeout(this._rerenderTimer);delete this._rerenderTimer;}B.prototype.destroy.apply(this,arguments);},render:function(){if(!this._rm){return;}if(this._rerenderTimer){clearTimeout(this._rerenderTimer);}this._rerenderTimer=setTimeout(function(){var c=document.getElementById(this._id);if(c){if(typeof(this._cntnt)==="string"){var a=this._ctrl.getAggregation(this._cntnt,[]);for(var i=0;i<a.length;i++){this._rm.renderControl(a[i]);}}else{this._cntnt(this._rm);}this._rm.flush(c);}this._cb(!!c);}.bind(this),0);}});t._iNumberOfOpenedShellOverlays=0;if(!t.ColorPickerHelper){t.ColorPickerHelper={isResponsive:function(){return false;},factory:{createLabel:function(){throw new Error("no Label control available");},createInput:function(){throw new Error("no Input control available");},createSlider:function(){throw new Error("no Slider control available");},createRadioButtonGroup:function(){throw new Error("no RadioButtonGroup control available");},createRadioButtonItem:function(){throw new Error("no RadioButtonItem control available");}},bFinal:false};}if(!t.FileUploaderHelper){t.FileUploaderHelper={createTextField:function(i){throw new Error("no TextField control available!");},setTextFieldContent:function(T,w){throw new Error("no TextField control available!");},createButton:function(){throw new Error("no Button control available!");},addFormClass:function(){return null;},bFinal:false};}t.calendar=t.calendar||{};return t;});
sap.ui.predefine('sap/ui/unified/Menu',['sap/ui/core/Element','sap/ui/core/Control','sap/ui/Device','sap/ui/core/Popup','./MenuItemBase','./library','sap/ui/core/library','sap/ui/unified/MenuRenderer',"sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/ControlEvents","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave"],function(E,C,D,P,M,l,c,a,b,q,K,L,d,f,g){"use strict";var h=P.Dock;var O=c.OpenState;
var j=C.extend("sap.ui.unified.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},ariaDescription:{type:"string",group:"Accessibility",defaultValue:null},maxVisibleItems:{type:"int",group:"Behavior",defaultValue:0},pageSize:{type:"int",group:"Behavior",defaultValue:5}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItemBase",multiple:true,singularName:"item"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{itemSelect:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
(function(w){j.prototype.bCozySupported=true;j._DELAY_SUBMENU_TIMER=300;j._DELAY_SUBMENU_TIMER_EXT=400;
j.prototype.init=function(){var t=this;this.bOpen=false;this.oOpenedSubMenu=null;this.oHoveredItem=null;this.oPopup=null;this._bOpenedAsContextMenu=false;this.fAnyEventHandlerProxy=q.proxy(function(e){var r=this.getRootMenu();if(r!=this||!this.bOpen||!this.getDomRef()||(e.type!="mousedown"&&e.type!="touchstart")){return;}r.handleOuterEvent(this.getId(),e);},this);this.fOrientationChangeHandler=function(){t.close();};this.bUseTopStyle=false;};
j.prototype._setCustomEnhanceAccStateFunction=function(e){this._fnCustomEnhanceAccStateFunction=e;};
j.prototype.enhanceAccessibilityState=function(e,A){var i=typeof this._fnCustomEnhanceAccStateFunction==="function";return i?this._fnCustomEnhanceAccStateFunction(e,A):A;};
j.prototype.exit=function(){if(this.oPopup){this.oPopup.detachClosed(this._menuClosed,this);this.oPopup.destroy();delete this.oPopup;}d.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this._resetDelayedRerenderItems();this._detachResizeHandler();};
j.prototype.invalidate=function(o){if(o instanceof M&&this.getDomRef()){this._delayedRerenderItems();}else{C.prototype.invalidate.apply(this,arguments);}};
j.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems();};
j.prototype.onAfterRendering=function(){if(this.$().parent().attr("id")!="sap-ui-static"){L.error("sap.ui.unified.Menu: The Menu is popup based and must not be rendered directly as content of the page.");this.close();this.$().remove();}var I=this.getItems();for(var i=0;i<I.length;i++){if(I[i].onAfterRendering&&I[i].getDomRef()){I[i].onAfterRendering();}}if(this.oHoveredItem){this.oHoveredItem.hover(true,this);}m(this);};
j.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getPopup().getOpenState()===O.OPEN){m(this);this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}};
j.prototype.setPageSize=function(S){return this.setProperty("pageSize",S,true);};
j.prototype.addItem=function(i){this.addAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.removeItem=function(i){this.removeAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return r;};
j.prototype.destroyItems=function(){this.destroyAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype._delayedRerenderItems=function(){if(!this.getDomRef()){return;}this._resetDelayedRerenderItems();this._discardOpenSubMenuDelayed();this._itemRerenderTimer=setTimeout(function(){var o=this.getDomRef();if(o){var r=sap.ui.getCore().createRenderManager();a.renderItems(r,this);r.flush(o);r.destroy();this.onAfterRendering();this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}}.bind(this),0);};
j.prototype._resetDelayedRerenderItems=function(){if(this._itemRerenderTimer){clearTimeout(this._itemRerenderTimer);delete this._itemRerenderTimer;}};
j.prototype._detachResizeHandler=function(){if(this._hasResizeListener){D.resize.detachHandler(this._handleResizeChange,this);this._hasResizeListener=false;}};
j.prototype.open=function(W,o,e,i,p,r,t){if(this.bOpen){return;}s(this,true);this.oOpenerRef=o;this.bIgnoreOpenerDOMRef=false;this.getPopup().open(0,e,i,p,r||"0 0",t||"_sapUiCommonsMenuFlip _sapUiCommonsMenuFlip",true);this.bOpen=true;D.resize.attachHandler(this._handleResizeChange,this);this._hasResizeListener=true;var u=this.getDomRef();q(u).attr("tabIndex",0).focus();if(W){this.setHoveredItem(this.getNextSelectableItem(-1));}d.bindAnyEvent(this.fAnyEventHandlerProxy);if(D.support.orientation&&this.getRootMenu()===this){q(w).bind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=true;}};
j.prototype._handleResizeChange=function(){this.getPopup()._applyPosition(this.getPopup()._oLastPosition);};
j.prototype.openAsContextMenu=function(e,o){var i,p,r,t,u;o=o instanceof E?o.getDomRef():o;if(e instanceof q.Event){u=q(o).offset();i=e.pageX-u.left;p=e.pageY-u.top;this._iX=e.clientX;this._iY=e.clientY;}else{i=e.offsetX||0;p=e.offsetY||0;this._iX=e.left||0;this._iY=e.top||0;}r=sap.ui.getCore().getConfiguration().getRTL();t=h;if(r){i=o.clientWidth-i;}this._bOpenedAsContextMenu=true;this.open(true,o,t.BeginTop,t.BeginTop,o,i+" "+p,'fit');};
j.prototype._handleOpened=function(){var $,W,i,e,r,B,R,o,p,t;if(!this._bOpenedAsContextMenu){return;}$=this.$();W=q(w);i=this._iX;e=this._iY;r=W.scrollLeft()+W.width();B=W.scrollTop()+W.height();R=sap.ui.getCore().getConfiguration().getRTL();o=false;p=$.width();t=$.height();if(e+t>B){e=e-t;o=true;}if(R){if((r-i)+p>r){i=r-(i+p);o=true;}else{i=r-i;o=true;}}else{if(i+p>r){i=i-p;o=true;}}this._bOpenedAsContextMenu=false;o&&this.oPopup.setPosition("begin top","begin top",W,i+" "+e,"flip");};
j.prototype.close=function(){if(!this.bOpen||j._dbg){return;}this._discardOpenSubMenuDelayed();s(this,false);delete this._bFixed;d.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this.bOpen=false;this.closeSubmenu();this.setHoveredItem();q(this.getDomRef()).attr("tabIndex",-1);this.getPopup().close(0);this._detachResizeHandler();this._resetDelayedRerenderItems();this.$().remove();this.bOutput=false;if(this.isSubMenu()){this.getParent().getParent().oOpenedSubMenu=null;}};
j.prototype._menuClosed=function(){if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef){try{this.oOpenerRef.focus();}catch(e){L.warning("Menu.close cannot restore the focus on opener "+this.oOpenerRef+", "+e);}}this.oOpenerRef=undefined;}};
j.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),false,!!(e.metaKey||e.ctrlKey));e.preventDefault();e.stopPropagation();};
j.prototype.onsapnext=function(e){if(e.keyCode!=K.ARROW_DOWN){if(this.oHoveredItem&&this.oHoveredItem.getSubmenu()&&this.checkEnabled(this.oHoveredItem)){this.openSubmenu(this.oHoveredItem,true);}return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;this.setHoveredItem(this.getNextSelectableItem(i));e.preventDefault();e.stopPropagation();};
j.prototype.onsapprevious=function(e){if(e.keyCode!=K.ARROW_UP){if(this.isSubMenu()){this.close();}e.preventDefault();e.stopPropagation();return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;this.setHoveredItem(this.getPreviousSelectableItem(i));e.preventDefault();e.stopPropagation();};
j.prototype.onsaphome=function(e){this.setHoveredItem(this.getNextSelectableItem(-1));e.preventDefault();e.stopPropagation();};
j.prototype.onsapend=function(e){this.setHoveredItem(this.getPreviousSelectableItem(this.getItems().length));e.preventDefault();e.stopPropagation();};
j.prototype.onsappagedown=function(e){if(this.getPageSize()<1){this.onsapend(e);return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;i+=this.getPageSize();if(i>=this.getItems().length){this.onsapend(e);return;}this.setHoveredItem(this.getNextSelectableItem(i-1));e.preventDefault();e.stopPropagation();};
j.prototype.onsappageup=function(e){if(this.getPageSize()<1){this.onsaphome(e);return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;i-=this.getPageSize();if(i<0){this.onsaphome(e);return;}this.setHoveredItem(this.getPreviousSelectableItem(i+1));e.preventDefault();e.stopPropagation();};
j.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=true;e.preventDefault();e.stopPropagation();};
j.prototype.onkeyup=function(e){if(this.oHoveredItem&&(q(e.target).prop("tagName")!="INPUT")){var o=this.oHoveredItem.getDomRef();q(o).attr("tabIndex",0).focus();}if(!this._sapSelectOnKeyDown){return;}else{this._sapSelectOnKeyDown=false;}if(!f.events.sapselect.fnCheck(e)){return;}this.selectItem(this.oHoveredItem,true,false);e.preventDefault();e.stopPropagation();};
j.prototype.onsapbackspace=function(e){if(q(e.target).prop("tagName")!="INPUT"){e.preventDefault();}};
j.prototype.onsapbackspacemodifiers=j.prototype.onsapbackspace;
j.prototype.onsapescape=function(e){this.close();e.preventDefault();e.stopPropagation();};
j.prototype.onsaptabnext=j.prototype.onsapescape;j.prototype.onsaptabprevious=j.prototype.onsapescape;
j.prototype.onmouseover=function(e){if(!D.system.desktop){return;}var i=this.getItemByDomRef(e.target);if(!this.bOpen||!i||i==this.oHoveredItem){return;}if(this.oOpenedSubMenu&&b(this.oOpenedSubMenu.getDomRef(),e.target)){return;}this.setHoveredItem(i);if(g(e,this.getDomRef())){if(!D.browser.msie&&!D.browser.edge){this.getDomRef().focus();}}if(D.browser.msie){this.getDomRef().focus();}this._openSubMenuDelayed(i);};
j.prototype._openSubMenuDelayed=function(i){if(!i){return;}this._discardOpenSubMenuDelayed();this._delayedSubMenuTimer=setTimeout(function(){this.closeSubmenu();if(!i.getSubmenu()||!this.checkEnabled(i)){return;}this.setHoveredItem(i);this.openSubmenu(i,false,true);}.bind(this),i.getSubmenu()&&this.checkEnabled(i)?j._DELAY_SUBMENU_TIMER:j._DELAY_SUBMENU_TIMER_EXT);};
j.prototype._discardOpenSubMenuDelayed=function(i){if(this._delayedSubMenuTimer){clearTimeout(this._delayedSubMenuTimer);this._delayedSubMenuTimer=null;}};
j.prototype.onmouseout=function(e){if(!D.system.desktop){return;}if(g(e,this.getDomRef())){if(!this.oOpenedSubMenu||!(this.oOpenedSubMenu.getParent()===this.oHoveredItem)){this.setHoveredItem(null);}this._discardOpenSubMenuDelayed();}};
j.prototype.onsapfocusleave=function(e){if(this.oOpenedSubMenu||!this.bOpen){return;}this.getRootMenu().handleOuterEvent(this.getId(),e);};
j.prototype.handleOuterEvent=function(o,e){var i=false,t=this.getPopup().touchEnabled;this.bIgnoreOpenerDOMRef=false;if(e.type=="mousedown"||e.type=="touchstart"){if(t&&(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose"))){return;}var p=this;while(p&&!i){if(b(p.getDomRef(),e.target)){i=true;}p=p.oOpenedSubMenu;}}else if(e.type=="sapfocusleave"){if(t){return;}if(e.relatedControlId){var p=this;while(p&&!i){if((p.oOpenedSubMenu&&p.oOpenedSubMenu.getId()==e.relatedControlId)||b(p.getDomRef(),q(document.getElementById(e.relatedControlId)).get(0))){i=true;}p=p.oOpenedSubMenu;}}if(!i){this.bIgnoreOpenerDOMRef=true;}}if(!i){this.close();}};
j.prototype.getItemByDomRef=function(o){var I=this.getItems(),e=I.length;for(var i=0;i<e;i++){var p=I[i],r=p.getDomRef();if(b(r,o)){return p;}}return null;};
j.prototype.selectItem=function(i,W,e){if(!i||!(i instanceof M&&this.checkEnabled(i))){return;}var S=i.getSubmenu();if(!S){this.getRootMenu().close();}else{if(!D.system.desktop&&this.oOpenedSubMenu===S){this.closeSubmenu();}else{this.openSubmenu(i,W);}}i.fireSelect({item:i,ctrlKey:e});this.getRootMenu().fireItemSelect({item:i});};
j.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof j;};
j.prototype.getRootMenu=function(){var t=this;while(t.isSubMenu()){t=t.getParent().getParent();}return t;};
j.prototype.getMenuLevel=function(){var i=1;var t=this;while(t.isSubMenu()){t=t.getParent().getParent();i++;}return i;};
j.prototype.getPopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.setDurations(0,0);this.oPopup.attachClosed(this._menuClosed,this);this.oPopup.attachOpened(this._handleOpened,this);}return this.oPopup;};
j.prototype.setHoveredItem=function(i){if(this.oHoveredItem){this.oHoveredItem.hover(false,this);}if(!i){this.oHoveredItem=null;q(this.getDomRef()).removeAttr("aria-activedescendant");return;}this.oHoveredItem=i;i.hover(true,this);this._setActiveDescendant(this.oHoveredItem);this.scrollToItem(this.oHoveredItem);};
j.prototype._setActiveDescendant=function(i){if(sap.ui.getCore().getConfiguration().getAccessibility()&&i){var t=this;t.$().removeAttr("aria-activedescendant");setTimeout(function(){if(t.oHoveredItem===i){t.$().attr("aria-activedescendant",t.oHoveredItem.getId());}},10);}};
j.prototype.openSubmenu=function(i,W,e){var S=i.getSubmenu();if(!S){return;}if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==S){this.closeSubmenu();}if(this.oOpenedSubMenu){this.oOpenedSubMenu._bFixed=(e&&this.oOpenedSubMenu._bFixed)||(!e&&!this.oOpenedSubMenu._bFixed);this.oOpenedSubMenu._bringToFront();}else{this.oOpenedSubMenu=S;var o=P.Dock;S.open(W,this,o.BeginTop,o.EndTop,i,"0 0");}};
j.prototype.closeSubmenu=function(i,I){if(this.oOpenedSubMenu){if(i&&this.oOpenedSubMenu._bFixed){return;}if(I){this.oOpenedSubMenu.bIgnoreOpenerDOMRef=true;}this.oOpenedSubMenu.close();this.oOpenedSubMenu=null;}};
j.prototype.scrollToItem=function(i){var o=this.getDomRef(),I=i?i.getDomRef():null;if(!I||!o){return;}var e=o.scrollTop,p=I.offsetTop,r=q(o).height(),t=q(I).height();if(e>p){o.scrollTop=p;}else if((p+t)>(e+r)){o.scrollTop=Math.ceil(p+t-r);}};
j.prototype._bringToFront=function(){q(document.getElementById(this.getPopup().getId())).mousedown();};
j.prototype.checkEnabled=function(i){return i&&i.getEnabled()&&this.getEnabled();};
j.prototype.getNextSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I+1;i<e.length;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=0;i<=I;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
j.prototype.getPreviousSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I-1;i>=0;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=e.length-1;i>=I;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
j.prototype.setRootMenuTopStyle=function(u){this.getRootMenu().bUseTopStyle=u;j.rerenderMenu(this.getRootMenu());};
j.rerenderMenu=function(o){var I=o.getItems();for(var i=0;i<I.length;i++){var S=I[i].getSubmenu();if(S){j.rerenderMenu(S);}}o.invalidate();o.rerender();};
j.prototype.focus=function(){if(this.bOpen){C.prototype.focus.apply(this,arguments);this._setActiveDescendant(this.oHoveredItem);}};
j.prototype.isCozy=function(){if(!this.bCozySupported){return false;}if(this.hasStyleClass("sapUiSizeCozy")){return true;}if(k(this.oOpenerRef)){return true;}if(k(this.getParent())){return true;}return false;};
function k(r){if(!r){return false;}r=r.$?r.$():q(r);return r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy").hasClass("sapUiSizeCozy");}
function s(o,e){var p=o.getParent();if(p&&p instanceof M){p.onSubmenuToggle(e);}}
function m(o){var e=o.getMaxVisibleItems(),p=document.documentElement.clientHeight-10,$=o.$();if(e>0){var I=o.getItems();for(var i=0;i<I.length;i++){if(I[i].getDomRef()){p=Math.min(p,I[i].$().outerHeight(true)*e);break;}}}if($.outerHeight(true)>p){$.css("max-height",p+"px").toggleClass("sapUiMnuScroll",true);}else{$.css("max-height","").toggleClass("sapUiMnuScroll",false);}}
/*!
	 * The following code is taken from
	 * jQuery UI 1.10.3 - 2013-11-18
	 * jquery.ui.position.js
	 *
	 * http://jqueryui.com
	 * Copyright 2013 jQuery Foundation and other contributors; Licensed MIT
	 */

function _(e){var i=q(w);e.within={element:i,isWindow:true,offset:i.offset()||{left:0,top:0},scrollLeft:i.scrollLeft(),scrollTop:i.scrollTop(),width:i.width(),height:i.height()};e.collisionPosition={marginLeft:0,marginTop:0};return e;}
var n={fit:{left:function(p,e){var i=e.within,o=i.isWindow?i.scrollLeft:i.offset.left,r=i.width,t=p.left-e.collisionPosition.marginLeft,u=o-t,v=t+e.collisionWidth-r-o,x;if(e.collisionWidth>r){if(u>0&&v<=0){x=p.left+u+e.collisionWidth-r-o;p.left+=u-x;}else if(v>0&&u<=0){p.left=o;}else{if(u>v){p.left=o+r-e.collisionWidth;}else{p.left=o;}}}else if(u>0){p.left+=u;}else if(v>0){p.left-=v;}else{p.left=Math.max(p.left-t,p.left);}},top:function(p,e){var i=e.within,o=i.isWindow?i.scrollTop:i.offset.top,r=e.within.height,t=p.top-e.collisionPosition.marginTop,u=o-t,v=t+e.collisionHeight-r-o,x;if(e.collisionHeight>r){if(u>0&&v<=0){x=p.top+u+e.collisionHeight-r-o;p.top+=u-x;}else if(v>0&&u<=0){p.top=o;}else{if(u>v){p.top=o+r-e.collisionHeight;}else{p.top=o;}}}else if(u>0){p.top+=u;}else if(v>0){p.top-=v;}else{p.top=Math.max(p.top-t,p.top);}}},flip:{left:function(p,e){var i=e.within,o=i.offset.left+i.scrollLeft,r=i.width,t=i.isWindow?i.scrollLeft:i.offset.left,u=p.left-e.collisionPosition.marginLeft,v=u-t,x=u+e.collisionWidth-r-t,y=e.my[0]==="left"?-e.elemWidth:e.my[0]==="right"?e.elemWidth:0,z=e.at[0]==="left"?e.targetWidth:e.at[0]==="right"?-e.targetWidth:0,A=-2*e.offset[0],B,F;if(v<0){B=p.left+y+z+A+e.collisionWidth-r-o;if(B<0||B<Math.abs(v)){p.left+=y+z+A;}}else if(x>0){F=p.left-e.collisionPosition.marginLeft+y+z+A-t;if(F>0||Math.abs(F)<x){p.left+=y+z+A;}}},top:function(p,e){var i=e.within,o=i.offset.top+i.scrollTop,r=i.height,t=i.isWindow?i.scrollTop:i.offset.top,u=p.top-e.collisionPosition.marginTop,v=u-t,x=u+e.collisionHeight-r-t,y=e.my[1]==="top",z=y?-e.elemHeight:e.my[1]==="bottom"?e.elemHeight:0,A=e.at[1]==="top"?e.targetHeight:e.at[1]==="bottom"?-e.targetHeight:0,B=-2*e.offset[1],F,G;if(v<0){G=p.top+z+A+B+e.collisionHeight-r-o;if((p.top+z+A+B)>v&&(G<0||G<Math.abs(v))){p.top+=z+A+B;}}else if(x>0){F=p.top-e.collisionPosition.marginTop+z+A+B-t;if((p.top+z+A+B)>x&&(F>0||Math.abs(F)<x)){p.top+=z+A+B;}}}},flipfit:{left:function(){n.flip.left.apply(this,arguments);n.fit.left.apply(this,arguments);},top:function(){n.flip.top.apply(this,arguments);n.fit.top.apply(this,arguments);}}};q.ui.position._sapUiCommonsMenuFlip={left:function(p,e){if(q.ui.position.flipfit){q.ui.position.flipfit.left.apply(this,arguments);return;}e=_(e);n.flipfit.left.apply(this,arguments);},top:function(p,e){if(q.ui.position.flipfit){q.ui.position.flipfit.top.apply(this,arguments);return;}e=_(e);n.flipfit.top.apply(this,arguments);}};})(window);return j;});
sap.ui.require.preload({
	"sap/ui/unified/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.unified","type":"library","embeds":[],"applicationVersion":{"version":"1.58.2"},"title":"Unified controls intended for both, mobile and desktop scenarios","description":"Unified controls intended for both, mobile and desktop scenarios","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.58","libs":{"sap.ui.core":{"minVersion":"1.58.2"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],"elements":["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],"types":["sap.ui.unified.CalendarDayType","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.ColorPickerMode","sap.ui.unified.ColorPickerDisplayMode"],"interfaces":["sap.ui.unified.IProcessableBlobs"]}}}}'
},"sap/ui/unified/library-preload"
);
//# sourceMappingURL=library-preload.js.map