/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/m/OnePersonHeader','sap/m/OnePersonGrid','sap/m/SegmentedButtonItem','sap/ui/unified/DateRange','sap/ui/core/date/UniversalDate','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/format/DateFormat'],function(C,O,a,S,D,U,L,b,c){"use strict";var d=C.extend("sap.m.OnePersonCalendar",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:""},startDate:{type:"object",group:"Data"},startHour:{type:"int",group:"Appearance",defaultValue:8},endHour:{type:"int",group:"Appearance",defaultValue:17},showFullDay:{type:"boolean",group:"Appearance",defaultValue:true},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:sap.ui.unified.CalendarAppointmentVisualization.Standard}},aggregations:{actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action",forwarding:{getter:"_getHeader",aggregation:"actions"}},appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment",forwarding:{getter:"_getGrid",aggregation:"appointments"}},views:{type:"sap.m.OnePersonView",multiple:true,singularName:"view"},_header:{type:"sap.m.OnePersonHeader",multiple:false,visibility:"hidden"},_grid:{type:"sap.m.OnePersonGrid",multiple:false,visibility:"hidden"}}}});var K=[sap.m.OnePersonCalendarView.Day,sap.m.OnePersonCalendarView.WorkWeek,sap.m.OnePersonCalendarView.Week];d.prototype.init=function(){var o=this.getId(),e=new Date(),u=new U(U.UTC(e.getFullYear(),e.getMonth(),e.getDate())),s;if(!this.oSelectedItem){this.oSelectedItem=new S({key:sap.m.OnePersonCalendarView.Week,text:sap.m.OnePersonCalendarView.Week});}s=this._getFirstAndLastWeekDate(u);this.setAggregation("_header",new O(o+"-Header",{pickerText:this._formatPickerText(s.firstDate,s.lastDate)}));var h=this._getHeader();h.attachEvent("pressPrevious",this._handlePressArrow,this);h.attachEvent("pressToday",this._handlePressToday,this);h.attachEvent("pressNext",this._handlePressArrow,this);h.attachEvent("dateSelect",this._handleDateSelect,this);this.setAggregation("_grid",new a(o+"-Grid",{}));this._getGrid().setStartDate(s.firstDate.oDate);this._setSelectedDateToCalendar();this._getHeader()._getViewSwitch().attachEvent("selectionChange",function(E){this.oSelectedItem=E.getParameter("item");this._alignColumns(this.oSelectedItem);this._setSelectedDateToCalendar();}.bind(this));};d.prototype.exit=function(){if(this.oSelectedItem){this.oSelectedItem.destroy();this.oSelectedItem=null;}};d.prototype.setTitle=function(t){this._getHeader().setTitle(t);return this.setProperty("title",t,true);};d.prototype.setStartDate=function(o){var u=new U(U.UTC(o.getFullYear(),o.getMonth(),o.getDate())),e,s,E,p;if(this.oSelectedItem.getKey()===sap.m.OnePersonCalendarView.Day){s=u;}else{e=this._getFirstAndLastWeekDate(u);s=e.firstDate;E=e.lastDate;}this.setProperty("startDate",o,true);this._getGrid().setStartDate(s.oDate);this._getHeader().setSelectedDate(s.oDate);this._setSelectedDateToCalendar();p=this._formatPickerText(s,E);this._getHeader().setPickerText(p);return this;};d.prototype.setStartHour=function(v){this.setProperty("startHour",v,true);this._getGrid().setStartHour(v);return this;};d.prototype.setEndHour=function(v){this.setProperty("endHour",v,true);this._getGrid().setEndHour(v);return this;};d.prototype.setShowFullDay=function(v){this.setProperty("showFullDay",v,true);this._getGrid().setProperty("showFullDay",v);return this;};d.prototype.setAppointmentsVisualization=function(v){this.setProperty("appointmentsVisualization",v,true);this._getGrid().setProperty("appointmentsVisualization",v);return this;};d.prototype.addView=function(v){var V=this._getHeader()._getViewSwitch();if(K.indexOf(v.getIntervalType())>-1){var i=new S({key:v.getIntervalType(),text:v.getTitle()});V.addItem(i);this.oSelectedItem=V.getItems()[0];this._switchVisibility();this._alignColumns(V.getItems()[0]);}return this.addAggregation("views",v);};d.prototype.insertView=function(v,p){var V=this._getHeader()._getViewSwitch();if(K.indexOf(v.getIntervalType())>-1){var i=new S({key:v.getIntervalType(),text:v.getTitle()});V.insertItem(i,p);this.oSelectedItem=V.getItems()[0];this._switchVisibility();this._alignColumns(V.getItems()[0]);}return this.insertAggregation("views",v,p);};d.prototype.removeView=function(v){var V=this._getHeader()._getViewSwitch();V.getItems().forEach(function(i){if(i.getKey()===v.getIntervalType()){V.removeItem(i);this._switchVisibility();this._alignColumns(V.getItems()[0]);}}.bind(this));return this.removeAggregation("views",v);};d.prototype.removeAllViews=function(){var v=this._getHeader()._getViewSwitch(),i=new S({key:sap.m.OnePersonCalendarView.Week,text:sap.m.OnePersonCalendarView.Week});v.removeAllItems();this.oSelectedItem=i;this._switchVisibility();this._alignColumns(i);return this.removeAllAggregation("views");};d.prototype.destroyViews=function(){var v=this._getHeader()._getViewSwitch(),i=new S({key:sap.m.OnePersonCalendarView.Week,text:sap.m.OnePersonCalendarView.Week});v.destroyItems();this.oSelectedItem=i;this._switchVisibility();this._alignColumns(i);return this.destroyAggregation("views");};d.prototype._switchVisibility=function(){var s=this._getHeader()._getViewSwitch();if(s.getItems().length>1){s.setProperty("visible",true,true);}else{s.setProperty("visible",false,true);}};d.prototype._handlePressArrow=function(e){if(e.getId()==="pressPrevious"){this._fireArrowsLogic(false);}else{this._fireArrowsLogic(true);}};d.prototype._handlePressToday=function(){var o=new Date(),u=new U(U.UTC(o.getFullYear(),o.getMonth(),o.getDate())),e,s;if(this.oSelectedItem.getKey()===sap.m.OnePersonCalendarView.Day){s=u;}else{e=this._getFirstAndLastWeekDate(u);s=e.firstDate;}this.setStartDate(s.oDate);};d.prototype._handleDateSelect=function(){var s=this._getHeader().getSelectedDate(),o=new U(U.UTC(s.getFullYear(),s.getMonth(),s.getDate())),e;if(this.oSelectedItem.getKey()===sap.m.OnePersonCalendarView.Day){this.setStartDate(o.oDate);}else{e=this._getFirstAndLastWeekDate(o);this.setStartDate(e.firstDate.oDate);}};d.prototype._setSelectedDateToCalendar=function(){var s=this._getHeader().getSelectedDate()||new Date(),o=new U(U.UTC(s.getFullYear(),s.getMonth(),s.getDate())),e,f,l,g;if(this.oSelectedItem.getKey()===sap.m.OnePersonCalendarView.Day){g=new D({startDate:o.oDate,endDate:o.oDate});}else{e=this._getFirstAndLastWeekDate(o);f=e.firstDate;l=e.lastDate;g=new D({startDate:f.oDate,endDate:l.oDate});}this._getHeader().getAggregation("_picker").removeAllSelectedDates();this._getHeader().getAggregation("_picker").addSelectedDate(g);};d.prototype._formatPickerText=function(f,l){var r=c.getDateInstance({style:"long"}).format(f.oDate);if(l){r+=" - "+c.getDateInstance({style:"long"}).format(l.oDate);}return r;};d.prototype._fireArrowsLogic=function(f){var s=this.getStartDate()||new Date(),n,F;if(f){if(this.oSelectedItem.getKey()===sap.m.OnePersonCalendarView.Day){n=1;}else{n=7;}}else{if(this.oSelectedItem.getKey()!==sap.m.OnePersonCalendarView.Day){n=-7;}else{n=-1;}}F=new U(U.UTC(s.getFullYear(),s.getMonth(),s.getDate()+n));this.setStartDate(F.oDate);};d.prototype._getFirstAndLastWeekDate=function(o){var w=U.getWeekByDate(o.getCalendarType(),o.getUTCFullYear(),o.getUTCMonth(),o.getUTCDate()),f=U.getFirstDateOfWeek(o.getCalendarType(),w.year,w.week),F=new U(U.UTC(f.year,f.month,f.day)),i=b.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getFirstDayOfWeek(),l,e;while(F.getUTCDay()!==i){F.setUTCDate(F.getUTCDate()-1);}if(this.oSelectedItem.getKey()===sap.m.OnePersonCalendarView.Day){e=0;}else if(this.oSelectedItem.getKey()===sap.m.OnePersonCalendarView.WorkWeek){var s=this._getLocale(),g=new L(s),h=b.getInstance(g);if(F.getDay()===h.getWeekendEnd()){F.setUTCDate(F.getUTCDate()+1);this._getGrid().setStartDate(F.oDate);}e=4;}else if(this.oSelectedItem.getKey()===sap.m.OnePersonCalendarView.Week){e=6;this._getGrid()&&this._getGrid().setStartDate(F.oDate);}l=new U(U.UTC(F.getUTCFullYear(),F.getUTCMonth(),F.getUTCDate()+e));return{firstDate:F,lastDate:l};};d.prototype._getLocale=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};d.prototype._alignColumns=function(v){var o=this.getStartDate()||new Date(),u=new U(U.UTC(o.getFullYear(),o.getMonth(),o.getDate())),s;this._setSelectedDateToCalendar();if(v.getKey()===sap.m.OnePersonCalendarView.Day){this._getGrid()._setColumns(1);this._getHeader().setPickerText(this._formatPickerText(u));this.getStartDate()?this.setStartDate(this.getStartDate()):this.setStartDate(new Date());}else if(v.getKey()===sap.m.OnePersonCalendarView.WorkWeek){var l=this._getLocale(),e=new L(l),f=b.getInstance(e);if(this.getStartDate()&&this.getStartDate().getDay()===f.getWeekendEnd()){this.getStartDate().setUTCDate(this.getStartDate().getUTCDate()+1);this._getGrid().setStartDate(this.getStartDate());}this.getStartDate()&&this.setStartDate(this.getStartDate());this._getGrid()._setColumns(5);s=this._getFirstAndLastWeekDate(u);this._getHeader().setPickerText(this._formatPickerText(s.firstDate,s.lastDate));}else if(v.getKey()===sap.m.OnePersonCalendarView.Week){this._getGrid()._setColumns(7);this.getStartDate()&&this.setStartDate(this.getStartDate());s=this._getFirstAndLastWeekDate(u);this._getHeader().setPickerText(this._formatPickerText(s.firstDate,s.lastDate));}};d.prototype._getHeader=function(){return this.getAggregation("_header");};d.prototype._getGrid=function(){return this.getAggregation("_grid");};return d;});
