/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/Item','./SelectListRenderer',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(l,C,I,a,S,q){"use strict";var t=l.touch;var b=l.SelectListKeyboardNavigationMode;var c=C.extend("sap.m.SelectList",{metadata:{library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},keyboardNavigationMode:{type:"sap.m.SelectListKeyboardNavigationMode",group:"Behavior",defaultValue:b.Delimited}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}},itemPress:{parameters:{item:{type:"sap.ui.core.Item"}}}}}});c.prototype._setSelectedIndex=function(i,_){var o;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);o=_[i];if(o){this.setSelection(o);}};c.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;this.synchronizeSelection({forceSelection:false});setTimeout(this.synchronizeSelection.bind(this),0);};c.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};c.prototype._activateItem=function(i){if(i instanceof a&&i&&i.getEnabled()){this.fireItemPress({item:i});if(this.getSelectedItem()!==i){this.setSelection(i);this.fireSelectionChange({selectedItem:i});}}};c.prototype._queryEnabledItemsDomRefs=function(d){var e="."+this.getRenderer().CSS_CLASS+"ItemBase";d=d||this.getDomRef();return d?Array.prototype.slice.call(d.querySelectorAll(e+":not("+e+"Disabled)")):[];};c.prototype._handleARIAActivedescendant=function(){var A=q(document.activeElement).control(0),d=this.getDomRef();if(A&&d){d.setAttribute("aria-activedescendant",A.getId());}};c.prototype.init=function(){this._iStartTimeout=0;this._iActiveTouchId=0;this._fStartX=0;this._fStartY=0;this._oItemNavigation=null;this._$ItemPressed=null;};c.prototype.onBeforeRendering=function(){this.synchronizeSelection();};c.prototype.onAfterRendering=function(){if(this.getKeyboardNavigationMode()===b.None){this.destroyItemNavigation();}else{this.createItemNavigation();}};c.prototype.exit=function(){this.destroyItemNavigation();this._$ItemPressed=null;};c.prototype.ontouchstart=function(e){if(t.countContained(e.touches,this.getId())>1||!this.getEnabled()){return;}e.setMarked();var T=e.targetTouches[0];this._iActiveTouchId=T.identifier;this._fStartX=T.pageX;this._fStartY=T.pageY;this._iStartTimeout=setTimeout(function(){var i=e.srcControl.$();if(i){i.addClass(this.getRenderer().CSS_CLASS+"ItemBasePressed");this._$ItemPressed=i;}}.bind(this),100);};c.prototype.ontouchmove=function(e){var T=null;if(!this.getEnabled()){return;}T=t.find(e.changedTouches,this._iActiveTouchId);if(T&&((Math.abs(T.pageX-this._fStartX)>10)||(Math.abs(T.pageY-this._fStartY)>10))){clearTimeout(this._iStartTimeout);if(this._$ItemPressed){this._$ItemPressed.removeClass(this.getRenderer().CSS_CLASS+"ItemBasePressed");this._$ItemPressed=null;}}};c.prototype.ontouchend=function(e){var T=null;if(!this.getEnabled()){return;}e.setMarked();T=t.find(e.changedTouches,this._iActiveTouchId);if(T){setTimeout(function(){if(this._$ItemPressed){this._$ItemPressed.removeClass(this.getRenderer().CSS_CLASS+"ItemBasePressed");this._$ItemPressed=null;}this._iStartTimeout=null;}.bind(this),100);}};c.prototype.ontouchcancel=c.prototype.ontouchend;c.prototype.ontap=function(e){if(this.getEnabled()){e.setMarked();this._activateItem(e.srcControl);}};c.prototype.onsapselect=function(e){if(this.getEnabled()){e.setMarked();e.preventDefault();this._activateItem(e.srcControl);}};c.prototype.onAfterFocus=function(o){this._handleARIAActivedescendant();};c.prototype.findFirstEnabledItem=function(d){d=d||this.getItems();for(var i=0;i<d.length;i++){if(d[i].getEnabled()){return d[i];}}return null;};c.prototype.setSelection=function(i){var s=this.getSelectedItem(),d=this.getRenderer().CSS_CLASS;this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof a)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setProperty("selectedKey",i?i.getKey():"",true);if(s){s.$().removeClass(d+"ItemBaseSelected").attr("aria-selected","false");}s=this.getSelectedItem();if(s){s.$().addClass(d+"ItemBaseSelected").attr("aria-selected","true");}};c.prototype.synchronizeSelection=function(o){if(this.isSelectionSynchronized()){return;}var f=true;if(o){f=!!o.forceSelection;}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);}else if(f&&this.getDefaultSelectedItem()&&(!this.isBound("items")||this.bItemsUpdated)){this.setSelection(this.getDefaultSelectedItem());}};c.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};c.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};c.prototype.getVisibleItems=function(){for(var i=0,o,d=this.getItems(),v=[];i<d.length;i++){o=d[i];if(o.bVisible||(o.bVisible===undefined)){v.push(o);}}return v;};c.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};c.prototype.findItem=function(p,v){var m="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,d=this.getItems();i<d.length;i++){if(d[i][m]()===v){return d[i];}}return null;};c.prototype.getItemByText=function(T){return this.findItem("text",T);};c.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};c.prototype._getNonSeparatorItemsCount=function(){return this.getItems().filter(function(i){return!(i instanceof sap.ui.core.SeparatorItem);}).length;};c.prototype.getDefaultSelectedItem=function(i){return null;};c.prototype.clearSelection=function(){this.setSelection(null);};c.prototype.createItemNavigation=function(){var d;if(!this._oItemNavigation){this._oItemNavigation=new I(null,null,!this.getEnabled());this._oItemNavigation.attachEvent(I.Events.AfterFocus,this.onAfterFocus,this);this.addEventDelegate(this._oItemNavigation);}d=this.getDomRef();this._oItemNavigation.setRootDomRef(d);this._oItemNavigation.setItemDomRefs(this._queryEnabledItemsDomRefs(d));this._oItemNavigation.setCycling(false);this._oItemNavigation.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));this._oItemNavigation.setPageSize(10);};c.prototype.destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};c.prototype.getItemNavigation=function(){return this._oItemNavigation;};c.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=sap.ui.getCore().byId(i);}if(!(i instanceof a)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);return this;};c.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);this.setSelection(i);return this;};c.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var i=this.getItemByKey(k);if(i||(k==="")){if(!i&&k===""){i=this.getDefaultSelectedItem();}this.setSelection(i);return this;}return this.setProperty("selectedKey",k);};c.prototype.getSelectedItem=function(){var s=this.getAssociation("selectedItem");return(s===null)?null:sap.ui.getCore().byId(s)||null;};c.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};c.prototype.getFirstItem=function(){return this.getItems()[0]||null;};c.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};c.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};c.prototype.getItemByKey=function(k){return this.findItem("key",k);};c.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){this.setSelection(this.getDefaultSelectedItem());}return i;};c.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items",true);this.$().children("li").remove();return i;};c.prototype.destroyItems=function(){this.destroyAggregation("items",true);return this;};c.prototype.setNoDataText=function(){};return c;});
