/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","./library","./ListBase","./ListItemBase","./CheckBox","./TableRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(D,l,L,a,C,T,b,q){"use strict";var c=l.ListKeyboardMode;var d=l.ListGrowingDirection;var B=l.BackgroundDesign;var P=l.PopinLayout;var e=L.extend("sap.m.Table",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent},fixedLayout:{type:"boolean",group:"Behavior",defaultValue:true},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false},popinLayout:{type:"sap.m.PopinLayout",group:"Appearance",defaultValue:P.Block}},aggregations:{columns:{type:"sap.m.Column",multiple:true,singularName:"column",dnd:{draggable:true,droppable:true,layout:"Horizontal"}}},events:{beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ColumnListItem"},column:{type:"sap.m.Column"}}}},designtime:"sap/m/designtime/Table.designtime"}});e.prototype.sNavItemClass="sapMListTblRow";e.prototype.init=function(){this._iItemNeedsColumn=0;L.prototype.init.call(this);};e.prototype.onBeforeRendering=function(){L.prototype.onBeforeRendering.call(this);this._ensureColumnsMedia();this._notifyColumns("ItemsRemoved");};e.prototype._ensureColumnsMedia=function(){this.getColumns().forEach(function(o){if(o._bShouldAddMedia){o._addMedia();}});};e.prototype.onAfterRendering=function(){L.prototype.onAfterRendering.call(this);this.updateSelectAllCheckbox();this._renderOverlay();};e.prototype._renderOverlay=function(){var $=this.$(),f=$.find(".sapMTableOverlay"),s=this.getShowOverlay();if(s&&f.length===0){f=q("<div>").addClass("sapUiOverlay sapMTableOverlay").css("z-index","1");$.append(f);}else if(!s){f.remove();}};e.prototype.setShowOverlay=function(s){this.setProperty("showOverlay",s,true);this._renderOverlay();return this;};e.prototype.exit=function(){L.prototype.exit.call(this);if(this._selectAllCheckBox){this._selectAllCheckBox.destroy();this._selectAllCheckBox=null;}};e.prototype.destroyItems=function(){this._notifyColumns("ItemsRemoved");return L.prototype.destroyItems.apply(this,arguments);};e.prototype.removeAllItems=function(){this._notifyColumns("ItemsRemoved");return L.prototype.removeAllItems.apply(this,arguments);};e.prototype.removeSelections=function(){L.prototype.removeSelections.apply(this,arguments);this.updateSelectAllCheckbox();return this;};e.prototype.selectAll=function(){L.prototype.selectAll.apply(this,arguments);this.updateSelectAllCheckbox();return this;};e.prototype.getColumns=function(s){var f=this.getAggregation("columns",[]);if(s){f.sort(function(g,h){return g.getOrder()-h.getOrder();});}return f;};e.prototype.onAfterPageLoaded=function(){this.updateSelectAllCheckbox();if(this.getAlternateRowColors()){var $=this.$("tblBody").removeClass();$.addClass(this._getAlternateRowColorsClass());}L.prototype.onAfterPageLoaded.apply(this,arguments);};e.prototype.shouldRenderItems=function(){var h=this.getColumns().some(function(o){return o.getVisible();});if(!h){b.warning("No visible columns found in "+this);}return h;};e.prototype.onItemTypeColumnChange=function(i,n){this._iItemNeedsColumn+=(n?1:-1);if(this._iItemNeedsColumn==1&&n){this._setTypeColumnVisibility(true);}else if(this._iItemNeedsColumn==0){this._setTypeColumnVisibility(false);}};e.prototype.onItemSelectedChange=function(i,s){L.prototype.onItemSelectedChange.apply(this,arguments);setTimeout(function(){this.updateSelectAllCheckbox();}.bind(this),0);};e.prototype.getTableDomRef=function(){return this.getDomRef("listUl");};e.prototype.getItemsContainerDomRef=function(){return this.getDomRef("tblBody");};e.prototype.setNavigationItems=function(i){var h=this.$("tblHeader");var f=this.$("tblFooter");var r=this.$("tblBody").children(".sapMLIB");var I=h.add(r).add(f).get();i.setItemDomRefs(I);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==d.Upwards){i.setFocusedIndex(I.length-1);}else{i.setFocusedIndex(h[0]?1:0);}}};e.prototype.checkGrowingFromScratch=function(){if(this.hasPopin()){return false;}return this.getColumns().some(function(o){return o.getVisible()&&o.getMergeDuplicates();});};e.prototype.onColumnPress=function(o){this.bActiveHeaders&&this.fireEvent("columnPress",{column:o});};e.prototype.onColumnResize=function(o){if(!this.hasPopin()&&!this._mutex){var h=this.getColumns().some(function(g){return g.isPopin();});if(!h){o.setDisplayViaMedia(this.getTableDomRef());return;}}this._dirty=this._getMediaContainerWidth()||window.innerWidth;if(!this._mutex){var f=this._getMediaContainerWidth()||window.innerWidth;this._mutex=true;this.rerender();setTimeout(function(){if(this._dirty!=f){this._dirty=0;this.rerender();}this._mutex=false;}.bind(this),200);}};e.prototype.setTableHeaderVisibility=function(f){if(!this.getDomRef()){return;}var $=this.$("tblHeader"),h=!$.hasClass("sapMListTblHeaderNone"),v=$.find(".sapMListTblCell:visible"),g=v.eq(0);if(v.length==1){g.width("");}else{v.each(function(){this.style.width=this.getAttribute("data-sap-width")||"";});}this._colCount=v.length+2+!!sap.m.ListBaseRenderer.ModeOrder[this.getMode()];this.$("tblBody").find(".sapMGHLICell").attr("colspan",this.getColSpan());this.$("nodata-text").attr("colspan",this.getColCount());if(this.getFixedLayout()){this._forceStyleChange();}if(!f&&h){$[0].className="sapMListTblRow sapMListTblHeader";this._headerHidden=false;}else if(f&&!h&&!v.length){$[0].className="sapMListTblHeaderNone";this._headerHidden=true;}};e.prototype._forceStyleChange=function(){if(D.browser.msie){var t=this.getTableDomRef().style;t.listStyleType="circle";window.setTimeout(function(){t.listStyleType="none";},0);}};e.prototype._setTypeColumnVisibility=function(v){q(this.getTableDomRef()).toggleClass("sapMListTblHasNav",v);};e.prototype._notifyColumns=function(A,p,v){this.getColumns().forEach(function(o){o["on"+A](p,v);});};e.prototype._getSelectAllCheckbox=function(){return this._selectAllCheckBox||(this._selectAllCheckBox=new C({id:this.getId("sa"),activeHandling:false}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).attachSelect(function(){if(this._selectAllCheckBox.getSelected()){this.selectAll(true);}else{this.removeSelections(false,true);}},this).setTabIndex(-1));};e.prototype.updateSelectAllCheckbox=function(){if(this._selectAllCheckBox&&this.getMode()==="MultiSelect"){var i=this.getItems(),s=this.getSelectedItems().length,S=i.filter(function(I){return I.isSelectable();}).length;this._selectAllCheckBox.setSelected(i.length>0&&s==S);}};e.prototype.enhanceAccessibilityState=function(E,A){if(E==this._selectAllCheckBox){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");A.label=o.getText("TABLE_CHECKBOX_SELECT_ALL");}};e.prototype.getColSpan=function(){return(this._colCount||1)-1;};e.prototype.getColCount=function(){return(this._colCount||0);};e.prototype.hasPopin=function(){return!!this._hasPopin;};e.prototype.isHeaderRowEvent=function(E){var h=this.$("tblHeader");return!!q(E.target).closest(h,this.getTableDomRef()).length;};e.prototype.isFooterRowEvent=function(E){var f=this.$("tblFooter");return!!q(E.target).closest(f,this.getTableDomRef()).length;};e.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TABLE");};e.prototype.getAccessibilityDescription=function(){return L.prototype.getAccessibilityDescription.call(this)+" "+this.getFooterText();};e.prototype._setHeaderAnnouncement=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m"),A=o.getText("ACC_CTR_TYPE_HEADER_ROW")+" ";if(this.isAllSelectableSelected()){A+=o.getText("LIST_ALL_SELECTED");}this.getColumns(true).forEach(function(f,i){if(!f.getVisible()){return;}var h=f.getHeader();if(h&&h.getVisible()){A+=a.getAccessibilityText(h)+" ";}});this.updateInvisibleText(A);};e.prototype._setFooterAnnouncement=function(){var A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_FOOTER_ROW")+" ";this.getColumns(true).forEach(function(o,i){if(!o.getVisible()){return;}var f=o.getFooter();if(f&&f.getVisible()){var h=o.getHeader();if(h&&h.getVisible()){A+=a.getAccessibilityText(h)+" ";}A+=a.getAccessibilityText(f)+" ";}});this.updateInvisibleText(A);};e.prototype.onsapspace=function(E){if(E.isMarked()){return;}if(this._selectAllCheckBox&&E.target===this.getDomRef("tblHeader")){this._selectAllCheckBox.setSelected(!this._selectAllCheckBox.getSelected()).fireSelect();E.preventDefault();E.setMarked();}};e.prototype.onsaptabnext=function(E){if(E.isMarked()||this.getKeyboardMode()==c.Edit){return;}var r=q();if(E.target.id==this.getId("nodata")){r=this.$("nodata");}else if(this.isHeaderRowEvent(E)){r=this.$("tblHeader");}else if(this.isFooterRowEvent(E)){r=this.$("tblFooter");}var o=r.find(":sapTabbable").get(-1)||r[0];if(E.target===o){this.forwardTab(true);E.setMarked();}};e.prototype.onsaptabprevious=function(E){if(E.isMarked()||this.getKeyboardMode()==c.Edit){return;}var t=E.target.id;if(t==this.getId("nodata")||t==this.getId("tblHeader")||t==this.getId("tblFooter")){this.forwardTab(false);}else if(t==this.getId("trigger")){this.focusPrevious();E.preventDefault();}};e.prototype.onfocusin=function(E){var t=E.target;if(t.id===this.getId("tblHeader")){this._setHeaderAnnouncement();}else if(t.id===this.getId("tblFooter")){this._setFooterAnnouncement();}if(this._bThemeChanged){this._bThemeChanged=false;this._forceStyleChange();}L.prototype.onfocusin.call(this,E);};e.prototype.onItemFocusIn=function(i){L.prototype.onItemFocusIn.apply(this,arguments);};e.prototype.onThemeChanged=function(){L.prototype.onThemeChanged.call(this);this._bThemeChanged=true;};e.prototype._getAlternateRowColorsClass=function(){if(this.isGrouped()){return"sapMListTblAlternateRowColorsGrouped";}if(this.hasPopin()){return"sapMListTblAlternateRowColorsPopin";}return"sapMListTblAlternateRowColors";};return e;});
