/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/EventProvider','sap/ui/thirdparty/datajs','sap/ui/core/cache/CacheManager','./_ODataMetaModelUtils',"sap/base/util/uid","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery"],function(E,O,C,U,u,L,a,q){"use strict";var b=E.extend("sap.ui.model.odata.ODataMetadata",{constructor:function(m,p){E.apply(this,arguments);this.bLoaded=false;this.bFailed=false;this.mEntityTypes={};this.mRequestHandles={};this.sUrl=m;this.bAsync=p.async;this.sUser=p.user;this.bWithCredentials=p.withCredentials;this.sPassword=p.password;this.mHeaders=p.headers;this.sCacheKey=p.cacheKey;this.oLoadEvent=null;this.oFailedEvent=null;this.oMetadata=null;this.mNamespaces=p.namespaces||{sap:"http://www.sap.com/Protocols/SAPData",m:"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata","":"http://schemas.microsoft.com/ado/2007/06/edmx"};var t=this;this.fnResolve;this.pLoaded=new Promise(function(r,c){t.fnResolve=r;});function w(p){C.set(t.sCacheKey,JSON.stringify({metadata:t.oMetadata,params:p}));}function l(){L.error("[ODataMetadata] initial loading of metadata failed");}if(this.sCacheKey){C.get(this.sCacheKey).then(function(M){if(M){var c=JSON.parse(M);this.oMetadata=c.metadata;this._handleLoaded(this.oMetadata,c.params,false);}else{this._loadMetadata().then(w).catch(l);}}.bind(this)).catch(l);}else{this._loadMetadata().catch(l);}},metadata:{publicMethods:["getServiceMetadata","attachFailed","detachFailed","attachLoaded","detachLoaded","refresh"]}});b.prototype._setNamespaces=function(n){this.mNamespaces=n;};b.prototype._handleLoaded=function(m,p,s){var e=[];this.oMetadata=this.oMetadata?this.merge(this.oMetadata,m,e):m;this.oRequestHandle=null;p.entitySets=e;this.fnResolve(p);if(this.bAsync&&!s){this.fireLoaded(this);}else if(!this.bAsync&&!s){this.bLoaded=true;this.bFailed=false;this.oLoadEvent=setTimeout(this.fireLoaded.bind(this,p),0);}};b.prototype._loadMetadata=function(s,S){var t=this;s=s||this.sUrl;var r=this._createRequest(s);return new Promise(function(c,d){var R;function _(m,o){if(!m||!m.dataServices){var p={message:"Invalid metadata document",request:r,response:o};e(p);return;}t.sMetadataBody=o.body;t.oRequestHandle=null;var P={metadataString:t.sMetadataBody};var l=o.headers["Last-Modified"];if(l){P.lastModified=l;}var f=o.headers["eTag"];if(f){P.eTag=f;}t._handleLoaded(m,P,S);c(P);}function e(o){var p={message:o.message,request:o.request,response:o.response};if(o.response){p.statusCode=o.response.statusCode;p.statusText=o.response.statusText;p.responseText=o.response.body;}if(R&&R.bSuppressErrorHandlerCall){return;}if(t.bAsync){delete t.mRequestHandles[R.id];}d(p);if(t.bAsync&&!S){t.fireFailed(p);}else if(!t.bAsync&&!S){t.bFailed=true;t.oFailedEvent=setTimeout(t.fireFailed.bind(t,p),0);}}R=O.request(r,_,e,O.metadataHandler);if(t.bAsync){R.id=u();t.mRequestHandles[R.id]=R;}});};b.prototype.refresh=function(){return this._loadMetadata();};b.prototype.getServiceMetadata=function(){return this.oMetadata;};b.prototype.isLoaded=function(){return this.bLoaded;};b.prototype.loaded=function(){return this.pLoaded;};b.prototype.isFailed=function(){return this.bFailed;};b.prototype.fireLoaded=function(p){this.bLoaded=true;this.bFailed=false;this.fireEvent("loaded",p);L.debug(this+" - loaded was fired");return this;};b.prototype.attachLoaded=function(d,f,l){this.attachEvent("loaded",d,f,l);return this;};b.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this;};b.prototype.fireFailed=function(A){this.bFailed=true;this.fireEvent("failed",A);return this;};b.prototype.attachFailed=function(d,f,l){this.attachEvent("failed",d,f,l);return this;};b.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this;};b.prototype._getEntityAssociationEnd=function(e,n){if(!this.oMetadata||q.isEmptyObject(this.oMetadata)){a(undefined,"No metadata loaded!");return null;}if(!this._mGetEntityAssociationEndCache||!this._mGetEntityAssociationEndCache[e.name+"|"+n]){this._mGetEntityAssociationEndCache={};var N=e?U.findObject(e.navigationProperty,n):null,A=N?U.getObject(this.oMetadata.dataServices.schema,"association",N.relationship):null,o=A?U.findObject(A.end,N.toRole,"role"):null;this._mGetEntityAssociationEndCache[e.name+"|"+n]=o;}return this._mGetEntityAssociationEndCache[e.name+"|"+n];};function g(s){var e={};for(var i=0;i<s.length;i++){var S=s[i];if(S.entityContainer){for(var j=0;j<S.entityContainer.length;j++){var o=S.entityContainer[j];if(o.entitySet){for(var k=0;k<o.entitySet.length;k++){if(o.entitySet[k].name!=null){e[o.entitySet[k].name]=o.entitySet[k];}}}}}}return e;}b.prototype._findEntitySetByName=function(n){if(!this.mEntitySets){this.mEntitySets=g(this.oMetadata.dataServices.schema);}return this.mEntitySets[n];};b.prototype._getEntityTypeByPath=function(p){if(!p){a(undefined,"sPath not defined!");return null;}if(!this.oMetadata||q.isEmptyObject(this.oMetadata)){a(undefined,"No metadata loaded!");return null;}if(this.mEntityTypes[p]){return this.mEntityTypes[p];}var c=p.replace(/^\/|\/$/g,""),P=c.split("/"),l=P.length,o,e,d,r,t=this;if(P[0].indexOf("(")!=-1){P[0]=P[0].substring(0,P[0].indexOf("("));}if(l>1){o=t._getEntityTypeByPath(P[0]);for(var i=1;i<P.length;i++){if(o){if(P[i].indexOf("(")!=-1){P[i]=P[i].substring(0,P[i].indexOf("("));}r=t._getEntityTypeByNavProperty(o,P[i]);if(r){o=r;}d=o;}}}else{e=this._splitName(this._getEntityTypeName(P[0]));d=this._getObjectMetadata("entityType",e.name,e.namespace);if(d){d.entityType=this._getEntityTypeName(P[0]);}}if(!d){var f=P[P.length-1];var F=this._getFunctionImportMetadata(f,"GET");if(!F){F=this._getFunctionImportMetadata(f,"POST");}if(F&&F.entitySet){d=this._getEntityTypeByPath(F.entitySet);if(d){d.entityType=this._getEntityTypeName(F.entitySet);}}}if(d){this.mEntityTypes[p]=d;}return d;};b.prototype._getEntityTypeByName=function(n){var e,t=this,s,N,o;if(!n){a(undefined,"sName not defined!");return null;}o=this._splitName(n);N=o.namespace;s=o.name;if(!this.oMetadata||q.isEmptyObject(this.oMetadata)){a(undefined,"No metadata loaded!");return null;}if(this.mEntityTypes[n]){e=this.mEntityTypes[n];}else{q.each(this.oMetadata.dataServices.schema,function(i,S){if(S.entityType&&(!N||S.namespace===N)){q.each(S.entityType,function(k,c){if(c.name===s){e=c;t.mEntityTypes[n]=e;e.namespace=S.namespace;return false;}});}});}return e;};b.prototype._getAnnotation=function(p){var n,P,m,M,e,s,o;P=p.split('/#');M=P[1].split('/');if(!P[0]){e=this._getEntityTypeByName(M[0]);a(e,M[0]+" is not a valid EntityType");if(!e){return;}s=P[1].substr(P[1].indexOf('/')+1);o=this._getPropertyMetadata(e,s);a(o,s+" is not a valid property path");if(!o){return;}m=s.substr(s.indexOf(o.name));m=m.substr(m.indexOf('/')+1);}else{e=this._getEntityTypeByPath(P[0]);a(e,P[0]+" is not a valid path");if(!e){return;}p=P[0].replace(/^\/|\/$/g,"");s=p;while(!o&&s.indexOf("/")>0){s=s.substr(s.indexOf('/')+1);o=this._getPropertyMetadata(e,s);}a(o,s+" is not a valid property path");if(!o){return;}m=M.join('/');}n=this._getAnnotationObject(e,o,m);return n;};b.prototype._getAnnotationObject=function(e,o,m){var A,p,c,n,s;if(!o){return;}n=o;p=m.split('/');if(p[0].indexOf('.')>-1){return this._getV4AnnotationObject(e,o,p);}else{if(p.length>1){n=n[p[0]];if(!n&&o.extensions){for(var i=0;i<o.extensions.length;i++){var d=o.extensions[i];if(d.name==p[0]){n=d;break;}}}m=p.splice(0,1);c=this._getAnnotationObject(e,n,p.join('/'));}else{if(p[0].indexOf('@')>-1){s=p[0].substr(1);A=s.split(':');c=n[A[0]];if(!c&&n.extensions){for(var i=0;i<n.extensions.length;i++){var d=n.extensions[i];if(d.name===A[1]&&d.namespace===this.mNamespaces[A[0]]){c=d.value;break;}}}}else{A=p[0].split(':');c=n[A[0]];c=n[p[0]];if(!c&&n.extensions){for(var i=0;i<n.extensions.length;i++){var d=n.extensions[i];if(d.name===A[1]&&d.namespace===this.mNamespaces[A[0]]){c=d;break;}}}}}}return c;};b.prototype._getV4AnnotationObject=function(e,o,p){var A,c=[];if(p.length>1){a(p.length==1,"'"+p.join('/')+"' is not a valid annotation path");return;}var t=e.namespace?e.namespace+".":"";t+=e.name+"/"+o.name;q.each(this.oMetadata.dataServices.schema,function(i,s){if(s.annotations){q.each(s.annotations,function(k,o){if(o.target===t&&!o.qualifier){c.push(o.annotation);return false;}});}});if(c){q.each(c,function(i,d){q.each(d,function(j,f){if(f.term===p[0]){A=f;}});});}return A;};b.prototype._splitName=function(f){var i={};if(f){var s=f.lastIndexOf(".");i.name=f.substr(s+1);i.namespace=f.substr(0,s);}return i;};b.prototype._getEntityTypeName=function(c){var e,o;if(c){o=this._findEntitySetByName(c);if(o){e=o.entityType;}}return e;};b.prototype._getObjectMetadata=function(o,s,n){var c;if(s&&n){q.each(this.oMetadata.dataServices.schema,function(i,S){if(S[o]&&S.namespace===n){q.each(S[o],function(j,d){if(d.name===s){c=d;c.namespace=S.namespace;return false;}});return!c;}});}return c;};b.prototype.getUseBatch=function(){var c=false;q.each(this.oMetadata.dataServices.schema,function(i,s){if(s.entityContainer){q.each(s.entityContainer,function(k,e){if(e.extensions){q.each(e.extensions,function(l,o){if(o.name==="use-batch"&&o.namespace==="http://www.sap.com/Protocols/SAPData"){c=(typeof o.value==='string')?(o.value.toLowerCase()==='true'):!!o.value;return false;}});}});}});return c;};b.prototype._getFunctionImportMetadata=function(f,m){var o=null;if(f.indexOf("/")>-1){f=f.substr(f.indexOf("/")+1);}q.each(this.oMetadata.dataServices.schema,function(i,s){if(s["entityContainer"]){q.each(s["entityContainer"],function(j,e){if(e["functionImport"]){q.each(e["functionImport"],function(k,F){if(F.name===f&&F.httpMethod===m){o=F;return false;}});}return!o;});}return!o;});return o;};b.prototype._getEntityTypeByNavProperty=function(e,n){if(!e.navigationProperty){return undefined;}for(var i=0;i<e.navigationProperty.length;++i){var N=e.navigationProperty[i];if(N.name===n){return this._getEntityTypeByNavPropertyObject(N);}}return undefined;};b.prototype._getEntityTypeByNavPropertyObject=function(n){var t;var A=this._splitName(n.relationship);var m=this._getObjectMetadata("association",A.name,A.namespace);if(m){var e=m.end[0];if(e.role!==n.toRole){e=m.end[1];}var o=this._splitName(e.type);t=this._getObjectMetadata("entityType",o.name,o.namespace);if(t){t.entityType=e.type;}}return t;};b.prototype._getNavigationPropertyNames=function(e){var n=[];if(e.navigationProperty){q.each(e.navigationProperty,function(k,N){n.push(N.name);});}return n;};b.prototype._getPropertyMetadata=function(e,p){var P,t=this;if(!e){return;}p=p.replace(/^\/|\/$/g,"");var c=p.split("/");q.each(e.property,function(k,o){if(o.name===c[0]){P=o;return false;}});if(c.length>1){if(!P){while(e&&c.length>1){e=this._getEntityTypeByNavProperty(e,c[0]);c.shift();}if(e){P=t._getPropertyMetadata(e,c[0]);}}else if(!P.type.toLowerCase().startsWith("edm.")){var n=this._splitName(P.type);P=this._getPropertyMetadata(this._getObjectMetadata("complexType",n.name,n.namespace),c[1]);}}return P;};b.prototype.destroy=function(){delete this.oMetadata;var t=this;q.each(this.mRequestHandles,function(k,r){r.bSuppressErrorHandlerCall=true;r.abort();delete t.mRequestHandles[k];});if(!!this.oLoadEvent){clearTimeout(this.oLoadEvent);}if(!!this.oFailedEvent){clearTimeout(this.oFailedEvent);}E.prototype.destroy.apply(this,arguments);};b.prototype._createRequest=function(s){var d={"sap-cancel-on-close":true},l={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()};q.extend(d,this.mHeaders,l);var r={headers:d,requestUri:s,method:'GET',user:this.sUser,password:this.sPassword,async:this.bAsync};if(this.bAsync){r.withCredentials=this.bWithCredentials;}return r;};b.prototype._getEntitySetByPath=function(e){if(!this._entitySetMap){this._entitySetMap={};this.oMetadata.dataServices.schema.forEach(function(s){if(s.entityContainer){s.entityContainer.forEach(function(c){if(c.entitySet){c.entitySet.forEach(function(m){this._entitySetMap[m.entityType]=m;},this);}},this);}},this);}var o=this._getEntityTypeByPath(e);if(o){return this._entitySetMap[o.entityType];}return;};b.prototype._addUrl=function(v){var c=[].concat(v);return Promise.all(c.map(function(s){return this._loadMetadata(s,true);},this));};b.prototype.merge=function(t,s,e){var c=this;if(this.mEntitySets){delete this.mEntitySets;}q.each(t.dataServices.schema,function(i,T){q.each(s.dataServices.schema,function(j,S){if(S.namespace===T.namespace){if(S.entityType){if(!c.mEntityTypeNames){c.mEntityTypeNames={};T.entityType.map(function(o){c.mEntityTypeNames[o.name]=true;});}T.entityType=!T.entityType?[]:T.entityType;for(var i=0;i<S.entityType.length;i++){if(!(S.entityType[i].name in c.mEntityTypeNames)){T.entityType.push(S.entityType[i]);c.mEntityTypeNames[S.entityType[i].name]=true;}}}if(T.entityContainer&&S.entityContainer){q.each(T.entityContainer,function(k,d){q.each(S.entityContainer,function(l,f){if(f.entitySet){if(f.name===d.name){if(!c.mEntitySetNames){c.mEntitySetNames={};d.entitySet.map(function(o){c.mEntitySetNames[o.name]=true;});}d.entitySet=!d.entitySet?[]:d.entitySet;for(var i=0;i<f.entitySet.length;i++){if(!(f.entitySet[i].name in c.mEntitySetNames)){d.entitySet.push(f.entitySet[i]);c.mEntitySetNames[f.entitySet[i].name]=true;}}f.entitySet.forEach(function(o){e.push(o);});}}});});}if(S.annotations){T.annotations=!T.annotations?[]:T.annotations;T.annotations=T.annotations.concat(S.annotations);}}});});return t;};b.prototype._getEntitySetByType=function(e){var s=e.namespace+"."+e.name;var S=this.oMetadata.dataServices.schema;for(var i=0;i<S.length;++i){var c=S[i].entityContainer;if(c){for(var n=0;n<c.length;++n){var d=c[n].entitySet;if(d){for(var m=0;m<d.length;++m){if(d[m].entityType===s){return d[m];}}}}}}return null;};return b;});
