/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/Sorter','sap/ui/model/FilterProcessor','sap/ui/core/format/DateFormat',"sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery","sap/base/security/encodeURL"],function(S,F,D,L,a,q,e){"use strict";var r=/^([-+]?)0*(\d+)(\.\d+|)$/,b=/\.$/,c=/0+$/;var O=function(){};O.createSortParams=function(m){var o;if(!m||m.length==0){return;}o="$orderby=";for(var i=0;i<m.length;i++){var t=m[i];if(t instanceof S){o+=t.sPath;o+=t.bDescending?"%20desc":"%20asc";o+=",";}else{L.error("Trying to use "+t+" as a Sorter, but it is a "+typeof t);}}o=o.slice(0,-1);return o;};O.createFilterParams=function(v,m,E){var o=Array.isArray(v)?F.groupFilters(v):v;if(!o){return;}return"$filter="+this._createFilterParams(o,m,E);};O._createFilterParams=function(v,m,E){var t=this,o=Array.isArray(v)?F.groupFilters(v):v;function u(o,i){if(o.aFilters){return w(o,i);}return t._createFilterSegment(o.sPath,m,E,o.sOperator,o.oValue1,o.oValue2,o.bCaseSensitive);}function w(M,x){var y=M.aFilters,A=!!M.bAnd,z="";if(y.length===1){if(y[0]._bMultiFilter){return u(y[0]);}return u(y[0],true);}if(!x){z+="(";}z+=u(y[0]);for(var i=1;i<y.length;i++){z+=A?"%20and%20":"%20or%20";z+=u(y[i]);}if(!x){z+=")";}return z;}if(!o){return;}return u(o,true);};O._createUrlParamsArray=function(P){var u,t=q.type(P),i;if(t==="array"){return P;}u=[];if(t==="object"){i=this._encodeURLParameters(P);if(i){u.push(i);}}else if(t==="string"){if(P){u.push(P);}}return u;};O._encodeURLParameters=function(P){if(!P){return"";}var u=[];q.each(P,function(i,v){if(q.type(v)==="string"){v=encodeURIComponent(v);}i=i.startsWith('$')?i:encodeURIComponent(i);u.push(i+"="+v);});return u.join("&");};O.setOrigin=function(i,P){var o,m,C;if(!i||!P||i.indexOf(";mo")>0){return i;}if(typeof P=="string"){o=P;}else{o=P.alias;if(!o){m=P.system;C=P.client;if(!m||!C){L.warning("ODataUtils.setOrigin: No Client or System ID given for Origin");return i;}o="sid("+m+"."+C+")";}}var u=i.split("?");var B=u[0];var U=u[1]?"?"+u[1]:"";var t="";if(B[B.length-1]==="/"){B=B.substring(0,B.length-1);t="/";}var v=/(\/[^\/]+)$/g;var w=/(;o=[^\/;]+)/g;var x=B.match(v)[0];var y=x.match(w);var z=y?y[0]:null;if(z){if(P.force){var A=x.replace(z,";o="+o);B=B.replace(x,A);return B+t+U;}return i;}B=B+";o="+o+t;return B+U;};O.setAnnotationOrigin=function(A,P){var i;var m=A.indexOf("/Annotations(");if(m===-1){m=A.indexOf("/Annotations%28");}if(m>=0){if(A.indexOf("/$value",m)===-1){L.warning("ODataUtils.setAnnotationOrigin: Annotation url is missing $value segment.");i=A;}else{var o=A.substring(0,m);var t=A.substring(m,A.length);var u=O.setOrigin(o,P);i=u+t;}}else{i=A.replace(P.preOriginBaseUri,P.postOriginBaseUri);}return i;};O._resolveMultiFilter=function(m,M,E){var t=this,o=m.aFilters,u="";if(o){u+="(";q.each(o,function(i,v){if(v._bMultiFilter){u+=t._resolveMultiFilter(v,M,E);}else if(v.sPath){u+=t._createFilterSegment(v.sPath,M,E,v.sOperator,v.oValue1,v.oValue2,"",v.bCaseSensitive);}if(i<(o.length-1)){if(m.bAnd){u+="%20and%20";}else{u+="%20or%20";}}});u+=")";}return u;};O._createFilterSegment=function(P,m,E,o,v,V,C){var i,t;if(C===undefined){C=true;}if(E){i=m._getPropertyMetadata(E,P);t=i&&i.type;a(i,"PropertyType for property "+P+" of EntityType "+E.name+" not found!");}if(t){v=this.formatValue(v,t,C);V=(V!=null)?this.formatValue(V,t,C):null;}else{a(null,"Type for filter property could not be found in metadata!");}if(v){v=e(String(v));}if(V){V=e(String(V));}if(!C&&t==="Edm.String"){P="toupper("+P+")";}switch(o){case"EQ":case"NE":case"GT":case"GE":case"LT":case"LE":return P+"%20"+o.toLowerCase()+"%20"+v;case"BT":return"("+P+"%20ge%20"+v+"%20and%20"+P+"%20le%20"+V+")";case"NB":return"not%20("+P+"%20ge%20"+v+"%20and%20"+P+"%20le%20"+V+")";case"Contains":return"substringof("+v+","+P+")";case"NotContains":return"not%20substringof("+v+","+P+")";case"StartsWith":return"startswith("+P+","+v+")";case"NotStartsWith":return"not%20startswith("+P+","+v+")";case"EndsWith":return"endswith("+P+","+v+")";case"NotEndsWith":return"not%20endswith("+P+","+v+")";default:L.error("ODataUtils :: Unknown filter operator "+o);return"true";}};O.formatValue=function(v,t,C){if(C===undefined){C=true;}if(!this.oDateTimeFormat){this.oDateTimeFormat=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss''"});this.oDateTimeFormatMs=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss.SSS''"});this.oDateTimeOffsetFormat=D.getDateInstance({pattern:"'datetimeoffset'''yyyy-MM-dd'T'HH:mm:ss'Z'''"});this.oTimeFormat=D.getTimeInstance({pattern:"'time''PT'HH'H'mm'M'ss'S'''"});}if(v===null||v===undefined){return"null";}var V;switch(t){case"Edm.String":v=C?v:v.toUpperCase();V="'"+String(v).replace(/'/g,"''")+"'";break;case"Edm.Time":if(typeof v==="object"){V=this.oTimeFormat.format(new Date(v.ms),true);}else{V="time'"+v+"'";}break;case"Edm.DateTime":var o=new Date(v);if(o.getMilliseconds()>0){V=this.oDateTimeFormatMs.format(o,true);}else{V=this.oDateTimeFormat.format(o,true);}break;case"Edm.DateTimeOffset":var o=new Date(v);V=this.oDateTimeOffsetFormat.format(o,true);break;case"Edm.Guid":V="guid'"+v+"'";break;case"Edm.Decimal":V=v+"m";break;case"Edm.Int64":V=v+"l";break;case"Edm.Double":V=v+"d";break;case"Edm.Float":case"Edm.Single":V=v+"f";break;case"Edm.Binary":V="binary'"+v+"'";break;default:V=String(v);break;}return V;};function s(v,V){if(v===V){return 0;}if(v===null||V===null||v===undefined||V===undefined){return NaN;}return v>V?1:-1;}function p(v){var m;if(typeof v!=="string"){return undefined;}m=r.exec(v);if(!m){return undefined;}return{sign:m[1]==="-"?-1:1,integerLength:m[2].length,abs:m[2]+m[3].replace(c,"").replace(b,"")};}function d(v,V){var o,i,R;if(v===V){return 0;}o=p(v);i=p(V);if(!o||!i){return NaN;}if(o.sign!==i.sign){return o.sign>i.sign?1:-1;}R=s(o.integerLength,i.integerLength)||s(o.abs,i.abs);return o.sign*R;}var f=/^PT(\d\d)H(\d\d)M(\d\d)S$/;function g(v){if(typeof v==="string"&&f.test(v)){v=parseInt(RegExp.$1,10)*3600000+parseInt(RegExp.$2,10)*60000+parseInt(RegExp.$3,10)*1000;}if(v instanceof Date){return v.getTime();}if(v&&v.__edmType==="Edm.Time"){return v.ms;}return v;}O.compare=function(v,V,A){return A?d(v,V):s(g(v),g(V));};O.getComparator=function(E){switch(E){case"Edm.Date":case"Edm.DateTime":case"Edm.DateTimeOffset":case"Edm.Time":return O.compare;case"Edm.Decimal":case"Edm.Int64":return d;default:return s;}};var h=/([(=,])('.*?')([,)])/g,j=/[MLDF](?=[,)](?:[^']*'[^']*')*[^']*$)/g,k=/([(=,])(X')/g,n=function(v,i,m,o){return i+encodeURIComponent(decodeURIComponent(m))+o;},N=function(v){return v.toLowerCase();},l=function(v,i){return i+"binary'";};O._normalizeKey=function(K){return K.replace(h,n).replace(j,N).replace(k,l);};return O;},true);
