/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['../_AnnotationHelperBasics','sap/ui/base/BindingParser','sap/ui/base/ManagedObject',"sap/ui/performance/Measurement","sap/base/Log"],function(B,a,M,b,L){'use strict';var A="sap.ui.model.odata.v4.AnnotationHelper",p=[A],P=A+"/getExpression",E,r=/^\{@i18n>[^\\\{\}:]+\}$/,o={And:"&&",Eq:"===",Ge:">=",Gt:">",Le:"<=",Lt:"<",Ne:"!==",Not:"!",Or:"||"},s=false,t={"Edm.Boolean":"boolean","Edm.Byte":"number","Edm.Date":"Date","Edm.DateTimeOffset":"DateTimeOffset","Edm.Decimal":"Decimal","Edm.Double":"number","Edm.Guid":"string","Edm.Int16":"number","Edm.Int32":"number","Edm.Int64":"Decimal","Edm.SByte":"number","Edm.Single":"number","Edm.String":"string","Edm.TimeOfDay":"TimeOfDay"},T={Bool:"Edm.Boolean",Float:"Edm.Double",Date:"Edm.Date",DateTimeOffset:"Edm.DateTimeOffset",Decimal:"Edm.Decimal",Guid:"Edm.Guid",Int:"Edm.Int64",Int32:"Edm.Int32",String:"Edm.String",TimeOfDay:"Edm.TimeOfDay"},m={"boolean":false,"Date":false,"DateTimeOffset":true,"Decimal":true,"number":false,"string":false,"TimeOfDay":false};function c(d,e){B.error(d,e,A);}E={adjustOperands:function(O,d){if(O.result!=="constant"&&O.category==="number"&&d.result==="constant"&&d.type==="Edm.Int64"){d.category="number";}if(O.result!=="constant"&&O.category==="Decimal"&&d.result==="constant"&&d.type==="Edm.Int32"){d.category="Decimal";d.type=O.type;}},apply:function(d,e){var f=B.descend(d,"$Function","string");switch(f.value){case"odata.concat":return E.concat(e);case"odata.fillUriTemplate":return E.fillUriTemplate(e);case"odata.uriEncode":return E.uriEncode(e);default:c(f,"unknown function: "+f.value);}},concat:function(d){var e=d.asExpression,f=[],R,g=[];B.expectType(d,"array");d.value.forEach(function(u,i){R=E.parameter(d,i);e=e||R.result==="expression";g.push(R);});g.forEach(function(R){if(e){E.wrapExpression(R);}if(R.type!=='edm:Null'){f.push(B.resultToString(R,e));}});R=e?{result:"expression",value:f.join("+")}:{result:"composite",value:f.join("")};R.type="Edm.String";return R;},conditional:function(d){var C=E.parameter(d,0,"Edm.Boolean"),e=E.parameter(d,1),f=E.parameter(d,2),g=e.type;if(e.type==="edm:Null"){g=f.type;}else if(f.type!=="edm:Null"&&e.type!==f.type){c(d,"Expected same type for second and third parameter, types are '"+e.type+"' and '"+f.type+"'");}return{result:"expression",type:g,value:B.resultToString(E.wrapExpression(C),true)+"?"+B.resultToString(E.wrapExpression(e),true)+":"+B.resultToString(E.wrapExpression(f),true)};},constant:function(d,e){var v=d.value;if(e==="String"){if(r.test(v)){return{ignoreTypeInPath:true,result:"binding",type:"Edm.String",value:v.slice(1,-1)};}}return{result:"constant",type:T[e],value:v};},expression:function(d){var R=d.value,S=d,e;if(R===null){e="Null";}else if(typeof R==="boolean"){e="Bool";}else if(typeof R==="number"){e=isFinite(R)&&Math.floor(R)===R?"Int32":"Float";}else if(typeof R==="string"){e="String";}else{B.expectType(d,"object");["$And","$Apply","$Date","$DateTimeOffset","$Decimal","$Float","$Eq","$Ge","$Gt","$Guid","$If","$Int","$Le","$Lt","$Ne","$Not","$Null","$Or","$Path","$PropertyPath","$TimeOfDay"].forEach(function(f){if(R.hasOwnProperty(f)){e=f.slice(1);S=B.descend(d,f);}});}switch(e){case"Apply":return E.apply(d,S);case"If":return E.conditional(S);case"Path":case"PropertyPath":return E.path(S);case"Date":case"DateTimeOffset":case"Decimal":case"Guid":case"Int":case"String":case"TimeOfDay":B.expectType(S,"string");case"Bool":case"Float":case"Int32":return E.constant(S,e);case"And":case"Eq":case"Ge":case"Gt":case"Le":case"Lt":case"Ne":case"Or":return E.operator(S,e);case"Not":return E.not(S);case"Null":return{result:"constant",type:"edm:Null",value:null};default:c(d,"Unsupported OData expression");}},formatOperand:function(d,i,R,w){if(R.result==="constant"){switch(R.category){case"boolean":case"number":return String(R.value);}}if(w){E.wrapExpression(R);}return B.resultToString(R,true);},getExpression:function(d){var R;if(d.value===undefined){return undefined;}b.average(P,"",p);if(!s&&M.bindingParser===a.simpleParser){L.warning("Complex binding syntax not active",null,A);s=true;}try{R=E.expression(d);b.end(P);return B.resultToString(R,false);}catch(e){b.end(P);if(e instanceof SyntaxError){return"Unsupported: "+a.complexParser.escape(B.toErrorString(d.value));}throw e;}},fillUriTemplate:function(d){var i,n,e=[],f="",g,h=d.value,R,j=E.parameter(d,0,"Edm.String");e.push('odata.fillUriTemplate(',B.resultToString(j,true),',{');for(i=1;i<h.length;i+=1){g=B.descend(d,i,"object");n=B.property(g,"$Name","string");R=E.expression(B.descend(g,"$LabeledElement",true));e.push(f,B.toJSON(n),":",B.resultToString(R,true));f=",";}e.push("})");return{result:"expression",type:"Edm.String",value:e.join("")};},not:function(d){var e;d.asExpression=true;e=E.expression(d);return{result:"expression",type:"Edm.Boolean",value:"!"+B.resultToString(E.wrapExpression(e),true)};},operator:function(d,e){var f=e==="And"||e==="Or"?"Edm.Boolean":undefined,n,g=E.parameter(d,0,f),h=E.parameter(d,1,f),S="",v,V;if(g.type!=="edm:Null"&&h.type!=="edm:Null"){g.category=t[g.type];h.category=t[h.type];E.adjustOperands(g,h);E.adjustOperands(h,g);if(g.category!==h.category){c(d,"Expected two comparable parameters but instead saw "+g.type+" and "+h.type);}switch(g.category){case"Decimal":S=",'Decimal'";break;case"DateTimeOffset":S=",'DateTime'";break;}n=m[g.category];}v=E.formatOperand(d,0,g,!n);V=E.formatOperand(d,1,h,!n);return{result:"expression",type:"Edm.Boolean",value:n?"odata.compare("+v+","+V+S+")"+o[e]+"0":v+o[e]+V};},parameter:function(d,i,e){var f=B.descend(d,i,true),R=E.expression(f);if(e&&e!==R.type){c(f,"Expected "+e+" but instead saw "+R.type);}return R;},path:function(d){B.expectType(d,"string");return{result:"binding",type:d.model.getProperty(d.path+"/$Type"),value:d.value};},uriEncode:function(d){var R=E.parameter(d,0);return{result:"expression",type:"Edm.String",value:R.type==="Edm.String"?'odata.uriEncode('+B.resultToString(R,true)+","+B.toJSON(R.type)+")":'String('+B.resultToString(R,true)+")"};},wrapExpression:function(R){if(R.result==="expression"){R.value="("+R.value+")";}return R;}};return E;},false);
