/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/URI","sap/base/Log"],function(U,L){"use strict";var r=/&/g,a=/\=/g,b=/%29/g,c=/%28/g,d=/%27/g,f=/#/g,g=/\([^/]*|\/-?\d+/g,h=/^-?\d+$/,j=/\+/g,k=/'/g,H;H={buildPath:function(){var i,p="",s;for(i=0;i<arguments.length;i++){s=arguments[i];if(s||s===0){if(p&&p!=="/"&&s[0]!=="("){p+="/";}p+=s;}}return p;},buildQuery:function(p){var K,q;if(!p){return"";}K=Object.keys(p);if(K.length===0){return"";}q=[];K.forEach(function(s){var v=p[s];if(Array.isArray(v)){v.forEach(function(i){q.push(H.encodePair(s,i));});}else{q.push(H.encodePair(s,v));}});return"?"+q.join("&");},clone:function clone(v){return v===undefined||v===Infinity||v===-Infinity||v!==v?v:JSON.parse(JSON.stringify(v));},createError:function(i){var B=i.responseText,C=i.getResponseHeader("Content-Type"),R=new Error(i.status+" "+i.statusText);R.status=i.status;R.statusText=i.statusText;if(i.status===0){R.message="Network error";return R;}if(C){C=C.split(";")[0];}if(i.status===412){R.isConcurrentModification=true;}if(C==="application/json"){try{R.error=JSON.parse(B).error;R.message=R.error.message;if(typeof R.message==="object"){R.message=R.error.message.value;}}catch(e){L.warning(e.toString(),B,"sap.ui.model.odata.v4.lib._Helper");}}else if(C==="text/plain"){R.message=B;}return R;},createGetMethod:function(F,t){return function(){var s=this[F].apply(this,arguments);if(s.isFulfilled()){return s.getResult();}else if(t){if(s.isRejected()){s.caught();throw s.getResult();}else{throw new Error("Result pending");}}};},createRequestMethod:function(F){return function(){return Promise.resolve(this[F].apply(this,arguments));};},deletePrivateAnnotation:function(o,A){var p=o["@$ui5._"];if(p){delete p[A];}},drillDown:function(D,p){return p.reduce(function(D,s){return(D&&s in D)?D[s]:undefined;},D);},encode:function(p,e){var E=encodeURI(p).replace(r,"%26").replace(f,"%23").replace(j,"%2B");if(e){E=E.replace(a,"%3D");}return E;},encodePair:function(K,v){return H.encode(K,true)+"="+H.encode(v,false);},fireChange:function(C,p,v){var l=C[p],i;if(l){for(i=0;i<l.length;i++){l[i].onChange(v);}}},fireChanges:function(C,p,v,R){Object.keys(v).forEach(function(P){var s=H.buildPath(p,P),V=v[P];if(V&&typeof V==="object"){H.fireChanges(C,s,V,R);}else{H.fireChange(C,s,R?undefined:V);}});},formatLiteral:function(v,t){if(v===undefined){throw new Error("Illegal value: undefined");}if(v===null){return"null";}switch(t){case"Edm.Binary":return"binary'"+v+"'";case"Edm.Boolean":case"Edm.Byte":case"Edm.Double":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":case"Edm.Single":return String(v);case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return v;case"Edm.Duration":return"duration'"+v+"'";case"Edm.String":return"'"+v.replace(k,"''")+"'";default:throw new Error("Unsupported type: "+t);}},getKeyPredicate:function(i,m,t){var K=[],e=H.getKeyProperties(i,m,t,true);if(!e){return undefined;}K=Object.keys(e).map(function(A,I,l){var v=encodeURIComponent(e[A]);return l.length===1?v:encodeURIComponent(A)+"="+v;});return"("+K.join(",")+")";},getKeyProperties:function(i,m,t,R){var F,K={};F=t[m].$Key.some(function(v){var s,e,p,P,T,V;if(typeof v==="string"){s=e=v;}else{s=Object.keys(v)[0];e=v[s];if(!R){s=e;}}p=e.split("/");V=H.drillDown(i,p);if(V===undefined){return true;}P=p.pop();T=t[H.buildPath(m,p.join("/"))];V=H.formatLiteral(V,T[P].$Type);K[s]=V;});return F?undefined:K;},getMetaPath:function(p){return p.replace(g,"");},getPrivateAnnotation:function(o,A){var p=o["@$ui5._"];return p&&p[A];},getSelectForPath:function(q,p){if(p){p.split("/").some(function(s){if(!h.test(s)){q=q&&q.$expand&&q.$expand[s];}});}return q&&q.$select;},hasPrivateAnnotation:function(o,A){var p=o["@$ui5._"];return p?A in p:false;},isSafeInteger:function(n){if(typeof n!=="number"||!isFinite(n)){return false;}n=Math.abs(n);return n<=9007199254740991&&Math.floor(n)===n;},makeAbsolute:function(u,B){return new U(u).absoluteTo(B).toString().replace(d,"'").replace(c,"(").replace(b,")");},namespace:function(n){var i=n.indexOf("/");if(i>=0){n=n.slice(0,i);}i=n.lastIndexOf(".");return i<0?"":n.slice(0,i);},parseLiteral:function(l,t,p){function e(n){if(!isFinite(n)){throw new Error(p+": Not a valid "+t+" literal: "+l);}return n;}if(l==="null"){return null;}switch(t){case"Edm.Boolean":return l==="true";case"Edm.Byte":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":return e(parseInt(l,10));case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return l;case"Edm.Double":case"Edm.Single":return l==="INF"||l==="-INF"||l==="NaN"?l:e(parseFloat(l));default:throw new Error(p+": Unsupported type: "+t);}},publicClone:function(v){var C=H.clone(v);if(C){delete C["@$ui5._"];}return C;},setPrivateAnnotation:function(o,A,v){var p=o["@$ui5._"];if(!p){p=o["@$ui5._"]={};}p[A]=v;},toArray:function(e){if(e===undefined||e===null){return[];}if(Array.isArray(e)){return e;}return[e];},updateCache:function(C,p,o,P){if(!P){return;}Object.keys(o).forEach(function(s){var e=H.buildPath(p,s),O=o[s],n;if(s in P){n=P[s];if(n&&typeof n==="object"){if(O){H.updateCache(C,e,O,n);}else{o[s]=n;H.fireChanges(C,e,n,false);}}else if(O&&typeof O==="object"){o[s]=n;H.fireChanges(C,e,O,true);}else{o[s]=n;if(O!==n){H.fireChange(C,e,n);}}}});},updateCacheAfterPost:function(C,p,o,P,s){function e(p,l,o,P){var S=l.split("/");S.every(function(m,I){if(P[m]===null){o[m]=null;if(I<S.length-1){return false;}H.fireChange(C,H.buildPath(p,l),o[m]);}else if(typeof P[m]==="object"){o[m]=o[m]||{};}else{if(o[m]!==P[m]){o[m]=P[m];H.fireChange(C,H.buildPath(p,l),o[m]);}return false;}o=o[m];P=P[m];return true;});}function i(O,l){Object.keys(O).forEach(function(m){var n=l?l+"/"+m:m,v=O[m];if(v!==null&&typeof v==="object"){i(v,n);}else{s.push(n);}});}if(!s||s.indexOf("*")>=0){s=[];i(P);}else{s=s.concat("@odata.etag");}s.forEach(function(l){e(p,l,o,P);});}};return H;},false);
