/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/ClientModel','sap/ui/model/Context','./XMLListBinding','./XMLPropertyBinding','./XMLTreeBinding',"sap/ui/util/XMLHelper","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,a,X,b,c,d,L,q){"use strict";var e=C.extend("sap.ui.model.xml.XMLModel",{constructor:function(D){C.apply(this,arguments);this.oNameSpaces=null;if(D&&D.documentElement){this.setData(D);}},metadata:{publicMethods:["setXML","getXML","setNameSpace"]}});e.prototype.setXML=function(x){var o=d.parse(x);if(o.parseError.errorCode!=0){var p=o.parseError;L.fatal("The following problem occurred: XML parse Error for "+p.url+" code: "+p.errorCode+" reason: "+p.reason+" src: "+p.srcText+" line: "+p.line+" linepos: "+p.linepos+" filepos: "+p.filepos);this.fireParseError({url:p.url,errorCode:p.errorCode,reason:p.reason,srcText:p.srcText,line:p.line,linepos:p.linepos,filepos:p.filepos});}this.setData(o);};e.prototype.getXML=function(){return d.serialize(this.oData);};e.prototype.setData=function(D){this.oData=D;this.checkUpdate();};e.prototype.loadData=function(u,p,A,t,f,h){var g=this;A=(A!==false);t=t||"GET";f=f===undefined?this.bCache:f;this.fireRequestSent({url:u,type:t,async:A,headers:h,info:"cache="+f,infoObject:{cache:f}});this._ajax({url:u,async:A,cache:f,dataType:'xml',data:p,headers:h,type:t,success:function(D){if(!D){L.fatal("The following problem occurred: No data was retrieved by service: "+u);}g.setData(D);g.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+f,infoObject:{cache:f},success:true});},error:function(i,j,k){var E={message:j,statusCode:i.status,statusText:i.statusText,responseText:i.responseText};L.fatal("The following problem occurred: "+j,i.responseText+","+i.status+","+i.statusText);g.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+f,infoObject:{cache:f},success:false,errorobject:E});g.fireRequestFailed(E);}});};e.prototype.setNameSpace=function(n,p){if(!p){p="";}if(!this.oNameSpaces){this.oNameSpaces={};}this.oNameSpaces[p]=n;};e.prototype.bindProperty=function(p,o,P){var B=new b(this,p,o,P);return B;};e.prototype.bindList=function(p,o,s,f,P){var B=new X(this,p,o,s,f,P);return B;};e.prototype.bindTree=function(p,o,f,P,s){var B=new c(this,p,o,f,P,s);return B;};e.prototype.setProperty=function(p,v,o,A){var O=p.substring(0,p.lastIndexOf("/")+1),P=p.substr(p.lastIndexOf("/")+1);if(!this.resolve(p,o)){return false;}if(!this.oData.documentElement){L.warning("Trying to set property "+p+", but no document exists.");return false;}var f;if(P.indexOf("@")==0){f=this._getObject(O,o);if(f[0]){f[0].setAttribute(P.substr(1),v);this.checkUpdate(false,A);return true;}}else{f=this._getObject(p,o);if(f[0]){q(f[0]).text(v);this.checkUpdate(false,A);return true;}}return false;};e.prototype.getProperty=function(p,o){var r=this._getObject(p,o);if(r&&typeof r!="string"){r=q(r[0]).text();}return r;};e.prototype.getObject=function(p,o){var O=this._getObject(p,o);if(Array.isArray(O)){O=O[0];}return O;};e.prototype._getObject=function(p,o){var r=this.oData.documentElement;if(!r){return null;}var n=this.isLegacySyntax()?[r]:[];if(o instanceof a){n=this._getObject(o.getPath());}else if(o){n=[o];}if(!p){return n;}var P=p.split("/"),s,i=0;if(!P[0]){n=r;i++;}n=n.length==undefined?[n]:n;n=n[0]?n:null;while(n&&n.length>0&&P[i]){s=P[i];if(s.indexOf("@")==0){n=this._getAttribute(n[0],s.substr(1));}else if(s=="text()"){n=q(n[0]).text();}else if(isNaN(s)){n=this._getChildElementsByTagName(n[0],s);}else{n=[n[s]];}i++;}return n;};e.prototype._getAttribute=function(n,N){if(!this.oNameSpaces||N.indexOf(":")==-1){return n.getAttribute(N);}var s=this._getNameSpace(N),l=this._getLocalName(N);if(n.getAttributeNS){return n.getAttributeNS(s,l);}else{if(!this.oDocNSPrefixes){this.oDocNSPrefixes=this._getDocNSPrefixes();}var p=this.oDocNSPrefixes[s];N=(p?p+":":"")+l;return n.getAttribute(N);}};e.prototype._getChildElementsByTagName=function(n,N){var f=n.childNodes,r=[];if(this.oNameSpaces){var s=this._getNameSpace(N),l=this._getLocalName(N),g;q.each(f,function(i,o){g=o.localName||o.baseName;if(o.nodeType==1&&g==l&&o.namespaceURI==s){r.push(o);}});}else{q.each(f,function(i,o){if(o.nodeType==1&&o.nodeName==N){r.push(o);}});}return r;};e.prototype._getNameSpace=function(n){var i=n.indexOf(":"),p="";if(i>0){p=n.substr(0,i);}return this.oNameSpaces[p];};e.prototype._getLocalName=function(n){var i=n.indexOf(":"),l=n;if(i>0){l=n.substr(i+1);}return l;};e.prototype._getDocNSPrefixes=function(){var p={},D=this.oData&&this.oData.documentElement;if(!D){return p;}var A=D.attributes;q.each(A,function(i,o){var n=o.name,v=o.value;if(n=="xmlns"){p[v]="";}else if(n.indexOf("xmlns")==0){p[v]=n.substr(6);}});return p;};e.prototype._resolve=function(p,o){var i=!p.startsWith("/"),r=p;if(i){if(o){r=o.getPath()+"/"+p;}else{r=this.isLegacySyntax()?"/"+p:undefined;}}return r;};e.prototype.isList=function(p,o){return false;};e.prototype._setMetaModel=function(m){this._oMetaModel=m;};e.prototype.getMetaModel=function(){return this._oMetaModel;};return e;});
