/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/rta/command/Stack','sap/ui/rta/command/FlexCommand','sap/ui/rta/command/BaseCommand','sap/ui/rta/command/AppDescriptorCommand','sap/ui/fl/FlexControllerFactory','sap/ui/fl/Utils','sap/ui/fl/Change','sap/ui/rta/ControlTreeModifier','sap/ui/fl/registry/Settings',"sap/base/Log"],function(M,C,F,B,A,a,b,c,R,S,L){"use strict";var d=M.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"commandStack":{type:"object"}},aggregations:{}}});d.prototype._lastPromise=Promise.resolve();d.prototype.setCommandStack=function(o){if(this.getCommandStack()){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);}this.setProperty("commandStack",o);o.addCommandExecutionHandler(this._fnHandleCommandExecuted);};d.prototype.init=function(){this._fnHandleCommandExecuted=this.handleCommandExecuted.bind(this);};d.prototype.exit=function(){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);};d.prototype._isPersistedChange=function(p){return!!this.getCommandStack()._aPersistedChanges&&this.getCommandStack()._aPersistedChanges.indexOf(p.getId())!==-1;};d.prototype.handleCommandExecuted=function(e){return(function(e){var p=e;this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var f=this.getCommandStack().getSubCommands(p.command);var o;if(p.undo){f.forEach(function(g){if(!(g instanceof F||g instanceof A)||g.getRuntimeOnly()){return;}var h=g.getPreparedChange();var i=g.getAppComponent();if(i){if(g instanceof F){o=a.createForControl(i);var j=R.bySelector(h.getSelector(),i);o.removeFromAppliedChangesOnControl(h,i,j);}else if(g instanceof A){o=this._getAppDescriptorFlexController(i);}o.deleteChange(h,i);}}.bind(this));}else{var D=[];f.forEach(function(g){if(g.getRuntimeOnly()){return;}if(g instanceof F){var h=g.getAppComponent();if(h){var o=a.createForControl(h);var P=g.getPreparedChange();if(P.getState()===c.states.DELETED){P.setState(c.states.NEW);}if(!this._isPersistedChange(P)){o.addPreparedChange(g.getPreparedChange(),h);}}}else if(g instanceof A){D.push(g.createAndStoreChange());}}.bind(this));return Promise.all(D);}}.bind(this));return this._lastPromise;}.bind(this))(e);};d.prototype.needsReload=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var e=this.getCommandStack().getAllExecutedCommands();return e.some(function(o){return!!o.needsReload;});}.bind(this));return this._lastPromise;};d.prototype.saveCommands=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var r=sap.ui.getCore().byId(this.getRootControl());if(!r){throw new Error("Can't save commands without root control instance!");}var f=a.createForControl(r);return f.saveAll();}.bind(this)).then(function(){var r=sap.ui.getCore().byId(this.getRootControl());var f=this._getAppDescriptorFlexController(r);return f.saveAll();}.bind(this)).then(function(){L.info("UI adaptation successfully transfered changes to layered repository");this.getCommandStack().removeAllCommands();}.bind(this));return this._lastPromise;};d.prototype._getAppDescriptorFlexController=function(o){var O=b.getAppComponentForControl(o,true);var s=b.getComponentClassName(O).replace(".Component","");var e=b.getAppVersionFromManifest(O.getManifest());return a.create(s,e);};d.prototype._moveChangeToAppVariant=function(r,f){return S.getInstance().then(function(s){var p={reference:r};var n=b.createNamespace(p,"changes");var e=this.getCommandStack().getAllExecutedCommands();e.forEach(function(o){if(o.getPreparedChange&&!o.getRuntimeOnly()){var v=o.getPreparedChange();if(!Array.isArray(v)){v=[v];}v.forEach(function(g){if(s.isAtoEnabled()){g.setRequest("ATO_NOTIFICATION");}g.setNamespace(n);g.setComponent(r);});}});return f.saveAll(true);}.bind(this));};d.prototype._triggerUndoChanges=function(){var o=this.getCommandStack();var p=[];var e=o.getAllExecutedCommands();e.forEach(function(f){p.push(f.undo.bind(f));});p=p.reverse();return b.execPromiseQueueSequentially(p,false,true);};d.prototype._removeCommands=function(f){var o=this.getCommandStack();var e=o.getAllExecutedCommands();e.forEach(function(g){if(g instanceof F){var h=g.getPreparedChange();var i=g.getAppComponent();var j=R.bySelector(h.getSelector(),i);f.removeFromAppliedChangesOnControl(h,i,j);}});o.removeAllCommands();};d.prototype.saveAsCommands=function(r){if(!r){throw new Error("The id of the new app variant is required");}var o=sap.ui.getCore().byId(this.getRootControl());if(!o){throw new Error("Can't save commands without root control instance!");}var e=b.getAppDescriptor(o);if(e["sap.app"].id===r){throw new Error("The id of the app variant should be different from the current app id");}var f=a.createForControl(o);var g=this.getCommandStack();return this._moveChangeToAppVariant(r,f).then(function(){g.detachCommandExecuted(this.handleCommandExecuted.bind(this));return this._triggerUndoChanges();}.bind(this)).then(function(){this._removeCommands(f);g.attachCommandExecuted(this.handleCommandExecuted.bind(this));return true;}.bind(this));};return d;},true);
