/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthsRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(C,L,I,a,c,l,D,d,e,M,f,q){"use strict";var g=d.CalendarType;var h=C.extend("sap.ui.unified.calendar.MonthsRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});h.prototype.init=function(){this._oFormatYyyymm=D.getInstance({pattern:"yyyyMMdd",calendarType:g.Gregorian});this._oFormatLong=D.getInstance({pattern:"MMMM y"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonths){clearTimeout(this._sInvalidateMonths);}};h.prototype.onAfterRendering=function(){_.call(this);x.call(this);};h.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!f(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){A.call(this,true);t.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;w.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this);}}};h.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateMonths){if(this._bInvalidateSync){y.call(this);}else{this._sInvalidateMonths=setTimeout(y.bind(this),0);}}};h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("selectedDates");return b;};h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("specialDates");return b;};h.prototype.setDate=function(b){o.call(this,c.fromLocalJSDate(b),false);return this;};h.prototype._setDate=function(b){var i=b.toLocalJSDate();this.setProperty("date",i,true);this._oDate=b;};h.prototype._getDate=function(){if(!this._oDate){this._oDate=new c();}return this._oDate;};h.prototype.setStartDate=function(S){a._checkJSDateObject(S);var b,Y,O;Y=S.getFullYear();a._checkYearInValidRange(Y);b=c.fromLocalJSDate(S);this.setProperty("startDate",S,true);this._oStartDate=b;this._oStartDate.setDate(1);if(this.getDomRef()){O=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.setDate(O);}}return this;};h.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=new c();this._oStartDate.setDate(1);}return this._oStartDate;};h.prototype.displayDate=function(b){o.call(this,c.fromLocalJSDate(b),true);return this;};h.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};h.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var b=this._getLocale();var i=new e(b);this._oLocaleData=L.getInstance(i);}return this._oLocaleData;};h.prototype._getFormatLong=function(){var b=this._getLocale();if(this._oFormatLong.oLocale.toString()!=b){var i=new e(b);this._oFormatLong=D.getInstance({style:"long"},i);}return this._oFormatLong;};h.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};h.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};h.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};h.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};h.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};h.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};h.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};h.prototype._checkDateSelected=function(b){var R,S,E,T,B=0,F=0,G=0,i,H,J;a._checkCalendarDate(b);H=this.getSelectedDates();J=new c(b);J.setDate(1);T=J.toUTCJSDate().getTime();for(i=0;i<H.length;i++){R=H[i];S=R.getStartDate();B=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);B=S.toUTCJSDate().getTime();}E=R.getEndDate();F=0;if(E){E=c.fromLocalJSDate(E);E.setDate(1);F=E.toUTCJSDate().getTime();}if(T==B&&!E){G=1;break;}else if(T==B&&E){G=2;if(E&&T==F){G=5;}break;}else if(E&&T==F){G=3;break;}else if(E&&T>B&&T<F){G=4;break;}if(this.getSingleSelection()){break;}}return G;};h.prototype._getDateType=function(b){a._checkCalendarDate(b);var T,R,i,S,B=0,E,F=0,G,H=this.getSpecialDates(),J=new c(b);J.setDate(1);G=J.toUTCJSDate().getTime();for(i=0;i<H.length;i++){R=H[i];S=R.getStartDate();B=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);B=S.toUTCJSDate().getTime();}E=R.getEndDate();F=0;if(E){E=c.fromLocalJSDate(E);E.setDate(a._daysInMonth(E));F=E.toUTCJSDate().getTime();}if((G==B&&!E)||(G>=B&&G<=F)){T={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return T;};h.prototype._checkMonthEnabled=function(b){a._checkCalendarDate(b);var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(a._isOutside(b,P._oMinDate,P._oMaxDate)){return false;}}return true;};h.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){A.call(this,true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){var O=this._getDate();var F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);if(!F.isSame(O)){this._setDate(F);t.call(this,F,true);this._bMoveChange=true;}}};h.prototype.onmouseup=function(E){if(this._bMouseMove){A.call(this,true);var F=this._getDate();var b=this._oItemNavigation.getItemDomRefs();for(var i=0;i<b.length;i++){var $=q(b[i]);if($.attr("data-sap-month")==this._oFormatYyyymm.format(F.toUTCJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);}t.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;w.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;w.call(this);}};h.prototype.onsapselect=function(E){var S=t.call(this,this._getDate());if(S){w.call(this);}E.stopPropagation();E.preventDefault();};h.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};h.prototype.onsappageupmodifiers=function(E){var F=new c(this._getDate());var Y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(Y-10);}else{var i=this.getMonths();if(i<=12){F.setYear(Y-1);}else{F.setMonth(F.getMonth()-i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};h.prototype.onsappagedownmodifiers=function(E){var F=new c(this._getDate());var Y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(Y+10);}else{var i=this.getMonths();if(i<=12){F.setYear(Y+1);}else{F.setMonth(F.getMonth()+i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};h.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var b=this._getLocaleData();var B=b.getMonthsStandAlone("wide");var E=this.$("months").children();var F=this._getStartDate().getMonth();for(var i=0;i<E.length;i++){var $=q(q(E[i]).children(".sapUiCalItemText"));$.text(B[(i+F)%12]);}x.call(this);};h.prototype.checkDateFocusable=function(b){a._checkJSDateObject(b);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new c(S);E.setDate(1);E.setMonth(E.getMonth()+this.getMonths());var i=c.fromLocalJSDate(b);return i.isSameOrAfter(S)&&i.isBefore(E);};h.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};function _(){var b=this._getDate();var Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var B=0;var R=this.$("months").get(0);var E=this.$("months").children(".sapUiCalItem");for(var i=0;i<E.length;i++){var $=q(E[i]);if($.attr("data-sap-month")===Y){B=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,j,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,k,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,m,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(E);this._oItemNavigation.setFocusedIndex(B);this._oItemNavigation.setPageSize(E.length);}function j(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}var O=this._getDate();var F=new c(O);var B=this._oItemNavigation.getItemDomRefs();var $=q(B[i]);F=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));F.setDate(1);this._setDate(F);this.fireFocus({date:F.toLocalJSDate(),notVisible:false});if(E.type=="mousedown"){n.call(this,E,F,i);}}function k(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();n.call(this,E,F,i);}}function m(b){var E=b.getParameter("event");var i=this.getMonths();var O=this._getDate();var F=new c(O);if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setMonth(F.getMonth()+1);break;case"sapprevious":case"sappreviousmodifiers":F.setMonth(F.getMonth()-1);break;case"sappagedown":F.setMonth(F.getMonth()+i);break;case"sappageup":F.setMonth(F.getMonth()-i);break;default:break;}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});}}function n(E,F,i){if(E.button){return;}var S=t.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){A.call(this,true);this._bMoveChange=false;}else if(S&&this.getIntervalSelection()&&this.$().is(":visible")){z.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}function o(b,N){a._checkCalendarDate(b);var Y=b.getYear();a._checkYearInValidRange(Y);var F=true;if(!this.getDate()||!b.isSame(c.fromLocalJSDate(this.getDate()))){var i=new c(b);i.setDate(1);F=this.checkDateFocusable(b.toLocalJSDate());if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",b.toLocalJSDate(),true);this._oDate=i;}if(this.getDomRef()){if(F){p.call(this,this._oDate,N);}else{r.call(this,N);}}}function p(b,N){var Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var B=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<B.length;i++){$=q(B[i]);if($.attr("data-sap-month")==Y){if(document.activeElement!=B[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}function r(N){var b=this._getStartDate();var $=this.$("months");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderMonths(R,this,b);R.flush($[0]);R.destroy();}s.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}function s(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var b=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,b,S);R.flush($[0]);R.destroy();}}}function t(b,B){if(!this._checkMonthEnabled(b)){return false;}var S=this.getSelectedDates();var E;var F=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var G=this;var H;if(P&&P.getSelectedDates){G=P;}if(this.getSingleSelection()){if(S.length>0){E=S[0];H=E.getStartDate();if(H){H=c.fromLocalJSDate(H);H.setDate(1);}}else{E=new sap.ui.unified.DateRange();G.addAggregation("selectedDates",E,true);}if(this.getIntervalSelection()&&(!E.getEndDate()||B)&&H){var J;if(b.isBefore(H)){J=H;H=b;if(!B){E.setProperty("startDate",H.toLocalJSDate(),true);E.setProperty("endDate",J.toLocalJSDate(),true);}}else if(b.isSameOrAfter(H)){J=b;if(!B){E.setProperty("endDate",J.toLocalJSDate(),true);}}u.call(this,H,J);}else{u.call(this,b);E.setProperty("startDate",b.toLocalJSDate(),true);E.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var K=this._checkDateSelected(b);if(K>0){for(i=0;i<S.length;i++){H=S[i].getStartDate();if(H){H=c.fromLocalJSDate(H);H.setDate(1);if(b.isSame(H)){G.removeAggregation("selectedDates",i,true);break;}}}}else{E=new sap.ui.unified.DateRange({startDate:b.toLocalJSDate()});G.addAggregation("selectedDates",E,true);}Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);for(i=0;i<F.length;i++){$=q(F[i]);if($.attr("data-sap-month")==Y){if(K>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}function u(S,E){var b=this._oItemNavigation.getItemDomRefs();var $;var i=0;var B=false;var F=false;if(!E){var Y=this._oFormatYyyymm.format(S.toUTCJSDate(),true);for(i=0;i<b.length;i++){$=q(b[i]);B=false;F=false;if($.attr("data-sap-month")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");B=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}v.call(this,$,B,F);}}else{var G;for(i=0;i<b.length;i++){$=q(b[i]);B=false;F=false;G=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));G.setDate(1);if(G.isSame(S)){$.addClass("sapUiCalItemSelStart");B=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&G.isSame(E)){$.addClass("sapUiCalItemSelEnd");F=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(G,S,E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&G.isSame(E)){$.addClass("sapUiCalItemSelEnd");F=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}v.call(this,$,B,F);}}}function v($,S,E){if(!this.getIntervalSelection()){return;}var b="";var B=[];var F=this.getId();var G=false;b=$.attr("aria-describedby");if(b){B=b.split(" ");}var H=-1;var J=-1;for(var i=0;i<B.length;i++){var K=B[i];if(K==(F+"-Start")){H=i;}if(K==(F+"-End")){J=i;}}if(H>=0&&!S){B.splice(H,1);G=true;if(J>H){J--;}}if(J>=0&&!E){B.splice(J,1);G=true;}if(H<0&&S){B.push(F+"-Start");G=true;}if(J<0&&E){B.push(F+"-End");G=true;}if(G){b=B.join(" ");$.attr("aria-describedby",b);}}function w(){if(this._bMouseMove){A.call(this,true);}this.fireSelect();}function x(){if(!this._bNamesLengthChecked){var i=0;var B=this.$("months").children();var T=false;var E=this.getMonths();var F=Math.ceil(12/E);var G=0;var H=this._getLocaleData();var J=H.getMonthsStandAlone("wide");var $;for(var b=0;b<F;b++){if(E<12){for(i=0;i<B.length;i++){$=q(q(B[i]).children(".sapUiCalItemText"));$.text(J[(i+G)%12]);}G=G+E;if(G>11){G=11;}}for(i=0;i<B.length;i++){var K=B[i];if(Math.abs(K.clientWidth-K.scrollWidth)>1){T=true;break;}}if(T){break;}}if(E<12){G=this._getStartDate().getMonth();for(i=0;i<B.length;i++){$=q(q(B[i]).children(".sapUiCalItemText"));$.text(J[(i+G)%12]);}}if(T){this._bLongMonth=false;var N=H.getMonthsStandAlone("abbreviated");G=this._getStartDate().getMonth();for(i=0;i<B.length;i++){$=q(q(B[i]).children(".sapUiCalItemText"));$.text(N[(i+G)%12]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}function y(){this._sInvalidateMonths=undefined;r.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}function z(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}function A(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}return h;});
