/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/IconPool","./AvatarRenderer","sap/ui/events/KeyCodes","sap/base/Log"],function(l,C,I,A,K,L){"use strict";var a=l.AvatarType;var b=l.AvatarImageFitType;var c=l.AvatarSize;var d=l.AvatarShape;var e=C.extend("sap.f.Avatar",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.f.AvatarShape",group:"Appearance",defaultValue:d.Circle},displaySize:{type:"sap.f.AvatarSize",group:"Appearance",defaultValue:c.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.f.AvatarImageFitType",group:"Appearance",defaultValue:b.Cover}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},designtime:"sap/f/designtime/Avatar.designtime"}});e.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";e.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";e.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;};e.prototype.exit=function(){if(this._icon){this._icon.destroy();}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}};e.prototype.setDetailBox=function(o){var f=this.getDetailBox();if(o){if(o===f){return this;}if(f){this.detachPress(this._fnLightBoxOpen,f);}this._fnLightBoxOpen=o.open;this.attachPress(this._fnLightBoxOpen,o);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,f);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",o);};e.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments),f=o.getDetailBox();if(f){o.detachPress(this._fnLightBoxOpen,this.getDetailBox());o._fnLightBoxOpen=f.open;o.attachPress(o._fnLightBoxOpen,f);}return o;};e.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};e.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");this.$().attr("role","img");}return this;};e.prototype.ontap=function(){this.firePress({});};e.prototype.onkeyup=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this.firePress({});E.stopPropagation();}};e.prototype._areInitialsValid=function(i){var v=/^[a-zA-Z]{1,2}$/;if(!v.test(i)){L.warning("Initials should consist of only 1 or 2 latin letters",this);this._sActualType=a.Icon;this._bIsDefaultIcon=true;return false;}return true;};e.prototype._validateSrc=function(s){if(I.isIconURI(s)){this._sActualType=a.Icon;this._bIsDefaultIcon=false;}else{this._sActualType=a.Image;}return this;};e.prototype._getActualDisplayType=function(){var s=this.getSrc(),i=this.getInitials();if(s){this._validateSrc(s);}else if(i&&this._areInitialsValid(i)){this._sActualType=a.Initials;}else{L.warning("No src and initials were provided",this);this._sActualType=a.Icon;this._bIsDefaultIcon=true;}return this._sActualType;};e.prototype._getDefaultIconPath=function(D){var s=null;if(D===d.Circle){s=e.DEFAULT_CIRCLE_PLACEHOLDER;}else if(D===d.Square){s=e.DEFAULT_SQUARE_PLACEHOLDER;}return s;};e.prototype._getIcon=function(){var s=this.getSrc(),D=this.getDisplayShape();if(this._bIsDefaultIcon){s=this._getDefaultIconPath(D);}if(!this._icon){this._icon=I.createControlByURI({alt:"Image placeholder",src:s});}else if(this._icon.getSrc()!==s){this._icon.setSrc(s);}return this._icon;};e.prototype._getEscapedSrc=function(){var s=this.getSrc();if(!s){return'';}return s.replace(/'/g,"\\'");};e.prototype._getDefaultTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("AVATAR_TOOLTIP");};return e;});
