/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/f/library","sap/base/security/encodeXML","sap/ui/core/IconPool"],function(l,e,I){"use strict";var s={"1x1":{icon:true},"2x1":{icon:false,title:true,subtitle:true},"4x1":{icon:true,title:true,subtitle:true,status:true},"2x2":{icon:true,title:true,subtitle:true,status:false},"*x*":{icon:true,title:true,subtitle:true,status:true,content:true}};var C={};C.render=function(r,c){var S=C.getSizeSettings(c),R=c.getRaster(),h=c.getHorizontalSize(),v=c.getVerticalSize();r.write("<section");r.writeElementData(c);r.writeAttributeEscaped("aria-label",c.getTitle()+"-"+c.getSubtitle());r.writeAttribute("tabindex","0");r.addClass("sapFCard");r.addClass("sapFCard"+h+"x"+v);if(c.getBusy()){r.addClass("sapFCardLoading");}if(!S.content){r.addClass("sapFCardNoContent");}r.writeClasses();if(R==="CSSGrid"){r.addStyle("grid-column","span "+h);r.addStyle("grid-row","span "+v);}else{r.addStyle("min-width","calc("+h+" * "+R.minWidth+")");r.addStyle("min-height","calc("+v+" * "+R.minHeight+")");r.addStyle("max-width","calc("+h+" * "+R.maxWidth+")");r.addStyle("max-height","calc("+v+" * "+R.maxHeight+")");}var a=c.getColor(),b=c.getBackgroundColor(),B=c.getBackgroundImage(),d=c.getBackgroundImageSize();if(a){r.addStyle("color",a);r.addStyle("border-color",a+" !important");}if(b){r.addStyle("background-color",b);}if(B){r.addStyle("background-image","url('"+B+"')");if(d){r.addStyle("background-size",d);}}r.writeStyles();r.write(">");C.renderHeaderSection(r,c,S);if(S.content){r.write("<div class=\"sapFCardSeparator\" />");C.renderContentSection(r,c);}r.write("</section>");};C.renderHeaderSection=function(r,c,S){r.write("<header");r.addClass("sapFCardHeader");r.writeClasses();r.writeStyles();r.write(">");if(S.icon&&c.getIcon()){C.renderHeaderIcon(r,c);}if(S.title){r.write("<div>");var t=c.getTitle();r.write("<h1");r.addClass("sapFCardTitle");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</h1>");if(S.subtitle){var a=c.getSubtitle();r.write("<h2");r.addClass("sapFCardSubtitle");r.writeClasses();r.write(">");r.writeEscaped(a);r.write("</h2>");}r.write("</div>");}if(S.status&&c.getStatus()){var b=c.getStatus();if(b){r.write("<span");r.addClass("sapFCardStatus");r.writeClasses();r.write(">");r.writeEscaped(b);r.write("</span>");}}r.write("</header>");};C.renderHeaderIcon=function(r,c){var i=c.getIcon(),v=I.getIconInfo(c.getIcon(),undefined,"mixed"),b=false,a=c.getIconColor()||c.getColor(),d=c.getIconBackgroundColor();if(v instanceof Promise){v.then(c.invalidate.bind(c));}else if(v){b=true;}if(a){r.addStyle("color",a);}if(d){r.addStyle("background-color",d);}r.write("<span");r.addClass("sapFCardIcon");if(!i.startsWith("sap-icon://")){r.addStyle("background-image","url('"+e(i)+"')");}else if(b){r.writeAttributeEscaped("data-sap-ui-icon-content",v.content);r.addStyle("font-family","'"+e(v.fontFamily)+"'");r.addClass("sapUiIcon");}r.writeClasses();r.writeStyles();r.write(">");r.write("</span>");};C.renderContentSection=function(r,c){r.write("<section");r.addClass("sapFCardContent");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_content"));r.write("</section>");};C.getSizeSettings=function(c){var v=c.getVerticalSize(),h=c.getHorizontalSize(),S=s[h+"x"+v]||s["*x*"];S.vertical=v;S.horizontal=h;return S;};return C;},true);
