/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./ComboBoxTextField','./ComboBoxBase','./Popover','./SelectList','./library','sap/ui/Device','sap/ui/core/Item','./ComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/security/encodeXML"],function(I,C,a,P,S,l,D,b,c,d,K,e){"use strict";var f=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ComboBox.designtime",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});function h(o,i){if(!i){return;}var j=o.getFocusDomRef(),k=j.selectionStart,m=j.selectionEnd,n=k!==m,t=j.value.substring(0,j.selectionStart),p=this.getSelectedItem();this.setSelection(i);if(i!==p){o.updateDomValue(i.getText());this.fireSelectionChange({selectedItem:i});i=this.getSelectedItem();if(!((typeof t=="string"&&t!=""?i.getText().toLowerCase().startsWith(t.toLowerCase()):false))||!n){k=0;}o.selectText(k,j.value.length);}if(this.isOpen()){this.$().removeClass("sapMFocus");this.getList().addStyleClass("sapMSelectListFocus");}else{this.$().addClass("sapMFocus");}this.scrollToItem(i);}function s(i,E){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,E);}}function g(i){var o=this.getSelectedItem(),j=o&&o.getDomRef(),k=o&&j.offsetTop,m=o&&j.offsetHeight,p=this.getPicker(),n=p.getDomRef("cont"),q=n.clientHeight;if(o&&((k+m)>(q))){if(!i){this.getList().$().css("visibility","hidden");}else{n.scrollTop=k-m/2;this.getList().$().css("visibility","visible");}}}f.prototype._handleAriaActiveDescendant=function(i){var o=this.getFocusDomRef(),A="aria-activedescendant";if(o){if(i&&i.getDomRef()&&this.isOpen()){o.setAttribute(A,i.getId());}else{o.removeAttribute(A);}}};f.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};f.getMetadata().forwardAggregation("items",{getter:f.prototype.getList,aggregation:"items"});f.prototype._setItemVisibility=function(i,v){var o=i&&i.$(),j="sapMSelectListItemBaseInvisible";if(v){i.bVisible=true;o.length&&o.removeClass(j);}else{i.bVisible=false;o.length&&o.addClass(j);}};f.prototype._highlightList=function(v){var i=this.getVisibleItems();var L=[];var j=[];var o,k;i.forEach(function(m){var n=m.getDomRef();if(n===null){return;}o=n.children[1];k=Array.prototype.filter.call(n.children,function(p){return p.tagName.toLowerCase()!=="b";})[0]||n;if(o&&m.getAdditionalText){j.push({ref:o,text:m.getAdditionalText()});}k&&L.push({ref:k,text:m.getText()});});this.highLightList(v,L);this.highLightList(v,j);};f.prototype.setSelectedIndex=function(i,_){var o;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);o=_[i];if(o){this.setSelection(o);}};f.prototype.createDropdown=function(){var t=this;var o=new P(this.getDropdownSettings());o.setInitialFocus(this);o.open=function(){return this.openBy(t);};return o;};f.prototype.createPickerTextField=function(){var t=new C({width:"100%",showValueStateMessage:false,showButton:false}).addEventDelegate({onsapenter:function(){this.updateDomValue(t.getValue());this.onChange();}},this);return t;};f.prototype.revertSelection=function(){var p,o=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){p=this._sValueBeforeOpen;}else{p=this._oSelectedItemBeforeOpen.getText();}o&&o.setValue(p);};f.prototype.filterItems=function(o){var i=this.getItems(),F=[],j=[],k=o.properties.indexOf("additionalText")>-1,m=this.fnFilter||a.DEFAULT_TEXT_FILTER;this._oFirstItemTextMatched=null;i.forEach(function(n){var M=m.call(this,o.value,n,"getText");var p=m.call(this,o.value,n,"getAdditionalText");if(M){j.push(n);F.push(n);}else if(p&&k){F.push(n);}});i.forEach(function(n){var p=F.indexOf(n)>-1;var q=j.indexOf(n)>-1;if(!this._oFirstItemTextMatched&&q){this._oFirstItemTextMatched=n;}this._setItemVisibility(n,p);},this);return F;};f.prototype._filterStartsWithItems=function(i,m){var L=i.toLowerCase();var j=this.getItems(),F=j.filter(function(o){return o[m]&&o[m]().toLowerCase().startsWith(L);});return F;};f.prototype._getFilters=function(){return this.getFilterSecondaryValues()?["text","additionalText"]:["text"];};f.prototype.init=function(){a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this.bIsFocused=false;if(D.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}};f.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this.synchronizeSelection();};f.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;};f.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this);};f.prototype.onBeforeRenderingDropdown=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(l.BaseFontSize))+"rem";if(p){p.setContentMinWidth(w);}};f.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var L=this.getList(),F=this.getFocusDomRef();if(L){L.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};f.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this);g.call(this,false);};f.prototype.onAfterRenderingList=function(){if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var L=this.getList(),F=this.getFocusDomRef();this._highlightList(this._sInputValueBeforeOpen);if(L){L.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};f.prototype.oninput=function(E){a.prototype.oninput.apply(this,arguments);if(E.isMarked("invalid")){return;}this.$().addClass("sapMFocus");this.loadItems(function(){this.handleInputValidation(E,this.isComposingCharacter());},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&(this.getPickerType()==="Dropdown")){this.open();}this.$().addClass("sapMFocus");this.getList().removeStyleClass("sapMSelectListFocus");};f.prototype.handleInputValidation=function(E,i){var o=this.getSelectedItem(),v=E.target.value,j=v==="",k=E.srcControl,V,t=(this.getPickerType()==="Dropdown");if(j&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){V=this.getItems();}else{V=this.filterItems({properties:this._getFilters(),value:v});}var m=!!V.length;var F=V[0];if(!j&&F&&F.getEnabled()){this.handleTypeAhead(k,V,v,i);}if(j||!m||(!k._bDoTypeAhead&&(this._getSelectedItemText()!==v))){this.setSelection(null);if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}}this._sInputValueBeforeOpen=v;if(this.isOpen()){this._highlightList(v);}if(m){if(j&&!this.bOpenedByKeyboardOrButton){this.close();}else if(t){this.open();this.scrollToItem(this.getSelectedItem());}}else if(this.isOpen()){if(t&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}};f.prototype.handleTypeAhead=function(i,j,v,k){var m=this.intersectItems(this._filterStartsWithItems(v,'getText'),j);var n=this.getFilterSecondaryValues();var o=D.system.desktop;var p=this.getSelectedItem();if(i._bDoTypeAhead){var q=this.intersectItems(this._filterStartsWithItems(v,'getAdditionalText'),j);if(n&&!m[0]&&q[0]){!k&&i.updateDomValue(q[0].getAdditionalText());this.setSelection(q[0]);}else if(m[0]){!k&&i.updateDomValue(m[0].getText());this.setSelection(m[0]);}}else{this.setSelection(m[0]);}if(p!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}if(i._bDoTypeAhead){if(o){s.call(i,v.length,i.getValue().length);}else{setTimeout(s.bind(i,v.length,i.getValue().length),0);}}this.$().addClass("sapMFocus");this.getList().removeStyleClass("sapMSelectListFocus");};f.prototype.onSelectionChange=function(o){var i=o.getParameter("selectedItem"),p=this.getChangeEventParams(),j=(i!==this.getSelectedItem());this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(j){p.itemPressed=true;this.onChange(null,p);}};f.prototype.onItemPress=function(o){var i=o.getParameter("item"),t=i.getText(),p=this.getChangeEventParams(),j=(i!==this.getSelectedItem());this.updateDomValue(t);if(!j){p.itemPressed=true;this.onChange(null,p);}this.setProperty("value",i.getText(),true);if(this.getPickerType()==="Dropdown"&&!this.isPlatformTablet()){this.selectText.bind(this,this.getValue().length,this.getValue().length);}this.close();};f.prototype.onBeforeOpen=function(){var p=this["onBeforeOpen"+this.getPickerType()],o=this.getFocusDomRef();if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);if(o){o.setAttribute("aria-owns",this.getList().getId());}this.addContent();p&&p.call(this);};f.prototype.onBeforeOpenDialog=function(){var p=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({properties:this._getFilters(),value:""});}p.setValue(this._sValueBeforeOpen);};f.prototype.onAfterOpen=function(){var o=this.getFocusDomRef(),i=this.getSelectedItem();if(o){o.setAttribute("aria-expanded","true");i&&o.setAttribute("aria-activedescendant",i.getId());}g.call(this,true);};f.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var o=this.getFocusDomRef();if(o){o.removeAttribute("aria-owns");o.removeAttribute("aria-activedescendant");}this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);};f.prototype.onAfterClose=function(){var o=this.getFocusDomRef();if(o){o.setAttribute("aria-expanded","false");}this.clearFilter();this._sInputValueBeforeOpen="";if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===o)){this.openValueStateMessage();}};f.prototype.onItemChange=function(o){var i=this.getAssociation("selectedItem"),n=o.getParameter("newValue"),p=o.getParameter("name");if(i===o.getParameter("id")){switch(p){case"text":if(!this.isBound("value")){this.setValue(n);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(n);}break;}}};f.prototype.onkeydown=function(E){var o=E.srcControl;a.prototype.onkeydown.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}var k=K;o._bDoTypeAhead=(E.which!==k.BACKSPACE)&&(E.which!==k.DELETE);};f.prototype.oncut=function(E){var o=E.srcControl;a.prototype.oncut.apply(o,arguments);o._bDoTypeAhead=false;};f.prototype.onsapenter=function(E){var o=E.srcControl,i=o.getSelectedItem();if(i&&this.getFilterSecondaryValues()){o.updateDomValue(i.getText());}a.prototype.onsapenter.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}if(o.isOpen()&&!this.isComposingCharacter()){o.close();}};f.prototype.onsapdown=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function navigateToNextSelectableItem(){var i=this.getSelectableItems(),n;if(this.$().hasClass("sapMFocus")&&this.isOpen()){n=i[0];}else{n=i[i.indexOf(this.getSelectedItem())+1];}h.call(this,o,n);});};f.prototype.onsapup=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function navigateToPrevSelectableItem(){var i=this.getSelectableItems();var p=i[i.indexOf(this.getSelectedItem())-1];h.call(this,o,p);});};f.prototype.onsaphome=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function navigateToFirstSelectableItem(){var F=this.getSelectableItems()[0];h.call(this,o,F);});};f.prototype.onsapend=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function navigateToLastSelectableItem(){var L=this.findLastEnabledItem(this.getSelectableItems());h.call(this,o,L);});};f.prototype.onsappagedown=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function(){var i=this.getSelectableItems(),j=i.indexOf(this.getSelectedItem())+10,k;j=(j>i.length-1)?i.length-1:Math.max(0,j);k=i[j];h.call(this,o,k);});};f.prototype.onsappageup=function(E){var o=E.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}E.setMarked();E.preventDefault();this.loadItems(function(){var i=this.getSelectableItems(),j=i.indexOf(this.getSelectedItem())-10,k;j=(j>i.length-1)?i.length-1:Math.max(0,j);k=i[j];h.call(this,o,k);});};f.prototype.onsapshow=function(E){var i,o;a.prototype.onsapshow.apply(this,arguments);if(!this.getValue()){i=this.getSelectableItems();o=i[0];if(o){this.setSelection(o);this.updateDomValue(o.getText());this.fireSelectionChange({selectedItem:o});setTimeout(function(){this.selectText(0,o.getText().length);}.bind(this),0);}}};f.prototype.onsaphide=f.prototype.onsapshow;f.prototype.onfocusin=function(E){var i=this.getPickerType()==="Dropdown";if(this._bIsBeingDestroyed){return;}if(E.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(i&&!this.isPlatformTablet()){this.focus();}}else{if(i){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bIsFocused&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}this.bIsFocused=true;}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}if(!this.isOpen()||!this.getSelectedItem()||!this.getList().hasStyleClass("sapMSelectListFocus")){this.$().addClass("sapMFocus");}};f.prototype.onsapfocusleave=function(E){this.bIsFocused=false;var t,p,r,F,i=this.getSelectedItem();if(i&&this.getFilterSecondaryValues()){this.updateDomValue(i.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}p=this.getAggregation("picker");if(!E.relatedControlId||!p){return;}t=this.isPlatformTablet();r=sap.ui.getCore().byId(E.relatedControlId);F=r&&r.getFocusDomRef();if(d(p.getFocusDomRef(),F)&&!t){this.focus();}};f.prototype.setSelection=function(i){var L=this.getList(),k;if(L){L.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof b)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}k=i?i.getKey():"";this.setProperty("selectedKey",k,true);this._handleAriaActiveDescendant(i);};f.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};f.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText());this._sValue=this.getValue();}}};f.prototype.isFiltered=function(){var L=this.getList();return L&&(L.getVisibleItems().length!==L.getItems().length);};f.prototype.isItemVisible=function(i){return i&&(i.bVisible===undefined||i.bVisible);};f.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var i=this.getRenderer().CSS_CLASS_COMBOBOXBASE;o.setHorizontalScrolling(false).addStyleClass(i+"Picker").addStyleClass(i+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.createList());return o;};f.prototype.createList=function(){var r=this.getRenderer();this._oList=new S({width:"100%",busyIndicatorDelay:0}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List").addEventDelegate({onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this).attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);return this._oList;};f.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};f.prototype.getDefaultSelectedItem=function(){return null;};f.prototype.getChangeEventParams=function(){return{itemPressed:false};};f.prototype.clearSelection=function(){this.setSelection(null);};f.prototype.selectText=function(i,j){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=j;return this;};f.prototype.addAggregation=function(A,o,i){if(A==="items"&&!i&&!this.isInvalidateSuppressed()){this.invalidate(o);}return a.prototype.addAggregation.apply(this,arguments);};f.prototype.setAssociation=function(A,i,j){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.setAssociation.apply(L,arguments);}return a.prototype.setAssociation.apply(this,arguments);};f.prototype.setProperty=function(p,v,i){var L=this.getList();if(/selectedKey|selectedItemId/.test(p)){L&&S.prototype.setProperty.apply(L,arguments);}return a.prototype.setProperty.apply(this,arguments);};f.prototype.removeAllAssociation=function(A,i){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.removeAllAssociation.apply(L,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};f.prototype.clone=function(i){var o=a.prototype.clone.apply(this,arguments),L=this.getList();if(!this.isBound("items")&&L){o.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return o;};f.prototype.open=function(){var L=this.getList();a.prototype.open.call(this);if(this.getSelectedItem()){L.addStyleClass("sapMSelectListFocus");this.$().removeClass("sapMFocus");}return this;};f.prototype.close=function(){var L=this.getList();a.prototype.close.call(this);this.$().addClass("sapMFocus");L&&L.removeStyleClass("sapMSelectListFocus");return this;};f.prototype.findAggregatedObjects=function(){var L=this.getList();if(L){return S.prototype.findAggregatedObjects.apply(L,arguments);}return[];};f.prototype.setShowSecondaryValues=function(A){this.setProperty("showSecondaryValues",A,true);var L=this.getList();if(L){L.setShowSecondaryValues(A);}return this;};f.prototype.getItems=function(){var L=this.getList();return L?L.getItems():[];};f.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=sap.ui.getCore().byId(i);}if(!(i instanceof b)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};f.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};f.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var i=(k===""),j=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(i){this.setSelection(null);if(!j){this.setValue("");}return this;}var o=this.getItemByKey(k);if(o){this.setSelection(o);if(!j){this.setValue(this._getSelectedItemText(o));}return this;}this._sValue=this.getValue();return this.setProperty("selectedKey",k);};f.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:sap.ui.getCore().byId(v)||null;};f.prototype.updateItems=function(){var r,o=this.getSelectedItem(),r=a.prototype.updateItems.apply(this,arguments);clearTimeout(this._debounceItemsUpdate);this._debounceItemsUpdate=setTimeout(this["_syncItemsSelection"].bind(this,o),0);return r;};f.prototype._syncItemsSelection=function(o){var H,n,i=this.getSelectedKey();if(!o||o===this.getSelectedItem()){return;}n=this.getItems();H=n.some(function(j){return i===j.getKey();});this.setSelectedItem(H&&i?this.getItemByKey(i):null);};f.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var o;if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){o=this.getDefaultSelectedItem();this.setSelection(o);this.setValue(v);}return i;};return f;});
