/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','./DatePicker','./library','sap/ui/core/LocaleData','sap/ui/core/format/DateFormat','./DateRangeSelectionRenderer',"sap/base/util/deepEqual","sap/base/Log","sap/base/assert","sap/ui/dom/jquery/cursorPos"],function(D,a,l,L,b,c,d,e,f){"use strict";var g=a.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}},designtime:"sap/m/designtime/DateRangeSelection.designtime"}});g.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};g.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=n.call(this);var s=m.call(this);var A=F.sAllowedCharacters+s+" ";var C=String.fromCharCode(E.charCode);if(C&&F.sAllowedCharacters&&A.indexOf(C)<0){E.preventDefault();}};g.prototype._getPlaceholder=function(){var P=this.getPlaceholder(),B,i,r,s;if(!P){B=this.getBinding("value");r=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();s=L.getInstance(r);if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){i=B.getType();if(i.oFormatOptions&&i.oFormatOptions.format){P=s.getCustomDateTimePattern(i.oFormatOptions.format);}else{P=s.getDatePattern("medium");}}else{P=this.getDisplayFormat();if(!P){P="medium";}if(this._checkStyle(P)){P=s.getDatePattern(P);}}var t=m.call(this);if(t&&t!==""){P=P+" "+t+" "+P;}}return P;};g.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v);this._bValid=true;var i=[undefined,undefined];if(v){i=this._parseValue(v);if(!k.call(this,i[0],i[1])[0]){this._bValid=false;e.warning("Value can not be converted to a valid dates",this);}}this.setProperty("dateValue",_(i[0]));this.setProperty("secondDateValue",_(i[1]));if(this.getDomRef()){var O=this._formatValue(i[0],i[1]);if(this._$input.val()!==O){this._$input.val(O);this._curpos=this._$input.cursorPos();}}return this;};function _(B){return(typeof B==='number')?new Date(B):B;}function h(B){return(B&&B.getTime)?B.getTime():B;}g.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);e.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};g.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var O=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",O,true);if(this.getDomRef()&&(this._$input.val()!==O)){this._$input.val(O);this._curpos=this._$input.cursorPos();}return this;};g.prototype.setFrom=function(F){this.setDateValue(F);return this;};g.prototype.getFrom=function(){return this.getDateValue();};g.prototype.setTo=function(t){this.setSecondDateValue(t);return this;};g.prototype.getTo=function(){return this.getSecondDateValue();};g.prototype.setDateValue=function(i){if(this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getDateValue(),i)){return this;}a.prototype._dateValidation.call(this,i);this._syncDateObjectsToValue(i,this.getSecondDateValue());return this;};g.prototype.setSecondDateValue=function(s){if(this._isValidDate(s)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getSecondDateValue(),s)){return this;}this._bValid=true;if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;f(this._bValid,"Date must be in valid range");}this.setProperty("secondDateValue",s);this._syncDateObjectsToValue(this.getDateValue(),s);return this;};g.prototype.setMinDate=function(i){a.prototype.setMinDate.apply(this,arguments);if(i){var s=this.getSecondDateValue();if(s&&s.getTime()<this._oMinDate.getTime()){e.warning("SecondDateValue not in valid date range",this);}}return this;};g.prototype.setMaxDate=function(i){a.prototype.setMaxDate.apply(this,arguments);if(i){var s=this.getSecondDateValue();if(s&&s.getTime()>this._oMaxDate.getTime()){e.warning("SecondDateValue not in valid date range",this);}}return this;};g.prototype._checkMinMaxDate=function(){a.prototype._checkMinMaxDate.apply(this,arguments);var s=this.getSecondDateValue();if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){e.error("secondDateValue "+s.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain secondDateValue/value accordingly.",this);}};g.prototype._parseValue=function(v){var F;var i=[];var r,s;var B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){i=B.getType().parseValue(v,"string");if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){i=i.map(function(U){return new Date(U.getUTCFullYear(),U.getUTCMonth(),U.getUTCDate(),U.getUTCHours(),U.getUTCMinutes(),U.getUTCSeconds());});}return i;}var t=m.call(this);if(t&&v){v=v.trim();v=q(v,[t," "]);i=v.split(t);if(i.length===2){if(i[0].slice(i[0].length-1,i[0].length)==" "){i[0]=i[0].slice(0,i[0].length-1);}if(i[1].slice(0,1)==" "){i[1]=i[1].slice(1);}}else{i=v.split(" "+t+" ");}if(v.indexOf(t)===-1){var u=v.split(" ");if(u.length===2){i=u;}}}if(v&&i.length<=2){F=n.call(this);if((!t||t==="")||i.length===1){r=F.parse(v);}else if(i.length===2){r=F.parse(i[0]);s=F.parse(i[1]);if(!r||!s){r=undefined;s=undefined;}}}return[r,s];};g.prototype._formatValue=function(i,s){var v="",r=m.call(this),F,B,t,u;t=i;u=s;if(t){B=this.getBinding("value");if(B&&B.getType()instanceof sap.ui.model.type.DateInterval){if(B.getType().oFormatOptions&&B.getType().oFormatOptions.source&&B.getType().oFormatOptions.source.pattern==="timestamp"){v=B.getType().formatValue([h(i),h(s)],"string");}else{if(B.getType().oFormatOptions&&B.getType().oFormatOptions.UTC){t=new Date(Date.UTC(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours(),i.getMinutes(),i.getSeconds()));if(s){u=new Date(Date.UTC(s.getFullYear(),s.getMonth(),s.getDate(),s.getHours(),s.getMinutes(),s.getSeconds()));}}v=B.getType().formatValue([t,u],"string");}}else{F=n.call(this);if(r&&r!==""&&u){v=F.format(t)+" "+r+" "+F.format(u);}else{v=F.format(t);}}}return v;};g.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var i=[undefined,undefined];this._bValid=true;if(v!=""){i=this._parseValue(v);i[1]&&i[1].setHours(23,59,59,999);i=k.call(this,i[0],i[1]);if(i[0]){v=this._formatValue(i[0],i[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this._lastValue=v;this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",_(i[0]),true);this.setProperty("secondDateValue",_(i[1]),true);}if(this._oPopup&&this._oPopup.isOpen()){var s=this.getDateValue();if(s){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));this._oCalendar.focusDate(s);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));this._oCalendar.focusDate(E);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}j.call(this,this._bValid);}};g.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var i=this._parseValue(v);v=this._formatValue(i[0],i[1]);return v;};g.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var i=this._parseValue(v);v=this._formatValue(i[0],i[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}return this;};g.prototype.onsappageup=function(){};g.prototype.onsappageupmodifiers=function(){};g.prototype.onsappagedown=function(){};g.prototype.onsappagedownmodifiers=function(){};g.prototype._fillDateRange=function(){a.prototype._fillDateRange.apply(this,arguments);var E=this.getSecondDateValue();if(E&&E.getTime()>=this._oMinDate.getTime()&&E.getTime()<=this._oMaxDate.getTime()){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};g.prototype._selectDate=function(E){var s=this._oCalendar.getSelectedDates();if(s.length>0){var i=s[0].getStartDate();var r=s[0].getEndDate();if(i&&r){var t=this.getDateValue();var u=this.getSecondDateValue();r.setHours(23,59,59,999);var v;if(!d(i,t)||!d(r,u)){if(d(r,u)){this.setDateValue(i);}else{this.setProperty("dateValue",i,true);this.setSecondDateValue(r);}v=this.getValue();j.call(this,true);if(D.system.desktop||!D.support.touch){this._curpos=v.length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){v=this._formatValue(i,r);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);}j.call(this,true);}}this._oPopup.close();}}};g.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=a.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var s=this.getDateValue();if(s){v=this._formatValue(s,this.getSecondDateValue());}}i.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return i;};g.prototype._syncDateObjectsToValue=function(i,s){var v=this._formatValue(i,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v);if(this.getDomRef()){var O=this._formatValue(i,s);if(this._$input.val()!==O){this._$input.val(O);this._curpos=this._$input.cursorPos();}}};function j(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}function k(i,s){var F,S;if(i&&i.getTime){F=i.getTime();}else if(typeof i==='number'){F=i;}if(s&&s.getTime){S=s.getTime();}else if(typeof s==='number'){S=s;}if(i&&s&&F>S){var t=i;i=s;s=t;}if((i&&(F<this._oMinDate.getTime()||F>this._oMaxDate.getTime()))||(s&&(S<this._oMinDate.getTime()||S>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[i,s];}}function m(){var s=this.getDelimiter();if(!s){if(!this._sLocaleDelimiter){var i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var r=L.getInstance(i);var P=r.getIntervalPattern();var I=P.indexOf("{0}")+3;var t=P.indexOf("{1}");s=P.slice(I,t);if(s.length>1){if(s.slice(0,1)==" "){s=s.slice(1);}if(s.slice(s.length-1,s.length)==" "){s=s.slice(0,s.length-1);}}this._sLocaleDelimiter=s;}else{s=this._sLocaleDelimiter;}}return s;}function n(){var P=(this.getDisplayFormat()||"medium");var F;var C=this.getDisplayFormatType();if(P==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}else{if(this._checkStyle(P)){F=b.getInstance({style:P,strictParsing:true,calendarType:C});}else{F=b.getInstance({pattern:P,strictParsing:true,calendarType:C});}this._sUsedDisplayPattern=P;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=F;}return F;}function o(v,E){return v&&E&&v.lastIndexOf(E)===v.length-E.length;}function p(v,s){return v&&s&&v.indexOf(s)===0;}function q(v,P){var i=0,t=P;if(!t){t=[" "];}while(i<t.length){if(o(v,t[i])){v=v.substring(0,v.length-t[i].length);i=0;continue;}i++;}i=0;while(i<t.length){if(p(v,t[i])){v=v.substring(t[i].length);i=0;continue;}i++;}return v;}return g;});
