/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/core/EnabledPropagator','sap/ui/core/library','sap/ui/Device','./LinkRenderer',"sap/ui/events/KeyCodes","sap/base/Log","sap/base/security/URLWhitelist"],function(l,C,I,E,c,D,L,K,a,U){"use strict";var T=c.TextDirection;var b=c.TextAlign;var d=C.extend("sap.m.Link",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Link.designtime",properties:{text:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},target:{type:"string",group:"Behavior",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},validateUrl:{type:"boolean",group:"Data",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:b.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},subtle:{type:"boolean",group:"Behavior",defaultValue:false},emphasized:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true,parameters:{ctrlKey:{type:"boolean"},metaKey:{type:"boolean"}}}}}});E.call(d.prototype);d.prototype.onBeforeRendering=function(){};d.prototype.onsapspace=function(e){if(this.getEnabled()||this.getHref()){e.setMarked();e.preventDefault();}};d.prototype.onkeyup=function(e){if(e.which===K.SPACE){this._handlePress(e);if(this.getHref()&&!e.isDefaultPrevented()){e.preventDefault();e.setMarked();var o=document.createEvent('MouseEvents');o.initEvent('click',false,true);this.getDomRef().dispatchEvent(o);}}};d.prototype._handlePress=function(e){if(this.getEnabled()){e.setMarked();if(!this.firePress({ctrlKey:!!e.ctrlKey,metaKey:!!e.metaKey})||!this.getHref()){e.preventDefault();}}else{e.preventDefault();}};d.prototype.onsapenter=d.prototype._handlePress;if(D.support.touch){d.prototype.ontap=d.prototype._handlePress;}else{d.prototype.onclick=d.prototype._handlePress;}d.prototype.ontouchstart=function(e){if(this.getEnabled()){e.setMarked();}};d.prototype.setText=function(t){var $=this.$();this.setProperty("text",t,true);t=this.getProperty("text");if(this.writeText){this.writeText(t);}else{$.text(t);}if(t){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}return this;};d.prototype.setHref=function(u){var i=this._isHrefValid(u);this.setProperty("href",u,true);if(!i){this.$().removeAttr("href");a.warning(this+": The href tag of the link was not set since it's not valid.");return this;}if(this.getEnabled()){u=this.getProperty("href");if(!u){this.$().removeAttr("href");}else{this.$().attr("href",u);}}return this;};d.prototype.setSubtle=function(s){this.setProperty("subtle",s,true);var $=this.$();if($.length){$.toggleClass("sapMLnkSubtle",s);if(s){d._addToDescribedBy($,this._sAriaLinkSubtleId);}else{d._removeFromDescribedBy($,this._sAriaLinkSubtleId);}}if(s&&!d.prototype._sAriaLinkSubtleId){d.prototype._sAriaLinkSubtleId=I.getStaticId("sap.m","LINK_SUBTLE");}return this;};d.prototype.setEmphasized=function(e){this.setProperty("emphasized",e,true);var $=this.$();if($.length){$.toggleClass("sapMLnkEmphasized",e);if(e){d._addToDescribedBy($,this._sAriaLinkEmphasizedId);}else{d._removeFromDescribedBy($,this._sAriaLinkEmphasizedId);}}if(e&&!d.prototype._sAriaLinkEmphasizedId){d.prototype._sAriaLinkEmphasizedId=I.getStaticId("sap.m","LINK_EMPHASIZED");}return this;};d.prototype.setWrapping=function(w){this.setProperty("wrapping",w,true);this.$().toggleClass("sapMLnkWrapping",w);return this;};d.prototype.setEnabled=function(e){e=this.validateProperty("enabled",e);if(e!==this.getProperty("enabled")){this.setProperty("enabled",e,true);var $=this.$();$.toggleClass("sapMLnkDsbl",!e);if(e){$.attr("disabled",false);if(this.getText()){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}$.removeAttr("aria-disabled");if(this.getHref()){$.attr("href",this.getHref());}}else{$.attr("disabled",true);$.attr("aria-disabled",true);$.removeAttr("href");}}return this;};d.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().toggleClass("sapMLnkMaxWidth",!w);this.$().css("width",w);return this;};d.prototype.setTarget=function(t){this.setProperty("target",t,true);if(!t){this.$().removeAttr("target");}else{this.$().attr("target",t);}return this;};d.prototype._isHrefValid=function(u){return this.getValidateUrl()?U.validate(u):true;};d._addToDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A){$.attr("aria-describedby",A+" "+i);}else{$.attr("aria-describedby",i);}};d._removeFromDescribedBy=function($,i){var A=$.attr("aria-describedby");if(A&&A.indexOf(i)!==-1){A=A.replace(i,'');if(A.length>1){$.attr("aria-describedby",A);}else{$.removeAttr("aria-describedby");}}};d.prototype.getAccessibilityInfo=function(){return{role:"link",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LINK"),description:this.getText()||this.getHref()||"",focusable:this.getEnabled(),enabled:this.getEnabled()};};d.prototype.getFormDoNotAdjustWidth=function(){return true;};d.prototype._getTabindex=function(){return this.getText()?"0":"-1";};return d;});
