/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/m/semantic/SemanticPage','sap/ui/core/InvisibleText','sap/ui/Device','sap/ui/base/ManagedObject','sap/m/NavContainer','sap/m/Popover','./SplitContainerRenderer',"sap/ui/dom/containsOrEquals","sap/base/Log","sap/ui/thirdparty/jquery"],function(l,C,I,S,a,D,M,N,P,b,c,L,q){"use strict";var B=l.ButtonType;var d=l.PlacementType;var e=l.SplitAppMode;var f=C.extend("sap.m.SplitContainer",{metadata:{library:"sap.m",properties:{defaultTransitionNameDetail:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMaster:{type:"string",group:"Appearance",defaultValue:"slide"},mode:{type:"sap.m.SplitAppMode",group:"Appearance",defaultValue:e.ShowHideMode},masterButtonText:{type:"string",group:"Appearance",defaultValue:null},masterButtonTooltip:{type:"string",group:"Appearance",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1}},aggregations:{masterPages:{type:"sap.ui.core.Control",multiple:true,singularName:"masterPage"},detailPages:{type:"sap.ui.core.Control",multiple:true,singularName:"detailPage"},_navMaster:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_navDetail:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_navPopover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},associations:{initialDetail:{type:"sap.ui.core.Control",multiple:false},initialMaster:{type:"sap.ui.core.Control",multiple:false}},events:{masterNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMasterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},masterButton:{},beforeMasterOpen:{},afterMasterOpen:{},beforeMasterClose:{},afterMasterClose:{},detailNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterDetailNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}},designtime:"sap/m/designtime/SplitContainer.designtime"}});f.prototype.init=function(){var t=this;if(sap.ui.getCore().getConfiguration().getAccessibility()&&!f._sAriaPopupLabelId){f._sAriaPopupLabelId=new a({text:''}).toStatic().getId();}this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aMasterPages=[];this._aDetailPages=[];if(!D.system.phone){this._oMasterNav=new N(this.getId()+"-Master",{width:"",navigate:function(E){t._handleNavigationEvent(E,false,true);},afterNavigate:function(E){t._handleNavigationEvent(E,true,true);t._updateMasterButtonTooltip();}});this._oDetailNav=new N(this.getId()+"-Detail",{width:"",navigate:function(E){t._handleNavigationEvent(E,false,false);},afterNavigate:function(E){t._handleNavigationEvent(E,true,false);}});this.setAggregation("_navMaster",this._oMasterNav,true);this.setAggregation("_navDetail",this._oDetailNav,true);this._createShowMasterButton();this._oPopOver=new P(this.getId()+"-Popover",{placement:d.Bottom,showHeader:false,contentWidth:"320px",contentHeight:"600px",beforeOpen:function(){t.fireBeforeMasterOpen();},beforeClose:function(){t.fireBeforeMasterClose();},afterOpen:function(){t.fireAfterMasterOpen();t._bMasterisOpen=true;},afterClose:function(){t._afterHideMasterAnimation();}}).addStyleClass("sapMSplitContainerPopover");if(f._sAriaPopupLabelId){this._oPopOver.addAriaLabelledBy(f._sAriaPopupLabelId);}this.setAggregation("_navPopover",this._oPopOver,true);}else{this._oMasterNav=this._oDetailNav=new N({width:"",navigate:function(E){t._handleNavigationEvent(E,false,true);},afterNavigate:function(E){t._handleNavigationEvent(E,true,true);}});this.setAggregation("_navMaster",this._oMasterNav,true);}this._oldIsLandscape=D.orientation.landscape;this._bMasterisOpen=false;var t=this;var p=function(r,n,s){return function(o,A,h){r.apply(t[n],arguments);if(A==="pages"&&t[s]&&t[s].indexOf(o)!==-1){t._removePageFromArray(t[s],o);}};};var m=this._oMasterNav._removeChild;this._oMasterNav._removeChild=p(m,"_oMasterNav","_aMasterPages");if(this._oDetailNav){var g=this._oDetailNav._removeChild;this._oDetailNav._removeChild=p(g,"_oDetailNav","_aDetailPages");}};f.prototype.onBeforeRendering=function(){if(this._fnResize){D.resize.detachHandler(this._fnResize);}if(this._bMasterisOpen&&(this._portraitHide()||this._hideMode())){this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");this._bMasterisOpen=false;}this._updateMasterButtonTooltip();};f.prototype.exit=function(){if(this._fnResize){D.resize.detachHandler(this._fnResize);}delete this._aMasterPages;delete this._aDetailPages;if(this._oShowMasterBtn){this._oShowMasterBtn.destroy();this._oShowMasterBtn=null;}};f.prototype.onAfterRendering=function(){if(!D.system.phone&&this._oPopOver&&this._oPopOver.isOpen()){this._oPopOver.close();}if(!this._fnResize){this._fnResize=q.proxy(this._handleResize,this);}D.resize.attachHandler(this._fnResize);if(D.os.windows&&D.browser.internet_explorer){this._oMasterNav.$().append('<iframe class="sapMSplitContainerMasterBlindLayer" src="about:blank"></iframe>');}setTimeout(function(){this._oMasterNav.removeStyleClass("sapMSplitContainerNoTransition");}.bind(this),0);};f.prototype.applySettings=function(s,o){C.prototype.applySettings.call(this,s,o);this._updateMasterInitialPage();};f.prototype.ontouchstart=function(E){if(!D.system.phone){this._bIgnoreSwipe=(E.originalEvent&&E.originalEvent._sapui_handledByControl);}};f.prototype.onswiperight=function(E){if(D.support.touch===false){return;}if((D.system.tablet||(D.os.windows&&D.os.version>=8))&&(this._portraitHide()||this._hideMode())&&!this._bIgnoreSwipe&&!this._bDetailNavButton){this.showMaster();}};f.prototype.ontap=function(E){if(D.system.phone){return;}var i=true,$=q(E.target).closest(".sapMSplitContainerDetail, .sapMSplitContainerMaster"),m=E.srcControl.getMetadata();if($.length>0&&$.hasClass("sapMSplitContainerDetail")){i=false;}if(((!this._oldIsLandscape&&this.getMode()=="ShowHideMode")||this.getMode()=="HideMode")&&!i&&!c(this._oShowMasterBtn.getDomRef(),E.target)&&(!m.getEvent("tap")||!m.getEvent("press"))){this.hideMaster();}};f.prototype.onswipeleft=function(E){if((D.system.tablet||(D.os.windows&&D.os.version>=8))&&(this._portraitHide()||this._hideMode())&&!this._bIgnoreSwipe){this.hideMaster();}};f.prototype._onMasterButtonTap=function(E){if(D.system.phone){return;}if(!this._oldIsLandscape){if(this.getMode()=="PopoverMode"){if(!this._oPopOver.isOpen()){this._oPopOver.openBy(this._oShowMasterBtn,true);}else{this._oPopOver.close();}}else{this.showMaster();}}else{if(this.getMode()==="HideMode"){this.showMaster();}}};f.prototype.to=function(p,t,g,T){if(this._oMasterNav.getPage(p)){this._oMasterNav.to(p,t,g,T);}else{this._oDetailNav.to(p,t,g,T);}};f.prototype.backToPage=function(p,g,t){if(this._oMasterNav.getPage(p)){this._oMasterNav.backToPage(p,g,t);}else{this._oDetailNav.backToPage(p,g,t);}};f.prototype.insertPreviousPage=function(p,t,g){if(this._oMasterNav.getPage(p)){this._oMasterNav.insertPreviousPage(p,t,g);}else{this._oDetailNav.insertPreviousPage(p,t,g);}return this;};f.prototype.toMaster=function(p,t,g,T){this._oMasterNav.to(p,t,g,T);};f.prototype.backMaster=function(g,t){this._oMasterNav.back(g,t);};f.prototype.backMasterToPage=function(p,g,t){this._oMasterNav.backToPage(p,g,t);};f.prototype.toDetail=function(p,t,g,T){this._oDetailNav.to(p,t,g,T);};f.prototype.backDetail=function(g,t){this._oDetailNav.back(g,t);};f.prototype.backDetailToPage=function(p,g,t){this._oDetailNav.backToPage(p,g,t);};f.prototype.backToTopMaster=function(g,t){this._oMasterNav.backToTop(g,t);};f.prototype.backToTopDetail=function(g,t){this._oDetailNav.backToTop(g,t);};f.prototype.addMasterPage=function(p){if(this._hasPageInArray(this._aMasterPages,p)){return;}if(this._oMasterNav===this._oDetailNav&&this._oDetailNav.getPages()&&this._oDetailNav.getPages().indexOf(p)!==-1){this._removePageFromArray(this._aDetailPages,p);}this._oMasterNav.insertPage(p,this._aMasterPages.length);this._aMasterPages.push(p);return this;};f.prototype.addDetailPage=function(p){var t=this,r=this._getRealPage(p);if(this._hasPageInArray(this._aDetailPages,p)){return;}p.addDelegate({onBeforeShow:function(){if(r){if(!D.system.phone){if(t._needShowMasterButton()){t._setMasterButton(r);}}}}});if(r){r.addDelegate({onBeforeRendering:function(){if(!D.system.phone&&(t._oDetailNav.getCurrentPage()===r)){if(!r.getShowNavButton()&&t._needShowMasterButton()){t._setMasterButton(r,true);}else{t._removeMasterButton(r);}}}});if(!D.system.phone){if(!r._setCustomHeaderInSC){r._setCustomHeaderInSC=r.setCustomHeader;}r.setCustomHeader=function(h){this._setCustomHeaderInSC.apply(this,arguments);if(h&&t._needShowMasterButton()){t._setMasterButton(r);}return this;};if(!r._setShowNavButtonInSC){r._setShowNavButtonInSC=r.setShowNavButton;}r.setShowNavButton=function(s){this._setShowNavButtonInSC.apply(this,arguments);if(!s&&t._needShowMasterButton()){t._setMasterButton(r);}else{t._removeMasterButton(r,true);}return this;};}}if(this._oMasterNav===this._oDetailNav&&this._oMasterNav.getPages()&&this._oMasterNav.getPages().indexOf(p)!==-1){this._removePageFromArray(this._aMasterPages,p);}this._oDetailNav.addPage(p);this._aDetailPages.push(p);return this;};f.prototype.getMasterPages=function(){return this._aMasterPages;};f.prototype.getDetailPages=function(){return this._aDetailPages;};f.prototype.indexOfMasterPage=function(p){return this._indexOfMasterPage(p);};f.prototype.indexOfDetailPage=function(p){return this._indexOfDetailPage(p);};f.prototype.insertMasterPage=function(p,i,s){return this._insertPage(this._aMasterPages,"masterPages",p,i,s);};f.prototype.removeMasterPage=function(p,s){return this._removePage(this._aMasterPages,"masterPages",p,s);};f.prototype.removeAllMasterPages=function(s){this._aMasterPages=[];return this.removeAllAggregation("masterPages",s);};f.prototype.insertDetailPage=function(p,i,s){return this._insertPage(this._aDetailPages,"detailPages",p,i,s);};f.prototype._restoreMethodsInPage=function(p){if(D.system.phone){return;}var r=this._getRealPage(p);if(r){if(r._setCustomHeaderInSC){r.setCustomHeader=r._setCustomHeaderInSC;delete r._setCustomHeaderInSC;}if(r._setShowNavButtonInSC){r.setShowNavButton=r._setShowNavButtonInSC;delete r._setShowNavButtonInSC;}}};f.prototype.removeDetailPage=function(p,s){this._restoreMethodsInPage(p);return this._removePage(this._aDetailPages,"detailPages",p,s);};f.prototype.removeAllDetailPages=function(s){var p=this.getDetailPages();for(var i=0;i<p.length;i++){this._restoreMethodsInPage(p[i]);}this._aDetailPages=[];return this.removeAllAggregation("detailPages",s);};f.prototype.addPage=function(p,m){if(m){return this.addMasterPage(p);}else{return this.addDetailPage(p);}};f.prototype.showMaster=function(){var t=this,_=this._getRealPage(this._oDetailNav.getCurrentPage());function g(){this._oPopOver.detachAfterOpen(g,this);this._bMasterOpening=false;this._bMasterisOpen=true;this.fireAfterMasterOpen();}if(this._portraitPopover()){if(!this._oPopOver.isOpen()){this._oPopOver.attachAfterOpen(g,this);this.fireBeforeMasterOpen();this._oPopOver.openBy(this._oShowMasterBtn,true);this._bMasterOpening=true;}}else if((this._portraitHide()||this._hideMode())&&(!this._bMasterisOpen||this._bMasterClosing)){this._oMasterNav.$().one("webkitTransitionEnd transitionend",q.proxy(this._afterShowMasterAnimation,this));this.fireBeforeMasterOpen();this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",true);this._oMasterNav.getDomRef().offsetHeight;this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",false);this._bMasterOpening=true;t._removeMasterButton(_);if(D.browser.webkit){var m=this._oMasterNav;window.setTimeout(function(){m.$().css("box-shadow","none");window.setTimeout(function(){m.$().css("box-shadow","");},50);},0);}}return this;};f.prototype.hideMaster=function(){if(this._portraitPopover()){if(this._oPopOver.isOpen()){this._oPopOver.close();this._bMasterClosing=true;}}else if((this._portraitHide()||this._hideMode())&&(this._bMasterisOpen||this._oMasterNav.$().hasClass("sapMSplitContainerMasterVisible"))){this._oMasterNav.$().one("webkitTransitionEnd transitionend",q.proxy(this._afterHideMasterAnimation,this));this.fireBeforeMasterClose();this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",false);this._oMasterNav.getDomRef().offsetHeight;this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",true);this._bMasterClosing=true;}return this;};f.prototype._afterShowMasterAnimation=function(){if(this._portraitHide()||this._hideMode()){this._bMasterOpening=false;this._bMasterisOpen=true;this.fireAfterMasterOpen();}};f.prototype._afterHideMasterAnimation=function(){var o=this._getRealPage(this._oDetailNav.getCurrentPage());this._setMasterButton(o);this._bMasterClosing=false;this._bMasterisOpen=false;if(c(this._oMasterNav.getDomRef(),document.activeElement)){document.activeElement.blur();}this.fireAfterMasterClose();};f.prototype.getCurrentMasterPage=function(){return this._oMasterNav.getCurrentPage();};f.prototype.getCurrentDetailPage=function(){return this._oDetailNav.getCurrentPage();};f.prototype.getCurrentPage=function(m){if(m){return this.getCurrentMasterPage();}else{return this.getCurrentDetailPage();}};f.prototype.getPreviousPage=function(m){if(m){return this._oMasterNav.getPreviousPage();}else{return this._oDetailNav.getPreviousPage();}};f.prototype.getMasterPage=function(p){return this._oMasterNav.getPage(p);};f.prototype.getDetailPage=function(p){return this._oDetailNav.getPage(p);};f.prototype.getPage=function(p,m){if(m){return this.getMasterPage(p);}else{return this.getDetailPage(p);}};f.prototype.isMasterShown=function(){if(D.system.phone){var o=this._oMasterNav.getCurrentPage();return this._indexOfMasterPage(o)!==-1;}else{var m=this.getMode();switch(m){case e.StretchCompressMode:return true;case e.HideMode:return this._bMasterisOpen;case e.PopoverMode:case e.ShowHideMode:return D.orientation.landscape||this._bMasterisOpen;default:return false;}}};f.prototype.setInitialMaster=function(p){this._oMasterNav.setInitialPage(p);this.setAssociation('initialMaster',p,true);return this;};f.prototype.setInitialDetail=function(p){if(!D.system.phone){this._oDetailNav.setInitialPage(p);}this.setAssociation('initialDetail',p,true);return this;};f.prototype.setDefaultTransitionNameDetail=function(t){this.setProperty("defaultTransitionNameDetail",t,true);this._oDetailNav.setDefaultTransitionName(t);return this;};f.prototype.setDefaultTransitionNameMaster=function(t){this.setProperty("defaultTransitionNameMaster",t,true);this._oMasterNav.setDefaultTransitionName(t);return this;};f.prototype.setMasterButtonText=function(t){if(!D.system.phone){if(!t){t=this._rb.getText("SplitContainer_NAVBUTTON_TEXT");}this._oShowMasterBtn.setText(t);}this.setProperty("masterButtonText",t,true);return this;};f.prototype.setMode=function(m){var o=this.getMode();if(o===m){return this;}this.setProperty("mode",m,true);if(!D.system.phone&&this.getDomRef()){if(o==="HideMode"&&this._oldIsLandscape){this._removeMasterButton(this._oDetailNav.getCurrentPage());}if(m!=="PopoverMode"&&this._oPopOver.getContent().length>0){this._updateMasterPosition("landscape");}else if(m=="PopoverMode"){if(!this._oldIsLandscape){if(this._oPopOver.getContent().length===0){this._updateMasterPosition("popover");}this._setMasterButton(this._oDetailNav.getCurrentPage());}this.toggleStyleClass("sapMSplitContainerShowHide",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",false);this.toggleStyleClass("sapMSplitContainerHideMode",false);this.toggleStyleClass("sapMSplitContainerPopover",true);}if(m=="StretchCompressMode"){this.toggleStyleClass("sapMSplitContainerShowHide",false);this.toggleStyleClass("sapMSplitContainerPopover",false);this.toggleStyleClass("sapMSplitContainerHideMode",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",true);this._removeMasterButton(this._oDetailNav.getCurrentPage());}if(m=="ShowHideMode"){this.toggleStyleClass("sapMSplitContainerPopover",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",false);this.toggleStyleClass("sapMSplitContainerHideMode",false);this.toggleStyleClass("sapMSplitContainerShowHide",true);if(!D.orientation.landscape){this._setMasterButton(this._oDetailNav.getCurrentPage());}}if(m==="HideMode"){this.toggleStyleClass("sapMSplitContainerPopover",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",false);this.toggleStyleClass("sapMSplitContainerShowHide",false);this.toggleStyleClass("sapMSplitContainerHideMode",true);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",false);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",true);this._bMasterisOpen=false;this._setMasterButton(this._oDetailNav.getCurrentPage());}}return this;};f.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){L.warning("Invalid value "+o+" for SplitContainer.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};f.prototype._updateMasterInitialPage=function(){if(this.getMode()==="HideMode"&&D.system.phone&&this._aDetailPages){this._oMasterNav.setInitialPage(this.getInitialDetail()?this.getInitialDetail():(this.getInitialMaster()||this._aDetailPages[0]));}};f.prototype._indexOfMasterPage=function(p){return this._aMasterPages.indexOf(p);};f.prototype._indexOfDetailPage=function(p){return this._aDetailPages.indexOf(p);};f.prototype._insertPage=function(p,A,o,g,s){this.insertAggregation(A,o,g,s);var i;if(g<0){i=0;}else if(g>p.length){i=p.length;}else{i=g;}var O=(p?Array.prototype.indexOf.call(p,o):-1);p.splice(i,0,o);if(O!=-1){this._removePageFromArray(p,o);}return this;};f.prototype._removePage=function(p,A,o,s){var r=this.removeAggregation(A,o,s);if(r){this._removePageFromArray(p,r);}return r;};f.prototype._removePageFromArray=function(p,o){var i=(p?Array.prototype.indexOf.call(p,o):-1);if(i!=-1){p.splice(i,1);if(p===this._aDetailPages){this._restoreMethodsInPage(o);}}};f.prototype._handleNavigationEvent=function(E,A,m){var s=(A?"After":"")+(m?"Master":"Detail")+"Navigate",g;s=s.charAt(0).toLowerCase()+s.slice(1);g=this.fireEvent(s,E.mParameters,true);if(!g){E.preventDefault();}};f.prototype._handleResize=function(){var i=D.orientation.landscape,_=this._oDetailNav.getCurrentPage(),m=this.getMode();if(this._oldIsLandscape!==i){this._oldIsLandscape=i;if(!D.system.phone){this.toggleStyleClass("sapMSplitContainerPortrait",!i);if(m==="HideMode"){return;}if(m==="ShowHideMode"){if(i){this.fireBeforeMasterOpen();}else{this.fireBeforeMasterClose();}}if(m==="ShowHideMode"||m==="PopoverMode"){this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",i);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",!i);}if(m==="ShowHideMode"){if(i){this._bMasterisOpen=true;this.fireAfterMasterOpen();}else{this._bMasterisOpen=false;this.fireAfterMasterClose();}}if(m=="PopoverMode"){if(this._oPopOver.isOpen()){this._oPopOver.attachAfterClose(this._handlePopClose,this);this._oPopOver.close();}else{this._handlePopClose();}}_=this._getRealPage(_);if(!this._oldIsLandscape&&m!="StretchCompressMode"){this._setMasterButton(_);}else{this._removeMasterButton(_);}}if(this._onOrientationChange){this._onOrientationChange();}}};f.prototype._handlePopClose=function(E){this._oPopOver.detachAfterClose(this._handlePopClose,this);if(this._oldIsLandscape){this._updateMasterPosition("landscape");}else{this._updateMasterPosition("popover");}};f.prototype._getRealPage=function(p){var r=p,g;while(r){if(r instanceof sap.m.Page){return r;}if(r instanceof sap.m.MessagePage){return r;}if(r instanceof S){return r;}if(r instanceof sap.ui.core.mvc.View){g=r.getContent();if(g.length===1){r=g[0];continue;}}else if(r instanceof N){r=r.getCurrentPage();continue;}r=null;}return r;};f.prototype._updateMasterPosition=function(p){var t=this;if(p=="popover"){this.removeAggregation("_navMaster",this._oMasterNav,true);this._oMasterNav.$().remove();this._oPopOver.addContent(this._oMasterNav);this._bMasterisOpen=false;}if(p=="landscape"){var r=function(){t._oPopOver.removeAggregation("content",t._oMasterNav,false);t.setAggregation("_navMaster",t._oMasterNav,true);var $=t.$();if($[0]){var g=sap.ui.getCore().createRenderManager();g.renderControl(t._oMasterNav.addStyleClass("sapMSplitContainerMaster"));g.flush($[0],false,(t.$("BG")[0])?1:0);g.destroy();}};if(this._oPopOver.isOpen()){var A=function(){this._oPopOver.detachAfterClose(A,this);this._bMasterisOpen=false;r();};this._oPopOver.attachAfterClose(A,this);this._oPopOver.close();}else{r();}}};f.prototype._portraitHide=function(){if(!this._oldIsLandscape&&!D.system.phone&&this.getMode()==="ShowHideMode"){return true;}else{return false;}};f.prototype._portraitPopover=function(){if(!this._oldIsLandscape&&!D.system.phone&&this.getMode()==="PopoverMode"){return true;}else{return false;}};f.prototype._hideMode=function(){return this.getMode()==="HideMode"&&!D.system.phone;};f.prototype._needShowMasterButton=function(){return(this._portraitHide()||this._hideMode()||this._portraitPopover())&&(!this._bMasterisOpen||this._bMasterClosing);};f.prototype._updateMasterButtonTooltip=function(){if(!this._oShowMasterBtn){return;}var t=this.getMasterButtonTooltip();if(t){this._oShowMasterBtn.setTooltip(t);return;}var p=this._oMasterNav.getCurrentPage();if(p&&p.getTitle){var T=p.getTitle();if(T){T=T.replace(/[_0-9]+$/,'');t=this._rb.getText('SPLITCONTAINER_NAVBUTTON_TOOLTIP',T);}}if(!t){t=this._rb.getText('SPLITCONTAINER_NAVBUTTON_DEFAULT_TOOLTIP');}this._oShowMasterBtn.setTooltip(t);};f.prototype._createShowMasterButton=function(){if(this._oShowMasterBtn&&!this._oShowMasterBtn.bIsDestroyed){return;}this._oShowMasterBtn=new sap.m.Button(this.getId()+"-MasterBtn",{icon:I.getIconURI("menu2"),tooltip:this.getMasterButtonTooltip(),type:B.Default,press:q.proxy(this._onMasterButtonTap,this)}).addStyleClass("sapMSplitContainerMasterBtn");};f.prototype._setMasterButton=function(p,g,s){if(!p){return;}if(typeof g==='boolean'){s=g;g=undefined;}p=this._getRealPage(p);if(!p){return;}var h=f._getHeaderButtonAggregation(p),H=h.sAggregationName,j=h.aAggregationContent;for(var i=0;i<j.length;i++){if(j[i]instanceof sap.m.Button&&j[i].getVisible()&&(j[i].getType()==B.Back||(j[i].getType()==B.Up&&j[i]!==this._oShowMasterBtn))){this._bDetailNavButton=true;return;}}this._bDetailNavButton=false;var o=p._getAnyHeader();var k=false;for(var i=0;i<j.length;i++){if(j[i]===this._oShowMasterBtn){k=true;}}if(!k){this._createShowMasterButton();this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");if(o){o.insertAggregation(H,this._oShowMasterBtn,0,s);}}else{this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnHide",false);this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnShow",true);}if(g){g(p);}this.fireMasterButton({show:true});};f._getHeaderButtonAggregation=function(p){var h=p._getAnyHeader(),A,s;if(!h){return;}if(h.getContentLeft){A=h.getContentLeft();s="contentLeft";}if(h.getContent){A=h.getContent();s="content";}return{aAggregationContent:A,sAggregationName:s};};f.prototype._removeMasterButton=function(p,g,n){if(!p){return;}var t=this,h=this._oShowMasterBtn.$().is(":hidden"),H;if(typeof g==="boolean"){n=g;g=undefined;}if(!h&&!n){p=this._getRealPage(p);if(!p){return;}H=p._getAnyHeader();if(H){var j=f._getHeaderButtonAggregation(p).aAggregationContent;for(var i=0;i<j.length;i++){if(j[i]===this._oShowMasterBtn){this._oShowMasterBtn.destroy();this._oShowMasterBtn.$().parent().bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._oShowMasterBtn.addStyleClass("sapMSplitContainerMasterBtnHidden");if(g){g(p);}});break;}}}this.fireMasterButton({show:false});}else{this._oShowMasterBtn.addStyleClass("sapMSplitContainerMasterBtnHidden");if(g){g(p);}if(!h){this.fireMasterButton({show:false});}}};f.prototype._callMethodInManagedObject=function(F,A){var g=Array.prototype.slice.call(arguments);if(A==="masterPages"){if(F==="indexOfAggregation"){return this._indexOfMasterPage.apply(this,g.slice(2));}else{return this._callNavContainerMethod(F,this._oMasterNav,g);}}else if(A==="detailPages"){if(F==="indexOfAggregation"){return this._indexOfDetailPage.apply(this,g.slice(2));}else{return this._callNavContainerMethod(F,this._oDetailNav,g);}}else{return M.prototype[F].apply(this,g.slice(1));}};f.prototype._callNavContainerMethod=function(F,n,A){A[1]="pages";A=A.slice(1);var r=f._mFunctionMapping[F];if(r){A.shift();F=r;}return n[F].apply(n,A);};f.prototype._hasPageInArray=function(g,p){return g.some(function(A){return p&&(p===A);});};f.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};f.prototype.setAggregation=function(A,o,s){this._callMethodInManagedObject("setAggregation",A,o,s);return this;};f.prototype.getAggregation=function(A,o){return this._callMethodInManagedObject("getAggregation",A,o);};f.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};f.prototype.insertAggregation=function(A,o,i,s){this._callMethodInManagedObject("insertAggregation",A,o,i,s);return this;};f.prototype.addAggregation=function(A,o,s){this._callMethodInManagedObject("addAggregation",A,o,s);return this;};f.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};f.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};f.prototype.destroyAggregation=function(A,s){this._callMethodInManagedObject("destroyAggregation",A,s);return this;};f._mFunctionMapping={"getAggregation":"getPage","addAggregation":"addPage","insertAggregation":"insertPage","removeAggregation":"removePage","removeAllAggregation":"removeAllPages"};return f;});
