/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/Global','sap/ui/base/BindingParser','sap/ui/base/DataType','sap/ui/base/EventProvider','sap/ui/base/Interface','sap/ui/base/Object','sap/ui/base/ManagedObject','./Component','./Configuration','./Control','./Element','./ElementMetadata','./FocusHandler','./RenderManager','./ResizeHandler','./ThemeCheck','./UIArea','./message/MessageManager',"sap/ui/util/ActivityDetection","sap/ui/dom/getScrollbarSize","sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/performance/Measurement","sap/ui/security/FrameOptions","sap/base/assert","sap/ui/dom/includeStylesheet","sap/base/util/ObjectPath","sap/base/util/Version","sap/base/util/array/uniqueSort","sap/base/util/uid",'sap/ui/performance/trace/initTraces','sap/base/util/LoaderExtensions','sap/base/util/isEmptyObject','sap/ui/events/jquery/EventSimulation'],function(jQuery,Device,Global,BindingParser,DataType,EventProvider,Interface,BaseObject,ManagedObject,Component,Configuration,Control,Element,ElementMetadata,FocusHandler,RenderManager,ResizeHandler,ThemeCheck,UIArea,MessageManager,ActivityDetection,getScrollbarSize,ResourceBundle,Log,Measurement,FrameOptions,assert,includeStylesheet,ObjectPath,Version,uniqueSort,uid,initTraces,LoaderExtensions,isEmptyObject){"use strict";function globalEval(){eval(arguments[0]);}function each(o,f,t){Object.keys(o).forEach(f,t);}if(sap.ui.getCore&&sap.ui.getCore()){return sap.ui.getCore();}initTraces();var oRenderLog=UIArea._oRenderLog;var mLoadedLibraries={};var mLibraryPreloadBundles={};var _oEventProvider;var SyncPoint=function(n,c){var t=[],o=0,f=0;this.startTask=function(T){var i=t.length;t[i]={name:T,finished:false};o++;return i;};this.finishTask=function(i,s){if(!t[i]||t[i].finished){throw new Error("trying to finish non existing or already finished task");}t[i].finished=true;o--;if(s===false){f++;}if(o===0){Log.info("Sync point '"+n+"' finished (tasks:"+t.length+", open:"+o+", failures:"+f+")");a();}};function a(){if(c){c(o,f);}c=null;}Log.info("Sync point '"+n+"' created");};var Core=BaseObject.extend("sap.ui.core.Core",{constructor:function(){var t=this,M="sap.ui.core.Core";if(sap.ui.getCore&&sap.ui.getCore()){Log.error("Only the framework must create an instance of sap/ui/core/Core."+" To get access to its functionality, use sap.ui.getCore().");return sap.ui.getCore();}BaseObject.call(this);_oEventProvider=new EventProvider();["attachEvent","detachEvent","getEventingParent"].forEach(function(F){Core.prototype[F]=_oEventProvider[F].bind(_oEventProvider);});this.bBooted=false;this.bInitialized=false;this.bDomReady=false;this.aPlugins=[];this.mLibraries={};this.mResourceBundles={};this.mUIAreas={};this.oModels={};this.oEventBus=null;this.mElements={};this.mObjects={"component":{},"template":{}};this.oRootComponent=null;this.aInitListeners=[];this.bInitLegacyLib=false;this._sRerenderTimer=this;this.aPrerenderingTasks=[];Log.info("Creating Core",null,M);Measurement.start("coreComplete","Core.js - complete");Measurement.start("coreBoot","Core.js - boot");Measurement.start("coreInit","Core.js - init");this.oConfiguration=new Configuration(this);var f=this.oConfiguration["frameOptionsConfig"]||{};f.mode=this.oConfiguration.getFrameOptions();f.whitelistService=this.oConfiguration.getWhitelistService();this.oFrameOptions=new FrameOptions(f);if(this.oConfiguration["bindingSyntax"]==="complex"){ManagedObject.bindingParser=BindingParser.complexParser;}if(this.oConfiguration["xx-designMode"]==true){BindingParser._keepBindingStrings=true;}this._grantFriendAccess();var m=this.oConfiguration.modules;if(this.oConfiguration.getDebug()){m.unshift("sap.ui.debug.DebugEnv");}var i=m.indexOf("sap.ui.core.library");if(i!=0){if(i>0){m.splice(i,1);}m.unshift("sap.ui.core.library");}if(this.oConfiguration["xx-lesssupport"]&&m.indexOf("sap.ui.core.plugin.LessSupport")==-1){Log.info("Including LessSupport into declared modules");m.push("sap.ui.core.plugin.LessSupport");}var p=this.oConfiguration.preload;if(window["sap-ui-debug"]===true){p="";}if(p==="auto"){p=window["sap-ui-optimized"]?"sync":"";}this.oConfiguration.preload=p;var a=p==="async";if(sap.ui.loader.config().async){a=true;}this.oConfiguration['xx-libraryPreloadFiles'].forEach(function(v){var u=String(v).trim().split(/\s*:\s*/),w=u[0],x=u[1];if(u.length===1){x=w;w='';}if(/^(?:none|js|json|both)$/.test(x)){mLibraryPreloadFileTypes[w]=x;}});Log.info("Declared modules: "+m,M);this._setupThemes();this._setupContentDirection();this._setupBrowser();this._setupOS();this._setupLang();this._setupAnimation();sap.ui.getCore=function(){return t.getInterface();};this.oRenderManager=new RenderManager();var s=new SyncPoint("UI5 Document Ready",function(O,F){t.bDomReady=true;t.init();});var d=s.startTask("document.ready");var c=s.startTask("preload and boot");var C=function(){Log.trace("document is ready");s.finishTask(d);document.removeEventListener("DOMContentLoaded",C);};if(document.readyState!=="loading"){C();}else{document.addEventListener("DOMContentLoaded",C);}var S=new SyncPoint("UI5 Core Preloads and Bootstrap Script",function(O,F){Log.trace("Core loaded: open="+O+", failures="+F);t._boot(a,function(){s.finishTask(c);Measurement.end("coreBoot");});});var b=S.startTask("create sp2 tasks task");if(this.oConfiguration["versionedLibCss"]){var V=S.startTask("load version info");var e=function(v){if(v){Log.trace("Loaded \"sap-ui-version.json\".");}else{Log.error("Could not load \"sap-ui-version.json\".");}S.finishTask(V);};var r=sap.ui.getVersionInfo({async:a,failOnError:false});if(r instanceof Promise){r.then(e,function(E){Log.error("Unexpected error when loading \"sap-ui-version.json\": "+E);S.finishTask(V);});}else{e(r);}}var g=this.oConfiguration["xx-bootTask"];if(g){var h=S.startTask("custom boot task");g(function(u){S.finishTask(h,typeof u==="undefined"||u===true);});}this._polyfillFlexbox();var B=S.startTask("bootstrap script");this.boot=function(){if(this.bBooted){return;}this.bBooted=true;S.finishTask(B);};if(p==="sync"||p==="async"){var l=m.reduce(function(R,u){var v=u.search(/\.library$/);if(v>=0){R.push(u.slice(0,v));}return R;},[]);var j=this.loadLibraries(l,{async:a,preloadOnly:true});if(a){var P=S.startTask("preload bootstrap libraries");j.then(function(){S.finishTask(P);},function(){S.finishTask(P,false);});}}var A=this.oConfiguration.getAppCacheBuster();if(A&&A.length>0){var k=sap.ui.requireSync('sap/ui/core/AppCacheBuster');k.boot(S);}if(this.oConfiguration.getSupportMode()!==null){var n=S.startTask("support info script");var o=function(u){u.initSupportRules(t.oConfiguration.getSupportMode());S.finishTask(n);};var q=function(u){u.initializeSupportMode(t.oConfiguration.getSupportMode(),a);if(a){sap.ui.require(["sap/ui/support/Bootstrap"],o);}else{o(sap.ui.requireSync("sap/ui/support/Bootstrap"));}};if(a){sap.ui.require(["sap/ui/core/support/Support"],q);}else{q(sap.ui.requireSync("sap/ui/core/support/Support"));}}S.finishTask(b);},metadata:{publicMethods:["boot","isInitialized","isThemeApplied","attachInitEvent","attachInit","getRenderManager","createRenderManager","getConfiguration","setRoot","createUIArea","getUIArea","getUIDirty","getElementById","getCurrentFocusedControlId","getControl","getComponent","getTemplate","lock","unlock","isLocked","attachEvent","detachEvent","applyChanges","getEventBus","applyTheme","setThemeRoot","attachThemeChanged","detachThemeChanged","getStaticAreaRef","attachThemeScopingChanged","detachThemeScopingChanged","fireThemeScopingChanged","notifyContentDensityChanged","registerPlugin","unregisterPlugin","getLibraryResourceBundle","byId","getLoadedLibraries","loadLibrary","loadLibraries","initLibrary","includeLibraryTheme","setModel","getModel","hasModel","isMobile","attachControlEvent","detachControlEvent","attachIntervalTimer","detachIntervalTimer","attachParseError","detachParseError","fireParseError","attachValidationError","detachValidationError","fireValidationError","attachFormatError","detachFormatError","fireFormatError","attachValidationSuccess","detachValidationSuccess","fireValidationSuccess","attachLocalizationChanged","detachLocalizationChanged","attachLibraryChanged","detachLibraryChanged","isStaticAreaRef","createComponent","getRootComponent","getApplication","setMessageManager","getMessageManager","byFieldGroupId","addPrerenderingTask"]}});Core.M_EVENTS={ControlEvent:"ControlEvent",UIUpdated:"UIUpdated",ThemeChanged:"ThemeChanged",ThemeScopingChanged:"themeScopingChanged",LocalizationChanged:"localizationChanged",LibraryChanged:"libraryChanged",ValidationError:"validationError",ParseError:"parseError",FormatError:"formatError",ValidationSuccess:"validationSuccess"};var STATIC_UIAREA_ID="sap-ui-static";Core.prototype._grantFriendAccess=function(){var t=this;ElementMetadata.prototype.register=function(m){t.registerElementClass(m);};Element.prototype.register=function(){t.registerElement(this);};Element.prototype.deregister=function(){t.deregisterElement(this);};Element._updateFocusInfo=function(e){if(t.oFocusHandler){t.oFocusHandler.updateControlFocusInfo(e);}};Component.prototype.register=function(){t.registerObject(this);};Component.prototype.deregister=function(){var c=this.sId;for(var e in t.mElements){var E=t.mElements[e];if(E._sapui_candidateForDestroy&&E._sOwnerId===c&&!E.getParent()){Log.debug("destroying dangling template "+E+" when destroying the owner component");E.destroy();}}t.deregisterObject(this);};};Core.prototype._setupThemes=function(){var M="sap.ui.core.Core";var c=window["sap-ui-config"];if(this.oConfiguration.themeRoot){c=c||{};c.themeroots=c.themeroots||{};c.themeroots[this.oConfiguration.getTheme()]=this.oConfiguration.themeRoot;}if(c){if(c.themeroots){for(var t in c.themeroots){var a=c.themeroots[t];if(typeof a==="string"){this.setThemeRoot(t,a);}else{for(var l in a){if(l.length>0){this.setThemeRoot(t,[l],a[l]);}else{this.setThemeRoot(t,a[l]);}}}}}}this.sTheme=this.oConfiguration.getTheme();document.documentElement.classList.add("sapUiTheme-"+this.sTheme);Log.info("Declared theme "+this.sTheme,null,M);};Core.prototype._setupContentDirection=function(){var M="sap.ui.core.Core",d=this.oConfiguration.getRTL()?"rtl":"ltr";document.documentElement.setAttribute("dir",d);Log.info("Content direction set to '"+d+"'",null,M);};Core.prototype._setupBrowser=function(){var M="sap.ui.core.Core";var h=document.documentElement;var b=Device.browser;var i=b.name;if(i){if(i===b.BROWSER.SAFARI&&b.mobile){i="m"+i;}i=i+(b.version===-1?"":Math.floor(b.version));h.dataset.sapUiBrowser=i;Log.debug("Browser-Id: "+i,null,M);}};Core.prototype._setupOS=function(h){var h=document.documentElement;h.dataset.sapUiOs=Device.os.name+Device.os.versionStr;var o=null;switch(Device.os.name){case Device.os.OS.IOS:o="sap-ios";break;case Device.os.OS.ANDROID:o="sap-android";break;case Device.os.OS.BLACKBERRY:o="sap-bb";break;case Device.os.OS.WINDOWS_PHONE:o="sap-winphone";break;}if(o){h.classList.add(o);}};Core.prototype._setupLang=function(){var h=document.documentElement;var u=function(){var l=this.oConfiguration.getLocale();l?h.setAttribute("lang",l.toString()):h.removeAttribute("lang");};u.call(this);this.attachLocalizationChanged(u,this);};Core.prototype._setupAnimation=function(){if(this.oConfiguration){var h=document.documentElement;var a=this.oConfiguration.getAnimation();h.dataset.sapUiAnimation=a?"on":"off";if(typeof jQuery!=="undefined"){jQuery.fx.off=!a;}var A=this.oConfiguration.getAnimationMode();h.dataset.sapUiAnimationMode=A;}};Core.prototype._polyfillFlexbox=function(){jQuery.support.useFlexBoxPolyfill=false;};Core.prototype._boot=function(a,c){var C=this.oConfiguration['preloadLibCss'];if(C&&C.length>0&&!C.appManaged){this.includeLibraryTheme("sap-ui-merged",undefined,"?l="+C.join(","));}if(a){return this._requireModulesAsync().then(function(){c();});}this.oConfiguration.modules.forEach(function(b){var m=b.match(/^(.*)\.library$/);if(m){this.loadLibrary(m[1]);}else{sap.ui.requireSync(/^jquery\.sap\./.test(b)?b:b.replace(/\./g,"/"));}}.bind(this));c();};Core.prototype._requireModulesAsync=function(){var l=[],M=[];this.oConfiguration.modules.forEach(function(s){var m=s.match(/^(.*)\.library$/);if(m){l.push(m[1]);}else{M.push(/^jquery\.sap\./.test(s)?s:s.replace(/\./g,"/"));}});return Promise.all([this.loadLibraries(l),new Promise(function(r){sap.ui.require(M,function(){r(Array.prototype.slice.call(arguments));});})]);};Core.prototype.applyTheme=function(t,T){assert(typeof t==="string","sThemeName must be a string");assert(typeof T==="string"||typeof T==="undefined","sThemeBaseUrl must be a string or undefined");t=this.oConfiguration._normalizeTheme(t,T);if(T){this.setThemeRoot(t,T);}if(t&&this.sTheme!=t){var c=this.sTheme;var h=document.documentElement;this._updateThemeUrls(t,true);this.sTheme=t;this.oConfiguration._setTheme(t);h.classList.remove("sapUiTheme-"+c);h.classList.add("sapUiTheme-"+t);if(this.oThemeCheck){this.oThemeCheck.fireThemeChangedEvent(false);}}};Core.prototype._updateThemeUrl=function(l,t,s){var L=l.id.slice(13),q=l.href.search(/[?#]/),a,Q,S="library",r=this.oConfiguration.getRTL()?"-RTL":"",h,p;if(q>-1){a=l.href.substring(0,q);Q=l.href.substring(q);}else{a=l.href;Q="";}a=a.substring(a.lastIndexOf("/")+1);if((p=L.indexOf("-["))>0){S+=L.slice(p+2,-1);L=L.slice(0,p);}if(a===(S+".css")||a===(S+"-RTL.css")){a=S+r+".css";}h=this._getThemePath(L,t)+a+Q;if(h!=l.href){if(s){l.dataset.sapUiFoucmarker=l.id;}includeStylesheet(h,l.id);}};Core.prototype._updateThemeUrls=function(t,s){var q=document.querySelectorAll("link[id^=sap-ui-theme-]");Array.prototype.forEach.call(q,function(h){this._updateThemeUrl(h,t,s);}.bind(this));};Core.prototype._ensureThemeRoot=function(l,t){if(this._mThemeRoots){var p=this._mThemeRoots[t+" "+l]||this._mThemeRoots[t];if(p){p=p+l.replace(/\./g,"/")+"/themes/"+t+"/";registerModulePath(l+".themes."+t,p);}}};Core.prototype._getThemePath=function(l,t){this._ensureThemeRoot(l,t);return getModulePath(l+".themes."+t,"/");};Core.prototype.setThemeRoot=function(t,l,T,f){assert(typeof t==="string","sThemeName must be a string");assert((Array.isArray(l)&&typeof T==="string")||(typeof l==="string"&&T===undefined),"either the second parameter must be a string (and the third is undefined), or it must be an array and the third parameter is a string");if(!this._mThemeRoots){this._mThemeRoots={};}if(typeof l==="string"){f=T;T=l;l=undefined;}T=T+(T.slice(-1)=="/"?"":"/");if(l){for(var i=0;i<l.length;i++){var a=l[i];this._mThemeRoots[t+" "+a]=T;}}else{this._mThemeRoots[t]=T;}if(f&&t===this.sTheme){this._updateThemeUrls(this.sTheme);}return this;};Core.prototype.init=function(){if(this.bInitialized){return;}var M="sap.ui.core.Core.init()";this.boot();Log.info("Initializing",null,M);this.oFocusHandler=new FocusHandler(document.body,this);this.oRenderManager._setFocusHandler(this.oFocusHandler);this.oResizeHandler=new ResizeHandler(this);this.oThemeCheck=new ThemeCheck(this);Log.info("Initialized",null,M);Measurement.end("coreInit");this.bInitialized=true;Log.info("Starting Plugins",null,M);this.startPlugins();Log.info("Plugins started",null,M);this._createUIAreas();this.oThemeCheck.fireThemeChangedEvent(true);this._executeOnInit();this._setupRootComponent();this._setBodyAccessibilityRole();this._executeInitListeners();if(this.isThemeApplied()||!this.oConfiguration['xx-waitForTheme']){this.renderPendingUIUpdates("during Core init");}else{oRenderLog.debug("delay initial rendering until theme has been loaded");_oEventProvider.attachEventOnce(Core.M_EVENTS.ThemeChanged,function(){setTimeout(this.renderPendingUIUpdates.bind(this,"after theme has been loaded"),Device.browser.safari?50:0);},this);}Measurement.end("coreComplete");};Core.prototype._createUIAreas=function(){var c=this.oConfiguration;if(c.areas){for(var i=0,l=c.areas.length;i<l;i++){this.createUIArea(c.areas[i]);}c.areas=undefined;}};Core.prototype._executeOnInit=function(){var o=this.oConfiguration.onInit;if(o){if(typeof o==="function"){o();}else if(typeof o==="string"){var r=/^module\:((?:(?:[_$.\-a-zA-Z][_$.\-a-zA-Z0-9]*)\/?)*)$/.exec(o);if(r&&r[1]){setTimeout(sap.ui.require.bind(sap.ui,[r[1]]),0);}else{var f=ObjectPath.get(o);if(typeof f==="function"){f();}else{globalEval(o);}}}this.oConfiguration.onInit=undefined;}};Core.prototype._setupRootComponent=function(){var M="sap.ui.core.Core.init()",c=this.oConfiguration;var r=c.getRootComponent();if(r){Log.info("Loading Root Component: "+r,null,M);var C=sap.ui.component({name:r});this.oRootComponent=C;var R=c["xx-rootComponentNode"];if(R&&C.isA('sap.ui.core.UIComponent')){var o=(R?document.getElementById(R):null);if(o){Log.info("Creating ComponentContainer for Root Component: "+r,null,M);var a=sap.ui.requireSync('sap/ui/core/ComponentContainer'),b=new a({component:C,propagateModel:true});b.placeAt(o);}}}else{var A=c.getApplication();if(A){Log.warning("The configuration 'application' is deprecated. Please use the configuration 'component' instead! Please migrate from sap.ui.app.Application to sap.ui.core.Component.");Log.info("Loading Application: "+A,null,M);sap.ui.requireSync(A.replace(/\./g,"/"));var d=ObjectPath.get(A);assert(d!==undefined,"The specified application \""+A+"\" could not be found!");var e=new d();assert(BaseObject.isA(e,'sap.ui.app.Application'),"The specified application \""+A+"\" must be an instance of sap.ui.app.Application!");}}};Core.prototype._setBodyAccessibilityRole=function(){var c=this.oConfiguration,b=document.body,B,a;if(c.getAccessibility()&&c.getAutoAriaBodyRole()){B=b.getAttribute("role");a=c.getAvoidAriaApplicationRole();if(!B&&!a){b.setAttribute("role","application");}else if(B==="application"&&a){b.removeAttribute("role");}}};Core.prototype._executeInitListeners=function(){var M="sap.ui.core.Core.init()";var c=this.aInitListeners;this.aInitListeners=undefined;if(c&&c.length>0){Log.info("Fire Loaded Event",null,M);c.forEach(function(f){f();});}};Core.prototype.isInitialized=function(){return this.bInitialized;};Core.prototype.isThemeApplied=function(){return ThemeCheck.themeLoaded;};Core.prototype.attachInitEvent=function(f){assert(typeof f==="function","fnFunction must be a function");if(this.aInitListeners){this.aInitListeners.push(f);}};Core.prototype.attachInit=function(f){assert(typeof f==="function","fnFunction must be a function");if(this.aInitListeners){this.aInitListeners.push(f);}else{f();}};Core.prototype.lock=function(){this.bLocked=true;};Core.prototype.unlock=function(){this.bLocked=false;};Core.prototype.isLocked=function(){return this.bLocked;};Core.prototype.getConfiguration=function(){return this.oConfiguration;};Core.prototype.getRenderManager=function(){return this.createRenderManager();};Core.prototype.createRenderManager=function(){assert(this.isInitialized(),"A RenderManager should be created only after the Core has been initialized");var r=new RenderManager();r._setFocusHandler(this.oFocusHandler);return r.getInterface();};Core.prototype.getCurrentFocusedControlId=function(){if(!this.isInitialized()){throw new Error("Core must be initialized");}return this.oFocusHandler.getCurrentFocusedControlId();};var mLibraryPreloadFileTypes={};function evalLibConfig(l){assert(typeof l==='string'&&l||typeof l==='object'&&typeof l.name==='string'&&l.name&&(l.json==null||typeof l.json==='boolean'),"lib must be a non-empty string or an object with at least a non-empty 'name' property and an optional (boolean) property 'json'");var f='both';if(typeof l==='object'){if(l.json===true){f='json';}else if(l.json===false){f='js';}l=l.name;}var a=mLibraryPreloadFileTypes[l]||mLibraryPreloadFileTypes['']||'both';if(a==='both'){a=f;}else if(a!==f&&f!=='both'){a='none';}return{name:l,fileType:a};}function preloadLibraryAsync(l){var t=this;l=evalLibConfig(l);var a=l.name,f=l.fileType,b=a.replace(/\./g,'/'),h=this.oConfiguration.getDepCache();if(f==='none'||!!sap.ui.loader._.getModuleState(b+'/library.js')){return Promise.resolve(true);}var c=mLibraryPreloadBundles[a]||(mLibraryPreloadBundles[a]={});if(c.promise){return c.promise;}c.pending=true;c.async=true;var p;if(f!=='json'){var P=b+(h?'/library-h2-preload.js':'/library-preload.js');p=sap.ui.loader._.loadJSResourceAsync(P).then(function(){return dependenciesFromManifest(a);},function(e){if(f!=='js'){Log.error("failed to load '"+P+"' ("+(e&&e.message||e)+"), falling back to library-preload.json");return loadJSONAsync(a);}});}else{p=loadJSONAsync(a);}c.promise=p.then(function(d){var e=[],m=getManifest(a);if(d&&d.length){e=d.map(preloadLibraryAsync.bind(t));}if(m&&Version(m._version).compareTo("1.9.0")>=0){e.push(t.getLibraryResourceBundle(a,true));}return Promise.all(e).then(function(){c.pending=false;});});return c.promise;}function getManifest(l){var m=l.replace(/\./g,'/')+'/manifest.json';if(!!sap.ui.loader._.getModuleState(m)){return LoaderExtensions.loadResource(m,{dataType:'json',async:false,failOnError:false});}}function dependenciesFromManifest(l){var m=getManifest(l);var a=m&&m["sap.ui5"]&&m["sap.ui5"].dependencies&&m["sap.ui5"].dependencies.libs;if(a){return Object.keys(a).reduce(function(r,d){if(!a[d].lazy){r.push(d);}return r;},[]);}}function registerPreloadedModules(d,u){var m=d.modules,U=function(n){return/^jquery\.sap\./.test(n)?n:n.replace(/\./g,"/");};if(Version(d.version||"1.0").compareTo("2.0")<0){m={};for(var n in d.modules){m[U(n)+".js"]=d.modules[n];}}sap.ui.require.preload(m,d.name,u);}function preprocessDependencies(d){if(Array.isArray(d)){return d.map(function(a){return a.replace(/\.library-preload$/,'');});}return d;}function loadJSONAsync(l){var u=getModulePath(l,"/library-preload.json");return Promise.resolve(jQuery.ajax({dataType:"json",url:u})).then(function(d){if(d){registerPreloadedModules(d,u);return preprocessDependencies(d.dependencies);}},function(x,t,e){Log.error("failed to load '"+u+"': "+(e||t));});}function preloadLibrarySync(l){l=evalLibConfig(l);var a=l.name,f=l.fileType,b=a.replace(/\./g,'/'),c=!!sap.ui.loader._.getModuleState(b+'/library.js');if(f==='none'||c){return;}var d=mLibraryPreloadBundles[a]||(mLibraryPreloadBundles[a]={});if(d.pending===false){return;}if(d.pending){if(d.async){Log.warning("request to load "+a+" synchronously while async loading is pending; this causes a duplicate request and should be avoided by caller");}else{Log.warning("request to load "+a+" synchronously while sync loading is pending (cycle, ignored)");return;}}d.pending=true;d.async=false;var r;d.promise=new Promise(function(_,h){r=_;});var g;if(f!=='json'){var p=b+'/library-preload';try{sap.ui.requireSync(p);g=dependenciesFromManifest(a);}catch(e){Log.error("failed to load '"+p+"' ("+(e&&e.message||e)+")");if(e&&e.loadError&&f!=='js'){g=loadJSONSync(a);}}}else{g=loadJSONSync(a);}if(g&&g.length){g.forEach(preloadLibrarySync);}d.pending=false;r();}function loadJSONSync(l){var u=getModulePath(l,"/library-preload.json");var d;jQuery.ajax({dataType:"json",async:false,url:u,success:function(a){if(a){registerPreloadedModules(a,u);d=a.dependencies;}},error:function(x,t,e){Log.error("failed to load '"+u+"': "+(e||t));}});return preprocessDependencies(d);}function getModulePath(m,s){return sap.ui.require.toUrl(m.replace(/\./g,"/")+s);}function registerModulePath(m,u){LoaderExtensions.registerResourcePath(m.replace(/\./g,"/"),u);}Core.prototype.loadLibrary=function(l,u){assert(typeof l==="string","sLibrary must be a string");assert(u===undefined||typeof u==='boolean'||typeof u==='string'||typeof u==='object'&&(u.url==null||u.url==='string')&&(u.async==null||typeof u.async==='boolean'),"vUrl must be empty or a string or an object with an optional property 'url' of type string and an optional boolean property 'async'");if(typeof u==='boolean'){u={async:u};}if(typeof u==='object'){if(u.async){if(u.url&&mLibraryPreloadBundles[l]==null){registerModulePath(l,u.url);}return this.loadLibraries([l]);}u=u.url;}if(!mLoadedLibraries[l]){var m=l+".library";if(u){registerModulePath(l,u);}if(this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async'){preloadLibrarySync(l);}sap.ui.requireSync(m.replace(/\./g,"/"));if(!mLoadedLibraries[l]){Log.warning("library "+l+" didn't initialize itself");this.initLibrary(l);}}return this.mLibraries[l];};Core.prototype.loadLibraries=function(l,o){assert(Array.isArray(l),"aLibraries must be an array");o=Object.assign({async:true,preloadOnly:false},o);var p=this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async',a=o.async,r=!o.preloadOnly;function g(){return l.map(function(L){if(typeof L==='object'){L=L.name;}return L.replace(/\./g,"/")+"/library";});}function b(){return new Promise(function(e,f){sap.ui.require(g(),function(){e();},f);});}function c(){g().forEach(sap.ui.requireSync);}if(a){var d=p?Promise.all(l.map(preloadLibraryAsync.bind(this))):Promise.resolve(true);return r?d.then(b):d;}else{if(p){l.forEach(preloadLibrarySync);}if(r){c();}}};Core.prototype.createComponent=function(c,u,i,s){if(typeof c==="string"){c={name:c,url:u};if(typeof i==="object"){c.settings=i;}else{c.id=i;c.settings=s;}}if(c.async&&(c.manifest!==undefined||(c.manifestFirst===undefined&&c.manifestUrl===undefined))){if(c.manifest===undefined){c.manifest=false;}return Component.create(c);}return sap.ui.component(c);};Core.prototype.getRootComponent=function(){return this.oRootComponent;};Core.prototype.initLibrary=function(l){assert(typeof l==='string'||typeof l==='object',"oLibInfo must be a string or object");var L=typeof l==='string';if(L){l={name:l};}var s=l.name,M="sap.ui.core.Core.initLibrary()";if(L){Log.error("[Deprecated] library "+s+" uses old fashioned initLibrary() call (rebuild with newest generator)");}if(!s||mLoadedLibraries[s]){return;}Log.debug("Analyzing Library "+s,null,M);mLoadedLibraries[s]=true;function e(o,I){var k,v;for(k in I){v=I[k];if(v!==undefined){if(Array.isArray(o[k])){if(o[k].length===0){o[k]=v;}else{o[k]=uniqueSort(o[k].concat(v));}}else if(o[k]===undefined){o[k]=v;}else if(k!="name"){Log.warning("library info setting ignored: "+k+"="+v);}}}return o;}ObjectPath.create(s);this.mLibraries[s]=l=e(this.mLibraries[s]||{name:s,dependencies:[],types:[],interfaces:[],controls:[],elements:[]},l);for(var i=0;i<l.dependencies.length;i++){var d=l.dependencies[i];Log.debug("resolve Dependencies to "+d,null,M);if(mLoadedLibraries[d]!==true){Log.warning("Dependency from "+s+" to "+d+" has not been resolved by library itself",null,M);this.loadLibrary(d);}}DataType.registerInterfaceTypes(l.interfaces);for(var i=0;i<l.types.length;i++){if(!/^(any|boolean|float|int|string|object|void)$/.test(l.types[i])){sap.ui.loader._.declareModule(l.types[i].replace(/\./g,"/")+".js");var n=l.types[i].substring(0,l.types[i].lastIndexOf("."));if(ObjectPath.get(n)===undefined){ObjectPath.create(n);}}}var E=l.controls.concat(l.elements);for(var i=0;i<E.length;i++){sap.ui.lazyRequire(E[i],"new extend getMetadata");}if(!l.noLibraryCSS){this._ensureThemeRoot(s,this.sTheme);this._ensureThemeRoot(s,"base");if(this.oConfiguration['preloadLibCss'].indexOf(s)<0){var q=this._getLibraryCssQueryParams(l);this.includeLibraryTheme(s,undefined,q);if(this.oThemeCheck&&this.isInitialized()){this.oThemeCheck.fireThemeChangedEvent(false);}}}l.sName=l.name;l.aControls=l.controls;this.fireLibraryChanged({name:s,stereotype:"library",operation:"add",metadata:l});};Core.prototype.includeLibraryTheme=function(l,v,q){assert(typeof l==="string","sLibName must be a string");assert(v===undefined||typeof v==="string","sVariant must be a string or undefined");if((l!="sap.ui.legacy")&&(l!="sap.ui.classic")){if(!v){v="";}var r=(this.oConfiguration.getRTL()?"-RTL":"");var L,s=l+(v.length>0?"-["+v+"]":v);if(l&&l.indexOf(":")==-1){L="library"+v+r;}else{L=l.substring(l.indexOf(":")+1)+v;l=l.substring(0,l.indexOf(":"));}var a="sap-ui-theme-"+s,o=document.getElementById(a);if(o){o.dataset.sapUiFoucmarker=a;}var c=this._getThemePath(l,this.sTheme)+L+".css"+(q?q:"");Log.info("Including "+c+" -  sap.ui.core.Core.includeLibraryTheme()");includeStylesheet(c,a);var P=sap.ui.require("sap/ui/core/theming/Parameters");if(P){P._addLibraryTheme(s);}}};Core.prototype._getLibraryCssQueryParams=function(l){var q;if(this.oConfiguration["versionedLibCss"]&&l){q="?version="+l.version;if(Global.versioninfo){q+="&sap-ui-dist-version="+Global.versioninfo.version;}}return q;};Core.prototype.getLoadedLibraries=function(){return Object.assign({},this.mLibraries);};Core.prototype.getLibraryResourceBundle=function(l,L,a){var m,k,r,i;if(typeof l==="boolean"){a=l;l=undefined;L=undefined;}if(typeof L==="boolean"){a=L;L=undefined;}assert((l===undefined&&L===undefined)||typeof l==="string","sLibraryName must be a string or there is no argument given at all");assert(L===undefined||typeof L==="string","sLocale must be a string or omitted");l=l||"sap.ui.core";L=L||this.getConfiguration().getLanguage();k=l+"/"+L;r=this.mResourceBundles[k];if(!r||(!a&&r instanceof Promise)){m=getManifest(l);if(m&&Version(m._version).compareTo("1.9.0")>=0){i=m["sap.ui5"]&&m["sap.ui5"].library&&m["sap.ui5"].library.i18n;}if(i!==false){r=ResourceBundle.create({url:sap.ui.resource(l,typeof i==="string"?i:'messagebundle.properties'),locale:L,async:a});if(r instanceof Promise){r=r.then(function(b){this.mResourceBundles[k]=b;return b;}.bind(this));}this.mResourceBundles[k]=r;}}return a?Promise.resolve(r):r;};Core.prototype.setRoot=function(d,c){assert(typeof d==="string"||typeof d==="object","oDomRef must be a string or object");assert(c instanceof Interface||c instanceof Control,"oControl must be a Control or Interface");if(c){c.placeAt(d,"only");}};Core.prototype.createUIArea=function(d){var t=this;assert(typeof d==="string"||typeof d==="object","oDomRef must be a string or object");if(!d){throw new Error("oDomRef must not be null");}if(typeof(d)==="string"){var i=d;if(i==STATIC_UIAREA_ID){d=this.getStaticAreaRef();}else{d=(d?document.getElementById(d):null);if(!d){throw new Error("DOM element with ID '"+i+"' not found in page, but application tries to insert content.");}}}if(!d.id||d.id.length==0){d.id=uid();}var I=d.id;if(!this.mUIAreas[I]){this.mUIAreas[I]=new UIArea(this,d);if(!isEmptyObject(this.oModels)){var p={oModels:Object.assign({},this.oModels),oBindingContexts:{},aPropagationListeners:[]};t.mUIAreas[I]._propagateProperties(true,t.mUIAreas[I],p,true);}}else{this.mUIAreas[I].setRootNode(d);}return this.mUIAreas[I];};Core.prototype.getUIArea=function(o){assert(typeof o==="string"||typeof o==="object","o must be a string or object");var i="";if(typeof(o)=="string"){i=o;}else{i=o.id;}if(i){return this.mUIAreas[i];}return null;};Core.prototype.addInvalidatedUIArea=function(u){if(!this._sRerenderTimer){oRenderLog.debug("Registering timer for delayed re-rendering");this._sRerenderTimer=setTimeout(this["renderPendingUIUpdates"].bind(this),0);}};Core.MAX_RENDERING_ITERATIONS=20;Core.prototype.renderPendingUIUpdates=function(c){oRenderLog.debug("Render pending UI updates: start ("+(c||"by timer")+")");Measurement.start("renderPendingUIUpdates","Render pending UI updates in all UIAreas");var u=false,l=Core.MAX_RENDERING_ITERATIONS>0,L=0;this._bRendering=true;do{if(l){L++;if(L>Core.MAX_RENDERING_ITERATIONS){this._bRendering=false;throw new Error("Rendering has been re-started too many times ("+L+"). Add URL parameter sap-ui-xx-debugRendering=true for a detailed analysis.");}if(L>1){oRenderLog.debug("Render pending UI updates: iteration "+L);}}if(this._sRerenderTimer){if(this._sRerenderTimer!==this){clearTimeout(this._sRerenderTimer);}this._sRerenderTimer=undefined;}this.runPrerenderingTasks();var U=this.mUIAreas;for(var i in U){u=U[i].rerender()||u;}}while(l&&this._sRerenderTimer);this._bRendering=false;if(u){this.fireUIUpdated();}oRenderLog.debug("Render pending UI updates: finished");Measurement.end("renderPendingUIUpdates");};Core.prototype.getUIDirty=function(){return!!(this._sRerenderTimer||this._bRendering);};Core.prototype.attachUIUpdated=function(f,l){_oEventProvider.attachEvent(Core.M_EVENTS.UIUpdated,f,l);};Core.prototype.detachUIUpdated=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.UIUpdated,f,l);};Core.prototype.fireUIUpdated=function(p){_oEventProvider.fireEvent(Core.M_EVENTS.UIUpdated,p);};Core.prototype.notifyContentDensityChanged=function(){this.fireThemeChanged();};Core.prototype.attachThemeChanged=function(f,l){_oEventProvider.attachEvent(Core.M_EVENTS.ThemeChanged,f,l);};Core.prototype.detachThemeChanged=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.ThemeChanged,f,l);};Core.prototype.fireThemeChanged=function(p){getScrollbarSize(true);var P=sap.ui.require("sap/ui/core/theming/Parameters");if(P){P.reset(true);}p=p||{};if(!p.theme){p.theme=this.getConfiguration().getTheme();}var e=Core.M_EVENTS.ThemeChanged;var E=jQuery.Event(e);E.theme=p.theme;each(this.mElements,function(a){this.mElements[a]._handleEvent(E);},this);ActivityDetection.refresh();_oEventProvider.fireEvent(e,p);};Core.prototype.attachThemeScopingChanged=function(f,l){_oEventProvider.attachEvent(Core.M_EVENTS.ThemeScopingChanged,f,l);};Core.prototype.detachThemeScopingChanged=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.ThemeScopingChanged,f,l);};Core.prototype.fireThemeScopingChanged=function(p){_oEventProvider.fireEvent(Core.M_EVENTS.ThemeScopingChanged,p);};Core.prototype.attachLocalizationChanged=function(f,l){_oEventProvider.attachEvent(Core.M_EVENTS.LocalizationChanged,f,l);};Core.prototype.detachLocalizationChanged=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.LocalizationChanged,f,l);};Core.prototype.fireLocalizationChanged=function(c){var e=Core.M_EVENTS.LocalizationChanged,b=jQuery.Event(e,{changes:c}),a=ManagedObject._handleLocalizationChange;Log.info("localization settings changed: "+Object.keys(c).join(","),null,"sap.ui.core.Core");each(this.oModels,function(p){var m=this.oModels[p];if(m&&m._handleLocalizationChange){m._handleLocalizationChange();}},this);function n(p){each(this.mUIAreas,function(d){a.call(this.mUIAreas[d],p);},this);each(this.mObjects["component"],function(d){a.call(this.mObjects["component"][d],p);},this);each(this.mElements,function(d){a.call(this.mElements[d],p);},this);}n.call(this,1);n.call(this,2);if(c.rtl!=undefined){document.documentElement.setAttribute("dir",c.rtl?"rtl":"ltr");this._updateThemeUrls(this.sTheme);each(this.mUIAreas,function(p){this.mUIAreas[p].invalidate();},this);Log.info("RTL mode "+c.rtl?"activated":"deactivated");}each(this.mElements,function(p){this.mElements[p]._handleEvent(b);},this);_oEventProvider.fireEvent(e,{changes:c});};Core.prototype.attachLibraryChanged=function(f,l){_oEventProvider.attachEvent(Core.M_EVENTS.LibraryChanged,f,l);};Core.prototype.detachLibraryChanged=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.LibraryChanged,f,l);};Core.prototype.fireLibraryChanged=function(p){_oEventProvider.fireEvent(Core.M_EVENTS.LibraryChanged,p);};Core.prototype.applyChanges=function(){this.renderPendingUIUpdates("forced by applyChanges");};Core.prototype.registerElementClass=function(m){var n=m.getName(),l=m.getLibraryName()||"",L=this.mLibraries[l],c=Control.prototype.isPrototypeOf(m.getClass().prototype)?'controls':'elements';if(!L){ObjectPath.create(l);L=this.mLibraries[l]={name:l,dependencies:[],types:[],interfaces:[],controls:[],elements:[]};}if(L[c].indexOf(n)<0){L[c].push(n);Log.debug("Class "+m.getName()+" registered for library "+m.getLibraryName());this.fireLibraryChanged({name:m.getName(),stereotype:m.getStereotype(),operation:"add",metadata:m});}};Core.prototype.registerElement=function(e){var i=e.getId(),o=this.mElements[i];if(o&&o!==e){if(o._sapui_candidateForDestroy){Log.debug("destroying dangling template "+o+" when creating new object with same ID");o.destroy();}else{if(this.oConfiguration.getNoDuplicateIds()){Log.error("adding element with duplicate id '"+i+"'");throw new Error("Error: adding element with duplicate id '"+i+"'");}else{Log.warning("adding element with duplicate id '"+i+"'");}}}this.mElements[i]=e;};Core.prototype.deregisterElement=function(e){delete this.mElements[e.getId()];};Core.prototype.registerObject=function(o){var i=o.getId(),t=o.getMetadata().getStereotype(),a=this.getObject(t,i);if(a&&a!==o){Log.error("adding object \""+t+"\" with duplicate id '"+i+"'");throw new Error("Error: adding object \""+t+"\" with duplicate id '"+i+"'");}this.mObjects[t][i]=o;};Core.prototype.deregisterObject=function(o){var i=o.getId(),t=o.getMetadata().getStereotype();delete this.mObjects[t][i];};Core.prototype.byId=function(i){assert(i==null||typeof i==="string","sId must be a string when defined");return i==null?undefined:this.mElements[i];};Core.prototype.getControl=Core.prototype.byId;Core.prototype.getElementById=Core.prototype.byId;Core.prototype.getObject=function(t,i){assert(i==null||typeof i==="string","sId must be a string when defined");assert(this.mObjects[t]!==undefined,"sType must be a supported stereotype");return i==null?undefined:this.mObjects[t]&&this.mObjects[t][i];};Core.prototype.getComponent=function(i){return this.getObject("component",i);};Core.prototype.getTemplate=function(i){var T=sap.ui.requireSync('sap/ui/core/tmpl/Template');return T.byId(i);};Core.prototype.getStaticAreaRef=function(){var s=(STATIC_UIAREA_ID?document.getElementById(STATIC_UIAREA_ID):null),c;if(!s){s=document.createElement("div");c=this.getConfiguration();if(!this.bDomReady){throw new Error("DOM is not ready yet. Static UIArea cannot be created.");}s.setAttribute("id",STATIC_UIAREA_ID);if(document.body.getAttribute("role")!="application"&&!c.getAvoidAriaApplicationRole()){s.setAttribute("role","application");}Object.assign(s.style,{"height":"0","width":"0","overflow":"hidden","float":c.getRTL()?"right":"left"});document.body.insertBefore(s,document.body.firstChild);this.createUIArea(s).bInitial=false;}return s;};Core.prototype.isStaticAreaRef=function(d){return d&&(d.id===STATIC_UIAREA_ID);};Core._I_INTERVAL=200;ResizeHandler.prototype.I_INTERVAL=Core._I_INTERVAL;Core.prototype.attachIntervalTimer=function(f,l){if(!this.oTimedTrigger){var I=sap.ui.requireSync("sap/ui/core/IntervalTrigger");this.oTimedTrigger=new I(Core._I_INTERVAL);}this.oTimedTrigger.addListener(f,l);};Core.prototype.detachIntervalTimer=function(f,l){if(this.oTimedTrigger){this.oTimedTrigger.removeListener(f,l);}};Core.prototype.attachControlEvent=function(f,l){_oEventProvider.attachEvent(Core.M_EVENTS.ControlEvent,f,l);};Core.prototype.detachControlEvent=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.ControlEvent,f,l);};Core.prototype.fireControlEvent=function(p){_oEventProvider.fireEvent(Core.M_EVENTS.ControlEvent,p);};Core.prototype._handleControlEvent=function(e,u){var E=jQuery.Event(e.type);Object.assign(E,e);E.originalEvent=undefined;this.fireControlEvent({"browserEvent":E,"uiArea":u});};Core.prototype.getApplication=function(){return sap.ui.getApplication&&sap.ui.getApplication();};Core.prototype.registerPlugin=function(p){assert(typeof p==="object","oPlugin must be an object");if(!p){return;}for(var i=0,l=this.aPlugins.length;i<l;i++){if(this.aPlugins[i]===p){return;}}this.aPlugins.push(p);if(this.bInitialized&&p&&p.startPlugin){p.startPlugin(this);}};Core.prototype.unregisterPlugin=function(p){assert(typeof p==="object","oPlugin must be an object");if(!p){return;}var P=-1;for(var i=this.aPlugins.length;i--;i>=0){if(this.aPlugins[i]===p){P=i;break;}}if(P==-1){return;}if(this.bInitialized&&p&&p.stopPlugin){p.stopPlugin(this);}this.aPlugins.splice(P,1);};Core.prototype.startPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.startPlugin){p.startPlugin(this,true);}}};Core.prototype.stopPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.stopPlugin){p.stopPlugin(this);}}};Core.prototype.setModel=function(m,n){assert(m==null||BaseObject.isA(m,'sap.ui.model.Model'),"oModel must be an instance of sap.ui.model.Model, null or undefined");assert(n===undefined||(typeof n==="string"&&!/^(undefined|null)?$/.test(n)),"sName must be a string or omitted");var t=this,p;if(!m&&this.oModels[n]){delete this.oModels[n];if(isEmptyObject(t.oModels)&&isEmptyObject(t.oBindingContexts)){p=ManagedObject._oEmptyPropagatedProperties;}else{p={oModels:Object.assign({},t.oModels),oBindingContexts:{},aPropagationListeners:[]};}each(this.mUIAreas,function(a){var u=this.mUIAreas[a];if(m!=u.getModel(n)){u._propagateProperties(n,u,p,false,n);}},this);}else if(m&&m!==this.oModels[n]){this.oModels[n]=m;each(this.mUIAreas,function(a){var u=this.mUIAreas[a];if(m!=u.getModel(n)){var p={oModels:Object.assign({},this.oModels),oBindingContexts:{},aPropagationListeners:[]};u._propagateProperties(n,u,p,false,n);}},this);}return this;};Core.prototype.setMessageManager=function(m){this.oMessageManager=m;};Core.prototype.getMessageManager=function(){if(!this.oMessageManager){this.oMessageManager=new MessageManager();}return this.oMessageManager;};Core.prototype.byFieldGroupId=function(f){var r=[];for(var n in this.mElements){var e=this.mElements[n];if(e instanceof Control&&e.checkFieldGroupIds(f)){r.push(e);}}return r;};Core.prototype.getModel=function(n){assert(n===undefined||(typeof n==="string"&&!/^(undefined|null)?$/.test(n)),"sName must be a string or omitted");return this.oModels[n];};Core.prototype.hasModel=function(){return!isEmptyObject(this.oModels);};Core.prototype.getEventBus=function(){if(!this.oEventBus){var E=sap.ui.requireSync('sap/ui/core/EventBus');var e=this.oEventBus=new E();this._preserveHandler=function(a){e.publish("sap.ui","__preserveContent",{domNode:a.domNode});};RenderManager.attachPreserveContent(this._preserveHandler);}return this.oEventBus;};Core.prototype.attachValidationError=function(d,f,l){if(typeof(d)==="function"){l=f;f=d;d=undefined;}_oEventProvider.attachEvent(Core.M_EVENTS.ValidationError,d,f,l);return this;};Core.prototype.detachValidationError=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.ValidationError,f,l);return this;};Core.prototype.attachParseError=function(d,f,l){if(typeof(d)==="function"){l=f;f=d;d=undefined;}_oEventProvider.attachEvent(Core.M_EVENTS.ParseError,d,f,l);return this;};Core.prototype.detachParseError=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.ParseError,f,l);return this;};Core.prototype.attachFormatError=function(d,f,l){if(typeof(d)==="function"){l=f;f=d;d=undefined;}_oEventProvider.attachEvent(Core.M_EVENTS.FormatError,d,f,l);return this;};Core.prototype.detachFormatError=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.FormatError,f,l);return this;};Core.prototype.attachValidationSuccess=function(d,f,l){if(typeof(d)==="function"){l=f;f=d;d=undefined;}_oEventProvider.attachEvent(Core.M_EVENTS.ValidationSuccess,d,f,l);return this;};Core.prototype.detachValidationSuccess=function(f,l){_oEventProvider.detachEvent(Core.M_EVENTS.ValidationSuccess,f,l);return this;};Core.prototype.fireParseError=function(a){_oEventProvider.fireEvent(Core.M_EVENTS.ParseError,a);return this;};Core.prototype.fireValidationError=function(a){_oEventProvider.fireEvent(Core.M_EVENTS.ValidationError,a);return this;};Core.prototype.fireFormatError=function(a){_oEventProvider.fireEvent(Core.M_EVENTS.FormatError,a);return this;};Core.prototype.fireValidationSuccess=function(a){_oEventProvider.fireEvent(Core.M_EVENTS.ValidationSuccess,a);return this;};Core.prototype.isMobile=function(){return Device.browser.mobile;};Core.prototype._getEventProvider=function(){return _oEventProvider;};Core.prototype.addPrerenderingTask=function(p,f){if(f){this.aPrerenderingTasks.unshift(p);}else{this.aPrerenderingTasks.push(p);}this.addInvalidatedUIArea();};Core.prototype.runPrerenderingTasks=function(){var t=this.aPrerenderingTasks.slice();this.aPrerenderingTasks=[];t.forEach(function(p){p();});};Core.prototype.destroy=function(){RenderManager.detachPreserveContent(this._preserveHandler);this.oFocusHandler.destroy();_oEventProvider.destroy();BaseObject.prototype.destroy.call(this);};sap.ui.setRoot=function(d,c){assert(typeof d==="string"||typeof d==="object","oDomRef must be a string or object");assert(c instanceof Interface||c instanceof Control,"oControl must be a Control or Interface");sap.ui.getCore().setRoot(d,c);};return new Core().getInterface();});
