/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./LabelEnablement','sap/ui/base/Object','sap/ui/dom/patch','sap/ui/performance/trace/Interaction','sap/base/util/uid',"sap/ui/util/ActivityDetection","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/assert","sap/ui/performance/Measurement","sap/base/Log"],function(L,B,d,I,u,A,q,a,b,M,c){"use strict";var C=["renderControl","write","writeEscaped","translate","writeAcceleratorKey","writeControlData","writeInvisiblePlaceholderData","writeElementData","writeAttribute","writeAttributeEscaped","addClass","writeClasses","addStyle","writeStyles","writeAccessibilityState","writeIcon","getConfiguration","getHTML","cleanupControlWithoutRendering"];var N=["render","flush","destroy"];function R(){var l=this,F,p,v,S,x,y;this._setFocusHandler=function(n){b(n&&B.isA(n,'sap.ui.core.FocusHandler'),"oFocusHandler must be an sap.ui.core.FocusHandler");F=n;};function z(){p=l.aBuffer=[];v=l.aRenderedControls=[];S=l.aStyleStack=[{}];}this.write=function(T){b((typeof T==="string")||(typeof T==="number"),"sText must be a string or number");p.push.apply(p,arguments);return this;};this.writeEscaped=function(T,e){if(T!=null){T=a(String(T));if(e){T=T.replace(/&#xa;/g,"<br>");}p.push(T);}return this;};this.writeAttribute=function(n,V){b(typeof n==="string","sName must be a string");b(typeof V==="string"||typeof V==="number"||typeof V==="boolean","value must be a string, number or boolean");p.push(" ",n,"=\"",V,"\"");return this;};this.writeAttributeEscaped=function(n,V){b(typeof n==="string","sName must be a string");p.push(" ",n,"=\"",a(String(V)),"\"");return this;};this.addStyle=function(n,e){b(typeof n==="string","sName must be a string");if(e!=null){b((typeof e==="string"||typeof e==="number"),"value must be a string or number");var i=S[S.length-1];if(!i.aStyle){i.aStyle=[];}i.aStyle.push(n+":"+e);}return this;};this.writeStyles=function(){var e=S[S.length-1];if(e.aStyle){this.write(" style=\""+e.aStyle.join(";")+"\" ");}e.aStyle=null;return this;};this.addClass=function(n){if(n){b(typeof n==="string","sName must be a string");var e=S[S.length-1];if(!e.aClasses){e.aClasses=[];}e.aClasses.push(n);}return this;};this.writeClasses=function(e){b(!e||typeof e==="boolean"||B.isA(e,'sap.ui.core.Element'),"oElement must be empty, a boolean, or an sap.ui.core.Element");var j=S[S.length-1];var O;if(e){O=e.aCustomStyleClasses;}else if(e===false){O=[];}else{O=j.aCustomStyleClasses;}if(j.aClasses||O){var Q=[].concat(j.aClasses||[],O||[]);Q.sort();Q=Q.filter(function(n,i){return i==0||n!==Q[i-1];});this.write(" class=\"",Q.join(" "),"\" ");}if(!e){j.aCustomStyleClasses=null;}j.aClasses=null;return this;};function E(e){y=true;try{var i=q.Event("BeforeRendering");i.srcControl=e;e._handleEvent(i);}finally{y=false;}}this.cleanupControlWithoutRendering=function(e){b(!e||B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control or empty");if(!e||!e.getDomRef()){return;}E(e);e.bOutput=false;};this.renderControl=function(e){b(!e||B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control or empty");if(!e){return this;}if(!x){x=[];}if(x&&x.length>0){M.pause(x[0]+"---renderControl");}else if(e.getParent()&&e.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){M.pause(e.getParent().getId()+"---rerender");}x.unshift(e.getId());M.start(e.getId()+"---renderControl","Rendering of "+e.getMetadata().getName(),["rendering","control"]);var j=p.length;var n={};if(e.aCustomStyleClasses&&e.aCustomStyleClasses.length>0){n.aCustomStyleClasses=e.aCustomStyleClasses;}S.push(n);M.pause(e.getId()+"---renderControl");var O;var Q=e.getMetadata();var V=e.getVisible();if(V){O=Q.getRenderer();}else{var T=Q.getProperty("visible");var U=T&&T._oParent&&T._oParent.getName()=="sap.ui.core.Control";O=U?w:Q.getRenderer();}M.resume(e.getId()+"---renderControl");E(e);var W=e.aBindParameters;if(W&&W.length>0){var X=q(e.getDomRef());if(X&&X[0]){for(var i=0;i<W.length;i++){var Y=W[i];X.unbind(Y.sEventType,Y.fnProxy);}}}if(O&&typeof O.render==="function"){O.render(J,e);}else{c.error("The renderer for class "+Q.getName()+" is not defined or does not define a render function! Rendering of "+e.getId()+" will be skipped!");}S.pop();v.push(e);if(e.getUIArea&&e.getUIArea()){e.getUIArea()._onControlRendered(e);}e.bOutput=p.length!=j;if(O===w){e.bOutput="invisible";}M.end(e.getId()+"---renderControl");x.shift();if(x&&x.length>0){M.resume(x[0]+"---renderControl");}else if(e.getParent()&&e.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){M.resume(e.getParent().getId()+"---rerender");}return this;};this.getHTML=function(e){b(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");var i=p;var j=p=this.aBuffer=[];this.renderControl(e);p=this.aBuffer=i;return j.join("");};function G(n){var i,O=v.length;for(i=0;i<O;i++){v[i]._sapui_bInAfterRenderingPhase=true;}y=true;try{for(i=0;i<O;i++){var Q=v[i];if(Q.bOutput&&Q.bOutput!=="invisible"){var T=q.Event("AfterRendering");T.srcControl=Q;M.start(Q.getId()+"---AfterRendering","AfterRendering of "+Q.getMetadata().getName(),["rendering","after"]);Q._handleEvent(T);M.end(Q.getId()+"---AfterRendering");}}}finally{for(i=0;i<O;i++){delete v[i]._sapui_bInAfterRenderingPhase;}y=false;}try{F.restoreFocus(n);}catch(e){c.warning("Problems while restoring the focus after rendering: "+e,null);}for(i=0;i<O;i++){var Q=v[i],U=Q.aBindParameters;if(U&&U.length>0){var V=q(Q.getDomRef());if(V&&V[0]){for(var j=0;j<U.length;j++){var W=U[j];V.bind(W.sEventType,W.fnProxy);}}}}}function H(e){var i=F?F.getControlFocusInfo():null;var j=p.join("");e(j);G(i);z();A.refresh();I.notifyStepEnd();}this.flush=function(T,e,j){b((typeof T==="object")&&(T.ownerDocument==document),"oTargetDomNode must be a DOM element");if(!e&&(typeof j!=="number")&&!j){R.preserveContent(T);}H(function(n){for(var i=0;i<v.length;i++){var O=v[i].getDomRef();if(O&&!R.isPreservedContent(O)){if(R.isInlineTemplate(O)){q(O).empty();}else{q(O).remove();}}}if(typeof j==="number"){if(j<=0){q(T).prepend(n);}else{var $=q(T).children().eq(j-1);if($.length===1){$.after(n);}else{q(T).append(n);}}}else if(!j){q(T).html(n);}else{q(T).append(n);}});};this.render=function(e,T){b(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be a control");b(typeof T==="object"&&T.ownerDocument==document,"oTargetDomNode must be a DOM element");if(y){c.error("Render must not be called within Before or After Rendering Phase. Call ignored.",null,this);return;}z();this.renderControl(e);H(function(i){if(e&&T){var j=e.getDomRef();if(!j||R.isPreservedContent(j)){j=((f.Invisible+e.getId()?window.document.getElementById(f.Invisible+e.getId()):null))||((f.Dummy+e.getId()?window.document.getElementById(f.Dummy+e.getId()):null));}var n=j&&j.parentNode!=T;var O=function(){var U=q(T);if(T.innerHTML==""){U.html(i);}else{U.append(i);}};if(n){if(!R.isPreservedContent(j)){if(R.isInlineTemplate(j)){q(j).empty();}else{q(j).remove();}}if(i){O();}}else{if(i){if(j){if(R.isInlineTemplate(j)){q(j).html(i);}else if(t()){var Q=q.parseHTML(i)[0];q.cleanData([j]);q.cleanData(j.getElementsByTagName("*"));d(j,Q);}else{q(j).replaceWith(i);}}else{O();}}else{if(R.isInlineTemplate(j)){q(j).empty();}else{if(!e.getParent()||!e.getParent()._onChildRerenderedEmpty||!e.getParent()._onChildRerenderedEmpty(e,j)){q(j).remove();}}}}}});};this.destroy=function(){z();};var J={};var K={};C.forEach(function(e){J[e]=K[e]=l[e];});N.forEach(function(e){K[e]=l[e];});this.getRendererInterface=function(){return J;};this.getInterface=function(){return K;};z();}R.prototype.getConfiguration=function(){return sap.ui.getCore().getConfiguration();};R.prototype.translate=function(K){};R.prototype.writeAcceleratorKey=function(){return this;};R.prototype.writeControlData=function(e){b(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");this.writeElementData(e);return this;};R.prototype.writeInvisiblePlaceholderData=function(e){b(B.isA(e,'sap.ui.core.Element'),"oElement must be an instance of sap.ui.core.Element");var p=R.createInvisiblePlaceholderId(e),i=' '+'id="'+p+'" '+'class="sapUiHiddenPlaceholder" '+'data-sap-ui="'+p+'" '+'style="display: none;"'+'aria-hidden="true" ';this.write(i);return this;};R.prototype.writeElementData=function(e){b(e&&B.isA(e,'sap.ui.core.Element'),"oElement must be an sap.ui.core.Element");var j=e.getId();if(j){this.writeAttribute("id",j).writeAttribute("data-sap-ui",j);}var n=e.getCustomData();var l=n.length;for(var i=0;i<l;i++){var p=n[i]._checkWriteToDom(e);if(p){this.writeAttributeEscaped(p.key,p.value);}}var v=e.getDragDropConfig().some(function(y){return y.isDraggable(e);});if(!v){var x=e.getParent();if(x&&x.getDragDropConfig){v=x.getDragDropConfig().some(function(y){return y.isDraggable(e);});}}if(v){this.writeAttribute("draggable","true");this.writeAttribute("data-sap-ui-draggable","true");}return this;};R.prototype.writeAccessibilityState=function(e,j){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return this;}if(arguments.length==1&&!(B.isA(e,'sap.ui.core.Element'))){j=e;e=null;}var l={};if(e!=null){var n=e.getMetadata();var y=function(i,v,V){var J=n.getProperty(i);if(J&&e[J._sGetter]()===V){l[v]="true";}};var z=function(v,J){var K=n.getAssociation(v);if(K&&K.multiple){var O=e[K._sGetter]();if(v=="ariaLabelledBy"){var Q=L.getReferencingLabels(e);var S=Q.length;if(S){var T=[];for(var i=0;i<S;i++){if(O.indexOf(Q[i])<0){T.push(Q[i]);}}O=T.concat(O);}}if(O.length>0){l[J]=O.join(" ");}}};y("editable","readonly",false);y("enabled","disabled",false);y("visible","hidden",false);if(L.isRequired(e)){l["required"]="true";}y("selected","selected",true);y("checked","checked",true);z("ariaDescribedBy","describedby");z("ariaLabelledBy","labelledby");}if(j){var E=function(v){var i=typeof(v);return v===null||v===""||i==="number"||i==="string"||i==="boolean";};var F={};var x,G,H;for(x in j){G=j[x];if(E(G)){F[x]=G;}else if(typeof(G)==="object"&&E(G.value)){H="";if(G.append&&(x==="describedby"||x==="labelledby")){H=l[x]?l[x]+" ":"";}F[x]=H+G.value;}}q.extend(l,F);}if(B.isA(e,'sap.ui.core.Element')&&e.getParent()&&e.getParent().enhanceAccessibilityState){e.getParent().enhanceAccessibilityState(e,l);}for(var p in l){if(l[p]!=null&&l[p]!==""){this.writeAttributeEscaped(p==="role"?p:"aria-"+p,l[p]);}}return this;};R.prototype.writeIcon=function(U,e,i){var j=sap.ui.requireSync("sap/ui/core/IconPool"),l=j.isIconURI(U),S=l?"<span ":"<img ",n=false,p,v,x,y,z,E;if(typeof e==="string"){e=[e];}if(l){x=j.getIconInfo(U);if(!x){c.error("An unregistered icon: "+U+" is used in sap.ui.core.RenderManager's writeIcon method.");return this;}if(!e){e=[];}e.push("sapUiIcon");if(!x.suppressMirroring){e.push("sapUiIconMirrorInRTL");}}this.write(S);if(Array.isArray(e)&&e.length){p=e.join(" ");this.write("class=\""+p+"\" ");}if(l){y={"data-sap-ui-icon-content":x.content,"role":"presentation","title":x.text||null};this.write("style=\"font-family: '"+a(x.fontFamily)+"';\" ");}else{y={role:"presentation",alt:"",src:U};}i=q.extend(y,i);if(!i.id){i.id=u();}if(l){z=i.alt||i.title||x.text||x.name;E=i.id+"-label";if(i["aria-labelledby"]){n=true;i["aria-labelledby"]+=(" "+E);}else if(!i.hasOwnProperty("aria-label")){i["aria-label"]=z;}}if(typeof i==="object"){for(v in i){if(i.hasOwnProperty(v)&&i[v]!==null){this.writeAttributeEscaped(v,i[v]);}}}if(l){this.write(">");if(n){this.write("<span style=\"display:none;\" id=\""+E+"\">"+a(z)+"</span>");}this.write("</span>");}else{this.write("/>");}return this;};R.prototype.getRenderer=function(e){b(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");return R.getRenderer(e);};var f=R.RenderPrefixes={Invisible:"sap-ui-invisible-",Dummy:"sap-ui-dummy-",Temporary:"sap-ui-tmp-"};R.getRenderer=function(e){b(e&&B.isA(e,'sap.ui.core.Control'),"oControl must be an sap.ui.core.Control");return e.getMetadata().getRenderer();};R.forceRepaint=function(v){var e=v?window.document.getElementById(v):null;var i=typeof v=="string"?e:v;if(i){c.debug("forcing a repaint for "+(i.id||String(i)));var O=i.style.display;var j=document.activeElement;i.style.display="none";i.offsetHeight;i.style.display=O;if(document.activeElement!==j&&j){j.focus();}}};R.createInvisiblePlaceholderId=function(e){return f.Invisible+e.getId();};var g="sap-ui-preserve",h="sap-ui-static",k="data-sap-ui-preserve",m="data-sap-ui-area";function o(){var $=q(document.getElementById(g));if($.length===0){$=q("<DIV/>",{"aria-hidden":"true",id:g}).addClass("sapUiHidden").addClass("sapUiForcedHidden").css("width","0").css("height","0").css("overflow","hidden").appendTo(document.body);}return $;}function r(n){q("<DIV/>",{id:f.Dummy+n.id}).addClass("sapUiHidden").insertBefore(n);}var P=[];R.attachPreserveContent=function(l,e){R.detachPreserveContent(l);P.push({fn:l,context:e});};R.detachPreserveContent=function(l){P=P.filter(function(e){return e.fn!==l;});};R.preserveContent=function(e,p,j){b(typeof e==="object"&&e.ownerDocument==document,"oRootNode must be a DOM element");P.forEach(function(i){i.fn.call(i.context||R,{domNode:e});});var $=o();function n(i){while(i&&i!=e&&i.parentNode){i=i.parentNode;if(i.hasAttribute(k)){return true;}if(i.hasAttribute("data-sap-ui")){break;}}}function l(i){if(i.id===g||i.id===h){return;}if(i.hasAttribute(k)){if(i===e||n(i)){r(i);}$.append(i);}else if(j&&i.id){R.markPreservableContent(q(i),i.id);$.append(i);return;}if(!i.hasAttribute(m)){var v=i.firstChild;while(v){i=v;v=v.nextSibling;if(i.nodeType===1){l(i);}}}}M.start(e.id+"---preserveContent","preserveContent for "+e.id,["rendering","preserve"]);if(p){l(e);}else{q(e).children().each(function(i,v){l(v);});}M.end(e.id+"---preserveContent");};R.findPreservedContent=function(i){b(typeof i==="string","sId must be a string");var $=o(),e=$.children("["+k+"='"+i.replace(/(:|\.)/g,'\\$1')+"']");return e;};R.markPreservableContent=function($,i){$.attr(k,i);};R.isPreservedContent=function(e){return(e&&e.getAttribute(k)&&e.parentNode&&e.parentNode.id==g);};R.getPreserveAreaRef=function(){return o()[0];};var s="data-sap-ui-template";R.markInlineTemplate=function($){$.attr(s,"");};R.isInlineTemplate=function(e){return(e&&e.hasAttribute(s));};var D;function t(){if(D===undefined){D=sap.ui.getCore().getConfiguration().getDomPatching();if(D){c.warning("DOM Patching is enabled: This feature should be used only for testing purposes!");}}return D;}var w={render:function(e,i){e.write("<span");e.writeInvisiblePlaceholderData(i);e.write("></span>");}};return R;},true);
