/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/base/DataType','sap/ui/base/ManagedObject','sap/ui/core/CustomData','./mvc/View','./mvc/EventHandlerResolver','./ExtensionPoint','./StashedControlSupport','sap/ui/base/SyncPromise','sap/base/Log','sap/base/util/ObjectPath','sap/base/assert','sap/base/security/encodeXML','sap/base/util/LoaderExtensions'],function(q,D,M,C,V,E,a,S,b,L,O,c,d,f){"use strict";function p(t,v,n,o){var B=M.bindingParser(v,o,true);if(B&&typeof B==="object"){return B;}var e=v=B||v;var T=D.getType(t);if(T){if(T instanceof D){e=T.parseValue(v,{context:o});if(!T.isValid(e)){L.error("Value '"+v+"' is not valid for type '"+T.getName()+"'.");}}}else{throw new Error("Property "+n+" has unknown type "+t);}return typeof e==="string"?M.bindingParser.escape(e):e;}function l(x){return x.localName||x.baseName||x.nodeName;}function u(e){if(e.isRejected()){throw e.getResult();}return e.getResult();}function g(A,e){function s(n,o,m){var j,v,k=[];for(j=n.firstChild;j;j=j.nextSibling){v=e(n,o,m,j);if(v){k.push(u(v));}}return b.resolve(k);}function i(n,o,m){var j,k=Promise.resolve(),r=[];for(j=n.firstChild;j;j=j.nextSibling){k=k.then(e.bind(null,n,o,m,j));r.push(k);}return Promise.all(r);}return A?i:s;}var X={};X.loadTemplate=function(t,e){var r=t.replace(/\./g,"/")+("."+(e||"view")+".xml");return f.loadResource(r).documentElement;};X.loadTemplatePromise=function(t,e){var r=t.replace(/\./g,"/")+("."+(e||"view")+".xml");return f.loadResource(r,{async:true}).then(function(R){return R.documentElement;});};X.parseViewAttributes=function(x,v,s){var A=v.getMetadata().getAllProperties();for(var i=0;i<x.attributes.length;i++){var e=x.attributes[i];if(e.name==='controllerName'){v._controllerName=e.value;}else if(e.name==='resourceBundleName'){v._resourceBundleName=e.value;}else if(e.name==='resourceBundleUrl'){v._resourceBundleUrl=e.value;}else if(e.name==='resourceBundleLocale'){v._resourceBundleLocale=e.value;}else if(e.name==='resourceBundleAlias'){v._resourceBundleAlias=e.value;}else if(e.name==='class'){v.addStyleClass(e.value);}else if(!s[e.name]&&A[e.name]){s[e.name]=p(A[e.name].type,e.value,e.name,v._oContainingView.oController);}}};X.enrichTemplateIds=function(x,v){X.enrichTemplateIdsPromise(x,v,false);return x;};X.enrichTemplateIdsPromise=function(x,v,A){return h(x,v,true,A).then(function(){return x;});};X.parseTemplate=function(x,v){return u(X.parseTemplatePromise(x,v,false));};X.parseTemplatePromise=function(x,v,A,P){return h(x,v,false,A,P);};function h(x,v,k,A,P){var r=[],m=b.resolve(),s=v._sProcessingMode||sap.ui.getCore().getConfiguration().getXMLProcessingMode();A=A&&s==="sequential";L.debug("XML processing mode is "+(A?"sequential":"default"),"","XMLTemplateProcessor");var n=sap.ui.getCore().getConfiguration().getDesignMode();if(n){v._sapui_declarativeSourceInfo={xmlNode:x,xmlRootNode:v._oContainingView===v?x:v._oContainingView._sapui_declarativeSourceInfo.xmlRootNode};}var o=v.sViewName||v._sFragmentName;if(!o){var t=v;var w=0;while(++w<1000&&t&&t!==t._oContainingView){t=t._oContainingView;}o=t.sViewName;}if(v.isSubView()){G(x,true);}else{if(x.localName==="View"&&x.namespaceURI!=="sap.ui.core.mvc"){L.warning("XMLView root node must have the 'sap.ui.core.mvc' namespace, not '"+x.namespaceURI+"'"+(o?" (View name: "+o+")":""));}H(x);}var i=0;function y(){for(;i<r.length;i++){var e=r[i];if(e&&typeof e.then==='function'){return e.then(z).then(y);}}return r;}function z(e){var j=[i,1].concat(e);Array.prototype.splice.apply(r,j);}return m.then(y);function B(e){return e;}function F(e){return v._oContainingView.createId(e);}function G(x,e,j){if(x.nodeType===1){var T=l(x);if(x.namespaceURI==="http://www.w3.org/1999/xhtml"||x.namespaceURI==="http://www.w3.org/2000/svg"){r.push("<"+T+" ");var U=false;for(var i=0;i<x.attributes.length;i++){var W=x.attributes[i];var Y=W.value;if(W.name==="id"){U=true;Y=Q(v,x);}r.push(W.name+"=\""+d(Y)+"\" ");}if(e===true){r.push("data-sap-ui-preserve"+"=\""+v.getId()+"\" ");if(!U){r.push("id"+"=\""+v.getId()+"\" ");}}r.push(">");var Z=x;if(window.HTMLTemplateElement&&x instanceof HTMLTemplateElement&&x.content instanceof DocumentFragment){Z=x.content;}H(Z);r.push("</"+T+">");}else if(T==="FragmentDefinition"&&x.namespaceURI==="sap.ui.core"){H(x,false,true);}else{m=m.then(function(){return K(x).then(function(a1){for(var i=0;i<a1.length;i++){var b1=a1[i];if(v.getMetadata().hasAggregation("content")){v.addAggregation("content",b1);}else if(v.getMetadata().hasAssociation(("content"))){v.addAssociation("content",b1);}}return a1;});});r.push(m);}}else if(x.nodeType===3&&!j){var $=x.textContent||x.text,_=l(x.parentNode);if($){if(_!="style"){$=d($);}r.push($);}}}function H(x,e,j){var T=x.childNodes;for(var i=0;i<T.length;i++){G(T[i],e,j);}}function I(e,j){var T;var U=sap.ui.getCore().getLoadedLibraries();q.each(U,function($,_){if(e===_.namespace||e===_.name){T=_.name+"."+((_.tagNames&&_.tagNames[j])||j);}});T=T||e+"."+j;function W(Z){if(!Z){L.error("Control '"+T+"' did not return a class definition from sap.ui.define.","","XMLTemplateProcessor");Z=O.get(T);}if(!Z){L.error("Can't find object class '"+T+"' for XML-view","","XMLTemplateProcessor");}return Z;}var Y=T.replace(/\./g,"/");var Z=sap.ui.require(Y);if(!Z){if(A){return new Promise(function($){sap.ui.require([Y],function(Z){Z=W(Z);$(Z);});});}else{Z=sap.ui.requireSync(Y);Z=W(Z);}}return Z;}function J(e){if(e.namespaceURI==="http://www.w3.org/1999/xhtml"||e.namespaceURI==="http://www.w3.org/2000/svg"){var j=e.attributes['id']?e.attributes['id'].textContent||e.attributes['id'].text:null;if(k){return X.enrichTemplateIdsPromise(e,v,A).then(function(){return[];});}else{var T=function(W){var Y={id:j?Q(v,e,j):undefined,xmlNode:e,containingView:v._oContainingView};if(v.fnScopedRunWithOwner){return v.fnScopedRunWithOwner(function(){return new W(Y);});}return new W(Y);};if(A){return new Promise(function(W,Y){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(U){W([T(U)]);});});}else{var U=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return b.resolve([T(U)]);}}}else{return K(e);}}function K(e){if(l(e)==="ExtensionPoint"&&e.namespaceURI==="sap.ui.core"){if(k){return b.resolve([]);}else{var j=v instanceof V?v._oContainingView:v;var T=a._factory.bind(null,j,e.getAttribute("name"),function(){var W=b.resolve();var Y=[];var Z=e.childNodes;for(var i=0;i<Z.length;i++){var $=Z[i];if($.nodeType===1){W=W.then(J.bind(null,$));Y.push(W);}}return b.all(Y).then(function(_){var a1=[];_.forEach(function(b1){a1=a1.concat(b1);});return a1;});});return b.resolve(v.fnScopedRunWithOwner?v.fnScopedRunWithOwner(T):T());}}else{var U=I(e.namespaceURI,l(e));if(U&&typeof U.then==='function'){return U.then(function(W){return N(e,W);});}else{return N(e,U);}}}function N(T,U){var W=T.namespaceURI,Y={},Z="",$=[],_=null,a1=null;if(!U){return b.resolve([]);}var b1=U.getMetadata();var c1=b1.getAllSettings();if(!k){for(var i=0;i<T.attributes.length;i++){var d1=T.attributes[i],e1=d1.name,f1=c1[e1],g1=d1.value;if(e1==="id"){Y[e1]=Q(v,T,g1);}else if(e1==="class"){Z+=g1;}else if(e1==="viewName"){Y[e1]=g1;}else if(e1==="fragmentName"){Y[e1]=g1;Y['containingView']=v._oContainingView;}else if((e1==="binding"&&!f1)||e1==='objectBindings'){var h1=M.bindingParser(g1,v._oContainingView.oController);if(h1){Y.objectBindings=Y.objectBindings||{};Y.objectBindings[h1.model||undefined]=h1;}}else if(e1==='metadataContexts'){var i1=null;try{i1=X._calculatedModelMapping(g1,v._oContainingView.oController,true);}catch(e){L.error(v+":"+e.message);}if(i1){Y.metadataContexts=i1;if(X._preprocessMetadataContexts){X._preprocessMetadataContexts(U.getMetadata().getName(),Y,v._oContainingView.oController);}}}else if(e1.indexOf(":")>-1){if(d1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"){var j1=l(d1);$.push(new C({key:j1,value:p("any",g1,j1,v._oContainingView.oController)}));}else if(d1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1"){a1=g1;}else if(e1.indexOf("xmlns:")!==0){if(!_){_={};}if(!_.hasOwnProperty(d1.namespaceURI)){_[d1.namespaceURI]={};}_[d1.namespaceURI][l(d1)]=d1.nodeValue;L.debug(v+": XMLView parser encountered unknown attribute '"+e1+"' (value: '"+g1+"') with unknown namespace, stored as sap-ui-custom-settings of customData");}}else if(f1&&f1._iKind===0){Y[e1]=p(f1.type,g1,e1,v._oContainingView.oController);}else if(f1&&f1._iKind===1&&f1.altTypes){Y[e1]=p(f1.altTypes[0],g1,e1,v._oContainingView.oController);}else if(f1&&f1._iKind===2){var h1=M.bindingParser(g1,v._oContainingView.oController);if(h1){Y[e1]=h1;}else{L.error(v+": aggregations with cardinality 0..n only allow binding paths as attribute value (wrong value: "+e1+"='"+g1+"')");}}else if(f1&&f1._iKind===3){Y[e1]=F(g1);}else if(f1&&f1._iKind===4){Y[e1]=g1.split(/[\s,]+/g).filter(B).map(F);}else if(f1&&f1._iKind===5){var k1=E.resolveEventHandler(g1,v._oContainingView.oController);if(k1){Y[e1]=k1;}else{L.warning(v+": event handler function \""+g1+"\" is not a function or does not exist in the controller.");}}else if(f1&&f1._iKind===-1){if(V.prototype.isPrototypeOf(U.prototype)&&e1=="async"){Y[e1]=p(f1.type,g1,e1,v._oContainingView.oController);}else{L.warning(v+": setting '"+e1+"' for class "+b1.getName()+" (value:'"+g1+"') is not supported");}}else{c(e1==='xmlns',v+": encountered unknown setting '"+e1+"' for class "+b1.getName()+" (value:'"+g1+"')");if(X._supportInfo){X._supportInfo({context:T,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+e1+"' for class "+b1.getName()}});}}}if(_){$.push(new C({key:"sap-ui-custom-settings",value:_}));}if($.length>0){Y.customData=$;}}var l1=g(A,m1);function m1(T,n1,o1,p1,q1){var r1;if(p1.nodeType===1){if(p1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1"){Y[l(p1)]=p1.querySelector("*");return;}r1=p1.namespaceURI===W&&o1&&o1[l(p1)];if(r1){return l1(p1,r1);}else if(n1){if(!q1&&p1.getAttribute("stashed")==="true"&&!k){S.createStashedControl(Q(v,p1),{sParentId:Y["id"],sParentAggregationName:n1.name,fnCreate:function(){var j=A;A=false;try{return u(m1(T,n1,o1,p1,true));}finally{A=j;}}});return;}return J(p1).then(function(s1){for(var j=0;j<s1.length;j++){var t1=s1[j];var u1=n1.name;if(n1.multiple){if(!Y[u1]){Y[u1]=[];}if(typeof Y[u1].path==="string"){c(!Y[u1].template,"list bindings support only a single template object");Y[u1].template=t1;}else{Y[u1].push(t1);}}else{c(!Y[u1],"multiple aggregates defined for aggregation with cardinality 0..1");Y[u1]=t1;}}return s1;});}else if(l(T)!=="FragmentDefinition"||T.namespaceURI!=="sap.ui.core"){throw new Error("Cannot add direct child without default aggregation defined for control "+b1.getElementName());}}else if(p1.nodeType===3){if(q.trim(p1.textContent||p1.text)){throw new Error("Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed: "+q.trim(p1.textContent||p1.text));}}}var n1=b1.getDefaultAggregation();var o1=b1.getAllAggregations();return l1(T,n1,o1).then(function(){var j;if(k&&T.hasAttribute("id")){R(v,T);}else if(!k){if(V.prototype.isPrototypeOf(U.prototype)&&typeof U._sType==="string"){var p1=function(){return V._legacyCreate(Y,undefined,U._sType);};if(v.fnScopedRunWithOwner){j=v.fnScopedRunWithOwner(p1);}else{j=p1();}}else{var q1=function(){if(v.fnScopedRunWithOwner){return v.fnScopedRunWithOwner(function(){return new U(Y);});}else{return new U(Y);}};if(P&&P.fnRunWithPreprocessor){j=P.fnRunWithPreprocessor(q1);}else{j=q1();}}if(Z&&j.addStyleClass){j.addStyleClass(Z);}}if(!j){j=[];}else if(!Array.isArray(j)){j=[j];}if(X._supportInfo&&j){for(var i=0,r1=j.length;i<r1;i++){var s1=j[i];if(s1&&s1.getId()){var t1=X._supportInfo({context:T,env:{caller:"createRegularControls",nodeid:T.getAttribute("id"),controlid:s1.getId()}}),u1=a1?a1+",":"";u1+=t1;X._supportInfo.addSupportInfo(s1.getId(),u1);}}}if(n){j.forEach(function(s1){if(b1.getCompositeAggregationName){var v1=T.getElementsByTagName(s1.getMetadata().getCompositeAggregationName());for(var i=0;i<v1.length;i++){T.removeChild(v1[0]);}}s1._sapui_declarativeSourceInfo={xmlNode:T,xmlRootNode:v._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:b1.getName()==='sap.ui.core.Fragment'?Y['fragmentName']:null};});}return j;});}function Q(v,x,e){if(x.getAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id")){return x.getAttribute("id");}else{return F(e?e:x.getAttribute("id"));}}function R(v,x){x.setAttribute("id",F(x.getAttribute("id")));x.setAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id",true);}}X._preprocessMetadataContexts=null;X._calculatedModelMapping=function(B,o,A){var e,m={},j=M.bindingParser(B,o);function k(F){if(F.length%2===0){throw new Error("The last entry is no binding");}for(var i=1;i<=F.length;i=i+2){if(typeof F[i-1]=='string'){throw new Error("Binding expected not a string");}if(F[i]){if((typeof F[i]!='string')||(F[i]!=",")){throw new Error("Missing delimiter ','");}}}}if(j){if(!j.formatter){e=j;j={parts:[e]};}else{k(j.formatter.textFragments);}for(var i=0;i<j.parts.length;i++){e=j.parts[i];m[e.model]=m[e.model]||(A?[]:null);if(Array.isArray(m[e.model])){m[e.model].push(e);}else{m[e.model]=e;}}}return m;};return X;},true);
