/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/documentation/library',["sap/ui/thirdparty/jquery",'sap/ui/core/util/LibraryInfo',"sap/base/Log",'sap/ui/core/library','sap/m/library'],function(q,L,a){'use strict';sap.ui.getCore().initLibrary({name:'sap.ui.documentation',version:'1.60.20',dependencies:['sap.ui.core','sap.m'],types:[],interfaces:[],controls:["sap.ui.documentation.sdk.controls.Search","sap.ui.documentation.sdk.controls.ObjectPageSubSection","sap.ui.documentation.sdk.controls.LightTable","sap.ui.documentation.sdk.controls.Row"],elements:[],noLibraryCSS:true});var t=sap.ui.documentation;var _;
t._getLicense=function(){var u="./LICENSE.txt";return q.ajax({url:u,dataType:"text"});};
t._getAppInfo=function(c){var u=sap.ui.resource("","sap-ui-version.json");q.ajax({url:u,dataType:"json",error:function(x,s,e){a.error("failed to load library list from '"+u+"': "+s+", "+e);c(null);},success:function(A,s,x){if(!A){a.error("failed to load library list from '"+u+"': "+s+", Data: "+A);c(null);return;}c(A);}});};
t._getLibraryInfoSingleton=function(){if(!_){_=new L();}return _;};
t._loadAllLibInfo=function(A,I,r,c){if(typeof r==="function"){c=r;r=undefined;}var l=t._getLibraryInfoSingleton();var f=I=="_getLibraryInfoAndReleaseNotes";if(f){I="_getLibraryInfo";}t._getAppInfo(function(o){if(!(o&&o.libraries)){c(null,null);return;}var b=0,d=o.libraries,e=d.length,g={},h={},j=[],k,m;for(var i=0;i<e;i++){k=d[i].name;m=d[i].version;j.push(k);h[k]=m;l[I](k,function(E){var D=function(){b++;if(b==e){c(j,g,o);}};g[E.library]=E;if(!g[E.library].version){g[E.library].version=h[E.library];}if(f){if(!r){r=h[E.library];}l._getReleaseNotes(E.library,r,function(R){g[E.library].relnotes=R;D();});}else{D();}});}});};
return t;});
sap.ui.predefine('sap/ui/documentation/sdk/Component',["sap/ui/thirdparty/jquery","sap/ui/core/UIComponent","sap/ui/Device","sap/ui/documentation/sdk/model/models","sap/ui/documentation/sdk/controller/ErrorHandler","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ConfigUtil","sap/ui/documentation/sdk/controller/util/APIInfo","sap/base/util/Version","sap/ui/VersionInfo","sap/ui/documentation/sdk/util/DocumentationRouter","sap/m/ColumnListItem"],function(q,U,D,m,E,J,C,A,V,a){"use strict";var t=[],l={},T=1000000;return U.extend("sap.ui.documentation.sdk.Component",{metadata:{manifest:"json",includes:["css/style.css"]},init:function(){this._oErrorHandler=new E(this);this.setModel(m.createDeviceModel(),"device");this.setModel(new J(),"treeData");this.setModel(new J(),"libsData");this.setModel(new J(),"versionData");U.prototype.init.apply(this,arguments);this.loadVersionInfo();this.getRouter().initialize();},destroy:function(){this._oErrorHandler.destroy();this._oConfigUtil.destroy();this._oConfigUtil=null;U.prototype.destroy.apply(this,arguments);},getContentDensityClass:function(){if(this._sContentDensityClass===undefined){if(q(document.body).hasClass("sapUiSizeCozy")||q(document.body).hasClass("sapUiSizeCompact")){this._sContentDensityClass="";}this._sContentDensityClass="sapUiSizeCompact";}return this._sContentDensityClass;},getConfigUtil:function(){if(!this._oConfigUtil){this._oConfigUtil=new C(this);}return this._oConfigUtil;},loadVersionInfo:function(){if(!this._oVersionInfoPromise){this._oVersionInfoPromise=a.load().then(this._bindVersionModel.bind(this));}return this._oVersionInfoPromise;},fetchAPIIndex:function(){if(this._indexPromise){return this._indexPromise;}this._indexPromise=new Promise(function(r,b){A.getIndexJsonPromise().then(function(d){this._aLibraryElements=d;this._parseLibraryElements(d);this._bindTreeModel(t);r(d);}.bind(this));}.bind(this));return this._indexPromise;},_parseLibraryElements:function(L){for(var i=0;i<L.length;i++){if(!L[i].children){l[L[i].name]=L[i];}this._addElementToTreeData(L[i]);if(L[i].children){this._parseLibraryElements(L[i].children,true);}}},_addElementToTreeData:function(j){var n,h,b=this.aAllowedMembers;if(b.indexOf(j.visibility)!==-1){if(j.kind!=="namespace"){var N=j.name.split("."),B=N.pop(),s=N.join("."),o=this._createTreeNode(B,j.name,j.name===this._topicId,j.lib,!!j.deprecated),e=this._findNodeNamespaceInTreeStructure(s);if(e){if(!e.nodes){e.nodes=[];}e.nodes.push(o);}else if(s){h=this._aLibraryElements.some(function(c){return c.name===s&&b.indexOf(c.visibility)===-1;});if(!h){n=this._createTreeNode(s,s,s===this._topicId,j.lib,false);n.nodes=[];n.nodes.push(o);t.push(n);this._removeDuplicatedNodeFromTree(s);}}else{n=this._createTreeNode(j.name,j.name,j.name===this._topicId,j.lib,!!j.deprecated);t.push(n);}}else{n=this._createTreeNode(j.name,j.name,j.name===this._topicId,j.lib,!!j.deprecated);t.push(n);}}},_createTreeNode:function(b,n,i,L,I){var o={};o.text=b;o.name=n;o.ref="#/api/"+n;o.isSelected=i;o.bIsDeprecated=I;o.lib=L;return o;},_findNodeNamespaceInTreeStructure:function(n,b){b=b||t;for(var i=0;i<b.length;i++){var o=b[i];if(o.name===n){return o;}if(o.nodes){var c=this._findNodeNamespaceInTreeStructure(n,o.nodes);if(c){return c;}}}},_removeNodeFromNamespace:function(n,N){for(var i=0;i<N.nodes.length;i++){if(N.nodes[i].text===n){N.nodes.splice(i,1);return;}}},_removeDuplicatedNodeFromTree:function(n){if(l[n]){var N=n.substring(0,n.lastIndexOf("."));var o=this._findNodeNamespaceInTreeStructure(N);var s=n.substring(n.lastIndexOf(".")+1,n.lenght);this._removeNodeFromNamespace(s,o);}},_bindTreeModel:function(t){var b=this.getModel("treeData");b.setSizeLimit(T);if(t.length>0){t.push({isSelected:false,name:"experimental",ref:"#/api/experimental",text:"Experimental APIs",bIsDeprecated:false},{isSelected:false,name:"deprecated",ref:"#/api/deprecated",text:"Deprecated APIs",bIsDeprecated:false},{isSelected:false,name:"since",ref:"#/api/since",text:"Index by Version",bIsDeprecated:false});}b.setData(t,false);},_bindVersionModel:function(v){var o,s,O,b,i;this.aAllowedMembers=["public","protected"];if(!v){return;}o=V(v.version);b=o.getSuffix();s=/-SNAPSHOT$/i.test(b);O=v.gav&&/openui5/i.test(v.gav);if(/internal/i.test(v.name)||!!window['sap-ui-documentation-preview']){i=true;this.aAllowedMembers.push("restricted");}this.getModel("versionData").setData({versionGav:v.gav,versionName:v.name,version:[o.getMajor(),o.getMinor(),o.getPatch()].join("."),fullVersion:v.version,openUi5Version:sap.ui.version,isOpenUI5:O,isSnapshotVersion:s,isDevVersion:s||o.getMinor()%2===1,isBetaVersion:!O&&!s&&/-beta$/i.test(b),isInternal:!!i,libraries:v.libraries,allowedMembers:this.aAllowedMembers});}});});
sap.ui.predefine('sap/ui/documentation/sdk/blocks/IndexEntry',['sap/uxap/BlockBase',"sap/ui/documentation/sdk/model/formatter"],function(B,f){"use strict";
var a=B.extend("sap.ui.documentation.sdk.blocks.IndexEntry",{
metadata:{views:{Collapsed:{viewName:"sap.ui.documentation.sdk.blocks.IndexEntry",type:"XML"},Expanded:{viewName:"sap.ui.documentation.sdk.blocks.IndexEntry",type:"XML"}}},
formatText:function(){return f.formatIndexByVersionEntry.apply(f,arguments);}
});
return a;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiDetail.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter","sap/ui/core/library","sap/base/Log"],function(B,J,C,T,A,f,a,L){"use strict";var V=a.mvc.ViewType;return B.extend("sap.ui.documentation.sdk.controller.ApiDetail",{NOT_AVAILABLE:'N/A',NOT_FOUND:'Not found',onInit:function(){this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched,this);this._oModel=new J();this._oModel.setSizeLimit(10000);this._oContainerPage=this.getView().byId("apiDetailPageContainer");},_onTopicMatched:function(e){if(this._oView){this._oView.destroy();this._oContainerPage.setBusy(true);}var c=this.getOwnerComponent();this._sTopicid=f.decodeModuleName(e.getParameter("arguments").id);this._sEntityType=e.getParameter("arguments").entityType;this._sEntityId=f.decodeModuleName(e.getParameter("arguments").entityId);c.loadVersionInfo().then(function(){this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers");}.bind(this)).then(c.fetchAPIIndex.bind(c)).then(this._processApiIndexAndLoadApiJson.bind(this)).then(this._findEntityInApiJsonData.bind(this)).then(this._buildBorrowedModel.bind(this)).then(this._createModelAndSubView.bind(this)).then(this._initSubView.bind(this)).catch(function(r){if(r===this.NOT_FOUND){this._oContainerPage.setBusy(false);this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}else if(typeof r==="string"){L.error(r);}else if(r.name){L.error(r.name,r.message);}else if(r.message){L.error(r.message);}}.bind(this));},_initSubView:function(v){var c=v.getController();this._oContainerPage.addContent(v);this._oContainerPage.setBusy(false);c.initiate({sTopicId:this._sTopicid,oModel:this._oModel,aApiIndex:this._aApiIndex,aAllowedMembers:this._aAllowedMembers,oEntityData:this._oEntityData,sEntityType:this._sEntityType,sEntityId:this._sEntityId,oOwnerComponent:this.getOwnerComponent(),oContainerView:this.getView(),oContainerController:this});},_createModelAndSubView:function(b){this._oControlData.borrowed=b;this._bindData(this._sTopicid);this._oView=sap.ui.view({height:"100%",viewName:"sap.ui.documentation.sdk.view.SubApiDetail",type:V.XML,async:true,preprocessors:{xml:{models:{data:this._oModel}}}});return this._oView.loaded();},_buildBorrowedModel:function(c){this._oControlData=c;return this.buildBorrowedModel(c);},_findEntityInApiJsonData:function(l){var o,b,i;for(i=0,b=l.length;i<b;i++){o=l[i];if(o.name===this._sTopicid){if(o.visibility===undefined||this._aAllowedMembers.indexOf(o.visibility)>=0){return o;}else{return Promise.reject(this.NOT_FOUND);}}}return Promise.reject(this.NOT_FOUND);},_processApiIndexAndLoadApiJson:function(d){var e,m,v,t=this._sTopicid;this._aApiIndex=d;d.some(function(E){if(E.name===t){e=E;return true;}});if(!e){d.some(function(E){if(E.name.indexOf(t)===0){e=E;v=true;return true;}});}if(e){this._oEntityData=e;if(!v&&e.deprecated){m=this.getOwnerComponent().getConfigUtil().getMasterView("apiId").getController();m.selectDeprecatedSymbol(this._sTopicid);}return A.getLibraryElementsJSONPromise(e.lib).then(function(d){return Promise.resolve(d);});}return Promise.reject(this.NOT_FOUND);},_bindData:function(t){var c=this._oControlData,m,u;u=c['ui5-metadata'];c.hasProperties=false;c.hasOwnMethods=false;c.hasControlProperties=false;c.hasAssociations=false;c.hasAggregations=false;c.hasSpecialSettings=false;c.hasAnnotations=false;var i=function(e){return(this._aAllowedMembers.indexOf(e.visibility)>=0);}.bind(this);var F=function(e){e.name&&(e.name=f.apiRefEntityName(e.name));e.code&&(e.code=f.apiRefEntityName(e.code));if(e.name){var p=e.name.replace(/[$#/]/g,".");e.placeholderId=p+"_method";e.subPlaceholderId=p+"__method";}return e;};if(c.properties){c.properties=this.transformElements(c.properties,i,F);c.hasProperties=!!c.properties.length;}if(c.methods){c.methods=this.transformElements(c.methods,i,F);c.hasOwnMethods=!!c.methods.length;}if(u){c.dnd=u.dnd;if(u.properties){u.properties=this.transformElements(u.properties,i);c.hasControlProperties=!!u.properties.length;}if(u.associations){u.associations=this.transformElements(u.associations,i);c.hasAssociations=!!u.associations.length;}if(u.aggregations){u.aggregations=this.transformElements(u.aggregations,i);c.hasAggregations=!!u.aggregations.length;c.hasAggregationAltTypes=u.aggregations.some(function(e){return!!e.altTypes;});}if(u.specialSettings){u.specialSettings=this.transformElements(u.specialSettings,i);c.hasSpecialSettings=!!u.specialSettings.length;}c.hasAnnotations=!!(u.annotations&&u.annotations.length);}c.hasChildren=!!c.nodes;c.hasConstructor=c.hasOwnProperty("constructor")&&!!c.constructor;c.hasOwnEvents=!!c.events;c.hasEvents=!!(c.hasOwnEvents||(c.borrowed&&c.borrowed.events.length>0));c.hasMethods=!!(c.hasOwnMethods||(c.borrowed&&c.borrowed.methods.length>0));if(c.implements&&c.implements.length){c.implementsParsed=c.implements.map(function(b,d,e){var D=b.split("."),s=D[D.length-1];return{href:b,name:s};});c.hasImplementsData=true;}else{c.hasImplementsData=false;}c.isClass=c.kind==="class";c.isNamespace=c.kind==="namespace";c.isDerived=!!c.extends;c.extendsText=c.extends||this.NOT_AVAILABLE;c.sinceText=c.since||this.NOT_AVAILABLE;c.module=c.module||this.NOT_AVAILABLE;this._oModel.setData(c);if(this.extHookbindData){this.extHookbindData(t,m);}},buildBorrowedModel:function(c){var b,d,s,e,m,M,I,r=[],o,i;if(!c){return Promise.resolve({events:[],methods:[]});}e={methods:[],events:[]};s=c.extends;var v=function(g){return this._aAllowedMembers.indexOf(g.visibility)!==-1;}.bind(this);m=c.methods||[];M=m.map(function(g){return g.name;});var O=function(g){return M.indexOf(g.name)===-1;};I=[s];while(s){i=this._aApiIndex.length;while(i--){o=this._aApiIndex[i];if(o.name===s){s=o.extends;if(s){I.push(s);}if(r.indexOf(o.lib)===-1){r.push(o.lib);}break;}}if(i===-1){break;}}var p=r.map(function(l){return A.getLibraryElementsJSONPromise(l);});return Promise.all(p).then(function(R){var g=[];R.forEach(function(S){g=g.concat(S);});I.forEach(function(s){var h,i=g.length;while(i--){if(g[i].name===s){h=g[i];break;}}var j=function(k){return{name:k.name,link:"#/api/"+s+"/methods/"+k.name};};var E=function(k){return{name:k.name,link:"#/api/"+s+"/events/"+k.name};};if(h){b=(h.methods||[]).filter(v).filter(O).map(j);if(b.length){e.methods.push({name:s,methods:b});}d=(h.events||[]).filter(v).map(E);if(d.length){e.events.push({name:s,events:d});}}});return e;});},transformElements:function(e,F,b){var i,l=e.length,n=[],E;for(i=0;i<l;i++){E=e[i];if(F&&!F(E)){continue;}if(b){b(E);}n.push(E);}return n;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiDetailIndexDeprecatedExperimental.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter"],function(q,B,J,a,A,g){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental",{formatter:g,onInit:function(){var r=this.getRouter();this._oModel=new J();this._oModel.setSizeLimit(10000);this.setModel(this._oModel);r.getRoute("deprecated").attachPatternMatched(this._onTopicMatched,this);r.getRoute("experimental").attachPatternMatched(this._onTopicMatched,this);r.getRoute("since").attachPatternMatched(this._onTopicMatched,this);this._hasMatched=false;this._aVisitedTabs=[];},_onTopicMatched:function(e){var r=e.getParameter("name"),d={experimental:A.getExperimentalPromise,deprecated:A.getDeprecatedPromise,since:A.getSincePromise}[r],p;if(this._hasMatched){return;}this._hasMatched=true;this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers");p=this.getView().byId("objectPage");d().then(function(D){this._filterVisibleElements(D);this._oModel.setData(D);p.addEventDelegate({"onAfterRendering":this._prettify.bind(this)});if(p.getUseIconTabBar()){p.attachNavigate(this._attachPrettifyTab.bind(this));}}.bind(this));},_attachPrettifyTab:function(e){var s=e.getParameter("subSection"),i=s.getId(),b;if(this._aVisitedTabs.indexOf(i)<0){b=s.getBlocks();b.forEach(function(o){o.addEventDelegate({"onAfterRendering":this._prettify.bind(this)});}.bind(this));this._aVisitedTabs.push(i);}},_filterVisibleElements:function(d){Object.keys(d).forEach(function(v){d[v].apis=d[v].apis.filter(function(e){return this._aAllowedMembers.indexOf(e.visibility)>=0;}.bind(this));}.bind(this));},_prettify:function(){q('pre').addClass('prettyprint');window.prettyPrint();},_modifyLinks:function(e){var i=e.getSource().getItems(),l=i.length,I;while(l--){I=i[l];if(I._getLinkSender){var c=I.getCustomData(),C=c[0].getValue(),E=c[1].getValue(),s=c[2].getValue(),h;if(c[3].getValue()){E=C+"."+E;}h="#/api/"+C;if(s!=="class"){h+="/"+s+"/"+E;}I._getLinkSender().setHref(h);}}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiDetailInitial.controller',["sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController"],function(D,B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetailInitial",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiMaster.controller',["sap/ui/Device","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/ui/documentation/sdk/model/formatter","sap/m/library","sap/base/Log","sap/ui/model/Filter","sap/ui/model/FilterOperator"],function(D,M,f,m,L,F,a){"use strict";var S=m.SplitAppMode;return M.extend("sap.ui.documentation.sdk.controller.ApiMaster",{formatter:f,onInit:function(){this._bIncludeDeprecated=false;var c=this.getOwnerComponent();c.loadVersionInfo().then(c.fetchAPIIndex.bind(c)).then(function(){this._expandTreeToNode(this._topicId,this.getOwnerComponent().getModel("treeData"));}.bind(this));this._initTreeUtil("name","nodes");this.getRouter().getRoute("api").attachPatternMatched(this._onMatched,this);this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("deprecated").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("experimental").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("since").attachPatternMatched(this._onTopicMatched,this);},onBeforeRendering:function(){this.buildAndApplyFilters();},selectDeprecatedSymbol:function(t){this._bIncludeDeprecated=true;this.byId("includeDeprecated").setSelected(true);this.buildAndApplyFilters();this._expandTreeToNode(t,this.getModel("treeData"));},_onTopicMatched:function(b){try{this.showMasterSide();}catch(e){L.error(e);}this._topicId=f.decodeModuleName(b.getParameter("arguments").id)||b.getParameter("name");this._expandTreeToNode(this._topicId,this.getOwnerComponent().getModel("treeData"));},_onMatched:function(){var s=this.getView().getParent().getParent(),b=this.byId('tree'),c;s.setMode(S.ShowHideMode);if(b){c=b.getSelectedItem();c&&c.setSelected(false);}if(D.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus();}.bind(this),0);}},compareTreeNodes:function(n,N){if(n==="EXPERIMENTAL"){return 1;}if(N==="EXPERIMENTAL"){return-1;}if(n==="DEPRECATED"){return 1;}if(N==="DEPRECATED"){return-1;}if(n<N){return-1;}if(n>N){return 1;}if(n===N){return 0;}},onNodeSelect:function(e){var n=e.getParameter("listItem");var b=n.getCustomData()[0].getValue();if(!b){L.warning("Missing name for entity: "+n.getId()+" - cannot navigate to API ref");return;}this.getRouter().navTo("apiId",{id:f.encodeModuleName(b)},false);},buildAndApplyFilters:function(){var b=[];if(!this._bIncludeDeprecated){b.push(new F({path:"bIsDeprecated",operator:a.EQ,value1:false}));}if(this._sFilter){b.push(new F({and:false,filters:[new F({path:"name",operator:a.Contains,value1:this._sFilter}),new F({path:"name",operator:a.Contains,value1:this._sFilter.replace(/\s/g,'')})]}));}this.byId("tree").getBinding("items").filter(new F({and:true,filters:b}));return!!this._sFilter;},onIncludeDeprecatedItemsChange:function(e){this._bIncludeDeprecated=e.getParameter("selected");this.buildAndApplyFilters();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/App.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Fragment","sap/ui/documentation/library","sap/ui/core/IconPool","sap/m/MessageBox","sap/m/library","sap/base/Log","sap/base/util/Version","sap/ui/core/syncStyleClass"],function(q,B,J,R,D,F,c,I,M,m,L,V,s){"use strict";var S=m.SplitAppMode;var U=m.URLHelper,n="/neo-app.json",A="About",d="Feedback",C="Change version";return B.extend("sap.ui.documentation.sdk.controller.App",{onInit:function(){B.prototype.onInit.call(this);var v=new J({busy:false,delay:0,bPhoneSize:false,bShowVersionSwitchInHeader:false,bShowVersionSwitchInMenu:false,bLandscape:D.orientation.landscape,bHasMaster:false,bSearchMode:false,bHideTopicSection:!!window['sap-ui-documentation-hideTopicSection'],bHideApiSection:!!window['sap-ui-documentation-hideApiSection'],sAboutInfoSAPUI5:"Looking for the Demo Kit for a specific SAPUI5 version? "+"Check at <a href = 'https://sapui5.hana.ondemand.com/versionoverview.html'>https://sapui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://sapui5.hana.ondemand.com/1.52.4/'>https://sapui5.hana.ondemand.com/1.52.4/</a>",sAboutInfoOpenUI5:"Looking for the Demo Kit for a specific OpenUI5 version? "+"Check at <a href = 'https://openui5.hana.ondemand.com/versionoverview.html'>https://openui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://openui5.hana.ondemand.com/1.52.4/'>https://openui5.hana.ondemand.com/1.52.4/</a>"});this.MENU_LINKS_MAP={"Legal":"https://www.sap.com/corporate/en/legal/impressum.html","Privacy":"https://www.sap.com/corporate/en/legal/privacy.html","Terms of Use":"https://www.sap.com/corporate/en/legal/terms-of-use.html","Copyright":"https://www.sap.com/corporate/en/legal/copyright.html","Trademark":"https://www.sap.com/corporate/en/legal/trademark.html","Disclaimer":"https://help.sap.com/viewer/disclaimer","License":"LICENSE.txt"};this.getOwnerComponent().loadVersionInfo().then(function(){if(this.getModel("versionData").getProperty("/isOpenUI5")){this.MENU_LINKS_MAP["Terms of Use"]="TermsOfUse.txt";}}.bind(this));this.FEEDBACK_SERVICE_URL="https://feedback-sapuisofiaprod.hana.ondemand.com:443/api/v2/apps/5bb7d7ff-bab9-477a-a4c7-309fa84dc652/posts";this._oView=this.getView();this.setModel(v,"appView");this.oHeader=this._oView.byId("headerToolbar");this.oRouter=this.getRouter();this._selectHeader=this._oView.byId("selectHeader");this._tabHeader=this._oView.byId("tabHeader");R.register(this.oHeader,this.onHeaderResize.bind(this));this.oRouter.attachRouteMatched(this.onRouteChange.bind(this));this.oRouter.attachBypassed(this.onRouteNotFound.bind(this));this._registerFeedbackRatingIcons();this._requestVersionInfo();this.byId("splitApp").attachEvent("afterMasterClose",function(e){v.setProperty("/bIsShownMaster",false);},this);},onBeforeRendering:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onAfterRendering:function(){q(document.body).addClass(this.getOwnerComponent().getContentDensityClass());D.orientation.attachHandler(this._onOrientationChange,this);},onExit:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onRouteChange:function(e){if(!this.oRouter.getRoute(e.getParameter("name"))._oConfig.target){return;}var r=e.getParameter("name"),t=this.oRouter.getRoute(r)._oConfig.target[0]+"Tab",T=this._oView.byId(t),k=T?T.getKey():"home",v=this.getModel("appView"),p=v.getProperty("/bPhoneSize"),P=D.system.phone,h=this.getOwnerComponent().getConfigUtil().hasMasterView(r),o,a;this._setHeaderSelectedKey(k);v.setProperty("/bHasMaster",h);this._toggleTabHeaderClass();if(p){this._selectHeader.setVisible(true);}if(P&&h){o=this.getOwnerComponent().getConfigUtil().getMasterView(r);a=o&&o.getId();v.setProperty("/sMasterViewId",a);}this.byId("splitApp").hideMaster();v.setProperty("/bIsShownMaster",false);},onRouteNotFound:function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;},toggleMaster:function(e){var p=e.getParameter("pressed"),P=D.system.phone,o=this.byId("splitApp"),i=o.getMode()===S.ShowHideMode,a=o.getMode()===S.HideMode,b=this.getModel("appView").getProperty("/sMasterViewId"),t;if(!P&&(i||a)){t=(p)?o.showMaster:o.hideMaster;t.call(o);return;}if(P){if(p){o.to(b);}else{o.backDetail();}}},navigateToSection:function(e){var k=e.getParameter("key"),i;if(!k){i=e.getParameter("selectedItem");i&&(k=i.getKey());}e.preventDefault();if(k&&k!=="home"){this.getRouter().navTo(k,{},true);}else{this.getRouter().navTo("",{},true);this._setHeaderSelectedKey("home");}},handleMenuItemClick:function(e){var t=e.getParameter("item").getText(),T=this.MENU_LINKS_MAP[t];if(t===A){this.aboutDialogOpen();}else if(t===d){this.feedbackDialogOpen();}else if(t===C){this.onChangeVersionButtonPress();}else if(T){U.redirect(T,true);}},aboutDialogOpen:function(){if(!this._oAboutDialog){this._oAboutDialog=new sap.ui.xmlfragment("aboutDialogFragment","sap.ui.documentation.sdk.view.AboutDialog",this);this._oView.addDependent(this._oAboutDialog);}else{this._oAboutDialog.getContent()[0].backToTop();}this._oAboutDialog.open();},aboutDialogClose:function(e){this._oAboutDialog.close();},onAboutVersionDetails:function(e){var v=this.getModel("appView"),o=v.getData(),t=this;c._loadAllLibInfo("","_getLibraryInfo","",function(b,f){var g={};var h=c._getLibraryInfoSingleton();for(var i=0,l=b.length;i<l;i++){b[i]=f[b[i]];b[i].libDefaultComponent=h._getDefaultComponent(b[i]);}g.libs=b;o.oVersionInfo=g;v.setData(o);t.setModel(v,"appView");});var N=F.byId("aboutDialogFragment","aboutNavCon"),a=F.byId("aboutDialogFragment","aboutDetail");N.to(a);},onAboutThirdParty:function(e){var v=this.getModel("appView"),o=v.getData(),t=this;c._loadAllLibInfo("","_getThirdPartyInfo",function(l,g){if(!l){return;}var h={};h.thirdparty=[];for(var j=0;j<l.length;j++){var k=g[l[j]];for(var i=0;i<k.libs.length;i++){var O=k.libs[i];O._lib=l[j];h.thirdparty.push(O);}}h.thirdparty.sort(function(a,b){var p=(a.displayName||"").toUpperCase();var r=(b.displayName||"").toUpperCase();if(p>r){return 1;}else if(p<r){return-1;}else{return 0;}});o.oThirdPartyInfo=h;v.setData(o);t.setModel(v,"appView");});var N=F.byId("aboutDialogFragment","aboutNavCon"),f=F.byId("aboutDialogFragment","aboutThirdParty");N.to(f);},onReleaseDialogOpen:function(e){var l=c._getLibraryInfoSingleton(),v=e.getSource().data("version"),a=e.getSource().data("library"),N=new J(),o=new J(),t=this;if(!this._oReleaseDialog){this._oReleaseDialog=new sap.ui.xmlfragment("releaseDialogFragment","sap.ui.documentation.sdk.view.ReleaseDialog",this);this._oView.addDependent(this._oReleaseDialog);}if(!this._oNotesView){this._oNotesView=sap.ui.view({id:"notesView",viewName:"sap.ui.documentation.sdk.view.ReleaseNotesView",type:"Template"});this._oNotesView.setModel(N);}l._getReleaseNotes(a,v,function(r,v){var b={};if(r&&r[v]&&r[v].notes&&r[v].notes.length>0){t._oNotesView.getModel().setData(r);t._oNotesView.bindObject("/"+v);}else{b.noDataMessage="No changes for this library!";}b.library=a;o.setData(b);});this._oReleaseDialog.setModel(o);this._oReleaseDialog.addContent(this._oNotesView);this._oReleaseDialog.open();},onReleaseDialogClose:function(e){this._oReleaseDialog.close();},onAboutNavBack:function(e){var N=F.byId("aboutDialogFragment","aboutNavCon");N.back();},onChangeVersionButtonPress:function(){this.getVersionSwitchDialog().open();},onCloseVersionDialog:function(){this.getVersionSwitchDialog().close();},onChangeVersionDialogSearch:function(e){var a=e.getParameter("newValue"),f=new sap.ui.model.Filter("version",sap.ui.model.FilterOperator.Contains,a),b=sap.ui.getCore().byId("versionList").getBinding("items");b.filter([f]);},onVersionItemPress:function(e){var o=e.getParameter("listItem"),a=o.getCustomData()[0];if(a&&a.getKey()==="path"){window.location.href=a.getValue();}},getVersionSwitchDialog:function(){if(!this._oChangeVersionDialog){this._createVersionDialog();}return this._oChangeVersionDialog;},versionSwitchCustomComparator:function(g,G){return V(g).compareTo(V(G));},_updateVersionSwitchVisibility:function(){var v=this.getModel("appView"),p=v.getProperty("/bPhoneSize");v.setProperty("/bShowVersionSwitchInHeader",!p&&!!this._aNeoAppVersions);v.setProperty("/bShowVersionSwitchInMenu",p&&!!this._aNeoAppVersions);},_createVersionDialog:function(){this._oChangeVersionDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.ChangeVersionDialog",this);this._oChangeVersionDialog.setModel(this._buildVersionDialogModel());this._oView.addDependent(this._oChangeVersionDialog);},_buildVersionDialogModel:function(){var o=new J();o.setSizeLimit(1000);o.setData(this._aNeoAppVersions);return o;},feedbackDialogOpen:function(){var t=this;if(!this._oFeedbackDialog){this._oFeedbackDialog=new sap.ui.xmlfragment("feedbackDialogFragment","sap.ui.documentation.sdk.view.FeedbackDialog",this);this._oView.addDependent(this._oFeedbackDialog);this._oFeedbackDialog.textInput=F.byId("feedbackDialogFragment","feedbackInput");this._oFeedbackDialog.contextCheckBox=F.byId("feedbackDialogFragment","pageContext");this._oFeedbackDialog.contextData=F.byId("feedbackDialogFragment","contextData");this._oFeedbackDialog.ratingStatus=F.byId("feedbackDialogFragment","ratingStatus");this._oFeedbackDialog.ratingStatus.value=0;this._oFeedbackDialog.sendButton=F.byId("feedbackDialogFragment","sendButton");this._oFeedbackDialog.ratingBar=[{button:F.byId("feedbackDialogFragment","excellent"),status:"Excellent"},{button:F.byId("feedbackDialogFragment","good"),status:"Good"},{button:F.byId("feedbackDialogFragment","average"),status:"Average"},{button:F.byId("feedbackDialogFragment","poor"),status:"Poor"},{button:F.byId("feedbackDialogFragment","veryPoor"),status:"Very Poor"}];this._oFeedbackDialog.reset=function(){this.sendButton.setEnabled(false);this.textInput.setValue("");this.contextCheckBox.setSelected(true);this.ratingStatus.setText("");this.ratingStatus.setState("None");this.ratingStatus.value=0;this.contextData.setVisible(false);this.ratingBar.forEach(function(r){if(r.button.getPressed()){r.button.setPressed(false);}});};this._oFeedbackDialog.updateContextData=function(){var v=t._getUI5Version(),u=t._getUI5Distribution();if(this.contextCheckBox.getSelected()){this.contextData.setValue("Location: "+t._getCurrentPageRelativeURL()+"\n"+u+" Version: "+v);}else{this.contextData.setValue(u+" Version: "+v);}};this._oFeedbackDialog.updateContextData();}this._oFeedbackDialog.updateContextData();if(!this._oFeedbackDialog.isOpen()){s("sapUiSizeCompact",this.getView(),this._oFeedbackDialog);this._oFeedbackDialog.open();}},onFeedbackDialogSend:function(){var a={};if(this._oFeedbackDialog.contextCheckBox.getSelected()){a={"texts":{"t1":this._oFeedbackDialog.textInput.getValue()},"ratings":{"r1":{"value":this._oFeedbackDialog.ratingStatus.value}},"context":{"page":this._getCurrentPageRelativeURL(),"attr1":this._getUI5Distribution()+":"+sap.ui.version}};}else{a={"texts":{"t1":this._oFeedbackDialog.textInput.getValue()},"ratings":{"r1":{"value":this._oFeedbackDialog.ratingStatus.value}},"context":{"attr1":this._getUI5Distribution()+":"+sap.ui.version}};}this._oFeedbackDialog.setBusyIndicatorDelay(0);this._oFeedbackDialog.setBusy(true);q.ajax({url:this.FEEDBACK_SERVICE_URL,type:"POST",contentType:"application/json",data:JSON.stringify(a)}).done(function(){M.success("Your feedback has been sent.",{title:"Thank you!"});this._oFeedbackDialog.reset();this._oFeedbackDialog.close();this._oFeedbackDialog.setBusy(false);}.bind(this)).fail(function(r,b,e){var E=e;M.error("An error occurred sending your feedback:\n"+E,{title:"Sorry!"});this._oFeedbackDialog.setBusy(false);}.bind(this));},onFeedbackDialogCancel:function(){this._oFeedbackDialog.reset();this._oFeedbackDialog.close();},onShowHideContextData:function(){this._oFeedbackDialog.contextData.setVisible(!this._oFeedbackDialog.contextData.getVisible());},onContextSelect:function(){this._oFeedbackDialog.updateContextData();},onPressRatingButton:function(e){var t=this;var p=e.getSource();t._oFeedbackDialog.ratingBar.forEach(function(r){if(p!==r.button){r.button.setPressed(false);}else{if(!r.button.getPressed()){a("None","",0);}else{switch(r.status){case"Excellent":a("Success",r.status,5);break;case"Good":a("Success",r.status,4);break;case"Average":a("None",r.status,3);break;case"Poor":a("Warning",r.status,2);break;case"Very Poor":a("Error",r.status,1);}}}});function a(b,T,v){t._oFeedbackDialog.ratingStatus.setState(b);t._oFeedbackDialog.ratingStatus.setText(T);t._oFeedbackDialog.ratingStatus.value=v;if(v){t._oFeedbackDialog.sendButton.setEnabled(true);}else{t._oFeedbackDialog.sendButton.setEnabled(false);}}},onSearch:function(e){var Q=e.getParameter("query");if(!Q){return;}this.getRouter().navTo("search",{searchParam:Q},false);},onHeaderResize:function(e){var w=e.size.width,p=D.system.phone||w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this.getModel("appView").setProperty("/bPhoneSize",p);this._tabHeader.setVisible(!p);this._selectHeader.setVisible(p);},_onOrientationChange:function(){this.getModel("appView").setProperty("/bLandscape",D.orientation.landscape);this._toggleTabHeaderClass();},onToggleSearchMode:function(e){var b=e.getParameter("isOpen"),v=this.getModel("appView"),p=v.getProperty("/bPhoneSize");v.setProperty("/bSearchMode",b);this._toggleTabHeaderClass();if(b){setTimeout(function(){this._oView.byId("searchControl").getAggregation("_searchField").getFocusDomRef().focus();}.bind(this),0);if(p){this._selectHeader.setVisible(false);}}else if(p){this._selectHeader.setVisible(true);}},_registerFeedbackRatingIcons:function(){I.addIcon("icon-face-very-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E086",suppressMirroring:true});I.addIcon("icon-face-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E087",suppressMirroring:true});I.addIcon("icon-face-neutral","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E089",suppressMirroring:true});I.addIcon("icon-face-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08B",suppressMirroring:true});I.addIcon("icon-face-very-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08C",suppressMirroring:true});},_requestVersionInfo:function(){Promise.resolve(q.ajax(n)).then(function(N){var v=this.getModel("versionData"),i=v.getProperty("/isInternal"),b=v.getProperty("/isSnapshotVersion");if(!(N&&N.routes)){L.warning("No versions were found");return;}N.routes.pop();this._aNeoAppVersions=N.routes;if(!i&&!b){this._aNeoAppVersions=this._aNeoAppVersions.filter(function(r){return r.target.version.indexOf("-beta")===-1;});}this._aNeoAppVersions=this._aNeoAppVersions.map(function(r){var o=V(r.target.version),a={};a.patchVersion=o.getPatch();a.groupTitle=o.getMajor()+"."+o.getMinor();a.version=o.toString();a.path=r.path;return a;});this._updateVersionSwitchVisibility();}.bind(this),function(){L.warning("No neo-app.json was detected");});},_getUI5Version:function(){return this.getModel("versionData").getProperty("/version");},_getUI5VersionGav:function(){return this.getModel("versionData").getProperty("/versionGav");},_getUI5Distribution:function(){var v=this._getUI5VersionGav();var u="SAPUI5";if(v&&/openui5/i.test(v)){u="OpenUI5";}return u;},_getCurrentPageRelativeURL:function(){var p=window.location;return p.pathname+p.hash+p.search;},_isToggleButtonVisible:function(){var v=this.getModel("appView"),h=v.getProperty("/bHasMaster"),p=v.getProperty("/bPhoneSize"),l=v.getProperty("/bLandscape"),b=v.getProperty("/bSearchMode");return h&&(p||!l)&&!b;},_toggleTabHeaderClass:function(){var p=this.getModel("appView").getProperty("/bPhoneSize");if(this._isToggleButtonVisible()){this._tabHeader.setVisible(!p);this._selectHeader.setVisible(p);}else if(p){this._selectHeader.setVisible(false);}},_setHeaderSelectedKey:function(k){this._selectHeader.setSelectedKey(k);this._tabHeader.setSelectedKey(k);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/BaseController',["sap/ui/documentation/library","sap/ui/core/mvc/Controller","sap/ui/core/routing/History","sap/ui/Device","sap/m/library","sap/ui/documentation/sdk/controller/util/APIInfo"],function(l,C,H,D,m,A){"use strict";var S=m.SplitAppMode;return C.extend("sap.ui.documentation.sdk.controller.BaseController",{_oCore:sap.ui.getCore(),onInit:function(){if(D.system.phone||D.system.tablet){this.getOwnerComponent().loadVersionInfo();}},hideMasterSide:function(){var s=this.getSplitApp();s.setMode(S.HideMode);},showMasterSide:function(){var s=this.getSplitApp();s.setMode(S.ShowHideMode);},getSplitApp:function(){return this.getView().getParent().getParent();},getRouter:function(){return this.getOwnerComponent().getRouter();},getModel:function(n){return this.getView().getModel(n);},setModel:function(M,n){return this.getView().setModel(M,n);},getConfig:function(){return this.getOwnerComponent().getMetadata().getConfig();},onNavBack:function(e){var p=H.getInstance().getPreviousHash();if(p!==undefined){if(p.indexOf("search/")===0){this.getRouter().navTo("search",{searchParam:p.split("/")[1]},false);}else{history.go(-1);}}else{var c=window.location.hash;if(c.indexOf("#/topic/")==0){this.getRouter().navTo("topic",{},true);}else if(c.indexOf("#/api/")==0){this.getRouter().navTo("api",{},true);}}},searchResultsButtonVisibilitySwitch:function(b){var p=H.getInstance().getPreviousHash();if(p&&p.indexOf("search/")===0){b.setVisible(true);}else{b.setVisible(false);}},getRootView:function(){var c=this.getOwnerComponent();return c.byId(c.getManifestEntry("/sap.ui5/rootView").id);},onDisclaimerLinkPress:function(e){var s=e.getSource?e.getSource():e.target;if(!this.oDisclaimerPopover){sap.ui.core.Fragment.load({name:"sap.ui.documentation.sdk.view.LegalDisclaimerPopover"}).then(function(p){this.oDisclaimerPopover=p;p.openBy(s);}.bind(this));return;}else if(this.oDisclaimerPopover.isOpen()){this.oDisclaimerPopover.close();}this.oDisclaimerPopover.openBy(s);},_getControlComponent:function(c,o){var L=o.libComponentInfos,a=l._getLibraryInfoSingleton();return a._getActualComponent(L,c);},_onOrientationChange:function(e){if(D.system.phone){this.byId("phoneImage").toggleStyleClass("phoneHeaderImageLandscape",e.landscape);}},_registerOrientationChange:function(){D.orientation.attachHandler(this._onOrientationChange,this);},_deregisterOrientationChange:function(){D.orientation.detachHandler(this._onOrientationChange,this);},handleLandingImageLoad:function(){this.getView().byId("landingImageHeadline").setVisible(true);},getAPIReferenceCheckPromise:function(c){return A.getIndexJsonPromise().then(function(r){var f;f=r.filter(function(e){return e.name===c;});return f&&f.length>0;});}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Code.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/model/json/JSONModel","sap/ui/thirdparty/jquery","sap/ui/core/Component"],function(q,B,C,J,Q){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Code",{_aMockFiles:["products.json","supplier.json","img.json"],onInit:function(){this.oModel=new J();this.getView().setModel(this.oModel);this.router=this.getRouter();this.router.getRoute("code").attachPatternMatched(this.onRouteMatched,this);this.router.getRoute("code_file").attachPatternMatched(this.onRouteMatched,this);this._codeCache={};this._aFilesAvailable=[];this._bFirstLoad=true;},onRouteMatched:function(e){this.showMasterSide();this._sId=e.getParameter("arguments").id;this._sFileName=decodeURIComponent(e.getParameter("arguments").fileName);C.loadData().then(function(d){this._loadCode(d);}.bind(this));},_loadCode:function(d){var f=this._sFileName;var s=d.samples[this._sId];if(!s){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}if(!this._oData||s.id!==this._oData.id){var c='sampleComp-'+this._sId;var a=this._sId;var o=sap.ui.component(c);if(!o){o=sap.ui.getCore().createComponent({id:c,name:a});}var m=o.getMetadata();var b=(m)?m.getConfig():null;this._oData={id:s.id,title:"Code: "+s.name,name:s.name,stretch:b.sample?b.sample.stretch:false,files:[],iframe:b.sample.iframe,fileName:f,includeInDownload:b.sample.additionalDownloadFiles};if(b&&b.sample&&b.sample.files){var r=sap.ui.require.toUrl((s.id).replace(/\./g,"/"));for(var i=0;i<b.sample.files.length;i++){var F=b.sample.files[i];var e=this.fetchSourceFile(r,F);this._oData.files.push({name:F,raw:e,code:this._convertCodeToHtml(e)});this._aFilesAvailable.push(F);}}}else{this._oData.fileName=f;}this.entityId=s.entityId;this.getAPIReferenceCheckPromise(s.entityId).then(function(h){this.getView().byId("apiRefButton").setVisible(h);}.bind(this));this.oModel.setData(this._oData);if(f==="undefined"){f=this._getInitialFileName();}if(this._aFilesAvailable.indexOf(f)===-1){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}this._updateCodeEditor(f);this._getTabHeader().setSelectedKey(f);var p=this.byId("page");p.scrollTo(0);},fetchSourceFile:function(r,f){var t=this;var u=r+"/"+f;var s=function(a){t._codeCache[u]=a;};var e=function(a){t._codeCache[u]="not found: '"+u+"'";};if(!(u in this._codeCache)){this._codeCache[u]="";Q.ajax(u,{async:false,dataType:"text",success:s,error:e});}return t._codeCache[u];},onDownload:function(e){q.sap.require("sap.ui.thirdparty.jszip");var a=sap.ui.require("sap/ui/thirdparty/jszip");var z=new a();var d=this.oModel.getData();for(var i=0;i<d.files.length;i++){var f=d.files[i],r=f.raw;if(f.name&&(f.name===d.iframe||f.name.split(".").pop()==="html")){r=this._changeIframeBootstrapToCloud(r);}z.file(f.name,r);for(var j=0;j<this._aMockFiles.length;j++){var m=this._aMockFiles[j];if(f.raw.indexOf(m)>-1){z.file("mockdata/"+m,this.downloadMockFile(m));}}}var R=sap.ui.require.toUrl((this._sId).replace(/\./g,"/")),E=d.includeInDownload||[],t=this;if(!d.iframe){z.file("Component.js",this.fetchSourceFile(R,"Component.js"));z.file("index.html",this._changeIframeBootstrapToCloud(this.createIndexFile(d)));}E.forEach(function(F){z.file(F,t.fetchSourceFile(R,F));});var c=z.generate({type:"blob"});this._openGeneratedFile(c);},_openGeneratedFile:function(c){q.sap.require("sap.ui.core.util.File");var F=sap.ui.require("sap/ui/core/util/File");F.save(c,this._sId,"zip","application/zip");},createIndexFile:function(d){var h,s;var r=sap.ui.require.toUrl("sap/ui/documentation/sdk/")+"tmpl";var i=this.fetchSourceFile(r,"index.html.tmpl");i=i.replace(/{{TITLE}}/g,d.name);i=i.replace(/{{SAMPLE_ID}}/g,d.id);h=d.stretch?'height : "100%", ':"";i=i.replace(/{{HEIGHT}}/g,h);s=!d.stretch;i=i.replace(/{{SCROLLING}}/g,s);return i;},downloadMockFile:function(f){var r=sap.ui.require.toUrl("sap/ui/demo/")+"mock";var w="test-resources/sap/ui/documentation/sdk/images/";var c="https://openui5.hana.ondemand.com/test-resources/sap/ui/documentation/sdk/images/";var R=new RegExp(w,"g");var m=this.fetchSourceFile(r,f);if(m){m=m.replace(R,c);}return m;},onAPIRefPress:function(){this.getRouter().navTo("apiId",{id:this.entityId});},onNavBack:function(){this.router.navTo("sample",{id:this._sId},true);},_convertCodeToHtml:function(c){q.sap.require("jquery.sap.encoder");c=c.toString();c=c.replace(/^function.+{/,"");c=c.replace(/}[!}]*$/,"");c=c.replace(/^[\n\s\S]*\/\/\s*CODESNIP_START\n/,"");c=c.replace(/\/\/\s*CODESNIP_END[\n\s\S]*$/,"");c=c.replace(/\t/g,"  ");return c;},_changeIframeBootstrapToCloud:function(r){q.sap.require("sap.ui.thirdparty.URI");var U=sap.ui.require("sap/ui/thirdparty/URI");var a=/src=(?:"[^"]*\/sap-ui-core\.js"|'[^']*\/sap-ui-core\.js')/;var c=new U(window.location.href).search("");var R=new U(sap.ui.require.toUrl("")+"/sap-ui-core.js");var b=R.absoluteTo(c).toString();return r.replace(a,'src="'+b+'"');},handleTabSelectEvent:function(e){var f=e.getParameter("selectedKey");this._bFirstLoad=false;this.router.navTo("code_file",{id:this._sId,fileName:encodeURIComponent(f)},false);},_updateCodeEditor:function(f){var c=this._getCodeEditor(),a=c._getEditorInstance(),A=a.renderer;c.setValue(this._getCode(f));c.setType(this._getFileType(f));a.gotoLine(0,0,false);if(this._bFirstLoad){setTimeout(function(){A.onResize();},0);}},_getCode:function(f){var F=this.getModel().getData().files,c="";F.forEach(function(o){if(o.name===f){c=o.raw;return true;}});return c;},_getFileType:function(f){var F=f.split('.').pop();return F==="js"?"javascript":F;},_getInitialFileName:function(){return(this._oData&&this._oData.files&&this._oData.files.length>0&&this._oData.files[0].name)||null;},_getCodeEditor:function(){if(!this.oCodeEditor){this.oCodeEditor=this.byId("codeEditor");}return this.oCodeEditor;},_getTabHeader:function(){if(!this.oTabHeader){this.oTabHeader=this.byId("tabHeader");}return this.oTabHeader;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Controls.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device"],function(B,D){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Controls",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},onPress:function(e){var f=e.oSource.getFilter(),s=this.getOwnerComponent().byId("controlsMaster").byId("searchField");s.setValue(f).fireLiveChange({newValue:f});setTimeout(function(){this.getSplitApp().showMaster();}.bind(this),0);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ControlsMaster.controller',["jquery.sap.global","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/m/GroupHeaderListItem","sap/ui/model/Filter","sap/ui/model/Sorter","sap/base/util/Version","sap/ui/thirdparty/jquery","sap/base/util/UriParameters","sap/ui/util/Storage"],function(q,D,B,J,C,G,F,S,V,Q,U,a){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ControlsMaster",{_oStorage:new a(a.Type.local),_sStorageKey:"UI5_EXPLORED_LIST_SETTINGS_FROM_1_48",_oViewSettings:{compactOn:false,themeActive:"sap_belize",rtl:false},_oDefaultSettings:{compactOn:false,themeActive:"sap_belize",rtl:false},_oListSettings:{filter:{},groupProperty:"category",groupDescending:false,version:V(sap.ui.version).getMajor()+"."+V(sap.ui.version).getMinor()},_mGroupFunctions:{"name":function(c){var k=c.getProperty("name").charAt(0);return{key:k,text:k};},"namespace":true,"category":true,"since":true,"formFactors":true},_sFilterValue:"",onInit:function(){var e,d,f,o=function(c){this._oView.getModel().setData({entityCount:c.entityCount,entities:c.entities});this.getModel("filter").setData(c.filter);this._toggleListItem(this._getItemToSelect(),true);}.bind(this);this._oRouter=this.getRouter();this._bNavToEntityViaList=false;this._oView=this.getView();C.loadData().then(o);e=new J();e.setSizeLimit(100000);this._oView.setModel(e);d=new J({listMode:(D.system.phone)?"None":"SingleSelectMaster",listItemType:(D.system.phone)?"Active":"Inactive"});d.setDefaultBindingMode("OneWay");this._oView.setModel(d,"viewModel");f=new J();f.setSizeLimit(100000);this.setModel(f,"filter");this._vsFilterBar=this._oView.byId("vsFilterBar");this._vsFilterLabel=this._oView.byId("vsFilterLabel");this._oRouter.getRoute("listFilter").attachPatternMatched(this._onFilterMatched,this);this._oRouter.getRoute("group").attachPatternMatched(this._onGroupMatched,this);this._oRouter.getRoute("entity").attachPatternMatched(this._onEntityMatched,this);this._oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("code").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("controls").attachPatternMatched(this._onControlsMatched,this);this._oRouter.getRoute("controlsMaster").attachPatternMatched(this._onControlsMasterMatched,this);this.LIST_SCROLL_DURATION=0;this._iDomRenderingDelay=0;this._getList().addEventDelegate({onAfterRendering:function(){setTimeout(this._scrollToSelectedListItem.bind(this),this._iDomRenderingDelay);}},this);this._oCore.attachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.attachLocalizationChanged(this._onLocalizationChange,this);this._oView.addEventDelegate({onBeforeFirstShow:this.onBeforeFirstShow.bind(this)});this._oComponent=this.getOwnerComponent();this._oRootView=this.getRootView();this._oViewSettings.compactOn=this._oComponent.getContentDensityClass()==="sapUiSizeCompact";this._oViewSettings.rtl=this._oCore.getConfiguration().getRTL();this._oDefaultSettings.compactOn=this._oViewSettings.compactOn;this._oDefaultSettings.rtl=this._oViewSettings.rtl;this._initListSettings();},_viewSettingsResetOnNavigation:function(e){var r=e.getParameter("name");if(["group","entity","sample","code","code_file","controls","controlsMaster","listFilter"].indexOf(r)===-1){this._applyAppConfiguration(this._oDefaultSettings.themeActive,this._oDefaultSettings.compactOn,this._oDefaultSettings.rtl);this.getRouter().detachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}},_initListSettings:function(){var j=this._oStorage.get(this._sStorageKey);if(j){this._oListSettings=JSON.parse(j);}},_applyAppConfiguration:function(t,c,r){var s,o,$,R,T,b;if(this._oViewSettings.compactOn!==c){Q(document.body).toggleClass("sapUiSizeCompact",c).toggleClass("sapUiSizeCozy",!c);this._oViewSettings.compactOn=c;b=true;}if(this._oViewSettings.rtl!==r){this._oCore.getConfiguration().setRTL(r);this._oViewSettings.rtl=r;R=true;}if(this._oViewSettings.themeActive!==t){this._oCore.applyTheme(t);this._oViewSettings.themeActive=t;T=true;}else if(b){this._oCore.notifyContentDensityChanged();}if(R||b||T){$=Q("#sampleFrame");if($.length>0){s=$[0].contentWindow;if(s){o=s.sap.ui.getCore();if(b){s.jQuery('body').toggleClass("sapUiSizeCompact",c).toggleClass("sapUiSizeCozy",!c);}if(R){o.getConfiguration().setRTL(r);}if(T){o.applyTheme(t);}else if(b){o.notifyContentDensityChanged();}}}}},_onGroupMatched:function(e){this._onMatched('#/group/',e);},_onEntityMatched:function(e){this._onMatched('#/entity/',e);},_onSampleMatched:function(e){this._onMatched('#/sample/',e);},_onMatched:function(n,e){var E=this._getList().getModel(),s=e.getParameter("arguments").id;this.showMasterSide();this._topicId=n+s;this._entityId=s;E.refresh();this._updateListSelection();},_onControlsMasterMatched:function(e){this.showMasterSide();if(!D.system.phone){this.getRouter().navTo("controls");}},_onFilterMatched:function(e){var f=e.getParameter("arguments").value,s;if(f){s=this.byId("searchField");s.setValue(f).fireLiveChange({newValue:f});setTimeout(function(){this.getSplitApp().showMaster();}.bind(this),0);if(D.system.phone){this.getRouter().navTo("controlsMaster",{});}}this._onControlsMatched(e);},_onControlsMatched:function(){this.showMasterSide();this._resetListSelection();if(D.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus();}.bind(this),0);}},_onLocalizationChange:function(e){this._iDomRenderingDelay=3000;setTimeout(function(){this._iDomRenderingDelay=0;}.bind(this),this._iDomRenderingDelay);},onNavToEntity:function(e){var i=e.getParameter("listItem"),I=(i)?i:e.getSource(),p=I.getBindingContext().getPath(),E=this.getView().getModel().getProperty(p),r=!D.system.phone;this._bNavToEntityViaList=true;this.getRouter().navTo("entity",{id:E.id,part:"samples"},r);},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});},_updateListSelection:function(){var i=this._getItemToSelect();if(!i){return;}this._toggleListItem(i,true);if(!this._bNavToEntityViaList){setTimeout(this._scrollToSelectedListItem.bind(this),0);}this._bNavToEntityViaList=false;},_resetListSelection:function(){var s=this._getList().getSelectedItem();if(s){this._toggleListItem(s,false);setTimeout(this._scrollPageTo.bind(this,0,0),0);}},_toggleListItem:function(i,s){this._getList().setSelectedItem(i,s,false);},_scrollToSelectedListItem:function(){var i=this._getList().getSelectedItem();if(i){this._getPage().scrollToElement(i,this.LIST_SCROLL_DURATION);}},_scrollPageTo:function(p,d){this._getPage().scrollTo(p,d);},_getItemToSelect:function(){var l=this._getList(),e=l.getModel(),E,i,I,L=this._entityId,o=null;l.getItems().forEach(function(b){i=b.getBindingContext();if(i){I=i.getPath();E=e.getProperty(I);if(E.id===L){o=b;return false;}}});return o;},_getPage:function(){if(!this.oPage){this.oPage=this.byId("exploredMasterPage");}return this.oPage;},_getList:function(){if(!this.oList){this.oList=this.byId("exploredMasterList");}return this.oList;},onBeforeFirstShow:function(){this._updateView();},onExit:function(){this._oCore.detachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.detachLocalizationChanged(this._onLocalizationChange,this);},onConfirmViewSettings:function(e){var g=e.getParameter("groupItem");this._oListSettings.filter=e.getParameter("filterCompoundKeys");this._oListSettings.groupProperty=g?g.getKey():null;this._oListSettings.groupDescending=e.getParameter("groupDescending");this._oStorage.put(this._sStorageKey,JSON.stringify(this._oListSettings));this._updateView();},handleListSettings:function(){if(!this._oVSDialog){this._oVSDialog=sap.ui.xmlfragment(this.getView().getId(),"sap.ui.documentation.sdk.view.viewSettingsDialog",this);this.getView().addDependent(this._oVSDialog);}this._oVSDialog.setSelectedFilterCompoundKeys(this._oListSettings.filter);this._oVSDialog.setSelectedGroupItem(this._oListSettings.groupProperty);this._oVSDialog.setGroupDescending(this._oListSettings.groupDescending);this._oVSDialog.open();},handleListFilter:function(e){this._sFilterValue=e.getParameter("newValue").trim();this._updateView();},_updateListBinding:function(){var f,s,b=[],c=[],d=false,g=false,l=this._oView.byId("exploredMasterList"),o=l.getBinding("items");d=true;b.push(new F("searchTags","Contains",this._sFilterValue));Q.each(this._oListSettings.filter,function(p,v){var P=[];Q.each(v,function(k,e){var O=(p==="formFactors")?"Contains":"EQ";P.push(new F(p,O,k));});d=true;b.push(new F(P,false));});if(d&&b.length===0){o.filter(b,"Application");}else if(d&&b.length>0){f=new F(b,true);o.filter(f,"Application");}if(this._oListSettings.groupProperty&&this._oListSettings.groupProperty!==this._sCurrentGroup){g=true;}else if(this._oListSettings.groupProperty&&this._oListSettings.groupDescending!==this._bCurrentlyGroupedDescending){g=true;}if(g){s=new S(this._oListSettings.groupProperty,this._oListSettings.groupDescending,this._mGroupFunctions[this._oListSettings.groupProperty]);c.push(s);c.push(new S("name",false));o.sort(c);}this._sCurrentGroup=this._oListSettings.groupProperty;this._bCurrentlyGroupedDescending=this._oListSettings.groupDescending;this._bIsViewUpdatedAtLeastOnce=true;},_updateView:function(){this._updateFilterBarDisplay();this._updateListBinding();},_updateFilterBarDisplay:function(){var f=[];Q.each(this._oListSettings.filter,function(p,v){f=f.concat(Object.keys(v));});if(f.length>0){this._vsFilterBar.setVisible(true);this._vsFilterLabel.setText(f.join(", "));}else{this._vsFilterBar.setVisible(false);}},handleSettings:function(){if(!this._oSettingsDialog){this._oSettingsDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.appSettingsDialog",this);this._oView.addDependent(this._oSettingsDialog);}setTimeout(function(){var A=this._oCore.getConfiguration(),t=this._oCore.byId("ThemeSelect"),u=new U(window.location.href).get("sap-theme"),c=this._oViewSettings.compactOn;t.setSelectedKey(u?u:A.getTheme());this._oCore.byId("RTLSwitch").setState(A.getRTL());this._oCore.byId("CompactModeSwitch").setState(c);this._oSettingsDialog.open();}.bind(this),0);},handleCloseAppSettings:function(){this._oSettingsDialog.close();},handleSaveAppSettings:function(){var b,c=this._oCore.byId('CompactModeSwitch').getState(),t=this._oCore.byId('ThemeSelect').getSelectedKey(),r=this._oCore.byId('RTLSwitch').getState();this._oSettingsDialog.close();if(!this._oBusyDialog){q.sap.require("sap.m.BusyDialog");b=sap.ui.require("sap/m/BusyDialog");this._oBusyDialog=new b();this.getView().addDependent(this._oBusyDialog);}this._oBusyDialog.open();setTimeout(function(){this._oBusyDialog.close();}.bind(this),1000);this._applyAppConfiguration(t,c,r);this.getRouter().attachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/DemoApps.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/resource/ResourceModel","sap/ui/Device","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/model/sourceFileDownloader","sap/ui/documentation/sdk/model/formatter","sap/m/MessageBox","sap/m/MessageToast","sap/ui/model/Filter","sap/ui/model/FilterOperator",'sap/ui/documentation/sdk/model/libraryData',"sap/base/Log"],function(q,B,R,D,J,s,f,M,a,F,b,l,L){"use strict";return B.extend("sap.ui.documentation.sdk.controller.DemoApps",{formatter:f,onInit:function(){var m=new J(),i=new R({bundleName:"sap.ui.documentation.sdk.i18n.i18n"});this.getView().setModel(i,"i18n");l.fillJSONModel(m);this.setModel(m);this.getRouter().getRoute("demoapps").attachPatternMatched(this._onMatched,this);sap.ui.getVersionInfo({async:true}).then(function(v){var V=new J({isOpenUI5:v&&v.gav&&/openui5/i.test(v.gav)});this.getView().setModel(V,"appView");}.bind(this));this._onOrientationChange({landscape:D.orientation.landscape});this._onResize({name:(D.resize.width<=600?"Phone":"NoPhone")});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();this._registerResize();},onExit:function(){this._deregisterOrientationChange();this._deregisterResize();},_registerOrientationChange:function(){D.orientation.attachHandler(this._onOrientationChange,this);},_deregisterOrientationChange:function(){D.media.detachHandler(this._onOrientationChange,this);},_registerResize:function(){D.media.attachHandler(this._onResize,this);},_deregisterResize:function(){D.orientation.detachHandler(this._onResize,this);},_onOrientationChange:function(e){this.byId("phoneImage").toggleStyleClass("phoneHeaderImageLandscape",e.landscape);},_onResize:function(e){this.byId("phoneImage").setVisible(e.name==="Phone");this.byId("desktopImage").setVisible(e.name!=="Phone");this.byId("phoneImage").toggleStyleClass("phoneHeaderImageDesktop",e.name==="Phone");},_onMatched:function(){try{this.hideMasterSide();}catch(e){L.error(e);}},onDownloadButtonPress:function(e){var d=this.byId("downloadDialog");this._oDownloadButton=e.getSource();d.getBinding("items").filter([]);d.open();d._oDialog.setContentHeight("");},onReadMoreButtonPress:function(){window.open("#/topic/a3ab54ecf7ac493b91904beb2095d208","_blank");},onSearch:function(e){e.getParameters().itemsBinding.filter([new F("name",b.Contains,e.getParameters().value)]);},onDownloadPress:function(e){var S=e.getParameters().selectedItem,o=S?S:e.getSource().getParent();this._oDownloadButton.setBusy(true);sap.ui.require(["sap/ui/core/util/File","sap/ui/thirdparty/jszip"],function(c,d){var z=new d();q.getJSON(o.data("config"),function(C){var g=C.files,p=[],h=[];g.forEach(function(i){var P=s(C.cwd+i);P.then(function(j){if(j.errorMessage){h.push(j.errorMessage);}else{if(!i.startsWith("../")){z.file(i,j,{base64:false,binary:true});}}});p.push(P);});Promise.all(p).then(function(){if(h.length){var i=h.reduce(function(E,k){return E+k+"\n";},"Could not locate the following download files:\n");this._handleError(i);}this._oDownloadButton.setBusy(false);a.show("Downloading for app \""+o.getLabel()+"\" has been started");var j=z.generate({type:"blob"});this._createArchive(c,j,o.getLabel());}.bind(this));}.bind(this));}.bind(this));},createDemoAppCell:function(i,o){var c;if(o.getObject().teaser){try{sap.ui.loader.config({paths:{"test-resources":"test-resources"}});var r=sap.ui.require.toUrl(o.getObject().teaser);var t=sap.ui.xmlfragment(i,r);c=sap.ui.xmlfragment(i,"sap.ui.documentation.sdk.view.BlockLayoutTeaserCell",this);c.getContent()[0].addContent(t);sap.ui.loader.config({paths:{"test-resources":null}});t.addEventDelegate({"onAfterRendering":function(){this.getParent().getDomRef().childNodes[1].setAttribute("aria-hidden","true");}.bind(t)});}catch(e){L.warning("Teaser for demo app \""+o.getObject().name+"\" could not be loaded: "+e);c=sap.ui.xmlfragment(i,"sap.ui.documentation.sdk.view.BlockLayoutCell",this);}}else{c=sap.ui.xmlfragment(i,"sap.ui.documentation.sdk.view.BlockLayoutCell",this);}c.setBindingContext(o);return c;},_createArchive:function(c,C,d){c.save(C,d,"zip","application/zip");},_handleError:function(e){M.error(e);},handleLandingImageLoad:function(){this.byId("landingImageHeadline").setVisible(true);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Downloads.controller',["sap/ui/documentation/sdk/controller/BaseController"],function(B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Downloads",{onInit:function(){this.getRouter().getRoute("downloads").attachPatternMatched(this._onMatched,this);},_onMatched:function(){this.hideMasterSide();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Entity.controller',["sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/EntityInfo","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute"],function(J,B,C,E,A,T,a,L,b,c,H,O){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Entity",{onInit:function(){this.router=this.getRouter();this.router.getRoute("entity").attachPatternMatched(this.onRouteMatched,this);this._oObjectPage=this.byId("ObjectPageLayout");this.getView().setModel(new J());},onTypeLinkPress:function(e){var t=e.getSource().data("type");this.getRouter().navTo("entity",{id:t},false);},onAPIRefPress:function(e){var s=e.getSource().data("name");this.getRouter().navTo("apiId",{id:s},false);},onTabSelect:function(e){var t=e.getParameter("key");this.router.navTo("entity",{id:this._sId,part:t},true);},onNavToSample:function(e){var p=e.getSource().getBindingContext().getPath();var s=this.getView().getModel().getProperty(p);this.router.navTo("sample",{id:s.id});},_wrapInSpanTag:function(t){var f=a.formatTextBlock(t,{linkFormatter:function(s,t){var r="entity",d,m,p;t=t||s;if(s.match("://")){return'<a target="_blank" href="'+s+'">'+t+'</a>';}s=s.trim().replace(/\.prototype\./g,"#");p=s.indexOf("#");if(p===0){return"<code>"+s.slice(1)+"</code>";}else if(p>0){s=s.slice(0,p);}m=s.match(/^topic:(\w{32})$/);if(m){s=m[1];r="topic";}d=s.split('/');if(d.length>1&&["methods","events"].indexOf(d[1].toLowerCase())!==-1){r="api";}return'<a class="jsdoclink" href="#/'+r+'/'+s+'">'+t+'</a>';}});return'<span class="sapUiJSD">'+f+'</span>';},_TAB_KEYS:["samples","about"],_loadSample:function(o){var n=this._sNewId;var f=o.entities.filter(function(g){return g.id===n;});var e=f.length?f[0]:undefined;function u(){if(this._TAB_KEYS.indexOf(this._sNewTab)===-1){this._sNewTab="samples";}if(!d.show[this._sNewTab]){this._sNewTab="samples";}this._switchPageTab();setTimeout(function(){this._oObjectPage.setBusy(false);}.bind(this),0);}var d,v=this.getView();if(this._sId!==n){E.getEntityDocuAsync(n,e&&e.library).then(function(D){if(!e&&!D){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}d=this._getViewData(n,D,e,o);this.getAPIReferenceCheckPromise(d.name).then(function(h){d.bHasAPIReference=h;this._buildHeaderLayout(d);}.bind(this));v.getModel().setData(d,false);this._sId=n;u.call(this);}.bind(this));}else{d=this.getView().getModel().getData();u.call(this);}},onRouteMatched:function(e){this._oObjectPage.setBusy(true);this._sNewId=e.getParameter("arguments").id;this._sNewTab=e.getParameter("arguments").sectionTab;C.loadData().then(function(d){this._loadSample(d);}.bind(this));this.searchResultsButtonVisibilitySwitch(this.byId("entityBackToSearch"));},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},_getViewData:function(i,d,e,o){var D=this._convertEntityInfo(i,d,o),s=false,S=0;D.show.introLink=false;if(e){if(!D.shortDescription&&e.description){D.shortDescription=e.description;}if(!D.baseName){D.baseName=e.name;}if(e.docuLink){D.show.introLink=true;D.docuLink=e.docuLink.replace("docs/guide","topic").replace(/\.html$/,"");D.docuLinkText=D.baseName;}s=e.samples.length>0;S=e.samples.length;}D.show.samples=s;D.count.samples=S;D.entity=e;if(d){if(d.docuLink){D.show.introLink=true;D.docuLink="#/topic/"+d.docuLink;D.docuLinkText=d.docuLinkText;}D.uxGuidelinesLink=d.uxGuidelinesLink;D.uxGuidelinesLinkText=d.uxGuidelinesLinkText;}return D;},_convertEntityInfo:function(i,d,o){var D={name:i,deprecated:(d)?this._formatDeprecated(d.deprecation):null,deprecatedMark:(d)?this._createDeprecatedMark(d.deprecation):null,baseType:(d)?this._formatType(d.baseType):null,baseTypeText:(d)?this._formatTypeText(d.baseType):"-",baseTypeNav:(d)?this._formatTypeNav(d.baseType):null,shortDescription:(d)?this._formatDeprecatedDescription(d.deprecation):null,description:(d)?this._wrapInSpanTag(d.doc):null,docuLink:null,docuLinkText:null,uxGuidelinesLink:null,uxGuidelinesLinkText:null,values:d?d.values:[],show:{baseType:(d)?!!d.baseType:false,about:!!d,values:false,introActive:false},count:{samples:0},appComponent:this._getControlComponent(i,o)};if(!d){return D;}D.show.values=Array.isArray(D.values)&&D.values.length>0;return D;},_formatDeprecated:function(d){return(d&&d.length>0)?"true":"false";},_formatDeprecatedDescription:function(d){return(d&&d.length>0)?(this._createDeprecatedMark(d)+": "+d):null;},_formatType:function(t){if(!t){return null;}else{return t.replace("[]","");}},_formatTypeText:function(t){if(!t){return null;}else{t=t.replace("sap.ui.core.","");var i=t.lastIndexOf(".");return(i!==-1)?t.substr(i+1):t;}},_createDeprecatedMark:function(d){return(d)?"Deprecated":"";},_switchPageTab:function(){var s=this.byId(this._sNewTab);if(!s){return;}if(this._oObjectPage){this._oObjectPage.attachEvent("onAfterRenderingDOMReady",function(){this._oObjectPage.setSelectedSection(s.getId());},this);}},_getHeaderLayoutUtil:function(){if(!this._oHeaderLayoutUtil){var _=function(t,s){return new O({title:t,text:s}).addStyleClass("sapUiTinyMarginBottom");},d=function(o){return new b(o||{});},e=function(o){return new c(o||{});},f=function(o){return new L(o||{});},g=function(o,h){var i=new H(o||{});if(h){i.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom");}return i;};this._oHeaderLayoutUtil={_getApiReferenceBlock:function(D){return g({items:[f({design:"Bold",text:"API Reference:"}),d({emphasized:true,text:D.name,href:"#/api/"+D.name})]},true);},_getDocumentationBlock:function(D){return g({items:[f({design:"Bold",text:"Documentation:"}),d({emphasized:true,text:D.docuLinkText,href:D.docuLink})]},true);},_getUXGuidelinesBlock:function(D){return g({items:[f({design:"Bold",text:"UX Guidelines:"}),d({emphasized:true,text:D.uxGuidelinesLinkText,href:D.uxGuidelinesLink,target:"_blank"})]},true);},_getExtendsBlock:function(D){return g({items:[f({text:"Extends:"}),d({text:D.baseTypeText,href:"#/entity/"+D.baseType,visible:!!D.baseTypeNav}),e({text:"N/A",visible:!D.baseTypeNav||!D.baseType})]},true);},_getApplicationComponentBlock:function(D){return _("Application Component",D.appComponent);},_getAvailableSinceBlock:function(D){return _("Available since",D.entity.since);},_getCategoryBlock:function(D){return _("Category",D.entity.category);},_getContentDensityBlock:function(D){return _("Content Density",D.entity.formFactors);}};}return this._oHeaderLayoutUtil;},backToSearch:function(){this.onNavBack();},_buildHeaderLayout:function(d){var F=0,S=1,e=2,f=3,h=[[],[],[]],o=this._getHeaderLayoutUtil(),g=[{creator:"_getApiReferenceBlock",exists:d.bHasAPIReference},{creator:"_getDocumentationBlock",exists:d.show.introLink},{creator:"_getUXGuidelinesBlock",exists:!!d.uxGuidelinesLink},{creator:"_getExtendsBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getCategoryBlock",exists:true},{creator:"_getContentDensityBlock",exists:true}],i=function(){var j=0,I,G=function(j){if(j<=f){return F;}else if(j<=f*2){return S;}return e;};g.forEach(function(k){var l;if(k.exists){l=o[k.creator].call(this,d);I=G(++j);h[I].push(l);}},this);}.bind(this);i();h.forEach(function(j,I){var v=this.byId("headerColumn"+I);v.removeAllContent();if(j.length>0){v.setVisible(true);j.forEach(v.addContent,v);}},this);},_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","any","object","function","float","int","boolean","string"],_formatTypeNav:function(t){return this._baseTypes.indexOf(t)===-1;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ErrorHandler',["sap/ui/base/Object","sap/m/MessageBox"],function(U,M){"use strict";return U.extend("sap.ui.documentation.sdk.controller.ErrorHandler",{constructor:function(c){this._oComponent=c;this._oModel=c.getModel();this._bMessageOpen=false;this._sErrorText="Sorry, a technical error occurred! Please try again later.";},_showMetadataError:function(d){M.error(this._sErrorText,{id:"metadataErrorMessageBox",details:d,styleClass:this._oComponent.getContentDensityClass(),actions:[M.Action.RETRY,M.Action.CLOSE],onClose:function(a){if(a===M.Action.RETRY){this._oModel.refreshMetadata();}}.bind(this)});},_showServiceError:function(d){if(this._bMessageOpen){return;}this._bMessageOpen=true;M.error(this._sErrorText,{id:"serviceErrorMessageBox",details:d,styleClass:this._oComponent.getContentDensityClass(),actions:[M.Action.CLOSE],onClose:function(){this._bMessageOpen=false;}.bind(this)});}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Group.controller',["sap/ui/documentation/sdk/controller/BaseController"],function(B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Group",{onInit:function(){this.getRouter().getRoute("group").attachPatternMatched(this._onGroupMatched,this);},_onGroupMatched:function(e){this._id=e.getParameter("arguments").id;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/MasterTreeBaseController',["sap/ui/thirdparty/jquery","./BaseController","./util/TreeUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator"],function(q,B,T,F,a){"use strict";var b=300;
var M=B.extend("sap.ui.documentation.sdk.controller.MasterTreeBaseController",{
_initTreeUtil:function(n,d){this._oTreeUtil=new T(n,d);},
_expandTreeToNode:function(t,m){var o=this.byId("tree"),d=m.getData();var e=this._oTreeUtil.getPathToNode(t,d);var l;e.forEach(function(i){var I=this._findTreeItem(i);if(I){o.getBinding("items").expand(o.indexOfItem(I));l=I;}},this);if(l){l.setSelected(true);setTimeout(function(){if(l.getDomRef()&&!c(l.getDomRef())){this._scrollTreeItemIntoView(l);}}.bind(this),0);}},
_findTreeItem:function(I){var o=this.byId("tree").getItems();for(var i=0;i<o.length;i++){var C=o[i].getCustomData()[0];if(C.getKey()==="nodeId"&&C.getValue()===I){return o[i];}}return null;},
_scrollTreeItemIntoView:function(i){var p=this.byId("page");p.scrollToElement(i.getDomRef(),b);},
onTreeFilter:function(e){this._sFilter=e.getParameter("newValue").trim();if(this._filterTimeout){clearTimeout(this._filterTimeout);}this._filterTimeout=setTimeout(function(){if(this.buildAndApplyFilters()){this._expandAllNodes();}else{this._collapseAllNodes();}this._filterTimeout=null;}.bind(this),250);},
buildAndApplyFilters:function(){var o=this.byId("tree").getBinding("items");if(this._sFilter){o.filter(new F({path:"name",operator:a.Contains,value1:this._sFilter}));return true;}else{o.filter();return false;}},
_expandAllNodes:function(){this.byId("tree").expandToLevel(10);},
_collapseAllNodes:function(){this.byId("tree").collapseAll();},
_clearSelection:function(){var i=this.byId("tree").getItems();if(i.length){i[0].setSelected(false);}},
onTreeExpandAll:function(e){this._expandAllNodes();},
onTreeCollapseAll:function(e){this._collapseAllNodes();}
});
function c(d){var r=d.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=q(document).height()&&r.right<=q(document).width());}
return M;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ReleaseNotes.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/library","sap/base/util/Version","sap/base/Log"],function(q,B,J,l,V,L){"use strict";var n="neo-app.json",s="resources/sap-ui-version.json";return B.extend("sap.ui.documentation.sdk.controller.ReleaseNotes",{onInit:function(){this._oView=this.getView();this._requestResources();this._resourceAvailabilityHandler();this._oModel=new J();this._oVersionModel=new J();this._oView.setModel(this._oModel);this._oView.setModel(this._oVersionModel,"select");l._loadAllLibInfo("","_getLibraryInfoAndReleaseNotes","",this._processLibInfo.bind(this));l._getAppInfo(this._processAppInfo.bind(this));},_processAppInfo:function(a){var v,m,M,b,o;if(!(a)){return;}v=V(a.version);m=v.getMajor();M=v.getMinor();if(v.getSuffix()!==""){if(M%2!==0){M=(M+1);}}b=m+"."+M;o={items:[]};while(M>=28){b=m+"."+M;o.items.push({key:b,value:b});M=M-2;}this._oVersionModel.setData(o);},_processLibInfo:function(c,o){var r,R=[],d=c.length,p,i;p=function(v,e){r+=e.notes.length;c[i].versions.push({version:v,notes:e.notes});c[i].versions.sort(function(a,b){return V(b.version).compareTo(a.version);});};for(i=0;i<d;i++){c[i]=o[c[i]];c[i].versions=[];if(c[i].relnotes){r=0;q.each(c[i].relnotes,p);if(r>0){R.push(c[i]);}}}this._oModel.setData({libs:R});this._hideBusyIndicator();},_requestResources:function(){this._oNeoAppJsonPromise=q.ajax(n);this._oSapUiVersionJsonPromise=q.ajax(s);},_resourceAvailabilityHandler:function(){q.when(this._oNeoAppJsonPromise,this._oSapUiVersionJsonPromise).then(function(N,S){this._oNeoAppVersions=N[0].routes;this._sSapUiVersion=S[0].version;this._oView.byId("VersionSelect").setVisible(true);}.bind(this),function(){L.warning("No neo-app.json was detected");});},_compareUI5Versions:function(v,a){var o=V(v),b=V(a);return(o.getMajor()+"."+o.getMinor())===(b.getMajor()+"."+b.getMinor());},_updateLastReleasedVersion:function(v){if(this._compareUI5Versions(v,this._sSapUiVersion)&&parseFloat(this._sLastReleasedVersion)>parseFloat(this._sSapUiVersion)){this._sLastReleasedVersion=this._sSapUiVersion;}},_getLastVersionFromNeoAppJson:function(S){var a=this._oNeoAppVersions?this._oNeoAppVersions.length:0,v,i;for(i=0;i<a;i++){v=this._oNeoAppVersions[i].target.version;if(this._compareUI5Versions(v,S)){return v;}}},handleVersionChange:function(e){var i=e.getParameter("selectedItem"),S=i.getKey(),v;this._sLastReleasedVersion=this._getLastVersionFromNeoAppJson(S);this._updateLastReleasedVersion(S);v=this._sLastReleasedVersion?this._sLastReleasedVersion:S;this._showBusyIndicator();l._loadAllLibInfo("","_getLibraryInfoAndReleaseNotes",v,this._processLibInfo.bind(this));},_showBusyIndicator:function(){this.byId("releaseNotesObjectPage").setBusy(true);},_hideBusyIndicator:function(){this.byId("releaseNotesObjectPage").setBusy(false);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Sample.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/m/Text","sap/ui/core/HTML","sap/ui/Device","sap/ui/core/routing/History","sap/m/library","sap/base/Log"],function(q,B,J,C,a,b,T,c,H,D,d,m,L){"use strict";var U=m.URLHelper;return B.extend("sap.ui.documentation.sdk.controller.Sample",{onInit:function(){this.getRouter().getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._viewModel=new J({showNavButton:true,showNewTab:false});Promise.all([sap.ui.getCore().loadLibrary("sap.ui.fl",{async:true}),sap.ui.getCore().loadLibrary("sap.ui.rta",{async:true})]).then(this._loadRTA.bind(this));this.getView().setModel(this._viewModel);},_onSampleMatched:function(e){this.getModel("appView").setProperty("/bHasMaster",false);var p=this.byId("page");p.setBusy(true);this._sId=e.getParameter("arguments").id;b.loadData().then(function(o){this._loadSample(o);}.bind(this));},_loadSample:function(o){var p=this.byId("page"),h=d.getInstance(),P=h.getPreviousHash(),M=this._viewModel.getData(),s=o.samples[this._sId],e;if(!s){setTimeout(function(){p.setBusy(false);},0);this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}M.showNavButton=D.system.phone||!!P;M.previousSampleId=s.previousSampleId;M.nextSampleId=s.nextSampleId;this.entityId=s.entityId;M.title="Sample: "+s.name;try{e=this._createComponent();}catch(f){p.removeAllContent();p.addContent(new c({text:"Error while loading the sample: "+f}));setTimeout(function(){p.setBusy(false);},0);return;}this.getOwnerComponent()._oCurrentOpenedSample=e?e:undefined;var g=(this._oComp.getMetadata())?this._oComp.getMetadata().getConfig():null;var S=g&&g.sample||{};M.showNewTab=!!S.iframe;if(S.iframe){e=this._createIframe(e,S.iframe);}else{this.sIFrameUrl=null;}var i=!!S.stretch;var j=i?"100%":null;p.setEnableScrolling(!i);if(e.setHeight){e.setHeight(j);}p.removeAllContent();p.addContent(e);p.scrollTo(0);this.getAPIReferenceCheckPromise(s.entityId).then(function(k){this.getView().byId("apiRefButton").setVisible(k);}.bind(this));this._viewModel.setData(M);setTimeout(function(){p.setBusy(false);},0);},onAPIRefPress:function(){this.getRouter().navTo("apiId",{id:this.entityId});},onNewTab:function(){U.redirect(this.sIFrameUrl,true);},onPreviousSample:function(e){this.getRouter().navTo("sample",{id:this._viewModel.getProperty("/previousSampleId")},true);},onNextSample:function(e){this.getRouter().navTo("sample",{id:this._viewModel.getProperty("/nextSampleId")},true);},_resolveIframePath:function(s,I){var e=I.split("/"),i;for(i=0;i<e.length-1;i++){if(e[i]==".."){s=s.substring(0,s.lastIndexOf("."));}else{s+="."+e[i];}}return s;},_createIframe:function(i,I){var s=this._sId,e="",r=/\/([^\/]*)$/,f=/\..+$/,F,g,h;if(typeof I==="string"){e=this._resolveIframePath(s,I);F=r.exec(I);g=(F&&F.length>1?F[1]:I);h=f.exec(g)[0];var j=g.replace(f,"");this.sIFrameUrl=sap.ui.require.toUrl((e+"/"+j).replace(/\./g,"/"))+h||".html";}else{L.error("no iframe source was provided");return;}if(!this._oHtmlControl){this._oHtmlControl=new H({id:"sampleFrame",content:'<iframe src="'+this.sIFrameUrl+'" id="sampleFrame" frameBorder="0"></iframe>'}).addEventDelegate({onAfterRendering:function(){if(!this._oHtmlControl._jQueryHTMLControlLoadEventAttached){this._oHtmlControl.$().on("load",function(){var S=this._oHtmlControl.$()[0].contentWindow,o=S.sap.ui.getCore();S.sap.ui.getCore().attachInit(function(){var k=q(document.body).hasClass("sapUiSizeCompact");o.applyTheme(this._oCore.getConfiguration().getTheme());o.getConfiguration().setRTL(this._oCore.getConfiguration().getRTL());S.jQuery('body').toggleClass("sapUiSizeCompact",k).toggleClass("sapUiSizeCozy",!k);o.notifyContentDensityChanged();}.bind(this));}.bind(this));this._oHtmlControl._jQueryHTMLControlLoadEventAttached=true;}}.bind(this)});}else{this._oHtmlControl.getDomRef().src=this.sIFrameUrl;}return this._oHtmlControl;},_createComponent:function(){var s='sampleComp-'+this._sId;var e=this._sId;var M=this.getOwnerComponent();this._oComp=sap.ui.component(s);if(this._oComp){this._oComp.destroy();}return M.runAsOwner(function(){this._oComp=sap.ui.getCore().createComponent({id:s,name:e});return new a({component:this._oComp});}.bind(this));},onNavBack:function(e){this.getRouter().navTo("entity",{id:this.entityId},true);},onNavToCode:function(e){this.getRouter().navTo("code",{id:this._sId},false);},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},_oRTA:null,_loadRTA:function(){sap.ui.require(["sap/ui/fl/Utils","sap/ui/fl/FakeLrepConnectorLocalStorage","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,F,f){f.checkControlId=function(){return true;};e.checkControlId=function(){return true;};F.enableFakeConnector({"isProductiveSystem":true});this.byId("toggleRTA").setVisible(true);this.getRouter().attachRouteMatched(function(){if(this._oRTA){this._oRTA.destroy();this._oRTA=null;}},this);}.bind(this));},onToggleAdaptationMode:function(e){sap.ui.require(["sap/ui/rta/RuntimeAuthoring"],function(R){if(!this._oRTA){this._oRTA=new R({flexSettings:{developerMode:false}});this._oRTA.setRootControl(this.byId("page"));this._oRTA.attachStop(function(){this._oRTA.destroy();delete this._oRTA;}.bind(this));this._oRTA.start();}}.bind(this));}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/SearchPage.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/m/GroupHeaderListItem","sap/base/Log"],function(q,B,J,G,L){"use strict";return B.extend("sap.ui.documentation.sdk.controller.SearchPage",{onInit:function(){this.setModel(new J());this.bindListResults();this.getRouter().getRoute("search").attachPatternMatched(this._onTopicMatched,this);},bindListResults:function(){this.dataObject={data:[]};this.getModel().setData(this.dataObject);},_onTopicMatched:function(a){var t=this,Q=a.getParameter("arguments").searchParam;this.dataObject.searchTerm=Q;this._modelRefresh();try{this.hideMasterSide();}catch(e){L.error(e);}var s="(category:topics) AND ("+encodeURIComponent(Q)+")";var b="(category:apiref) AND ("+encodeURIComponent(Q)+")";var c="(category:entity) AND ("+encodeURIComponent(Q)+")";var P=new Promise(function(r){q.ajax({url:"search?q="+s,dataType:"json",success:function(D,S,x){r(D,S,x);},error:function(){r([]);}});});var d=new Promise(function(r){q.ajax({url:"search?q="+b,dataType:"json",success:function(D,S,x){r(D,S,x);},error:function(){r([]);}});});var f=new Promise(function(r){q.ajax({url:"search?q="+c,dataType:"json",success:function(D,S,x){r(D,S,x);},error:function(){r([]);}});});Promise.all([P,d,f]).then(function(r){var D={},R=r[0][0]||{},o=r[1][0]||{},g=r[2][0]||{};R.matches=R.matches||[];o.matches=o.matches||[];g.matches=g.matches||[];D.success=R.success||o.success||g.success||false;D.totalHits=(R.totalHits+o.totalHits+g.totalHits)||0;D.matches=R.matches.concat(o.matches).concat(g.matches);t.processResult(D);}).catch(function(r){});},processResult:function(d){this.dataObject.data=[];this.dataObject.dataAPI=[];this.dataObject.dataDoc=[];this.dataObject.dataExplored=[];this.dataObject.AllLength=0;this.dataObject.APILength=0;this.dataObject.DocLength=0;this.dataObject.ExploredLength=0;if(d&&d.success){if(d.totalHits==0){q(".sapUiRrNoData").html("No matches found.");}else{for(var i=0;i<d.matches.length;i++){var D=d.matches[i];D.modifiedStr=D.modified+"";var m=D.modifiedStr.substring(0,4)+"/"+D.modifiedStr.substring(4,6)+"/"+D.modifiedStr.substring(6,8)+", "+D.modifiedStr.substring(8,10)+":"+D.modifiedStr.substring(10),n=D.path,s=false,c;if(n.indexOf("topic/")===0){n=n.substring(0,n.lastIndexOf(".html"));s=true;c="Documentation";this.dataObject.dataDoc.push({index:this.dataObject.DocLength,title:D.title?D.title:"Untitled",path:n,summary:D.summary?(D.summary+"..."):"",score:D.score,modified:m,category:c});this.dataObject.DocLength++;}else if(n.indexOf("entity/")===0){s=true;c="Samples";this.dataObject.dataExplored.push({index:this.dataObject.ExploredLength,title:D.title?D.title:"Untitled",path:n,summary:D.summary?(D.summary+"..."):"",score:D.score,modified:m,category:c});this.dataObject.ExploredLength++;}else if(n.indexOf("docs/api/symbols/")===0){n=n.substring("docs/api/symbols/".length,n.lastIndexOf(".html"));n="api/"+n;s=true;c="API Reference";this.dataObject.dataAPI.push({index:this.dataObject.APILength,title:D.title?D.title:"Untitled",path:n,summary:D.summary?(D.summary+"..."):"",score:D.score,modified:m,category:c});this.dataObject.APILength++;}else if(n.indexOf("docs/api/modules/")===0){n=n.substring("docs/api/modules/".length,n.lastIndexOf(".html")).replace(/_/g,".");n="api/"+n;s=true;c="API Reference";this.dataObject.dataAPI.push({index:this.dataObject.APILength,title:D.title?D.title:"Untitled",path:n,summary:D.summary?(D.summary+"..."):"",score:D.score,modified:m,category:c});this.dataObject.APILength++;}if(s){this.dataObject.data.push({index:i,title:D.title?D.title:"Untitled",path:n,summary:D.summary?(D.summary+"..."):"",score:D.score,modified:m,category:c});this.dataObject.AllLength++;}}}}else{q(".sapUiRrNoData").html("Search failed, please retry ...");}this._modelRefresh();},_modifyLinks:function(){var v=this.getView(),i=[].concat(v.byId("allList").getItems(),v.byId("apiList").getItems(),v.byId("documentationList").getItems(),v.byId("samplesList").getItems()),l=i.length,I;while(l--){I=i[l];if(I._getLinkSender){I._getLinkSender().setHref("#/"+I.getCustomData()[0].getValue());}}},_modelRefresh:function(){this.getModel().refresh();this._modifyLinks();},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});},categoryAPIFormatter:function(c){return c==="API Reference";},categoryDocFormatter:function(c){return c==="Documentation";},categoryExploredFormatter:function(c){return c==="Samples";},onAllLoadMore:function(e){this.dataObject.visibleAllLength=e.getParameter("actual");this._modelRefresh();},onAPILoadMore:function(e){this.dataObject.visibleAPILength=e.getParameter("actual");this._modelRefresh();},onDocLoadMore:function(e){this.dataObject.visibleDocLength=e.getParameter("actual");this._modelRefresh();},onExploredLoadMore:function(e){this.dataObject.visibleExploredLength=e.getParameter("actual");this._modelRefresh();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/SubApiDetail.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute","sap/m/Popover","sap/m/library"],function(q,B,J,C,T,A,f,L,a,b,H,O,P,l){"use strict";var F=l.FlexWrap;return B.extend("sap.ui.documentation.sdk.controller.SubApiDetail",{NOT_AVAILABLE:'N/A',SECTION_MAP:{"properties":"controlProperties","fields":"properties","special settings":"specialsettings"},formatter:f,onInit:function(){this._objectPage=this.byId("apiDetailObjectPage");},initiate:function(r){this._sTopicId=r.sTopicId;this._oModel=r.oModel;this._oControlData=this._oModel.getData();this._aApiIndex=r.aApiIndex;this._aAllowedMembers=r.aAllowedMembers;this._sEntityType=r.sEntityType;this._sEntityId=r.sEntityId;this._oEntityData=r.oEntityData;this._oContainerController=r.oContainerController;this._oContainerView=r.oContainerView;this.getOwnerComponent=function(){return r.oOwnerComponent;};this._oRouter=this.getRouter();this.setModel(this._oModel);this._oEntityData.appComponent=this._oControlData.component||this.NOT_AVAILABLE;this._oEntityData.hasSample=this._oControlData.hasSample;this._oEntityData.sample=this._oControlData.hasSample?this._sTopicId:this.NOT_AVAILABLE;this._buildHeaderLayout(this._oControlData,this._oEntityData);setTimeout(function(){this._prettify();this._objectPage.attachEvent("subSectionEnteredViewPort",function(){if(this._sPrettyPrintDelayedCallID){clearTimeout(this._sPrettyPrintDelayedCallID);}this._sPrettyPrintDelayedCallID=setTimeout(function(){var $=q('.sapUxAPObjectPageContainer .APIDetailMethodsSection pre:not(.prettyprint)',this._objectPage.$());if($.length>0){$.addClass('prettyprint');window.prettyPrint();}}.bind(this),200);},this);setTimeout(function(){if(this._sEntityType){this._scrollToEntity(this._sEntityType,this._sEntityId);}setTimeout(function(){this._objectPage.attachEvent("_sectionChange",function(e){var s=e.getParameter("section"),S=e.getParameter("subSection");if(this._oNavigatingTo){if(this._oNavigatingTo===S){this._oNavigatingTo=null;}return;}this._modifyURL(s,S,false);},this);this._objectPage.attachEvent("navigate",function(e){var s=e.getParameter("section"),S=e.getParameter("subSection");this._oNavigatingTo=S;this._modifyURL(s,S,true);},this);}.bind(this),500);}.bind(this),1000);}.bind(this),0);this.searchResultsButtonVisibilitySwitch(this.byId("apiDetailBackToSearch"));},onAfterRendering:function(){this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this);},onToggleFullScreen:function(e){T.updateMode(e,this._oContainerView,this._oContainerController);},onJSDocLinkClick:function(e){var c=e.target.classList,j=c.contains("jsdoclink"),E=c.contains("sapUISDKExternalLink"),s=e.target.getAttribute("data-sap-ui-target"),d;if(!j&&!E){return;}if(E){this.onDisclaimerLinkPress(e);return;}if(c.contains("scrollToMethod")){d="methods";}else if(c.contains("scrollToEvent")){d="events";}else{return;}this._scrollToEntity(d,s);this._navigateRouter(d,s,true);},_navigateRouter:function(e,E,s){this._oRouter.stop();this._oRouter.navTo("apiId",{id:f.encodeModuleName(this._sTopicId),entityType:e,entityId:f.encodeModuleName(E)},!s);this._oRouter.initialize(true);},_modifyURL:function(s,S,c){var d=s.getTitle().toLowerCase(),e=(S&&S.getTitle()!=='Overview')?S.getTitle():'';if(Object.keys(this.SECTION_MAP).indexOf(d)>=0){d=this.SECTION_MAP[d];}this._navigateRouter(d,e,c);},_prettify:function(){q('.sapUxAPObjectPageContainer pre',this._objectPage.$()).addClass('prettyprint');window.prettyPrint();},scrollToMethod:function(e){this._scrollToEntity("methods",e.getSource().getText());},scrollToEvent:function(e){this._scrollToEntity("events",e.getSource().getText());},scrollToAnnotation:function(e){this._scrollToEntity("annotations",e.getSource().getText());},_scrollToEntity:function(s,S){var c,d,o;if(!s){return;}s=s.toLowerCase();o=this.byId(s);if(!o){return;}if(S){S=S.toLowerCase();d=o.getSubSections();c=d.filter(function(e){return e.getTitle().toLowerCase()===S;});if(c.length){this._oRouter.stop();setTimeout(function(){this._oRouter.initialize(true);}.bind(this),0);this._objectPage.scrollToSection(c[0].getId(),250);}}else{this._objectPage.scrollToSection(o.getId(),250);}},_scrollContentToTop:function(){if(this._objectPage&&this._objectPage.$().length>0){this._objectPage.getScrollDelegate().scrollTo(0,0);}},_getHeaderLayoutUtil:function(){if(!this._oHeaderLayoutUtil){var _=function(t,s){return new O({title:t,text:s}).addStyleClass("sapUiTinyMarginBottom");},c=function(o){return new a(o||{});},d=function(o){return new b(o||{});},e=function(o){return new L(o||{});},g=function(o,h){var i=new H(o||{});if(h){i.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom");}return i;};this._oHeaderLayoutUtil={_getControlSampleBlock:function(o,E){return g({items:[e({design:"Bold",text:"Control Sample:"}),c({emphasized:true,text:E.sample,visible:!!E.hasSample,href:"#/entity/"+o.name}),d({text:E.sample,visible:!E.hasSample})]},true);},_getDocumentationBlock:function(o,E){return g({items:[e({design:"Bold",text:"Documentation:"}),c({emphasized:true,text:o.docuLinkText,href:"#/topic/"+o.docuLink})]},true);},_getUXGuidelinesBlock:function(o){return g({items:[e({design:"Bold",text:"UX Guidelines:"}),c({emphasized:true,text:o.uxGuidelinesLinkText,href:o.uxGuidelinesLink,target:"_blank"})]},true);},_getExtendsBlock:function(o,E){return g({items:[e({text:"Extends:"}),c({text:o.extendsText,href:"#/api/"+o.extendsText,visible:o.isDerived}),d({text:o.extendsText,visible:!o.isDerived})]},true);},_getSubclassesBlock:function(o,E){var s=E.extendedBy||E.implementedBy,S;this._aSubClasses=s;if(s.length===1){S=c({text:s[0],href:"#/api/"+s[0]});}else{S=c({text:o.isClass?"View subclasses":"View implementations",press:this._openSubclassesImplementationsPopover.bind(this)});}return g({items:[e({text:o.isClass?"Known direct subclasses:":"Known direct implementations:"}),S]},true);},_getImplementsBlock:function(o,E){var i=[e({text:"Implements:"})];o.implementsParsed.forEach(function(h){i.push(c({text:h.name,href:"#/api/"+h.href}));});return g({items:i,wrap:F.Wrap},true).addStyleClass("sapUiDocumentationCommaList");},_getModuleBlock:function(o,E){return _("Module",o.module);},_getLibraryBlock:function(o,E){return _("Library",E.lib);},_getVisibilityBlock:function(o,E){return _("Visibility",o.visibility);},_getAvailableSinceBlock:function(o,E){return _("Available since",o.sinceText);},_getApplicationComponentBlock:function(o,E){return _("Application Component",E.appComponent);}};}return this._oHeaderLayoutUtil;},_openSubclassesImplementationsPopover:function(e){var p=this._aSubClasses.map(function(E){return new a({text:E,href:"#/api/"+E}).addStyleClass("sapUiTinyMarginBottom sapUiTinyMarginEnd");}),o=this._getSubClassesAndImplementationsPopover(p);o.openBy(e.getSource());},_getSubClassesAndImplementationsPopover:function(c){var p=this._getPopover();if(p.getContent().length>0){p.destroyContent();}(c||[]).forEach(p.addContent,p);return p;},_getPopover:function(){if(!this._oPopover){this._oPopover=new P({placement:"Bottom",showHeader:false}).addStyleClass("sapUiDocumentationSubclassesPopover");}return this._oPopover;},_buildHeaderLayout:function(c,e){var d=0,S=1,g=2,E=3,h=[[],[],[]],o=this._getHeaderLayoutUtil(),s=e.extendedBy||e.implementedBy||[],i=[{creator:"_getControlSampleBlock",exists:c.isClass||c.isNamespace},{creator:"_getDocumentationBlock",exists:c.docuLink!==undefined},{creator:"_getUXGuidelinesBlock",exists:c.uxGuidelinesLink!==undefined},{creator:"_getExtendsBlock",exists:c.isClass},{creator:"_getSubclassesBlock",exists:s.length>0},{creator:"_getImplementsBlock",exists:c.hasImplementsData},{creator:"_getModuleBlock",exists:true},{creator:"_getLibraryBlock",exists:c.kind==="namespace"&&e.lib},{creator:"_getVisibilityBlock",exists:c.visibility},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true}],j=function(){var k=0,I,G=function(k){if(k<=E){return d;}else if(k<=E*2){return S;}return g;};i.forEach(function(m){var n;if(m.exists){n=o[m.creator].call(this,c,e);I=G(++k);h[I].push(n);}},this);}.bind(this);j();h.forEach(function(k,I){var v=this.byId("headerColumn"+I);v.removeAllContent();if(k.length>0){v.setVisible(true);k.forEach(v.addContent,v);}},this);},onAnnotationsLinkPress:function(){this._scrollToEntity("annotations","Summary");},backToSearch:function(){this.onNavBack();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TermsOfUse.controller',["sap/ui/documentation/sdk/controller/BaseController"],function(B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.TermsOfUse",{onInit:function(){this.oRouter=this.getRouter();this.oRouter.getRoute("termsOfUse").attachPatternMatched(this._onTopicMatched,this);},_onTopicMatched:function(e){jQuery.ajax({url:"./TermsOfUse.txt",dataType:"text"}).done(function(t){this.getView().byId("termsOfUseText").setText(t);}.bind(this)).fail(function(){this.oRouter.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}.bind(this));}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Tools.controller',["sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/base/Log"],function(D,B,L){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Tools",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});this.getRouter().getRoute("tools").attachPatternMatched(this._onMatched,this);},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},_onMatched:function(){try{this.hideMasterSide();}catch(e){L.error(e);}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TopicDetail.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/XML2JSONUtils","sap/ui/Device","sap/ui/documentation/sdk/util/ToggleFullScreenHandler"],function(q,B,J,X,D,T){"use strict";return B.extend("sap.ui.documentation.sdk.controller.TopicDetail",{onInit:function(){this.oPage=this.byId("topicDetailPage");this.oPage.addStyleClass('docuPage');if(!window.prettyPrint){q.sap.require("sap.ui.documentation.sdk.thirdparty.google-code-prettify.prettify");}this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);this._oConfig=this.getConfig();this.jsonDefModel=new J();this.getView().setModel(this.jsonDefModel);},onBeforeRendering:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onAfterRendering:function(){D.orientation.attachHandler(this._onOrientationChange,this);},onExit:function(){D.orientation.detachHandler(this._onOrientationChange,this);},_onTopicMatched:function(e){var t=e.getParameter("arguments").id,a=this._oConfig.docuPath+t+(t.match(/\.html/)?"":".html"),h=q.sap.syncGetText(a).data,j;if(!h){setTimeout(function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}.bind(this),0);return;}j=X.XML2JSON(h,this._oConfig);j.topicURL=a;this.jsonDefModel.setData(j);this._scrollContentToTop();setTimeout(window.prettyPrint,0);this.searchResultsButtonVisibilitySwitch(this.byId("topicDetailBackToSearch"));if(this.extHookonTopicMatched){this.extHookonTopicMatched(t);}},_scrollContentToTop:function(){if(this.oPage&&this.oPage.$().length>0){this.oPage.getScrollDelegate().scrollTo(0,1);}},_formatHTML:function(h){return'<div>'+h+'</div>';},backToSearch:function(t){this.onNavBack();},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TopicDetailInitial.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device","sap/ui/thirdparty/jquery"],function(B,D,q){"use strict";return B.extend("sap.ui.documentation.sdk.controller.TopicDetailInitial",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});this.handleDocumentationDisclaimer();},handleDocumentationDisclaimer:function(){q.ajax(this.getConfig().docuPath+"disclaimer.json",{dataType:"json"}).then(function(d){var v=this.getView();if(d.showDisclaimer&&d.message){v.byId("disclaimerBlock").setVisible(true);v.byId("disclaimerMessage").setText(d.message);}}.bind(this),function(){});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},onDownloadButtonPress:function(){window.open(this._determineFileLocation(),"_blank");},_determineFileLocation:function(){var v=this.getModel("versionData"),i=v.getProperty('/isDevVersion'),I=v.getProperty('/isOpenUI5');if(I){return'https://help.sap.com/OpenUI5_PDF/OpenUI5.pdf';}return i?'https://help.sap.com/DRAFT/SAPUI5_Internal_PDF/SAPUI5_Internal.pdf':'https://help.sap.com/SAPUI5_PDF/SAPUI5.pdf';}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TopicMaster.controller',["sap/ui/Device","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/ui/model/json/JSONModel","sap/m/library","sap/base/Log"],function(D,M,J,m,L){"use strict";var S=m.SplitAppMode;return M.extend("sap.ui.documentation.sdk.controller.TopicMaster",{onInit:function(){this.oJSONContent=this._fetchDocuIndex();var o=new J(this.oJSONContent);o.setSizeLimit(10000);this.getView().setModel(o);this._initTreeUtil("key","links");this.getRouter().getRoute("topic").attachPatternMatched(this._onMatched,this);this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);},_onTopicMatched:function(a){try{this.showMasterSide();}catch(e){L.error(e);}this._topicId=a.getParameter("arguments").id;this._expandTreeToNode(this._preProcessTopicID(this._topicId),this.getModel());},_onMatched:function(){var s=this.getView().getParent().getParent();s.setMode(S.ShowHideMode);this._collapseAllNodes();this._clearSelection();if(D.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus();}.bind(this),0);}},_fetchDocuIndex:function(){var r=jQuery.sap.syncGetJSON(this.getConfig().docuPath+"index.json");if(r.data===undefined){return[];}var d=r.data.links;d=this._reorderDocuIndex(d);d=this._addSearchMetadata(d,"");return d;},_reorderDocuIndex:function(d){var s="95d113be50ae40d5b0b562b84d715227",t="1b4124400a764ec0a8623d0d5c585321",p=[],T,o;for(var i=0;i<d.length;i++){if(d[i].key===s){o=d[i];}else if(d[i].key===t){T=d[i];}}if(o){p=o.links;if(T){p.push(T);}}return p;},_addSearchMetadata:function(d,p){for(var i=0;i<d.length;i++){d[i].name=p?p+" "+d[i].text:d[i].text;if(d[i].links){d[i].links=this._addSearchMetadata(d[i].links,d[i].text);}}return d;},onNodeSelect:function(e){var n=e.getParameter("listItem"),t=n.getCustomData()[0].getValue(),r;if(!t){L.warning("Missing key for entity: "+n.getId()+" - cannot navigate to topic");return;}r=this.getRouter();if(t==="a6a78b7e104348b4bb94fb8bcf003480"){r.navTo("releaseNotes");return;}r.navTo("topicId",{id:t},false);},_preProcessTopicID:function(t){if(!t||(typeof t!=="string")){return t;}return t.replace(/\.html$/,"");}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Welcome.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/m/library","sap/ui/Device","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/base/Log"],function(B,m,D,J,R,L){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Welcome",{onInit:function(){var i=new R({bundleName:"sap.ui.documentation.sdk.i18n.i18n"});this.getView().setModel(i,"i18n");this.getRouter().getRoute("welcome").attachPatternMatched(this._onMatched,this);sap.ui.getVersionInfo({async:true}).then(function(v){var M=new J({isOpenUI5:v&&v.gav&&/openui5/i.test(v.gav)});this.getView().setModel(M,"welcomeView");}.bind(this));this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},navigateToDetails:function(e){var h=e.oSource.getHref()||e.oSource.getTarget();h=h.replace("#/","").split('/');var p=h[0];var a=h[1];e.preventDefault();this.getRouter().navTo(p,{id:a},true);},onGetStarted:function(){m.URLHelper.redirect("#/topic/8b49fc198bf04b2d9800fc37fecbb218");},onDownloadButtonPress:function(e){var i=this.getView().getModel("welcomeView").getProperty("/isOpenUI5"),u=i?"http://openui5.org/download.html":"https://tools.hana.ondemand.com/#sapui5";window.open(u,"_blank");},_onMatched:function(){try{this.hideMasterSide();}catch(e){L.error(e);}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/APIInfo',["sap/ui/thirdparty/jquery","sap/base/Log"],function(q,L){"use strict";var t;var l={};var a=null;var b=["sap.ui.demokit","sap.ui.documentation"];var c=["themelib_"];
function g(){if(l["index"]){return Promise.resolve(l["index"]);}return new Promise(function(r,m){q.ajax({async:true,url:"./docs/api/api-index.json",dataType:'json',success:function(R){var n=R.symbols||[];l["index"]=n;r(n);},error:function(){L.error("failed to load api-index.json");l["index"]=[];r([]);}});});}
function d(){if(l["deprecated"]){return Promise.resolve(l["deprecated"]);}return new Promise(function(r,m){q.ajax({async:true,url:"./docs/api/api-index-deprecated.json",dataType:'json',success:function(R){l["deprecated"]=R;r(R);},error:function(){m();}});});}
function e(){if(l["experimental"]){return Promise.resolve(l["experimental"]);}return new Promise(function(r,m){q.ajax({async:true,url:"./docs/api/api-index-experimental.json",dataType:'json',success:function(R){l["experimental"]=R;r(R);},error:function(){m();}});});}
function f(){if(l["since"]){return Promise.resolve(l["since"]);}return new Promise(function(r,m){q.ajax({async:true,url:"./docs/api/api-index-since.json",dataType:'json',success:function(R){l["since"]=R;r(R);},error:function(){m();}});});}
function h(m){var r=[];if(!m){return r;}if(l[m]){return l[m];}q.ajax({async:false,url:t+m.replace(/\./g,'/')+'/designtime/apiref/api.json',dataType:'json',success:function(R){r=R.symbols;},error:function(){r=[];L.error("failed to load api.json for: "+m);}});l[m]=r;return r;}
function i(m){if(!m){return Promise.resolve([]);}if(l[m]){return Promise.resolve(l[m]);}return new Promise(function(r){q.ajax({async:true,url:t+m.replace(/\./g,'/')+'/designtime/apiref/api.json',dataType:'json',success:function(R){var n=R.symbols||[];l[m]=n;r(n);},error:function(n){L.error("failed to load api.json for: "+m);l[m]=[];r([]);}});});}
function j(o){var I=b.indexOf(o.name)!==-1;var S=c.some(function(p){return o.name.indexOf(p)===0;});return!I&&!S;}
function k(m){if(a){return a;}m=m||sap.ui.getVersionInfo().libraries||[];m=m.filter(j);var p=m.map(function(o){return i(o.name);});a=Promise.all(p);return a;}
function s(r){r=r==null?sap.ui.require.toUrl("")+"/"+'../test-resources/':r;if(r.slice(-1)!='/'){r+='/';}t=r;}
s();return{_setRoot:s,getIndexJsonPromise:g,getDeprecatedPromise:d,getExperimentalPromise:e,getSincePromise:f,getLibraryElementsJSONSync:h,getLibraryElementsJSONPromise:i,getAllLibrariesElementsJSONPromise:k};});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/ConfigUtil',["sap/ui/base/Object","sap/base/strings/capitalize"],function(B,c){"use strict";return B.extend("sap.ui.documentation.sdk.controller.util.ConfigUtil",{constructor:function(C){this._oComponent=C;},hasMasterView:function(r){var R=this._getRouteConfig(r),i=R&&R.target.length===2;return!!i;},getMasterView:function(r){var m=this._getMasterTargetName(r),t=this._getTargetConfig(m),v=t.viewName;v="sap.ui.documentation.sdk.view."+c(v,0);return this._oComponent.getRouter().getView(v);},_getMasterTargetName:function(r){var R=this._getRouteConfig(r),i=R&&R.target.length===2,m=i&&R.target[0];return m;},_getRouteConfig:function(r){var C=this._getSapUI5ConfigEntry(),R=C.routing.routes,a=jQuery.grep(R,function(o){return o.name===r;}),o=a.length&&a[0];return o;},_getSapUI5ConfigEntry:function(){return this._oComponent.getMetadata().getManifestObject().getEntry("sap.ui5");},_getTargetConfig:function(t){return this._getSapUI5ConfigEntry().routing.targets[t];},destroy:function(){this._oComponent=null;return B.prototype.destroy.apply(this,arguments);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/ControlsInfo',["sap/ui/thirdparty/jquery",'sap/ui/documentation/library',"sap/base/Log"],function(q,l,L){"use strict";var p;var C={loadData:function(){if(!p){p=new Promise(function(r,a){l._loadAllLibInfo("","_getDocuIndex",function(b,d){var D=C._getIndices(b,d,function(){r(D);});});});}return p;},_getIndices:function(a,d,c){var b=["Action","Application","Container","Display","Chart","Mini Chart","Layout","List","Popup","Tile","User Input","Testing","Theming","Tutorial","Routing","Data Binding","Data Visualization","Map","Utility"];var e=["namespace","since","category"];var f={namespace:{},since:{},category:{},formFactors:{"Independent":true,"Condensed":true,"Compact":true,"Cozy":true}};var F={"-":"Independent","S":"Condensed","SM":"Condensed, Compact","SL":"Condensed, Cozy","SML":"Condensed, Compact, Cozy","M":"Compact","ML":"Compact, Cozy","L":"Cozy"};var g={};g={};g.entityCount=0;g.entities=[];g.filter={};g.samples={};q.each(d,function(i,D){if(!D.explored){return;}else if(!D.explored.samplesRef){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef'");return;}else if(Array.isArray(D.explored.samplesRef)&&D.explored.samplesRef.length!==D.explored.samplesRef.filter(function(I){return I.namespace&&I.ref;}).length){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef.namespace' or 'explored.samplesRef.ref' in one or more of the configured namespaces");return;}else if(!Array.isArray(D.explored.samplesRef)&&!D.explored.samplesRef.namespace){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef.namespace'");return;}else if(!Array.isArray(D.explored.samplesRef)&&!D.explored.samplesRef.ref){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef.ref'");return;}else if(!D.explored.entities){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.entities'");return;}else{L.info("explored: now reading lib '"+D.library+"'");}if(Array.isArray(D.explored.samplesRef)){D.explored.samplesRef.forEach(function(I){(function(){var j={};j[I.namespace.replace(/\./g,"/")]=""+I.ref||".";sap.ui.loader.config({paths:j});}());});}else{(function(){var j={};j[D.explored.samplesRef.namespace.replace(/\./g,"/")]=""+D.explored.samplesRef.ref||".";sap.ui.loader.config({paths:j});}());}q.each(D.explored.samples,function(i,s){if(!s.id){L.error("explored: cannot register sample '?'. missing 'id'");}else if(!s.name){L.error("explored: cannot register sample '"+s.id+"'. missing 'name'");}else{g.samples[s.id]=s;}});q.each(D.explored.entities,function(j,E){if(!E.id){L.error("explored: cannot register entity '?'. missing 'id'");return;}if(D.explored.entitiesDefaults){q.each(D.explored.entitiesDefaults,function(k,v){if(!E.hasOwnProperty(k)){E[k]=v;}});}var I=E.id.lastIndexOf(".");var n=(I!==-1)?E.id.substring(0,I):E.id;E.namespace=n;if(!E.name){L.error("explored: cannot register entity '"+E.id+"'. missing 'name'");return;}if(b.indexOf(E.category)===-1){L.error("explored: cannot register entity '"+E.id+"'. category '"+E.category+"' is not allowed");return;}if(!E.formFactors){L.error("explored: cannot register entity '"+E.id+"'. missing 'formFactors'");return;}if(!F[E.formFactors]){L.error("explored: cannot register entity '"+E.id+"'. formFactors '"+E.formFactors+"' is not allowed");return;}E.formFactors=F[E.formFactors];var A=false;q.each(e,function(i,s){if(!E[s]){L.error("explored: cannot register entity '"+E.id+"'. missing '"+s+"'");A=true;return false;}});if(A){return;}q.each(e,function(i,s){f[s][E[s]]=true;});E.library=D.library;g.entities.push(E);});});q.each(g.entities,function(n,E){var i=0,s,k;E.searchTags=E.name+" "+E.name.replace(/\s/g,"")+" "+E.category;if(E.samples){E.samples.forEach(function(j){var r=g.samples[j];if(r){E.searchTags+=" "+r.name;E.searchTags+=" "+r.description;}});}if(E.samples&&!(E.samples instanceof Array)){E.samples=[];L.error("explored: cannot register samples for entity '"+E.id+"'. 'samples' is not an array");return;}if(!E.samples){E.samples=[];}if(E.samplesAsSteps){if(!(E.samplesAsSteps instanceof Array)){L.error("explored: cannot register samples for entity '"+E.id+"'. 'samplesAsSteps' is not an array");return;}k=function(N){if(N.toString().length===1){return"0"+N;}return N;};for(;i<E.samplesAsSteps.length;i++){s={"id":E.id+"."+k(i+1),"name":E.name+" - Step "+(i+1)+" - "+E.samplesAsSteps[i]};if(i>0){s.previousSampleId=E.id+"."+k(i);}if(i<E.samplesAsSteps.length-1){s.nextSampleId=E.id+"."+k(i+2);}s.entityId=E.id;E.samples.push(s);g.samples[s.id]=s;E.searchTags+=" "+s.name;}}else{var S=[],m;q.each(E.samples,function(j,I){var r=g.samples[I];if(!r){L.warning("explored: cannot register sample '"+I+"' for '"+E.id+"'. not found in the available docu indizes");}else{r.previousSampleId=(m?m.id:undefined);if(m){m.nextSampleId=r.id;}m=r;r.entityId=E.id;S.push(r);E.searchTags+=" "+r.name;}});E.samples=S;}E.sampleCount=E.samples.length;});g.entityCount=g.entities.length;q.each(f,function(s,j){g.filter[s]=[];q.each(j,function(k,v){g.filter[s].push({id:k});});});var o=l._getLibraryInfoSingleton();var h={};var P=[];for(var i=0;i<a.length;i++){P.push(new Promise(function(r){var j=function(k){h[k.library]=k.componentInfo;r();};o._getLibraryInfo(a[i],j);}));}Promise.all(P).then(function(){c&&c();});g.libComponentInfos=h;g.groups=this.getGroups(g.entities);return g;},findGroup:function(g,n){var a;for(var i=0;i<g.length;i++){a=g[i];if(a.name==n){return a;}}},getGroups:function(e){var g=[],a,b,s,c,i,j;for(i=0;i<e.length;i++){a=e[i];a.key='#/entity/'+a.id;s=a.samples;for(j=0;j<s.length;j++){c=s[j];c.key='#/sample/'+c.id+"/preview";}b=this.findGroup(g,a.category);if(!b){b={name:a.category,key:'#/group/'+a.category,controls:[a]};g.push(b);}else{b.controls.push(a);}}return g;}};return C;},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/EntityInfo',["sap/ui/thirdparty/jquery",'sap/ui/documentation/sdk/thirdparty/jsanalyzer/ModuleAnalyzer','./APIInfo',"sap/base/Log","sap/base/util/ObjectPath"],function(q,a,A,L,O){"use strict";var r={};
function g(n){var P=n.split('.');var e=r;var l=P.length-1;for(var i=0;i<l&&!e.__noMetamodel&&!e.__noSource;i++){e=e[P[i]]||(e[P[i]]={});}return e;}
var C="boolean int float number function object string void any Element Control Component";
function b(t,s){if(t.indexOf("/")>=0){return t.replace(/\//g,".");}else if(t&&t.indexOf(".")<0&&C.indexOf(t)>=0){return"sap.ui.core."+t;}else{return s.split(".").slice(0,-1).concat([t.replace(/\//g,".")]).join(".");}}
function p(D,e){var $=q(D.documentElement);var E={metatype:'control',baseType:undefined,doc:undefined,deprecation:undefined,properties:{},aggregations:{},associations:{},events:{},methods:{}};var B=$.children("baseType").text();E.baseType=(B)?b(B,e):null;E.doc=h($);E.deprecation=j($);f($,"properties/property",function(i){E.properties[i.attr("name")]={kind:0,type:b(i.attr("type")||"string",e),defaultValue:i.attr("defaultValue")||"empty/undefined",doc:h(i),deprecation:j(i),since:i.attr("since")||null};});E.defaultAggregation=E.defaultAggregation||$.children("aggregations").attr("default");f($,"aggregations/aggregation",function(i){E.aggregations[i.attr("name")]={kind:i.attr("cardinality")==="0..1"?1:2,type:b(i.attr("type")||"sap.ui.core/Control",e),cardinality:i.attr("cardinality")||"0..n",visibility:i.attr("visibility")||null,doc:h(i),deprecation:j(i),since:i.attr("since")||null};});f($,"associations/association",function(i){E.associations[i.attr("name")]={kind:i.attr("cardinality")==="0..n"?4:3,type:b(i.attr("type")||"sap.ui.core/Control",e),cardinality:i.attr("cardinality")||"0..1",doc:h(i),deprecation:j(i),since:i.attr("since")||null};});f($,"events/event",function(i){var n=i.attr("name");E.events[n]={kind:5,doc:h(i),deprecation:j(i),since:i.attr("since")||null,parameters:[]};f(i,"parameters/parameter",function(l){E.events[n].parameters[l.attr("name")]={kind:6,type:b(l.attr("type")||"string",e),doc:h(l),since:l.attr("since")||null,deprecation:j(l)};});});f($,"methods/method",function(i){var n=i.attr("name");E.methods[n]={kind:7,type:b(i.attr("type")||"sap.ui.core/void",e),doc:h(i),deprecation:j(i),since:i.attr("since")||null,parameters:[]};f(i,"parameters/parameter",function(l){E.methods[n].parameters.push({kind:8,name:l.attr("name"),type:b(l.attr("type")||"sap.ui.core/Control",e),doc:h(l),since:l.attr("since")||null,deprecation:j(l)});});});return E;}
function c(D,e){var $=q(D.documentElement);var E={metatype:'type',doc:undefined,deprecation:false,values:{}};E.doc=h($);E.deprecation=j($);f($,"enumeration/value",function(i){var n=i.attr("name");E.values[n]={value:i.attr("value")||n,doc:h(i),deprecation:j(i)};});E.pattern=$.children("pattern").text();E.baseType=b($.children("baseType").text(),e);return E;}
function d(D,e,M){return a.analyze(D,e,M);}
function f($,N,l){q.each(N.split("/"),function(i,n){$=$.children(n);});q.each(function(i,e){l(q(e));});}
function h($){return $.children("documentation").text();}
function j($){return $.children("deprecation").text();}
function k(n,t,D,P,e){var E;q.ajax({async:false,url:sap.ui.require.toUrl((n).replace(/\./g,"/"))+t,dataType:D,success:function(R){E=P(R,e,n.replace(/\./g,'/'));},error:function(i){L.debug("tried to load entity docu for: "+n+t);}});return E;}
function m(e){var v=sap.ui.getVersionInfo(),l,n,i;if(v&&Array.isArray(v.libraries)){n=v.libraries.length;for(i=0;i<n;i++){l=v.libraries[i];if(e===l.name||e.indexOf(l.name+".")===0){return l.name;}}}return"sap.ui.core";}
function o(e,l){var P=g(e);var E;if(!l){var n=O.get(e||"");if(n&&n.getMetadata){var M=n.getMetadata();if(M.getLibraryName){l=M.getLibraryName();}else{l="sap.ui.core";}}else{l=m(e);}}if(!E&&!P.__noAPIJson){return A.getLibraryElementsJSONPromise(l).then(function(t){var u;for(var i=0,v=t.length;i<v;i++){if(t[i].name===e){u=t[i];break;}}if(u){E={baseType:u.extends,deprecation:u.deprecated?u.deprecated.text:null,doc:u.description,module:u.module,name:u.name,since:u.since,values:u.properties,uxGuidelinesLink:u.uxGuidelinesLink,uxGuidelinesLinkText:u.uxGuidelinesLinkText,docuLink:u.docuLink,docuLinkText:u.docuLinkText};P.__noSource=true;P.__noMetamodel=true;}return E;});}else if(P.__noAPIJson){L.debug("ancestor package for "+e+" is marked with 'noMetamodel'");}if(!E&&!P.__noMetamodel){E=k(e,".control","xml",p,e);if(!E){E=k(e,".type","xml",c,e);}if(!E){E=k(e,".js","text",d,e);}if(E){P.__noSource=true;}}else if(P.__noMetamodel){L.debug("ancestor package for "+e+" is marked with 'noMetamodel'");}if(!E&&!P.noSource){var s=e.replace(/\.[^.]+$/,".library");E=k(s,".js","text",d,e);if(!E){E=k(s,".js","text",d,e);}if(E){P.__noMetamodel=true;}}else if(P.__noSource){L.debug("ancestor package for "+e+" is marked with 'noSource'");}return E;}
return{getEntityDocuAsync:function(e,l){return o(e,l);}};},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/JSDocUtil',["sap/base/strings/escapeRegExp"],function(e){"use strict";
function d(t,a){return"<code>"+(a||t)+"</code>";}
function f(s,o){o=o||{};var b=o.beforeParagraph==null?'<p>':o.beforeParagraph;var a=o.afterParagraph==null?'</p>':o.afterParagraph;var c=o.beforeFirstParagraph==null?b:o.beforeFirstParagraph;var g=o.afterLastParagraph==null?a:o.afterLastParagraph;var l=typeof o.linkFormatter==='function'?o.linkFormatter:d;var r=/(<pre>)|(<\/pre>)|(<h[\d+]>)|(<\/h[\d+]>)|\{@link\s+([^}\s]+)(?:\s+([^\}]*))?\}|((?:\r\n|\r|\n)[ \t]*(?:\r\n|\r|\n))/gi;var i=false;s=s||'';l=l||d;s=c+s.replace(r,function(m,p,h,j,k,n,q,t){if(p){i=true;}else if(h){i=false;}else if(j){if(!i){return a+m;}}else if(k){if(!i){return m+b;}}else if(t){if(!i){return a+b;}}else if(n){if(!i){return l(n,q);}}return m;})+g;s=s.replace(new RegExp(e(b)+"\s*"+e(a),"g"),"");return s;}
return{formatTextBlock:f};});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/TreeUtil',[],function(){"use strict";var T=function(n,c){this.nodeIdField=n;this.childrenField=c;};
T.prototype.getPathToNode=function(n,t){var s=[];this._walkTree(n,t,s);return s;};
T.prototype._walkTree=function(n,t,s){var f=this._findLeaf(t,n);if(f){s.push(n);return true;}for(var i=0;i<t.length;i++){if(t[i][this.childrenField]){s.push(t[i][this.nodeIdField]);if(this._walkTree(n,t[i][this.childrenField],s)){return true;}s.pop();}}};
T.prototype._findLeaf=function(t,n){for(var i=0;i<t.length;i++){if(t[i][this.nodeIdField]===n){return t[i];}}return null;};
return T;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/XML2JSONUtils',["sap/ui/thirdparty/jquery"],function(q){"use strict";
function b(a,c){var d=x(a,c);var s=["topictitle1","shortdesc"];var p=function(h,i){var X=i||d;var n=X.getElementsByClassName(h);if(n.length===0){return'';}var k=q("<div/>").html(r(n[0].innerHTML)).text();return n&&n.length>0&&("innerHTML"in n[0])&&k||'';};var r=function(t){return t.replace(/<[^>]*>/g," ").replace(/\s{2,}/g,' ');};var f=function(h){var l=h.querySelectorAll("a.xref, a.link, area"),i,k,m,n,o;for(i=0;i<l.length;i++){k=l[i];m=k.getAttribute("href");n=m.indexOf("#")==0;o=m.indexOf("http")==0;if(o){k.setAttribute('target','_blank');}if(o||n){continue;}if(m.indexOf("/docs/api/")>-1){m=m.substr(0,m.lastIndexOf(".html"));m=m.substr(m.lastIndexOf('/')+1);m="#/api/"+m;}else if(m.indexOf("explored.html")>-1){m=m.split("../").join("");m=c.exploredURI+m;}else{m=m.substr(0,m.lastIndexOf(".html"));m="#/topic/"+m;}k.setAttribute("href",m);}};var e=function(h){var k=h.querySelectorAll("img");for(var i=0;i<k.length;i++){k[i].setAttribute("src",c.docuPath+k[i].getAttribute("src"));}return h.innerHTML;};var g=function(){var w=d,h=w.querySelectorAll("script, .topictitle1, .shortdesc, #local-navigation, header, #footer-container, nav.mobile-nav, #breadcrumb-container, #content-toolbar"),k,i;for(var i=0;i<h.length;i++){k=h[i].parentElement;k.removeChild(h[i]);}f(w);e(w);j['html']=w.innerHTML;};var j={};s.forEach(function(h,i){j[h]=p(h);});g();return j;}
function x(a,c){var d=q.parseHTML(a);var m=c.topicHtmlMainDivId;for(var i=0;i<d.length;i++){if(d[i].getAttribute&&d[i].getAttribute("id")===m){var n='<div id ="'+m+'">'+d[i].innerHTML+'</div>';d[i].innerHTML=n;return d[i];}}}
return{DomXml2JSON:b,XML2DOM:x,XML2JSON:b};});
sap.ui.predefine('sap/ui/documentation/sdk/controls/BorrowedList',['sap/ui/core/Control'],function(C){"use strict";return C.extend("sap.ui.documentation.sdk.controls.BorrowedList",{metadata:{properties:{list:{type:"array"}}},renderer:function(r,c){var l=c.getList(),I,L,i;r.write("<div");r.writeControlData(c);r.write(">");for(i=0,L=l.length;i<L;i++){I=l[i];r.write(['<a href="',I.link,'" role="link" tabindex="0" class="sapMLnk sapMLnkMaxWidth sapUiTinyMargin">',I.name,'</a>'].join(""));}r.write("</div>");}});});
sap.ui.predefine('sap/ui/documentation/sdk/controls/DemokitTreeItem',["sap/m/TreeItemBase"],function(T){"use strict";return T.extend("sap.ui.documentation.sdk.controls.DemokitTreeItem",{metadata:{properties:{title:{type:"string",defaultValue:""},deprecated:{type:"boolean",defaultValue:false}}},init:function(){T.prototype.init.call(this);this.addStyleClass("sapDemokitTreeItem");}});});
sap.ui.predefine('sap/ui/documentation/sdk/controls/DemokitTreeItemRenderer',['sap/m/TreeItemBaseRenderer','sap/ui/core/Renderer'],function(T,R){"use strict";var D=R.extend(T);
D.renderLIContent=function(r,c){r.write('<span');r.addClass("sapDemokitTreeItemTitle");r.addClass("sapUiTinyMarginEnd");r.writeClasses();r.write('>');r.writeEscaped(c.getTitle());r.write('</span>');if(c.getDeprecated()){r.write('<span');r.addClass("sapDemokitTreeItemLabel");r.writeClasses();r.write('>');r.write("Deprecated");r.write('</span>');}};
return D;},true);
sap.ui.predefine('sap/ui/documentation/sdk/controls/JSDocText',['sap/ui/core/Control',"sap/base/security/sanitizeHTML"],function(C,s){"use strict";return C.extend("sap.ui.documentation.sdk.controls.JSDocText",{metadata:{properties:{text:{type:"string",defaultValue:""}}},renderer:function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiJSD");r.writeClasses();r.write(">");r.write(s(c.getText()));r.write("</div>");}});});
sap.ui.predefine('sap/ui/documentation/sdk/controls/LightTable',['sap/ui/core/Control'],function(C){"use strict";return C.extend("sap.ui.documentation.sdk.controls.LightTable",{metadata:{properties:{columnTitles:{type:"string[]"},columnCount:{type:"int"}},defaultAggregation:"rows",aggregations:{rows:{type:"sap.ui.documentation.sdk.controls.Row",multiple:true}}},renderer:function(r,c){var R=c.getRows(),b,d=c.getColumnTitles(),l,a,L,i;r.write("<div");r.writeControlData(c);r.addClass("sapUiDocLightTable");r.addClass("columns-"+c.getColumnCount());r.writeClasses();r.write(">");r.write("<div class='head'>");for(i=0,L=d.length;i<L;i++){r.write("<div class='cell'>");r.writeEscaped(d[i]);r.write("</div>");}r.write("</div>");for(i=0,L=R.length;i<L;i++){r.write("<div class='row'>");b=R[i].getContent();for(a=0,l=b.length;a<l;a++){r.write("<div class='cell'>");if(a>0){r.write("<div class='inTitle'>");r.writeEscaped(d[a]);r.write(":</div>");}r.renderControl(b[a]);r.write("</div>");}r.write("</div>");}r.write("</div>");}});});
sap.ui.predefine('sap/ui/documentation/sdk/controls/ObjectPageSubSection',['sap/ui/core/Control','sap/uxap/ObjectPageSubSection'],function(C,O){"use strict";
var S=O.extend("sap.ui.documentation.sdk.controls.ObjectPageSubSection",{renderer:"sap.uxap.ObjectPageSubSectionRenderer"});
var a=new C.extend("Container",{
metadata:{aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},
renderer:function(r,c){var b=c.getContent(),l,i;r.write("<div>");for(i=0,l=b.length;i<l;i++){r.renderControl(b[i]);}r.write("</div>");}
});
S.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new a({id:this.getId()+"-innerGrid"}),true);}return this.getAggregation("_grid");};
return S;});
sap.ui.predefine('sap/ui/documentation/sdk/controls/ParamText',['sap/ui/core/Control','sap/ui/Device'],function(C,D){"use strict";
var P=C.extend("sap.ui.documentation.sdk.controls.ParamText",{
metadata:{properties:{text:{type:"string",defaultValue:""},phoneText:{type:"string",defaultValue:""},depth:{type:"int",defaultValue:0},optional:{type:"boolean",defaultValue:false},defaultFlag:{type:"boolean",defaultValue:false},deprecated:{type:"boolean",defaultValue:false},experimental:{type:"boolean",defaultValue:false},href:{type:"sap.ui.core.URI"}},events:{press:{}}},
_getText:function(){var p=this.getPhoneText();return D.system.phone&&p?p:this.getText();},
renderer:function(r,c){var h=c.getHref();if(h){r.write("<a");r.writeAttributeEscaped("href",h);r.addClass("sapMLnk");}else{r.write("<div");}r.addClass("depth-"+c.getDepth());r.writeControlData(c);r.addClass("sapUiParamText");r.writeClasses();r.write(">");r.writeEscaped(c._getText());if(c.getOptional()){r.write("?");}if(c.getDefaultFlag()){r.write("<span");r.addClass("parameterDefault");r.writeClasses();r.write(">");r.write("(default)");r.write("</span>");}if(h){r.write("</a>");r.write("<div");r.addClass("sapUiParamText");r.writeClasses();r.write(">");}if(c.getDeprecated()){r.write("<div");r.addClass("deprecated");r.writeClasses();r.write(">");r.writeIcon('sap-icon://message-error');r.write("<span");r.addClass("deprecatedText");r.writeClasses();r.write(">");r.write("Deprecated");r.write("</span>");r.write("</div>");}if(c.getExperimental()){r.write("<div");r.addClass("experimental");r.writeClasses();r.write(">");r.writeIcon('sap-icon://message-warning');r.write("<span");r.addClass("experimentalText");r.writeClasses();r.write(">");r.write("Experimental");r.write("</span>");r.write("</div>");}r.write("</div>");}
});
P.prototype._handlePress=function(e){this.firePress({});};
if(D.support.touch){P.prototype.ontap=P.prototype._handlePress;}else{P.prototype.onclick=P.prototype._handlePress;}return P;});
sap.ui.predefine('sap/ui/documentation/sdk/controls/Row',['sap/ui/core/Element'],function(E){"use strict";return E.extend("sap.ui.documentation.sdk.controls.Row",{metadata:{properties:{visible:{type:"boolean"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controls/Search',['sap/ui/core/Control','sap/m/Button','sap/m/SearchField','sap/m/library'],function(C,B,S,m){"use strict";
var a=C.extend("sap.ui.documentation.sdk.controls.Search",{
metadata:{properties:{isOpen:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{_openingButton:{type:"sap.m.Button",multiple:false},_closingButton:{type:"sap.m.Button",multiple:false},_searchField:{type:"sap.m.SearchField",multiple:false}},events:{toggle:{isOpen:{type:"boolean"}},search:{parameters:{query:{type:"string"},suggestionItem:{type:"sap.m.SuggestionItem"},refreshButtonPressed:{type:"boolean"},clearButtonPressed:{type:"boolean"}}}}},
renderer:function(r,c){var w=c.getWidth(),o,b,s;r.write("<div");r.writeControlData(c);if(w){r.writeAttribute("style","width:"+w+";");}r.addClass("sapUiDocumentationSearch");r.writeClasses();r.write(">");if(c.getIsOpen()){s=c._lazyLoadSearchField(true);b=c._lazyLoadClosingButton(true);r.renderControl(s);r.renderControl(b);}else{o=c._lazyLoadOpeningButton(true);r.renderControl(o);}r.write("</div>");}
});
a.prototype.onAfterRendering=function(){if(this.getIsOpen()){this._maximizeSearchField();}};
a.prototype._maximizeSearchField=function(){return this._resizeSearchField("100%");};
a.prototype._minimizeSearchField=function(){return this._resizeSearchField("10%");};
a.prototype._resizeSearchField=function(w){return new Promise(function(r,b){var $=this.$("searchField");if(!$.length){b();}if($.css("max-width")===w){r();}$.one("webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend",function(){r();});$.css("max-width",w);}.bind(this));};
a.prototype._toggleOpen=function(o){this.setIsOpen(o);this.fireToggle({isOpen:o});};
a.prototype._lazyLoadOpeningButton=function(s){if(!this.getAggregation("_openingButton")){var b=new B(this.getId()+"-openingBtn",{icon:"sap-icon://search",type:m.ButtonType.Transparent,press:function(){this._toggleOpen(true);}.bind(this)});b.addStyleClass("sdkHeaderSearchButton");this.setAggregation("_openingButton",b,s);}return this.getAggregation("_openingButton");};
a.prototype._lazyLoadClosingButton=function(s){if(!this.getAggregation("_closingButton")){var b=new B(this.getId()+"-closingBtn",{text:"Close",type:m.ButtonType.Transparent,press:function(){this._minimizeSearchField().then(function(){this._toggleOpen(false);}.bind(this));}.bind(this)});this.setAggregation("_closingButton",b,s);}return this.getAggregation("_closingButton");};
a.prototype._lazyLoadSearchField=function(s){if(!this.getAggregation("_searchField")){var o=new S(this.getId()+"-searchField",{showSearchButton:true,search:function(e){var p=e.getParameters();p.id=this.getId();this.fireSearch(p);}.bind(this)});o.addStyleClass("sdkHeaderSearchField");this.setAggregation("_searchField",o,s);}return this.getAggregation("_searchField");};
return a;});
sap.ui.predefine('sap/ui/documentation/sdk/controls/TitleLink',['sap/ui/core/library','sap/ui/Device','sap/m/Toolbar','sap/m/Title'],function(c,D,T,a){"use strict";var b=c.TextAlign;var d=c.TitleLevel;
var e=a.extend("sap.ui.documentation.sdk.controls.TitleLink",{
metadata:{properties:{target:{type:"string",group:"Behavior",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},filter:{type:"string",group:"Data",defaultValue:""},wrap:{type:"boolean",group:"Behavior",defaultValue:true}},events:{press:{allowPreventDefault:true}}},
init:function(){if(D.support.touch){this.ontap=this._handlePress;}else{this.onclick=this._handlePress;}this.ontouchstart=function(E){if(this.getHref()){E.setMarked();}};},
onsapspace:function(E){this._handlePress(E);if(this.getHref()&&!E.isDefaultPrevented()){E.preventDefault();E.setMarked();var C=document.createEvent('MouseEvents');C.initEvent('click',false,true);this.getDomRef().dispatchEvent(C);}},
_handlePress:function(E){E.setMarked();if(!this.firePress()||!this.getHref()){E.preventDefault();}},
setHref:function(u){this.setProperty("href",u,true);u=this.getProperty("href");this.$().attr("href",u);return this;},
setTarget:function(t){this.setProperty("target",t,true);if(!t){this.$().removeAttr("target");}else{this.$().attr("target",t);}return this;},
renderer:function(r,t){var A=t._getTitle(),l=(A?A.getLevel():t.getLevel())||c.TitleLevel.Auto,f=l==d.Auto,s=f?"div":l;r.write("<",s);r.writeControlData(t);r.addClass("sapUiDocTitleLink");r.addClass("sapMTitle");r.addClass("sapMTitleStyle"+(t.getTitleStyle()||c.TitleLevel.Auto));r.addClass("sapUiSelectable");if(t.getWrap()){r.addClass("wrap");}else{r.addClass("sapMTitleNoWrap");}var w=t.getWidth();if(!w){r.addClass("sapMTitleMaxWidth");}else{r.addStyle("width",w);}var g=t.getTextAlign();if(g&&g!=b.Initial){r.addClass("sapMTitleAlign"+g);}if(t.getParent()instanceof T){r.addClass("sapMTitleTB");}var h=A?A.getTooltip_AsString():t.getTooltip_AsString();if(h){r.writeAttributeEscaped("title",h);}if(f){r.writeAttribute("role","heading");}r.writeClasses();r.writeStyles();r.write(">");r.write("<a");r.addClass("sapMLnk");if(t.getText()){r.writeAttribute("tabIndex","0");}else{r.writeAttribute("tabIndex","-1");}r.writeAttributeEscaped("href",t.getHref());if(t.getTarget()){r.writeAttributeEscaped("target",t.getTarget());}r.writeClasses();r.write(">");r.write("<span");r.writeAttribute("id",t.getId()+"-inner");r.write(">");r.writeEscaped(A?A.getText():t.getText());r.write("</span></",s,">");r.write("</a>");}
});
return e;});
sap.ui.predefine('sap/ui/documentation/sdk/model/formatter',["sap/ui/documentation/sdk/controller/util/JSDocUtil"],function(J){"use strict";return{crossLink:function(l){if(l[0]==="#"){l=document.location.href.substring(0,document.location.href.search("demoapps\.html"))+l;}return l;},libraryLink:function(n){if(n&&n.search("sap\\.")===0){return this.formatter.crossLink("#docs/api/symbols/"+n+".html");}else{return"";}},libraryLinkEnabled:function(n){return!!this.formatter.libraryLink.bind(this)(n);},categoryName:function(c){var r=this.getView().getModel("i18n").getResourceBundle();return r.getText("demoAppCategory"+c);},encodeModuleName:function(m){if(m){return encodeURIComponent(m);}},decodeModuleName:function(m){if(m){return decodeURIComponent(m);}},apiRefEntityName:function(o){if(o){return o.replace("module:","");}},apiRefAggregationAltTypes:function(a){return a&&a.join(", ");},formatVersionTitle:function(t){return t?"As of "+t:"Version N/A";},formatSenderLink:function(c,e,E){if(E==="methods"){return c+"#"+e;}if(E==="events"){return c+"#events:"+e;}if(E==="class"){return c;}return"";},formatIndexByVersionEntry:function(c,e,E,s,t){var T=this.formatSenderLink(c,e,E),h=this.formatApiHref(c,e,E,s),d=this.formatLinks(t);return'<a href="'+h+'" class="sapMLnk sapMLnkMaxWidth">'+T+'</a>'+d;},formatApiHref:function(c,e,E,s){var h;if(s){e=c+"."+e;}h="#/api/"+c;if(E!=="class"){h+="/"+E+"/"+e;}return h;},formatLinks:function(t){return J.formatTextBlock(t,{linkFormatter:function(a,b){var h;if(a.match("://")){return'<a target="_blank" href="'+a+'">'+(b||a)+'</a>';}a=a.trim().replace(/\.prototype\./g,"#");h=a.indexOf("#");b=b||a;if(h<0){var l=a.lastIndexOf("."),c=a.substring(0,l),m=a.substring(l+1),d=m;if(d){if(d.static===true){a=c+'/methods/'+c+'.'+m;}else{a=c+'/methods/'+m;}}}if(h===0){return"<code>"+a.slice(1)+"</code>";}if(h>0){a=a.slice(0,h)+'/methods/'+a.slice(h+1);}return"<a class=\"jsdoclink\" href=\"#/api/"+a+"\" target=\"_self\">"+b+"</a>";}});}};});
sap.ui.predefine('sap/ui/documentation/sdk/model/libraryData',["sap/ui/thirdparty/jquery",'sap/ui/documentation/library',"sap/base/Log"],function(q,l,L){"use strict";
function c(d,s,b){var e=[];if(q.isPlainObject(d.links)){e=Object.keys(d.links).map(function(k){return{name:k,ref:d.links[k]};});}var A={lib:d.namespace||b,name:d.text,icon:d.icon,desc:d.desc,config:d.config,teaser:d.teaser,category:d.category,ref:(d.resolve==="lib"?s:"")+d.ref,links:e};return A;}
function a(b,d){var C=["Showcase","Tutorial","Template","RTA","Misc"];var D={};C.forEach(function(s){D[s]=[];});var o={demoApps:[],demoAppsByCategory:[]};for(var i=0;i<b.length;i++){var e=d[b[i]].demo;if(!e){continue;}if(e.links&&e.links.length>0){for(var j=0;j<e.links.length;j++){var f=c(e.links[j],d[b[i]].libraryUrl,e.text);o.demoApps.push(f);if(C.indexOf(f.category)<0){L.warning("Demo app category \""+f.category+"\" not found, correcting demo app \""+f.name+"\" to \"Misc\"");f.category="Misc";}if(e.links[j].category!=="Tool"){D[f.category].push(f);}}}}Object.keys(D).forEach(function(k){if(D[k].length===0){return;}var r=[];var g=r.push([]);var h=0;for(var i=0;i<D[k].length;i++){h++;if(D[k][i].teaser){h++;}if(h>4){g=r.push([]);h=0;}r[g-1].push(D[k][i]);}o.demoAppsByCategory.push({categoryId:k,rows:r});});return o;}
return{fillJSONModel:function(m){function h(b,d){m.setProperty("/bFooterVisible",true);if(!b){return;}var M=m.getData();m.setData(q.extend(M,a(b,d)));}m.setProperty("/bFooterVisible",false);l._loadAllLibInfo("","_getDocuIndex",h);}};});
sap.ui.predefine('sap/ui/documentation/sdk/model/models',["sap/ui/model/json/JSONModel","sap/ui/Device"],function(J,D){"use strict";return{createDeviceModel:function(){var m=new J(D);m.setDefaultBindingMode("OneWay");return m;}};});
sap.ui.predefine('sap/ui/documentation/sdk/model/sourceFileDownloader',["sap/ui/thirdparty/jquery"],function(q){"use strict";var c={};return function(u){return new Promise(function(r){var s=function(a){c[u]=a;r(a);};var e=function(){r({errorMessage:"FIle not found: '"+u+"'"});};if(!(u in c)){q.ajax(u,{dataType:"text",success:s,error:e});}else{r(c[u]);}});};});
sap.ui.predefine('sap/ui/documentation/sdk/util/DocumentationRouter',['sap/m/routing/Router','sap/ui/core/routing/History','sap/ui/thirdparty/hasher'],function(R,H,a){"use strict";var n={sampleLegacyRoute:"sample",codeLegacyRoute:"code",codeFileLegacyRoute:"code_file"};a.raw=true;return R.extend("sap.ui.documentation.sdk.util.DocumentationRouter",{constructor:function(){R.prototype.constructor.apply(this,arguments);this.getRoute("entitySamplesLegacyRoute").attachPatternMatched(this._onEntityOldRouteMatched,this);this.getRoute("entityAboutLegacyRoute").attachPatternMatched(this._onEntityOldRouteMatched,this);this.getRoute("entityPropertiesLegacyRoute").attachPatternMatched({entityType:"controlProperties"},this._forwardToAPIRef,this);this.getRoute("entityAggregationsLegacyRoute").attachPatternMatched({entityType:"aggregations"},this._forwardToAPIRef,this);this.getRoute("entityAssociationsLegacyRoute").attachPatternMatched({entityType:"associations"},this._forwardToAPIRef,this);this.getRoute("entityEventsLegacyRoute").attachPatternMatched({entityType:"events"},this._forwardToAPIRef,this);this.getRoute("entityMethodsLegacyRoute").attachPatternMatched({entityType:"methods"},this._forwardToAPIRef,this);this.getRoute("topicIdLegacyRoute").attachPatternMatched(this._onOldTopicRouteMatched,this);this.getRoute("apiIdLegacyRoute").attachPatternMatched(this._onOldApiRouteMatched,this);this.getRoute("sampleLegacyRoute").attachPatternMatched(this._onNewSampleRouteMatched,this);this.getRoute("codeLegacyRoute").attachPatternMatched(this._onNewSampleRouteMatched,this);this.getRoute("codeFileLegacyRoute").attachPatternMatched(this._onNewSampleRouteMatched,this);},_onNewSampleRouteMatched:function(e){var p=e.getParameter("name"),A=e.getParameter("arguments"),N={id:A.sampleId};if(p==="codeFileLegacyRoute"){N.fileName=A.fileName;}this.navTo(n[p],N);},_onEntityOldRouteMatched:function(e){this.navTo("entity",{id:e.getParameter("arguments").id});},_forwardToAPIRef:function(e,d){d||(d={});d['id']=e.getParameter("arguments").id;this.navTo("apiId",d);},_onOldTopicRouteMatched:function(e){this.navTo("topicId",{id:e.getParameter("arguments").id.replace(/.html$/,"")});},_onOldApiRouteMatched:function(e){var E,s,S,i=e.getParameter("arguments").id;if(i){S=i.split("#");if(S.length===2){i=S[0];E=S[1];S=E.split(":");if(S.length===2){E=S[0];s=S[1];}}i=i.replace(/.html$/,"");if(E==='event'){E="events";}}this.navTo("apiId",{id:i,entityType:E,entityId:s});},myNavBack:function(r,d){var h=H.getInstance();var p=h.getPreviousHash();if(p!==undefined){window.history.go(-1);}else{var b=true;this.navTo(r,d,b);}},myNavToWithoutHash:function(v,b,m,d){var c=this._getOwnerComponent(),r=c.byId(c.getManifestEntry("/sap.ui5/rootView").id),A=r.byId("splitApp"),V=this.getView(v,b);A.addPage(V,m);A.toDetail(V.getId(),"show",d);},_getOwnerComponent:function(){return this._oOwner;},_destroySampleComponent:function(){var c=this._getOwnerComponent()._oCurrentOpenedSample;if(c){c.destroy();c=null;}},navTo:function(){this._destroySampleComponent();R.prototype.navTo.apply(this,arguments);}});});
sap.ui.predefine('sap/ui/documentation/sdk/util/ToggleFullScreenHandler',[],function(){"use strict";var T={updateMode:function(e,v,c){var s=(this._getSplitApp(c).getMode()==="ShowHideMode");if(s){this._getSplitApp(c).setMode('HideMode');}else{this._getSplitApp(c).setMode('ShowHideMode');}this.updateControl(e.getSource(),v,s,c);},_getSplitApp:function(c){if(!this._oSplitApp){this._oSplitApp=c.getSplitApp();}return this._oSplitApp;},updateControl:function(b,v,f,c){if(arguments.length===2){f=!(this._getSplitApp(c).getMode()==="ShowHideMode");}if(!f){b.setTooltip("Show this sample in full screen mode");b.setIcon('sap-icon://full-screen');}else{b.setTooltip("Show this sample in the detail view of a split container.");b.setIcon('sap-icon://exit-full-screen');}},cleanUp:function(){this._oSplitApp=null;}};return T;},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/License.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/library"],function(B,l){"use strict";return B.extend("sap.ui.documentation.sdk.controller.License",{onInit:function(){this.getRouter().getRoute("license").attachPatternMatched(this._onTopicMatched,this);},_onTopicMatched:function(e){
// Get the LICENSE.txt file and display it. In case of error redirect to NotFound view.
l._getLicense().done(function(L){if(L!==""){this.getView().byId("licenseText").setText(L);}else{this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}}.bind(this)).fail(function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}.bind(this));}});});
sap.ui.require.preload({
	"sap/ui/documentation/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.documentation","type":"library","embeds":["sdk"],"applicationVersion":{"version":"1.60.20"},"title":"SAPUI5 library for the Demokit 2.0.","description":"SAPUI5 library for the Demokit 2.0.","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"esprima","packagedWithMySelf":true,"version":"0.0.0"},{"name":"google-code-prettify","packagedWithMySelf":true,"version":"0.0.0"}]},"sap.ui":{"technology":"UI5","supportedThemes":[]},"sap.ui5":{"dependencies":{"minUI5Version":"1.60","libs":{"sap.ui.core":{"minVersion":"1.60.20"},"sap.ui.layout":{"minVersion":"1.60.20"},"sap.m":{"minVersion":"1.60.20"}}},"library":{"i18n":false,"css":false,"content":{"controls":["sap.ui.documentation.sdk.controls.Search","sap.ui.documentation.sdk.controls.ObjectPageSubSection","sap.ui.documentation.sdk.controls.LightTable","sap.ui.documentation.sdk.controls.Row"],"elements":[],"types":[],"interfaces":[]}}}}',
	"sap/ui/documentation/sdk/blocks/IndexEntry.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.blocks.IndexEntry" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:custom="sap.ui.documentation.sdk.controls" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><m:List items="{path:\'apis\',templateShareable:\'false\'}" showSeparators="Inner" class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><m:items><m:CustomListItem class="indexEntry"><custom:JSDocText text="{parts:[{path:\'control\'},{path:\'entityName\'},{path:\'type\'},{path:\'static\'},{path:\'text\'}],formatter:\'.formatText\'}" app:control="{control}" app:entity="{entityName}" app:type="{type}" app:static="{static}" app:text="{text}"/></m:CustomListItem></m:items></m:List></mvc:View>',
	"sap/ui/documentation/sdk/manifest.json":'{"_version":"1.8.0","sap.app":{"id":"sap.ui.documentation.sdk","type":"application","title":"OpenUI5 SDK - Demo Kit v2.0","applicationVersion":{"version":"1.0.0"}},"sap.ui":{"technology":"UI5","icons":{"icon":"sap-icon://detail-view","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.documentation.sdk.view.App","type":"XML","async":true,"id":"app"},"dependencies":{"minUI5Version":"1.46.0","libs":{"sap.ui.core":{"minVersion":"1.46.0"},"sap.m":{"minVersion":"1.46.0"},"sap.ui.layout":{"minVersion":"1.46.0"},"sap.f":{"minVersion":"1.46.0"},"sap.uxap":{"minVersion":"1.46.0"},"sap.tnt":{"minVersion":"1.46.0"},"sap.ui.codeeditor":{"minVersion":"1.46.0"}}},"contentDensities":{"compact":true,"cozy":true},"config":{"docuPath":"./docs/topics/","exploredURI":"./","topicHtmlMainDivId":"d4h5-main-container"},"routing":{"config":{"routerClass":"sap.ui.documentation.sdk.util.DocumentationRouter","viewType":"XML","viewPath":"sap.ui.documentation.sdk.view","controlId":"splitApp","controlAggregation":"detailPages","bypassed":{"target":["welcome"]},"async":true,"clearTarget":false},"routes":[{"pattern":"","name":"welcome","target":["welcome"]},{"pattern":"controlsMaster","name":"controlsMaster","target":["controlsMaster"]},{"pattern":"controls","name":"controls","target":["controlsMaster","controls"],"subroutes":[{"pattern":"controls/filter/{value}","name":"listFilter","target":["controlsMaster","controls"]}]},{"pattern":"group/{id}","name":"group","target":["controlsMaster","group"]},{"pattern":"entity/{id}/samples","name":"entitySamplesLegacyRoute"},{"pattern":"entity/{id}/about","name":"entityAboutLegacyRoute"},{"pattern":"entity/{id}/properties","name":"entityPropertiesLegacyRoute"},{"pattern":"entity/{id}/aggregations","name":"entityAggregationsLegacyRoute"},{"pattern":"entity/{id}/associations","name":"entityAssociationsLegacyRoute"},{"pattern":"entity/{id}/events","name":"entityEventsLegacyRoute"},{"pattern":"entity/{id}/methods","name":"entityMethodsLegacyRoute"},{"pattern":"entity/{id}/:sectionTab:","name":"entity","target":["controlsMaster","entity"]},{"pattern":"sample/{id}/preview","name":"sample","target":["controlsMaster","sample"]},{"pattern":"sample/{id}/code","name":"code","target":["controlsMaster","code"]},{"pattern":"sample/{id}/code/{fileName}","name":"code_file","target":["controlsMaster","code"]},{"pattern":"entity/{entityId}/sample/{sampleId}","name":"sampleLegacyRoute"},{"pattern":"entity/{entityId}/sample/{sampleId}/code","name":"codeLegacyRoute"},{"pattern":"entity/{entityId}/sample/{sampleId}/code/{fileName}","name":"codeFileLegacyRoute"},{"pattern":"downloads","name":"downloads","target":["downloads"]},{"pattern":"api","name":"api","target":["apiMaster","apiDetailInitial"]},{"pattern":"api/deprecated","name":"deprecated","target":["apiMaster","apiDetailDeprecated"]},{"pattern":"api/experimental","name":"experimental","target":["apiMaster","apiDetailExperimental"]},{"pattern":"api/since","name":"since","target":["apiMaster","apiDetailSince"]},{"pattern":"api/{id}/:entityType:/:entityId:","name":"apiId","target":["apiMaster","apiDetail"]},{"pattern":"topic","name":"topic","target":["topicMaster","topicDetailInitial"]},{"pattern":"topic/{id}","name":"topicId","target":["topicMaster","topicDetail"]},{"pattern":"demoapps","name":"demoapps","target":["demoApps"]},{"pattern":"tools","name":"tools","target":["tools"]},{"pattern":"search/{searchParam}","name":"search","target":["searchPage"]},{"pattern":"releasenotes.html","name":"releaseNotes","target":["topicMaster","releaseNotes"]},{"pattern":"versioninfo.html","name":"versionInfo","target":["topicMaster","versionInfo"]},{"pattern":"LICENSE.txt","name":"license","target":["license"]},{"pattern":"TermsOfUse.txt","name":"termsOfUse","target":["termsOfUse"]},{"pattern":"docs/guide/{id}","name":"topicIdLegacyRoute"},{"pattern":"docs/api/symbols/{id}","name":"apiIdLegacyRoute"}],"targets":{"empty":{"viewName":"Empty","viewLevel":1,"viewId":"empty","controlAggregation":"masterPages"},"welcome":{"viewName":"Welcome","viewLevel":2,"viewId":"welcome"},"controls":{"viewName":"Controls","viewLevel":2,"viewId":"controls"},"controlsMaster":{"viewName":"ControlsMaster","viewLevel":1,"viewId":"controlsMaster","controlAggregation":"masterPages"},"group":{"viewName":"Group","viewLevel":2,"viewId":"group"},"entity":{"viewName":"Entity","viewLevel":2,"viewId":"entity"},"sample":{"viewName":"Sample","viewLevel":2,"viewId":"sample"},"code":{"viewName":"Code","viewLevel":2,"viewId":"code","transition":"flip"},"downloads":{"viewName":"Downloads","viewLevel":2,"viewId":"downloads"},"apiMaster":{"viewName":"ApiMaster","viewLevel":1,"viewId":"apiMaster","controlAggregation":"masterPages"},"demoApps":{"viewName":"DemoApps","viewLevel":2,"viewId":"demoApps"},"tools":{"viewName":"Tools","viewLevel":2,"viewId":"tools"},"apiDetailInitial":{"viewName":"ApiDetailInitial","viewId":"apiDetailInitial","viewLevel":2},"apiDetail":{"viewName":"ApiDetail","viewId":"apiDetail","viewLevel":2},"apiDetailDeprecated":{"viewName":"ApiDetailDeprecated","viewId":"apiDetailDeprecated","viewLevel":2},"apiDetailExperimental":{"viewName":"ApiDetailExperimental","viewId":"apiDetailExperimental","viewLevel":2},"apiDetailSince":{"viewName":"ApiDetailSince","viewId":"apiDetailSince","viewLevel":2},"topicMaster":{"viewName":"TopicMaster","viewLevel":1,"viewId":"topicMaster","controlAggregation":"masterPages"},"topicDetailInitial":{"viewName":"TopicDetailInitial","viewId":"topicDetailInitial","viewLevel":2},"topicDetail":{"viewName":"TopicDetail","viewId":"topicDetail","viewLevel":2},"searchPage":{"viewName":"SearchPage","viewId":"searchPage","viewLevel":2,"controlAggregation":"detailPages"},"notFound":{"viewName":"NotFound","viewId":"notFound"},"releaseNotes":{"viewName":"ReleaseNotes","viewLevel":2,"viewId":"releaseNotes","controlAggregation":"detailPages"},"license":{"viewName":"License","viewLevel":2,"viewId":"releaseNotes","controlAggregation":"detailPages"},"termsOfUse":{"viewName":"TermsOfUse","viewLevel":2,"viewId":"termsOfUse","controlAggregation":"detailPages"},"versionInfo":{"viewName":"VersionInfo","viewLevel":2,"viewId":"versionInfo","controlAggregation":"detailPages"}}}}}',
	"sap/ui/documentation/sdk/view/AboutDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:f="sap.ui.layout.form" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation.sdk.controls"><Dialog id="aboutDialog" resizable="true" draggable="true" title="About" contentWidth="42rem" contentHeight="50rem" showHeader="false" stretch="{appView&gt;/bPhoneSize}" class="aboutDialog"><NavContainer id="aboutNavCon"><Page id="aboutMaster" title="About"><VBox class="sapUiSmallMargin"><Image id="aboutLogoSAP" src="./resources/sap/ui/documentation/sdk/images/Logo_B_SAPUI5_H.png" densityAware="false" width="100%" class="sapUiSmallMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><Image id="aboutLogoUI5" src="./resources/sap/ui/documentation/sdk/images/Logo_B_OpenUI5_H.png" densityAware="false" width="100%" class="sapUiSmallMarginBottom" visible="{versionData&gt;/isOpenUI5}"/><Text text="UI5 Demo Kit - UI Development Toolkit for HTML5" class="sapMTitleStyleH2 sapUiSmallMarginBottom"/><Text text="© Copyright 2009-2018 SAP SE. All rights reserved." class="sapUiMediumMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><Text text="© 2009-2018 SAP SE or an SAP affiliate company." visible="{versionData&gt;/isOpenUI5}"/><custom:JSDocText class="sapUiMediumMarginBottom" visible="{versionData&gt;/isOpenUI5}" text="Licensed under the Apache License, Version 2.0 – see &lt;a href=\'LICENSE.txt\' target=\'_blank\' class=\'sapMLnk sapMLnkMaxWidth aboutLink\'&gt;LICENSE.txt&lt;/a&gt;"/><Text text="{versionData&gt;/versionName} Version {versionData&gt;/fullVersion}" class="sapMTitleStyleH4 sapUiSmallMarginBottom"/><Text text="Open UI5 Version {versionData&gt;/openUi5Version}" class="sapMTitleStyleH5 sapUiSmallMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><Text text="This software includes the following library versions"/><custom:JSDocText class="sapUiTinyMarginBottom" text="(a full change log for all libraries can be found &lt;a href=\'releasenotes.html\' target=\'_blank\' class=\'sapMLnk sapMLnkMaxWidth aboutLink\'&gt;here&lt;/a&gt;)."/><Link text="Version Details" press="onAboutVersionDetails" class="sapUiSmallMarginBottom"/><Text text="This software includes third-party open source software." class="sapUiTinyMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><Link text="Included Third-Party Software" press="onAboutThirdParty" class="sapUiSmallMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><MessageStrip showIcon="true" text="{= ${versionData&gt;/isOpenUI5} ? ${appView&gt;/sAboutInfoOpenUI5} : ${appView&gt;/sAboutInfoSAPUI5}}" class="sapUiSmallMarginBottom" enableFormattedText="true"/></VBox></Page><Page id="aboutDetail" showNavButton="true" navButtonPress="onAboutNavBack" title="Version Details"><l:VerticalLayout class="sapUiSmallMargin" content="{path:\'appView&gt;/oVersionInfo/libs\'}"><f:Form width="100%" editable="false"><f:title><core:Title text="{appView&gt;library}"/></f:title><f:layout><f:ResponsiveGridLayout/></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement label="Version"><f:fields><Text text="{appView&gt;version}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement><f:FormElement label="Description"><f:fields><Text text="{appView&gt;documentation}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement><f:FormElement label="Change Log" visible="{=!!${appView&gt;releasenotes}}"><f:fields><Link text="Open Change Log" press="onReleaseDialogOpen" class="sapUiSmallMarginBottom"><customData><core:CustomData key="library" value="{appView&gt;library}"/><core:CustomData key="version" value="{versionData&gt;/version}"/></customData></Link></f:fields></f:FormElement><f:FormElement label="Component" visible="{=!!${appView&gt;libDefaultComponent}}"><f:fields><Text text="{appView&gt;libDefaultComponent}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form></l:VerticalLayout></Page><Page id="aboutThirdParty" showNavButton="true" navButtonPress="onAboutNavBack" title="Included Third-Party Software"><l:VerticalLayout class="sapUiSmallMargin" content="{path:\'appView&gt;/oThirdPartyInfo/thirdparty\'}"><f:Form width="100%" editable="false"><f:title><core:Title text="{appView&gt;displayName}"/></f:title><f:layout><f:GridLayout/></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement><f:fields><Link text="Web Site" target="_blank" href="{appView&gt;homepage}" class="sapUiSmallMarginBottom"/><Link text="License Conditions" target="_blank" href="{appView&gt;license/url}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement><f:FormElement><f:fields><Link text="Licensed by SAP under \'{appView&gt;license/type}\'" target="_blank" href="{appView&gt;license/file}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form></l:VerticalLayout></Page></NavContainer><beginButton><Button id="aboutDialogCloseButton" text="Close" press="aboutDialogClose"/></beginButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ApiDetail.view.xml":'<mvc:View xmlns="sap.m" xmlns:mvc="sap.ui.core.mvc" controllerName="sap.ui.documentation.sdk.controller.ApiDetail"><Page id="apiDetailPageContainer" showHeader="false" showSubHeader="false" showFooter="false" busyIndicatorDelay="0" busy="true" class="apiDetailPage"/></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailDeprecated.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><ObjectPageLayout id="objectPage" upperCaseAnchorBar="false" sections="{/}"><headerTitle><ObjectPageHeader objectTitle="Index of Deprecated APIs"/></headerTitle><headerContent><m:MessageStrip text="For general information about Deprecated features, please check the Compatibility Rules." type="Error" class="specialListsMessageStrip" showIcon="true"/></headerContent><ObjectPageSection titleUppercase="false" title="{parts:[{path:\'name\'}],formatter:\'.formatter.formatVersionTitle\'}"><ObjectPageSubSection><m:List items="{path:\'apis\',templateShareable:\'false\'}" updateFinished="._modifyLinks" showSeparators="Inner" class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><m:items><m:FeedListItem showIcon="false" sender="{parts:[{path:\'control\'},{path:\'entityName\'},{path:\'type\'}],formatter:\'.formatter.formatSenderLink\'}" text="{path:\'text\',formatter:\'.formatter.formatLinks\'}" class="specialListFeedItem" app:control="{control}" app:entity="{entityName}" app:type="{type}" app:static="{static}"/></m:items></m:List></ObjectPageSubSection></ObjectPageSection></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailExperimental.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><ObjectPageLayout id="objectPage" upperCaseAnchorBar="false" sections="{/}"><headerTitle><ObjectPageHeader objectTitle="Index of Experimental APIs"/></headerTitle><headerContent><m:MessageStrip enableFormattedText="true" text="Experimental features are not part of the officially delivered scope that SAP is going to guarantee for future releases – means experimental Features may be changed by SAP at any time for any reason without notice. The Experimental features are NOT FOR PRODUCTION USE. You may not demonstrate, test, examine, evaluate or otherwise use the Experimental Features in a live operating environment or with data that has not been sufficiently backed up. The purpose of Experimental features is to get feedback at an early point of time allowing customers/partners to influence the future product accordingly. Please use the SDN Developer Center &lt;a target=\'_blank\' href=\'https://www.sap.com/developer/topics/ui5.html\'&gt;https://www.sap.com/developer/topics/ui5.html&lt;/a&gt; to provide feedback accepting that Intellectual Property rights of the contributions or derivative works shall remain the exclusive property of SAP. For general information about Experimental features, please check the Compatibility Rules" type="Warning" showIcon="true" class="specialListsMessageStrip"/></headerContent><ObjectPageSection titleUppercase="false" title="{parts:[{path:\'name\'}],formatter:\'.formatter.formatVersionTitle\'}"><ObjectPageSubSection><m:List items="{path:\'apis\',templateShareable:\'false\'}" updateFinished="._modifyLinks" showSeparators="Inner" class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><m:items><m:FeedListItem showIcon="false" sender="{parts:[{path:\'control\'},{path:\'entityName\'},{path:\'type\'}],formatter:\'.formatter.formatSenderLink\'}" text="{path:\'text\',formatter:\'.formatter.formatLinks\'}" class="specialListFeedItem" app:control="{control}" app:entity="{entityName}" app:type="{type}" app:static="{static}"/></m:items></m:List></ObjectPageSubSection></ObjectPageSection></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailInitial.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailInitial" xmlns="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation.sdk.controls"><Page showHeader="false"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/API_ref_S_cropped.jpg" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/API_ref_M_and_L_cropped.jpg" width="100%" class="landingImage" densityAware="false" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><Text id="landingImageHeadline" class="sapUiDocumentationApiHeaderText sapUiDocumentationApiHeaderTitleText" text="API Reference" width="100%" textAlign="Left"/></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell title="Featured Namespaces" class="sapUiDemokitLandingBlockHeadline" backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA"/></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell width="2" class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Main Controls" href="#/api/sap.m"/><Text text="Responsive controls for touch-enabled devices and desktop browsers" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.m"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Layout" href="#/api/sap.ui.layout.form.Form"/><Label text="Namespace: sap.ui.layout"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Tables" href="#/api/sap.ui.table"/><Text text="Tables for desktop-type scenarios" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.ui.table"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="SAP Fiori" href="#/api/sap.f"/><Text text="Controls specialized for SAP Fiori applications" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.f"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="SAP Fiori for Tools" href="#/api/sap.tnt"/><Text text="Controls specialized for administrative applications" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.tnt"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA" width="2"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="UI5 Core Runtime" href="#/api/sap.ui.core"/><Text text="Boots the core framework and makes it available for the application via method sap.ui.getCore()" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.ui.core"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD" width="2"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Object Page" href="#/api/sap.uxap"/><Text text="Controls for displaying, creating and editing objects" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.uxap"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB" width="2"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Models" href="#/api/sap.ui.model"/><Text text="Data binding utilities" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.ui.model"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow visible="{= !${versionData&gt;/isOpenUI5}}"><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA" width="2"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Smart Controls" href="#/api/sap.ui.comp"/><Text text="Metadata-driven controls" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.ui.comp"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Micro Charts" href="#/api/sap.suite.ui.microchart"/><Text text="Lightweight diagrams" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.suite.ui.microchart"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Charts" href="#/api/sap.viz"/><Text text="Data visualization" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.viz"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailSince.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:custom="sap.ui.documentation.sdk.controls" xmlns:blocks="sap.ui.documentation.sdk.blocks" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><ObjectPageLayout id="objectPage" enableLazyLoading="true" showAnchorBarPopover="true" upperCaseAnchorBar="false" useIconTabBar="true" sections="{/}"><headerTitle><ObjectPageHeader objectTitle="Index by Version"/></headerTitle><ObjectPageSection titleUppercase="false" title="As of {name}"><ObjectPageSubSection><blocks:IndexEntry/></ObjectPageSubSection></ObjectPageSection></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiMaster.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiMaster" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation.sdk.controls" class="sapContrast sapContrastPlus"><Page id="page" enableScrolling="true" showFooter="false" navButtonPress="onNavBack" showNavButton="false" class="sapUiDocumentationMasterPage"><customHeader><Toolbar width="100%"><SearchField id="searchField" placeholder="Filter" liveChange="onTreeFilter" class="sapUiDocumentationFilterField"/><Button id="expandAllButton" icon="sap-icon://expand-all" press="onTreeExpandAll"/><Button id="collapseAllButton" icon="sap-icon://collapse-all" press="onTreeCollapseAll"/></Toolbar></customHeader><subHeader><Toolbar><CheckBox id="includeDeprecated" text="Include deprecated" class="sapUiNoMarginBegin" select="onIncludeDeprecatedItemsChange"/></Toolbar></subHeader><content><Tree id="tree" mode="SingleSelectMaster" selectionChange="onNodeSelect" noDataText="No data, please try with the global search" items="{path:\'treeData&gt;/\',sorter:{path:\'name\',comparator:\'.compareTreeNodes\'}}"><custom:DemokitTreeItem title="{path:\'treeData&gt;text\',formatter:\'.formatter.apiRefEntityName\'}" deprecated="{treeData&gt;bIsDeprecated}"><custom:customData><core:CustomData key="nodeId" value="{treeData&gt;name}"/></custom:customData></custom:DemokitTreeItem></Tree></content></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/App.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.App" xmlns="sap.m" xmlns:tnt="sap.tnt" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns:custom="sap.ui.documentation.sdk.controls" xmlns:html="http://www.w3.org/1999/xhtml" displayBlock="true" busy="{appView&gt;/busy}" busyIndicatorDelay="{appView&gt;/delay}"><Page showHeader="false" enableScrolling="false" showNavButton="false" class="sapUiDemokit"><content><tnt:ToolHeader id="headerToolbar"><ToggleButton icon="sap-icon://menu2" type="Transparent" visible="{= ${appView&gt;/bHasMaster} &amp;&amp; !${appView&gt;/bPhoneSize} &amp;&amp; !${appView&gt;/bLandscape} &amp;&amp; !${appView&gt;/bSearchMode} }" press="toggleMaster" pressed="{appView&gt;/bIsShownMaster}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></ToggleButton><html:a href="#" class="sapLogo">\n\t\t\t\t\t<Image id="sap_logo" src="./resources/sap/ui/documentation/sdk/images/logo_ui5.png" densityAware="false" height="2rem" alt="UI5 logo" decorative="false"/>\n\t\t\t\t</html:a><core:ExtensionPoint name="customStartLinks"/><Select id="selectHeader" class="sapUiDocumentationSelect menuSelect" visible="{=${appView&gt;/bPhoneSize}}" change="navigateToSection" autoAdjustWidth="true"><items><core:Item text="Home" key="home"/><core:Item text="Documentation" key="topic"/><core:Item text="API Reference" key="api"/><core:Item text="Samples" key="controls"/><core:Item text="Demo Apps" key="demoapps"/><core:Item text="Tools" key="tools"/></items><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" shrinkable="true"/></layoutData></Select><IconTabHeader id="tabHeader" selectedKey="home" showOverflowSelectList="true" backgroundDesign="Transparent" mode="Inline" select="navigateToSection" visible="{=!${appView&gt;/bPhoneSize}}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" shrinkable="true"/></layoutData><items><IconTabFilter id="welcomeTab" text="Home" key="home" visible="{=${appView&gt;/bPhoneSize}}"/><IconTabFilter id="topicMasterTab" text="Documentation" key="topic" visible="{= !${appView&gt;/bHideTopicSection}}"/><IconTabFilter id="apiMasterTab" text="API Reference" key="api" visible="{= !${appView&gt;/bHideApiSection}}"/><IconTabFilter id="controlsMasterTab" text="Samples" key="controls"/><IconTabFilter id="demoAppsTab" text="Demo Apps" key="demoapps"/><IconTabFilter id="toolsTab" text="Tools" key="tools"/></items></IconTabHeader><ToolbarSpacer><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" minWidth="{= ${device&gt;/system/tablet} ? \'\' : \'1rem\'}"/></layoutData></ToolbarSpacer><ObjectStatus text="{= ${versionData&gt;/isBetaVersion} ? \'Beta version\' : \'Version\'} {versionData&gt;/version} {= ${versionData&gt;/isBetaVersion} ? \'– not for productive use!\' : ${versionData&gt;/isDevVersion} ? \'- development in progress!\' : \'\'}" state="{= ${versionData&gt;/isBetaVersion} ? \'Error\' : ${versionData&gt;/isDevVersion} ? \'Warning\' : \'None\'}" visible="{=!${appView&gt;/bPhoneSize}}"/><Button id="changeVersionButton" press="onChangeVersionButtonPress" type="Transparent" text="Change version" visible="{appView&gt;/bShowVersionSwitchInHeader}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><custom:Search id="searchControl" toggle="onToggleSearchMode" search="onSearch" width="{= (${appView&gt;/bPhoneSize} &amp;&amp; ${appView&gt;/bSearchMode}) ? \'100%\' : \'\'}"/><Button id="feedBackDialogButton" press="feedbackDialogOpen" icon="sap-icon://comment" type="Transparent" visible="{=!${appView&gt;/bPhoneSize} &amp;&amp; !${appView&gt;/bSearchMode}}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><MenuButton id="aboutMenuButton" icon="sap-icon://hint" type="Transparent" visible="{=!${appView&gt;/bSearchMode}}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData><menu><Menu id="aboutMenu" class="sapContrast sapContrastPlus" itemSelected="handleMenuItemClick"><items><MenuItem text="{= ${versionData&gt;/isBetaVersion} ? \'Beta\' : \'\'} Version {versionData&gt;/version} {=${versionData&gt;/isDevVersion} ? \'- development in progress!\' : \'\'}" visible="{appView&gt;/bPhoneSize}"/><MenuItem text="Change version" visible="{appView&gt;/bShowVersionSwitchInMenu}"/><MenuItem text="Feedback" visible="{appView&gt;/bPhoneSize}"/><MenuItem id="aboutMenuItem" text="About"/><MenuItem text="Legal"/><MenuItem text="Privacy"/><MenuItem text="Terms of Use" visible="{=!${versionData&gt;/isOpenUI5}}"><items><MenuItem text="Terms of Use"/><MenuItem text="Copyright"/><MenuItem text="Trademark"/><MenuItem text="Disclaimer"/></items></MenuItem><MenuItem text="License" visible="{versionData&gt;/isOpenUI5}"/><MenuItem text="Terms of Use" visible="{versionData&gt;/isOpenUI5}"/></items></Menu></menu></MenuButton><core:ExtensionPoint name="customLinks"/></tnt:ToolHeader><Bar visible="{= ${appView&gt;/bPhoneSize} &amp;&amp; ${appView&gt;/bHasMaster}}" class="sapContrast sapContrastPlus"><contentLeft><ToggleButton icon="sap-icon://menu2" type="Transparent" press="toggleMaster" pressed="{appView&gt;/bIsShownMaster}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></ToggleButton></contentLeft></Bar><core:ExtensionPoint name="customControls"/><ScrollContainer id="contentId" width="100%" height="{= ${appView&gt;/bPhoneSize} &amp;&amp; ${appView&gt;/bHasMaster} ? \'calc(100% - 5rem)\' : \'calc(100% - 3rem)\'}" horizontal="false" vertical="false"><SplitApp id="splitApp" mode="HideMode" defaultTransitionNameDetail="show" defaultTransitionNameMaster="fade"/></ScrollContainer></content><footer><core:ExtensionPoint name="footer"/></footer></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/BlockLayoutCell.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout" xmlns:custom="sap.ui.documentation.sdk.controls"><l:BlockLayoutCell width="2"><l:VerticalLayout width="100%"><core:Icon src="sap-icon://{icon}" size="2rem" color="Default"/><custom:TitleLink level="H1" titleStyle="H1" text="{name}" href="{ref}" target="_blank" class="sapUiTinyMarginTop"/><Text text="{desc}" class="sapUiTinyMarginBottom"/><l:VerticalLayout content="{links}" class="sapUiTinyMarginBottom" visible="{= ${links}.length === 0 ? false : true }"><Link href="{path:\'ref\',formatter:\'.formatter.crossLink\'}" target="_blank" text="{name}"/></l:VerticalLayout><l:HorizontalLayout><Label design="Bold" text="{i18n&gt;demoAppTileLibrary}" class="sapUiTinyMarginEnd"/><Link text="{lib}" href="{path:\'lib\',formatter:\'.formatter.libraryLink\'}" target="_blank" enabled="{path:\'lib\',formatter:\'.formatter.libraryLinkEnabled\'}" emphasized="true"/></l:HorizontalLayout></l:VerticalLayout></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/BlockLayoutTeaserCell.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout" xmlns:custom="sap.ui.documentation.sdk.controls"><l:BlockLayoutCell width="4"><l:Grid hSpacing="0" defaultSpan="L6 M12 S12"><l:VerticalLayout class="sapUiTinyMarginEnd" width="100%"><core:Icon src="sap-icon://{icon}" size="2rem" color="Default"/><custom:TitleLink level="H1" titleStyle="H1" text="{name}" href="{ref}" target="_blank" class="sapUiTinyMarginTop"/><Text text="{desc}" class="sapUiTinyMarginBottom"/><l:VerticalLayout content="{links}" class="sapUiTinyMarginBottom" visible="{= ${links}.length === 0 ? false : true }"><Link href="{path:\'ref\',formatter:\'.formatter.crossLink\'}" target="_blank" text="{name}"/></l:VerticalLayout><l:HorizontalLayout><Label design="Bold" text="{i18n&gt;demoAppTileLibrary}" class="sapUiTinyMarginEnd"/><Link text="sap.m" href="{path:\'lib\',formatter:\'.formatter.libraryLink\'}" target="_blank" enabled="{path:\'lib\',formatter:\'.formatter.libraryLinkEnabled\'}" emphasized="true"/></l:HorizontalLayout></l:VerticalLayout></l:Grid></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ChangeVersionDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Dialog title="Change version" contentHeight="400px" stretch="{appView&gt;/bPhoneSize}"><endButton><Button text="Close" press="onCloseVersionDialog"/></endButton><subHeader><Bar><contentMiddle><SearchField liveChange="onChangeVersionDialogSearch" showSearchButton="false"/></contentMiddle></Bar></subHeader><List id="versionList" itemPress="onVersionItemPress" items="{path:\'/\',sorter:[{path:\'groupTitle\',descending:true,group:true,comparator:\'.versionSwitchCustomComparator\'},{path:\'patchVersion\',descending:true}]}"><StandardListItem title="{path:\'version\'}" type="Active"><customData><core:CustomData key="path" value="{path:\'path\'}"/></customData></StandardListItem></List></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Code.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Code" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout" xmlns="sap.m" xmlns:ce="sap.ui.codeeditor" height="100%"><Page id="page" showHeader="false" showNavButton="true" navButtonPress="onNavBack" title="{/title}" icon="img/144_iPad_Retina_Web_Clip.png" enableScrolling="false"><landmarkInfo><PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"/></landmarkInfo><subHeader><Bar id="header" class="sapContrast sapContrastPlus"><contentLeft><Button type="Back" press="onNavBack"/></contentLeft><contentMiddle><Title text="{/title}"/></contentMiddle><contentRight><Button id="apiRefButton" text="API Reference" type="Emphasized" press="onAPIRefPress" visible="false"/><Button class="sapUiHideOnPhone" text="Download" icon="sap-icon://download" press="onDownload"/><Button class="sapUiVisibleOnlyOnPhone" icon="sap-icon://download" press="onDownload"/></contentRight></Bar></subHeader><content><l:FixFlex><l:fixContent><IconTabHeader id="tabHeader" showOverflowSelectList="true" mode="Inline" items="{/files}" select="handleTabSelectEvent" selectedKey="{/fileName}"><items><IconTabFilter key="{name}" text="{name}"/></items></IconTabHeader></l:fixContent><l:flexContent><ce:CodeEditor id="codeEditor" editable="false"/></l:flexContent></l:FixFlex></content></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/Controls.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Controls" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation.sdk.controls"><ScrollContainer width="100%" height="100%" horizontal="false" vertical="true"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/Explored_S_cropped.jpg" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/Explored_M_and_L_cropped.jpg" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><l:VerticalLayout id="landingImageHeadline" visible="false" width="100%"><Text class="sapUiDocumentationExploredHeaderText sapUiDocumentationExploredHeaderTitleText" text="Samples" width="100%" textAlign="Left"/><Text class="sapUiDocumentationExploredHeaderText sapUiDocumentationExploredSubText" text="Explore and download code samples" width="100%" textAlign="Left"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell title="Featured Controls" class="sapUiDemokitLandingBlockHeadline" backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA"/></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://edit" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Input" filter="Input" text="Input" titleStyle="H2"/><Text text="User interaction"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon src="sap-icon://list" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/List" filter="List" text="Lists" titleStyle="H2"/><Text text="Various list structures"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon src="sap-icon://table-view" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Table" filter="Table" text="Tables" titleStyle="H2"/><Text text="Simple or more powerful tables"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://popup-window" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Popup" filter="Popup" text="Pop-Ups" titleStyle="H2"/><Text text="Dialogs and popovers"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon src="sap-icon://grid" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Tile" filter="Tile" text="Tiles" titleStyle="H2"/><Text text="Tiles for e.g. texts, images or charts"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon src="sap-icon://message-popup" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Message" filter="Message" text="Messages" titleStyle="H2"/><Text text="User notification"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://header" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Bar" filter="Bar" text="Bars" titleStyle="H2"/><Text text="Toolbars and headers"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon src="sap-icon://tree" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Tree" filter="Tree" text="Trees" titleStyle="H2"/><Text text="Hierarchical data representation"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow visible="{= !${versionData&gt;/isOpenUI5}}"><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon src="sap-icon://lightbulb" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Smart" filter="Smart" text="Smart Controls" titleStyle="H2"/><Text text="Metadata-driven controls"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://map-2" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Map" filter="Map" text="Maps" titleStyle="H2"/><Text text="Location visualization"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon src="sap-icon://filter-analytics" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Chart" filter="Chart" text="Charts" titleStyle="H2"/><Text text="Data visualization"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon src="sap-icon://process" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Process" filter="Process" text="Processes" titleStyle="H2"/><Text text="Step-based Interactions"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell title="Layout &amp; Pages" class="sapUiDemokitLandingBlockHeadline" backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA"/></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://write-new" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Object Page" filter="Object Page" text="Object Page" titleStyle="H2"/><Text text="Displaying, creating, or editing objects"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon src="sap-icon://chart-table-view" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Dynamic Page" filter="Dynamic Page" text="Dynamic Page" titleStyle="H2"/><Text text="Page with title, header, and content area" class="sapUiTinyMarginBottom"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon src="sap-icon://screen-split-three" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Flexible Column Layout" filter="Flexible Column Layout" text="Flexible Column Layout" titleStyle="H2"/><Text text="Page with up to 3 columns"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon src="sap-icon://screen-split-one" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="#controls/filter/Split App" filter="Split App" text="Split App" titleStyle="H2"/><Text text="Two-column layout" class="sapUiTinyMarginBottom"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></ScrollContainer></mvc:View>',
	"sap/ui/documentation/sdk/view/ControlsMaster.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ControlsMaster" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m" class="sapContrast sapContrastPlus"><Page id="exploredMasterPage" showFooter="false" navButtonPress="onNavBack" showNavButton="false" class="sapUiDocumentationMasterPage"><customHeader><Toolbar width="100%"><SearchField id="searchField" placeholder="Filter" liveChange="handleListFilter" class="sapUiDocumentationFilterField"/><Button id="listFilterSettings" icon="sap-icon://drop-down-list" press="handleListSettings"/><Button id="sampleSettings" icon="sap-icon://action-settings" press="handleSettings"/></Toolbar></customHeader><content><List id="exploredMasterList" mode="{viewModel&gt;/listMode}" selectionChange="onNavToEntity" noDataText="No data, please try with the global search" items="{path:\'/entities\',groupHeaderFactory:\'.getGroupHeader\',sorter:[{path:\'category\',descending:false,group:true},{path:\'name\',descending:false}]}"><infoToolbar><Toolbar id="vsFilterBar" active="true" visible="false" press="handleListSettings"><Label id="vsFilterLabel"/></Toolbar></infoToolbar><items><StandardListItem title="{name}" counter="{sampleCount}" type="{viewModel&gt;/listItemType}" press="onNavToEntity"/></items></List></content></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/DemoApps.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.DemoApps" xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns:l="sap.ui.layout"><Page id="demoAppsPage" showSubHeader="false" showFooter="false" showHeader="false" class="sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo headerRole="Region" headerLabel="{i18n&gt;RootView_headerLabel}" contentRole="Main" contentLabel="{i18n&gt;RootView_contentLabel}"/></landmarkInfo><content><ScrollContainer vertical="true" width="100%" height="100%"><Panel id="rootPage" accessibleRole="Region" class="sapUiNoContentPadding"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/DemoApps_S_cropped.jpg" alt="{i18n&gt;imagePhone}" width="100%" class="welcomeImage" load="handleLandingImageLoad" visible="{device&gt;/system/phone}" densityAware="false"/><l:BlockLayout id="headerLayout" background="Light"><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiDemokitLandingImageCell sapUiNoContentPadding welcomeImageCell"><Image id="desktopImage" class="desktopImage welcomeImage" src="./resources/sap/ui/documentation/sdk/images/DemoApps_M_and_L_cropped.jpg" alt="{i18n&gt;imageComp}" densityAware="false" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}" width="100%"/><l:Grid id="landingImageHeadline" width="100%" visible="false" class="headerGrid" hSpacing="0" defaultSpan="L6 M6 S12"><l:VerticalLayout width="100%" class="sapUiTinyMarginTop sapUiTinyMarginEnd"><Text class="headerText" text="{i18n&gt;pageTitle}" width="100%" textAlign="Left"/><l:HorizontalLayout><Button class="actionButton headerButton" id="download" text="{i18n&gt;downloadButtonText}" type="Emphasized" press="onDownloadButtonPress"/><Button class="actionButton headerButton sapContrast sapContrastPlus sapUiSmallMarginBegin" id="readMoreButton" text="{i18n&gt;linkText}" type="Ghost" press="onReadMoreButtonPress"/></l:HorizontalLayout></l:VerticalLayout><Image src="resources/sap/ui/documentation/sdk/images/demoAppsTeaser.png" alt="{i18n&gt;imageAllDev}" densityAware="false" class="sapUiHideOnPhone" visible="{=!${device&gt;/system/phone}}" width="100%"/></l:Grid></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><l:VerticalLayout content="{/demoAppsByCategory}" width="100%"><Panel accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title text="{path:\'categoryId\',formatter:\'.formatter.categoryName\'}" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout content="{rows}" background="Light"><l:BlockLayoutRow content="{path:\'\',factory:\'.createDemoAppCell\'}"/></l:BlockLayout></Panel></l:VerticalLayout><l:BlockLayout id="demoAppsFooter" visible="{/bFooterVisible}"><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></ScrollContainer></content><dependents><SelectDialog id="downloadDialog" items="{/demoApps}" title="{i18n&gt;downloadDialogTitle}" liveChange="onSearch" confirm="onDownloadPress"><InputListItem visible="{= !!${config} }" label="{name}" type="Active"><customData><core:CustomData key="config" value="{config}"/></customData><Button text="{i18n&gt;downloadButtonText}" type="Emphasized" press="onDownloadPress"/></InputListItem></SelectDialog></dependents></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/Downloads.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Downloads" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><Label text="Downloads"/></mvc:View>',
	"sap/ui/documentation/sdk/view/Empty.view.xml":'<mvc:View xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><Label text="Empty"/></mvc:View>',
	"sap/ui/documentation/sdk/view/Entity.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Entity" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:m="sap.m" xmlns:l="sap.ui.layout" xmlns="sap.uxap" xmlns:html="http://www.w3.org/1999/xhtml"><ObjectPageLayout id="ObjectPageLayout" useIconTabBar="true" selectedSection="samples" upperCaseAnchorBar="false" busyIndicatorDelay="0"><headerTitle><ObjectPageHeader id="entityHeader" objectTitle="{/name}"><actions><ObjectPageHeaderActionButton id="entityBackToSearch" text="Back to search results" hideIcon="true" hideText="false" press="backToSearch" visible="false"/><ObjectPageHeaderActionButton id="toggleFullScreenBtn" visible="{device&gt;/system/desktop}" icon="sap-icon://full-screen" tooltip="Show this sample in full screen mode" press="onToggleFullScreen"/></actions></ObjectPageHeader></headerTitle><headerContent><l:Grid defaultSpan="L4 M6 S12" class="sapUiNoMargin" hSpacing="0"><l:VerticalLayout width="98%" id="headerColumn0"/><l:VerticalLayout width="100%" id="headerColumn1" visible="false"/><l:VerticalLayout width="100%" id="headerColumn2" visible="false"/></l:Grid></headerContent><sections><ObjectPageSection id="about" title="About"><subSections><ObjectPageSubSection><l:VerticalLayout><core:HTML content="{/description}"/><l:VerticalLayout visible="{/show/introLink}"><m:Text text="{/shortDescription}"/></l:VerticalLayout></l:VerticalLayout></ObjectPageSubSection></subSections></ObjectPageSection><ObjectPageSection id="samples" title="Samples ({/count/samples})" visible="{= ${/count/samples} &gt; 0 }"><subSections><ObjectPageSubSection><m:Table class="myTable sapUxAPObjectPageSubSectionAlignContent" width="auto" id="table" items="{/entity/samples}" fixedLayout="false" showSeparators="Inner"><m:columns><m:Column><m:Label text="Name"/></m:Column><m:Column minScreenWidth="Tablet"><m:Label text="Description"/></m:Column></m:columns><m:items><m:ColumnListItem type="Navigation" press="onNavToSample" vAlign="Middle"><m:cells><m:Text text="{name}" class="entitySampleName" wrapping="false"/><m:FormattedText htmlText="{= ${path: \'description\'} ? ${path: \'description\'} : \'\'}"/></m:cells></m:ColumnListItem></m:items></m:Table></ObjectPageSubSection></subSections></ObjectPageSection></sections></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/FeedbackDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:html="http://www.w3.org/1999/xhtml"><Dialog title="Give Feedback" class="sapUiContentPadding" id="feedbackDialog" resizable="true" draggable="true" contentHeight="35rem" contentWidth="32rem" stretch="{appView&gt;/bPhoneSize}" showHeader="true"><content><VBox><HBox justifyContent="SpaceBetween"><items><Label text="How is your overall experience?" design="Bold" class="sapMFontMediumSize" required="true"/><ObjectStatus id="ratingStatus" text="" state="None" class="sapMFontMediumSize"/></items></HBox><HBox id="feedbackButtons"><items><ToggleButton id="excellent" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-very-happy" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton><ToggleButton id="good" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-happy" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton><ToggleButton id="average" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-neutral" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton><ToggleButton id="poor" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-bad" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton><ToggleButton id="veryPoor" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-very-bad" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton></items></HBox><Label text="What would you like to tell us?" design="Bold" class="sapUiTinyMarginTop"/><TextArea id="feedbackInput" width="100%" placeholder="You can share your feedback for the overall Demo Kit experience or for the specific page you are currently viewing." rows="7" class="sapMFontMediumSize sapUiFeedbackDialogTextArea"/><CheckBox id="pageContext" text="Feedback is related to the current page" selected="true" class="sapMFontMediumSize contextCheckBoxAlign" select="onContextSelect"/><FormattedText class="sapMLabel sapUiFeedbackDialogNoteLabel sapUiTinyMarginBottom" htmlText="&lt;strong&gt;Note:&lt;/strong&gt; If you want to report a bug,    {= ${versionData&gt;/isOpenUI5} ?    \' you can open a GitHub issue &lt;a href=&quot;https://github.com/SAP/openui5/issues/new&quot;&gt;here.&lt;/a&gt;\' :    ${versionData&gt;/isSnapshotVersion} ?    \' please open a BCP ticket on CA-UI5-CTR component.\' :    \' you can report an Incident &lt;a href=&quot;https://launchpad.support.sap.com/#incident/solution&quot;&gt;here.&lt;/a&gt;\'    }    This way we will be able to get back to you in case we have follow-up questions."/><Link text="Show context Data" class="sapMFontMediumSize sapUiTinyMarginBottom" press="onShowHideContextData"/><TextArea id="contextData" width="100%" value="Details/ descriptive text..." visible="false" editable="false" rows="3" class="sapUiBaseText sapMFontMediumSize sapUiTinyMarginBottom sapUiNoMarginTop"/><MessageStrip text="Your feedback is anonymous, we do not collect any personal data" type="Information" showIcon="true"/></VBox></content><beginButton><Button id="sendButton" text="Send" press="onFeedbackDialogSend" enabled="false"/></beginButton><endButton><Button id="cancelButton" text="Cancel" press="onFeedbackDialogCancel"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Footer.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core"><l:BlockLayoutCell class="demokitInitialPagesColorPatternFContrast sapUiDocumentationFooter"><FlexBox alignItems="{= ${device&gt;/system/phone} ? \'Start\' : \'Center\' }" justifyContent="SpaceBetween" direction="{= ${device&gt;/system/phone} ? \'Column\' : \'Row\' }" width="100%"><items><Image src="./resources/sap/ui/documentation/sdk/images/logo_sap.png" densityAware="false" width="4.25rem" height="2rem"/><FlexBox direction="{= ${device&gt;/system/phone} ? \'Column\' : \'Row\' }" class="sapUiTinyMarginTop"><items><Link class="demokitInitialPagesBrightLink sapUiLargeMarginEnd sapUiTinyMarginBottom" text="Legal Disclosure" href="https://www.sap.com/corporate/en/legal/impressum.html" target="_blank"/><Link class="demokitInitialPagesBrightLink sapUiLargeMarginEnd sapUiTinyMarginBottom" text="Privacy" href="https://www.sap.com/corporate/en/legal/privacy.html" target="_blank"/><Link class="demokitInitialPagesBrightLink" text="Terms of Use" href="https://www.sap.com/corporate/en/legal/terms-of-use.html" visible="{=!${versionData&gt;/isOpenUI5}}" target="_blank"/><Link class="demokitInitialPagesBrightLink sapUiTinyMarginBottom sapUiLargeMarginEnd" text="License" href="LICENSE.txt" visible="{versionData&gt;/isOpenUI5}" target="_blank"/><Link class="demokitInitialPagesBrightLink" text="Terms of Use" href="TermsOfUse.txt" visible="{versionData&gt;/isOpenUI5}" target="_blank"/></items></FlexBox></items></FlexBox></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Group.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Group" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:layout="sap.ui.layout" xmlns:controls="sap.ui.documentation.sdk.controls"><m:Page id="controlsDetailPage" navButtonPress="onNavBack" showHeader="{device&gt;/orientation/portrait}" showSubHeader="false" showFooter="false" showNavButton="{device&gt;/system/phone}" busy="{detailView&gt;/busy}" busyIndicatorDelay="{detailView&gt;/delay}"><m:content/></m:Page></mvc:View>',
	"sap/ui/documentation/sdk/view/LegalDisclaimerPopover.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Popover placement="Auto" showHeader="true" title="Legal Disclaimer for Links" horizontalScrolling="false" contentWidth="30%" class="sapUiContentPadding"><Label text="Links with the icon " design="Bold"/><Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="Information published on non SAP site" width="1.25rem" class="sapUiTinyMarginBegin"/><Text text="You are entering a Web site that is not hosted by SAP. By using such links, you agree    (unless expressly stated otherwise in your agreements with SAP) to this:"/><Text text="- The content of the linked-to site is not SAP documentation. You may not infer any product claims against SAP based on this information."/><Text text="- SAP does not agree or disagree with the content on the linked-to site, nor does SAP warrant the availability and correctness."/><Label text="Links with the icon " design="Bold" class="sapUiTinyMarginTop"/><Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1.25rem" class="sapUiTinyMarginBegin"/><Text text="You are leaving the documentation for that particular SAP product or service and are entering a SAP-hosted Web site.     By using such links, you agree that (unless expressly stated otherwise in your agreements with SAP)     you may not infer any product claims against SAP based on this information."/></Popover></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/License.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.License" id="license" height="100%" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><Page height="100%" showHeader="false" showSubHeader="false"><Text id="licenseText" renderWhitespace="true" class="sapUiTinyMarginBegin"/></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/NotFound.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.BaseController" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><MessagePage id="page" title="Not Found" text="The requested resource was not found" icon="sap-icon://document" description="" showNavButton="{device&gt;/system/phone}" navButtonPress="onNavBack"/></mvc:View>',
	"sap/ui/documentation/sdk/view/ReleaseDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core"><Dialog id="releaseDialog" resizable="true" draggable="true" title="Change log for: {/library}" contentWidth="40%" contentHeight="40%" stretch="{appView&gt;/bPhoneSize}"><Text text="{/noDataMessage}" class="sapUiSmallMargin" visible="{=!!${/noDataMessage}}"/><beginButton><Button text="Close" press="onReleaseDialogClose"/></beginButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ReleaseNotes.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ReleaseNotes" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.uxap" xmlns:layout="sap.ui.layout" xmlns:m="sap.m" xmlns:html="http://www.w3.org/1999/xhtml" height="100%"><ObjectPageLayout id="releaseNotesObjectPage" busy="true" enableLazyLoading="false" showTitleInHeaderContent="false" sections="{/libs}" upperCaseAnchorBar="false"><headerTitle><ObjectPageHeader objectTitle="Change Log"/></headerTitle><headerContent><layout:VerticalLayout><html:div class="sapUiCustomTitleText">\n\t\t\t\t\t\t\tThis log includes the library notes for the libraries listed below.\n\t\t\t\t\t\t\tThe change log for old version which are not patched anymore can be reviewed\n\t\t\t\t\t\t\t<m:Link text="here" href="docs/guide/relnotes/ReleaseNotes.html"/>.\n\t\t\t\t\t\t</html:div><m:Select id="VersionSelect" items="{select&gt;/items}" change="handleVersionChange" visible="false"><core:Item text="{select&gt;value}" key="{select&gt;key}"/></m:Select></layout:VerticalLayout></headerContent><sections><ObjectPageSection title="{library}" titleUppercase="false"><ObjectPageSubSection titleUppercase="false"><layout:VerticalLayout content="{path:\'versions\',templateShareable:false}" width="100%"><m:Panel headerText="{version}" content="{path:\'notes\',templateShareable:false}" expandable="true" expanded="true" class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><m:Text width="100%" text="[{type}] {text}"/></m:Panel></layout:VerticalLayout></ObjectPageSubSection></ObjectPageSection></sections></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/Sample.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Sample" xmlns="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:layout="sap.ui.layout" xmlns:controls="sap.ui.documentation.sdk.controls"><Page id="page" showHeader="false" showNavButton="{/showNavButton}" navButtonPress="onNavBack" busyIndicatorDelay="0"><landmarkInfo><PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"/></landmarkInfo><subHeader><Bar id="header" class="sapContrast sapContrastPlus"><contentLeft><Button type="Back" press="onNavBack"/></contentLeft><contentMiddle><Title text="{/title}"/></contentMiddle><contentRight><Button id="apiRefButton" text="API Reference" type="Emphasized" press="onAPIRefPress" visible="false"/><Button id="prevSample" icon="sap-icon://navigation-up-arrow" class="sapUiHideOnPhone" tooltip="Show previous sample" enabled="{= ${/previousSampleId} !== undefined }" press="onPreviousSample"/><Button id="nextSample" icon="sap-icon://navigation-down-arrow" class="sapUiHideOnPhone" tooltip="Show next sample" enabled="{= ${/nextSampleId} !== undefined }" press="onNextSample"/><Button id="toggleFullScreenBtn" icon="sap-icon://full-screen" visible="{device&gt;/system/desktop}" tooltip="Show this sample in full screen mode" press="onToggleFullScreen"/><Button id="toggleRTA" icon="sap-icon://wrench" class="sapUiHideOnPhone" tooltip="Adapt UI" press="onToggleAdaptationMode" visible="false"/><Button id="code" icon="sap-icon://syntax" tooltip="Show source code for this sample" press="onNavToCode"/><Button visible="{/showNewTab}" id="newTab" tooltip="Open in new Tab" icon="sap-icon://inspect" press="onNewTab"/></contentRight></Bar></subHeader></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/SearchPage.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.SearchPage" xmlns="sap.m" xmlns:op="sap.uxap" xmlns:mvc="sap.ui.core.mvc" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><op:ObjectPageLayout id="searchPage" useIconTabBar="true" alwaysShowContentHeader="true" upperCaseAnchorBar="false"><op:headerTitle><op:ObjectPageHeader id="searchTitle" objectTitle="Search Results for &quot;{/searchTerm}&quot;"/></op:headerTitle><op:headerContent><ObjectAttribute title="" text="Search results are displayed in categories."/></op:headerContent><op:sections><op:ObjectPageSection id="allSummaryTitle" title="All ({/AllLength})"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="ALL ({=!!${/AllLength} &gt; 0 ? \'1 - \' + ${/visibleAllLength} : \'0\'} of {/AllLength})"/></OverflowToolbar><List id="allList" growing="true" growingThreshold="25" updateFinished="onAllLoadMore" items="{path:\'/data\',sorter:{path:\'category\',descending:false,group:true},groupHeaderFactory:\'.getGroupHeader\'}"><FeedListItem sender="{title}" text="{summary}" showIcon="false" app:path="{path}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection><op:ObjectPageSection title="API Reference ({/APILength})" visible="{=!!${/APILength}}"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="API Reference (1 - {/visibleAPILength} of {/APILength})"/></OverflowToolbar><List id="apiList" growing="true" growingThreshold="25" updateFinished="onAPILoadMore" items="{path:\'/dataAPI\',sorter:{path:\'title\',descending:false}}"><FeedListItem visible="{path:\'category\',formatter:\'.categoryAPIFormatter\'}" sender="{title}" text="{summary}" showIcon="false" app:path="{path}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection><op:ObjectPageSection title="Documentation ({/DocLength})" visible="{=!!${/DocLength}}"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="Documentation (1 - {/visibleDocLength} of {/DocLength})"/></OverflowToolbar><List id="documentationList" growing="true" growingThreshold="25" updateFinished="onDocLoadMore" items="{path:\'/dataDoc\',sorter:{path:\'title\',descending:false}}"><FeedListItem visible="{path:\'category\',formatter:\'.categoryDocFormatter\'}" sender="{title}" text="{summary}" showIcon="false" app:path="{path}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection><op:ObjectPageSection title="Samples ({/ExploredLength})" visible="{=!!${/ExploredLength}}"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="Samples (1 - {/visibleExploredLength} of {/ExploredLength})"/></OverflowToolbar><List id="samplesList" growing="true" growingThreshold="25" updateFinished="onExploredLoadMore" items="{path:\'/dataExplored\',sorter:{path:\'title\',descending:false}}"><FeedListItem visible="{path:\'category\',formatter:\'.categoryExploredFormatter\'}" sender="{title}" text="{summary}" showIcon="false" app:path="{path}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection></op:sections></op:ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/SubApiDetail.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.SubApiDetail" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns:layout="sap.ui.layout" xmlns:custom="sap.ui.documentation.sdk.controls" xmlns:template="http://schemas.sap.com/sapui5/extension/sap.ui.core.template/1"><m:Page id="apiDetailPage" showHeader="false" showSubHeader="false" showFooter="false" class="apiDetailPage"><m:content><ObjectPageLayout id="apiDetailObjectPage" enableLazyLoading="true" showAnchorBarPopover="true" upperCaseAnchorBar="false" busyIndicatorDelay="0"><headerTitle><ObjectPageHeader id="title" objectTitle="{path:\'/title\',formatter:\'.formatter.apiRefEntityName\'}" objectSubtitle="{/subTitle}"><actions><ObjectPageHeaderActionButton id="apiDetailBackToSearch" text="Back to search results" hideIcon="true" hideText="false" press="backToSearch" visible="false"/><ObjectPageHeaderActionButton id="toggleFullScreenBtn" visible="{device&gt;/system/desktop}" icon="sap-icon://full-screen" tooltip="Show this sample in full screen mode" press="onToggleFullScreen"/></actions></ObjectPageHeader><core:ExtensionPoint name="customTitle"/></headerTitle><headerContent><layout:Grid defaultSpan="L4 M6 S12" class="sapUiNoMargin" hSpacing="0"><layout:VerticalLayout width="98%" id="headerColumn0"/><layout:VerticalLayout width="100%" id="headerColumn1" visible="false"/><layout:VerticalLayout width="100%" id="headerColumn2" visible="false"/></layout:Grid></headerContent><sections><ObjectPageSection id="overview" title="Overview" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><layout:VerticalLayout width="100%"><template:if test="{=${data&gt;/deprecatedText} !== undefined}"><m:MessageStrip text="{/deprecatedText}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/></template:if><custom:JSDocText text="{/description}"/><template:if test="{=${data&gt;/dnd/draggable} === true}"><m:MessageStrip text="This control can be a drag source." type="Information" showIcon="true" showCloseButton="false" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/></template:if><template:if test="{=${data&gt;/dnd/droppable} === true}"><m:MessageStrip text="This control can be a drop target." type="Information" showIcon="true" showCloseButton="false" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/></template:if><template:if test="{data&gt;/hasAnnotations}"><layout:HorizontalLayout class="sapUiTinyMarginTop sapUiDocumentationAnnotationsText"><m:Text text="A detailed description of the OData annotations handled by this control is available"/><m:Link text="here" press="onAnnotationsLinkPress"/><m:Text text="."/></layout:HorizontalLayout><layout:HorizontalLayout class="sapUiDocumentationAnnotationsText"><m:Label text="Annotation Limitations:" design="Bold"/><m:Text text="Qualifier support for entity types is limited for this control."/></layout:HorizontalLayout></template:if><template:if test="{=${data&gt;/experimental} !== undefined}"><m:MessageStrip text="Experimental API since version {/experimental/since} {/experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><template:if test="{= !!${data&gt;/parameters} }"><custom:LightTable rows="{path:\'/parameters\'}" columnTitles="Param,Type,Default Value,Description" columnCount="4" class="sapUiDocumentationParamsTable"><custom:Row><custom:ParamText text="{name}" phoneText="{phoneName}" depth="{depth}" optional="{optional}"/><m:Text text="{type}" wrapping="false"/><m:Text text="{defaultValue}" wrapping="false"/><custom:JSDocText text="{description}"/></custom:Row></custom:LightTable></template:if><template:if test="{= ${data&gt;/returnValue} !== undefined}"><custom:LightTable columnCount="2" columnTitles="Returns,Description" class="sapUiDocumentation2ColumnsEqualTable"><custom:Row><m:Text text="{data&gt;/returnValue/type}" wrapping="false"/><custom:JSDocText text="{path:\'data&gt;/returnValue/description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></custom:LightTable></template:if><template:if test="{data&gt;/hasChildren}"><custom:LightTable rows="{path:\'/nodes\'}" columnTitles="Namespaces &amp; Classes,Description" columnCount="2" class="sapUiSmallMarginTop"><custom:Row><m:Link href="{ref}" text="{name}"/><custom:JSDocText text="{description}"/></custom:Row></custom:LightTable></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection><template:if test="{data&gt;/hasProperties}"><ObjectPageSection id="properties" title="Fields" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><custom:LightTable rows="{path:\'/properties\'}" columnCount="3" columnTitles="Name,Type,Description" class="sapUiSmallMarginTop"><custom:Row><custom:ParamText class="sapUiDocumentationParamBold" text="{name}" deprecated="{= ${deprecated} !== undefined }"/><m:Link text="{type}" href="{href}" enabled="{= !!${linkEnabled} }"/><layout:VerticalLayout><custom:JSDocText text="{description}"/><m:MessageStrip visible="{=${deprecated} !== undefined}" text="Deprecated as of version {deprecated/since}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${experimental} !== undefined}" text="Experimental API since {experimental/since} {experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:ObjectStatus text="Visibility: {visibility}" state="{= ${visibility} === \'public\' ? \'Success\' : \'Warning\'}"/></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasConstructor}"><ObjectPageSection id="constructor" title="Constructor" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><layout:VerticalLayout width="100%"><custom:JSDocText text="{/constructor/description}"/><layout:VerticalLayout visible="{= ${/constructor/examples} !== undefined}" content="{path:\'/constructor/examples\',templateShareable:\'false\'}"><custom:JSDocText text="{data}"/></layout:VerticalLayout><custom:JSDocText text="{/constructor/codeExample}"/><template:if test="{= !!${data&gt;/constructor/parameters} }"><custom:LightTable rows="{path:\'/constructor/parameters\'}" columnTitles="Param,Type,Default Value,Description" columnCount="4" class="sapUiDocumentationParamsTable"><custom:Row><custom:ParamText text="{name}" phoneText="{phoneName}" depth="{depth}" optional="{optional}"/><layout:VerticalLayout content="{path:\'types\',templateShareable:\'false\'}" width="100%"><m:Link text="{name}" href="#/api/{name}" enabled="{= !!${linkEnabled} }"/></layout:VerticalLayout><m:Text text="{defaultValue}" wrapping="false"/><custom:JSDocText text="{description}"/></custom:Row></custom:LightTable></template:if><template:if test="{= ${data&gt;/constructor/throws} !== undefined}"><custom:LightTable rows="{path:\'/constructor/throws\',templateShareable:\'false\'}" columnTitles="Throws,Desktop" columnCount="2" class="sapUiDocumentation2ColumnsEqualTable"><custom:Row><m:Link text="{type}" href="#/api/{type}" enabled="{= !!${linkEnabled} }"/><custom:JSDocText text="{description}"/></custom:Row></custom:LightTable></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasControlProperties}"><ObjectPageSection id="controlproperties" title="Properties" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><custom:LightTable rows="{path:\'/ui5-metadata/properties\'}" columnTitles="Name,Type,Default Value,Description" columnCount="4" class="sapUiSmallMarginTop"><custom:Row><custom:ParamText class="sapUiDocumentationParamBold" text="{name}"/><m:Link text="{type}" href="#/api/{= ${type}.replace(\'[]\', \'\') }" enabled="{= !!${linkEnabled} }"/><m:Text text="{defaultValue}"/><layout:VerticalLayout width="100%"><custom:JSDocText text="{description}"/><m:ObjectStatus text="Visibility: {visibility}" state="{= ${visibility} === \'public\' ? \'Success\' : \'Warning\'}"/><m:MessageStrip visible="{=${deprecatedText} !== undefined}" text="{deprecatedText}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${experimental} !== undefined}" text="Experimental API since {experimental/since} {experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasAggregations}"><ObjectPageSection id="aggregations" title="Aggregations" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><custom:LightTable rows="{path:\'/ui5-metadata/aggregations\'}" columnTitles="{= ${data&gt;/hasAggregationAltTypes} ? \'Name,Cardinality,Type,Alt types,Description\' : \'Name,Cardinality,Type,Description\'}" columnCount="{= ${data&gt;/hasAggregationAltTypes} ? 5 : 4}" class="sapUiSmallMarginTop"><custom:Row visible="{= ${visibility} === \'public\'}"><custom:ParamText text="{name}" defaultFlag="{= ${/ui5-metadata/defaultAggregation} === ${path: \'name\'} }"/><m:Text text="{cardinality}" wrapping="false"/><m:Link text="{type}" href="#/api/{type}" enabled="{= !!${linkEnabled} }"/><template:if test="{data&gt;/hasAggregationAltTypes}"><m:Text text="{path:\'altTypes\',formatter:\'.formatter.apiRefAggregationAltTypes\'}"/></template:if><layout:VerticalLayout width="100%"><custom:JSDocText text="{description}"/><m:MessageStrip visible="{=${deprecated} !== undefined}" text="Deprecated as of version {deprecated/since}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${experimental} !== undefined}" text="Experimental API since {experimental/since} {experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${dnd/draggable} === true}" text="This aggregation can be a drag source." type="Information" showIcon="true" showCloseButton="false" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/><m:MessageStrip visible="{=${dnd/droppable} === true}" text="This aggregation can be a drop target." type="Information" showIcon="true" showCloseButton="false" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasAssociations}"><ObjectPageSection id="associations" title="Associations" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><custom:LightTable rows="{path:\'/ui5-metadata/associations\'}" columnCount="4" columnTitles="Name,Cardinality,Type,Description" class="sapUiSmallMarginTop"><custom:Row visible="{visibility === \'public\'}"><custom:ParamText class="sapUiDocumentationParamBold" text="{name}"/><m:Text text="{cardinality}" wrapping="false"/><m:Link text="{type}" href="#/api/{type}" enabled="{= !!${linkEnabled} }"/><layout:VerticalLayout width="100%"><custom:JSDocText text="{description}"/><m:MessageStrip visible="{=${deprecated} !== undefined}" text="Deprecated as of version {deprecated/since}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${experimental} !== undefined}" text="Experimental API since {experimental/since} {experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasEvents}"><ObjectPageSection id="events" title="Events" titleUppercase="false"><subSections><custom:ObjectPageSubSection title="{= ${data&gt;/hasEvents} &amp;&amp; !${data&gt;/hasOwnEvents} ? \'Events\' : \'Summary\'}"><custom:blocks><layout:VerticalLayout width="100%"><template:if test="{data&gt;/hasOwnEvents}"><custom:LightTable columnCount="2" columnTitles="Event,Description"><template:repeat list="{data&gt;/events}" var="event"><custom:Row><custom:ParamText text="{event&gt;name}" href="#/api/{data&gt;/name}/events/{event&gt;name}" deprecated="{= ${event&gt;deprecated} !== undefined }" press="scrollToEvent"/><custom:JSDocText text="{path:\'event&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if><template:if test="{= ${data&gt;/borrowed/events/}.length &gt; 0 }"><m:Title text="Borrowed from:" class="sapUiSmallMarginTop sapUiDocumentationBorrowedTitle"/><layout:VerticalLayout width="100%" content="{path:\'/borrowed/events/\',templateShareable:\'false\'}"><m:Panel class="borrowedListPanel" expandable="true" expanded="true" headerText="{name}" width="100%"><custom:BorrowedList list="{events}"/></m:Panel></layout:VerticalLayout></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection><template:repeat list="{data&gt;/events}" var="event"><custom:ObjectPageSubSection title="{event&gt;name}"><custom:blocks><layout:VerticalLayout width="100%"><custom:JSDocText text="{path:\'event&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><m:ObjectStatus text="Visibility: {event&gt;visibility}" state="{= ${event&gt;visibility} === \'public\' ? \'Success\' : \'Warning\'}" class="sapUiSmallMarginBottom"/><template:if test="{=${event&gt;deprecated} !== undefined}"><m:MessageStrip text="{event&gt;deprecatedText}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><template:if test="{=${event&gt;experimental} !== undefined}"><m:MessageStrip text="Experimental API since {event&gt;experimental/since} {event&gt;experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><template:if test="{= !!${event&gt;parameters} &amp;&amp; ${event&gt;parameters}.length &gt; 0}"><custom:LightTable columnTitles="Param,Type,Description" columnCount="3"><template:repeat list="{event&gt;parameters}" var="parameter"><custom:Row><custom:ParamText text="{parameter&gt;name}" phoneText="{parameter&gt;phoneName}" depth="{parameter&gt;depth}" optional="{parameter&gt;optional}"/><m:Link text="{parameter&gt;type}" href="#/api/{parameter&gt;type}" enabled="{= !!${parameter&gt;linkEnabled} }"/><custom:JSDocText text="{path:\'parameter&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></template:repeat></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasMethods}"><ObjectPageSection id="methods" title="Methods" titleUppercase="false" class="APIDetailMethodsSection"><subSections><custom:ObjectPageSubSection title="{= ${data&gt;/hasMethods} &amp;&amp; !${data&gt;/hasOwnMethods} ? \'Methods\' : \'Summary\'}"><custom:blocks><layout:VerticalLayout width="100%"><template:if test="{data&gt;/hasOwnMethods}"><custom:LightTable columnCount="2" columnTitles="Method,Description"><template:repeat list="{data&gt;/methods}" var="method"><custom:Row><custom:ParamText text="{method&gt;name}" href="{method&gt;href}" deprecated="{= ${method&gt;deprecated} !== undefined }" experimental="{= ${method&gt;experimental} !== undefined }" press="scrollToMethod"/><custom:JSDocText text="{path:\'method&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if><template:if test="{= ${data&gt;/borrowed/methods/}.length &gt; 0 }"><m:Title text="Borrowed from:" class="sapUiSmallMarginTop sapUiDocumentationBorrowedTitle"/><layout:VerticalLayout width="100%" content="{path:\'/borrowed/methods/\',templateShareable:\'false\'}"><m:Panel class="borrowedListPanel" expandable="true" expanded="true" headerText="{name}" width="100%"><custom:BorrowedList list="{methods}"/></m:Panel></layout:VerticalLayout></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection><template:repeat list="{data&gt;/methods}" var="method"><custom:ObjectPageSubSection title="{method&gt;name}" id="{method&gt;placeholderId}"><custom:blocks><ObjectPageLazyLoader stashed="true" id="{method&gt;subPlaceholderId}"><layout:VerticalLayout width="100%"><custom:JSDocText text="{path:\'method&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><layout:VerticalLayout visible="{= ${method&gt;examples} !== undefined}" width="100%"><template:repeat list="{method&gt;examples}" var="example"><custom:JSDocText text="{path:\'example&gt;data\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></template:repeat></layout:VerticalLayout><layout:HorizontalLayout class="sapUiTinyMarginBottom"><m:ObjectStatus text="Visibility: {method&gt;visibility}" state="{= ${method&gt;visibility} === \'public\' ? \'Success\' : \'Warning\'}" class="sapUiTinyMarginEnd"/><m:ObjectStatus visible="{=${method&gt;since} !== undefined}" text="Since: {method&gt;since}"/></layout:HorizontalLayout><template:if test="{=${method&gt;deprecated} !== undefined}"><m:MessageStrip text="{method&gt;deprecatedText}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><template:if test="{=${method&gt;experimental} !== undefined}"><m:MessageStrip text="Experimental API since {method&gt;experimental/since} {method&gt;experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><custom:JSDocText text="{method&gt;code}"/><template:if test="{= !!${method&gt;parameters} &amp;&amp; ${method&gt;parameters}.length &gt; 0}"><custom:LightTable columnCount="4" columnTitles="Param,Type,Default Value,Description" class="sapUiDocumentationParamsTable"><template:repeat list="{method&gt;parameters}" var="parameter"><custom:Row><custom:ParamText text="{parameter&gt;name}" phoneText="{parameter&gt;phoneName}" depth="{parameter&gt;depth}" optional="{parameter&gt;optional}"/><layout:VerticalLayout class="sapUiDocumentationOrList" width="100%"><template:repeat list="{parameter&gt;types}" var="type"><template:if test="{= !!${type&gt;linkEnabled} }"><template:then><m:Link text="{path:\'type&gt;value\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}" href="{type&gt;href}" enabled="true"/></template:then><template:else><m:Link text="{path:\'type&gt;value\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}" enabled="false"/></template:else></template:if></template:repeat></layout:VerticalLayout><m:Text text="{parameter&gt;defaultValue}" wrapping="false"/><custom:JSDocText text="{path:\'parameter&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if><template:if test="{= ${method&gt;returnValue} !== undefined}"><custom:LightTable columnCount="2" columnTitles="Returns,Description" class="sapUiDocumentation2ColumnsEqualTable"><custom:Row><layout:VerticalLayout class="sapUiDocumentationOrList" width="100%"><template:repeat list="{method&gt;returnValue/types}" var="rtype"><m:Link text="{rtype&gt;value}" href="{rtype&gt;href}" enabled="{= !!${rtype&gt;linkEnabled} }"/></template:repeat></layout:VerticalLayout><custom:JSDocText text="{path:\'method&gt;returnValue/description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></custom:LightTable></template:if><template:if test="{= ${method&gt;throws} !== undefined}"><custom:LightTable columnTitles="Throws,Description" columnCount="2" class="sapUiDocumentation2ColumnsEqualTable"><template:repeat list="{method&gt;throws}" var="throws"><custom:Row><m:Link text="{throws&gt;type}" href="#/api/{throws&gt;type}" enabled="{= !!${throws&gt;linkEnabled} }"/><custom:JSDocText text="{path:\'throws&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if></layout:VerticalLayout></ObjectPageLazyLoader></custom:blocks></custom:ObjectPageSubSection></template:repeat></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasSpecialSettings}"><ObjectPageSection id="specialsettings" title="Special Settings" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><custom:LightTable rows="{path:\'/ui5-metadata/specialSettings\'}" columnCount="3" columnTitles="Name,Type,Description" class="sapUiSmallMarginTop sapUiDocumentationSpecialSettingsTable"><custom:Row><custom:ParamText class="sapUiDocumentationParamBold" text="{name}"/><m:Link text="{type}" href="#/api/{type}" enabled="{= !!${linkEnabled} }"/><custom:JSDocText text="{description}"/></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasAnnotations}"><ObjectPageSection id="annotations" title="Annotations" titleUppercase="false"><subSections><custom:ObjectPageSubSection title="Summary"><custom:blocks><custom:LightTable columnCount="2" columnTitles="Annotation,Description"><template:repeat list="{data&gt;/ui5-metadata/annotations}" var="annotation"><custom:Row><m:Link text="{= ${annotation&gt;annotation} !== \'undefined\' ? ${annotation&gt;annotation} : \'(\' + ${annotation&gt;namespaceText} + \')\' }" press="scrollToAnnotation" wrapping="false"/><custom:JSDocText text="{path:\'annotation&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></custom:blocks></custom:ObjectPageSubSection><template:repeat list="{data&gt;/ui5-metadata/annotations}" var="annotation"><custom:ObjectPageSubSection title="{= ${annotation&gt;annotation} !== \'undefined\' ? ${annotation&gt;annotation} : \'(\' + ${annotation&gt;namespaceText} + \')\' }"><custom:blocks><layout:VerticalLayout width="100%"><custom:JSDocText text="{path:\'annotation&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><custom:LightTable columnTitles="Namespace,Target Type,Applies To" columnCount="3"><custom:Row><custom:JSDocText text="{annotation&gt;namespace}"/><custom:JSDocText text="{annotation&gt;target}"/><custom:JSDocText text="{annotation&gt;appliesTo}"/></custom:Row></custom:LightTable></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></template:repeat></subSections></ObjectPageSection></template:if><core:ExtensionPoint name="customSections"/></sections></ObjectPageLayout></m:content></m:Page></mvc:View>',
	"sap/ui/documentation/sdk/view/TermsOfUse.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.TermsOfUse" id="termsOfUse" height="100%" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><Page showHeader="false" showSubHeader="false"><Text id="termsOfUseText" renderWhitespace="true" class="sapUiTinyMarginBegin"/></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/Tools.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Tools" xmlns="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation.sdk.controls" xmlns:html="http://www.w3.org/1999/xhtml"><Page showHeader="false" class="sapUiNoContentPadding"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell toolsImageCell"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/Tools_S_cropped.jpg" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/Tools_M_and_L_cropped.jpg" width="100%" class="landingImage" densityAware="false" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><Text id="landingImageHeadline" visible="false" class="sapUiDocumentationToolsHeaderText" text="Tools" width="100%" textAlign="Left"/></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><Image src="./resources/sap/ui/documentation/sdk/images/WebIDE_logo_white_32x61.png" class="sapUiTinyMarginBottom" densityAware="false"/><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="SAP Web IDE" href="https://www.sap.com/developer/topics/sap-webide.html" class="demokitInitialPagesWhiteText" target="_blank"/>\n\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t</html:div><Text text="SAP Web IDE on SAP CP is delivered on SAP Cloud Platform, SAP\'s public cloud,         and is used to build modern UI apps for desktop and mobile devices with the latest         SAPUI5 and SAP Fiori technologies." class="sapUiSmallMarginBottom"/><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t<Link text="View Documentation" target="_blank" href="https://help.sap.com/viewer/825270ffffe74d9f988a0f0066ad59f0/CF/en-US" class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t</html:div><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t<Link text="SAP Web IDE SDK" target="_blank" href="https://sdk-sapwebide.dispatcher.hana.ondemand.com/index.html" class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t</html:div><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t<Link text="Community" target="_blank" href="https://www.sap.com/developer/topics/sap-webide.html" class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t</html:div></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><core:Icon src="sap-icon://inspection" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="UI5 Inspector" href="https://chrome.google.com/webstore/detail/ui5-inspector/bebecogbafbighhaildooiibipcnbngo?hl=en" target="_blank"/>\n\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="Information published on non SAP site" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t</html:div><Text text="With the UI5 Inspector, you can easily debug and support your OpenUI5 or SAPUI5-based apps." class="sapUiSmallMarginBottom"/><Link text="View Documentation" target="_blank" href="#/topic/b24e72443eb34d0fb7bf6940f2d697eb"/><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t<Link text="View Source Code" target="_blank" href="https://github.com/SAP/ui5-inspector"/>\n\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="Information published on non SAP site" width="1rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t</html:div></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:Grid width="100%" vSpacing="1" hSpacing="0" position="Left" defaultSpan="L6 M12 S12" defaultIndent="XL0 L0 M0 S0"><l:VerticalLayout width="100%"><core:Icon src="sap-icon://widgets" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink level="H1" titleStyle="H1" text="Icon Explorer" href="test-resources/sap/m/demokit/iconExplorer/webapp/index.html" target="_blank"/><Text text="All our icons at your fingertips" class="sapUiSmallMarginBottom"/><Link text="View Documentation" target="_blank" href="#/topic/21ea0ea94614480d9a910b2e93431291" class="sapUiTinyMarginBottom"/><Link text="Run Integration Tests" target="_blank" href="test-resources/sap/m/demokit/iconExplorer/webapp/test/integration/opaTests.qunit.html" class="sapUiTinyMarginBottom"/><Link text="Run Unit Tests" target="_blank" href="test-resources/sap/m/demokit/iconExplorer/webapp/test/unit/unitTests.qunit.html" class="sapUiTinyMarginBottom"/></l:VerticalLayout><Panel headerText="Browse Hundreds of icons"><l:VerticalLayout><l:HorizontalLayout><core:Icon src="sap-icon://paper-plane" size="1.5rem" color="Neutral"/><core:Icon src="sap-icon://paper-plane" size="2.5rem" color="Neutral"/><core:Icon src="sap-icon://paper-plane" size="4.5rem" color="Neutral"/><core:Icon src="sap-icon://paper-plane" size="6rem" color="Neutral"/></l:HorizontalLayout><HBox><Label text="Code:" design="Bold" class="sapUiTinyMarginEnd sapUiTinyMarginTopBottom"/><Input type="text" value="sap-icon://paper-plane" enabled="false"/><Button type="Emphasized" icon="sap-icon://copy" class="sapUiTinyMarginBegin"/></HBox></l:VerticalLayout></Panel></l:Grid></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeC"><l:Grid width="100%" vSpacing="1" hSpacing="0" position="Left" defaultSpan="L6 M12 S12" defaultIndent="XL0 L0 M0 S0"><l:VerticalLayout><Image src="./resources/sap/ui/documentation/sdk/images/build_logo__white_26x80.png" class="sapUiTinyMarginBottom" densityAware="false"/><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="Find Out About Build" href="https://www.build.me" target="_blank" class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="Information published on non SAP site" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div><Text text="Everything you need to design beautiful apps in one set of cloud-based tools." class="sapUiSmallMarginBottom"/><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t\t\t<Link text="View Documentation" target="_blank" href="http://sap.github.io/BUILD_User_Assistance/build/external/" class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="Information published on non SAP site" width="1rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t\t\t<Link text="View Source Code" target="_blank" href="https://www.github.com/SAP/BUILD" class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="Information published on non SAP site" width="1rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div></l:VerticalLayout><Image src="./resources/sap/ui/documentation/sdk/images/build_illu_astronaut_320x235.png" densityAware="false"/></l:Grid></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeD"><l:Grid width="100%" vSpacing="1" hSpacing="0" position="Left" defaultSpan="L6 M12 S12" defaultIndent="XL0 L0 M0 S0"><l:VerticalLayout width="100%"><core:Icon src="sap-icon://palette" size="2rem" class="sapUiTinyMarginBottom"/><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="UI Theme Designer" href="https://themedesigner-themedesigner.dispatcher.hanatrial.ondemand.com/index.html" target="_blank" class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text text="Responsive controls for touch-enabled devices and desktop browsers" class="sapUiSmallMarginBottom"/><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t\t<Link text="View Documentation" target="_blank" href="https://help.sap.com/viewer/09f6818d8e064537973102d6289e2aca/Cloud/en-US" class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t\t<Link text="Community" target="_blank" href="https://www.sap.com/community/topic/ui-theme-designer.html" class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div></l:VerticalLayout><Image src="./resources/sap/ui/documentation/sdk/images/Theme_Designer_Image_350x197.jpg" densityAware="false"/></l:Grid></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><core:Icon src="sap-icon://example" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink level="H1" titleStyle="H1" text="Theme Parameter Toolbox" href="test-resources/sap/m/demokit/theming/webapp/index.html" target="_blank"/><Text text="Search, filter and preview semantic theme parameters" class="sapUiSmallMarginBottom"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/TopicDetail.view.xml":'<mvc:View height="100%" controllerName="sap.ui.documentation.sdk.controller.TopicDetail" id="sap.ui.documentation.sdk.controller.TopicDetail" xmlns="sap.f" xmlns:m="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core"><DynamicPage id="topicDetailPage" preserveHeaderStateOnScroll="true" toggleHeaderOnTitleClick="false" fitContent="true"><title><DynamicPageTitle class="sapUiDocumentationDynamicPageTitle"><heading><m:Text text="{/topictitle1}" class="sapUiDocumentationTopicTitle" wrapping="true"/></heading><actions><m:Button id="topicDetailBackToSearch" text="Back to search results" type="Transparent" press="backToSearch" visible="false"/><m:Button visible="{device&gt;/system/desktop}" icon="sap-icon://full-screen" type="Transparent" tooltip="Show this document in full screen mode" press="onToggleFullScreen"/></actions></DynamicPageTitle></title><header><DynamicPageHeader pinnable="fale"><content><m:Text text="{/shortdesc}"/></content></DynamicPageHeader></header><content><core:HTML id="testHTML" preferDOM="false" content="&lt;div style=&quot;height:100%; overflow-x:auto;&quot;&gt;&lt;iframe class=&quot;sapUiDocumentationTopicsIframe&quot; name=&quot;content&quot; src=&quot;{/topicURL}&quot; frameborder=&quot;0&quot;&quot;&gt;&lt;/iframe&gt;&lt;/div&gt;"/></content></DynamicPage></mvc:View>',
	"sap/ui/documentation/sdk/view/TopicDetailInitial.view.xml":'<mvc:View height="100%" width="100%" controllerName="sap.ui.documentation.sdk.controller.TopicDetailInitial" xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation.sdk.controls"><Page id="topicDetailPage" showHeader="false" class="sapUiNoContentPadding"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/Docu_S_cropped.jpg" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/Docu_M_and_L_cropped.jpg" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><l:VerticalLayout id="landingImageHeadline" class="sapUiDocumentationDocumentationHeading" visible="false" width="100%"><Text text="Documentation" width="100%" textAlign="Left"/><Button class="actionButton" text="Download" type="Emphasized" press="onDownloadButtonPress"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow id="disclaimerBlock" visible="false"><l:BlockLayoutCell backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA"><MessageStrip id="disclaimerMessage" showIcon="true"/></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow class="sapUiContentPadding"><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="What\'s New?" href="#/topic/99ac68a5b1c3416ab5c84c99fefa250d" titleStyle="H1"/><Text text="Find out about the new features in the latest UI5 versions"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="Read Me First" href="#/topic/167193ced54c41c3961d7df3479d7bbe" titleStyle="H1"/><Text text="Important information before you start using UI5 productively"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell width="2" class="largeCell" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="Get Started" href="#/topic/8b49fc198bf04b2d9800fc37fecbb218" class="demokitInitialPagesWhiteText" titleStyle="H1"/><Text text="Setup and tutorials" class="demokitInitialPagesWhiteText"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell width="2" class="largeCell" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="Developing Apps" href="#/topic/23cfd955f58142389fa7c9097e11559c" class="demokitInitialPagesWhiteText" titleStyle="H1"/><Text text="Best practices and what pitfalls you should look out for" class="demokitInitialPagesWhiteText"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="Extending Apps" href="#/topic/a264a9abf98d4caabbf9b027bc1005d8" titleStyle="H1"/><Text text="Adapt apps to your specific requirements"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="Developing Controls" href="#/topic/8dcab0011d274051808f959800cabf9f" titleStyle="H1"/><Text text="Create custom controls or contribute to UI5"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternA" backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA" visible="{=!${versionData&gt;/isOpenUI5}}"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="SAP Fiori Elements" href="#/topic/03265b0408e2432c9571d6b3feb6b1fd" titleStyle="H1"/><Text text="UI patterns and templates for commonly used application patterns"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternC" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB" visible="{=!${versionData&gt;/isOpenUI5}}"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="Analysis Path Framework" href="#/topic/1c457c53595a6655e10000000a423f68" titleStyle="H1"/><Text text="Build and enhance interactive analytical web applications"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeD"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="Essentials" href="#/topic/ec699e0817fb46a0817b0fa276a249f8" class="demokitInitialPagesWhiteText" titleStyle="H1"/><Text text="Development concepts, such as MVC, data binding, and components" class="demokitInitialPagesWhiteText"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="More About Controls" href="#/topic/3ec6808ff0f34a75a9f40748cf9989b9" titleStyle="H1"/><Text text="Addition to the API reference"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/TopicMaster.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.TopicMaster" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m" xmlns:core="sap.ui.core" class="sapContrast sapContrastPlus"><Page id="page" enableScrolling="true" showFooter="false" navButtonPress="onNavBack" showNavButton="false" class="sapUiDocumentationMasterPage"><customHeader><Toolbar width="100%"><SearchField id="searchField" placeholder="Filter" liveChange="onTreeFilter" class="sapUiDocumentationFilterField"/><Button icon="sap-icon://expand-all" press="onTreeExpandAll"/><Button icon="sap-icon://collapse-all" press="onTreeCollapseAll"/></Toolbar></customHeader><content><Tree id="tree" mode="SingleSelectMaster" selectionChange="onNodeSelect" noDataText="No data, please try with the global search" items="{path:\'/\'}"><StandardTreeItem title="{text}" selected="{isSelected}"><customData><core:CustomData key="nodeId" value="{key}"/></customData></StandardTreeItem></Tree></content></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/VersionInfo.view.xml":'<mvc:View id="versionInfo" height="100%" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core"><core:HTML id="testHTML" preferDOM="false" content="&lt;div style=&quot;height:100%; overflow-x:auto;&quot;&gt;&lt;iframe style=&quot;width:100%;height:99%;&quot; name=&quot;content&quot; src=&quot;versioninfo.html&quot; frameborder=&quot;0&quot;&quot;&gt;&lt;/iframe&gt;&lt;/div&gt;"/></mvc:View>',
	"sap/ui/documentation/sdk/view/Welcome.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Welcome" xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns:custom="sap.ui.documentation.sdk.controls" xmlns:html="http://www.w3.org/1999/xhtml"><Page showHeader="false"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell welcomeImageCell"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/Home_S_cropped.jpg" width="100%" class="welcomeImage" densityAware="false" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/Home_M_and_L_cropped.jpg" width="100%" densityAware="false" class="welcomeImage" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><l:VerticalLayout id="landingImageHeadline" visible="false" width="100%" class="welcomeImageTextLayout"><Text class="welcomeImageTextHeadline" text="Discover New Enterprise-Grade Horizons" width="100%" textAlign="Center"/><l:HorizontalLayout><Button text="Get Started with UI5" type="Emphasized" press="onGetStarted" class="actionButton"/><Button class="actionButton sapContrast sapContrastPlus sapUiSmallMarginBegin" visible="{=${welcomeView&gt;/isOpenUI5} !== undefined}" id="readMoreButton" text="{i18n&gt;downloadButtonText}" type="Ghost" press="onDownloadButtonPress"/></l:HorizontalLayout></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiDemokitLandingBlockHeadline" backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA" title="Key Features" titleAlignment="Center"/></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell backgroundColorSet="ColorSet5" backgroundColorShade="ShadeD"><l:Grid defaultSpan="L6 M12 S12" hSpacing="0" vSpacing="0"><l:VerticalLayout width="100%"><custom:TitleLink href="#/topic/50eadaac8d2e49ee8996dc2b560cb76b" text="Responsive Across Browsers and Devices" titleStyle="H2" class="demokitInitialPagesWhiteText sapUiSmallMarginBottom"/><Text text="No need to worry about device specifics! UI5 apps run on smartphones, tablets, and desktops. The UI controls automatically adapt themselves to each device\'s capabilities and make the most of the available real estate." class="demokitInitialPagesWhiteText"/></l:VerticalLayout><Image src="./resources/sap/ui/documentation/sdk/images/Fiori_guidelines_image.png" densityAware="false" width="100%"><layoutData><l:GridData span="L6 M12 S12"/></layoutData></Image></l:Grid></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout width="100%"><custom:TitleLink text="Powerful Development Concepts" href="#/topic/ec699e0817fb46a0817b0fa276a249f8" class="sapUiSmallMarginBottom" titleStyle="H2"/><Text text="The UI5 core offers a solid foundation that simplifies your work by managing many aspects of modern development behind the scenes. It comes with built-in support for architectural concepts like MVC, two-way data binding, and routing." class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Includes standards like MVC and various data-binding types"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Choose between different view formats (XML, HTML, JavaScript, JSON)"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Binding with OData, JSON, XML and other data formats"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Built-in support tool for exploring the object tree and binding status"/></HBox></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink href="#/topic/23cfd955f58142389fa7c9097e11559c" text="Enterprise-Ready Web Toolkit" class="sapUiSmallMarginBottom" titleStyle="H2"/><Text text="Created by professionals, for modern developers building state of the art web applications. It comes with all features needed to cover most current application requirements, with standards high enough to be delivered in standard SAP solutions." class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Translation and internationalization support"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Extensibility concepts at code and application level"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="High Contrast theme to aid visually impaired users"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:Grid defaultSpan="L6 M12 S12" hSpacing="0" vSpacing="0"><l:VerticalLayout width="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink href="https://experience.sap.com/fiori-design/" text="Award-Winning SAP Fiori Design in Action" titleStyle="H2" target="_blank"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text text="UI5 applications benefit from a consistent design language and predefined UX patterns across all frontend features. Use a predefined theme or try our online theming tool to create a custom theme." class="sapUiSmallMarginBottom"/></l:VerticalLayout><Image src="./resources/sap/ui/documentation/sdk/images/Fiori_design_examples.png" class="sapUiSmallmarginBeginEnd" densityAware="false" width="100%"><layoutData><l:GridData span="L6 M12 S12"/></layoutData></Image></l:Grid></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA" class="sapUiDemokitLandingBlockHeadline" title="Choose Your Scenario" titleAlignment="Center"/></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout width="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t<custom:TitleLink href="https://www.sap.com/developer/tutorials/hcp-create-trial-account.html" text="SAPUI5 on SAP Cloud Platform" titleStyle="H2" target="_blank"/>\n\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t</html:div><Text text="Sign up for the free SAP Cloud Platform developer edition to test the platform and build cloud-based UI5 apps." class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Easy-to-use development environment with SAP Web IDE"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Free trial for development use"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t<custom:TitleLink href="https://sapui5.hana.ondemand.com/#/topic/91f346786f4d1014b6dd926db0e91070" target="_blank" text="SAPUI5 On-Premise" titleStyle="H2"/>\n\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t</html:div><Text text="SAPUI5 is part of the user interface technologies in SAP HANA, NetWeaver ABAP or Java systems." class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="ready to use for SAP Customers"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Integrates with existing system landscapes"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t<custom:TitleLink href="http://openui5.org" text="OpenUI5 - Free and Open Source" target="_blank" titleStyle="H2"/>\n\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t</html:div><Text text="Try the open source variant of UI5. It contains all core UI5 features and is available on GitHub under the Apache 2.0 license." class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Supported by the open source community"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Managed on GitHub - contributions welcome!"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink href="#/topic/2d3eb2f322ea4a82983c1c62a33ec4ae" text="UI5 on Content Delivery Network" titleStyle="H2" class="sapUiSmallMarginBottom"/><Text text="Develop and run UI5 apps with the flexibility of a robust CDN. Files are loaded from the location closest to the user for optimal performance." class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="Multi-version CDN to maintain a custom lifecycle"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="For any on-premise and cloud development scenario"/></HBox></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiDemokitLandingBlockHeadline" backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA" title="Join the Community" titleAlignment="Center"/></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiBlockCenteredCell communityLinkCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:HorizontalLayout><core:Icon src="sap-icon://collaborate" size="2.5rem" color="Default"/><custom:TitleLink href="https://www.sap.com/community/topic/ui5.html?" target="_blank" text="SAP Community" titleStyle="H2" wrap="false" class="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="Information published on SAP site" width="1.5rem" class="sapUiDisclaimerCommunityLink" press="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="sapUiBlockCenteredCell communityLinkCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:HorizontalLayout><Image src="./resources/sap/ui/documentation/sdk/images/logo_stackoverflow.png" width="2.5rem" densityAware="false" class="sapUiTinyMarginTop"/><custom:TitleLink href="http://stackoverflow.com/search?q=sapui5" target="_blank" text="StackOverflow" titleStyle="H2" wrap="false" class="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="Information published on non SAP site" width="1.5rem" class="sapUiDisclaimerCommunityLink" press="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="sapUiBlockCenteredCell communityLinkCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:HorizontalLayout><Image src="./resources/sap/ui/documentation/sdk/images/logo_youtube.png" width="2.5rem" densityAware="false" class="sapUiTinyMarginTop"/><custom:TitleLink href="https://youtube.com/openui5videos" target="_blank" text="YouTube" titleStyle="H2" wrap="false" class="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="Information published on non SAP site" width="1.5rem" class="sapUiDisclaimerCommunityLink" press="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="sapUiBlockCenteredCell communityLinkCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:HorizontalLayout><Image src="./resources/sap/ui/documentation/sdk/images/logo_twitter.png" width="2.5rem" densityAware="false" class="sapUiTinyMarginTop"/><custom:TitleLink href="https://twitter.com/@openui5" target="_blank" text="Twitter" titleStyle="H2" wrap="false" class="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="Information published on non SAP site" width="1.5rem" class="sapUiDisclaimerCommunityLink" press="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/appSettingsDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core"><Dialog title="Settings" class="sapUiPopupWithPadding" contentWidth="350px" id="AppSettingsDialog"><content><VBox class="sapUiTinyMarginTop"><Label text="Theme:" design="Standard" labelFor="ThemeSelect"/><Select id="ThemeSelect" width="100%"><core:Item key="sap_belize" text="Belize"/><core:Item key="sap_belize_plus" text="Belize Deep"/><core:Item key="sap_belize_hcb" text="High Contrast Black"/><core:Item key="sap_belize_hcw" text="High Contrast White"/></Select><HBox class="sapUiTinyMarginTop" alignItems="Center" justifyContent="SpaceBetween"><Label text="Compact Content Density:" design="Standard" labelFor="CompactModeSwitch"/><Switch id="CompactModeSwitch" state="false"/></HBox><HBox class="sapUiTinyMarginTop" alignItems="Center" justifyContent="SpaceBetween"><Label text="Right To Left Mode:" design="Standard" labelFor="RTLSwitch"/><Switch id="RTLSwitch" state="false"/></HBox></VBox></content><beginButton><Button text="OK" press="handleSaveAppSettings"/></beginButton><endButton><Button text="Cancel" press="handleCloseAppSettings"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/viewSettingsDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><ViewSettingsDialog id="viewSettingsDialog" confirm="onConfirmViewSettings"><groupItems><ViewSettingsItem text="Alphabetically" key="name" selected="true"/><ViewSettingsItem text="Category" key="category"/><ViewSettingsItem text="Content Density" key="formFactors"/><ViewSettingsItem text="Namespace" key="namespace"/><ViewSettingsItem text="Release" key="since"/></groupItems><filterItems><ViewSettingsFilterItem text="Category" key="category" id="categoryFilter" items="{path:\'filter&gt;/category\',sorter:{path:\'id\',descending:false}}"><items><ViewSettingsItem text="{filter&gt;id}" key="{filter&gt;id}"/></items></ViewSettingsFilterItem><ViewSettingsFilterItem text="Content Density" key="formFactors" items="{path:\'filter&gt;/formFactors\',sorter:{path:\'id\',descending:false}}"><items><ViewSettingsItem text="{filter&gt;id}" key="{filter&gt;id}"/></items></ViewSettingsFilterItem><ViewSettingsFilterItem text="Namespace" key="namespace" items="{path:\'filter&gt;/namespace\',sorter:{path:\'id\',descending:false}}"><items><ViewSettingsItem text="{filter&gt;id}" key="{filter&gt;id}"/></items></ViewSettingsFilterItem><ViewSettingsFilterItem text="Release" key="since" items="{path:\'filter&gt;/since\',sorter:{path:\'id\',descending:false}}"><items><ViewSettingsItem text="{filter&gt;id}" key="{filter&gt;id}"/></items></ViewSettingsFilterItem></filterItems></ViewSettingsDialog></core:FragmentDefinition>'
},"sap/ui/documentation/library-preload"
);
//# sourceMappingURL=library-preload.js.map