/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/ui/base/ManagedObject","sap/ui/dt/Util","sap/base/Log","sap/ui/core/Component"],function(q,B,M,U,L,C){"use strict";var E={};E.iMaxAllowedZIndex=null;E.iterateOverAllPublicAggregations=function(e,c){var a=e.getMetadata().getAllAggregations();var A=Object.keys(a);A.forEach(function(s){var o=a[s];var v=this.getAggregation(e,s);c(o,v);},this);};E.getElementInstance=function(e){if(typeof e==="string"){var o=sap.ui.getCore().byId(e);return o||C.get(e);}else{return e;}};E.hasAncestor=function(e,a){a=this.fixComponentContainerElement(a);var f;while(e&&e!==a){f=this.fixComponentParent(e);if(e===f){e=e.getParent();}else{e=f;}}return!!e;};E.getClosestElementForNode=function(n){var c=q(n).closest("[data-sap-ui]");return c.length?sap.ui.getCore().byId(c.data("sap-ui")):undefined;};E.fixComponentParent=function(e){if(B.isA(e,"sap.ui.core.UIComponent")){var c=e.oContainer;if(c){return c.getParent();}}else{return e;}};E.fixComponentContainerElement=function(e){if(B.isA(e,"sap.ui.core.ComponentContainer")){if(!e.getComponentInstance()){return;}return e.getComponentInstance().getRootControl();}else{return e;}};E.getDomRef=function(e){if(e){var d;if(e.getDomRef){d=e.getDomRef();}if(!d&&e.getRenderedDomRef){d=e.getRenderedDomRef();}return d;}};E.findAllSiblingsInContainer=function(e,c){var p=e.getParent();if(!p){return[];}if(p!==c){var P=E.findAllSiblingsInContainer(p,c);return P.map(function(p){return E.getAggregation(p,e.sParentAggregationName);}).reduce(function(a,b){return a.concat(b);},[]);}return E.getAggregation(p,e.sParentAggregationName);};E.getAggregationAccessors=function(e,a){var m=e.getMetadata();m.getJSONKeys();var A=m.getAggregation(a);if(A){var g=A._sGetter;if(A.altTypes&&A.altTypes.length&&e[A._sGetter+"Control"]){g=A._sGetter+"Control";}return{get:g,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}else{return{};}};E.getAggregation=function(e,a){var v;var g=this.getAggregationAccessors(e,a).get;if(g){v=e[g]();}else{v=e.getAggregation(a);}v=v&&v.splice?v:(v?[v]:[]);return v;};E.getIndexInAggregation=function(e,p,a){return this.getAggregation(p,a).indexOf(e);};E.addAggregation=function(p,a,e){if(this.hasAncestor(p,e)){throw new Error("Trying to add an element to itself or its successors");}var A=this.getAggregationAccessors(p,a).add;if(A){p[A](e);}else{p.addAggregation(a,e);}};E.removeAggregation=function(p,a,e,s){var A=this.getAggregationAccessors(p,a).remove;if(A){p[A](e,s);}else{p.removeAggregation(a,e,s);}};E.insertAggregation=function(p,a,e,i){if(this.hasAncestor(p,e)){throw new Error("Trying to add an element to itself or its successors");}if(this.getIndexInAggregation(e,p,a)!==-1){e.__bSapUiDtSupressParentChangeEvent=true;try{this.removeAggregation(p,a,e,true);}finally{delete e.__bSapUiDtSupressParentChangeEvent;}}var A=this.getAggregationAccessors(p,a).insert;if(A){p[A](e,i);}else{p.insertAggregation(a,e,i);}};E.isValidForAggregation=function(p,a,e){var A=p.getMetadata().getAggregation(a);if(this.hasAncestor(p,e)){return false;}if(A){var t=A.type;if(A.multiple===false&&this.getAggregation(p,a)&&this.getAggregation(p,a).length>0){return false;}return B.isA(e,t)||this.hasInterface(e,t);}};E.getAssociationAccessors=function(e,a){var m=e.getMetadata();m.getJSONKeys();var A=m.getAssociation(a);if(A){return{get:A._sGetter,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}else{return{};}};E.getAssociation=function(e,a){var v;var g=this.getAssociationAccessors(e,a).get;if(g){v=e[g]();}return v;};E.getIndexInAssociation=function(e,p,a){return this.getAssociationInstances(p,a).indexOf(e);};E.getAssociationInstances=function(e,a){var v=U.castArray(this.getAssociation(e,a));return v.map(function(i){return this.getElementInstance(i);},this);};E.hasInterface=function(e,i){var I=e.getMetadata().getInterfaces();return I.indexOf(i)!==-1;};E.isElementValid=function(e,s,a){var i=e instanceof M&&!e.bIsDestroyed;if(!i&&s&&a){L.error(["sap.ui.dt.DesignTime: child element in aggregation "+a+" of '"+s,"' should be a descendant of 'sap.ui.base.ManagedObject' and it is a '"+typeof e+"'. ","Please ignore the aggregation '"+a+"' in the .designtime configuration"].join(''));}return i;};E.getParent=function(e){return B.isA(e,'sap.ui.core.Component')?e.oContainer:e.getParent();};E.getLabelForElement=function(e,f){if(!E.isElementValid(e)){throw U.createError("ElementUtil#getLabelForElement","A valid managed object instance should be passed as parameter","sap.ui.dt");}if(typeof f==="function"){return f(e);}else{var c=function(e){var F=(typeof e.getText==="function"&&e.getText()||typeof e.getLabelText==="function"&&e.getLabelText()||typeof e.getLabel==="function"&&e.getLabel()||typeof e.getTitle==="function"&&e.getTitle()||typeof e.getHeading==="function"&&e.getHeading());if(E.isElementValid(F)){return c(F);}else{return F;}};var v=c(e);return typeof v!=="string"?e.getId():v;}};E.extractTemplateId=function(b){if(b.templateId){if(b.stack.length>1){var r;var a=sap.ui.getCore().byId(b.templateId);var A;var I;for(var i=b.stack.length-2;i>=0;i--){A=b.stack[i].aggregation;I=b.stack[i].index;r=E.getAggregation(a,A)[I];a=r;}return a.getId();}else if(b.stack.length===1){return b.templateId;}}else{return undefined;}};E.getZIndexBelowOpenPopups=function(c){if(U.isInteger(this.iMaxAllowedZIndex)&&this.iMaxAllowedZIndex<c){return this.iMaxAllowedZIndex;}else{return c;}};E.setMaxAllowedZIndex=function(z){this.iMaxAllowedZIndex=z;};return E;},true);
