/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/Utils","sap/ui/fl/FlexCustomData","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/context/ContextManager","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/core/Component","sap/ui/core/Element"],function(C,U,F,a,V,b,c,d,J,X,e,E){"use strict";var f=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};f.PENDING="sap.ui.fl:PendingChange";f.PROCESSING="sap.ui.fl:ProcessingChange";f.variantTechnicalParameterName="sap-ui-fl-control-variant-id";f.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};f.prototype.getComponentName=function(){return this._sComponentName;};f.prototype.getAppVersion=function(){return this._sAppVersion;};f.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController._fillVariantModel();}return D;};f.prototype.createBaseChange=function(o,A){var g,h;var i=d._getContextIdsFromUrl();if(i.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No Application Component found - to offer flexibility. Valid relation to its owning component must be present.");}o.reference=this.getComponentName();o.packageName="$TMP";o.context=i.length===1?i[0]:"";o.validAppVersions=this._getValidAppVersions(o);g=a.createInitialFileContent(o);h=new a(g);if(o.variantReference){h.setVariantReference(o.variantReference);}return h;};f.prototype.createChange=function(o,g){var h,i;if(!g){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=g.id||g.getId();if(!o.selector){o.selector={};}var A=g.appComponent||U.getAppComponentForControl(g);if(!A){throw new Error("No Application Component found - to offer flexibility the control with the id '"+s+"' has to have a valid relation to its owning application component.");}Object.assign(o.selector,J.getSelector(s,A));h=this.createBaseChange(o,A);var j=g.controlType||U.getControlType(g);if(!j){throw new Error("No control type found - the change handler can not be retrieved.");}i=this._getChangeHandler(h,j,g,J);if(i){i.completeChangeContent(h,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return h;};f.prototype.createVariant=function(v,A){var o,g;if(!A){throw new Error("No Application Component found - to offer flexibility the variant has to have a valid relation to its owning application component.");}v.content.reference=this.getComponentName();v.content.packageName="$TMP";v.content.validAppVersions=this._getValidAppVersions(v);g=V.createInitialFileContent(v);o=new V(g);return o;};f.prototype._getValidAppVersions=function(o){var A=this.getAppVersion();var v={creation:A,from:A};if(A&&o.developerMode&&o.scenario!==sap.ui.fl.Scenario.AdaptationProject&&o.scenario!==sap.ui.fl.Scenario.AppVariant){v.to=A;}return v;};f.prototype.addChange=function(o,g){var h=this.createChange(o,g);var A=U.getAppComponentForControl(g);this.addPreparedChange(h,A);return h;};f.prototype.addPreparedChange=function(o,A){if(o.getVariantReference()){var m=A.getModel("$FlexVariants");m._addChange(o);}this._oChangePersistence.addChange(o,A);return o;};f.prototype.deleteChange=function(o,A){this._oChangePersistence.deleteChange(o);if(o.getVariantReference()){A.getModel("$FlexVariants")._removeChange(o);}};f.prototype.createAndApplyChange=function(o,g){var h=this.addChange(o,g);var p={modifier:J,appComponent:U.getAppComponentForControl(g),view:U.getViewForControl(g)};return this.checkTargetAndApplyChange(h,g,p).then(function(r){if(!r.success){var i=r.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(h);throw i;}return h;}.bind(this));};f.prototype._checkDependencies=function(o,D,m,A,r){var R=this._checkChange(o,A);if(!R){return[];}r.push(o);var s=o.getId();var g=D[s]&&D[s].dependencies||[];for(var i=0,n=g.length;i<n;i++){var h=U.getChangeFromChangesMap(m,g[i]);R=this._checkDependencies(h,D,m,A,r);if(R.length===0){r=[];break;}delete D[s];}return r;};f.prototype._checkChange=function(o,A){var s;var S=o.getSelector();if(S.idIsLocal){s=A.createId(S.id);}else{s=S.id;}var g=sap.ui.getCore().byId(s);if(!g){return false;}var h=F.hasFailedCustomDataJs(g,o,J).customData;if(h){return false;}return true;};f.prototype.waitForChangesToBeApplied=function(o){var m=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=Object.assign({},m.mDependencies);var g=m.mChanges;var h=g[o.getId()]||[];var n=h.filter(function(i){return!this._isChangeCurrentlyApplied(o,i,J);},this);var A=U.getAppComponentForControl(o);var r=[];n.forEach(function(i){var j=this._checkDependencies(i,D,m.mChanges,A,[]);r=r.concat(j);},this);r=r.filter(function(i,P,j){return j.indexOf(i)===P;});r.forEach(function(w){if(!w.aPromiseFn){w.aPromiseFn=[];}p.push(new Promise(function(i,j){w.aPromiseFn.push({resolve:i,reject:j});}).catch(function(i){var j=i.getId&&m.mDependentChangesOnMe[i.getId()]||[];j.forEach(function(s){var k=U.getChangeFromChangesMap(g,s);if(k.aPromiseFn){k.aPromiseFn.forEach(function(P){P.reject(k);});}});Promise.resolve();}));},this);return Promise.all(p);};f.prototype.saveAll=function(s){return this._oChangePersistence.saveDirtyChanges(s);};f.prototype.processXmlView=function(v,p){var o=e.get(p.componentId);var A=U.getAppComponentForControl(o);var m=A.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};f.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};f.prototype._checkForDependentSelectorControls=function(o,p){var D=o.getDependentControlSelectorList();D.forEach(function(s){var g=p.modifier.bySelector(s,p.appComponent,p.view);if(!g){throw new Error("A dependent selector control of the flexibility change is not available.");}});};f.prototype._resolveGetChangesForView=function(p,g){var P=[];if(!Array.isArray(g)){var s="No list of changes was passed for processing the flexibility on view: "+p.view+".";U.log.error(s,undefined,"sap.ui.fl.FlexController");return[];}g.forEach(function(o){try{var S=this._getSelectorOfChange(o);if(!S||!S.id){throw new Error("No selector in change found or no selector ID.");}var h=p.modifier.bySelector(S,p.appComponent,p.view);if(!h){throw new Error("A flexibility change tries to change a nonexistent control.");}this._checkForDependentSelectorControls(o,p);P.push(function(){return this.checkTargetAndApplyChange(o,h,p).then(function(r){if(!r.success){this._logApplyChangeError(r.error||{},o);}}.bind(this));}.bind(this));}catch(i){this._logApplyChangeError(i,o);}}.bind(this));return U.execPromiseQueueSequentially(P).then(function(){return p.view;});};f.prototype._logApplyChangeError=function(o,g){var D=g.getDefinition();var s=D.changeType;var t=D.selector.id;var h=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(o.message){w+="\n   occurred error message: '"+o.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+h;w+="\n   id of targeted control: '"+t+"'.";U.log.warning(w,undefined,"sap.ui.fl.FlexController");};f.prototype._isXmlModifier=function(p){return p.modifier.targets==="xmlTree";};f.prototype.checkTargetAndApplyChange=function(o,g,p){var x=this._isXmlModifier(p);var m=p.modifier;var s=m.getControlType(g);var h=this._getControlIfTemplateAffected(o,g,s,p);var i=this._getChangeHandler(o,h.controlType,h.control,m);var S,r;if(!i){var j="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";U.log.warning(j);return new U.FakePromise({success:false,error:new Error(j)});}if(x&&o.getDefinition().jsOnly){return new U.FakePromise({success:false,error:new Error("Change cannot be applied in XML. Retrying in JS.")});}if(!this._isChangeCurrentlyApplied(g,o,m)){var R=this.isChangeHandlerRevertible(o,h.control,i);return new U.FakePromise().then(function(){S=b.getInstanceOrUndef();if(!R&&S&&S._oSettings.recordUndo){if(x){throw new Error();}return new Promise(function(k){sap.ui.require(["sap/ui/rta/ControlTreeModifier"],function(l){if(!l){U.log.error("Please load 'sap/ui/rta' library if you want to record undo");}else{p.modifier=l;l.startRecordingUndo();r=l;}k();});});}}).then(function(){o.PROCESSING=o.PROCESSING?o.PROCESSING:true;var I=i.applyChange(o,h.control,p);if(h.bTemplateAffected){m.updateAggregation(g,o.getContent().boundAggregation);}return I;}).then(function(I){if(I instanceof E){g=I;}if(!R&&S&&S._oSettings.recordUndo&&r){o.setUndoOperations(r.stopRecordingUndo());}F.addAppliedCustomData(g,o,p,R&&x);if(o.aPromiseFn){o.aPromiseFn.forEach(function(P){P.resolve(o);});}delete o.PROCESSING;o.PROCESSED=true;return{success:true};}).catch(function(k){this._logErrorAndWriteCustomData(k,o,p,g,x);if(o.aPromiseFn){o.aPromiseFn.forEach(function(P){P.reject(o);});}delete o.PROCESSING;o.PROCESSED=true;return{success:false,error:k};}.bind(this));}return new U.FakePromise({success:true});};f.prototype._removeFromAppliedChangesAndMaybeRevert=function(o,g,p,r){var m=p.modifier;var s=m.getControlType(g);var h=this._getControlIfTemplateAffected(o,g,s,p);var i=this._getChangeHandler(o,h.controlType,h.control,m);var R;var S;if(r&&!i){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");return new U.FakePromise();}if(o.getChangeType()==="stashControl"&&s==="sap.ui.core._StashedControl"){S=true;if(r&&!o.getRevertData()){i.setChangeRevertData(o,false);}}var I=this._isChangeCurrentlyApplied(g,o,m);if(!I&&(o.PROCESSING||o.QUEUED)){R=new Promise(function(j,k){o.aPromiseFn=o.aPromiseFn||[];o.aPromiseFn.push({resolve:j,reject:k});}).then(function(){return true;});}else{R=new U.FakePromise(false);}return R.then(function(P){if(r&&(P||(!P&&I))||r&&S){if(!o.getRevertData()){o.setRevertData(F.getParsedRevertDataFromCustomData(g,o,m));}var j=i.revertChange(o,h.control,p);if(h.bTemplateAffected){m.updateAggregation(g,o.getContent().boundAggregation);}return j;}}).then(function(){g=p.modifier.bySelector(o.getSelector(),p.appComponent,p.view);F.destroyAppliedCustomData(g,o,p.modifier);}).catch(function(j){U.log.error("Change could not be reverted:",j);});};f.prototype._logErrorAndWriteCustomData=function(r,o,p,g,x){var s=o.getId(),l="Change ''{0}'' could not be applied.",h=r instanceof Error,i=F.getCustomDataIdentifier(false,h,x);switch(i){case F.notApplicableChangesCustomDataKey:U.formatAndLogMessage("info",[l,r.message],[s]);break;case F.failedChangesCustomDataKeyXml:this._setMergeError(true);U.formatAndLogMessage("warning",[l,"Merge error detected while processing the XML tree."],[s],r.stack);break;case F.failedChangesCustomDataKeyJs:this._setMergeError(true);U.formatAndLogMessage("error",[l,"Merge error detected while processing the JS control tree."],[s],r.stack);break;}F.addFailedCustomData(g,o,p,i);};f.prototype._isChangeCurrentlyApplied=function(o,g,m){return!!F.getAppliedCustomDataValue(o,g,m);};f.prototype._handlePromiseChainError=function(v,o){U.log.error("Error processing view "+o+".");return v;};f.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};f.prototype._getChangeHandler=function(o,s,g,m){var h=o.getChangeType();var l=o.getLayer();return this._getChangeRegistry().getChangeHandler(h,s,g,m,l);};f.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};f.prototype._getControlIfTemplateAffected=function(o,g,s,p){var h=o.getDefinition();var m={};if(o.getContent().boundAggregation&&h.dependentSelector.originalSelector){var M=p.modifier;m.control=M.bySelector(h.dependentSelector.originalSelector,p.appComponent,p.view);m.controlType=M.getControlType(m.control);m.bTemplateAffected=true;}else{m.control=g;m.controlType=s;m.bTemplateAffected=false;}return m;};f.prototype.getComponentChanges=function(p,i){return this._oChangePersistence.getChangesForComponent(p,i);};f.prototype.checkForOpenDependenciesForControl=function(s,m,o){return this._oChangePersistence.checkForOpenDependenciesForControl(s,m,o);};f.prototype.hasHigherLayerChanges=function(p){p=p||{};var s=p.upToLayer||U.getCurrentLayer(false);p.includeVariants=true;p.includeCtrlVariants=true;return this.getComponentChanges(p).then(function(v){var h=v===this._oChangePersistence.HIGHER_LAYER_CHANGES_EXIST||v.some(function(o){return U.compareAgainstCurrentLayer(o.getLayer(),s)>0;});return!!h;}.bind(this));};f.prototype._createChangePersistence=function(){this._oChangePersistence=c.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};f.prototype.resetChanges=function(l,g,o){return this._oChangePersistence.resetChanges(l,g).then(function(r){if(o){var m=o.getModel("$FlexVariants");if(m){m.updateHasherEntry({parameters:[],updateURL:true,component:o});}}return r;});};f.prototype.discardChanges=function(g,D){var A=U.getCurrentLayer(!!D);var i=0;var l;var o;l=g.length;while(i<g.length){o=g[i];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(l===g.length){i++;}else{l=g.length;}}return this._oChangePersistence.saveDirtyChanges();};f.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var g=o.mChanges[i]||[];return this.discardChanges(g,D);};f.prototype._setMergeError=function(){return b.getInstance().then(function(s){s.setMergeErrorOccured(true);});};f.prototype._checkIfDependencyIsStillValid=function(A,m,s){var o=U.getChangeFromChangesMap(this._oChangePersistence._mChanges.mChanges,s);if(!o.PROCESSED){return true;}var g=m.bySelector(o.getSelector(),A);if(!this._isChangeCurrentlyApplied(g,o,m)){return true;}return false;};f.prototype._applyChangesOnControl=function(g,o,h){var p=[];var m=g();var i=m.mChanges;var D=m.mDependencies;var j=m.mDependentChangesOnMe;var k=i[h.getId()]||[];var A=U.getAppComponentForControl(h);var P={modifier:J,appComponent:A,view:U.getViewForControl(h)};k.forEach(function(l){if(l.PROCESSED&&!this._isChangeCurrentlyApplied(h,l,P.modifier)){m=this._oChangePersistence.copyDependenciesFromInitialChangesMap(l,this._checkIfDependencyIsStillValid.bind(this,A,P.modifier));D=m.mDependencies;j=m.mDependentChangesOnMe;delete l.PROCESSED;}if(!D[l.getId()]){l.QUEUED=true;p.push(function(){return this.checkTargetAndApplyChange(l,h,P).then(function(r){this._updateDependencies(D,j,l.getId());delete l.QUEUED;}.bind(this));}.bind(this));}else{D[l.getId()][f.PENDING]=this.checkTargetAndApplyChange.bind(this,l,h,P);}}.bind(this));return U.execPromiseQueueSequentially(p).then(function(){return this._processDependentQueue(D,j,A);}.bind(this));};f.prototype.getBoundApplyChangesOnControl=function(g,o){var B=this._applyChangesOnControl.bind(this,g,o);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};f.prototype.revertChangesOnControl=function(g,A){var p=[];g.forEach(function(o){p.push(function(){var s=this._getSelectorOfChange(o);var h=J.bySelector(s,A);var P={modifier:J,appComponent:A,view:U.getViewForControl(h)};return this._removeFromAppliedChangesAndMaybeRevert(o,h,P,true).then(function(){this._oChangePersistence._deleteChangeInMap(o);}.bind(this));}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};f.prototype.isChangeHandlerRevertible=function(o,g,h){if(!h){var s=J.getControlType(g);h=this._getChangeHandler(o,s,g,J);}return!!(h&&typeof h.revertChange==="function");};f.prototype.applyVariantChanges=function(g,A){var p=[];g.forEach(function(o){this._oChangePersistence._addChangeAndUpdateDependencies(A,o);p.push(function(){var m=J;var s=this._getSelectorOfChange(o);var h=m.bySelector(s,A);if(!h){U.log.error("A flexibility change tries to change a nonexistent control.");return new U.FakePromise();}return this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,h);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};f.prototype.removeFromAppliedChangesOnControl=function(o,A,g){var p={modifier:J,appComponent:A,view:U.getViewForControl(g)};return this._removeFromAppliedChangesAndMaybeRevert(o,g,p,false);};f.prototype._updateControlsDependencies=function(D,A){var o;Object.keys(D).forEach(function(s){var g=D[s];if(g.controlsDependencies&&g.controlsDependencies.length>0){var l=g.controlsDependencies.length;while(l--){var S=g.controlsDependencies[l];o=J.bySelector(S,A);if(o){g.controlsDependencies.splice(l,1);}}}});};f.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o.dependencies.indexOf(s);if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};f.prototype._iterateDependentQueue=function(D,m,A){var g=[],h=[],p=[];this._updateControlsDependencies(D,A);Object.keys(D).forEach(function(s){var o=D[s];if(o[f.PENDING]&&o.dependencies.length===0&&!(o.controlsDependencies&&o.controlsDependencies.length>0)&&!o[f.PROCESSING]){o[f.PROCESSING]=true;p.push(function(){return o[f.PENDING]().then(function(r){h.push(s);g.push(o.changeObject.getId());});});}});return U.execPromiseQueueSequentially(p).then(function(){for(var j=0;j<h.length;j++){delete D[h[j]];}for(var k=0;k<g.length;k++){this._updateDependencies(D,m,g[k]);}return g;}.bind(this));};f.prototype._processDependentQueue=function(D,m,A){return this._iterateDependentQueue(D,m,A).then(function(g){if(g.length>0){return this._processDependentQueue(D,m,A);}}.bind(this));};return f;},true);
