/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/Sorter','sap/ui/model/FilterProcessor','sap/ui/core/format/DateFormat',"sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery","sap/base/security/encodeURL","sap/ui/core/library"],function(S,F,D,L,a,q,e,l){"use strict";var C=l.CalendarType;var r=/^([-+]?)0*(\d+)(\.\d+|)$/,b=/\.$/,c=/0+$/;var O=function(){};O.createSortParams=function(t){var u;if(!t||t.length==0){return;}u="$orderby=";for(var i=0;i<t.length;i++){var v=t[i];if(v instanceof S){u+=v.sPath;u+=v.bDescending?"%20desc":"%20asc";u+=",";}else{L.error("Trying to use "+v+" as a Sorter, but it is a "+typeof v);}}u=u.slice(0,-1);return u;};function d(i){if(i&&typeof i.convert==="function"){i=i.convert();}return i;}O.createFilterParams=function(v,M,E){var i;if(Array.isArray(v)){v=v.map(d);i=F.groupFilters(v);}else{i=d(v);}if(!i){return;}return"$filter="+this._createFilterParams(i,M,E);};O._createFilterParams=function(v,M,E){var t=this,u=Array.isArray(v)?F.groupFilters(v):v;function w(u,i){u=d(u);if(u.aFilters){return x(u,i);}return t._createFilterSegment(u.sPath,M,E,u.sOperator,u.oValue1,u.oValue2,u.bCaseSensitive);}function x(y,z){var A=y.aFilters,B=!!y.bAnd,G="";if(A.length===1){if(A[0]._bMultiFilter){return w(A[0]);}return w(A[0],true);}if(!z){G+="(";}G+=w(A[0]);for(var i=1;i<A.length;i++){G+=B?"%20and%20":"%20or%20";G+=w(A[i]);}if(!z){G+=")";}return G;}if(!u){return;}return w(u,true);};O._createUrlParamsArray=function(P){var u,t=q.type(P),i;if(t==="array"){return P;}u=[];if(t==="object"){i=this._encodeURLParameters(P);if(i){u.push(i);}}else if(t==="string"){if(P){u.push(P);}}return u;};O._encodeURLParameters=function(P){if(!P){return"";}var u=[];q.each(P,function(i,v){if(q.type(v)==="string"){v=encodeURIComponent(v);}i=i.startsWith('$')?i:encodeURIComponent(i);u.push(i+"="+v);});return u.join("&");};O.setOrigin=function(i,P){var t,u,v;if(!i||!P||i.indexOf(";mo")>0){return i;}if(typeof P=="string"){t=P;}else{t=P.alias;if(!t){u=P.system;v=P.client;if(!u||!v){L.warning("ODataUtils.setOrigin: No Client or System ID given for Origin");return i;}t="sid("+u+"."+v+")";}}var U=i.split("?");var B=U[0];var w=U[1]?"?"+U[1]:"";var T="";if(B[B.length-1]==="/"){B=B.substring(0,B.length-1);T="/";}var x=/(\/[^\/]+)$/g;var y=/(;o=[^\/;]+)/g;var z=B.match(x)[0];var A=z.match(y);var E=A?A[0]:null;if(E){if(P.force){var G=z.replace(E,";o="+t);B=B.replace(z,G);return B+T+w;}return i;}B=B+";o="+t+T;return B+w;};O.setAnnotationOrigin=function(A,P){var i;var t=A.indexOf("/Annotations(");var H=P&&P.preOriginBaseUri?P.preOriginBaseUri.indexOf(".xsodata"):-1;if(t===-1){t=A.indexOf("/Annotations%28");}if(t>=0){if(A.indexOf("/$value",t)===-1){L.warning("ODataUtils.setAnnotationOrigin: Annotation url is missing $value segment.");i=A;}else{var u=A.substring(0,t);var v=A.substring(t,A.length);var w=O.setOrigin(u,P);i=w+v;}}else if(H>=0){i=O.setOrigin(A,P);}else{i=A.replace(P.preOriginBaseUri,P.postOriginBaseUri);}return i;};O._resolveMultiFilter=function(M,t,E){var u=this,v=M.aFilters,w="";if(v){w+="(";q.each(v,function(i,x){if(x._bMultiFilter){w+=u._resolveMultiFilter(x,t,E);}else if(x.sPath){w+=u._createFilterSegment(x.sPath,t,E,x.sOperator,x.oValue1,x.oValue2,"",x.bCaseSensitive);}if(i<(v.length-1)){if(M.bAnd){w+="%20and%20";}else{w+="%20or%20";}}});w+=")";}return w;};O._createFilterSegment=function(P,M,E,i,v,V,t){var u,T;if(t===undefined){t=true;}if(E){u=M._getPropertyMetadata(E,P);T=u&&u.type;a(u,"PropertyType for property "+P+" of EntityType "+E.name+" not found!");}if(T){v=this.formatValue(v,T,t);V=(V!=null)?this.formatValue(V,T,t):null;}else{a(null,"Type for filter property could not be found in metadata!");}if(v){v=e(String(v));}if(V){V=e(String(V));}if(!t&&T==="Edm.String"){P="toupper("+P+")";}switch(i){case"EQ":case"NE":case"GT":case"GE":case"LT":case"LE":return P+"%20"+i.toLowerCase()+"%20"+v;case"BT":return"("+P+"%20ge%20"+v+"%20and%20"+P+"%20le%20"+V+")";case"NB":return"not%20("+P+"%20ge%20"+v+"%20and%20"+P+"%20le%20"+V+")";case"Contains":return"substringof("+v+","+P+")";case"NotContains":return"not%20substringof("+v+","+P+")";case"StartsWith":return"startswith("+P+","+v+")";case"NotStartsWith":return"not%20startswith("+P+","+v+")";case"EndsWith":return"endswith("+P+","+v+")";case"NotEndsWith":return"not%20endswith("+P+","+v+")";default:L.error("ODataUtils :: Unknown filter operator "+i);return"true";}};O.formatValue=function(v,t,i){if(i===undefined){i=true;}if(!this.oDateTimeFormat){this.oDateTimeFormat=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss''",calendarType:C.Gregorian});this.oDateTimeFormatMs=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss.SSS''",calendarType:C.Gregorian});this.oDateTimeOffsetFormat=D.getDateInstance({pattern:"'datetimeoffset'''yyyy-MM-dd'T'HH:mm:ss'Z'''",calendarType:C.Gregorian});this.oTimeFormat=D.getTimeInstance({pattern:"'time''PT'HH'H'mm'M'ss'S'''",calendarType:C.Gregorian});}if(v===null||v===undefined){return"null";}var V;switch(t){case"Edm.String":v=i?v:v.toUpperCase();V="'"+String(v).replace(/'/g,"''")+"'";break;case"Edm.Time":if(typeof v==="object"){V=this.oTimeFormat.format(new Date(v.ms),true);}else{V="time'"+v+"'";}break;case"Edm.DateTime":var u=new Date(v);if(u.getMilliseconds()>0){V=this.oDateTimeFormatMs.format(u,true);}else{V=this.oDateTimeFormat.format(u,true);}break;case"Edm.DateTimeOffset":var u=new Date(v);V=this.oDateTimeOffsetFormat.format(u,true);break;case"Edm.Guid":V="guid'"+v+"'";break;case"Edm.Decimal":V=v+"m";break;case"Edm.Int64":V=v+"l";break;case"Edm.Double":V=v+"d";break;case"Edm.Float":case"Edm.Single":V=v+"f";break;case"Edm.Binary":V="binary'"+v+"'";break;default:V=String(v);break;}return V;};function s(v,V){if(v===V){return 0;}if(v===null||V===null||v===undefined||V===undefined){return NaN;}return v>V?1:-1;}function p(v){var M;if(typeof v!=="string"){return undefined;}M=r.exec(v);if(!M){return undefined;}return{sign:M[1]==="-"?-1:1,integerLength:M[2].length,abs:M[2]+M[3].replace(c,"").replace(b,"")};}function f(v,V){var i,t,R;if(v===V){return 0;}i=p(v);t=p(V);if(!i||!t){return NaN;}if(i.sign!==t.sign){return i.sign>t.sign?1:-1;}R=s(i.integerLength,t.integerLength)||s(i.abs,t.abs);return i.sign*R;}var g=/^PT(\d\d)H(\d\d)M(\d\d)S$/;function h(v){if(typeof v==="string"&&g.test(v)){v=parseInt(RegExp.$1,10)*3600000+parseInt(RegExp.$2,10)*60000+parseInt(RegExp.$3,10)*1000;}if(v instanceof Date){return v.getTime();}if(v&&v.__edmType==="Edm.Time"){return v.ms;}return v;}O.compare=function(v,V,A){return A?f(v,V):s(h(v),h(V));};O.getComparator=function(E){switch(E){case"Edm.Date":case"Edm.DateTime":case"Edm.DateTimeOffset":case"Edm.Time":return O.compare;case"Edm.Decimal":case"Edm.Int64":return f;default:return s;}};var j=/([(=,])('.*?')([,)])/g,k=/[MLDF](?=[,)](?:[^']*'[^']*')*[^']*$)/g,m=/([(=,])(X')/g,n=function(v,i,t,u){return i+encodeURIComponent(decodeURIComponent(t))+u;},N=function(v){return v.toLowerCase();},o=function(v,i){return i+"binary'";};O._normalizeKey=function(K){return K.replace(j,n).replace(k,N).replace(m,o);};return O;},true);
