/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_AnnotationHelperBasics","sap/base/Log","sap/ui/base/BindingParser","sap/ui/base/ManagedObject","sap/ui/core/format/DateFormat","sap/ui/model/odata/ODataUtils","sap/ui/performance/Measurement"],function(B,L,a,M,D,O,b){'use strict';var A="sap.ui.model.odata.AnnotationHelper",d="\\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\\d|3[01])",s="[-+]?\\d+(?:\\.\\d+)?",m="9007199254740991",c="-"+m,p=[A],P=A+"/getExpression",t="(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d(\\.\\d{1,12})?)?",E={Bool:/^true$|^false$/i,Float:new RegExp("^"+s+"(?:[eE][-+]?\\d+)?$|^NaN$|^-INF$|^INF$"),Date:new RegExp("^"+d+"$"),DateTimeOffset:new RegExp("^"+d+"T"+t+"(?:Z|[-+](?:0\\d|1[0-3]):[0-5]\\d|[-+]14:00)$","i"),Decimal:new RegExp("^"+s+"$"),Guid:/^[A-F0-9]{8}-(?:[A-F0-9]{4}-){3}[A-F0-9]{12}$/i,Int:/^[-+]?\d{1,19}$/,TimeOfDay:new RegExp("^"+t+"$")},f,r=/^\{@i18n>[^\\\{\}:]+\}$/,g=/^\d+$/,o={And:"&&",Eq:"===",Ge:">=",Gt:">",Le:"<=",Lt:"<",Ne:"!==",Not:"!",Or:"||"},h=/^(\/dataServices\/schema\/\d+)(?:\/|$)/,T={"Edm.Boolean":"boolean","Edm.Byte":"number","Edm.Date":"date","Edm.DateTime":"datetime","Edm.DateTimeOffset":"datetime","Edm.Decimal":"decimal","Edm.Double":"number","Edm.Float":"number","Edm.Guid":"string","Edm.Int16":"number","Edm.Int32":"number","Edm.Int64":"decimal","Edm.SByte":"number","Edm.Single":"number","Edm.String":"string","Edm.Time":"time","Edm.TimeOfDay":"time"},j={Bool:"Edm.Boolean",Float:"Edm.Double",Date:"Edm.Date",DateTimeOffset:"Edm.DateTimeOffset",Decimal:"Edm.Decimal",Guid:"Edm.Guid",Int:"Edm.Int64",String:"Edm.String",TimeOfDay:"Edm.TimeOfDay"},k={"boolean":false,"date":true,"datetime":true,"decimal":true,"number":false,"string":false,"time":true};f={adjustOperands:function(e,i){if(e.result!=="constant"&&e.category==="number"&&i.result==="constant"&&i.type==="Edm.Int64"){i.category="number";}if(e.result!=="constant"&&e.category==="decimal"&&i.result==="constant"&&i.type==="Edm.Int32"){i.category="decimal";i.type=e.type;}if(e.result==="constant"&&e.category==="date"&&i.result!=="constant"&&i.category==="datetime"){i.category="date";}},apply:function(i,e){var n=B.descend(e,"Name","string"),l=B.descend(e,"Parameters");switch(n.value){case"odata.concat":return f.concat(i,l);case"odata.fillUriTemplate":return f.fillUriTemplate(i,l);case"odata.uriEncode":return f.uriEncode(i,l);default:B.error(n,"unknown function: "+n.value);}},concat:function(I,e){var l=e.asExpression,n=[],R,q=[];B.expectType(e,"array");e.value.forEach(function(u,i){R=f.parameter(I,e,i);l=l||R.result==="expression";q.push(R);});q.forEach(function(R){if(l){f.wrapExpression(R);}if(R.type!=='edm:Null'){n.push(B.resultToString(R,l,e.withType));}});R=l?{result:"expression",value:n.join("+")}:{result:"composite",value:n.join("")};R.type="Edm.String";return R;},conditional:function(i,e){var C=f.parameter(i,e,0,"Edm.Boolean"),l=f.parameter(i,e,1),n=f.parameter(i,e,2),q=l.type,w=e.withType;if(l.type==="edm:Null"){q=n.type;}else if(n.type!=="edm:Null"&&l.type!==n.type){B.error(e,"Expected same type for second and third parameter, types are '"+l.type+"' and '"+n.type+"'");}return{result:"expression",type:q,value:B.resultToString(f.wrapExpression(C),true,false)+"?"+B.resultToString(f.wrapExpression(l),true,w)+":"+B.resultToString(f.wrapExpression(n),true,w)};},constant:function(i,e,l){var v=e.value;B.expectType(e,"string");if(l==="String"){if(r.test(v)){return{ignoreTypeInPath:true,result:"binding",type:"Edm.String",value:v.slice(1,-1)};}else if(i.getSetting&&i.getSetting("bindTexts")){return{result:"binding",type:"Edm.String",ignoreTypeInPath:true,value:"/##"+f.replaceIndexes(i.getModel(),e.path)};}l="Edm.String";}else if(!E[l].test(v)){B.error(e,"Expected "+l+" value but instead saw '"+v+"'");}else{l=j[l];if(l==="Edm.Int64"&&O.compare(v,c,true)>=0&&O.compare(v,m,true)<=0){l="Edm.Int32";}}return{result:"constant",type:l,value:v};},expression:function(i,e){var R=e.value,S,l;B.expectType(e,"object");if(R.hasOwnProperty("Type")){l=B.property(e,"Type","string");S=B.descend(e,"Value");}else{["And","Apply","Bool","Date","DateTimeOffset","Decimal","Float","Eq","Ge","Gt","Guid","If","Int","Le","Lt","Ne","Not","Null","Or","Path","PropertyPath","String","TimeOfDay"].forEach(function(n){if(R.hasOwnProperty(n)){l=n;S=B.descend(e,n);}});}switch(l){case"Apply":return f.apply(i,S);case"If":return f.conditional(i,S);case"Path":case"PropertyPath":return f.path(i,S);case"Bool":case"Date":case"DateTimeOffset":case"Decimal":case"Float":case"Guid":case"Int":case"String":case"TimeOfDay":return f.constant(i,S,l);case"And":case"Eq":case"Ge":case"Gt":case"Le":case"Lt":case"Ne":case"Or":return f.operator(i,S,l);case"Not":return f.not(i,S);case"Null":return{result:"constant",value:"null",type:"edm:Null"};default:B.error(e,"Unsupported OData expression");}},formatOperand:function(e,i,R,w){var l;if(R.result==="constant"){switch(R.category){case"boolean":case"number":return R.value;case"date":l=f.parseDate(R.value);if(!l){B.error(B.descend(e,i),"Invalid Date "+R.value);}return String(l.getTime());case"datetime":l=f.parseDateTimeOffset(R.value);if(!l){B.error(B.descend(e,i),"Invalid DateTime "+R.value);}return String(l.getTime());case"time":return String(f.parseTimeOfDay(R.value).getTime());}}if(w){f.wrapExpression(R);}return B.resultToString(R,true);},getExpression:function(i,R,w){var l;if(R===undefined){return undefined;}b.average(P,"",p);if(!f.simpleParserWarningLogged&&M.bindingParser===a.simpleParser){L.warning("Complex binding syntax not active",null,A);f.simpleParserWarningLogged=true;}try{l=f.expression(i,{asExpression:false,path:i.getPath(),value:R,withType:w});b.end(P);return B.resultToString(l,false,w);}catch(e){b.end(P);if(e instanceof SyntaxError){return"Unsupported: "+a.complexParser.escape(B.toErrorString(R));}throw e;}},fillUriTemplate:function(I,e){var i,n,l=[],q="",u,v=e.value,R,w=f.parameter(I,e,0,"Edm.String");l.push('odata.fillUriTemplate(',B.resultToString(w,true),',{');for(i=1;i<v.length;i+=1){u=B.descend(e,i,"object");n=B.property(u,"Name","string");R=f.expression(I,B.descend(u,"Value"),true);l.push(q,B.toJSON(n),":",B.resultToString(R,true));q=",";}l.push("})");return{result:"expression",value:l.join(""),type:"Edm.String"};},not:function(i,e){var l;e.asExpression=true;l=f.expression(i,e);return{result:"expression",value:"!"+B.resultToString(f.wrapExpression(l),true),type:"Edm.Boolean"};},operator:function(i,e,l){var n=l==="And"||l==="Or"?"Edm.Boolean":undefined,q=f.parameter(i,e,0,n),u=f.parameter(i,e,1,n),v,N,V,w;if(q.type!=="edm:Null"&&u.type!=="edm:Null"){q.category=T[q.type];u.category=T[u.type];f.adjustOperands(q,u);f.adjustOperands(u,q);if(q.category!==u.category){B.error(e,"Expected two comparable parameters but instead saw "+q.type+" and "+u.type);}v=q.category==="decimal"?",true":"";N=k[q.category];}V=f.formatOperand(e,0,q,!N);w=f.formatOperand(e,1,u,!N);return{result:"expression",value:N?"odata.compare("+V+","+w+v+")"+o[l]+"0":V+o[l]+w,type:"Edm.Boolean"};},parameter:function(i,e,I,l){var n=B.descend(e,I),R;n.asExpression=true;R=f.expression(i,n);if(l&&l!==R.type){B.error(n,"Expected "+l+" but instead saw "+R.type);}return R;},parseDate:function(v){return D.getDateInstance({pattern:"yyyy-MM-dd",strictParsing:true,UTC:true}).parse(v);},parseDateTimeOffset:function(v){var e=E.DateTimeOffset.exec(v);if(e&&e[1]&&e[1].length>4){v=v.replace(e[1],e[1].slice(0,4));}return D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSX",strictParsing:true}).parse(v.toUpperCase());},parseTimeOfDay:function(v){if(v.length>12){v=v.slice(0,12);}return D.getTimeInstance({pattern:"HH:mm:ss.SSS",strictParsing:true,UTC:true}).parse(v);},path:function(i,e){var l=e.value,C={},n,I,q,u=i.getModel(),v={getModel:function(){return u;},getPath:function(){return e.path;}},w,R={result:"binding",value:l},x;B.expectType(e,"string");x=B.followPath(v,{"Path":l});if(x&&x.resolvedPath){w=u.getProperty(x.resolvedPath);R.type=w.type;switch(w.type){case"Edm.DateTime":C.displayFormat=w["sap:display-format"];break;case"Edm.Decimal":if(w.precision){C.precision=w.precision;}if(w.scale){C.scale=w.scale;}q=w["Org.OData.Validation.V1.Minimum"];if(q&&(q.Decimal||q.String)){C.minimum=q.Decimal||q.String;n=q["Org.OData.Validation.V1.Exclusive"];if(n){C.minimumExclusive=n.Bool||"true";}}q=w["Org.OData.Validation.V1.Maximum"];if(q&&(q.Decimal||q.String)){C.maximum=q.Decimal||q.String;n=q["Org.OData.Validation.V1.Exclusive"];if(n){C.maximumExclusive=n.Bool||"true";}}break;case"Edm.String":C.maxLength=w.maxLength;I=w["com.sap.vocabularies.Common.v1.IsDigitSequence"];if(I){C.isDigitSequence=I.Bool||"true";}break;}if(w.nullable==="false"){C.nullable="false";}R.constraints=C;}else{L.warning("Could not find property '"+l+"' starting from '"+e.path+"'",null,A);}return R;},replaceIndexes:function(e,l){var n,q=l.split('/'),u,R;function v(w,i){var x=e.getProperty(u+"/"+w);if(typeof x==="string"){q[i]="[${"+w+"}==="+B.toJSON(x)+"]";return true;}return false;}n=h.exec(l);if(!n){return l;}u=n[1];if(!v("namespace",3)){return l;}for(var i=4;i<q.length;i++){u=u+"/"+q[i];if(g.test(q[i])&&!v("name",i)){R=e.getProperty(u+"/RecordType");if(R){if(R==="com.sap.vocabularies.UI.v1.DataFieldForAction"){v("Action/String",i);}else if(R==="com.sap.vocabularies.UI.v1.DataFieldForAnnotation"){v("Target/AnnotationPath",i);}else if(R.indexOf("com.sap.vocabularies.UI.v1.DataField")===0){v("Value/Path",i);}}}}return q.join('/');},simpleParserWarningLogged:false,uriEncode:function(i,e){var R=f.parameter(i,e,0);if(R.result==="constant"){if(R.type==="Edm.Date"){R.type="Edm.DateTime";R.value=R.value+"T00:00:00Z";}else if(R.type==="Edm.TimeOfDay"){R.type="Edm.Time";R.value="PT"+R.value.slice(0,2)+"H"+R.value.slice(3,5)+"M"+R.value.slice(6,8)+"S";}}return{result:"expression",value:'odata.uriEncode('+B.resultToString(R,true)+","+B.toJSON(R.type)+")",type:"Edm.String"};},wrapExpression:function(R){if(R.result==="expression"){R.value="("+R.value+")";}return R;}};return f;},false);
