/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./lib/_Helper","sap/ui/base/SyncPromise","sap/ui/model/odata/OperationMode","sap/ui/thirdparty/jquery"],function(_,S,O,q){"use strict";var c="sap.ui.model.odata.v4.ODataBinding";function a(){}a.prototype.checkBindingParameters=function(p,A){var t=this;Object.keys(p).forEach(function(k){var v=p[k];if(k.indexOf("$$")!==0){return;}if(A.indexOf(k)<0){throw new Error("Unsupported binding parameter: "+k);}switch(k){case"$$aggregation":break;case"$$groupId":case"$$updateGroupId":t.oModel.checkGroupId(v,false,"Unsupported value for binding parameter '"+k+"': ");break;case"$$inheritExpandSelect":if(v!==true&&v!==false){throw new Error("Unsupported value for binding parameter "+"'$$inheritExpandSelect': "+v);}if(!t.oOperation){throw new Error("Unsupported binding parameter $$inheritExpandSelect: "+"binding is not an operation binding");}if(p.$expand||p.$select){throw new Error("Must not set parameter $$inheritExpandSelect on a binding "+"which has a $expand or $select binding parameter");}break;case"$$operationMode":if(v!==O.Server){throw new Error("Unsupported operation mode: "+v);}break;case"$$ownRequest":case"$$patchWithoutSideEffects":if(v!==true){throw new Error("Unsupported value for binding parameter '"+k+"': "+v);}break;default:throw new Error("Unknown binding-specific parameter: "+k);}});};a.prototype.checkSuspended=function(){var r=this.getRootBinding();if(r&&r.isSuspended()){throw new Error("Must not call method when the binding's root binding is suspended: "+this);}};a.prototype.fetchCache=function(C){var o,b={},d,p,t=this;if(!this.bRelative){C=undefined;}if(this.oCachePromise.isFulfilled()){d=this.oCachePromise.getResult();if(d){d.setActive(false);}}p=[this.fetchQueryOptionsForOwnCache(C),this.oModel.oRequestor.ready()];this.mCacheQueryOptions=undefined;o=S.all(p).then(function(r){var v,Q=r[0];if(Q&&!(C&&C.getIndex&&C.getIndex()===-2)){v=S.resolve(C&&(C.fetchCanonicalPath?C.fetchCanonicalPath():C.getPath()));return v.then(function(s){var e,E;if(!o||t.oFetchCacheCallToken===b){t.mCacheQueryOptions=q.extend(true,{},t.oModel.mUriParameters,Q);if(s){t.mCacheByContext=t.mCacheByContext||{};e=t.mCacheByContext[s];if(e){e.setActive(true);}else{e=t.doCreateCache(_.buildPath(s,t.sPath).slice(1),t.mCacheQueryOptions,C);t.mCacheByContext[s]=e;e.$canonicalPath=s;}}else{e=t.doCreateCache(t.sPath.slice(1),t.mCacheQueryOptions,C);}return e;}else{E=new Error("Cache discarded as a new cache has been created");E.canceled=true;throw E;}});}});o.catch(function(e){t.oModel.reportError("Failed to create cache for binding "+t,c,e);});this.oCachePromise=o;this.oFetchCacheCallToken=b;};a.prototype.fetchQueryOptionsForOwnCache=function(C){var h,Q,t=this;if(this.oOperation){return S.resolve(undefined);}if(this.bRelative&&!C){return S.resolve(undefined);}Q=this.doFetchQueryOptions(C);if(this.oModel.bAutoExpandSelect&&this.aChildCanUseCachePromises){Q=S.all([Q,Promise.resolve().then(function(){return S.all(t.aChildCanUseCachePromises);})]).then(function(r){t.aChildCanUseCachePromises=[];t.updateAggregatedQueryOptions(r[0]);return t.mAggregatedQueryOptions;});}if(!this.bRelative||!C.fetchValue){return Q;}if(this.oModel.bAutoExpandSelect){h=t.mParameters&&Object.keys(t.mParameters).some(function(k){return k[0]!=="$"||k[1]==="$";});if(h){return Q;}return C.getBinding().fetchIfChildCanUseCache(C,t.sPath,Q).then(function(b){return b?undefined:Q;});}if(this.mParameters&&Object.keys(this.mParameters).length){return Q;}return Q.then(function(m){return Object.keys(m).length===0?undefined:m;});};a.prototype.getDependentBindings=function(){return this.oModel.getDependentBindings(this);};a.prototype.getGroupId=function(){return this.sGroupId||(this.bRelative&&this.oContext&&this.oContext.getGroupId&&this.oContext.getGroupId())||this.oModel.getGroupId();};a.prototype.getRelativePath=function(p){var P,r;if(p[0]==="/"){r=this.oModel.resolve(this.sPath,this.oContext);if(p.indexOf(r)===0){P=r;}else if(this.oReturnValueContext&&p.indexOf(this.oReturnValueContext.getPath())===0){P=this.oReturnValueContext.getPath();}else{return undefined;}p=p.slice(P.length);if(p[0]==="/"){p=p.slice(1);}}return p;};a.prototype.getRootBinding=function(){if(this.bRelative&&this.oContext&&this.oContext.getBinding){return this.oContext.getBinding().getRootBinding();}return this.bRelative&&!this.oContext?undefined:this;};a.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId||(this.bRelative&&this.oContext&&this.oContext.getUpdateGroupId&&this.oContext.getUpdateGroupId())||this.oModel.getUpdateGroupId();};a.prototype.hasPendingChanges=function(){return this.hasPendingChangesForPath("")||this.hasPendingChangesInDependents();};a.prototype.hasPendingChangesForPath=function(p){var t=this,P=this.withCache(function(C,s){return C.hasPendingChangesForPath(s);},p).catch(function(e){t.oModel.reportError("Error in hasPendingChangesForPath",c,e);return false;});return P.isFulfilled()?P.getResult():false;};a.prototype.hasPendingChangesInDependents=function(){return this.getDependentBindings().some(function(d){var C,h;if(d.oCachePromise.isFulfilled()){C=d.oCachePromise.getResult();if(C&&C.hasPendingChangesForPath("")){return true;}}if(d.mCacheByContext){h=Object.keys(d.mCacheByContext).some(function(p){return d.mCacheByContext[p].hasPendingChangesForPath("");});if(h){return true;}}return d.hasPendingChangesInDependents();});};a.prototype.isInitial=function(){throw new Error("Unsupported operation: isInitial");};a.prototype.isRefreshable=function(){return(!this.bRelative||this.oContext&&!this.oContext.getBinding)&&!this.isSuspended();};a.prototype.lockGroup=function(g,l){return this.oModel.lockGroup(g,l,this);};a.prototype.refresh=function(g){if(!this.isRefreshable()){throw new Error("Refresh on this binding is not supported");}if(this.hasPendingChanges()){throw new Error("Cannot refresh due to pending changes");}this.oModel.checkGroupId(g);this.refreshInternal(g,true);};a.prototype.removeCachesAndMessages=function(){var m=this.oModel,r=m.resolve(this.sPath,this.oContext);if(r){m.reportBoundMessages(r.slice(1),{});}if(this.mCacheByContext){Object.keys(this.mCacheByContext).forEach(function(p){m.reportBoundMessages(p.slice(1),{});});this.mCacheByContext=undefined;}};a.prototype.resetChanges=function(){this.checkSuspended();this.resetChangesForPath("");this.resetChangesInDependents();this.resetInvalidDataState();};a.prototype.resetChangesForPath=function(p){var P=this.withCache(function(C,s){C.resetChangesForPath(s);},p),t=this;P.catch(function(e){t.oModel.reportError("Error in resetChangesForPath",c,e);});if(P.isRejected()){throw P.getResult();}};a.prototype.resetChangesInDependents=function(){this.getDependentBindings().forEach(function(d){var C;if(d.oCachePromise.isFulfilled()){C=d.oCachePromise.getResult();if(C){C.resetChangesForPath("");}d.resetInvalidDataState();}if(d.mCacheByContext){Object.keys(d.mCacheByContext).forEach(function(p){d.mCacheByContext[p].resetChangesForPath("");});}d.resetChangesInDependents();});};a.prototype.resetInvalidDataState=function(){};a.prototype.toString=function(){return this.getMetadata().getName()+": "+(this.bRelative?this.oContext+"|":"")+this.sPath;};a.prototype.withCache=function(p,P){var r,t=this;P=P||"";return this.oCachePromise.then(function(C){if(C){r=t.getRelativePath(P);if(r!==undefined){return p(C,r,t);}}else if(t.oOperation){return undefined;}if(t.oContext&&t.oContext.withCache){return t.oContext.withCache(p,P[0]==="/"?P:_.buildPath(t.sPath,P));}return undefined;});};return function(p){if(p){q.extend(p,a.prototype);return;}this.mCacheByContext=undefined;};},false);
