/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Context","./ODataParentBinding","./lib/_Cache","./lib/_GroupLock","./lib/_Helper","sap/ui/base/SyncPromise","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/ContextBinding","sap/ui/thirdparty/jquery"],function(C,a,_,b,c,S,B,d,e,q){"use strict";var s="sap.ui.model.odata.v4.ODataContextBinding",m={AggregatedDataStateChange:true,change:true,dataReceived:true,dataRequested:true,DataStateChange:true,patchCompleted:true,patchSent:true};var O=e.extend("sap.ui.model.odata.v4.ODataContextBinding",{constructor:function(M,p,o,P){var i=p.indexOf("(...)");e.call(this,M,p);a.call(this);if(p.slice(-1)==="/"){throw new Error("Invalid path: "+p);}this.mAggregatedQueryOptions={};this.bAggregatedQueryOptionsInitial=true;this.oCachePromise=S.resolve();this.sGroupId=undefined;this.bInheritExpandSelect=false;this.oOperation=undefined;this.aChildCanUseCachePromises=[];this.oReadGroupLock=undefined;this.oReturnValueContext=null;this.sUpdateGroupId=undefined;if(i>=0){this.oOperation={bAction:undefined,mParameters:{},sResourcePath:undefined};if(i!==this.sPath.length-5){throw new Error("The path must not continue after a deferred operation: "+this.sPath);}}this.applyParameters(q.extend(true,{},P));this.oElementContext=this.bRelative?null:C.create(this.oModel,this,p);if(!this.oOperation&&(!this.bRelative||o&&!o.fetchValue)){this.createReadGroupLock(this.getGroupId(),true);}this.setContext(o);M.bindingCreated(this);},metadata:{publicMethods:[]}});a(O.prototype);O.prototype._delete=function(g,E){var t=this;if(this.sPath===""&&this.oContext.delete){return this.oContext._delete(g);}if(this.hasPendingChanges()){throw new Error("Cannot delete due to pending changes");}return this.deleteFromCache(g,E,"",function(){t.oElementContext.destroy();t.oElementContext=null;if(t.oReturnValueContext){t.oReturnValueContext.destroy();t.oReturnValueContext=null;}t._fireChange({reason:d.Remove});});};O.prototype._execute=function(g){var M=this.oModel.getMetaModel(),o,p,r=this.getResolvedPath(),t=this;function f(){t._fireChange({reason:d.Change});t.getDependentBindings().forEach(function(D){D.refreshInternal(g.getGroupId(),true);});}g.setGroupId(this.getGroupId());p=M.fetchObject(M.getMetaPath(r)+"/@$ui5.overload").then(function(h){var G,i,P;if(!h){throw new Error("Unknown operation: "+r);}if(h.length!==1){throw new Error("Unsupported overloads for "+r);}if(t.bRelative&&t.oContext.getBinding){i=t.sPath.lastIndexOf("/");P=i>=0?t.sPath.slice(0,i):"";G=t.oContext.getValue.bind(t.oContext,P);}o=h[0];return t.createCacheAndRequest(g,r,o,G);}).then(function(R){var h,i;f();if(t.hasReturnValueContext(o)){h=c.getPrivateAnnotation(t.oContext.fetchValue().getResult(),"predicate");i=c.getPrivateAnnotation(R,"predicate");if(h===i){t.oContext.patch(R);}if(t.oReturnValueContext){t.oReturnValueContext.destroy();}t.oReturnValueContext=C.create(t.oModel,t,r.slice(0,r.indexOf("("))+i);return t.oReturnValueContext;}},function(E){var h;function i(j){if(j.target){var k=j.target.split("/");if(k.shift()===h){j.target=k.join("/");return;}}delete j.target;}if(o&&o.$IsBound){h=o.$Parameter[0].$Name;E.resourcePath=t.oContext.getPath().slice(1);i(E.error);if(E.error.details){E.error.details.forEach(i);}}f();throw E;}).catch(function(E){g.unlock(true);if(t.oReturnValueContext){t.oReturnValueContext.destroy();t.oReturnValueContext=null;}t.oModel.reportError("Failed to execute "+r,s,E);throw E;});return Promise.resolve(p);};O.prototype.applyParameters=function(p,f){this.checkBindingParameters(p,["$$groupId","$$inheritExpandSelect","$$ownRequest","$$patchWithoutSideEffects","$$updateGroupId"]);this.sGroupId=p.$$groupId;this.sUpdateGroupId=p.$$updateGroupId;this.bInheritExpandSelect=p.$$inheritExpandSelect;this.mQueryOptions=this.oModel.buildQueryOptions(p,true);this.mParameters=p;if(!this.oOperation){this.fetchCache(this.oContext);if(f){this.refreshInternal(undefined,true);}else{this.checkUpdate();}}else if(this.oOperation.bAction===false){this.execute();}};O.prototype.attachEvent=function(E){if(!(E in m)){throw new Error("Unsupported event '"+E+"': v4.ODataContextBinding#attachEvent");}return e.prototype.attachEvent.apply(this,arguments);};O.prototype.createCacheAndRequest=function(g,p,o,G){var A=o.$kind==="Action",f,E=G,h=this.hasReturnValueContext(o),M=this.oModel,i=M.getMetaModel().getMetaPath(p)+"/@$ui5.overload/0/$ReturnType",P=q.extend({},this.oOperation.mParameters),j,r=M.oRequestor,Q=q.extend({},M.mUriParameters,this.mQueryOptions);if(!A&&o.$kind!=="Function"){throw new Error("Not an operation: "+p);}if(this.bInheritExpandSelect){if(h){j=this.oContext.getBinding().mCacheQueryOptions;if("$select"in j){Q.$select=j.$select;}if("$expand"in j){Q.$expand=j.$expand;}}else{throw new Error("Must not set parameter $$inheritExpandSelect on binding which has "+"no return value context");}}this.oOperation.bAction=A;if(A&&G){E=G();}p=r.getPathAndAddQueryOptions(p,o,P,Q,E);this.mCacheQueryOptions=Q;f=_.createSingle(r,p,Q,M.bAutoExpandSelect,A,i,h);this.oCachePromise=S.resolve(f);return A?f.post(g,P,E):f.fetchValue(g);};O.prototype.destroy=function(){if(this.oElementContext){this.oElementContext.destroy();this.oElementContext=undefined;}if(this.oReturnValueContext){this.oReturnValueContext.destroy();this.oReturnValueContext=undefined;}this.oModel.bindingDestroyed(this);this.removeReadGroupLock();this.mCacheByContext=undefined;this.oCachePromise=S.resolve();this.mCacheQueryOptions=undefined;this.aChildCanUseCachePromises=S.resolve();this.oContext=undefined;this.oOperation=undefined;this.mParameters=undefined;this.mQueryOptions=undefined;e.prototype.destroy.apply(this);};O.prototype.doCreateCache=function(r,Q){return _.createSingle(this.oModel.oRequestor,r,Q,this.oModel.bAutoExpandSelect);};O.prototype.doFetchQueryOptions=function(){return S.resolve(this.mQueryOptions);};O.prototype.execute=function(g){var r=this.oModel.resolve(this.sPath,this.oContext);this.checkSuspended();this.oModel.checkGroupId(g);if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(this.bRelative){if(!r){throw new Error("Unresolved binding: "+this.sPath);}if(this.oContext.isTransient&&this.oContext.isTransient()){throw new Error("Execute for transient context not allowed: "+r);}if(this.oContext.getPath().indexOf("(...)")>=0){throw new Error("Nested deferred operation bindings not supported: "+r);}}return this._execute(this.lockGroup(g,true));};O.prototype.fetchValue=function(p,l,f){var E,g,r=this.getRootBinding(),t=this;if(r&&r.isSuspended()){E=new Error("Suspended binding provides no value");E.canceled="noDebugLog";throw E;}return this.oCachePromise.then(function(o){var D=false,R;if(o){R=t.getRelativePath(p);if(R!==undefined){if(f){g=b.$cached;}else{g=t.lockGroup(t.getGroupId(),t.oReadGroupLock);t.oReadGroupLock=undefined;}return o.fetchValue(g,R,function(){D=true;t.fireDataRequested();},l).then(function(v){if(D){t.fireDataReceived({data:{}});}return v;},function(E){g.unlock(true);if(D){t.oModel.reportError("Failed to read path "+t.sPath,s,E);t.fireDataReceived(E.canceled?{data:{}}:{error:E});}throw E;});}}if(!t.oOperation&&t.oContext&&t.oContext.fetchValue){return t.oContext.fetchValue(p,l,f);}});};O.prototype.getResolvedPath=function(){var p="",r=this.oModel.resolve(this.sPath,this.oContext),f,t=this;if(r&&r.includes("/-1")){f=r.slice(1).split("/");r="";f.forEach(function(g){var E,P;p+="/"+g;if(g==="-1"){E=t.oContext.fetchValue(p).getResult();P=c.getPrivateAnnotation(E,"predicate");if(!P){throw new Error("No key predicate known at "+p);}r+=P;}else{r+="/"+g;}});}return r;};O.prototype.hasReturnValueContext=function(M){var o=this.oModel.getMetaModel(),f;if(!(this.bRelative&&this.oContext&&this.oContext.getBinding)){return false;}f=o.getMetaPath(this.oModel.resolve(this.sPath,this.oContext)).split("/");return M.$IsBound&&M.$ReturnType&&!M.$ReturnType.$isCollection&&M.$EntitySetPath&&M.$EntitySetPath.indexOf("/")<0&&f.length===3&&o.getObject("/"+f[1]).$kind==="EntitySet";};O.prototype.refreshInternal=function(g,f){var t=this;if(this.oOperation&&this.oOperation.bAction!==false){return;}this.createReadGroupLock(g,this.isRefreshable());this.oCachePromise.then(function(o){if(!t.oElementContext){t.oElementContext=C.create(t.oModel,t,t.oModel.resolve(t.sPath,t.oContext));if(!o){t._fireChange({reason:d.Refresh});}}if(!t.oOperation){if(o){t.removeCachesAndMessages();t.fetchCache(t.oContext);}t.getDependentBindings().forEach(function(D){D.refreshInternal(g,f);});}else{t._execute(t.oReadGroupLock);t.oReadGroupLock=undefined;}});};O.prototype.resumeInternal=function(f){if(!this.oOperation){this.mAggregatedQueryOptions={};this.bAggregatedQueryOptionsInitial=true;this.removeCachesAndMessages();this.fetchCache(this.oContext);this.getDependentBindings().forEach(function(D){D.resumeInternal(f);});this._fireChange({reason:d.Change});}else if(this.oOperation.bAction===false){this.execute();}};O.prototype.setContext=function(o){if(this.oContext!==o){if(this.bRelative&&(this.oContext||o)){if(this.oElementContext){this.oElementContext.destroy();this.oElementContext=null;}if(this.oReturnValueContext){this.oReturnValueContext.destroy();this.oReturnValueContext=null;}this.fetchCache(o);if(o){this.oElementContext=C.create(this.oModel,this,this.oModel.resolve(this.sPath,o));}B.prototype.setContext.call(this,o);}else{this.oContext=o;}}};O.prototype.setParameter=function(p,v){if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(!p){throw new Error("Missing parameter name");}if(v===undefined){throw new Error("Missing value for parameter: "+p);}this.oOperation.mParameters[p]=v;this.oOperation.bAction=undefined;return this;};return O;});
