/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ValueListType","./lib/_Helper","sap/base/assert","sap/base/Log","sap/base/util/ObjectPath","sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding","sap/ui/model/Context","sap/ui/model/ContextBinding","sap/ui/model/MetaModel","sap/ui/model/PropertyBinding","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Int64","sap/ui/model/odata/type/Raw","sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI"],function(V,_,a,L,O,S,B,C,b,c,d,M,P,f,I,R,q,U){"use strict";var g,D=L.Level.DEBUG,r=/^-?\d+$/,h,j,s="sap.ui.model.odata.v4.ODataMetaModel",k,l=new R(),m={messageChange:true},u={"Edm.Boolean":{type:"sap.ui.model.odata.type.Boolean"},"Edm.Byte":{type:"sap.ui.model.odata.type.Byte"},"Edm.Date":{type:"sap.ui.model.odata.type.Date"},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.DateTimeOffset"},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum/$Decimal":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum/$Decimal":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive","$Precision":"precision","$Scale":"scale"},type:"sap.ui.model.odata.type.Decimal"},"Edm.Double":{type:"sap.ui.model.odata.type.Double"},"Edm.Guid":{type:"sap.ui.model.odata.type.Guid"},"Edm.Int16":{type:"sap.ui.model.odata.type.Int16"},"Edm.Int32":{type:"sap.ui.model.odata.type.Int32"},"Edm.Int64":{type:"sap.ui.model.odata.type.Int64"},"Edm.SByte":{type:"sap.ui.model.odata.type.SByte"},"Edm.Single":{type:"sap.ui.model.odata.type.Single"},"Edm.Stream":{type:"sap.ui.model.odata.type.Stream"},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},type:"sap.ui.model.odata.type.String"},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.TimeOfDay"}},p={},v="@com.sap.vocabularies.Common.v1.ValueList",t="@com.sap.vocabularies.Common.v1.ValueListMapping",w={},x="@com.sap.vocabularies.Common.v1.ValueListReferences",y="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",W=L.Level.WARNING;function z(o,e,i,n){var N,Q=o.mSchema2MetadataUrl[e];if(!Q){Q=o.mSchema2MetadataUrl[e]={};Q[i]=false;}else if(!(i in Q)){N=Object.keys(Q)[0];if(Q[N]){H(o,"A schema cannot span more than one document: "+e+" - expected reference URI "+N+" but instead saw "+i,n);}Q[i]=false;}}function A(o,e,i,n){var N,Q,T,X;function Y(Z){var $,a1;if(!(i in Z)){n(W,Q," does not contain ",i);return;}n(D,"Including ",i," from ",Q);for(a1 in Z){if(a1[0]!=="$"&&J(a1)===i){$=Z[a1];e[a1]=$;G($,e.$Annotations);}}}if(i in e){return e[i];}X=o.mSchema2MetadataUrl[i];if(X){T=Object.keys(X);if(T.length>1){H(o,"A schema cannot span more than one document: "+"schema is referenced by following URLs: "+T.join(", "),i);}Q=T[0];X[Q]=true;n(D,"Namespace ",i," found in $Include of ",Q);N=o.mMetadataUrl2Promise[Q];if(!N){n(D,"Reading ",Q);N=o.mMetadataUrl2Promise[Q]=S.resolve(o.oRequestor.read(Q)).then(o.validate.bind(o,Q));}N=N.then(Y);if(i in e){return e[i];}e[i]=N;return N;}}function E(T,e){if(T===e){return"";}if(T.indexOf(e)===0&&T[e.length]==="#"&&T.indexOf("@",e.length)<0){return T.slice(e.length+1);}}function F(T){var Q=E(T,t);return Q!==undefined?Q:E(T,v);}function G(o,e,i){var T;function n(N,Q){var X;for(X in Q){if(i||!(X in N)){N[X]=Q[X];}}}for(T in o.$Annotations){if(!(T in e)){e[T]={};}n(e[T],o.$Annotations[T]);}delete o.$Annotations;}function H(o,e,i){var n=new Error(i+": "+e);o.oModel.reportError(e,s,n);throw n;}function J(Q){return Q.slice(0,Q.lastIndexOf(".")+1);}h=d.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(o,e,i){a(!i||i.getModel()===o,"oContext must belong to this model");d.call(this,o,e,i);},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange();}},setContext:function(o){a(!o||o.getModel()===this.oModel,"oContext must belong to this model");if(o!==this.oContext){this.oContext=o;if(!this.bInitial){this.initialize();}}}});j=b.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{constructor:function(){b.apply(this,arguments);},_fireFilter:function(){},_fireSort:function(){},checkUpdate:function(e){var i=this.oList.length;this.update();if(e||this.oList.length!==i){this._fireChange({reason:C.Change});}},fetchContexts:function(){var i,e=this.oModel.resolve(this.sPath,this.oContext),n=this;if(!e){return S.resolve([]);}i=e.slice(-1)==="@";if(!i&&!e.endsWith("/")){e+="/";}return this.oModel.fetchObject(e).then(function(o){if(!o){return[];}if(i){e=e.slice(0,-1);}return Object.keys(o).filter(function(N){return N[0]!=="$"&&i!==(N[0]!=="@");}).map(function(N){return new c(n.oModel,e+N);});});},getContexts:function(i,e){this.iCurrentStart=i||0;this.iCurrentLength=Math.min(e||Infinity,this.iLength,this.oModel.iSizeLimit);return this.getCurrentContexts();},getCurrentContexts:function(){var e=[],i,n=this.iCurrentStart+this.iCurrentLength;for(i=this.iCurrentStart;i<n;i++){e.push(this.oList[this.aIndices[i]]);}if(this.oList.dataRequested){e.dataRequested=true;}return e;},setContexts:function(e){this.oList=e;this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();},update:function(){var e=[],o=this.fetchContexts(),i=this;if(o.isFulfilled()){e=o.getResult();}else{o.then(function(e){i.setContexts(e);i._fireChange({reason:C.Change});});e.dataRequested=true;}this.setContexts(e);}});k=P.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){P.apply(this,arguments);this.vValue=undefined;},checkUpdate:function(e,i){var o,n=this;function N(Q){if(e||Q!==n.vValue){n.vValue=Q;n._fireChange({reason:i||C.Change});}return Q;}o=this.oModel.fetchObject(this.sPath,this.oContext,this.mParameters).then(N);if(this.mParameters&&this.mParameters.$$valueAsPromise&&o.isPending()){N(o.unwrap());}},getValue:function(){return this.vValue;},setContext:function(o){if(this.oContext!=o){this.oContext=o;if(this.bRelative){this.checkUpdate(false,C.Context);}}},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var K=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(o,e,i,n,N){M.call(this);this.aAnnotationUris=i&&!Array.isArray(i)?[i]:i;this.sDefaultBindingMode=B.OneTime;this.mETags={};this.dLastModified=new Date(0);this.oMetadataPromise=null;this.oModel=n;this.mMetadataUrl2Promise={};this.oRequestor=o;this.mSchema2MetadataUrl={};this.mSupportedBindingModes={"OneTime":true,"OneWay":true};this.bSupportReferences=N!==false;this.sUrl=e;}});K.prototype.$$valueAsPromise=true;K.prototype._mergeAnnotations=function(e,n){var o=this;this.validate(this.sUrl,e);e.$Annotations={};Object.keys(e).forEach(function(i){if(e[i].$kind==="Schema"){z(o,i,o.sUrl);G(e[i],e.$Annotations);}});n.forEach(function(N,i){var Q,T;o.validate(o.aAnnotationUris[i],N);for(T in N){if(T[0]!=="$"){if(T in e){H(o,"A schema cannot span more than one document: "+T,o.aAnnotationUris[i]);}Q=N[T];e[T]=Q;if(Q.$kind==="Schema"){z(o,T,o.aAnnotationUris[i]);G(Q,e.$Annotations,true);}}}});};K.prototype.attachEvent=function(e){if(!(e in m)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};K.prototype.bindContext=function(e,o){return new h(this,e,o);};K.prototype.bindList=function(e,o,i,n){return new j(this,e,o,i,n);};K.prototype.bindProperty=function(e,o,i){return new k(this,e,o,i);};K.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};K.prototype.fetchCanonicalPath=function(o){return this.fetchUpdateData("",o).then(function(e){if(e.propertyPath){throw new Error("Context "+o.getPath()+" does not point to an entity. It should be "+e.entityPath);}return"/"+e.editUrl;});};K.prototype.fetchData=function(){return this.fetchEntityContainer().then(function(e){return JSON.parse(JSON.stringify(e));});};K.prototype.fetchEntityContainer=function(e){var i,n=this;if(!this.oMetadataPromise){i=[S.resolve(this.oRequestor.read(this.sUrl,false,e))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(o){i.push(S.resolve(n.oRequestor.read(o,true,e)));});}if(!e){this.oMetadataPromise=S.all(i).then(function(o){var N=o[0];n._mergeAnnotations(N,o.slice(1));return N;});}}return this.oMetadataPromise;};K.prototype.fetchModule=function(e){var i;e=e.replace(/\./g,"/");i=sap.ui.require(e);if(i){return S.resolve(i);}return S.resolve(new Promise(function(n,o){sap.ui.require([e],n);}));};K.prototype.fetchObject=function(n,N,Q){var T=this.resolve(n,N),X=this;if(!T){L.error("Invalid relative path w/o context",n,s);return S.resolve(null);}return this.fetchEntityContainer().then(function(Y){var Z,$,a1,b1=true,c1,d1,e1,f1=Y;function g1(i,n){var o,n1=i.indexOf("@",2);if(n1>-1){return j1(W,"Unsupported path after ",i.slice(0,n1));}i=i.slice(2);o=i[0]==="."?O.get(i.slice(1),Q.scope):Q&&O.get(i,Q.scope)||O.get(i);if(typeof o!=="function"){return j1(W,i," is not a function but: "+o);}try{f1=o(f1,{$$valueAsPromise:Q&&Q.$$valueAsPromise,context:new c(X,n),schemaChildName:d1});}catch(e){j1(W,"Error calling ",i,": ",e);}return true;}function h1(o){return o.$kind!=="Action"||(!o.$IsBound&&Z===p||o.$IsBound&&Z===o.$Parameter[0].$Type);}function i1(o){return o&&typeof o.then==="function";}function j1(i){var e;if(L.isLoggable(i,s)){e=Array.isArray($)?$.join("/"):$;L[i===D?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(e?" at /"+e:""),T,s);}if(i===W){f1=undefined;}return false;}function k1(e,i){var o;function n1(){$=$||e1&&i&&e1+"/"+i;return j1.apply(this,arguments);}Z=f1&&f1.$Type;if(X.bSupportReferences&&!(e in Y)){o=J(e);f1=A(X,Y,o,n1);}if(e in Y){e1=a1=d1=e;f1=c1=Y[d1];if(!i1(f1)){return true;}}if(i1(f1)&&f1.isPending()){return n1(D,"Waiting for ",o);}return n1(W,"Unknown qualified name ",e);}function l1(e,i,o){var n1,o1;if(e==="$Annotations"){return j1(W,"Invalid segment: $Annotations");}if(f1!==Y&&typeof f1==="object"&&e in f1){if(e[0]==="$"||r.test(e)){b1=false;}}else{n1=e.indexOf("@@");if(n1<0){if(e.length>11&&e.slice(-11)==="@sapui.name"){n1=e.length-11;}else{n1=e.indexOf("@");}}if(n1>0){if(!l1(e.slice(0,n1),i,o)){return false;}e=e.slice(n1);o1=true;}if(typeof f1==="string"&&!(o1&&(e==="@sapui.name"||e[1]==="@"))&&!m1(f1,o.slice(0,i))){return false;}if(b1){if(e[0]==="$"||r.test(e)){b1=false;}else if(!o1){if(e[0]!=="@"&&e.indexOf(".")>0){return k1(e);}else if(f1&&"$Type"in f1){if(!k1(f1.$Type,"$Type")){return false;}}else if(f1&&"$Action"in f1){if(!k1(f1.$Action,"$Action")){return false;}Z=p;}else if(f1&&"$Function"in f1){if(!k1(f1.$Function,"$Function")){return false;}}else if(i===0){e1=a1=d1=d1||Y.$EntityContainer;f1=c1=c1||Y[d1];if(e&&e[0]!=="@"&&!(e in c1)){return j1(W,"Unknown child ",e," of ",d1);}}if(Array.isArray(f1)){f1=f1.filter(h1);if(e==="@$ui5.overload"){return true;}if(f1.length!==1){return j1(W,"Unsupported overloads");}f1=f1[0].$ReturnType;e1=e1+"/0/$ReturnType";if(f1){if(e==="value"&&!(Y[f1.$Type]&&Y[f1.$Type].value)){a1=undefined;return true;}if(!k1(f1.$Type,"$Type")){return false;}}}}}if(!e){return i+1>=o.length||j1(W,"Invalid empty segment");}if(e[0]==="@"){if(e==="@sapui.name"){f1=a1;if(f1===undefined){j1(W,"Unsupported path before @sapui.name");}else if(i+1<o.length){j1(W,"Unsupported path after @sapui.name");}return false;}if(e[1]==="@"){if(i+1<o.length){return j1(W,"Unsupported path after ",e);}return g1(e,[""].concat(o.slice(0,i),o[i].slice(0,n1)).join("/"));}}if(!f1||typeof f1!=="object"){f1=undefined;return j1(D,"Invalid segment: ",e);}if(b1&&e[0]==="@"){f1=(Y.$Annotations||{})[e1]||{};b1=false;}}if(e!=="@"){a1=b1||e[0]==="@"?e:undefined;e1=b1?e1+"/"+e:undefined;f1=f1[e];}return true;}function m1(e,i){var o;if($){return j1(W,"Invalid recursion");}$=i;b1=true;f1=Y;o=e.split("/").every(l1);$=undefined;return o;}if(!m1(T.slice(1))&&i1(f1)){f1=f1.then(function(){return X.fetchObject(n,N,Q);});}return f1;});};K.prototype.fetchUI5Type=function(e){var o=this.getMetaContext(e),i=this;if(e.endsWith("/$count")){g=g||new I();return S.resolve(g);}return this.fetchObject(undefined,o).catch(function(){}).then(function(n){var N,Q,T,X,Y=l.getName();function Z($,a1){if(a1!==undefined){N=N||{};N[$]=a1;}}if(!n){L.warning("No metadata for path '"+e+"', using "+Y,undefined,s);return l;}T=n["$ui5.type"];if(T){return T;}if(n.$isCollection){L.warning("Unsupported collection type, using "+Y,e,s);}else{X=u[n.$Type];if(X){Y=X.type;for(Q in X.constraints){Z(X.constraints[Q],Q[0]==="@"?i.getObject(Q,o):n[Q]);}if(n.$Nullable===false){Z("nullable",false);}}else{L.warning("Unsupported type '"+n.$Type+"', using "+Y,e,s);}}if(Y===l.getName()){n["$ui5.type"]=l;}else{n["$ui5.type"]=i.fetchModule(Y).then(function($){T=new $(undefined,N);n["$ui5.type"]=T;return T;});}return n["$ui5.type"];});};K.prototype.fetchUpdateData=function(e,o){var n=o.getModel(),N=n.resolve(e,o),Q=this;function T(i){var X=new Error(N+": "+i);n.reportError(i,s,X);throw X;}return this.fetchObject(this.getMetaPath(N)).then(function(){return Q.fetchEntityContainer();}).then(function(X){var Y,Z=X[X.$EntityContainer],$,a1,b1,c1,d1,e1,f1=false,g1;function h1(k1){var i=k1.indexOf("(");return i>=0?k1.slice(i):"";}function i1(){Y.push({path:c1,prefix:Y.pop(),type:g1});}function j1(k1){var i=k1.indexOf("(");return i>=0?k1.slice(0,i):k1;}e1=N.slice(1).split("/");Y=[e1.shift()];c1="/"+Y[0];$=c1;b1=decodeURIComponent(j1(Y[0]));a1=Z[b1];if(!a1){T("Not an entity set: "+b1);}g1=X[a1.$Type];e="";d1="";e1.forEach(function(i){var k1,l1;c1+="/"+i;if(r.test(i)){i1();$+="/"+i;}else{l1=decodeURIComponent(j1(i));d1=_.buildPath(d1,l1);k1=g1[l1];if(!k1){T("Not a (navigation) property: "+l1);}g1=X[k1.$Type];if(k1.$kind==="NavigationProperty"){if(a1.$NavigationPropertyBinding&&d1 in a1.$NavigationPropertyBinding){b1=a1.$NavigationPropertyBinding[d1];a1=Z[b1];d1="";Y=[encodeURIComponent(b1)+h1(i)];if(!k1.$isCollection){i1();}}else{Y.push(i);}$=c1;e="";}else{e=_.buildPath(e,i);}}});return S.all(Y.map(function(i){if(typeof i==="string"){return i;}return o.fetchValue(i.path).then(function(k1){var l1;if(!k1){T("No instance to calculate key predicate at "+i.path);}if(_.hasPrivateAnnotation(k1,"transient")){f1=true;return undefined;}l1=_.getPrivateAnnotation(k1,"predicate");if(!l1){T("No key predicate known at "+i.path);}return i.prefix+l1;},function(k1){T(k1.message+" at "+i.path);});})).then(function(i){return{editUrl:f1?undefined:i.join("/"),entityPath:$,propertyPath:e};});});};K.prototype.fetchValueListMappings=function(o,n,e){var i=this,N=o.getMetaModel();return N.fetchEntityContainer().then(function(Q){var T,X=Q.$Annotations,Y={},Z=i===N,$;$=Object.keys(X).filter(function(a1){if(_.namespace(a1)===n){if(i.getObject("/"+a1)===e){return true;}if(!Z){throw new Error("Unexpected annotation target '"+a1+"' with namespace of data service in "+o.sServiceUrl);}}return false;});if(!$.length){throw new Error("No annotation '"+v.slice(1)+"' in "+o.sServiceUrl);}T=X[$[0]];Object.keys(T).forEach(function(a1){var b1=F(a1);if(b1!==undefined){Y[b1]=T[a1];["CollectionRoot","SearchSupported"].forEach(function(c1){if(c1 in T[a1]){throw new Error("Property '"+c1+"' is not allowed in annotation '"+a1.slice(1)+"' for target '"+$[0]+"' in "+o.sServiceUrl);}});}else if(!Z){throw new Error("Unexpected annotation '"+a1.slice(1)+"' for target '"+$[0]+"' with namespace of data service in "+o.sServiceUrl);}});return Y;});};K.prototype.fetchValueListType=function(e){var o=this.getMetaContext(e),i=this;return this.fetchObject(undefined,o).then(function(n){var N,T;if(!n){throw new Error("No metadata for "+e);}N=i.getObject("@",o);if(N[y]){return V.Fixed;}for(T in N){if(E(T,x)!==undefined||E(T,t)!==undefined){return V.Standard;}if(E(T,v)!==undefined){return N[T].SearchSupported===false?V.Fixed:V.Standard;}}return V.None;});};K.prototype.getAdapterFactoryModulePath=function(){return"sap/ui/mdc/experimental/adapter/odata/v4/ODataAdapterFactory";};K.prototype.getData=_.createGetMethod("fetchData");K.prototype.getETags=function(){return this.mETags;};K.prototype.getLastModified=function(){return this.dLastModified;};K.prototype.getMetaContext=function(e){return new c(this,this.getMetaPath(e));};K.prototype.getMetaPath=function(e){return _.getMetaPath(e);};K.prototype.getObject=_.createGetMethod("fetchObject");K.prototype.getOrCreateValueListModel=function(e){var i=new U(this.sUrl).absoluteTo(document.baseURI).pathname().toString(),o,n;n=new U(e).absoluteTo(i).filename("").toString();o=w[n];if(!o){o=new this.oModel.constructor({operationMode:f.Server,serviceUrl:n,synchronizationMode:"None"});o.setDefaultBindingMode(B.OneWay);w[n]=o;o.oRequestor.mHeaders["X-CSRF-Token"]=this.oModel.oRequestor.mHeaders["X-CSRF-Token"];}return o;};K.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};K.prototype.getProperty=K.prototype.getObject;K.prototype.getUI5Type=_.createGetMethod("fetchUI5Type",true);K.prototype.getValueListType=_.createGetMethod("fetchValueListType",true);K.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};K.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};K.prototype.requestData=_.createRequestMethod("fetchData");K.prototype.requestObject=_.createRequestMethod("fetchObject");K.prototype.requestUI5Type=_.createRequestMethod("fetchUI5Type");K.prototype.requestValueListInfo=function(e){var i=this.getMetaPath(e),T=i.slice(0,i.lastIndexOf("/")+1),n=this;return Promise.all([this.requestObject(T+"@sapui.name"),this.requestObject(i),this.requestObject(i+"@"),this.requestObject(i+y)]).then(function(o){var N=o[2],Q=o[3],X={},Y=_.namespace(o[0]),Z=o[1],$={};function a1(b1,c1,d1,e1){if(Q!==undefined&&"SearchSupported"in b1){throw new Error("Must not set 'SearchSupported' in annotation "+"'com.sap.vocabularies.Common.v1.ValueList' and annotation "+"'com.sap.vocabularies.Common.v1.ValueListWithFixedValues'");}if("CollectionRoot"in b1){e1=n.getOrCreateValueListModel(b1.CollectionRoot);if($[c1]&&$[c1].$model===e1){X[c1]=undefined;}}if(X[c1]){throw new Error("Annotations '"+v.slice(1)+"' with identical qualifier '"+c1+"' for property "+e+" in "+X[c1]+" and "+d1);}X[c1]=d1;b1=q.extend(true,{$model:e1},b1);delete b1.CollectionRoot;delete b1.SearchSupported;$[c1]=b1;}if(!Z){throw new Error("No metadata for "+e);}return Promise.all(Object.keys(N).filter(function(b1){return E(b1,x)!==undefined;}).map(function(b1){var c1=N[b1];return Promise.all(c1.map(function(d1){var e1=n.getOrCreateValueListModel(d1);return n.fetchValueListMappings(e1,Y,Z).then(function(f1){Object.keys(f1).forEach(function(g1){a1(f1[g1],g1,d1,e1);});});}));})).then(function(){var b1;Object.keys(N).filter(function(c1){return F(c1)!==undefined;}).forEach(function(c1){a1(N[c1],F(c1),n.sUrl,n.oModel);});b1=Object.keys($);if(!b1.length){throw new Error("No annotation '"+x.slice(1)+"' for "+e);}if(Q){if(b1.length>1){throw new Error("Annotation '"+y.slice(1)+"' but multiple '"+v.slice(1)+"' for property "+e);}return{"":$[b1[0]]};}return $;});});};K.prototype.requestValueListType=_.createRequestMethod("fetchValueListType");K.prototype.resolve=function(e,o){var i,n;if(!e){return o?o.getPath():undefined;}n=e[0];if(n==="/"){return e;}if(!o){return undefined;}if(n==="."){if(e[1]!=="/"){throw new Error("Unsupported relative path: "+e);}e=e.slice(2);}i=o.getPath();return n==="@"||i.slice(-1)==="/"?i+e:i+"/"+e;};K.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};K.prototype.toString=function(){return s+": "+this.sUrl;};K.prototype.validate=function(e,n){var i,o,N,Q,T,X;if(!this.bSupportReferences){return n;}for(X in n.$Reference){T=n.$Reference[X];X=new U(X).absoluteTo(this.sUrl).toString();if("$IncludeAnnotations"in T){H(this,"Unsupported IncludeAnnotations",e);}for(i in T.$Include){Q=T.$Include[i];if(Q in n){H(this,"A schema cannot span more than one document: "+Q+" - is both included and defined",e);}z(this,Q,X,e);}}N=n.$LastModified?new Date(n.$LastModified):null;this.mETags[e]=n.$ETag?n.$ETag:N;o=n.$Date?new Date(n.$Date):new Date();N=N||o;if(this.dLastModified<N){this.dLastModified=N;}delete n.$Date;delete n.$ETag;delete n.$LastModified;return n;};return K;});
