/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_GroupLock","./_Helper","./_Requestor","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/thirdparty/jquery"],function(_,a,b,L,S,q){"use strict";var m="@com.sap.vocabularies.Common.v1.Messages",r=/^([^(]*)(\(.*\))$/;function c(h,p,i,D){if(i.$count!==undefined){s(h,p,i,i.$count+D);}}function g(h){return h.$count!==undefined?h.$count:Infinity;}function d(R,p){return p===""||R===p||R.indexOf(p+"/")===0;}function s(h,p,i,v){if(typeof v==="string"){v=parseInt(v,10);}a.updateExisting(h,p,i,{$count:v});}function C(R,h,Q,i){this.bActive=true;this.mChangeListeners={};this.sMetaPath=a.getMetaPath("/"+h);this.mPatchRequests={};this.mPostRequests={};this.oRequestor=R;this.bSortExpandSelect=i;this.sResourcePath=h;this.bSentReadRequest=false;this.oTypePromise=undefined;this.setQueryOptions(Q);}C.prototype._delete=function(G,E,p,h){var i=p.split("/"),D=i.pop(),j=i.join("/"),t=this;return this.fetchValue(_.$cached,j).then(function(v){var o=D?v[D]:v,H,k=a.getPrivateAnnotation(o,"predicate"),l=a.buildPath(j,Array.isArray(v)?k:D),T=a.getPrivateAnnotation(o,"transient");if(T===true){throw new Error("No 'delete' allowed while waiting for server response");}if(T){G.unlock();t.oRequestor.removePost(T,o);return Promise.resolve();}if(o["$ui5.deleting"]){throw new Error("Must not delete twice: "+E);}o["$ui5.deleting"]=true;H={"If-Match":o};E+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return t.oRequestor.request("DELETE",E,G,H,undefined,undefined,undefined,undefined,a.buildPath(t.sResourcePath,l)).catch(function(n){if(n.status!==404){delete o["$ui5.deleting"];throw n;}}).then(function(){var n;if(Array.isArray(v)){if(v[D]!==o){D=v.indexOf(o);}if(D==="-1"){delete v[-1];}else{n=a.getPrivateAnnotation(o,"predicate");if(n){delete v.$byPredicate[n];}v.splice(D,1);}c(t.mChangeListeners,j,v,-1);t.iLimit-=1;h(Number(D),v);}else{if(D){a.updateExisting(t.mChangeListeners,j,v,C.makeUpdateData([D],null));}else{o["$ui5.deleted"]=true;}h();}t.oRequestor.reportBoundMessages(t.sResourcePath,[],[l]);});});};C.prototype.addByPath=function(M,p,i){if(i){if(!M[p]){M[p]=[i];}else if(M[p].indexOf(i)<0){M[p].push(i);}}};C.prototype.calculateKeyPredicate=function(i,t,M){var p,T=t[M];if(T&&T.$Key){p=a.getKeyPredicate(i,M,t);if(p){a.setPrivateAnnotation(i,"predicate",p);}}return p;};C.prototype.checkActive=function(){var E;if(!this.bActive){E=new Error("Response discarded: cache is inactive");E.canceled=true;throw E;}};C.prototype.create=function(G,p,h,E,i,j){var k,K=E&&E["@$ui5.keepTransientPath"],t=this;function l(){t.removeByPath(t.mPostRequests,h,E);delete k[-1];i();}function n(){a.setPrivateAnnotation(E,"transient",true);}function o(u,v){var w=v.getGroupId();a.setPrivateAnnotation(E,"transient",w);t.addByPath(t.mPostRequests,h,E);return S.all([t.oRequestor.request("POST",u,v,null,E,n,l,undefined,a.buildPath(t.sResourcePath,h,"-1")),t.fetchTypes()]).then(function(R){var x=R[0],y;a.deletePrivateAnnotation(E,"transient");c(t.mChangeListeners,h,k,1);t.removeByPath(t.mPostRequests,h,E);t.visitResponse(x,R[1],false,a.getMetaPath(a.buildPath(t.sMetaPath,h)),h+"/-1",K);if(!K){y=a.getPrivateAnnotation(x,"predicate");if(y){k.$byPredicate[y]=E;a.updateTransientPaths(t.mChangeListeners,h,y);}}a.updateSelected(t.mChangeListeners,a.buildPath(h,y||"-1"),E,x,a.getSelectForPath(t.mQueryOptions,h));return E;},function(x){if(x.canceled){throw x;}j(x);return o(u,new _(t.oRequestor.getGroupSubmitMode(w)==="API"?w:"$parked."+w));});}E=q.extend(true,{},E);E=b.cleanPayload(E);k=this.fetchValue(_.$cached,h).getResult();if(!Array.isArray(k)){throw new Error("Create is only supported for collections; '"+h+"' does not reference a collection");}k[-1]=E;return S.resolve(p).then(function(u){u+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return o(u,G);});};C.prototype.deregisterChange=function(p,l){this.removeByPath(this.mChangeListeners,p,l);};C.prototype.drillDown=function(D,p){var o=S.resolve(D),t=false,h=this;function j(i){L.error("Failed to drill-down into "+p+", invalid segment: "+i,h.toString(),"sap.ui.model.odata.v4.lib._Cache");return undefined;}function k(v,i,l){var n="",R,u;if(p[0]!=='('){n+="/";}n+=p.split("/").slice(0,l).join("/");return h.oRequestor.fetchMetadata(h.sMetaPath+a.getMetaPath(n)).then(function(w){if(!w){return j(i);}if(w.$Type==="Edm.Stream"){R=v[i+"@odata.mediaReadLink"];u=h.oRequestor.getServiceUrl();return R||u+h.sResourcePath+n;}if(!t){return j(i);}if(w.$kind==="NavigationProperty"){return null;}if(!w.$Type.startsWith("Edm.")){return{};}if("$DefaultValue"in w){return w.$Type==="Edm.String"?w.$DefaultValue:a.parseLiteral(w.$DefaultValue,w.$Type,n);}return null;});}if(!p){return o;}return p.split("/").reduce(function(l,n,i){return l.then(function(v){var M,u;if(n==="$count"){return Array.isArray(v)?v.$count:j(n);}if(v===undefined||v===null){return undefined;}if(typeof v!=="object"||n==="@$ui5._"){return j(n);}u=v;t=t||a.getPrivateAnnotation(v,"transient");M=r.exec(n);if(M){if(M[1]){v=v[M[1]];}if(v){v=v.$byPredicate[M[2]];}}else{v=v[n];}return v===undefined&&n[0]!=="#"?k(u,n,i+1):v;});},o);};C.prototype.fetchTypes=function(){var p,t,h=this;function i(B,Q){if(Q&&Q.$expand){Object.keys(Q.$expand).forEach(function(n){var M=B;n.split("/").forEach(function(k){M+="/"+k;j(M);});i(M,Q.$expand[n]);});}}function j(M){p.push(h.oRequestor.fetchTypeForPath(M).then(function(T){var o=h.oRequestor.fetchMetadata(M+"/"+m).getResult();if(o){T=Object.create(T);T[m]=o;}t[M]=T;if(T&&T.$Key){T.$Key.forEach(function(k){var I,K;if(typeof k!=="string"){K=k[Object.keys(k)[0]];I=K.lastIndexOf("/");if(I>=0){j(M+"/"+K.slice(0,I));}}});}}));}if(!this.oTypePromise){p=[];t={};j(this.sMetaPath);if(this.bFetchOperationReturnType){j(this.sMetaPath+"/$Type");}i(this.sMetaPath,this.mQueryOptions);this.oTypePromise=S.all(p).then(function(){return t;});}return this.oTypePromise;};C.prototype.hasPendingChangesForPath=function(p){return Object.keys(this.mPatchRequests).some(function(R){return d(R,p);})||Object.keys(this.mPostRequests).some(function(R){return d(R,p);});};C.prototype.patch=function(p,D){var t=this;this.fetchValue(_.$cached,p).then(function(o){a.updateExisting(t.mChangeListeners,p,o,D);});};C.prototype.registerChange=function(p,l){this.addByPath(this.mChangeListeners,p,l);};C.prototype.removeByPath=function(M,p,i){var I=M[p],h;if(I){h=I.indexOf(i);if(h>=0){if(I.length===1){delete M[p];}else{I.splice(h,1);}}}};C.prototype.resetChangesForPath=function(p){var t=this;Object.keys(this.mPatchRequests).forEach(function(R){var i,h;if(d(R,p)){h=t.mPatchRequests[R];for(i=h.length-1;i>=0;i--){t.oRequestor.removePatch(h[i]);}delete t.mPatchRequests[R];}});Object.keys(this.mPostRequests).forEach(function(R){var E,i,T;if(d(R,p)){E=t.mPostRequests[R];for(i=E.length-1;i>=0;i--){T=a.getPrivateAnnotation(E[i],"transient");t.oRequestor.removePost(T,E[i]);}delete t.mPostRequests[R];}});};C.prototype.setActive=function(A){this.bActive=A;if(!A){this.mChangeListeners={};}};C.prototype.setQueryOptions=function(Q){if(this.bSentReadRequest){throw new Error("Cannot set query options: Cache has already sent a read request");}this.mQueryOptions=Q;this.sQueryString=this.oRequestor.buildQueryString(this.sMetaPath,Q,false,this.bSortExpandSelect);};C.prototype.toString=function(){return this.oRequestor.getServiceUrl()+this.sResourcePath+this.sQueryString;};C.prototype.update=function(G,p,v,E,h,i,u,j,k){var l=p.split("/"),U,t=this;return this.fetchValue(G.getUnlockedCopy(),i).then(function(o){var F=a.buildPath(i,p),n=G.getGroupId(),O,w,x,T,y,z=C.makeUpdateData(l,v);function A(){t.removeByPath(t.mPatchRequests,F,w);a.updateExisting(t.mChangeListeners,i,o,C.makeUpdateData(l,O));}function B(D,H){var R;function I(){R=t.oRequestor.getModelInterface().lockGroup(n,true,t);if(k){k();}}w=t.oRequestor.request("PATCH",h,D,{"If-Match":o},z,I,A,undefined,a.buildPath(t.sResourcePath,i),H);t.addByPath(t.mPatchRequests,F,w);return S.all([w,t.fetchTypes()]).then(function(J){var K=J[0];t.removeByPath(t.mPatchRequests,F,w);if(!j){t.visitResponse(K,J[1],false,a.getMetaPath(a.buildPath(t.sMetaPath,i)),i);}a.updateExisting(t.mChangeListeners,i,o,j?{"@odata.etag":K["@odata.etag"]}:K);},function(J){var K=n;t.removeByPath(t.mPatchRequests,F,w);if(J.canceled){throw J;}E(J);switch(t.oRequestor.getGroupSubmitMode(n)){case"API":break;case"Auto":if(!t.oRequestor.hasChanges(n,o)){K="$parked."+n;}break;default:throw J;}R.unlock();R=undefined;return B(new _(K),true);}).finally(function(){if(R){R.unlock();}});}if(!o){throw new Error("Cannot update '"+p+"': '"+i+"' does not exist");}T=a.getPrivateAnnotation(o,"transient");if(T){if(T===true){throw new Error("No 'update' allowed while waiting for server response");}if(T.indexOf("$parked.")===0){x=T;T=T.slice(8);}if(T!==n){throw new Error("The entity will be created via group '"+T+"'. Cannot patch via group '"+n+"'");}}O=a.drillDown(o,l);a.updateSelected(t.mChangeListeners,i,o,z);if(u){U=u.split("/");u=a.buildPath(i,u);y=t.fetchValue(_.$cached,u).getResult();if(y===undefined){L.debug("Missing value for unit of measure "+u+" when updating "+F,t.toString(),"sap.ui.model.odata.v4.lib._Cache");}else{q.extend(true,T?o:z,C.makeUpdateData(U,y));}}if(T){if(x){a.setPrivateAnnotation(o,"transient",T);t.oRequestor.relocate(x,o,T);}G.unlock();return Promise.resolve();}t.oRequestor.relocateAll("$parked."+n,o,n);h+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return B(G);});};C.prototype.visitResponse=function(R,t,w,h,j,k){var H=false,K,p={},l=this.oRequestor.getServiceUrl()+this.sResourcePath,n=this;function o(M,i,y){H=true;if(M&&M.length){p[i]=M;M.forEach(function(z){if(z.longtextUrl){z.longtextUrl=a.makeAbsolute(z.longtextUrl,y);}});}}function u(B,i){return i?a.makeAbsolute(i,B):B;}function v(I,M,y,z){var B={},i,A,D;for(i=0;i<I.length;i++){A=I[i];if(A&&typeof A==="object"){x(A,M,y,z,true);D=a.getPrivateAnnotation(A,"predicate");if(!y){K.push(D);}if(D){B[D]=A;I.$byPredicate=B;}}}}function x(i,M,I,y,z){var A,T=t[M],B=T&&T[m]&&T[m].$Path,D;y=u(y,i["@odata.context"]);A=n.calculateKeyPredicate(i,t,M);if(z){I+=A;}else if(!k&&A&&I.endsWith("/-1")){I=I.slice(0,-3)+A;}if(B){D=a.drillDown(i,B.split("/"));if(D!==undefined){o(D,I,y);}}Object.keys(i).forEach(function(E){var F,G=M+"/"+E,J=i[E],N=a.buildPath(I,E);if(E.endsWith("@odata.mediaReadLink")){i[E]=a.makeAbsolute(J,y);}if(E.includes("@")){return;}if(Array.isArray(J)){J.$count=undefined;F=i[E+"@odata.count"];if(F){s({},"",J,F);}else if(!i[E+"@odata.nextLink"]){s({},"",J,J.length);}v(J,G,N,u(y,i[E+"@odata.context"]));}else if(J&&typeof J==="object"){x(J,G,N,y);}});}if(w){K=[];v(R.value,h||this.sMetaPath,"",u(l,R["@odata.context"]));}else if(R&&typeof R==="object"){x(R,h||this.sMetaPath,j||"",l);}if(H){this.oRequestor.reportBoundMessages(this.sResourcePath,p,K);}};function e(R,h,Q,i){C.apply(this,arguments);this.sContext=undefined;this.aElements=[];this.aElements.$byPredicate={};this.aElements.$count=undefined;this.aElements.$tail=undefined;this.iLimit=Infinity;this.oSyncPromiseAll=undefined;}e.prototype=Object.create(C.prototype);e.prototype.fetchValue=function(G,p,D,l){var E,t=this;G.unlock();if(!this.oSyncPromiseAll){E=this.aElements.$tail?this.aElements.concat(this.aElements.$tail):this.aElements;this.oSyncPromiseAll=S.all(E);}return this.oSyncPromiseAll.then(function(){t.checkActive();t.registerChange(p,l);return t.drillDown(t.aElements,p);});};e.prototype.fill=function(p,h,E){var i,n=Math.max(this.aElements.length,1024);if(E>n){if(this.aElements.$tail&&p){throw new Error("Cannot fill from "+h+" to "+E+", $tail already in use, # of elements is "+this.aElements.length);}this.aElements.$tail=p;E=this.aElements.length;}for(i=h;i<E;i++){this.aElements[i]=p;}this.oSyncPromiseAll=undefined;};e.prototype.getReadRange=function(h,l,p){var E=this.aElements;function j(h,k){var i;for(i=h;i<k;i+=1){if(E[i]===undefined){return true;}}return false;}if(j(h+l,h+l+p/2)){l+=p;}if(j(Math.max(h-p/2,0),h)){l+=p;h-=p;if(h<0){l+=h;if(isNaN(l)){l=Infinity;}h=0;}}return{length:l,start:h};};e.prototype.getResourcePath=function(i,E){var D=this.sQueryString?"&":"?",h=E-i,R=this.sResourcePath+this.sQueryString;if(i>0||h<Infinity){R+=D+"$skip="+i;}if(h<Infinity){R+="&$top="+h;}return R;};e.prototype.handleResponse=function(h,E,R,t){var j,k,o,i,p,l=R.value.length;this.sContext=R["@odata.context"];k=R["@odata.count"];if(k){this.iLimit=parseInt(k,10);s(this.mChangeListeners,"",this.aElements,this.iLimit);}this.visitResponse(R,t,true);for(i=0;i<l;i++){o=R.value[i];this.aElements[h+i]=o;p=a.getPrivateAnnotation(o,"predicate");if(p){this.aElements.$byPredicate[p]=o;}}if(l<E-h){j=Math.min(g(this.aElements),h+l);this.aElements.length=j;if(!k&&j>0&&!this.aElements[j-1]){j=undefined;}s(this.mChangeListeners,"",this.aElements,j);this.iLimit=j;}};e.prototype.read=function(I,l,p,G,D){var i,n,E,h,j=-1,k=this.aElements[-1]?-1:0,R,o=Math.max(I,0),t=this;if(I<k){throw new Error("Illegal index "+I+", must be >= "+k);}if(l<0){throw new Error("Illegal length "+l+", must be >= 0");}if(this.aElements.$tail){return this.aElements.$tail.then(function(){return t.read(I,l,p,G,D);});}R=this.getReadRange(I,l,p);h=Math.min(R.start+R.length,this.iLimit);n=Math.min(h,Math.max(R.start,this.aElements.length)+1);for(i=R.start;i<n;i++){if(this.aElements[i]!==undefined){if(j>=0){this.requestElements(j,i,G.getUnlockedCopy(),D);D=undefined;j=-1;}}else if(j<0){j=i;}}if(j>=0){this.requestElements(j,h,G.getUnlockedCopy(),D);}G.unlock();E=this.aElements.slice(o,h);if(this.aElements.$tail){E.push(this.aElements.$tail);}return S.all(E).then(function(){var u;t.checkActive();u={"@odata.context":t.sContext,value:t.aElements.slice(o,h)};u.value.$count=t.aElements.$count;if(I===-1){u.value.unshift(t.aElements[-1]);}return u;});};e.prototype.requestElements=function(i,E,G,D){var p,t=this;p=S.all([this.oRequestor.request("GET",this.getResourcePath(i,E),G,undefined,undefined,D),this.fetchTypes()]).then(function(R){if(t.aElements.$tail===p){t.aElements.$tail=undefined;}t.handleResponse(i,E,R[0],R[1]);}).catch(function(o){t.fill(undefined,i,E);throw o;});this.bSentReadRequest=true;this.fill(p,i,E);};e.prototype.refreshSingle=function(G,i,D){var p=a.getPrivateAnnotation(this.aElements[i],"predicate"),o,R=this.sResourcePath+p,Q=q.extend({},this.mQueryOptions),t=this;delete Q["$count"];delete Q["$filter"];delete Q["$orderby"];R+=this.oRequestor.buildQueryString(this.sMetaPath,Q,false,this.bSortExpandSelect);o=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,D),this.fetchTypes()]).then(function(h){var E=h[0];t.aElements[i]=t.aElements.$byPredicate[p]=E;t.visitResponse(E,h[1],false,t.sMetapath,p);return E;});this.bSentReadRequest=true;return o;};e.prototype.refreshSingleWithRemove=function(G,i,D,o){var t=this;return this.fetchTypes().then(function(T){var k,K=[],E=t.aElements[i],h=a.getKeyProperties(E,"/"+t.sResourcePath,T),p=a.getPrivateAnnotation(E,"predicate"),Q=q.extend({},t.mQueryOptions),F=Q["$filter"],R=t.sResourcePath;for(k in h){K.push(k+" eq "+h[k]);}Q["$filter"]=(F?"("+F+") and ":"")+K.join(" and ");R+=t.oRequestor.buildQueryString(t.sMetaPath,Q,false,t.bSortExpandSelect);t.bSentReadRequest=true;return t.oRequestor.request("GET",R,G,undefined,undefined,D).then(function(j){if(t.aElements[i]!==E){i=t.aElements.indexOf(E);}if(j.value.length>1){throw new Error("Unexpected server response, more than one entity returned.");}else if(j.value.length===0){if(i===-1){delete t.aElements[-1];}else{t.aElements.splice(i,1);}delete t.aElements.$byPredicate[p];c(t.mChangeListeners,"",t.aElements,-1);t.iLimit-=1;o(i);}else{j=j.value[0];t.aElements[i]=t.aElements.$byPredicate[p]=j;t.visitResponse(j,T,false,t.sMetapath,p);}});});};function P(R,h,Q){C.call(this,R,h,Q);this.oPromise=null;}P.prototype=Object.create(C.prototype);P.prototype._delete=function(){throw new Error("Unsupported");};P.prototype.create=function(){throw new Error("Unsupported");};P.prototype.fetchValue=function(G,p,D,l){var t=this;t.registerChange("",l);if(this.oPromise){G.unlock();}else{this.oPromise=S.resolve(this.oRequestor.request("GET",this.sResourcePath+this.sQueryString,G,undefined,undefined,D,undefined,this.sMetaPath));this.bSentReadRequest=true;}return this.oPromise.then(function(R){t.checkActive();return R.value;});};P.prototype.update=function(){throw new Error("Unsupported");};function f(R,h,Q,i,p,M,F){C.apply(this,arguments);this.bFetchOperationReturnType=F;this.sMetaPath=M||this.sMetaPath;this.bPost=p;this.bPosting=false;this.oPromise=null;}f.prototype=Object.create(C.prototype);f.prototype.fetchValue=function(G,p,D,l){var R=this.sResourcePath+this.sQueryString,t=this;this.registerChange(p,l);if(this.oPromise){G.unlock();}else{if(this.bPost){throw new Error("Cannot fetch a value before the POST request");}this.oPromise=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,D,undefined,this.sMetaPath),this.fetchTypes()]).then(function(h){t.visitResponse(h[0],h[1],false,t.bFetchOperationReturnType?t.sMetaPath+"/$Type":undefined);return h[0];});this.bSentReadRequest=true;}return this.oPromise.then(function(o){t.checkActive();if(o["$ui5.deleted"]){throw new Error("Cannot read a deleted entity");}return t.drillDown(o,p);});};f.prototype.post=function(G,D,E){var h=G.getGroupId(),H="POST",p,t=this;if(!this.bPost){throw new Error("POST request not allowed");}if(this.bPosting){throw new Error("Parallel POST requests not allowed");}this.oRequestor.relocateAll("$parked."+h,E,h);if(D){H=D["X-HTTP-Method"]||H;delete D["X-HTTP-Method"];if(this.oRequestor.isActionBodyOptional()&&!Object.keys(D).length){D=undefined;}}p=[this.oRequestor.request(H,this.sResourcePath+this.sQueryString,G,{"If-Match":E},D)];if(this.bFetchOperationReturnType){p.push(this.fetchTypes());}this.oPromise=S.all(p).then(function(R){t.bPosting=false;if(t.bFetchOperationReturnType){t.visitResponse(R[0],R[1],false,t.sMetaPath+"/$Type");}return R[0];},function(o){t.bPosting=false;throw o;});this.bPosting=true;return this.oPromise;};C.create=function(R,h,Q,i){return new e(R,h,Q,i);};C.createProperty=function(R,h,Q){return new P(R,h,Q);};C.createSingle=function(R,h,Q,i,p,M,F){return new f(R,h,Q,i,p,M,F);};C.makeUpdateData=function(p,v){return p.reduceRight(function(V,h){var R={};R[h]=V;return R;},v);};return C;},false);
