/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/thirdparty/URI"],function(L,U){"use strict";var r=/&/g,a=/\=/g,b=/%29/g,c=/%28/g,d=/%27/g,f=/#/g,g=/\([^/]*|\/-?\d+/g,h=/^-?\d+$/,j=/\+/g,k=/'/g,H;H={buildPath:function(){var i,p="",s;for(i=0;i<arguments.length;i++){s=arguments[i];if(s||s===0){if(p&&p!=="/"&&s[0]!=="("){p+="/";}p+=s;}}return p;},buildQuery:function(p){var K,q;if(!p){return"";}K=Object.keys(p);if(K.length===0){return"";}q=[];K.forEach(function(s){var v=p[s];if(Array.isArray(v)){v.forEach(function(i){q.push(H.encodePair(s,i));});}else{q.push(H.encodePair(s,v));}});return"?"+q.join("&");},clone:function clone(v){return v===undefined||v===Infinity||v===-Infinity||v!==v?v:JSON.parse(JSON.stringify(v));},createError:function(i,m,R,s){var B=i.responseText,C=i.getResponseHeader("Content-Type"),o=new Error(m+": "+i.status+" "+i.statusText);o.status=i.status;o.statusText=i.statusText;o.requestUrl=R;o.resourcePath=s;if(i.status===0){o.message="Network error";return o;}if(C){C=C.split(";")[0];}if(i.status===412){o.isConcurrentModification=true;}if(C==="application/json"){try{o.error=JSON.parse(B).error;o.message=o.error.message;if(typeof o.message==="object"){o.message=o.error.message.value;}}catch(e){L.warning(e.toString(),B,"sap.ui.model.odata.v4.lib._Helper");}}else if(C==="text/plain"){o.message=B;}return o;},createGetMethod:function(F,t){return function(){var s=this[F].apply(this,arguments);if(s.isFulfilled()){return s.getResult();}else if(t){if(s.isRejected()){s.caught();throw s.getResult();}else{throw new Error("Result pending");}}};},createRequestMethod:function(F){return function(){return Promise.resolve(this[F].apply(this,arguments));};},deletePrivateAnnotation:function(o,A){var p=o["@$ui5._"];if(p){delete p[A];}},drillDown:function(D,p){return p.reduce(function(D,s){return(D&&s in D)?D[s]:undefined;},D);},encode:function(p,e){var E=encodeURI(p).replace(r,"%26").replace(f,"%23").replace(j,"%2B");if(e){E=E.replace(a,"%3D");}return E;},encodePair:function(K,v){return H.encode(K,true)+"="+H.encode(v,false);},fireChange:function(C,p,v){var l=C[p],i;if(l){for(i=0;i<l.length;i++){l[i].onChange(v);}}},fireChanges:function(C,p,v,R){Object.keys(v).forEach(function(P){var s=H.buildPath(p,P),V=v[P];if(V&&typeof V==="object"){H.fireChanges(C,s,V,R);}else{H.fireChange(C,s,R?undefined:V);}});},formatLiteral:function(v,t){if(v===undefined){throw new Error("Illegal value: undefined");}if(v===null){return"null";}switch(t){case"Edm.Binary":return"binary'"+v+"'";case"Edm.Boolean":case"Edm.Byte":case"Edm.Double":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":case"Edm.Single":return String(v);case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return v;case"Edm.Duration":return"duration'"+v+"'";case"Edm.String":return"'"+v.replace(k,"''")+"'";default:throw new Error("Unsupported type: "+t);}},getKeyPredicate:function(i,m,t){var K=[],e=H.getKeyProperties(i,m,t,true);if(!e){return undefined;}K=Object.keys(e).map(function(A,I,l){var v=encodeURIComponent(e[A]);return l.length===1?v:encodeURIComponent(A)+"="+v;});return"("+K.join(",")+")";},getKeyProperties:function(i,m,t,R){var F,K={};F=t[m].$Key.some(function(v){var s,e,p,P,T,V;if(typeof v==="string"){s=e=v;}else{s=Object.keys(v)[0];e=v[s];if(!R){s=e;}}p=e.split("/");V=H.drillDown(i,p);if(V===undefined){return true;}P=p.pop();T=t[H.buildPath(m,p.join("/"))];V=H.formatLiteral(V,T[P].$Type);K[s]=V;});return F?undefined:K;},getMetaPath:function(p){return p.replace(g,"");},getPrivateAnnotation:function(o,A){var p=o["@$ui5._"];return p&&p[A];},getSelectForPath:function(q,p){if(p){p.split("/").some(function(s){if(!h.test(s)){q=q&&q.$expand&&q.$expand[s];}});}return q&&q.$select;},hasPrivateAnnotation:function(o,A){var p=o["@$ui5._"];return p?A in p:false;},isSafeInteger:function(n){if(typeof n!=="number"||!isFinite(n)){return false;}n=Math.abs(n);return n<=9007199254740991&&Math.floor(n)===n;},makeAbsolute:function(u,B){return new U(u).absoluteTo(B).toString().replace(d,"'").replace(c,"(").replace(b,")");},namespace:function(n){var i=n.indexOf("/");if(i>=0){n=n.slice(0,i);}i=n.lastIndexOf(".");return i<0?"":n.slice(0,i);},parseLiteral:function(l,t,p){function e(n){if(!isFinite(n)){throw new Error(p+": Not a valid "+t+" literal: "+l);}return n;}if(l==="null"){return null;}switch(t){case"Edm.Boolean":return l==="true";case"Edm.Byte":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":return e(parseInt(l,10));case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return l;case"Edm.Double":case"Edm.Single":return l==="INF"||l==="-INF"||l==="NaN"?l:e(parseFloat(l));default:throw new Error(p+": Unsupported type: "+t);}},publicClone:function(v){var C=H.clone(v);if(C){delete C["@$ui5._"];}return C;},resolveIfMatchHeader:function(m){var i=m&&m["If-Match"];if(i&&typeof i==="object"){i=i["@odata.etag"];m=jQuery.extend({},m);if(i===undefined){delete m["If-Match"];}else{m["If-Match"]=i;}}return m;},setPrivateAnnotation:function(o,A,v){var p=o["@$ui5._"];if(!p){p=o["@$ui5._"]={};}p[A]=v;},toArray:function(e){if(e===undefined||e===null){return[];}if(Array.isArray(e)){return e;}return[e];},updateExisting:function(C,p,o,n){if(!n){return;}Object.keys(o).forEach(function(P){var s=H.buildPath(p,P),O=o[P],N;if(P in n){N=n[P];if(N&&typeof N==="object"){if(Array.isArray(N)){o[P]=N;}else if(O){H.updateExisting(C,s,O,N);}else{o[P]=N;H.fireChanges(C,s,N,false);}}else if(O&&typeof O==="object"){o[P]=N;H.fireChanges(C,s,O,true);}else{o[P]=N;if(O!==N){H.fireChange(C,s,N);}}}});},updateSelected:function(C,p,o,n,s){function e(p,P,o,n){var S=P.split("/");S.every(function(l,I){if(n[l]===null){o[l]=null;if(I<S.length-1){return false;}H.fireChange(C,H.buildPath(p,P),o[l]);}else if(typeof n[l]==="object"){o[l]=o[l]||{};}else{if(o[l]!==n[l]){o[l]=n[l];H.fireChange(C,H.buildPath(p,P),o[l]);}return false;}o=o[l];n=n[l];return true;});}function i(O,l){Object.keys(O).forEach(function(P){var m=l?l+"/"+P:P,v=O[P];if(v!==null&&typeof v==="object"){i(v,m);}else{s.push(m);}});}if(!s||s.indexOf("*")>=0){s=[];i(n);}else{s=s.concat("@odata.etag","@$ui5._/predicate");}s.forEach(function(P){e(p,P,o,n);});},updateTransientPaths:function(m,p,P){var s,e=H.buildPath(p,"-1");for(s in m){if(s.startsWith(e)){m[p+P+s.slice(e.length)]=m[s];delete m[s];}}}};return H;},false);
